// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare Special_effects = on

camera {
	location <0.974,2.000,-7.269>
	look_at  <-5.929,2.000,-0.226>
}

light_source {<0,2,-5> color Gray50 atmosphere off}

light_source {<10,20,-50> color White}

#if (Special_effects = on)

atmosphere
{
  type 1
  samples 20
  distance 400
  scattering 0.1
  aa_level 8
  aa_threshold 0.1
  jitter 0.5
  color rgbft <1,1,1,.25,.75>
}

// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
//#declare Rad_Quality = Radiosity_Debug
//#declare Rad_Quality = Radiosity_Fast
#declare Rad_Quality = Radiosity_Normal
//#declare Rad_Quality = Radiosity_2Bounce
//#declare Rad_Quality = Radiosity_Final

#include "rad_def.inc"
#end

#include "13room.pov"
object {Room_interior}

#include "13copter.pov"
object {Davinci_copter scale 0.8 translate <-4.5,-0.45,-3>}
