// ----------------------------------------------------
// Persistence of Vision RayTracer version 2 Scene description file
// Description: Tthe "de Jong Box"
// Date: 6/5/94
// Mod:  8/30/94 - Cleanup, moved box to include file
// Author: Eduard Schwan
// Copyright 1994, Eduard Schwan, All Rights Reserved
// ----------------------------------------------------

// Updated to Povray version 3 code by Nathan O'Brien
// Date: 10.5.97

// POV-Ray version 3 scene file
// add you object here
// #declare ObjectToSlice = object { ... }

// #declare djb_MaxRot = 20 // You can change this
// #declare djb_NSlices = 30 // You can change this

#declare djb_Object = object { ObjectToSlice }
#declare djb_1NSlices = 1/djb_NSlices // Don't touch!

#declare djb_Slice =
box
{
  <-1.5,0,-1.5> <1.5,djb_1NSlices,1.5>
  translate -0.5*y  scale <1,2,1> // move to bottom of cube
}

#declare djBox = union
{
  #declare Count = 0
  #while (Count < djb_NSlices)
  intersection // slice 1 of 20
  {
    object { djb_Object rotate Count/djb_NSlices*djb_MaxRot*y }
    object { djb_Slice translate 2*Count/djb_NSlices*y }   
  }
  #declare Count = (Count + 1)
  #end
}

