//
// OBJETS PARADOXAUX
//

//-----------------------------------------------------------
// Include standards
//-----------------------------------------------------------

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"

//-----------------------------------------------------------
// Include perso
//-----------------------------------------------------------

#include "penrose.inc"
#include "huizer.inc"
#include "construc.inc"

//-----------------------------------------------------------
// Commutateurs
//-----------------------------------------------------------

#declare penrose_com = on
#declare huizer_com = on
#declare construc_com = on
#declare decors_com = on
#declare pencartes_com = on

//-----------------------------------------------------------
// Decors
//-----------------------------------------------------------

#declare decors = union {
  plane {
    <0, 1, 0>, -3.5
    texture {
      T_Stone8
      scale <4, 4, 6>
      rotate <0, 45, 0>
    }
  }
  plane {
    <0, 0, -1>, -13
    texture {
      T_Stone12
      scale 2
    }
  }
}

//-----------------------------------------------------------
// Scene
//-----------------------------------------------------------

#if (penrose_com = on)
  object {
    penrose
    rotate <0, 45, 0>
    translate <14.5, -3.5, 4>
    finish {
      ambient 0.7
    }
  }
#end

#if (construc_com = on)
  object {
    construc
    rotate <0, 45, 0>
    translate <-10.8, -3.5, -4>
    finish {
      ambient 0.7
    }
  }
#end

#if (huizer_com = on)
  object {
    huizer
    rotate <0, 45, 0>
    translate <0, -3.5, 0>
    finish {
      ambient 0.7
    }
  }
#end

#if (decors_com = on)
  object {
    decors
  }
#end

#if (pencartes_com = on)
  union {
    object {
      #declare echelle_texte = 1
      #declare echelle_auteur = 0.8
      #declare texte =  "      Cube"
      #declare auteur = "DIRK HUIZER"
      #include "pencarte.inc"
      rotate <0, 0, 0>
      translate <0, -3.5+rayon, -13>
    }
    object {
      #declare echelle_texte = 1
      #declare echelle_auteur = 0.8
      #declare texte =  "Three Beams"
      #declare auteur = "  PENROSE"
      #include "pencarte.inc"
      rotate <0, 10, 0>
      translate <10.5, -3.5+rayon, -13>
    }
    object {
      #declare echelle_texte = 0.85
      #declare echelle_auteur = 0.55
      #declare texte =  "construction set"
      #declare auteur = "MITSUMASA ANNO"
      #include "pencarte.inc"
      rotate <0, -10, 0>
      translate <-10.8, -3.5+rayon, -13>
    }
  }
#end

//-----------------------------------------------------------
// Light
//-----------------------------------------------------------

light_source {
  <-100, 300, -900>
  color White
}
light_source {
  <-100, 900, -900>
  color White
}

//-----------------------------------------------------------
// Camera
//-----------------------------------------------------------

camera {
  location  <0, 0, -21000>
  direction  <0, 0, 850>
  rotate <35.27, 0, 0>
}
