//-----------------------------------------------------------
// Pencarte
//-----------------------------------------------------------

#declare larg = 6
#declare epaisseur = 1/7
#declare rayon = 1.5

union {
  difference {
    cylinder {
      <-larg/2, 0, 0>, <larg/2, 0, 0>, rayon
    }
    union {
      cylinder {
        <-larg/2-1, 0, 0>, <larg/2+1, 0, 0>, rayon-epaisseur
      }
      box {
        <-larg/2-1, -rayon-1, rayon+1>, <larg/2+1, rayon+1, 0>
      }
      box {
        <-larg/2-1, -rayon-1, rayon+1>, <larg/2+1, rayon+1, 0>
        rotate <-45, 0, 0>
      }
    }
  }
  box {
    <-larg/2, -rayon, 0.7*larg>, <larg/2, -rayon+epaisseur, 0>
  }
  union {
    box {
      <-larg/2, rayon-epaisseur, larg/5>, <larg/2, rayon, 0>
    }
    union {
      text {
        ttf "Times.ttf",
        texte,
        0.1, 0
        scale echelle_texte
        rotate <90, 0, 0>
        translate <-larg/2+0.3, rayon, 0.3>
      }
      text {
        ttf "Times.ttf",
        auteur,
        0.1, 0
        scale echelle_auteur
        rotate <90, 0, 0>
        translate <-larg/2+0.5, rayon, -0.5>
      }
      texture {
        pigment {
          color Black
        }
      }
    }
    rotate <-45, 0, 0>
  }
  texture {
    pigment { White }
  }
}

