// Persistence of Vision Ray Tracer Scene Description File
// File: stool.inc
// Desc: a simple 4 legged stool
// Date: 06/18/97
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"



#declare stoolSeat=
union{
  object{torus{6.5, .25} translate<0,3.75,0>  }
  cylinder{<0,3,0>,<0,3.75,0>, 6.75}
  cylinder{<0,3.75,0>,<0,4.0,0>, 6.5}
  #if (testing = True)
    pigment{Yellow}
  #else
    texture{Yellow_Pine rotate<0,0,89> finish{Shiny} translate<0,0,0>}
  #end
}

#declare stoolLeg=
union{
  difference{
    torus {2.5, .5}
    plane {x,0 }
    plane {z,0 inverse rotate<0,4,0> }
    rotate<90,0,0>
  }
  cylinder{<-4,2.5,0>,<0,2.5,0>,.5}
  cylinder{<2.5*cos(radians(4)), 2.5*sin(radians(4)), 0>,
          <(2.5*cos(radians(4)))+(26*sin(radians(4))),(2.5*sin(radians(4)))-(26*cos(radians(4))),0>, .5
  }
  translate<4,0,0>
  #if (testing = True)
    pigment{White*.5}
  #else
    texture{Aluminum  }
  #end
}


#declare stool=
union{
  object{stoolLeg rotate<0,0,0>}
  object{stoolLeg rotate<0,90,0>}
  object{stoolLeg rotate<0,180,0>}
  object{stoolLeg rotate<0,270,0>}
  object{stoolSeat}
  translate<0,26*cos(radians(4)),0>
}

