
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.01
// Desc: bike
// Date: 24. june 1997.
// Auth: Anto Matkovic
// E-mail: anto.matkovic@zg.tel.hr

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "bike_autokotac.inc"
#include "bikelanac.inc"

#include "bike_drz.inc"
#include "bikegume.inc"
#include "bikelajsne.inc"
#include "bikemalegume.inc"
#include "bike_met.inc"
#include "bikeosoped.inc"
#include "bikepedale.inc"
#include "bikepokl_zu.inc"
#include "bikesjedalo.inc"
#include "biketrup.inc"
#include "bikevolan.inc"
#include "bikevzupc.inc"
#include "bikezbiceitd.inc"
#include "bikefelge.inc"
#include "bikerucke.inc"


global_settings { assumed_gamma 2.2 }

global_settings { max_trace_level 11 }

sky_sphere {pigment{ gradient z
      colour_map {
            [0 colour red 0.12 green 0.2 blue 0.99 ]
            [0.3 colour red 0.12 green 0.2 blue 0.99 ]
            [0.7 colour red 0.5 green 0.5 blue 0.99 ]
            [1 colour red 0.5 green 0.5 blue 0.99 ]}scale 0.32 translate z*35}}

plane
{
  z, 3100 texture {pigment { wrinkles
  colour_map {[ 0 colour rgbt <0.99, 0.99, 0.99, 0.15>]
              [ 0.4 colour rgbt <0.87, 0.87, 0.87, 0.6>]

              [ 1 colour rgbt <0.5, 0.5, 0.9, 0.9>]}scale <700, 1100, 700>}
finish {ambient 0.5 diffuse 0.5}

}rotate <0, -18, 0>}

#declare to= texture {pigment {colour rgb <0.1, 0.1, 0.1>} finish {phong 1 phong_size 23}}

#declare prozori= texture {pigment {colour rgb <0.05, 0.05, 0.05>} finish {
ambient 0.2 diffuse 0.6
 specular 0.9 roughness 0.01 brilliance 21
reflection <0.25, 0.3, 0.2>
metallic on}}

#declare plavo = texture { pigment {colour rgb <0, 0, 1>}
finish {phong 1 phong_size 34 }}

#declare amortizerr = texture {pigment {colour rgb <0.44, 0.44, 0.44>} finish {ambient 0.18 diffuse 0.6
specular 0.6 roughness 0.05 brilliance 6 irid   {0.17  thickness 0.2 turbulence 0.7}}}

#declare zmigavci = texture { pigment {colour rgbf <0.99, 0.6, 0.02, 0.2>}
finish {ambient 0.2 diffuse 0.6 specular 0.7 roughness 0.01
phong 0.99 phong_size 234 reflection 0.24 caustics on refraction 1 ior 1.55}
normal {gradient y 0.45 scale 0.15}}

#declare lim = texture {pigment {colour rgb <0.8, 0.8, 0.8>} finish {ambient 0.25 diffuse 0.6
specular 0.7 roughness 0.05 brilliance 6 reflection 0.25 irid {0.2  thickness 0.2 turbulence 0.7}}}

#declare oplata = texture { pigment {colour rgb <0.12, 0.12, 0.12>}
finish {phong 0.9 phong_size 134
reflection <0.27, 0.2, 0.15>
}}

#declare vslova = texture {pigment {colour rgb <0.44, 0.44, 0.44>} finish {ambient 0.18 diffuse 0.6
specular 0.6 roughness 0.05 brilliance 6 irid   {0.22  thickness 0.2 turbulence 0.7}}}

#declare trotoar =  texture{ pigment {bozo
colour_map {[ 0 colour rgb <0.42, 0.4, 0.4>]
            [ 1 colour rgb <0.48, 0.45, 0.45>]}}
finish {specular 0.25 roughness 0.05 ambient 0.25 diffuse 0.55 }
normal {bozo scale 1
normal_map {
[0  granite 0.3  scale 0.01]
[0.1  granite 0.1  scale 0.01]
[0.9  granite 0.1  scale 0.05]
[1  granite 0.3  scale 0.1]}
}}

#declare kamenje = texture{ pigment {bozo
colour_map {[ 0 colour rgb <0.29, 0.27, 0.27>]
            [ 0.5 colour rgb <0.33, 0.3, 0.3>]
            [ 1 colour rgb <0.31, 0.29, 0.29>]}}
finish {specular 0.4 roughness 0.05 ambient 0.25 diffuse 0.55}
normal {granite 0.3 scale 0.2}}


#declare ograda = texture { pigment {radial frequency 360
colour_map {[ 0 colour rgb <0.4, 0.4, 0.4>]
            [ 0.2 colour rgb <0.36, 0.36, 0.36>]
            [ 0.3 colour rgb <0.4, 0.44, 0.46>]
            [ 0.6 colour rgb <0.4, 0.44, 0.46>]
            [ 0.8 colour rgb <0.36, 0.36, 0.36>]
            [ 1 colour rgb <0.4, 0.4, 0.4>]}}
finish {ambient 0.3 diffuse 0.57 specular 0.7 roughness 0.1 reflection 0.1}}



#declare pod =  texture{ pigment {bozo scale 0.5
colour_map {[ 0 colour rgb <0.28, 0.24, 0.22>]
            [ 0.07 colour rgb <0.29, 0.24, 0.21>]
            [ 0.5 colour rgb <0.29, 0.25, 0.22>]
            [ 0.93 colour rgb <0.31, 0.26, 0.23>]
            [ 1 colour rgb <0.35, 0.29, 0.29>]}}
finish {specular 0.25 roughness 0.05
phong 0.7 phong_size 89 ambient 0.25 diffuse 0.55}
normal {bozo scale 0.5
normal_map {
[0  granite 0.3  scale 0.01]
[0.07 dents 0.2  scale 0.05]
[0.93 dents 0.2  scale 0.05]
[1  granite 0.3  scale 0.1]}
}}

 texture{ pigment {gradient y
colour_map {[ 0 colour rgbf <0.99, 0.99, 0.99, 0>]
            [ 0.005 colour rgbf <0.99, 0.99, 0.99, 0>]
            [ 0.007 colour rgbf <0.4, 0.33, 0.3, 0.9>]
            [ 0.06 colour rgbf <0.4, 0.33, 0.3, 0.9>]
            [ 0.1 colour rgbf <0.4, 0.2, 0.1, 0.2>]
            [ 0.14 colour rgbf <0.4, 0.33, 0.3, 0.9>]
            [ 0.23 colour rgbf <0.4, 0.33, 0.3, 0.9>]
            [ 0.235 colour rgbf <0.9, 0.6, 0.05, 0>]
            [ 0.999 colour rgbf <0.4, 0.33, 0.3, 0.9>]
            }scale 200 translate y*5.5}
finish {specular 0.25 roughness 0.05
phong 0.7 phong_size 89 ambient 0.25 diffuse 0.55}
normal {bozo
normal_map {
[0  granite 0.3  scale 0.01]
[0.07 dents 0.2  scale 0.05]
[0.93 dents 0.2  scale 0.05]
[1  granite 0.3  scale 0.1]}
}}





#declare unutra = texture { pigment {colour rgb <0.8, 0.8, 0.8>}
finish {phong 1 phong_size 134 }}

#declare ograda_c = texture {pigment { colour rgb <0.5, 0.55, 0.55>}
finish {ambient 0.22 diffuse 0.6 specular 0.3 roughness 0.03}
normal {dents 0.3 scale 1} }

#declare ograda_d = texture {pigment { colour rgb <0.3, 0.62, 0.5>}
finish {ambient 0.22 diffuse 0.6 specular 0.3 roughness 0.03}
normal {dents 0.3 scale 1} }

#declare kr_usp = texture {pigment { radial frequency 4
colour_map {[0 colour rgb <1, 1, 1>]
            [0.499 colour rgb <1, 1, 1>]
            [0.501 colour rgb <1, 0.7, 0>]
            [1 colour rgb <1, 0.7, 0>]}scale 3}
finish {ambient 0.21 diffuse 0.6 specular 0.3 roughness 0.03}
rotate <90, 0, -30> translate <-25, -55, 0>}

#declare kr_vod = texture {pigment { radial frequency 4
colour_map {[0 colour rgb <1, 1, 1>]
            [0.499 colour rgb <1, 1, 1>]
            [0.501 colour rgb <1, 0.7, 0>]
            [1 colour rgb <1, 0.7, 0>]}scale 3}
finish {ambient 0.21 diffuse 0.6 specular 0.3 roughness 0.03}
rotate <0, -30, 90> translate <-25, -55, 17>  }



light_source{ 0*x  color rgb 1.4
area_light <8, 0, 0> <0, 0, 8> 4, 4
  adaptive 0
  jitter
  translate <-600, -2000, 2000>}

//backlight
light_source
{0*x color rgb 0.7 translate <423, 233, 100> shadowless}

camera{  location  <52, 12, 14> direction <0.0, 2.414214, 0.0>
sky <0.0, 0.0, 1.0> up <0.0, 0.0, 1.0> right     <1.33, 0.0, 0.0> look_at <11, -11, 2.2> angle 49}




//pod

cylinder {<0, -70, -2004.58><0, 100, -2004.58>, 2000 texture {pod}}

//trotoar

cylinder {<0, -70, -2004.58><0, -50, -2004.58>, 2001 texture {trotoar}}

//ograda

#declare dio_ograde1 =
blob {threshold 0.1
cylinder {<-16, 0, 0.7>,<16, 0, 0.7>,1, 1 scale <1, 0.6, 1.2>}
cylinder {<-16, 0, -0.7>,<16, 0, -0.7>, 1, 1  scale <1, 0.6, 1.2>}
translate <0, -68, 2004.58> texture {ograda}}




#declare oho = 0
	#while (oho <36)
object { dio_ograde1  rotate <0,(oho * -1), 0> translate z*-2005 }
object { dio_ograde1  rotate <0,(oho * -1), 0> translate z*-2001 }

#declare oho = (oho + 1)
#end

#declare oho = 0
	#while (oho <360)
cylinder {<0, -69.5, 2009>, <0, -70, 2000>, 1   rotate <0,(oho * 1), 0> rotate y*0.4 translate z*-2004.58
 texture {ograda_c}}
 cylinder {<0, -69.9, 2002>, <0, -70, 2000>, 1.05   rotate <0,(oho * 1), 0> rotate y*0.4 translate z*-2004.58
 texture {ograda_d}}
cylinder {<0, -69.5, 2009>, <0, -70, 2000>, 1   rotate <0,(oho * 1), 0> rotate y*-0.4 translate z*-2004.58
 texture {ograda_c}}
cylinder {<0, -69.5, 2009>, <0, -70, 2000>, 1   rotate <0,(oho * 1), 0>  translate z*-2004.58
 texture {ograda_c}}

#declare oho = (oho + 1)
#end


#declare oho = 0
	#while (oho <90)
superellipsoid
{<0.2,  0.2 >  scale <3.68, 2, 1>  translate <0, -49 , 2004.58>  rotate <0,(oho * -0.22), 0> rotate y*12
 translate z*-2009
texture {kamenje}}

#declare oho = (oho + 1)
#end


#declare auto_trup =
blob {
threshold 0.1

//prednji trup
sphere {<0, 0, 0>, 1, 1 scale <25, 4, 7> rotate <0, 7, 0>  translate <12, 7, 1>}
sphere {<0, 0, 0>, 1, 1 scale <27, 14, 8> rotate <0, 7, 0>  translate <12, 0, 1>}
sphere {<0, 0, 0>, 1, 1  scale <25, 4, 7> rotate <0, 7, 0>  translate <12, -7, 1>}
//zadnji trup
sphere {<0, 0, 0>, 1, 1 scale <20, 4, 10> translate <-10, 6, 2>}
sphere {<0, 0, 0>, 1, 1 scale <22, 14, 11> translate <-10, 0, 2>}
sphere {<0, 0, 0>, 1, 1 scale <20, 4, 10> translate <-10, -6, 2>}
//kabina
cylinder {<-0.5, 0, 0>,<0.5, 0, 0>, 1, 1 scale < 9, 9, 8> rotate <0, 12, 0> translate <0, 0, 8>}
cylinder {<-0.5, 0, 0>,<0.5, 0, 0>, 1, 1 scale < 7, 8.4, 6> rotate <0, 22, 0> translate <6, 0, 6>}
//rupe za prednje kotace
sphere {<0, 0, 0>, 1, -1 scale <6.4, 14, 6.4>translate <19, 8, -2.5>}
sphere {<0, 0, 0>, 1, -1 scale <6.4, 14, 6.4>translate <19, -8, -2.5>}
//rupe za zadnje kotace
sphere {<0, 0, 0>, 1, -1 scale <6.2, 11, 6.2>translate <-12, 8.4, -2.5>}
sphere {<0, 0, 0>, 1, -1 scale <6.2, 11, 6.2>translate <-12, -8.4, -2.5>}

}
#declare amortizer =
blob {
threshold 0.1

//prednji trup za amortizer
sphere {<0, 0, 0>, 1, 1 scale <11, 4, 2.7> rotate <0, 7, 0>  translate <23, 6.5, -1.5>}
sphere {<0, 0, 0>, 1, 1 scale <14, 11, 2.7> rotate <0, 7, 0>  translate <22, 0, -1.5>}
sphere {<0, 0, 0>, 1, 1  scale <11, 4, 2.7> rotate <0, 7, 0>  translate <23, -6.5, -1.5>}
sphere {<0, 0, 0>, 1, -1 scale <6.4, 14, 6.4>translate <19, 8, -4>}
sphere {<0, 0, 0>, 1, -1 scale <6.4, 14, 6.4>translate <19, -8, -4>}}

//pravi amortizer
difference{
object {amortizer}

box {< 22, 15, -6>,<-19, -15, 6>}
texture {amortizerr}
translate <-24, -9.5, 3> }



//pravi auto trup

difference{
object {auto_trup texture {oplata}}
//dijelovi za otkidanje rupe za sajbe
box {<16, -3.6, 7.5><-9, 3.6, 11.5>texture {oplata}}
cylinder {<16, -3.6, 9.5>,<-9, -3.6, 9.5>, 2 texture {oplata}}
cylinder {<16, 3.6, 9.5>,<-9, 3.6, 9.5>, 2 texture {oplata}}//svi za prednju rupu

box {<-16, -3.6, 11><-6, 3.6, 14> texture {oplata}}
cylinder {<-16, -3.6, 12.5>,<-6, -3.6, 12.5>, 1.5 texture {oplata}}
cylinder {<-16, 3.6, 12.5>,<-6, 3.6, 12.5>, 1.5 texture {oplata}}//svi za zadnju rupu

superellipsoid
{<0.2,  0.2 > rotate y* -30 scale <5, 10, 2.1> rotate y*27 translate <3.2, 0, 10>texture {oplata}}
cylinder {<-5, 11, 11.5>,<-5, -11, 11.5>, 1.7 texture {oplata} }//mala bocna
//okvir
difference{
superellipsoid
{<0.2,  0.2 > rotate y* -30 scale <5.2, 14, 2.3> rotate y*27 translate <3.2, 0, 10>texture {oplata}}
superellipsoid
{<0.2,  0.2 > rotate y* -30 scale <5.1, 15, 2.2> rotate y*27 translate <3.2, 0, 10>texture {oplata}}
}

//otvori na prednjoj sajbi
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, 0, 0> texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, 0.4, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, 0.8, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, -0.4,0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, -0.8, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, -1.2, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, 1.2, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, -1.6, 0>texture {amortizerr}}
superellipsoid
{<0.2,  0.2 > scale <3.9, 0.15, 8>  translate <21, 1.6, 0>texture {amortizerr}}
//rupe naprijed
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, 0, -0.99> texture {amortizerr}}
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, 1.2, -0.99> texture {amortizerr}}
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, 2.4, -0.99> texture {amortizerr}}
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, -1.2, -0.99>texture {amortizerr} }
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, -2.4, -0.99> texture {amortizerr}}
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, -3.6, -0.99> texture {amortizerr}}
sphere {<0, 0, 0>, 1 scale <7, 0.56, 0.56> translate <32, 3.6, -0.99> texture {amortizerr}}

//prosirenja prednjeg otvora za kotace
cylinder {<19, -14, -2.5>,<19, 14, -2.5>, 5.5 texture {oplata}}

//rupe za svijetla
difference{
cylinder {<36, 6.5, -0.5>,<28, 6.5, -0.5>, 1.55}
cylinder {<36, 6.5, -0.5>,<28, 6.5, -0.5>, 1.5} texture {oplata}}
difference{
cylinder {<36, -6.5, -0.5>,<28, -6.5, -0.5>, 1.55}
cylinder {<36, -6.5, -0.5>,<28, -6.5, -0.5>, 1.5} texture {oplata}}


//poklopac
difference{
superellipsoid
{<0.2,  0.2 > scale <8, 4.6, 5.6>  translate <23, 0, 2>}
superellipsoid
{<0.2,  0.2 > scale <7.9, 4.5, 6>  translate <23, 0, 2>}texture {oplata}}
translate <-25, -9.5, 3.4> }

//prozori
intersection{
object {auto_trup}
union{
box {<16, -3.6, 7.5><-9, 3.6, 11.5> }
cylinder {<16, -3.6, 9.5>,<-9, -3.6, 9.5>, 2 }
cylinder {<16, 3.6, 9.5>,<-9, 3.6, 9.5>, 2 }//svi za prednju rupu

box {<-16, -3.6, 11><-6, 3.6, 14> }
cylinder {<-16, -3.6, 12.5>,<-6, -3.6, 12.5>, 1.5 }
cylinder {<-16, 3.6, 12.5>,<-6, 3.6, 12.5>, 1.5 }//svi za zadnju rupu

superellipsoid
{<0.2,  0.2 > rotate y* -30 scale <5, 10, 2.1> rotate y*27 translate <3.2, 0, 10>}
cylinder {<-5, 11, 11.5>,<-5, -11, 11.5>, 1.7  }//mala bocna

}translate <-25, -9.5, 3.4> texture {prozori}}



//zmigavci
union{
sphere {<0, 0, 0>, 0.5 scale <2, 1, 0.8> translate <29, -8.7, -0.5> texture {zmigavci}}
sphere {<0, 0, 0>, 0.5 scale <2, 1, 0.8> translate <29, 8.7, -0.5> texture {zmigavci}}
translate <-24.99, -9.5, 3.4>}

//prednji tekst
union{
text {ttf  "comic.ttf", "P",  0.31, 0.31  scale 0.8  rotate <41, -7, 90>  translate <33, -0.55, 0.6>
rotate <0, 0, 0> }
text {ttf  "comic.ttf", "&",  0.31, 0.31  scale 0.8  rotate <41, 0, 90>   translate <33, -0.15, 0.6>
 rotate <0, 0, 0>}
text {ttf  "comic.ttf", "M",  0.31, 0.31  scale 0.8  rotate <41, 7, 90>translate <33, 0.55, 0.6>
 rotate <0, 0, 0> }
translate <-24, -9.5, 3> texture {amortizerr}}

//antene
cylinder {<-16, 6.5, 0>,<-20, 6.5, 24>, 0.09 translate <-24, -9.5, 3>texture {amortizerr}}
cylinder {<-16, -6.5, 0>,<-20, -6.5, 24>, 0.09 translate <-24, -9.5, 3>texture {amortizerr}}

object {lanac scale 0.43 rotate y*0.6 translate <24, -14, -4.64>}


//kr
blob {threshold 0.1
cylinder {<0, 0, -6>, <0, 0, 7>, 1, 1 scale <1.2, 1.2, 1> translate <-25, -55, 0> texture {kr_usp}}
cylinder {<0, 0, -6>, <0, 0, 44>, 1, 1  translate <-25, -55, 0> texture {kr_usp}}
cylinder {<-9, 0, 17>, <9, 0, 17>, 1, 1  translate <-25, -55, 0> texture {kr_vod}}
}

cylinder {<-25, -55, -5>, <-25, -55, -2.5>, 3 texture {trotoar}}






