global_settings { assumed_gamma 1.0 }

camera {
  location  <-0.1, 1.0, -25.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

//light_source { <0,.75,0> color rgb <1,1,1> }

light_source {
  <0,.75,0>  color rgb <2,2,2>
  area_light <2, 0, 0>, <0, 0, 2>, 4, 4
  adaptive 1  jitter
}

#declare WaterT = texture {
   pigment { color rgb <0,0,1> }
   normal  { waves 2.5 }
   finish  { reflection .3 ambient .25 }
   scale .01
   translate <-.775,0,0>
}

#declare MSize = 25

#declare Mred = <.7,.4,.1>
#declare MStoneT = texture {
   pigment {
      agate
      color_map {
         [ 0.2  color rgb 1.4 + Mred ]
         [ 0.4  color rgb 1.6 + Mred + Mred ]
         [ 0.5  color rgb 1.5 + Mred ]
         [ 0.75 color rgb 1.2 + Mred ]
         [ 0.95 color rgb 1.4 + Mred ]
      }
   }
   //finish { ambient .25 }
   scale .25
}

#declare MandT = texture {
   mandel 512
   texture_map {
      [0.0   MStoneT ]
      [0.15  pigment { color rgb < 0,0,0> } ]
      [1.0   WaterT ]
   }
   rotate <90,0,0>
   scale MSize
   translate <MSize*.75,0,0>
}

union {
   intersection {
      quartic {
         < 0.0, 0.0, 0,-0.5, 0.0,
           0.0, 0.0, 0, 0.0,-0.5,
           0.0, 0.0, 0, 0.0, 0.0,
           0.0, 0.0, 0, 0.0, 0.0,
           0.0, 0.0, 0, 0.0, 0.0,
           1.0, 0.0, 0, 0.0, 0.0,
           0.0, 0.0, 1, 0.0, 0.0 >
         rotate <0,0,90>
      }
      cylinder { <0,0,0>, <0,5,0>, 15 }
   }
   plane { y 5 inverse }
   texture { MandT }
   translate <0,1.2,0>
   no_shadow
}

#declare EarthMap = texture {
   pigment { image_map { tga "earthmap.tga" map_type 1 } }
   finish  { ambient .25 }
}

intersection {
   quartic {
      < 0,   0,   0,   -0.5, 0,   0,   0,   0,   0, -0.5,
        0,   0,   0,    0,   0,   0,   0,   0,   0,  0,
        0,   0,   0,    0,   0,   1,   0,   0,   0,  0,
        0,   0,   1,    0,   0>
      rotate <0,0,90>
   }
   cylinder { <0,0,0>, <0,-5,0>, 1 }
   texture { EarthMap translate <0,-.5,0> rotate <0,200,0> }
   scale 2
   translate <0,.25,0>
   //no_shadow
}

#declare MSize = 1000000

#declare GraniteT = pigment {
   granite
   color_map {
      [0.25  color rgb <.3,.3,.3>]
      [0.4   color rgb <.4,.3,.4>]
      [0.75  color rgb <.6,.6,.6>]
      [1.001 color rgb <.45,.5,.41>]
   }
   rotate <0,0,90>
   scale 2/MSize
}

#declare Clouds = pigment {
    wrinkles
    turbulence 0.1
    color_map {
        [0.5  color rgb <0.1,0.2,0.7>]
        [0.7  color rgb <3.0,3.0,3.0>]
        [1.01 color rgb <0.1,0.2,0.7>]
    }
    rotate <0,0,90>
    scale .000005
    //translate <0,0,.1>
}

plane {
   y 0
   texture {
      pigment {
         mandel 512
         pigment_map {
            [0.0  color rgb  <0,1,1> ]
            [0.1  GraniteT ]
            [1.0  GraniteT ]
            [1.0  Clouds rotate <0,0,50> ]
         }
         rotate <90,0,0>
      }
      normal {
         mandel 512
         50.0
         rotate <90,0,0>
      }
   }
   scale MSize
   translate <MSize*1.81005,-2,0>
}

sphere { 0, 1
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
         [ 0.0 color rgbt <1, 0, 0,  1> ]
         [ 0.5 color rgbt <1, 1, 0, -1> ]
         [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
   }
   hollow
   scale <1.5,1,1.5>
   translate <0,.75,0>
}
