
// Persistence of Vision Ray Tracer Scene Description File
// File: calc1.inc
// Vers: 1.00
// Desc: A Casio fx-100D calculator. Created for the May-June round of the IRTC.
// Date: 2nd June 97
// Auth: Chris Hernandez


#declare Calc_CasePlastic = texture {
	pigment { color rgb 0.175 }
	finish {
	   ambient 0.5
	   diffuse 0.25
	   specular 0.2
	   roughness 0.075
	   crand 0.05
	}
}


// -----------------------------------------------------------------------------------------
//                                    Calculator Case
// -----------------------------------------------------------------------------------------

#declare CalcCase_RoundEdge = object {
   merge {
	  difference {
		 box { < 0.0, 1, -0.9> < 0.3, -1,  0.9 > }
		 box { < 0.2, 1,  0.9> < 0.3, -1,  1.0 > }
		 box { < 0.2, 1, -0.9> < 0.3, -1, -1.0 > }
	  }
	  cylinder { y, -y, 0.1 translate < 0.2, 0,  0.9 > }
	  cylinder { y, -y, 0.1 translate < 0.2, 0, -0.9 > }
   }
}


#declare CalcCase_Primitive = object {
   difference {
	  merge {
		 box { < -2, -0.75, -1> < 2, 0.75, 1> }
		 object { CalcCase_RoundEdge rotate -z*5 translate 1.8*x}
		 object { CalcCase_RoundEdge rotate y*180 rotate z*5 translate -1.8*x}
	  }
	  plane { y, 0 }
	  plane { -y, -0.5 rotate -z*3 }
   }
}


#declare Calc_Case = object {
   difference {
	  union {
		 difference {
			object { CalcCase_Primitive }
			object { CalcCase_Primitive scale <0.96, 1, 0.91> translate y*0.1 }
			box { < 0, -1, -0.425> < 0.5, 1, 0.425> translate x*1.95 }
		 }

		 // -------------- Create recess for the cover latch ----------------
		 box { < 0, 0.1, -0.5> < 0.2, 1, -0.425> translate x*1.85 }
		 box { < 0, 0.1,  0.5> < 0.2, 1,  0.425> translate x*1.85 }

		 box { < 0, 0.1, -0.15> < 0.075, 1, -0.425> translate x*1.85 }
		 box { < 0, 0.1,  0.15> < 0.075, 1,  0.425> translate x*1.85 }

		 // ---------- Create 3 protrusions on the inside of case -----------
		 box { < 0, -1, -0.01> < 0.065, 1, 0.01> translate < -2, 0,  0.00 > }
		 box { < 0, -1, -0.01> < 0.065, 1, 0.01> translate < -2, 0,  0.5 > }
		 box { < 0, -1, -0.01> < 0.065, 1, 0.01> translate < -2, 0, -0.5 > }

		 // ------------------- Create 3 hinges for cover -------------------
		 box { < -0.05, -0.025, -0.20> < 0.085, 0.05, 0.20> translate < -2.3, 0.6,  0.00 > }
		 box { < -0.05, -0.025, -0.20> < 0.085, 0.05, 0.20> translate < -2.3, 0.6,  0.60 > }
		 box { < -0.05, -0.025, -0.20> < 0.085, 0.05, 0.20> translate < -2.3, 0.6, -0.60 > }
	  }
	  plane { y, 0 }
	  plane { -y, -0.5 rotate -z*3 }
   }
   texture { Calc_CasePlastic }
}


// -----------------------------------------------------------------------------------------
//                                     Calculator Cover
// -----------------------------------------------------------------------------------------

#declare CalcCover_Primitive = object {
   difference {
	  union {
		 box { < -2, 0, -1> < 2.1, 0.2, 1> }
		 object { CalcCase_RoundEdge  rotate y*180 translate -1.8*x}
		 object { CalcCase_RoundEdge rotate z*3 translate 1.9*x}
	  }
	  plane { -y, -0.2 }
	  plane {  y,  0.0 }
   }
}

#declare CalcCover = object {
   union {
	  difference {
		 object { CalcCover_Primitive }
		 object { CalcCover_Primitive scale <0.96, 1, 0.91> translate -y*0.05 }
		 translate x*2.25
	  }
	  // ------------------------------ Hinges ------------------------------
	  box { < 0.0, 0.0, -0.20> < 0.25, 0.06, 0.20> translate < 0, 0,  0.0 > }
	  box { < 0.0, 0.0, -0.20> < 0.25, 0.06, 0.20> translate < 0, 0,  0.6 > }
	  box { < 0.0, 0.0, -0.20> < 0.25, 0.06, 0.20> translate < 0, 0, -0.6 > }
	  // ------------------------------- Latch ------------------------------
	  box { < 0.0, 0.0, -0.40> < 0.075, -0.35, 0.40> translate < 4.375, 0, 0.0 > }
	  box { < 0.0,-0.3, -0.10> <-0.05, -0.35, 0.10> translate < 4.375, 0,  0.3 > }
	  box { < 0.0,-0.3, -0.10> <-0.05, -0.35, 0.10> translate < 4.375, 0, -0.3 > }
	  // ----------------------------- Crosspiece --------------------------
	  difference {
		 box { <0, 0.0, -0.6> < 0.075, 0.6, 0.6> }
		 cylinder { -x, x, 0.5 translate -y*0.1 }
		 scale <1,0.2,1.475>
		 translate <2,0.05,0>
	  }
   }
   texture { Calc_CasePlastic }
}


// -----------------------------------------------------------------------------------------
//                                   Calculator Face
// -----------------------------------------------------------------------------------------

#declare Face_BevelAngle = 20
#declare Face_XDist = 0.70
#declare Face_Zdist = 0.91

#declare Calc_FacePrimitive = object {
   difference {
	  box { < -Face_XDist, -0.2, -Face_Zdist> < Face_XDist, 0.3, Face_Zdist> }
	  plane {  x,0 rotate -z*Face_BevelAngle translate -x*Face_XDist }
	  plane { -x,0 rotate  z*Face_BevelAngle translate  x*Face_XDist }
	  plane {  z,0 rotate  x*Face_BevelAngle translate -z*Face_Zdist }
	  plane { -z,0 rotate -x*Face_BevelAngle translate  z*Face_Zdist }
   }
}

#declare Calc_FGWidth = 0.025  // -- Face Groove Width
#declare Calc_FGDepth = 0.030  // -- Face Groove Depth
#declare Calc_FaceGrooves = object {
   union {
	  box { <0,-Calc_FGDepth,-2> <Calc_FGWidth,0.1,2> translate 0*x*2*Calc_FGWidth }
	  box { <0,-Calc_FGDepth,-2> <Calc_FGWidth,0.1,2> translate 1*x*2*Calc_FGWidth }
	  box { <0,-Calc_FGDepth,-2> <Calc_FGWidth,0.1,2> translate 2*x*2*Calc_FGWidth }
	  box { <0,-Calc_FGDepth,-2> <Calc_FGWidth,0.1,2> translate 3*x*2*Calc_FGWidth }
	  box { <0,-Calc_FGDepth,-2> <Calc_FGWidth,0.1,2> translate 4*x*2*Calc_FGWidth }
   }
}

#declare Calc_Face = object {
   union {
	  difference {
		 object { Calc_FacePrimitive }
		 object {
			Calc_FacePrimitive
			scale <0.375, 0.45, 0.85>
			rotate z*180
			translate <0.275,0.375,0>
		 }
		 object { Calc_FaceGrooves translate <-0.275, 0.3, 0> }
		 box { <-0.25,-0.01,-0.78> <-0.1,0.1,0.78> translate <-0.275, 0.3, 0> }
	  }
	  box {
		 <-0.25,-0.01,-0.7> <0.25,0,0.7>
		 texture {
			pigment { color rgb 0.45 }
			finish {
				ambient 0.3
				diffuse 0.3
				reflection 0.20
				specular 0.4
				roughness 0.005
			}
		 }
		 translate <0.275,0.2425,0>
	  }
	  texture {
		 pigment { color rgb 0.175 }
		 finish {
			ambient 0.45
			diffuse 0.35
			specular 0.35
			roughness 0.02
			reflection 0.02
		 }
	  }
	  texture {
		 pigment {
			image_map {
			   gif "title.gif"
			   map_type 0
			   interpolate 2
			   once
			   transmit 32, 1.0
			}
		 }
		 finish { ambient 0.6 diffuse 0.1 }
		 translate <-0.5, -0.5, 0>
		 scale <1.5,0.275,1>
		 rotate x*90
		 rotate -y*90
		 translate <-0.45, 0.3, 0>
	  }
	  scale <1,1,1.05>
   }
}

// -----------------------------------------------------------------------------------------
//                                   Calculator Keypad
// -----------------------------------------------------------------------------------------

#declare Calc_BttnTexture = texture {
   pigment{
	  image_map{
		 gif "keys.gif"
		 map_type 0
		 interpolate 2
		 once
		 transmit 48, 1.0
	  }
   }
   finish { ambient 0.6 diffuse 0.1 }
   translate <-0.5, -0.5, 0>
   scale <1,1.382,1>
   scale 1.8
   rotate x*90
   rotate -y*90
   translate x*0.685
}

// --------------------------------------------------------Small Buttons

#declare Calc_SBTexture = texture {   //...Small Bttn Texture
	pigment { color rgb 0.35 }
	finish {
	   ambient 0.3
	   diffuse 0.35
	   specular 0.35
	   roughness 0.020
	}
}

#declare Calc_SmallButton = object {
   superellipsoid {
	  <0.25, 0.25>
	  scale <1,0.75,2> // <---- Set relative scaling
	  scale 0.05       // <---- Set absolute scaling
   }
}


#declare Calc_SmlBttnOffset = 0.05
#declare Calc_SmlBttnRow1 = object {
   union {
	  object { Calc_SmallButton translate -z*0.70 }
	  object { Calc_SmallButton translate -z*0.42 }
	  object { Calc_SmallButton translate -z*0.14 }
	  object { Calc_SmallButton translate  z*0.14 }
	  object { Calc_SmallButton translate  z*0.42 }
	  object { Calc_SmallButton translate  z*0.70 }
   }
}

#declare Calc_SmlBttnRow1 = object {
   union {
	  object { Calc_SmallButton translate -z*0.70 }
	  object { Calc_SmallButton translate -z*0.42 }
	  object { Calc_SmallButton translate -z*0.14 }
	  object { Calc_SmallButton translate  z*0.14 }
	  object { Calc_SmallButton translate  z*0.42 }
	  object { Calc_SmallButton translate  z*0.70 }
   }
}

#declare Calc_SmlBttnRow2 = object {
   union {
	  object { Calc_SmallButton translate -z*0.70 }
	  object { Calc_SmallButton translate -z*0.42 }
	  object { Calc_SmallButton translate -z*0.14 }
	  object { Calc_SmallButton translate  z*0.14 }
	  object { Calc_SmallButton translate  z*0.42 }
	  object { Calc_SmallButton translate  z*0.70 }
   }
}

#declare Calc_SmlBttnRow3 = object {
   union {
	  object { Calc_SmallButton translate -z*0.70 }
	  object { Calc_SmallButton translate -z*0.42 }
	  object { Calc_SmallButton translate -z*0.14 }
	  object { Calc_SmallButton translate  z*0.14 }
	  object { Calc_SmallButton translate  z*0.42 }
	  object { Calc_SmallButton translate  z*0.70 }
   }
}

#declare Calc_SmlBttnRow4 = object {
   union {
	  object { Calc_SmallButton translate -z*0.70 }
	  object { Calc_SmallButton translate -z*0.42 }
	  object { Calc_SmallButton translate -z*0.14 }
	  object { Calc_SmallButton translate  z*0.14 }
	  object { Calc_SmallButton translate  z*0.42 }
	  object { Calc_SmallButton translate  z*0.70 }
   }
}


// --------------------------------------------------------Large Buttons

#declare Calc_LBTexture = texture {   //...Large Bttn Texture
	pigment { color rgb 0.1 }
	finish {
	   ambient 0.3
	   diffuse 0.35
	   specular 0.35
	   roughness 0.020
	}
}

#declare Calc_LBTexture2 = texture {   //...Texture for C and AC buttons.
	pigment { color rgb <0.9, 0.3, 0.3> }
	finish {
	   ambient 0.3
	   diffuse 0.35
	   specular 0.35
	   roughness 0.020
	}
}


#declare Calc_LargeButton = object {
   superellipsoid {
	  <0.25, 0.25>
	  scale <1,0.75,1.333> // <---- Set relative scaling
	  scale 0.085          // <---- Set absolute scaling
   }
}

#declare Calc_LgeBttnRow1a = object {
   union {
	  object { Calc_LargeButton translate -z*0.70 }
	  object { Calc_LargeButton translate -z*0.35 }
	  object { Calc_LargeButton translate  z*0.00 }
   }
}

#declare Calc_LgeBttnRow1b = object {
   union {
	  object { Calc_LargeButton translate  z*0.35 }
	  object { Calc_LargeButton translate  z*0.70 }
   }
}

#declare Calc_LgeBttnRow2 = object {
   union {
	  object { Calc_LargeButton translate -z*0.70 }
	  object { Calc_LargeButton translate -z*0.35 }
	  object { Calc_LargeButton translate  z*0.00 }
	  object { Calc_LargeButton translate  z*0.35 }
	  object { Calc_LargeButton translate  z*0.70 }
   }
}

#declare Calc_LgeBttnRow3 = object {
   union {
	  object { Calc_LargeButton translate -z*0.70 }
	  object { Calc_LargeButton translate -z*0.35 }
	  object { Calc_LargeButton translate  z*0.00 }
	  object { Calc_LargeButton translate  z*0.35 }
	  object { Calc_LargeButton translate  z*0.70 }
   }
}

#declare Calc_LgeBttnRow4 = object {
   union {
	  object { Calc_LargeButton translate -z*0.70 }
	  object { Calc_LargeButton translate -z*0.35 }
	  object { Calc_LargeButton translate  z*0.00 }
	  object { Calc_LargeButton translate  z*0.35 }
	  object { Calc_LargeButton translate  z*0.70 }
   }
}


// --------------------------------------------------------Main Keypad
#declare SR_Spacing = 0.255  // --- Small Row Spacing
#declare LR_Spacing = 0.300  // --- Large Row Spacing

#declare Calc_Keypad = object {
   union {
	  object { CalcCover_Primitive
		 scale <0.9, 1, 0.91>
		 texture {
			pigment { color rgb 0.65 }
			finish {
			   ambient 0.35
			   diffuse 0.35
			   specular 0.3
			   roughness 0.0075
			   reflection 0.03
			}
		 }
		 texture {
			pigment{
			   image_map{
				  gif "keypad.gif"
				  map_type 0
				  interpolate 2
				  once
				  transmit 1, 1.0
			   }
			}
			finish { ambient 0.8 diffuse 0.1 }
			translate <-0.5, -0.5, 0>
			scale <1,1.382,1>
			scale 1.8
			rotate x*90
			rotate -y*90
			translate x*0.685
		 }
	  }
	  object { Calc_SmlBttnRow1 translate <-0.225+(SR_Spacing*0),0.2,0>
		 texture { Calc_SBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_SmlBttnRow2 translate <-0.225+(SR_Spacing*1),0.2,0>
		 texture { Calc_SBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_SmlBttnRow3 translate <-0.225+(SR_Spacing*2),0.2,0>
		 texture { Calc_SBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_SmlBttnRow4 translate <-0.225+(SR_Spacing*3),0.2,0>
		 texture { Calc_SBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_LgeBttnRow1a translate < 0.875+(LR_Spacing*0),0.2,0>
		 texture { Calc_LBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_LgeBttnRow1b translate < 0.875+(LR_Spacing*0),0.2,0>
		 texture { Calc_LBTexture2 } texture { Calc_BttnTexture }
	  }
	  object { Calc_LgeBttnRow2 translate < 0.875+(LR_Spacing*1),0.2,0>
		 texture { Calc_LBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_LgeBttnRow3 translate < 0.875+(LR_Spacing*2),0.2,0>
		 texture { Calc_LBTexture } texture { Calc_BttnTexture }
	  }
	  object { Calc_LgeBttnRow4 translate < 0.875+(LR_Spacing*3),0.2,0>
		 texture { Calc_LBTexture } texture { Calc_BttnTexture }
	  }
   }
}



#declare Calc_Top = object {
   union {
	  object { Calc_Face translate <-1.225, 0.1, 0> }
	  object { Calc_Keypad }
   }
}

#declare Calc_CoverClosed = 0
#declare Calc_CoverOpen = 188.125
#declare CalcShell_CoverAngle = Calc_CoverOpen


#declare Calculator = object {
   union {
	  object { Calc_Case }
	  object { CalcCover rotate z*(CalcShell_CoverAngle - 3) translate <-2.3, 0.6, 0>  }
	  object { Calc_Top rotate -z*3 translate <-0.1,0.4,0> }
   }
}

