
// Persistence of Vision Ray Tracer Scene Description File
// File: mathmisc.pov
// Vers: 1.00
// Desc: Contains misc elements for the scene "Cram Chowder". Created for the
//       May-June round of the IRTC.
// Date: 17th June 1997.
// Auth: Chris Hernandez




// -----------------------------------------------------------------------------------------
//                           Set of books held in place by book end
// -----------------------------------------------------------------------------------------

// *----------------------------------------- Books

// **** NOTE ****
// The books are very sparingly detailed. They are only meant for background/midground use.

#declare Book_EdgeTexture = texture {
   pigment {
	  gradient x sine_wave
	  color_map {
		 [ 0.00 color rgb 0.80 ]
		 [ 0.40 color rgb 0.80 ]
		 [ 0.41 color rgb 0.77 ]
		 [ 0.60 color rgb 0.77 ]
		 [ 0.61 color rgb 0.80 ]
		 [ 1.00 color rgb 0.80 ]
	  }
   }
   normal  {
	  gradient x sine_wave
	  slope_map {
		 [0.00 <0.0, 0.0>]
		 [0.50 <0.5, 0.0>]
		 [1.00 <0.0, 0.0>]

	  }
   }
   finish  { ambient 0.35 diffuse 0.35 crand 0.03 }
   scale 0.06
}


#declare BasicBook = object {
   difference {
	  box { <-0.068,0,0> <0.068,1,-0.656> }
	  cylinder {
		 -0.1*y, 1.1*y, 0.15
		 scale <1,1,0.2>
		 translate -z*0.656
		 texture {
			pigment { image_map { gif "chaos.gif" map_type 0 interpolate 2 once } }
			finish  { ambient 0.7 diffuse 0.35 specular 0.35 roughness 0.0075 crand 0.04 }
			translate <-0.5, -0.5, 0>
			rotate -z*90
			translate y*0.5
			scale <0.136,1,1>
		 }
	  }

	  box {  // ------------** Fudge to get white texture on left cover of book
		 <-0.069,-0.1,0.1> <-0.067,1.1,-0.75>
		 texture {
			pigment { image_map { gif "chaos2.gif" map_type 0 interpolate 2 once } }
			finish  { ambient 0.6 diffuse 0.45 specular 0.35 roughness 0.0075 crand 0.04 }
			translate -x*0.5
			scale <0.656, 1, 1>
			rotate y*90
			translate -z*0.37
		 }
	  }
   }
   translate -x*0.068
   scale 6.2
   texture { Book_EdgeTexture }
}

#declare BasicBook2 = object {
   difference {
	  box { <-0.075,0,0> <0.075,1,-0.7> }
	  cylinder {
		 -0.1*y, 1.1*y, 0.15
		 scale <1,1,0.2>
		 translate -z*0.7
		 texture {
			pigment { image_map { gif "zen.gif" map_type 0 interpolate 2 once } }
			finish  { ambient 0.7 diffuse 0.35 specular 0.35 roughness 0.0075 crand 0.04 }
			translate <-0.5, -0.5, 0>
			rotate -z*90
			translate y*0.5
			scale <0.15,1,1>
		 }
	  }
	  box {  // ------------** Fudge to get white texture on left cover of book
		 <-0.076,-0.1,0.1> <-0.074,1.1,-0.75>
		 texture {
			pigment { color rgb 0.80 }
			finish  { ambient 0.45 diffuse 0.45 crand 0.04 }
		 }
	  }
   }
   translate x*0.075
   scale 6.3
   texture { Book_EdgeTexture }
}

#declare BasicBook3 = object {
   difference {
	  box { <-0.068,0,0> <0.068,1,-0.656> }
	  cylinder {
		 -0.1*y, 1.1*y, 0.15
		 scale <1,1,0.2>
		 translate -z*0.656
		 texture {
			pigment { image_map { gif "life.gif" map_type 0 interpolate 2 once } }
			finish  { ambient 0.7 diffuse 0.35 specular 0.35 roughness 0.0075 crand 0.04 }
			translate <-0.5, -0.5, 0>
			rotate -z*90
			translate y*0.5
			scale <0.136,1,1>
		 }
	  }

	  box {  // ------------** Fudge to get white texture on left cover of book
		 <-0.069,-0.1,0.1> <-0.067,1.1,-0.75>
		 texture {
			pigment { color rgb <0.9, 0.9, 0.95> }
			finish  { ambient 0.6 diffuse 0.45 specular 0.35 roughness 0.0075 crand 0.04 }
		 }
	  }
   }
   translate x*0.068
   scale 6.2
   texture { Book_EdgeTexture }
}

// *----------------------------------------- Book End
#declare BookEnd = object {
   union {
	  difference {
		 superellipsoid { <0.25, 0.25> }
		 plane { -x, -0.05 }
		 plane {  x, -0.05 }
		 plane {  y,  0.00 }
		 superellipsoid { <0.25, 0.25> scale <0.6, 0.8, 0.6 > }
		 scale <1,2,0.75>
	  }
	  difference {
		 superellipsoid { <0.25, 0.25> }
		 plane { -x,  0.00 }
		 plane { -y, -0.05 }
		 plane {  y,  0.00 }
		 superellipsoid { <0.25, 0.25> scale 0.6 }
		 scale <1,1,0.75>
	  }
   }
   texture {
	  pigment { color rgb <0.65, 0.65, 0.68> }
	  finish  { ambient 0.35 diffuse 0.35 brilliance 2 crand 0.04
				specular 0.25 roughness 0.075 reflection 0.03 }
   }
   translate <-0.05, 0, -0.75>
   scale <1.5, 2.5, 2.5>
}

// *----------------------------------------- Main Book Set Object
#declare BookSet = object {
   union {
	  object { BasicBook }
	  object { BasicBook2 }
	  object { BasicBook3 translate x*0.945 }
	  object { BookEnd scale 0.85 translate <-0.8, 0, -0.1> }
   }
}


// -----------------------------------------------------------------------------------------
//                    Albert Einstein Poster w/ drawing pins at corners
// -----------------------------------------------------------------------------------------

#declare Drawing_Pin = object {
   union {
	  cone { 0*z, 0.23, -0.15*z, 0.13 }
	  cylinder { -0.15*z, -0.4*z, 0.13 }
	  cone { -0.4*z, 0.13, -0.5*z, 0.16 }
	  cone { 0*z, 0.05, 0.6*z, 0 }
   }
   texture {
	  pigment { color rgb <0.1, 0.65, 0.45> }
	  finish { ambient 0.35 diffuse 0.35 specular 0.25 roughness 0.05 reflection 0.05 }
   }
   scale 1.1
}

#declare AE_Poster = object {
   union {
	  box {
		 < -8, -10, 0> < 8, 10, 0.02>
		 texture {
			pigment { image_map { gif "ae.gif" map_type 0 interpolate 2 once } }
			finish  {
			   ambient 0.75 diffuse 0.35 specular 0.2
			   roughness 0.005 reflection 0.04 crand 0.03
			}
			translate <-0.5, -0.5, 0>
			scale <16, 20, 1>
		 }
	  }
	  object { Drawing_Pin translate <-7.5, -9.5, 0> }
	  object { Drawing_Pin translate < 7.5, -9.5, 0> }
	  object { Drawing_Pin translate <-7.5,  9.5, 0> }
	  object { Drawing_Pin translate < 7.5,  9.5, 0> }
   }
   //translate < -10, (12+3.25), 0 >
}


// -----------------------------------------------------------------------------------------
//                                        Post-It Notes
// -----------------------------------------------------------------------------------------

#declare PostIt1 = object {
   union {
	  box{ <-1.4, 0, 0> <1.4, 0.7, 0.03> }
	  object { Drawing_Pin translate y*0.3}
	  box{
		 <-1.4, 0.05, 0> <1.4, -2.3, 0.02>
		 texture {
			pigment {color rgb<0.9, 0.9,0> }
			finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 }
		 }
		 texture {
			pigment{
			   image_map { gif "postit1.gif" map_type 0 interpolate 2 once transmit 1, 1.0 }
			}
			finish { ambient 0.6 diffuse 0.35 }
			translate <-0.5, -0.5, 0>
			scale <2.8, 2.3, 1>
			translate -y*1.2
		 }
		 rotate x*10
	  }
   }
   texture {
	  pigment {color rgb<0.9, 0.9,0>}
	  finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 crand 0.05 }
   }
}

#declare PostIt2 = object {
   union {
	  box{ <-1.4, 0, 0> <1.4, 0.7, 0.03> }
	  object { Drawing_Pin translate y*0.3}
	  box{
		 <-1.4, 0.05, 0> <1.4, -2.3, 0.02>
		 texture {
			pigment {color rgb<0.9, 0.9,0> }
			finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 }
		 }
		 texture {
			pigment{
			   image_map { gif "postit2.gif" map_type 0 interpolate 2 once transmit 1, 1.0 }
			}
			finish { ambient 0.6 diffuse 0.35 }
			translate <-0.5, -0.5, 0>
			scale <2.8, 2.3, 1>
			translate -y*1.2
		 }
		 rotate x*15
	  }
   }
   texture {
	  pigment {color rgb<0.9, 0.9,0>}
	  finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 }
   }
}

#declare PostIt3 = object {
   union {
	  box{ <-1.4, 0, 0> <1.4, 0.7, 0.03> }
	  object { Drawing_Pin translate y*0.3}
	  box{
		 <-1.4, 0.05, 0> <1.4, -2.3, 0.02>
		 texture {
			pigment {color rgb<0.9, 0.9,0> }
			finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 }
		 }
		 texture {
			pigment{
			   image_map { gif "postit3.gif" map_type 0 interpolate 2 once transmit 1, 1.0 }
			}
			finish { ambient 0.6 diffuse 0.35 }
			translate <-0.5, -0.5, 0>
			scale <2.8, 2.3, 1>
			translate -y*1.2
		 }
		 rotate x*5
	  }
   }
   texture {
	  pigment {color rgb<0.9, 0.9,0> }
	  finish { ambient 0.55 diffuse 0.45 specular 0.1 roughness 0.1 crand 0.05 }
   }
}

#declare Post_Its = object {
   union {
	  object { PostIt1 rotate z*14 translate <-0.25, 0, -0.01> }
	  object { PostIt2 rotate z*3 translate <-2.75, 3.75, -0.01> }
	  object { PostIt3 rotate -z*8 translate <-4.5, -3, -0.01> }
   }
}
