
// Persistence of Vision Ray Tracer Scene Description File
// File: paper.pov
// Vers: 1.00
// Desc: Pad of lined paper, with some writing and equations on the top sheet.
//       (Quantum physics radial probability eqn's for the curious!) Created
//       for the May-June round of the IRTC.
// Date: 19-05-97.
// Auth: Chris Hernandez


#declare PadOfPaper = object {
   union {
      box {
         <-2.9, -4.4, 0> <2.9, 4.4, -0.49>
         texture {
            pigment {
               gradient z sine_wave
               color_map {
                  [ 0.00 color rgb 0.85 ]
                  [ 0.40 color rgb 0.85 ]
                  [ 0.41 color rgb 0.80 ]
                  [ 0.60 color rgb 0.80 ]
                  [ 0.61 color rgb 0.85 ]
                  [ 1.00 color rgb 0.85 ]
               }
            }
            normal  {
               gradient z
               slope_map {
                  [0.00 <0.0, 0.0>]
                  [0.50 <0.1, 0.0>]
                  [1.00 <0.0, 0.0>]
               }
            }
            finish { ambient 0.4 diffuse 0.35 crand 0.02 }
            scale 0.10 //0.05
         }
      }

      box {
         <-2.9, -4.4, -0.49> <2.9, 4.4, -0.5>
         texture {
            pigment {
               image_map {
                  gif "paper.gif"
                  map_type 0
                  interpolate 2
                  once
               }
            }
            finish { ambient 0.5 diffuse 0.35 crand 0.03 }
            translate <-0.5, -0.5, 0>
            scale <5.8,8.8,1>
         }
      }
   }
}


