// Persistence of Vision Ray Tracer Scene Description File

// File: pencil.ini
// Vers: 1.00
// Desc: Retractable ball point pen, blue. Based on the Pilot PBS. Created for the
//       May-June round of the internet raytracing comp.
// Date: May 1997
// Auth: Chris Hernandez


/* -------------------------------- Declare Global Attributes --------------------------- */

#declare Pencil_OuterRadius = 0.178
#declare Pencil_InnerRadius = 0.16

#declare PencilTexture = texture {
   pigment { color red 0.55 green 0.15 blue 0.15 }
   finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 crand 0.05 }
}



/* ------------------------------------- Pencil Body ----------------------------------- */

#declare PencilBody_Length = 5.5
#declare PencilBody_PlaneDist = 0.16875

#declare PencilBody = object {
      cylinder { PencilBody_Length*y,  0*y,  Pencil_OuterRadius hollow }

      texture {
         pigment { color rgb 0.05 }
         finish  { ambient 0.5 diffuse 0.4 specular 0.1 roughness 0.04 }
      }
}


/* ------------------------------------ Pencil Top ---------------------------------- */

#declare PencilTop = object {
   sphere {
     <0, 0, 0>
     Pencil_OuterRadius
     scale <1,0.7,1>
     translate y*PencilBody_Length
     texture { PencilTexture }
   }
}



/* ------------------------------------- End Cover ---------------------------------- */

#declare PencilEnd_Length     = 0.8

#declare PencilEnd = object {

   union{
      difference {
         cone { 0*y,  Pencil_OuterRadius, -PencilEnd_Length*y, 0.0 }
         plane { y, -0.75 }
      }
      sphere { <0, -0.75, 0>, 0.01 }

      texture {
         pigment { color red 0.9 green 0.8 blue 0.675 }
         finish  { ambient 0.6 diffuse 0.4 crand 0.1 }
      }
      texture {
         pigment {
            image_map {
               gif "pencil2.gif"
               map_type 2
               interpolate 2
               transmit 0, 1.0
            }
            scale <0.5, 1.0, 1>
            translate -y*PencilEnd_Length
         }
         finish { ambient 0.5 diffuse 0.3 crand 0.05 }
      }
   }
}

/* ------------------------------------- Pencil Sides ---------------------------------- */

#declare PencilSides = object {
   union {
      plane { z, -PencilBody_PlaneDist rotate y*000 }
      plane { z, -PencilBody_PlaneDist rotate y*045 }
      plane { z, -PencilBody_PlaneDist rotate y*090 }     //  Give the pencil body 8 sides,
      plane { z, -PencilBody_PlaneDist rotate y*135 }     //  while making the joins between
      plane { z, -PencilBody_PlaneDist rotate y*180 }     //  between the sides rounded.
      plane { z, -PencilBody_PlaneDist rotate y*225 }
      plane { z, -PencilBody_PlaneDist rotate y*270 }
      plane { z, -PencilBody_PlaneDist rotate y*315 }
   }
   texture { PencilTexture }
}



/*
   *----------------------------------------------------------------------------------------*
   |                                    Main Pencil Object                                  |
   *----------------------------------------------------------------------------------------*
*/


#declare Pencil = object {
   difference {
      union {
         object { PencilBody }
         object { PencilEnd  }
         object { PencilTop  }
      }
      object { PencilSides }
   }
}
