/******* ESSENTIAL SETUP ******/

#include "phystex.inc" //the texture set

camera {
	orthographic
	location<-3.25,1,-50>
	look_at<-3.25,1,0>
	up<0,14,0>
	right<14,0,0>
}

#background { rgb <.5,.5,1> }

light_source { <-100,100,-100> color rgb<1,1,1> }
light_source { <100,50,-200> color rgb<1,1,1> }

/***** A CATAPULT ******/

#declare Part01 = //"01: The cup"
difference {
	sphere { //outer surface of cup...
		<0,0,0>, 1.25
	}
	box { //and slice off the top...
		<-1.5,0,-1.5>, <1.5,1.5,1.5>
	}
	sphere { //...and carve out the inner surface of the cup.
		<0,0,0>, 1
	}

	scale <1,.7,1>
	texture { BaseWood rotate -90*x }
}//end Part01:The cup

#declare Part02 = //"02: The arm"
union { /*general notes: The arm will be oriented with it's pivot
		located at the origin, soas to facilitate rotating it to
		whatever angle is most convenient. (This would also make
		an animated catapult easier). */
	cylinder { //the pivot
		<0,0,-.55>, <0,0,.55>, .5
	}
	cylinder { //and an "axel" which will eventually fit together with
	           //the base unit
		<0,0,-2>, <0,0,2>, .1
		texture { Steel }
	}
	difference { //this internally sub-CSG difference "carves" the
	             //end of the arm to match up with the cup surface
		superellipsoid { //the main arm
			<.1,.1>
			scale <3.51, .2, .35>
			translate <-3.5,0,0>
		}
		sphere { //hack off where the cup is going to go...
			<0,0,0>, 1.25
			scale <1,.5,1>
			translate <-7,.3,0>
		}
	} //end sub-CSG difference

	texture { BaseWood rotate <0,90,90> scale .95 } //don't forget axel is different texture -cf
}

#declare Part03 = //the counterweight assembly...
union {
	difference { //first, an subCSG to build a smooth edged cylindrical
	             //flywheel
		superellipsoid { //the outer rim
			<1,0.1>
			scale <1,1,.25>
		}
		superellipsoid { //cut away some inner stuff
			<1,0.1>
			scale <.75,.75,.25>
			translate <0,0,-.275>
		}
		superellipsoid { //cut away some more inner stuff (other side)
			<1,0.1>
			scale <.75,.75,.25>
			translate <0,0,.275>
		}

	}

	cylinder { //the counterweight arm
	<.85,0,0>,<4,0,0>, .15
	}

	difference { //one more subCSG to make the counterweight look
	             //somewhat more interesting
		superellipsoid {
			<.1,.1>
		}
		box {
			<-1.1, -.5, -.6>, <1.1, .5, -1.1>
		}
		box {
			<-1.1, -.5, .6>, <1.1, .5, 1.1>
		}

	scale <.45, .85, .45>
	translate <4,0,0>

	texture { Lead }
	}

	texture { Steel }
	rotate <0,0,50>
}

#declare Part04 = //the launch assembly
union { //rotate this union in the negative z direction to "fire"
        //the catapult.
	object { Part01 translate <-7,.3,0> } //the cup
	object { Part02 } //the arm
	object { Part03 translate <0,0,1> } //counterweight assembly, left
	object { Part03 translate <0,0,-1> } //counterweight assembly,right
}

#declare Part05 = //the primary vertical supports...
superellipsoid {
	<.1, .1>
	scale <.3,2,.2>
	texture { BaseWood rotate 90*x }
}

#declare Part06 = //loading support
union {
	difference { //subCSG to cut a seat for the cup
		superellipsoid {
			<1,.25>
			rotate -90*x
			scale <.6,.35,.6>
			translate <0,-.5,0>
			pigment { rgb<1,1,1> }
		}
		sphere { //hack off where the cup is going to go...
			<0,0,0>, 1.25
			scale <1,.5,1>
			translate <-7,.3,0>
		}
	}

	cylinder {
		<0,-.5,0>, <0, -2,0>, .5
	}

	texture { Steel }
}

#declare Part07 = //the restraining hook needed to secure the catapult
                  //during loading
union {
	torus {
		.5, .09
		rotate -90*x
		clipped_by {
			box { <-.6,0,-.6>,<0,.6,.6> }
		}
		texture { Steel }
		translate<0,-.17,0>
	}

	cylinder {
		<0,.33,0>, <.1,.33,0>, .09
		texture { Steel }
	}

	cylinder {
		<-.5,-.17,0>, <-.5,-1.2543,0>, .09
		texture { Steel }
	}

	cone {
		<.1,.33,0>,.09,<.25,.33,0>, 0
		texture { Steel }
	}

	torus {
		.25, .085
		rotate -90*x
		scale <1,1.25,1>
		translate <-.5,-1.57,0>
		texture { Steel }
	}

	translate <0,.1,.0>
}//end restraint hook


union { //the complete catapult...

	object { Part04 } //launch assembly
	object { Part05 translate <0,0,2> } //vertical support left
	object { Part05 translate <0,0,-2> } //veritcal support right
	object { Part06 translate <-7,0,0> } //loading support
	box { //the braking bar...
		<-.26,1.4,-2>,<.26,1.77,2>
		texture { BaseWood }
	}
	superellipsoid { //the platform
		<.1,.1>
		scale <6, .5, 5>
		translate <-4,-2.5,0>
		texture { BaseWood }
	}

	object { Part07 translate <-8.1,0,0> } //the restraining hook
	torus { //the base loop which secures the restraining hook
		.25, .1
		rotate <-90,90,0>
		translate <-8.6,-1.75, 0>
		texture { Steel }
	}
	sphere { <0,0,0>, .85
		pigment { rgb<1,0,0> }
		finish { phong .75 }
		translate <-7,.195,0>
	}


}//end complete catapult

/***THE SETTING ***/
