/******* ESSENTIAL SETUP ******/

camera { //main view
	location<-20,6,-90>
	look_at<2,3,0>
	angle 14
}

global_settings {
	radiosity {
		count 200
		distance_maximum 110
		error_bound  .333
		low_error_factor .6
	}
}

/*Exterior Lighting*/

light_source {
	<50,55,-55>
	color rgb .8

}

light_source {
	<-50,55,-55>
	color rgb .8
}

/*Case Lighting*/
light_source {
	<1.75, 9.8, 0> color rgb 1.5
	 area_light <19,0,0>, <0,0,.5>, 4, 2
	 adaptive 3
	 jitter
}


#include "phystex.inc" //the texture set

/***THE SCENE***/
#include "catapult.inc" //the display item in the case
#include "papers.inc" //the papers on the back wall
#include "dispcase.inc" //the display case declaration
#include "reflect.inc" //a few items to facilitate reflections in the
                       //glass pane and the chrome parts
