// Create a segment of a torus.

/* Define the properties of the torus in the calling file */
/*
#declare TorusMajorRadius = 1
#declare TorusMinorRadius = 0.5
#declare TorusFraction = 0.5
*/

/* Error checking */
#ifndef (TorusMajorRadius)
#error "TorusMajorRadius not defined\n"
#end
#ifndef (TorusMinorRadius)
#error "TorusMinorRadius not defined\n"
#end
#ifndef (TorusFraction)
#error "TorusFraction not defined\n"
#end

#declare FractionTorus = intersection {
   torus {
      TorusMajorRadius
      TorusMinorRadius
   }
#if (TorusFraction < 0.5)
   intersection {
#else
   union {
#end
      box {
         <-TorusMajorRadius - TorusMinorRadius, -TorusMinorRadius, 0>
         < TorusMajorRadius + TorusMinorRadius, TorusMinorRadius, TorusMajorRadius + TorusMinorRadius>
      }
      box {
         <-TorusMajorRadius - TorusMinorRadius, -TorusMinorRadius, 0>
         < TorusMajorRadius + TorusMinorRadius, TorusMinorRadius, TorusMajorRadius + TorusMinorRadius>
         rotate (0.5 - TorusFraction) * 360 * y
      }
      scale 1.01
   }
   rotate -90 * x
}
