/*************************************************************************/
#declare Toaster =
union {
 union {
  difference {
   superellipsoid {<0.1,0.2> scale <0.5,1,0.9>}
   box {<1,1,2> <-1,-1,-2> translate -1.25*y}
   box {<0.1,2,0.55> <-0.1,-1,-0.55> translate -0.2*x}
   box {<0.1,2,0.55> <-0.1,-1,-0.55> translate 0.2*x}
         texture {Chrome_Texture} finish {reflection 0.6}}
  difference {
   box {<0.48,-0.25,-0.7> <-0.48,0.9,-0.92>}
   sphere {0,1 scale <0.15,0.15,0.01> translate <0,0.64,-0.922>}
   box {<0.01,0.3,0.5> <-0.01,0.05,-1.1>}
   box {<0.2,-0.1,0.5> <-0.2,-0.13,-1.1>} }
   box {<0.05,-0.1,-0.93> <-0.05,-0.14,-1> pigment {White}}
   box {<0.48,0.4,0.7> <-0.48,0.38,1.1>}
  difference {
   box {<0.48,0.4,-0.7> <-0.48,0.38,-1.1>}
   box {<0.13,0.5,-0.72> <-0.13,0,-2>} }
   box {<0.12,0.4,-0.71> <-0.12,0.38,-1.1>}
   box {<0.48,-0.25,0.8> <-0.48,0.9,0.92>}
   box {<0.5,-0.3,0.92> <-0.5,-0.24,-0.92>}  // base
   box {<0.09,1.01,0.54> <-0.09,-0.1,-0.54> translate -0.2*x}
   box {<0.09,1.01,0.54> <-0.09,-0.1,-0.54> translate 0.2*x}
        pigment {Black} finish {phong 0.8 phong_size 142} }
   box {<-0.23,-0.09,-0.88> <0.24,-0.03,-0.921> pigment {rgb <0.7,0.7,0.7>}}
   box {<-0.24,-0.09,-0.88> <-0.15,-0.03,-0.922> pigment {rgb <1,1,0>}}
   box {<-0.14,-0.09,-0.88> <-0.05,-0.03,-0.922> pigment {rgb <1,0.5,0.01>}}
   box {<-0.04,-0.09,-0.88> <0.05,-0.03,-0.922> pigment {rgb <1,0.2,0.01>}}
   box {<0.06,-0.09,-0.88> <0.15,-0.03,-0.922> pigment {rgb <0.7,0.1,0.1>}}
   box {<0.16,-0.09,-0.88> <0.25,-0.03,-0.922> pigment {rgb <0.5,0.1,0.1>}}
#declare Pin =
 union {
   box {<0.5,-0.24,-0.9> <0.55,-0.25,-0.83>}
   box {<0.54,-0.25,-0.9> <0.55,-0.45,-0.83>}
   sphere {0, 0.1 scale <0.5,0.2,0.3> translate <0.54,-0.46,-0.87>}
	      texture {Silver1}}
#declare Pin2 =
 union {
   box {<-0.5,-0.24,-0.9> <-0.55,-0.25,-0.83>}
   box {<-0.54,-0.25,-0.9> <-0.55,-0.45,-0.83>}
   sphere {0, 0.1 scale <0.5,0.2,0.3> translate <-0.54,-0.46,-0.87>}
         texture {Silver1}}
#declare Count=0
  #while (Count < 15)
    object {Pin translate z*0.12*Count}
    object {Pin2 translate z*0.12*Count}
#declare Count=Count+1
 #end
 text { ttf "arial.ttf" "Silex" 1, 0
    pigment { White } finish {ambient 0.7} scale <0.1,0.1,0.2>
      rotate <0,0,0> translate <-0.1,0.61,-0.918>} }

///////////////////////////////////////////////////////////////////////////////

#declare Toaster_1 =
union {
 union {
  difference {
   superellipsoid {<0.1,0.2> scale <0.5,1,0.9>}
   box {<1,1,2> <-1,-1,-2> translate -1.25*y}
   box {<0.1,2,0.55> <-0.1,-1,-0.55> translate -0.2*x}
   box {<0.1,2,0.55> <-0.1,-1,-0.55> translate 0.2*x}
         texture {Chrome_Texture} finish {reflection 0.6}}
  difference {
   box {<0.48,-0.25,-0.7> <-0.48,0.9,-0.92>}
   sphere {0,1 scale <0.15,0.15,0.01> translate <0,0.64,-0.922>}
   box {<0.01,0.3,0.5> <-0.01,0.05,-1.1>}
   box {<0.2,-0.1,0.5> <-0.2,-0.13,-1.1>} }
   box {<0.05,-0.1,-0.93> <-0.05,-0.14,-1> pigment {White}}
   box {<0.48,0.4,0.7> <-0.48,0.38,1.1>}
  difference {
   box {<0.48,0.4,-0.7> <-0.48,0.38,-1.1>}
   box {<0.13,0.5,-0.72> <-0.13,0,-2>} }
   box {<0.12,0.4,-0.71> <-0.12,0.38,-1.1>}
   box {<0.48,-0.25,0.8> <-0.48,0.9,0.92>}
   box {<0.5,-0.3,0.92> <-0.5,-0.24,-0.92>}  // base
   box {<0.09,1.01,0.54> <-0.09,-0.1,-0.54> translate -0.2*x}
   box {<0.09,1.01,0.54> <-0.09,-0.1,-0.54> translate 0.2*x}
        pigment {Black} finish {phong 0.8 phong_size 172} }
   box {<-0.23,-0.09,-0.88> <0.24,-0.03,-0.921> pigment {rgb <0.7,0.7,0.7>}}
   box {<-0.24,-0.09,-0.88> <-0.15,-0.03,-0.922> pigment {rgb <1,1,0>}}
   box {<-0.14,-0.09,-0.88> <-0.05,-0.03,-0.922> pigment {rgb <1,0.5,0.01>}}
   box {<-0.04,-0.09,-0.88> <0.05,-0.03,-0.922> pigment {rgb <1,0.2,0.01>}}
   box {<0.06,-0.09,-0.88> <0.15,-0.03,-0.922> pigment {rgb <0.7,0.1,0.1>}}
   box {<0.16,-0.09,-0.88> <0.25,-0.03,-0.922> pigment {rgb <0.5,0.1,0.1>}}
#declare Pin =
 union {
   box {<0.5,-0.25,-0.75> <0.55,-0.26,-0.65>}
   box {<0.54,-0.26,-0.75> <0.55,-0.71,-0.65>}
   sphere {0, 0.1 scale <0.5,0.2,0.5> translate <0.54,-0.72,-0.7>}
         texture {Silver1}}
#declare Pin2 =
 union {
   box {<-0.5,-0.25,-0.75> <-0.55,-0.26,-0.65>}
   box {<-0.54,-0.26,-0.75> <-0.55,-0.71,-0.65>}
   sphere {0, 0.1 scale <0.5,0.2,0.5> translate <-0.54,-0.72,-0.7>}
         texture {Silver1}}
#declare Count=0
  #while (Count < 8)
    object {Pin translate z*0.2*Count}
    object {Pin2 translate z*0.2*Count}
#declare Count=Count+1
 #end
 text { ttf "arial.ttf" "Silex" 1, 0
       pigment { White } finish {ambient 0.7} scale <0.1,0.1,0.2>
       rotate <0,0,0> translate <-0.1,0.61,-0.918>} }

//////////////////////////////////////////////////////////////////////////////////

#declare Pin11 =
 union {
   box {<-3.4,0.97,-0.5> <-3.3,1,-0.59>}
   box {<-3.4,1,-0.59> <-3.3,0.6,-0.59>} texture {Chrome_Texture}}
#declare Pin12 =
 union {
   box {<-3.4,0.97,0.5> <-3.3,1,0.59>}
   box {<-3.4,1,0.59> <-3.3,0.6,0.59>} texture {Chrome_Texture}}

/////////////////////////////////////////////////////////////////////////////////

#declare Toaster_Chip =
union {
 union {
  difference {
   box {<0.48,-0.25,-0.7> <-0.48,0.9,-0.92>}
   box {<0.01,0.3,0.5> <-0.01,0.05,-1.1>}
   box {<0.2,-0.1,0.5> <-0.2,-0.13,-1.1>} }
   box {<0.05,-0.1,-0.93> <-0.05,-0.14,-1> pigment {White} finish {ambient 0.4}}
   difference {
   box {<0.48,0.4,-0.7> <-0.48,0.38,-1.1>}
   box {<0.13,0.5,-0.72> <-0.13,0,-2>} }
   box {<0.12,0.4,-0.71> <-0.12,0.38,-1.1>}
        pigment {Black} finish {phong 0.9 phong_size 142} }
 union {
   box {<-0.23,-0.09,-0.88> <0.24,-0.03,-0.921> pigment {rgb <0.7,0.7,0.7>}}
   box {<-0.24,-0.09,-0.88> <-0.15,-0.03,-0.922> pigment {rgb <1,1,0>}}
   box {<-0.14,-0.09,-0.88> <-0.05,-0.03,-0.922> pigment {rgb <1,0.5,0.01>}}
   box {<-0.04,-0.09,-0.88> <0.05,-0.03,-0.922> pigment {rgb <1,0.2,0.01>}}
   box {<0.06,-0.09,-0.88> <0.15,-0.03,-0.922> pigment {rgb <0.7,0.1,0.1>}}
   box {<0.16,-0.09,-0.88> <0.25,-0.03,-0.922> pigment {rgb <0.5,0.1,0.1>}}
   text {ttf "arial.ttf" "Silex" 1, 0 pigment {White} finish {ambient 0.4}
         scale <0.18,0.25,0.2> rotate <0,0,-90> translate <-0.07,0.82,-0.922>} }
#declare Pin155 =
union {
   box {<-0.48,0.85,-0.8> <-0.58,0.8,-0.82> }
   box {<-0.56,0.85,-0.82> <-0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Pin156 =
union {
   box {<0.48,0.85,-0.8> <0.58,0.8,-0.82> }
   box {<0.56,0.85,-0.82> <0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Count=0
  #while (Count < 11)
    object {Pin155 translate y*-0.1*Count}
    object {Pin156 translate y*-0.1*Count}
#declare Count=Count+1
 #end
        scale <1,2,1> rotate 90*x translate -0.7*y}

///////////////////////////////////////////

#declare Toaster_Chip_Light =
union {
 union {
  difference {
   box {<0.48,-0.25,-0.7> <-0.48,0.9,-0.92>}
   box {<0.01,0.3,0.5> <-0.01,0.05,-1.1>}
   box {<0.2,-0.1,0.5> <-0.2,-0.13,-1.1>} }
   box {<-0.15,-0.1,-0.93> <-0.1,-0.14,-1> pigment {White} finish {ambient 0.4}}
   difference {
   box {<0.48,0.4,-0.7> <-0.48,0.38,-1.1>}
   box {<0.13,0.5,-0.72> <-0.13,0,-2>} }
   box {<0.12,0.4,-0.71> <-0.12,0.38,-1.1>}
        pigment {Black} finish {phong 0.9 phong_size 142} }
union {
   box {<-0.23,-0.09,-0.88> <0.24,-0.03,-0.921> pigment {rgb <0.7,0.7,0.7>}}
   box {<-0.24,-0.09,-0.88> <-0.15,-0.03,-0.922> pigment {rgb <1,1,0>}}
   box {<-0.14,-0.09,-0.88> <-0.05,-0.03,-0.922> pigment {rgb <1,0.5,0.01>}}
   box {<-0.04,-0.09,-0.88> <0.05,-0.03,-0.922> pigment {rgb <1,0.2,0.01>}}
   box {<0.06,-0.09,-0.88> <0.15,-0.03,-0.922> pigment {rgb <0.7,0.1,0.1>}}
   box {<0.16,-0.09,-0.88> <0.25,-0.03,-0.922> pigment {rgb <0.5,0.1,0.1>}}
   text {ttf "arial.ttf" "Silex" 1, 0 pigment {White} finish {ambient 0.4}
         scale <0.18,0.25,0.2> rotate <0,0,-90> translate <-0.07,0.82,-0.922>} }

#declare Pin155 =
union {
   box {<-0.48,0.85,-0.8> <-0.58,0.8,-0.82> }
   box {<-0.56,0.85,-0.82> <-0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Pin156 =
union {
   box {<0.48,0.85,-0.8> <0.58,0.8,-0.82> }
   box {<0.56,0.85,-0.82> <0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Count=0
  #while (Count < 11)
    object {Pin155 translate y*-0.1*Count}
    object {Pin156 translate y*-0.1*Count}
#declare Count=Count+1
 #end
  rotate 90*x scale <1,1,2> translate -0.7*y}

/////////////////////////////////////////////////

#declare Toaster_Chip_Dark =
union {
 union {
  difference {
   box {<0.48,-0.25,-0.7> <-0.48,0.9,-0.92>}
   box {<0.01,0.3,0.5> <-0.01,0.05,-1.1>}
   box {<0.2,-0.1,0.5> <-0.2,-0.13,-1.1>} }
   box {<0.15,-0.1,-0.93> <0.1,-0.14,-1> pigment {White} finish {ambient 0.4}}
   difference {
   box {<0.48,0.4,-0.7> <-0.48,0.38,-1.1>}
   box {<0.13,0.5,-0.72> <-0.13,0,-2>} }
   box {<0.12,0.4,-0.71> <-0.12,0.38,-1.1>}
        pigment {Black} finish {phong 0.9 phong_size 142} }
union {
   box {<-0.23,-0.09,-0.88> <0.24,-0.03,-0.921> pigment {rgb <0.7,0.7,0.7>}}
   box {<-0.24,-0.09,-0.88> <-0.15,-0.03,-0.922> pigment {rgb <1,1,0>}}
   box {<-0.14,-0.09,-0.88> <-0.05,-0.03,-0.922> pigment {rgb <1,0.5,0.01>}}
   box {<-0.04,-0.09,-0.88> <0.05,-0.03,-0.922> pigment {rgb <1,0.2,0.01>}}
   box {<0.06,-0.09,-0.88> <0.15,-0.03,-0.922> pigment {rgb <0.7,0.1,0.1>}}
   box {<0.16,-0.09,-0.88> <0.25,-0.03,-0.922> pigment {rgb <0.5,0.1,0.1>}}
   text {ttf "arial.ttf" "Silex" 1, 0 pigment {White} finish {ambient 0.4}
         scale <0.18,0.25,0.2> rotate <0,0,-90> translate <-0.07,0.82,-0.922>} }

#declare Pin155 =
union {
   box {<-0.48,0.85,-0.8> <-0.58,0.8,-0.82> }
   box {<-0.56,0.85,-0.82> <-0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Pin156 =
union {
   box {<0.48,0.85,-0.8> <0.58,0.8,-0.82> }
   box {<0.56,0.85,-0.82> <0.58,0.8,-0.46>}
        texture {Chrome_Texture} }
#declare Count=0
  #while (Count < 11)
    object {Pin155 translate y*-0.1*Count}
    object {Pin156 translate y*-0.1*Count}
#declare Count=Count+1
 #end
  rotate 90*x scale <1,1,2> translate -0.7*y}

///////////////////////////////////////////////////

#declare The_Little_Chip_With_A_Lot_Of_Legs =
 union {
   box {<-1,0.2,-0.6> <1,0,0.6> pigment {Black} }
   box {<-1.02,0.1,-0.62> <1.02,0,0.62> pigment {Black} }
   text {ttf "wpro10na.ttf" "C9X" 1, 0
        pigment {White} finish {ambient 0.32}
        scale <0.4,0.3,0.02>
        rotate <90,90,0> translate <-0.3,0.21,0.5>}
   text {ttf "arial.ttf" "P-4a" 1, 0
        pigment {White} finish {ambient 0.42}
        scale <0.2,0.2,0.02>
        rotate <90,90,0> translate <0.2,0.21,0.2>}
#declare Pin131 =
 union {
   box {<-0.98,0.1,-0.6> <-0.96,0.11,-0.65>}
   box {<-0.98,0.1,-0.65> <-0.96,0.05,-0.65>}
   box {<-0.98,0.05,-0.65> <-0.96,0.05,-0.7>}
   box {<-0.98,0,-0.7> <-0.96,0.025,-0.95>}
        texture {Chrome_Texture}}
#declare Pin132 =
 union {
   box {<-0.98,0.1,0.6> <-0.96,0.11,0.65>}
   box {<-0.98,0.1,0.65> <-0.96,0.05,0.65>}
   box {<-0.98,0.05,0.65> <-0.96,0.05,0.7>}
   box {<-0.98,0,0.7> <-0.96,0.025,0.95>}
        texture {Chrome_Texture}}
#declare Pin133 =
 union {
   box {<-1,0.1,0.58> <-1.05,0.11,0.56>}
   box {<-1.05,0.1,0.58> <-1.05,0.05,0.56>}
   box {<-1.05,0.05,0.58> <-1.1,0.05,0.56>}
   box {<-1.1,0,0.58> <-1.35,0.025,0.56>}
        texture {Chrome_Texture}}
#declare Pin134 =
 union {
   box {<1,0.1,0.58> <1.05,0.11,0.56>}
   box {<1.05,0.1,0.58> <1.05,0.05,0.56>}
   box {<1.05,0.05,0.58> <1.1,0.05,0.56>}
   box {<1.1,0,0.58> <1.35,0.025,0.56>}
        texture {Chrome_Texture} }
#declare Count=0
  #while (Count < 40)
    object {Pin131 translate x*0.05*Count}
    object {Pin132 translate x*0.05*Count}
#declare Count=Count+1
 #end
#declare Count=0
  #while (Count < 24)
    object {Pin133 translate -z*0.05*Count}
    object {Pin134 translate -z*0.05*Count}
#declare Count=Count+1
 #end }


/////////////////////////////////////////////////////////////////////////////////
#declare Russian_Chip =
 union {
  difference {
   box {<-3.5,0.8,-0.5> <3.6,1.2,0.5>}
   sphere {0,1 scale 0.25 translate <-3.6,1.2,0>}
   sphere {0,1 scale <0.3,0.15,0.3> translate <-2.7,1.3,0>
            pigment {Black} finish {phong 1}}
   sphere {0,1 scale <0.3,0.15,0.3> translate <2.7,1.3,0>
            pigment {Black} finish {phong 1}}
            pigment {Black} }
   box {<-3.7,0.7,-0.6> <3.8,0.4,0.6>}
   text {ttf "wpro10na.ttf" "AD.H,8HD46 `P" 1, 0
            pigment {White} finish {ambient 0.2}
            scale <0.4,0.3,0.2>
            rotate <90,0,0> translate <-1.5,1.21,-0.05>}
#declare Count=0
  #while (Count < 32)
    object {Pin11 translate x*0.22*Count}
    object {Pin12 translate x*0.22*Count}
#declare Count=Count+1
 #end
            pigment {Black} finish {phong 0.8} }

/////////////////////////////////////////////////////////////////////

#declare Connection =
 union {
  difference {
   superellipsoid {<0.1,0.3> scale <1.499,0.19,0.302>}
   box {-0.4,0.4 rotate 20*z translate -1.8*x}
   box {-0.4,0.4 rotate -20*z translate 1.8*x}
       pigment {Black} finish {phong 0.8} }
  difference {
   superellipsoid {<0.1,0.3> scale <1.5,0.2,0.3>}
   box {-0.4,0.4 rotate 20*z translate -1.87*x}
   box {-0.4,0.4 rotate -20*z translate 1.87*x}
      texture {Chrome_Texture} finish {reflection 0.4}} }

#declare Hole =
   cylinder {<0,0.05,1> <0,0.05,-1>, 0.035 open texture {Chrome_Texture}}
#declare Hole2 =
   object {Hole translate <-0.085,-0.12,0>}

#declare Connect =
 difference {
   object {Connection}
   object {Hole}
   object {Hole translate x*0.17*1}
   object {Hole translate x*0.17*2}
   object {Hole translate x*0.17*3}
   object {Hole translate x*0.17*4}
   object {Hole translate x*0.17*5}
   object {Hole translate x*0.17*6}
   object {Hole translate x*0.17*7}
   object {Hole translate x*-0.17*1}
   object {Hole translate x*-0.17*2}
   object {Hole translate x*-0.17*3}
   object {Hole translate x*-0.17*4}
   object {Hole translate x*-0.17*5}
   object {Hole translate x*-0.17*6}
   object {Hole translate x*-0.17*7}
   object {Hole2}
   object {Hole2 translate x*0.17*1}
   object {Hole2 translate x*0.17*2}
   object {Hole2 translate x*0.17*3}
   object {Hole2 translate x*0.17*4}
   object {Hole2 translate x*0.17*5}
   object {Hole2 translate x*0.17*6}
   object {Hole2 translate x*0.17*7}
   object {Hole2 translate x*-0.17*1}
   object {Hole2 translate x*-0.17*2}
   object {Hole2 translate x*-0.17*3}
   object {Hole2 translate x*-0.17*4}
   object {Hole2 translate x*-0.17*5}
   object {Hole2 translate x*-0.17*6} }

#declare Connect_2 =
 difference {
   object {Connection scale <0.35,1,1>}
   object {Hole}
   object {Hole translate x*0.17*1}
   object {Hole translate x*0.17*2}
   object {Hole translate x*-0.17*1}
   object {Hole translate x*-0.17*2}
   object {Hole2}
   object {Hole2 translate x*-0.17*1}
   object {Hole2 translate x*0.17*1}
   object {Hole2 translate x*0.17*2}
}
#declare Pin21 =
 union {
  difference {
   cylinder {<0,0,0.1> <0,0,-0.26>, 0.2}
   cylinder {<0,0,0.2> <0,0,-0.6>, 0.12}
   box {-1,1 translate 1.18*x}
   box {-1,1 translate -1.18*x}
   box {-1,1 translate 1.17*y}
   box {-1,1 translate -1.17*y}
   box {-1,1 rotate 45*z translate <-0.5,1.16,0>}
   box {-1,1 rotate -45*z translate <0.5,1.16,0>}
   box {-1,1 rotate 45*z translate <-0.5,-1.16,0>}
   box {-1,1 rotate -45*z translate <0.5,-1.16,0>}
       texture {Chrome_Texture} finish {reflection 0.5}  }
   cylinder {<0,0,0.11> <0,0,-0.32>, 0.10 open}
       texture {Chrome_Texture} finish {reflection 0.5} }

#declare Back_Plugs =
 union {
  union {
   box {<2,-0.3,0.1> <-2.4,0.3,0.37> pigment {Black}}
 difference {
   box {<1.3,-0.2,0.1> <-1.7,0.3,0.7>}
   box {<2.2,-0.3,0.36> <-2.5,0.2,0.8>}
         pigment {Black} }
   box {<2.02,-0.32,0.06> <-2.42,0.32,0.1>}
   box {<-2.15,0.32,0.1> <-2.05,0.32,0.35>}
   box {<1.8,0.32,0.1> <1.7,0.32,0.35>}
   box {<1.8,-0.2,0.37> <1.5,0.2,0.44>}
   cylinder {<1.65,0,0.36> <1.65,0,0.6>, 0.04}
   box {<-2.2,-0.2,0.37> <-2,0.2,0.44>}
   cylinder {<-2.1,0,0.36> <-2.1,0,0.6>, 0.04}
         translate -0.8*x }

 union {
   box {<0.1,-0.3,0.1> <2.4,0.3,0.37> pigment {Black}}
 difference {
   box {<0.5,-0.2,0.1> <1.8,0.22,0.7>}
   box {<0.6,-0.3,0.36> <1.7,0.17,0.8>}
        pigment {Black} }
   box {<0.12,-0.32,0.06> <2.42,0.32,0.1>}
   box {<0.2,0.32,0.1> <0.3,0.32,0.35>}
   box {<2.05,0.32,0.1> <2.15,0.32,0.35>}
   box {<0.2,-0.2,0.37> <0.5,0.2,0.44>}
   cylinder {<0.35,0,0.36> <0.35,0,0.6>,0.04}
   box {<2.2,-0.2,0.37> <1.9,0.2,0.44>}
     cylinder {<2.05,0,0.36> <2.05,0,0.6>,0.04}
   cylinder {<2.05,0,0.36> <2.05,0,0.6>,0.04}
       translate 1.3*x }
#declare Pin17 =
union {
   box {<0.6,0,0.1> <0.7,-0.02,0.6>}
   box {<0.6,0,0.6> <0.7,-0.5,0.62>} texture {Chrome_Texture}
         translate 1.35*x}
#declare Pin18 =
union {
   box {<-1.6,0,0.1> <-1.7,-0.02,0.6>}
   box {<-1.6,0,0.6> <-1.7,-0.5,0.62>} texture {Chrome_Texture}
         translate -0.75*x}
#declare Count=0
  #while (Count < 14)
    object {Pin18 translate x*0.2*Count}
#declare Count=Count+1
 #end
#declare Count=0
  #while (Count < 5)
    object {Pin17 translate x*0.2*Count}
#declare Count=Count+1
 #end
        texture {Chrome_Texture}
     finish {phong_size 14 phong 1} }

#declare Plugs =
 union {
   object {Connect translate -1*x}
   object {Connect_2 translate 2.5*x}
   object {Back_Plugs}
   object {Pin21  translate -2.9*x}
   object {Pin21 rotate 4*z translate 0.8*x}
   object {Pin21  rotate 6*z translate 1.625*x}
   object {Pin21  rotate 9*z translate 3.35*x} }

//////////////////////////////////////////////////////////////////////////////////

#declare Transistor =
union {
 difference {
   superellipsoid {<0.7,0.3> scale <1.5,1,0.15>}
   cylinder {<0,-1.8,-1> <0,-1.8,1>, 1 scale <1,0.5,1>}
   pigment {rgb <0.6,0.35,0.012>} finish {phong_size 140 phong 1} }
   cylinder {<-1,0,0> <-1.05,-3,0>, 0.04}
   cone {<-1,-2.8,0>, 0.04 <-1.04,-3.15,0>, 0.35}
   sphere {0,0.4 scale <1.1,0.6,1> translate <-1.1,-3.25.0>}
   cone {<-1,-3.5,0>, 0.4 <-1.04,-4.15,0>, 0.01}
   cylinder {<1,0,0> <1.05,-3,0>, 0.04 }
   cone {<1,-2.8,0>, 0.04 <1.04,-3.15,0>, 0.35}
   sphere {0,0.4 scale <1.1,0.6,1> translate <1.1,-3.25.0>}
   cone {<1,-3.5,0>, 0.4 <1.04,-4.15,0>, 0.01}
  text {ttf "arial.ttf" "-{ }-" 1, 0 scale <2,2,0.2>
           rotate <90,0,0> translate <-1.5,-3.15,-0.7>
		   pigment {White} finish {ambient 0.3}}
          texture {Chrome_Texture}  }

///////////////////////////////////////////////////////////////////

#declare Transistor_B =
union {
  difference {
   cylinder {<0,2.5,0> <0,0.5,0>, 1}
   box {<-2,0,0> <2,3,3>}
       pigment {Black} finish {phong_size 100 phong 1} }
   cylinder {<0.7,0.5,-0.5> <1,-1,-0.5>, 0.04}
   sphere {0,1 scale <0.3,0.1,0.3> translate <1,-1,-0.5>}
   cone {<1,-2,-0.5>, 0.6 <1.04,-2.7,-0.5>, 0.01}
   cylinder {<-0.7,0.5,-0.5> <-1,-1,-0.5>, 0.04}
   sphere {0,1 scale <0.3,0.1,0.3> translate <-1,-1,-0.5>}
   cone {<-1,-2,-0.5>, 0.6 <-1,-2.7,-0.5>, 0.01}
   cylinder {<0,0.5,-0.5> <0,-1,-0.5>, 0.04}
   sphere {0,1 scale <0.3,0.1,0.3> translate <0,-1,-0.5>}
   cone {<0,-2,-0.5>, 0.6 <0,-2.7,-0.5>, 0.01}
 difference {
   box {<-1.6,-1.59,-1.5> <1.6,-1.6,1>}
   box {<-1.5,0,-1.4> <1.5,-2.5,0.9>}
     pigment {White} finish {ambient 0.2} }

          texture {Chrome_Texture} }

#declare Transistor_Blue =
  union {
   sphere {0.5,1 scale <0.2,0.45,0.15> pigment {Blue}
           finish {specular 0.025 roughness 0.001}}
   cylinder {<0.0,0,0.05> <0.0,-0.92,0.05>, 0.03}
   cylinder {<0.2,0,0.05> <0.2,-0.92,0.05>, 0.03}
   sphere {0, 1 scale <0.09,0.04,0.04> translate <-0.02,-0.92,0>}
   sphere {0, 1 scale <0.09,0.04,0.04> translate <0.22,-0.92,0>}
   text {ttf "arial.ttf" "O" 1, 0 scale <0.6,0.6,0.2>
           rotate <90,0,0> translate <-0.18,-0.9,-0.25>
		   pigment {White} finish {ambient 0.3}}
           texture {Chrome_Texture} translate 0.92*y}


#declare Transistor_O =
union {
 union {
   cylinder {<0,0.3,0> <0,1.4,0>, 0.4}
 difference {
   cylinder {<0,1.4,0> <0,1.5,0>, 0.42}
   cylinder {<0,1.47,0> <0,1.6,0>, 0.37} }
   cylinder {<0,1.43,0> <0,1.49,0>, 0.36 texture {Chrome_Texture} }
   cylinder {<0,0.3,0> <0,0.4,0>, 0.42}
      texture { gradient x texture_map {
   [0.1  pigment{Orange} finish {phong 0.9 phong_size 115}]
   [0.59  pigment{Orange} finish {phong 0.9 phong_size 5}]
   [0.995  pigment{DarkBrown} finish {phong 0.9 phong_size 115}]}
      scale 0.3}
      rotate 13*x}
   cylinder {<0.3,0.3,0> <0.3,-0.5,0>, 0.04 texture {Chrome_Texture}}
   cylinder {<-0.3,0.3,0> <-0.3,-0.5,0>, 0.04 texture {Chrome_Texture}}
   text {ttf "arial.ttf" "-| |-" 1, 0 scale <1,1,0.2>
           rotate <90,0,0> translate <-0.7,-0.3,-0.2>
		   pigment {White} finish {ambient 0.3}} }

#declare Spot_of_tin =
 union {
   sphere {0, 1 scale <0.1,0.05,0.1>}
   sphere {0, 1 scale <0.1,0.05,0.1> translate -0.2*y}
           texture {Chrome_Texture} }

///////////////////////////////////////////////////////////////////////

#declare C1 =
 union {
   superellipsoid {<0.1,0.3> scale <1,0.2,0.12>
          pigment {rgb <0.88,0,0.2>} finish {phong 0.7}}
#declare C2 =
 union {
   cylinder {<0,0.15,0> <0,-0.2,0>, 0.16 pigment {rgb <0.8,0,0.2>}}
   cylinder {<0,0.15,0> <0,-0.3,0>, 0.04 texture {Chrome_Texture}}
   cone {<0,-0.3,0>, 0.1 <0,-0.6,0>, 0.05 texture {Chrome_Texture}}
   sphere {0,1 scale <0.13,0.01,0.17> translate -0.3*y
           texture {Chrome_Texture}} }
#declare Count=0
  #while (Count < 5)
    object {C2 translate x*0.2*Count}
    object {C2 translate x*-0.2*Count}
#declare Count=Count+1
 #end }

///////////////////////////////////////////////////////////////////////

#declare Jumper =
 union {
   box {<-0.2,0,-0.2> <0.2,0.25,0.2> pigment {Black}
        finish {ambient 0.2 phong 1} }
   box {<-0.26,0,-0.26> <0.26,0.04,0.26> pigment {White}
        finish {ambient 0.2 phong 1}}
   cylinder {<0,0,0> <0,1.3,0>, 0.04 pigment {Gold}} }
#declare Jumper_On =
 union {
   box {<-0.2,0,-0.2> <0.2,0.25,0.2>}
   box {<-0.2,0.26,-0.16> <0.2,1.33,0.16>}
   box {<-0.26,0,-0.26> <0.26,0.04,0.26> pigment {White}
        finish {ambient 0.2 phong 1}}
   cylinder {<0,0,0> <0,1.3,0>, 0.04 pigment {Gold}}
        pigment {Black} finish {ambient 0.2 phong 1}}

#declare Jumper_G =
 union {
   object {Jumper}
   object {Jumper translate 0.62*x}
   object {Jumper translate 0.32*x}
   object {Jumper translate -0.32*x}
   object {Jumper translate -0.92*x}
   object {Jumper translate -1.22*x}
   object {Jumper translate -1.52*x}
   object {Jumper translate -1.82*x}
   object {Jumper translate -2.12*x}
   object {Jumper translate -2.42*x}
   object {Jumper translate -2.72*x}}

//////////////////////////////////////////////////////////////////////////////////

#declare Resistance_R3 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,1,1> color rgb <0,1,0> ]
    [0.5, 0.8 color rgb <0,1,0> color rgb <1,1,1>]
    [0.8, 1.0 color rgb <1,1,1> color rgb <1,0,0>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R3" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3>}
     texture {Chrome_Texture} }

////////////////////////////

#declare Resistance_R4 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,1,1> color rgb <1,0,1> ]
    [0.5, 0.8 color rgb <1,0,1> color rgb <1,1,0>]
    [0.8, 1.0 color rgb <1,1,1> color rgb <1,1,1>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R4" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3>}
     texture {Chrome_Texture} }

//////////////////

#declare Resistance_R5 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <0,0,0> color rgb <0,0,1> ]
    [0.5, 0.8 color rgb <0,0,0> color rgb <0,0,1>]
    [0.8, 1.0 color rgb <1,1,0> color rgb <1,1,0>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R5" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////

#declare Resistance_R6 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <0,0,0> color rgb <1,1,1> ]
    [0.5, 0.8 color rgb <1,0,0> color rgb <1,0,0>]
    [0.8, 1.0 color rgb <1,1,1> color rgb <0.9,0.8,0.7>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text { ttf "arial.ttf" "R6" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////

#declare Resistance_R7 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,1,1> color rgb <1,1,1> ]
    [0.5, 0.8 color rgb <1,0,1> color rgb <1,0,1>]
    [0.8, 1.0 color rgb <1,0,0> color rgb <1,0,0>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text { ttf "arial.ttf" "R7" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

////////////////////

#declare Resistance_R8 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,1,1> color rgb <1,1,1> ]
    [0.5, 0.8 color rgb <0,0,1> color rgb <0,1,1>]
    [0.8, 1.0 color rgb <1,1,0> color rgb <1,1,1>] }
         scale 0.2 } finish {phong_size 113 phong 1} }
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R8" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////

#declare Resistance_R9 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,1,1> color rgb <1,1,1> ]
    [0.5, 0.8 color rgb <1,1,0.5> color rgb <1,1,1>]
    [0.8, 1.0 color rgb <1,1,1> color rgb <0.5,0.5,0.5>] }
         scale 0.2 } finish {phong_size 113 phong 1}}
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R9" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

////////////////

#declare Resistance_R10 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <1,0,1> color rgb <1,1,1> ]
    [0.5, 0.8 color rgb <1,1,0> color rgb <1,0.9,0.99>]
    [0.8, 1.0 color rgb <1,1,1> color rgb <0.5,0.6,0.5>] }
         scale 0.2 } finish {phong_size 113 phong 1}}
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R10" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////

#declare Resistance_R11 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.5 color rgb <0,0,1> color rgb <1,1,1> ]
    [0.5, 0.6 color rgb <1,0,0> color rgb <0.9,0.9,0.99>]
    [0.6, 1.0 color rgb <1,1,0> color rgb <0.75,0.60,0.50>] }
         scale 0.2 } finish {phong_size 113 phong 1}}
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R11" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////////////////////////////////

#declare Resistance_R12 =
union {
 blob { threshold 0.6
   cylinder {<-0.9,0,0> <0.9,0,0>, 0.3, 3} pigment {
       gradient x color_map {
    [0.0, 0.2 color rgb <0,0,0.9> color rgb <1,1,1> ]
    [0.2, 0.6 color rgb <0.25,0.23,0.01> color rgb <0.9,0.9,0.99>]
    [0.6, 1.0 color rgb <0.15,0.12,0.10> color rgb <0.75,0.60,0.50>] }
         scale 0.1 } finish {phong_size 113 phong 1}}
   cylinder {<-1,0,0> <-1.2,0,0>, 0.03}
   cylinder {<-1.2,0,0> <-1.3,-0.05,0>, 0.03}
   cylinder {<-1.3,-0.05,0> <-1.4,-0.1,0>, 0.03}
   cylinder {<-1.4,-0.1,0> <-1.4,-0.3,0>, 0.03}
   cylinder {<1,0,0> <1.2,0,0>, 0.03}
   cylinder {<1.2,0,0> <1.3,-0.05,0>, 0.03}
   cylinder {<1.3,-0.05,0> <1.4,-0.1,0>, 0.03}
   cylinder {<1.4,-0.1,0> <1.4,-0.3,0>, 0.03}
   sphere {0,1 scale <0.25,0.1,0.28> translate <1.42,-0.3,0>}
   sphere {0,1 scale <0.25,0.1,0.27> translate <-1.42,-0.3,0>}
 difference {
   box {<-2,-0.28,-0.5> <2,-0.29,0.5>}
   box {<-1.9,0,-0.4> <1.9,-0.5,0.4>}
     pigment {White} finish {ambient 0.2} }
   text {ttf "arial.ttf" "R12" 1, 0
     pigment {White} finish {ambient 0.3} scale <1,1,0.02>
     rotate <90,0,0> translate <2.2,-0.28,-0.3> }
     texture {Chrome_Texture} }

/////////////////////////////////////////////////////////////////////////////

#declare Plate =
union {
#declare Connector =
   box {<-11.9,0.01,-11.5> <-10,0,-11> texture {Gold_Texture}}
#declare Count=0
  #while (Count < 23)
    object {Connector translate z*0.7*Count}
#declare Count=Count+1
 #end

union {
difference {
   box {<-10.02,-0.02,-15.02> <10.02,-0.18,15.02>}
      cylinder {<0,6,0> <0,-6,0>,0.5 translate <-10.5,0,-14>}
      cylinder {<0,6,0> <0,-6,0>,0.5 translate <6.5,0,13>}
        pigment { color Quartz filter 0.5} finish {ambient 0.3} }
difference {
   box {<-10,0,-15> <10,-0.2,15>}
   cylinder {<0,6,0> <0,-6,0>,0.5 translate <6.5,0,13>}
   cylinder {<0,6,0> <0,-6,0>,0.5 translate <-10.5,0,-14>} }
   box {<-12,0,-11.7> <-10,-0.2,4.7>
   pigment {color red 0.61 green 0.74 blue 0.56 filter 0.5} }
union {
 difference {
   box {<9,0.2,-14.95> <8.95,2.4,-17>}
   cone {<8,1.4,-16>, 0.35 <12,1.4,-16>, 0.35 scale <1,1.6,1>}
   cone {<8,1.2,-16.8>, 0.35 <12,1.2,-16.8>, 0.35} }
 difference {
   box {<-15.6,0,-15> <9,2.4,-14.95>}
   box {<-15.6,3,-16> <7.5,2,-13>}
   box {<-17,1.5,-16> <-14.5,3,-13>}
   box {<-17,-0.5,-16> <-14.5,0.5,-13>}
   box {<-1,0,-1> <1,1,1> rotate -35*z translate <-15.3,2.1,-15>}
   box {<-1,0,-1> <1,1,1> rotate 35*z translate <-14.7,-0.9,-15>}
   box {<-1,0,-1> <1,1,1> rotate -40*z translate <-16.56,1.65,-15>}
   box {<-1,0,-1> <1,1,1> rotate 40*z translate <-15.9,-0.52,-15>}
   box {<-1,0,-1> <1,1,1> rotate -40*z translate <6.6,2.6,-15>}
   box {<-1,0,-1> <1,1,1> rotate -40*z translate <8,-1.1,-15>}
   box {<-1,0,-1> <1,1,1> translate <8.9,-0.7,-15>}
   cone {<-13.4,1,-16>, 0.4 <-13.4,1,-13>, 0.4 }
   cone {<7,1,-16>, 0.4 <11,1,-16>, 0.4 }  }
   object {Plugs scale 2.5 translate <-2,1,-15.3>}
        texture {Chrome_Texture} finish {reflection 0.6} }
 difference {
   box {<-12,0,-15> <-10,-0.2,-13>}
   cylinder {<0,6,0> <0,-6,0>,0.5 translate <6.5,0,13>}
   cylinder {<0,6,0> <0,-6,0>,0.5 translate <-10.5,0,-14>}
   box {<-13,1,-15> <-11.7,-1,-11>}}
        pigment {rgb <0.0221,0.2721,0.0131>}
	finish {ambient 0.1 diffuse 0.8} }
   text {ttf "arial.ttf" "MADE IN QUEBEC" 1, 0
        pigment {White} finish {ambient 0.35}
        scale <0.7,0.7,0.2> rotate <90,90,0>
        translate <9.3,0.01,13>}  }

///////////////////////////////////////////////////////////////////////////////////
