// Persistence of Vision Raytracer
// Mur arrire avec pices et appareils d'observation

/******************************************************************************
   A faire:
******************************************************************************/

#declare INC_ARRIERE=1
#include "common.inc"

/******************************************************************************

        textures

******************************************************************************/

#declare Arriere_CBlanc=color rgb<.95, .9, .85>*1
#declare Arriere_CLampes=color rgb<1, 1, 1>*1
#declare Arriere_TWood1=texture { pigment { P_WoodGrain1A color_map { M_Wood18A }}}
    texture { pigment { P_WoodGrain1B color_map { M_Wood18B }}}

/******************************************************************************

        objets

******************************************************************************/

#declare Arriere1=object{
   difference{
      box {<-1000, -10, -20> <1000, 700, 320>}
      box {<-1010, 4.9, 0> <-300, 350, 280>}
      box {<-100, 4.9, 0> <1010, 350, 280>}
      box {<-310, 4.9, 164.5> <-90, 350, 280>}
      box {<-1010, 4.9, 300> <1010, 330, 350>}
      box {<  50, 5, 270> <350, 250, 350>}
      box {<-350, 5, 165> <-50, 250, 350>}
      box {<-750, 5, 270> <-450, 250, 350>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate <-600, 250, 0>}
      cylinder {<0, 0, 165> <0, 0, 350> 1 scale <150, 50, 1> translate <-200, 250, 0>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate < 200, 250, 0>}

      box {<-1010, 354.5, -30> <1010, 680, 280>}
      box {<-1010, 354.5, 300> <1010, 680, 350>}
      box {<  50, 355, 270> < 350, 600, 350>}
      box {<-350, 355, 270> < -50, 600, 350>}
      box {<-750, 355, 270> <-450, 600, 350>}
      box {<-1150, 355, 270> <-850, 600, 350>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate < -600, 600, 0>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate < -200, 600, 0>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate <  200, 600, 0>}
      cylinder {<0, 0, 270> <0, 0, 350> 1 scale <150, 50, 1> translate <-1000, 600, 0>}
      }
   texture{T_Stone8 scale 10}
   }

#declare Arriere_Col1=union{
      box {<-60, 230, 270> <60, 240, 310>}
      box {<-55, 220, 270> <55, 230, 310>}
      sphere {0, 1 scale <30, 5, 30> translate <0, 0, 300>}
      sphere {0, 1 scale <25, 3, 25> translate <0, 13, 300>}
      cone {<0, 0, 0> 20 <0, 330, 0> 15 translate <0, 0, 300>}
      sphere {0, 1 scale <20, 3, 20> translate <0, 305, 300>}
      sphere {0, 1 scale <20, 3, 20> translate <0, 320, 300>}
      box {<-20, 320, -20> <20, 330, 20> translate <0, 0, 300>}
      }

#declare Arriere_Col2=union{
      box {<-60, 230, 270> <60, 240, 310>}
      box {<-55, 220, 270> <55, 230, 310>}
      sphere {0, 1 scale <30, 5, 30> translate <0, 0, 300>}
      sphere {0, 1 scale <25, 3, 25> translate <0, 13, 300>}
      cone {<0, 0, 0> 20 <0, 330, 0> 15 translate <0, 0, 300>}
      sphere {0, 1 scale <20, 3, 20> translate <0, 305, 300>}
      sphere {0, 1 scale <20, 3, 20> translate <0, 320, 300>}
      box {<-20, 320, -20> <20, 330, 20> translate <0, 0, 300>}
      translate 350*y
      }

#declare Arriere_Rampe1=union{
   sphere {50*y, 7}
   intersection{
      sphere {36*y, 7}
      box {<-8, 36, -8> <8, 44, 8>}
      }
   cone {0, 2, 36*y, 7}
   }

#declare Arriere_i=-1000
#declare Arriere_Rampe=union{
   cylinder {<-1000, 57, 0> <1000, 57, 0> 5}
   #while (Arriere_i < 800)
      object {Arriere_Rampe1 translate Arriere_i*x}
      #declare Arriere_i = Arriere_i+30
      #end
   }

#declare Arriere2=object{
   union{
      object {Arriere_Rampe translate <0, 350, 10>}
      object {Arriere_Col1 translate -800*x}
      object {Arriere_Col1 translate -400*x}
      object {Arriere_Col1 translate    0*x}
      object {Arriere_Col1 translate  400*x}
      object {Arriere_Col2 translate -800*x}
      object {Arriere_Col2 translate -400*x}
      object {Arriere_Col2 translate    0*x}
      object {Arriere_Col2 translate  400*x}
      }
   texture{T_Stone8 scale 10}
   }

#declare Arriere3_1=union{
   difference{
      box {<-200, 240, 300> <200, 330, 301>}
      cylinder {290*z, 310*z, 1 scale <180, 80, 1> translate <-200, 250, 0>}
      cylinder {290*z, 310*z, 1 scale <180, 80, 1> translate < 200, 250, 0>}
      cylinder {290*z, 310*z, 1 scale <10, 10, 1> translate < 25, 300, 0>}
      cylinder {290*z, 310*z, 1 scale <10, 10, 1> translate <-25, 300, 0>}
      }
   difference{
      box {<-200, 240, 300> <200, 320, 301>}
      box {< -25, 230, 290> < 25, 330, 310>}
      cylinder {290*z, 310*z, 1 scale <180, 80, 1> translate <-200, 250, 0>}
      cylinder {290*z, 310*z, 1 scale <180, 80, 1> translate < 200, 250, 0>}
      translate 350*y
      }
   }

#declare Arriere3=object{
   union{
      object {Arriere3_1 translate -800*x}
      object {Arriere3_1 translate -400*x}
      object {Arriere3_1 translate    0*x}
      object {Arriere3_1 translate  400*x}
      }
   texture{T_Stone1 scale 10}
   }

#declare Arriere_Armillae1=object{
   difference{
      union{
         cylinder {-4*x, 4*x, 50}
         cylinder {-4*y, 4*y, 50}
         cylinder {-4*z, 4*z, 50}
         }
      sphere {0, 49}
      }
   texture {T_Brass_4B }
   }

#declare Arriere_Armillae2=object{
   intersection{
      box {<-50, 0, -50> <50, 150, 50>}
      union{
         torus {40, 2 rotate 90*x rotate 45*y}
         torus {40, 2 rotate 90*x rotate -45*y}
         }
      }
   texture {T_Brass_5A }
   }

#declare Arriere_Armillae3=object{
   union{
      intersection{
         box {<-60, -60, -60> <0, 60, 60>}
         torus {55, 2.5 rotate 90*x}
         }
      cylinder {-55*y, 55*y, 2}
      }
   texture {T_Brass_5A}
   //rotate 130*z
   }

#declare Arriere_Armillae=union{
   object{Arriere_Armillae1 rotate 25*y rotate 40*z translate 85*y}
   object{Arriere_Armillae2 scale <1, .75, 1>}
   object{Arriere_Armillae3 rotate 40*z translate 85*y}
   bounded_by {box {<-100, 0, -100> <100, 140, 100>}}
   }

#declare Arriere_Globe1=object{
   difference{
      sphere {0, 49}
      union{
         cylinder {-x, x, 50 rotate   0*y}
         cylinder {-x, x, 50 rotate  30*y}
         cylinder {-x, x, 50 rotate  60*y}
         cylinder {-x, x, 50 rotate  90*y}
         cylinder {-x, x, 50 rotate 120*y}
         cylinder {-x, x, 50 rotate 150*y}
         cylinder {-y, y, 50}
         #declare Arriere_seed=seed(1)
         #declare Arriere_i=0
         #while (Arriere_i<200)
            sphere {49*x, 1 rotate <360*rand(Arriere_seed), 360*rand(Arriere_seed), 360*rand(Arriere_seed)>}
            #declare Arriere_i=Arriere_i+1
            #end
         }
      }
   texture{
      pigment {colour rgb<0.196,0.184,0.455>}
      finish {
         ambient 0.21
         brilliance 5.1
         phong 0.2    metallic
         reflection 0.1
         }
      }
   }

#declare Arriere_Globe1bis=object{
   sphere {0, 48.9}
   texture {T_Silver_5A }
   }

#declare Arriere_Globe2=object{
   intersection{
      box {<-50, 0, -50> <50, 150, 50>}
      union{
         torus {40, 2 rotate 90*x rotate 45*y}
         torus {40, 2 rotate 90*x rotate -45*y}
         }
      }
   texture {T_Brass_5A }
   }

#declare Arriere_Globe3=object{
   union{
      intersection{
         box {<-60, -60, -60> <0, 60, 60>}
         torus {55, 2.5 rotate 90*x}
         }
      cylinder {-55*y, 55*y, 2}
      }
   texture {T_Brass_5A}
   //rotate 130*z
   }

#declare Arriere_Globe=union{
   object{Arriere_Globe1 rotate 45*y rotate 40*z translate 85*y}
   object{Arriere_Globe1bis rotate 45*y rotate 40*z translate 85*y}
   object{Arriere_Globe2 scale <1, .75, 1>}
   object{Arriere_Globe3 rotate 40*z translate 85*y}
   }

#declare Arriere_Sextant1 =object{
   union{
      intersection{
         difference{
            cylinder {-3*y, 3*y, 100}
            cylinder {-4*y, 4*y,  94}
            }
         box {<-60, -4, 0> <60, 4, 100>}
         }
      box {<-37.5-2, -2, 50-2> <37.5+2, 2, 50+2>}
      box {<-2, -2, 0> <2, 2, 100>}
      box {<-3, -3, 0> <3, 3, 100> rotate  36.87*y}
      box {<-3, -3, 0> <3, 3, 100> rotate -36.87*y}
      box {<-3, -3, -55> <3, 3, 0> rotate  36.87*y translate 94*z}
      box {<-3, -3, -55> <3, 3, 0> rotate -36.87*y translate 94*z}
      }
   texture{Arriere_TWood1}
   }

#declare Arriere_Sextant2 =object{
   sphere {0, 15}
   texture{Arriere_TWood1}
   }

#declare Arriere_Sextant3 =union{
   object{Arriere_Sextant1 translate <0, 15, -50>}
   object{Arriere_Sextant2 }
   }

#declare Arriere_Sextant4=object{
   difference{
      union{
         cylinder {-4*y, 4*y, 50}
         cylinder {-3*x, 3*x, 50 rotate   0*y}
         cylinder {-3*x, 3*x, 50 rotate  30*y}
         cylinder {-3*x, 3*x, 50 rotate  60*y}
         cylinder {-3*x, 3*x, 50 rotate  90*y}
         cylinder {-3*x, 3*x, 50 rotate 120*y}
         cylinder {-3*x, 3*x, 50 rotate 150*y}
         }
      sphere {0, 49}
      box {<-100, 0, -100> <100, 100, 100>}
      }
   scale 0.4
   texture {T_Brass_4B }
   }

#declare Arriere_Sextant5=object{
   difference{
      sphere {0, 1 scale <30, 100, 30>}
      sphere {0, 1 scale <25, 95, 25>}
      box {<-40, -110, -40> <40, 0, 40>}
      box {<-40, 4, -40> <-2, 110, -2>}
      box {<  2, 4, -40> <40, 110, -2>}
      box {<-40, 4,   2> <-2, 110, 40>}
      box {<  2, 4,   2> <40, 110, 40>}
      }
   scale 0.8
   texture {T_Brass_4B }
   }

#declare Arriere_Sextant =union{
   object{Arriere_Sextant3 rotate 30*y rotate 30*x translate 100*y}
   object{Arriere_Sextant4 translate <0, 100, 0>}
   object{Arriere_Sextant5 }
   }

#declare Arriere_Pendule1=object{
   cylinder {-z, z, 85}
   texture {T_Stone6 scale 10}
   }

#declare Arriere_Pendule2=object{
   union{
      text {ttf "c:\windows\fonts\timesbd.ttf", "XII", 1,  0 scale 20 translate <-10, 65, 0> rotate 0*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "I", 1,  0 scale 20 translate <-2, 65, 0> rotate -30*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "II", 1,  0 scale 20 translate <-4, 65, 0> rotate -60*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "III", 1,  0 scale 20 translate <-6, 65, 0> rotate -90*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "IV", 1,  0 scale 20 translate <-8, 65, 0> rotate -120*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "V", 1,  0 scale 20 translate <-6, 65, 0> rotate -150*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "VI", 1,  0 scale 20 translate <-8, 65, 0> rotate -180*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "VII", 1,  0 scale 20 translate <-10, 65, 0> rotate -210*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "VIII", 1,  0 scale 20 translate <-12, 65, 0> rotate -240*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "IX", 1,  0 scale 20 translate <-8, 65, 0> rotate -270*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "X", 1,  0 scale 20 translate <-6, 65, 0> rotate -300*z}
      text {ttf "c:\windows\fonts\timesbd.ttf", "XI", 1,  0 scale 20 translate <-8, 65, 0> rotate -330*z}
      }
   //pigment {Black}
   texture {T_Brass_5A scale 10 finish{brilliance 0.0}}
   }

#declare Arriere_Pendule3=object{
   union{
      cylinder {0, 2*z, 5}
      box {<-5, 0, 0> <5, 50, 2>}
      }
   texture {T_Brass_5C scale 10}
   }

#declare Arriere_Pendule4=object{
   union{
      cylinder {2*z, 3*z, 10}
      box {<-5, 0, 2> <5, 30, 3>}
      }
   texture {T_Brass_5C scale 10}
   }

#declare Arriere_Pendule =union{
   object {Arriere_Pendule1}
   object {Arriere_Pendule2}
   object {Arriere_Pendule3 rotate -65*z}
   object {Arriere_Pendule4 rotate  65*z}
   bounded_by {cylinder {-2*z, 20*z, 90}}
   }
   
#declare Arriere_Lampes=union{
   object{ light_source{< 400, 270, 25> color Arriere_CLampes fade_distance 100 fade_power 1}}
   object{ light_source{<   0, 270, 25> color Arriere_CLampes fade_distance 100 fade_power 1}}
   object{ light_source{<-400, 270, 25> color Arriere_CLampes fade_distance 100 fade_power 1}}
   object{ light_source{<-800, 270, 25> color Arriere_CLampes fade_distance 100 fade_power 1}}
   }

#declare Arriere=union{
   object {Arriere1}
   object {Arriere2}
   object {Arriere3}
   object {Arriere_Lampes}
   object {Arriere_Armillae scale 1.2 rotate  30*y translate <-600, 355, 150>}
   object {Arriere_Sextant  scale 1.2 rotate  20*y translate <-200, 355, 150>}
   object {Arriere_Globe    scale 1.3 rotate -120*y translate < 200, 355, 150>}
   object {Arriere_Pendule translate <-200, 220, 165>}
   bounded_by{ box {<-1000, -10, -20> <1000, 700, 320>}}
   }

#ifndef (INC_MAIN)
   #include "Tycho.pov"
#end

