// Persistence of Vision Raytracer
// Mur droit

/******************************************************************************
   A faire:
******************************************************************************/

#declare INC_MURD=1
#include "common.inc"

/******************************************************************************

        textures

******************************************************************************/

#declare Murd_T2=texture{
   pigment{
      color red 0.958824 green 0.76471 blue 0.469216
      turbulence 0.5
      }
   normal{ crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
   scale 10
   }

#declare Murd_TWood1=texture { pigment { P_WoodGrain1A color_map { M_Wood17A }}}
    texture { pigment { P_WoodGrain1B color_map { M_Wood17B }}}

#declare Murd_TPages=texture {
   pigment {
      gradient y
      color_map {
         [0 color Tan *.3]
         [0.1 color Tan *.3]
         [0.1 color Tan]
         [1 color Tan*1.5]
         }
      scale .4
      translate 1000*y
      }
   }


/******************************************************************************

        objets

******************************************************************************/

#declare Murd1=object{
   union{
      difference{
         box {<300, -10, 50> <350, 500, 1000>}
         box {<298, 220, 125> <350, 280, 165>}
         cylinder {<298, 280, 145> <350, 280, 145>, 20}
         }
      cylinder{<302, -10, 50> <302, 500, 50> 2}
      }
   texture{Murd_T2}
   }

#declare Murd2=object{
   difference{
      union{
         box {<298, 220, 125> <350, 280, 165>}
         cylinder {<298, 280, 145> <350, 280, 145>, 20}
         cylinder {<298, 225, 130>, <298, 225, 160>, 1}
         cylinder {<298, 225, 130>, <298, 280, 130>, 1}
         cylinder {<298, 225, 160>, <298, 280, 160>, 1}
         sphere {<298, 225, 130>, 1}
         sphere {<298, 225, 160>, 1}
         intersection{
            box {<295, 280, 125> <350, 320, 165>}
            torus {15, 1 rotate 90*z translate <298, 280, 145>}
            }
         }
      cylinder {<298, 230, 145> <298, 280, 145>, 10}
      sphere {<298, 280, 145>, 10}
      sphere {0, 1 scale <12, 12, 4> rotate -80*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate -60*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate -40*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate -20*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate   0*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate  20*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate  40*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate  60*y translate <298, 280, 145>}
      sphere {0, 1 scale <12, 12, 4> rotate  80*y translate <298, 280, 145>}
      }
   texture{
      pigment{color White}
      }
   }

#declare Murd_Globe1=object {
   difference{
      union{
         cylinder {-.25*x, .25*x, 15}
         cylinder {-.25*x, .25*x, 15 rotate 30*y}
         cylinder {-.25*x, .25*x, 15 rotate 60*y}
         cylinder {-.25*x, .25*x, 15 rotate 90*y}
         cylinder {-.25*x, .25*x, 15 rotate 120*y}
         cylinder {-.25*x, .25*x, 15 rotate 150*y}
         difference{
            sphere {0, 15}
            box {<-16, .25, -16> <16, 4.75, 16>}
            box {<-16, 5.25, -16> <16, 9.75, 16>}
            box {<-16, 10.25, -16> <16, 15.75, 16>}
            box {<-16, -4.75, -16> <16, -.25, 16>}
            box {<-16, -9.75, -16> <16, -5.25, 16>}
            box {<-16, -15.75, -16> <16, -10.25, 16>}
            }
         }
      sphere {0, 14.5}
      }
   texture {T_Brass_3C }
   }

#declare Murd_Globe2=object{
   sphere {0, 14.75}
   texture { pigment { P_WoodGrain1A color_map { M_Wood18A }}}
   texture { pigment { P_WoodGrain1B color_map { M_Wood18B }}}
   }

#declare Murd_Globe3=object{
   intersection{
      box {<-20, 0, -20> <20, 50, 20>}
      union{
         torus {10, .5 rotate 90*x rotate 70*y}
         torus {10, .5 rotate 90*x rotate -70*y}
         }
      }
   texture {T_Brass_4B }
   }

#declare Murd_Globe4=object{
   intersection{
      box {<-20, 0, -20> <20, 50, 20>}
      torus {16, .5 rotate 90*x}
      }
   texture {T_Brass_5A}
   rotate 130*z
   }

#declare Murd_Globe=union{
   object{Murd_Globe1 rotate 10*y rotate 40*z scale 0.7}
   object{Murd_Globe2 scale 0.7}
   object{Murd_Globe3 translate -22*y}
   object{Murd_Globe4 scale 0.7}
   }

#declare Murd_iEquerre=intersection{
   box {<-20, -20, -1> <0, 0, 1>}
   union{
      cylinder {-z, z, 1 scale <15, 6, 2>}
      difference{
         box {<-5, -11, -2> <1, 1, 2>}
         cylinder {-z, z, 1 scale <5, 5, 2> translate <-5, -11, 0>}
         }
      }
   }

#declare Murd_Livre_Pages=object{
   box {<0, 0, 0> <20, 3, 30>}
   texture{Murd_TPages}
   }

#declare Murd_Livre_Broche=object{
   cylinder {0, 4*y, .3}
   texture{ T_Gold_3C}
   }

#declare Murd_Couverture1=object{
   box {<-.5, 0, -.5> <20.5, .5, 30.5>}
   texture {
      pigment {Red *.8}
      normal {crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
      }
   }

#declare Murd_Livre1=union{
   object {Murd_Couverture1}
   object {Murd_Couverture1 translate 4.5*y}
   object {Murd_Livre_Pages}
   object {Murd_Livre_Broche translate <-.5, .5,  5>}
   object {Murd_Livre_Broche translate <-.5, .5, 15>}
   object {Murd_Livre_Broche translate <-.5, .5, 25>}
   }

#declare Murd_Livre2=object{
   union{
      box {<0, 0, 0> <16, 5, 25>}
      cylinder {0, 25*z, 1 scale <1, 2.5, 1> translate <0, 2.5, 0>}
      }
   texture {
      pigment {Green *.8}
      normal {crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
      }
   }

#declare Murd_Livre3=object{
   union{
      box {<0, 0, 0> <18, 4, 28>}
      cylinder {0, 25*z, 1 scale <1, 4/2, 1> translate <0, 4/2, 0>}
      }
   texture {
      pigment {Tan *.8}
      normal {crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
      }
   }

#declare Murd_Livre4=object{
   union{
      box {<0, 0, 0> <12, 6, 24>}
      cylinder {0, 25*z, 1 scale <1, 6/2, 1> translate <0, 6/2, 0>}
      }
   texture {
      pigment {Tan *.6}
      normal {crackle 0.5 turbulence 0.5 bump_size /*3.0*/10}
      }
   }

#declare Murd_Etagere1=union{
   object {object{Murd_iEquerre} texture{Murd_TWood1 translate 1265} translate 25*z}
   object {object{Murd_iEquerre} texture{Murd_TWood1 translate 861} translate -25*z}
   object {box{<-20, 0, -30> <0, 2, 30>} texture{Murd_TWood1 translate 87287}}
   object {Murd_Livre1 translate <-20,    2, -21>}
   object {Murd_Livre1 translate <-19.5,  7, -19>}
   object {Murd_Livre1 translate <-20,   12, -20>}
   object {Murd_Livre2 rotate -105*x translate <-17, 2, 18>}
   }

#declare Murd_Etagere2=union{
   object {object{Murd_iEquerre} texture{Murd_TWood1 translate 8361} translate 25*z}
   object {object{Murd_iEquerre} texture{Murd_TWood1 translate 2488} translate -25*z}
   object {box{<-20, 0, -30> <0, 2, 30>} texture{Murd_TWood1 translate 63871}}
   object {Murd_Livre3 rotate -90*x translate <-18, 2,  9  >}
   object {Murd_Livre3 rotate -90*x translate <-18.5, 2, 13.5>}
   object {Murd_Livre3 rotate -90*x translate <-18, 2, 18  >}
   object {Murd_Livre4 rotate -90*x translate <-11, 2, 23  >}
   }

#declare Murd=union{
   object {Murd1}
   object {Murd2 translate 1*x}
   object {Murd_Globe translate <303, 250, 145>}
   object {Murd_Etagere1 translate <300, 250, 90>}
   object {Murd_Etagere2 translate <300, 300, 90>}
   }

#ifndef (INC_MAIN)
   #include "Tycho.pov"
#end
