/*
    Fantasy on Pair Creation in a Bubble Tank
    (c) 1997 by Alan Grover
*/

camera {
	location <-5, -10, -20>
	look_at  <0, 5,0>
}

light_source {
	<0, 200, -200>
	color rgb<1,1,1>
}

sphere {

	<0,0,0>, 10000
	pigment { color rgb<.5,.6,1> }
	normal { wrinkles .5 scale <1000,1000,1000> }
	scale <1,.5,1>
	hollow
}

#declare Bubble = sphere {
	<0,0,0>, 1
	hollow
	pigment { color rgbt<1,1,1,.5> }
	finish { reflection 1  specular 1 roughness .0008 diffuse 0 ambient 0}
}

#declare R8 = seed(9)

union {
#declare N = 1
#while (N < 1000)
	object {
		Bubble
		#declare rTheta = rand(R8) * 360
		#declare rr = (( 10 / 360 ) * rTheta) + (((7/360) * rTheta)*( (( rand(R8) + rand(R8) + rand(R8) ) / 3) - 1/2))
		#declare ry = ( 10 / 360) * rTheta  + (((7/360) * rTheta)*( (( rand(R8) + rand(R8) + rand(R8) ) / 3) - 1/2))
		#declare rs = (1.25 - (rTheta/360)) * (( rand(R8) + rand(R8) + rand(R8) ) / 3)
		scale rs
		translate <0,ry,rr>
		rotate <0,rTheta,0>
	}
	#declare N = N + 1
#end



	sphere {
		<0,0,0>, 4
		pigment { color rgbt<1,1,1,1> }
		hollow
		halo {
			emitting
			spherical_mapping
			cubic

			color_map {
				[ 0 rgbt <0,0,0,1> ]
				[ .01 rgbt <1,0,0,.9> ]
				[ .1 rgbt <1,.5,0,.8> ]
				[ .5 rgbt <1,.7,0,.2> ]
				[ .55 rgbt <1,1,0,0> ]
				[ .8 rgbt <1,1,1,0> ]
				[ 1 rgbt <1,1,1,0> ]
			}
			samples 30
		}
		halo {
			emitting
			box_mapping
			cubic

			color_map {
				[ 0 rgbt <0,0,0,1> ]
				[ .1 rgbt <1,0,0,.9> ]
				[ .5 rgbt <1,.5,0,.8> ]
				[ .6 rgbt <1,.7,0,.2> ]
				[ .77 rgbt <1,1,0,0> ]
				[ .8 rgbt <1,1,1,0> ]
				[ 1 rgbt <1,1,1,0> ]
			}
			samples 30
			scale 1.5
		}
		translate <-.6,0,-.6>
	}
	rotate <0,90,0>
	translate <-10,0,0>
}

union {
#declare N = 1
#while (N < 1000)
	object {
		Bubble
		#declare rTheta = rand(R8) * 360
		#declare rr = (( 10 / 360 ) * rTheta) + (((7/360) * rTheta)*( (( rand(R8) + rand(R8) + rand(R8) ) / 3) - 1/2))
		#declare ry = ( 10 / 360) * rTheta  + (((7/360) * rTheta)*( (( rand(R8) + rand(R8) + rand(R8) ) / 3) - 1/2))
		#declare rs = (1.25 - (rTheta/360)) * (( rand(R8) + rand(R8) + rand(R8) ) / 3)
		scale rs
		translate <0,ry,rr>
		rotate <0,-rTheta,0>
	}
	#declare N = N + 1
#end



	sphere {
		<0,0,0>, 4
		pigment { color rgbt<1,1,1,1> }
		hollow
		halo {
			emitting
			spherical_mapping
			cubic

			color_map {
				[ 0 rgbt <0,0,0,1> ]
				[ .01 rgbt <1,0,0,.9> ]
				[ .1 rgbt <1,.5,0,.8> ]
				[ .5 rgbt <1,.7,0,.2> ]
				[ .55 rgbt <1,1,0,0> ]
				[ .8 rgbt <1,1,1,0> ]
				[ 1 rgbt <1,1,1,0> ]
			}
			samples 30
		}
		halo {
			emitting
			box_mapping
			cubic

			color_map {
				[ 0 rgbt <0,0,0,1> ]
				[ .1 rgbt <1,0,0,.9> ]
				[ .5 rgbt <1,.5,0,.8> ]
				[ .6 rgbt <1,.7,0,.2> ]
				[ .77 rgbt <1,1,0,0> ]
				[ .8 rgbt <1,1,1,0> ]
				[ 1 rgbt <1,1,1,0> ]
			}
			samples 30
			scale 1.5
		}
		translate <.6,0,-.6>
	}
	rotate <0,-90,0>
	translate <10,0,0>
}

#declare R1 = seed(0)
#declare N = 1
#while (N < 1000)
	object {
		Bubble
		#declare rx = 25 * rand(R1)
		#declare ry = ( (5/3) * ( rand(R1) + rand(R1) + rand(R1) ) - 5/2 )
		#declare rz = ( (5/3) * ( rand(R1) + rand(R1) + rand(R1) ) - 5/2 )
		#declare rr = ( rand(R1) + rand(R1) + rand(R1) ) / 15
		scale rr
		translate < rx, ry + 10, rz >
		rotate <0,90,0>
	}
	#declare N = N + 1
#end
