global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 5
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.5,0.65,0.8> }

camera {  //  Camera StdCam
  location  <-80.930, -100.621, 20.645>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <5.337, -20.447, 16.583>
}

// *******  L I G H T S *******
light_source { // AreaL001
  <-37.270, -100.603, 70.928>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}


light_source {   // Light1
  <-111.513, 63.431, 143.883>
  color rgb <1.000, 1.000, 1.000>
}


// ********  BOY en FIL DE FER  *******
#include "glboy.inc"  


// ********  SUPPORT  *******

#declare carreau1 = object {
  superellipsoid { // carreau1
    <0.1, 0.3>
    scale <10.0, 10.0, 1.0>
    translate  <60.0, 60.0, 0.0>
  }
}

#declare txCarreau = texture {
   pigment {
     color rgb<0.216, 0.216, 0.659>
   }
   finish {
     diffuse 0.700
     ambient 0.300
     reflection 0.150
     specular 0.600
     roughness 0.1000
     brilliance 8.000
   }
}


 union { // Allcarreau
 #declare cpti=-10
 #declare maxcpti=10
 #declare maxcptj=10
 #declare pas=20.5

 #while (cpti<maxcpti)
  #declare cptj=-5
  #while (cptj<maxcptj)
    object { // carreau2->carreau1
      carreau1
      translate  <pas*cpti,pas*cptj,0.0>
  }
    #declare cptj=cptj+1
  #end
  #declare cpti=cpti+1
 #end
 translate  -1.082504*z
 texture {
    txCarreau
  }
}


//******** Boy surface plein *******

#declare SphRay=0.5
#declare maxcntmu=100
#declare maxcntte=100
#declare cntmu = 0

#while (cntmu<maxcntmu)
  #declare mu=cntmu*pi/maxcntmu
  #declare myD=10+1.41*sin(6*mu-pi/3)
  #declare myE=1.98*sin(3*mu-pi/6)
  #declare myA=myD+myE
  #declare myB=myD-myE
  #declare myAL=(pi/8)*sin(3*mu)
  #declare myC1=myA*myA-myB*myB
  #declare myC2=sqrt(myA*myA+myB*myB)
  #declare myCM=cos(mu)
  #declare mySM=sin(mu)

  #declare cntte=0
  #while  (cntte<maxcntte)
   #declare te=cntte*2*pi/maxcntte
   #declare myX1=myC1/myC2+myA*cos(te)-myB*sin(te)
   #declare myZ1=myC2+myA*cos(te)+myB*sin(te)
   #declare myX=myX1*myCM-myZ1*sin(myAL)*mySM
   #declare myY=myX1*mySM+myZ1*sin(myAL)*myCM
   #declare myZ=myZ1*cos(myAL)
   #declare cntte=cntte+1

   sphere
   {
     <myX,myY,myZ>,SphRay
     translate <55,-10,0>
     pigment {
        #if (te<pi)
             color red 0.5 green 0.65 blue te/(2*pi)
        #else
             color red 0.5 green 0.65 blue 1-te/(2*pi)
        #end
     }
   }
  #end
  #declare cntmu=cntmu+1
#end
