//
//  bh20.pov
//+
//	Black hole
//-
//  rev 06/26/97 gls continue
//  rev 06/23/97 gls continue
//  rev 06/19/97 gls continue
//  rev 06/05/97 gls continue
//  rev 05/30/97 gls continue
//  rev 05/22/97 gls continue
//  rev 05/20/97 gls continue
//  rev 05/14/97 gls continue
//  rev 05/12/97 gls continue
//  rev 05/11/97 gls
//


#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "stars.inc"
#include "metals.inc"

#declare ScaleXYZ= 0.01
#declare fDebugSphere = 0
#declare fDebugPlanes = 0
#declare fDebugXYZ = 0


#declare fEnableAll = 1
#declare fEnableBlkHole = 0
#declare fEnableTextEMC2 = 0
#declare fEnableTextSpace = 0
#declare fEnableTeapot = 0
#declare fEnableSig = 1


#declare Default = texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
#declare Default = texture { pigment{ White } }




#declare Default = texture { pigment{ White } }


// //////////////////////////////////////////////////


camera
      {
      location  <125*1, 125*1, -125*2>      // x, y, z
///      location  <125*2, 125*1, -125*2>      // x, y, z
      direction <0, 0,  1>
      up        <0, 1,  0>
      right     <4/3, 0, 0>
      look_at   <0, 0, 0>
      }

// //////////////////////////////////////////////////
//
//  Describe the light sources to project the shadows
//
light_source  { <125, 125, -125> color White  }
light_source  { <0, 125, 0> color White  }
light_source  { <-100, 300, 0> color White  }

// //////////////////////////////////////////////////

// //////////////////////////////////////////////////
#if ( fEnableBlkHole | fEnableAll )

#declare PigBlkHole = pigment
        {
        image_map {  tga "\images\mesh4.tga" } // MODIFIERS...
        scale 100.0
        }

#declare objBlkHole = object { #include "3dm\bh20.inc" }

object{ objBlkHole
        scale 3.0

        pigment{ PigBlkHole rotate <90,0,0>}
 //       pigment{ White }

        }
#end
// //////////////////////////////////////////////////
#if ( fEnableTeapot | fEnableAll )

#declare TextureTeapot = texture
        {
        T_Gold_5E finish { phong 0.9 phong_size 60 }
        }


#declare Default = texture { TextureTeapot }
#declare objTeapot = union{ #include "3dm\teapot20.inc" }

object{ objTeapot
        scale 1.20
        rotate <0, -60, 33>
        translate <-10, 40, -150>
        texture { TextureTeapot }
//        pigment{ White }
        }
#end

// //////////////////////////////////////////////////

#if ( fEnableTextEMC2 | fEnableAll )

#declare TextureText1 = texture
        {
        T_Silver_1A finish { phong 0.9 phong_size 60 }
        }

#declare Default = texture { TextureText1  }
#declare objEmc2 = union { #include "3dm\emc20.inc" }

object{ objEmc2
        scale 3.0
        rotate <0, 0, -20>
        translate <50+20, 0, 0>
//        pigment{ White }
        }
#end

// //////////////////////////////////////////////////

#if ( fEnableTextSpace | fEnableAll )

#declare TextureTextSpace = texture
        {
        T_Chrome_5A finish { phong 0.9 phong_size 60 }
        }

#declare Default = texture { TextureTextSpace  }
#declare objSpaceTime = union { #include "3dm\sptime21.inc" }

object{ objSpaceTime
        scale 2.0
        rotate <0, 0, 33>
        translate <-50, 0, 0>
//        pigment{ White }
        }
#end



// //////////////////////////////////////////////////

// //////////////////////////////////////////////////


// The sky
#declare MyStarField =
    pigment {
        granite
            color_map {
                [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
                [ 0.72  0.75 color Gray20 color Gray40 ] // Very Very Faint Stars
                [ 0.75  0.78 color Gray40 color Gray60 ] // Very Faint Stars
                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
                [ 0.81  0.85 color Gray80 color Gray95 ] // Medium White Stars
                [ 0.85  0.91 color Gray95 color White  ] // White Stars
                [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
            }
         scale .015
     }

#declare MyApocalypse =
pigment {
    bozo
    color_map {
        [0.0, 0.3 color rgbt <0.8, 0.0, 0.0, 0.0 >
                  color rgbt <0.4, 0.0, 0.4, 0.3 >]
        [0.3, 0.6 color rgbt <0.4, 0.0, 0.4, 0.3 >
                  color rgbt <0.0, 0.0, 0.2, 0.85 >]
        [0.6, 1.0 color rgbt <0.0, 0.0, 0.2, 0.85 >
                  color rgbt <0.0, 0.0, 0.0, 1.0 >]
    }
}
#declare MyLightning =
pigment {
    marble
    color_map {
        [0.0, 0.01          color rgbt <1.0, 1.0, 1.0, 0.0 >
                            color rgbt <0.94, 0.81, 0.99, 0.65 >]
        [0.01, 0.010001     color rgbt <0.94, 0.81, 0.99, 0.65 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
        [0.010001, 1.0      color rgbt <1.0, 1.0, 1.0, 1.00 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
    }
}


sky_sphere {
    pigment { MyStarField }

    pigment { MyApocalypse turbulence 2.5 scale .30 rotate < -45, 0, 0 > }

    pigment { MyLightning turbulence 0.5 scale .5 }
    pigment { MyLightning turbulence 0.4 scale .7 rotate < 0, -5, 135 > }
    pigment { MyLightning turbulence 0.45 scale .6 rotate < 0, 4, -140 > }
    pigment { MyLightning turbulence 0.45 scale .4 rotate < -40, 4, -90 > }

    pigment { MyLightning turbulence 0.65 scale .3 rotate < -40, 40, -40 > }
}


// //////////////////////////////////////////////////

#if( fDebugPlanes )
plane
     {
     y, -50                     // axis, distance from origin
     pigment { color Green }
///     pigment { color Aquamarine   }
     }

plane
     {
     x, -50                     // axis, distance from origin
     pigment { color Red }
///     pigment { color White }
     }

plane
     {
     z, 50                     // axis, distance from origin
     pigment { color Blue }
     }
#end

// //////////////////////////////////////////////////
//
//  Now, a sphere for demo purposes
//
#if( fDebugSphere )

sphere
      {
      <5, 5, -5> 5.0
      pigment {
              color Silver
              }
      finish  {
              Shiny
              }

      }
#end

// //////////////////////////////////////////////////
//
//  Now, the signature (Using a TrueType font)...
//
#if ( fEnableSig | fEnableAll )
text {
    ttf             // font type (only TrueType format for now)
    "timrom.ttf",   // Microsoft Windows-format TrueType font file name
    "GLS",          // the string to create
    0.15,            // the extrusion depth
    0               // offset

    texture { T_Chrome_5E finish { phong 0.9 phong_size 60 } }
    rotate < 45.0/3, -45.0/2, 0 >
    scale < 15.0, 8.0, 15.0 >
    translate < -10, 5, -190>
}
#end

// //////////////////////////////////////////////////

#if (fDebugXYZ)
//
//  Now, the X axis
//
cylinder
        {
        <1,0,0>,       // Center of one end
        <100,0,0>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Red }
        finish {Shiny}
        }


//
//  Y axis
//
cylinder
        {
        <0,1,0>,       // Center of one end
        <0,100,0>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Green }
        finish {Shiny}
        }


//
//  Z axis
//
cylinder
        {
        <0,0,-1>,       // Center of one end
        <0,0,-100>,       // Center of other end
        2.5            // Radius
        open           // Remove end caps
        pigment {color Blue }
        finish {Shiny}
        }

#end

// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
// //////////////////////////////////////////////////

