//
//  geb810.pov
//+
// Goedel/Escher/Bach
//-
//  rev 06/18/97 gls continue
//  rev 06/13/97 gls continue
//  rev 05/12/97 gls change to normalize the object to (0,0,0)
//  rev 01/26/97 gls change to use TTF for charachters
//  rev 12/21/96 gls continue
//  rev 12/08/96 gls continue
//  rev 11/26/96 gls
//

#include "colors.inc"
#include "textures.inc"

#include "woods.inc"
#include "metals.inc"


// //////////////////////////////////////////////////
camera
      {
      location  <100, 100, -100>      // x, y, z
      direction <0, 0,  1>
      up        <0, 1,  0>
      right     <4/3, 0, 0>
      look_at   <0, -20, 0>
      }
// //////////////////////////////////////////////////
//
//      Configurable parameters
//
#declare fDebugSphere = 0
#declare fDebugXYZ = 0
#declare SizeObjectGEB = 40
#declare xDistPtLightGEB = 200 * 1.5
#declare DistPtLightGEB = 300 * 1.2

#declare FontObjectGEB = "ariblk.ttf" // Microsoft Windows-format TrueType font file name
#declare xFontObjectGEB = "timrom.ttf" // Microsoft Windows-format TrueType font file name


// //////////////////////////////////////////////////

//
//  Describe the light sources to project the shadows
//
#declare xxSpotlightTightness = 60/0.5
#declare SpotlightTightness = 150.0
#declare SpotlightRadius = 10*1
#declare SpoltlightFalloff = 35

light_source      // YZ projection - Goedel
    {
    <DistPtLightGEB , 0, 0> color White
    spotlight point_at <0, 0, 0>
    tightness SpotlightTightness
    radius SpotlightRadius
    falloff SpoltlightFalloff
    }

light_source     // XZ projection - Escher
    {
    <0, DistPtLightGEB , 0> color White // Blue // White
    spotlight point_at <0, 0, 0>
    tightness SpotlightTightness
    radius SpotlightRadius
    falloff SpoltlightFalloff
    }

light_source      // XY projection - Bach
    {
    <0, 0, -DistPtLightGEB > color White // Green //White
    spotlight point_at <0, 0, 0>
    tightness SpotlightTightness
    radius SpotlightRadius
    falloff SpoltlightFalloff
    }


// //////////////////////////////////////////////////
//
//      G for Goedel
//
#declare Goedel =
        text {
                ttf             // font type (only TrueType format for now)
                FontObjectGEB,  // TTFont
                "G",            // the string to create
                1.02,            // the extrusion depth
                0               // offset

                scale <1.0, 1.0, 1.0>  // some more needed
//                scale <1.0/1.02, 1.0/1.02, 1.0/1.02>  // some more needed
                translate <0, 0, -1>      // place in foreground
                rotate <0, -90, 0>        // rotate into place
        }

//
//      E for Escher
//
#declare Escher=
        text {
                ttf             // font type (only TrueType format for now)
                FontObjectGEB,  // TTFont
                "E",            // the string to create
                1.02,            // the extrusion depth
                0               // offset

                scale <1.02, 1.02, 1.02>  // some more needed
                translate <0, 0, -1>      // place in foreground
                rotate <90, 0, 0>        // rotate into place
        }

//
//      B for Bach
//
#declare Bach=
        text {
                ttf             // font type (only TrueType format for now)
                FontObjectGEB,  // TTFont
                "B",            // the string to create
                1.02,            // the extrusion depth
                0               // offset

                translate <0, 0, 0>      // place in foreground
                rotate <0, 0, 0>        // rotate into place
        }


//
//      Now, the CSG combined object
//
intersection
        {
        object{ Goedel }
        object{ Escher }
        object{ Bach }

        translate <0.15, 0.15, 0.15>       // nudge into place
        scale SizeObjectGEB             // scale to size
        translate <-SizeObjectGEB/2.0, -SizeObjectGEB/2.0, -SizeObjectGEB/2.0>             // no translation

        texture { pigment{ BrightGold } finish { phong 0.9 phong_size 60 } }
    }


#if ( fDebugSphere )
        sphere
        {
        <0, 0, 0> // center of sphere <X Y Z>
        0.25       // radius of sphere
        scale SizeObjectGEB
        texture { pigment{ BrightGold } finish { phong 0.9 phong_size 60 } }
        }
#end

// //////////////////////////////////////////////////
//
//  XYZ planes to project on
//
#declare PigG = pigment
        {
        image_map {  gif "goedel2.gif" transmit all 0.01 } // MODIFIERS...
        scale 50.0
        }
#declare PigE = pigment
        {
        image_map {  gif "escher2.gif" transmit all 0.01 } // MODIFIERS...
//        image_map {  gif "esc221.gif" filter all 0.1 } // MODIFIERS...
        scale 100.0
        }
#declare PigB = pigment
        {
        image_map {  gif "bach2.gif" transmit all 0.01 } // MODIFIERS...
//        image_map {  gif "esc221.gif" filter all 0.1 } // MODIFIERS...
        scale 100.0
        }

plane                           // Godel plane
     {
     x, -SizeObjectGEB * 3.0 // axis, distance from origin
        pigment { PigG  rotate <0, -90, 0>}
 //    pigment { color Red transmit 0.1 }
     }

plane                           // Escher plane
     {
     y, -SizeObjectGEB  * 3.0 // axis, distance from origin

        pigment { PigE rotate <0, 90, 90> }
//      pigment { color Green}
     }

plane                           // Bach plane
     {
     z, SizeObjectGEB * 3.0 // axis, distance from origin
        pigment { PigB }
//     pigment { color Blue }
     }


// //////////////////////////////////////////////////
// //////////////////////////////////////////////////

#if (fDebugXYZ)
//
//  Now, the X axis
//
cylinder
        {
        <1,0,0>,       // Center of one end
        <100,0,0>,       // Center of other end
        1.0            // Radius
        open           // Remove end caps
        pigment {color Red }
        finish {Shiny}
        }


//
//  Y axis
//
cylinder
        {
        <0,1,0>,       // Center of one end
        <0,100,0>,       // Center of other end
        1.0            // Radius
        open           // Remove end caps
        pigment {color Green }
        finish {Shiny}
        }

//
//  Z axis
//
cylinder
        {
        <0,0,-1>,       // Center of one end
        <0,0,-100>,       // Center of other end
        1.0            // Radius
        open           // Remove end caps
        pigment {color Blue }
        finish {Shiny}
        }
#end

// //////////////////////////////////////////////////
//
//  Now, the signature (Using a TrueType font)...
//
text {
    ttf             // font type (only TrueType format for now)
    "timrom.ttf",   // Microsoft Windows-format TrueType font file name
    "GLS",          // the string to create
    0.2,            // the extrusion depth
    0               // offset
    texture { T_Gold_5E finish { phong 0.9 phong_size 60 } }
    scale 8.0
    rotate 30 * x       // rotate into view
    rotate -45 * y      // rotate into view
    no_shadow
    translate < -20, -60, -100>
//    translate < 20, -40, -80>
//    translate < -40, -20, -20 >
}


// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
// //////////////////////////////////////////////////

