//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


#declare NucleonRadius = 1


#declare T_Atomic =
texture {
    finish {
        ambient .2
        diffuse .6
        specular .7
        reflection .1
        roughness .02
    }
}

#declare AtomicRed =
texture {
    T_Atomic
    pigment {  color Red  }
}

#declare AtomicBlue =
texture {
    T_Atomic
    pigment {  color Blue  }
}


#declare GlassShellTex =
texture {
    pigment { color rgbt <1,1,1,1> }
    finish {
        ambient 0
        diffuse 0
        reflection 0.01
        specular 0.32
        refraction on
        ior 1
    }
}


//--------------------------- nucleus of atom ---------------------------------

#declare AtomicNucleus =
union
{
    sphere {
           < -1.00000, -2.88675, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000, -2.88675, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000, -1.15470, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000, -1.15470, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000, -1.15470, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -3.00000,  0.57735, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -1.00000,  0.57735, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000,  0.57735, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  3.00000,  0.57735, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000,  2.30940, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000,  2.30940, -4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000,  2.30940, -4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000, -3.46410, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000, -3.46410, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000, -3.46410, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -3.00000, -1.73205, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -1.00000, -1.73205, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000, -1.73205, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  3.00000, -1.73205, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -4.00000,  0.00000, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  0.00000, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  0.00000, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  0.00000, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  4.00000,  0.00000, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  1.73205, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  1.73205, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  1.73205, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  1.73205, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  3.46410, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  3.46410, -3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  3.46410, -3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -4.61880, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -4.61880, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -4.61880, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000, -2.88675, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000, -2.88675, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000, -2.88675, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000, -2.88675, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -4.00000, -1.15470, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -1.15470, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -1.15470, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -1.15470, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  4.00000, -1.15470, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -5.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  5.00000,  0.57735, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -4.00000,  2.30940, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  2.30940, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  2.30940, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  2.30940, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  4.00000,  2.30940, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  4.04145, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  4.04145, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  4.04145, -1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  4.04145, -1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -1.00000, -5.19615,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000, -5.19615,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -4.00000, -3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -3.46410,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -3.46410,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  4.00000, -3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -5.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  5.00000, -1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -4.00000,  0.00000,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  0.00000,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  0.00000,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  0.00000,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  4.00000,  0.00000,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -5.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -3.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -1.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  3.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  5.00000,  1.73205,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -4.00000,  3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000,  3.46410,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000,  3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000,  3.46410,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  4.00000,  3.46410,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  5.19615,  0.00000>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  5.19615,  0.00000>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -4.61880,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -4.61880,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -4.61880,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000, -2.88675,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000, -2.88675,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000, -2.88675,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000, -2.88675,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -4.00000, -1.15470,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -1.15470,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -1.15470,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -1.15470,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  4.00000, -1.15470,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -5.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  5.00000,  0.57735,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -4.00000,  2.30940,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  2.30940,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  2.30940,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  2.30940,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  4.00000,  2.30940,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  4.04145,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  4.04145,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  4.04145,  1.63299>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  4.04145,  1.63299>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000, -3.46410,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000, -3.46410,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000, -3.46410,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -3.00000, -1.73205,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -1.00000, -1.73205,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  1.00000, -1.73205,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  3.00000, -1.73205,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -4.00000,  0.00000,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  0.00000,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  0.00000,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  0.00000,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  4.00000,  0.00000,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  1.73205,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  1.73205,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  1.73205,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  3.00000,  1.73205,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -2.00000,  3.46410,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  0.00000,  3.46410,  3.26599>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  2.00000,  3.46410,  3.26599>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000, -2.88675,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000, -2.88675,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -2.00000, -1.15470,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  0.00000, -1.15470,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           <  2.00000, -1.15470,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           < -3.00000,  0.57735,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere {
           < -1.00000,  0.57735,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere {
           <  1.00000,  0.57735,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere
    {
           <  3.00000,  0.57735,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere
    {
           < -2.00000,  2.30940,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
    sphere
    {
           <  0.00000,  2.30940,  4.89898>, NucleonRadius
           texture { AtomicBlue }
    }
    sphere
    {
           <  2.00000,  2.30940,  4.89898>, NucleonRadius
           texture { AtomicRed }
    }
#if ( SimplifyAtom = off )
    sphere {
        <0,0,0>, 6.8
        texture { GlassShellTex }
    }
#end
}


//---------------------------- electrons --------------------------------------

#declare ElectronOrbitTex =
texture {
    pigment {
        Gold
    }
#if ( SimplifyAtom = off )
    finish {
        ambient 0.15
        diffuse 0.65
        reflection 0.3
        phong 10
        roughness 0.01
        metallic
    }
#end
}

#declare ElectronTex =
texture {
    pigment { color Green }
#if ( SimplifyAtom = off )
    finish {
        ambient 0.05
        diffuse 0.5
        specular 0.1
        reflection 0.4
        roughness 0.1
        metallic
    }
#end
}


#declare ElectronOrbit =
torus {
    12, 0.06
    texture {  ElectronOrbitTex  }
}


#declare Electron =
sphere {
    <12,0,0>, 0.45
    texture {  ElectronTex  }
}


#declare ElectronTrail =
cone {
    <12,0,0>, 0.5 <12,0,-5>, 0.2

#if ( SimplifyAtom = off )
    pigment { color rgbt <1,1,1,1> }
    halo {
        attenuating
        cylindrical_mapping
        linear
        turbulence 1.6
        color_map {
            [ 0   color rgbt <0.8,0.49,0.19,0.5> ]
            [ 1   color rgbt <0.9,0.9,0.1,1> ]
        }
        samples 10
        scale 0.75
    }
    hollow
#else
    pigment { color Yellow }
#end
}


#declare ElectronShell =
union {
    object {  ElectronOrbit  }
    object {  Electron  }
    object {  ElectronTrail  }
}


#declare Atom =
union {
    object {  AtomicNucleus  }
    object {                                // e1   - electrons
        ElectronShell
        rotate y*100
    }
    object {                                // e2
        ElectronShell
        rotate y*58
        rotate z*30
    }
    object {                                // e3
        ElectronShell
        rotate y*198
        rotate z*60
    }
    object {                                // e4
        ElectronShell
        rotate y*-48
        rotate z*90
    }
    object {                                // e5
        ElectronShell
        rotate y*52
        rotate z*120
    }
    object {                                // e6
        ElectronShell
        rotate y*185
        rotate z*150
    }
}


object {                                            // atom
    Atom
    scale <0.3,0.3,0.3>
    translate <3,3.2,0>
}


