//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


#include "golds.inc"


#declare B1 = 0.5               // semi-length of chip
#declare B2 = 0.15              // vertical separation from board
#declare B3 = 0.15              // height of chip
#declare B4 = 0.12              // upper connector length
#declare B5 = 0.03              // connector width
#declare B6 = 0.01              // thickness of connector
#declare B7 = 0.11              // separation between connector legs


#declare ChipBox =
box {
    <-B1,B2,-B1>, <B1,B2+B3,B1>
    texture {
        pigment {
            image_map {
                gif "chip.gif"
            }
            translate <-0.5,-0.5,0>
            rotate <90,0,0>
        }
        finish { Dull }
    }
}


#declare ChipLeg =
union {
    // one-side leg
    box {
        <B1-Eps,B2+B3/2-B6,-B5>, <B1+B4,B2+B3/2+B6,B5>
    }
    box {
        <B1+B4,B2+B3/2+B6,-B5>, <B1+B4,-Eps,B5>
    }
    box {
        <B1+B4,Eps,-B5>, <B1+B4+B4,Eps,B5>
    }
    // one-side leg
    box {
        <-B1+Eps,B2+B3/2-B6,-B5>, <-B1-B4,B2+B3/2+B6,B5>
    }
    box {
        <-B1-B4,B2+B3/2+B6,-B5>, <-B1-B4,-Eps,B5>
    }
    box {
        <-B1-B4,Eps,-B5>, <-B1-B4-B4,Eps,B5>
    }
    texture { T_Gold_1A }
}


#declare Chip =
union {
    object {  ChipBox  }
    object {
        ChipLeg
    }
    object {
        ChipLeg
        translate <0,0,B7>
    }
    object {
        ChipLeg
        translate <0,0,2*B7>
    }
    object {
        ChipLeg
        translate <0,0,3*B7>
    }
    object {
        ChipLeg
        translate <0,0,4*B7>
    }
    object {
        ChipLeg
        translate <0,0,-B7>
    }
    object {
        ChipLeg
        translate <0,0,-2*B7>
    }
    object {
        ChipLeg
        translate <0,0,-3*B7>
    }
    object {
        ChipLeg
        translate <0,0,-4*B7>
    }
}


//------------------------------ IC chips -------------------------------------

object {
    Chip
    rotate <0,90,0>
    scale <0.7,1,0.7>
    translate <3.5,0,-2.4>
}

object {
    Chip
    rotate <0,180,0>
    scale <0.7,1,0.7>
    translate <4.5,0,-6.8>
}

object {
    Chip
    scale <0.9,1,1>
    translate <2.2,0,-7>
}


