//-----------------------------------------------------------------------------
//  Image Title: "Realms of Physics"
//  Author: Mark Borg
//          markborg@keyworld.net
//  For Internet Raytracing Competition of June
//  Competition Subject: Maths & Physics
//-----------------------------------------------------------------------------



#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "golds.inc"


#declare UseCamera = 1



#declare Eps = 0.0001


#if ( UseCamera = 1 )
    #declare camera_location = <2.8,3.5,-13>        // camera 1
    #declare camera_look_at = <-0.8,0,0>
#end
#if ( UseCamera = 2 )
    #declare camera_location = <1,11,-5>         // camera 2
    #declare camera_look_at = <1,0,-5>
#end


camera {
    location camera_location
    look_at camera_look_at
}


light_source {
    <1.5,3,-35>
    color White
}

light_source {
    <1,11,-5>
    color White*0.7
    shadowless
}



#declare SimplifyAtom = off
#include "atom.inc"

#include "board.inc"
#include "capacitr.inc"
#include "resistor.inc"
#include "chip.inc"

#declare SimplifyPlasma = off
#include "plasma.inc"

#include "binaryst.inc"
#include "starsky.inc"


/* end of file */
