/*
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: FEMALE FIGURE
// Date: v1 07.06.97
// Auth: NB

background{ color rgb <.9,.9,1>}

light_source {<-500,500,500>
color rgb <1,1,1>}

//camera{ location<-60,0,0>*12
//camera{ location<0,0,60>*12
//camera{ location<0,-60,0>*8
camera{ location<-500,50,300>*1.5
angle 5
look_at <0,10,0>}
//look_at <0,0,0>}

#declare SK_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.7
      phong 0.2
      phong_size 20
   }
  normal {bumps .2 scale.005}
   pigment{color rgb <1,.85,.7>}
}
*/

#declare DD_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.8
      phong 0.2
      phong_size 20
   }
   pigment{color rgb <.7,1,.6>}
}

#declare FEM01=
union{
#declare SIDE = -1 // 1=left, -1=right, don't even try other values
#declare ZCENT = 3.05*SIDE
#include "head02.inc"
union{
object{HEAD02f
   translate<(.3+1.8*sin(radians(7)))*-1,1.5+1.8*cos(radians(7)),0>
   scale 1.415
   translate<.3,23,0>}

object{HAIR01
   translate<(.3+1.8*sin(radians(7)))*-1,1.5+1.8*cos(radians(7)),0>
   scale 1.415
   translate<.3,23,0>}

//right
//leg
#declare LJZ_01 = 5
#declare LJZ_02 = 10
#declare LJZ_03 = 0
#declare DJZ_11 = LJZ_01
//arm
#declare AAX_01 = 3
#declare AAZ_01 = -5
#declare AAZ_02 = 40
#declare AAY_02 = -45
//hand
//ball of the thumb/thumb
   #declare H_A01X = 3*SIDE     //adjustable
   #declare H_A01Z = -32        //adjustable
//thumb
   #declare H_A11Y = 10*SIDE    //"joint 1", adjustable
   #declare H_A21Y = 10*SIDE    //"joint 2", adjustable
   #declare H_A21Z = 15         //"joint 2", adjustable
//forefinger
   #declare H_A02Y = 32*SIDE    //"joint 1", adjustable
   #declare H_A12Y = 65*SIDE    //"joint 2", adjustable
   #declare H_A22Y = 72*SIDE    //"joint 3", adjustable
//middle finger
   #declare H_A03Y = 34*SIDE    //"joint 1", adjustable
   #declare H_A13Y = 66*SIDE    //"joint 2", adjustable
   #declare H_A23Y = 68*SIDE    //"joint 3", adjustable
//4th finger
   #declare H_A04Y = 34*SIDE    //"joint 1", adjustable
   #declare H_A14Y = 68*SIDE    //"joint 2", adjustable
   #declare H_A24Y = 70*SIDE    //"joint 3", adjustable
//little finger
   #declare H_A05Y = 35*SIDE    //"joint 1", adjustable
   #declare H_A15Y = 66*SIDE    //"joint 2", adjustable
   #declare H_A25Y = 68*SIDE    //"joint 3", adjustable

#include "body001.inc"
#include "shoe001.inc"

//left
#declare SIDE = 1 // 1=left, -1=right, don't even try other values
#declare ZCENT = 3.05*SIDE
//LEG
#declare LJZ_01 = -25
#declare LJZ_02 = 20
#declare LJZ_03 = 20
#declare DJZ_01 = LJZ_01
//arm
#declare AAX_01 = 8
#declare AAZ_01 = -10
#declare AAZ_02 = 10
#declare AAY_02 = 5
//hand
//ball of the thumb/thumb
   #declare H_A01X = 3*SIDE     //adjustable
   #declare H_A01Z = -40        //adjustable
//thumb
   #declare H_A11Y = 10*SIDE    //"joint 1", adjustable
   #declare H_A21Y = 10*SIDE    //"joint 2", adjustable
   #declare H_A21Z = 20         //"joint 2", adjustable
//forefinger
   #declare H_A02Y = 32*SIDE    //"joint 1", adjustable
   #declare H_A12Y = 63*SIDE    //"joint 2", adjustable
   #declare H_A22Y = 74*SIDE    //"joint 3", adjustable
//middle finger
   #declare H_A03Y = 34*SIDE    //"joint 1", adjustable
   #declare H_A13Y = 66*SIDE    //"joint 2", adjustable
   #declare H_A23Y = 72*SIDE    //"joint 3", adjustable
//4th finger
   #declare H_A04Y = 34*SIDE    //"joint 1", adjustable
   #declare H_A14Y = 68*SIDE    //"joint 2", adjustable
   #declare H_A24Y = 72*SIDE    //"joint 3", adjustable
//little finger
   #declare H_A05Y = 35*SIDE    //"joint 1", adjustable
   #declare H_A15Y = 66*SIDE    //"joint 2", adjustable
   #declare H_A25Y = 70*SIDE    //"joint 3", adjustable

#include "body001.inc"
#include "shoe001.inc"
#include "dress001.inc"
}
}
// cylinder{<0,0,0><0,100,0>,.1}
//object{FEM01}
