 global_settings {
     radiosity {
       // brightness
       distance_maximum 20
       
       count 150
     }
   }

#include"metals.inc"

background {color rgb <.9,.95,1>}

camera{
// location <0,-100,-100>
location <-50,60,-60>*.2
//location <20,5,15>*1.2
   angle 15
   look_at <4,2,5.9>
// look_at <7,(1/256*166),5.9>
// look_at <1.65,.9,6.9>
}

light_source{ <-500,500,-500>*100
   color rgb <1,1,1>
//   fade_distance 100
//   fade_power 2
}

#declare TEX=
texture{
   finish { ambient <1,.7,0>*.4 diffuse 0.9 phong .5 reflection .1}
   normal{bumps .1 scale .15}
   pigment{color rgb <1,.7,0>}
}

#declare SK_TEX =
texture{
   finish{
   diffuse .4
     // ambient <1,.85,.7>*.7
      ambient <.98,.82,.67>*.7
      phong 0.2
      phong_size 20
   }
  normal {bumps .2 scale.005}
   pigment{color rgb <.98,.82,.67>}
//   pigment{color rgb <1,.85,.7>}
}

#declare TERR01=
height_field
{
  gif
  "aa.gif" scale <10,1,10>
  smooth
texture{TEX}
}

#declare LAKE01=
box{<0,0,0><10,.1,10> texture{T_Chrome_4D}
#declare W_SC01=3
normal {
  gradient x-z //sine_wave
    normal_map {
               [0 wood 0.3 rotate x*90 scale .2/W_SC01 translate <0.2/W_SC01,0,0>]
               [.9 spiral2 72 0.2 rotate x*90 scale .3/W_SC01 translate <0.05/W_SC01,0,0>]
               [1 bumps .01]
               }
               scale W_SC01
               translate <4.8,0,5.9>}
}

#declare TERR02=
difference{
   cylinder{<0,0,0><0,(1/256*166),0>30 translate <5,0,5.9>}
   box{<0,-1,0><9.999999,1,9.999999>}
texture{TEX}
}

//#declare R=10
//#declare r=2
#declare R=0
#declare r=0
#declare b_r=1
#declare n=24
#declare m=24
#declare g0=0
#declare g=(2*pi/(m*n))
#declare a0=0
#declare a=(pi/m)
//#declare Count=m*n
#declare Count=2500
#declare dz=0

#declare SPIRAL01=
blob {threshold 0.6
     #while (Count>0)
#declare x1= (R+r*cos(a0))*cos(g0)
#declare y1= (R+r*cos(a0))*sin(g0)
#declare z1= r*sin(a0)+dz
     #declare g0=g0+g
     #declare a0=a0+a
     #declare dz=(dz+.03)*1.0002
     #declare R=R+.012
     #declare r=r+.005
#declare x2= (R+r*cos(a0))*cos(g0)
#declare y2= (R+r*cos(a0))*sin(g0)
#declare z2= r*sin(a0)+dz
     cylinder{<x1,y1,z1><x2,y2,z2>,b_r,5}
     #declare Count=Count-1
     #declare b_r=b_r*1.0004
     #end
scale .05
rotate x*-90
translate <5,0.1,5.9>
//texture{TEX}
texture{T_Chrome_4D}
}

#declare FH01=2
#declare FR01=2
#declare FT01=.01

#declare FN01=6
#declare FA00=360/FN01
#declare FA0I=0

#declare FENCE01=
union{
   torus { FR01,FT01}
   #while (FN01>0)
      cylinder{<0,0,0><0,FH01*-1,0>FT01 translate x*FR01 rotate y*FA0I}
      #declare FA0I=FA0I+FA00
      #declare FN01=FN01-1
   #end
translate <4.2,FH01,5.9>
texture{T_Chrome_4D}}

object{TERR01}
object{TERR02}
object{LAKE01}
object{SPIRAL01}
object{FENCE01}

#declare E_R00=0
#declare W_R00=-1
#include "fem01.pov"
object{FEM01 rotate y*-15 scale .065  translate <7,1.55,5>}

#declare E_R00=1
#declare W_R00=0
#include "fem02.pov"
object{FEM01 rotate z*-2  rotate y*-98 scale .065  translate <2.2,1.596,7.1>}

#include "f_37_01.inc"
object {CAR01 translate y*13 scale .04 rotate y*0 translate <4.6,(1/256*166),10.5>}

