
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: NB
/*
background{ color rgb <.9,.9,1>}

light_source {<-500,-500,-500>
color rgb <1,1,1>}

//camera{ location<-60,-10,0>*3
camera{ location<0,-10,-60>*3
//camera{ location<0,-60,0>*3
//camera{ location<500,50,300>*.5
angle 5
look_at <0,-10,0>}
//look_at <0,0,0>}

#declare DD_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.8
      phong 0.2
      phong_size 20
   }
   pigment{color rgb <.7,1,.6>}
}

#declare SIDE = 1 // 1=left, -1=right, don't even try other values
*/
#declare HR_02 = .65
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11
#declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 10.7
/*
#declare ZCENT = 3.05*SIDE

#declare LJZ_01 = -30
#declare LJZ_02 = 40
#declare LJZ_03 = 0//20
*/
union{
difference{
blob{ threshold HD_02
   cylinder{<0,0,0><0,2,0>,1.2,HS_02
      translate y*LB_02*-1
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02}

   sphere{0,1,HS_02 scale <.6/HR_02,.5/HR_02,.5/HR_02>*1.1
      rotate z*-80
      translate x*.5
      rotate y*-10*SIDE
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02}

   sphere{0,1,HS_02 scale <1.9/HR_02,1.5/HR_02,.95/HR_02>
      translate x*-1
      rotate z*25
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02}

cylinder{<0,0,1><0,0,-1>,1,HS_02*-1
      scale <1/HR_02,1/HR_02,1>
      translate <-2.2,1.2,0>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02}

sphere{0,1,-5 scale <5/HR_02,.7/HR_02,5/HR_02>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.17,(LB_02*sin(radians(LAX_02))*SIDE)*1.15>
   rotate z*LJZ_02}


sphere{0,1,HS_02
      scale <1.7/HR_02,.4/HR_02,1/HR_02>
      //rotate y*-15*SIDE
      translate <-2.2,0,.2*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02}
sturm
translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
          (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
           LB_01*sin(radians(LAX_01))>*SIDE
rotate z*LJZ_01
translate y*10
translate z*ZCENT*-1
}
union{
   box{<0,0,-5><3,3,3>
      rotate z*25
      translate <-.45,.2,0>
   }
   box{<0,-.7,-5><3,-3,3>
      translate y*.2
      rotate z*25
      translate <-.45,0,0>
   }
   box{<0,0,-5><-3,3,3>
      rotate z*10
      translate <-3.1,-.8,0>
   }
      rotate z*LJZ_03
      translate y*LB_02*-1
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02
   translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
             (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
              LB_01*sin(radians(LAX_01))>*SIDE
rotate z*LJZ_01
translate y*10
translate z*ZCENT*-1
}
}


difference{
union{
   difference{
      cylinder{<0,0,0><0,-2.8,0>,1
         scale <1,1,.65>
         translate <.2,0,0>}
      cylinder{<0,0,0><0,-2.9,0>,1
         scale <.4,1,.65>
         translate <-.4,0,0>}
   }
   difference{
      cylinder{<0,0,0><0,-2.8,0>,1.5
         scale <1.35,1,.72>
         rotate y*-8*SIDE
         translate <-1.62,0,-.2*SIDE>}
      cylinder{<0,0,-5><0,0,5>,1
         scale <1.5,3,1>
         rotate y*-2*SIDE
         translate y*-3
         rotate z*-50
         translate <3.5,0,0>}
   }
}
cylinder{<0,0,-5><0,0,5>,1
         scale <4,1.5,1>
         rotate z*20
         translate y*-3
         translate <-2,2.95,0>}

      rotate z*(LJZ_03-20)
      translate y*LB_02*-1
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02
   translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
             (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
              LB_01*sin(radians(LAX_01))>*SIDE
rotate z*LJZ_01
translate y*10
translate z*ZCENT*-1
}
//texture{DD_TEX}
texture{T_Chrome_4D}
}
