
//=============================================================================
// 3D-Lissajous
// by Roland Baer
// May 22. 1997
//=============================================================================

#include "colors.inc"
#include "textures.inc"

//-----------------------------------------------------------------------------

camera {
       location <75,75,-75>
       look_at <20,0,0>
}

//-----------------------------------------------------------------------------

light_source {
       <300,600,-300>
       color rgb <1,1,1>
}

//-----------------------------------------------------------------------------

plane {
       y,-1
       texture {finish {Mirror} pigment{White} }
        //pigment{color rgb <0.3,0.2,0.7>}

}

plane {
       z,21
       texture {finish {Phong_Shiny} pigment{Blue}}
       //pigment{color rgb <0.3,0.7,0.2>}

}

#declare Schrittweite=0.002
#declare A=0
#while (A<1)
              #declare X=15*(sin(3*A*pi*2)*5)
              #declare Y=15*(sin(5*A*pi*2+5))
              #declare Z=15*(sin(4*A*pi*2+1))
              #declare Farbe=<(sin(A*pi*2)*0.5+0.5),1-(sin(A*pi*2)*0.5+0.5),0.5>
              sphere {
                     <X,Y,Z>,1
                     texture{
                           finish {Phong_Shiny}
                           pigment{
                                  color rgb Farbe
                           }
                     }
                     translate <0,20,0>
              }
              #declare A=A+Schrittweite
#end
