/*
  Spiral Generator For PoV 3.01
  Written by Wong Chee Fah on Friday 4th April 1997
*/

// Enter Major Spiral parameters here
#declare Show_Major = 0		// Show Major Spiral ( Default = 1 )
				// 0 for No, 1 for Yes
#declare Dir_Major = 1		// Major Spiral Direction ( Default = 1 )
				// 0 for Anti-Clockwise, 1 for Clockwise
#declare R1 = 60		// Start Radius of Major Spiral
#declare R2 = 0			// End Radius of Major Spiral
#declare H = 200		// Major Spiral Height
#declare Rev = 3		// Number of Major Revolutions
#declare Start_Rad_Maj = 5	// Starting Radius of Major Sphere
#declare End_Rad_Maj = 0	// Ending Radius of Major Sphere
#declare Num_Maj = 300		// Number of Spheres per Major Spiral
#declare S_Num_Maj = 4		// Number of Major Spirals

// Enter Minor Spiral parameters here
#declare Show_Minor = 1		// Show Minor Spiral ( Default = 1 )
				// 0 for No, 1 for Yes
#declare Dir_Minor = 0		// Minor Spiral Direction ( Default = 1 )
				// 0 for Anti-Clockwise, 1 for Clockwise
#declare R3 = 15		// Start Radius of Minor Spiral
#declare R4 = 0			// End Radius of Minor Spiral
#declare Turns = 2		// Number of Turns per Major Revolution
#declare Start_Rad_Min = 5	// Starting Radius of Minor Sphere
#declare End_Rad_Min = 0	// Ending Radius of Minor Sphere
#declare Num_Min = 1		// Number of Spheres generated per Major Sphere
#declare S_Num_Min = 4		// Number of Minor Spirals per Major Spiral

#declare Col_Scale = 200	// Scale Factor for color map

// The Spiral is computed here
#declare Spiral = union {

#declare T_Maj = 0
#while ( T_Maj < Num_Maj )

        #declare Y_Pos_Major = H*T_Maj/Num_Maj

	#if ( Dir_Major = 0 )	// Anti-Clockwise
	#declare X_Pos_Major = (R1-T_Maj*(R1-R2)/Num_Maj) * sin(-2*pi*Rev*T_Maj/Num_Maj)
        #declare Z_Pos_Major = (R1-T_Maj*(R1-R2)/Num_Maj) * cos(-2*pi*Rev*T_Maj/Num_Maj)
	#else			// Clockwise (Default)
	#declare X_Pos_Major = (R1-T_Maj*(R1-R2)/Num_Maj) * sin(2*pi*Rev*T_Maj/Num_Maj)
        #declare Z_Pos_Major = (R1-T_Maj*(R1-R2)/Num_Maj) * cos(2*pi*Rev*T_Maj/Num_Maj)
	#end	// End of If

	#if (!( Show_Major = 0 ))	// Show Major Spiral
        object { 
                sphere {0, 1}
                scale (Start_Rad_Maj-T_Maj*(Start_Rad_Maj-End_Rad_Maj)/Num_Maj)
                translate < X_Pos_Major, Y_Pos_Major, Z_Pos_Major >
               }
	#end	// End of If

	#if (!( Show_Minor = 0 ))	// Compute and Show Minor Spiral

	#declare T_Min = 0
	#while ( T_Min < Num_Min )

		#declare T = T_Maj*Num_Min + T_Min
		#declare Num = Num_Maj*Num_Min

        	#declare Y_Pos_Minor = H*T/Num - Y_Pos_Major

		#if ( Dir_Minor = 0 )	// Anti-Clockwise
		#declare X_Pos_Minor = (R3-T*(R3-R4)/Num) * sin(-2*pi*Rev*Turns*T/Num)
        	#declare Z_Pos_Minor = (R3-T*(R3-R4)/Num) * cos(-2*pi*Rev*Turns*T/Num)
		#else			// Clockwise (Default)
		#declare X_Pos_Minor = (R3-T*(R3-R4)/Num) * sin(2*pi*Rev*Turns*T/Num)
        	#declare Z_Pos_Minor = (R3-T*(R3-R4)/Num) * cos(2*pi*Rev*Turns*T/Num)
		#end	// End of If

		#declare Minor_Group = union {

		#declare Group_Obj = 0
		#while ( Group_Obj < S_Num_Min )

        	object { 
                	sphere {0, 1}
	                scale (Start_Rad_Min-T*(Start_Rad_Min-End_Rad_Min)/Num)
        	        translate < X_Pos_Minor, Y_Pos_Minor, Z_Pos_Minor >
			rotate < 0, Group_Obj*360/S_Num_Min, 0 >
		       }

		#declare Group_Obj = Group_Obj + 1

		#end	// End of While

		}	// End of Union (Minor_Group)

		object {	// Place Minor Group into position wrt Major Spiral
			Minor_Group
	                translate < X_Pos_Major, Y_Pos_Major, Z_Pos_Major >
		       }

	#declare T_Min = T_Min + 1

	#end	// End of While

	#end	// End of If

#declare T_Maj = T_Maj + 1

#end	// End of While

} // End of Union (Spiral)

// Define texture for the Sipral
#declare Atexture = texture {
                         finish{
                                ambient 0.2
                                diffuse 0.8
                                phong 1.0
                                phong_size 30.0
                               }
                             }

// Define colors for the color map 
#declare Color0 = color rgb< 1, 0, 0 >
#declare Color1 = color rgb< 1, 1, 0 >
#declare Color2 = color rgb< 0, 1, 0 >
#declare Color3 = color rgb< 0, 1, 1 >
#declare Color4 = color rgb< 0, 0, 1 >
#declare Color5 = color rgb< 1, 0, 1 >

// Place the Spiral in the scene
#declare Count = 0	// Spiral Count
#while ( Count < S_Num_Maj )
object {
        Spiral
        texture { Atexture
                pigment {
			gradient y
                        color_map {
                                [ 0.0 Color0 ]
                    		[ 0.1 Color1 ]
			        [ 0.2 Color2 ]
				[ 0.3 Color3 ]
				[ 0.4 Color4 ]
                                [ 0.5 Color5 ]
                                [ 0.6 Color4 ]
  				[ 0.7 Color3 ]
				[ 0.8 Color2 ]
				[ 0.9 Color1 ]
				[ 1.0 Color0 ]
				  }
                        scale Col_Scale
                        }
                }
	rotate < 0, Count*360/S_Num_Maj, 0> // Rotate each spiral by an increasing amount
       } // End of Object

#declare Count = Count + 1

#end	// End of While

// Place camera
camera {
	location  < 180, 180, 180 >
	direction < 0.0, 0.0, 1.0 >
	up	  < 0.0, 1.0, 0.0 >
	right	  < 4/3, 0.0, 0.0 >
	look_at   < 0.0,  90, 0.0 >
	}

// Let there be light
object { light_source { <300 300 300> color rgb< 1, 1, 1 >} }
