#include "colors.inc"
#include "textures.inc"

#declare G = 6.6720e-11 // Gravitational Constant
#declare black_hole_mass = 1e16
#declare c = 300000000 // speed of light is about 300,000,000 m/sec

#declare divisor = 1e7  // 1/divisor seconds per iteration
#declare num_skips = 1e3// skip this many movement calculations
                        // this gives us the precision of divisor without
                        // having to have so many particles

#declare objloc = <1e9 , 1, -7326>
#declare objvec = <0, c, 0>

camera
    {
    location <10, 1, 3e9>
    direction <0,0,1>
    sky <0,0,1>
    look_at 0
    }

light_source
    {
    <10e8,10e8,10e8>
    color 1
    }

sphere
     {
     0, 1000
     texture{ pigment{ color White} }
     finish{ ambient 1 }
     }

#debug "Initial data\n"
#debug concat("Objloc is: <",str(objloc.x,0,0),",",str(objloc.y,0,0), "," ,str(objloc.z,0,0),">\n")
#debug concat("ObjVec is: <",str(objvec.x,0,0),",",str(objvec.y,0,0), "," ,str(objvec.z,0,0),">\n\n")

#declare i = 0
#while (i < 30)
    sphere{
        0, 1
        texture{ pigment {color Blue} finish {ambient 1} }
        scale 1e3
        translate objloc
        }

#declare j = 0
#while (j<num_skips)
#if (vlength(objvec))
#else
#declare objvec = objvec +1
#end

#if (vlength(objloc))
#else
#declare objvec = objloc +1
#end

#declare oldloc = objloc

#declare deltavec = G*(black_hole_mass/pow(vlength( objloc ),2))

//#declare objvec = objvec - vnormalize(objvec)*deltavec
//#declare objloc = objloc + objvec/divisor

// From Mike 2-Jun
//   objloc_new = objloc + (objvec * t) + 1/2 * pow((deltavec * t) ,2)
//
//#declare objloc = objloc + objvec/divisor + vnormalize(objvec)*( .5 * pow(deltavec/divisor,2) )
//#declare objvec = objloc - oldloc

// Next try is from grav1.pas
//                TempVec1[1] := Stars[Which, I, 1] - Stars[Which, J, 1];
//                TempVec1[2] := Stars[Which, I, 2] - Stars[Which, J, 2];
//                TempVec2[1] := TempVec1[1]/(Sqr(TempVec1[1]) + Sqr(TempVec1[2])) * Stars[Which,J,5];
//                TempVec2[2] := TempVec1[2]/(Sqr(TempVec1[1]) + Sqr(TempVec1[2])) * Stars[Which,J,5];
//                SumVec[1] := SumVec[1] + TempVec2[1];
//                SumVec[2] := SumVec[2] + TempVec2[2];
//                End
//            End;
//        Stars[Not Which, I, 3] := Stars[Which, I, 3] - SumVec[1]/stars[Which,I, 5];
//        Stars[Not Which, I, 4] := Stars[Which, I, 4] - SumVec[2]/stars[Which,I, 5];
//        Stars[Not Which, I, 1] := Stars[Which, I, 1] + Stars[Not Which, I, 3] * Speed;
//        Stars[Not Which, I, 2] := Stars[Which, I, 2] + Stars[Not Which, I, 4] * Speed;
// NOTES:
//tvec1 is objloc -0 (the black hole is at <0,0,0>)
//tvec2 is objloc/vlength(objloc)*BHM
// objvec = objvec - tvec2
// objloc = objloc + objvec/divisor

#declare objvec = objvec - (objloc/pow(vlength(objloc),2)*black_hole_mass)
#declare objloc = objloc + objvec/divisor

#declare j = j+1
#end // while(j<num_skips)

//#debug concat("deltavec is: <",str(deltavec,0,0),">\n")
#debug concat("Objloc is: <",str(objloc.x,0,0),",",str(objloc.y,0,0), "," ,str(objloc.z,0,0),">\n")
#debug concat("ObjVec is: <",str(objvec.x,0,0),",",str(objvec.y,0,0), "," ,str(objvec.z,0,0),">\n\n")

#declare i = i+1
#end
