// Persistence of Vision Ray Tracer Scene Description File
// File:
// Vers: 3
// Desc:
// Date: mm/dd/yy
// Auth:
//

#version 3

#include "colors.inc"
#include "metals.inc"

#declare TMAP = texture {
  pigment {
    image_map {
     gif "flymat.gif"
     map_type 2
     interpolate 2
    }
  }
  finish {
    ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
    crand 0.02
  } //finish
} //texture

#declare B_GLAS= texture {
   pigment { color rgbf<0.7, 0.8, 1.0, 1.0> }
   finish {
    ambient 0
    diffuse 0
    reflection 0.5
    refraction 1
    ior 1.5
    phong 0.3
    phong_size 60
   }
}


#declare WING=object {
 cone { <0,0,0>, 1, <0,1,0>, 0.5
        texture { TMAP }
        scale <0.5,1,0.1>
        matrix < 1, 1, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
    }
}

#declare FUSELAGE=object {
 cone { <0,0,0>, 0.2, <1,0,0>, 0.35
        texture { TMAP rotate <0,0,90> scale <0.5,0.7,0.7> }
        scale <2,1,1>
    }
}

#declare NOSE=object {
 cone { <0,0,0>, 0, <1,0,0>, 0.2
        texture { TMAP }
        scale <0.5,1,1>
    }
}

#declare GUN=object {
 union {
  object { FUSELAGE  translate <-1,0,0>}
  object { NOSE  translate <-1.5,0,0>}
  scale <0.7,0.2,0.2>
 }
}

#declare DUSE=object {
 cone { <0,0,0>, 0.35, <1,0,0>, 0.3
        texture { TMAP }
        scale <0.3,1,1>
      }
}

#declare TALE=object {
 union {
  object { WING  rotate <0,0,-45> }
  object { WING  rotate <0,0,-45> rotate <180,0,0>}
  scale <1,0.5,0.3>
  rotate <90,0,0>
  translate <0.5,0,0>
 }
}

#declare COCKPIT=object {
 sphere { 0, 1
   texture {B_GLAS}
   scale <0.5,0.1,0.3>
 }
}

#declare SPEED=16
#declare ARD=clock*SPEED*pi
#declare AGR=clock*SPEED*180

#declare FLAME=object {
cylinder { 0, <sin(ARD),1,cos(ARD)>, 1
 hollow
 texture
 {
  pigment { color rgbt <1,1,1,1>}
  halo { //halo 1
    emitting
    linear
    spherical_mapping
    color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <0.5, 1, 1, -0.5> ]
    }
    samples 10
  //  aa_level 2
   // aa_threshold 0.5
   // jitter 0.1
    turbulence <0.4,2,0.4>
    // phase 0.3*mod(clock*2000,100)/100 // 20x (0 till 0.2)
    // frequency 2
    scale <0.7, 0.8,  0.7>
    //[ rotate <VECTOR> ]
    //[ translate <VECTOR> ]
  }//halo
 }//texture
 rotate <0,-AGR,0>
}// cylinder
}

#declare FLAME1=object {
cylinder { 0, <0,1,0>, 1
 hollow
 texture
 {
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    linear
    cylindrical_mapping
    color_map {
        [ 0 color rgbt <1, 0, 1, 1> ]
        [ 1 color rgbt <0.5, 0.7+0.3*( mod(clock*100,10)/10 ), 1, -0.5> ]
    }
    samples 10
  }//halo
 }//texture
 scale <0.4,0.1,0.4>
}// cylinder
}

 #declare T  = clock
 #declare T1 = 0.1         // Beschl.-Zeit = Bremszeit
 #declare T2 = 0.75-T1*2   // Zwischenfahrts-Zeit
 #declare A  = 360/(T1*(T2+T1))  //Beschleunigung
 #declare VC = A*T1              //Zwischenfahrts-Geschw. (konstant)
 #declare S1 = A*T1*T1/2
 #declare S2 = S1+VC*T2

 #if (clock<=T1)
   #declare AC = A*T*T/2
 #else
   #if (clock<=T1+T2)
     #declare TC = T-T1
     #declare AC = S1+VC*TC
   #else
     #if (clock<=0.75)
      #declare TC = T-T2-T1
      #declare AC= -A*TC*TC/2+VC*TC +S2
     #else
      #declare AC=0
     #end
   #end
 #end

 #declare BC=AC


#declare FLYER = union {
  object { WING  rotate <0,0,-45> translate <0,0.2,0> }
  object { WING  rotate <0,0,-45> rotate <180,0,0> translate <0,-0.2,0> }
  object { FUSELAGE  translate <-1,0,0>}
  object { NOSE  translate <-1.5,0,0>}
  object { GUN  translate <0.5,-0.93,0>}
  object { GUN  translate <0.5,0.93,0>}
  object { DUSE translate <1,0,0> }
  object { TALE translate <0,0.93,0> }
  object { TALE translate <0,-0.93,0> }
  object { COCKPIT translate <-0.7,0,-0.12> }
  object { FLAME  scale <1,1.5,1> rotate <0,0,-90> translate <1.55,0,0> }
  object { FLAME1  rotate <0,0,-90> translate <1.3,0,0> }
  hollow
  rotate <5,10-AC,7+BC>
}
