
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 30
}


#declare star_sky=sky_sphere
{
  pigment
  {
     image_map
      {
       gif "star.gif" // the file to read (iff/gif/tga/png/sys)
       map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
       interpolate 0 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

       //once
     } // image_map
    scale 1.3
  }
}


// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

//********************************* PLANET ********************************
#declare PLANET = union {
 //sphere { 0.0, 1    texture {pigment {color rgb <0.7,0.5,0.0>} finish{specular 1 ambient 1}} }
 sphere { 0.0, 1
   texture{
    pigment {

     image_map
      {
       gif "map7.gif" // the file to read (iff/gif/tga/png/sys)
       map_type 1 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
       interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

       //once
     } // image_map
      rotate <0,-90,0>
    }
    finish{ diffuse 0 specular 0 ambient 1 }
   }
 }
 //sphere { 0.0, 1.2  texture {pigment {color rgbf <0.7,0.7,1,0.9>} } }
 sphere { 0,
    //1.1 //A
    1.0 //B
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      cubic
      // turbulence 0.05 //A
      turbulence 1.2 //B
      color_map {
        [ 0 color rgbt   <0, 0, 1,  1> ]
        [ 0.3 color rgbt <1, 1, 1, -1> ]
        [ 0.6 color rgbt   <0, 0, 1,  0> ]
        [ 1 color rgbt   <1, 1, 1,  1> ]
      }
      // frequency 80 //A
      frequency 3 //B
      samples 7
      rotate <7,15,90>
    }
    hollow
    scale 1.1
  }

 sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt   <0, 0, 1,  1> ]
        [ 1 color rgbt   <0, 0, 1, -1> ]
      }
      samples 5
    }
    hollow
    scale 1.3
  }

 scale 3
 translate <2,-2,0>
} //planet-union 

//******************************** TOKAMAK **********************************

union {
 #declare plasma= torus
  {
    0.8,
    0.005
    texture {
      pigment { color rgb <1,0,1>}
      finish{ diffuse 0 specular 0 ambient 1 }
    }
   }
   
 //object { plasma }

 #declare plasm_i=cylinder { <0,-0.5,0>, <0,0.5,0>, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 0.05
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
    }
    hollow
    no_shadow
    scale <0.02,0.1,0.02>
    rotate x*90
  }

#declare i=0
#while (i<72)
  object {
   plasm_i
   rotate <0,-i*5,0>
   translate<0.8*cos(i*2*3.1415/72),0,0.8*sin(i*2*3.1415/72)>
  }
  
  light_source {
    <0.8*cos(i*2*3.1415/72),0,0.8*sin(i*2*3.1415/72)>
    color rgb <1,1,0>
    shadowless
    fade_distance 0.01
    fade_power 3
  }
 #declare i=i+1
#end



 #declare o_magnet=torus  //quarter
  {
    0.82,
    0.003
    texture {
      pigment { color rgb <0.4,0.5,0.7>}
      finish{ specular 1  phong 0.9
           phong_size 60
           metallic
      }
    }
 }

 #declare i_magnet=torus  //quarter
  {
    0.78,
    0.003
    texture {
      pigment { color rgb <0.4,0.5,0.7>}
      finish{ specular 1  phong 0.9
           phong_size 60
           metallic
      }
    }

 }

object { o_magnet translate y*0.02 }
object { o_magnet translate -y*0.02 }
object { i_magnet translate y*0.02 }
object { i_magnet translate -y*0.02 }


#declare magn1=torus {
 1.5,
 0.1
 texture {
   pigment { color rgb <0.5,0.5,0.5>}
   finish{ specular 1  phong 0.9
           phong_size 60
           metallic
   }
 }
 rotate z*90
 scale 0.02
}

#declare magn3=torus {  //big magnets
 1.9,
 0.3
 texture {
   pigment { color rgb <0.7,0.6,0.5>}
   finish{ specular 1  phong 0.9
           phong_size 60
           metallic
   }
 }
 rotate z*90
 scale 0.02
}
#declare magn2=union {  //big magnets
 box {  <-2.2,-0.3,-2.2>, < 2.2,0.3,-1.6> }
 box {  < 2.2,-0.3,-2.2>, < 1.6,0.3, 2.2> }
 box {  < 2.2,-0.3, 2.2>, <-2.2,0.3, 1.6> }
 box {  <-2.2,-0.3, 2.2>, <-1.6,0.3,-2.2> }
 
 texture {
   pigment { color rgb <0.7,0.6,0.5>}
   finish{ specular 1  phong 0.9
           phong_size 60
           metallic
   }
 }
 rotate z*90
 scale 0.02
}

#declare i=0;
#while (i<72)
 #if (mod(i,18)-3=0)
  object {
   magn2
   rotate <0,-i*5+90,0>
   translate<0.8*cos(i*2*3.1415/72),0,0.8*sin(i*2*3.1415/72)>
  }
 #else
  object {
   magn1
   rotate <0,-i*5+90,0>
   translate<0.8*cos(i*2*3.1415/72),0,0.8*sin(i*2*3.1415/72)>
  }
 #end 
 #declare i=i+1
#end

  scale <0.3,0.3,0.33>
  translate <0.15,0.48,-3.7>

} //union

sky_sphere { star_sky }

object { PLANET }

#include "flyer.pov"
object { //small
 FLYER
 scale 0.001
 rotate -40*x
 rotate 110*y
 rotate -40*x
 rotate -90*y
 translate <-0.01, 0.482,-3.93>
}

object { //large
 FLYER
 scale 0.01
 rotate -50*x
 rotate -20*y
 rotate 150*z
 rotate -50*y
 translate <-0.05,0.51,-3.8>
}
