
// Text is always formed in XY plane, extending into +Z
// Here, it is set up for RH system: in XZ plane, extending into -Y (!)

//===============================================
//             Transformations
//===============================================


#declare ShearXZ05 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis
             0, 1, 0,
            .5, 0, 1,
             0, 0, 0 >
	}

//===============================================
//             Textures
//===============================================

#declare BrightWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 1.8 }
	}

#declare DarkBlueTex =
	texture {
		pigment { color rgb<0,0,.1> }
		finish { ambient .1 }
	}

#declare BrightOrangeTex =
	texture {
		pigment { color rgb<1.3,.8,.2> }
		finish { ambient 1 }
	}
#declare BrightRedTex =
	texture {
		pigment { color rgb<.7,.01,.01> }
		finish { ambient .8 }
	}
#declare BrightRedGradTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0  color rgb<0.2,0.01,0.01> ] // dark red
				[ 1.0  color rgb<0.7,0.1,0.01> ] // bright red
			}
		}
		finish { ambient .8 }
	}

//===============================================
//             Objects
//===============================================

#declare RRRR =
	union {
    text {
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "RRRRRRRRRRR!",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,0,0>
      translate <0,0,0>
    }
	}

#declare CRAK =
	union {
    text {
      ttf "c:\Windows\Fonts\TT0295M_.TTF",
      "C",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,-12,0>
      translate <.1,0,.10>
    }
    text {
      ttf "c:\Windows\Fonts\TT0295M_.TTF",
      "R",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,0,0>
      translate <0.8,0,.25>
    }
    text {
      ttf "c:\Windows\Fonts\TT0295M_.TTF",
      "A",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,-5,0>
      translate <1.6,0,.30>
    }
    text {
      ttf "c:\Windows\Fonts\TT0295M_.TTF",
      "K",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,10,0>
      translate <2.3,0,.09>
    }
    text {
      ttf "c:\Windows\Fonts\TT0295M_.TTF",
      "!",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1.3,1>
      rotate <90,0,0>
      translate <3.3,0,.27>
    }
		polygon {
			19,
			<-.6,.2>,<-.4,2.3>,<1.5,3.5>,<2,2.4>,
			<3,3.8>,<4,2.7>,<4.8,3.7>,<6.1,2.5>,
			<7,3.6>,<8,1.7>,<8.4,0>,
			<7,-1.6>,<6,-.4>,<5.4,-2.2>,<3.8,-0.6>,
			<3.1,-1.8>,<2,-.6>,<.8,-1.7>,<-.6,.2>
			rotate <90,0,0>
			scale <.5,1,.5> // length, height
			texture { BrightRedGradTex scale <1,1,3> translate <0,0,-1.0> }
		}
	}

#declare VROOM =
    text {
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "VRROOOM!",
      .001,  0
      texture { BrightOrangeTex }
      scale <1,1,1>
      rotate <90,0,0>
      translate <0,0,0>
    }

#declare BalloonDisc =
	disc {
		<0,0,0>,y,1
	}
#declare BalloonText1 =
    text {
      ttf "c:\Windows\Fonts\COMIC.TTF",
      "GOTTA",
      .05,  0
      texture { pigment { color rgb<0,0,0> } }
      scale <4,4,4>
      rotate <90,0,0>
      translate <0,0,0>
    }
#declare BalloonText2 =
    text {
      ttf "c:\Windows\Fonts\COMIC.TTF",
      "STOP HIM!",
      .05,  0
      texture { pigment { color rgb<0,0,0> } }
      scale <3.4,4,4>
      rotate <90,0,0>
      translate <0,0,0>
    }

#declare BalloonShape =
	union {
		object { BalloonDisc scale .7 translate <0,0,0> } // root
		object { BalloonDisc scale 1.2 translate <1.5,0,2.5> }
		object { BalloonDisc scale 1.3 translate <3,0,5> }
		object { BalloonDisc scale 1.4 translate <2.3,0,6.7> }
		object { BalloonDisc scale <12,1,7> translate <10,0,12> }// main balloon
		object { BalloonDisc scale <5,1,5> translate <17,0,15> }// upper rh corner
		object { BalloonDisc scale <5,1,5> translate <20,0,13> }// upper rh corner
		object { BalloonDisc scale <5,1,5> translate <16,0,12> }// upper rh corner
		object { BalloonDisc scale 1.5 translate <5.3,0,6> } // bottom
		object { BalloonDisc scale 1.6 translate <8,0,5> }
		object { BalloonDisc scale 1.5 translate <11,0,5> }
		object { BalloonDisc scale 1.7 translate <14,0,5.5> }
		object { BalloonDisc scale 1.4 translate <17,0,5.7> }
		object { BalloonDisc scale 1.5 translate <19.5,0,7> }
		object { BalloonDisc scale 1.5 translate <20,0,8> }
		object { BalloonDisc scale 1.5 translate <20.3,0,9.5> }
		object { BalloonDisc scale 1.6 translate <-.5,0,8> } // left side
		object { BalloonDisc scale 1.5 translate <-2,0,10> }
		object { BalloonDisc scale 1.5 translate <-2,0,13> }
		object { BalloonDisc scale 1.7 translate <-.5,0,15.5> }
		object { BalloonDisc scale 1.7 translate <.5,0,16.5> }
		object { BalloonDisc scale 1.7 translate <1.5,0,17> }
	}
#declare Balloon =
	union {
		object { BalloonText1 translate <1,0,12> }
		object { BalloonText2 translate <-.5,0,8> }
		object { BalloonShape texture { BrightWhiteTex } }
		object { BalloonShape texture { DarkBlueTex } translate <0,0.1,0> }
	}

#declare AllText =
	union {
//		object { RRRR scale 10 rotate <0,-30,-90> translate <-80,80,60> }
		object { CRAK scale 10 rotate <0,30,-140> translate <-110,-68,80> }
		object { VROOM scale <8,8,4> transform ShearXZ05 rotate <0,0,-160> rotate <0,8,0> translate <-80,120,2> }
//		object { Balloon scale .7 rotate <0,-7,-110> translate <-110,-290,58> }
		no_shadow
	}
