
#include "BlobHead.inc"
#include "BlobHand.inc"
#include "Accessories.inc"

// Glenn's BlobMan POV-Ray Scene File
// first concept 30-May-97 last update 24-Jun-97
// copyright Glenn McCarter 1997
// This file does not render.  #include "BlobMan.inc" in another .pov file
//
// A head, torso, and arms
// "BlobMan" and "Cop"
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//================================================================
//      Remove this section -- only used for test renders!
//================================================================

/*
#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
  location  <-52, -48, 8> // 3/4 overall view
  look_at   <0.000, 0.000, -8.000>
  location  <-18, -55, 8> // render view
  look_at   <-8, 0, -4>
	angle 40
}
camera { Render_Cam }
//object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb60Watt translate <40,-80,70> }
object {StdBulb100Watt translate <-100,-40,80> }
*/

//===============================================
//             Variable Declarations
//===============================================

// Pose Angles ( in order )

#declare HPan     = 32 // head, positive = towards his left
#declare HTiltFwd = 15
#declare HCock    = 0
/*
 // INSET
//#declare RWCock  = 0 // wrist side-to-side (golf)
//#declare RWAng   = 0 // wrist angle
#declare RETwist = 20 // twists the hand, positive = palms up
#declare REAng   = 70 // elbow
#declare RAFwd   = 43 // total arm
#declare RARot   = 12 // claps hands
#declare RAOut   = 12 // opens underarm
#declare RAFwd2   = 0 // total arm
#declare RARot2   = 0 // claps hands

#declare LWCock  = 20 // wrist side-to-side (golf)
#declare LWAng   = 0 // wrist angle
#declare LETwist = 140 // twists the hand, positive = palms up
#declare LEAng   = 36 // elbow
#declare LAFwd   = 12 // total arm
#declare LARot   = -30 // claps hands
#declare LAOut   = 70 // opens underarm
#declare LAFwd2   = 0 // total arm
#declare LARot2   = -20 // claps hands
*/
// RENDER
//#declare RWCock  = 0 // wrist side-to-side (golf)
//#declare RWAng   = 0 // wrist angle
#declare RETwist = 20 // twists the hand, positive = palms up
#declare REAng   = 70 // elbow
#declare RAFwd   = 43 // total arm
#declare RARot   = 12 // claps hands
#declare RAOut   = 12 // opens underarm
#declare RAFwd2   = 0 // total arm
#declare RARot2   = 0 // claps hands

#declare LWCock  = 20 // wrist side-to-side (golf)
#declare LWAng   = 0 // wrist angle
#declare LETwist = 140 // twists the hand, positive = palms up
#declare LEAng   = 36 // elbow
#declare LAFwd   = 12 // total arm
#declare LARot   = 12 // claps hands
#declare LAOut   = 70 // opens underarm
#declare LAFwd2   = 0 // total arm
#declare LARot2   = -20 // claps hands

// RightHand Pose Angles ( in order )


//===============================================
//             Textures
//===============================================

#declare SuitTex = // Police Blue
	texture {
		pigment {color rgb<.15,.15,.6> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}

//===============================================
//       Objects
//===============================================


#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { SuitTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-14>,9
			scale <.4,1,1>
			texture { SuitTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
			texture { SuitTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
//	object { LeftHand
	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				texture { SuitTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				texture { SuitTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				texture { SuitTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { SuitTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { SuitTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { SuitTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { SuitTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				texture { SuitTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				texture { SuitTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { SuitTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { SuitTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { SuitTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { SuitTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare BlobMan = //center at base of neck
	union {
		object { MaleHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}
	}

#declare Cop = //center at base of neck
	union {
		union  {
			object { PoliceHat rotate <0,12,0> translate <0,0,7> } // set it on the head
			object { MaleHead }
			object { SunGlasses translate <-4,0,6.7> }
				rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0>
		}
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}
		object { PoliceBadge scale 1.1 translate <-3.6,-5,-1.5> } // on breast
	}

//object { BlobMan }
//object { Cop }

//sphere {<0,0,-3>,3 pigment { White } }
