
// Glenn's Railroad Sign POV-Ray Object File
// This file does not render.  #include "RRSign.inc" in another .pov file
// first concept 21-May-97  last update 22-June-97
// copyright 1997 Glenn McCarter

// a "Railroad Crossing" sign, with flying bullet splinters
// Intended scale is English system (inches)
// Sign stands on XY plane, origin at ground level, extending upwards into +Z
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#declare WhitePaint =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .2 specular .7 roughness .005 }
	}
#declare DirtyWhitePaint =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0  color rgb<0.2,0.2,0.2> ]
				[ 0.5  color rgb<0.4,0.4,0.4> ]
				[ 0.6  color rgb<1.0,1.0,1.0> ]
				[ 1.0  color rgb<1.0,1.0,1.0> ]
			}
//			turbulence <1,1,1>
			scale <1,1,.2>
		}
		finish { ambient .5 specular .7 roughness .005 }
	}

#declare UndersideTex = // dirty underside of signboards
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.0  color rgb<0.7,0.7,0.7> ]
				[ 0.5  color rgb<0.3,0.3,0.3> ]
				[ 1.0  color rgb<0.7,0.7,0.7> ]
			}
//			turbulence <1,1,1>
			scale <1,1,1>
		}
		finish { ambient .5 specular .7 roughness .005 }
	}

#declare WoodTex =
	texture {
		pigment { color rgb <.44,.38,.15> }
		normal { bumps .4 scale <2,4,2> }
		finish { ambient .01 }
	}

#declare BlackPaint =
	texture {
		pigment { color rgb<.05,.05,.05> }
		finish { ambient .02 specular .7 roughness .005 }
	}


//===============================================
//             Objects
//===============================================

#declare SplintPyr = intersection { // raw pyramid shape for wood splinter
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40> texture { WhitePaint } }
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40> texture { WhitePaint } }
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0> texture { WoodTex } }
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0> texture { WoodTex } }
   plane { <0, -1, 0>, 0  texture { WhitePaint } }
   translate <0 ,-1, 0>
}

#declare Splinter =
	union {
	object { SplintPyr rotate x*90 translate <0,0,1> scale <.1,.1,2> }
	object { SplintPyr rotate x*-90 translate <0,0,-1> scale <.1,.1,1> }
	bounded_by { box { <-2,-2,-2>,<2,2,2> } }
	}

#declare RSeed = seed(1234)
#declare Splinters =
	union {
		#declare CountS = 0 // Upper Splinters
		#while ( CountS < 20 )
			object { Splinter
				scale <1,1,rand(RSeed)*1>
				rotate <rand(RSeed)*20,rand(RSeed)*20,rand(RSeed)*-140+70>
				translate <rand(RSeed)*1.4,rand(RSeed)*4,rand(RSeed)*3>
			}
			#declare CountS = CountS +1
		#end
		#declare CountS = 0 // Lower Splinters
		#while ( CountS < 20 )
			object { Splinter
				scale <1,1,rand(RSeed)*1>
				rotate <190+rand(RSeed)*-20,rand(RSeed)*-40,rand(RSeed)*-140+70>
				translate <rand(RSeed)*1.4,rand(RSeed)*4,-rand(RSeed)*5>
			}
			#declare CountS = CountS +1
		#end
		#declare CountS = 0 // Exploding Splinters
		#while ( CountS < 20 )
			object { Splinter
				scale <1,1,rand(RSeed)*1>
				rotate <rand(RSeed)*360,rand(RSeed)*360,rand(RSeed)*360>
				translate <rand(RSeed)*6,rand(RSeed)*8,-3+rand(RSeed)*4>
			}
			#declare CountS = CountS +1
		#end
	}

#declare BH = 25 // bullet hole height
#declare RRSign =
	union {
		object { Splinters translate <-4,0,BH> }
		difference {
			superellipsoid { // the post
				<.2,.2>
				scale <2,2,50>
				translate <0,0,30>
				texture {
					pigment {
						gradient z
						color_map {
							[ 0.0  color rgb<0.3,0.4,0.3> ]
							[ 0.2  color rgb<1.0,1.0,1.0> ]
							[ 0.8  color rgb<1.0,1.0,1.0> ]
							[ 1.0  color rgb<0.3,0.4,0.3> ]
						}
						turbulence <1,1,.05>
//							scale <1,1,.2>
							scale <1,1,64> translate z*-60
					}
					normal {
						wood 0.3
						turbulence 0.03
						rotate <7,2,0>
						scale .4
					}
					finish { ambient .2 specular .7 roughness .005 }
				}
			}
			cylinder { // bullet hole
				<0,-3,0>,<0,3,0>,1.4
				texture {
					pigment { color rgb <.44,.38,.15> }
					normal { bumps .4 scale <2,4,2> }
					finish { ambient .01 }
				}
				rotate z*8
				translate <-2,0,BH>
			}
			intersection {
				height_field { // upper cracks
					gif "BulletHF1.gif"
					rotate x*90 // set up for RH coordinate system
					translate <-.5,.5,0> //center on origin
					rotate z*98
					scale <4,10,8> // scale it up
					translate <-2,0,BH>
					texture { WoodTex }
				}
				height_field { // upper cracks
					gif "BulletHF1.gif"
					rotate x*90 // set up for RH coordinate system
					translate <-.5,.5,0> //center on origin
					rotate <180,0,98>
					scale <4,10,8> // scale it up
					translate <-2,0,BH+.4>
					texture { WoodTex }
				}
			} // end of height field intersection
		} // end of bullet hole difference
		union { // "railroad" sign
			box { // wood plate
				<-20,0,0>,<20,.6,5>
				texture { WhitePaint }
			}
			box { // underside
				<0,0,-.05>,<1,.6,0.05>
				texture { UndersideTex }
				scale <40,1,1>
				translate <-20,0,0>
			}
			text {
				ttf "c:\Windows\Fonts\ARIAL.TTF",
				"RAIL          ROAD",
				.2,     // THICKNESS_FLOAT
				0       //OFFSET_VECTOR
				texture { BlackPaint }
				scale <4.5,4,1>
				rotate <90,0,180>
				translate <16,.45,1>
			}
			rotate y*20
			translate <0,2,70>
		}
		union { // "crossing" sign
			box { // wood plate
				<-20,0,0>,<20,.6,5>
				texture { WhitePaint }
			}
			box { // underside
				<0,0,-.05>,<1,.6,0.05>
				texture { UndersideTex }
				scale <40,1,1>
				translate <-20,0,0>
			}
			text {
				ttf "c:\Windows\Fonts\ARIAL.TTF",
				"CROSSING",
				.2,     // THICKNESS_FLOAT
				0       //OFFSET_VECTOR
				texture { BlackPaint }
				scale <6,4,1>
				rotate <90,0,180>
				translate <16,.45,1>
			}
			rotate y*-20
			translate <0,2.6,70>
		}
	}
