
// Glenn's Tires POV-Ray Scene File
// first concept 7-Jul-96 last update 29-May-97
// copyright Glenn McCarter 1997
// This file does not render.  #include "Tires.inc" in another .pov file
//
// Several good tire objects are here:
//
// Tire: standard car tire
// RearSlickTire: wide
// FrontSlickTire: less wide
// RearHexTreadTire - temporarily removed
// FrontHexTreadTire - temporarily removed
//
// Tires are spun around Y-axis, front face at Y=0
// extending into +Y

#declare TreadDepth = .2
#declare ZTread = 2.8 // horizontal distance between tread blocks
#declare ZOffset = 1.4 // horizontal offset between every other row
#declare RearTreadOffset = 2.1 // tread starts this far from edge of tire
#declare FrontTreadOffset = 0.9 // tread starts this far from edge of tire
#declare TreadRadius = 13.2 // from center of axle to bottom of tread
#declare RotAngle = 0 // initial angle to start around the tire
#declare RotAngleIncrement = 8

//===============================================
//             Textures
//===============================================

#declare TireTexture =
      texture {
        pigment { color rgb<.2,.2,.2> }
        normal { bumps .1 scale .03}
        finish { phong .3 phong_size 12 }
      }

#declare TreadTexture =
      texture {
        pigment { color rgb<.3,.3,.3> }
        normal { bumps .1 scale .03}
//        finish {Metal}
        finish { phong .3 phong_size 12 }
      }

//===============================================
//             Treads
//===============================================

/*
#declare HexTreadBlock =
  union {
    box { <-.7,-.4,-.4>,<.7,TreadDepth,.4> texture { TreadTexture }}
    box { <-.7,-.4,-.4>,<.7,TreadDepth,.4> rotate y*120 texture { TreadTexture }}
    box { <-.7,-.4,-.4>,<.7,TreadDepth,.4> rotate y*240 texture { TreadTexture }}
  }
#declare ExoticHexBlock =
   difference {
     object { HexTreadBlock }
     sphere {<0,TreadDepth+.1,0>,.3 texture { pigment {color rgb<.5,.5,.61> }}}
   }

#declare TreadBlock = ExoticHexBlock

#declare Row5R =
  union {
    object { TreadBlock rotate x*-3 translate <0,.13,ZTread*1> }
    object { TreadBlock rotate x*-1 translate <0,.24,ZTread*2> }
    object { TreadBlock rotate x*1 translate <0,.24,ZTread*3> }
    object { TreadBlock rotate x*3 translate <0,.13,ZTread*4> }
    object { TreadBlock rotate x*5 translate <0,-.07,ZTread*5> }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,0>,<2,2,3>} }}
      rotate x*-6
      translate <0,-.1,0>
    }
  }

#declare Row5L =
  union {
    object { TreadBlock rotate x*-5 translate <0,-.07,ZTread*0> }
    object { TreadBlock rotate x*-3 translate <0,.13,ZTread*1> }
    object { TreadBlock rotate x*-1 translate <0,.24,ZTread*2> }
    object { TreadBlock rotate x*1 translate <0,.24,ZTread*3> }
    object { TreadBlock rotate x*4 translate <0,.13,ZTread*4> }
    object { TreadBlock
      clipped_by {object {box {<-1,-1,0>,<1,1,2>} }}
      rotate y*180
      rotate x*6
      translate <0,-.1,ZTread*5>
    }
  }
#declare Row4 =
  union {
    object { TreadBlock translate <0,0,ZTread*0> }
    object { TreadBlock translate <0,.18,ZTread*1> }
    object { TreadBlock translate <0,.24,ZTread*2> }
    object { TreadBlock translate <0,.18,ZTread*3> }
  }
#declare Row3LR =
  union {
    object { TreadBlock translate <0,.14,ZTread*1> }
    object { TreadBlock translate <0,.24,ZTread*2> }
    object { TreadBlock translate <0,.14,ZTread*3> }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,0>,<2,2,3>} }}
      translate <0,-.1,0>
    }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,-3>,<2,2,0>} }}
      translate <0,-.1,ZTread*4>
    }
  }
#declare Row3R =
  union {
    object { TreadBlock rotate x*-3 translate <0,.14,ZTread*1> }
    object { TreadBlock rotate x*1 translate <0,.24,ZTread*2> }
    object { TreadBlock rotate x*4 translate <0,.14,ZTread*3> }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,0>,<2,2,3>} }}
      rotate x*-6
      translate <0,0,0>
    }
  }
#declare Row3L =
  union {
    object { TreadBlock rotate x*-4 translate <0,.14,ZTread*0> }
    object { TreadBlock rotate x*-1 translate <0,.24,ZTread*1> }
    object { TreadBlock rotate x*2 translate <0,.14,ZTread*2> }
    object { TreadBlock
      clipped_by {object {box {<-1,-1,0>,<1,1,2>} }}
      rotate y*180
      rotate x*5
      translate <0,0,ZTread*3>
    }
  }
#declare Row3 =
  union {
    object { TreadBlock rotate x*-6 translate <0,.10,ZTread*0> }
    object { TreadBlock translate <0,.24,ZTread*1> }
    object { TreadBlock rotate x*6 translate <0,.10,ZTread*2> }
  }

#declare Row2 =
  union {
    object { TreadBlock rotate x*-3 translate <0,.14,ZTread*0> }
    object { TreadBlock rotate x*3 translate <0,.24,ZTread*1> }
  }
#declare Row2LR =
  union {
    object { TreadBlock rotate x*-3 translate <0,.14,ZTread*1> }
    object { TreadBlock rotate x*3 translate <0,.14,ZTread*2> }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,0>,<2,2,3>} }}
      rotate x*8
      translate <0,-.07,0>
    }
    object { TreadBlock
      clipped_by {object {box {<-2,-2,-3>,<2,2,0>} }}
      rotate x*-8
      translate <0,-.07,ZTread*3>
    }
  }

#declare WideTread =
  union {
    #while ( RotAngle < 360 )
      object { Row5R translate <0,TreadRadius,0> rotate <0,0,RotAngle> }
      object { Row5L translate <0,TreadRadius,ZOffset> rotate <0,0,RotAngle+RotAngleIncrement/2> }
      #declare RotAngle = RotAngle + RotAngleIncrement
    #end
  }

#declare RotAngle = 0 // reset after previous block
#declare NarrowTread =
  union {
    #while ( RotAngle < 360 )
      object { Row3R translate <0,TreadRadius,0> rotate <0,0,RotAngle> }
      object { Row3L translate <0,TreadRadius,ZOffset> rotate <0,0,RotAngle+RotAngleIncrement/2> }
      #declare RotAngle = RotAngle + RotAngleIncrement
    #end
  }
*/

//===============================================
//             Tire Shapes
//===============================================

#declare StdTire = // width 10
	lathe {
		cubic_spline // n-3 segments
		19,
		<8.5, 5>
		<9, 1>, <9.2,.5>, <10,0.1>,
		<11,0>,
		<12,0.1>, <12.8,.5>, <13, 1>,
		<13.5,5>,
		<13, 9>, <12.8, 9.5>, <12, 9.9>,
		<11, 10>,
		<10, 9.9>, <9.2, 9.5>, <9, 9>,
		<8.5, 5>, <9, 1>, <9.2,.5>
		texture { TireTexture }
	}

#declare WideTire = // width 20
	lathe {
		cubic_spline // n-3 segments
		19,
		<8.5, 10>
		<9, 2>, <9.2,1>, <10,0.2>,
		<11,0>,
		<12,0.2>, <12.8,1>, <13, 2>,
		<13.5,10>,
		<13, 18>, <12.8, 19>, <12, 19.8>,
		<11, 20>,
		<10, 19.8>, <9.2, 19>, <9, 18>,
		<8.5, 10>, <9, 2>, <9.2,1>
		texture { TireTexture }
	}

//===============================================
//             Tire Assy Definitions
//===============================================

#declare Tire =
  object { StdTire }

#declare RearSlickTire =
  object { WideTire }

#declare FrontSlickTire =
  object { WideTire scale <1,.6,1> }  // makes it narrower

#declare RearHexTreadTire =
  union {
    object { WideTire }
//    object { WideTread translate <0,0,RearTreadOffset> rotate x*-90 }
  }
#declare FrontHexTreadTire =
  union {
    object { WideTire scale <1,.6,1> }  // makes it narrower
//    object { NarrowTread translate <0,0,FrontTreadOffset> rotate x*-90 }
  }
