
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "surfaces.inc"

#declare Mage = on
#declare Satan = on
#declare Scenery = on
#declare Surface = on
#declare Final_lights = on
#declare Summoning = on
#declare Volume = on
#declare Impact = on

camera {
	location <0,2,-5>
	look_at  <0,1.5,0>
}

#if (Final_lights = on)

light_source {<1.4,12,-1> color White
	cylinder
	point_at <1.4,0,-1>
	radius 10
	falloff 15
	tightness 10
}

#else

light_source {<0,3,-5> color White}

#end

plane {y,0

#if (Scenery = on)

texture {Floor_stone}
normal {crackle 2 scale .5 turbulence .2}
finish {crand 0.2}

#else

pigment{White}

#end

}

#if (Satan = on)

#include "demon.pov"

object {Demon
rotate <-90,90,0>
scale 5
translate <1.4,0,-1>

#if (Surface = on)

texture{Lava_skin scale .25}
finish {phong 1 reflection .2 metallic}

#else

pigment{White}

#end

}

#end

#if (Mage = on)

#include "magician.pov"

object {Magician
rotate <-90,90,0>
scale 5
translate <1.4,0,-1>
pigment{White}
}

#end

#if (Scenery = on)

#include "13column.inc"

object {Column translate <0,0,2.5>}
object {Column rotate <0,45,0> translate <1.75,0,2>}
object {Column rotate <0,90,0> translate <-1.75,0,2>}
object {Column rotate <0,135,0> translate <3.5,0,1.5>}
object {Column rotate <0,180,0> translate <-3.5,0,1.5>}

#end

#if (Summoning = on)

#declare Pillar_of_fire =
cylinder {<0,-1,0><0,6,0>,.5
pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <1, 1, 0, -1> ]
        [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 1.5
      samples 20
      scale 0.5
    }
    hollow
    scale <1,2,1>
	translate <0,1,0>
}

object {Pillar_of_fire translate <1.4,0,-1>}

#end

#include "Pentangle.pov"

object {Pentangle
pigment{color <1.00,0.86,0.44>}
finish {phong 1 reflection .5 metallic}
translate <1.4,0,-1>}

#if (Volume = on)

#include "book.pov"

object {Spell_book scale .5 rotate <-45,-45,0> translate <-1.45,0.95,-1.9>}

#end

#if (Impact = on)

#declare camera_location = <0, 2, -5>
#declare camera_look_at = <0, 1.5, 0>
#declare flare_count = 6

#declare flare_position = <-0.25, 2.05, -1>
#declare flare_type = 2
#declare flare_size = 0.5
#declare flare_spots = false
#declare flare_brightness = .8
#include "Lensflar.inc"

#declare flare_position = <0, 1.9, -1>
#declare flare_type = 7
#declare flare_size = 0.25
#declare flare_brightness = .7
#include "Lensflar.inc"

#declare flare_position = <-0.05, 1.7, -1>
#declare flare_type = 9
#declare flare_size = 0.5
#declare flare_brightness = .7
#include "Lensflar.inc"

#declare flare_position = <0.2, 1.6, -1>
#declare flare_type = 7
#declare flare_size = 0.15
#declare flare_brightness = .5
#include "Lensflar.inc"

#declare flare_position = <0.1, 1.72, -1>
#declare flare_type = 9
#declare flare_size = 0.25
#declare flare_brightness = .5
#include "Lensflar.inc"

#declare flare_position = <0.3, 1.5, -1>
#declare flare_type = 9
#declare flare_size = 0.25
#declare flare_brightness = .5
#include "Lensflar.inc"

#end
