
// Glenn's Magic POV-Ray Scene File
// "A Rabbit's Eye View Of The Magic Act"
// created 1-Jul-97 for the Internet Ray Tracing Competition
// at http://www.irtc.org
// last update 23-Aug-97
// copyright 1997 Glenn McCarter

// NOTE: these files have many embedded tabs.
// To best viewing, use the POV-Ray for Windows editor,
// and set Editor | Tabs | Real Tabs, with tab size 2.
// Also, this file uses the RH reference system (Z=up).

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"
#include "golds.inc"
#include "stones.inc"
#include "GIncludeRH.inc"
#include "BlobHead.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare HatTex =
	texture {
//		pigment { color rgb<.07,.04,.10> }
		pigment { color rgb<.01,.00,.03> }
		normal { bumps 0.04 scale .02 }
		finish { ambient .05 specular .1 roughness .03 }
	}
#declare GlossyBlack =
	texture {
		pigment { color rgb<.05,.01,.1> }
		normal { bumps 0.2 scale .2 }
		finish { ambient .05 specular .9 roughness .01 }
	}
#declare DarkishGray =
	texture {
		pigment { color rgb<.05,.01,.1> }
		normal { bumps 0.2 scale .2 }
		finish { ambient .05 specular .9 roughness .01 }
	}
#declare SatinRed =
	texture {
		pigment { color rgb<.8,.1,.01> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .01 specular .7 roughness .012 }
	}
#declare SatinRed2 = // for hat lining
	texture {
		pigment { color rgb<.8,.1,.01> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .01 specular .4 roughness .004 }
	}
#declare RedThread =
	texture {
		pigment { color rgb<.46,.1,.01> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .01 specular .3 roughness .06 }
	}
#declare LabelTex =
	texture {
//		pigment { color rgb<.91,.63,.44> }
		pigment { color rgb<.91,.83,.74> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .01 specular .97 roughness .01 }
	}

#declare GlitterTex =
	texture {
		pigment { color rgb<1,1,.3> }
		finish { ambient .01 specular .97 roughness .2 reflection 0.8 }
	}
#declare YellowTex =
	texture {
		pigment { color rgb<1,1,0> }
		finish { ambient .2 specular 1 roughness .005 }
	}
#declare RedTex =
	texture {
		pigment { color rgb<1,0,0> }
		finish { ambient .2 specular 1 roughness .005 }
	}
#declare GreenTex =
	texture {
		pigment { color rgb<0,1,0> }
		finish { ambient .2 specular 1 roughness .005 }
	}
#declare BlueTex =
	texture {
		pigment { color rgb<0,0,1> }
		finish { ambient .2 specular 1 roughness .005 }
	}
#declare WhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .2 specular 1 roughness .005 }
	}
#declare TrussPaint =
	texture {
//		pigment { color rgb<.63,.52,.25> }
		pigment { color rgb<.08,.06,.02> }
		finish { ambient 0.02 specular .4 roughness .22 }
	}
#declare RoofPaint =
	texture {
		pigment { color rgb<.02,.01,.04> }
		finish { ambient 0.02 specular .2 roughness .1 }
	}

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
	perspective
	direction <0.0,     1.0,  0.0>
	sky       <0.0,     0.0,  1.0>  // Use right handed-system!
	up        <0.0,     0.0,  1.0>  // Where Z is up
	right     <1.33333, 0.0,  0.0>
/*	// Focal Blur section: uncomment to enable focal blur
	blur_samples 6
	aperture .05    //lower value = wider range in focus
	focal_point <0,0,0>
	confidence .995
	variance 1/128
*/	// end focal blur
	location <-2, -.1, 1> // render view
	look_at <1, 0, 10> // render view
	angle 75
}

#declare Special_Cam =
	camera {
	perspective
	direction <0.0,     1.0,  0.0>
	sky       <0.0,     0.1,  1.0>  // Use right handed-system!
	up        <0.0,     0.0,  1.0>  // Where Z is up
	right     <1.33333, 0.0,  0.0>
/*	// Focal Blur section: uncomment to enable focal blur
	blur_samples 6
	aperture .05    //lower value = wider range in focus
	focal_point <0,0,0>
	confidence .995
	variance 1/128
*/	// end focal blur
//	location <-30, -16.1, 2.4*Feet> // scene view
//	look_at <0, 0, 8> // scene view
//	location <-5*Feet, -24, 2*Feet> // scaffold
//	look_at <0, 0, 15*Feet> // scaffold
//	location <-30, 2, 2.4*Feet> // front view
//	look_at <0, 0, 8> // front view
//	location <-30, 2, 1.4*Feet> // lower front view
//	look_at <0, 0, 8> // lower front view
//	location <-8, .2, 3.4*Feet> // upper view
//	look_at <0, 0, 8> // upper view
//	location <-7, 28, 2.4*Feet> // LH side
//	look_at <0, 0, 8> // LH side
//	location <-18, -22, 2.4*Feet> // RH 3/4
//	look_at <0, 0, 8> // RH 3/4
	location <-15, 2, 12> // hat view
	look_at <0, 0, 6> // hat view
//	location <-3, 2, 10> // label closeup
//	look_at <4, 0, 7> // label closeup
	angle 55
}


camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Lighting
//===============================================


#declare MainSpotLight = // behind camera (simple spotlight)
	light_source {
		<-60*Feet,12*Feet,12*Feet>
		color rgb<1.0, 1.0, 1.0>*4.0
		atmosphere off
		spotlight
		point_at <0,0,0>
		radius 16    // degrees fully lit (*2)
		falloff 22   // degrees no lighting (*2)
		tightness 1
		fade_distance 32*Feet
		fade_power 1
	}
#declare TinyLight = // red near camera, provides red glow from hat lining
	light_source {
		<-2,-.1,1>
		color rgb<1.0, 0.2, 0.1>*.6
		atmosphere off
		spotlight
		point_at <0,0,12>
		radius 58    // degrees fully lit (*2)
		falloff 72   // degrees no lighting (*2)
		tightness 1
		fade_distance 8
		fade_power 1
	}
#declare YellowSpot = // highlights
	light_source {
		<-3*Feet,6*Feet,10*Feet>
		color rgb<1.0, 1.0, 0.0>
		atmosphere off
		spotlight
		point_at <0,0,0>
		radius 18    // degrees fully lit (*2)
		falloff 32   // degrees no lighting (*2)
		tightness 1
		fade_distance 10*Feet
		fade_power 1
	}
#declare BlueSpot = // highlights
	light_source {
		<-3*Feet,4*Feet,10*Feet>
		color rgb<0.0, 0.0, 1.0>
		atmosphere off
		spotlight
		point_at <0,0,0>
		radius 18    // degrees fully lit (*2)
		falloff 32   // degrees no lighting (*2)
		tightness 1
		fade_distance 10*Feet
		fade_power 1
	}
#declare RedSpot = // highlights
	light_source {
		<-3*Feet,-2*Feet,10*Feet>
		color rgb<1.0, 0.0, 0.0>
		atmosphere off
		spotlight
		point_at <0,0,0>
		radius 18    // degrees fully lit (*2)
		falloff 32   // degrees no lighting (*2)
		tightness 1
		fade_distance 10*Feet
		fade_power 1
	}
#declare StageBulb = // stark light, makes truss and roof shadows
	light_source {
		<18*Feet,15*Feet,8*Feet>
//		color rgb<0.7, 0.7, 0.6>
		color rgb<0.4, 0.4, 0.3>
		atmosphere off
		fade_distance 3*Feet
		fade_power 1
	}

//===============================================
//             Environment
//===============================================

sky_sphere {
	pigment {
		gradient z
			color_map {
				[ 0.0  color <0.0, 0.0, 0.0> ]
				[ 1.0  color <0.02, 0.02, 0.03> ]
			}
	}
}


fog
{
  fog_type 1
  distance 3000
  color rgb<.51,.33,.26>
}


//===============================================
//             Basic Objects
//===============================================


#declare TableTop =
	box { //
		<-15,-20,-1>,<15,20,0>
		texture {pigment {color rgb<.6,.6,.6>} finish {ambient .2}}
	}

/*-------------- Hat Parts --------------*/
#include "LABEL.POV"
#declare Label =
		object { LabelSurf
			scale <.1,.1,.1>
			rotate <0,0,90>
			rotate <0,-90,0>
		texture { LabelTex }
		texture {
			pigment {
				image_map { // default mapping onto XY plane
					png "Label2.png"
					once
				}
			}
			scale <2,2,2> rotate <0,-90,0> rotate <-90,0,0> translate <0,-1.0,1.6>
//			finish { ambient .3 }
		}
	}
#include "LINING.POV"
#declare Lining =
	union {
		object { LiningSurf
			scale <.33,.6,.4>
			rotate <-90,0,0>
			translate <0,-3.97,0>
			rotate <0,0,0>
		}
		object { LiningSurf
			scale <.33,.6,.4>
			rotate <-90,0,0>
			translate <0,-3.97,0>
			rotate <0,0,90>
		}
		object { LiningSurf
			scale <.33,.6,.4>
			rotate <-90,0,0>
			translate <0,-3.97,0>
			rotate <0,0,180>
		}
		object { LiningSurf
			scale <.33,.6,.4>
			rotate <-90,0,0>
			translate <0,-3.97,0>
			rotate <0,0,270>
		}
		texture { SatinRed2 }
		translate <0,0,5.6>
		rotate <0,0,-30>
	} // end union
#declare HatInnerBandRidge =
	cylinder {
		<0,0,0>,<0,0,1>,.04
		texture { SatinRed }
	}
#declare HatInnerBand = // a series of ridges
	union {
		#declare BDeg = 90.5
		#while ( BDeg < 449.5 ) // leave a tiny gap
			object { HatInnerBandRidge
				translate <3.85,0,0>
				rotate z*BDeg
			}
			#declare BDeg = BDeg + 0.5
		#end
	}
#declare Stitch = // in xz plane, top to +z
	union {
		torus {
			.06,.02
			clipped_by {box{<-.1,-.1,0>,<0,.1,.1>}}
			translate <-.03,0,0>
		}
		torus {
			.06,.02
			clipped_by {box{<0,-.1,0>,<.1,.1,.1>}}
			translate <.03,0,0>
		}
		cylinder {
			<-.03,0,0>,<.03,0,0>,.02
			translate <0,0,.06>
		}
		texture { RedThread }
		scale 1
	} // end union
/*-------------- The Hat --------------*/
#declare Hat =
	union {
		object { Label translate <3.8,0,5.8> rotate <0,0,90> }
		object { Lining }
		object { HatInnerBand translate <0,0,6.5> }
		object { Stitch rotate <90,0,-90> translate <3.87,0,7.3> rotate <0,0,90> }
		object { Stitch rotate <90,0,-90> translate <3.87,0,7.0> rotate <0,0,90> }
		object { Stitch rotate <90,0,-90> translate <3.8.4,6.6> rotate <0,0,90> } // label
		object { Stitch rotate <90,0,-90> translate <3.8,-.4,6.6> rotate <0,0,90> } // label
//		object { TestSphere scale .3 rotate <90,0,-90> translate <3.57,-.3,6.3> rotate <0,0,90> }
		difference {
			cylinder { // outer
//				<0,0,0>,<0,0,8>,4.2
				<0,0,0>,<0,0,8>,8
				texture { HatTex }
			}
			cylinder { // inner
//				<0,0,.2>,<0,0,9>,4.0
				<0,0,.2>,<0,0,9>,7
				texture { HatTex }
			}
		} // end difference
		torus {
			4.8,.8
			texture { HatTex }
			rotate x*90
			translate <0,0,8>
		}
		difference { // lining
			cylinder {
//				<0,0,0.5>,<0,0,6.6>,4.01
				<0,0,0.5>,<0,0,6.6>,6
				texture { SatinRed }
			}
			cylinder {
//				<0,0,0.4>,<0,0,6.7>,3.95
				<0,0,0.4>,<0,0,6.7>,5
				texture { SatinRed }
			}
		} // end difference
		scale <1,1.2,1>
	}

#declare Wand =
	union {
		cylinder { // black
			<0,0,0>,<11,0,0>,.23
			texture {
				pigment { color rgb<0,0,0> }
				finish { specular .5 roughness .02 }
			}
		}
		cylinder { // white
			<11,0,0>,<12,0,0>,.24
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient .4 specular .5 roughness .02 }
			}
		}
		torus { // white tip
			.16,.08
			texture {
				pigment { color rgb<1,1,1> }
				finish { ambient .4 specular .5 roughness .02 }
			}
			rotate <0,0,90>
			translate <12,0,0>
		}
	}
/*-------------- Stage Structure --------------*/
#declare IBeam =
	box {
		<0,-2.5,0>,<40*Feet,2.5,.5>
	}
#declare DiagBrace =
	box {
		<0,-.25,-2.5>,<5.7*Feet,.25,2.5>
		rotate <0,-45,0>
	}
#declare VertSupport =
	box {
		<0,-2.5,0>,<.5,2.5,4*Feet>
	}
#declare ICount = 1
#declare RoofTruss = //origin at lower edge on end
	union {
		object { IBeam }
		object { IBeam translate <0,0,-1.3> }
		object { IBeam translate <0,0,4*Feet> }
		#while ( ICount < 10 )
			object { DiagBrace translate <ICount*4*Feet,0,0> }
			object { VertSupport translate <ICount*4*Feet,0,0> }
		#declare ICount = ICount + 1
		#end
		texture { TrussPaint }
	}
#declare RCount = 1
#declare Roof =
	union {
		box { // the roof itself
			<-30*Feet,-20*Feet,0>,<30*Feet,40*Feet,1>
		}
		#while ( RCount < 10 ) // dividers
			object { IBeam
				scale <1,2,1>
				rotate z*90
				translate <-10*Feet+RCount*4*Feet,-20*Feet,-.75> }
		#declare RCount = RCount + 1
		#end
			texture { RoofPaint }
	}
#declare SRail =
	cylinder {
		<0,0,0>,<0,40*Feet,0>,2
		texture { GlossyBlack }
		translate <0,-20*Feet,0>
	}
#declare CrossBar =
	#declare Roundness = .3 // range 0 to .5, larger = more rounded
	object { RoundedBox
		scale <20,6,1>
		texture { GlossyBlack }
	}
#declare Scaffold =
	union {
		object { SRail translate <-10,0,0> }
		object { SRail translate <10,0,0> }
		#declare SYCount = 1
		#while ( SYCount < 80 )
			object { CrossBar translate <0,-20*Feet+SYCount*14,0> }
			#declare SYCount = SYCount + 1
		#end
	}
/*-------------- Cables --------------*/
#declare StraightCable =
	cylinder {
		<0,-20*Feet,0>,<0,20*Feet,0>,.6
		texture { GlossyBlack }
	}
#declare CurveCable =
	torus {
		50*Feet,.4
		rotate x*90
		translate <50*Feet,0,0>
		texture { GlossyBlack }
//		texture { LabelTex }
	}
#declare CableGroup1 =
	union {
		object { StraightCable }
		object { StraightCable rotate z*2 translate <4,0,0> }
		object { CurveCable translate <-2,0,0> }
		object { CurveCable rotate z*-1 translate <6,0,0> }
	}
#declare CableGroup2 =
	union {
		object { StraightCable }
		object { StraightCable rotate z*-3 translate <9,0,0> }
		object { CurveCable rotate z*3 translate <4,0,0> }
		object { CurveCable rotate z*2 translate <-3,0,0> }
	}

#declare LightGroup =
union {
		#declare RS = seed(70382)
		#include "StageLight.inc"
		object { WhiteLight translate <0,0,0> }
		#include "StageLight.inc"
		object { GreenLight translate <0,14,0> }
		#include "StageLight.inc"
		object { RedLight translate <0,28,0> }
		#include "StageLight.inc"
		object { YellowLight translate <0,42,0> }
		#include "StageLight.inc"
		object { BlueLight translate <0,56,0> }
	} // end union

#declare CurtainPart =
	#include "CURTAIN.POV"
	object { CurtainSurf
		scale <4,12,6>
		rotate <90,0,90>
		texture { SatinRed }
	}
#declare CurtainRail =
	difference {
		box {
			<-4,-20*Feet,0>,<4,20*Feet,6>
			texture { TrussPaint }
		}
		box {
			<-3,-20*Feet,-1>,<3,20*Feet,5>
			texture { RoofPaint }
		}
	}
#declare UpperCurtain =
	union {
		object { CurtainRail translate <0,0,12> }
		object { CurtainPart translate <0,0*Feet,0> }
		object { CurtainPart translate <0,-5.93*Feet,0> }
		object { CurtainPart translate <0,6.0*Feet,0> }
	}
#declare HalfCuff =
	union {
		difference {
			cylinder { // outer shirt
				<0,0,0>,<4,0,0>,2
			}
			cylinder { // inner shirt
				<-.1,0,0>,<4.1,0,0>,1.95
			}
			box { // cuts off half in Y
				<-.2,.3,-3>,<4.2,3,3>
			}
			texture {
				pigment { color White }
				finish { ambient .3 }
			}
		} // end difference
	} // end union
#declare Cuff =
	union {
		object { HalfCuff }
		object { HalfCuff rotate x*160 translate <0,0,.2> }
/*
		difference {
			cylinder { // outer shirt
				<0,0,0>,<4,0,0>,2
			}
			cylinder { // inner shirt
				<-.1,0,0>,<4.1,0,0>,1.95
			}
			texture {
				pigment { color White }
				finish { ambient .3 }
			}
		} // end difference
*/
		difference {
			cylinder { // outer jacket
				<.5,0,0>,<5,0,0>,2.3
			}
			cylinder { // inner jacket
				<-.4,0,0>,<5.1,0,0>,2.25
			}
			texture {
				pigment { color Black }
				finish { ambient .1 }
			}
		} // end difference
		scale <1,1,1.2>
	} // end union

/*-------------- Magic Dust --------------*/
#declare RS = seed(95378)
#declare MoteSize = .08
#declare CloudSize = 3 //inches
#declare MagicDust =
	union {
		#declare DCount = 1
		#while ( DCount < 60 )
			box {
				<0,0,0>,<rand(RS)*MoteSize,rand(RS)*MoteSize,.001>
				texture { GlitterTex }
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*CloudSize,rand(RS)*CloudSize,rand(RS)*CloudSize>
			}
			box {
				<0,0,0>,<rand(RS)*MoteSize,rand(RS)*MoteSize,.001>
				texture { YellowTex }
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*CloudSize,rand(RS)*CloudSize,rand(RS)*CloudSize>
			}
			box {
				<0,0,0>,<rand(RS)*MoteSize,rand(RS)*MoteSize,.001>
				texture { GreenTex }
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*CloudSize,rand(RS)*CloudSize,rand(RS)*CloudSize>
			}
			box {
				<0,0,0>,<rand(RS)*MoteSize,rand(RS)*MoteSize,.001>
				texture { GlitterTex }
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*CloudSize,rand(RS)*CloudSize,rand(RS)*CloudSize>
			}
			box {
				<0,0,0>,<rand(RS)*MoteSize,rand(RS)*MoteSize,.001>
				texture { WhiteTex }
				rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
				translate <rand(RS)*CloudSize,rand(RS)*CloudSize,rand(RS)*CloudSize>
			}
			#declare DCount = DCount + 1
		#end
	} // end union

//===============================================
//             Human Figures
//===============================================

/*-------------- Right Hand --------------*/
#declare HandPose = 1
#declare FFat = 1.23 // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 12 // thumb, outer joint
#declare TB  = 25 // thumb, middle joint
#declare TRot  = 30 // thumb rotation angle
#declare TExt  = 8 // thumb extension from hand
#declare F1A  = 44 // index finger, outer joint
#declare F1B  = 67 // index finger, middle joint
#declare F1C  = 28 // index finger angle
#declare F1Rot  = 10 // index finger rotation
#declare F2A  = 40 // middle finger, outer joint
#declare F2B  = 90 // middle finger, middle joint
#declare F2C  = 48 // middle finger angle
#declare F2Rot  = 4 // middle finger rotation
#declare F3A  = 70 // ring finger, outer joint
#declare F3B  = 98 // ring finger, middle joint
#declare F3C  = 52 // ring finger angle
#declare F3Rot  = -4 // ring finger rotation
#declare F4A  = 22 // pinky finger, outer joint
#declare F4B  = 36 // pinky finger, middle joint
#declare F4C  = 32 // pinky finger angle
#declare F4Rot  = -25 // pinky finger rotation
#declare WRot = -12 // wrist angle
#declare WCock = -5 // wrist cock side-to-side
#include "BlobHand.inc"
#declare HandWand =
	union {
		object { RightHand  }
		object { Cuff rotate <35,0,0> translate <0,-.9,0> }
		object { Wand rotate <0,0,-130> translate <-3,0,-.7> }
	}
object { HandWand rotate <0,0,0> translate <7,8,15> }

/*-------------- Left Hand --------------*/
#declare HandPose = 1
#declare FFat = 1.23 // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 12 // thumb, outer joint
#declare TB  = 25 // thumb, middle joint
#declare TRot  = 30 // thumb rotation angle
#declare TExt  = 0 // thumb extension from hand
#declare F1A  = 24 // index finger, outer joint
#declare F1B  = 22 // index finger, middle joint
#declare F1C  = 10 // index finger angle
#declare F1Rot  = 10 // index finger rotation
#declare F2A  = 20 // middle finger, outer joint
#declare F2B  = 20 // middle finger, middle joint
#declare F2C  = 20 // middle finger angle
#declare F2Rot  = 0 // middle finger rotation
#declare F3A  = 25 // ring finger, outer joint
#declare F3B  = 58 // ring finger, middle joint
#declare F3C  = 23 // ring finger angle
#declare F3Rot  = -4 // ring finger rotation
#declare F4A  = 22 // pinky finger, outer joint
#declare F4B  = 66 // pinky finger, middle joint
#declare F4C  = 32 // pinky finger angle
#declare F4Rot  = -10 // pinky finger rotation
#declare WRot = -12 // wrist angle
#declare WCock = -25 // wrist cock side-to-side
#include "BlobHand.inc"
#declare HandWCuff =
	union {
		object { LeftHand rotate <70,0,0> translate <0,0,0> }
		object { Cuff scale <.8,.8,1.0> rotate <0,0,0> translate <0,-.0,-.1> }
	}
object { HandWCuff rotate <0,0,-30> translate <3,-6,16> }

//===============================================
//             Main Constructs
//===============================================


//===============================================
//             Object Placement
//===============================================

object { MainSpotLight }
object { TinyLight }
object { YellowSpot }
object { BlueSpot }
object { RedSpot }
object { StageBulb }

object { Roof translate <0,0,18.5*Feet> }
object { RoofTruss translate <-10*Feet,-6*Feet,14*Feet> }
object { RoofTruss translate <-10*Feet, 6*Feet,14*Feet> }
object { Scaffold translate <-1*Feet,0,12*Feet> }
object { CableGroup1 translate <-1.7*Feet,0,12.1*Feet> } // near
object { Scaffold translate <3*Feet,0,12*Feet> }
object { CableGroup2 translate <3*Feet,0,12.1*Feet> } // far

object { LightGroup rotate y*0 translate <-1*Feet,2*Feet,11*Feet> }
object { LightGroup rotate y*0 translate <-1*Feet,-7*Feet,11*Feet> }
object { LightGroup rotate y*0 translate <3*Feet,2*Feet,11*Feet> }
object { LightGroup rotate y*0 translate <3*Feet,-7*Feet,11*Feet> }

object { UpperCurtain translate <-5*Feet,0,12*Feet> }
object { UpperCurtain translate <1*Feet,0,12*Feet> }
object { UpperCurtain translate <5*Feet,0,12*Feet> }
object { UpperCurtain translate <9*Feet,0,12*Feet> }

object { Hat rotate <0,0,-20> }
object { TableTop }
object { BlobHead rotate <0,-25,9> translate <16,0,24> }
object { MagicDust rotate <0,0,-33> translate <-2.5,-.7,9> }

// Test Objects - Do Not Render
// simple lighting - for quick render
//object {StdBulb100Watt translate <0,0,5> } // inside hat
//object {StdBulb100Watt translate <-7*Feet+24,-6*Feet,7*Feet> } // left front area
//object {StdBulb100Watt translate <10*Feet+24,10*Feet,8*Feet> } // right rear area
//object {Spot40Deg75Watt rotate <0,40,0> translate <-88,27,72> } // right front highlight
//object { Lining }
