#include "colors.inc"
#include "textures.inc"
#include "knight.inc"
#include "scenary.inc"
#include "magician.inc"

global_settings { max_trace_level 10 }

camera {
   location  <20, 15,-35>
   look_at   <0, 5, -10>
}

// general scene light
light_source { <10, 10, -25> color Gray30}



// ------------------------------------------
object {Knight
       rotate <30, -70, 0>
       translate <-5, 10.6, -22>
}

object {Wizard
       scale 2
       translate <11, 3, -7>
}
object {Staff
       rotate <0, -10, -20>
       translate <11.4, 4.5, -12>
}
object {Blast_Magic}

// throne dias
cylinder {<0, 0, 0>, <0, 1, 0>, 19
         texture {Stone}
}
cylinder {<0, 1, 0>, <0, 2, 0>, 13
         texture {Stone}
}
cylinder {<0, 2, 0>, <0, 3, 0>, 8
         texture {Stone}
}
object {Throne
       translate <0, 4, 2>
}

object {Brazier
       translate <-16, 1, -4>
}
object {Brazier
       translate <16, 1, -4>
}
object {Brazier
       rotate <0, 120, 0>
       translate <-10, 2, 1>
}
object {Brazier
       translate <10, 2, 1>
}

object {Crystal_Ball
        rotate <0, -40, 0>
        scale 0.7
        translate <7, 0, -20>}

// walls
box {<-70, 0, -70>, <70, 50, 50>
      hollow
      texture {Stone_Floor}
}

#declare Count = -4
#while (Count < 5)
object {ArchWay
       translate <Count * 10, 0, 20>
}
object {ArchWay
       translate <5 + Count * 10, 21, 20>
}
object {ArchWay
       rotate <0, -90, 0>
       translate <-45, 0, -25 + Count*10>
}
object {ArchWay
       rotate <0, -90, 0>
       translate <-45, 21, -20 + Count*10>
}

#declare Count=Count + 1
#end
