// Persistence of Vision Ray Tracer Scene Description File
// File: assemble.pov
// Vers: 3.02 Watcom Win32
// Desc: Assemble the unicorn
// Date: August 28, 1997
// Auth: Sonya Roberts
// Note:

#declare Tail=
object {
	#declare HR=seed(7)
	#declare X1=-.2
	union {
		#while (X1<=.2)
			#debug str(X1,0,1)
			#debug " - "
			#declare Y1=-.1
			union {
				#while (Y1<=.2)
					#debug str(Y1,0,2)
					#debug " "
					union {
						#declare HStart=<0,0,0>
						#declare HSegment=1
						#while (HSegment<=7)
							#declare HFx=HStart.x+(-.03+(rand(HR)*.06))
							#switch (HSegment)
								#case (1)
									#declare HFy=HStart.y+(.15+(rand(HR)*.25))
								#break
								#case (2)
									#declare HFy=HStart.y+(.1+(rand(HR)*.15))
								#break
								#case (3)
									#declare HFy=HStart.y-(.05+(rand(HR)*.1))
								#break
							     #else
								#declare HFy=HStart.y-rand(HR)
							#end
							#declare HFz=HStart.z+(rand(HR)*((7/HSegment)*.075))
							#declare CLR=.5+(.06*HSegment)
							cylinder {
								HStart,<HFx,HFy,HFz>,.0075
								pigment {color rgb <CLR,CLR,CLR>}
								finish {ambient .2}
							}
							#declare HStart=<HFx,HFy,HFz>
							#declare HSegment=HSegment+1
						#end
						translate <X1,Y1,0>
					}
					#declare Y1=Y1+.025
				#end
			}
			#declare X1=X1+.025
			#debug "\n"
		#end
	}
}

#declare Mane=
object {
	#declare HR=seed(7)
	#declare X1=-.15
	union {
		#while (X1<=.15)
			#debug str(X1,0,2)
			#debug " - "
			#declare Y1=0
			union {
				#while (Y1<=1.9)
					#debug str(Y1,0,2)
					#debug " "
					union {
						#declare HStart=<0,0,0>
						#declare HSegment=1
						#while (HSegment<=7)
							#declare HFx=HStart.x+(-.03+(rand(HR)*.06))
							#switch (HSegment)
								#case (1)
									#declare HFy=HStart.y+(.15+(rand(HR)*.15))
								#break
								#case (2)
									#declare HFy=HStart.y+(.1+(rand(HR)*.075))
								#break
								#case (3)
									#declare HFy=HStart.y+(-.05+(rand(HR)*.05))
								#break
							     #else
								#declare HFy=HStart.y-(rand(HR)*.35)
							#end
							#declare HFz=HStart.z+(rand(HR)*((7/HSegment)*.05))
							#declare CLR=.5+(.06*HSegment)
							cylinder {
								HStart,<HFx,HFy,HFz>,.0075
								pigment {color rgb <CLR,CLR,CLR>}
								finish {ambient .2}
							}
							#declare HStart=<HFx,HFy,HFz>
							#declare HSegment=HSegment+1
						#end
						rotate y*(-5+(rand(HR)*10))
						#if (abs(X1)=X1)
							rotate y*90
							#if (Y1<=1)
								rotate z*-((1-Y1)*15)
							#end
						     #else
							rotate y*-90
							#if (Y1<=1)
								rotate z*((1-Y1)*15)
							#end
						#end
						#if (Y1>1)
							rotate y*((Y1-1)*12)
							translate <X1-((Y1-1)/5),Y1,-((Y1/1.5)+(((Y1-1)/2.5)*(Y1*1.4)))>
						     #else
							translate <X1,Y1,-((Y1/1.5)+((Y1/5)*(Y1*1.4)))>
						#end
					}
					#declare Y1=Y1+.025
				#end
			}
			#declare X1=X1+.025
			#debug "\n"
		#end
	}
}

#declare Eye=
object {
	union {
		difference {
			sphere {<0,0,0>,.13}
			box {<-.2,-.2,-.2>,<.2,0,.2>}
			rotate x*30
			pigment {color White}
			finish {ambient .2}
		}
		sphere {
			<0,0,0>,.125
			pigment {color DarkBrown}
			finish {ambient .3 phong .3 reflection .2}
		}
		scale <1.25,.9,.75>
	}
}

object {
	union {
		union {					// Eyes
			object {Eye	rotate y*90	translate <-.375,6.125,-4.425>}
			object {Eye	rotate y*-90	translate <.25,6.125,-4.5>}
			rotate y*3.75
		}
		object {
			#include "unicorn.pov"
			texture {
				pigment {
					gradient y
					color_map {
						[0	color Black]
						[.05	color Black]
						[.05	color White]
						[1	color White]
					}
				}
				finish {
					ambient .2
				}
				scale <1,8,1>
			}
		}
		#include "horn.pov"
		object {Tail	translate <0,4.75,1>}
		object {Mane	translate <0,4.8,-1.8>}
	}
	scale <.7,.7,.7>
	rotate y*50
	translate <1.5,0,8>
}
