// Persistence of Vision Ray Tracer Scene Description File
// File: Attic.pov
// Vers: 3.01 Watcom Win32
// Desc: Scene of Magic in an Attic
// Date: June 13, 1997
// Auth: Sonya Roberts0
// Note: 

// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"
#include "attic.inc"
#include "jewels.inc"

#declare BaseCamera=
camera {
	location	<-3,3.5,-10>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,5,0>
}

#declare GoodCamera=
camera {
	location	<-3.5,3.25,-1.25>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,4,15>
}


object {
	sphere {<0,0,0>,3000}
	hollow
	texture {
		pigment {
			gradient y
			color_map {
				[0	color LightBlue]
				[1.0	color NavyBlue]
			}
			scale <1,3000,1>
		}
	}
	texture {
		pigment {
			bozo
			turbulence 0.5
			octaves 3
			lambda 6.0
			color_map {
				[0.0 color rgbf <1, 1, 1, 1>]
				[0.9 color rgb <0.737, 0.788, 0.820>]
				[1.0 color rgb <1, 1, 1>]
			}
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}
		scale <1500, 800, 1000>
		rotate y*-155
	}
}

//==== Setup needed variables ====
#declare True=1
#declare False=0
#declare RSD=seed (29)

//==== Decide what to include in scene ====
#declare Use_Camera=2		// 1=BaseCamera, 2=GoodCamera
#declare FastLighting=False
#declare I_Tree=True
#declare I_Land=True

#declare I_EmptyAttic=True
#if (I_EmptyAttic)
	#declare I_Window=True
	#declare I_Rafters=True
	#include "room.pov"
#end

#declare I_Furnishings=True
#if (I_Furnishings)
	#declare I_Table=True
	#declare I_Dummy=True
	#declare I_Couch=True
	#include "furnish.pov"
#end

#declare I_MiscJunk=True
#if (I_MiscJunk)
	#declare I_BookPile=True
	#declare I_Wyvern=True
	#declare I_Carpet=True
	#declare I_SwordStone=True
	#declare I_Poster=True
	#declare I_Crystal=True
	#include "miscjunk.pov"
#end

#declare I_Unicorn=True
#if (I_Unicorn)
	#include "assemble.pov"
#end

//==== Set up the selected scene ====
#switch (Use_Camera)
	#case (1)	camera {BaseCamera}	#break
	#case (2)	camera {GoodCamera}	#break
	#else		#debug "Unable to locate specified camera"	camera {Base_Camera}	#break
#end

light_source {
	<150,200,450>
	color White
}

#if (FastLighting)
	light_source {
		<0,6,-10>
		color Gray50
		fade_distance 15
		fade_power 1
	}
	light_source {
		<0,6,8>
		color Gray30
		shadowless
		fade_distance 15
		fade_power 1
	}
     #else
	light_source {
		<0,6,-10>
		color Gray50
		area_light <2,0,0,>,<0,2,0>,4,4
		jitter
		adaptive 1
		fade_distance 15
		fade_power 1
	}
	light_source {
		<0,6,8>
		color Gray30
		shadowless
		fade_distance 15
		fade_power 1
	}
#end

#if (I_Land)
	object {
		height_field {
			pot "mount.pot"
			smooth
			translate <-.5,-.1,.5>
			scale <500,75,500>
		}
		pigment {
			color Gray60
		}
	}
#end

#if (I_Tree)
	#include "defaults.inc"
	#declare LeafShape=6
	#declare LeafNum=4
	#declare MaxSplits=6
	object {
		#include "trees.inc"
		translate <5.5,-9,26>
	}
#end
