// Magic : object 4
//         - an axe

#ifndef (PREVIEW)
#declare PREVIEW=0
#end

#if (PREVIEW=1)

#declare Metal1 =
texture {
	pigment { color rgb <1, 1, 1> }
	finish { phong 1 ambient 0.3 }
}

#declare Mesing1 =
texture {
	pigment { color rgb <1, 1, 0.3> }
	finish { phong 1 ambient 0.3 }
}

#declare Gold45 =
texture {
	pigment { color rgb <1, 1, 0> }
	finish { phong 1 ambient 0.3 }
}

#declare Metal2 =
texture {
	pigment { color rgb <0.5, 0.5, 0.5> }
	finish { phong 0.6 ambient 0.3 }
}

#declare Leather1 =
texture {
	pigment { color rgb <0.7, 0.7, 0.2> }
	finish { phong 0.3 ambient 0.3 }
}

// ********************************************************
#else

#declare Metal1 =
texture {
	pigment { color rgb <0.6, 0.6, 0.6> }
	finish {
		diffuse 0.8 brilliance 0.8
		phong 1 phong_size 80
		reflection 0.4
		ambient 0.3
	}
}

#declare Mesing1 =
texture {
	pigment { color rgb <0.8, 0.7, 0.3> }
	finish {
		diffuse 0.8 brilliance 0.8
		phong 0.7 phong_size 60
		reflection 0.3
		ambient 0.3
	}
}

#declare Gold45 =
texture {
	pigment { color rgb <0.5, 0.5, 0> }
	finish {
		brilliance 5
		ambient <0.3, 0.3, 0>
		phong 1 phong_size 100
		reflection 0.5
	}
}

#declare Metal2 =
texture {
	pigment { color rgb <0.4, 0.4, 0.4> }
	finish {
		diffuse 0.8 brilliance 0.8
		phong 0.7 phong_size 60
		reflection 0.2
		ambient 0.3
	}
}

#declare Leather1 =
texture {
	pigment { color rgb <0.6, 0.5, 0.2> }
	normal { bumps 0.5  scale (1/20) }
	finish {
		diffuse 1 brilliance 0.4
		phong 0.4 phong_size 60
		ambient 0.3
	}
}

#end

// ********************************************************

#declare helper1 =
intersection {
	sphere { <0, 0, 0>, 14 }
	sphere { <0, 0, -13>, 14 }
	translate <0, 0, 6.5>
}

#declare bigedge1 =
union {
	difference {
		intersection {
			box { <1, -9, -0.2>, <7, 7, 0.2> }
			object { helper1 scale <(5.75/6.2), (5.75/6.2), 1/10> translate <-5, -0.5, 0> }
		}
		union {
			cylinder { <0, 6.5, -1>, <0, 6.5, 1>, 4.5 }
			cylinder { <-2, -6.5, -1>, <-2, -6.5, 1>, 5.5 }
			box { <-0.5, -0.5, -1>, <0.5, 0.5, 1> scale <sqrt(2), sqrt(2), 1> rotate z*45
				translate <3, 0, 0> }
		}
	}
	difference {
		box { <-0.5, -1, -0.2>, <0, 0, 0.2> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.5 }
		translate <1.5, 2.5, 0>
	}
	difference {
		box { <-0.5, 1, -0.2>, <0, 0, 0.2> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.5 }
		translate <1.5, -2.5, 0>
	}
	texture { Metal1 }
}

#declare smalledge1 =
union {
	difference {
		intersection {
			box { <-6, -4, -0.2>, <-1, 4, 0.2> }
			object { helper1 scale <(2.75/6.2), (2.75/6.2), 1/10> }
		}
		union {
			cone { <-3.3, 0.8, -0.3>, 0.8, <-3.3, 0.8, 0.1>, 0.4 }
			cone { <-3.3, 0.8, 0.3>, 0.8, <-3.3, 0.8, -0.1>, 0.4 }
			cylinder { <-1, 5.5, -1>, <-1, 5.5, 1>, 4 }
			cylinder { <-1, -5.5, -1>, <-1, -5.5, 1>, 4 }
		}
	}
	difference {
		box { <1, -2, -0.2>, <0, 0, 0.2> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 1 }
		translate <-2, 2.5, 0>
	}
	difference {
		box { <1, 2, -0.2>, <0, 0, 0.2> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 1 }
		translate <-2, -2.5, 0>
	}
	difference {
		box { <-2.1, -1.2, -0.25>, <-1.3, 1.2, 0.25> }
		box { <-2, -1.1, -1>, <-1.4, 1.1, 1> }
	}
	box { <-0.1, -0.1, -0.25>, <0.1, 0.1, 0.25> scale <sqrt(2), sqrt(2), 1> rotate z*45
		translate <-1.7, -0.8, 0> }
	box { <-0.1, -0.1, -0.25>, <0.1, 0.1, 0.25> scale <sqrt(2), sqrt(2), 1> rotate z*45
		translate <-1.7, -0.3, 0> }
	box { <-0.1, -0.1, -0.25>, <0.1, 0.1, 0.25> scale <sqrt(2), sqrt(2), 1> rotate z*45
		translate <-1.7, 0.3, 0> }
	box { <-0.1, -0.1, -0.25>, <0.1, 0.1, 0.25> scale <sqrt(2), sqrt(2), 1> rotate z*45
		translate <-1.7, 0.8, 0> }

	texture { Metal1 }
}

#declare bridge1 =
difference {
	intersection {
		box { <-1, -2.5, -0.5>, <1, 2.5, 0.5> }
		cylinder { <0, -3, 0>, <0, 3, 0>, 1.5  scale <1, 1, (0.35/1.5)> }
	}
	union {
		cylinder { <-0.5, 2.5, -1>, <-0.5, 2.5, 1>, 0.3 }
		cylinder { <0.5, 2.5, -1>, <0.5, 2.5, 1>, 0.3 }
	}
	texture { Metal1 }
}

#declare knob1 =
intersection {
	box { <-0.3, -0.5, -0.3501>, <0.3, 0.5, 0.3501> }
	cylinder { <0, 0, -0.5>, <0, 0, 0.5>, 0.7  scale <(2/7), 1, 1> }
	texture { Mesing1 }
}

#declare knob2 =
intersection {
	box { <-0.3, -0.5, -1>, <0.3, 0.5, 1> }
	cylinder { <0, 0, -1>, <0, 0, 1>, 0.7  scale <(2/7), 1, 1> }
	sphere { <0, 0, 0>, 0.8001  scale <1, (1.5/0.8), 1> translate <0, -1, 0> }
	texture { Mesing1 }
}

#declare adecor1 =
difference {
	cylinder { <0, -0.3, 0>, <0, 0.3, 0>, 1.1 }
	union {
		torus { 1.1, 0.3 translate y*0.3 }
		torus { 1.1, 0.3 translate y*(-0.3) }
	}
	texture { Gold45 }
}

#declare handletop1 =
difference {
	cylinder { <0, 0, 0>, <0, -9, 0>, 0.8 }
	union {
		#declare i=0
		#while (i<17)
			#declare j=0
			#while (j<6)
				sphere { <0, -0.5, -0.8>, 0.2  rotate y*((60*j)+(30*i)) translate y*(-0.5)*i }
			#declare j=j+1
			#end
		#declare i=i+1
		#end
	}
	texture { Metal2 }
}

#declare adecor2 =
difference {
	cylinder { <0, -0.4, 0>, <0, 0.4, 0>, 1 }
	union {
		torus { 1, 0.2 translate y*0.4 }
		torus { 1, 0.2 translate y*(-0.4) }
	}
	texture { Gold45 }
}

#declare handlebot1 =
blob {
	threshold 0.3
	#declare i=0
	#while (i<16)
		sphere { <0, -(i/2), 0>, 1, 1.5 }
	#declare i=i+1
	#end
	texture { Leather1 }
}

#declare bot1 =
union {
	difference {
		cylinder { <0, 0, 0>, <0, -0.6, 0>, 1 }
		torus { 1, 0.2 }
	}
	torus { 1, 0.2 translate y*(-0.4) }
	torus { 0.6, 0.2 rotate x*90 translate <-0.8, -0.8, 0> }
	texture { Metal2 }
}

// ********************************************************

#declare axe1 =
union {
	object { bigedge1 }
	object { smalledge1 }
	object { bridge1 }
	object { knob1 translate y*1.5 }
	object { knob1 }
	object { knob2 translate y*(-1.5) }

	sphere { <0, 0, 0>, 0.8  texture { Metal1 } scale <1, (1.5/0.8), 1> translate <0, -2.5, 0> }

	cylinder { <0, -2.5, 0>, <0, -4, 0>, 0.8  texture { Metal1 } }
	object { adecor1 translate y*(-3.2) }
	object { adecor1 translate y*(-4.2) }
	object { handletop1 translate y*(-4.5) }
	object { adecor2 translate y*(-13.7) }
	object { handlebot1 translate y*(-14) }
	object { bot1 translate y*(-21.9) }
}
