// Magic : object 3
//         - crystal sphere v1.0

#ifndef (HALO)
#declare HALO=1
#end

#ifndef (PREVIEW)
#declare PREVIEW=0
#end

#declare Grey3 =
texture {
    pigment { color rgb <1, 1, 1> }
    finish { phong 1 ambient 0.3 }
}


#if (PREVIEW=1)

#declare Gold23 =
texture {
    pigment { color rgb <1, 1, 0> }
    finish { phong 1 ambient 0.3 }
}

#declare Staklo1 =
texture {
    pigment { color rgb <1, 1, 1> }
    finish { phong 1 ambient 0.3 }
}

#declare Kromm =
texture {
	pigment { color rgb <0.8, 0.8, 1> }
	finish { phong 1 ambient 0.3 }
}

// ********************************************************
#else

#declare Gold23 =
texture {
	pigment { color rgb <0.5, 0.5, 0> }
	finish {
		brilliance 5
		ambient <0.3, 0.3, 0>
		phong 1 phong_size 100
		reflection 0.5
	}
}

#declare Kromm =
texture {
	pigment { color rgb <0, 0, 0.2> }
	finish {
		brilliance 10
		specular 1  roughness 0.001
		reflection 0.95
	}
}

#declare Staklo1 =
texture {
    pigment { color rgbt <0, 0 ,0 ,1> }
    finish {
        ambient 0  diffuse 0
        specular 1
        roughness 0.001
        reflection 0.2
        refraction 1  ior 1.5
    }
}

#end

// ********************************************************

#declare dummy1 =
union {
    cone { <0, 0, 0>, 7, <0, 10, 0>, 2 }
    sphere { <0, 10, 0>, 5 }
    texture { Grey3 }
}

#declare dummy2 =
union {
    sphere { <0, 10, 0>, 5  texture { Staklo1 } }
    difference {
        cone { <0, 0, 0>, 7, <0, 10, 0>, 2 }
        sphere { <0, 10, 0>, 5 }
        texture { Grey3 }
    }
}

#declare nail1 =
difference {
	sphere { <0, 0, 0>, 3.3  scale <1, 1, (0.2/2.3)> }
	union {
		cylinder { <2, 0, -1>, <2, 0, 1>, 4.8 }
		box { <-4, 0, -1>, <4, -4, 1> }
		box { <0, 0, -1>, <4, 4, 1> }
	}
	texture { Kromm }
}

#declare finger1 =
union {
	difference {
		cylinder { <0, 0, 0>, <0, 1, 0>, 1 }
		torus { 1, 0.9  translate <0, 1, 0> }
	}
	blob {
		threshold 0.3
		sphere { <0, 1, 0>, 0.65, 1 }
		sphere { <-0.2, 1.3, 0>, 0.5, 1 }
		sphere { <-0.4, 1.6, 0>, 0.4, 1 }
		sphere { <-0.6, 1.9, 0>, 0.4, 1 }
		sphere { <-0.7, 2.2, 0>, 0.4, 1 }
		sphere { <-0.9, 2.5, 0>, 0.4, 1 }
		sphere { <-0.9, 2.8, 0>, 0.4, 1 }
		sphere { <-1, 3, 0>, 0.6, 1 }
		sphere { <-1.05, 3.3, 0>, 0.4, 1 }
		sphere { <-1.075, 3.6, 0>, 0.4, 1 }
		sphere { <-1.1, 3.9, 0>, 0.4, 1 }
		sphere { <-1.075, 4.2, 0>, 0.4, 1 }
		sphere { <-1.05, 4.5, 0>, 0.4, 1 }
		sphere { <-1.075, 4.8, 0>, 0.4, 1 }
		sphere { <-1.1, 5.1, 0>, 0.4, 1 }
		sphere { <-1.1, 5.4, 0>, 0.4, 1 }
		sphere { <-1, 5.7, 0>, 0.4, 1 }
		sphere { <-1, 6, 0>, 0.45, 1 }
	}
	texture { Gold23 }
}

#declare frame1 =
union {
	difference {
		union {
			#declare i=0
			#while (i<6)
				torus { 1.4, 0.1  rotate x*90 rotate y*60*i }
			#declare i=i+1
			#end
		}
		cylinder { <0, -0.1, 0>, <0, 0.1, 0>, 2.1 }
	}
	#declare i=0
	#while (i<6)
		sphere { <-1.4, 0.1, 0>, 0.1  rotate y*60*i }
		sphere { <-1.4, -0.1, 0>, 0.1  rotate y*60*i }
	#declare i=i+1
	#end
	texture { Gold23 }
}

#declare krombowl1=
difference {
	sphere { <0, 0, 0>, 1 }
	union {
		#declare i=0
		#while (i<3)
			torus { 1, 0.05  rotate z*60*i }
			torus { 1, 0.05  rotate x*60*i }
		#declare i=i+1
		#end
	}
	texture { Kromm }
}

#declare fingerglow1=
sphere { <0, 0, 0>, 5.001 scale <(7/5), 1, (7/5)>
	pigment { color rgbt <1, 1, 1, 1> }
	#declare i=0
	#while (i<6)
		halo {
			emitting
			spherical_mapping
			linear
			color_map {
				[0 color rgbt <0.6, 0.5, 1, 1> ]
				[1 color rgbt <0.95, 0.9, 1, -1> ]
			}
			samples 10
			scale 1
			translate <-5, -1.4, 0> rotate y*60*i
		}
	#declare i=i+1
	#end
	hollow
	translate <0, 10, 0>
}

#declare thunder1=
cylinder { <0, 0, 0>, <0, 1000, 0>, 7
	pigment { color rgbt <0, 0, 0, 1> }
	halo {
		emitting
		cylindrical_mapping
		linear
		color_map {
			[0 color rgbt <0.6, 0.5, 1, 1> ]
			[0.5 color rgbt <0.95, 0.9, 1, 0.7> ]
			[1 color rgbt <0.6, 0.5, 1, 1> ]
		}
		frequency 2
		samples 15
		scale 4
		turbulence <1, 0, 1>
	}
	hollow
}

// ********************************************************

#declare crystal_sphere1 =
union {
	#declare i=0
	#while (i<6)
		object { finger1  translate <-4.75, 0, 0> rotate y*60*i }
		object { nail1  translate <-2.75, 6, 0> rotate y*60*i }
	#declare i=i+1
	#end

	sphere { <0, 10, 0>, 5  texture { Staklo1 } }

	object { frame1 translate <0, 3.5, 0> }
//	sphere { <0, 3.5, 0>, 1.3  texture { Kromm } }

	object { krombowl1 rotate y*15 translate <0, 1, 0> }

	#if (HALO=1)
//		object { fingerglow1 }
		object { thunder1 translate <0, 0, 0> }
	#end

}
