// Persistence of Vision Ray Tracer Scene Description File
// File: bahmagic.pov
// Vers: 3
// Desc: IRTC July-August (Magic)
// Date: 07-15-1997
// Auth: Brendan Heilke
#include "Colors.Inc"
#include "Textures.Inc"
#include "Metals.Inc"
#include "Skies.Inc"
#include "Stones.Inc"
#include "Bahmagi1.Inc"
#include "Bahmagi3.Inc"
#include "Bahmagi4.Inc"
#include "Bahmagi5.Inc"
#include "Bahmagi6.Inc"
global_settings {max_trace_level 100}
background {color rgb <.001,0,.04>}
plane {z,1000
 pigment {P_Cloud1
  scale 1000
 }
 hollow
}
plane {y,0.01
 texture {
  pigment {color rgbt <.2,.4,.7,.9>}
  finish {
   reflection .8
   refraction .6
  }
  normal {
   waves 1
   scale <10,20,10>
   translate <0,0,300>
   turbulence .3
  }
  normal {
   ripples .5
   scale 30
   translate <1000,0,200>
   turbulence .2
  }
 }
}
camera {
 location <1,75,150>
 look_at <0,30,0>
}
fog {
 fog_type 2
 distance 230
 color rgbf <.35,.35,.4,.01>
 fog_offset 15
 fog_alt 20
 turbulence 1
 turb_depth .2
}
light_source {<-100,150,-250> White}
light_source {<100,75,0> White}
light_source {<0,100,-200> White}
light_source {<-30,200,50>
 color rgbf <.1,.1,.1,.5>
 spotlight
 point_at <5,0,0>
 falloff 20
 tightness 100
 radius 15
}
height_field {
 gif "bahmagi1.gif"
 texture {T_Grnt15}
 translate <-.5,0,-.5>
 scale <300,40,300>
 rotate y*70
 smooth
}
height_field {
 gif "bahmagi2.gif"
 texture {T_Grnt15}
 translate <-.5,0,-.5>
 rotate y*180
 scale <800,175,800>
 translate <-300,0,-1000>
 smooth
}
height_field {
 gif "bahmagi3.gif"
 texture {T_Grnt15}
 translate <-.5,0,-.5>
 rotate y*180
 scale <800,150,800>
 translate <100,0,-500>
 smooth
}
object {sword
 texture {T_Chrome_4E}
 rotate <15,-10,-170>
 translate <0,30,10>
}
object {tree
 scale .005
 translate <100,30,-300>
}
object {tree
 scale .005
 rotate y*90
 translate <270,10,-350>
}
object {tree
 scale .008
 rotate y*180
 translate <60,70,-500>
}
object {tree3
 scale <.07,.1,.07>
 translate <260,20,-470>
}
object {tree3
 scale <.07,.1,.07>
 rotate y*90
 translate <150,10,-425>
}
object {tree4
 scale .03
 translate <50,0,-400>
}
object {tree4
 scale .04
 rotate y*180
 translate <220,5,-385>
}
object {tree5
 scale .03
 translate <-100,0,-450>
}
object {tree5
 scale .04
 translate <-250,0,-520>
}