// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// forest.inc
// POV-Ray 3.x include file...
// July 97, SjG (libelle@webbwerks.com)
//
// This file has three tree includes here, bareTree, greenTree,
// and greenTree2, all of which create random conifers.
//
// Their origins are at <0,0,0>, and they grow somewhat randomly.
//
// The tree definitions work best for distant trees, preferably
// shrouded in fog or something.
//
// Samuel Goldstein. libelle@webbwerks.com
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
#declare treeTrunkTexture = texture {
	finish
		{
		roughness 1.0
		}
	pigment
		{
		wrinkles
		turbulence 1
		octaves 8
		omega 0.7
		lambda 2
		color_map
			{
			[0.0 color Tan ]
			[0.4 color DarkBrown]
			[0.8 color Copper]
			[1.001 color Brass]
    		}
		}
	}

#declare treeBranchTexture = texture {
	finish
		{
		roughness 1.0
		}
	pigment
		{
		wrinkles
		turbulence 2
		octaves 8
		omega 0.7
		lambda 2
		frequency 2
		color_map
			{
			[0.0 color ForestGreen ]
			[0.4 transmit 1]
			[0.8 color DarkBrown]
			[1.001 transmit 1]
    		}
		}
	}


#declare bareTree = union {
	#declare bareTreeCount = 0
	#declare treeHeight = 10
	#declare branchIntervalCount = 20
	#declare branchProb = 0.75
	#declare trunkThickness = treeHeight/30
	#declare branchSeed = seed(1025)
	#declare branchDroop = 40 // in degrees
	#declare counter = 1 + treeHeight/branchIntervalCount
	#declare maxLen = treeHeight/1.5

	cone{<0,0,0>,trunkThickness,<0,treeHeight,0>,0.1}

	#while (counter < treeHeight)
		#if (rand(branchSeed) < branchProb)
			#declare branchAngle = rand(branchSeed) * 3.14159 * 2
			#declare workingLen = maxLen / max(counter,1)
			#declare bareTreeCount = bareTreeCount + 1
			cylinder{
					<0,counter,0>,
					<workingLen*sin(branchAngle),
			   	 counter-workingLen*sin(radians(branchDroop)),
			   	workingLen*cos(branchAngle)>,
			   	trunkThickness / max(counter,1)}
		#end //if
		#declare counter=counter + treeHeight/branchIntervalCount
	#end // while
	texture{treeTrunkTexture}
	#debug concat("bare tree: ",str(bareTreeCount,5,0)," branches\n")
}

#declare greenTree = union {
	#declare greenTreeCount = 0
	#declare treeHeight = 10
	#declare branchIntervalCount = 30
	#declare branchProb = 0.85
	#declare trunkThickness = treeHeight/30
	#declare branchSeed = seed(2725)
	#declare branchDroop = 30 // in degrees
	#declare counter = 1 + treeHeight/branchIntervalCount
	#declare maxLen = treeHeight/1.1

	cone{<0,0,0>,trunkThickness,<0,treeHeight,0>,0.1
		texture{treeTrunkTexture}}

	#while (counter < treeHeight)
		#if (rand(branchSeed) < branchProb)
			#declare greenTreeCount = greenTreeCount + 1
			#declare branchAngle = rand(branchSeed) * 3.14159 * 2
			#declare workingLen = maxLen / max(counter,1)
			cone{
					<0,counter,0>,trunkThickness / max(counter,1)
					<workingLen*sin(branchAngle),
			   	 counter-workingLen*sin(radians(branchDroop)),
			   	workingLen*cos(branchAngle)>,
			   	trunkThickness texture{treeBranchTexture}}
		#end //if
		#declare counter=counter + treeHeight/branchIntervalCount
	#end // while
	#debug concat("green tree 1: ",str(greenTreeCount,5,0)," branches\n")
}

#declare greenTree2 = union {
	#declare greenTree2Count = 0
	#declare treeHeight = 12
	#declare branchIntervalCount = 20
	#declare branchProb = 0.55
	#declare trunkThickness = treeHeight/32
	#declare branchSeed = seed(2725)
	#declare branchDroop = 30 // in degrees
	#declare counter = 1 + treeHeight/branchIntervalCount
	#declare maxLen = treeHeight

	cone{<0,0,0>,trunkThickness,<0,treeHeight,0>,0.1
		texture{treeTrunkTexture}}

	#while (counter < treeHeight)
		#if (rand(branchSeed) < branchProb)
			#declare greenTree2Count = greenTree2Count + 1
			#declare branchAngle = rand(branchSeed) * 3.14159 * 2
			#declare workingLen = maxLen / max(counter,1)
			cone{
					<0,counter,0>,trunkThickness / max(counter,1)
					<workingLen*sin(branchAngle),
			   	 counter-workingLen*sin(radians(branchDroop)),
			   	workingLen*cos(branchAngle)>,
			   	trunkThickness texture{treeBranchTexture}}
		#end //if
		#declare counter=counter + treeHeight/branchIntervalCount
	#end // while
	#debug concat("green tree 2: ",str(greenTree2Count,5,0)," branches\n")

}

// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Everything below this line is a specific forest. The ugliness of the
// coordinates is because I got the values for the height-map by measuring
// specific locations off of a gray-scale image.
//
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
 	(151-landSize/2) + 0,
	((37/255) * 60) - 60,
	(landSize/2-154) + 150
	>
	}
	
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(164-landSize/2) + 0,
	((52/255) * 60) - 60,
	(landSize/2-155) + 150
	>
	}

#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(155-landSize/2) + 0,
	((77/255) * 60) - 30,
	(landSize/2-131) + 150
	>
	}
	
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(147-landSize/2) + 0,
	((67/255) * 60) - 30,
	(landSize/2-123) + 150
	>
	}

#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(135-landSize/2) + 0,
	((78/255) * 60) - 30,
	(landSize/2-121) + 150
	>
	}

#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(118-landSize/2) + 0,
	((19/255) * 60) - 30,
	(landSize/2-151) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(127-landSize/2) + 0,
	((45/255) * 60) - 30,
	(landSize/2-140) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(124-landSize/2) + 0,
	((19/255) * 60) - 30,
	(landSize/2-152) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(107-landSize/2) + 0,
	((25/255) * 60) - 30,
	(landSize/2-155) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(111-landSize/2) + 0,
	((24/255) * 60) - 30,
	(landSize/2-151) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(111-landSize/2) + 0,
	((45/255) * 60) - 30,
	(landSize/2-142) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(107-landSize/2) + 0,
	((27/255) * 60) - 30,
	(landSize/2-164) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(101-landSize/2) + 0,
	((36/255) * 60) - 30,
	(landSize/2-171) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(169-landSize/2) + 0,
	((36/255) * 60) - 30,
	(landSize/2-170) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(180-landSize/2) + 0,
	((37/255) * 60) - 30,
	(landSize/2-178) + 150
	>
	}
#declare scaleFactor =  0.7 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(180-landSize/2) + 0,
	((20/255) * 60) - 30,
	(landSize/2-189) + 150
	>
	}

#declare scaleFactor = 0.7 + 0.3*rand(branchSeed)
object {bareTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(187-landSize/2) + 0,
	((22/255) * 60) - 30,
	(landSize/2-192) + 150
	>
	}


#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(199-landSize/2) + 0,
	((24/255) * 60) - 30,
	(-192 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(198-landSize/2) + 0,
	((20/255) * 60) - 30,
	(-198 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(200-landSize/2) + 0,
	((19/255) * 60) - 30,
	(-199 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(205-landSize/2) + 0,
	((22/255) * 60) - 30,
	(-199 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(155-landSize/2) + 0,
	((48/255) * 60) - 30,
	(-144 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(144-landSize/2) + 0,
	((32/255) * 60) - 30,
	(-146 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(135-landSize/2) + 0,
	((22/255) * 60) - 30,
	(-149 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(125-landSize/2) + 0,
	((21/255) * 60) - 30,
	(-153 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(126-landSize/2) + 0,
	((16/255) * 60) - 30,
	(-156 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(118-landSize/2) + 0,
	((18/255) * 60) - 30,
	(-153 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(131-landSize/2) + 0,
	((43/255) * 60) - 30,
	(-141 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(168-landSize/2) + 0,
	((45/255) * 60) - 30,
	(-161 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(162-landSize/2) + 0,
	((27/255) * 60) - 30,
	(-162 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(161-landSize/2) + 0,
	((25/255) * 60) - 30,
	(-164 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(121-landSize/2) + 0,
	((36/255) * 60) - 30,
	(-143 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(122-landSize/2) + 0,
	((24/255) * 60) - 30,
	(-146 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(114-landSize/2) + 0,
	((21/255) * 60) - 30,
	(-150 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(117-landSize/2) + 0,
	((18/255) * 60) - 30,
	(-153 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(111-landSize/2) + 0,
	((32/255) * 60) - 30,
	(-148 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(108-landSize/2) + 0,
	((27/255) * 60) - 30,
	(-166 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(256-landSize/2) + 0,
	((49/255) * 60) - 30,
	(-161 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(256-landSize/2) + 0,
	((52/255) * 60) - 30,
	(-173 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(259-landSize/2) + 0,
	((55/255) * 60) - 30,
	(-157 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(248-landSize/2) + 0,
	((39/255) * 60) - 30,
	(-156 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(287-landSize/2) + 0,
	((69/255) * 60) - 30,
	(-101 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(189-landSize/2) + 0,
	((47/255) * 60) - 30,
	(-179 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(188-landSize/2) + 0,
	((53/255) * 60) - 30,
	(-174 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(193-landSize/2) + 0,
	((67/255) * 60) - 30,
	(-170 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(177-landSize/2) + 0,
	((53/255) * 60) - 30,
	(-169 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(178-landSize/2) + 0,
	((60/255) * 60) - 30,
	(-167 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(184-landSize/2) + 0,
	((71/255) * 60) - 30,
	(-163 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(145-landSize/2) + 0,
	((58/255) * 60) - 30,
	(-127 +landSize/2) + 150
	>
	}
	
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(146-landSize/2) + 0,
	((37/255) * 60) - 30,
	(-137 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(150-landSize/2) + 0,
	((42/255) * 60) - 30,
	(-137 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(152-landSize/2) + 0,
	((40/255) * 60) - 30,
	(-141 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(152-landSize/2) + 0,
	((32/255) * 60) - 30,
	(-146 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(152-landSize/2) + 0,
	((35/255) * 60) - 30,
	(-151 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(155-landSize/2) + 0,
	((47/255) * 60) - 30,
	(-151 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(142-landSize/2) + 0,
	((45/255) * 60) - 30,
	(-138 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.3*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(142-landSize/2) + 0,
	((42/255) * 60) - 30,
	(-140 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.3*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(145-landSize/2) + 0,
	((35/255) * 60) - 30,
	(-143 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(146-landSize/2) + 0,
	((32/255) * 60) - 30,
	(-144 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(146-landSize/2) + 0,
	((30/255) * 60) - 30,
	(-147 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(148-landSize/2) + 0,
	((24/255) * 60) - 30,
	(-153 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(140-landSize/2) + 0,
	((40/255) * 60) - 30,
	(-142 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree2
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(145-landSize/2) + 0,
	((23/255) * 60) - 30,
	(-155 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(108-landSize/2) + 0,
	((27/255) * 60) - 30,
	(-183 +landSize/2) + 150
	>
	}

#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(109-landSize/2) + 0,
	((19/255) * 60) - 30,
	(-192 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(105-landSize/2) + 0,
	((28/255) * 60) - 30,
	(-198 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(109-landSize/2) + 0,
	((32/255) * 60) - 30,
	(-213 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(108-landSize/2) + 0,
	((28/255) * 60) - 30,
	(-173 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(109-landSize/2) + 0,
	((28/255) * 60) - 30,
	(-168 +landSize/2) + 150
	>
	}
#declare scaleFactor = 0.85 + 0.15*rand(branchSeed)
object {greenTree
	scale <scaleFactor,scaleFactor,scaleFactor> rotate <0,3.1415*2*rand(branchSeed),0>
	translate <
	(258-landSize/2) + 0,
	((52/255) * 60) - 30,
	(-175 +landSize/2) + 150
	>
	}
