// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// mountGen2.pov
// Mountain/Landscape Generator, source file for PovRay 3.x
// 5 July 1997, SjG (libelle@webbwerks.com)
//
// Use this to build some funny-looking mountains and landscapes.
// It's not all that realistic, but you can get some decent
// results out of it.
//
// Preferably, render into a large square, e.g., 200x200 or 400x400,
// depending on how much detail you want.
//
// Samuel Goldstein. libelle@webbwerks.com
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare StdCam = camera
	{
	location  <0.01, 0, -8.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.0,  0.0>
	}


#declare liftedRegion = light_source
{
  -1*z
  color red 0.5  green 0.5  blue 0.5
  fade_distance 2
  fade_power 1
}

#declare depressedRegion = light_source
{
  -1*z
  color red -0.25  green -0.25  blue -0.25
  fade_distance 3
  fade_power 1
}

#declare mildDepressedRegion = light_source
{
  -2*z
  color red -0.25  green -0.25  blue -0.25
  fade_distance 2
  fade_power 1
}


#declare tinyPeak = light_source
{
  -0.1*z
  color red 0.5  green 0.5  blue 0.5
  fade_distance .1
  fade_power 2
}

#declare smallPeak = light_source
{
  -0.2*z
  color red 0.3  green 0.3  blue 0.3
  fade_distance .2
  fade_power 1
}

#declare mediumPeak = light_source
{
  -0.2*z
  color red .5  green .5  blue .5
  fade_distance .2
  fade_power 1
}

#declare largePeak = light_source
{
  -0.6*z
  color red 1  green 1  blue 1
  fade_distance .35
  fade_power 0.5
}

#declare roughMap = color_map
				{
				[0 0.3 color Gray80 color Gray80]
				[0.3 1.001 color Gray80 color White]
				}

#declare topMap = color_map
				{
				[0 0.3 color rgbt <0.8,0.8,0.8,1> color rgbt <0.8,0.8,0.8,0.5>]
				[0.3 1.001 color rgbt <0.8,0.8,0.8,0.5> color rgbt <1,1,1,0>]
				}

#declare platMap = color_map
				{
				[0 color rgbt <1,1,1,1>]
				[0.8 color rgbt <0.5,0.5,0.5,0>]
				}


#declare volcanicLandscape = plane
	{z,0
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			bozo
			color_map
				{
				roughMap
				}
			turbulence 3
			scale <0.4,0.4,0.4>
			}
		}
	}

#declare metamorphicLandscape = plane
	{z,0
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			agate
			color_map
				{
				roughMap
				}
			turbulence 0.3
			scale <.5,.1,0.4>
			}
		rotate <0,0,30>
		}
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			bozo
			color_map
				{
				topMap
				}
			turbulence 1
			}
		}
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			bozo
			color_map
				{
				platMap
				}
			turbulence 1
			}
		}
	}
	
#declare meta2Landscape = plane
	{z,0
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			agate
			color_map
				{
				roughMap
				}
			turbulence 0.3
			scale <1,1,1>
			}
		rotate <0,0,30>
		}
	texture{
		finish
			{
			roughness 10
			}
		pigment
			{
			bozo
			color_map
				{
				platMap
				}
			turbulence 1
			}
		}
	}	

#declare Grid80 = texture{finish{ambient .5} pigment{Gray80}}
#declare Grid50 = texture{finish{ambient .5} pigment{Gray50}}
#declare Grid100 = texture{finish{ambient .5} pigment{White}}

#declare AlignmentAxis = union {
cylinder{<-10,-5.0,0>,<10,-5.0,0>,0.02 texture{Grid80}}
cylinder{<-10,-4.5,0>,<10,-4.5,0>,0.02 texture{Grid50}}
cylinder{<-10,-4.0,0>,<10,-4.0,0>,0.02 texture{Grid50}}
cylinder{<-10,-3.5,0>,<10,-3.5,0>,0.02 texture{Grid50}}
cylinder{<-10,-3.0,0>,<10,-3.0,0>,0.02 texture{Grid50}}
cylinder{<-10,-2.5,0>,<10,-2.5,0>,0.02 texture{Grid80}}
cylinder{<-10,-2.0,0>,<10,-2.0,0>,0.02 texture{Grid50}}
cylinder{<-10,-1.5,0>,<10,-1.5,0>,0.02 texture{Grid50}}
cylinder{<-10,-1.0,0>,<10,-1.0,0>,0.02 texture{Grid50}}
cylinder{<-10,-0.5,0>,<10,-0.5,0>,0.02 texture{Grid50}}
cylinder{<-10, 0.0,0>,<10, 0.0,0>,0.02 texture{Grid100}}
cylinder{<-10, 0.5,0>,<10, 0.5,0>,0.02 texture{Grid50}}
cylinder{<-10, 1.0,0>,<10, 1.0,0>,0.02 texture{Grid50}}
cylinder{<-10, 1.5,0>,<10, 1.5,0>,0.02 texture{Grid50}}
cylinder{<-10, 2.0,0>,<10, 2.0,0>,0.02 texture{Grid50}}
cylinder{<-10, 2.5,0>,<10, 2.5,0>,0.02 texture{Grid80}}
cylinder{<-10, 3.0,0>,<10, 3.0,0>,0.02 texture{Grid50}}
cylinder{<-10, 3.5,0>,<10, 3.5,0>,0.02 texture{Grid50}}
cylinder{<-10, 4.0,0>,<10, 4.0,0>,0.02 texture{Grid50}}
cylinder{<-10, 4.5,0>,<10, 4.5,0>,0.02 texture{Grid50}}
cylinder{<-10, 5.0,0>,<10, 5.0,0>,0.02 texture{Grid80}}

cylinder{<-5.0,-10,0>,<-5.0,10,0>,0.02 texture{Grid80}}
cylinder{<-4.5,-10,0>,<-4.5,10,0>,0.02 texture{Grid50}}
cylinder{<-4.0,-10,0>,<-4.0,10,0>,0.02 texture{Grid50}}
cylinder{<-3.5,-10,0>,<-3.5,10,0>,0.02 texture{Grid50}}
cylinder{<-3.0,-10,0>,<-3.0,10,0>,0.02 texture{Grid50}}
cylinder{<-2.5,-10,0>,<-2.5,10,0>,0.02 texture{Grid80}}
cylinder{<-2.0,-10,0>,<-2.0,10,0>,0.02 texture{Grid50}}
cylinder{<-1.5,-10,0>,<-1.5,10,0>,0.02 texture{Grid50}}
cylinder{<-1.0,-10,0>,<-1.0,10,0>,0.02 texture{Grid50}}
cylinder{<-0.5,-10,0>,<-0.5,10,0>,0.02 texture{Grid50}}
cylinder{< 0.0,-10,0>,< 0.0,10,0>,0.02 texture{Grid100}}
cylinder{< 0.5,-10,0>,< 0.5,10,0>,0.02 texture{Grid50}}
cylinder{< 1.0,-10,0>,< 1.0,10,0>,0.02 texture{Grid50}}
cylinder{< 1.5,-10,0>,< 1.5,10,0>,0.02 texture{Grid50}}
cylinder{< 2.0,-10,0>,< 2.0,10,0>,0.02 texture{Grid50}}
cylinder{< 2.5,-10,0>,< 2.5,10,0>,0.02 texture{Grid80}}
cylinder{< 3.0,-10,0>,< 3.0,10,0>,0.02 texture{Grid50}}
cylinder{< 3.5,-10,0>,< 3.5,10,0>,0.02 texture{Grid50}}
cylinder{< 4.0,-10,0>,< 4.0,10,0>,0.02 texture{Grid50}}
cylinder{< 4.5,-10,0>,< 4.5,10,0>,0.02 texture{Grid50}}
cylinder{< 5.0,-10,0>,< 5.0,10,0>,0.02 texture{Grid80}}

}
camera{StdCam}

object{meta2Landscape}
object{largePeak translate <2,0,0>}
object{largePeak translate <1.5,1,0>}
object{largePeak translate <0,3,0>}
object{largePeak translate <4,2.5,0>}

object{largePeak translate <-1,1,0>}
object{largePeak translate <-2.5,-1.5,0>}

object{smallPeak translate <2.25,0.5,0>}
object{smallPeak translate <-2,-0.2,0>}
object{smallPeak translate <4,2.29,0>}
object{smallPeak translate <4.2,2.5,0>}
object{smallPeak translate <4.5,3,0>}

object{depressedRegion translate <0,-2,0>}
object{depressedRegion translate <2,-2,0>}
object{depressedRegion translate <-3,3,0>}
object{depressedRegion translate <-0.5,-0.5,0>}
object{depressedRegion translate <-2.25,.5,0>}
object{mildDepressedRegion translate <2,2.5,0>}

//object{AlignmentAxis translate <0,0,-0.01>}
