#include "Yeuille.inc"
#include "Snake.inc"


sky_sphere {
   pigment {
      bozo
      color_map {
	 [0.000 rgb <1.00,1.00,0.20> ]
	 [0.360 rgb <1.00,0.00,0.00> ]
	 [1.000 rgb <0.00,0.00,0.00> ]
      }
      turbulence 4
      scale <0.1, 3, 0.1>
   }
}


background { White }
#declare camera_location = <5,20,-60>
#declare camera_look_at  = <0,0,0>
#declare camera_angle = 9

#declare ChaudronScale=5

// #declare camera_angle = 6
// #declare camera_look_at  = <0,0,0>
// #declare camera_location = <0,0,-60>


camera {
   location camera_location
   look_at camera_look_at
   
   angle camera_angle
}

light_source {
   <25,50,-100>
   rgb <1,1,0.75>
 //  area_light <1,0,0.5>*5, <0,1,0.5>*5, 5 , 5
}

light_source {
   <-250,500,-30>
   White
  //area_light <20,0,0>, <0,20,0>, 5, 5
}

light_source {
   <0,-500,0>
   Red
 //  area_light <50,0,0>, <0,0,50>, 5, 5
}


#declare R1=seed(1000)
#declare R2=seed(500)
#declare R3=seed(3000)
#declare Proba = 0.2
#declare Max_x = 2
#declare Max_y = 3
#declare Max_z = 2
#declare Max_e = 0.05
#declare Ray = 0.45

#declare i=-Max_x
#while(i <= Max_x)

#declare j=-Max_y
#while ( j <= Max_y )

#declare k=-Max_z
#while ( k <= Max_z )



#if ( rand(R1) < Proba )
object { Yeuille
   scale Ray
   rotate <rand(R2)*360, rand(R2)*360, rand(R2)*360>
   translate <i,j+1,k>
   translate <rand(R3)*2-1, rand(R3)*2-1, rand(R3)*2-1>*Max_e
}
#end

#declare k=k+1
#end

#declare j=j+1
#end

#declare i=i+1
#end

#declare ChaudronHautLiq=0.62
#include "Chaudron.inc"

object { Chaudron
   rotate y*30
   scale ChaudronScale
   translate -y*3 
}


// La Fumee Verte...
sphere {
   <0,0,0>, 1-ChaudronEp
   
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      spherical_mapping
      linear
      turbulence 2
      color_map {
	 [ 0 color rgbt <0.5, 1, 0, 1> ]
	 [ 0.2 color rgbt <0.5, 1, 0, -1> ]
	 [ 1.0 color rgbt <0.75, 1, 0, -1> ]
      }
      samples 10
      scale 0.25
   }
   hollow   
   scale <1,2,1>
   rotate y*180
   scale ChaudronScale
   translate -y*3 
}
 
// La fumee Blanche, sous le chaudron...
sphere {
      <0,0,0>, 1
   
   pigment { color rgbt <1, 1, 1, 1> }
   halo {
      emitting
      spherical_mapping
      linear
      // turbulence 3
      turbulence <0.5,3,0.5>
      color_map {
	 [ 0.0 color rgbt <1,1,1,1> ]
	 [ 0.3 color rgbt <1, 1, 1, -1> ]
	 [ 0.8 color rgbt <1,1,1,1> ]
	 [ 1.0 color rgbt <0, 1, 1, -1> ]
      }
      samples 5
//      scale 
   }
   hollow   
   scale <7/5,1,7/5>*ChaudronScale
   translate -y*3 
}


object {
   Snake
 
   rotate z*15
   translate x*(ChaudronOuv+2)

   rotate y*55
   translate y*(ChaudronOuvHaut*ChaudronScale - 2.53)
}



#declare CandleColor=rgb <0.7,0.85,0.6>
#include "candles.inc"
object{
   #O_Candle()
   scale 1.5
   rotate y*90
   translate y*(ChaudronEpBord*4.1)
   translate x*(ChaudronOuv*ChaudronScale*0.98)
  
//   rotate -y*40
}


#declare CandleColor=rgb <0.85,0.4,0.7>
object{
   #O_SkinyCandle()
   scale 2.3
   translate y*(ChaudronEpBord*4.2)
   translate x*(ChaudronOuv*ChaudronScale)
  
   rotate -y*50
}


// La Paille
#declare PailleScale=1.7
#include "Paille.inc"
object {
   Paille
   
   translate y*1.2
   scale PailleScale
   translate -(ChaudronEpBord*ChaudronScale+PailleScale*PailleTubEp)*x
   rotate -z*20
   translate ChaudronOuv*5*x
   
  rotate y*125
}


#include "Recette.inc"
object {
   Recette
   rotate x*14
   rotate -y*40
   scale 5
   translate -y*3 
}
