
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.2
// Desc: Captain's wife
// Date: 15. august 1997.
// Auth: Anto Matkovic
// email: anto.matkovic@zg.tel.hr
// web page: http://www.geocities.com/SoHo/Studios/7415/


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#include "CONSTS.INC"

//#declare Rad_Quality = Radiosity_Debug
//#declare Rad_Quality = Radiosity_Fast
//#declare Rad_Quality = Radiosity_Normal
//#declare Rad_Quality = Radiosity_2Bounce
//#declare Rad_Quality = Radiosity_Final
//#include "rad_def.inc"

global_settings {
assumed_gamma 2.2

radiosity {
  count 400            // Ensure that we get good, accurate samples
  error_bound 0.25        // And calculate lots of them.  (more important than count)
   gray_threshold 0.31
  distance_maximum 16    // Scene-dependant!
  low_error_factor 0.7     // force many extra samples to be calculated...
   nearest_count 9        // so we can average them together for smoothness
   minimum_reuse 0.002       // get quite tightly into corners
   brightness 3.3           // doesn't really matter.  Not used in final output.
   recursion_limit 1       // Try this = 2, but drop the count to maybe 300}
   }}




#include "cpw_chair.inc"
#include "cpw_desk.inc"
#include "cpw_ograda_rail.inc"
#include "cpw_she.inc"
#include "cpw_desk_lampa.inc"
#include "cpw_lampa.inc"
#include "cpw_frog.inc"


object {stolac rotate <90, 0, 112> translate <-6, 3, 1.805>}
object {stolac translate <-4, 16, 0>}
object {stol translate <-3.7, 10, 0>}





background { color red 0.24 green 0.24 blue 0.29 }

#declare zid = texture { pigment {bozo scale 0.5
colour_map {[ 0 colour rgb <0.88, 0.84, 0.77>]
            [ 0.2 colour rgb <0.92, 0.9, 0.89>]
            [ 0.6 colour rgb <0.95, 0.92, 0.91>]
            [ 1 colour rgb <0.98, 0.95, 0.93>]}}
finish {ambient 0.2 diffuse 0.6 phong 0.6 phong_size 89 }
normal {marble turbulence 1.1 scale 2
normal_map {[0 granite  0.3 scale 0.1]
            [0.12 granite 0.07 scale 0.1]
            [1 granite 0.01 scale 0.1]}}}


 #declare more= texture { pigment { colour rgb < 0.25, 0.25, 0.27>}
 finish {phong 0.8 phong_size 123 reflection 0.1}
 normal { marble 0.7 scale 56
turbulence 1 rotate z*123
normal_map {
        [0 bozo 0.04 scale 0.03]
        [0.3 bozo 0.1 scale 0.03]
         [1 bozo 0.2 scale 0.03]}
        }}



//zid
difference{
box{<24, -60, 40><27, 60, -1> }
box{<23, 0.5, 27><28, 9, -2>}
texture {zid}}


//svijetlo od iza
light_source { 0*x color rgb <0.45, 0.4, 0.35> area_light 0.2, 0.2
  3, 3 adaptive 0 jitter  translate <61, -4.5, 24>}



//srednje svijetlo
light_source { 0*x color rgb <0.81, 0.77, 0.75>  area_light 0.03, 0.03
  3, 3 adaptive 0 jitter translate <-6.2, 6.4, 10.8>}

//svijetlo od mora
light_source {0*x color rgb <0.64, 0.64, 0.7> area_light <21, 21, 21> <-21, -21, -21>
 3, 3 adaptive 0 jitter translate <-1230, 700, 230>}




camera {  sky z*1 up z*1 right <1.33, 0.0, 0.0>
location  <19, -5.6, 21> look_at   <-3.3, 9.3, 7.2> angle 35}


//more
plane {z, - 50 texture {more}}


