
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions




#declare nosac = texture { pigment {bozo turbulence 0.5
colour_map {[0 color rgb<0.2, 0.2, 0.22>]
           [1 color rgb<0.25, 0.25, 0.25>]}  scale 0.09}
finish {specular 0.5 roughness 0.1 brilliance 12 ambient 0.25 diffuse 0.55 }
}


#declare nosac1 = texture { pigment {bozo turbulence 0.5
colour_map {[0 color rgb<0.2, 0.2, 0.22>]
           [1 color rgb<0.25, 0.25, 0.25>]}  scale 0.09}
finish {specular 0.5 roughness 0.1 brilliance 12 ambient 0.25 diffuse 0.55 }
normal {granite 0.15 scale 0.01}}



#declare pldrvostolac1 = texture { pigment {wood turbulence 0.5
colour_map {[0 color rgb<0.6, 0.4, 0.25>]
           [0.3 color rgb<0.78, 0.44, 0.29>]
           [1 color rgb<0.8, 0.5, 0.33>]}  scale 0.09}
finish {
phong 0.7 phong_size 45 ambient 0.25 diffuse 0.55 }

normal {marble 0.2 scale 0.3}}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <40, -40, 22>
}
camera {  sky z*1 up z*1 right <1.33, 0.0, 0.0>
location  <19, -5.6, 17> look_at   <-3.3, 10.7, 6.8> angle 38}





#declare stalak = union {
//nosac okolo
difference{
blob {threshold 0.5
#declare stall = -560
	#while (stall <560 )
sphere {<0, 0, 0>, 1, 1  scale 0.12  translate x*0.5
translate z*4
translate <0, (stall*0.002), (stall*0.007)>
rotate <0,0,(stall * 6)>
  }
		#declare stall = (stall + 1)
	#end }

 cylinder {<0, 0, 8>,<0, 0, 9>, 2 }
texture {nosac}}

//nosac vert
difference{
blob {threshold 0.5
#declare stalll = - 164
	#while (stalll <164 )
sphere {<0, 0, 0>, 1, 1  scale <0.09, 0.09, 0.7> rotate <-5, 0, 0> translate x*0.5
translate z*4
translate <0, (stalll*0.008), (stalll*0.028)>
rotate <0,0,(stalll * 384)>
}
		#declare stalll = (stalll + 1)
	#end }

cylinder {<0, 0, 8>,<0, 0, 9>, 2 }
texture {nosac}}
//poklopac
cylinder {<0, 0, 7.98>,<0, 0, 8.02>, 1.25 texture {nosac1}}
torus{1.25, 0.08 rotate x*90
 translate z*8 texture {nosac1}}

 
}

object {stalak translate <-6.4, 6.4, 0>}









