// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.2
// Desc: Captain's wife
// Date: 15. august 1997.
// Auth: Anto Matkovic
// email: anto.matkovic@zg.tel.hr
// web page: http://www.geocities.com/SoHo/Studios/7415/

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare ograda = texture { pigment {bozo scale 0.5
colour_map {[ 0 colour rgb <0.78, 0.75, 0.69>]
            [ 0.2 colour rgb <0.82, 0.8, 0.77>]
            [ 0.6 colour rgb <0.84, 0.82, 0.78>]
            [ 1 colour rgb <0.86, 0.84, 0.79>]}}
finish {ambient 0.2 diffuse 0.6 phong 0.4 phong_size 89 }
normal {marble turbulence 1.1 scale 2
normal_map {[0 granite  0.3 scale 0.1]
            [0.12 granite 0.07 scale 0.1]
            [1 granite 0.01 scale 0.1]}}}

superellipsoid
{ <0.1, 0.1 > scale <25, 22, 1> translate <12, 0, -1> texture {ograda}}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 0.9062> <-11.1109, 19.0245, 0.9062> <-11.1109, 20.5047, 0.9062> <-11.0664, 20.5493, 0.9062>
		<-11.0712, 18.9751, 0.8515> <-11.1157, 19.0196, 0.8515> <-11.1157, 20.5095, 0.8515> <-11.0712, 20.5541, 0.8515>
		<-11.1500, 18.8963, 0.8308> <-11.1998, 18.9461, 0.8308> <-11.1998, 20.5831, 0.8308> <-11.1500, 20.6329, 0.8308>
		<-11.1589, 18.8874, 0.7771> <-11.2087, 18.9372, 0.7771> <-11.2087, 20.5920, 0.7771> <-11.1589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 0.9062> <-11.0620, 18.9842, 0.9557> <-11.1560, 18.8903, 0.9996> <-11.1357, 18.9105, 1.0404>
		<-11.1109, 19.0245, 0.9062> <-11.1066, 19.0288, 0.9557> <-11.2045, 18.9388, 0.9996> <-11.1842, 18.9590, 1.0404>
		<-11.1109, 20.5047, 0.9062> <-11.1066, 20.5004, 0.9557> <-11.2045, 20.5904, 0.9996> <-11.1842, 20.5702, 1.0404>
		<-11.0664, 20.5493, 0.9062> <-11.0620, 20.5449, 0.9557> <-11.1560, 20.6389, 0.9996> <-11.1357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 0.9062> <-11.0712, 18.9751, 0.8515> <-11.1500, 18.8963, 0.8308> <-11.1589, 18.8874, 0.7771>
		<-11.0218, 18.9353, 0.9062> <-11.0266, 18.9305, 0.8515> <-11.1001, 18.8465, 0.8308> <-11.1090, 18.8376, 0.7771>
		<-9.5415, 18.9353, 0.9062> <-9.5367, 18.9305, 0.8515> <-9.4632, 18.8465, 0.8308> <-9.4543, 18.8376, 0.7771>
		<-9.4970, 18.9799, 0.9062> <-9.4922, 18.9751, 0.8515> <-9.4134, 18.8963, 0.8308> <-9.4045, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 0.9062> <-11.0218, 18.9353, 0.9062> <-9.5415, 18.9353, 0.9062> <-9.4970, 18.9799, 0.9062>
		<-11.0620, 18.9842, 0.9557> <-11.0175, 18.9397, 0.9557> <-9.5459, 18.9397, 0.9557> <-9.5013, 18.9842, 0.9557>
		<-11.1560, 18.8903, 0.9996> <-11.1075, 18.8418, 0.9996> <-9.4559, 18.8418, 0.9996> <-9.4073, 18.8903, 0.9996>
		<-11.1357, 18.9105, 1.0404> <-11.0872, 18.8620, 1.0404> <-9.4761, 18.8620, 1.0404> <-9.4276, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.9799, 0.9062> <-9.4922, 18.9751, 0.8515> <-9.4134, 18.8963, 0.8308> <-9.4045, 18.8874, 0.7771>
		<-9.4524, 19.0245, 0.9062> <-9.4476, 19.0196, 0.8515> <-9.3635, 18.9461, 0.8308> <-9.3546, 18.9372, 0.7771>
		<-9.4524, 20.5047, 0.9062> <-9.4476, 20.5095, 0.8515> <-9.3635, 20.5831, 0.8308> <-9.3546, 20.5920, 0.7771>
		<-9.4970, 20.5493, 0.9062> <-9.4922, 20.5541, 0.8515> <-9.4134, 20.6329, 0.8308> <-9.4045, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.9799, 0.9062> <-9.4524, 19.0245, 0.9062> <-9.4524, 20.5047, 0.9062> <-9.4970, 20.5493, 0.9062>
		<-9.5013, 18.9842, 0.9557> <-9.4567, 19.0288, 0.9557> <-9.4567, 20.5004, 0.9557> <-9.5013, 20.5449, 0.9557>
		<-9.4073, 18.8903, 0.9996> <-9.3588, 18.9388, 0.9996> <-9.3588, 20.5904, 0.9996> <-9.4073, 20.6389, 0.9996>
		<-9.4276, 18.9105, 1.0404> <-9.3791, 18.9590, 1.0404> <-9.3791, 20.5702, 1.0404> <-9.4276, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 20.5493, 0.9062> <-9.4922, 20.5541, 0.8515> <-9.4134, 20.6329, 0.8308> <-9.4045, 20.6418, 0.7771>
		<-9.5415, 20.5939, 0.9062> <-9.5367, 20.5987, 0.8515> <-9.4632, 20.6827, 0.8308> <-9.4543, 20.6916, 0.7771>
		<-11.0218, 20.5939, 0.9062> <-11.0266, 20.5987, 0.8515> <-11.1001, 20.6827, 0.8308> <-11.1090, 20.6916, 0.7771>
		<-11.0664, 20.5493, 0.9062> <-11.0712, 20.5541, 0.8515> <-11.1500, 20.6329, 0.8308> <-11.1589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 20.5493, 0.9062> <-9.5415, 20.5939, 0.9062> <-11.0218, 20.5939, 0.9062> <-11.0664, 20.5493, 0.9062>
		<-9.5013, 20.5449, 0.9557> <-9.5459, 20.5895, 0.9557> <-11.0175, 20.5895, 0.9557> <-11.0620, 20.5449, 0.9557>
		<-9.4073, 20.6389, 0.9996> <-9.4559, 20.6874, 0.9996> <-11.1075, 20.6874, 0.9996> <-11.1560, 20.6389, 0.9996>
		<-9.4276, 20.6187, 1.0404> <-9.4761, 20.6672, 1.0404> <-11.0872, 20.6672, 1.0404> <-11.1357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 18.9105, 1.0404> <-11.0677, 18.9786, 1.1777> <-10.8982, 19.1481, 1.2552> <-10.8269, 19.2193, 1.3892>
		<-11.1842, 18.9590, 1.0404> <-11.1162, 19.0271, 1.1777> <-10.9291, 19.1790, 1.2552> <-10.8579, 19.2503, 1.3892>
		<-11.1842, 20.5702, 1.0404> <-11.1162, 20.5021, 1.1777> <-10.9291, 20.3501, 1.2552> <-10.8579, 20.2789, 1.3892>
		<-11.1357, 20.6187, 1.0404> <-11.0677, 20.5506, 1.1777> <-10.8982, 20.3811, 1.2552> <-10.8269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 18.9105, 1.0404> <-11.0872, 18.8620, 1.0404> <-9.4761, 18.8620, 1.0404> <-9.4276, 18.9105, 1.0404>
		<-11.0677, 18.9786, 1.1777> <-11.0192, 18.9301, 1.1777> <-9.5442, 18.9301, 1.1777> <-9.4957, 18.9786, 1.1777>
		<-10.8982, 19.1481, 1.2552> <-10.8672, 19.1171, 1.2552> <-9.6961, 19.1171, 1.2552> <-9.6652, 19.1481, 1.2552>
		<-10.8269, 19.2193, 1.3892> <-10.7959, 19.1884, 1.3892> <-9.7674, 19.1884, 1.3892> <-9.7364, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 18.9105, 1.0404> <-9.3791, 18.9590, 1.0404> <-9.3791, 20.5702, 1.0404> <-9.4276, 20.6187, 1.0404>
		<-9.4957, 18.9786, 1.1777> <-9.4471, 19.0271, 1.1777> <-9.4471, 20.5021, 1.1777> <-9.4957, 20.5506, 1.1777>
		<-9.6652, 19.1481, 1.2552> <-9.6342, 19.1790, 1.2552> <-9.6342, 20.3501, 1.2552> <-9.6652, 20.3811, 1.2552>
		<-9.7364, 19.2193, 1.3892> <-9.7054, 19.2503, 1.3892> <-9.7054, 20.2789, 1.3892> <-9.7364, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 20.6187, 1.0404> <-9.4761, 20.6672, 1.0404> <-11.0872, 20.6672, 1.0404> <-11.1357, 20.6187, 1.0404>
		<-9.4957, 20.5506, 1.1777> <-9.5442, 20.5991, 1.1777> <-11.0192, 20.5991, 1.1777> <-11.0677, 20.5506, 1.1777>
		<-9.6652, 20.3811, 1.2552> <-9.6961, 20.4121, 1.2552> <-10.8672, 20.4121, 1.2552> <-10.8982, 20.3811, 1.2552>
		<-9.7364, 20.3098, 1.3892> <-9.7674, 20.3408, 1.3892> <-10.7959, 20.3408, 1.3892> <-10.8269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 19.2193, 1.3892> <-10.8079, 19.2383, 1.4249> <-10.8837, 19.1626, 1.4698> <-10.8837, 19.1626, 1.5144>
		<-10.8579, 19.2503, 1.3892> <-10.8389, 19.2693, 1.4249> <-10.9179, 19.1968, 1.4698> <-10.9179, 19.1968, 1.5144>
		<-10.8579, 20.2789, 1.3892> <-10.8389, 20.2599, 1.4249> <-10.9179, 20.3324, 1.4698> <-10.9179, 20.3324, 1.5144>
		<-10.8269, 20.3098, 1.3892> <-10.8079, 20.2909, 1.4249> <-10.8837, 20.3666, 1.4698> <-10.8837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 19.2193, 1.3892> <-10.7959, 19.1884, 1.3892> <-9.7674, 19.1884, 1.3892> <-9.7364, 19.2193, 1.3892>
		<-10.8079, 19.2383, 1.4249> <-10.7770, 19.2073, 1.4249> <-9.7863, 19.2073, 1.4249> <-9.7554, 19.2383, 1.4249>
		<-10.8837, 19.1626, 1.4698> <-10.8495, 19.1284, 1.4698> <-9.7138, 19.1284, 1.4698> <-9.6796, 19.1626, 1.4698>
		<-10.8837, 19.1626, 1.5144> <-10.8495, 19.1284, 1.5144> <-9.7138, 19.1284, 1.5144> <-9.6796, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 19.2193, 1.3892> <-9.7054, 19.2503, 1.3892> <-9.7054, 20.2789, 1.3892> <-9.7364, 20.3098, 1.3892>
		<-9.7554, 19.2383, 1.4249> <-9.7244, 19.2693, 1.4249> <-9.7244, 20.2599, 1.4249> <-9.7554, 20.2909, 1.4249>
		<-9.6796, 19.1626, 1.4698> <-9.6455, 19.1968, 1.4698> <-9.6455, 20.3324, 1.4698> <-9.6796, 20.3666, 1.4698>
		<-9.6796, 19.1626, 1.5144> <-9.6455, 19.1968, 1.5144> <-9.6455, 20.3324, 1.5144> <-9.6796, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 20.3098, 1.3892> <-9.7674, 20.3408, 1.3892> <-10.7959, 20.3408, 1.3892> <-10.8269, 20.3098, 1.3892>
		<-9.7554, 20.2909, 1.4249> <-9.7863, 20.3218, 1.4249> <-10.7770, 20.3218, 1.4249> <-10.8079, 20.2909, 1.4249>
		<-9.6796, 20.3666, 1.4698> <-9.7138, 20.4008, 1.4698> <-10.8495, 20.4008, 1.4698> <-10.8837, 20.3666, 1.4698>
		<-9.6796, 20.3666, 1.5144> <-9.7138, 20.4008, 1.5144> <-10.8495, 20.4008, 1.5144> <-10.8837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 19.1626, 1.5144> <-10.8837, 19.1626, 1.5613> <-10.8121, 19.2341, 1.6066> <-10.8269, 19.2193, 1.6486>
		<-10.9179, 19.1968, 1.5144> <-10.9179, 19.1968, 1.5613> <-10.8431, 19.2651, 1.6066> <-10.8579, 19.2503, 1.6486>
		<-10.9179, 20.3324, 1.5144> <-10.9179, 20.3324, 1.5613> <-10.8431, 20.2641, 1.6066> <-10.8579, 20.2789, 1.6486>
		<-10.8837, 20.3666, 1.5144> <-10.8837, 20.3666, 1.5613> <-10.8121, 20.2950, 1.6066> <-10.8269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 19.1626, 1.5144> <-10.8495, 19.1284, 1.5144> <-9.7138, 19.1284, 1.5144> <-9.6796, 19.1626, 1.5144>
		<-10.8837, 19.1626, 1.5613> <-10.8495, 19.1284, 1.5613> <-9.7138, 19.1284, 1.5613> <-9.6796, 19.1626, 1.5613>
		<-10.8121, 19.2341, 1.6066> <-10.7812, 19.2032, 1.6066> <-9.7822, 19.2032, 1.6066> <-9.7512, 19.2341, 1.6066>
		<-10.8269, 19.2193, 1.6486> <-10.7959, 19.1884, 1.6486> <-9.7674, 19.1884, 1.6486> <-9.7364, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 19.1626, 1.5144> <-9.6455, 19.1968, 1.5144> <-9.6455, 20.3324, 1.5144> <-9.6796, 20.3666, 1.5144>
		<-9.6796, 19.1626, 1.5613> <-9.6455, 19.1968, 1.5613> <-9.6455, 20.3324, 1.5613> <-9.6796, 20.3666, 1.5613>
		<-9.7512, 19.2341, 1.6066> <-9.7202, 19.2651, 1.6066> <-9.7202, 20.2641, 1.6066> <-9.7512, 20.2950, 1.6066>
		<-9.7364, 19.2193, 1.6486> <-9.7054, 19.2503, 1.6486> <-9.7054, 20.2789, 1.6486> <-9.7364, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 20.3666, 1.5144> <-9.7138, 20.4008, 1.5144> <-10.8495, 20.4008, 1.5144> <-10.8837, 20.3666, 1.5144>
		<-9.6796, 20.3666, 1.5613> <-9.7138, 20.4008, 1.5613> <-10.8495, 20.4008, 1.5613> <-10.8837, 20.3666, 1.5613>
		<-9.7512, 20.2950, 1.6066> <-9.7822, 20.3260, 1.6066> <-10.7812, 20.3260, 1.6066> <-10.8121, 20.2950, 1.6066>
		<-9.7364, 20.3098, 1.6486> <-9.7674, 20.3408, 1.6486> <-10.7959, 20.3408, 1.6486> <-10.8269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 19.2193, 1.6486> <-10.8754, 19.1709, 1.7862> <-11.0172, 19.0290, 1.8960> <-11.0664, 18.9799, 2.0332>
		<-10.8579, 19.2503, 1.6486> <-10.9063, 19.2018, 1.7862> <-11.0618, 19.0736, 1.8960> <-11.1109, 19.0245, 2.0332>
		<-10.8579, 20.2789, 1.6486> <-10.9063, 20.3273, 1.7862> <-11.0618, 20.4556, 1.8960> <-11.1109, 20.5047, 2.0332>
		<-10.8269, 20.3098, 1.6486> <-10.8754, 20.3583, 1.7862> <-11.0172, 20.5002, 1.8960> <-11.0664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 19.2193, 1.6486> <-10.7959, 19.1884, 1.6486> <-9.7674, 19.1884, 1.6486> <-9.7364, 19.2193, 1.6486>
		<-10.8754, 19.1709, 1.7862> <-10.8444, 19.1399, 1.7862> <-9.7189, 19.1399, 1.7862> <-9.6880, 19.1709, 1.7862>
		<-11.0172, 19.0290, 1.8960> <-10.9727, 18.9844, 1.8960> <-9.5907, 18.9844, 1.8960> <-9.5461, 19.0290, 1.8960>
		<-11.0664, 18.9799, 2.0332> <-11.0218, 18.9353, 2.0332> <-9.5415, 18.9353, 2.0332> <-9.4970, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 19.2193, 1.6486> <-9.7054, 19.2503, 1.6486> <-9.7054, 20.2789, 1.6486> <-9.7364, 20.3098, 1.6486>
		<-9.6880, 19.1709, 1.7862> <-9.6570, 19.2018, 1.7862> <-9.6570, 20.3273, 1.7862> <-9.6880, 20.3583, 1.7862>
		<-9.5461, 19.0290, 1.8960> <-9.5015, 19.0736, 1.8960> <-9.5015, 20.4556, 1.8960> <-9.5461, 20.5002, 1.8960>
		<-9.4970, 18.9799, 2.0332> <-9.4524, 19.0245, 2.0332> <-9.4524, 20.5047, 2.0332> <-9.4970, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 20.3098, 1.6486> <-9.7674, 20.3408, 1.6486> <-10.7959, 20.3408, 1.6486> <-10.8269, 20.3098, 1.6486>
		<-9.6880, 20.3583, 1.7862> <-9.7189, 20.3893, 1.7862> <-10.8444, 20.3893, 1.7862> <-10.8754, 20.3583, 1.7862>
		<-9.5461, 20.5002, 1.8960> <-9.5907, 20.5447, 1.8960> <-10.9727, 20.5447, 1.8960> <-11.0172, 20.5002, 1.8960>
		<-9.4970, 20.5493, 2.0332> <-9.5415, 20.5939, 2.0332> <-11.0218, 20.5939, 2.0332> <-11.0664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 2.0332> <-11.0930, 18.9533, 2.1074> <-11.0932, 18.9531, 2.2382> <-11.0641, 18.9822, 2.3104>
		<-11.1109, 19.0245, 2.0332> <-11.1375, 18.9979, 2.1074> <-11.1376, 18.9975, 2.2382> <-11.1085, 19.0266, 2.3104>
		<-11.1109, 20.5047, 2.0332> <-11.1375, 20.5313, 2.1074> <-11.1376, 20.5317, 2.2382> <-11.1085, 20.5025, 2.3104>
		<-11.0664, 20.5493, 2.0332> <-11.0930, 20.5759, 2.1074> <-11.0932, 20.5761, 2.2382> <-11.0641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 18.9799, 2.0332> <-11.0218, 18.9353, 2.0332> <-9.5415, 18.9353, 2.0332> <-9.4970, 18.9799, 2.0332>
		<-11.0930, 18.9533, 2.1074> <-11.0484, 18.9087, 2.1074> <-9.5149, 18.9087, 2.1074> <-9.4704, 18.9533, 2.1074>
		<-11.0932, 18.9531, 2.2382> <-11.0488, 18.9086, 2.2382> <-9.5146, 18.9086, 2.2382> <-9.4701, 18.9531, 2.2382>
		<-11.0641, 18.9822, 2.3104> <-11.0196, 18.9378, 2.3104> <-9.5437, 18.9378, 2.3104> <-9.4993, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.9799, 2.0332> <-9.4524, 19.0245, 2.0332> <-9.4524, 20.5047, 2.0332> <-9.4970, 20.5493, 2.0332>
		<-9.4704, 18.9533, 2.1074> <-9.4258, 18.9979, 2.1074> <-9.4258, 20.5313, 2.1074> <-9.4704, 20.5759, 2.1074>
		<-9.4701, 18.9531, 2.2382> <-9.4257, 18.9975, 2.2382> <-9.4257, 20.5317, 2.2382> <-9.4701, 20.5761, 2.2382>
		<-9.4993, 18.9822, 2.3104> <-9.4548, 19.0266, 2.3104> <-9.4548, 20.5025, 2.3104> <-9.4993, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 20.5493, 2.0332> <-9.5415, 20.5939, 2.0332> <-11.0218, 20.5939, 2.0332> <-11.0664, 20.5493, 2.0332>
		<-9.4704, 20.5759, 2.1074> <-9.5149, 20.6204, 2.1074> <-11.0484, 20.6204, 2.1074> <-11.0930, 20.5759, 2.1074>
		<-9.4701, 20.5761, 2.2382> <-9.5146, 20.6206, 2.2382> <-11.0488, 20.6206, 2.2382> <-11.0932, 20.5761, 2.2382>
		<-9.4993, 20.5470, 2.3104> <-9.5437, 20.5914, 2.3104> <-11.0196, 20.5914, 2.3104> <-11.0641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 18.9822, 2.3104> <-10.9801, 19.0661, 2.5186> <-10.7843, 19.2620, 2.7154> <-10.7056, 19.3406, 2.9276>
		<-11.1085, 19.0266, 2.3104> <-11.0246, 19.1106, 2.5186> <-10.8084, 19.2860, 2.7154> <-10.7297, 19.3647, 2.9276>
		<-11.1085, 20.5025, 2.3104> <-11.0246, 20.4186, 2.5186> <-10.8084, 20.2431, 2.7154> <-10.7297, 20.1645, 2.9276>
		<-11.0641, 20.5470, 2.3104> <-10.9801, 20.4630, 2.5186> <-10.7843, 20.2672, 2.7154> <-10.7056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 18.9822, 2.3104> <-11.0196, 18.9378, 2.3104> <-9.5437, 18.9378, 2.3104> <-9.4993, 18.9822, 2.3104>
		<-10.9801, 19.0661, 2.5186> <-10.9357, 19.0217, 2.5186> <-9.6277, 19.0217, 2.5186> <-9.5832, 19.0661, 2.5186>
		<-10.7843, 19.2620, 2.7154> <-10.7602, 19.2379, 2.7154> <-9.8031, 19.2379, 2.7154> <-9.7790, 19.2620, 2.7154>
		<-10.7056, 19.3406, 2.9276> <-10.6815, 19.3165, 2.9276> <-9.8818, 19.3165, 2.9276> <-9.8577, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 18.9822, 2.3104> <-9.4548, 19.0266, 2.3104> <-9.4548, 20.5025, 2.3104> <-9.4993, 20.5470, 2.3104>
		<-9.5832, 19.0661, 2.5186> <-9.5388, 19.1106, 2.5186> <-9.5388, 20.4186, 2.5186> <-9.5832, 20.4630, 2.5186>
		<-9.7790, 19.2620, 2.7154> <-9.7550, 19.2860, 2.7154> <-9.7550, 20.2431, 2.7154> <-9.7790, 20.2672, 2.7154>
		<-9.8577, 19.3406, 2.9276> <-9.8336, 19.3647, 2.9276> <-9.8336, 20.1645, 2.9276> <-9.8577, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 20.5470, 2.3104> <-9.5437, 20.5914, 2.3104> <-11.0196, 20.5914, 2.3104> <-11.0641, 20.5470, 2.3104>
		<-9.5832, 20.4630, 2.5186> <-9.6277, 20.5075, 2.5186> <-10.9357, 20.5075, 2.5186> <-10.9801, 20.4630, 2.5186>
		<-9.7790, 20.2672, 2.7154> <-9.8031, 20.2913, 2.7154> <-10.7602, 20.2913, 2.7154> <-10.7843, 20.2672, 2.7154>
		<-9.8577, 20.1885, 2.9276> <-9.8818, 20.2126, 2.9276> <-10.6815, 20.2126, 2.9276> <-10.7056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 19.3406, 2.9276> <-10.6887, 19.3576, 2.9732> <-10.7889, 19.2574, 3.0012> <-10.7889, 19.2574, 3.0528>
		<-10.7297, 19.3647, 2.9276> <-10.7128, 19.3816, 2.9732> <-10.8177, 19.2862, 3.0012> <-10.8177, 19.2862, 3.0528>
		<-10.7297, 20.1645, 2.9276> <-10.7128, 20.1475, 2.9732> <-10.8177, 20.2430, 3.0012> <-10.8177, 20.2430, 3.0528>
		<-10.7056, 20.1885, 2.9276> <-10.6887, 20.1716, 2.9732> <-10.7889, 20.2718, 3.0012> <-10.7889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 19.3406, 2.9276> <-10.6815, 19.3165, 2.9276> <-9.8818, 19.3165, 2.9276> <-9.8577, 19.3406, 2.9276>
		<-10.6887, 19.3576, 2.9732> <-10.6646, 19.3335, 2.9732> <-9.8987, 19.3335, 2.9732> <-9.8746, 19.3576, 2.9732>
		<-10.7889, 19.2574, 3.0012> <-10.7601, 19.2286, 3.0012> <-9.8033, 19.2286, 3.0012> <-9.7745, 19.2574, 3.0012>
		<-10.7889, 19.2574, 3.0528> <-10.7601, 19.2286, 3.0528> <-9.8033, 19.2286, 3.0528> <-9.7745, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 19.3406, 2.9276> <-9.8336, 19.3647, 2.9276> <-9.8336, 20.1645, 2.9276> <-9.8577, 20.1885, 2.9276>
		<-9.8746, 19.3576, 2.9732> <-9.8506, 19.3816, 2.9732> <-9.8506, 20.1475, 2.9732> <-9.8746, 20.1716, 2.9732>
		<-9.7745, 19.2574, 3.0012> <-9.7456, 19.2862, 3.0012> <-9.7456, 20.2430, 3.0012> <-9.7745, 20.2718, 3.0012>
		<-9.7745, 19.2574, 3.0528> <-9.7456, 19.2862, 3.0528> <-9.7456, 20.2430, 3.0528> <-9.7745, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 20.1885, 2.9276> <-9.8818, 20.2126, 2.9276> <-10.6815, 20.2126, 2.9276> <-10.7056, 20.1885, 2.9276>
		<-9.8746, 20.1716, 2.9732> <-9.8987, 20.1957, 2.9732> <-10.6646, 20.1957, 2.9732> <-10.6887, 20.1716, 2.9732>
		<-9.7745, 20.2718, 3.0012> <-9.8033, 20.3006, 3.0012> <-10.7601, 20.3006, 3.0012> <-10.7889, 20.2718, 3.0012>
		<-9.7745, 20.2718, 3.0528> <-9.8033, 20.3006, 3.0528> <-10.7601, 20.3006, 3.0528> <-10.7889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 19.2574, 3.0528> <-10.7889, 19.2574, 3.1044> <-10.6862, 19.3600, 3.1344> <-10.7056, 19.3406, 3.1780>
		<-10.8177, 19.2862, 3.0528> <-10.8177, 19.2862, 3.1044> <-10.7103, 19.3841, 3.1344> <-10.7297, 19.3647, 3.1780>
		<-10.8177, 20.2430, 3.0528> <-10.8177, 20.2430, 3.1044> <-10.7103, 20.1451, 3.1344> <-10.7297, 20.1645, 3.1780>
		<-10.7889, 20.2718, 3.0528> <-10.7889, 20.2718, 3.1044> <-10.6862, 20.1691, 3.1344> <-10.7056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 19.2574, 3.0528> <-10.7601, 19.2286, 3.0528> <-9.8033, 19.2286, 3.0528> <-9.7745, 19.2574, 3.0528>
		<-10.7889, 19.2574, 3.1044> <-10.7601, 19.2286, 3.1044> <-9.8033, 19.2286, 3.1044> <-9.7745, 19.2574, 3.1044>
		<-10.6862, 19.3600, 3.1344> <-10.6621, 19.3359, 3.1344> <-9.9012, 19.3359, 3.1344> <-9.8771, 19.3600, 3.1344>
		<-10.7056, 19.3406, 3.1780> <-10.6815, 19.3165, 3.1780> <-9.8818, 19.3165, 3.1780> <-9.8577, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 19.2574, 3.0528> <-9.7456, 19.2862, 3.0528> <-9.7456, 20.2430, 3.0528> <-9.7745, 20.2718, 3.0528>
		<-9.7745, 19.2574, 3.1044> <-9.7456, 19.2862, 3.1044> <-9.7456, 20.2430, 3.1044> <-9.7745, 20.2718, 3.1044>
		<-9.8771, 19.3600, 3.1344> <-9.8530, 19.3841, 3.1344> <-9.8530, 20.1451, 3.1344> <-9.8771, 20.1691, 3.1344>
		<-9.8577, 19.3406, 3.1780> <-9.8336, 19.3647, 3.1780> <-9.8336, 20.1645, 3.1780> <-9.8577, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 20.2718, 3.0528> <-9.8033, 20.3006, 3.0528> <-10.7601, 20.3006, 3.0528> <-10.7889, 20.2718, 3.0528>
		<-9.7745, 20.2718, 3.1044> <-9.8033, 20.3006, 3.1044> <-10.7601, 20.3006, 3.1044> <-10.7889, 20.2718, 3.1044>
		<-9.8771, 20.1691, 3.1344> <-9.9012, 20.1932, 3.1344> <-10.6621, 20.1932, 3.1344> <-10.6862, 20.1691, 3.1344>
		<-9.8577, 20.1885, 3.1780> <-9.8818, 20.2126, 3.1780> <-10.6815, 20.2126, 3.1780> <-10.7056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 19.3406, 3.1780> <-10.7438, 19.3024, 3.2640> <-10.8610, 19.1852, 3.2738> <-10.9161, 19.1302, 3.3390>
		<-10.7297, 19.3647, 3.1780> <-10.7679, 19.3265, 3.2640> <-10.8971, 19.2212, 3.2738> <-10.9521, 19.1662, 3.3390>
		<-10.7297, 20.1645, 3.1780> <-10.7679, 20.2027, 3.2640> <-10.8971, 20.3079, 3.2738> <-10.9521, 20.3629, 3.3390>
		<-10.7056, 20.1885, 3.1780> <-10.7438, 20.2267, 3.2640> <-10.8610, 20.3440, 3.2738> <-10.9161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 19.3406, 3.1780> <-10.6815, 19.3165, 3.1780> <-9.8818, 19.3165, 3.1780> <-9.8577, 19.3406, 3.1780>
		<-10.7438, 19.3024, 3.2640> <-10.7197, 19.2784, 3.2640> <-9.8436, 19.2784, 3.2640> <-9.8195, 19.3024, 3.2640>
		<-10.8610, 19.1852, 3.2738> <-10.8250, 19.1492, 3.2738> <-9.7383, 19.1492, 3.2738> <-9.7023, 19.1852, 3.2738>
		<-10.9161, 19.1302, 3.3390> <-10.8800, 19.0942, 3.3390> <-9.6833, 19.0942, 3.3390> <-9.6473, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 19.3406, 3.1780> <-9.8336, 19.3647, 3.1780> <-9.8336, 20.1645, 3.1780> <-9.8577, 20.1885, 3.1780>
		<-9.8195, 19.3024, 3.2640> <-9.7954, 19.3265, 3.2640> <-9.7954, 20.2027, 3.2640> <-9.8195, 20.2267, 3.2640>
		<-9.7023, 19.1852, 3.2738> <-9.6663, 19.2212, 3.2738> <-9.6663, 20.3079, 3.2738> <-9.7023, 20.3440, 3.2738>
		<-9.6473, 19.1302, 3.3390> <-9.6112, 19.1662, 3.3390> <-9.6112, 20.3629, 3.3390> <-9.6473, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 20.1885, 3.1780> <-9.8818, 20.2126, 3.1780> <-10.6815, 20.2126, 3.1780> <-10.7056, 20.1885, 3.1780>
		<-9.8195, 20.2267, 3.2640> <-9.8436, 20.2508, 3.2640> <-10.7197, 20.2508, 3.2640> <-10.7438, 20.2267, 3.2640>
		<-9.7023, 20.3440, 3.2738> <-9.7383, 20.3800, 3.2738> <-10.8250, 20.3800, 3.2738> <-10.8610, 20.3440, 3.2738>
		<-9.6473, 20.3990, 3.3390> <-9.6833, 20.4350, 3.3390> <-10.8800, 20.4350, 3.3390> <-10.9161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 19.1302, 3.3390> <-10.9416, 19.1046, 3.3693> <-10.9797, 19.0665, 3.4419> <-10.9623, 19.0839, 3.4821>
		<-10.9521, 19.1662, 3.3390> <-10.9777, 19.1406, 3.3693> <-11.0184, 19.1052, 3.4419> <-11.0010, 19.1226, 3.4821>
		<-10.9521, 20.3629, 3.3390> <-10.9777, 20.3885, 3.3693> <-11.0184, 20.4240, 3.4419> <-11.0010, 20.4066, 3.4821>
		<-10.9161, 20.3990, 3.3390> <-10.9416, 20.4246, 3.3693> <-10.9797, 20.4627, 3.4419> <-10.9623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 19.1302, 3.3390> <-10.8800, 19.0942, 3.3390> <-9.6833, 19.0942, 3.3390> <-9.6473, 19.1302, 3.3390>
		<-10.9416, 19.1046, 3.3693> <-10.9056, 19.0686, 3.3693> <-9.6577, 19.0686, 3.3693> <-9.6217, 19.1046, 3.3693>
		<-10.9797, 19.0665, 3.4419> <-10.9411, 19.0279, 3.4419> <-9.6223, 19.0279, 3.4419> <-9.5836, 19.0665, 3.4419>
		<-10.9623, 19.0839, 3.4821> <-10.9236, 19.0453, 3.4821> <-9.6397, 19.0453, 3.4821> <-9.6010, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 19.1302, 3.3390> <-9.6112, 19.1662, 3.3390> <-9.6112, 20.3629, 3.3390> <-9.6473, 20.3990, 3.3390>
		<-9.6217, 19.1046, 3.3693> <-9.5857, 19.1406, 3.3693> <-9.5857, 20.3885, 3.3693> <-9.6217, 20.4246, 3.3693>
		<-9.5836, 19.0665, 3.4419> <-9.5449, 19.1052, 3.4419> <-9.5449, 20.4240, 3.4419> <-9.5836, 20.4627, 3.4419>
		<-9.6010, 19.0839, 3.4821> <-9.5624, 19.1226, 3.4821> <-9.5624, 20.4066, 3.4821> <-9.6010, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 20.3990, 3.3390> <-9.6833, 20.4350, 3.3390> <-10.8800, 20.4350, 3.3390> <-10.9161, 20.3990, 3.3390>
		<-9.6217, 20.4246, 3.3693> <-9.6577, 20.4606, 3.3693> <-10.9056, 20.4606, 3.3693> <-10.9416, 20.4246, 3.3693>
		<-9.5836, 20.4627, 3.4419> <-9.6223, 20.5013, 3.4419> <-10.9411, 20.5013, 3.4419> <-10.9797, 20.4627, 3.4419>
		<-9.6010, 20.4452, 3.4821> <-9.6397, 20.4839, 3.4821> <-10.9236, 20.4839, 3.4821> <-10.9623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 19.0839, 3.4821> <-10.9163, 19.1300, 3.5884> <-10.7961, 19.2502, 3.6567> <-10.7380, 19.3083, 3.7504>
		<-11.0010, 19.1226, 3.4821> <-10.9550, 19.1686, 3.5884> <-10.8220, 19.2761, 3.6567> <-10.7639, 19.3342, 3.7504>
		<-11.0010, 20.4066, 3.4821> <-10.9550, 20.3606, 3.5884> <-10.8220, 20.2531, 3.6567> <-10.7639, 20.1950, 3.7504>
		<-10.9623, 20.4452, 3.4821> <-10.9163, 20.3992, 3.5884> <-10.7961, 20.2790, 3.6567> <-10.7380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 19.0839, 3.4821> <-10.9236, 19.0453, 3.4821> <-9.6397, 19.0453, 3.4821> <-9.6010, 19.0839, 3.4821>
		<-10.9163, 19.1300, 3.5884> <-10.8776, 19.0913, 3.5884> <-9.6857, 19.0913, 3.5884> <-9.6470, 19.1300, 3.5884>
		<-10.7961, 19.2502, 3.6567> <-10.7702, 19.2242, 3.6567> <-9.7932, 19.2242, 3.6567> <-9.7672, 19.2502, 3.6567>
		<-10.7380, 19.3083, 3.7504> <-10.7121, 19.2823, 3.7504> <-9.8513, 19.2823, 3.7504> <-9.8253, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 19.0839, 3.4821> <-9.5624, 19.1226, 3.4821> <-9.5624, 20.4066, 3.4821> <-9.6010, 20.4452, 3.4821>
		<-9.6470, 19.1300, 3.5884> <-9.6084, 19.1686, 3.5884> <-9.6084, 20.3606, 3.5884> <-9.6470, 20.3992, 3.5884>
		<-9.7672, 19.2502, 3.6567> <-9.7413, 19.2761, 3.6567> <-9.7413, 20.2531, 3.6567> <-9.7672, 20.2790, 3.6567>
		<-9.8253, 19.3083, 3.7504> <-9.7994, 19.3342, 3.7504> <-9.7994, 20.1950, 3.7504> <-9.8253, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 20.4452, 3.4821> <-9.6397, 20.4839, 3.4821> <-10.9236, 20.4839, 3.4821> <-10.9623, 20.4452, 3.4821>
		<-9.6470, 20.3992, 3.5884> <-9.6857, 20.4379, 3.5884> <-10.8776, 20.4379, 3.5884> <-10.9163, 20.3992, 3.5884>
		<-9.7672, 20.2790, 3.6567> <-9.7932, 20.3049, 3.6567> <-10.7702, 20.3049, 3.6567> <-10.7961, 20.2790, 3.6567>
		<-9.8253, 20.2209, 3.7504> <-9.8513, 20.2468, 3.7504> <-10.7121, 20.2468, 3.7504> <-10.7380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 19.3083, 3.7504> <-10.6964, 19.3498, 3.8175> <-10.6527, 19.3935, 3.9241> <-10.6352, 19.4110, 4.0098>
		<-10.7639, 19.3342, 3.7504> <-10.7223, 19.3757, 3.8175> <-10.6728, 19.4136, 3.9241> <-10.6553, 19.4311, 4.0098>
		<-10.7639, 20.1950, 3.7504> <-10.7223, 20.1534, 3.8175> <-10.6728, 20.1156, 3.9241> <-10.6553, 20.0981, 4.0098>
		<-10.7380, 20.2209, 3.7504> <-10.6964, 20.1793, 3.8175> <-10.6527, 20.1356, 3.9241> <-10.6352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 19.3083, 3.7504> <-10.7121, 19.2823, 3.7504> <-9.8513, 19.2823, 3.7504> <-9.8253, 19.3083, 3.7504>
		<-10.6964, 19.3498, 3.8175> <-10.6705, 19.3239, 3.8175> <-9.8928, 19.3239, 3.8175> <-9.8669, 19.3498, 3.8175>
		<-10.6527, 19.3935, 3.9241> <-10.6326, 19.3734, 3.9241> <-9.9307, 19.3734, 3.9241> <-9.9106, 19.3935, 3.9241>
		<-10.6352, 19.4110, 4.0098> <-10.6152, 19.3909, 4.0098> <-9.9482, 19.3909, 4.0098> <-9.9281, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 19.3083, 3.7504> <-9.7994, 19.3342, 3.7504> <-9.7994, 20.1950, 3.7504> <-9.8253, 20.2209, 3.7504>
		<-9.8669, 19.3498, 3.8175> <-9.8410, 19.3757, 3.8175> <-9.8410, 20.1534, 3.8175> <-9.8669, 20.1793, 3.8175>
		<-9.9106, 19.3935, 3.9241> <-9.8905, 19.4136, 3.9241> <-9.8905, 20.1156, 3.9241> <-9.9106, 20.1356, 3.9241>
		<-9.9281, 19.4110, 4.0098> <-9.9080, 19.4311, 4.0098> <-9.9080, 20.0981, 4.0098> <-9.9281, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 20.2209, 3.7504> <-9.8513, 20.2468, 3.7504> <-10.7121, 20.2468, 3.7504> <-10.7380, 20.2209, 3.7504>
		<-9.8669, 20.1793, 3.8175> <-9.8928, 20.2053, 3.8175> <-10.6705, 20.2053, 3.8175> <-10.6964, 20.1793, 3.8175>
		<-9.9106, 20.1356, 3.9241> <-9.9307, 20.1557, 3.9241> <-10.6326, 20.1557, 3.9241> <-10.6527, 20.1356, 3.9241>
		<-9.9281, 20.1182, 4.0098> <-9.9482, 20.1383, 4.0098> <-10.6152, 20.1383, 4.0098> <-10.6352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 19.4110, 4.0098> <-10.6168, 19.4294, 4.1002> <-10.6221, 19.4242, 4.2288> <-10.6213, 19.4250, 4.3229>
		<-10.6553, 19.4311, 4.0098> <-10.6369, 19.4495, 4.1002> <-10.6413, 19.4435, 4.2288> <-10.6405, 19.4443, 4.3229>
		<-10.6553, 20.0981, 4.0098> <-10.6369, 20.0797, 4.1002> <-10.6413, 20.0857, 4.2288> <-10.6405, 20.0849, 4.3229>
		<-10.6352, 20.1182, 4.0098> <-10.6168, 20.0997, 4.1002> <-10.6221, 20.1050, 4.2288> <-10.6213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 19.4110, 4.0098> <-10.6152, 19.3909, 4.0098> <-9.9482, 19.3909, 4.0098> <-9.9281, 19.4110, 4.0098>
		<-10.6168, 19.4294, 4.1002> <-10.5967, 19.4094, 4.1002> <-9.9666, 19.4094, 4.1002> <-9.9465, 19.4294, 4.1002>
		<-10.6221, 19.4242, 4.2288> <-10.6028, 19.4049, 4.2288> <-9.9606, 19.4049, 4.2288> <-9.9413, 19.4242, 4.2288>
		<-10.6213, 19.4250, 4.3229> <-10.6020, 19.4057, 4.3229> <-9.9614, 19.4057, 4.3229> <-9.9421, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 19.4110, 4.0098> <-9.9080, 19.4311, 4.0098> <-9.9080, 20.0981, 4.0098> <-9.9281, 20.1182, 4.0098>
		<-9.9465, 19.4294, 4.1002> <-9.9264, 19.4495, 4.1002> <-9.9264, 20.0797, 4.1002> <-9.9465, 20.0997, 4.1002>
		<-9.9413, 19.4242, 4.2288> <-9.9220, 19.4435, 4.2288> <-9.9220, 20.0857, 4.2288> <-9.9413, 20.1050, 4.2288>
		<-9.9421, 19.4250, 4.3229> <-9.9228, 19.4443, 4.3229> <-9.9228, 20.0849, 4.3229> <-9.9421, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 20.1182, 4.0098> <-9.9482, 20.1383, 4.0098> <-10.6152, 20.1383, 4.0098> <-10.6352, 20.1182, 4.0098>
		<-9.9465, 20.0997, 4.1002> <-9.9666, 20.1198, 4.1002> <-10.5967, 20.1198, 4.1002> <-10.6168, 20.0997, 4.1002>
		<-9.9413, 20.1050, 4.2288> <-9.9606, 20.1243, 4.2288> <-10.6028, 20.1243, 4.2288> <-10.6221, 20.1050, 4.2288>
		<-9.9421, 20.1042, 4.3229> <-9.9614, 20.1235, 4.3229> <-10.6020, 20.1235, 4.3229> <-10.6213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 19.4250, 4.3229> <-10.6179, 19.4284, 4.7283> <-10.6197, 19.4265, 5.2689> <-10.6213, 19.4250, 5.6744>
		<-10.6405, 19.4443, 4.3229> <-10.6371, 19.4477, 4.7283> <-10.6390, 19.4458, 5.2689> <-10.6405, 19.4443, 5.6744>
		<-10.6405, 20.0849, 4.3229> <-10.6371, 20.0815, 4.7283> <-10.6390, 20.0834, 5.2689> <-10.6405, 20.0849, 5.6744>
		<-10.6213, 20.1042, 4.3229> <-10.6179, 20.1008, 4.7283> <-10.6197, 20.1027, 5.2689> <-10.6213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 19.4250, 4.3229> <-10.6020, 19.4057, 4.3229> <-9.9614, 19.4057, 4.3229> <-9.9421, 19.4250, 4.3229>
		<-10.6179, 19.4284, 4.7283> <-10.5986, 19.4091, 4.7283> <-9.9648, 19.4091, 4.7283> <-9.9455, 19.4284, 4.7283>
		<-10.6197, 19.4265, 5.2689> <-10.6004, 19.4072, 5.2689> <-9.9629, 19.4072, 5.2689> <-9.9436, 19.4265, 5.2689>
		<-10.6213, 19.4250, 5.6744> <-10.6020, 19.4057, 5.6744> <-9.9614, 19.4057, 5.6744> <-9.9421, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 19.4250, 4.3229> <-9.9228, 19.4443, 4.3229> <-9.9228, 20.0849, 4.3229> <-9.9421, 20.1042, 4.3229>
		<-9.9455, 19.4284, 4.7283> <-9.9262, 19.4477, 4.7283> <-9.9262, 20.0815, 4.7283> <-9.9455, 20.1008, 4.7283>
		<-9.9436, 19.4265, 5.2689> <-9.9243, 19.4458, 5.2689> <-9.9243, 20.0834, 5.2689> <-9.9436, 20.1027, 5.2689>
		<-9.9421, 19.4250, 5.6744> <-9.9228, 19.4443, 5.6744> <-9.9228, 20.0849, 5.6744> <-9.9421, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 20.1042, 4.3229> <-9.9614, 20.1235, 4.3229> <-10.6020, 20.1235, 4.3229> <-10.6213, 20.1042, 4.3229>
		<-9.9455, 20.1008, 4.7283> <-9.9648, 20.1201, 4.7283> <-10.5986, 20.1201, 4.7283> <-10.6179, 20.1008, 4.7283>
		<-9.9436, 20.1027, 5.2689> <-9.9629, 20.1220, 5.2689> <-10.6004, 20.1220, 5.2689> <-10.6197, 20.1027, 5.2689>
		<-9.9421, 20.1042, 5.6744> <-9.9614, 20.1235, 5.6744> <-10.6020, 20.1235, 5.6744> <-10.6213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 19.4250, 5.6744> <-10.6225, 19.4237, 6.0073> <-10.6172, 19.4290, 6.4517> <-10.6305, 19.4157, 6.7841>
		<-10.6405, 19.4443, 5.6744> <-10.6418, 19.4430, 6.0073> <-10.6371, 19.4488, 6.4517> <-10.6503, 19.4355, 6.7841>
		<-10.6405, 20.0849, 5.6744> <-10.6418, 20.0861, 6.0073> <-10.6371, 20.0804, 6.4517> <-10.6503, 20.0936, 6.7841>
		<-10.6213, 20.1042, 5.6744> <-10.6225, 20.1054, 6.0073> <-10.6172, 20.1002, 6.4517> <-10.6305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 19.4250, 5.6744> <-10.6020, 19.4057, 5.6744> <-9.9614, 19.4057, 5.6744> <-9.9421, 19.4250, 5.6744>
		<-10.6225, 19.4237, 6.0073> <-10.6032, 19.4044, 6.0073> <-9.9601, 19.4044, 6.0073> <-9.9408, 19.4237, 6.0073>
		<-10.6172, 19.4290, 6.4517> <-10.5974, 19.4092, 6.4517> <-9.9659, 19.4092, 6.4517> <-9.9461, 19.4290, 6.4517>
		<-10.6305, 19.4157, 6.7841> <-10.6107, 19.3959, 6.7841> <-9.9526, 19.3959, 6.7841> <-9.9328, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 19.4250, 5.6744> <-9.9228, 19.4443, 5.6744> <-9.9228, 20.0849, 5.6744> <-9.9421, 20.1042, 5.6744>
		<-9.9408, 19.4237, 6.0073> <-9.9215, 19.4430, 6.0073> <-9.9215, 20.0861, 6.0073> <-9.9408, 20.1054, 6.0073>
		<-9.9461, 19.4290, 6.4517> <-9.9263, 19.4488, 6.4517> <-9.9263, 20.0804, 6.4517> <-9.9461, 20.1002, 6.4517>
		<-9.9328, 19.4157, 6.7841> <-9.9130, 19.4355, 6.7841> <-9.9130, 20.0936, 6.7841> <-9.9328, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 20.1042, 5.6744> <-9.9614, 20.1235, 5.6744> <-10.6020, 20.1235, 5.6744> <-10.6213, 20.1042, 5.6744>
		<-9.9408, 20.1054, 6.0073> <-9.9601, 20.1247, 6.0073> <-10.6032, 20.1247, 6.0073> <-10.6225, 20.1054, 6.0073>
		<-9.9461, 20.1002, 6.4517> <-9.9659, 20.1200, 6.4517> <-10.5974, 20.1200, 6.4517> <-10.6172, 20.1002, 6.4517>
		<-9.9328, 20.1134, 6.7841> <-9.9526, 20.1333, 6.7841> <-10.6107, 20.1333, 6.7841> <-10.6305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 19.4157, 6.7841> <-10.6325, 19.4137, 6.8341> <-10.6449, 19.4013, 6.9079> <-10.6718, 19.3745, 6.9405>
		<-10.6503, 19.4355, 6.7841> <-10.6523, 19.4336, 6.8341> <-10.6671, 19.4235, 6.9079> <-10.6940, 19.3966, 6.9405>
		<-10.6503, 20.0936, 6.7841> <-10.6523, 20.0956, 6.8341> <-10.6671, 20.1057, 6.9079> <-10.6940, 20.1326, 6.9405>
		<-10.6305, 20.1134, 6.7841> <-10.6325, 20.1154, 6.8341> <-10.6449, 20.1278, 6.9079> <-10.6718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 19.4157, 6.7841> <-10.6107, 19.3959, 6.7841> <-9.9526, 19.3959, 6.7841> <-9.9328, 19.4157, 6.7841>
		<-10.6325, 19.4137, 6.8341> <-10.6127, 19.3939, 6.8341> <-9.9506, 19.3939, 6.8341> <-9.9308, 19.4137, 6.8341>
		<-10.6449, 19.4013, 6.9079> <-10.6228, 19.3792, 6.9079> <-9.9406, 19.3792, 6.9079> <-9.9184, 19.4013, 6.9079>
		<-10.6718, 19.3745, 6.9405> <-10.6496, 19.3523, 6.9405> <-9.9137, 19.3523, 6.9405> <-9.8915, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 19.4157, 6.7841> <-9.9130, 19.4355, 6.7841> <-9.9130, 20.0936, 6.7841> <-9.9328, 20.1134, 6.7841>
		<-9.9308, 19.4137, 6.8341> <-9.9110, 19.4336, 6.8341> <-9.9110, 20.0956, 6.8341> <-9.9308, 20.1154, 6.8341>
		<-9.9184, 19.4013, 6.9079> <-9.8962, 19.4235, 6.9079> <-9.8962, 20.1057, 6.9079> <-9.9184, 20.1278, 6.9079>
		<-9.8915, 19.3745, 6.9405> <-9.8694, 19.3966, 6.9405> <-9.8694, 20.1326, 6.9405> <-9.8915, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 20.1134, 6.7841> <-9.9526, 20.1333, 6.7841> <-10.6107, 20.1333, 6.7841> <-10.6305, 20.1134, 6.7841>
		<-9.9308, 20.1154, 6.8341> <-9.9506, 20.1352, 6.8341> <-10.6127, 20.1352, 6.8341> <-10.6325, 20.1154, 6.8341>
		<-9.9184, 20.1278, 6.9079> <-9.9406, 20.1500, 6.9079> <-10.6228, 20.1500, 6.9079> <-10.6449, 20.1278, 6.9079>
		<-9.8915, 20.1547, 6.9405> <-9.9137, 20.1769, 6.9405> <-10.6496, 20.1769, 6.9405> <-10.6718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 19.3745, 6.9405> <-10.7339, 19.3123, 7.0160> <-10.8620, 19.1842, 7.0331> <-10.9114, 19.1348, 7.1255>
		<-10.6940, 19.3966, 6.9405> <-10.7561, 19.3345, 7.0160> <-10.8978, 19.2200, 7.0331> <-10.9472, 19.1706, 7.1255>
		<-10.6940, 20.1326, 6.9405> <-10.7561, 20.1947, 7.0160> <-10.8978, 20.3092, 7.0331> <-10.9472, 20.3586, 7.1255>
		<-10.6718, 20.1547, 6.9405> <-10.7339, 20.2168, 7.0160> <-10.8620, 20.3449, 7.0331> <-10.9114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 19.3745, 6.9405> <-10.6496, 19.3523, 6.9405> <-9.9137, 19.3523, 6.9405> <-9.8915, 19.3745, 6.9405>
		<-10.7339, 19.3123, 7.0160> <-10.7117, 19.2902, 7.0160> <-9.8516, 19.2902, 7.0160> <-9.8294, 19.3123, 7.0160>
		<-10.8620, 19.1842, 7.0331> <-10.8262, 19.1485, 7.0331> <-9.7371, 19.1485, 7.0331> <-9.7013, 19.1842, 7.0331>
		<-10.9114, 19.1348, 7.1255> <-10.8757, 19.0990, 7.1255> <-9.6877, 19.0990, 7.1255> <-9.6519, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 19.3745, 6.9405> <-9.8694, 19.3966, 6.9405> <-9.8694, 20.1326, 6.9405> <-9.8915, 20.1547, 6.9405>
		<-9.8294, 19.3123, 7.0160> <-9.8073, 19.3345, 7.0160> <-9.8073, 20.1947, 7.0160> <-9.8294, 20.2168, 7.0160>
		<-9.7013, 19.1842, 7.0331> <-9.6655, 19.2200, 7.0331> <-9.6655, 20.3092, 7.0331> <-9.7013, 20.3449, 7.0331>
		<-9.6519, 19.1348, 7.1255> <-9.6161, 19.1706, 7.1255> <-9.6161, 20.3586, 7.1255> <-9.6519, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 20.1547, 6.9405> <-9.9137, 20.1769, 6.9405> <-10.6496, 20.1769, 6.9405> <-10.6718, 20.1547, 6.9405>
		<-9.8294, 20.2168, 7.0160> <-9.8516, 20.2390, 7.0160> <-10.7117, 20.2390, 7.0160> <-10.7339, 20.2168, 7.0160>
		<-9.7013, 20.3449, 7.0331> <-9.7371, 20.3807, 7.0331> <-10.8262, 20.3807, 7.0331> <-10.8620, 20.3449, 7.0331>
		<-9.6519, 20.3944, 7.1255> <-9.6877, 20.4301, 7.1255> <-10.8757, 20.4301, 7.1255> <-10.9114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 19.1348, 7.1255> <-10.9319, 19.1143, 7.1638> <-10.8316, 19.2146, 7.1912> <-10.8316, 19.2146, 7.2393>
		<-10.9472, 19.1706, 7.1255> <-10.9677, 19.1501, 7.1638> <-10.8629, 19.2459, 7.1912> <-10.8629, 19.2459, 7.2393>
		<-10.9472, 20.3586, 7.1255> <-10.9677, 20.3791, 7.1638> <-10.8629, 20.2833, 7.1912> <-10.8629, 20.2833, 7.2393>
		<-10.9114, 20.3944, 7.1255> <-10.9319, 20.4149, 7.1638> <-10.8316, 20.3146, 7.1912> <-10.8316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 19.1348, 7.1255> <-10.8757, 19.0990, 7.1255> <-9.6877, 19.0990, 7.1255> <-9.6519, 19.1348, 7.1255>
		<-10.9319, 19.1143, 7.1638> <-10.8962, 19.0785, 7.1638> <-9.6671, 19.0785, 7.1638> <-9.6314, 19.1143, 7.1638>
		<-10.8316, 19.2146, 7.1912> <-10.8004, 19.1834, 7.1912> <-9.7629, 19.1834, 7.1912> <-9.7317, 19.2146, 7.1912>
		<-10.8316, 19.2146, 7.2393> <-10.8004, 19.1834, 7.2393> <-9.7629, 19.1834, 7.2393> <-9.7317, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 19.1348, 7.1255> <-9.6161, 19.1706, 7.1255> <-9.6161, 20.3586, 7.1255> <-9.6519, 20.3944, 7.1255>
		<-9.6314, 19.1143, 7.1638> <-9.5956, 19.1501, 7.1638> <-9.5956, 20.3791, 7.1638> <-9.6314, 20.4149, 7.1638>
		<-9.7317, 19.2146, 7.1912> <-9.7005, 19.2459, 7.1912> <-9.7005, 20.2833, 7.1912> <-9.7317, 20.3146, 7.1912>
		<-9.7317, 19.2146, 7.2393> <-9.7005, 19.2459, 7.2393> <-9.7005, 20.2833, 7.2393> <-9.7317, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 20.3944, 7.1255> <-9.6877, 20.4301, 7.1255> <-10.8757, 20.4301, 7.1255> <-10.9114, 20.3944, 7.1255>
		<-9.6314, 20.4149, 7.1638> <-9.6671, 20.4506, 7.1638> <-10.8962, 20.4506, 7.1638> <-10.9319, 20.4149, 7.1638>
		<-9.7317, 20.3146, 7.1912> <-9.7629, 20.3458, 7.1912> <-10.8004, 20.3458, 7.1912> <-10.8316, 20.3146, 7.1912>
		<-9.7317, 20.3146, 7.2393> <-9.7629, 20.3458, 7.2393> <-10.8004, 20.3458, 7.2393> <-10.8316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 19.2146, 7.2393> <-10.8316, 19.2146, 7.2905> <-10.9054, 19.1408, 7.3169> <-10.9114, 19.1348, 7.3673>
		<-10.8629, 19.2459, 7.2393> <-10.8629, 19.2459, 7.2905> <-10.9412, 19.1766, 7.3169> <-10.9472, 19.1706, 7.3673>
		<-10.8629, 20.2833, 7.2393> <-10.8629, 20.2833, 7.2905> <-10.9412, 20.3526, 7.3169> <-10.9472, 20.3586, 7.3673>
		<-10.8316, 20.3146, 7.2393> <-10.8316, 20.3146, 7.2905> <-10.9054, 20.3883, 7.3169> <-10.9114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 19.2146, 7.2393> <-10.8004, 19.1834, 7.2393> <-9.7629, 19.1834, 7.2393> <-9.7317, 19.2146, 7.2393>
		<-10.8316, 19.2146, 7.2905> <-10.8004, 19.1834, 7.2905> <-9.7629, 19.1834, 7.2905> <-9.7317, 19.2146, 7.2905>
		<-10.9054, 19.1408, 7.3169> <-10.8696, 19.1051, 7.3169> <-9.6937, 19.1051, 7.3169> <-9.6579, 19.1408, 7.3169>
		<-10.9114, 19.1348, 7.3673> <-10.8757, 19.0990, 7.3673> <-9.6877, 19.0990, 7.3673> <-9.6519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 19.2146, 7.2393> <-9.7005, 19.2459, 7.2393> <-9.7005, 20.2833, 7.2393> <-9.7317, 20.3146, 7.2393>
		<-9.7317, 19.2146, 7.2905> <-9.7005, 19.2459, 7.2905> <-9.7005, 20.2833, 7.2905> <-9.7317, 20.3146, 7.2905>
		<-9.6579, 19.1408, 7.3169> <-9.6222, 19.1766, 7.3169> <-9.6222, 20.3526, 7.3169> <-9.6579, 20.3883, 7.3169>
		<-9.6519, 19.1348, 7.3673> <-9.6161, 19.1706, 7.3673> <-9.6161, 20.3586, 7.3673> <-9.6519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 20.3146, 7.2393> <-9.7629, 20.3458, 7.2393> <-10.8004, 20.3458, 7.2393> <-10.8316, 20.3146, 7.2393>
		<-9.7317, 20.3146, 7.2905> <-9.7629, 20.3458, 7.2905> <-10.8004, 20.3458, 7.2905> <-10.8316, 20.3146, 7.2905>
		<-9.6579, 20.3883, 7.3169> <-9.6937, 20.4241, 7.3169> <-10.8696, 20.4241, 7.3169> <-10.9054, 20.3883, 7.3169>
		<-9.6519, 20.3944, 7.3673> <-9.6877, 20.4301, 7.3673> <-10.8757, 20.4301, 7.3673> <-10.9114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 19.1348, 7.9080> <-10.9472, 19.1706, 7.9080> <-10.9472, 20.3586, 7.9080> <-10.9114, 20.3944, 7.9080>
		<-10.9114, 19.1348, 7.7458> <-10.9472, 19.1706, 7.7458> <-10.9472, 20.3586, 7.7458> <-10.9114, 20.3944, 7.7458>
		<-10.9305, 19.1157, 7.5273> <-10.9663, 19.1515, 7.5273> <-10.9663, 20.3777, 7.5273> <-10.9305, 20.4134, 7.5273>
		<-10.9114, 19.1348, 7.3673> <-10.9472, 19.1706, 7.3673> <-10.9472, 20.3586, 7.3673> <-10.9114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 19.1348, 7.9080> <-10.9114, 19.1348, 7.7458> <-10.9305, 19.1157, 7.5273> <-10.9114, 19.1348, 7.3673>
		<-10.8757, 19.0990, 7.9080> <-10.8757, 19.0990, 7.7458> <-10.8947, 19.0800, 7.5273> <-10.8757, 19.0990, 7.3673>
		<-9.6877, 19.0990, 7.9080> <-9.6877, 19.0990, 7.7458> <-9.6686, 19.0800, 7.5273> <-9.6877, 19.0990, 7.3673>
		<-9.6519, 19.1348, 7.9080> <-9.6519, 19.1348, 7.7458> <-9.6328, 19.1157, 7.5273> <-9.6519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 19.1348, 7.9080> <-9.6519, 19.1348, 7.7458> <-9.6328, 19.1157, 7.5273> <-9.6519, 19.1348, 7.3673>
		<-9.6161, 19.1706, 7.9080> <-9.6161, 19.1706, 7.7458> <-9.5970, 19.1515, 7.5273> <-9.6161, 19.1706, 7.3673>
		<-9.6161, 20.3586, 7.9080> <-9.6161, 20.3586, 7.7458> <-9.5970, 20.3777, 7.5273> <-9.6161, 20.3586, 7.3673>
		<-9.6519, 20.3944, 7.9080> <-9.6519, 20.3944, 7.7458> <-9.6328, 20.4134, 7.5273> <-9.6519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 20.3944, 7.9080> <-9.6519, 20.3944, 7.7458> <-9.6328, 20.4134, 7.5273> <-9.6519, 20.3944, 7.3673>
		<-9.6877, 20.4301, 7.9080> <-9.6877, 20.4301, 7.7458> <-9.6686, 20.4492, 7.5273> <-9.6877, 20.4301, 7.3673>
		<-10.8757, 20.4301, 7.9080> <-10.8757, 20.4301, 7.7458> <-10.8947, 20.4492, 7.5273> <-10.8757, 20.4301, 7.3673>
		<-10.9114, 20.3944, 7.9080> <-10.9114, 20.3944, 7.7458> <-10.9305, 20.4134, 7.5273> <-10.9114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 18.8874, 0.7771> <-11.2087, 18.9372, 0.7771> <-11.2087, 20.5920, 0.7771> <-11.1589, 20.6418, 0.7771>
		<-11.1796, 18.8666, 0.6520> <-11.2294, 18.9164, 0.6520> <-11.2294, 20.6127, 0.6520> <-11.1796, 20.6626, 0.6520>
		<-11.1589, 18.8874, 0.4772> <-11.2087, 18.9372, 0.4772> <-11.2087, 20.5920, 0.4772> <-11.1589, 20.6418, 0.4772>
		<-11.1589, 18.8874, 0.3486> <-11.2087, 18.9372, 0.3486> <-11.2087, 20.5920, 0.3486> <-11.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 18.8874, 0.7771> <-11.1796, 18.8666, 0.6520> <-11.1589, 18.8874, 0.4772> <-11.1589, 18.8874, 0.3486>
		<-11.1090, 18.8376, 0.7771> <-11.1298, 18.8168, 0.6520> <-11.1090, 18.8376, 0.4772> <-11.1090, 18.8376, 0.3486>
		<-9.4543, 18.8376, 0.7771> <-9.4335, 18.8168, 0.6520> <-9.4543, 18.8376, 0.4772> <-9.4543, 18.8376, 0.3486>
		<-9.4045, 18.8874, 0.7771> <-9.3837, 18.8666, 0.6520> <-9.4045, 18.8874, 0.4772> <-9.4045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 18.8874, 0.7771> <-9.3837, 18.8666, 0.6520> <-9.4045, 18.8874, 0.4772> <-9.4045, 18.8874, 0.3486>
		<-9.3546, 18.9372, 0.7771> <-9.3339, 18.9164, 0.6520> <-9.3546, 18.9372, 0.4772> <-9.3546, 18.9372, 0.3486>
		<-9.3546, 20.5920, 0.7771> <-9.3339, 20.6127, 0.6520> <-9.3546, 20.5920, 0.4772> <-9.3546, 20.5920, 0.3486>
		<-9.4045, 20.6418, 0.7771> <-9.3837, 20.6626, 0.6520> <-9.4045, 20.6418, 0.4772> <-9.4045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 20.6418, 0.7771> <-9.3837, 20.6626, 0.6520> <-9.4045, 20.6418, 0.4772> <-9.4045, 20.6418, 0.3486>
		<-9.4543, 20.6916, 0.7771> <-9.4335, 20.7124, 0.6520> <-9.4543, 20.6916, 0.4772> <-9.4543, 20.6916, 0.3486>
		<-11.1090, 20.6916, 0.7771> <-11.1298, 20.7124, 0.6520> <-11.1090, 20.6916, 0.4772> <-11.1090, 20.6916, 0.3486>
		<-11.1589, 20.6418, 0.7771> <-11.1796, 20.6626, 0.6520> <-11.1589, 20.6418, 0.4772> <-11.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 18.8874, -0.0618> <-11.1589, 18.8874, 0.0613> <-11.1589, 18.8874, 0.2255> <-11.1589, 18.8874, 0.3486>
		<-11.2087, 18.9372, -0.0618> <-11.2087, 18.9372, 0.0613> <-11.2087, 18.9372, 0.2255> <-11.2087, 18.9372, 0.3486>
		<-11.2087, 20.5920, -0.0618> <-11.2087, 20.5920, 0.0613> <-11.2087, 20.5920, 0.2255> <-11.2087, 20.5920, 0.3486>
		<-11.1589, 20.6418, -0.0618> <-11.1589, 20.6418, 0.0613> <-11.1589, 20.6418, 0.2255> <-11.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 18.8874, -0.0618> <-11.1090, 18.8376, -0.0618> <-9.4543, 18.8376, -0.0618> <-9.4045, 18.8874, -0.0618>
		<-11.1589, 18.8874, 0.0613> <-11.1090, 18.8376, 0.0613> <-9.4543, 18.8376, 0.0613> <-9.4045, 18.8874, 0.0613>
		<-11.1589, 18.8874, 0.2255> <-11.1090, 18.8376, 0.2255> <-9.4543, 18.8376, 0.2255> <-9.4045, 18.8874, 0.2255>
		<-11.1589, 18.8874, 0.3486> <-11.1090, 18.8376, 0.3486> <-9.4543, 18.8376, 0.3486> <-9.4045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 18.8874, -0.0618> <-9.3546, 18.9372, -0.0618> <-9.3546, 20.5920, -0.0618> <-9.4045, 20.6418, -0.0618>
		<-9.4045, 18.8874, 0.0613> <-9.3546, 18.9372, 0.0613> <-9.3546, 20.5920, 0.0613> <-9.4045, 20.6418, 0.0613>
		<-9.4045, 18.8874, 0.2255> <-9.3546, 18.9372, 0.2255> <-9.3546, 20.5920, 0.2255> <-9.4045, 20.6418, 0.2255>
		<-9.4045, 18.8874, 0.3486> <-9.3546, 18.9372, 0.3486> <-9.3546, 20.5920, 0.3486> <-9.4045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 20.6418, -0.0618> <-9.4543, 20.6916, -0.0618> <-11.1090, 20.6916, -0.0618> <-11.1589, 20.6418, -0.0618>
		<-9.4045, 20.6418, 0.0613> <-9.4543, 20.6916, 0.0613> <-11.1090, 20.6916, 0.0613> <-11.1589, 20.6418, 0.0613>
		<-9.4045, 20.6418, 0.2255> <-9.4543, 20.6916, 0.2255> <-11.1090, 20.6916, 0.2255> <-11.1589, 20.6418, 0.2255>
		<-9.4045, 20.6418, 0.3486> <-9.4543, 20.6916, 0.3486> <-11.1090, 20.6916, 0.3486> <-11.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9580, -0.3264, 8.1902> <-9.0271, -0.3264, 8.1689> <-9.1466, -0.3264, 8.1784> <-9.1883, -0.3264, 8.1193>
		<-8.9580, -5.8634, 8.1902> <-9.0271, -5.8634, 8.1689> <-9.1466, -5.9225, 8.1784> <-9.1883, -5.9225, 8.1193>
		<-8.9580, -13.2462, 8.1902> <-9.0271, -13.3052, 8.1689> <-9.1400, -13.3426, 8.1877> <-9.1883, -13.3839, 8.1193>
		<-8.9580, -18.7832, 8.1902> <-9.0271, -18.8422, 8.1689> <-9.1400, -18.9386, 8.1877> <-9.1883, -18.9799, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9580, -0.3264, 8.1902> <-8.9580, 5.3497, 8.1902> <-8.9580, 12.9177, 8.1902> <-8.9580, 18.5938, 8.1902>
		<-9.0271, -0.3264, 8.1689> <-9.0271, 5.3497, 8.1689> <-9.0271, 12.9768, 8.1689> <-9.0271, 18.6528, 8.1689>
		<-9.1466, -0.3264, 8.1784> <-9.1466, 5.4087, 8.1784> <-9.1400, 13.0142, 8.1877> <-9.1400, 18.7493, 8.1877>
		<-9.1883, -0.3264, 8.1193> <-9.1883, 5.4087, 8.1193> <-9.1883, 13.0555, 8.1193> <-9.1883, 18.7906, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9580, -0.3264, 8.1902> <-8.9580, -5.8634, 8.1902> <-8.9580, -13.2462, 8.1902> <-8.9580, -18.7832, 8.1902>
		<-8.9572, -0.3264, 8.2606> <-8.9572, -5.8634, 8.2606> <-8.9572, -13.2455, 8.2606> <-8.9572, -18.7826, 8.2606>
		<-8.9562, -0.3264, 8.3545> <-8.9562, -5.8628, 8.3545> <-8.9562, -13.2453, 8.3545> <-8.9562, -18.7817, 8.3545>
		<-8.9554, -0.3264, 8.4249> <-8.9554, -5.8628, 8.4249> <-8.9554, -13.2447, 8.4249> <-8.9554, -18.7810, 8.4249>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9580, -0.3264, 8.1902> <-8.9572, -0.3264, 8.2606> <-8.9562, -0.3264, 8.3545> <-8.9554, -0.3264, 8.4249>
		<-8.9580, 5.3497, 8.1902> <-8.9572, 5.3497, 8.2606> <-8.9562, 5.3490, 8.3545> <-8.9554, 5.3490, 8.4249>
		<-8.9580, 12.9177, 8.1902> <-8.9572, 12.9171, 8.2606> <-8.9562, 12.9169, 8.3545> <-8.9554, 12.9162, 8.4249>
		<-8.9580, 18.5938, 8.1902> <-8.9572, 18.5932, 8.2606> <-8.9562, 18.5923, 8.3545> <-8.9554, 18.5917, 8.4249>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9554, -0.3264, 8.4249> <-8.9554, -5.8628, 8.4249> <-8.9554, -13.2447, 8.4249> <-8.9554, -18.7810, 8.4249>
		<-8.8731, -0.3264, 8.4493> <-8.8731, -5.8628, 8.4493> <-8.8731, -13.1744, 8.4493> <-8.8731, -18.7108, 8.4493>
		<-8.6918, -0.3264, 8.4211> <-8.6918, -5.7925, 8.4211> <-8.6949, -13.0925, 8.3968> <-8.6949, -18.5586, 8.3968>
		<-8.6810, -0.3264, 8.5063> <-8.6810, -5.7925, 8.5063> <-8.6810, -13.0806, 8.5063> <-8.6810, -18.5467, 8.5063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9554, -0.3264, 8.4249> <-8.8731, -0.3264, 8.4493> <-8.6918, -0.3264, 8.4211> <-8.6810, -0.3264, 8.5063>
		<-8.9554, 5.3490, 8.4249> <-8.8731, 5.3490, 8.4493> <-8.6918, 5.2787, 8.4211> <-8.6810, 5.2787, 8.5063>
		<-8.9554, 12.9162, 8.4249> <-8.8731, 12.8459, 8.4493> <-8.6949, 12.7641, 8.3968> <-8.6810, 12.7522, 8.5063>
		<-8.9554, 18.5917, 8.4249> <-8.8731, 18.5214, 8.4493> <-8.6949, 18.3692, 8.3968> <-8.6810, 18.3573, 8.5063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6810, -0.3264, 8.5063> <-8.6810, -5.7925, 8.5063> <-8.6810, -13.0806, 8.5063> <-8.6810, -18.5467, 8.5063>
		<-8.6642, -0.3264, 8.6389> <-8.6642, -5.7925, 8.6389> <-8.6629, -13.0652, 8.6489> <-8.6629, -18.5313, 8.6489>
		<-8.7886, -0.3264, 8.8167> <-8.7886, -5.8474, 8.8167> <-8.8000, -13.1273, 8.8253> <-8.8000, -18.6484, 8.8253>
		<-8.8955, -0.3264, 8.8969> <-8.8955, -5.8474, 8.8969> <-8.8955, -13.2088, 8.8969> <-8.8955, -18.7299, 8.8969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6810, -0.3264, 8.5063> <-8.6642, -0.3264, 8.6389> <-8.7886, -0.3264, 8.8167> <-8.8955, -0.3264, 8.8969>
		<-8.6810, 5.2787, 8.5063> <-8.6642, 5.2787, 8.6389> <-8.7886, 5.3337, 8.8167> <-8.8955, 5.3337, 8.8969>
		<-8.6810, 12.7522, 8.5063> <-8.6629, 12.7368, 8.6489> <-8.8000, 12.7989, 8.8253> <-8.8955, 12.8804, 8.8969>
		<-8.6810, 18.3573, 8.5063> <-8.6629, 18.3419, 8.6489> <-8.8000, 18.4590, 8.8253> <-8.8955, 18.5405, 8.8969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8955, -0.3264, 8.8969> <-8.8955, -5.8474, 8.8969> <-8.8955, -13.2088, 8.8969> <-8.8955, -18.7299, 8.8969>
		<-9.0045, -0.3264, 8.9787> <-9.0045, -5.8474, 8.9787> <-9.0126, -13.3088, 8.9848> <-9.0126, -18.8298, 8.9848>
		<-9.2021, -0.3264, 8.9900> <-9.2021, -5.9608, 8.9900> <-9.2034, -13.3584, 8.9901> <-9.2034, -18.9928, 8.9901>
		<-9.3380, -0.3264, 8.9994> <-9.3380, -5.9608, 8.9994> <-9.3380, -13.4733, 8.9994> <-9.3380, -19.1077, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8955, -0.3264, 8.8969> <-9.0045, -0.3264, 8.9787> <-9.2021, -0.3264, 8.9900> <-9.3380, -0.3264, 8.9994>
		<-8.8955, 5.3337, 8.8969> <-9.0045, 5.3337, 8.9787> <-9.2021, 5.4470, 8.9900> <-9.3380, 5.4470, 8.9994>
		<-8.8955, 12.8804, 8.8969> <-9.0126, 12.9804, 8.9848> <-9.2034, 13.0300, 8.9901> <-9.3380, 13.1449, 8.9994>
		<-8.8955, 18.5405, 8.8969> <-9.0126, 18.6405, 8.9848> <-9.2034, 18.8034, 8.9901> <-9.3380, 18.9183, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.3380, -0.3264, 8.9994> <-9.3380, -5.9608, 8.9994> <-9.3380, -13.4733, 8.9994> <-9.3380, -19.1077, 8.9994>
		<-9.6477, -0.3264, 9.0209> <-9.6477, -5.9608, 9.0209> <-9.6480, -13.7381, 9.0209> <-9.6480, -19.3725, 9.0209>
		<-10.0624, -0.3264, 9.0023> <-10.0624, -6.2259, 9.0023> <-10.0624, -13.8268, 9.0023> <-10.0624, -19.7264, 9.0023>
		<-10.3729, -0.3264, 8.9994> <-10.3729, -6.2259, 8.9994> <-10.3729, -14.0919, 8.9994> <-10.3729, -19.9915, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.3380, -0.3264, 8.9994> <-9.6477, -0.3264, 9.0209> <-10.0624, -0.3264, 9.0023> <-10.3729, -0.3264, 8.9994>
		<-9.3380, 5.4470, 8.9994> <-9.6477, 5.4470, 9.0209> <-10.0624, 5.7121, 9.0023> <-10.3729, 5.7121, 8.9994>
		<-9.3380, 13.1449, 8.9994> <-9.6480, 13.4097, 9.0209> <-10.0624, 13.4984, 9.0023> <-10.3729, 13.7635, 8.9994>
		<-9.3380, 18.9183, 8.9994> <-9.6480, 19.1831, 9.0209> <-10.0624, 19.5370, 9.0023> <-10.3729, 19.8021, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.3729, -0.3264, 8.9994> <-10.3729, -6.2259, 8.9994> <-10.3729, -14.0919, 8.9994> <-10.3729, -19.9915, 8.9994>
		<-10.7194, -0.3264, 8.9962> <-10.7194, -6.2259, 8.9962> <-10.7194, -14.3878, 8.9962> <-10.7194, -20.2873, 8.9962>
		<-11.1860, -0.3264, 9.0363> <-11.1860, -6.5218, 9.0363> <-11.1841, -14.4888, 9.0367> <-11.1841, -20.6842, 9.0367>
		<-11.5278, -0.3264, 8.9789> <-11.5278, -6.5218, 8.9789> <-11.5278, -14.7823, 8.9789> <-11.5278, -20.9776, 8.9789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.3729, -0.3264, 8.9994> <-10.7194, -0.3264, 8.9962> <-11.1860, -0.3264, 9.0363> <-11.5278, -0.3264, 8.9789>
		<-10.3729, 5.7121, 8.9994> <-10.7194, 5.7121, 8.9962> <-11.1860, 6.0080, 9.0363> <-11.5278, 6.0080, 8.9789>
		<-10.3729, 13.7635, 8.9994> <-10.7194, 14.0594, 8.9962> <-11.1841, 14.1604, 9.0367> <-11.5278, 14.4539, 8.9789>
		<-10.3729, 19.8021, 8.9994> <-10.7194, 20.0979, 8.9962> <-11.1841, 20.4948, 9.0367> <-11.5278, 20.7883, 8.9789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.5278, -0.3264, 8.9789> <-11.5278, -6.5218, 8.9789> <-11.5278, -14.7823, 8.9789> <-11.5278, -20.9776, 8.9789>
		<-11.6153, -0.3264, 8.9642> <-11.6153, -6.5218, 8.9642> <-11.6061, -14.8491, 8.9658> <-11.6061, -21.0445, 8.9658>
		<-11.7189, -0.3264, 8.8569> <-11.7189, -6.5755, 8.8569> <-11.7160, -14.8893, 8.8699> <-11.7160, -21.1384, 8.8699>
		<-11.7376, -0.3264, 8.7700> <-11.7376, -6.5755, 8.7700> <-11.7376, -14.9077, 8.7700> <-11.7376, -21.1568, 8.7700>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.5278, -0.3264, 8.9789> <-11.6153, -0.3264, 8.9642> <-11.7189, -0.3264, 8.8569> <-11.7376, -0.3264, 8.7700>
		<-11.5278, 6.0080, 8.9789> <-11.6153, 6.0080, 8.9642> <-11.7189, 6.0617, 8.8569> <-11.7376, 6.0617, 8.7700>
		<-11.5278, 14.4539, 8.9789> <-11.6061, 14.5207, 8.9658> <-11.7160, 14.5609, 8.8699> <-11.7376, 14.5793, 8.7700>
		<-11.5278, 20.7883, 8.9789> <-11.6061, 20.8551, 8.9658> <-11.7160, 20.9490, 8.8699> <-11.7376, 20.9674, 8.7700>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.7376, -0.3264, 8.7700> <-11.7376, -6.5755, 8.7700> <-11.7376, -14.9077, 8.7700> <-11.7376, -21.1568, 8.7700>
		<-11.7822, -0.3264, 8.5632> <-11.7822, -6.5755, 8.5632> <-11.7815, -14.9452, 8.5665> <-11.7815, -21.1943, 8.5665>
		<-11.8306, -0.3264, 8.2482> <-11.8306, -6.5723, 8.2482> <-11.8221, -14.9831, 8.2335> <-11.8221, -21.2290, 8.2335>
		<-11.7248, -0.3264, 8.0649> <-11.7248, -6.5723, 8.0649> <-11.7248, -14.9001, 8.0649> <-11.7248, -21.1459, 8.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.7376, -0.3264, 8.7700> <-11.7822, -0.3264, 8.5632> <-11.8306, -0.3264, 8.2482> <-11.7248, -0.3264, 8.0649>
		<-11.7376, 6.0617, 8.7700> <-11.7822, 6.0617, 8.5632> <-11.8306, 6.0585, 8.2482> <-11.7248, 6.0585, 8.0649>
		<-11.7376, 14.5793, 8.7700> <-11.7815, 14.6168, 8.5665> <-11.8221, 14.6547, 8.2335> <-11.7248, 14.5717, 8.0649>
		<-11.7376, 20.9674, 8.7700> <-11.7815, 21.0049, 8.5665> <-11.8221, 21.0396, 8.2335> <-11.7248, 20.9566, 8.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.7248, -0.3264, 8.0649> <-11.7248, -6.5723, 8.0649> <-11.7248, -14.9001, 8.0649> <-11.7248, -21.1459, 8.0649>
		<-11.6250, -0.3264, 7.8918> <-11.6250, -6.5723, 7.8918> <-11.6103, -14.8023, 7.8663> <-11.6103, -21.0481, 7.8663>
		<-11.3391, -0.3264, 7.7799> <-11.3391, -6.4233, 7.7799> <-11.3306, -14.7124, 7.7782> <-11.3306, -20.8093, 7.7782>
		<-11.1433, -0.3264, 7.7399> <-11.1433, -6.4233, 7.7399> <-11.1433, -14.5525, 7.7399> <-11.1433, -20.6494, 7.7399>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.7248, -0.3264, 8.0649> <-11.6250, -0.3264, 7.8918> <-11.3391, -0.3264, 7.7799> <-11.1433, -0.3264, 7.7399>
		<-11.7248, 6.0585, 8.0649> <-11.6250, 6.0585, 7.8918> <-11.3391, 5.9095, 7.7799> <-11.1433, 5.9095, 7.7399>
		<-11.7248, 14.5717, 8.0649> <-11.6103, 14.4738, 7.8663> <-11.3306, 14.3840, 7.7782> <-11.1433, 14.2241, 7.7399>
		<-11.7248, 20.9566, 8.0649> <-11.6103, 20.8587, 7.8663> <-11.3306, 20.6199, 7.7782> <-11.1433, 20.4600, 7.7399>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1433, -0.3264, 7.7399> <-11.1433, -6.4233, 7.7399> <-11.1433, -14.5525, 7.7399> <-11.1433, -20.6494, 7.7399>
		<-10.7242, -0.3264, 7.6542> <-10.7242, -6.4233, 7.6542> <-10.7209, -14.1917, 7.6536> <-10.7209, -20.2886, 7.6536>
		<-10.1475, -0.3264, 7.6479> <-10.1475, -6.0586, 7.6479> <-10.1472, -14.0666, 7.6479> <-10.1472, -19.7987, 7.6479>
		<-9.7197, -0.3264, 7.6550> <-9.7197, -6.0586, 7.6550> <-9.7197, -13.7015, 7.6550> <-9.7197, -19.4337, 7.6550>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1433, -0.3264, 7.7399> <-10.7242, -0.3264, 7.6542> <-10.1475, -0.3264, 7.6479> <-9.7197, -0.3264, 7.6550>
		<-11.1433, 5.9095, 7.7399> <-10.7242, 5.9095, 7.6542> <-10.1475, 5.5448, 7.6479> <-9.7197, 5.5448, 7.6550>
		<-11.1433, 14.2241, 7.7399> <-10.7209, 13.8633, 7.6536> <-10.1472, 13.7381, 7.6479> <-9.7197, 13.3731, 7.6550>
		<-11.1433, 20.4600, 7.7399> <-10.7209, 20.0992, 7.6536> <-10.1472, 19.6094, 7.6479> <-9.7197, 19.2443, 7.6550>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7197, -0.3264, 7.6550> <-9.7197, -6.0586, 7.6550> <-9.7197, -13.7015, 7.6550> <-9.7197, -19.4337, 7.6550>
		<-9.5758, -0.3264, 7.6575> <-9.5758, -6.0586, 7.6575> <-9.5776, -13.5802, 7.6574> <-9.5776, -19.3124, 7.6574>
		<-9.3627, -0.3264, 7.6769> <-9.3627, -5.9394, 7.6769> <-9.3727, -13.5244, 7.6681> <-9.3727, -19.1374, 7.6681>
		<-9.2544, -0.3264, 7.7716> <-9.2544, -5.9394, 7.7716> <-9.2544, -13.4234, 7.7716> <-9.2544, -19.0363, 7.7716>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7197, -0.3264, 7.6550> <-9.5758, -0.3264, 7.6575> <-9.3627, -0.3264, 7.6769> <-9.2544, -0.3264, 7.7716>
		<-9.7197, 5.5448, 7.6550> <-9.5758, 5.5448, 7.6575> <-9.3627, 5.4256, 7.6769> <-9.2544, 5.4256, 7.7716>
		<-9.7197, 13.3731, 7.6550> <-9.5776, 13.2518, 7.6574> <-9.3727, 13.1960, 7.6681> <-9.2544, 13.0949, 7.7716>
		<-9.7197, 19.2443, 7.6550> <-9.5776, 19.1230, 7.6574> <-9.3727, 18.9480, 7.6681> <-9.2544, 18.8469, 7.7716>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.2544, -0.3264, 7.7716> <-9.2544, -5.9394, 7.7716> <-9.2544, -13.4234, 7.7716> <-9.2544, -19.0363, 7.7716>
		<-9.1744, -0.3264, 7.8414> <-9.1744, -5.9394, 7.8414> <-9.1863, -13.3652, 7.8311> <-9.1863, -18.9782, 7.8311>
		<-9.2497, -0.3264, 8.0327> <-9.2497, -5.9225, 8.0327> <-9.2441, -13.4315, 8.0406> <-9.2441, -19.0275, 8.0406>
		<-9.1883, -0.3264, 8.1193> <-9.1883, -5.9225, 8.1193> <-9.1883, -13.3839, 8.1193> <-9.1883, -18.9799, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.2544, -0.3264, 7.7716> <-9.1744, -0.3264, 7.8414> <-9.2497, -0.3264, 8.0327> <-9.1883, -0.3264, 8.1193>
		<-9.2544, 5.4256, 7.7716> <-9.1744, 5.4256, 7.8414> <-9.2497, 5.4087, 8.0327> <-9.1883, 5.4087, 8.1193>
		<-9.2544, 13.0949, 7.7716> <-9.1863, 13.0368, 7.8311> <-9.2441, 13.1031, 8.0406> <-9.1883, 13.0555, 8.1193>
		<-9.2544, 18.8469, 7.7716> <-9.1863, 18.7888, 7.8311> <-9.2441, 18.8381, 8.0406> <-9.1883, 18.7906, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.5938, 8.1902> <7.5749, 18.6528, 8.1689> <7.5749, 18.7581, 8.1730> <7.5749, 18.7906, 8.1193>
		<2.6151, 18.5938, 8.1902> <2.6151, 18.6528, 8.1689> <2.5460, 18.7581, 8.1730> <2.5460, 18.7906, 8.1193>
		<-3.9981, 18.5938, 8.1902> <-4.0672, 18.6528, 8.1689> <-4.1110, 18.7493, 8.1877> <-4.1594, 18.7906, 8.1193>
		<-8.9580, 18.5938, 8.1902> <-9.0271, 18.6528, 8.1689> <-9.1400, 18.7493, 8.1877> <-9.1883, 18.7906, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.5938, 8.1902> <2.6151, 18.5938, 8.1902> <-3.9981, 18.5938, 8.1902> <-8.9580, 18.5938, 8.1902>
		<7.5749, 18.5932, 8.2606> <2.6151, 18.5932, 8.2606> <-3.9973, 18.5932, 8.2606> <-8.9572, 18.5932, 8.2606>
		<7.5749, 18.5923, 8.3545> <2.6158, 18.5923, 8.3545> <-3.9971, 18.5923, 8.3545> <-8.9562, 18.5923, 8.3545>
		<7.5749, 18.5917, 8.4249> <2.6158, 18.5917, 8.4249> <-3.9963, 18.5917, 8.4249> <-8.9554, 18.5917, 8.4249>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.5917, 8.4249> <2.6158, 18.5917, 8.4249> <-3.9963, 18.5917, 8.4249> <-8.9554, 18.5917, 8.4249>
		<7.5749, 18.5214, 8.4493> <2.6158, 18.5214, 8.4493> <-3.9140, 18.5214, 8.4493> <-8.8731, 18.5214, 8.4493>
		<7.5749, 18.3654, 8.4323> <2.6982, 18.3654, 8.4323> <-3.8181, 18.3692, 8.3968> <-8.6949, 18.3692, 8.3968>
		<7.5749, 18.3573, 8.5063> <2.6982, 18.3573, 8.5063> <-3.8042, 18.3573, 8.5063> <-8.6810, 18.3573, 8.5063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.3573, 8.5063> <2.6982, 18.3573, 8.5063> <-3.8042, 18.3573, 8.5063> <-8.6810, 18.3573, 8.5063>
		<7.5749, 18.3434, 8.6350> <2.6982, 18.3434, 8.6350> <-3.7861, 18.3419, 8.6489> <-8.6629, 18.3419, 8.6489>
		<7.5749, 18.4433, 8.8115> <2.6338, 18.4433, 8.8115> <-3.8589, 18.4590, 8.8253> <-8.8000, 18.4590, 8.8253>
		<7.5749, 18.5405, 8.8969> <2.6338, 18.5405, 8.8969> <-3.9544, 18.5405, 8.8969> <-8.8955, 18.5405, 8.8969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.5405, 8.8969> <2.6338, 18.5405, 8.8969> <-3.9544, 18.5405, 8.8969> <-8.8955, 18.5405, 8.8969>
		<7.5749, 18.6287, 8.9745> <2.6338, 18.6287, 8.9745> <-4.0714, 18.6405, 8.9848> <-9.0126, 18.6405, 8.9848>
		<7.5749, 18.8013, 8.9899> <2.5011, 18.8013, 8.9899> <-4.1295, 18.8034, 8.9901> <-9.2034, 18.8034, 8.9901>
		<7.5749, 18.9183, 8.9994> <2.5011, 18.9183, 8.9994> <-4.2641, 18.9183, 8.9994> <-9.3380, 18.9183, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.9183, 8.9994> <2.5011, 18.9183, 8.9994> <-4.2641, 18.9183, 8.9994> <-9.3380, 18.9183, 8.9994>
		<7.5749, 19.1826, 9.0209> <2.5011, 19.1826, 9.0209> <-4.5742, 19.1831, 9.0209> <-9.6480, 19.1831, 9.0209>
		<7.5749, 19.5370, 9.0023> <2.1906, 19.5370, 9.0023> <-4.6781, 19.5370, 9.0023> <-10.0624, 19.5370, 9.0023>
		<7.5749, 19.8021, 8.9994> <2.1906, 19.8021, 8.9994> <-4.9885, 19.8021, 8.9994> <-10.3729, 19.8021, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 19.8021, 8.9994> <2.1906, 19.8021, 8.9994> <-4.9885, 19.8021, 8.9994> <-10.3729, 19.8021, 8.9994>
		<7.5749, 20.0980, 8.9962> <2.1906, 20.0980, 8.9962> <-5.3350, 20.0979, 8.9962> <-10.7194, 20.0979, 8.9962>
		<7.5749, 20.4979, 9.0361> <1.8441, 20.4979, 9.0361> <-5.4533, 20.4948, 9.0367> <-11.1841, 20.4948, 9.0367>
		<7.5749, 20.7883, 8.9789> <1.8441, 20.7883, 8.9789> <-5.7969, 20.7883, 8.9789> <-11.5278, 20.7883, 8.9789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 20.7883, 8.9789> <1.8441, 20.7883, 8.9789> <-5.7969, 20.7883, 8.9789> <-11.5278, 20.7883, 8.9789>
		<7.5749, 20.8693, 8.9630> <1.8441, 20.8693, 8.9630> <-5.8753, 20.8551, 8.9658> <-11.6061, 20.8551, 8.9658>
		<7.5749, 20.9525, 8.8512> <1.7812, 20.9525, 8.8512> <-5.9223, 20.9490, 8.8699> <-11.7160, 20.9490, 8.8699>
		<7.5749, 20.9674, 8.7700> <1.7812, 20.9674, 8.7700> <-5.9438, 20.9674, 8.7700> <-11.7376, 20.9674, 8.7700>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 20.9674, 8.7700> <1.7812, 20.9674, 8.7700> <-5.9438, 20.9674, 8.7700> <-11.7376, 20.9674, 8.7700>
		<7.5749, 21.0057, 8.5620> <1.7812, 21.0057, 8.5620> <-5.9877, 21.0049, 8.5665> <-11.7815, 21.0049, 8.5665>
		<7.5749, 21.0500, 8.2547> <1.7850, 21.0500, 8.2547> <-6.0322, 21.0396, 8.2335> <-11.8221, 21.0396, 8.2335>
		<7.5749, 20.9566, 8.0649> <1.7850, 20.9566, 8.0649> <-5.9349, 20.9566, 8.0649> <-11.7248, 20.9566, 8.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 20.9566, 8.0649> <1.7850, 20.9566, 8.0649> <-5.9349, 20.9566, 8.0649> <-11.7248, 20.9566, 8.0649>
		<7.5749, 20.8779, 7.9052> <1.7850, 20.8779, 7.9052> <-5.8203, 20.8587, 7.8663> <-11.6103, 20.8587, 7.8663>
		<7.5749, 20.6331, 7.7814> <1.9595, 20.6331, 7.7814> <-5.7152, 20.6199, 7.7782> <-11.3306, 20.6199, 7.7782>
		<7.5749, 20.4600, 7.7399> <1.9595, 20.4600, 7.7399> <-5.5279, 20.4600, 7.7399> <-11.1433, 20.4600, 7.7399>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 20.4600, 7.7399> <1.9595, 20.4600, 7.7399> <-5.5279, 20.4600, 7.7399> <-11.1433, 20.4600, 7.7399>
		<7.5749, 20.1044, 7.6548> <1.9595, 20.1044, 7.6548> <-5.1054, 20.0992, 7.6536> <-10.7209, 20.0992, 7.6536>
		<7.5749, 19.6098, 7.6479> <2.3865, 19.6098, 7.6479> <-4.9588, 19.6094, 7.6479> <-10.1472, 19.6094, 7.6479>
		<7.5749, 19.2443, 7.6550> <2.3865, 19.2443, 7.6550> <-4.5313, 19.2443, 7.6550> <-9.7197, 19.2443, 7.6550>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 19.2443, 7.6550> <2.3865, 19.2443, 7.6550> <-4.5313, 19.2443, 7.6550> <-9.7197, 19.2443, 7.6550>
		<7.5749, 19.1201, 7.6575> <2.3865, 19.1201, 7.6575> <-4.3892, 19.1230, 7.6574> <-9.5776, 19.1230, 7.6574>
		<7.5749, 18.9338, 7.6827> <2.5261, 18.9338, 7.6827> <-4.3239, 18.9480, 7.6681> <-9.3727, 18.9480, 7.6681>
		<7.5749, 18.8469, 7.7716> <2.5261, 18.8469, 7.7716> <-4.2056, 18.8469, 7.7716> <-9.2544, 18.8469, 7.7716>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, 18.8469, 7.7716> <2.5261, 18.8469, 7.7716> <-4.2056, 18.8469, 7.7716> <-9.2544, 18.8469, 7.7716>
		<7.5749, 18.7731, 7.8472> <2.5261, 18.7731, 7.8472> <-4.1375, 18.7888, 7.8311> <-9.1863, 18.7888, 7.8311>
		<7.5749, 18.8453, 8.0289> <2.5460, 18.8453, 8.0289> <-4.2151, 18.8381, 8.0406> <-9.2441, 18.8381, 8.0406>
		<7.5749, 18.7906, 8.1193> <2.5460, 18.7906, 8.1193> <-4.1594, 18.7906, 8.1193> <-9.1883, 18.7906, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -18.7832, 8.1902> <2.6151, -18.7832, 8.1902> <-3.9981, -18.7832, 8.1902> <-8.9580, -18.7832, 8.1902>
		<7.5749, -18.8422, 8.1689> <2.6151, -18.8422, 8.1689> <-4.0672, -18.8422, 8.1689> <-9.0271, -18.8422, 8.1689>
		<7.5749, -18.9475, 8.1730> <2.5460, -18.9475, 8.1730> <-4.1110, -18.9386, 8.1877> <-9.1400, -18.9386, 8.1877>
		<7.5749, -18.9799, 8.1193> <2.5460, -18.9799, 8.1193> <-4.1594, -18.9799, 8.1193> <-9.1883, -18.9799, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -18.7832, 8.1902> <7.5749, -18.7826, 8.2606> <7.5749, -18.7817, 8.3545> <7.5749, -18.7810, 8.4249>
		<2.6151, -18.7832, 8.1902> <2.6151, -18.7826, 8.2606> <2.6158, -18.7817, 8.3545> <2.6158, -18.7810, 8.4249>
		<-3.9981, -18.7832, 8.1902> <-3.9973, -18.7826, 8.2606> <-3.9971, -18.7817, 8.3545> <-3.9963, -18.7810, 8.4249>
		<-8.9580, -18.7832, 8.1902> <-8.9572, -18.7826, 8.2606> <-8.9562, -18.7817, 8.3545> <-8.9554, -18.7810, 8.4249>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -18.7810, 8.4249> <7.5749, -18.7108, 8.4493> <7.5749, -18.5547, 8.4323> <7.5749, -18.5467, 8.5063>
		<2.6158, -18.7810, 8.4249> <2.6158, -18.7108, 8.4493> <2.6982, -18.5547, 8.4323> <2.6982, -18.5467, 8.5063>
		<-3.9963, -18.7810, 8.4249> <-3.9140, -18.7108, 8.4493> <-3.8181, -18.5586, 8.3968> <-3.8042, -18.5467, 8.5063>
		<-8.9554, -18.7810, 8.4249> <-8.8731, -18.7108, 8.4493> <-8.6949, -18.5586, 8.3968> <-8.6810, -18.5467, 8.5063>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -18.5467, 8.5063> <7.5749, -18.5328, 8.6350> <7.5749, -18.6327, 8.8115> <7.5749, -18.7299, 8.8969>
		<2.6982, -18.5467, 8.5063> <2.6982, -18.5328, 8.6350> <2.6338, -18.6327, 8.8115> <2.6338, -18.7299, 8.8969>
		<-3.8042, -18.5467, 8.5063> <-3.7861, -18.5313, 8.6489> <-3.8589, -18.6484, 8.8253> <-3.9544, -18.7299, 8.8969>
		<-8.6810, -18.5467, 8.5063> <-8.6629, -18.5313, 8.6489> <-8.8000, -18.6484, 8.8253> <-8.8955, -18.7299, 8.8969>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -18.7299, 8.8969> <7.5749, -18.8181, 8.9745> <7.5749, -18.9907, 8.9899> <7.5749, -19.1077, 8.9994>
		<2.6338, -18.7299, 8.8969> <2.6338, -18.8181, 8.9745> <2.5011, -18.9907, 8.9899> <2.5011, -19.1077, 8.9994>
		<-3.9544, -18.7299, 8.8969> <-4.0714, -18.8298, 8.9848> <-4.1295, -18.9928, 8.9901> <-4.2641, -19.1077, 8.9994>
		<-8.8955, -18.7299, 8.8969> <-9.0126, -18.8298, 8.9848> <-9.2034, -18.9928, 8.9901> <-9.3380, -19.1077, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -19.1077, 8.9994> <7.5749, -19.3720, 9.0209> <7.5749, -19.7264, 9.0023> <7.5749, -19.9915, 8.9994>
		<2.5011, -19.1077, 8.9994> <2.5011, -19.3720, 9.0209> <2.1906, -19.7264, 9.0023> <2.1906, -19.9915, 8.9994>
		<-4.2641, -19.1077, 8.9994> <-4.5742, -19.3725, 9.0209> <-4.6781, -19.7264, 9.0023> <-4.9885, -19.9915, 8.9994>
		<-9.3380, -19.1077, 8.9994> <-9.6480, -19.3725, 9.0209> <-10.0624, -19.7264, 9.0023> <-10.3729, -19.9915, 8.9994>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -19.9915, 8.9994> <7.5749, -20.2874, 8.9962> <7.5749, -20.6873, 9.0361> <7.5749, -20.9776, 8.9789>
		<2.1906, -19.9915, 8.9994> <2.1906, -20.2874, 8.9962> <1.8441, -20.6873, 9.0361> <1.8441, -20.9776, 8.9789>
		<-4.9885, -19.9915, 8.9994> <-5.3350, -20.2873, 8.9962> <-5.4533, -20.6842, 9.0367> <-5.7969, -20.9776, 8.9789>
		<-10.3729, -19.9915, 8.9994> <-10.7194, -20.2873, 8.9962> <-11.1841, -20.6842, 9.0367> <-11.5278, -20.9776, 8.9789>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -20.9776, 8.9789> <7.5749, -21.0586, 8.9630> <7.5749, -21.1419, 8.8512> <7.5749, -21.1568, 8.7700>
		<1.8441, -20.9776, 8.9789> <1.8441, -21.0586, 8.9630> <1.7812, -21.1419, 8.8512> <1.7812, -21.1568, 8.7700>
		<-5.7969, -20.9776, 8.9789> <-5.8753, -21.0445, 8.9658> <-5.9223, -21.1384, 8.8699> <-5.9438, -21.1568, 8.7700>
		<-11.5278, -20.9776, 8.9789> <-11.6061, -21.0445, 8.9658> <-11.7160, -21.1384, 8.8699> <-11.7376, -21.1568, 8.7700>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -21.1568, 8.7700> <7.5749, -21.1951, 8.5620> <7.5749, -21.2394, 8.2547> <7.5749, -21.1459, 8.0649>
		<1.7812, -21.1568, 8.7700> <1.7812, -21.1951, 8.5620> <1.7850, -21.2394, 8.2547> <1.7850, -21.1459, 8.0649>
		<-5.9438, -21.1568, 8.7700> <-5.9877, -21.1943, 8.5665> <-6.0322, -21.2290, 8.2335> <-5.9349, -21.1459, 8.0649>
		<-11.7376, -21.1568, 8.7700> <-11.7815, -21.1943, 8.5665> <-11.8221, -21.2290, 8.2335> <-11.7248, -21.1459, 8.0649>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -21.1459, 8.0649> <7.5749, -21.0673, 7.9052> <7.5749, -20.8225, 7.7814> <7.5749, -20.6494, 7.7399>
		<1.7850, -21.1459, 8.0649> <1.7850, -21.0673, 7.9052> <1.9595, -20.8225, 7.7814> <1.9595, -20.6494, 7.7399>
		<-5.9349, -21.1459, 8.0649> <-5.8204, -21.0481, 7.8663> <-5.7152, -20.8093, 7.7782> <-5.5279, -20.6494, 7.7399>
		<-11.7248, -21.1459, 8.0649> <-11.6103, -21.0481, 7.8663> <-11.3306, -20.8093, 7.7782> <-11.1433, -20.6494, 7.7399>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -20.6494, 7.7399> <7.5749, -20.2938, 7.6548> <7.5749, -19.7992, 7.6479> <7.5749, -19.4337, 7.6550>
		<1.9595, -20.6494, 7.7399> <1.9595, -20.2938, 7.6548> <2.3865, -19.7992, 7.6479> <2.3865, -19.4337, 7.6550>
		<-5.5279, -20.6494, 7.7399> <-5.1054, -20.2886, 7.6536> <-4.9588, -19.7987, 7.6479> <-4.5313, -19.4337, 7.6550>
		<-11.1433, -20.6494, 7.7399> <-10.7209, -20.2886, 7.6536> <-10.1472, -19.7987, 7.6479> <-9.7197, -19.4337, 7.6550>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -19.4337, 7.6550> <7.5749, -19.3095, 7.6575> <7.5749, -19.1232, 7.6827> <7.5749, -19.0363, 7.7716>
		<2.3865, -19.4337, 7.6550> <2.3865, -19.3095, 7.6575> <2.5261, -19.1232, 7.6827> <2.5261, -19.0363, 7.7716>
		<-4.5313, -19.4337, 7.6550> <-4.3892, -19.3124, 7.6574> <-4.3239, -19.1374, 7.6681> <-4.2056, -19.0363, 7.7716>
		<-9.7197, -19.4337, 7.6550> <-9.5776, -19.3124, 7.6574> <-9.3727, -19.1374, 7.6681> <-9.2544, -19.0363, 7.7716>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.5749, -19.0363, 7.7716> <7.5749, -18.9625, 7.8472> <7.5749, -19.0346, 8.0289> <7.5749, -18.9799, 8.1193>
		<2.5261, -19.0363, 7.7716> <2.5261, -18.9625, 7.8472> <2.5460, -19.0346, 8.0289> <2.5460, -18.9799, 8.1193>
		<-4.2056, -19.0363, 7.7716> <-4.1375, -18.9782, 7.8311> <-4.2151, -19.0275, 8.0406> <-4.1594, -18.9799, 8.1193>
		<-9.2544, -19.0363, 7.7716> <-9.1863, -18.9782, 7.8311> <-9.2441, -19.0275, 8.0406> <-9.1883, -18.9799, 8.1193>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 0.9062> <-11.1109, 16.8244, 0.9062> <-11.1109, 18.3047, 0.9062> <-11.0664, 18.3493, 0.9062>
		<-11.0712, 16.7751, 0.8515> <-11.1157, 16.8196, 0.8515> <-11.1157, 18.3095, 0.8515> <-11.0712, 18.3541, 0.8515>
		<-11.1500, 16.6963, 0.8308> <-11.1998, 16.7461, 0.8308> <-11.1998, 18.3831, 0.8308> <-11.1500, 18.4329, 0.8308>
		<-11.1589, 16.6874, 0.7771> <-11.2087, 16.7372, 0.7771> <-11.2087, 18.3920, 0.7771> <-11.1589, 18.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 0.9062> <-11.0620, 16.7842, 0.9557> <-11.1560, 16.6903, 0.9996> <-11.1357, 16.7105, 1.0404>
		<-11.1109, 16.8244, 0.9062> <-11.1066, 16.8288, 0.9557> <-11.2045, 16.7388, 0.9996> <-11.1842, 16.7590, 1.0404>
		<-11.1109, 18.3047, 0.9062> <-11.1066, 18.3004, 0.9557> <-11.2045, 18.3904, 0.9996> <-11.1842, 18.3702, 1.0404>
		<-11.0664, 18.3493, 0.9062> <-11.0620, 18.3449, 0.9557> <-11.1560, 18.4389, 0.9996> <-11.1357, 18.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 0.9062> <-11.0712, 16.7751, 0.8515> <-11.1500, 16.6963, 0.8308> <-11.1589, 16.6874, 0.7771>
		<-11.0218, 16.7353, 0.9062> <-11.0266, 16.7305, 0.8515> <-11.1001, 16.6465, 0.8308> <-11.1090, 16.6376, 0.7771>
		<-9.5415, 16.7353, 0.9062> <-9.5367, 16.7305, 0.8515> <-9.4632, 16.6465, 0.8308> <-9.4543, 16.6376, 0.7771>
		<-9.4970, 16.7799, 0.9062> <-9.4922, 16.7751, 0.8515> <-9.4134, 16.6963, 0.8308> <-9.4045, 16.6874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 0.9062> <-11.0218, 16.7353, 0.9062> <-9.5415, 16.7353, 0.9062> <-9.4970, 16.7799, 0.9062>
		<-11.0620, 16.7842, 0.9557> <-11.0175, 16.7397, 0.9557> <-9.5459, 16.7397, 0.9557> <-9.5013, 16.7842, 0.9557>
		<-11.1560, 16.6903, 0.9996> <-11.1075, 16.6418, 0.9996> <-9.4559, 16.6418, 0.9996> <-9.4073, 16.6903, 0.9996>
		<-11.1357, 16.7105, 1.0404> <-11.0872, 16.6620, 1.0404> <-9.4761, 16.6620, 1.0404> <-9.4276, 16.7105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.7799, 0.9062> <-9.4922, 16.7751, 0.8515> <-9.4134, 16.6963, 0.8308> <-9.4045, 16.6874, 0.7771>
		<-9.4524, 16.8244, 0.9062> <-9.4476, 16.8196, 0.8515> <-9.3635, 16.7461, 0.8308> <-9.3546, 16.7372, 0.7771>
		<-9.4524, 18.3047, 0.9062> <-9.4476, 18.3095, 0.8515> <-9.3635, 18.3831, 0.8308> <-9.3546, 18.3920, 0.7771>
		<-9.4970, 18.3493, 0.9062> <-9.4922, 18.3541, 0.8515> <-9.4134, 18.4329, 0.8308> <-9.4045, 18.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.7799, 0.9062> <-9.4524, 16.8244, 0.9062> <-9.4524, 18.3047, 0.9062> <-9.4970, 18.3493, 0.9062>
		<-9.5013, 16.7842, 0.9557> <-9.4567, 16.8288, 0.9557> <-9.4567, 18.3004, 0.9557> <-9.5013, 18.3449, 0.9557>
		<-9.4073, 16.6903, 0.9996> <-9.3588, 16.7388, 0.9996> <-9.3588, 18.3904, 0.9996> <-9.4073, 18.4389, 0.9996>
		<-9.4276, 16.7105, 1.0404> <-9.3791, 16.7590, 1.0404> <-9.3791, 18.3702, 1.0404> <-9.4276, 18.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.3493, 0.9062> <-9.4922, 18.3541, 0.8515> <-9.4134, 18.4329, 0.8308> <-9.4045, 18.4418, 0.7771>
		<-9.5415, 18.3939, 0.9062> <-9.5367, 18.3987, 0.8515> <-9.4632, 18.4827, 0.8308> <-9.4543, 18.4916, 0.7771>
		<-11.0218, 18.3939, 0.9062> <-11.0266, 18.3987, 0.8515> <-11.1001, 18.4827, 0.8308> <-11.1090, 18.4916, 0.7771>
		<-11.0664, 18.3493, 0.9062> <-11.0712, 18.3541, 0.8515> <-11.1500, 18.4329, 0.8308> <-11.1589, 18.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.3493, 0.9062> <-9.5415, 18.3939, 0.9062> <-11.0218, 18.3939, 0.9062> <-11.0664, 18.3493, 0.9062>
		<-9.5013, 18.3449, 0.9557> <-9.5459, 18.3895, 0.9557> <-11.0175, 18.3895, 0.9557> <-11.0620, 18.3449, 0.9557>
		<-9.4073, 18.4389, 0.9996> <-9.4559, 18.4874, 0.9996> <-11.1075, 18.4874, 0.9996> <-11.1560, 18.4389, 0.9996>
		<-9.4276, 18.4187, 1.0404> <-9.4761, 18.4672, 1.0404> <-11.0872, 18.4672, 1.0404> <-11.1357, 18.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 16.7105, 1.0404> <-11.0677, 16.7786, 1.1777> <-10.8982, 16.9481, 1.2552> <-10.8269, 17.0193, 1.3892>
		<-11.1842, 16.7590, 1.0404> <-11.1162, 16.8271, 1.1777> <-10.9291, 16.9790, 1.2552> <-10.8579, 17.0503, 1.3892>
		<-11.1842, 18.3702, 1.0404> <-11.1162, 18.3021, 1.1777> <-10.9291, 18.1501, 1.2552> <-10.8579, 18.0789, 1.3892>
		<-11.1357, 18.4187, 1.0404> <-11.0677, 18.3506, 1.1777> <-10.8982, 18.1811, 1.2552> <-10.8269, 18.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 16.7105, 1.0404> <-11.0872, 16.6620, 1.0404> <-9.4761, 16.6620, 1.0404> <-9.4276, 16.7105, 1.0404>
		<-11.0677, 16.7786, 1.1777> <-11.0192, 16.7301, 1.1777> <-9.5442, 16.7301, 1.1777> <-9.4957, 16.7786, 1.1777>
		<-10.8982, 16.9481, 1.2552> <-10.8672, 16.9171, 1.2552> <-9.6961, 16.9171, 1.2552> <-9.6652, 16.9481, 1.2552>
		<-10.8269, 17.0193, 1.3892> <-10.7959, 16.9884, 1.3892> <-9.7674, 16.9884, 1.3892> <-9.7364, 17.0193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 16.7105, 1.0404> <-9.3791, 16.7590, 1.0404> <-9.3791, 18.3702, 1.0404> <-9.4276, 18.4187, 1.0404>
		<-9.4957, 16.7786, 1.1777> <-9.4471, 16.8271, 1.1777> <-9.4471, 18.3021, 1.1777> <-9.4957, 18.3506, 1.1777>
		<-9.6652, 16.9481, 1.2552> <-9.6342, 16.9790, 1.2552> <-9.6342, 18.1501, 1.2552> <-9.6652, 18.1811, 1.2552>
		<-9.7364, 17.0193, 1.3892> <-9.7054, 17.0503, 1.3892> <-9.7054, 18.0789, 1.3892> <-9.7364, 18.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 18.4187, 1.0404> <-9.4761, 18.4672, 1.0404> <-11.0872, 18.4672, 1.0404> <-11.1357, 18.4187, 1.0404>
		<-9.4957, 18.3506, 1.1777> <-9.5442, 18.3991, 1.1777> <-11.0192, 18.3991, 1.1777> <-11.0677, 18.3506, 1.1777>
		<-9.6652, 18.1811, 1.2552> <-9.6961, 18.2121, 1.2552> <-10.8672, 18.2121, 1.2552> <-10.8982, 18.1811, 1.2552>
		<-9.7364, 18.1098, 1.3892> <-9.7674, 18.1408, 1.3892> <-10.7959, 18.1408, 1.3892> <-10.8269, 18.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 17.0193, 1.3892> <-10.8079, 17.0383, 1.4249> <-10.8837, 16.9626, 1.4698> <-10.8837, 16.9626, 1.5144>
		<-10.8579, 17.0503, 1.3892> <-10.8389, 17.0693, 1.4249> <-10.9179, 16.9968, 1.4698> <-10.9179, 16.9968, 1.5144>
		<-10.8579, 18.0789, 1.3892> <-10.8389, 18.0599, 1.4249> <-10.9179, 18.1324, 1.4698> <-10.9179, 18.1324, 1.5144>
		<-10.8269, 18.1098, 1.3892> <-10.8079, 18.0909, 1.4249> <-10.8837, 18.1666, 1.4698> <-10.8837, 18.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 17.0193, 1.3892> <-10.7959, 16.9884, 1.3892> <-9.7674, 16.9884, 1.3892> <-9.7364, 17.0193, 1.3892>
		<-10.8079, 17.0383, 1.4249> <-10.7770, 17.0073, 1.4249> <-9.7863, 17.0073, 1.4249> <-9.7554, 17.0383, 1.4249>
		<-10.8837, 16.9626, 1.4698> <-10.8495, 16.9284, 1.4698> <-9.7138, 16.9284, 1.4698> <-9.6796, 16.9626, 1.4698>
		<-10.8837, 16.9626, 1.5144> <-10.8495, 16.9284, 1.5144> <-9.7138, 16.9284, 1.5144> <-9.6796, 16.9626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 17.0193, 1.3892> <-9.7054, 17.0503, 1.3892> <-9.7054, 18.0789, 1.3892> <-9.7364, 18.1098, 1.3892>
		<-9.7554, 17.0383, 1.4249> <-9.7244, 17.0693, 1.4249> <-9.7244, 18.0599, 1.4249> <-9.7554, 18.0909, 1.4249>
		<-9.6796, 16.9626, 1.4698> <-9.6455, 16.9968, 1.4698> <-9.6455, 18.1324, 1.4698> <-9.6796, 18.1666, 1.4698>
		<-9.6796, 16.9626, 1.5144> <-9.6455, 16.9968, 1.5144> <-9.6455, 18.1324, 1.5144> <-9.6796, 18.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 18.1098, 1.3892> <-9.7674, 18.1408, 1.3892> <-10.7959, 18.1408, 1.3892> <-10.8269, 18.1098, 1.3892>
		<-9.7554, 18.0909, 1.4249> <-9.7863, 18.1218, 1.4249> <-10.7770, 18.1218, 1.4249> <-10.8079, 18.0909, 1.4249>
		<-9.6796, 18.1666, 1.4698> <-9.7138, 18.2008, 1.4698> <-10.8495, 18.2008, 1.4698> <-10.8837, 18.1666, 1.4698>
		<-9.6796, 18.1666, 1.5144> <-9.7138, 18.2008, 1.5144> <-10.8495, 18.2008, 1.5144> <-10.8837, 18.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 16.9626, 1.5144> <-10.8837, 16.9626, 1.5613> <-10.8121, 17.0341, 1.6066> <-10.8269, 17.0193, 1.6486>
		<-10.9179, 16.9968, 1.5144> <-10.9179, 16.9968, 1.5613> <-10.8431, 17.0651, 1.6066> <-10.8579, 17.0503, 1.6486>
		<-10.9179, 18.1324, 1.5144> <-10.9179, 18.1324, 1.5613> <-10.8431, 18.0641, 1.6066> <-10.8579, 18.0789, 1.6486>
		<-10.8837, 18.1666, 1.5144> <-10.8837, 18.1666, 1.5613> <-10.8121, 18.0950, 1.6066> <-10.8269, 18.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 16.9626, 1.5144> <-10.8495, 16.9284, 1.5144> <-9.7138, 16.9284, 1.5144> <-9.6796, 16.9626, 1.5144>
		<-10.8837, 16.9626, 1.5613> <-10.8495, 16.9284, 1.5613> <-9.7138, 16.9284, 1.5613> <-9.6796, 16.9626, 1.5613>
		<-10.8121, 17.0341, 1.6066> <-10.7812, 17.0032, 1.6066> <-9.7822, 17.0032, 1.6066> <-9.7512, 17.0341, 1.6066>
		<-10.8269, 17.0193, 1.6486> <-10.7959, 16.9884, 1.6486> <-9.7674, 16.9884, 1.6486> <-9.7364, 17.0193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 16.9626, 1.5144> <-9.6455, 16.9968, 1.5144> <-9.6455, 18.1324, 1.5144> <-9.6796, 18.1666, 1.5144>
		<-9.6796, 16.9626, 1.5613> <-9.6455, 16.9968, 1.5613> <-9.6455, 18.1324, 1.5613> <-9.6796, 18.1666, 1.5613>
		<-9.7512, 17.0341, 1.6066> <-9.7202, 17.0651, 1.6066> <-9.7202, 18.0641, 1.6066> <-9.7512, 18.0950, 1.6066>
		<-9.7364, 17.0193, 1.6486> <-9.7054, 17.0503, 1.6486> <-9.7054, 18.0789, 1.6486> <-9.7364, 18.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 18.1666, 1.5144> <-9.7138, 18.2008, 1.5144> <-10.8495, 18.2008, 1.5144> <-10.8837, 18.1666, 1.5144>
		<-9.6796, 18.1666, 1.5613> <-9.7138, 18.2008, 1.5613> <-10.8495, 18.2008, 1.5613> <-10.8837, 18.1666, 1.5613>
		<-9.7512, 18.0950, 1.6066> <-9.7822, 18.1260, 1.6066> <-10.7812, 18.1260, 1.6066> <-10.8121, 18.0950, 1.6066>
		<-9.7364, 18.1098, 1.6486> <-9.7674, 18.1408, 1.6486> <-10.7959, 18.1408, 1.6486> <-10.8269, 18.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 17.0193, 1.6486> <-10.8754, 16.9709, 1.7862> <-11.0172, 16.8290, 1.8960> <-11.0664, 16.7799, 2.0332>
		<-10.8579, 17.0503, 1.6486> <-10.9063, 17.0018, 1.7862> <-11.0618, 16.8736, 1.8960> <-11.1109, 16.8244, 2.0332>
		<-10.8579, 18.0789, 1.6486> <-10.9063, 18.1273, 1.7862> <-11.0618, 18.2556, 1.8960> <-11.1109, 18.3047, 2.0332>
		<-10.8269, 18.1098, 1.6486> <-10.8754, 18.1583, 1.7862> <-11.0172, 18.3002, 1.8960> <-11.0664, 18.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 17.0193, 1.6486> <-10.7959, 16.9884, 1.6486> <-9.7674, 16.9884, 1.6486> <-9.7364, 17.0193, 1.6486>
		<-10.8754, 16.9709, 1.7862> <-10.8444, 16.9399, 1.7862> <-9.7189, 16.9399, 1.7862> <-9.6880, 16.9709, 1.7862>
		<-11.0172, 16.8290, 1.8960> <-10.9727, 16.7844, 1.8960> <-9.5907, 16.7844, 1.8960> <-9.5461, 16.8290, 1.8960>
		<-11.0664, 16.7799, 2.0332> <-11.0218, 16.7353, 2.0332> <-9.5415, 16.7353, 2.0332> <-9.4970, 16.7799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 17.0193, 1.6486> <-9.7054, 17.0503, 1.6486> <-9.7054, 18.0789, 1.6486> <-9.7364, 18.1098, 1.6486>
		<-9.6880, 16.9709, 1.7862> <-9.6570, 17.0018, 1.7862> <-9.6570, 18.1273, 1.7862> <-9.6880, 18.1583, 1.7862>
		<-9.5461, 16.8290, 1.8960> <-9.5015, 16.8736, 1.8960> <-9.5015, 18.2556, 1.8960> <-9.5461, 18.3002, 1.8960>
		<-9.4970, 16.7799, 2.0332> <-9.4524, 16.8244, 2.0332> <-9.4524, 18.3047, 2.0332> <-9.4970, 18.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 18.1098, 1.6486> <-9.7674, 18.1408, 1.6486> <-10.7959, 18.1408, 1.6486> <-10.8269, 18.1098, 1.6486>
		<-9.6880, 18.1583, 1.7862> <-9.7189, 18.1893, 1.7862> <-10.8444, 18.1893, 1.7862> <-10.8754, 18.1583, 1.7862>
		<-9.5461, 18.3002, 1.8960> <-9.5907, 18.3447, 1.8960> <-10.9727, 18.3447, 1.8960> <-11.0172, 18.3002, 1.8960>
		<-9.4970, 18.3493, 2.0332> <-9.5415, 18.3939, 2.0332> <-11.0218, 18.3939, 2.0332> <-11.0664, 18.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 2.0332> <-11.0930, 16.7533, 2.1074> <-11.0932, 16.7530, 2.2382> <-11.0641, 16.7822, 2.3104>
		<-11.1109, 16.8244, 2.0332> <-11.1375, 16.7979, 2.1074> <-11.1376, 16.7975, 2.2382> <-11.1085, 16.8266, 2.3104>
		<-11.1109, 18.3047, 2.0332> <-11.1375, 18.3313, 2.1074> <-11.1376, 18.3317, 2.2382> <-11.1085, 18.3025, 2.3104>
		<-11.0664, 18.3493, 2.0332> <-11.0930, 18.3759, 2.1074> <-11.0932, 18.3761, 2.2382> <-11.0641, 18.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 16.7799, 2.0332> <-11.0218, 16.7353, 2.0332> <-9.5415, 16.7353, 2.0332> <-9.4970, 16.7799, 2.0332>
		<-11.0930, 16.7533, 2.1074> <-11.0484, 16.7087, 2.1074> <-9.5149, 16.7087, 2.1074> <-9.4704, 16.7533, 2.1074>
		<-11.0932, 16.7530, 2.2382> <-11.0488, 16.7086, 2.2382> <-9.5146, 16.7086, 2.2382> <-9.4701, 16.7530, 2.2382>
		<-11.0641, 16.7822, 2.3104> <-11.0196, 16.7378, 2.3104> <-9.5437, 16.7378, 2.3104> <-9.4993, 16.7822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.7799, 2.0332> <-9.4524, 16.8244, 2.0332> <-9.4524, 18.3047, 2.0332> <-9.4970, 18.3493, 2.0332>
		<-9.4704, 16.7533, 2.1074> <-9.4258, 16.7979, 2.1074> <-9.4258, 18.3313, 2.1074> <-9.4704, 18.3759, 2.1074>
		<-9.4701, 16.7530, 2.2382> <-9.4257, 16.7975, 2.2382> <-9.4257, 18.3317, 2.2382> <-9.4701, 18.3761, 2.2382>
		<-9.4993, 16.7822, 2.3104> <-9.4548, 16.8266, 2.3104> <-9.4548, 18.3025, 2.3104> <-9.4993, 18.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 18.3493, 2.0332> <-9.5415, 18.3939, 2.0332> <-11.0218, 18.3939, 2.0332> <-11.0664, 18.3493, 2.0332>
		<-9.4704, 18.3759, 2.1074> <-9.5149, 18.4204, 2.1074> <-11.0484, 18.4204, 2.1074> <-11.0930, 18.3759, 2.1074>
		<-9.4701, 18.3761, 2.2382> <-9.5146, 18.4206, 2.2382> <-11.0488, 18.4206, 2.2382> <-11.0932, 18.3761, 2.2382>
		<-9.4993, 18.3470, 2.3104> <-9.5437, 18.3914, 2.3104> <-11.0196, 18.3914, 2.3104> <-11.0641, 18.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 16.7822, 2.3104> <-10.9801, 16.8661, 2.5186> <-10.7843, 17.0620, 2.7154> <-10.7056, 17.1406, 2.9276>
		<-11.1085, 16.8266, 2.3104> <-11.0246, 16.9106, 2.5186> <-10.8084, 17.0860, 2.7154> <-10.7297, 17.1647, 2.9276>
		<-11.1085, 18.3025, 2.3104> <-11.0246, 18.2186, 2.5186> <-10.8084, 18.0431, 2.7154> <-10.7297, 17.9645, 2.9276>
		<-11.0641, 18.3470, 2.3104> <-10.9801, 18.2630, 2.5186> <-10.7843, 18.0672, 2.7154> <-10.7056, 17.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 16.7822, 2.3104> <-11.0196, 16.7378, 2.3104> <-9.5437, 16.7378, 2.3104> <-9.4993, 16.7822, 2.3104>
		<-10.9801, 16.8661, 2.5186> <-10.9357, 16.8217, 2.5186> <-9.6277, 16.8217, 2.5186> <-9.5832, 16.8661, 2.5186>
		<-10.7843, 17.0620, 2.7154> <-10.7602, 17.0379, 2.7154> <-9.8031, 17.0379, 2.7154> <-9.7790, 17.0620, 2.7154>
		<-10.7056, 17.1406, 2.9276> <-10.6815, 17.1165, 2.9276> <-9.8818, 17.1165, 2.9276> <-9.8577, 17.1406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 16.7822, 2.3104> <-9.4548, 16.8266, 2.3104> <-9.4548, 18.3025, 2.3104> <-9.4993, 18.3470, 2.3104>
		<-9.5832, 16.8661, 2.5186> <-9.5388, 16.9106, 2.5186> <-9.5388, 18.2186, 2.5186> <-9.5832, 18.2630, 2.5186>
		<-9.7790, 17.0620, 2.7154> <-9.7550, 17.0860, 2.7154> <-9.7550, 18.0431, 2.7154> <-9.7790, 18.0672, 2.7154>
		<-9.8577, 17.1406, 2.9276> <-9.8336, 17.1647, 2.9276> <-9.8336, 17.9645, 2.9276> <-9.8577, 17.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 18.3470, 2.3104> <-9.5437, 18.3914, 2.3104> <-11.0196, 18.3914, 2.3104> <-11.0641, 18.3470, 2.3104>
		<-9.5832, 18.2630, 2.5186> <-9.6277, 18.3075, 2.5186> <-10.9357, 18.3075, 2.5186> <-10.9801, 18.2630, 2.5186>
		<-9.7790, 18.0672, 2.7154> <-9.8031, 18.0913, 2.7154> <-10.7602, 18.0913, 2.7154> <-10.7843, 18.0672, 2.7154>
		<-9.8577, 17.9885, 2.9276> <-9.8818, 18.0126, 2.9276> <-10.6815, 18.0126, 2.9276> <-10.7056, 17.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 17.1406, 2.9276> <-10.6887, 17.1576, 2.9732> <-10.7889, 17.0574, 3.0012> <-10.7889, 17.0574, 3.0528>
		<-10.7297, 17.1647, 2.9276> <-10.7128, 17.1816, 2.9732> <-10.8177, 17.0862, 3.0012> <-10.8177, 17.0862, 3.0528>
		<-10.7297, 17.9645, 2.9276> <-10.7128, 17.9475, 2.9732> <-10.8177, 18.0430, 3.0012> <-10.8177, 18.0430, 3.0528>
		<-10.7056, 17.9885, 2.9276> <-10.6887, 17.9716, 2.9732> <-10.7889, 18.0718, 3.0012> <-10.7889, 18.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 17.1406, 2.9276> <-10.6815, 17.1165, 2.9276> <-9.8818, 17.1165, 2.9276> <-9.8577, 17.1406, 2.9276>
		<-10.6887, 17.1576, 2.9732> <-10.6646, 17.1335, 2.9732> <-9.8987, 17.1335, 2.9732> <-9.8746, 17.1576, 2.9732>
		<-10.7889, 17.0574, 3.0012> <-10.7601, 17.0286, 3.0012> <-9.8033, 17.0286, 3.0012> <-9.7745, 17.0574, 3.0012>
		<-10.7889, 17.0574, 3.0528> <-10.7601, 17.0286, 3.0528> <-9.8033, 17.0286, 3.0528> <-9.7745, 17.0574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 17.1406, 2.9276> <-9.8336, 17.1647, 2.9276> <-9.8336, 17.9645, 2.9276> <-9.8577, 17.9885, 2.9276>
		<-9.8746, 17.1576, 2.9732> <-9.8506, 17.1816, 2.9732> <-9.8506, 17.9475, 2.9732> <-9.8746, 17.9716, 2.9732>
		<-9.7745, 17.0574, 3.0012> <-9.7456, 17.0862, 3.0012> <-9.7456, 18.0430, 3.0012> <-9.7745, 18.0718, 3.0012>
		<-9.7745, 17.0574, 3.0528> <-9.7456, 17.0862, 3.0528> <-9.7456, 18.0430, 3.0528> <-9.7745, 18.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 17.9885, 2.9276> <-9.8818, 18.0126, 2.9276> <-10.6815, 18.0126, 2.9276> <-10.7056, 17.9885, 2.9276>
		<-9.8746, 17.9716, 2.9732> <-9.8987, 17.9957, 2.9732> <-10.6646, 17.9957, 2.9732> <-10.6887, 17.9716, 2.9732>
		<-9.7745, 18.0718, 3.0012> <-9.8033, 18.1006, 3.0012> <-10.7601, 18.1006, 3.0012> <-10.7889, 18.0718, 3.0012>
		<-9.7745, 18.0718, 3.0528> <-9.8033, 18.1006, 3.0528> <-10.7601, 18.1006, 3.0528> <-10.7889, 18.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 17.0574, 3.0528> <-10.7889, 17.0574, 3.1044> <-10.6862, 17.1600, 3.1344> <-10.7056, 17.1406, 3.1780>
		<-10.8177, 17.0862, 3.0528> <-10.8177, 17.0862, 3.1044> <-10.7103, 17.1841, 3.1344> <-10.7297, 17.1647, 3.1780>
		<-10.8177, 18.0430, 3.0528> <-10.8177, 18.0430, 3.1044> <-10.7103, 17.9451, 3.1344> <-10.7297, 17.9645, 3.1780>
		<-10.7889, 18.0718, 3.0528> <-10.7889, 18.0718, 3.1044> <-10.6862, 17.9691, 3.1344> <-10.7056, 17.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 17.0574, 3.0528> <-10.7601, 17.0286, 3.0528> <-9.8033, 17.0286, 3.0528> <-9.7745, 17.0574, 3.0528>
		<-10.7889, 17.0574, 3.1044> <-10.7601, 17.0286, 3.1044> <-9.8033, 17.0286, 3.1044> <-9.7745, 17.0574, 3.1044>
		<-10.6862, 17.1600, 3.1344> <-10.6621, 17.1359, 3.1344> <-9.9012, 17.1359, 3.1344> <-9.8771, 17.1600, 3.1344>
		<-10.7056, 17.1406, 3.1780> <-10.6815, 17.1165, 3.1780> <-9.8818, 17.1165, 3.1780> <-9.8577, 17.1406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 17.0574, 3.0528> <-9.7456, 17.0862, 3.0528> <-9.7456, 18.0430, 3.0528> <-9.7745, 18.0718, 3.0528>
		<-9.7745, 17.0574, 3.1044> <-9.7456, 17.0862, 3.1044> <-9.7456, 18.0430, 3.1044> <-9.7745, 18.0718, 3.1044>
		<-9.8771, 17.1600, 3.1344> <-9.8530, 17.1841, 3.1344> <-9.8530, 17.9451, 3.1344> <-9.8771, 17.9691, 3.1344>
		<-9.8577, 17.1406, 3.1780> <-9.8336, 17.1647, 3.1780> <-9.8336, 17.9645, 3.1780> <-9.8577, 17.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 18.0718, 3.0528> <-9.8033, 18.1006, 3.0528> <-10.7601, 18.1006, 3.0528> <-10.7889, 18.0718, 3.0528>
		<-9.7745, 18.0718, 3.1044> <-9.8033, 18.1006, 3.1044> <-10.7601, 18.1006, 3.1044> <-10.7889, 18.0718, 3.1044>
		<-9.8771, 17.9691, 3.1344> <-9.9012, 17.9932, 3.1344> <-10.6621, 17.9932, 3.1344> <-10.6862, 17.9691, 3.1344>
		<-9.8577, 17.9885, 3.1780> <-9.8818, 18.0126, 3.1780> <-10.6815, 18.0126, 3.1780> <-10.7056, 17.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 17.1406, 3.1780> <-10.7438, 17.1024, 3.2640> <-10.8610, 16.9852, 3.2738> <-10.9161, 16.9302, 3.3390>
		<-10.7297, 17.1647, 3.1780> <-10.7679, 17.1265, 3.2640> <-10.8971, 17.0212, 3.2738> <-10.9521, 16.9662, 3.3390>
		<-10.7297, 17.9645, 3.1780> <-10.7679, 18.0027, 3.2640> <-10.8971, 18.1079, 3.2738> <-10.9521, 18.1629, 3.3390>
		<-10.7056, 17.9885, 3.1780> <-10.7438, 18.0267, 3.2640> <-10.8610, 18.1440, 3.2738> <-10.9161, 18.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 17.1406, 3.1780> <-10.6815, 17.1165, 3.1780> <-9.8818, 17.1165, 3.1780> <-9.8577, 17.1406, 3.1780>
		<-10.7438, 17.1024, 3.2640> <-10.7197, 17.0784, 3.2640> <-9.8436, 17.0784, 3.2640> <-9.8195, 17.1024, 3.2640>
		<-10.8610, 16.9852, 3.2738> <-10.8250, 16.9492, 3.2738> <-9.7383, 16.9492, 3.2738> <-9.7023, 16.9852, 3.2738>
		<-10.9161, 16.9302, 3.3390> <-10.8800, 16.8942, 3.3390> <-9.6833, 16.8942, 3.3390> <-9.6473, 16.9302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 17.1406, 3.1780> <-9.8336, 17.1647, 3.1780> <-9.8336, 17.9645, 3.1780> <-9.8577, 17.9885, 3.1780>
		<-9.8195, 17.1024, 3.2640> <-9.7954, 17.1265, 3.2640> <-9.7954, 18.0027, 3.2640> <-9.8195, 18.0267, 3.2640>
		<-9.7023, 16.9852, 3.2738> <-9.6663, 17.0212, 3.2738> <-9.6663, 18.1079, 3.2738> <-9.7023, 18.1440, 3.2738>
		<-9.6473, 16.9302, 3.3390> <-9.6112, 16.9662, 3.3390> <-9.6112, 18.1629, 3.3390> <-9.6473, 18.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 17.9885, 3.1780> <-9.8818, 18.0126, 3.1780> <-10.6815, 18.0126, 3.1780> <-10.7056, 17.9885, 3.1780>
		<-9.8195, 18.0267, 3.2640> <-9.8436, 18.0508, 3.2640> <-10.7197, 18.0508, 3.2640> <-10.7438, 18.0267, 3.2640>
		<-9.7023, 18.1440, 3.2738> <-9.7383, 18.1800, 3.2738> <-10.8250, 18.1800, 3.2738> <-10.8610, 18.1440, 3.2738>
		<-9.6473, 18.1990, 3.3390> <-9.6833, 18.2350, 3.3390> <-10.8800, 18.2350, 3.3390> <-10.9161, 18.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 16.9302, 3.3390> <-10.9416, 16.9046, 3.3693> <-10.9797, 16.8665, 3.4419> <-10.9623, 16.8839, 3.4821>
		<-10.9521, 16.9662, 3.3390> <-10.9777, 16.9406, 3.3693> <-11.0184, 16.9052, 3.4419> <-11.0010, 16.9226, 3.4821>
		<-10.9521, 18.1629, 3.3390> <-10.9777, 18.1885, 3.3693> <-11.0184, 18.2240, 3.4419> <-11.0010, 18.2066, 3.4821>
		<-10.9161, 18.1990, 3.3390> <-10.9416, 18.2246, 3.3693> <-10.9797, 18.2627, 3.4419> <-10.9623, 18.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 16.9302, 3.3390> <-10.8800, 16.8942, 3.3390> <-9.6833, 16.8942, 3.3390> <-9.6473, 16.9302, 3.3390>
		<-10.9416, 16.9046, 3.3693> <-10.9056, 16.8686, 3.3693> <-9.6577, 16.8686, 3.3693> <-9.6217, 16.9046, 3.3693>
		<-10.9797, 16.8665, 3.4419> <-10.9411, 16.8279, 3.4419> <-9.6223, 16.8279, 3.4419> <-9.5836, 16.8665, 3.4419>
		<-10.9623, 16.8839, 3.4821> <-10.9236, 16.8453, 3.4821> <-9.6397, 16.8453, 3.4821> <-9.6010, 16.8839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 16.9302, 3.3390> <-9.6112, 16.9662, 3.3390> <-9.6112, 18.1629, 3.3390> <-9.6473, 18.1990, 3.3390>
		<-9.6217, 16.9046, 3.3693> <-9.5857, 16.9406, 3.3693> <-9.5857, 18.1885, 3.3693> <-9.6217, 18.2246, 3.3693>
		<-9.5836, 16.8665, 3.4419> <-9.5449, 16.9052, 3.4419> <-9.5449, 18.2240, 3.4419> <-9.5836, 18.2627, 3.4419>
		<-9.6010, 16.8839, 3.4821> <-9.5624, 16.9226, 3.4821> <-9.5624, 18.2066, 3.4821> <-9.6010, 18.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 18.1990, 3.3390> <-9.6833, 18.2350, 3.3390> <-10.8800, 18.2350, 3.3390> <-10.9161, 18.1990, 3.3390>
		<-9.6217, 18.2246, 3.3693> <-9.6577, 18.2606, 3.3693> <-10.9056, 18.2606, 3.3693> <-10.9416, 18.2246, 3.3693>
		<-9.5836, 18.2627, 3.4419> <-9.6223, 18.3013, 3.4419> <-10.9411, 18.3013, 3.4419> <-10.9797, 18.2627, 3.4419>
		<-9.6010, 18.2452, 3.4821> <-9.6397, 18.2839, 3.4821> <-10.9236, 18.2839, 3.4821> <-10.9623, 18.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 16.8839, 3.4821> <-10.9163, 16.9300, 3.5884> <-10.7961, 17.0502, 3.6567> <-10.7380, 17.1083, 3.7504>
		<-11.0010, 16.9226, 3.4821> <-10.9550, 16.9686, 3.5884> <-10.8220, 17.0761, 3.6567> <-10.7639, 17.1342, 3.7504>
		<-11.0010, 18.2066, 3.4821> <-10.9550, 18.1606, 3.5884> <-10.8220, 18.0531, 3.6567> <-10.7639, 17.9950, 3.7504>
		<-10.9623, 18.2452, 3.4821> <-10.9163, 18.1992, 3.5884> <-10.7961, 18.0790, 3.6567> <-10.7380, 18.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 16.8839, 3.4821> <-10.9236, 16.8453, 3.4821> <-9.6397, 16.8453, 3.4821> <-9.6010, 16.8839, 3.4821>
		<-10.9163, 16.9300, 3.5884> <-10.8776, 16.8913, 3.5884> <-9.6857, 16.8913, 3.5884> <-9.6470, 16.9300, 3.5884>
		<-10.7961, 17.0502, 3.6567> <-10.7702, 17.0242, 3.6567> <-9.7932, 17.0242, 3.6567> <-9.7672, 17.0502, 3.6567>
		<-10.7380, 17.1083, 3.7504> <-10.7121, 17.0823, 3.7504> <-9.8513, 17.0823, 3.7504> <-9.8253, 17.1083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 16.8839, 3.4821> <-9.5624, 16.9226, 3.4821> <-9.5624, 18.2066, 3.4821> <-9.6010, 18.2452, 3.4821>
		<-9.6470, 16.9300, 3.5884> <-9.6084, 16.9686, 3.5884> <-9.6084, 18.1606, 3.5884> <-9.6470, 18.1992, 3.5884>
		<-9.7672, 17.0502, 3.6567> <-9.7413, 17.0761, 3.6567> <-9.7413, 18.0531, 3.6567> <-9.7672, 18.0790, 3.6567>
		<-9.8253, 17.1083, 3.7504> <-9.7994, 17.1342, 3.7504> <-9.7994, 17.9950, 3.7504> <-9.8253, 18.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 18.2452, 3.4821> <-9.6397, 18.2839, 3.4821> <-10.9236, 18.2839, 3.4821> <-10.9623, 18.2452, 3.4821>
		<-9.6470, 18.1992, 3.5884> <-9.6857, 18.2379, 3.5884> <-10.8776, 18.2379, 3.5884> <-10.9163, 18.1992, 3.5884>
		<-9.7672, 18.0790, 3.6567> <-9.7932, 18.1049, 3.6567> <-10.7702, 18.1049, 3.6567> <-10.7961, 18.0790, 3.6567>
		<-9.8253, 18.0209, 3.7504> <-9.8513, 18.0468, 3.7504> <-10.7121, 18.0468, 3.7504> <-10.7380, 18.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 17.1083, 3.7504> <-10.6964, 17.1498, 3.8175> <-10.6527, 17.1935, 3.9241> <-10.6352, 17.2110, 4.0098>
		<-10.7639, 17.1342, 3.7504> <-10.7223, 17.1757, 3.8175> <-10.6728, 17.2136, 3.9241> <-10.6553, 17.2311, 4.0098>
		<-10.7639, 17.9950, 3.7504> <-10.7223, 17.9534, 3.8175> <-10.6728, 17.9156, 3.9241> <-10.6553, 17.8981, 4.0098>
		<-10.7380, 18.0209, 3.7504> <-10.6964, 17.9793, 3.8175> <-10.6527, 17.9356, 3.9241> <-10.6352, 17.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 17.1083, 3.7504> <-10.7121, 17.0823, 3.7504> <-9.8513, 17.0823, 3.7504> <-9.8253, 17.1083, 3.7504>
		<-10.6964, 17.1498, 3.8175> <-10.6705, 17.1239, 3.8175> <-9.8928, 17.1239, 3.8175> <-9.8669, 17.1498, 3.8175>
		<-10.6527, 17.1935, 3.9241> <-10.6326, 17.1734, 3.9241> <-9.9307, 17.1734, 3.9241> <-9.9106, 17.1935, 3.9241>
		<-10.6352, 17.2110, 4.0098> <-10.6152, 17.1909, 4.0098> <-9.9482, 17.1909, 4.0098> <-9.9281, 17.2110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 17.1083, 3.7504> <-9.7994, 17.1342, 3.7504> <-9.7994, 17.9950, 3.7504> <-9.8253, 18.0209, 3.7504>
		<-9.8669, 17.1498, 3.8175> <-9.8410, 17.1757, 3.8175> <-9.8410, 17.9534, 3.8175> <-9.8669, 17.9793, 3.8175>
		<-9.9106, 17.1935, 3.9241> <-9.8905, 17.2136, 3.9241> <-9.8905, 17.9156, 3.9241> <-9.9106, 17.9356, 3.9241>
		<-9.9281, 17.2110, 4.0098> <-9.9080, 17.2311, 4.0098> <-9.9080, 17.8981, 4.0098> <-9.9281, 17.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 18.0209, 3.7504> <-9.8513, 18.0468, 3.7504> <-10.7121, 18.0468, 3.7504> <-10.7380, 18.0209, 3.7504>
		<-9.8669, 17.9793, 3.8175> <-9.8928, 18.0053, 3.8175> <-10.6705, 18.0053, 3.8175> <-10.6964, 17.9793, 3.8175>
		<-9.9106, 17.9356, 3.9241> <-9.9307, 17.9557, 3.9241> <-10.6326, 17.9557, 3.9241> <-10.6527, 17.9356, 3.9241>
		<-9.9281, 17.9182, 4.0098> <-9.9482, 17.9383, 4.0098> <-10.6152, 17.9383, 4.0098> <-10.6352, 17.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 17.2110, 4.0098> <-10.6168, 17.2294, 4.1002> <-10.6221, 17.2242, 4.2288> <-10.6213, 17.2250, 4.3229>
		<-10.6553, 17.2311, 4.0098> <-10.6369, 17.2495, 4.1002> <-10.6413, 17.2435, 4.2288> <-10.6405, 17.2443, 4.3229>
		<-10.6553, 17.8981, 4.0098> <-10.6369, 17.8797, 4.1002> <-10.6413, 17.8857, 4.2288> <-10.6405, 17.8849, 4.3229>
		<-10.6352, 17.9182, 4.0098> <-10.6168, 17.8997, 4.1002> <-10.6221, 17.9050, 4.2288> <-10.6213, 17.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 17.2110, 4.0098> <-10.6152, 17.1909, 4.0098> <-9.9482, 17.1909, 4.0098> <-9.9281, 17.2110, 4.0098>
		<-10.6168, 17.2294, 4.1002> <-10.5967, 17.2094, 4.1002> <-9.9666, 17.2094, 4.1002> <-9.9465, 17.2294, 4.1002>
		<-10.6221, 17.2242, 4.2288> <-10.6028, 17.2049, 4.2288> <-9.9606, 17.2049, 4.2288> <-9.9413, 17.2242, 4.2288>
		<-10.6213, 17.2250, 4.3229> <-10.6020, 17.2057, 4.3229> <-9.9614, 17.2057, 4.3229> <-9.9421, 17.2250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 17.2110, 4.0098> <-9.9080, 17.2311, 4.0098> <-9.9080, 17.8981, 4.0098> <-9.9281, 17.9182, 4.0098>
		<-9.9465, 17.2294, 4.1002> <-9.9264, 17.2495, 4.1002> <-9.9264, 17.8797, 4.1002> <-9.9465, 17.8997, 4.1002>
		<-9.9413, 17.2242, 4.2288> <-9.9220, 17.2435, 4.2288> <-9.9220, 17.8857, 4.2288> <-9.9413, 17.9050, 4.2288>
		<-9.9421, 17.2250, 4.3229> <-9.9228, 17.2443, 4.3229> <-9.9228, 17.8849, 4.3229> <-9.9421, 17.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 17.9182, 4.0098> <-9.9482, 17.9383, 4.0098> <-10.6152, 17.9383, 4.0098> <-10.6352, 17.9182, 4.0098>
		<-9.9465, 17.8997, 4.1002> <-9.9666, 17.9198, 4.1002> <-10.5967, 17.9198, 4.1002> <-10.6168, 17.8997, 4.1002>
		<-9.9413, 17.9050, 4.2288> <-9.9606, 17.9243, 4.2288> <-10.6028, 17.9243, 4.2288> <-10.6221, 17.9050, 4.2288>
		<-9.9421, 17.9042, 4.3229> <-9.9614, 17.9235, 4.3229> <-10.6020, 17.9235, 4.3229> <-10.6213, 17.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 17.2250, 4.3229> <-10.6179, 17.2284, 4.7283> <-10.6197, 17.2265, 5.2689> <-10.6213, 17.2250, 5.6744>
		<-10.6405, 17.2443, 4.3229> <-10.6371, 17.2477, 4.7283> <-10.6390, 17.2458, 5.2689> <-10.6405, 17.2443, 5.6744>
		<-10.6405, 17.8849, 4.3229> <-10.6371, 17.8815, 4.7283> <-10.6390, 17.8834, 5.2689> <-10.6405, 17.8849, 5.6744>
		<-10.6213, 17.9042, 4.3229> <-10.6179, 17.9008, 4.7283> <-10.6197, 17.9027, 5.2689> <-10.6213, 17.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 17.2250, 4.3229> <-10.6020, 17.2057, 4.3229> <-9.9614, 17.2057, 4.3229> <-9.9421, 17.2250, 4.3229>
		<-10.6179, 17.2284, 4.7283> <-10.5986, 17.2091, 4.7283> <-9.9648, 17.2091, 4.7283> <-9.9455, 17.2284, 4.7283>
		<-10.6197, 17.2265, 5.2689> <-10.6004, 17.2072, 5.2689> <-9.9629, 17.2072, 5.2689> <-9.9436, 17.2265, 5.2689>
		<-10.6213, 17.2250, 5.6744> <-10.6020, 17.2057, 5.6744> <-9.9614, 17.2057, 5.6744> <-9.9421, 17.2250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 17.2250, 4.3229> <-9.9228, 17.2443, 4.3229> <-9.9228, 17.8849, 4.3229> <-9.9421, 17.9042, 4.3229>
		<-9.9455, 17.2284, 4.7283> <-9.9262, 17.2477, 4.7283> <-9.9262, 17.8815, 4.7283> <-9.9455, 17.9008, 4.7283>
		<-9.9436, 17.2265, 5.2689> <-9.9243, 17.2458, 5.2689> <-9.9243, 17.8834, 5.2689> <-9.9436, 17.9027, 5.2689>
		<-9.9421, 17.2250, 5.6744> <-9.9228, 17.2443, 5.6744> <-9.9228, 17.8849, 5.6744> <-9.9421, 17.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 17.9042, 4.3229> <-9.9614, 17.9235, 4.3229> <-10.6020, 17.9235, 4.3229> <-10.6213, 17.9042, 4.3229>
		<-9.9455, 17.9008, 4.7283> <-9.9648, 17.9201, 4.7283> <-10.5986, 17.9201, 4.7283> <-10.6179, 17.9008, 4.7283>
		<-9.9436, 17.9027, 5.2689> <-9.9629, 17.9219, 5.2689> <-10.6004, 17.9219, 5.2689> <-10.6197, 17.9027, 5.2689>
		<-9.9421, 17.9042, 5.6744> <-9.9614, 17.9235, 5.6744> <-10.6020, 17.9235, 5.6744> <-10.6213, 17.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 17.2250, 5.6744> <-10.6225, 17.2237, 6.0073> <-10.6172, 17.2290, 6.4517> <-10.6305, 17.2157, 6.7841>
		<-10.6405, 17.2443, 5.6744> <-10.6418, 17.2430, 6.0073> <-10.6371, 17.2488, 6.4517> <-10.6503, 17.2355, 6.7841>
		<-10.6405, 17.8849, 5.6744> <-10.6418, 17.8861, 6.0073> <-10.6371, 17.8804, 6.4517> <-10.6503, 17.8936, 6.7841>
		<-10.6213, 17.9042, 5.6744> <-10.6225, 17.9054, 6.0073> <-10.6172, 17.9002, 6.4517> <-10.6305, 17.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 17.2250, 5.6744> <-10.6020, 17.2057, 5.6744> <-9.9614, 17.2057, 5.6744> <-9.9421, 17.2250, 5.6744>
		<-10.6225, 17.2237, 6.0073> <-10.6032, 17.2044, 6.0073> <-9.9601, 17.2044, 6.0073> <-9.9408, 17.2237, 6.0073>
		<-10.6172, 17.2290, 6.4517> <-10.5974, 17.2092, 6.4517> <-9.9659, 17.2092, 6.4517> <-9.9461, 17.2290, 6.4517>
		<-10.6305, 17.2157, 6.7841> <-10.6107, 17.1959, 6.7841> <-9.9526, 17.1959, 6.7841> <-9.9328, 17.2157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 17.2250, 5.6744> <-9.9228, 17.2443, 5.6744> <-9.9228, 17.8849, 5.6744> <-9.9421, 17.9042, 5.6744>
		<-9.9408, 17.2237, 6.0073> <-9.9215, 17.2430, 6.0073> <-9.9215, 17.8861, 6.0073> <-9.9408, 17.9054, 6.0073>
		<-9.9461, 17.2290, 6.4517> <-9.9263, 17.2488, 6.4517> <-9.9263, 17.8804, 6.4517> <-9.9461, 17.9002, 6.4517>
		<-9.9328, 17.2157, 6.7841> <-9.9130, 17.2355, 6.7841> <-9.9130, 17.8936, 6.7841> <-9.9328, 17.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 17.9042, 5.6744> <-9.9614, 17.9235, 5.6744> <-10.6020, 17.9235, 5.6744> <-10.6213, 17.9042, 5.6744>
		<-9.9408, 17.9054, 6.0073> <-9.9601, 17.9247, 6.0073> <-10.6032, 17.9247, 6.0073> <-10.6225, 17.9054, 6.0073>
		<-9.9461, 17.9002, 6.4517> <-9.9659, 17.9200, 6.4517> <-10.5974, 17.9200, 6.4517> <-10.6172, 17.9002, 6.4517>
		<-9.9328, 17.9134, 6.7841> <-9.9526, 17.9333, 6.7841> <-10.6107, 17.9333, 6.7841> <-10.6305, 17.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 17.2157, 6.7841> <-10.6325, 17.2137, 6.8341> <-10.6449, 17.2013, 6.9079> <-10.6718, 17.1745, 6.9405>
		<-10.6503, 17.2355, 6.7841> <-10.6523, 17.2336, 6.8341> <-10.6671, 17.2235, 6.9079> <-10.6940, 17.1966, 6.9405>
		<-10.6503, 17.8936, 6.7841> <-10.6523, 17.8956, 6.8341> <-10.6671, 17.9057, 6.9079> <-10.6940, 17.9326, 6.9405>
		<-10.6305, 17.9134, 6.7841> <-10.6325, 17.9154, 6.8341> <-10.6449, 17.9278, 6.9079> <-10.6718, 17.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 17.2157, 6.7841> <-10.6107, 17.1959, 6.7841> <-9.9526, 17.1959, 6.7841> <-9.9328, 17.2157, 6.7841>
		<-10.6325, 17.2137, 6.8341> <-10.6127, 17.1939, 6.8341> <-9.9506, 17.1939, 6.8341> <-9.9308, 17.2137, 6.8341>
		<-10.6449, 17.2013, 6.9079> <-10.6228, 17.1792, 6.9079> <-9.9406, 17.1792, 6.9079> <-9.9184, 17.2013, 6.9079>
		<-10.6718, 17.1745, 6.9405> <-10.6496, 17.1523, 6.9405> <-9.9137, 17.1523, 6.9405> <-9.8915, 17.1745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 17.2157, 6.7841> <-9.9130, 17.2355, 6.7841> <-9.9130, 17.8936, 6.7841> <-9.9328, 17.9134, 6.7841>
		<-9.9308, 17.2137, 6.8341> <-9.9110, 17.2336, 6.8341> <-9.9110, 17.8956, 6.8341> <-9.9308, 17.9154, 6.8341>
		<-9.9184, 17.2013, 6.9079> <-9.8962, 17.2235, 6.9079> <-9.8962, 17.9057, 6.9079> <-9.9184, 17.9278, 6.9079>
		<-9.8915, 17.1745, 6.9405> <-9.8694, 17.1966, 6.9405> <-9.8694, 17.9326, 6.9405> <-9.8915, 17.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 17.9134, 6.7841> <-9.9526, 17.9333, 6.7841> <-10.6107, 17.9333, 6.7841> <-10.6305, 17.9134, 6.7841>
		<-9.9308, 17.9154, 6.8341> <-9.9506, 17.9352, 6.8341> <-10.6127, 17.9352, 6.8341> <-10.6325, 17.9154, 6.8341>
		<-9.9184, 17.9278, 6.9079> <-9.9406, 17.9500, 6.9079> <-10.6228, 17.9500, 6.9079> <-10.6449, 17.9278, 6.9079>
		<-9.8915, 17.9547, 6.9405> <-9.9137, 17.9769, 6.9405> <-10.6496, 17.9769, 6.9405> <-10.6718, 17.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 17.1745, 6.9405> <-10.7339, 17.1123, 7.0160> <-10.8620, 16.9842, 7.0331> <-10.9114, 16.9348, 7.1255>
		<-10.6940, 17.1966, 6.9405> <-10.7561, 17.1345, 7.0160> <-10.8978, 17.0200, 7.0331> <-10.9472, 16.9706, 7.1255>
		<-10.6940, 17.9326, 6.9405> <-10.7561, 17.9947, 7.0160> <-10.8978, 18.1092, 7.0331> <-10.9472, 18.1586, 7.1255>
		<-10.6718, 17.9547, 6.9405> <-10.7339, 18.0168, 7.0160> <-10.8620, 18.1449, 7.0331> <-10.9114, 18.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 17.1745, 6.9405> <-10.6496, 17.1523, 6.9405> <-9.9137, 17.1523, 6.9405> <-9.8915, 17.1745, 6.9405>
		<-10.7339, 17.1123, 7.0160> <-10.7117, 17.0902, 7.0160> <-9.8516, 17.0902, 7.0160> <-9.8294, 17.1123, 7.0160>
		<-10.8620, 16.9842, 7.0331> <-10.8262, 16.9485, 7.0331> <-9.7371, 16.9485, 7.0331> <-9.7013, 16.9842, 7.0331>
		<-10.9114, 16.9348, 7.1255> <-10.8757, 16.8990, 7.1255> <-9.6877, 16.8990, 7.1255> <-9.6519, 16.9348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 17.1745, 6.9405> <-9.8694, 17.1966, 6.9405> <-9.8694, 17.9326, 6.9405> <-9.8915, 17.9547, 6.9405>
		<-9.8294, 17.1123, 7.0160> <-9.8073, 17.1345, 7.0160> <-9.8073, 17.9947, 7.0160> <-9.8294, 18.0168, 7.0160>
		<-9.7013, 16.9842, 7.0331> <-9.6655, 17.0200, 7.0331> <-9.6655, 18.1092, 7.0331> <-9.7013, 18.1449, 7.0331>
		<-9.6519, 16.9348, 7.1255> <-9.6161, 16.9706, 7.1255> <-9.6161, 18.1586, 7.1255> <-9.6519, 18.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 17.9547, 6.9405> <-9.9137, 17.9769, 6.9405> <-10.6496, 17.9769, 6.9405> <-10.6718, 17.9547, 6.9405>
		<-9.8294, 18.0168, 7.0160> <-9.8516, 18.0390, 7.0160> <-10.7117, 18.0390, 7.0160> <-10.7339, 18.0168, 7.0160>
		<-9.7013, 18.1449, 7.0331> <-9.7371, 18.1807, 7.0331> <-10.8262, 18.1807, 7.0331> <-10.8620, 18.1449, 7.0331>
		<-9.6519, 18.1944, 7.1255> <-9.6877, 18.2301, 7.1255> <-10.8757, 18.2301, 7.1255> <-10.9114, 18.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 16.9348, 7.1255> <-10.9319, 16.9143, 7.1638> <-10.8316, 17.0146, 7.1912> <-10.8316, 17.0146, 7.2393>
		<-10.9472, 16.9706, 7.1255> <-10.9677, 16.9501, 7.1638> <-10.8629, 17.0459, 7.1912> <-10.8629, 17.0459, 7.2393>
		<-10.9472, 18.1586, 7.1255> <-10.9677, 18.1791, 7.1638> <-10.8629, 18.0833, 7.1912> <-10.8629, 18.0833, 7.2393>
		<-10.9114, 18.1944, 7.1255> <-10.9319, 18.2149, 7.1638> <-10.8316, 18.1145, 7.1912> <-10.8316, 18.1145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 16.9348, 7.1255> <-10.8757, 16.8990, 7.1255> <-9.6877, 16.8990, 7.1255> <-9.6519, 16.9348, 7.1255>
		<-10.9319, 16.9143, 7.1638> <-10.8962, 16.8785, 7.1638> <-9.6671, 16.8785, 7.1638> <-9.6314, 16.9143, 7.1638>
		<-10.8316, 17.0146, 7.1912> <-10.8004, 16.9834, 7.1912> <-9.7629, 16.9834, 7.1912> <-9.7317, 17.0146, 7.1912>
		<-10.8316, 17.0146, 7.2393> <-10.8004, 16.9834, 7.2393> <-9.7629, 16.9834, 7.2393> <-9.7317, 17.0146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 16.9348, 7.1255> <-9.6161, 16.9706, 7.1255> <-9.6161, 18.1586, 7.1255> <-9.6519, 18.1944, 7.1255>
		<-9.6314, 16.9143, 7.1638> <-9.5956, 16.9501, 7.1638> <-9.5956, 18.1791, 7.1638> <-9.6314, 18.2149, 7.1638>
		<-9.7317, 17.0146, 7.1912> <-9.7005, 17.0459, 7.1912> <-9.7005, 18.0833, 7.1912> <-9.7317, 18.1145, 7.1912>
		<-9.7317, 17.0146, 7.2393> <-9.7005, 17.0459, 7.2393> <-9.7005, 18.0833, 7.2393> <-9.7317, 18.1145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 18.1944, 7.1255> <-9.6877, 18.2301, 7.1255> <-10.8757, 18.2301, 7.1255> <-10.9114, 18.1944, 7.1255>
		<-9.6314, 18.2149, 7.1638> <-9.6671, 18.2506, 7.1638> <-10.8962, 18.2506, 7.1638> <-10.9319, 18.2149, 7.1638>
		<-9.7317, 18.1145, 7.1912> <-9.7629, 18.1458, 7.1912> <-10.8004, 18.1458, 7.1912> <-10.8316, 18.1145, 7.1912>
		<-9.7317, 18.1145, 7.2393> <-9.7629, 18.1458, 7.2393> <-10.8004, 18.1458, 7.2393> <-10.8316, 18.1145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 17.0146, 7.2393> <-10.8316, 17.0146, 7.2905> <-10.9054, 16.9408, 7.3169> <-10.9114, 16.9348, 7.3673>
		<-10.8629, 17.0459, 7.2393> <-10.8629, 17.0459, 7.2905> <-10.9412, 16.9766, 7.3169> <-10.9472, 16.9706, 7.3673>
		<-10.8629, 18.0833, 7.2393> <-10.8629, 18.0833, 7.2905> <-10.9412, 18.1526, 7.3169> <-10.9472, 18.1586, 7.3673>
		<-10.8316, 18.1145, 7.2393> <-10.8316, 18.1145, 7.2905> <-10.9054, 18.1883, 7.3169> <-10.9114, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 17.0146, 7.2393> <-10.8004, 16.9834, 7.2393> <-9.7629, 16.9834, 7.2393> <-9.7317, 17.0146, 7.2393>
		<-10.8316, 17.0146, 7.2905> <-10.8004, 16.9834, 7.2905> <-9.7629, 16.9834, 7.2905> <-9.7317, 17.0146, 7.2905>
		<-10.9054, 16.9408, 7.3169> <-10.8696, 16.9051, 7.3169> <-9.6937, 16.9051, 7.3169> <-9.6579, 16.9408, 7.3169>
		<-10.9114, 16.9348, 7.3673> <-10.8757, 16.8990, 7.3673> <-9.6877, 16.8990, 7.3673> <-9.6519, 16.9348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 17.0146, 7.2393> <-9.7005, 17.0459, 7.2393> <-9.7005, 18.0833, 7.2393> <-9.7317, 18.1145, 7.2393>
		<-9.7317, 17.0146, 7.2905> <-9.7005, 17.0459, 7.2905> <-9.7005, 18.0833, 7.2905> <-9.7317, 18.1145, 7.2905>
		<-9.6579, 16.9408, 7.3169> <-9.6222, 16.9766, 7.3169> <-9.6222, 18.1526, 7.3169> <-9.6579, 18.1883, 7.3169>
		<-9.6519, 16.9348, 7.3673> <-9.6161, 16.9706, 7.3673> <-9.6161, 18.1586, 7.3673> <-9.6519, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 18.1145, 7.2393> <-9.7629, 18.1458, 7.2393> <-10.8004, 18.1458, 7.2393> <-10.8316, 18.1145, 7.2393>
		<-9.7317, 18.1145, 7.2905> <-9.7629, 18.1458, 7.2905> <-10.8004, 18.1458, 7.2905> <-10.8316, 18.1145, 7.2905>
		<-9.6579, 18.1883, 7.3169> <-9.6937, 18.2241, 7.3169> <-10.8696, 18.2241, 7.3169> <-10.9054, 18.1883, 7.3169>
		<-9.6519, 18.1944, 7.3673> <-9.6877, 18.2301, 7.3673> <-10.8757, 18.2301, 7.3673> <-10.9114, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 16.9348, 7.9080> <-10.9472, 16.9706, 7.9080> <-10.9472, 18.1586, 7.9080> <-10.9114, 18.1944, 7.9080>
		<-10.9114, 16.9348, 7.7458> <-10.9472, 16.9706, 7.7458> <-10.9472, 18.1586, 7.7458> <-10.9114, 18.1944, 7.7458>
		<-10.9305, 16.9157, 7.5273> <-10.9663, 16.9515, 7.5273> <-10.9663, 18.1777, 7.5273> <-10.9305, 18.2134, 7.5273>
		<-10.9114, 16.9348, 7.3673> <-10.9472, 16.9706, 7.3673> <-10.9472, 18.1586, 7.3673> <-10.9114, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 16.9348, 7.9080> <-10.9114, 16.9348, 7.7458> <-10.9305, 16.9157, 7.5273> <-10.9114, 16.9348, 7.3673>
		<-10.8757, 16.8990, 7.9080> <-10.8757, 16.8990, 7.7458> <-10.8947, 16.8800, 7.5273> <-10.8757, 16.8990, 7.3673>
		<-9.6877, 16.8990, 7.9080> <-9.6877, 16.8990, 7.7458> <-9.6686, 16.8800, 7.5273> <-9.6877, 16.8990, 7.3673>
		<-9.6519, 16.9348, 7.9080> <-9.6519, 16.9348, 7.7458> <-9.6328, 16.9157, 7.5273> <-9.6519, 16.9348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 16.9348, 7.9080> <-9.6519, 16.9348, 7.7458> <-9.6328, 16.9157, 7.5273> <-9.6519, 16.9348, 7.3673>
		<-9.6161, 16.9706, 7.9080> <-9.6161, 16.9706, 7.7458> <-9.5970, 16.9515, 7.5273> <-9.6161, 16.9706, 7.3673>
		<-9.6161, 18.1586, 7.9080> <-9.6161, 18.1586, 7.7458> <-9.5970, 18.1777, 7.5273> <-9.6161, 18.1586, 7.3673>
		<-9.6519, 18.1944, 7.9080> <-9.6519, 18.1944, 7.7458> <-9.6328, 18.2134, 7.5273> <-9.6519, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 18.1944, 7.9080> <-9.6519, 18.1944, 7.7458> <-9.6328, 18.2134, 7.5273> <-9.6519, 18.1944, 7.3673>
		<-9.6877, 18.2301, 7.9080> <-9.6877, 18.2301, 7.7458> <-9.6686, 18.2492, 7.5273> <-9.6877, 18.2301, 7.3673>
		<-10.8757, 18.2301, 7.9080> <-10.8757, 18.2301, 7.7458> <-10.8947, 18.2492, 7.5273> <-10.8757, 18.2301, 7.3673>
		<-10.9114, 18.1944, 7.9080> <-10.9114, 18.1944, 7.7458> <-10.9305, 18.2134, 7.5273> <-10.9114, 18.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 16.6874, 0.7771> <-11.2087, 16.7372, 0.7771> <-11.2087, 18.3920, 0.7771> <-11.1589, 18.4418, 0.7771>
		<-11.1796, 16.6666, 0.6520> <-11.2294, 16.7164, 0.6520> <-11.2294, 18.4127, 0.6520> <-11.1796, 18.4626, 0.6520>
		<-11.1589, 16.6874, 0.4772> <-11.2087, 16.7372, 0.4772> <-11.2087, 18.3920, 0.4772> <-11.1589, 18.4418, 0.4772>
		<-11.1589, 16.6874, 0.3486> <-11.2087, 16.7372, 0.3486> <-11.2087, 18.3920, 0.3486> <-11.1589, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 16.6874, 0.7771> <-11.1796, 16.6666, 0.6520> <-11.1589, 16.6874, 0.4772> <-11.1589, 16.6874, 0.3486>
		<-11.1090, 16.6376, 0.7771> <-11.1298, 16.6168, 0.6520> <-11.1090, 16.6376, 0.4772> <-11.1090, 16.6376, 0.3486>
		<-9.4543, 16.6376, 0.7771> <-9.4335, 16.6168, 0.6520> <-9.4543, 16.6376, 0.4772> <-9.4543, 16.6376, 0.3486>
		<-9.4045, 16.6874, 0.7771> <-9.3837, 16.6666, 0.6520> <-9.4045, 16.6874, 0.4772> <-9.4045, 16.6874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 16.6874, 0.7771> <-9.3837, 16.6666, 0.6520> <-9.4045, 16.6874, 0.4772> <-9.4045, 16.6874, 0.3486>
		<-9.3546, 16.7372, 0.7771> <-9.3339, 16.7164, 0.6520> <-9.3546, 16.7372, 0.4772> <-9.3546, 16.7372, 0.3486>
		<-9.3546, 18.3920, 0.7771> <-9.3339, 18.4127, 0.6520> <-9.3546, 18.3920, 0.4772> <-9.3546, 18.3920, 0.3486>
		<-9.4045, 18.4418, 0.7771> <-9.3837, 18.4626, 0.6520> <-9.4045, 18.4418, 0.4772> <-9.4045, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 18.4418, 0.7771> <-9.3837, 18.4626, 0.6520> <-9.4045, 18.4418, 0.4772> <-9.4045, 18.4418, 0.3486>
		<-9.4543, 18.4916, 0.7771> <-9.4335, 18.5124, 0.6520> <-9.4543, 18.4916, 0.4772> <-9.4543, 18.4916, 0.3486>
		<-11.1090, 18.4916, 0.7771> <-11.1298, 18.5124, 0.6520> <-11.1090, 18.4916, 0.4772> <-11.1090, 18.4916, 0.3486>
		<-11.1589, 18.4418, 0.7771> <-11.1796, 18.4626, 0.6520> <-11.1589, 18.4418, 0.4772> <-11.1589, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 16.6874, -0.0618> <-11.1589, 16.6874, 0.0613> <-11.1589, 16.6874, 0.2255> <-11.1589, 16.6874, 0.3486>
		<-11.2087, 16.7372, -0.0618> <-11.2087, 16.7372, 0.0613> <-11.2087, 16.7372, 0.2255> <-11.2087, 16.7372, 0.3486>
		<-11.2087, 18.3920, -0.0618> <-11.2087, 18.3920, 0.0613> <-11.2087, 18.3920, 0.2255> <-11.2087, 18.3920, 0.3486>
		<-11.1589, 18.4418, -0.0618> <-11.1589, 18.4418, 0.0613> <-11.1589, 18.4418, 0.2255> <-11.1589, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 16.6874, -0.0618> <-11.1090, 16.6376, -0.0618> <-9.4543, 16.6376, -0.0618> <-9.4045, 16.6874, -0.0618>
		<-11.1589, 16.6874, 0.0613> <-11.1090, 16.6376, 0.0613> <-9.4543, 16.6376, 0.0613> <-9.4045, 16.6874, 0.0613>
		<-11.1589, 16.6874, 0.2255> <-11.1090, 16.6376, 0.2255> <-9.4543, 16.6376, 0.2255> <-9.4045, 16.6874, 0.2255>
		<-11.1589, 16.6874, 0.3486> <-11.1090, 16.6376, 0.3486> <-9.4543, 16.6376, 0.3486> <-9.4045, 16.6874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 16.6874, -0.0618> <-9.3546, 16.7372, -0.0618> <-9.3546, 18.3920, -0.0618> <-9.4045, 18.4418, -0.0618>
		<-9.4045, 16.6874, 0.0613> <-9.3546, 16.7372, 0.0613> <-9.3546, 18.3920, 0.0613> <-9.4045, 18.4418, 0.0613>
		<-9.4045, 16.6874, 0.2255> <-9.3546, 16.7372, 0.2255> <-9.3546, 18.3920, 0.2255> <-9.4045, 18.4418, 0.2255>
		<-9.4045, 16.6874, 0.3486> <-9.3546, 16.7372, 0.3486> <-9.3546, 18.3920, 0.3486> <-9.4045, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 18.4418, -0.0618> <-9.4543, 18.4916, -0.0618> <-11.1090, 18.4916, -0.0618> <-11.1589, 18.4418, -0.0618>
		<-9.4045, 18.4418, 0.0613> <-9.4543, 18.4916, 0.0613> <-11.1090, 18.4916, 0.0613> <-11.1589, 18.4418, 0.0613>
		<-9.4045, 18.4418, 0.2255> <-9.4543, 18.4916, 0.2255> <-11.1090, 18.4916, 0.2255> <-11.1589, 18.4418, 0.2255>
		<-9.4045, 18.4418, 0.3486> <-9.4543, 18.4916, 0.3486> <-11.1090, 18.4916, 0.3486> <-11.1589, 18.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 0.9062> <-11.1109, 14.6244, 0.9062> <-11.1109, 16.1047, 0.9062> <-11.0664, 16.1493, 0.9062>
		<-11.0712, 14.5751, 0.8515> <-11.1157, 14.6196, 0.8515> <-11.1157, 16.1095, 0.8515> <-11.0712, 16.1541, 0.8515>
		<-11.1500, 14.4963, 0.8308> <-11.1998, 14.5461, 0.8308> <-11.1998, 16.1831, 0.8308> <-11.1500, 16.2329, 0.8308>
		<-11.1589, 14.4874, 0.7771> <-11.2087, 14.5372, 0.7771> <-11.2087, 16.1920, 0.7771> <-11.1589, 16.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 0.9062> <-11.0620, 14.5842, 0.9557> <-11.1560, 14.4903, 0.9996> <-11.1357, 14.5105, 1.0404>
		<-11.1109, 14.6244, 0.9062> <-11.1066, 14.6288, 0.9557> <-11.2045, 14.5388, 0.9996> <-11.1842, 14.5590, 1.0404>
		<-11.1109, 16.1047, 0.9062> <-11.1066, 16.1004, 0.9557> <-11.2045, 16.1904, 0.9996> <-11.1842, 16.1702, 1.0404>
		<-11.0664, 16.1493, 0.9062> <-11.0620, 16.1449, 0.9557> <-11.1560, 16.2389, 0.9996> <-11.1357, 16.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 0.9062> <-11.0712, 14.5751, 0.8515> <-11.1500, 14.4963, 0.8308> <-11.1589, 14.4874, 0.7771>
		<-11.0218, 14.5353, 0.9062> <-11.0266, 14.5305, 0.8515> <-11.1001, 14.4465, 0.8308> <-11.1090, 14.4376, 0.7771>
		<-9.5415, 14.5353, 0.9062> <-9.5367, 14.5305, 0.8515> <-9.4632, 14.4465, 0.8308> <-9.4543, 14.4376, 0.7771>
		<-9.4970, 14.5799, 0.9062> <-9.4922, 14.5751, 0.8515> <-9.4134, 14.4963, 0.8308> <-9.4045, 14.4874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 0.9062> <-11.0218, 14.5353, 0.9062> <-9.5415, 14.5353, 0.9062> <-9.4970, 14.5799, 0.9062>
		<-11.0620, 14.5842, 0.9557> <-11.0175, 14.5397, 0.9557> <-9.5459, 14.5397, 0.9557> <-9.5013, 14.5842, 0.9557>
		<-11.1560, 14.4903, 0.9996> <-11.1075, 14.4418, 0.9996> <-9.4559, 14.4418, 0.9996> <-9.4073, 14.4903, 0.9996>
		<-11.1357, 14.5105, 1.0404> <-11.0872, 14.4620, 1.0404> <-9.4761, 14.4620, 1.0404> <-9.4276, 14.5105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 14.5799, 0.9062> <-9.4922, 14.5751, 0.8515> <-9.4134, 14.4963, 0.8308> <-9.4045, 14.4874, 0.7771>
		<-9.4524, 14.6244, 0.9062> <-9.4476, 14.6196, 0.8515> <-9.3635, 14.5461, 0.8308> <-9.3546, 14.5372, 0.7771>
		<-9.4524, 16.1047, 0.9062> <-9.4476, 16.1095, 0.8515> <-9.3635, 16.1831, 0.8308> <-9.3546, 16.1920, 0.7771>
		<-9.4970, 16.1493, 0.9062> <-9.4922, 16.1541, 0.8515> <-9.4134, 16.2329, 0.8308> <-9.4045, 16.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 14.5799, 0.9062> <-9.4524, 14.6244, 0.9062> <-9.4524, 16.1047, 0.9062> <-9.4970, 16.1493, 0.9062>
		<-9.5013, 14.5842, 0.9557> <-9.4567, 14.6288, 0.9557> <-9.4567, 16.1004, 0.9557> <-9.5013, 16.1449, 0.9557>
		<-9.4073, 14.4903, 0.9996> <-9.3588, 14.5388, 0.9996> <-9.3588, 16.1904, 0.9996> <-9.4073, 16.2389, 0.9996>
		<-9.4276, 14.5105, 1.0404> <-9.3791, 14.5590, 1.0404> <-9.3791, 16.1702, 1.0404> <-9.4276, 16.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.1493, 0.9062> <-9.4922, 16.1541, 0.8515> <-9.4134, 16.2329, 0.8308> <-9.4045, 16.2418, 0.7771>
		<-9.5415, 16.1939, 0.9062> <-9.5367, 16.1987, 0.8515> <-9.4632, 16.2827, 0.8308> <-9.4543, 16.2916, 0.7771>
		<-11.0218, 16.1939, 0.9062> <-11.0266, 16.1987, 0.8515> <-11.1001, 16.2827, 0.8308> <-11.1090, 16.2916, 0.7771>
		<-11.0664, 16.1493, 0.9062> <-11.0712, 16.1541, 0.8515> <-11.1500, 16.2329, 0.8308> <-11.1589, 16.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.1493, 0.9062> <-9.5415, 16.1939, 0.9062> <-11.0218, 16.1939, 0.9062> <-11.0664, 16.1493, 0.9062>
		<-9.5013, 16.1449, 0.9557> <-9.5459, 16.1895, 0.9557> <-11.0175, 16.1895, 0.9557> <-11.0620, 16.1449, 0.9557>
		<-9.4073, 16.2389, 0.9996> <-9.4559, 16.2874, 0.9996> <-11.1075, 16.2874, 0.9996> <-11.1560, 16.2389, 0.9996>
		<-9.4276, 16.2187, 1.0404> <-9.4761, 16.2672, 1.0404> <-11.0872, 16.2672, 1.0404> <-11.1357, 16.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 14.5105, 1.0404> <-11.0677, 14.5786, 1.1777> <-10.8982, 14.7481, 1.2552> <-10.8269, 14.8193, 1.3892>
		<-11.1842, 14.5590, 1.0404> <-11.1162, 14.6271, 1.1777> <-10.9291, 14.7790, 1.2552> <-10.8579, 14.8503, 1.3892>
		<-11.1842, 16.1702, 1.0404> <-11.1162, 16.1021, 1.1777> <-10.9291, 15.9501, 1.2552> <-10.8579, 15.8789, 1.3892>
		<-11.1357, 16.2187, 1.0404> <-11.0677, 16.1506, 1.1777> <-10.8982, 15.9811, 1.2552> <-10.8269, 15.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 14.5105, 1.0404> <-11.0872, 14.4620, 1.0404> <-9.4761, 14.4620, 1.0404> <-9.4276, 14.5105, 1.0404>
		<-11.0677, 14.5786, 1.1777> <-11.0192, 14.5301, 1.1777> <-9.5442, 14.5301, 1.1777> <-9.4957, 14.5786, 1.1777>
		<-10.8982, 14.7481, 1.2552> <-10.8672, 14.7171, 1.2552> <-9.6961, 14.7171, 1.2552> <-9.6652, 14.7481, 1.2552>
		<-10.8269, 14.8193, 1.3892> <-10.7959, 14.7884, 1.3892> <-9.7674, 14.7884, 1.3892> <-9.7364, 14.8193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 14.5105, 1.0404> <-9.3791, 14.5590, 1.0404> <-9.3791, 16.1702, 1.0404> <-9.4276, 16.2187, 1.0404>
		<-9.4957, 14.5786, 1.1777> <-9.4471, 14.6271, 1.1777> <-9.4471, 16.1021, 1.1777> <-9.4957, 16.1506, 1.1777>
		<-9.6652, 14.7481, 1.2552> <-9.6342, 14.7790, 1.2552> <-9.6342, 15.9501, 1.2552> <-9.6652, 15.9811, 1.2552>
		<-9.7364, 14.8193, 1.3892> <-9.7054, 14.8503, 1.3892> <-9.7054, 15.8789, 1.3892> <-9.7364, 15.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 16.2187, 1.0404> <-9.4761, 16.2672, 1.0404> <-11.0872, 16.2672, 1.0404> <-11.1357, 16.2187, 1.0404>
		<-9.4957, 16.1506, 1.1777> <-9.5442, 16.1991, 1.1777> <-11.0192, 16.1991, 1.1777> <-11.0677, 16.1506, 1.1777>
		<-9.6652, 15.9811, 1.2552> <-9.6961, 16.0121, 1.2552> <-10.8672, 16.0121, 1.2552> <-10.8982, 15.9811, 1.2552>
		<-9.7364, 15.9098, 1.3892> <-9.7674, 15.9408, 1.3892> <-10.7959, 15.9408, 1.3892> <-10.8269, 15.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 14.8193, 1.3892> <-10.8079, 14.8383, 1.4249> <-10.8837, 14.7626, 1.4698> <-10.8837, 14.7626, 1.5144>
		<-10.8579, 14.8503, 1.3892> <-10.8389, 14.8693, 1.4249> <-10.9179, 14.7968, 1.4698> <-10.9179, 14.7968, 1.5144>
		<-10.8579, 15.8789, 1.3892> <-10.8389, 15.8599, 1.4249> <-10.9179, 15.9324, 1.4698> <-10.9179, 15.9324, 1.5144>
		<-10.8269, 15.9098, 1.3892> <-10.8079, 15.8909, 1.4249> <-10.8837, 15.9666, 1.4698> <-10.8837, 15.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 14.8193, 1.3892> <-10.7959, 14.7884, 1.3892> <-9.7674, 14.7884, 1.3892> <-9.7364, 14.8193, 1.3892>
		<-10.8079, 14.8383, 1.4249> <-10.7770, 14.8073, 1.4249> <-9.7863, 14.8073, 1.4249> <-9.7554, 14.8383, 1.4249>
		<-10.8837, 14.7626, 1.4698> <-10.8495, 14.7284, 1.4698> <-9.7138, 14.7284, 1.4698> <-9.6796, 14.7626, 1.4698>
		<-10.8837, 14.7626, 1.5144> <-10.8495, 14.7284, 1.5144> <-9.7138, 14.7284, 1.5144> <-9.6796, 14.7626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 14.8193, 1.3892> <-9.7054, 14.8503, 1.3892> <-9.7054, 15.8789, 1.3892> <-9.7364, 15.9098, 1.3892>
		<-9.7554, 14.8383, 1.4249> <-9.7244, 14.8693, 1.4249> <-9.7244, 15.8599, 1.4249> <-9.7554, 15.8909, 1.4249>
		<-9.6796, 14.7626, 1.4698> <-9.6455, 14.7968, 1.4698> <-9.6455, 15.9324, 1.4698> <-9.6796, 15.9666, 1.4698>
		<-9.6796, 14.7626, 1.5144> <-9.6455, 14.7968, 1.5144> <-9.6455, 15.9324, 1.5144> <-9.6796, 15.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 15.9098, 1.3892> <-9.7674, 15.9408, 1.3892> <-10.7959, 15.9408, 1.3892> <-10.8269, 15.9098, 1.3892>
		<-9.7554, 15.8909, 1.4249> <-9.7863, 15.9218, 1.4249> <-10.7770, 15.9218, 1.4249> <-10.8079, 15.8909, 1.4249>
		<-9.6796, 15.9666, 1.4698> <-9.7138, 16.0008, 1.4698> <-10.8495, 16.0008, 1.4698> <-10.8837, 15.9666, 1.4698>
		<-9.6796, 15.9666, 1.5144> <-9.7138, 16.0008, 1.5144> <-10.8495, 16.0008, 1.5144> <-10.8837, 15.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 14.7626, 1.5144> <-10.8837, 14.7626, 1.5613> <-10.8121, 14.8341, 1.6066> <-10.8269, 14.8193, 1.6486>
		<-10.9179, 14.7968, 1.5144> <-10.9179, 14.7968, 1.5613> <-10.8431, 14.8651, 1.6066> <-10.8579, 14.8503, 1.6486>
		<-10.9179, 15.9324, 1.5144> <-10.9179, 15.9324, 1.5613> <-10.8431, 15.8641, 1.6066> <-10.8579, 15.8789, 1.6486>
		<-10.8837, 15.9666, 1.5144> <-10.8837, 15.9666, 1.5613> <-10.8121, 15.8950, 1.6066> <-10.8269, 15.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 14.7626, 1.5144> <-10.8495, 14.7284, 1.5144> <-9.7138, 14.7284, 1.5144> <-9.6796, 14.7626, 1.5144>
		<-10.8837, 14.7626, 1.5613> <-10.8495, 14.7284, 1.5613> <-9.7138, 14.7284, 1.5613> <-9.6796, 14.7626, 1.5613>
		<-10.8121, 14.8341, 1.6066> <-10.7812, 14.8032, 1.6066> <-9.7822, 14.8032, 1.6066> <-9.7512, 14.8341, 1.6066>
		<-10.8269, 14.8193, 1.6486> <-10.7959, 14.7884, 1.6486> <-9.7674, 14.7884, 1.6486> <-9.7364, 14.8193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 14.7626, 1.5144> <-9.6455, 14.7968, 1.5144> <-9.6455, 15.9324, 1.5144> <-9.6796, 15.9666, 1.5144>
		<-9.6796, 14.7626, 1.5613> <-9.6455, 14.7968, 1.5613> <-9.6455, 15.9324, 1.5613> <-9.6796, 15.9666, 1.5613>
		<-9.7512, 14.8341, 1.6066> <-9.7202, 14.8651, 1.6066> <-9.7202, 15.8641, 1.6066> <-9.7512, 15.8950, 1.6066>
		<-9.7364, 14.8193, 1.6486> <-9.7054, 14.8503, 1.6486> <-9.7054, 15.8789, 1.6486> <-9.7364, 15.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 15.9666, 1.5144> <-9.7138, 16.0008, 1.5144> <-10.8495, 16.0008, 1.5144> <-10.8837, 15.9666, 1.5144>
		<-9.6796, 15.9666, 1.5613> <-9.7138, 16.0008, 1.5613> <-10.8495, 16.0008, 1.5613> <-10.8837, 15.9666, 1.5613>
		<-9.7512, 15.8950, 1.6066> <-9.7822, 15.9260, 1.6066> <-10.7812, 15.9260, 1.6066> <-10.8121, 15.8950, 1.6066>
		<-9.7364, 15.9098, 1.6486> <-9.7674, 15.9408, 1.6486> <-10.7959, 15.9408, 1.6486> <-10.8269, 15.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 14.8193, 1.6486> <-10.8754, 14.7709, 1.7862> <-11.0172, 14.6290, 1.8960> <-11.0664, 14.5799, 2.0332>
		<-10.8579, 14.8503, 1.6486> <-10.9063, 14.8018, 1.7862> <-11.0618, 14.6736, 1.8960> <-11.1109, 14.6244, 2.0332>
		<-10.8579, 15.8789, 1.6486> <-10.9063, 15.9273, 1.7862> <-11.0618, 16.0556, 1.8960> <-11.1109, 16.1047, 2.0332>
		<-10.8269, 15.9098, 1.6486> <-10.8754, 15.9583, 1.7862> <-11.0172, 16.1002, 1.8960> <-11.0664, 16.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 14.8193, 1.6486> <-10.7959, 14.7884, 1.6486> <-9.7674, 14.7884, 1.6486> <-9.7364, 14.8193, 1.6486>
		<-10.8754, 14.7709, 1.7862> <-10.8444, 14.7399, 1.7862> <-9.7189, 14.7399, 1.7862> <-9.6880, 14.7709, 1.7862>
		<-11.0172, 14.6290, 1.8960> <-10.9727, 14.5844, 1.8960> <-9.5907, 14.5844, 1.8960> <-9.5461, 14.6290, 1.8960>
		<-11.0664, 14.5799, 2.0332> <-11.0218, 14.5353, 2.0332> <-9.5415, 14.5353, 2.0332> <-9.4970, 14.5799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 14.8193, 1.6486> <-9.7054, 14.8503, 1.6486> <-9.7054, 15.8789, 1.6486> <-9.7364, 15.9098, 1.6486>
		<-9.6880, 14.7709, 1.7862> <-9.6570, 14.8018, 1.7862> <-9.6570, 15.9273, 1.7862> <-9.6880, 15.9583, 1.7862>
		<-9.5461, 14.6290, 1.8960> <-9.5015, 14.6736, 1.8960> <-9.5015, 16.0556, 1.8960> <-9.5461, 16.1002, 1.8960>
		<-9.4970, 14.5799, 2.0332> <-9.4524, 14.6244, 2.0332> <-9.4524, 16.1047, 2.0332> <-9.4970, 16.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 15.9098, 1.6486> <-9.7674, 15.9408, 1.6486> <-10.7959, 15.9408, 1.6486> <-10.8269, 15.9098, 1.6486>
		<-9.6880, 15.9583, 1.7862> <-9.7189, 15.9893, 1.7862> <-10.8444, 15.9893, 1.7862> <-10.8754, 15.9583, 1.7862>
		<-9.5461, 16.1002, 1.8960> <-9.5907, 16.1447, 1.8960> <-10.9727, 16.1447, 1.8960> <-11.0172, 16.1002, 1.8960>
		<-9.4970, 16.1493, 2.0332> <-9.5415, 16.1939, 2.0332> <-11.0218, 16.1939, 2.0332> <-11.0664, 16.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 2.0332> <-11.0930, 14.5533, 2.1074> <-11.0932, 14.5531, 2.2382> <-11.0641, 14.5822, 2.3104>
		<-11.1109, 14.6244, 2.0332> <-11.1375, 14.5979, 2.1074> <-11.1376, 14.5975, 2.2382> <-11.1085, 14.6266, 2.3104>
		<-11.1109, 16.1047, 2.0332> <-11.1375, 16.1313, 2.1074> <-11.1376, 16.1317, 2.2382> <-11.1085, 16.1025, 2.3104>
		<-11.0664, 16.1493, 2.0332> <-11.0930, 16.1759, 2.1074> <-11.0932, 16.1761, 2.2382> <-11.0641, 16.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 14.5799, 2.0332> <-11.0218, 14.5353, 2.0332> <-9.5415, 14.5353, 2.0332> <-9.4970, 14.5799, 2.0332>
		<-11.0930, 14.5533, 2.1074> <-11.0484, 14.5087, 2.1074> <-9.5149, 14.5087, 2.1074> <-9.4704, 14.5533, 2.1074>
		<-11.0932, 14.5531, 2.2382> <-11.0488, 14.5086, 2.2382> <-9.5146, 14.5086, 2.2382> <-9.4701, 14.5531, 2.2382>
		<-11.0641, 14.5822, 2.3104> <-11.0196, 14.5378, 2.3104> <-9.5437, 14.5378, 2.3104> <-9.4993, 14.5822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 14.5799, 2.0332> <-9.4524, 14.6244, 2.0332> <-9.4524, 16.1047, 2.0332> <-9.4970, 16.1493, 2.0332>
		<-9.4704, 14.5533, 2.1074> <-9.4258, 14.5979, 2.1074> <-9.4258, 16.1313, 2.1074> <-9.4704, 16.1759, 2.1074>
		<-9.4701, 14.5531, 2.2382> <-9.4257, 14.5975, 2.2382> <-9.4257, 16.1317, 2.2382> <-9.4701, 16.1761, 2.2382>
		<-9.4993, 14.5822, 2.3104> <-9.4548, 14.6266, 2.3104> <-9.4548, 16.1025, 2.3104> <-9.4993, 16.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 16.1493, 2.0332> <-9.5415, 16.1939, 2.0332> <-11.0218, 16.1939, 2.0332> <-11.0664, 16.1493, 2.0332>
		<-9.4704, 16.1759, 2.1074> <-9.5149, 16.2204, 2.1074> <-11.0484, 16.2204, 2.1074> <-11.0930, 16.1759, 2.1074>
		<-9.4701, 16.1761, 2.2382> <-9.5146, 16.2206, 2.2382> <-11.0488, 16.2206, 2.2382> <-11.0932, 16.1761, 2.2382>
		<-9.4993, 16.1470, 2.3104> <-9.5437, 16.1914, 2.3104> <-11.0196, 16.1914, 2.3104> <-11.0641, 16.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 14.5822, 2.3104> <-10.9801, 14.6661, 2.5186> <-10.7843, 14.8620, 2.7154> <-10.7056, 14.9406, 2.9276>
		<-11.1085, 14.6266, 2.3104> <-11.0246, 14.7106, 2.5186> <-10.8084, 14.8860, 2.7154> <-10.7297, 14.9647, 2.9276>
		<-11.1085, 16.1025, 2.3104> <-11.0246, 16.0186, 2.5186> <-10.8084, 15.8431, 2.7154> <-10.7297, 15.7645, 2.9276>
		<-11.0641, 16.1470, 2.3104> <-10.9801, 16.0630, 2.5186> <-10.7843, 15.8672, 2.7154> <-10.7056, 15.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 14.5822, 2.3104> <-11.0196, 14.5378, 2.3104> <-9.5437, 14.5378, 2.3104> <-9.4993, 14.5822, 2.3104>
		<-10.9801, 14.6661, 2.5186> <-10.9357, 14.6217, 2.5186> <-9.6277, 14.6217, 2.5186> <-9.5832, 14.6661, 2.5186>
		<-10.7843, 14.8620, 2.7154> <-10.7602, 14.8379, 2.7154> <-9.8031, 14.8379, 2.7154> <-9.7790, 14.8620, 2.7154>
		<-10.7056, 14.9406, 2.9276> <-10.6815, 14.9165, 2.9276> <-9.8818, 14.9165, 2.9276> <-9.8577, 14.9406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 14.5822, 2.3104> <-9.4548, 14.6266, 2.3104> <-9.4548, 16.1025, 2.3104> <-9.4993, 16.1470, 2.3104>
		<-9.5832, 14.6661, 2.5186> <-9.5388, 14.7106, 2.5186> <-9.5388, 16.0186, 2.5186> <-9.5832, 16.0630, 2.5186>
		<-9.7790, 14.8620, 2.7154> <-9.7550, 14.8860, 2.7154> <-9.7550, 15.8431, 2.7154> <-9.7790, 15.8672, 2.7154>
		<-9.8577, 14.9406, 2.9276> <-9.8336, 14.9647, 2.9276> <-9.8336, 15.7645, 2.9276> <-9.8577, 15.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 16.1470, 2.3104> <-9.5437, 16.1914, 2.3104> <-11.0196, 16.1914, 2.3104> <-11.0641, 16.1470, 2.3104>
		<-9.5832, 16.0630, 2.5186> <-9.6277, 16.1075, 2.5186> <-10.9357, 16.1075, 2.5186> <-10.9801, 16.0630, 2.5186>
		<-9.7790, 15.8672, 2.7154> <-9.8031, 15.8913, 2.7154> <-10.7602, 15.8913, 2.7154> <-10.7843, 15.8672, 2.7154>
		<-9.8577, 15.7885, 2.9276> <-9.8818, 15.8126, 2.9276> <-10.6815, 15.8126, 2.9276> <-10.7056, 15.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 14.9406, 2.9276> <-10.6887, 14.9576, 2.9732> <-10.7889, 14.8574, 3.0012> <-10.7889, 14.8574, 3.0528>
		<-10.7297, 14.9647, 2.9276> <-10.7128, 14.9816, 2.9732> <-10.8177, 14.8862, 3.0012> <-10.8177, 14.8862, 3.0528>
		<-10.7297, 15.7645, 2.9276> <-10.7128, 15.7475, 2.9732> <-10.8177, 15.8430, 3.0012> <-10.8177, 15.8430, 3.0528>
		<-10.7056, 15.7885, 2.9276> <-10.6887, 15.7716, 2.9732> <-10.7889, 15.8718, 3.0012> <-10.7889, 15.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 14.9406, 2.9276> <-10.6815, 14.9165, 2.9276> <-9.8818, 14.9165, 2.9276> <-9.8577, 14.9406, 2.9276>
		<-10.6887, 14.9576, 2.9732> <-10.6646, 14.9335, 2.9732> <-9.8987, 14.9335, 2.9732> <-9.8746, 14.9576, 2.9732>
		<-10.7889, 14.8574, 3.0012> <-10.7601, 14.8286, 3.0012> <-9.8033, 14.8286, 3.0012> <-9.7745, 14.8574, 3.0012>
		<-10.7889, 14.8574, 3.0528> <-10.7601, 14.8286, 3.0528> <-9.8033, 14.8286, 3.0528> <-9.7745, 14.8574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 14.9406, 2.9276> <-9.8336, 14.9647, 2.9276> <-9.8336, 15.7645, 2.9276> <-9.8577, 15.7885, 2.9276>
		<-9.8746, 14.9576, 2.9732> <-9.8506, 14.9816, 2.9732> <-9.8506, 15.7475, 2.9732> <-9.8746, 15.7716, 2.9732>
		<-9.7745, 14.8574, 3.0012> <-9.7456, 14.8862, 3.0012> <-9.7456, 15.8430, 3.0012> <-9.7745, 15.8718, 3.0012>
		<-9.7745, 14.8574, 3.0528> <-9.7456, 14.8862, 3.0528> <-9.7456, 15.8430, 3.0528> <-9.7745, 15.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 15.7885, 2.9276> <-9.8818, 15.8126, 2.9276> <-10.6815, 15.8126, 2.9276> <-10.7056, 15.7885, 2.9276>
		<-9.8746, 15.7716, 2.9732> <-9.8987, 15.7957, 2.9732> <-10.6646, 15.7957, 2.9732> <-10.6887, 15.7716, 2.9732>
		<-9.7745, 15.8718, 3.0012> <-9.8033, 15.9006, 3.0012> <-10.7601, 15.9006, 3.0012> <-10.7889, 15.8718, 3.0012>
		<-9.7745, 15.8718, 3.0528> <-9.8033, 15.9006, 3.0528> <-10.7601, 15.9006, 3.0528> <-10.7889, 15.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 14.8574, 3.0528> <-10.7889, 14.8574, 3.1044> <-10.6862, 14.9600, 3.1344> <-10.7056, 14.9406, 3.1780>
		<-10.8177, 14.8862, 3.0528> <-10.8177, 14.8862, 3.1044> <-10.7103, 14.9841, 3.1344> <-10.7297, 14.9647, 3.1780>
		<-10.8177, 15.8430, 3.0528> <-10.8177, 15.8430, 3.1044> <-10.7103, 15.7451, 3.1344> <-10.7297, 15.7645, 3.1780>
		<-10.7889, 15.8718, 3.0528> <-10.7889, 15.8718, 3.1044> <-10.6862, 15.7691, 3.1344> <-10.7056, 15.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 14.8574, 3.0528> <-10.7601, 14.8286, 3.0528> <-9.8033, 14.8286, 3.0528> <-9.7745, 14.8574, 3.0528>
		<-10.7889, 14.8574, 3.1044> <-10.7601, 14.8286, 3.1044> <-9.8033, 14.8286, 3.1044> <-9.7745, 14.8574, 3.1044>
		<-10.6862, 14.9600, 3.1344> <-10.6621, 14.9360, 3.1344> <-9.9012, 14.9360, 3.1344> <-9.8771, 14.9600, 3.1344>
		<-10.7056, 14.9406, 3.1780> <-10.6815, 14.9165, 3.1780> <-9.8818, 14.9165, 3.1780> <-9.8577, 14.9406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 14.8574, 3.0528> <-9.7456, 14.8862, 3.0528> <-9.7456, 15.8430, 3.0528> <-9.7745, 15.8718, 3.0528>
		<-9.7745, 14.8574, 3.1044> <-9.7456, 14.8862, 3.1044> <-9.7456, 15.8430, 3.1044> <-9.7745, 15.8718, 3.1044>
		<-9.8771, 14.9600, 3.1344> <-9.8530, 14.9841, 3.1344> <-9.8530, 15.7451, 3.1344> <-9.8771, 15.7691, 3.1344>
		<-9.8577, 14.9406, 3.1780> <-9.8336, 14.9647, 3.1780> <-9.8336, 15.7645, 3.1780> <-9.8577, 15.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 15.8718, 3.0528> <-9.8033, 15.9006, 3.0528> <-10.7601, 15.9006, 3.0528> <-10.7889, 15.8718, 3.0528>
		<-9.7745, 15.8718, 3.1044> <-9.8033, 15.9006, 3.1044> <-10.7601, 15.9006, 3.1044> <-10.7889, 15.8718, 3.1044>
		<-9.8771, 15.7691, 3.1344> <-9.9012, 15.7932, 3.1344> <-10.6621, 15.7932, 3.1344> <-10.6862, 15.7691, 3.1344>
		<-9.8577, 15.7885, 3.1780> <-9.8818, 15.8126, 3.1780> <-10.6815, 15.8126, 3.1780> <-10.7056, 15.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 14.9406, 3.1780> <-10.7438, 14.9024, 3.2640> <-10.8610, 14.7852, 3.2738> <-10.9161, 14.7302, 3.3390>
		<-10.7297, 14.9647, 3.1780> <-10.7679, 14.9265, 3.2640> <-10.8971, 14.8212, 3.2738> <-10.9521, 14.7662, 3.3390>
		<-10.7297, 15.7645, 3.1780> <-10.7679, 15.8027, 3.2640> <-10.8971, 15.9079, 3.2738> <-10.9521, 15.9629, 3.3390>
		<-10.7056, 15.7885, 3.1780> <-10.7438, 15.8267, 3.2640> <-10.8610, 15.9440, 3.2738> <-10.9161, 15.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 14.9406, 3.1780> <-10.6815, 14.9165, 3.1780> <-9.8818, 14.9165, 3.1780> <-9.8577, 14.9406, 3.1780>
		<-10.7438, 14.9024, 3.2640> <-10.7197, 14.8784, 3.2640> <-9.8436, 14.8784, 3.2640> <-9.8195, 14.9024, 3.2640>
		<-10.8610, 14.7852, 3.2738> <-10.8250, 14.7492, 3.2738> <-9.7383, 14.7492, 3.2738> <-9.7023, 14.7852, 3.2738>
		<-10.9161, 14.7302, 3.3390> <-10.8800, 14.6942, 3.3390> <-9.6833, 14.6942, 3.3390> <-9.6473, 14.7302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 14.9406, 3.1780> <-9.8336, 14.9647, 3.1780> <-9.8336, 15.7645, 3.1780> <-9.8577, 15.7885, 3.1780>
		<-9.8195, 14.9024, 3.2640> <-9.7954, 14.9265, 3.2640> <-9.7954, 15.8027, 3.2640> <-9.8195, 15.8267, 3.2640>
		<-9.7023, 14.7852, 3.2738> <-9.6663, 14.8212, 3.2738> <-9.6663, 15.9079, 3.2738> <-9.7023, 15.9440, 3.2738>
		<-9.6473, 14.7302, 3.3390> <-9.6112, 14.7662, 3.3390> <-9.6112, 15.9629, 3.3390> <-9.6473, 15.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 15.7885, 3.1780> <-9.8818, 15.8126, 3.1780> <-10.6815, 15.8126, 3.1780> <-10.7056, 15.7885, 3.1780>
		<-9.8195, 15.8267, 3.2640> <-9.8436, 15.8508, 3.2640> <-10.7197, 15.8508, 3.2640> <-10.7438, 15.8267, 3.2640>
		<-9.7023, 15.9440, 3.2738> <-9.7383, 15.9800, 3.2738> <-10.8250, 15.9800, 3.2738> <-10.8610, 15.9440, 3.2738>
		<-9.6473, 15.9990, 3.3390> <-9.6833, 16.0350, 3.3390> <-10.8800, 16.0350, 3.3390> <-10.9161, 15.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 14.7302, 3.3390> <-10.9416, 14.7046, 3.3693> <-10.9797, 14.6665, 3.4419> <-10.9623, 14.6839, 3.4821>
		<-10.9521, 14.7662, 3.3390> <-10.9777, 14.7406, 3.3693> <-11.0184, 14.7052, 3.4419> <-11.0010, 14.7226, 3.4821>
		<-10.9521, 15.9629, 3.3390> <-10.9777, 15.9885, 3.3693> <-11.0184, 16.0240, 3.4419> <-11.0010, 16.0066, 3.4821>
		<-10.9161, 15.9990, 3.3390> <-10.9416, 16.0246, 3.3693> <-10.9797, 16.0627, 3.4419> <-10.9623, 16.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 14.7302, 3.3390> <-10.8800, 14.6942, 3.3390> <-9.6833, 14.6942, 3.3390> <-9.6473, 14.7302, 3.3390>
		<-10.9416, 14.7046, 3.3693> <-10.9056, 14.6686, 3.3693> <-9.6577, 14.6686, 3.3693> <-9.6217, 14.7046, 3.3693>
		<-10.9797, 14.6665, 3.4419> <-10.9411, 14.6279, 3.4419> <-9.6223, 14.6279, 3.4419> <-9.5836, 14.6665, 3.4419>
		<-10.9623, 14.6839, 3.4821> <-10.9236, 14.6453, 3.4821> <-9.6397, 14.6453, 3.4821> <-9.6010, 14.6839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 14.7302, 3.3390> <-9.6112, 14.7662, 3.3390> <-9.6112, 15.9629, 3.3390> <-9.6473, 15.9990, 3.3390>
		<-9.6217, 14.7046, 3.3693> <-9.5857, 14.7406, 3.3693> <-9.5857, 15.9885, 3.3693> <-9.6217, 16.0246, 3.3693>
		<-9.5836, 14.6665, 3.4419> <-9.5449, 14.7052, 3.4419> <-9.5449, 16.0240, 3.4419> <-9.5836, 16.0627, 3.4419>
		<-9.6010, 14.6839, 3.4821> <-9.5624, 14.7226, 3.4821> <-9.5624, 16.0066, 3.4821> <-9.6010, 16.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 15.9990, 3.3390> <-9.6833, 16.0350, 3.3390> <-10.8800, 16.0350, 3.3390> <-10.9161, 15.9990, 3.3390>
		<-9.6217, 16.0246, 3.3693> <-9.6577, 16.0606, 3.3693> <-10.9056, 16.0606, 3.3693> <-10.9416, 16.0246, 3.3693>
		<-9.5836, 16.0627, 3.4419> <-9.6223, 16.1013, 3.4419> <-10.9411, 16.1013, 3.4419> <-10.9797, 16.0627, 3.4419>
		<-9.6010, 16.0452, 3.4821> <-9.6397, 16.0839, 3.4821> <-10.9236, 16.0839, 3.4821> <-10.9623, 16.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 14.6839, 3.4821> <-10.9163, 14.7300, 3.5884> <-10.7961, 14.8502, 3.6567> <-10.7380, 14.9083, 3.7504>
		<-11.0010, 14.7226, 3.4821> <-10.9550, 14.7686, 3.5884> <-10.8220, 14.8761, 3.6567> <-10.7639, 14.9342, 3.7504>
		<-11.0010, 16.0066, 3.4821> <-10.9550, 15.9606, 3.5884> <-10.8220, 15.8531, 3.6567> <-10.7639, 15.7950, 3.7504>
		<-10.9623, 16.0452, 3.4821> <-10.9163, 15.9992, 3.5884> <-10.7961, 15.8790, 3.6567> <-10.7380, 15.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 14.6839, 3.4821> <-10.9236, 14.6453, 3.4821> <-9.6397, 14.6453, 3.4821> <-9.6010, 14.6839, 3.4821>
		<-10.9163, 14.7300, 3.5884> <-10.8776, 14.6913, 3.5884> <-9.6857, 14.6913, 3.5884> <-9.6470, 14.7300, 3.5884>
		<-10.7961, 14.8502, 3.6567> <-10.7702, 14.8242, 3.6567> <-9.7932, 14.8242, 3.6567> <-9.7672, 14.8502, 3.6567>
		<-10.7380, 14.9083, 3.7504> <-10.7121, 14.8823, 3.7504> <-9.8513, 14.8823, 3.7504> <-9.8253, 14.9083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 14.6839, 3.4821> <-9.5624, 14.7226, 3.4821> <-9.5624, 16.0066, 3.4821> <-9.6010, 16.0452, 3.4821>
		<-9.6470, 14.7300, 3.5884> <-9.6084, 14.7686, 3.5884> <-9.6084, 15.9606, 3.5884> <-9.6470, 15.9992, 3.5884>
		<-9.7672, 14.8502, 3.6567> <-9.7413, 14.8761, 3.6567> <-9.7413, 15.8531, 3.6567> <-9.7672, 15.8790, 3.6567>
		<-9.8253, 14.9083, 3.7504> <-9.7994, 14.9342, 3.7504> <-9.7994, 15.7950, 3.7504> <-9.8253, 15.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 16.0452, 3.4821> <-9.6397, 16.0839, 3.4821> <-10.9236, 16.0839, 3.4821> <-10.9623, 16.0452, 3.4821>
		<-9.6470, 15.9992, 3.5884> <-9.6857, 16.0379, 3.5884> <-10.8776, 16.0379, 3.5884> <-10.9163, 15.9992, 3.5884>
		<-9.7672, 15.8790, 3.6567> <-9.7932, 15.9049, 3.6567> <-10.7702, 15.9049, 3.6567> <-10.7961, 15.8790, 3.6567>
		<-9.8253, 15.8209, 3.7504> <-9.8513, 15.8468, 3.7504> <-10.7121, 15.8468, 3.7504> <-10.7380, 15.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 14.9083, 3.7504> <-10.6964, 14.9498, 3.8175> <-10.6527, 14.9935, 3.9241> <-10.6352, 15.0110, 4.0098>
		<-10.7639, 14.9342, 3.7504> <-10.7223, 14.9757, 3.8175> <-10.6728, 15.0136, 3.9241> <-10.6553, 15.0311, 4.0098>
		<-10.7639, 15.7950, 3.7504> <-10.7223, 15.7534, 3.8175> <-10.6728, 15.7156, 3.9241> <-10.6553, 15.6981, 4.0098>
		<-10.7380, 15.8209, 3.7504> <-10.6964, 15.7793, 3.8175> <-10.6527, 15.7356, 3.9241> <-10.6352, 15.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 14.9083, 3.7504> <-10.7121, 14.8823, 3.7504> <-9.8513, 14.8823, 3.7504> <-9.8253, 14.9083, 3.7504>
		<-10.6964, 14.9498, 3.8175> <-10.6705, 14.9239, 3.8175> <-9.8928, 14.9239, 3.8175> <-9.8669, 14.9498, 3.8175>
		<-10.6527, 14.9935, 3.9241> <-10.6326, 14.9734, 3.9241> <-9.9307, 14.9734, 3.9241> <-9.9106, 14.9935, 3.9241>
		<-10.6352, 15.0110, 4.0098> <-10.6152, 14.9909, 4.0098> <-9.9482, 14.9909, 4.0098> <-9.9281, 15.0110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 14.9083, 3.7504> <-9.7994, 14.9342, 3.7504> <-9.7994, 15.7950, 3.7504> <-9.8253, 15.8209, 3.7504>
		<-9.8669, 14.9498, 3.8175> <-9.8410, 14.9757, 3.8175> <-9.8410, 15.7534, 3.8175> <-9.8669, 15.7793, 3.8175>
		<-9.9106, 14.9935, 3.9241> <-9.8905, 15.0136, 3.9241> <-9.8905, 15.7156, 3.9241> <-9.9106, 15.7356, 3.9241>
		<-9.9281, 15.0110, 4.0098> <-9.9080, 15.0311, 4.0098> <-9.9080, 15.6981, 4.0098> <-9.9281, 15.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 15.8209, 3.7504> <-9.8513, 15.8468, 3.7504> <-10.7121, 15.8468, 3.7504> <-10.7380, 15.8209, 3.7504>
		<-9.8669, 15.7793, 3.8175> <-9.8928, 15.8053, 3.8175> <-10.6705, 15.8053, 3.8175> <-10.6964, 15.7793, 3.8175>
		<-9.9106, 15.7356, 3.9241> <-9.9307, 15.7557, 3.9241> <-10.6326, 15.7557, 3.9241> <-10.6527, 15.7356, 3.9241>
		<-9.9281, 15.7182, 4.0098> <-9.9482, 15.7383, 4.0098> <-10.6152, 15.7383, 4.0098> <-10.6352, 15.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 15.0110, 4.0098> <-10.6168, 15.0294, 4.1002> <-10.6221, 15.0242, 4.2288> <-10.6213, 15.0250, 4.3229>
		<-10.6553, 15.0311, 4.0098> <-10.6369, 15.0495, 4.1002> <-10.6413, 15.0435, 4.2288> <-10.6405, 15.0443, 4.3229>
		<-10.6553, 15.6981, 4.0098> <-10.6369, 15.6797, 4.1002> <-10.6413, 15.6857, 4.2288> <-10.6405, 15.6849, 4.3229>
		<-10.6352, 15.7182, 4.0098> <-10.6168, 15.6997, 4.1002> <-10.6221, 15.7050, 4.2288> <-10.6213, 15.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 15.0110, 4.0098> <-10.6152, 14.9909, 4.0098> <-9.9482, 14.9909, 4.0098> <-9.9281, 15.0110, 4.0098>
		<-10.6168, 15.0294, 4.1002> <-10.5967, 15.0094, 4.1002> <-9.9666, 15.0094, 4.1002> <-9.9465, 15.0294, 4.1002>
		<-10.6221, 15.0242, 4.2288> <-10.6028, 15.0049, 4.2288> <-9.9606, 15.0049, 4.2288> <-9.9413, 15.0242, 4.2288>
		<-10.6213, 15.0250, 4.3229> <-10.6020, 15.0057, 4.3229> <-9.9614, 15.0057, 4.3229> <-9.9421, 15.0250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 15.0110, 4.0098> <-9.9080, 15.0311, 4.0098> <-9.9080, 15.6981, 4.0098> <-9.9281, 15.7182, 4.0098>
		<-9.9465, 15.0294, 4.1002> <-9.9264, 15.0495, 4.1002> <-9.9264, 15.6797, 4.1002> <-9.9465, 15.6997, 4.1002>
		<-9.9413, 15.0242, 4.2288> <-9.9220, 15.0435, 4.2288> <-9.9220, 15.6857, 4.2288> <-9.9413, 15.7050, 4.2288>
		<-9.9421, 15.0250, 4.3229> <-9.9228, 15.0443, 4.3229> <-9.9228, 15.6849, 4.3229> <-9.9421, 15.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 15.7182, 4.0098> <-9.9482, 15.7383, 4.0098> <-10.6152, 15.7383, 4.0098> <-10.6352, 15.7182, 4.0098>
		<-9.9465, 15.6997, 4.1002> <-9.9666, 15.7198, 4.1002> <-10.5967, 15.7198, 4.1002> <-10.6168, 15.6997, 4.1002>
		<-9.9413, 15.7050, 4.2288> <-9.9606, 15.7243, 4.2288> <-10.6028, 15.7243, 4.2288> <-10.6221, 15.7050, 4.2288>
		<-9.9421, 15.7042, 4.3229> <-9.9614, 15.7235, 4.3229> <-10.6020, 15.7235, 4.3229> <-10.6213, 15.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 15.0250, 4.3229> <-10.6179, 15.0284, 4.7283> <-10.6197, 15.0265, 5.2689> <-10.6213, 15.0250, 5.6744>
		<-10.6405, 15.0443, 4.3229> <-10.6371, 15.0477, 4.7283> <-10.6390, 15.0458, 5.2689> <-10.6405, 15.0443, 5.6744>
		<-10.6405, 15.6849, 4.3229> <-10.6371, 15.6815, 4.7283> <-10.6390, 15.6834, 5.2689> <-10.6405, 15.6849, 5.6744>
		<-10.6213, 15.7042, 4.3229> <-10.6179, 15.7008, 4.7283> <-10.6197, 15.7027, 5.2689> <-10.6213, 15.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 15.0250, 4.3229> <-10.6020, 15.0057, 4.3229> <-9.9614, 15.0057, 4.3229> <-9.9421, 15.0250, 4.3229>
		<-10.6179, 15.0284, 4.7283> <-10.5986, 15.0091, 4.7283> <-9.9648, 15.0091, 4.7283> <-9.9455, 15.0284, 4.7283>
		<-10.6197, 15.0265, 5.2689> <-10.6004, 15.0072, 5.2689> <-9.9629, 15.0072, 5.2689> <-9.9436, 15.0265, 5.2689>
		<-10.6213, 15.0250, 5.6744> <-10.6020, 15.0057, 5.6744> <-9.9614, 15.0057, 5.6744> <-9.9421, 15.0250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 15.0250, 4.3229> <-9.9228, 15.0443, 4.3229> <-9.9228, 15.6849, 4.3229> <-9.9421, 15.7042, 4.3229>
		<-9.9455, 15.0284, 4.7283> <-9.9262, 15.0477, 4.7283> <-9.9262, 15.6815, 4.7283> <-9.9455, 15.7008, 4.7283>
		<-9.9436, 15.0265, 5.2689> <-9.9243, 15.0458, 5.2689> <-9.9243, 15.6834, 5.2689> <-9.9436, 15.7027, 5.2689>
		<-9.9421, 15.0250, 5.6744> <-9.9228, 15.0443, 5.6744> <-9.9228, 15.6849, 5.6744> <-9.9421, 15.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 15.7042, 4.3229> <-9.9614, 15.7235, 4.3229> <-10.6020, 15.7235, 4.3229> <-10.6213, 15.7042, 4.3229>
		<-9.9455, 15.7008, 4.7283> <-9.9648, 15.7201, 4.7283> <-10.5986, 15.7201, 4.7283> <-10.6179, 15.7008, 4.7283>
		<-9.9436, 15.7027, 5.2689> <-9.9629, 15.7219, 5.2689> <-10.6004, 15.7219, 5.2689> <-10.6197, 15.7027, 5.2689>
		<-9.9421, 15.7042, 5.6744> <-9.9614, 15.7235, 5.6744> <-10.6020, 15.7235, 5.6744> <-10.6213, 15.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 15.0250, 5.6744> <-10.6225, 15.0237, 6.0073> <-10.6172, 15.0290, 6.4517> <-10.6305, 15.0157, 6.7841>
		<-10.6405, 15.0443, 5.6744> <-10.6418, 15.0430, 6.0073> <-10.6371, 15.0488, 6.4517> <-10.6503, 15.0355, 6.7841>
		<-10.6405, 15.6849, 5.6744> <-10.6418, 15.6861, 6.0073> <-10.6371, 15.6804, 6.4517> <-10.6503, 15.6936, 6.7841>
		<-10.6213, 15.7042, 5.6744> <-10.6225, 15.7054, 6.0073> <-10.6172, 15.7002, 6.4517> <-10.6305, 15.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 15.0250, 5.6744> <-10.6020, 15.0057, 5.6744> <-9.9614, 15.0057, 5.6744> <-9.9421, 15.0250, 5.6744>
		<-10.6225, 15.0237, 6.0073> <-10.6032, 15.0044, 6.0073> <-9.9601, 15.0044, 6.0073> <-9.9408, 15.0237, 6.0073>
		<-10.6172, 15.0290, 6.4517> <-10.5974, 15.0092, 6.4517> <-9.9659, 15.0092, 6.4517> <-9.9461, 15.0290, 6.4517>
		<-10.6305, 15.0157, 6.7841> <-10.6107, 14.9959, 6.7841> <-9.9526, 14.9959, 6.7841> <-9.9328, 15.0157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 15.0250, 5.6744> <-9.9228, 15.0443, 5.6744> <-9.9228, 15.6849, 5.6744> <-9.9421, 15.7042, 5.6744>
		<-9.9408, 15.0237, 6.0073> <-9.9215, 15.0430, 6.0073> <-9.9215, 15.6861, 6.0073> <-9.9408, 15.7054, 6.0073>
		<-9.9461, 15.0290, 6.4517> <-9.9263, 15.0488, 6.4517> <-9.9263, 15.6804, 6.4517> <-9.9461, 15.7002, 6.4517>
		<-9.9328, 15.0157, 6.7841> <-9.9130, 15.0355, 6.7841> <-9.9130, 15.6936, 6.7841> <-9.9328, 15.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 15.7042, 5.6744> <-9.9614, 15.7235, 5.6744> <-10.6020, 15.7235, 5.6744> <-10.6213, 15.7042, 5.6744>
		<-9.9408, 15.7054, 6.0073> <-9.9601, 15.7247, 6.0073> <-10.6032, 15.7247, 6.0073> <-10.6225, 15.7054, 6.0073>
		<-9.9461, 15.7002, 6.4517> <-9.9659, 15.7200, 6.4517> <-10.5974, 15.7200, 6.4517> <-10.6172, 15.7002, 6.4517>
		<-9.9328, 15.7134, 6.7841> <-9.9526, 15.7333, 6.7841> <-10.6107, 15.7333, 6.7841> <-10.6305, 15.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 15.0157, 6.7841> <-10.6325, 15.0137, 6.8341> <-10.6449, 15.0013, 6.9079> <-10.6718, 14.9745, 6.9405>
		<-10.6503, 15.0355, 6.7841> <-10.6523, 15.0336, 6.8341> <-10.6671, 15.0235, 6.9079> <-10.6940, 14.9966, 6.9405>
		<-10.6503, 15.6936, 6.7841> <-10.6523, 15.6956, 6.8341> <-10.6671, 15.7057, 6.9079> <-10.6940, 15.7326, 6.9405>
		<-10.6305, 15.7134, 6.7841> <-10.6325, 15.7154, 6.8341> <-10.6449, 15.7278, 6.9079> <-10.6718, 15.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 15.0157, 6.7841> <-10.6107, 14.9959, 6.7841> <-9.9526, 14.9959, 6.7841> <-9.9328, 15.0157, 6.7841>
		<-10.6325, 15.0137, 6.8341> <-10.6127, 14.9939, 6.8341> <-9.9506, 14.9939, 6.8341> <-9.9308, 15.0137, 6.8341>
		<-10.6449, 15.0013, 6.9079> <-10.6228, 14.9792, 6.9079> <-9.9406, 14.9792, 6.9079> <-9.9184, 15.0013, 6.9079>
		<-10.6718, 14.9745, 6.9405> <-10.6496, 14.9523, 6.9405> <-9.9137, 14.9523, 6.9405> <-9.8915, 14.9745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 15.0157, 6.7841> <-9.9130, 15.0355, 6.7841> <-9.9130, 15.6936, 6.7841> <-9.9328, 15.7134, 6.7841>
		<-9.9308, 15.0137, 6.8341> <-9.9110, 15.0336, 6.8341> <-9.9110, 15.6956, 6.8341> <-9.9308, 15.7154, 6.8341>
		<-9.9184, 15.0013, 6.9079> <-9.8962, 15.0235, 6.9079> <-9.8962, 15.7057, 6.9079> <-9.9184, 15.7278, 6.9079>
		<-9.8915, 14.9745, 6.9405> <-9.8694, 14.9966, 6.9405> <-9.8694, 15.7326, 6.9405> <-9.8915, 15.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 15.7134, 6.7841> <-9.9526, 15.7333, 6.7841> <-10.6107, 15.7333, 6.7841> <-10.6305, 15.7134, 6.7841>
		<-9.9308, 15.7154, 6.8341> <-9.9506, 15.7352, 6.8341> <-10.6127, 15.7352, 6.8341> <-10.6325, 15.7154, 6.8341>
		<-9.9184, 15.7278, 6.9079> <-9.9406, 15.7500, 6.9079> <-10.6228, 15.7500, 6.9079> <-10.6449, 15.7278, 6.9079>
		<-9.8915, 15.7547, 6.9405> <-9.9137, 15.7769, 6.9405> <-10.6496, 15.7769, 6.9405> <-10.6718, 15.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 14.9745, 6.9405> <-10.7339, 14.9123, 7.0160> <-10.8620, 14.7842, 7.0331> <-10.9114, 14.7348, 7.1255>
		<-10.6940, 14.9966, 6.9405> <-10.7561, 14.9345, 7.0160> <-10.8978, 14.8200, 7.0331> <-10.9472, 14.7706, 7.1255>
		<-10.6940, 15.7326, 6.9405> <-10.7561, 15.7947, 7.0160> <-10.8978, 15.9092, 7.0331> <-10.9472, 15.9586, 7.1255>
		<-10.6718, 15.7547, 6.9405> <-10.7339, 15.8168, 7.0160> <-10.8620, 15.9449, 7.0331> <-10.9114, 15.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 14.9745, 6.9405> <-10.6496, 14.9523, 6.9405> <-9.9137, 14.9523, 6.9405> <-9.8915, 14.9745, 6.9405>
		<-10.7339, 14.9123, 7.0160> <-10.7117, 14.8902, 7.0160> <-9.8516, 14.8902, 7.0160> <-9.8294, 14.9123, 7.0160>
		<-10.8620, 14.7842, 7.0331> <-10.8262, 14.7485, 7.0331> <-9.7371, 14.7485, 7.0331> <-9.7013, 14.7842, 7.0331>
		<-10.9114, 14.7348, 7.1255> <-10.8757, 14.6990, 7.1255> <-9.6877, 14.6990, 7.1255> <-9.6519, 14.7348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 14.9745, 6.9405> <-9.8694, 14.9966, 6.9405> <-9.8694, 15.7326, 6.9405> <-9.8915, 15.7547, 6.9405>
		<-9.8294, 14.9123, 7.0160> <-9.8073, 14.9345, 7.0160> <-9.8073, 15.7947, 7.0160> <-9.8294, 15.8168, 7.0160>
		<-9.7013, 14.7842, 7.0331> <-9.6655, 14.8200, 7.0331> <-9.6655, 15.9092, 7.0331> <-9.7013, 15.9449, 7.0331>
		<-9.6519, 14.7348, 7.1255> <-9.6161, 14.7706, 7.1255> <-9.6161, 15.9586, 7.1255> <-9.6519, 15.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 15.7547, 6.9405> <-9.9137, 15.7769, 6.9405> <-10.6496, 15.7769, 6.9405> <-10.6718, 15.7547, 6.9405>
		<-9.8294, 15.8168, 7.0160> <-9.8516, 15.8390, 7.0160> <-10.7117, 15.8390, 7.0160> <-10.7339, 15.8168, 7.0160>
		<-9.7013, 15.9449, 7.0331> <-9.7371, 15.9807, 7.0331> <-10.8262, 15.9807, 7.0331> <-10.8620, 15.9449, 7.0331>
		<-9.6519, 15.9944, 7.1255> <-9.6877, 16.0301, 7.1255> <-10.8757, 16.0301, 7.1255> <-10.9114, 15.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 14.7348, 7.1255> <-10.9319, 14.7143, 7.1638> <-10.8316, 14.8146, 7.1912> <-10.8316, 14.8146, 7.2393>
		<-10.9472, 14.7706, 7.1255> <-10.9677, 14.7501, 7.1638> <-10.8629, 14.8459, 7.1912> <-10.8629, 14.8459, 7.2393>
		<-10.9472, 15.9586, 7.1255> <-10.9677, 15.9791, 7.1638> <-10.8629, 15.8833, 7.1912> <-10.8629, 15.8833, 7.2393>
		<-10.9114, 15.9944, 7.1255> <-10.9319, 16.0149, 7.1638> <-10.8316, 15.9145, 7.1912> <-10.8316, 15.9145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 14.7348, 7.1255> <-10.8757, 14.6990, 7.1255> <-9.6877, 14.6990, 7.1255> <-9.6519, 14.7348, 7.1255>
		<-10.9319, 14.7143, 7.1638> <-10.8962, 14.6785, 7.1638> <-9.6671, 14.6785, 7.1638> <-9.6314, 14.7143, 7.1638>
		<-10.8316, 14.8146, 7.1912> <-10.8004, 14.7834, 7.1912> <-9.7629, 14.7834, 7.1912> <-9.7317, 14.8146, 7.1912>
		<-10.8316, 14.8146, 7.2393> <-10.8004, 14.7834, 7.2393> <-9.7629, 14.7834, 7.2393> <-9.7317, 14.8146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 14.7348, 7.1255> <-9.6161, 14.7706, 7.1255> <-9.6161, 15.9586, 7.1255> <-9.6519, 15.9944, 7.1255>
		<-9.6314, 14.7143, 7.1638> <-9.5956, 14.7501, 7.1638> <-9.5956, 15.9791, 7.1638> <-9.6314, 16.0149, 7.1638>
		<-9.7317, 14.8146, 7.1912> <-9.7005, 14.8459, 7.1912> <-9.7005, 15.8833, 7.1912> <-9.7317, 15.9145, 7.1912>
		<-9.7317, 14.8146, 7.2393> <-9.7005, 14.8459, 7.2393> <-9.7005, 15.8833, 7.2393> <-9.7317, 15.9145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 15.9944, 7.1255> <-9.6877, 16.0301, 7.1255> <-10.8757, 16.0301, 7.1255> <-10.9114, 15.9944, 7.1255>
		<-9.6314, 16.0149, 7.1638> <-9.6671, 16.0506, 7.1638> <-10.8962, 16.0506, 7.1638> <-10.9319, 16.0149, 7.1638>
		<-9.7317, 15.9145, 7.1912> <-9.7629, 15.9458, 7.1912> <-10.8004, 15.9458, 7.1912> <-10.8316, 15.9145, 7.1912>
		<-9.7317, 15.9145, 7.2393> <-9.7629, 15.9458, 7.2393> <-10.8004, 15.9458, 7.2393> <-10.8316, 15.9145, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 14.8146, 7.2393> <-10.8316, 14.8146, 7.2905> <-10.9054, 14.7408, 7.3169> <-10.9114, 14.7348, 7.3673>
		<-10.8629, 14.8459, 7.2393> <-10.8629, 14.8459, 7.2905> <-10.9412, 14.7766, 7.3169> <-10.9472, 14.7706, 7.3673>
		<-10.8629, 15.8833, 7.2393> <-10.8629, 15.8833, 7.2905> <-10.9412, 15.9526, 7.3169> <-10.9472, 15.9586, 7.3673>
		<-10.8316, 15.9145, 7.2393> <-10.8316, 15.9145, 7.2905> <-10.9054, 15.9883, 7.3169> <-10.9114, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 14.8146, 7.2393> <-10.8004, 14.7834, 7.2393> <-9.7629, 14.7834, 7.2393> <-9.7317, 14.8146, 7.2393>
		<-10.8316, 14.8146, 7.2905> <-10.8004, 14.7834, 7.2905> <-9.7629, 14.7834, 7.2905> <-9.7317, 14.8146, 7.2905>
		<-10.9054, 14.7408, 7.3169> <-10.8696, 14.7051, 7.3169> <-9.6937, 14.7051, 7.3169> <-9.6579, 14.7408, 7.3169>
		<-10.9114, 14.7348, 7.3673> <-10.8757, 14.6990, 7.3673> <-9.6877, 14.6990, 7.3673> <-9.6519, 14.7348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 14.8146, 7.2393> <-9.7005, 14.8459, 7.2393> <-9.7005, 15.8833, 7.2393> <-9.7317, 15.9145, 7.2393>
		<-9.7317, 14.8146, 7.2905> <-9.7005, 14.8459, 7.2905> <-9.7005, 15.8833, 7.2905> <-9.7317, 15.9145, 7.2905>
		<-9.6579, 14.7408, 7.3169> <-9.6222, 14.7766, 7.3169> <-9.6222, 15.9526, 7.3169> <-9.6579, 15.9883, 7.3169>
		<-9.6519, 14.7348, 7.3673> <-9.6161, 14.7706, 7.3673> <-9.6161, 15.9586, 7.3673> <-9.6519, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 15.9145, 7.2393> <-9.7629, 15.9458, 7.2393> <-10.8004, 15.9458, 7.2393> <-10.8316, 15.9145, 7.2393>
		<-9.7317, 15.9145, 7.2905> <-9.7629, 15.9458, 7.2905> <-10.8004, 15.9458, 7.2905> <-10.8316, 15.9145, 7.2905>
		<-9.6579, 15.9883, 7.3169> <-9.6937, 16.0241, 7.3169> <-10.8696, 16.0241, 7.3169> <-10.9054, 15.9883, 7.3169>
		<-9.6519, 15.9944, 7.3673> <-9.6877, 16.0301, 7.3673> <-10.8757, 16.0301, 7.3673> <-10.9114, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 14.7348, 7.9080> <-10.9472, 14.7706, 7.9080> <-10.9472, 15.9586, 7.9080> <-10.9114, 15.9944, 7.9080>
		<-10.9114, 14.7348, 7.7458> <-10.9472, 14.7706, 7.7458> <-10.9472, 15.9586, 7.7458> <-10.9114, 15.9944, 7.7458>
		<-10.9305, 14.7157, 7.5273> <-10.9663, 14.7515, 7.5273> <-10.9663, 15.9777, 7.5273> <-10.9305, 16.0134, 7.5273>
		<-10.9114, 14.7348, 7.3673> <-10.9472, 14.7706, 7.3673> <-10.9472, 15.9586, 7.3673> <-10.9114, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 14.7348, 7.9080> <-10.9114, 14.7348, 7.7458> <-10.9305, 14.7157, 7.5273> <-10.9114, 14.7348, 7.3673>
		<-10.8757, 14.6990, 7.9080> <-10.8757, 14.6990, 7.7458> <-10.8947, 14.6800, 7.5273> <-10.8757, 14.6990, 7.3673>
		<-9.6877, 14.6990, 7.9080> <-9.6877, 14.6990, 7.7458> <-9.6686, 14.6800, 7.5273> <-9.6877, 14.6990, 7.3673>
		<-9.6519, 14.7348, 7.9080> <-9.6519, 14.7348, 7.7458> <-9.6328, 14.7157, 7.5273> <-9.6519, 14.7348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 14.7348, 7.9080> <-9.6519, 14.7348, 7.7458> <-9.6328, 14.7157, 7.5273> <-9.6519, 14.7348, 7.3673>
		<-9.6161, 14.7706, 7.9080> <-9.6161, 14.7706, 7.7458> <-9.5970, 14.7515, 7.5273> <-9.6161, 14.7706, 7.3673>
		<-9.6161, 15.9586, 7.9080> <-9.6161, 15.9586, 7.7458> <-9.5970, 15.9777, 7.5273> <-9.6161, 15.9586, 7.3673>
		<-9.6519, 15.9944, 7.9080> <-9.6519, 15.9944, 7.7458> <-9.6328, 16.0134, 7.5273> <-9.6519, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 15.9944, 7.9080> <-9.6519, 15.9944, 7.7458> <-9.6328, 16.0134, 7.5273> <-9.6519, 15.9944, 7.3673>
		<-9.6877, 16.0301, 7.9080> <-9.6877, 16.0301, 7.7458> <-9.6686, 16.0492, 7.5273> <-9.6877, 16.0301, 7.3673>
		<-10.8757, 16.0301, 7.9080> <-10.8757, 16.0301, 7.7458> <-10.8947, 16.0492, 7.5273> <-10.8757, 16.0301, 7.3673>
		<-10.9114, 15.9944, 7.9080> <-10.9114, 15.9944, 7.7458> <-10.9305, 16.0134, 7.5273> <-10.9114, 15.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 14.4874, 0.7771> <-11.2087, 14.5372, 0.7771> <-11.2087, 16.1920, 0.7771> <-11.1589, 16.2418, 0.7771>
		<-11.1796, 14.4666, 0.6520> <-11.2294, 14.5164, 0.6520> <-11.2294, 16.2127, 0.6520> <-11.1796, 16.2626, 0.6520>
		<-11.1589, 14.4874, 0.4772> <-11.2087, 14.5372, 0.4772> <-11.2087, 16.1920, 0.4772> <-11.1589, 16.2418, 0.4772>
		<-11.1589, 14.4874, 0.3486> <-11.2087, 14.5372, 0.3486> <-11.2087, 16.1920, 0.3486> <-11.1589, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 14.4874, 0.7771> <-11.1796, 14.4666, 0.6520> <-11.1589, 14.4874, 0.4772> <-11.1589, 14.4874, 0.3486>
		<-11.1090, 14.4376, 0.7771> <-11.1298, 14.4168, 0.6520> <-11.1090, 14.4376, 0.4772> <-11.1090, 14.4376, 0.3486>
		<-9.4543, 14.4376, 0.7771> <-9.4335, 14.4168, 0.6520> <-9.4543, 14.4376, 0.4772> <-9.4543, 14.4376, 0.3486>
		<-9.4045, 14.4874, 0.7771> <-9.3837, 14.4666, 0.6520> <-9.4045, 14.4874, 0.4772> <-9.4045, 14.4874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 14.4874, 0.7771> <-9.3837, 14.4666, 0.6520> <-9.4045, 14.4874, 0.4772> <-9.4045, 14.4874, 0.3486>
		<-9.3546, 14.5372, 0.7771> <-9.3339, 14.5164, 0.6520> <-9.3546, 14.5372, 0.4772> <-9.3546, 14.5372, 0.3486>
		<-9.3546, 16.1920, 0.7771> <-9.3339, 16.2127, 0.6520> <-9.3546, 16.1920, 0.4772> <-9.3546, 16.1920, 0.3486>
		<-9.4045, 16.2418, 0.7771> <-9.3837, 16.2626, 0.6520> <-9.4045, 16.2418, 0.4772> <-9.4045, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 16.2418, 0.7771> <-9.3837, 16.2626, 0.6520> <-9.4045, 16.2418, 0.4772> <-9.4045, 16.2418, 0.3486>
		<-9.4543, 16.2916, 0.7771> <-9.4335, 16.3124, 0.6520> <-9.4543, 16.2916, 0.4772> <-9.4543, 16.2916, 0.3486>
		<-11.1090, 16.2916, 0.7771> <-11.1298, 16.3124, 0.6520> <-11.1090, 16.2916, 0.4772> <-11.1090, 16.2916, 0.3486>
		<-11.1589, 16.2418, 0.7771> <-11.1796, 16.2626, 0.6520> <-11.1589, 16.2418, 0.4772> <-11.1589, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 14.4874, -0.0618> <-11.1589, 14.4874, 0.0613> <-11.1589, 14.4874, 0.2255> <-11.1589, 14.4874, 0.3486>
		<-11.2087, 14.5372, -0.0618> <-11.2087, 14.5372, 0.0613> <-11.2087, 14.5372, 0.2255> <-11.2087, 14.5372, 0.3486>
		<-11.2087, 16.1920, -0.0618> <-11.2087, 16.1920, 0.0613> <-11.2087, 16.1920, 0.2255> <-11.2087, 16.1920, 0.3486>
		<-11.1589, 16.2418, -0.0618> <-11.1589, 16.2418, 0.0613> <-11.1589, 16.2418, 0.2255> <-11.1589, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 14.4874, -0.0618> <-11.1090, 14.4376, -0.0618> <-9.4543, 14.4376, -0.0618> <-9.4045, 14.4874, -0.0618>
		<-11.1589, 14.4874, 0.0613> <-11.1090, 14.4376, 0.0613> <-9.4543, 14.4376, 0.0613> <-9.4045, 14.4874, 0.0613>
		<-11.1589, 14.4874, 0.2255> <-11.1090, 14.4376, 0.2255> <-9.4543, 14.4376, 0.2255> <-9.4045, 14.4874, 0.2255>
		<-11.1589, 14.4874, 0.3486> <-11.1090, 14.4376, 0.3486> <-9.4543, 14.4376, 0.3486> <-9.4045, 14.4874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 14.4874, -0.0618> <-9.3546, 14.5372, -0.0618> <-9.3546, 16.1920, -0.0618> <-9.4045, 16.2418, -0.0618>
		<-9.4045, 14.4874, 0.0613> <-9.3546, 14.5372, 0.0613> <-9.3546, 16.1920, 0.0613> <-9.4045, 16.2418, 0.0613>
		<-9.4045, 14.4874, 0.2255> <-9.3546, 14.5372, 0.2255> <-9.3546, 16.1920, 0.2255> <-9.4045, 16.2418, 0.2255>
		<-9.4045, 14.4874, 0.3486> <-9.3546, 14.5372, 0.3486> <-9.3546, 16.1920, 0.3486> <-9.4045, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 16.2418, -0.0618> <-9.4543, 16.2916, -0.0618> <-11.1090, 16.2916, -0.0618> <-11.1589, 16.2418, -0.0618>
		<-9.4045, 16.2418, 0.0613> <-9.4543, 16.2916, 0.0613> <-11.1090, 16.2916, 0.0613> <-11.1589, 16.2418, 0.0613>
		<-9.4045, 16.2418, 0.2255> <-9.4543, 16.2916, 0.2255> <-11.1090, 16.2916, 0.2255> <-11.1589, 16.2418, 0.2255>
		<-9.4045, 16.2418, 0.3486> <-9.4543, 16.2916, 0.3486> <-11.1090, 16.2916, 0.3486> <-11.1589, 16.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 0.9062> <-11.1109, 12.4244, 0.9062> <-11.1109, 13.9047, 0.9062> <-11.0664, 13.9493, 0.9062>
		<-11.0712, 12.3751, 0.8515> <-11.1157, 12.4196, 0.8515> <-11.1157, 13.9095, 0.8515> <-11.0712, 13.9541, 0.8515>
		<-11.1500, 12.2963, 0.8308> <-11.1998, 12.3461, 0.8308> <-11.1998, 13.9831, 0.8308> <-11.1500, 14.0329, 0.8308>
		<-11.1589, 12.2874, 0.7771> <-11.2087, 12.3372, 0.7771> <-11.2087, 13.9920, 0.7771> <-11.1589, 14.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 0.9062> <-11.0620, 12.3842, 0.9557> <-11.1560, 12.2903, 0.9996> <-11.1357, 12.3105, 1.0404>
		<-11.1109, 12.4244, 0.9062> <-11.1066, 12.4288, 0.9557> <-11.2045, 12.3388, 0.9996> <-11.1842, 12.3590, 1.0404>
		<-11.1109, 13.9047, 0.9062> <-11.1066, 13.9004, 0.9557> <-11.2045, 13.9904, 0.9996> <-11.1842, 13.9702, 1.0404>
		<-11.0664, 13.9493, 0.9062> <-11.0620, 13.9449, 0.9557> <-11.1560, 14.0389, 0.9996> <-11.1357, 14.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 0.9062> <-11.0712, 12.3751, 0.8515> <-11.1500, 12.2963, 0.8308> <-11.1589, 12.2874, 0.7771>
		<-11.0218, 12.3353, 0.9062> <-11.0266, 12.3305, 0.8515> <-11.1001, 12.2465, 0.8308> <-11.1090, 12.2376, 0.7771>
		<-9.5415, 12.3353, 0.9062> <-9.5367, 12.3305, 0.8515> <-9.4632, 12.2465, 0.8308> <-9.4543, 12.2376, 0.7771>
		<-9.4970, 12.3799, 0.9062> <-9.4922, 12.3751, 0.8515> <-9.4134, 12.2963, 0.8308> <-9.4045, 12.2874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 0.9062> <-11.0218, 12.3353, 0.9062> <-9.5415, 12.3353, 0.9062> <-9.4970, 12.3799, 0.9062>
		<-11.0620, 12.3842, 0.9557> <-11.0175, 12.3397, 0.9557> <-9.5459, 12.3397, 0.9557> <-9.5013, 12.3842, 0.9557>
		<-11.1560, 12.2903, 0.9996> <-11.1075, 12.2418, 0.9996> <-9.4559, 12.2418, 0.9996> <-9.4073, 12.2903, 0.9996>
		<-11.1357, 12.3105, 1.0404> <-11.0872, 12.2620, 1.0404> <-9.4761, 12.2620, 1.0404> <-9.4276, 12.3105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 12.3799, 0.9062> <-9.4922, 12.3751, 0.8515> <-9.4134, 12.2963, 0.8308> <-9.4045, 12.2874, 0.7771>
		<-9.4524, 12.4244, 0.9062> <-9.4476, 12.4196, 0.8515> <-9.3635, 12.3461, 0.8308> <-9.3546, 12.3372, 0.7771>
		<-9.4524, 13.9047, 0.9062> <-9.4476, 13.9095, 0.8515> <-9.3635, 13.9831, 0.8308> <-9.3546, 13.9920, 0.7771>
		<-9.4970, 13.9493, 0.9062> <-9.4922, 13.9541, 0.8515> <-9.4134, 14.0329, 0.8308> <-9.4045, 14.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 12.3799, 0.9062> <-9.4524, 12.4244, 0.9062> <-9.4524, 13.9047, 0.9062> <-9.4970, 13.9493, 0.9062>
		<-9.5013, 12.3842, 0.9557> <-9.4567, 12.4288, 0.9557> <-9.4567, 13.9004, 0.9557> <-9.5013, 13.9449, 0.9557>
		<-9.4073, 12.2903, 0.9996> <-9.3588, 12.3388, 0.9996> <-9.3588, 13.9904, 0.9996> <-9.4073, 14.0389, 0.9996>
		<-9.4276, 12.3105, 1.0404> <-9.3791, 12.3590, 1.0404> <-9.3791, 13.9702, 1.0404> <-9.4276, 14.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 13.9493, 0.9062> <-9.4922, 13.9541, 0.8515> <-9.4134, 14.0329, 0.8308> <-9.4045, 14.0418, 0.7771>
		<-9.5415, 13.9939, 0.9062> <-9.5367, 13.9987, 0.8515> <-9.4632, 14.0827, 0.8308> <-9.4543, 14.0916, 0.7771>
		<-11.0218, 13.9939, 0.9062> <-11.0266, 13.9987, 0.8515> <-11.1001, 14.0827, 0.8308> <-11.1090, 14.0916, 0.7771>
		<-11.0664, 13.9493, 0.9062> <-11.0712, 13.9541, 0.8515> <-11.1500, 14.0329, 0.8308> <-11.1589, 14.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 13.9493, 0.9062> <-9.5415, 13.9939, 0.9062> <-11.0218, 13.9939, 0.9062> <-11.0664, 13.9493, 0.9062>
		<-9.5013, 13.9449, 0.9557> <-9.5459, 13.9895, 0.9557> <-11.0175, 13.9895, 0.9557> <-11.0620, 13.9449, 0.9557>
		<-9.4073, 14.0389, 0.9996> <-9.4559, 14.0874, 0.9996> <-11.1075, 14.0874, 0.9996> <-11.1560, 14.0389, 0.9996>
		<-9.4276, 14.0187, 1.0404> <-9.4761, 14.0672, 1.0404> <-11.0872, 14.0672, 1.0404> <-11.1357, 14.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 12.3105, 1.0404> <-11.0677, 12.3786, 1.1777> <-10.8982, 12.5481, 1.2552> <-10.8269, 12.6193, 1.3892>
		<-11.1842, 12.3590, 1.0404> <-11.1162, 12.4271, 1.1777> <-10.9291, 12.5790, 1.2552> <-10.8579, 12.6503, 1.3892>
		<-11.1842, 13.9702, 1.0404> <-11.1162, 13.9021, 1.1777> <-10.9291, 13.7501, 1.2552> <-10.8579, 13.6789, 1.3892>
		<-11.1357, 14.0187, 1.0404> <-11.0677, 13.9506, 1.1777> <-10.8982, 13.7811, 1.2552> <-10.8269, 13.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 12.3105, 1.0404> <-11.0872, 12.2620, 1.0404> <-9.4761, 12.2620, 1.0404> <-9.4276, 12.3105, 1.0404>
		<-11.0677, 12.3786, 1.1777> <-11.0192, 12.3301, 1.1777> <-9.5442, 12.3301, 1.1777> <-9.4957, 12.3786, 1.1777>
		<-10.8982, 12.5481, 1.2552> <-10.8672, 12.5171, 1.2552> <-9.6961, 12.5171, 1.2552> <-9.6652, 12.5481, 1.2552>
		<-10.8269, 12.6193, 1.3892> <-10.7959, 12.5884, 1.3892> <-9.7674, 12.5884, 1.3892> <-9.7364, 12.6193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 12.3105, 1.0404> <-9.3791, 12.3590, 1.0404> <-9.3791, 13.9702, 1.0404> <-9.4276, 14.0187, 1.0404>
		<-9.4957, 12.3786, 1.1777> <-9.4471, 12.4271, 1.1777> <-9.4471, 13.9021, 1.1777> <-9.4957, 13.9506, 1.1777>
		<-9.6652, 12.5481, 1.2552> <-9.6342, 12.5790, 1.2552> <-9.6342, 13.7501, 1.2552> <-9.6652, 13.7811, 1.2552>
		<-9.7364, 12.6193, 1.3892> <-9.7054, 12.6503, 1.3892> <-9.7054, 13.6789, 1.3892> <-9.7364, 13.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 14.0187, 1.0404> <-9.4761, 14.0672, 1.0404> <-11.0872, 14.0672, 1.0404> <-11.1357, 14.0187, 1.0404>
		<-9.4957, 13.9506, 1.1777> <-9.5442, 13.9991, 1.1777> <-11.0192, 13.9991, 1.1777> <-11.0677, 13.9506, 1.1777>
		<-9.6652, 13.7811, 1.2552> <-9.6961, 13.8121, 1.2552> <-10.8672, 13.8121, 1.2552> <-10.8982, 13.7811, 1.2552>
		<-9.7364, 13.7098, 1.3892> <-9.7674, 13.7408, 1.3892> <-10.7959, 13.7408, 1.3892> <-10.8269, 13.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 12.6193, 1.3892> <-10.8079, 12.6383, 1.4249> <-10.8837, 12.5626, 1.4698> <-10.8837, 12.5626, 1.5144>
		<-10.8579, 12.6503, 1.3892> <-10.8389, 12.6693, 1.4249> <-10.9179, 12.5968, 1.4698> <-10.9179, 12.5968, 1.5144>
		<-10.8579, 13.6789, 1.3892> <-10.8389, 13.6599, 1.4249> <-10.9179, 13.7324, 1.4698> <-10.9179, 13.7324, 1.5144>
		<-10.8269, 13.7098, 1.3892> <-10.8079, 13.6909, 1.4249> <-10.8837, 13.7666, 1.4698> <-10.8837, 13.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 12.6193, 1.3892> <-10.7959, 12.5884, 1.3892> <-9.7674, 12.5884, 1.3892> <-9.7364, 12.6193, 1.3892>
		<-10.8079, 12.6383, 1.4249> <-10.7770, 12.6073, 1.4249> <-9.7863, 12.6073, 1.4249> <-9.7554, 12.6383, 1.4249>
		<-10.8837, 12.5626, 1.4698> <-10.8495, 12.5284, 1.4698> <-9.7138, 12.5284, 1.4698> <-9.6796, 12.5626, 1.4698>
		<-10.8837, 12.5626, 1.5144> <-10.8495, 12.5284, 1.5144> <-9.7138, 12.5284, 1.5144> <-9.6796, 12.5626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 12.6193, 1.3892> <-9.7054, 12.6503, 1.3892> <-9.7054, 13.6789, 1.3892> <-9.7364, 13.7098, 1.3892>
		<-9.7554, 12.6383, 1.4249> <-9.7244, 12.6693, 1.4249> <-9.7244, 13.6599, 1.4249> <-9.7554, 13.6909, 1.4249>
		<-9.6796, 12.5626, 1.4698> <-9.6455, 12.5968, 1.4698> <-9.6455, 13.7324, 1.4698> <-9.6796, 13.7666, 1.4698>
		<-9.6796, 12.5626, 1.5144> <-9.6455, 12.5968, 1.5144> <-9.6455, 13.7324, 1.5144> <-9.6796, 13.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 13.7098, 1.3892> <-9.7674, 13.7408, 1.3892> <-10.7959, 13.7408, 1.3892> <-10.8269, 13.7098, 1.3892>
		<-9.7554, 13.6909, 1.4249> <-9.7863, 13.7218, 1.4249> <-10.7770, 13.7218, 1.4249> <-10.8079, 13.6909, 1.4249>
		<-9.6796, 13.7666, 1.4698> <-9.7138, 13.8008, 1.4698> <-10.8495, 13.8008, 1.4698> <-10.8837, 13.7666, 1.4698>
		<-9.6796, 13.7666, 1.5144> <-9.7138, 13.8008, 1.5144> <-10.8495, 13.8008, 1.5144> <-10.8837, 13.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 12.5626, 1.5144> <-10.8837, 12.5626, 1.5613> <-10.8121, 12.6341, 1.6066> <-10.8269, 12.6193, 1.6486>
		<-10.9179, 12.5968, 1.5144> <-10.9179, 12.5968, 1.5613> <-10.8431, 12.6651, 1.6066> <-10.8579, 12.6503, 1.6486>
		<-10.9179, 13.7324, 1.5144> <-10.9179, 13.7324, 1.5613> <-10.8431, 13.6641, 1.6066> <-10.8579, 13.6789, 1.6486>
		<-10.8837, 13.7666, 1.5144> <-10.8837, 13.7666, 1.5613> <-10.8121, 13.6950, 1.6066> <-10.8269, 13.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 12.5626, 1.5144> <-10.8495, 12.5284, 1.5144> <-9.7138, 12.5284, 1.5144> <-9.6796, 12.5626, 1.5144>
		<-10.8837, 12.5626, 1.5613> <-10.8495, 12.5284, 1.5613> <-9.7138, 12.5284, 1.5613> <-9.6796, 12.5626, 1.5613>
		<-10.8121, 12.6341, 1.6066> <-10.7812, 12.6032, 1.6066> <-9.7822, 12.6032, 1.6066> <-9.7512, 12.6341, 1.6066>
		<-10.8269, 12.6193, 1.6486> <-10.7959, 12.5884, 1.6486> <-9.7674, 12.5884, 1.6486> <-9.7364, 12.6193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 12.5626, 1.5144> <-9.6455, 12.5968, 1.5144> <-9.6455, 13.7324, 1.5144> <-9.6796, 13.7666, 1.5144>
		<-9.6796, 12.5626, 1.5613> <-9.6455, 12.5968, 1.5613> <-9.6455, 13.7324, 1.5613> <-9.6796, 13.7666, 1.5613>
		<-9.7512, 12.6341, 1.6066> <-9.7202, 12.6651, 1.6066> <-9.7202, 13.6641, 1.6066> <-9.7512, 13.6950, 1.6066>
		<-9.7364, 12.6193, 1.6486> <-9.7054, 12.6503, 1.6486> <-9.7054, 13.6789, 1.6486> <-9.7364, 13.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 13.7666, 1.5144> <-9.7138, 13.8008, 1.5144> <-10.8495, 13.8008, 1.5144> <-10.8837, 13.7666, 1.5144>
		<-9.6796, 13.7666, 1.5613> <-9.7138, 13.8008, 1.5613> <-10.8495, 13.8008, 1.5613> <-10.8837, 13.7666, 1.5613>
		<-9.7512, 13.6950, 1.6066> <-9.7822, 13.7260, 1.6066> <-10.7812, 13.7260, 1.6066> <-10.8121, 13.6950, 1.6066>
		<-9.7364, 13.7098, 1.6486> <-9.7674, 13.7408, 1.6486> <-10.7959, 13.7408, 1.6486> <-10.8269, 13.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 12.6193, 1.6486> <-10.8754, 12.5709, 1.7862> <-11.0172, 12.4290, 1.8960> <-11.0664, 12.3799, 2.0332>
		<-10.8579, 12.6503, 1.6486> <-10.9063, 12.6018, 1.7862> <-11.0618, 12.4736, 1.8960> <-11.1109, 12.4244, 2.0332>
		<-10.8579, 13.6789, 1.6486> <-10.9063, 13.7273, 1.7862> <-11.0618, 13.8556, 1.8960> <-11.1109, 13.9047, 2.0332>
		<-10.8269, 13.7098, 1.6486> <-10.8754, 13.7583, 1.7862> <-11.0172, 13.9002, 1.8960> <-11.0664, 13.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 12.6193, 1.6486> <-10.7959, 12.5884, 1.6486> <-9.7674, 12.5884, 1.6486> <-9.7364, 12.6193, 1.6486>
		<-10.8754, 12.5709, 1.7862> <-10.8444, 12.5399, 1.7862> <-9.7189, 12.5399, 1.7862> <-9.6880, 12.5709, 1.7862>
		<-11.0172, 12.4290, 1.8960> <-10.9727, 12.3844, 1.8960> <-9.5907, 12.3844, 1.8960> <-9.5461, 12.4290, 1.8960>
		<-11.0664, 12.3799, 2.0332> <-11.0218, 12.3353, 2.0332> <-9.5415, 12.3353, 2.0332> <-9.4970, 12.3799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 12.6193, 1.6486> <-9.7054, 12.6503, 1.6486> <-9.7054, 13.6789, 1.6486> <-9.7364, 13.7098, 1.6486>
		<-9.6880, 12.5709, 1.7862> <-9.6570, 12.6018, 1.7862> <-9.6570, 13.7273, 1.7862> <-9.6880, 13.7583, 1.7862>
		<-9.5461, 12.4290, 1.8960> <-9.5015, 12.4736, 1.8960> <-9.5015, 13.8556, 1.8960> <-9.5461, 13.9002, 1.8960>
		<-9.4970, 12.3799, 2.0332> <-9.4524, 12.4244, 2.0332> <-9.4524, 13.9047, 2.0332> <-9.4970, 13.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 13.7098, 1.6486> <-9.7674, 13.7408, 1.6486> <-10.7959, 13.7408, 1.6486> <-10.8269, 13.7098, 1.6486>
		<-9.6880, 13.7583, 1.7862> <-9.7189, 13.7893, 1.7862> <-10.8444, 13.7893, 1.7862> <-10.8754, 13.7583, 1.7862>
		<-9.5461, 13.9002, 1.8960> <-9.5907, 13.9447, 1.8960> <-10.9727, 13.9447, 1.8960> <-11.0172, 13.9002, 1.8960>
		<-9.4970, 13.9493, 2.0332> <-9.5415, 13.9939, 2.0332> <-11.0218, 13.9939, 2.0332> <-11.0664, 13.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 2.0332> <-11.0930, 12.3533, 2.1074> <-11.0932, 12.3531, 2.2382> <-11.0641, 12.3822, 2.3104>
		<-11.1109, 12.4244, 2.0332> <-11.1375, 12.3979, 2.1074> <-11.1376, 12.3975, 2.2382> <-11.1085, 12.4266, 2.3104>
		<-11.1109, 13.9047, 2.0332> <-11.1375, 13.9313, 2.1074> <-11.1376, 13.9317, 2.2382> <-11.1085, 13.9025, 2.3104>
		<-11.0664, 13.9493, 2.0332> <-11.0930, 13.9759, 2.1074> <-11.0932, 13.9761, 2.2382> <-11.0641, 13.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 12.3799, 2.0332> <-11.0218, 12.3353, 2.0332> <-9.5415, 12.3353, 2.0332> <-9.4970, 12.3799, 2.0332>
		<-11.0930, 12.3533, 2.1074> <-11.0484, 12.3087, 2.1074> <-9.5149, 12.3087, 2.1074> <-9.4704, 12.3533, 2.1074>
		<-11.0932, 12.3531, 2.2382> <-11.0488, 12.3086, 2.2382> <-9.5146, 12.3086, 2.2382> <-9.4701, 12.3531, 2.2382>
		<-11.0641, 12.3822, 2.3104> <-11.0196, 12.3378, 2.3104> <-9.5437, 12.3378, 2.3104> <-9.4993, 12.3822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 12.3799, 2.0332> <-9.4524, 12.4244, 2.0332> <-9.4524, 13.9047, 2.0332> <-9.4970, 13.9493, 2.0332>
		<-9.4704, 12.3533, 2.1074> <-9.4258, 12.3979, 2.1074> <-9.4258, 13.9313, 2.1074> <-9.4704, 13.9759, 2.1074>
		<-9.4701, 12.3531, 2.2382> <-9.4257, 12.3975, 2.2382> <-9.4257, 13.9317, 2.2382> <-9.4701, 13.9761, 2.2382>
		<-9.4993, 12.3822, 2.3104> <-9.4548, 12.4266, 2.3104> <-9.4548, 13.9025, 2.3104> <-9.4993, 13.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 13.9493, 2.0332> <-9.5415, 13.9939, 2.0332> <-11.0218, 13.9939, 2.0332> <-11.0664, 13.9493, 2.0332>
		<-9.4704, 13.9759, 2.1074> <-9.5149, 14.0204, 2.1074> <-11.0484, 14.0204, 2.1074> <-11.0930, 13.9759, 2.1074>
		<-9.4701, 13.9761, 2.2382> <-9.5146, 14.0206, 2.2382> <-11.0488, 14.0206, 2.2382> <-11.0932, 13.9761, 2.2382>
		<-9.4993, 13.9470, 2.3104> <-9.5437, 13.9914, 2.3104> <-11.0196, 13.9914, 2.3104> <-11.0641, 13.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 12.3822, 2.3104> <-10.9801, 12.4661, 2.5186> <-10.7843, 12.6620, 2.7154> <-10.7056, 12.7406, 2.9276>
		<-11.1085, 12.4266, 2.3104> <-11.0246, 12.5106, 2.5186> <-10.8084, 12.6860, 2.7154> <-10.7297, 12.7647, 2.9276>
		<-11.1085, 13.9025, 2.3104> <-11.0246, 13.8186, 2.5186> <-10.8084, 13.6431, 2.7154> <-10.7297, 13.5645, 2.9276>
		<-11.0641, 13.9470, 2.3104> <-10.9801, 13.8630, 2.5186> <-10.7843, 13.6672, 2.7154> <-10.7056, 13.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 12.3822, 2.3104> <-11.0196, 12.3378, 2.3104> <-9.5437, 12.3378, 2.3104> <-9.4993, 12.3822, 2.3104>
		<-10.9801, 12.4661, 2.5186> <-10.9357, 12.4217, 2.5186> <-9.6277, 12.4217, 2.5186> <-9.5832, 12.4661, 2.5186>
		<-10.7843, 12.6620, 2.7154> <-10.7602, 12.6379, 2.7154> <-9.8031, 12.6379, 2.7154> <-9.7790, 12.6620, 2.7154>
		<-10.7056, 12.7406, 2.9276> <-10.6815, 12.7165, 2.9276> <-9.8818, 12.7165, 2.9276> <-9.8577, 12.7406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 12.3822, 2.3104> <-9.4548, 12.4266, 2.3104> <-9.4548, 13.9025, 2.3104> <-9.4993, 13.9470, 2.3104>
		<-9.5832, 12.4661, 2.5186> <-9.5388, 12.5106, 2.5186> <-9.5388, 13.8186, 2.5186> <-9.5832, 13.8630, 2.5186>
		<-9.7790, 12.6620, 2.7154> <-9.7550, 12.6860, 2.7154> <-9.7550, 13.6431, 2.7154> <-9.7790, 13.6672, 2.7154>
		<-9.8577, 12.7406, 2.9276> <-9.8336, 12.7647, 2.9276> <-9.8336, 13.5645, 2.9276> <-9.8577, 13.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 13.9470, 2.3104> <-9.5437, 13.9914, 2.3104> <-11.0196, 13.9914, 2.3104> <-11.0641, 13.9470, 2.3104>
		<-9.5832, 13.8630, 2.5186> <-9.6277, 13.9075, 2.5186> <-10.9357, 13.9075, 2.5186> <-10.9801, 13.8630, 2.5186>
		<-9.7790, 13.6672, 2.7154> <-9.8031, 13.6913, 2.7154> <-10.7602, 13.6913, 2.7154> <-10.7843, 13.6672, 2.7154>
		<-9.8577, 13.5885, 2.9276> <-9.8818, 13.6126, 2.9276> <-10.6815, 13.6126, 2.9276> <-10.7056, 13.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 12.7406, 2.9276> <-10.6887, 12.7576, 2.9732> <-10.7889, 12.6574, 3.0012> <-10.7889, 12.6574, 3.0528>
		<-10.7297, 12.7647, 2.9276> <-10.7128, 12.7816, 2.9732> <-10.8177, 12.6862, 3.0012> <-10.8177, 12.6862, 3.0528>
		<-10.7297, 13.5645, 2.9276> <-10.7128, 13.5475, 2.9732> <-10.8177, 13.6430, 3.0012> <-10.8177, 13.6430, 3.0528>
		<-10.7056, 13.5885, 2.9276> <-10.6887, 13.5716, 2.9732> <-10.7889, 13.6718, 3.0012> <-10.7889, 13.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 12.7406, 2.9276> <-10.6815, 12.7165, 2.9276> <-9.8818, 12.7165, 2.9276> <-9.8577, 12.7406, 2.9276>
		<-10.6887, 12.7576, 2.9732> <-10.6646, 12.7335, 2.9732> <-9.8987, 12.7335, 2.9732> <-9.8746, 12.7576, 2.9732>
		<-10.7889, 12.6574, 3.0012> <-10.7601, 12.6286, 3.0012> <-9.8033, 12.6286, 3.0012> <-9.7745, 12.6574, 3.0012>
		<-10.7889, 12.6574, 3.0528> <-10.7601, 12.6286, 3.0528> <-9.8033, 12.6286, 3.0528> <-9.7745, 12.6574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 12.7406, 2.9276> <-9.8336, 12.7647, 2.9276> <-9.8336, 13.5645, 2.9276> <-9.8577, 13.5885, 2.9276>
		<-9.8746, 12.7576, 2.9732> <-9.8506, 12.7816, 2.9732> <-9.8506, 13.5475, 2.9732> <-9.8746, 13.5716, 2.9732>
		<-9.7745, 12.6574, 3.0012> <-9.7456, 12.6862, 3.0012> <-9.7456, 13.6430, 3.0012> <-9.7745, 13.6718, 3.0012>
		<-9.7745, 12.6574, 3.0528> <-9.7456, 12.6862, 3.0528> <-9.7456, 13.6430, 3.0528> <-9.7745, 13.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 13.5885, 2.9276> <-9.8818, 13.6126, 2.9276> <-10.6815, 13.6126, 2.9276> <-10.7056, 13.5885, 2.9276>
		<-9.8746, 13.5716, 2.9732> <-9.8987, 13.5957, 2.9732> <-10.6646, 13.5957, 2.9732> <-10.6887, 13.5716, 2.9732>
		<-9.7745, 13.6718, 3.0012> <-9.8033, 13.7006, 3.0012> <-10.7601, 13.7006, 3.0012> <-10.7889, 13.6718, 3.0012>
		<-9.7745, 13.6718, 3.0528> <-9.8033, 13.7006, 3.0528> <-10.7601, 13.7006, 3.0528> <-10.7889, 13.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 12.6574, 3.0528> <-10.7889, 12.6574, 3.1044> <-10.6862, 12.7600, 3.1344> <-10.7056, 12.7406, 3.1780>
		<-10.8177, 12.6862, 3.0528> <-10.8177, 12.6862, 3.1044> <-10.7103, 12.7841, 3.1344> <-10.7297, 12.7647, 3.1780>
		<-10.8177, 13.6430, 3.0528> <-10.8177, 13.6430, 3.1044> <-10.7103, 13.5451, 3.1344> <-10.7297, 13.5645, 3.1780>
		<-10.7889, 13.6718, 3.0528> <-10.7889, 13.6718, 3.1044> <-10.6862, 13.5691, 3.1344> <-10.7056, 13.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 12.6574, 3.0528> <-10.7601, 12.6286, 3.0528> <-9.8033, 12.6286, 3.0528> <-9.7745, 12.6574, 3.0528>
		<-10.7889, 12.6574, 3.1044> <-10.7601, 12.6286, 3.1044> <-9.8033, 12.6286, 3.1044> <-9.7745, 12.6574, 3.1044>
		<-10.6862, 12.7600, 3.1344> <-10.6621, 12.7360, 3.1344> <-9.9012, 12.7360, 3.1344> <-9.8771, 12.7600, 3.1344>
		<-10.7056, 12.7406, 3.1780> <-10.6815, 12.7165, 3.1780> <-9.8818, 12.7165, 3.1780> <-9.8577, 12.7406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 12.6574, 3.0528> <-9.7456, 12.6862, 3.0528> <-9.7456, 13.6430, 3.0528> <-9.7745, 13.6718, 3.0528>
		<-9.7745, 12.6574, 3.1044> <-9.7456, 12.6862, 3.1044> <-9.7456, 13.6430, 3.1044> <-9.7745, 13.6718, 3.1044>
		<-9.8771, 12.7600, 3.1344> <-9.8530, 12.7841, 3.1344> <-9.8530, 13.5451, 3.1344> <-9.8771, 13.5691, 3.1344>
		<-9.8577, 12.7406, 3.1780> <-9.8336, 12.7647, 3.1780> <-9.8336, 13.5645, 3.1780> <-9.8577, 13.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 13.6718, 3.0528> <-9.8033, 13.7006, 3.0528> <-10.7601, 13.7006, 3.0528> <-10.7889, 13.6718, 3.0528>
		<-9.7745, 13.6718, 3.1044> <-9.8033, 13.7006, 3.1044> <-10.7601, 13.7006, 3.1044> <-10.7889, 13.6718, 3.1044>
		<-9.8771, 13.5691, 3.1344> <-9.9012, 13.5932, 3.1344> <-10.6621, 13.5932, 3.1344> <-10.6862, 13.5691, 3.1344>
		<-9.8577, 13.5885, 3.1780> <-9.8818, 13.6126, 3.1780> <-10.6815, 13.6126, 3.1780> <-10.7056, 13.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 12.7406, 3.1780> <-10.7438, 12.7024, 3.2640> <-10.8610, 12.5852, 3.2738> <-10.9161, 12.5302, 3.3390>
		<-10.7297, 12.7647, 3.1780> <-10.7679, 12.7265, 3.2640> <-10.8971, 12.6212, 3.2738> <-10.9521, 12.5662, 3.3390>
		<-10.7297, 13.5645, 3.1780> <-10.7679, 13.6027, 3.2640> <-10.8971, 13.7079, 3.2738> <-10.9521, 13.7629, 3.3390>
		<-10.7056, 13.5885, 3.1780> <-10.7438, 13.6267, 3.2640> <-10.8610, 13.7440, 3.2738> <-10.9161, 13.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 12.7406, 3.1780> <-10.6815, 12.7165, 3.1780> <-9.8818, 12.7165, 3.1780> <-9.8577, 12.7406, 3.1780>
		<-10.7438, 12.7024, 3.2640> <-10.7197, 12.6784, 3.2640> <-9.8436, 12.6784, 3.2640> <-9.8195, 12.7024, 3.2640>
		<-10.8610, 12.5852, 3.2738> <-10.8250, 12.5492, 3.2738> <-9.7383, 12.5492, 3.2738> <-9.7023, 12.5852, 3.2738>
		<-10.9161, 12.5302, 3.3390> <-10.8800, 12.4942, 3.3390> <-9.6833, 12.4942, 3.3390> <-9.6473, 12.5302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 12.7406, 3.1780> <-9.8336, 12.7647, 3.1780> <-9.8336, 13.5645, 3.1780> <-9.8577, 13.5885, 3.1780>
		<-9.8195, 12.7024, 3.2640> <-9.7954, 12.7265, 3.2640> <-9.7954, 13.6027, 3.2640> <-9.8195, 13.6267, 3.2640>
		<-9.7023, 12.5852, 3.2738> <-9.6663, 12.6212, 3.2738> <-9.6663, 13.7079, 3.2738> <-9.7023, 13.7440, 3.2738>
		<-9.6473, 12.5302, 3.3390> <-9.6112, 12.5662, 3.3390> <-9.6112, 13.7629, 3.3390> <-9.6473, 13.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 13.5885, 3.1780> <-9.8818, 13.6126, 3.1780> <-10.6815, 13.6126, 3.1780> <-10.7056, 13.5885, 3.1780>
		<-9.8195, 13.6267, 3.2640> <-9.8436, 13.6508, 3.2640> <-10.7197, 13.6508, 3.2640> <-10.7438, 13.6267, 3.2640>
		<-9.7023, 13.7440, 3.2738> <-9.7383, 13.7800, 3.2738> <-10.8250, 13.7800, 3.2738> <-10.8610, 13.7440, 3.2738>
		<-9.6473, 13.7990, 3.3390> <-9.6833, 13.8350, 3.3390> <-10.8800, 13.8350, 3.3390> <-10.9161, 13.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 12.5302, 3.3390> <-10.9416, 12.5046, 3.3693> <-10.9797, 12.4665, 3.4419> <-10.9623, 12.4839, 3.4821>
		<-10.9521, 12.5662, 3.3390> <-10.9777, 12.5406, 3.3693> <-11.0184, 12.5052, 3.4419> <-11.0010, 12.5226, 3.4821>
		<-10.9521, 13.7629, 3.3390> <-10.9777, 13.7885, 3.3693> <-11.0184, 13.8240, 3.4419> <-11.0010, 13.8066, 3.4821>
		<-10.9161, 13.7990, 3.3390> <-10.9416, 13.8246, 3.3693> <-10.9797, 13.8627, 3.4419> <-10.9623, 13.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 12.5302, 3.3390> <-10.8800, 12.4942, 3.3390> <-9.6833, 12.4942, 3.3390> <-9.6473, 12.5302, 3.3390>
		<-10.9416, 12.5046, 3.3693> <-10.9056, 12.4686, 3.3693> <-9.6577, 12.4686, 3.3693> <-9.6217, 12.5046, 3.3693>
		<-10.9797, 12.4665, 3.4419> <-10.9411, 12.4279, 3.4419> <-9.6223, 12.4279, 3.4419> <-9.5836, 12.4665, 3.4419>
		<-10.9623, 12.4839, 3.4821> <-10.9236, 12.4453, 3.4821> <-9.6397, 12.4453, 3.4821> <-9.6010, 12.4839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 12.5302, 3.3390> <-9.6112, 12.5662, 3.3390> <-9.6112, 13.7629, 3.3390> <-9.6473, 13.7990, 3.3390>
		<-9.6217, 12.5046, 3.3693> <-9.5857, 12.5406, 3.3693> <-9.5857, 13.7885, 3.3693> <-9.6217, 13.8246, 3.3693>
		<-9.5836, 12.4665, 3.4419> <-9.5449, 12.5052, 3.4419> <-9.5449, 13.8240, 3.4419> <-9.5836, 13.8627, 3.4419>
		<-9.6010, 12.4839, 3.4821> <-9.5624, 12.5226, 3.4821> <-9.5624, 13.8066, 3.4821> <-9.6010, 13.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 13.7990, 3.3390> <-9.6833, 13.8350, 3.3390> <-10.8800, 13.8350, 3.3390> <-10.9161, 13.7990, 3.3390>
		<-9.6217, 13.8246, 3.3693> <-9.6577, 13.8606, 3.3693> <-10.9056, 13.8606, 3.3693> <-10.9416, 13.8246, 3.3693>
		<-9.5836, 13.8627, 3.4419> <-9.6223, 13.9013, 3.4419> <-10.9411, 13.9013, 3.4419> <-10.9797, 13.8627, 3.4419>
		<-9.6010, 13.8452, 3.4821> <-9.6397, 13.8839, 3.4821> <-10.9236, 13.8839, 3.4821> <-10.9623, 13.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 12.4839, 3.4821> <-10.9163, 12.5300, 3.5884> <-10.7961, 12.6502, 3.6567> <-10.7380, 12.7083, 3.7504>
		<-11.0010, 12.5226, 3.4821> <-10.9550, 12.5686, 3.5884> <-10.8220, 12.6761, 3.6567> <-10.7639, 12.7342, 3.7504>
		<-11.0010, 13.8066, 3.4821> <-10.9550, 13.7606, 3.5884> <-10.8220, 13.6531, 3.6567> <-10.7639, 13.5950, 3.7504>
		<-10.9623, 13.8452, 3.4821> <-10.9163, 13.7992, 3.5884> <-10.7961, 13.6790, 3.6567> <-10.7380, 13.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 12.4839, 3.4821> <-10.9236, 12.4453, 3.4821> <-9.6397, 12.4453, 3.4821> <-9.6010, 12.4839, 3.4821>
		<-10.9163, 12.5300, 3.5884> <-10.8776, 12.4913, 3.5884> <-9.6857, 12.4913, 3.5884> <-9.6470, 12.5300, 3.5884>
		<-10.7961, 12.6502, 3.6567> <-10.7702, 12.6242, 3.6567> <-9.7932, 12.6242, 3.6567> <-9.7672, 12.6502, 3.6567>
		<-10.7380, 12.7083, 3.7504> <-10.7121, 12.6823, 3.7504> <-9.8513, 12.6823, 3.7504> <-9.8253, 12.7083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 12.4839, 3.4821> <-9.5624, 12.5226, 3.4821> <-9.5624, 13.8066, 3.4821> <-9.6010, 13.8452, 3.4821>
		<-9.6470, 12.5300, 3.5884> <-9.6084, 12.5686, 3.5884> <-9.6084, 13.7606, 3.5884> <-9.6470, 13.7992, 3.5884>
		<-9.7672, 12.6502, 3.6567> <-9.7413, 12.6761, 3.6567> <-9.7413, 13.6531, 3.6567> <-9.7672, 13.6790, 3.6567>
		<-9.8253, 12.7083, 3.7504> <-9.7994, 12.7342, 3.7504> <-9.7994, 13.5950, 3.7504> <-9.8253, 13.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 13.8452, 3.4821> <-9.6397, 13.8839, 3.4821> <-10.9236, 13.8839, 3.4821> <-10.9623, 13.8452, 3.4821>
		<-9.6470, 13.7992, 3.5884> <-9.6857, 13.8379, 3.5884> <-10.8776, 13.8379, 3.5884> <-10.9163, 13.7992, 3.5884>
		<-9.7672, 13.6790, 3.6567> <-9.7932, 13.7049, 3.6567> <-10.7702, 13.7049, 3.6567> <-10.7961, 13.6790, 3.6567>
		<-9.8253, 13.6209, 3.7504> <-9.8513, 13.6468, 3.7504> <-10.7121, 13.6468, 3.7504> <-10.7380, 13.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 12.7083, 3.7504> <-10.6964, 12.7498, 3.8175> <-10.6527, 12.7935, 3.9241> <-10.6352, 12.8110, 4.0098>
		<-10.7639, 12.7342, 3.7504> <-10.7223, 12.7757, 3.8175> <-10.6728, 12.8136, 3.9241> <-10.6553, 12.8311, 4.0098>
		<-10.7639, 13.5950, 3.7504> <-10.7223, 13.5534, 3.8175> <-10.6728, 13.5156, 3.9241> <-10.6553, 13.4981, 4.0098>
		<-10.7380, 13.6209, 3.7504> <-10.6964, 13.5793, 3.8175> <-10.6527, 13.5356, 3.9241> <-10.6352, 13.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 12.7083, 3.7504> <-10.7121, 12.6823, 3.7504> <-9.8513, 12.6823, 3.7504> <-9.8253, 12.7083, 3.7504>
		<-10.6964, 12.7498, 3.8175> <-10.6705, 12.7239, 3.8175> <-9.8928, 12.7239, 3.8175> <-9.8669, 12.7498, 3.8175>
		<-10.6527, 12.7935, 3.9241> <-10.6326, 12.7734, 3.9241> <-9.9307, 12.7734, 3.9241> <-9.9106, 12.7935, 3.9241>
		<-10.6352, 12.8110, 4.0098> <-10.6152, 12.7909, 4.0098> <-9.9482, 12.7909, 4.0098> <-9.9281, 12.8110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 12.7083, 3.7504> <-9.7994, 12.7342, 3.7504> <-9.7994, 13.5950, 3.7504> <-9.8253, 13.6209, 3.7504>
		<-9.8669, 12.7498, 3.8175> <-9.8410, 12.7757, 3.8175> <-9.8410, 13.5534, 3.8175> <-9.8669, 13.5793, 3.8175>
		<-9.9106, 12.7935, 3.9241> <-9.8905, 12.8136, 3.9241> <-9.8905, 13.5156, 3.9241> <-9.9106, 13.5356, 3.9241>
		<-9.9281, 12.8110, 4.0098> <-9.9080, 12.8311, 4.0098> <-9.9080, 13.4981, 4.0098> <-9.9281, 13.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 13.6209, 3.7504> <-9.8513, 13.6468, 3.7504> <-10.7121, 13.6468, 3.7504> <-10.7380, 13.6209, 3.7504>
		<-9.8669, 13.5793, 3.8175> <-9.8928, 13.6053, 3.8175> <-10.6705, 13.6053, 3.8175> <-10.6964, 13.5793, 3.8175>
		<-9.9106, 13.5356, 3.9241> <-9.9307, 13.5557, 3.9241> <-10.6326, 13.5557, 3.9241> <-10.6527, 13.5356, 3.9241>
		<-9.9281, 13.5182, 4.0098> <-9.9482, 13.5383, 4.0098> <-10.6152, 13.5383, 4.0098> <-10.6352, 13.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 12.8110, 4.0098> <-10.6168, 12.8294, 4.1002> <-10.6221, 12.8242, 4.2288> <-10.6213, 12.8250, 4.3229>
		<-10.6553, 12.8311, 4.0098> <-10.6369, 12.8495, 4.1002> <-10.6413, 12.8435, 4.2288> <-10.6405, 12.8443, 4.3229>
		<-10.6553, 13.4981, 4.0098> <-10.6369, 13.4797, 4.1002> <-10.6413, 13.4857, 4.2288> <-10.6405, 13.4849, 4.3229>
		<-10.6352, 13.5182, 4.0098> <-10.6168, 13.4997, 4.1002> <-10.6221, 13.5050, 4.2288> <-10.6213, 13.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 12.8110, 4.0098> <-10.6152, 12.7909, 4.0098> <-9.9482, 12.7909, 4.0098> <-9.9281, 12.8110, 4.0098>
		<-10.6168, 12.8294, 4.1002> <-10.5967, 12.8094, 4.1002> <-9.9666, 12.8094, 4.1002> <-9.9465, 12.8294, 4.1002>
		<-10.6221, 12.8242, 4.2288> <-10.6028, 12.8049, 4.2288> <-9.9606, 12.8049, 4.2288> <-9.9413, 12.8242, 4.2288>
		<-10.6213, 12.8250, 4.3229> <-10.6020, 12.8057, 4.3229> <-9.9614, 12.8057, 4.3229> <-9.9421, 12.8250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 12.8110, 4.0098> <-9.9080, 12.8311, 4.0098> <-9.9080, 13.4981, 4.0098> <-9.9281, 13.5182, 4.0098>
		<-9.9465, 12.8294, 4.1002> <-9.9264, 12.8495, 4.1002> <-9.9264, 13.4797, 4.1002> <-9.9465, 13.4997, 4.1002>
		<-9.9413, 12.8242, 4.2288> <-9.9220, 12.8435, 4.2288> <-9.9220, 13.4857, 4.2288> <-9.9413, 13.5050, 4.2288>
		<-9.9421, 12.8250, 4.3229> <-9.9228, 12.8443, 4.3229> <-9.9228, 13.4849, 4.3229> <-9.9421, 13.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 13.5182, 4.0098> <-9.9482, 13.5383, 4.0098> <-10.6152, 13.5383, 4.0098> <-10.6352, 13.5182, 4.0098>
		<-9.9465, 13.4997, 4.1002> <-9.9666, 13.5198, 4.1002> <-10.5967, 13.5198, 4.1002> <-10.6168, 13.4997, 4.1002>
		<-9.9413, 13.5050, 4.2288> <-9.9606, 13.5243, 4.2288> <-10.6028, 13.5243, 4.2288> <-10.6221, 13.5050, 4.2288>
		<-9.9421, 13.5042, 4.3229> <-9.9614, 13.5235, 4.3229> <-10.6020, 13.5235, 4.3229> <-10.6213, 13.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 12.8250, 4.3229> <-10.6179, 12.8284, 4.7283> <-10.6197, 12.8265, 5.2689> <-10.6213, 12.8250, 5.6744>
		<-10.6405, 12.8443, 4.3229> <-10.6371, 12.8477, 4.7283> <-10.6390, 12.8458, 5.2689> <-10.6405, 12.8443, 5.6744>
		<-10.6405, 13.4849, 4.3229> <-10.6371, 13.4815, 4.7283> <-10.6390, 13.4834, 5.2689> <-10.6405, 13.4849, 5.6744>
		<-10.6213, 13.5042, 4.3229> <-10.6179, 13.5008, 4.7283> <-10.6197, 13.5027, 5.2689> <-10.6213, 13.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 12.8250, 4.3229> <-10.6020, 12.8057, 4.3229> <-9.9614, 12.8057, 4.3229> <-9.9421, 12.8250, 4.3229>
		<-10.6179, 12.8284, 4.7283> <-10.5986, 12.8091, 4.7283> <-9.9648, 12.8091, 4.7283> <-9.9455, 12.8284, 4.7283>
		<-10.6197, 12.8265, 5.2689> <-10.6004, 12.8072, 5.2689> <-9.9629, 12.8072, 5.2689> <-9.9436, 12.8265, 5.2689>
		<-10.6213, 12.8250, 5.6744> <-10.6020, 12.8057, 5.6744> <-9.9614, 12.8057, 5.6744> <-9.9421, 12.8250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 12.8250, 4.3229> <-9.9228, 12.8443, 4.3229> <-9.9228, 13.4849, 4.3229> <-9.9421, 13.5042, 4.3229>
		<-9.9455, 12.8284, 4.7283> <-9.9262, 12.8477, 4.7283> <-9.9262, 13.4815, 4.7283> <-9.9455, 13.5008, 4.7283>
		<-9.9436, 12.8265, 5.2689> <-9.9243, 12.8458, 5.2689> <-9.9243, 13.4834, 5.2689> <-9.9436, 13.5027, 5.2689>
		<-9.9421, 12.8250, 5.6744> <-9.9228, 12.8443, 5.6744> <-9.9228, 13.4849, 5.6744> <-9.9421, 13.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 13.5042, 4.3229> <-9.9614, 13.5235, 4.3229> <-10.6020, 13.5235, 4.3229> <-10.6213, 13.5042, 4.3229>
		<-9.9455, 13.5008, 4.7283> <-9.9648, 13.5201, 4.7283> <-10.5986, 13.5201, 4.7283> <-10.6179, 13.5008, 4.7283>
		<-9.9436, 13.5027, 5.2689> <-9.9629, 13.5219, 5.2689> <-10.6004, 13.5219, 5.2689> <-10.6197, 13.5027, 5.2689>
		<-9.9421, 13.5042, 5.6744> <-9.9614, 13.5235, 5.6744> <-10.6020, 13.5235, 5.6744> <-10.6213, 13.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 12.8250, 5.6744> <-10.6225, 12.8237, 6.0073> <-10.6172, 12.8290, 6.4517> <-10.6305, 12.8157, 6.7841>
		<-10.6405, 12.8443, 5.6744> <-10.6418, 12.8430, 6.0073> <-10.6371, 12.8488, 6.4517> <-10.6503, 12.8355, 6.7841>
		<-10.6405, 13.4849, 5.6744> <-10.6418, 13.4861, 6.0073> <-10.6371, 13.4804, 6.4517> <-10.6503, 13.4936, 6.7841>
		<-10.6213, 13.5042, 5.6744> <-10.6225, 13.5054, 6.0073> <-10.6172, 13.5002, 6.4517> <-10.6305, 13.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 12.8250, 5.6744> <-10.6020, 12.8057, 5.6744> <-9.9614, 12.8057, 5.6744> <-9.9421, 12.8250, 5.6744>
		<-10.6225, 12.8237, 6.0073> <-10.6032, 12.8044, 6.0073> <-9.9601, 12.8044, 6.0073> <-9.9408, 12.8237, 6.0073>
		<-10.6172, 12.8290, 6.4517> <-10.5974, 12.8092, 6.4517> <-9.9659, 12.8092, 6.4517> <-9.9461, 12.8290, 6.4517>
		<-10.6305, 12.8157, 6.7841> <-10.6107, 12.7959, 6.7841> <-9.9526, 12.7959, 6.7841> <-9.9328, 12.8157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 12.8250, 5.6744> <-9.9228, 12.8443, 5.6744> <-9.9228, 13.4849, 5.6744> <-9.9421, 13.5042, 5.6744>
		<-9.9408, 12.8237, 6.0073> <-9.9215, 12.8430, 6.0073> <-9.9215, 13.4861, 6.0073> <-9.9408, 13.5054, 6.0073>
		<-9.9461, 12.8290, 6.4517> <-9.9263, 12.8488, 6.4517> <-9.9263, 13.4804, 6.4517> <-9.9461, 13.5002, 6.4517>
		<-9.9328, 12.8157, 6.7841> <-9.9130, 12.8355, 6.7841> <-9.9130, 13.4936, 6.7841> <-9.9328, 13.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 13.5042, 5.6744> <-9.9614, 13.5235, 5.6744> <-10.6020, 13.5235, 5.6744> <-10.6213, 13.5042, 5.6744>
		<-9.9408, 13.5054, 6.0073> <-9.9601, 13.5247, 6.0073> <-10.6032, 13.5247, 6.0073> <-10.6225, 13.5054, 6.0073>
		<-9.9461, 13.5002, 6.4517> <-9.9659, 13.5200, 6.4517> <-10.5974, 13.5200, 6.4517> <-10.6172, 13.5002, 6.4517>
		<-9.9328, 13.5134, 6.7841> <-9.9526, 13.5333, 6.7841> <-10.6107, 13.5333, 6.7841> <-10.6305, 13.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 12.8157, 6.7841> <-10.6325, 12.8137, 6.8341> <-10.6449, 12.8013, 6.9079> <-10.6718, 12.7745, 6.9405>
		<-10.6503, 12.8355, 6.7841> <-10.6523, 12.8336, 6.8341> <-10.6671, 12.8235, 6.9079> <-10.6940, 12.7966, 6.9405>
		<-10.6503, 13.4936, 6.7841> <-10.6523, 13.4956, 6.8341> <-10.6671, 13.5057, 6.9079> <-10.6940, 13.5326, 6.9405>
		<-10.6305, 13.5134, 6.7841> <-10.6325, 13.5154, 6.8341> <-10.6449, 13.5278, 6.9079> <-10.6718, 13.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 12.8157, 6.7841> <-10.6107, 12.7959, 6.7841> <-9.9526, 12.7959, 6.7841> <-9.9328, 12.8157, 6.7841>
		<-10.6325, 12.8137, 6.8341> <-10.6127, 12.7939, 6.8341> <-9.9506, 12.7939, 6.8341> <-9.9308, 12.8137, 6.8341>
		<-10.6449, 12.8013, 6.9079> <-10.6228, 12.7792, 6.9079> <-9.9406, 12.7792, 6.9079> <-9.9184, 12.8013, 6.9079>
		<-10.6718, 12.7745, 6.9405> <-10.6496, 12.7523, 6.9405> <-9.9137, 12.7523, 6.9405> <-9.8915, 12.7745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 12.8157, 6.7841> <-9.9130, 12.8355, 6.7841> <-9.9130, 13.4936, 6.7841> <-9.9328, 13.5134, 6.7841>
		<-9.9308, 12.8137, 6.8341> <-9.9110, 12.8336, 6.8341> <-9.9110, 13.4956, 6.8341> <-9.9308, 13.5154, 6.8341>
		<-9.9184, 12.8013, 6.9079> <-9.8962, 12.8235, 6.9079> <-9.8962, 13.5057, 6.9079> <-9.9184, 13.5278, 6.9079>
		<-9.8915, 12.7745, 6.9405> <-9.8694, 12.7966, 6.9405> <-9.8694, 13.5326, 6.9405> <-9.8915, 13.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 13.5134, 6.7841> <-9.9526, 13.5333, 6.7841> <-10.6107, 13.5333, 6.7841> <-10.6305, 13.5134, 6.7841>
		<-9.9308, 13.5154, 6.8341> <-9.9506, 13.5352, 6.8341> <-10.6127, 13.5352, 6.8341> <-10.6325, 13.5154, 6.8341>
		<-9.9184, 13.5278, 6.9079> <-9.9406, 13.5500, 6.9079> <-10.6228, 13.5500, 6.9079> <-10.6449, 13.5278, 6.9079>
		<-9.8915, 13.5547, 6.9405> <-9.9137, 13.5769, 6.9405> <-10.6496, 13.5769, 6.9405> <-10.6718, 13.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 12.7745, 6.9405> <-10.7339, 12.7123, 7.0160> <-10.8620, 12.5842, 7.0331> <-10.9114, 12.5348, 7.1255>
		<-10.6940, 12.7966, 6.9405> <-10.7561, 12.7345, 7.0160> <-10.8978, 12.6200, 7.0331> <-10.9472, 12.5706, 7.1255>
		<-10.6940, 13.5326, 6.9405> <-10.7561, 13.5947, 7.0160> <-10.8978, 13.7092, 7.0331> <-10.9472, 13.7586, 7.1255>
		<-10.6718, 13.5547, 6.9405> <-10.7339, 13.6168, 7.0160> <-10.8620, 13.7449, 7.0331> <-10.9114, 13.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 12.7745, 6.9405> <-10.6496, 12.7523, 6.9405> <-9.9137, 12.7523, 6.9405> <-9.8915, 12.7745, 6.9405>
		<-10.7339, 12.7123, 7.0160> <-10.7117, 12.6902, 7.0160> <-9.8516, 12.6902, 7.0160> <-9.8294, 12.7123, 7.0160>
		<-10.8620, 12.5842, 7.0331> <-10.8262, 12.5485, 7.0331> <-9.7371, 12.5485, 7.0331> <-9.7013, 12.5842, 7.0331>
		<-10.9114, 12.5348, 7.1255> <-10.8757, 12.4990, 7.1255> <-9.6877, 12.4990, 7.1255> <-9.6519, 12.5348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 12.7745, 6.9405> <-9.8694, 12.7966, 6.9405> <-9.8694, 13.5326, 6.9405> <-9.8915, 13.5547, 6.9405>
		<-9.8294, 12.7123, 7.0160> <-9.8073, 12.7345, 7.0160> <-9.8073, 13.5947, 7.0160> <-9.8294, 13.6168, 7.0160>
		<-9.7013, 12.5842, 7.0331> <-9.6655, 12.6200, 7.0331> <-9.6655, 13.7092, 7.0331> <-9.7013, 13.7449, 7.0331>
		<-9.6519, 12.5348, 7.1255> <-9.6161, 12.5706, 7.1255> <-9.6161, 13.7586, 7.1255> <-9.6519, 13.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 13.5547, 6.9405> <-9.9137, 13.5769, 6.9405> <-10.6496, 13.5769, 6.9405> <-10.6718, 13.5547, 6.9405>
		<-9.8294, 13.6168, 7.0160> <-9.8516, 13.6390, 7.0160> <-10.7117, 13.6390, 7.0160> <-10.7339, 13.6168, 7.0160>
		<-9.7013, 13.7449, 7.0331> <-9.7371, 13.7807, 7.0331> <-10.8262, 13.7807, 7.0331> <-10.8620, 13.7449, 7.0331>
		<-9.6519, 13.7944, 7.1255> <-9.6877, 13.8301, 7.1255> <-10.8757, 13.8301, 7.1255> <-10.9114, 13.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 12.5348, 7.1255> <-10.9319, 12.5143, 7.1638> <-10.8316, 12.6146, 7.1912> <-10.8316, 12.6146, 7.2393>
		<-10.9472, 12.5706, 7.1255> <-10.9677, 12.5501, 7.1638> <-10.8629, 12.6459, 7.1912> <-10.8629, 12.6459, 7.2393>
		<-10.9472, 13.7586, 7.1255> <-10.9677, 13.7791, 7.1638> <-10.8629, 13.6833, 7.1912> <-10.8629, 13.6833, 7.2393>
		<-10.9114, 13.7944, 7.1255> <-10.9319, 13.8149, 7.1638> <-10.8316, 13.7146, 7.1912> <-10.8316, 13.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 12.5348, 7.1255> <-10.8757, 12.4990, 7.1255> <-9.6877, 12.4990, 7.1255> <-9.6519, 12.5348, 7.1255>
		<-10.9319, 12.5143, 7.1638> <-10.8962, 12.4785, 7.1638> <-9.6671, 12.4785, 7.1638> <-9.6314, 12.5143, 7.1638>
		<-10.8316, 12.6146, 7.1912> <-10.8004, 12.5834, 7.1912> <-9.7629, 12.5834, 7.1912> <-9.7317, 12.6146, 7.1912>
		<-10.8316, 12.6146, 7.2393> <-10.8004, 12.5834, 7.2393> <-9.7629, 12.5834, 7.2393> <-9.7317, 12.6146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 12.5348, 7.1255> <-9.6161, 12.5706, 7.1255> <-9.6161, 13.7586, 7.1255> <-9.6519, 13.7944, 7.1255>
		<-9.6314, 12.5143, 7.1638> <-9.5956, 12.5501, 7.1638> <-9.5956, 13.7791, 7.1638> <-9.6314, 13.8149, 7.1638>
		<-9.7317, 12.6146, 7.1912> <-9.7005, 12.6459, 7.1912> <-9.7005, 13.6833, 7.1912> <-9.7317, 13.7146, 7.1912>
		<-9.7317, 12.6146, 7.2393> <-9.7005, 12.6459, 7.2393> <-9.7005, 13.6833, 7.2393> <-9.7317, 13.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 13.7944, 7.1255> <-9.6877, 13.8301, 7.1255> <-10.8757, 13.8301, 7.1255> <-10.9114, 13.7944, 7.1255>
		<-9.6314, 13.8149, 7.1638> <-9.6671, 13.8506, 7.1638> <-10.8962, 13.8506, 7.1638> <-10.9319, 13.8149, 7.1638>
		<-9.7317, 13.7146, 7.1912> <-9.7629, 13.7458, 7.1912> <-10.8004, 13.7458, 7.1912> <-10.8316, 13.7146, 7.1912>
		<-9.7317, 13.7146, 7.2393> <-9.7629, 13.7458, 7.2393> <-10.8004, 13.7458, 7.2393> <-10.8316, 13.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 12.6146, 7.2393> <-10.8316, 12.6146, 7.2905> <-10.9054, 12.5408, 7.3169> <-10.9114, 12.5348, 7.3673>
		<-10.8629, 12.6459, 7.2393> <-10.8629, 12.6459, 7.2905> <-10.9412, 12.5766, 7.3169> <-10.9472, 12.5706, 7.3673>
		<-10.8629, 13.6833, 7.2393> <-10.8629, 13.6833, 7.2905> <-10.9412, 13.7526, 7.3169> <-10.9472, 13.7586, 7.3673>
		<-10.8316, 13.7146, 7.2393> <-10.8316, 13.7146, 7.2905> <-10.9054, 13.7883, 7.3169> <-10.9114, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 12.6146, 7.2393> <-10.8004, 12.5834, 7.2393> <-9.7629, 12.5834, 7.2393> <-9.7317, 12.6146, 7.2393>
		<-10.8316, 12.6146, 7.2905> <-10.8004, 12.5834, 7.2905> <-9.7629, 12.5834, 7.2905> <-9.7317, 12.6146, 7.2905>
		<-10.9054, 12.5408, 7.3169> <-10.8696, 12.5051, 7.3169> <-9.6937, 12.5051, 7.3169> <-9.6579, 12.5408, 7.3169>
		<-10.9114, 12.5348, 7.3673> <-10.8757, 12.4990, 7.3673> <-9.6877, 12.4990, 7.3673> <-9.6519, 12.5348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 12.6146, 7.2393> <-9.7005, 12.6459, 7.2393> <-9.7005, 13.6833, 7.2393> <-9.7317, 13.7146, 7.2393>
		<-9.7317, 12.6146, 7.2905> <-9.7005, 12.6459, 7.2905> <-9.7005, 13.6833, 7.2905> <-9.7317, 13.7146, 7.2905>
		<-9.6579, 12.5408, 7.3169> <-9.6222, 12.5766, 7.3169> <-9.6222, 13.7526, 7.3169> <-9.6579, 13.7883, 7.3169>
		<-9.6519, 12.5348, 7.3673> <-9.6161, 12.5706, 7.3673> <-9.6161, 13.7586, 7.3673> <-9.6519, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 13.7146, 7.2393> <-9.7629, 13.7458, 7.2393> <-10.8004, 13.7458, 7.2393> <-10.8316, 13.7146, 7.2393>
		<-9.7317, 13.7146, 7.2905> <-9.7629, 13.7458, 7.2905> <-10.8004, 13.7458, 7.2905> <-10.8316, 13.7146, 7.2905>
		<-9.6579, 13.7883, 7.3169> <-9.6937, 13.8241, 7.3169> <-10.8696, 13.8241, 7.3169> <-10.9054, 13.7883, 7.3169>
		<-9.6519, 13.7944, 7.3673> <-9.6877, 13.8301, 7.3673> <-10.8757, 13.8301, 7.3673> <-10.9114, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 12.5348, 7.9080> <-10.9472, 12.5706, 7.9080> <-10.9472, 13.7586, 7.9080> <-10.9114, 13.7944, 7.9080>
		<-10.9114, 12.5348, 7.7458> <-10.9472, 12.5706, 7.7458> <-10.9472, 13.7586, 7.7458> <-10.9114, 13.7944, 7.7458>
		<-10.9305, 12.5157, 7.5273> <-10.9663, 12.5515, 7.5273> <-10.9663, 13.7777, 7.5273> <-10.9305, 13.8134, 7.5273>
		<-10.9114, 12.5348, 7.3673> <-10.9472, 12.5706, 7.3673> <-10.9472, 13.7586, 7.3673> <-10.9114, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 12.5348, 7.9080> <-10.9114, 12.5348, 7.7458> <-10.9305, 12.5157, 7.5273> <-10.9114, 12.5348, 7.3673>
		<-10.8757, 12.4990, 7.9080> <-10.8757, 12.4990, 7.7458> <-10.8947, 12.4800, 7.5273> <-10.8757, 12.4990, 7.3673>
		<-9.6877, 12.4990, 7.9080> <-9.6877, 12.4990, 7.7458> <-9.6686, 12.4800, 7.5273> <-9.6877, 12.4990, 7.3673>
		<-9.6519, 12.5348, 7.9080> <-9.6519, 12.5348, 7.7458> <-9.6328, 12.5157, 7.5273> <-9.6519, 12.5348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 12.5348, 7.9080> <-9.6519, 12.5348, 7.7458> <-9.6328, 12.5157, 7.5273> <-9.6519, 12.5348, 7.3673>
		<-9.6161, 12.5706, 7.9080> <-9.6161, 12.5706, 7.7458> <-9.5970, 12.5515, 7.5273> <-9.6161, 12.5706, 7.3673>
		<-9.6161, 13.7586, 7.9080> <-9.6161, 13.7586, 7.7458> <-9.5970, 13.7777, 7.5273> <-9.6161, 13.7586, 7.3673>
		<-9.6519, 13.7944, 7.9080> <-9.6519, 13.7944, 7.7458> <-9.6328, 13.8134, 7.5273> <-9.6519, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 13.7944, 7.9080> <-9.6519, 13.7944, 7.7458> <-9.6328, 13.8134, 7.5273> <-9.6519, 13.7944, 7.3673>
		<-9.6877, 13.8301, 7.9080> <-9.6877, 13.8301, 7.7458> <-9.6686, 13.8492, 7.5273> <-9.6877, 13.8301, 7.3673>
		<-10.8757, 13.8301, 7.9080> <-10.8757, 13.8301, 7.7458> <-10.8947, 13.8492, 7.5273> <-10.8757, 13.8301, 7.3673>
		<-10.9114, 13.7944, 7.9080> <-10.9114, 13.7944, 7.7458> <-10.9305, 13.8134, 7.5273> <-10.9114, 13.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 12.2874, 0.7771> <-11.2087, 12.3372, 0.7771> <-11.2087, 13.9920, 0.7771> <-11.1589, 14.0418, 0.7771>
		<-11.1796, 12.2666, 0.6520> <-11.2294, 12.3164, 0.6520> <-11.2294, 14.0127, 0.6520> <-11.1796, 14.0625, 0.6520>
		<-11.1589, 12.2874, 0.4772> <-11.2087, 12.3372, 0.4772> <-11.2087, 13.9920, 0.4772> <-11.1589, 14.0418, 0.4772>
		<-11.1589, 12.2874, 0.3486> <-11.2087, 12.3372, 0.3486> <-11.2087, 13.9920, 0.3486> <-11.1589, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 12.2874, 0.7771> <-11.1796, 12.2666, 0.6520> <-11.1589, 12.2874, 0.4772> <-11.1589, 12.2874, 0.3486>
		<-11.1090, 12.2376, 0.7771> <-11.1298, 12.2168, 0.6520> <-11.1090, 12.2376, 0.4772> <-11.1090, 12.2376, 0.3486>
		<-9.4543, 12.2376, 0.7771> <-9.4335, 12.2168, 0.6520> <-9.4543, 12.2376, 0.4772> <-9.4543, 12.2376, 0.3486>
		<-9.4045, 12.2874, 0.7771> <-9.3837, 12.2666, 0.6520> <-9.4045, 12.2874, 0.4772> <-9.4045, 12.2874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 12.2874, 0.7771> <-9.3837, 12.2666, 0.6520> <-9.4045, 12.2874, 0.4772> <-9.4045, 12.2874, 0.3486>
		<-9.3546, 12.3372, 0.7771> <-9.3339, 12.3164, 0.6520> <-9.3546, 12.3372, 0.4772> <-9.3546, 12.3372, 0.3486>
		<-9.3546, 13.9920, 0.7771> <-9.3339, 14.0127, 0.6520> <-9.3546, 13.9920, 0.4772> <-9.3546, 13.9920, 0.3486>
		<-9.4045, 14.0418, 0.7771> <-9.3837, 14.0625, 0.6520> <-9.4045, 14.0418, 0.4772> <-9.4045, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 14.0418, 0.7771> <-9.3837, 14.0625, 0.6520> <-9.4045, 14.0418, 0.4772> <-9.4045, 14.0418, 0.3486>
		<-9.4543, 14.0916, 0.7771> <-9.4335, 14.1124, 0.6520> <-9.4543, 14.0916, 0.4772> <-9.4543, 14.0916, 0.3486>
		<-11.1090, 14.0916, 0.7771> <-11.1298, 14.1124, 0.6520> <-11.1090, 14.0916, 0.4772> <-11.1090, 14.0916, 0.3486>
		<-11.1589, 14.0418, 0.7771> <-11.1796, 14.0625, 0.6520> <-11.1589, 14.0418, 0.4772> <-11.1589, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 12.2874, -0.0618> <-11.1589, 12.2874, 0.0613> <-11.1589, 12.2874, 0.2255> <-11.1589, 12.2874, 0.3486>
		<-11.2087, 12.3372, -0.0618> <-11.2087, 12.3372, 0.0613> <-11.2087, 12.3372, 0.2255> <-11.2087, 12.3372, 0.3486>
		<-11.2087, 13.9920, -0.0618> <-11.2087, 13.9920, 0.0613> <-11.2087, 13.9920, 0.2255> <-11.2087, 13.9920, 0.3486>
		<-11.1589, 14.0418, -0.0618> <-11.1589, 14.0418, 0.0613> <-11.1589, 14.0418, 0.2255> <-11.1589, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 12.2874, -0.0618> <-11.1090, 12.2376, -0.0618> <-9.4543, 12.2376, -0.0618> <-9.4045, 12.2874, -0.0618>
		<-11.1589, 12.2874, 0.0613> <-11.1090, 12.2376, 0.0613> <-9.4543, 12.2376, 0.0613> <-9.4045, 12.2874, 0.0613>
		<-11.1589, 12.2874, 0.2255> <-11.1090, 12.2376, 0.2255> <-9.4543, 12.2376, 0.2255> <-9.4045, 12.2874, 0.2255>
		<-11.1589, 12.2874, 0.3486> <-11.1090, 12.2376, 0.3486> <-9.4543, 12.2376, 0.3486> <-9.4045, 12.2874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 12.2874, -0.0618> <-9.3546, 12.3372, -0.0618> <-9.3546, 13.9920, -0.0618> <-9.4045, 14.0418, -0.0618>
		<-9.4045, 12.2874, 0.0613> <-9.3546, 12.3372, 0.0613> <-9.3546, 13.9920, 0.0613> <-9.4045, 14.0418, 0.0613>
		<-9.4045, 12.2874, 0.2255> <-9.3546, 12.3372, 0.2255> <-9.3546, 13.9920, 0.2255> <-9.4045, 14.0418, 0.2255>
		<-9.4045, 12.2874, 0.3486> <-9.3546, 12.3372, 0.3486> <-9.3546, 13.9920, 0.3486> <-9.4045, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 14.0418, -0.0618> <-9.4543, 14.0916, -0.0618> <-11.1090, 14.0916, -0.0618> <-11.1589, 14.0418, -0.0618>
		<-9.4045, 14.0418, 0.0613> <-9.4543, 14.0916, 0.0613> <-11.1090, 14.0916, 0.0613> <-11.1589, 14.0418, 0.0613>
		<-9.4045, 14.0418, 0.2255> <-9.4543, 14.0916, 0.2255> <-11.1090, 14.0916, 0.2255> <-11.1589, 14.0418, 0.2255>
		<-9.4045, 14.0418, 0.3486> <-9.4543, 14.0916, 0.3486> <-11.1090, 14.0916, 0.3486> <-11.1589, 14.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 0.9062> <-11.1109, 10.2245, 0.9062> <-11.1109, 11.7047, 0.9062> <-11.0664, 11.7493, 0.9062>
		<-11.0712, 10.1751, 0.8515> <-11.1157, 10.2196, 0.8515> <-11.1157, 11.7095, 0.8515> <-11.0712, 11.7541, 0.8515>
		<-11.1500, 10.0963, 0.8308> <-11.1998, 10.1461, 0.8308> <-11.1998, 11.7831, 0.8308> <-11.1500, 11.8329, 0.8308>
		<-11.1589, 10.0874, 0.7771> <-11.2087, 10.1372, 0.7771> <-11.2087, 11.7920, 0.7771> <-11.1589, 11.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 0.9062> <-11.0620, 10.1842, 0.9557> <-11.1560, 10.0903, 0.9996> <-11.1357, 10.1105, 1.0404>
		<-11.1109, 10.2245, 0.9062> <-11.1066, 10.2288, 0.9557> <-11.2045, 10.1388, 0.9996> <-11.1842, 10.1590, 1.0404>
		<-11.1109, 11.7047, 0.9062> <-11.1066, 11.7004, 0.9557> <-11.2045, 11.7904, 0.9996> <-11.1842, 11.7702, 1.0404>
		<-11.0664, 11.7493, 0.9062> <-11.0620, 11.7449, 0.9557> <-11.1560, 11.8389, 0.9996> <-11.1357, 11.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 0.9062> <-11.0712, 10.1751, 0.8515> <-11.1500, 10.0963, 0.8308> <-11.1589, 10.0874, 0.7771>
		<-11.0218, 10.1353, 0.9062> <-11.0266, 10.1305, 0.8515> <-11.1001, 10.0465, 0.8308> <-11.1090, 10.0376, 0.7771>
		<-9.5415, 10.1353, 0.9062> <-9.5367, 10.1305, 0.8515> <-9.4632, 10.0465, 0.8308> <-9.4543, 10.0376, 0.7771>
		<-9.4970, 10.1799, 0.9062> <-9.4922, 10.1751, 0.8515> <-9.4134, 10.0963, 0.8308> <-9.4045, 10.0874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 0.9062> <-11.0218, 10.1353, 0.9062> <-9.5415, 10.1353, 0.9062> <-9.4970, 10.1799, 0.9062>
		<-11.0620, 10.1842, 0.9557> <-11.0175, 10.1397, 0.9557> <-9.5459, 10.1397, 0.9557> <-9.5013, 10.1842, 0.9557>
		<-11.1560, 10.0903, 0.9996> <-11.1075, 10.0418, 0.9996> <-9.4559, 10.0418, 0.9996> <-9.4073, 10.0903, 0.9996>
		<-11.1357, 10.1105, 1.0404> <-11.0872, 10.0620, 1.0404> <-9.4761, 10.0620, 1.0404> <-9.4276, 10.1105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 10.1799, 0.9062> <-9.4922, 10.1751, 0.8515> <-9.4134, 10.0963, 0.8308> <-9.4045, 10.0874, 0.7771>
		<-9.4524, 10.2245, 0.9062> <-9.4476, 10.2196, 0.8515> <-9.3635, 10.1461, 0.8308> <-9.3546, 10.1372, 0.7771>
		<-9.4524, 11.7047, 0.9062> <-9.4476, 11.7095, 0.8515> <-9.3635, 11.7831, 0.8308> <-9.3546, 11.7920, 0.7771>
		<-9.4970, 11.7493, 0.9062> <-9.4922, 11.7541, 0.8515> <-9.4134, 11.8329, 0.8308> <-9.4045, 11.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 10.1799, 0.9062> <-9.4524, 10.2245, 0.9062> <-9.4524, 11.7047, 0.9062> <-9.4970, 11.7493, 0.9062>
		<-9.5013, 10.1842, 0.9557> <-9.4567, 10.2288, 0.9557> <-9.4567, 11.7004, 0.9557> <-9.5013, 11.7449, 0.9557>
		<-9.4073, 10.0903, 0.9996> <-9.3588, 10.1388, 0.9996> <-9.3588, 11.7904, 0.9996> <-9.4073, 11.8389, 0.9996>
		<-9.4276, 10.1105, 1.0404> <-9.3791, 10.1590, 1.0404> <-9.3791, 11.7702, 1.0404> <-9.4276, 11.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 11.7493, 0.9062> <-9.4922, 11.7541, 0.8515> <-9.4134, 11.8329, 0.8308> <-9.4045, 11.8418, 0.7771>
		<-9.5415, 11.7939, 0.9062> <-9.5367, 11.7987, 0.8515> <-9.4632, 11.8827, 0.8308> <-9.4543, 11.8916, 0.7771>
		<-11.0218, 11.7939, 0.9062> <-11.0266, 11.7987, 0.8515> <-11.1001, 11.8827, 0.8308> <-11.1090, 11.8916, 0.7771>
		<-11.0664, 11.7493, 0.9062> <-11.0712, 11.7541, 0.8515> <-11.1500, 11.8329, 0.8308> <-11.1589, 11.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 11.7493, 0.9062> <-9.5415, 11.7939, 0.9062> <-11.0218, 11.7939, 0.9062> <-11.0664, 11.7493, 0.9062>
		<-9.5013, 11.7449, 0.9557> <-9.5459, 11.7895, 0.9557> <-11.0175, 11.7895, 0.9557> <-11.0620, 11.7449, 0.9557>
		<-9.4073, 11.8389, 0.9996> <-9.4559, 11.8874, 0.9996> <-11.1075, 11.8874, 0.9996> <-11.1560, 11.8389, 0.9996>
		<-9.4276, 11.8187, 1.0404> <-9.4761, 11.8672, 1.0404> <-11.0872, 11.8672, 1.0404> <-11.1357, 11.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 10.1105, 1.0404> <-11.0677, 10.1786, 1.1777> <-10.8982, 10.3481, 1.2552> <-10.8269, 10.4193, 1.3892>
		<-11.1842, 10.1590, 1.0404> <-11.1162, 10.2271, 1.1777> <-10.9291, 10.3790, 1.2552> <-10.8579, 10.4503, 1.3892>
		<-11.1842, 11.7702, 1.0404> <-11.1162, 11.7021, 1.1777> <-10.9291, 11.5501, 1.2552> <-10.8579, 11.4789, 1.3892>
		<-11.1357, 11.8187, 1.0404> <-11.0677, 11.7506, 1.1777> <-10.8982, 11.5811, 1.2552> <-10.8269, 11.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 10.1105, 1.0404> <-11.0872, 10.0620, 1.0404> <-9.4761, 10.0620, 1.0404> <-9.4276, 10.1105, 1.0404>
		<-11.0677, 10.1786, 1.1777> <-11.0192, 10.1301, 1.1777> <-9.5442, 10.1301, 1.1777> <-9.4957, 10.1786, 1.1777>
		<-10.8982, 10.3481, 1.2552> <-10.8672, 10.3171, 1.2552> <-9.6961, 10.3171, 1.2552> <-9.6652, 10.3481, 1.2552>
		<-10.8269, 10.4193, 1.3892> <-10.7959, 10.3884, 1.3892> <-9.7674, 10.3884, 1.3892> <-9.7364, 10.4193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 10.1105, 1.0404> <-9.3791, 10.1590, 1.0404> <-9.3791, 11.7702, 1.0404> <-9.4276, 11.8187, 1.0404>
		<-9.4957, 10.1786, 1.1777> <-9.4471, 10.2271, 1.1777> <-9.4471, 11.7021, 1.1777> <-9.4957, 11.7506, 1.1777>
		<-9.6652, 10.3481, 1.2552> <-9.6342, 10.3790, 1.2552> <-9.6342, 11.5501, 1.2552> <-9.6652, 11.5811, 1.2552>
		<-9.7364, 10.4193, 1.3892> <-9.7054, 10.4503, 1.3892> <-9.7054, 11.4789, 1.3892> <-9.7364, 11.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 11.8187, 1.0404> <-9.4761, 11.8672, 1.0404> <-11.0872, 11.8672, 1.0404> <-11.1357, 11.8187, 1.0404>
		<-9.4957, 11.7506, 1.1777> <-9.5442, 11.7991, 1.1777> <-11.0192, 11.7991, 1.1777> <-11.0677, 11.7506, 1.1777>
		<-9.6652, 11.5811, 1.2552> <-9.6961, 11.6121, 1.2552> <-10.8672, 11.6121, 1.2552> <-10.8982, 11.5811, 1.2552>
		<-9.7364, 11.5098, 1.3892> <-9.7674, 11.5408, 1.3892> <-10.7959, 11.5408, 1.3892> <-10.8269, 11.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 10.4193, 1.3892> <-10.8079, 10.4383, 1.4249> <-10.8837, 10.3626, 1.4698> <-10.8837, 10.3626, 1.5144>
		<-10.8579, 10.4503, 1.3892> <-10.8389, 10.4693, 1.4249> <-10.9179, 10.3968, 1.4698> <-10.9179, 10.3968, 1.5144>
		<-10.8579, 11.4789, 1.3892> <-10.8389, 11.4599, 1.4249> <-10.9179, 11.5324, 1.4698> <-10.9179, 11.5324, 1.5144>
		<-10.8269, 11.5098, 1.3892> <-10.8079, 11.4909, 1.4249> <-10.8837, 11.5666, 1.4698> <-10.8837, 11.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 10.4193, 1.3892> <-10.7959, 10.3884, 1.3892> <-9.7674, 10.3884, 1.3892> <-9.7364, 10.4193, 1.3892>
		<-10.8079, 10.4383, 1.4249> <-10.7770, 10.4073, 1.4249> <-9.7863, 10.4073, 1.4249> <-9.7554, 10.4383, 1.4249>
		<-10.8837, 10.3626, 1.4698> <-10.8495, 10.3284, 1.4698> <-9.7138, 10.3284, 1.4698> <-9.6796, 10.3626, 1.4698>
		<-10.8837, 10.3626, 1.5144> <-10.8495, 10.3284, 1.5144> <-9.7138, 10.3284, 1.5144> <-9.6796, 10.3626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 10.4193, 1.3892> <-9.7054, 10.4503, 1.3892> <-9.7054, 11.4789, 1.3892> <-9.7364, 11.5098, 1.3892>
		<-9.7554, 10.4383, 1.4249> <-9.7244, 10.4693, 1.4249> <-9.7244, 11.4599, 1.4249> <-9.7554, 11.4909, 1.4249>
		<-9.6796, 10.3626, 1.4698> <-9.6455, 10.3968, 1.4698> <-9.6455, 11.5324, 1.4698> <-9.6796, 11.5666, 1.4698>
		<-9.6796, 10.3626, 1.5144> <-9.6455, 10.3968, 1.5144> <-9.6455, 11.5324, 1.5144> <-9.6796, 11.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 11.5098, 1.3892> <-9.7674, 11.5408, 1.3892> <-10.7959, 11.5408, 1.3892> <-10.8269, 11.5098, 1.3892>
		<-9.7554, 11.4909, 1.4249> <-9.7863, 11.5218, 1.4249> <-10.7770, 11.5218, 1.4249> <-10.8079, 11.4909, 1.4249>
		<-9.6796, 11.5666, 1.4698> <-9.7138, 11.6008, 1.4698> <-10.8495, 11.6008, 1.4698> <-10.8837, 11.5666, 1.4698>
		<-9.6796, 11.5666, 1.5144> <-9.7138, 11.6008, 1.5144> <-10.8495, 11.6008, 1.5144> <-10.8837, 11.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 10.3626, 1.5144> <-10.8837, 10.3626, 1.5613> <-10.8121, 10.4341, 1.6066> <-10.8269, 10.4193, 1.6486>
		<-10.9179, 10.3968, 1.5144> <-10.9179, 10.3968, 1.5613> <-10.8431, 10.4651, 1.6066> <-10.8579, 10.4503, 1.6486>
		<-10.9179, 11.5324, 1.5144> <-10.9179, 11.5324, 1.5613> <-10.8431, 11.4641, 1.6066> <-10.8579, 11.4789, 1.6486>
		<-10.8837, 11.5666, 1.5144> <-10.8837, 11.5666, 1.5613> <-10.8121, 11.4950, 1.6066> <-10.8269, 11.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 10.3626, 1.5144> <-10.8495, 10.3284, 1.5144> <-9.7138, 10.3284, 1.5144> <-9.6796, 10.3626, 1.5144>
		<-10.8837, 10.3626, 1.5613> <-10.8495, 10.3284, 1.5613> <-9.7138, 10.3284, 1.5613> <-9.6796, 10.3626, 1.5613>
		<-10.8121, 10.4341, 1.6066> <-10.7812, 10.4032, 1.6066> <-9.7822, 10.4032, 1.6066> <-9.7512, 10.4341, 1.6066>
		<-10.8269, 10.4193, 1.6486> <-10.7959, 10.3884, 1.6486> <-9.7674, 10.3884, 1.6486> <-9.7364, 10.4193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 10.3626, 1.5144> <-9.6455, 10.3968, 1.5144> <-9.6455, 11.5324, 1.5144> <-9.6796, 11.5666, 1.5144>
		<-9.6796, 10.3626, 1.5613> <-9.6455, 10.3968, 1.5613> <-9.6455, 11.5324, 1.5613> <-9.6796, 11.5666, 1.5613>
		<-9.7512, 10.4341, 1.6066> <-9.7202, 10.4651, 1.6066> <-9.7202, 11.4641, 1.6066> <-9.7512, 11.4950, 1.6066>
		<-9.7364, 10.4193, 1.6486> <-9.7054, 10.4503, 1.6486> <-9.7054, 11.4789, 1.6486> <-9.7364, 11.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 11.5666, 1.5144> <-9.7138, 11.6008, 1.5144> <-10.8495, 11.6008, 1.5144> <-10.8837, 11.5666, 1.5144>
		<-9.6796, 11.5666, 1.5613> <-9.7138, 11.6008, 1.5613> <-10.8495, 11.6008, 1.5613> <-10.8837, 11.5666, 1.5613>
		<-9.7512, 11.4950, 1.6066> <-9.7822, 11.5260, 1.6066> <-10.7812, 11.5260, 1.6066> <-10.8121, 11.4950, 1.6066>
		<-9.7364, 11.5098, 1.6486> <-9.7674, 11.5408, 1.6486> <-10.7959, 11.5408, 1.6486> <-10.8269, 11.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 10.4193, 1.6486> <-10.8754, 10.3709, 1.7862> <-11.0172, 10.2290, 1.8960> <-11.0664, 10.1799, 2.0332>
		<-10.8579, 10.4503, 1.6486> <-10.9063, 10.4018, 1.7862> <-11.0618, 10.2736, 1.8960> <-11.1109, 10.2245, 2.0332>
		<-10.8579, 11.4789, 1.6486> <-10.9063, 11.5273, 1.7862> <-11.0618, 11.6556, 1.8960> <-11.1109, 11.7047, 2.0332>
		<-10.8269, 11.5098, 1.6486> <-10.8754, 11.5583, 1.7862> <-11.0172, 11.7002, 1.8960> <-11.0664, 11.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 10.4193, 1.6486> <-10.7959, 10.3884, 1.6486> <-9.7674, 10.3884, 1.6486> <-9.7364, 10.4193, 1.6486>
		<-10.8754, 10.3709, 1.7862> <-10.8444, 10.3399, 1.7862> <-9.7189, 10.3399, 1.7862> <-9.6880, 10.3709, 1.7862>
		<-11.0172, 10.2290, 1.8960> <-10.9727, 10.1844, 1.8960> <-9.5907, 10.1844, 1.8960> <-9.5461, 10.2290, 1.8960>
		<-11.0664, 10.1799, 2.0332> <-11.0218, 10.1353, 2.0332> <-9.5415, 10.1353, 2.0332> <-9.4970, 10.1799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 10.4193, 1.6486> <-9.7054, 10.4503, 1.6486> <-9.7054, 11.4789, 1.6486> <-9.7364, 11.5098, 1.6486>
		<-9.6880, 10.3709, 1.7862> <-9.6570, 10.4018, 1.7862> <-9.6570, 11.5273, 1.7862> <-9.6880, 11.5583, 1.7862>
		<-9.5461, 10.2290, 1.8960> <-9.5015, 10.2736, 1.8960> <-9.5015, 11.6556, 1.8960> <-9.5461, 11.7002, 1.8960>
		<-9.4970, 10.1799, 2.0332> <-9.4524, 10.2245, 2.0332> <-9.4524, 11.7047, 2.0332> <-9.4970, 11.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 11.5098, 1.6486> <-9.7674, 11.5408, 1.6486> <-10.7959, 11.5408, 1.6486> <-10.8269, 11.5098, 1.6486>
		<-9.6880, 11.5583, 1.7862> <-9.7189, 11.5893, 1.7862> <-10.8444, 11.5893, 1.7862> <-10.8754, 11.5583, 1.7862>
		<-9.5461, 11.7002, 1.8960> <-9.5907, 11.7447, 1.8960> <-10.9727, 11.7447, 1.8960> <-11.0172, 11.7002, 1.8960>
		<-9.4970, 11.7493, 2.0332> <-9.5415, 11.7939, 2.0332> <-11.0218, 11.7939, 2.0332> <-11.0664, 11.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 2.0332> <-11.0930, 10.1533, 2.1074> <-11.0932, 10.1531, 2.2382> <-11.0641, 10.1822, 2.3104>
		<-11.1109, 10.2245, 2.0332> <-11.1375, 10.1979, 2.1074> <-11.1376, 10.1975, 2.2382> <-11.1085, 10.2266, 2.3104>
		<-11.1109, 11.7047, 2.0332> <-11.1375, 11.7313, 2.1074> <-11.1376, 11.7317, 2.2382> <-11.1085, 11.7025, 2.3104>
		<-11.0664, 11.7493, 2.0332> <-11.0930, 11.7759, 2.1074> <-11.0932, 11.7761, 2.2382> <-11.0641, 11.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 10.1799, 2.0332> <-11.0218, 10.1353, 2.0332> <-9.5415, 10.1353, 2.0332> <-9.4970, 10.1799, 2.0332>
		<-11.0930, 10.1533, 2.1074> <-11.0484, 10.1087, 2.1074> <-9.5149, 10.1087, 2.1074> <-9.4704, 10.1533, 2.1074>
		<-11.0932, 10.1531, 2.2382> <-11.0488, 10.1086, 2.2382> <-9.5146, 10.1086, 2.2382> <-9.4701, 10.1531, 2.2382>
		<-11.0641, 10.1822, 2.3104> <-11.0196, 10.1378, 2.3104> <-9.5437, 10.1378, 2.3104> <-9.4993, 10.1822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 10.1799, 2.0332> <-9.4524, 10.2245, 2.0332> <-9.4524, 11.7047, 2.0332> <-9.4970, 11.7493, 2.0332>
		<-9.4704, 10.1533, 2.1074> <-9.4258, 10.1979, 2.1074> <-9.4258, 11.7313, 2.1074> <-9.4704, 11.7759, 2.1074>
		<-9.4701, 10.1531, 2.2382> <-9.4257, 10.1975, 2.2382> <-9.4257, 11.7317, 2.2382> <-9.4701, 11.7761, 2.2382>
		<-9.4993, 10.1822, 2.3104> <-9.4548, 10.2266, 2.3104> <-9.4548, 11.7025, 2.3104> <-9.4993, 11.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 11.7493, 2.0332> <-9.5415, 11.7939, 2.0332> <-11.0218, 11.7939, 2.0332> <-11.0664, 11.7493, 2.0332>
		<-9.4704, 11.7759, 2.1074> <-9.5149, 11.8204, 2.1074> <-11.0484, 11.8204, 2.1074> <-11.0930, 11.7759, 2.1074>
		<-9.4701, 11.7761, 2.2382> <-9.5146, 11.8206, 2.2382> <-11.0488, 11.8206, 2.2382> <-11.0932, 11.7761, 2.2382>
		<-9.4993, 11.7470, 2.3104> <-9.5437, 11.7914, 2.3104> <-11.0196, 11.7914, 2.3104> <-11.0641, 11.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 10.1822, 2.3104> <-10.9801, 10.2661, 2.5186> <-10.7843, 10.4620, 2.7154> <-10.7056, 10.5406, 2.9276>
		<-11.1085, 10.2266, 2.3104> <-11.0246, 10.3106, 2.5186> <-10.8084, 10.4860, 2.7154> <-10.7297, 10.5647, 2.9276>
		<-11.1085, 11.7025, 2.3104> <-11.0246, 11.6186, 2.5186> <-10.8084, 11.4431, 2.7154> <-10.7297, 11.3645, 2.9276>
		<-11.0641, 11.7470, 2.3104> <-10.9801, 11.6630, 2.5186> <-10.7843, 11.4672, 2.7154> <-10.7056, 11.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 10.1822, 2.3104> <-11.0196, 10.1378, 2.3104> <-9.5437, 10.1378, 2.3104> <-9.4993, 10.1822, 2.3104>
		<-10.9801, 10.2661, 2.5186> <-10.9357, 10.2217, 2.5186> <-9.6277, 10.2217, 2.5186> <-9.5832, 10.2661, 2.5186>
		<-10.7843, 10.4620, 2.7154> <-10.7602, 10.4379, 2.7154> <-9.8031, 10.4379, 2.7154> <-9.7790, 10.4620, 2.7154>
		<-10.7056, 10.5406, 2.9276> <-10.6815, 10.5166, 2.9276> <-9.8818, 10.5166, 2.9276> <-9.8577, 10.5406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 10.1822, 2.3104> <-9.4548, 10.2266, 2.3104> <-9.4548, 11.7025, 2.3104> <-9.4993, 11.7470, 2.3104>
		<-9.5832, 10.2661, 2.5186> <-9.5388, 10.3106, 2.5186> <-9.5388, 11.6186, 2.5186> <-9.5832, 11.6630, 2.5186>
		<-9.7790, 10.4620, 2.7154> <-9.7550, 10.4860, 2.7154> <-9.7550, 11.4431, 2.7154> <-9.7790, 11.4672, 2.7154>
		<-9.8577, 10.5406, 2.9276> <-9.8336, 10.5647, 2.9276> <-9.8336, 11.3645, 2.9276> <-9.8577, 11.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 11.7470, 2.3104> <-9.5437, 11.7914, 2.3104> <-11.0196, 11.7914, 2.3104> <-11.0641, 11.7470, 2.3104>
		<-9.5832, 11.6630, 2.5186> <-9.6277, 11.7075, 2.5186> <-10.9357, 11.7075, 2.5186> <-10.9801, 11.6630, 2.5186>
		<-9.7790, 11.4672, 2.7154> <-9.8031, 11.4913, 2.7154> <-10.7602, 11.4913, 2.7154> <-10.7843, 11.4672, 2.7154>
		<-9.8577, 11.3885, 2.9276> <-9.8818, 11.4126, 2.9276> <-10.6815, 11.4126, 2.9276> <-10.7056, 11.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 10.5406, 2.9276> <-10.6887, 10.5576, 2.9732> <-10.7889, 10.4574, 3.0012> <-10.7889, 10.4574, 3.0528>
		<-10.7297, 10.5647, 2.9276> <-10.7128, 10.5816, 2.9732> <-10.8177, 10.4862, 3.0012> <-10.8177, 10.4862, 3.0528>
		<-10.7297, 11.3645, 2.9276> <-10.7128, 11.3475, 2.9732> <-10.8177, 11.4430, 3.0012> <-10.8177, 11.4430, 3.0528>
		<-10.7056, 11.3885, 2.9276> <-10.6887, 11.3716, 2.9732> <-10.7889, 11.4718, 3.0012> <-10.7889, 11.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 10.5406, 2.9276> <-10.6815, 10.5166, 2.9276> <-9.8818, 10.5166, 2.9276> <-9.8577, 10.5406, 2.9276>
		<-10.6887, 10.5576, 2.9732> <-10.6646, 10.5335, 2.9732> <-9.8987, 10.5335, 2.9732> <-9.8746, 10.5576, 2.9732>
		<-10.7889, 10.4574, 3.0012> <-10.7601, 10.4286, 3.0012> <-9.8033, 10.4286, 3.0012> <-9.7745, 10.4574, 3.0012>
		<-10.7889, 10.4574, 3.0528> <-10.7601, 10.4286, 3.0528> <-9.8033, 10.4286, 3.0528> <-9.7745, 10.4574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 10.5406, 2.9276> <-9.8336, 10.5647, 2.9276> <-9.8336, 11.3645, 2.9276> <-9.8577, 11.3885, 2.9276>
		<-9.8746, 10.5576, 2.9732> <-9.8506, 10.5816, 2.9732> <-9.8506, 11.3475, 2.9732> <-9.8746, 11.3716, 2.9732>
		<-9.7745, 10.4574, 3.0012> <-9.7456, 10.4862, 3.0012> <-9.7456, 11.4430, 3.0012> <-9.7745, 11.4718, 3.0012>
		<-9.7745, 10.4574, 3.0528> <-9.7456, 10.4862, 3.0528> <-9.7456, 11.4430, 3.0528> <-9.7745, 11.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 11.3885, 2.9276> <-9.8818, 11.4126, 2.9276> <-10.6815, 11.4126, 2.9276> <-10.7056, 11.3885, 2.9276>
		<-9.8746, 11.3716, 2.9732> <-9.8987, 11.3957, 2.9732> <-10.6646, 11.3957, 2.9732> <-10.6887, 11.3716, 2.9732>
		<-9.7745, 11.4718, 3.0012> <-9.8033, 11.5006, 3.0012> <-10.7601, 11.5006, 3.0012> <-10.7889, 11.4718, 3.0012>
		<-9.7745, 11.4718, 3.0528> <-9.8033, 11.5006, 3.0528> <-10.7601, 11.5006, 3.0528> <-10.7889, 11.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 10.4574, 3.0528> <-10.7889, 10.4574, 3.1044> <-10.6862, 10.5600, 3.1344> <-10.7056, 10.5406, 3.1780>
		<-10.8177, 10.4862, 3.0528> <-10.8177, 10.4862, 3.1044> <-10.7103, 10.5841, 3.1344> <-10.7297, 10.5647, 3.1780>
		<-10.8177, 11.4430, 3.0528> <-10.8177, 11.4430, 3.1044> <-10.7103, 11.3451, 3.1344> <-10.7297, 11.3645, 3.1780>
		<-10.7889, 11.4718, 3.0528> <-10.7889, 11.4718, 3.1044> <-10.6862, 11.3691, 3.1344> <-10.7056, 11.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 10.4574, 3.0528> <-10.7601, 10.4286, 3.0528> <-9.8033, 10.4286, 3.0528> <-9.7745, 10.4574, 3.0528>
		<-10.7889, 10.4574, 3.1044> <-10.7601, 10.4286, 3.1044> <-9.8033, 10.4286, 3.1044> <-9.7745, 10.4574, 3.1044>
		<-10.6862, 10.5600, 3.1344> <-10.6621, 10.5360, 3.1344> <-9.9012, 10.5360, 3.1344> <-9.8771, 10.5600, 3.1344>
		<-10.7056, 10.5406, 3.1780> <-10.6815, 10.5166, 3.1780> <-9.8818, 10.5166, 3.1780> <-9.8577, 10.5406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 10.4574, 3.0528> <-9.7456, 10.4862, 3.0528> <-9.7456, 11.4430, 3.0528> <-9.7745, 11.4718, 3.0528>
		<-9.7745, 10.4574, 3.1044> <-9.7456, 10.4862, 3.1044> <-9.7456, 11.4430, 3.1044> <-9.7745, 11.4718, 3.1044>
		<-9.8771, 10.5600, 3.1344> <-9.8530, 10.5841, 3.1344> <-9.8530, 11.3451, 3.1344> <-9.8771, 11.3691, 3.1344>
		<-9.8577, 10.5406, 3.1780> <-9.8336, 10.5647, 3.1780> <-9.8336, 11.3645, 3.1780> <-9.8577, 11.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 11.4718, 3.0528> <-9.8033, 11.5006, 3.0528> <-10.7601, 11.5006, 3.0528> <-10.7889, 11.4718, 3.0528>
		<-9.7745, 11.4718, 3.1044> <-9.8033, 11.5006, 3.1044> <-10.7601, 11.5006, 3.1044> <-10.7889, 11.4718, 3.1044>
		<-9.8771, 11.3691, 3.1344> <-9.9012, 11.3932, 3.1344> <-10.6621, 11.3932, 3.1344> <-10.6862, 11.3691, 3.1344>
		<-9.8577, 11.3885, 3.1780> <-9.8818, 11.4126, 3.1780> <-10.6815, 11.4126, 3.1780> <-10.7056, 11.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 10.5406, 3.1780> <-10.7438, 10.5024, 3.2640> <-10.8610, 10.3852, 3.2738> <-10.9161, 10.3302, 3.3390>
		<-10.7297, 10.5647, 3.1780> <-10.7679, 10.5265, 3.2640> <-10.8971, 10.4212, 3.2738> <-10.9521, 10.3662, 3.3390>
		<-10.7297, 11.3645, 3.1780> <-10.7679, 11.4027, 3.2640> <-10.8971, 11.5079, 3.2738> <-10.9521, 11.5629, 3.3390>
		<-10.7056, 11.3885, 3.1780> <-10.7438, 11.4267, 3.2640> <-10.8610, 11.5440, 3.2738> <-10.9161, 11.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 10.5406, 3.1780> <-10.6815, 10.5166, 3.1780> <-9.8818, 10.5166, 3.1780> <-9.8577, 10.5406, 3.1780>
		<-10.7438, 10.5024, 3.2640> <-10.7197, 10.4784, 3.2640> <-9.8436, 10.4784, 3.2640> <-9.8195, 10.5024, 3.2640>
		<-10.8610, 10.3852, 3.2738> <-10.8250, 10.3492, 3.2738> <-9.7383, 10.3492, 3.2738> <-9.7023, 10.3852, 3.2738>
		<-10.9161, 10.3302, 3.3390> <-10.8800, 10.2942, 3.3390> <-9.6833, 10.2942, 3.3390> <-9.6473, 10.3302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 10.5406, 3.1780> <-9.8336, 10.5647, 3.1780> <-9.8336, 11.3645, 3.1780> <-9.8577, 11.3885, 3.1780>
		<-9.8195, 10.5024, 3.2640> <-9.7954, 10.5265, 3.2640> <-9.7954, 11.4027, 3.2640> <-9.8195, 11.4267, 3.2640>
		<-9.7023, 10.3852, 3.2738> <-9.6663, 10.4212, 3.2738> <-9.6663, 11.5079, 3.2738> <-9.7023, 11.5440, 3.2738>
		<-9.6473, 10.3302, 3.3390> <-9.6112, 10.3662, 3.3390> <-9.6112, 11.5629, 3.3390> <-9.6473, 11.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 11.3885, 3.1780> <-9.8818, 11.4126, 3.1780> <-10.6815, 11.4126, 3.1780> <-10.7056, 11.3885, 3.1780>
		<-9.8195, 11.4267, 3.2640> <-9.8436, 11.4508, 3.2640> <-10.7197, 11.4508, 3.2640> <-10.7438, 11.4267, 3.2640>
		<-9.7023, 11.5440, 3.2738> <-9.7383, 11.5800, 3.2738> <-10.8250, 11.5800, 3.2738> <-10.8610, 11.5440, 3.2738>
		<-9.6473, 11.5990, 3.3390> <-9.6833, 11.6350, 3.3390> <-10.8800, 11.6350, 3.3390> <-10.9161, 11.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 10.3302, 3.3390> <-10.9416, 10.3046, 3.3693> <-10.9797, 10.2665, 3.4419> <-10.9623, 10.2839, 3.4821>
		<-10.9521, 10.3662, 3.3390> <-10.9777, 10.3406, 3.3693> <-11.0184, 10.3052, 3.4419> <-11.0010, 10.3226, 3.4821>
		<-10.9521, 11.5629, 3.3390> <-10.9777, 11.5885, 3.3693> <-11.0184, 11.6240, 3.4419> <-11.0010, 11.6066, 3.4821>
		<-10.9161, 11.5990, 3.3390> <-10.9416, 11.6246, 3.3693> <-10.9797, 11.6627, 3.4419> <-10.9623, 11.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 10.3302, 3.3390> <-10.8800, 10.2942, 3.3390> <-9.6833, 10.2942, 3.3390> <-9.6473, 10.3302, 3.3390>
		<-10.9416, 10.3046, 3.3693> <-10.9056, 10.2686, 3.3693> <-9.6577, 10.2686, 3.3693> <-9.6217, 10.3046, 3.3693>
		<-10.9797, 10.2665, 3.4419> <-10.9411, 10.2279, 3.4419> <-9.6223, 10.2279, 3.4419> <-9.5836, 10.2665, 3.4419>
		<-10.9623, 10.2839, 3.4821> <-10.9236, 10.2453, 3.4821> <-9.6397, 10.2453, 3.4821> <-9.6010, 10.2839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 10.3302, 3.3390> <-9.6112, 10.3662, 3.3390> <-9.6112, 11.5629, 3.3390> <-9.6473, 11.5990, 3.3390>
		<-9.6217, 10.3046, 3.3693> <-9.5857, 10.3406, 3.3693> <-9.5857, 11.5885, 3.3693> <-9.6217, 11.6246, 3.3693>
		<-9.5836, 10.2665, 3.4419> <-9.5449, 10.3052, 3.4419> <-9.5449, 11.6240, 3.4419> <-9.5836, 11.6627, 3.4419>
		<-9.6010, 10.2839, 3.4821> <-9.5624, 10.3226, 3.4821> <-9.5624, 11.6066, 3.4821> <-9.6010, 11.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 11.5990, 3.3390> <-9.6833, 11.6350, 3.3390> <-10.8800, 11.6350, 3.3390> <-10.9161, 11.5990, 3.3390>
		<-9.6217, 11.6246, 3.3693> <-9.6577, 11.6606, 3.3693> <-10.9056, 11.6606, 3.3693> <-10.9416, 11.6246, 3.3693>
		<-9.5836, 11.6627, 3.4419> <-9.6223, 11.7013, 3.4419> <-10.9411, 11.7013, 3.4419> <-10.9797, 11.6627, 3.4419>
		<-9.6010, 11.6452, 3.4821> <-9.6397, 11.6839, 3.4821> <-10.9236, 11.6839, 3.4821> <-10.9623, 11.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 10.2839, 3.4821> <-10.9163, 10.3300, 3.5884> <-10.7961, 10.4502, 3.6567> <-10.7380, 10.5083, 3.7504>
		<-11.0010, 10.3226, 3.4821> <-10.9550, 10.3686, 3.5884> <-10.8220, 10.4761, 3.6567> <-10.7639, 10.5342, 3.7504>
		<-11.0010, 11.6066, 3.4821> <-10.9550, 11.5606, 3.5884> <-10.8220, 11.4531, 3.6567> <-10.7639, 11.3950, 3.7504>
		<-10.9623, 11.6452, 3.4821> <-10.9163, 11.5992, 3.5884> <-10.7961, 11.4790, 3.6567> <-10.7380, 11.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 10.2839, 3.4821> <-10.9236, 10.2453, 3.4821> <-9.6397, 10.2453, 3.4821> <-9.6010, 10.2839, 3.4821>
		<-10.9163, 10.3300, 3.5884> <-10.8776, 10.2913, 3.5884> <-9.6857, 10.2913, 3.5884> <-9.6470, 10.3300, 3.5884>
		<-10.7961, 10.4502, 3.6567> <-10.7702, 10.4242, 3.6567> <-9.7932, 10.4242, 3.6567> <-9.7672, 10.4502, 3.6567>
		<-10.7380, 10.5083, 3.7504> <-10.7121, 10.4823, 3.7504> <-9.8513, 10.4823, 3.7504> <-9.8253, 10.5083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 10.2839, 3.4821> <-9.5624, 10.3226, 3.4821> <-9.5624, 11.6066, 3.4821> <-9.6010, 11.6452, 3.4821>
		<-9.6470, 10.3300, 3.5884> <-9.6084, 10.3686, 3.5884> <-9.6084, 11.5606, 3.5884> <-9.6470, 11.5992, 3.5884>
		<-9.7672, 10.4502, 3.6567> <-9.7413, 10.4761, 3.6567> <-9.7413, 11.4531, 3.6567> <-9.7672, 11.4790, 3.6567>
		<-9.8253, 10.5083, 3.7504> <-9.7994, 10.5342, 3.7504> <-9.7994, 11.3950, 3.7504> <-9.8253, 11.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 11.6452, 3.4821> <-9.6397, 11.6839, 3.4821> <-10.9236, 11.6839, 3.4821> <-10.9623, 11.6452, 3.4821>
		<-9.6470, 11.5992, 3.5884> <-9.6857, 11.6379, 3.5884> <-10.8776, 11.6379, 3.5884> <-10.9163, 11.5992, 3.5884>
		<-9.7672, 11.4790, 3.6567> <-9.7932, 11.5049, 3.6567> <-10.7702, 11.5049, 3.6567> <-10.7961, 11.4790, 3.6567>
		<-9.8253, 11.4209, 3.7504> <-9.8513, 11.4468, 3.7504> <-10.7121, 11.4468, 3.7504> <-10.7380, 11.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 10.5083, 3.7504> <-10.6964, 10.5498, 3.8175> <-10.6527, 10.5935, 3.9241> <-10.6352, 10.6110, 4.0098>
		<-10.7639, 10.5342, 3.7504> <-10.7223, 10.5757, 3.8175> <-10.6728, 10.6136, 3.9241> <-10.6553, 10.6311, 4.0098>
		<-10.7639, 11.3950, 3.7504> <-10.7223, 11.3534, 3.8175> <-10.6728, 11.3156, 3.9241> <-10.6553, 11.2981, 4.0098>
		<-10.7380, 11.4209, 3.7504> <-10.6964, 11.3793, 3.8175> <-10.6527, 11.3356, 3.9241> <-10.6352, 11.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 10.5083, 3.7504> <-10.7121, 10.4823, 3.7504> <-9.8513, 10.4823, 3.7504> <-9.8253, 10.5083, 3.7504>
		<-10.6964, 10.5498, 3.8175> <-10.6705, 10.5239, 3.8175> <-9.8928, 10.5239, 3.8175> <-9.8669, 10.5498, 3.8175>
		<-10.6527, 10.5935, 3.9241> <-10.6326, 10.5734, 3.9241> <-9.9307, 10.5734, 3.9241> <-9.9106, 10.5935, 3.9241>
		<-10.6352, 10.6110, 4.0098> <-10.6152, 10.5909, 4.0098> <-9.9482, 10.5909, 4.0098> <-9.9281, 10.6110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 10.5083, 3.7504> <-9.7994, 10.5342, 3.7504> <-9.7994, 11.3950, 3.7504> <-9.8253, 11.4209, 3.7504>
		<-9.8669, 10.5498, 3.8175> <-9.8410, 10.5757, 3.8175> <-9.8410, 11.3534, 3.8175> <-9.8669, 11.3793, 3.8175>
		<-9.9106, 10.5935, 3.9241> <-9.8905, 10.6136, 3.9241> <-9.8905, 11.3156, 3.9241> <-9.9106, 11.3356, 3.9241>
		<-9.9281, 10.6110, 4.0098> <-9.9080, 10.6311, 4.0098> <-9.9080, 11.2981, 4.0098> <-9.9281, 11.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 11.4209, 3.7504> <-9.8513, 11.4468, 3.7504> <-10.7121, 11.4468, 3.7504> <-10.7380, 11.4209, 3.7504>
		<-9.8669, 11.3793, 3.8175> <-9.8928, 11.4053, 3.8175> <-10.6705, 11.4053, 3.8175> <-10.6964, 11.3793, 3.8175>
		<-9.9106, 11.3356, 3.9241> <-9.9307, 11.3557, 3.9241> <-10.6326, 11.3557, 3.9241> <-10.6527, 11.3356, 3.9241>
		<-9.9281, 11.3182, 4.0098> <-9.9482, 11.3383, 4.0098> <-10.6152, 11.3383, 4.0098> <-10.6352, 11.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 10.6110, 4.0098> <-10.6168, 10.6294, 4.1002> <-10.6221, 10.6242, 4.2288> <-10.6213, 10.6250, 4.3229>
		<-10.6553, 10.6311, 4.0098> <-10.6369, 10.6495, 4.1002> <-10.6413, 10.6435, 4.2288> <-10.6405, 10.6443, 4.3229>
		<-10.6553, 11.2981, 4.0098> <-10.6369, 11.2797, 4.1002> <-10.6413, 11.2857, 4.2288> <-10.6405, 11.2849, 4.3229>
		<-10.6352, 11.3182, 4.0098> <-10.6168, 11.2997, 4.1002> <-10.6221, 11.3050, 4.2288> <-10.6213, 11.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 10.6110, 4.0098> <-10.6152, 10.5909, 4.0098> <-9.9482, 10.5909, 4.0098> <-9.9281, 10.6110, 4.0098>
		<-10.6168, 10.6294, 4.1002> <-10.5967, 10.6094, 4.1002> <-9.9666, 10.6094, 4.1002> <-9.9465, 10.6294, 4.1002>
		<-10.6221, 10.6242, 4.2288> <-10.6028, 10.6049, 4.2288> <-9.9606, 10.6049, 4.2288> <-9.9413, 10.6242, 4.2288>
		<-10.6213, 10.6250, 4.3229> <-10.6020, 10.6057, 4.3229> <-9.9614, 10.6057, 4.3229> <-9.9421, 10.6250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 10.6110, 4.0098> <-9.9080, 10.6311, 4.0098> <-9.9080, 11.2981, 4.0098> <-9.9281, 11.3182, 4.0098>
		<-9.9465, 10.6294, 4.1002> <-9.9264, 10.6495, 4.1002> <-9.9264, 11.2797, 4.1002> <-9.9465, 11.2997, 4.1002>
		<-9.9413, 10.6242, 4.2288> <-9.9220, 10.6435, 4.2288> <-9.9220, 11.2857, 4.2288> <-9.9413, 11.3050, 4.2288>
		<-9.9421, 10.6250, 4.3229> <-9.9228, 10.6443, 4.3229> <-9.9228, 11.2849, 4.3229> <-9.9421, 11.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 11.3182, 4.0098> <-9.9482, 11.3383, 4.0098> <-10.6152, 11.3383, 4.0098> <-10.6352, 11.3182, 4.0098>
		<-9.9465, 11.2997, 4.1002> <-9.9666, 11.3198, 4.1002> <-10.5967, 11.3198, 4.1002> <-10.6168, 11.2997, 4.1002>
		<-9.9413, 11.3050, 4.2288> <-9.9606, 11.3243, 4.2288> <-10.6028, 11.3243, 4.2288> <-10.6221, 11.3050, 4.2288>
		<-9.9421, 11.3042, 4.3229> <-9.9614, 11.3235, 4.3229> <-10.6020, 11.3235, 4.3229> <-10.6213, 11.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 10.6250, 4.3229> <-10.6179, 10.6284, 4.7283> <-10.6197, 10.6265, 5.2689> <-10.6213, 10.6250, 5.6744>
		<-10.6405, 10.6443, 4.3229> <-10.6371, 10.6477, 4.7283> <-10.6390, 10.6458, 5.2689> <-10.6405, 10.6443, 5.6744>
		<-10.6405, 11.2849, 4.3229> <-10.6371, 11.2815, 4.7283> <-10.6390, 11.2834, 5.2689> <-10.6405, 11.2849, 5.6744>
		<-10.6213, 11.3042, 4.3229> <-10.6179, 11.3008, 4.7283> <-10.6197, 11.3027, 5.2689> <-10.6213, 11.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 10.6250, 4.3229> <-10.6020, 10.6057, 4.3229> <-9.9614, 10.6057, 4.3229> <-9.9421, 10.6250, 4.3229>
		<-10.6179, 10.6284, 4.7283> <-10.5986, 10.6091, 4.7283> <-9.9648, 10.6091, 4.7283> <-9.9455, 10.6284, 4.7283>
		<-10.6197, 10.6265, 5.2689> <-10.6004, 10.6072, 5.2689> <-9.9629, 10.6072, 5.2689> <-9.9436, 10.6265, 5.2689>
		<-10.6213, 10.6250, 5.6744> <-10.6020, 10.6057, 5.6744> <-9.9614, 10.6057, 5.6744> <-9.9421, 10.6250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 10.6250, 4.3229> <-9.9228, 10.6443, 4.3229> <-9.9228, 11.2849, 4.3229> <-9.9421, 11.3042, 4.3229>
		<-9.9455, 10.6284, 4.7283> <-9.9262, 10.6477, 4.7283> <-9.9262, 11.2815, 4.7283> <-9.9455, 11.3008, 4.7283>
		<-9.9436, 10.6265, 5.2689> <-9.9243, 10.6458, 5.2689> <-9.9243, 11.2834, 5.2689> <-9.9436, 11.3027, 5.2689>
		<-9.9421, 10.6250, 5.6744> <-9.9228, 10.6443, 5.6744> <-9.9228, 11.2849, 5.6744> <-9.9421, 11.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 11.3042, 4.3229> <-9.9614, 11.3235, 4.3229> <-10.6020, 11.3235, 4.3229> <-10.6213, 11.3042, 4.3229>
		<-9.9455, 11.3008, 4.7283> <-9.9648, 11.3201, 4.7283> <-10.5986, 11.3201, 4.7283> <-10.6179, 11.3008, 4.7283>
		<-9.9436, 11.3027, 5.2689> <-9.9629, 11.3219, 5.2689> <-10.6004, 11.3219, 5.2689> <-10.6197, 11.3027, 5.2689>
		<-9.9421, 11.3042, 5.6744> <-9.9614, 11.3235, 5.6744> <-10.6020, 11.3235, 5.6744> <-10.6213, 11.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 10.6250, 5.6744> <-10.6225, 10.6237, 6.0073> <-10.6172, 10.6290, 6.4517> <-10.6305, 10.6157, 6.7841>
		<-10.6405, 10.6443, 5.6744> <-10.6418, 10.6430, 6.0073> <-10.6371, 10.6488, 6.4517> <-10.6503, 10.6355, 6.7841>
		<-10.6405, 11.2849, 5.6744> <-10.6418, 11.2861, 6.0073> <-10.6371, 11.2804, 6.4517> <-10.6503, 11.2936, 6.7841>
		<-10.6213, 11.3042, 5.6744> <-10.6225, 11.3054, 6.0073> <-10.6172, 11.3002, 6.4517> <-10.6305, 11.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 10.6250, 5.6744> <-10.6020, 10.6057, 5.6744> <-9.9614, 10.6057, 5.6744> <-9.9421, 10.6250, 5.6744>
		<-10.6225, 10.6237, 6.0073> <-10.6032, 10.6044, 6.0073> <-9.9601, 10.6044, 6.0073> <-9.9408, 10.6237, 6.0073>
		<-10.6172, 10.6290, 6.4517> <-10.5974, 10.6092, 6.4517> <-9.9659, 10.6092, 6.4517> <-9.9461, 10.6290, 6.4517>
		<-10.6305, 10.6157, 6.7841> <-10.6107, 10.5959, 6.7841> <-9.9526, 10.5959, 6.7841> <-9.9328, 10.6157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 10.6250, 5.6744> <-9.9228, 10.6443, 5.6744> <-9.9228, 11.2849, 5.6744> <-9.9421, 11.3042, 5.6744>
		<-9.9408, 10.6237, 6.0073> <-9.9215, 10.6430, 6.0073> <-9.9215, 11.2861, 6.0073> <-9.9408, 11.3054, 6.0073>
		<-9.9461, 10.6290, 6.4517> <-9.9263, 10.6488, 6.4517> <-9.9263, 11.2804, 6.4517> <-9.9461, 11.3002, 6.4517>
		<-9.9328, 10.6157, 6.7841> <-9.9130, 10.6355, 6.7841> <-9.9130, 11.2936, 6.7841> <-9.9328, 11.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 11.3042, 5.6744> <-9.9614, 11.3235, 5.6744> <-10.6020, 11.3235, 5.6744> <-10.6213, 11.3042, 5.6744>
		<-9.9408, 11.3054, 6.0073> <-9.9601, 11.3247, 6.0073> <-10.6032, 11.3247, 6.0073> <-10.6225, 11.3054, 6.0073>
		<-9.9461, 11.3002, 6.4517> <-9.9659, 11.3200, 6.4517> <-10.5974, 11.3200, 6.4517> <-10.6172, 11.3002, 6.4517>
		<-9.9328, 11.3134, 6.7841> <-9.9526, 11.3333, 6.7841> <-10.6107, 11.3333, 6.7841> <-10.6305, 11.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 10.6157, 6.7841> <-10.6325, 10.6137, 6.8341> <-10.6449, 10.6013, 6.9079> <-10.6718, 10.5745, 6.9405>
		<-10.6503, 10.6355, 6.7841> <-10.6523, 10.6336, 6.8341> <-10.6671, 10.6235, 6.9079> <-10.6940, 10.5966, 6.9405>
		<-10.6503, 11.2936, 6.7841> <-10.6523, 11.2956, 6.8341> <-10.6671, 11.3057, 6.9079> <-10.6940, 11.3326, 6.9405>
		<-10.6305, 11.3134, 6.7841> <-10.6325, 11.3154, 6.8341> <-10.6449, 11.3278, 6.9079> <-10.6718, 11.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 10.6157, 6.7841> <-10.6107, 10.5959, 6.7841> <-9.9526, 10.5959, 6.7841> <-9.9328, 10.6157, 6.7841>
		<-10.6325, 10.6137, 6.8341> <-10.6127, 10.5939, 6.8341> <-9.9506, 10.5939, 6.8341> <-9.9308, 10.6137, 6.8341>
		<-10.6449, 10.6013, 6.9079> <-10.6228, 10.5792, 6.9079> <-9.9406, 10.5792, 6.9079> <-9.9184, 10.6013, 6.9079>
		<-10.6718, 10.5745, 6.9405> <-10.6496, 10.5523, 6.9405> <-9.9137, 10.5523, 6.9405> <-9.8915, 10.5745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 10.6157, 6.7841> <-9.9130, 10.6355, 6.7841> <-9.9130, 11.2936, 6.7841> <-9.9328, 11.3134, 6.7841>
		<-9.9308, 10.6137, 6.8341> <-9.9110, 10.6336, 6.8341> <-9.9110, 11.2956, 6.8341> <-9.9308, 11.3154, 6.8341>
		<-9.9184, 10.6013, 6.9079> <-9.8962, 10.6235, 6.9079> <-9.8962, 11.3057, 6.9079> <-9.9184, 11.3278, 6.9079>
		<-9.8915, 10.5745, 6.9405> <-9.8694, 10.5966, 6.9405> <-9.8694, 11.3326, 6.9405> <-9.8915, 11.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 11.3134, 6.7841> <-9.9526, 11.3333, 6.7841> <-10.6107, 11.3333, 6.7841> <-10.6305, 11.3134, 6.7841>
		<-9.9308, 11.3154, 6.8341> <-9.9506, 11.3352, 6.8341> <-10.6127, 11.3352, 6.8341> <-10.6325, 11.3154, 6.8341>
		<-9.9184, 11.3278, 6.9079> <-9.9406, 11.3500, 6.9079> <-10.6228, 11.3500, 6.9079> <-10.6449, 11.3278, 6.9079>
		<-9.8915, 11.3547, 6.9405> <-9.9137, 11.3769, 6.9405> <-10.6496, 11.3769, 6.9405> <-10.6718, 11.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 10.5745, 6.9405> <-10.7339, 10.5123, 7.0160> <-10.8620, 10.3842, 7.0331> <-10.9114, 10.3348, 7.1255>
		<-10.6940, 10.5966, 6.9405> <-10.7561, 10.5345, 7.0160> <-10.8978, 10.4200, 7.0331> <-10.9472, 10.3706, 7.1255>
		<-10.6940, 11.3326, 6.9405> <-10.7561, 11.3947, 7.0160> <-10.8978, 11.5092, 7.0331> <-10.9472, 11.5586, 7.1255>
		<-10.6718, 11.3547, 6.9405> <-10.7339, 11.4168, 7.0160> <-10.8620, 11.5449, 7.0331> <-10.9114, 11.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 10.5745, 6.9405> <-10.6496, 10.5523, 6.9405> <-9.9137, 10.5523, 6.9405> <-9.8915, 10.5745, 6.9405>
		<-10.7339, 10.5123, 7.0160> <-10.7117, 10.4902, 7.0160> <-9.8516, 10.4902, 7.0160> <-9.8294, 10.5123, 7.0160>
		<-10.8620, 10.3842, 7.0331> <-10.8262, 10.3485, 7.0331> <-9.7371, 10.3485, 7.0331> <-9.7013, 10.3842, 7.0331>
		<-10.9114, 10.3348, 7.1255> <-10.8757, 10.2990, 7.1255> <-9.6877, 10.2990, 7.1255> <-9.6519, 10.3348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 10.5745, 6.9405> <-9.8694, 10.5966, 6.9405> <-9.8694, 11.3326, 6.9405> <-9.8915, 11.3547, 6.9405>
		<-9.8294, 10.5123, 7.0160> <-9.8073, 10.5345, 7.0160> <-9.8073, 11.3947, 7.0160> <-9.8294, 11.4168, 7.0160>
		<-9.7013, 10.3842, 7.0331> <-9.6655, 10.4200, 7.0331> <-9.6655, 11.5092, 7.0331> <-9.7013, 11.5449, 7.0331>
		<-9.6519, 10.3348, 7.1255> <-9.6161, 10.3706, 7.1255> <-9.6161, 11.5586, 7.1255> <-9.6519, 11.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 11.3547, 6.9405> <-9.9137, 11.3769, 6.9405> <-10.6496, 11.3769, 6.9405> <-10.6718, 11.3547, 6.9405>
		<-9.8294, 11.4168, 7.0160> <-9.8516, 11.4390, 7.0160> <-10.7117, 11.4390, 7.0160> <-10.7339, 11.4168, 7.0160>
		<-9.7013, 11.5449, 7.0331> <-9.7371, 11.5807, 7.0331> <-10.8262, 11.5807, 7.0331> <-10.8620, 11.5449, 7.0331>
		<-9.6519, 11.5944, 7.1255> <-9.6877, 11.6301, 7.1255> <-10.8757, 11.6301, 7.1255> <-10.9114, 11.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 10.3348, 7.1255> <-10.9319, 10.3143, 7.1638> <-10.8316, 10.4146, 7.1912> <-10.8316, 10.4146, 7.2393>
		<-10.9472, 10.3706, 7.1255> <-10.9677, 10.3501, 7.1638> <-10.8629, 10.4459, 7.1912> <-10.8629, 10.4459, 7.2393>
		<-10.9472, 11.5586, 7.1255> <-10.9677, 11.5791, 7.1638> <-10.8629, 11.4833, 7.1912> <-10.8629, 11.4833, 7.2393>
		<-10.9114, 11.5944, 7.1255> <-10.9319, 11.6149, 7.1638> <-10.8316, 11.5146, 7.1912> <-10.8316, 11.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 10.3348, 7.1255> <-10.8757, 10.2990, 7.1255> <-9.6877, 10.2990, 7.1255> <-9.6519, 10.3348, 7.1255>
		<-10.9319, 10.3143, 7.1638> <-10.8962, 10.2785, 7.1638> <-9.6671, 10.2785, 7.1638> <-9.6314, 10.3143, 7.1638>
		<-10.8316, 10.4146, 7.1912> <-10.8004, 10.3834, 7.1912> <-9.7629, 10.3834, 7.1912> <-9.7317, 10.4146, 7.1912>
		<-10.8316, 10.4146, 7.2393> <-10.8004, 10.3834, 7.2393> <-9.7629, 10.3834, 7.2393> <-9.7317, 10.4146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 10.3348, 7.1255> <-9.6161, 10.3706, 7.1255> <-9.6161, 11.5586, 7.1255> <-9.6519, 11.5944, 7.1255>
		<-9.6314, 10.3143, 7.1638> <-9.5956, 10.3501, 7.1638> <-9.5956, 11.5791, 7.1638> <-9.6314, 11.6149, 7.1638>
		<-9.7317, 10.4146, 7.1912> <-9.7005, 10.4459, 7.1912> <-9.7005, 11.4833, 7.1912> <-9.7317, 11.5146, 7.1912>
		<-9.7317, 10.4146, 7.2393> <-9.7005, 10.4459, 7.2393> <-9.7005, 11.4833, 7.2393> <-9.7317, 11.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 11.5944, 7.1255> <-9.6877, 11.6301, 7.1255> <-10.8757, 11.6301, 7.1255> <-10.9114, 11.5944, 7.1255>
		<-9.6314, 11.6149, 7.1638> <-9.6671, 11.6506, 7.1638> <-10.8962, 11.6506, 7.1638> <-10.9319, 11.6149, 7.1638>
		<-9.7317, 11.5146, 7.1912> <-9.7629, 11.5458, 7.1912> <-10.8004, 11.5458, 7.1912> <-10.8316, 11.5146, 7.1912>
		<-9.7317, 11.5146, 7.2393> <-9.7629, 11.5458, 7.2393> <-10.8004, 11.5458, 7.2393> <-10.8316, 11.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 10.4146, 7.2393> <-10.8316, 10.4146, 7.2905> <-10.9054, 10.3408, 7.3169> <-10.9114, 10.3348, 7.3673>
		<-10.8629, 10.4459, 7.2393> <-10.8629, 10.4459, 7.2905> <-10.9412, 10.3766, 7.3169> <-10.9472, 10.3706, 7.3673>
		<-10.8629, 11.4833, 7.2393> <-10.8629, 11.4833, 7.2905> <-10.9412, 11.5526, 7.3169> <-10.9472, 11.5586, 7.3673>
		<-10.8316, 11.5146, 7.2393> <-10.8316, 11.5146, 7.2905> <-10.9054, 11.5883, 7.3169> <-10.9114, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 10.4146, 7.2393> <-10.8004, 10.3834, 7.2393> <-9.7629, 10.3834, 7.2393> <-9.7317, 10.4146, 7.2393>
		<-10.8316, 10.4146, 7.2905> <-10.8004, 10.3834, 7.2905> <-9.7629, 10.3834, 7.2905> <-9.7317, 10.4146, 7.2905>
		<-10.9054, 10.3408, 7.3169> <-10.8696, 10.3051, 7.3169> <-9.6937, 10.3051, 7.3169> <-9.6579, 10.3408, 7.3169>
		<-10.9114, 10.3348, 7.3673> <-10.8757, 10.2990, 7.3673> <-9.6877, 10.2990, 7.3673> <-9.6519, 10.3348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 10.4146, 7.2393> <-9.7005, 10.4459, 7.2393> <-9.7005, 11.4833, 7.2393> <-9.7317, 11.5146, 7.2393>
		<-9.7317, 10.4146, 7.2905> <-9.7005, 10.4459, 7.2905> <-9.7005, 11.4833, 7.2905> <-9.7317, 11.5146, 7.2905>
		<-9.6579, 10.3408, 7.3169> <-9.6222, 10.3766, 7.3169> <-9.6222, 11.5526, 7.3169> <-9.6579, 11.5883, 7.3169>
		<-9.6519, 10.3348, 7.3673> <-9.6161, 10.3706, 7.3673> <-9.6161, 11.5586, 7.3673> <-9.6519, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 11.5146, 7.2393> <-9.7629, 11.5458, 7.2393> <-10.8004, 11.5458, 7.2393> <-10.8316, 11.5146, 7.2393>
		<-9.7317, 11.5146, 7.2905> <-9.7629, 11.5458, 7.2905> <-10.8004, 11.5458, 7.2905> <-10.8316, 11.5146, 7.2905>
		<-9.6579, 11.5883, 7.3169> <-9.6937, 11.6241, 7.3169> <-10.8696, 11.6241, 7.3169> <-10.9054, 11.5883, 7.3169>
		<-9.6519, 11.5944, 7.3673> <-9.6877, 11.6301, 7.3673> <-10.8757, 11.6301, 7.3673> <-10.9114, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 10.3348, 7.9080> <-10.9472, 10.3706, 7.9080> <-10.9472, 11.5586, 7.9080> <-10.9114, 11.5944, 7.9080>
		<-10.9114, 10.3348, 7.7458> <-10.9472, 10.3706, 7.7458> <-10.9472, 11.5586, 7.7458> <-10.9114, 11.5944, 7.7458>
		<-10.9305, 10.3157, 7.5273> <-10.9663, 10.3515, 7.5273> <-10.9663, 11.5777, 7.5273> <-10.9305, 11.6134, 7.5273>
		<-10.9114, 10.3348, 7.3673> <-10.9472, 10.3706, 7.3673> <-10.9472, 11.5586, 7.3673> <-10.9114, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 10.3348, 7.9080> <-10.9114, 10.3348, 7.7458> <-10.9305, 10.3157, 7.5273> <-10.9114, 10.3348, 7.3673>
		<-10.8757, 10.2990, 7.9080> <-10.8757, 10.2990, 7.7458> <-10.8947, 10.2800, 7.5273> <-10.8757, 10.2990, 7.3673>
		<-9.6877, 10.2990, 7.9080> <-9.6877, 10.2990, 7.7458> <-9.6686, 10.2800, 7.5273> <-9.6877, 10.2990, 7.3673>
		<-9.6519, 10.3348, 7.9080> <-9.6519, 10.3348, 7.7458> <-9.6328, 10.3157, 7.5273> <-9.6519, 10.3348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 10.3348, 7.9080> <-9.6519, 10.3348, 7.7458> <-9.6328, 10.3157, 7.5273> <-9.6519, 10.3348, 7.3673>
		<-9.6161, 10.3706, 7.9080> <-9.6161, 10.3706, 7.7458> <-9.5970, 10.3515, 7.5273> <-9.6161, 10.3706, 7.3673>
		<-9.6161, 11.5586, 7.9080> <-9.6161, 11.5586, 7.7458> <-9.5970, 11.5777, 7.5273> <-9.6161, 11.5586, 7.3673>
		<-9.6519, 11.5944, 7.9080> <-9.6519, 11.5944, 7.7458> <-9.6328, 11.6134, 7.5273> <-9.6519, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 11.5944, 7.9080> <-9.6519, 11.5944, 7.7458> <-9.6328, 11.6134, 7.5273> <-9.6519, 11.5944, 7.3673>
		<-9.6877, 11.6301, 7.9080> <-9.6877, 11.6301, 7.7458> <-9.6686, 11.6492, 7.5273> <-9.6877, 11.6301, 7.3673>
		<-10.8757, 11.6301, 7.9080> <-10.8757, 11.6301, 7.7458> <-10.8947, 11.6492, 7.5273> <-10.8757, 11.6301, 7.3673>
		<-10.9114, 11.5944, 7.9080> <-10.9114, 11.5944, 7.7458> <-10.9305, 11.6134, 7.5273> <-10.9114, 11.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 10.0874, 0.7771> <-11.2087, 10.1372, 0.7771> <-11.2087, 11.7920, 0.7771> <-11.1589, 11.8418, 0.7771>
		<-11.1796, 10.0666, 0.6520> <-11.2294, 10.1164, 0.6520> <-11.2294, 11.8127, 0.6520> <-11.1796, 11.8625, 0.6520>
		<-11.1589, 10.0874, 0.4772> <-11.2087, 10.1372, 0.4772> <-11.2087, 11.7920, 0.4772> <-11.1589, 11.8418, 0.4772>
		<-11.1589, 10.0874, 0.3486> <-11.2087, 10.1372, 0.3486> <-11.2087, 11.7920, 0.3486> <-11.1589, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 10.0874, 0.7771> <-11.1796, 10.0666, 0.6520> <-11.1589, 10.0874, 0.4772> <-11.1589, 10.0874, 0.3486>
		<-11.1090, 10.0376, 0.7771> <-11.1298, 10.0168, 0.6520> <-11.1090, 10.0376, 0.4772> <-11.1090, 10.0376, 0.3486>
		<-9.4543, 10.0376, 0.7771> <-9.4335, 10.0168, 0.6520> <-9.4543, 10.0376, 0.4772> <-9.4543, 10.0376, 0.3486>
		<-9.4045, 10.0874, 0.7771> <-9.3837, 10.0666, 0.6520> <-9.4045, 10.0874, 0.4772> <-9.4045, 10.0874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 10.0874, 0.7771> <-9.3837, 10.0666, 0.6520> <-9.4045, 10.0874, 0.4772> <-9.4045, 10.0874, 0.3486>
		<-9.3546, 10.1372, 0.7771> <-9.3339, 10.1164, 0.6520> <-9.3546, 10.1372, 0.4772> <-9.3546, 10.1372, 0.3486>
		<-9.3546, 11.7920, 0.7771> <-9.3339, 11.8127, 0.6520> <-9.3546, 11.7920, 0.4772> <-9.3546, 11.7920, 0.3486>
		<-9.4045, 11.8418, 0.7771> <-9.3837, 11.8625, 0.6520> <-9.4045, 11.8418, 0.4772> <-9.4045, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 11.8418, 0.7771> <-9.3837, 11.8625, 0.6520> <-9.4045, 11.8418, 0.4772> <-9.4045, 11.8418, 0.3486>
		<-9.4543, 11.8916, 0.7771> <-9.4335, 11.9124, 0.6520> <-9.4543, 11.8916, 0.4772> <-9.4543, 11.8916, 0.3486>
		<-11.1090, 11.8916, 0.7771> <-11.1298, 11.9124, 0.6520> <-11.1090, 11.8916, 0.4772> <-11.1090, 11.8916, 0.3486>
		<-11.1589, 11.8418, 0.7771> <-11.1796, 11.8625, 0.6520> <-11.1589, 11.8418, 0.4772> <-11.1589, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 10.0874, -0.0618> <-11.1589, 10.0874, 0.0613> <-11.1589, 10.0874, 0.2255> <-11.1589, 10.0874, 0.3486>
		<-11.2087, 10.1372, -0.0618> <-11.2087, 10.1372, 0.0613> <-11.2087, 10.1372, 0.2255> <-11.2087, 10.1372, 0.3486>
		<-11.2087, 11.7920, -0.0618> <-11.2087, 11.7920, 0.0613> <-11.2087, 11.7920, 0.2255> <-11.2087, 11.7920, 0.3486>
		<-11.1589, 11.8418, -0.0618> <-11.1589, 11.8418, 0.0613> <-11.1589, 11.8418, 0.2255> <-11.1589, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 10.0874, -0.0618> <-11.1090, 10.0376, -0.0618> <-9.4543, 10.0376, -0.0618> <-9.4045, 10.0874, -0.0618>
		<-11.1589, 10.0874, 0.0613> <-11.1090, 10.0376, 0.0613> <-9.4543, 10.0376, 0.0613> <-9.4045, 10.0874, 0.0613>
		<-11.1589, 10.0874, 0.2255> <-11.1090, 10.0376, 0.2255> <-9.4543, 10.0376, 0.2255> <-9.4045, 10.0874, 0.2255>
		<-11.1589, 10.0874, 0.3486> <-11.1090, 10.0376, 0.3486> <-9.4543, 10.0376, 0.3486> <-9.4045, 10.0874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 10.0874, -0.0618> <-9.3546, 10.1372, -0.0618> <-9.3546, 11.7920, -0.0618> <-9.4045, 11.8418, -0.0618>
		<-9.4045, 10.0874, 0.0613> <-9.3546, 10.1372, 0.0613> <-9.3546, 11.7920, 0.0613> <-9.4045, 11.8418, 0.0613>
		<-9.4045, 10.0874, 0.2255> <-9.3546, 10.1372, 0.2255> <-9.3546, 11.7920, 0.2255> <-9.4045, 11.8418, 0.2255>
		<-9.4045, 10.0874, 0.3486> <-9.3546, 10.1372, 0.3486> <-9.3546, 11.7920, 0.3486> <-9.4045, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 11.8418, -0.0618> <-9.4543, 11.8916, -0.0618> <-11.1090, 11.8916, -0.0618> <-11.1589, 11.8418, -0.0618>
		<-9.4045, 11.8418, 0.0613> <-9.4543, 11.8916, 0.0613> <-11.1090, 11.8916, 0.0613> <-11.1589, 11.8418, 0.0613>
		<-9.4045, 11.8418, 0.2255> <-9.4543, 11.8916, 0.2255> <-11.1090, 11.8916, 0.2255> <-11.1589, 11.8418, 0.2255>
		<-9.4045, 11.8418, 0.3486> <-9.4543, 11.8916, 0.3486> <-11.1090, 11.8916, 0.3486> <-11.1589, 11.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 0.9062> <-11.1109, 8.0245, 0.9062> <-11.1109, 9.5047, 0.9062> <-11.0664, 9.5493, 0.9062>
		<-11.0712, 7.9751, 0.8515> <-11.1157, 8.0196, 0.8515> <-11.1157, 9.5095, 0.8515> <-11.0712, 9.5541, 0.8515>
		<-11.1500, 7.8963, 0.8308> <-11.1998, 7.9461, 0.8308> <-11.1998, 9.5831, 0.8308> <-11.1500, 9.6329, 0.8308>
		<-11.1589, 7.8874, 0.7771> <-11.2087, 7.9372, 0.7771> <-11.2087, 9.5920, 0.7771> <-11.1589, 9.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 0.9062> <-11.0620, 7.9842, 0.9557> <-11.1560, 7.8903, 0.9996> <-11.1357, 7.9105, 1.0404>
		<-11.1109, 8.0245, 0.9062> <-11.1066, 8.0288, 0.9557> <-11.2045, 7.9388, 0.9996> <-11.1842, 7.9590, 1.0404>
		<-11.1109, 9.5047, 0.9062> <-11.1066, 9.5004, 0.9557> <-11.2045, 9.5904, 0.9996> <-11.1842, 9.5702, 1.0404>
		<-11.0664, 9.5493, 0.9062> <-11.0620, 9.5449, 0.9557> <-11.1560, 9.6389, 0.9996> <-11.1357, 9.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 0.9062> <-11.0712, 7.9751, 0.8515> <-11.1500, 7.8963, 0.8308> <-11.1589, 7.8874, 0.7771>
		<-11.0218, 7.9353, 0.9062> <-11.0266, 7.9305, 0.8515> <-11.1001, 7.8465, 0.8308> <-11.1090, 7.8376, 0.7771>
		<-9.5415, 7.9353, 0.9062> <-9.5367, 7.9305, 0.8515> <-9.4632, 7.8465, 0.8308> <-9.4543, 7.8376, 0.7771>
		<-9.4970, 7.9799, 0.9062> <-9.4922, 7.9751, 0.8515> <-9.4134, 7.8963, 0.8308> <-9.4045, 7.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 0.9062> <-11.0218, 7.9353, 0.9062> <-9.5415, 7.9353, 0.9062> <-9.4970, 7.9799, 0.9062>
		<-11.0620, 7.9842, 0.9557> <-11.0175, 7.9397, 0.9557> <-9.5459, 7.9397, 0.9557> <-9.5013, 7.9842, 0.9557>
		<-11.1560, 7.8903, 0.9996> <-11.1075, 7.8418, 0.9996> <-9.4559, 7.8418, 0.9996> <-9.4073, 7.8903, 0.9996>
		<-11.1357, 7.9105, 1.0404> <-11.0872, 7.8620, 1.0404> <-9.4761, 7.8620, 1.0404> <-9.4276, 7.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.9799, 0.9062> <-9.4922, 7.9751, 0.8515> <-9.4134, 7.8963, 0.8308> <-9.4045, 7.8874, 0.7771>
		<-9.4524, 8.0245, 0.9062> <-9.4476, 8.0196, 0.8515> <-9.3635, 7.9461, 0.8308> <-9.3546, 7.9372, 0.7771>
		<-9.4524, 9.5047, 0.9062> <-9.4476, 9.5095, 0.8515> <-9.3635, 9.5831, 0.8308> <-9.3546, 9.5920, 0.7771>
		<-9.4970, 9.5493, 0.9062> <-9.4922, 9.5541, 0.8515> <-9.4134, 9.6329, 0.8308> <-9.4045, 9.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.9799, 0.9062> <-9.4524, 8.0245, 0.9062> <-9.4524, 9.5047, 0.9062> <-9.4970, 9.5493, 0.9062>
		<-9.5013, 7.9842, 0.9557> <-9.4567, 8.0288, 0.9557> <-9.4567, 9.5004, 0.9557> <-9.5013, 9.5449, 0.9557>
		<-9.4073, 7.8903, 0.9996> <-9.3588, 7.9388, 0.9996> <-9.3588, 9.5904, 0.9996> <-9.4073, 9.6389, 0.9996>
		<-9.4276, 7.9105, 1.0404> <-9.3791, 7.9590, 1.0404> <-9.3791, 9.5702, 1.0404> <-9.4276, 9.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 9.5493, 0.9062> <-9.4922, 9.5541, 0.8515> <-9.4134, 9.6329, 0.8308> <-9.4045, 9.6418, 0.7771>
		<-9.5415, 9.5939, 0.9062> <-9.5367, 9.5987, 0.8515> <-9.4632, 9.6827, 0.8308> <-9.4543, 9.6916, 0.7771>
		<-11.0218, 9.5939, 0.9062> <-11.0266, 9.5987, 0.8515> <-11.1001, 9.6827, 0.8308> <-11.1090, 9.6916, 0.7771>
		<-11.0664, 9.5493, 0.9062> <-11.0712, 9.5541, 0.8515> <-11.1500, 9.6329, 0.8308> <-11.1589, 9.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 9.5493, 0.9062> <-9.5415, 9.5939, 0.9062> <-11.0218, 9.5939, 0.9062> <-11.0664, 9.5493, 0.9062>
		<-9.5013, 9.5449, 0.9557> <-9.5459, 9.5895, 0.9557> <-11.0175, 9.5895, 0.9557> <-11.0620, 9.5449, 0.9557>
		<-9.4073, 9.6389, 0.9996> <-9.4559, 9.6874, 0.9996> <-11.1075, 9.6874, 0.9996> <-11.1560, 9.6389, 0.9996>
		<-9.4276, 9.6187, 1.0404> <-9.4761, 9.6672, 1.0404> <-11.0872, 9.6672, 1.0404> <-11.1357, 9.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 7.9105, 1.0404> <-11.0677, 7.9786, 1.1777> <-10.8982, 8.1481, 1.2552> <-10.8269, 8.2193, 1.3892>
		<-11.1842, 7.9590, 1.0404> <-11.1162, 8.0271, 1.1777> <-10.9291, 8.1790, 1.2552> <-10.8579, 8.2503, 1.3892>
		<-11.1842, 9.5702, 1.0404> <-11.1162, 9.5021, 1.1777> <-10.9291, 9.3501, 1.2552> <-10.8579, 9.2789, 1.3892>
		<-11.1357, 9.6187, 1.0404> <-11.0677, 9.5506, 1.1777> <-10.8982, 9.3811, 1.2552> <-10.8269, 9.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 7.9105, 1.0404> <-11.0872, 7.8620, 1.0404> <-9.4761, 7.8620, 1.0404> <-9.4276, 7.9105, 1.0404>
		<-11.0677, 7.9786, 1.1777> <-11.0192, 7.9301, 1.1777> <-9.5442, 7.9301, 1.1777> <-9.4957, 7.9786, 1.1777>
		<-10.8982, 8.1481, 1.2552> <-10.8672, 8.1171, 1.2552> <-9.6961, 8.1171, 1.2552> <-9.6652, 8.1481, 1.2552>
		<-10.8269, 8.2193, 1.3892> <-10.7959, 8.1884, 1.3892> <-9.7674, 8.1884, 1.3892> <-9.7364, 8.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 7.9105, 1.0404> <-9.3791, 7.9590, 1.0404> <-9.3791, 9.5702, 1.0404> <-9.4276, 9.6187, 1.0404>
		<-9.4957, 7.9786, 1.1777> <-9.4471, 8.0271, 1.1777> <-9.4471, 9.5021, 1.1777> <-9.4957, 9.5506, 1.1777>
		<-9.6652, 8.1481, 1.2552> <-9.6342, 8.1790, 1.2552> <-9.6342, 9.3501, 1.2552> <-9.6652, 9.3811, 1.2552>
		<-9.7364, 8.2193, 1.3892> <-9.7054, 8.2503, 1.3892> <-9.7054, 9.2789, 1.3892> <-9.7364, 9.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 9.6187, 1.0404> <-9.4761, 9.6672, 1.0404> <-11.0872, 9.6672, 1.0404> <-11.1357, 9.6187, 1.0404>
		<-9.4957, 9.5506, 1.1777> <-9.5442, 9.5991, 1.1777> <-11.0192, 9.5991, 1.1777> <-11.0677, 9.5506, 1.1777>
		<-9.6652, 9.3811, 1.2552> <-9.6961, 9.4121, 1.2552> <-10.8672, 9.4121, 1.2552> <-10.8982, 9.3811, 1.2552>
		<-9.7364, 9.3098, 1.3892> <-9.7674, 9.3408, 1.3892> <-10.7959, 9.3408, 1.3892> <-10.8269, 9.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 8.2193, 1.3892> <-10.8079, 8.2383, 1.4249> <-10.8837, 8.1626, 1.4698> <-10.8837, 8.1626, 1.5144>
		<-10.8579, 8.2503, 1.3892> <-10.8389, 8.2693, 1.4249> <-10.9179, 8.1968, 1.4698> <-10.9179, 8.1968, 1.5144>
		<-10.8579, 9.2789, 1.3892> <-10.8389, 9.2599, 1.4249> <-10.9179, 9.3324, 1.4698> <-10.9179, 9.3324, 1.5144>
		<-10.8269, 9.3098, 1.3892> <-10.8079, 9.2909, 1.4249> <-10.8837, 9.3666, 1.4698> <-10.8837, 9.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 8.2193, 1.3892> <-10.7959, 8.1884, 1.3892> <-9.7674, 8.1884, 1.3892> <-9.7364, 8.2193, 1.3892>
		<-10.8079, 8.2383, 1.4249> <-10.7770, 8.2073, 1.4249> <-9.7863, 8.2073, 1.4249> <-9.7554, 8.2383, 1.4249>
		<-10.8837, 8.1626, 1.4698> <-10.8495, 8.1284, 1.4698> <-9.7138, 8.1284, 1.4698> <-9.6796, 8.1626, 1.4698>
		<-10.8837, 8.1626, 1.5144> <-10.8495, 8.1284, 1.5144> <-9.7138, 8.1284, 1.5144> <-9.6796, 8.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 8.2193, 1.3892> <-9.7054, 8.2503, 1.3892> <-9.7054, 9.2789, 1.3892> <-9.7364, 9.3098, 1.3892>
		<-9.7554, 8.2383, 1.4249> <-9.7244, 8.2693, 1.4249> <-9.7244, 9.2599, 1.4249> <-9.7554, 9.2909, 1.4249>
		<-9.6796, 8.1626, 1.4698> <-9.6455, 8.1968, 1.4698> <-9.6455, 9.3324, 1.4698> <-9.6796, 9.3666, 1.4698>
		<-9.6796, 8.1626, 1.5144> <-9.6455, 8.1968, 1.5144> <-9.6455, 9.3324, 1.5144> <-9.6796, 9.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 9.3098, 1.3892> <-9.7674, 9.3408, 1.3892> <-10.7959, 9.3408, 1.3892> <-10.8269, 9.3098, 1.3892>
		<-9.7554, 9.2909, 1.4249> <-9.7863, 9.3218, 1.4249> <-10.7770, 9.3218, 1.4249> <-10.8079, 9.2909, 1.4249>
		<-9.6796, 9.3666, 1.4698> <-9.7138, 9.4008, 1.4698> <-10.8495, 9.4008, 1.4698> <-10.8837, 9.3666, 1.4698>
		<-9.6796, 9.3666, 1.5144> <-9.7138, 9.4008, 1.5144> <-10.8495, 9.4008, 1.5144> <-10.8837, 9.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 8.1626, 1.5144> <-10.8837, 8.1626, 1.5613> <-10.8121, 8.2341, 1.6066> <-10.8269, 8.2193, 1.6486>
		<-10.9179, 8.1968, 1.5144> <-10.9179, 8.1968, 1.5613> <-10.8431, 8.2651, 1.6066> <-10.8579, 8.2503, 1.6486>
		<-10.9179, 9.3324, 1.5144> <-10.9179, 9.3324, 1.5613> <-10.8431, 9.2641, 1.6066> <-10.8579, 9.2789, 1.6486>
		<-10.8837, 9.3666, 1.5144> <-10.8837, 9.3666, 1.5613> <-10.8121, 9.2950, 1.6066> <-10.8269, 9.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 8.1626, 1.5144> <-10.8495, 8.1284, 1.5144> <-9.7138, 8.1284, 1.5144> <-9.6796, 8.1626, 1.5144>
		<-10.8837, 8.1626, 1.5613> <-10.8495, 8.1284, 1.5613> <-9.7138, 8.1284, 1.5613> <-9.6796, 8.1626, 1.5613>
		<-10.8121, 8.2341, 1.6066> <-10.7812, 8.2032, 1.6066> <-9.7822, 8.2032, 1.6066> <-9.7512, 8.2341, 1.6066>
		<-10.8269, 8.2193, 1.6486> <-10.7959, 8.1884, 1.6486> <-9.7674, 8.1884, 1.6486> <-9.7364, 8.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 8.1626, 1.5144> <-9.6455, 8.1968, 1.5144> <-9.6455, 9.3324, 1.5144> <-9.6796, 9.3666, 1.5144>
		<-9.6796, 8.1626, 1.5613> <-9.6455, 8.1968, 1.5613> <-9.6455, 9.3324, 1.5613> <-9.6796, 9.3666, 1.5613>
		<-9.7512, 8.2341, 1.6066> <-9.7202, 8.2651, 1.6066> <-9.7202, 9.2641, 1.6066> <-9.7512, 9.2950, 1.6066>
		<-9.7364, 8.2193, 1.6486> <-9.7054, 8.2503, 1.6486> <-9.7054, 9.2789, 1.6486> <-9.7364, 9.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 9.3666, 1.5144> <-9.7138, 9.4008, 1.5144> <-10.8495, 9.4008, 1.5144> <-10.8837, 9.3666, 1.5144>
		<-9.6796, 9.3666, 1.5613> <-9.7138, 9.4008, 1.5613> <-10.8495, 9.4008, 1.5613> <-10.8837, 9.3666, 1.5613>
		<-9.7512, 9.2950, 1.6066> <-9.7822, 9.3260, 1.6066> <-10.7812, 9.3260, 1.6066> <-10.8121, 9.2950, 1.6066>
		<-9.7364, 9.3098, 1.6486> <-9.7674, 9.3408, 1.6486> <-10.7959, 9.3408, 1.6486> <-10.8269, 9.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 8.2193, 1.6486> <-10.8754, 8.1709, 1.7862> <-11.0172, 8.0290, 1.8960> <-11.0664, 7.9799, 2.0332>
		<-10.8579, 8.2503, 1.6486> <-10.9063, 8.2018, 1.7862> <-11.0618, 8.0736, 1.8960> <-11.1109, 8.0245, 2.0332>
		<-10.8579, 9.2789, 1.6486> <-10.9063, 9.3273, 1.7862> <-11.0618, 9.4556, 1.8960> <-11.1109, 9.5047, 2.0332>
		<-10.8269, 9.3098, 1.6486> <-10.8754, 9.3583, 1.7862> <-11.0172, 9.5002, 1.8960> <-11.0664, 9.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 8.2193, 1.6486> <-10.7959, 8.1884, 1.6486> <-9.7674, 8.1884, 1.6486> <-9.7364, 8.2193, 1.6486>
		<-10.8754, 8.1709, 1.7862> <-10.8444, 8.1399, 1.7862> <-9.7189, 8.1399, 1.7862> <-9.6880, 8.1709, 1.7862>
		<-11.0172, 8.0290, 1.8960> <-10.9727, 7.9844, 1.8960> <-9.5907, 7.9844, 1.8960> <-9.5461, 8.0290, 1.8960>
		<-11.0664, 7.9799, 2.0332> <-11.0218, 7.9353, 2.0332> <-9.5415, 7.9353, 2.0332> <-9.4970, 7.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 8.2193, 1.6486> <-9.7054, 8.2503, 1.6486> <-9.7054, 9.2789, 1.6486> <-9.7364, 9.3098, 1.6486>
		<-9.6880, 8.1709, 1.7862> <-9.6570, 8.2018, 1.7862> <-9.6570, 9.3273, 1.7862> <-9.6880, 9.3583, 1.7862>
		<-9.5461, 8.0290, 1.8960> <-9.5015, 8.0736, 1.8960> <-9.5015, 9.4556, 1.8960> <-9.5461, 9.5002, 1.8960>
		<-9.4970, 7.9799, 2.0332> <-9.4524, 8.0245, 2.0332> <-9.4524, 9.5047, 2.0332> <-9.4970, 9.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 9.3098, 1.6486> <-9.7674, 9.3408, 1.6486> <-10.7959, 9.3408, 1.6486> <-10.8269, 9.3098, 1.6486>
		<-9.6880, 9.3583, 1.7862> <-9.7189, 9.3893, 1.7862> <-10.8444, 9.3893, 1.7862> <-10.8754, 9.3583, 1.7862>
		<-9.5461, 9.5002, 1.8960> <-9.5907, 9.5447, 1.8960> <-10.9727, 9.5447, 1.8960> <-11.0172, 9.5002, 1.8960>
		<-9.4970, 9.5493, 2.0332> <-9.5415, 9.5939, 2.0332> <-11.0218, 9.5939, 2.0332> <-11.0664, 9.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 2.0332> <-11.0930, 7.9533, 2.1074> <-11.0932, 7.9531, 2.2382> <-11.0641, 7.9822, 2.3104>
		<-11.1109, 8.0245, 2.0332> <-11.1375, 7.9979, 2.1074> <-11.1376, 7.9975, 2.2382> <-11.1085, 8.0266, 2.3104>
		<-11.1109, 9.5047, 2.0332> <-11.1375, 9.5313, 2.1074> <-11.1376, 9.5317, 2.2382> <-11.1085, 9.5025, 2.3104>
		<-11.0664, 9.5493, 2.0332> <-11.0930, 9.5759, 2.1074> <-11.0932, 9.5761, 2.2382> <-11.0641, 9.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 7.9799, 2.0332> <-11.0218, 7.9353, 2.0332> <-9.5415, 7.9353, 2.0332> <-9.4970, 7.9799, 2.0332>
		<-11.0930, 7.9533, 2.1074> <-11.0484, 7.9087, 2.1074> <-9.5149, 7.9087, 2.1074> <-9.4704, 7.9533, 2.1074>
		<-11.0932, 7.9531, 2.2382> <-11.0488, 7.9086, 2.2382> <-9.5146, 7.9086, 2.2382> <-9.4701, 7.9531, 2.2382>
		<-11.0641, 7.9822, 2.3104> <-11.0196, 7.9378, 2.3104> <-9.5437, 7.9378, 2.3104> <-9.4993, 7.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.9799, 2.0332> <-9.4524, 8.0245, 2.0332> <-9.4524, 9.5047, 2.0332> <-9.4970, 9.5493, 2.0332>
		<-9.4704, 7.9533, 2.1074> <-9.4258, 7.9979, 2.1074> <-9.4258, 9.5313, 2.1074> <-9.4704, 9.5759, 2.1074>
		<-9.4701, 7.9531, 2.2382> <-9.4257, 7.9975, 2.2382> <-9.4257, 9.5317, 2.2382> <-9.4701, 9.5761, 2.2382>
		<-9.4993, 7.9822, 2.3104> <-9.4548, 8.0266, 2.3104> <-9.4548, 9.5025, 2.3104> <-9.4993, 9.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 9.5493, 2.0332> <-9.5415, 9.5939, 2.0332> <-11.0218, 9.5939, 2.0332> <-11.0664, 9.5493, 2.0332>
		<-9.4704, 9.5759, 2.1074> <-9.5149, 9.6204, 2.1074> <-11.0484, 9.6204, 2.1074> <-11.0930, 9.5759, 2.1074>
		<-9.4701, 9.5761, 2.2382> <-9.5146, 9.6206, 2.2382> <-11.0488, 9.6206, 2.2382> <-11.0932, 9.5761, 2.2382>
		<-9.4993, 9.5470, 2.3104> <-9.5437, 9.5914, 2.3104> <-11.0196, 9.5914, 2.3104> <-11.0641, 9.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 7.9822, 2.3104> <-10.9801, 8.0661, 2.5186> <-10.7843, 8.2620, 2.7154> <-10.7056, 8.3406, 2.9276>
		<-11.1085, 8.0266, 2.3104> <-11.0246, 8.1106, 2.5186> <-10.8084, 8.2860, 2.7154> <-10.7297, 8.3647, 2.9276>
		<-11.1085, 9.5025, 2.3104> <-11.0246, 9.4186, 2.5186> <-10.8084, 9.2431, 2.7154> <-10.7297, 9.1645, 2.9276>
		<-11.0641, 9.5470, 2.3104> <-10.9801, 9.4630, 2.5186> <-10.7843, 9.2672, 2.7154> <-10.7056, 9.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 7.9822, 2.3104> <-11.0196, 7.9378, 2.3104> <-9.5437, 7.9378, 2.3104> <-9.4993, 7.9822, 2.3104>
		<-10.9801, 8.0661, 2.5186> <-10.9357, 8.0217, 2.5186> <-9.6277, 8.0217, 2.5186> <-9.5832, 8.0661, 2.5186>
		<-10.7843, 8.2620, 2.7154> <-10.7602, 8.2379, 2.7154> <-9.8031, 8.2379, 2.7154> <-9.7790, 8.2620, 2.7154>
		<-10.7056, 8.3406, 2.9276> <-10.6815, 8.3166, 2.9276> <-9.8818, 8.3166, 2.9276> <-9.8577, 8.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 7.9822, 2.3104> <-9.4548, 8.0266, 2.3104> <-9.4548, 9.5025, 2.3104> <-9.4993, 9.5470, 2.3104>
		<-9.5832, 8.0661, 2.5186> <-9.5388, 8.1106, 2.5186> <-9.5388, 9.4186, 2.5186> <-9.5832, 9.4630, 2.5186>
		<-9.7790, 8.2620, 2.7154> <-9.7550, 8.2860, 2.7154> <-9.7550, 9.2431, 2.7154> <-9.7790, 9.2672, 2.7154>
		<-9.8577, 8.3406, 2.9276> <-9.8336, 8.3647, 2.9276> <-9.8336, 9.1645, 2.9276> <-9.8577, 9.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 9.5470, 2.3104> <-9.5437, 9.5914, 2.3104> <-11.0196, 9.5914, 2.3104> <-11.0641, 9.5470, 2.3104>
		<-9.5832, 9.4630, 2.5186> <-9.6277, 9.5075, 2.5186> <-10.9357, 9.5075, 2.5186> <-10.9801, 9.4630, 2.5186>
		<-9.7790, 9.2672, 2.7154> <-9.8031, 9.2913, 2.7154> <-10.7602, 9.2913, 2.7154> <-10.7843, 9.2672, 2.7154>
		<-9.8577, 9.1885, 2.9276> <-9.8818, 9.2126, 2.9276> <-10.6815, 9.2126, 2.9276> <-10.7056, 9.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 8.3406, 2.9276> <-10.6887, 8.3576, 2.9732> <-10.7889, 8.2574, 3.0012> <-10.7889, 8.2574, 3.0528>
		<-10.7297, 8.3647, 2.9276> <-10.7128, 8.3816, 2.9732> <-10.8177, 8.2862, 3.0012> <-10.8177, 8.2862, 3.0528>
		<-10.7297, 9.1645, 2.9276> <-10.7128, 9.1475, 2.9732> <-10.8177, 9.2430, 3.0012> <-10.8177, 9.2430, 3.0528>
		<-10.7056, 9.1885, 2.9276> <-10.6887, 9.1716, 2.9732> <-10.7889, 9.2718, 3.0012> <-10.7889, 9.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 8.3406, 2.9276> <-10.6815, 8.3166, 2.9276> <-9.8818, 8.3166, 2.9276> <-9.8577, 8.3406, 2.9276>
		<-10.6887, 8.3576, 2.9732> <-10.6646, 8.3335, 2.9732> <-9.8987, 8.3335, 2.9732> <-9.8746, 8.3576, 2.9732>
		<-10.7889, 8.2574, 3.0012> <-10.7601, 8.2286, 3.0012> <-9.8033, 8.2286, 3.0012> <-9.7745, 8.2574, 3.0012>
		<-10.7889, 8.2574, 3.0528> <-10.7601, 8.2286, 3.0528> <-9.8033, 8.2286, 3.0528> <-9.7745, 8.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 8.3406, 2.9276> <-9.8336, 8.3647, 2.9276> <-9.8336, 9.1645, 2.9276> <-9.8577, 9.1885, 2.9276>
		<-9.8746, 8.3576, 2.9732> <-9.8506, 8.3816, 2.9732> <-9.8506, 9.1475, 2.9732> <-9.8746, 9.1716, 2.9732>
		<-9.7745, 8.2574, 3.0012> <-9.7456, 8.2862, 3.0012> <-9.7456, 9.2430, 3.0012> <-9.7745, 9.2718, 3.0012>
		<-9.7745, 8.2574, 3.0528> <-9.7456, 8.2862, 3.0528> <-9.7456, 9.2430, 3.0528> <-9.7745, 9.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 9.1885, 2.9276> <-9.8818, 9.2126, 2.9276> <-10.6815, 9.2126, 2.9276> <-10.7056, 9.1885, 2.9276>
		<-9.8746, 9.1716, 2.9732> <-9.8987, 9.1957, 2.9732> <-10.6646, 9.1957, 2.9732> <-10.6887, 9.1716, 2.9732>
		<-9.7745, 9.2718, 3.0012> <-9.8033, 9.3006, 3.0012> <-10.7601, 9.3006, 3.0012> <-10.7889, 9.2718, 3.0012>
		<-9.7745, 9.2718, 3.0528> <-9.8033, 9.3006, 3.0528> <-10.7601, 9.3006, 3.0528> <-10.7889, 9.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 8.2574, 3.0528> <-10.7889, 8.2574, 3.1044> <-10.6862, 8.3600, 3.1344> <-10.7056, 8.3406, 3.1780>
		<-10.8177, 8.2862, 3.0528> <-10.8177, 8.2862, 3.1044> <-10.7103, 8.3841, 3.1344> <-10.7297, 8.3647, 3.1780>
		<-10.8177, 9.2430, 3.0528> <-10.8177, 9.2430, 3.1044> <-10.7103, 9.1451, 3.1344> <-10.7297, 9.1645, 3.1780>
		<-10.7889, 9.2718, 3.0528> <-10.7889, 9.2718, 3.1044> <-10.6862, 9.1691, 3.1344> <-10.7056, 9.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 8.2574, 3.0528> <-10.7601, 8.2286, 3.0528> <-9.8033, 8.2286, 3.0528> <-9.7745, 8.2574, 3.0528>
		<-10.7889, 8.2574, 3.1044> <-10.7601, 8.2286, 3.1044> <-9.8033, 8.2286, 3.1044> <-9.7745, 8.2574, 3.1044>
		<-10.6862, 8.3600, 3.1344> <-10.6621, 8.3360, 3.1344> <-9.9012, 8.3360, 3.1344> <-9.8771, 8.3600, 3.1344>
		<-10.7056, 8.3406, 3.1780> <-10.6815, 8.3166, 3.1780> <-9.8818, 8.3166, 3.1780> <-9.8577, 8.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 8.2574, 3.0528> <-9.7456, 8.2862, 3.0528> <-9.7456, 9.2430, 3.0528> <-9.7745, 9.2718, 3.0528>
		<-9.7745, 8.2574, 3.1044> <-9.7456, 8.2862, 3.1044> <-9.7456, 9.2430, 3.1044> <-9.7745, 9.2718, 3.1044>
		<-9.8771, 8.3600, 3.1344> <-9.8530, 8.3841, 3.1344> <-9.8530, 9.1451, 3.1344> <-9.8771, 9.1691, 3.1344>
		<-9.8577, 8.3406, 3.1780> <-9.8336, 8.3647, 3.1780> <-9.8336, 9.1645, 3.1780> <-9.8577, 9.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 9.2718, 3.0528> <-9.8033, 9.3006, 3.0528> <-10.7601, 9.3006, 3.0528> <-10.7889, 9.2718, 3.0528>
		<-9.7745, 9.2718, 3.1044> <-9.8033, 9.3006, 3.1044> <-10.7601, 9.3006, 3.1044> <-10.7889, 9.2718, 3.1044>
		<-9.8771, 9.1691, 3.1344> <-9.9012, 9.1932, 3.1344> <-10.6621, 9.1932, 3.1344> <-10.6862, 9.1691, 3.1344>
		<-9.8577, 9.1885, 3.1780> <-9.8818, 9.2126, 3.1780> <-10.6815, 9.2126, 3.1780> <-10.7056, 9.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 8.3406, 3.1780> <-10.7438, 8.3024, 3.2640> <-10.8610, 8.1852, 3.2738> <-10.9161, 8.1302, 3.3390>
		<-10.7297, 8.3647, 3.1780> <-10.7679, 8.3265, 3.2640> <-10.8971, 8.2212, 3.2738> <-10.9521, 8.1662, 3.3390>
		<-10.7297, 9.1645, 3.1780> <-10.7679, 9.2027, 3.2640> <-10.8971, 9.3079, 3.2738> <-10.9521, 9.3629, 3.3390>
		<-10.7056, 9.1885, 3.1780> <-10.7438, 9.2267, 3.2640> <-10.8610, 9.3440, 3.2738> <-10.9161, 9.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 8.3406, 3.1780> <-10.6815, 8.3166, 3.1780> <-9.8818, 8.3166, 3.1780> <-9.8577, 8.3406, 3.1780>
		<-10.7438, 8.3024, 3.2640> <-10.7197, 8.2784, 3.2640> <-9.8436, 8.2784, 3.2640> <-9.8195, 8.3024, 3.2640>
		<-10.8610, 8.1852, 3.2738> <-10.8250, 8.1492, 3.2738> <-9.7383, 8.1492, 3.2738> <-9.7023, 8.1852, 3.2738>
		<-10.9161, 8.1302, 3.3390> <-10.8800, 8.0942, 3.3390> <-9.6833, 8.0942, 3.3390> <-9.6473, 8.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 8.3406, 3.1780> <-9.8336, 8.3647, 3.1780> <-9.8336, 9.1645, 3.1780> <-9.8577, 9.1885, 3.1780>
		<-9.8195, 8.3024, 3.2640> <-9.7954, 8.3265, 3.2640> <-9.7954, 9.2027, 3.2640> <-9.8195, 9.2267, 3.2640>
		<-9.7023, 8.1852, 3.2738> <-9.6663, 8.2212, 3.2738> <-9.6663, 9.3079, 3.2738> <-9.7023, 9.3440, 3.2738>
		<-9.6473, 8.1302, 3.3390> <-9.6112, 8.1662, 3.3390> <-9.6112, 9.3629, 3.3390> <-9.6473, 9.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 9.1885, 3.1780> <-9.8818, 9.2126, 3.1780> <-10.6815, 9.2126, 3.1780> <-10.7056, 9.1885, 3.1780>
		<-9.8195, 9.2267, 3.2640> <-9.8436, 9.2508, 3.2640> <-10.7197, 9.2508, 3.2640> <-10.7438, 9.2267, 3.2640>
		<-9.7023, 9.3440, 3.2738> <-9.7383, 9.3800, 3.2738> <-10.8250, 9.3800, 3.2738> <-10.8610, 9.3440, 3.2738>
		<-9.6473, 9.3990, 3.3390> <-9.6833, 9.4350, 3.3390> <-10.8800, 9.4350, 3.3390> <-10.9161, 9.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 8.1302, 3.3390> <-10.9416, 8.1046, 3.3693> <-10.9797, 8.0665, 3.4419> <-10.9623, 8.0839, 3.4821>
		<-10.9521, 8.1662, 3.3390> <-10.9777, 8.1406, 3.3693> <-11.0184, 8.1052, 3.4419> <-11.0010, 8.1226, 3.4821>
		<-10.9521, 9.3629, 3.3390> <-10.9777, 9.3885, 3.3693> <-11.0184, 9.4240, 3.4419> <-11.0010, 9.4066, 3.4821>
		<-10.9161, 9.3990, 3.3390> <-10.9416, 9.4246, 3.3693> <-10.9797, 9.4627, 3.4419> <-10.9623, 9.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 8.1302, 3.3390> <-10.8800, 8.0942, 3.3390> <-9.6833, 8.0942, 3.3390> <-9.6473, 8.1302, 3.3390>
		<-10.9416, 8.1046, 3.3693> <-10.9056, 8.0686, 3.3693> <-9.6577, 8.0686, 3.3693> <-9.6217, 8.1046, 3.3693>
		<-10.9797, 8.0665, 3.4419> <-10.9411, 8.0279, 3.4419> <-9.6223, 8.0279, 3.4419> <-9.5836, 8.0665, 3.4419>
		<-10.9623, 8.0839, 3.4821> <-10.9236, 8.0453, 3.4821> <-9.6397, 8.0453, 3.4821> <-9.6010, 8.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 8.1302, 3.3390> <-9.6112, 8.1662, 3.3390> <-9.6112, 9.3629, 3.3390> <-9.6473, 9.3990, 3.3390>
		<-9.6217, 8.1046, 3.3693> <-9.5857, 8.1406, 3.3693> <-9.5857, 9.3885, 3.3693> <-9.6217, 9.4246, 3.3693>
		<-9.5836, 8.0665, 3.4419> <-9.5449, 8.1052, 3.4419> <-9.5449, 9.4240, 3.4419> <-9.5836, 9.4627, 3.4419>
		<-9.6010, 8.0839, 3.4821> <-9.5624, 8.1226, 3.4821> <-9.5624, 9.4066, 3.4821> <-9.6010, 9.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 9.3990, 3.3390> <-9.6833, 9.4350, 3.3390> <-10.8800, 9.4350, 3.3390> <-10.9161, 9.3990, 3.3390>
		<-9.6217, 9.4246, 3.3693> <-9.6577, 9.4606, 3.3693> <-10.9056, 9.4606, 3.3693> <-10.9416, 9.4246, 3.3693>
		<-9.5836, 9.4627, 3.4419> <-9.6223, 9.5013, 3.4419> <-10.9411, 9.5013, 3.4419> <-10.9797, 9.4627, 3.4419>
		<-9.6010, 9.4452, 3.4821> <-9.6397, 9.4839, 3.4821> <-10.9236, 9.4839, 3.4821> <-10.9623, 9.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 8.0839, 3.4821> <-10.9163, 8.1300, 3.5884> <-10.7961, 8.2502, 3.6567> <-10.7380, 8.3083, 3.7504>
		<-11.0010, 8.1226, 3.4821> <-10.9550, 8.1686, 3.5884> <-10.8220, 8.2761, 3.6567> <-10.7639, 8.3342, 3.7504>
		<-11.0010, 9.4066, 3.4821> <-10.9550, 9.3606, 3.5884> <-10.8220, 9.2531, 3.6567> <-10.7639, 9.1950, 3.7504>
		<-10.9623, 9.4452, 3.4821> <-10.9163, 9.3992, 3.5884> <-10.7961, 9.2790, 3.6567> <-10.7380, 9.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 8.0839, 3.4821> <-10.9236, 8.0453, 3.4821> <-9.6397, 8.0453, 3.4821> <-9.6010, 8.0839, 3.4821>
		<-10.9163, 8.1300, 3.5884> <-10.8776, 8.0913, 3.5884> <-9.6857, 8.0913, 3.5884> <-9.6470, 8.1300, 3.5884>
		<-10.7961, 8.2502, 3.6567> <-10.7702, 8.2242, 3.6567> <-9.7932, 8.2242, 3.6567> <-9.7672, 8.2502, 3.6567>
		<-10.7380, 8.3083, 3.7504> <-10.7121, 8.2823, 3.7504> <-9.8513, 8.2823, 3.7504> <-9.8253, 8.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 8.0839, 3.4821> <-9.5624, 8.1226, 3.4821> <-9.5624, 9.4066, 3.4821> <-9.6010, 9.4452, 3.4821>
		<-9.6470, 8.1300, 3.5884> <-9.6084, 8.1686, 3.5884> <-9.6084, 9.3606, 3.5884> <-9.6470, 9.3992, 3.5884>
		<-9.7672, 8.2502, 3.6567> <-9.7413, 8.2761, 3.6567> <-9.7413, 9.2531, 3.6567> <-9.7672, 9.2790, 3.6567>
		<-9.8253, 8.3083, 3.7504> <-9.7994, 8.3342, 3.7504> <-9.7994, 9.1950, 3.7504> <-9.8253, 9.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 9.4452, 3.4821> <-9.6397, 9.4839, 3.4821> <-10.9236, 9.4839, 3.4821> <-10.9623, 9.4452, 3.4821>
		<-9.6470, 9.3992, 3.5884> <-9.6857, 9.4379, 3.5884> <-10.8776, 9.4379, 3.5884> <-10.9163, 9.3992, 3.5884>
		<-9.7672, 9.2790, 3.6567> <-9.7932, 9.3049, 3.6567> <-10.7702, 9.3049, 3.6567> <-10.7961, 9.2790, 3.6567>
		<-9.8253, 9.2209, 3.7504> <-9.8513, 9.2468, 3.7504> <-10.7121, 9.2468, 3.7504> <-10.7380, 9.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 8.3083, 3.7504> <-10.6964, 8.3498, 3.8175> <-10.6527, 8.3935, 3.9241> <-10.6352, 8.4110, 4.0098>
		<-10.7639, 8.3342, 3.7504> <-10.7223, 8.3757, 3.8175> <-10.6728, 8.4136, 3.9241> <-10.6553, 8.4311, 4.0098>
		<-10.7639, 9.1950, 3.7504> <-10.7223, 9.1534, 3.8175> <-10.6728, 9.1156, 3.9241> <-10.6553, 9.0981, 4.0098>
		<-10.7380, 9.2209, 3.7504> <-10.6964, 9.1793, 3.8175> <-10.6527, 9.1356, 3.9241> <-10.6352, 9.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 8.3083, 3.7504> <-10.7121, 8.2823, 3.7504> <-9.8513, 8.2823, 3.7504> <-9.8253, 8.3083, 3.7504>
		<-10.6964, 8.3498, 3.8175> <-10.6705, 8.3239, 3.8175> <-9.8928, 8.3239, 3.8175> <-9.8669, 8.3498, 3.8175>
		<-10.6527, 8.3935, 3.9241> <-10.6326, 8.3734, 3.9241> <-9.9307, 8.3734, 3.9241> <-9.9106, 8.3935, 3.9241>
		<-10.6352, 8.4110, 4.0098> <-10.6152, 8.3909, 4.0098> <-9.9482, 8.3909, 4.0098> <-9.9281, 8.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 8.3083, 3.7504> <-9.7994, 8.3342, 3.7504> <-9.7994, 9.1950, 3.7504> <-9.8253, 9.2209, 3.7504>
		<-9.8669, 8.3498, 3.8175> <-9.8410, 8.3757, 3.8175> <-9.8410, 9.1534, 3.8175> <-9.8669, 9.1793, 3.8175>
		<-9.9106, 8.3935, 3.9241> <-9.8905, 8.4136, 3.9241> <-9.8905, 9.1156, 3.9241> <-9.9106, 9.1356, 3.9241>
		<-9.9281, 8.4110, 4.0098> <-9.9080, 8.4311, 4.0098> <-9.9080, 9.0981, 4.0098> <-9.9281, 9.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 9.2209, 3.7504> <-9.8513, 9.2468, 3.7504> <-10.7121, 9.2468, 3.7504> <-10.7380, 9.2209, 3.7504>
		<-9.8669, 9.1793, 3.8175> <-9.8928, 9.2053, 3.8175> <-10.6705, 9.2053, 3.8175> <-10.6964, 9.1793, 3.8175>
		<-9.9106, 9.1356, 3.9241> <-9.9307, 9.1557, 3.9241> <-10.6326, 9.1557, 3.9241> <-10.6527, 9.1356, 3.9241>
		<-9.9281, 9.1182, 4.0098> <-9.9482, 9.1383, 4.0098> <-10.6152, 9.1383, 4.0098> <-10.6352, 9.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 8.4110, 4.0098> <-10.6168, 8.4294, 4.1002> <-10.6221, 8.4242, 4.2288> <-10.6213, 8.4250, 4.3229>
		<-10.6553, 8.4311, 4.0098> <-10.6369, 8.4495, 4.1002> <-10.6413, 8.4435, 4.2288> <-10.6405, 8.4443, 4.3229>
		<-10.6553, 9.0981, 4.0098> <-10.6369, 9.0797, 4.1002> <-10.6413, 9.0857, 4.2288> <-10.6405, 9.0849, 4.3229>
		<-10.6352, 9.1182, 4.0098> <-10.6168, 9.0997, 4.1002> <-10.6221, 9.1050, 4.2288> <-10.6213, 9.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 8.4110, 4.0098> <-10.6152, 8.3909, 4.0098> <-9.9482, 8.3909, 4.0098> <-9.9281, 8.4110, 4.0098>
		<-10.6168, 8.4294, 4.1002> <-10.5967, 8.4094, 4.1002> <-9.9666, 8.4094, 4.1002> <-9.9465, 8.4294, 4.1002>
		<-10.6221, 8.4242, 4.2288> <-10.6028, 8.4049, 4.2288> <-9.9606, 8.4049, 4.2288> <-9.9413, 8.4242, 4.2288>
		<-10.6213, 8.4250, 4.3229> <-10.6020, 8.4057, 4.3229> <-9.9614, 8.4057, 4.3229> <-9.9421, 8.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 8.4110, 4.0098> <-9.9080, 8.4311, 4.0098> <-9.9080, 9.0981, 4.0098> <-9.9281, 9.1182, 4.0098>
		<-9.9465, 8.4294, 4.1002> <-9.9264, 8.4495, 4.1002> <-9.9264, 9.0797, 4.1002> <-9.9465, 9.0997, 4.1002>
		<-9.9413, 8.4242, 4.2288> <-9.9220, 8.4435, 4.2288> <-9.9220, 9.0857, 4.2288> <-9.9413, 9.1050, 4.2288>
		<-9.9421, 8.4250, 4.3229> <-9.9228, 8.4443, 4.3229> <-9.9228, 9.0849, 4.3229> <-9.9421, 9.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 9.1182, 4.0098> <-9.9482, 9.1383, 4.0098> <-10.6152, 9.1383, 4.0098> <-10.6352, 9.1182, 4.0098>
		<-9.9465, 9.0997, 4.1002> <-9.9666, 9.1198, 4.1002> <-10.5967, 9.1198, 4.1002> <-10.6168, 9.0997, 4.1002>
		<-9.9413, 9.1050, 4.2288> <-9.9606, 9.1243, 4.2288> <-10.6028, 9.1243, 4.2288> <-10.6221, 9.1050, 4.2288>
		<-9.9421, 9.1042, 4.3229> <-9.9614, 9.1235, 4.3229> <-10.6020, 9.1235, 4.3229> <-10.6213, 9.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 8.4250, 4.3229> <-10.6179, 8.4284, 4.7283> <-10.6197, 8.4265, 5.2689> <-10.6213, 8.4250, 5.6744>
		<-10.6405, 8.4443, 4.3229> <-10.6371, 8.4477, 4.7283> <-10.6390, 8.4458, 5.2689> <-10.6405, 8.4443, 5.6744>
		<-10.6405, 9.0849, 4.3229> <-10.6371, 9.0815, 4.7283> <-10.6390, 9.0834, 5.2689> <-10.6405, 9.0849, 5.6744>
		<-10.6213, 9.1042, 4.3229> <-10.6179, 9.1008, 4.7283> <-10.6197, 9.1027, 5.2689> <-10.6213, 9.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 8.4250, 4.3229> <-10.6020, 8.4057, 4.3229> <-9.9614, 8.4057, 4.3229> <-9.9421, 8.4250, 4.3229>
		<-10.6179, 8.4284, 4.7283> <-10.5986, 8.4091, 4.7283> <-9.9648, 8.4091, 4.7283> <-9.9455, 8.4284, 4.7283>
		<-10.6197, 8.4265, 5.2689> <-10.6004, 8.4072, 5.2689> <-9.9629, 8.4072, 5.2689> <-9.9436, 8.4265, 5.2689>
		<-10.6213, 8.4250, 5.6744> <-10.6020, 8.4057, 5.6744> <-9.9614, 8.4057, 5.6744> <-9.9421, 8.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 8.4250, 4.3229> <-9.9228, 8.4443, 4.3229> <-9.9228, 9.0849, 4.3229> <-9.9421, 9.1042, 4.3229>
		<-9.9455, 8.4284, 4.7283> <-9.9262, 8.4477, 4.7283> <-9.9262, 9.0815, 4.7283> <-9.9455, 9.1008, 4.7283>
		<-9.9436, 8.4265, 5.2689> <-9.9243, 8.4458, 5.2689> <-9.9243, 9.0834, 5.2689> <-9.9436, 9.1027, 5.2689>
		<-9.9421, 8.4250, 5.6744> <-9.9228, 8.4443, 5.6744> <-9.9228, 9.0849, 5.6744> <-9.9421, 9.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 9.1042, 4.3229> <-9.9614, 9.1235, 4.3229> <-10.6020, 9.1235, 4.3229> <-10.6213, 9.1042, 4.3229>
		<-9.9455, 9.1008, 4.7283> <-9.9648, 9.1201, 4.7283> <-10.5986, 9.1201, 4.7283> <-10.6179, 9.1008, 4.7283>
		<-9.9436, 9.1027, 5.2689> <-9.9629, 9.1219, 5.2689> <-10.6004, 9.1219, 5.2689> <-10.6197, 9.1027, 5.2689>
		<-9.9421, 9.1042, 5.6744> <-9.9614, 9.1235, 5.6744> <-10.6020, 9.1235, 5.6744> <-10.6213, 9.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 8.4250, 5.6744> <-10.6225, 8.4237, 6.0073> <-10.6172, 8.4290, 6.4517> <-10.6305, 8.4157, 6.7841>
		<-10.6405, 8.4443, 5.6744> <-10.6418, 8.4430, 6.0073> <-10.6371, 8.4488, 6.4517> <-10.6503, 8.4355, 6.7841>
		<-10.6405, 9.0849, 5.6744> <-10.6418, 9.0861, 6.0073> <-10.6371, 9.0804, 6.4517> <-10.6503, 9.0936, 6.7841>
		<-10.6213, 9.1042, 5.6744> <-10.6225, 9.1054, 6.0073> <-10.6172, 9.1002, 6.4517> <-10.6305, 9.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 8.4250, 5.6744> <-10.6020, 8.4057, 5.6744> <-9.9614, 8.4057, 5.6744> <-9.9421, 8.4250, 5.6744>
		<-10.6225, 8.4237, 6.0073> <-10.6032, 8.4044, 6.0073> <-9.9601, 8.4044, 6.0073> <-9.9408, 8.4237, 6.0073>
		<-10.6172, 8.4290, 6.4517> <-10.5974, 8.4092, 6.4517> <-9.9659, 8.4092, 6.4517> <-9.9461, 8.4290, 6.4517>
		<-10.6305, 8.4157, 6.7841> <-10.6107, 8.3959, 6.7841> <-9.9526, 8.3959, 6.7841> <-9.9328, 8.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 8.4250, 5.6744> <-9.9228, 8.4443, 5.6744> <-9.9228, 9.0849, 5.6744> <-9.9421, 9.1042, 5.6744>
		<-9.9408, 8.4237, 6.0073> <-9.9215, 8.4430, 6.0073> <-9.9215, 9.0861, 6.0073> <-9.9408, 9.1054, 6.0073>
		<-9.9461, 8.4290, 6.4517> <-9.9263, 8.4488, 6.4517> <-9.9263, 9.0804, 6.4517> <-9.9461, 9.1002, 6.4517>
		<-9.9328, 8.4157, 6.7841> <-9.9130, 8.4355, 6.7841> <-9.9130, 9.0936, 6.7841> <-9.9328, 9.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 9.1042, 5.6744> <-9.9614, 9.1235, 5.6744> <-10.6020, 9.1235, 5.6744> <-10.6213, 9.1042, 5.6744>
		<-9.9408, 9.1054, 6.0073> <-9.9601, 9.1247, 6.0073> <-10.6032, 9.1247, 6.0073> <-10.6225, 9.1054, 6.0073>
		<-9.9461, 9.1002, 6.4517> <-9.9659, 9.1200, 6.4517> <-10.5974, 9.1200, 6.4517> <-10.6172, 9.1002, 6.4517>
		<-9.9328, 9.1134, 6.7841> <-9.9526, 9.1333, 6.7841> <-10.6107, 9.1333, 6.7841> <-10.6305, 9.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 8.4157, 6.7841> <-10.6325, 8.4137, 6.8341> <-10.6449, 8.4013, 6.9079> <-10.6718, 8.3745, 6.9405>
		<-10.6503, 8.4355, 6.7841> <-10.6523, 8.4336, 6.8341> <-10.6671, 8.4235, 6.9079> <-10.6940, 8.3966, 6.9405>
		<-10.6503, 9.0936, 6.7841> <-10.6523, 9.0956, 6.8341> <-10.6671, 9.1057, 6.9079> <-10.6940, 9.1326, 6.9405>
		<-10.6305, 9.1134, 6.7841> <-10.6325, 9.1154, 6.8341> <-10.6449, 9.1278, 6.9079> <-10.6718, 9.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 8.4157, 6.7841> <-10.6107, 8.3959, 6.7841> <-9.9526, 8.3959, 6.7841> <-9.9328, 8.4157, 6.7841>
		<-10.6325, 8.4137, 6.8341> <-10.6127, 8.3939, 6.8341> <-9.9506, 8.3939, 6.8341> <-9.9308, 8.4137, 6.8341>
		<-10.6449, 8.4013, 6.9079> <-10.6228, 8.3792, 6.9079> <-9.9406, 8.3792, 6.9079> <-9.9184, 8.4013, 6.9079>
		<-10.6718, 8.3745, 6.9405> <-10.6496, 8.3523, 6.9405> <-9.9137, 8.3523, 6.9405> <-9.8915, 8.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 8.4157, 6.7841> <-9.9130, 8.4355, 6.7841> <-9.9130, 9.0936, 6.7841> <-9.9328, 9.1134, 6.7841>
		<-9.9308, 8.4137, 6.8341> <-9.9110, 8.4336, 6.8341> <-9.9110, 9.0956, 6.8341> <-9.9308, 9.1154, 6.8341>
		<-9.9184, 8.4013, 6.9079> <-9.8962, 8.4235, 6.9079> <-9.8962, 9.1057, 6.9079> <-9.9184, 9.1278, 6.9079>
		<-9.8915, 8.3745, 6.9405> <-9.8694, 8.3966, 6.9405> <-9.8694, 9.1326, 6.9405> <-9.8915, 9.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 9.1134, 6.7841> <-9.9526, 9.1333, 6.7841> <-10.6107, 9.1333, 6.7841> <-10.6305, 9.1134, 6.7841>
		<-9.9308, 9.1154, 6.8341> <-9.9506, 9.1352, 6.8341> <-10.6127, 9.1352, 6.8341> <-10.6325, 9.1154, 6.8341>
		<-9.9184, 9.1278, 6.9079> <-9.9406, 9.1500, 6.9079> <-10.6228, 9.1500, 6.9079> <-10.6449, 9.1278, 6.9079>
		<-9.8915, 9.1547, 6.9405> <-9.9137, 9.1769, 6.9405> <-10.6496, 9.1769, 6.9405> <-10.6718, 9.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 8.3745, 6.9405> <-10.7339, 8.3123, 7.0160> <-10.8620, 8.1842, 7.0331> <-10.9114, 8.1348, 7.1255>
		<-10.6940, 8.3966, 6.9405> <-10.7561, 8.3345, 7.0160> <-10.8978, 8.2200, 7.0331> <-10.9472, 8.1706, 7.1255>
		<-10.6940, 9.1326, 6.9405> <-10.7561, 9.1947, 7.0160> <-10.8978, 9.3092, 7.0331> <-10.9472, 9.3586, 7.1255>
		<-10.6718, 9.1547, 6.9405> <-10.7339, 9.2168, 7.0160> <-10.8620, 9.3449, 7.0331> <-10.9114, 9.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 8.3745, 6.9405> <-10.6496, 8.3523, 6.9405> <-9.9137, 8.3523, 6.9405> <-9.8915, 8.3745, 6.9405>
		<-10.7339, 8.3123, 7.0160> <-10.7117, 8.2902, 7.0160> <-9.8516, 8.2902, 7.0160> <-9.8294, 8.3123, 7.0160>
		<-10.8620, 8.1842, 7.0331> <-10.8262, 8.1485, 7.0331> <-9.7371, 8.1485, 7.0331> <-9.7013, 8.1842, 7.0331>
		<-10.9114, 8.1348, 7.1255> <-10.8757, 8.0990, 7.1255> <-9.6877, 8.0990, 7.1255> <-9.6519, 8.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 8.3745, 6.9405> <-9.8694, 8.3966, 6.9405> <-9.8694, 9.1326, 6.9405> <-9.8915, 9.1547, 6.9405>
		<-9.8294, 8.3123, 7.0160> <-9.8073, 8.3345, 7.0160> <-9.8073, 9.1947, 7.0160> <-9.8294, 9.2168, 7.0160>
		<-9.7013, 8.1842, 7.0331> <-9.6655, 8.2200, 7.0331> <-9.6655, 9.3092, 7.0331> <-9.7013, 9.3449, 7.0331>
		<-9.6519, 8.1348, 7.1255> <-9.6161, 8.1706, 7.1255> <-9.6161, 9.3586, 7.1255> <-9.6519, 9.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 9.1547, 6.9405> <-9.9137, 9.1769, 6.9405> <-10.6496, 9.1769, 6.9405> <-10.6718, 9.1547, 6.9405>
		<-9.8294, 9.2168, 7.0160> <-9.8516, 9.2390, 7.0160> <-10.7117, 9.2390, 7.0160> <-10.7339, 9.2168, 7.0160>
		<-9.7013, 9.3449, 7.0331> <-9.7371, 9.3807, 7.0331> <-10.8262, 9.3807, 7.0331> <-10.8620, 9.3449, 7.0331>
		<-9.6519, 9.3944, 7.1255> <-9.6877, 9.4301, 7.1255> <-10.8757, 9.4301, 7.1255> <-10.9114, 9.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 8.1348, 7.1255> <-10.9319, 8.1143, 7.1638> <-10.8316, 8.2146, 7.1912> <-10.8316, 8.2146, 7.2393>
		<-10.9472, 8.1706, 7.1255> <-10.9677, 8.1501, 7.1638> <-10.8629, 8.2459, 7.1912> <-10.8629, 8.2459, 7.2393>
		<-10.9472, 9.3586, 7.1255> <-10.9677, 9.3791, 7.1638> <-10.8629, 9.2833, 7.1912> <-10.8629, 9.2833, 7.2393>
		<-10.9114, 9.3944, 7.1255> <-10.9319, 9.4149, 7.1638> <-10.8316, 9.3146, 7.1912> <-10.8316, 9.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 8.1348, 7.1255> <-10.8757, 8.0990, 7.1255> <-9.6877, 8.0990, 7.1255> <-9.6519, 8.1348, 7.1255>
		<-10.9319, 8.1143, 7.1638> <-10.8962, 8.0785, 7.1638> <-9.6671, 8.0785, 7.1638> <-9.6314, 8.1143, 7.1638>
		<-10.8316, 8.2146, 7.1912> <-10.8004, 8.1834, 7.1912> <-9.7629, 8.1834, 7.1912> <-9.7317, 8.2146, 7.1912>
		<-10.8316, 8.2146, 7.2393> <-10.8004, 8.1834, 7.2393> <-9.7629, 8.1834, 7.2393> <-9.7317, 8.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 8.1348, 7.1255> <-9.6161, 8.1706, 7.1255> <-9.6161, 9.3586, 7.1255> <-9.6519, 9.3944, 7.1255>
		<-9.6314, 8.1143, 7.1638> <-9.5956, 8.1501, 7.1638> <-9.5956, 9.3791, 7.1638> <-9.6314, 9.4149, 7.1638>
		<-9.7317, 8.2146, 7.1912> <-9.7005, 8.2459, 7.1912> <-9.7005, 9.2833, 7.1912> <-9.7317, 9.3146, 7.1912>
		<-9.7317, 8.2146, 7.2393> <-9.7005, 8.2459, 7.2393> <-9.7005, 9.2833, 7.2393> <-9.7317, 9.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 9.3944, 7.1255> <-9.6877, 9.4301, 7.1255> <-10.8757, 9.4301, 7.1255> <-10.9114, 9.3944, 7.1255>
		<-9.6314, 9.4149, 7.1638> <-9.6671, 9.4506, 7.1638> <-10.8962, 9.4506, 7.1638> <-10.9319, 9.4149, 7.1638>
		<-9.7317, 9.3146, 7.1912> <-9.7629, 9.3458, 7.1912> <-10.8004, 9.3458, 7.1912> <-10.8316, 9.3146, 7.1912>
		<-9.7317, 9.3146, 7.2393> <-9.7629, 9.3458, 7.2393> <-10.8004, 9.3458, 7.2393> <-10.8316, 9.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 8.2146, 7.2393> <-10.8316, 8.2146, 7.2905> <-10.9054, 8.1408, 7.3169> <-10.9114, 8.1348, 7.3673>
		<-10.8629, 8.2459, 7.2393> <-10.8629, 8.2459, 7.2905> <-10.9412, 8.1766, 7.3169> <-10.9472, 8.1706, 7.3673>
		<-10.8629, 9.2833, 7.2393> <-10.8629, 9.2833, 7.2905> <-10.9412, 9.3526, 7.3169> <-10.9472, 9.3586, 7.3673>
		<-10.8316, 9.3146, 7.2393> <-10.8316, 9.3146, 7.2905> <-10.9054, 9.3883, 7.3169> <-10.9114, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 8.2146, 7.2393> <-10.8004, 8.1834, 7.2393> <-9.7629, 8.1834, 7.2393> <-9.7317, 8.2146, 7.2393>
		<-10.8316, 8.2146, 7.2905> <-10.8004, 8.1834, 7.2905> <-9.7629, 8.1834, 7.2905> <-9.7317, 8.2146, 7.2905>
		<-10.9054, 8.1408, 7.3169> <-10.8696, 8.1051, 7.3169> <-9.6937, 8.1051, 7.3169> <-9.6579, 8.1408, 7.3169>
		<-10.9114, 8.1348, 7.3673> <-10.8757, 8.0990, 7.3673> <-9.6877, 8.0990, 7.3673> <-9.6519, 8.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 8.2146, 7.2393> <-9.7005, 8.2459, 7.2393> <-9.7005, 9.2833, 7.2393> <-9.7317, 9.3146, 7.2393>
		<-9.7317, 8.2146, 7.2905> <-9.7005, 8.2459, 7.2905> <-9.7005, 9.2833, 7.2905> <-9.7317, 9.3146, 7.2905>
		<-9.6579, 8.1408, 7.3169> <-9.6222, 8.1766, 7.3169> <-9.6222, 9.3526, 7.3169> <-9.6579, 9.3883, 7.3169>
		<-9.6519, 8.1348, 7.3673> <-9.6161, 8.1706, 7.3673> <-9.6161, 9.3586, 7.3673> <-9.6519, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 9.3146, 7.2393> <-9.7629, 9.3458, 7.2393> <-10.8004, 9.3458, 7.2393> <-10.8316, 9.3146, 7.2393>
		<-9.7317, 9.3146, 7.2905> <-9.7629, 9.3458, 7.2905> <-10.8004, 9.3458, 7.2905> <-10.8316, 9.3146, 7.2905>
		<-9.6579, 9.3883, 7.3169> <-9.6937, 9.4241, 7.3169> <-10.8696, 9.4241, 7.3169> <-10.9054, 9.3883, 7.3169>
		<-9.6519, 9.3944, 7.3673> <-9.6877, 9.4301, 7.3673> <-10.8757, 9.4301, 7.3673> <-10.9114, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 8.1348, 7.9080> <-10.9472, 8.1706, 7.9080> <-10.9472, 9.3586, 7.9080> <-10.9114, 9.3944, 7.9080>
		<-10.9114, 8.1348, 7.7458> <-10.9472, 8.1706, 7.7458> <-10.9472, 9.3586, 7.7458> <-10.9114, 9.3944, 7.7458>
		<-10.9305, 8.1157, 7.5273> <-10.9663, 8.1515, 7.5273> <-10.9663, 9.3777, 7.5273> <-10.9305, 9.4134, 7.5273>
		<-10.9114, 8.1348, 7.3673> <-10.9472, 8.1706, 7.3673> <-10.9472, 9.3586, 7.3673> <-10.9114, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 8.1348, 7.9080> <-10.9114, 8.1348, 7.7458> <-10.9305, 8.1157, 7.5273> <-10.9114, 8.1348, 7.3673>
		<-10.8757, 8.0990, 7.9080> <-10.8757, 8.0990, 7.7458> <-10.8947, 8.0800, 7.5273> <-10.8757, 8.0990, 7.3673>
		<-9.6877, 8.0990, 7.9080> <-9.6877, 8.0990, 7.7458> <-9.6686, 8.0800, 7.5273> <-9.6877, 8.0990, 7.3673>
		<-9.6519, 8.1348, 7.9080> <-9.6519, 8.1348, 7.7458> <-9.6328, 8.1157, 7.5273> <-9.6519, 8.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 8.1348, 7.9080> <-9.6519, 8.1348, 7.7458> <-9.6328, 8.1157, 7.5273> <-9.6519, 8.1348, 7.3673>
		<-9.6161, 8.1706, 7.9080> <-9.6161, 8.1706, 7.7458> <-9.5970, 8.1515, 7.5273> <-9.6161, 8.1706, 7.3673>
		<-9.6161, 9.3586, 7.9080> <-9.6161, 9.3586, 7.7458> <-9.5970, 9.3777, 7.5273> <-9.6161, 9.3586, 7.3673>
		<-9.6519, 9.3944, 7.9080> <-9.6519, 9.3944, 7.7458> <-9.6328, 9.4134, 7.5273> <-9.6519, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 9.3944, 7.9080> <-9.6519, 9.3944, 7.7458> <-9.6328, 9.4134, 7.5273> <-9.6519, 9.3944, 7.3673>
		<-9.6877, 9.4301, 7.9080> <-9.6877, 9.4301, 7.7458> <-9.6686, 9.4492, 7.5273> <-9.6877, 9.4301, 7.3673>
		<-10.8757, 9.4301, 7.9080> <-10.8757, 9.4301, 7.7458> <-10.8947, 9.4492, 7.5273> <-10.8757, 9.4301, 7.3673>
		<-10.9114, 9.3944, 7.9080> <-10.9114, 9.3944, 7.7458> <-10.9305, 9.4134, 7.5273> <-10.9114, 9.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 7.8874, 0.7771> <-11.2087, 7.9372, 0.7771> <-11.2087, 9.5920, 0.7771> <-11.1589, 9.6418, 0.7771>
		<-11.1796, 7.8666, 0.6520> <-11.2294, 7.9164, 0.6520> <-11.2294, 9.6127, 0.6520> <-11.1796, 9.6625, 0.6520>
		<-11.1589, 7.8874, 0.4772> <-11.2087, 7.9372, 0.4772> <-11.2087, 9.5920, 0.4772> <-11.1589, 9.6418, 0.4772>
		<-11.1589, 7.8874, 0.3486> <-11.2087, 7.9372, 0.3486> <-11.2087, 9.5920, 0.3486> <-11.1589, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 7.8874, 0.7771> <-11.1796, 7.8666, 0.6520> <-11.1589, 7.8874, 0.4772> <-11.1589, 7.8874, 0.3486>
		<-11.1090, 7.8376, 0.7771> <-11.1298, 7.8168, 0.6520> <-11.1090, 7.8376, 0.4772> <-11.1090, 7.8376, 0.3486>
		<-9.4543, 7.8376, 0.7771> <-9.4335, 7.8168, 0.6520> <-9.4543, 7.8376, 0.4772> <-9.4543, 7.8376, 0.3486>
		<-9.4045, 7.8874, 0.7771> <-9.3837, 7.8666, 0.6520> <-9.4045, 7.8874, 0.4772> <-9.4045, 7.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 7.8874, 0.7771> <-9.3837, 7.8666, 0.6520> <-9.4045, 7.8874, 0.4772> <-9.4045, 7.8874, 0.3486>
		<-9.3546, 7.9372, 0.7771> <-9.3339, 7.9164, 0.6520> <-9.3546, 7.9372, 0.4772> <-9.3546, 7.9372, 0.3486>
		<-9.3546, 9.5920, 0.7771> <-9.3339, 9.6127, 0.6520> <-9.3546, 9.5920, 0.4772> <-9.3546, 9.5920, 0.3486>
		<-9.4045, 9.6418, 0.7771> <-9.3837, 9.6625, 0.6520> <-9.4045, 9.6418, 0.4772> <-9.4045, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 9.6418, 0.7771> <-9.3837, 9.6625, 0.6520> <-9.4045, 9.6418, 0.4772> <-9.4045, 9.6418, 0.3486>
		<-9.4543, 9.6916, 0.7771> <-9.4335, 9.7124, 0.6520> <-9.4543, 9.6916, 0.4772> <-9.4543, 9.6916, 0.3486>
		<-11.1090, 9.6916, 0.7771> <-11.1298, 9.7124, 0.6520> <-11.1090, 9.6916, 0.4772> <-11.1090, 9.6916, 0.3486>
		<-11.1589, 9.6418, 0.7771> <-11.1796, 9.6625, 0.6520> <-11.1589, 9.6418, 0.4772> <-11.1589, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 7.8874, -0.0618> <-11.1589, 7.8874, 0.0613> <-11.1589, 7.8874, 0.2255> <-11.1589, 7.8874, 0.3486>
		<-11.2087, 7.9372, -0.0618> <-11.2087, 7.9372, 0.0613> <-11.2087, 7.9372, 0.2255> <-11.2087, 7.9372, 0.3486>
		<-11.2087, 9.5920, -0.0618> <-11.2087, 9.5920, 0.0613> <-11.2087, 9.5920, 0.2255> <-11.2087, 9.5920, 0.3486>
		<-11.1589, 9.6418, -0.0618> <-11.1589, 9.6418, 0.0613> <-11.1589, 9.6418, 0.2255> <-11.1589, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 7.8874, -0.0618> <-11.1090, 7.8376, -0.0618> <-9.4543, 7.8376, -0.0618> <-9.4045, 7.8874, -0.0618>
		<-11.1589, 7.8874, 0.0613> <-11.1090, 7.8376, 0.0613> <-9.4543, 7.8376, 0.0613> <-9.4045, 7.8874, 0.0613>
		<-11.1589, 7.8874, 0.2255> <-11.1090, 7.8376, 0.2255> <-9.4543, 7.8376, 0.2255> <-9.4045, 7.8874, 0.2255>
		<-11.1589, 7.8874, 0.3486> <-11.1090, 7.8376, 0.3486> <-9.4543, 7.8376, 0.3486> <-9.4045, 7.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 7.8874, -0.0618> <-9.3546, 7.9372, -0.0618> <-9.3546, 9.5920, -0.0618> <-9.4045, 9.6418, -0.0618>
		<-9.4045, 7.8874, 0.0613> <-9.3546, 7.9372, 0.0613> <-9.3546, 9.5920, 0.0613> <-9.4045, 9.6418, 0.0613>
		<-9.4045, 7.8874, 0.2255> <-9.3546, 7.9372, 0.2255> <-9.3546, 9.5920, 0.2255> <-9.4045, 9.6418, 0.2255>
		<-9.4045, 7.8874, 0.3486> <-9.3546, 7.9372, 0.3486> <-9.3546, 9.5920, 0.3486> <-9.4045, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 9.6418, -0.0618> <-9.4543, 9.6916, -0.0618> <-11.1090, 9.6916, -0.0618> <-11.1589, 9.6418, -0.0618>
		<-9.4045, 9.6418, 0.0613> <-9.4543, 9.6916, 0.0613> <-11.1090, 9.6916, 0.0613> <-11.1589, 9.6418, 0.0613>
		<-9.4045, 9.6418, 0.2255> <-9.4543, 9.6916, 0.2255> <-11.1090, 9.6916, 0.2255> <-11.1589, 9.6418, 0.2255>
		<-9.4045, 9.6418, 0.3486> <-9.4543, 9.6916, 0.3486> <-11.1090, 9.6916, 0.3486> <-11.1589, 9.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 0.9062> <-11.1109, 5.8245, 0.9062> <-11.1109, 7.3047, 0.9062> <-11.0664, 7.3493, 0.9062>
		<-11.0712, 5.7751, 0.8515> <-11.1157, 5.8196, 0.8515> <-11.1157, 7.3095, 0.8515> <-11.0712, 7.3541, 0.8515>
		<-11.1500, 5.6963, 0.8308> <-11.1998, 5.7461, 0.8308> <-11.1998, 7.3831, 0.8308> <-11.1500, 7.4329, 0.8308>
		<-11.1589, 5.6874, 0.7771> <-11.2087, 5.7372, 0.7771> <-11.2087, 7.3920, 0.7771> <-11.1589, 7.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 0.9062> <-11.0620, 5.7842, 0.9557> <-11.1560, 5.6903, 0.9996> <-11.1357, 5.7105, 1.0404>
		<-11.1109, 5.8245, 0.9062> <-11.1066, 5.8288, 0.9557> <-11.2045, 5.7388, 0.9996> <-11.1842, 5.7590, 1.0404>
		<-11.1109, 7.3047, 0.9062> <-11.1066, 7.3004, 0.9557> <-11.2045, 7.3904, 0.9996> <-11.1842, 7.3702, 1.0404>
		<-11.0664, 7.3493, 0.9062> <-11.0620, 7.3449, 0.9557> <-11.1560, 7.4389, 0.9996> <-11.1357, 7.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 0.9062> <-11.0712, 5.7751, 0.8515> <-11.1500, 5.6963, 0.8308> <-11.1589, 5.6874, 0.7771>
		<-11.0218, 5.7353, 0.9062> <-11.0266, 5.7305, 0.8515> <-11.1001, 5.6465, 0.8308> <-11.1090, 5.6376, 0.7771>
		<-9.5415, 5.7353, 0.9062> <-9.5367, 5.7305, 0.8515> <-9.4632, 5.6465, 0.8308> <-9.4543, 5.6376, 0.7771>
		<-9.4970, 5.7799, 0.9062> <-9.4922, 5.7751, 0.8515> <-9.4134, 5.6963, 0.8308> <-9.4045, 5.6874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 0.9062> <-11.0218, 5.7353, 0.9062> <-9.5415, 5.7353, 0.9062> <-9.4970, 5.7799, 0.9062>
		<-11.0620, 5.7842, 0.9557> <-11.0175, 5.7397, 0.9557> <-9.5459, 5.7397, 0.9557> <-9.5013, 5.7842, 0.9557>
		<-11.1560, 5.6903, 0.9996> <-11.1075, 5.6418, 0.9996> <-9.4559, 5.6418, 0.9996> <-9.4073, 5.6903, 0.9996>
		<-11.1357, 5.7105, 1.0404> <-11.0872, 5.6620, 1.0404> <-9.4761, 5.6620, 1.0404> <-9.4276, 5.7105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.7799, 0.9062> <-9.4922, 5.7751, 0.8515> <-9.4134, 5.6963, 0.8308> <-9.4045, 5.6874, 0.7771>
		<-9.4524, 5.8245, 0.9062> <-9.4476, 5.8196, 0.8515> <-9.3635, 5.7461, 0.8308> <-9.3546, 5.7372, 0.7771>
		<-9.4524, 7.3047, 0.9062> <-9.4476, 7.3095, 0.8515> <-9.3635, 7.3831, 0.8308> <-9.3546, 7.3920, 0.7771>
		<-9.4970, 7.3493, 0.9062> <-9.4922, 7.3541, 0.8515> <-9.4134, 7.4329, 0.8308> <-9.4045, 7.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.7799, 0.9062> <-9.4524, 5.8245, 0.9062> <-9.4524, 7.3047, 0.9062> <-9.4970, 7.3493, 0.9062>
		<-9.5013, 5.7842, 0.9557> <-9.4567, 5.8288, 0.9557> <-9.4567, 7.3004, 0.9557> <-9.5013, 7.3449, 0.9557>
		<-9.4073, 5.6903, 0.9996> <-9.3588, 5.7388, 0.9996> <-9.3588, 7.3904, 0.9996> <-9.4073, 7.4389, 0.9996>
		<-9.4276, 5.7105, 1.0404> <-9.3791, 5.7590, 1.0404> <-9.3791, 7.3702, 1.0404> <-9.4276, 7.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.3493, 0.9062> <-9.4922, 7.3541, 0.8515> <-9.4134, 7.4329, 0.8308> <-9.4045, 7.4418, 0.7771>
		<-9.5415, 7.3939, 0.9062> <-9.5367, 7.3987, 0.8515> <-9.4632, 7.4827, 0.8308> <-9.4543, 7.4916, 0.7771>
		<-11.0218, 7.3939, 0.9062> <-11.0266, 7.3987, 0.8515> <-11.1001, 7.4827, 0.8308> <-11.1090, 7.4916, 0.7771>
		<-11.0664, 7.3493, 0.9062> <-11.0712, 7.3541, 0.8515> <-11.1500, 7.4329, 0.8308> <-11.1589, 7.4418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.3493, 0.9062> <-9.5415, 7.3939, 0.9062> <-11.0218, 7.3939, 0.9062> <-11.0664, 7.3493, 0.9062>
		<-9.5013, 7.3449, 0.9557> <-9.5459, 7.3895, 0.9557> <-11.0175, 7.3895, 0.9557> <-11.0620, 7.3449, 0.9557>
		<-9.4073, 7.4389, 0.9996> <-9.4559, 7.4874, 0.9996> <-11.1075, 7.4874, 0.9996> <-11.1560, 7.4389, 0.9996>
		<-9.4276, 7.4187, 1.0404> <-9.4761, 7.4672, 1.0404> <-11.0872, 7.4672, 1.0404> <-11.1357, 7.4187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 5.7105, 1.0404> <-11.0677, 5.7786, 1.1777> <-10.8982, 5.9481, 1.2552> <-10.8269, 6.0193, 1.3892>
		<-11.1842, 5.7590, 1.0404> <-11.1162, 5.8271, 1.1777> <-10.9291, 5.9790, 1.2552> <-10.8579, 6.0503, 1.3892>
		<-11.1842, 7.3702, 1.0404> <-11.1162, 7.3021, 1.1777> <-10.9291, 7.1501, 1.2552> <-10.8579, 7.0789, 1.3892>
		<-11.1357, 7.4187, 1.0404> <-11.0677, 7.3506, 1.1777> <-10.8982, 7.1811, 1.2552> <-10.8269, 7.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 5.7105, 1.0404> <-11.0872, 5.6620, 1.0404> <-9.4761, 5.6620, 1.0404> <-9.4276, 5.7105, 1.0404>
		<-11.0677, 5.7786, 1.1777> <-11.0192, 5.7301, 1.1777> <-9.5442, 5.7301, 1.1777> <-9.4957, 5.7786, 1.1777>
		<-10.8982, 5.9481, 1.2552> <-10.8672, 5.9171, 1.2552> <-9.6961, 5.9171, 1.2552> <-9.6652, 5.9481, 1.2552>
		<-10.8269, 6.0193, 1.3892> <-10.7959, 5.9884, 1.3892> <-9.7674, 5.9884, 1.3892> <-9.7364, 6.0193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 5.7105, 1.0404> <-9.3791, 5.7590, 1.0404> <-9.3791, 7.3702, 1.0404> <-9.4276, 7.4187, 1.0404>
		<-9.4957, 5.7786, 1.1777> <-9.4471, 5.8271, 1.1777> <-9.4471, 7.3021, 1.1777> <-9.4957, 7.3506, 1.1777>
		<-9.6652, 5.9481, 1.2552> <-9.6342, 5.9790, 1.2552> <-9.6342, 7.1501, 1.2552> <-9.6652, 7.1811, 1.2552>
		<-9.7364, 6.0193, 1.3892> <-9.7054, 6.0503, 1.3892> <-9.7054, 7.0789, 1.3892> <-9.7364, 7.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 7.4187, 1.0404> <-9.4761, 7.4672, 1.0404> <-11.0872, 7.4672, 1.0404> <-11.1357, 7.4187, 1.0404>
		<-9.4957, 7.3506, 1.1777> <-9.5442, 7.3991, 1.1777> <-11.0192, 7.3991, 1.1777> <-11.0677, 7.3506, 1.1777>
		<-9.6652, 7.1811, 1.2552> <-9.6961, 7.2121, 1.2552> <-10.8672, 7.2121, 1.2552> <-10.8982, 7.1811, 1.2552>
		<-9.7364, 7.1098, 1.3892> <-9.7674, 7.1408, 1.3892> <-10.7959, 7.1408, 1.3892> <-10.8269, 7.1098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 6.0193, 1.3892> <-10.8079, 6.0383, 1.4249> <-10.8837, 5.9626, 1.4698> <-10.8837, 5.9626, 1.5144>
		<-10.8579, 6.0503, 1.3892> <-10.8389, 6.0693, 1.4249> <-10.9179, 5.9968, 1.4698> <-10.9179, 5.9968, 1.5144>
		<-10.8579, 7.0789, 1.3892> <-10.8389, 7.0599, 1.4249> <-10.9179, 7.1324, 1.4698> <-10.9179, 7.1324, 1.5144>
		<-10.8269, 7.1098, 1.3892> <-10.8079, 7.0909, 1.4249> <-10.8837, 7.1666, 1.4698> <-10.8837, 7.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 6.0193, 1.3892> <-10.7959, 5.9884, 1.3892> <-9.7674, 5.9884, 1.3892> <-9.7364, 6.0193, 1.3892>
		<-10.8079, 6.0383, 1.4249> <-10.7770, 6.0073, 1.4249> <-9.7863, 6.0073, 1.4249> <-9.7554, 6.0383, 1.4249>
		<-10.8837, 5.9626, 1.4698> <-10.8495, 5.9284, 1.4698> <-9.7138, 5.9284, 1.4698> <-9.6796, 5.9626, 1.4698>
		<-10.8837, 5.9626, 1.5144> <-10.8495, 5.9284, 1.5144> <-9.7138, 5.9284, 1.5144> <-9.6796, 5.9626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 6.0193, 1.3892> <-9.7054, 6.0503, 1.3892> <-9.7054, 7.0789, 1.3892> <-9.7364, 7.1098, 1.3892>
		<-9.7554, 6.0383, 1.4249> <-9.7244, 6.0693, 1.4249> <-9.7244, 7.0599, 1.4249> <-9.7554, 7.0909, 1.4249>
		<-9.6796, 5.9626, 1.4698> <-9.6455, 5.9968, 1.4698> <-9.6455, 7.1324, 1.4698> <-9.6796, 7.1666, 1.4698>
		<-9.6796, 5.9626, 1.5144> <-9.6455, 5.9968, 1.5144> <-9.6455, 7.1324, 1.5144> <-9.6796, 7.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 7.1098, 1.3892> <-9.7674, 7.1408, 1.3892> <-10.7959, 7.1408, 1.3892> <-10.8269, 7.1098, 1.3892>
		<-9.7554, 7.0909, 1.4249> <-9.7863, 7.1218, 1.4249> <-10.7770, 7.1218, 1.4249> <-10.8079, 7.0909, 1.4249>
		<-9.6796, 7.1666, 1.4698> <-9.7138, 7.2008, 1.4698> <-10.8495, 7.2008, 1.4698> <-10.8837, 7.1666, 1.4698>
		<-9.6796, 7.1666, 1.5144> <-9.7138, 7.2008, 1.5144> <-10.8495, 7.2008, 1.5144> <-10.8837, 7.1666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 5.9626, 1.5144> <-10.8837, 5.9626, 1.5613> <-10.8121, 6.0341, 1.6066> <-10.8269, 6.0193, 1.6486>
		<-10.9179, 5.9968, 1.5144> <-10.9179, 5.9968, 1.5613> <-10.8431, 6.0651, 1.6066> <-10.8579, 6.0503, 1.6486>
		<-10.9179, 7.1324, 1.5144> <-10.9179, 7.1324, 1.5613> <-10.8431, 7.0641, 1.6066> <-10.8579, 7.0789, 1.6486>
		<-10.8837, 7.1666, 1.5144> <-10.8837, 7.1666, 1.5613> <-10.8121, 7.0950, 1.6066> <-10.8269, 7.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 5.9626, 1.5144> <-10.8495, 5.9284, 1.5144> <-9.7138, 5.9284, 1.5144> <-9.6796, 5.9626, 1.5144>
		<-10.8837, 5.9626, 1.5613> <-10.8495, 5.9284, 1.5613> <-9.7138, 5.9284, 1.5613> <-9.6796, 5.9626, 1.5613>
		<-10.8121, 6.0341, 1.6066> <-10.7812, 6.0032, 1.6066> <-9.7822, 6.0032, 1.6066> <-9.7512, 6.0341, 1.6066>
		<-10.8269, 6.0193, 1.6486> <-10.7959, 5.9884, 1.6486> <-9.7674, 5.9884, 1.6486> <-9.7364, 6.0193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 5.9626, 1.5144> <-9.6455, 5.9968, 1.5144> <-9.6455, 7.1324, 1.5144> <-9.6796, 7.1666, 1.5144>
		<-9.6796, 5.9626, 1.5613> <-9.6455, 5.9968, 1.5613> <-9.6455, 7.1324, 1.5613> <-9.6796, 7.1666, 1.5613>
		<-9.7512, 6.0341, 1.6066> <-9.7202, 6.0651, 1.6066> <-9.7202, 7.0641, 1.6066> <-9.7512, 7.0950, 1.6066>
		<-9.7364, 6.0193, 1.6486> <-9.7054, 6.0503, 1.6486> <-9.7054, 7.0789, 1.6486> <-9.7364, 7.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 7.1666, 1.5144> <-9.7138, 7.2008, 1.5144> <-10.8495, 7.2008, 1.5144> <-10.8837, 7.1666, 1.5144>
		<-9.6796, 7.1666, 1.5613> <-9.7138, 7.2008, 1.5613> <-10.8495, 7.2008, 1.5613> <-10.8837, 7.1666, 1.5613>
		<-9.7512, 7.0950, 1.6066> <-9.7822, 7.1260, 1.6066> <-10.7812, 7.1260, 1.6066> <-10.8121, 7.0950, 1.6066>
		<-9.7364, 7.1098, 1.6486> <-9.7674, 7.1408, 1.6486> <-10.7959, 7.1408, 1.6486> <-10.8269, 7.1098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 6.0193, 1.6486> <-10.8754, 5.9709, 1.7862> <-11.0172, 5.8290, 1.8960> <-11.0664, 5.7799, 2.0332>
		<-10.8579, 6.0503, 1.6486> <-10.9063, 6.0018, 1.7862> <-11.0618, 5.8736, 1.8960> <-11.1109, 5.8245, 2.0332>
		<-10.8579, 7.0789, 1.6486> <-10.9063, 7.1273, 1.7862> <-11.0618, 7.2556, 1.8960> <-11.1109, 7.3047, 2.0332>
		<-10.8269, 7.1098, 1.6486> <-10.8754, 7.1583, 1.7862> <-11.0172, 7.3002, 1.8960> <-11.0664, 7.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 6.0193, 1.6486> <-10.7959, 5.9884, 1.6486> <-9.7674, 5.9884, 1.6486> <-9.7364, 6.0193, 1.6486>
		<-10.8754, 5.9709, 1.7862> <-10.8444, 5.9399, 1.7862> <-9.7189, 5.9399, 1.7862> <-9.6880, 5.9709, 1.7862>
		<-11.0172, 5.8290, 1.8960> <-10.9727, 5.7844, 1.8960> <-9.5907, 5.7844, 1.8960> <-9.5461, 5.8290, 1.8960>
		<-11.0664, 5.7799, 2.0332> <-11.0218, 5.7353, 2.0332> <-9.5415, 5.7353, 2.0332> <-9.4970, 5.7799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 6.0193, 1.6486> <-9.7054, 6.0503, 1.6486> <-9.7054, 7.0789, 1.6486> <-9.7364, 7.1098, 1.6486>
		<-9.6880, 5.9709, 1.7862> <-9.6570, 6.0018, 1.7862> <-9.6570, 7.1273, 1.7862> <-9.6880, 7.1583, 1.7862>
		<-9.5461, 5.8290, 1.8960> <-9.5015, 5.8736, 1.8960> <-9.5015, 7.2556, 1.8960> <-9.5461, 7.3002, 1.8960>
		<-9.4970, 5.7799, 2.0332> <-9.4524, 5.8245, 2.0332> <-9.4524, 7.3047, 2.0332> <-9.4970, 7.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 7.1098, 1.6486> <-9.7674, 7.1408, 1.6486> <-10.7959, 7.1408, 1.6486> <-10.8269, 7.1098, 1.6486>
		<-9.6880, 7.1583, 1.7862> <-9.7189, 7.1893, 1.7862> <-10.8444, 7.1893, 1.7862> <-10.8754, 7.1583, 1.7862>
		<-9.5461, 7.3002, 1.8960> <-9.5907, 7.3447, 1.8960> <-10.9727, 7.3447, 1.8960> <-11.0172, 7.3002, 1.8960>
		<-9.4970, 7.3493, 2.0332> <-9.5415, 7.3939, 2.0332> <-11.0218, 7.3939, 2.0332> <-11.0664, 7.3493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 2.0332> <-11.0930, 5.7533, 2.1074> <-11.0932, 5.7531, 2.2382> <-11.0641, 5.7822, 2.3104>
		<-11.1109, 5.8245, 2.0332> <-11.1375, 5.7979, 2.1074> <-11.1376, 5.7975, 2.2382> <-11.1085, 5.8266, 2.3104>
		<-11.1109, 7.3047, 2.0332> <-11.1375, 7.3313, 2.1074> <-11.1376, 7.3317, 2.2382> <-11.1085, 7.3025, 2.3104>
		<-11.0664, 7.3493, 2.0332> <-11.0930, 7.3759, 2.1074> <-11.0932, 7.3761, 2.2382> <-11.0641, 7.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 5.7799, 2.0332> <-11.0218, 5.7353, 2.0332> <-9.5415, 5.7353, 2.0332> <-9.4970, 5.7799, 2.0332>
		<-11.0930, 5.7533, 2.1074> <-11.0484, 5.7087, 2.1074> <-9.5149, 5.7087, 2.1074> <-9.4704, 5.7533, 2.1074>
		<-11.0932, 5.7531, 2.2382> <-11.0488, 5.7086, 2.2382> <-9.5146, 5.7086, 2.2382> <-9.4701, 5.7531, 2.2382>
		<-11.0641, 5.7822, 2.3104> <-11.0196, 5.7378, 2.3104> <-9.5437, 5.7378, 2.3104> <-9.4993, 5.7822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.7799, 2.0332> <-9.4524, 5.8245, 2.0332> <-9.4524, 7.3047, 2.0332> <-9.4970, 7.3493, 2.0332>
		<-9.4704, 5.7533, 2.1074> <-9.4258, 5.7979, 2.1074> <-9.4258, 7.3313, 2.1074> <-9.4704, 7.3759, 2.1074>
		<-9.4701, 5.7531, 2.2382> <-9.4257, 5.7975, 2.2382> <-9.4257, 7.3317, 2.2382> <-9.4701, 7.3761, 2.2382>
		<-9.4993, 5.7822, 2.3104> <-9.4548, 5.8266, 2.3104> <-9.4548, 7.3025, 2.3104> <-9.4993, 7.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 7.3493, 2.0332> <-9.5415, 7.3939, 2.0332> <-11.0218, 7.3939, 2.0332> <-11.0664, 7.3493, 2.0332>
		<-9.4704, 7.3759, 2.1074> <-9.5149, 7.4204, 2.1074> <-11.0484, 7.4204, 2.1074> <-11.0930, 7.3759, 2.1074>
		<-9.4701, 7.3761, 2.2382> <-9.5146, 7.4206, 2.2382> <-11.0488, 7.4206, 2.2382> <-11.0932, 7.3761, 2.2382>
		<-9.4993, 7.3470, 2.3104> <-9.5437, 7.3914, 2.3104> <-11.0196, 7.3914, 2.3104> <-11.0641, 7.3470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 5.7822, 2.3104> <-10.9801, 5.8661, 2.5186> <-10.7843, 6.0620, 2.7154> <-10.7056, 6.1406, 2.9276>
		<-11.1085, 5.8266, 2.3104> <-11.0246, 5.9106, 2.5186> <-10.8084, 6.0860, 2.7154> <-10.7297, 6.1647, 2.9276>
		<-11.1085, 7.3025, 2.3104> <-11.0246, 7.2186, 2.5186> <-10.8084, 7.0431, 2.7154> <-10.7297, 6.9645, 2.9276>
		<-11.0641, 7.3470, 2.3104> <-10.9801, 7.2630, 2.5186> <-10.7843, 7.0672, 2.7154> <-10.7056, 6.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 5.7822, 2.3104> <-11.0196, 5.7378, 2.3104> <-9.5437, 5.7378, 2.3104> <-9.4993, 5.7822, 2.3104>
		<-10.9801, 5.8661, 2.5186> <-10.9357, 5.8217, 2.5186> <-9.6277, 5.8217, 2.5186> <-9.5832, 5.8661, 2.5186>
		<-10.7843, 6.0620, 2.7154> <-10.7602, 6.0379, 2.7154> <-9.8031, 6.0379, 2.7154> <-9.7790, 6.0620, 2.7154>
		<-10.7056, 6.1406, 2.9276> <-10.6815, 6.1165, 2.9276> <-9.8818, 6.1165, 2.9276> <-9.8577, 6.1406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 5.7822, 2.3104> <-9.4548, 5.8266, 2.3104> <-9.4548, 7.3025, 2.3104> <-9.4993, 7.3470, 2.3104>
		<-9.5832, 5.8661, 2.5186> <-9.5388, 5.9106, 2.5186> <-9.5388, 7.2186, 2.5186> <-9.5832, 7.2630, 2.5186>
		<-9.7790, 6.0620, 2.7154> <-9.7550, 6.0860, 2.7154> <-9.7550, 7.0431, 2.7154> <-9.7790, 7.0672, 2.7154>
		<-9.8577, 6.1406, 2.9276> <-9.8336, 6.1647, 2.9276> <-9.8336, 6.9645, 2.9276> <-9.8577, 6.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 7.3470, 2.3104> <-9.5437, 7.3914, 2.3104> <-11.0196, 7.3914, 2.3104> <-11.0641, 7.3470, 2.3104>
		<-9.5832, 7.2630, 2.5186> <-9.6277, 7.3075, 2.5186> <-10.9357, 7.3075, 2.5186> <-10.9801, 7.2630, 2.5186>
		<-9.7790, 7.0672, 2.7154> <-9.8031, 7.0913, 2.7154> <-10.7602, 7.0913, 2.7154> <-10.7843, 7.0672, 2.7154>
		<-9.8577, 6.9885, 2.9276> <-9.8818, 7.0126, 2.9276> <-10.6815, 7.0126, 2.9276> <-10.7056, 6.9885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 6.1406, 2.9276> <-10.6887, 6.1576, 2.9732> <-10.7889, 6.0574, 3.0012> <-10.7889, 6.0574, 3.0528>
		<-10.7297, 6.1647, 2.9276> <-10.7128, 6.1816, 2.9732> <-10.8177, 6.0862, 3.0012> <-10.8177, 6.0862, 3.0528>
		<-10.7297, 6.9645, 2.9276> <-10.7128, 6.9475, 2.9732> <-10.8177, 7.0430, 3.0012> <-10.8177, 7.0430, 3.0528>
		<-10.7056, 6.9885, 2.9276> <-10.6887, 6.9716, 2.9732> <-10.7889, 7.0718, 3.0012> <-10.7889, 7.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 6.1406, 2.9276> <-10.6815, 6.1165, 2.9276> <-9.8818, 6.1165, 2.9276> <-9.8577, 6.1406, 2.9276>
		<-10.6887, 6.1576, 2.9732> <-10.6646, 6.1335, 2.9732> <-9.8987, 6.1335, 2.9732> <-9.8746, 6.1576, 2.9732>
		<-10.7889, 6.0574, 3.0012> <-10.7601, 6.0286, 3.0012> <-9.8033, 6.0286, 3.0012> <-9.7745, 6.0574, 3.0012>
		<-10.7889, 6.0574, 3.0528> <-10.7601, 6.0286, 3.0528> <-9.8033, 6.0286, 3.0528> <-9.7745, 6.0574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 6.1406, 2.9276> <-9.8336, 6.1647, 2.9276> <-9.8336, 6.9645, 2.9276> <-9.8577, 6.9885, 2.9276>
		<-9.8746, 6.1576, 2.9732> <-9.8506, 6.1816, 2.9732> <-9.8506, 6.9475, 2.9732> <-9.8746, 6.9716, 2.9732>
		<-9.7745, 6.0574, 3.0012> <-9.7456, 6.0862, 3.0012> <-9.7456, 7.0430, 3.0012> <-9.7745, 7.0718, 3.0012>
		<-9.7745, 6.0574, 3.0528> <-9.7456, 6.0862, 3.0528> <-9.7456, 7.0430, 3.0528> <-9.7745, 7.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 6.9885, 2.9276> <-9.8818, 7.0126, 2.9276> <-10.6815, 7.0126, 2.9276> <-10.7056, 6.9885, 2.9276>
		<-9.8746, 6.9716, 2.9732> <-9.8987, 6.9957, 2.9732> <-10.6646, 6.9957, 2.9732> <-10.6887, 6.9716, 2.9732>
		<-9.7745, 7.0718, 3.0012> <-9.8033, 7.1006, 3.0012> <-10.7601, 7.1006, 3.0012> <-10.7889, 7.0718, 3.0012>
		<-9.7745, 7.0718, 3.0528> <-9.8033, 7.1006, 3.0528> <-10.7601, 7.1006, 3.0528> <-10.7889, 7.0718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 6.0574, 3.0528> <-10.7889, 6.0574, 3.1044> <-10.6862, 6.1600, 3.1344> <-10.7056, 6.1406, 3.1780>
		<-10.8177, 6.0862, 3.0528> <-10.8177, 6.0862, 3.1044> <-10.7103, 6.1841, 3.1344> <-10.7297, 6.1647, 3.1780>
		<-10.8177, 7.0430, 3.0528> <-10.8177, 7.0430, 3.1044> <-10.7103, 6.9451, 3.1344> <-10.7297, 6.9645, 3.1780>
		<-10.7889, 7.0718, 3.0528> <-10.7889, 7.0718, 3.1044> <-10.6862, 6.9691, 3.1344> <-10.7056, 6.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 6.0574, 3.0528> <-10.7601, 6.0286, 3.0528> <-9.8033, 6.0286, 3.0528> <-9.7745, 6.0574, 3.0528>
		<-10.7889, 6.0574, 3.1044> <-10.7601, 6.0286, 3.1044> <-9.8033, 6.0286, 3.1044> <-9.7745, 6.0574, 3.1044>
		<-10.6862, 6.1600, 3.1344> <-10.6621, 6.1360, 3.1344> <-9.9012, 6.1360, 3.1344> <-9.8771, 6.1600, 3.1344>
		<-10.7056, 6.1406, 3.1780> <-10.6815, 6.1165, 3.1780> <-9.8818, 6.1165, 3.1780> <-9.8577, 6.1406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 6.0574, 3.0528> <-9.7456, 6.0862, 3.0528> <-9.7456, 7.0430, 3.0528> <-9.7745, 7.0718, 3.0528>
		<-9.7745, 6.0574, 3.1044> <-9.7456, 6.0862, 3.1044> <-9.7456, 7.0430, 3.1044> <-9.7745, 7.0718, 3.1044>
		<-9.8771, 6.1600, 3.1344> <-9.8530, 6.1841, 3.1344> <-9.8530, 6.9451, 3.1344> <-9.8771, 6.9691, 3.1344>
		<-9.8577, 6.1406, 3.1780> <-9.8336, 6.1647, 3.1780> <-9.8336, 6.9645, 3.1780> <-9.8577, 6.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 7.0718, 3.0528> <-9.8033, 7.1006, 3.0528> <-10.7601, 7.1006, 3.0528> <-10.7889, 7.0718, 3.0528>
		<-9.7745, 7.0718, 3.1044> <-9.8033, 7.1006, 3.1044> <-10.7601, 7.1006, 3.1044> <-10.7889, 7.0718, 3.1044>
		<-9.8771, 6.9691, 3.1344> <-9.9012, 6.9932, 3.1344> <-10.6621, 6.9932, 3.1344> <-10.6862, 6.9691, 3.1344>
		<-9.8577, 6.9885, 3.1780> <-9.8818, 7.0126, 3.1780> <-10.6815, 7.0126, 3.1780> <-10.7056, 6.9885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 6.1406, 3.1780> <-10.7438, 6.1024, 3.2640> <-10.8610, 5.9852, 3.2738> <-10.9161, 5.9302, 3.3390>
		<-10.7297, 6.1647, 3.1780> <-10.7679, 6.1265, 3.2640> <-10.8971, 6.0212, 3.2738> <-10.9521, 5.9662, 3.3390>
		<-10.7297, 6.9645, 3.1780> <-10.7679, 7.0027, 3.2640> <-10.8971, 7.1079, 3.2738> <-10.9521, 7.1629, 3.3390>
		<-10.7056, 6.9885, 3.1780> <-10.7438, 7.0267, 3.2640> <-10.8610, 7.1440, 3.2738> <-10.9161, 7.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 6.1406, 3.1780> <-10.6815, 6.1165, 3.1780> <-9.8818, 6.1165, 3.1780> <-9.8577, 6.1406, 3.1780>
		<-10.7438, 6.1024, 3.2640> <-10.7197, 6.0784, 3.2640> <-9.8436, 6.0784, 3.2640> <-9.8195, 6.1024, 3.2640>
		<-10.8610, 5.9852, 3.2738> <-10.8250, 5.9492, 3.2738> <-9.7383, 5.9492, 3.2738> <-9.7023, 5.9852, 3.2738>
		<-10.9161, 5.9302, 3.3390> <-10.8800, 5.8942, 3.3390> <-9.6833, 5.8942, 3.3390> <-9.6473, 5.9302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 6.1406, 3.1780> <-9.8336, 6.1647, 3.1780> <-9.8336, 6.9645, 3.1780> <-9.8577, 6.9885, 3.1780>
		<-9.8195, 6.1024, 3.2640> <-9.7954, 6.1265, 3.2640> <-9.7954, 7.0027, 3.2640> <-9.8195, 7.0267, 3.2640>
		<-9.7023, 5.9852, 3.2738> <-9.6663, 6.0212, 3.2738> <-9.6663, 7.1079, 3.2738> <-9.7023, 7.1440, 3.2738>
		<-9.6473, 5.9302, 3.3390> <-9.6112, 5.9662, 3.3390> <-9.6112, 7.1629, 3.3390> <-9.6473, 7.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 6.9885, 3.1780> <-9.8818, 7.0126, 3.1780> <-10.6815, 7.0126, 3.1780> <-10.7056, 6.9885, 3.1780>
		<-9.8195, 7.0267, 3.2640> <-9.8436, 7.0508, 3.2640> <-10.7197, 7.0508, 3.2640> <-10.7438, 7.0267, 3.2640>
		<-9.7023, 7.1440, 3.2738> <-9.7383, 7.1800, 3.2738> <-10.8250, 7.1800, 3.2738> <-10.8610, 7.1440, 3.2738>
		<-9.6473, 7.1990, 3.3390> <-9.6833, 7.2350, 3.3390> <-10.8800, 7.2350, 3.3390> <-10.9161, 7.1990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 5.9302, 3.3390> <-10.9416, 5.9046, 3.3693> <-10.9797, 5.8665, 3.4419> <-10.9623, 5.8839, 3.4821>
		<-10.9521, 5.9662, 3.3390> <-10.9777, 5.9406, 3.3693> <-11.0184, 5.9052, 3.4419> <-11.0010, 5.9226, 3.4821>
		<-10.9521, 7.1629, 3.3390> <-10.9777, 7.1885, 3.3693> <-11.0184, 7.2240, 3.4419> <-11.0010, 7.2066, 3.4821>
		<-10.9161, 7.1990, 3.3390> <-10.9416, 7.2246, 3.3693> <-10.9797, 7.2627, 3.4419> <-10.9623, 7.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 5.9302, 3.3390> <-10.8800, 5.8942, 3.3390> <-9.6833, 5.8942, 3.3390> <-9.6473, 5.9302, 3.3390>
		<-10.9416, 5.9046, 3.3693> <-10.9056, 5.8686, 3.3693> <-9.6577, 5.8686, 3.3693> <-9.6217, 5.9046, 3.3693>
		<-10.9797, 5.8665, 3.4419> <-10.9411, 5.8279, 3.4419> <-9.6223, 5.8279, 3.4419> <-9.5836, 5.8665, 3.4419>
		<-10.9623, 5.8839, 3.4821> <-10.9236, 5.8453, 3.4821> <-9.6397, 5.8453, 3.4821> <-9.6010, 5.8839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 5.9302, 3.3390> <-9.6112, 5.9662, 3.3390> <-9.6112, 7.1629, 3.3390> <-9.6473, 7.1990, 3.3390>
		<-9.6217, 5.9046, 3.3693> <-9.5857, 5.9406, 3.3693> <-9.5857, 7.1885, 3.3693> <-9.6217, 7.2246, 3.3693>
		<-9.5836, 5.8665, 3.4419> <-9.5449, 5.9052, 3.4419> <-9.5449, 7.2240, 3.4419> <-9.5836, 7.2627, 3.4419>
		<-9.6010, 5.8839, 3.4821> <-9.5624, 5.9226, 3.4821> <-9.5624, 7.2066, 3.4821> <-9.6010, 7.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 7.1990, 3.3390> <-9.6833, 7.2350, 3.3390> <-10.8800, 7.2350, 3.3390> <-10.9161, 7.1990, 3.3390>
		<-9.6217, 7.2246, 3.3693> <-9.6577, 7.2606, 3.3693> <-10.9056, 7.2606, 3.3693> <-10.9416, 7.2246, 3.3693>
		<-9.5836, 7.2627, 3.4419> <-9.6223, 7.3013, 3.4419> <-10.9411, 7.3013, 3.4419> <-10.9797, 7.2627, 3.4419>
		<-9.6010, 7.2452, 3.4821> <-9.6397, 7.2839, 3.4821> <-10.9236, 7.2839, 3.4821> <-10.9623, 7.2452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 5.8839, 3.4821> <-10.9163, 5.9300, 3.5884> <-10.7961, 6.0502, 3.6567> <-10.7380, 6.1083, 3.7504>
		<-11.0010, 5.9226, 3.4821> <-10.9550, 5.9686, 3.5884> <-10.8220, 6.0761, 3.6567> <-10.7639, 6.1342, 3.7504>
		<-11.0010, 7.2066, 3.4821> <-10.9550, 7.1606, 3.5884> <-10.8220, 7.0531, 3.6567> <-10.7639, 6.9950, 3.7504>
		<-10.9623, 7.2452, 3.4821> <-10.9163, 7.1992, 3.5884> <-10.7961, 7.0790, 3.6567> <-10.7380, 7.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 5.8839, 3.4821> <-10.9236, 5.8453, 3.4821> <-9.6397, 5.8453, 3.4821> <-9.6010, 5.8839, 3.4821>
		<-10.9163, 5.9300, 3.5884> <-10.8776, 5.8913, 3.5884> <-9.6857, 5.8913, 3.5884> <-9.6470, 5.9300, 3.5884>
		<-10.7961, 6.0502, 3.6567> <-10.7702, 6.0242, 3.6567> <-9.7932, 6.0242, 3.6567> <-9.7672, 6.0502, 3.6567>
		<-10.7380, 6.1083, 3.7504> <-10.7121, 6.0823, 3.7504> <-9.8513, 6.0823, 3.7504> <-9.8253, 6.1083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 5.8839, 3.4821> <-9.5624, 5.9226, 3.4821> <-9.5624, 7.2066, 3.4821> <-9.6010, 7.2452, 3.4821>
		<-9.6470, 5.9300, 3.5884> <-9.6084, 5.9686, 3.5884> <-9.6084, 7.1606, 3.5884> <-9.6470, 7.1992, 3.5884>
		<-9.7672, 6.0502, 3.6567> <-9.7413, 6.0761, 3.6567> <-9.7413, 7.0531, 3.6567> <-9.7672, 7.0790, 3.6567>
		<-9.8253, 6.1083, 3.7504> <-9.7994, 6.1342, 3.7504> <-9.7994, 6.9950, 3.7504> <-9.8253, 7.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 7.2452, 3.4821> <-9.6397, 7.2839, 3.4821> <-10.9236, 7.2839, 3.4821> <-10.9623, 7.2452, 3.4821>
		<-9.6470, 7.1992, 3.5884> <-9.6857, 7.2379, 3.5884> <-10.8776, 7.2379, 3.5884> <-10.9163, 7.1992, 3.5884>
		<-9.7672, 7.0790, 3.6567> <-9.7932, 7.1049, 3.6567> <-10.7702, 7.1049, 3.6567> <-10.7961, 7.0790, 3.6567>
		<-9.8253, 7.0209, 3.7504> <-9.8513, 7.0468, 3.7504> <-10.7121, 7.0468, 3.7504> <-10.7380, 7.0209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 6.1083, 3.7504> <-10.6964, 6.1498, 3.8175> <-10.6527, 6.1935, 3.9241> <-10.6352, 6.2110, 4.0098>
		<-10.7639, 6.1342, 3.7504> <-10.7223, 6.1757, 3.8175> <-10.6728, 6.2136, 3.9241> <-10.6553, 6.2311, 4.0098>
		<-10.7639, 6.9950, 3.7504> <-10.7223, 6.9534, 3.8175> <-10.6728, 6.9156, 3.9241> <-10.6553, 6.8981, 4.0098>
		<-10.7380, 7.0209, 3.7504> <-10.6964, 6.9793, 3.8175> <-10.6527, 6.9356, 3.9241> <-10.6352, 6.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 6.1083, 3.7504> <-10.7121, 6.0823, 3.7504> <-9.8513, 6.0823, 3.7504> <-9.8253, 6.1083, 3.7504>
		<-10.6964, 6.1498, 3.8175> <-10.6705, 6.1239, 3.8175> <-9.8928, 6.1239, 3.8175> <-9.8669, 6.1498, 3.8175>
		<-10.6527, 6.1935, 3.9241> <-10.6326, 6.1734, 3.9241> <-9.9307, 6.1734, 3.9241> <-9.9106, 6.1935, 3.9241>
		<-10.6352, 6.2110, 4.0098> <-10.6152, 6.1909, 4.0098> <-9.9482, 6.1909, 4.0098> <-9.9281, 6.2110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 6.1083, 3.7504> <-9.7994, 6.1342, 3.7504> <-9.7994, 6.9950, 3.7504> <-9.8253, 7.0209, 3.7504>
		<-9.8669, 6.1498, 3.8175> <-9.8410, 6.1757, 3.8175> <-9.8410, 6.9534, 3.8175> <-9.8669, 6.9793, 3.8175>
		<-9.9106, 6.1935, 3.9241> <-9.8905, 6.2136, 3.9241> <-9.8905, 6.9156, 3.9241> <-9.9106, 6.9356, 3.9241>
		<-9.9281, 6.2110, 4.0098> <-9.9080, 6.2311, 4.0098> <-9.9080, 6.8981, 4.0098> <-9.9281, 6.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 7.0209, 3.7504> <-9.8513, 7.0468, 3.7504> <-10.7121, 7.0468, 3.7504> <-10.7380, 7.0209, 3.7504>
		<-9.8669, 6.9793, 3.8175> <-9.8928, 7.0053, 3.8175> <-10.6705, 7.0053, 3.8175> <-10.6964, 6.9793, 3.8175>
		<-9.9106, 6.9356, 3.9241> <-9.9307, 6.9557, 3.9241> <-10.6326, 6.9557, 3.9241> <-10.6527, 6.9356, 3.9241>
		<-9.9281, 6.9182, 4.0098> <-9.9482, 6.9383, 4.0098> <-10.6152, 6.9383, 4.0098> <-10.6352, 6.9182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 6.2110, 4.0098> <-10.6168, 6.2294, 4.1002> <-10.6221, 6.2242, 4.2288> <-10.6213, 6.2250, 4.3229>
		<-10.6553, 6.2311, 4.0098> <-10.6369, 6.2495, 4.1002> <-10.6413, 6.2435, 4.2288> <-10.6405, 6.2443, 4.3229>
		<-10.6553, 6.8981, 4.0098> <-10.6369, 6.8797, 4.1002> <-10.6413, 6.8857, 4.2288> <-10.6405, 6.8849, 4.3229>
		<-10.6352, 6.9182, 4.0098> <-10.6168, 6.8997, 4.1002> <-10.6221, 6.9050, 4.2288> <-10.6213, 6.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 6.2110, 4.0098> <-10.6152, 6.1909, 4.0098> <-9.9482, 6.1909, 4.0098> <-9.9281, 6.2110, 4.0098>
		<-10.6168, 6.2294, 4.1002> <-10.5967, 6.2094, 4.1002> <-9.9666, 6.2094, 4.1002> <-9.9465, 6.2294, 4.1002>
		<-10.6221, 6.2242, 4.2288> <-10.6028, 6.2049, 4.2288> <-9.9606, 6.2049, 4.2288> <-9.9413, 6.2242, 4.2288>
		<-10.6213, 6.2250, 4.3229> <-10.6020, 6.2057, 4.3229> <-9.9614, 6.2057, 4.3229> <-9.9421, 6.2250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 6.2110, 4.0098> <-9.9080, 6.2311, 4.0098> <-9.9080, 6.8981, 4.0098> <-9.9281, 6.9182, 4.0098>
		<-9.9465, 6.2294, 4.1002> <-9.9264, 6.2495, 4.1002> <-9.9264, 6.8797, 4.1002> <-9.9465, 6.8997, 4.1002>
		<-9.9413, 6.2242, 4.2288> <-9.9220, 6.2435, 4.2288> <-9.9220, 6.8857, 4.2288> <-9.9413, 6.9050, 4.2288>
		<-9.9421, 6.2250, 4.3229> <-9.9228, 6.2443, 4.3229> <-9.9228, 6.8849, 4.3229> <-9.9421, 6.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 6.9182, 4.0098> <-9.9482, 6.9383, 4.0098> <-10.6152, 6.9383, 4.0098> <-10.6352, 6.9182, 4.0098>
		<-9.9465, 6.8997, 4.1002> <-9.9666, 6.9198, 4.1002> <-10.5967, 6.9198, 4.1002> <-10.6168, 6.8997, 4.1002>
		<-9.9413, 6.9050, 4.2288> <-9.9606, 6.9243, 4.2288> <-10.6028, 6.9243, 4.2288> <-10.6221, 6.9050, 4.2288>
		<-9.9421, 6.9042, 4.3229> <-9.9614, 6.9235, 4.3229> <-10.6020, 6.9235, 4.3229> <-10.6213, 6.9042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 6.2250, 4.3229> <-10.6179, 6.2284, 4.7283> <-10.6197, 6.2265, 5.2689> <-10.6213, 6.2250, 5.6744>
		<-10.6405, 6.2443, 4.3229> <-10.6371, 6.2477, 4.7283> <-10.6390, 6.2458, 5.2689> <-10.6405, 6.2443, 5.6744>
		<-10.6405, 6.8849, 4.3229> <-10.6371, 6.8815, 4.7283> <-10.6390, 6.8834, 5.2689> <-10.6405, 6.8849, 5.6744>
		<-10.6213, 6.9042, 4.3229> <-10.6179, 6.9008, 4.7283> <-10.6197, 6.9027, 5.2689> <-10.6213, 6.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 6.2250, 4.3229> <-10.6020, 6.2057, 4.3229> <-9.9614, 6.2057, 4.3229> <-9.9421, 6.2250, 4.3229>
		<-10.6179, 6.2284, 4.7283> <-10.5986, 6.2091, 4.7283> <-9.9648, 6.2091, 4.7283> <-9.9455, 6.2284, 4.7283>
		<-10.6197, 6.2265, 5.2689> <-10.6004, 6.2072, 5.2689> <-9.9629, 6.2072, 5.2689> <-9.9436, 6.2265, 5.2689>
		<-10.6213, 6.2250, 5.6744> <-10.6020, 6.2057, 5.6744> <-9.9614, 6.2057, 5.6744> <-9.9421, 6.2250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 6.2250, 4.3229> <-9.9228, 6.2443, 4.3229> <-9.9228, 6.8849, 4.3229> <-9.9421, 6.9042, 4.3229>
		<-9.9455, 6.2284, 4.7283> <-9.9262, 6.2477, 4.7283> <-9.9262, 6.8815, 4.7283> <-9.9455, 6.9008, 4.7283>
		<-9.9436, 6.2265, 5.2689> <-9.9243, 6.2458, 5.2689> <-9.9243, 6.8834, 5.2689> <-9.9436, 6.9027, 5.2689>
		<-9.9421, 6.2250, 5.6744> <-9.9228, 6.2443, 5.6744> <-9.9228, 6.8849, 5.6744> <-9.9421, 6.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 6.9042, 4.3229> <-9.9614, 6.9235, 4.3229> <-10.6020, 6.9235, 4.3229> <-10.6213, 6.9042, 4.3229>
		<-9.9455, 6.9008, 4.7283> <-9.9648, 6.9201, 4.7283> <-10.5986, 6.9201, 4.7283> <-10.6179, 6.9008, 4.7283>
		<-9.9436, 6.9027, 5.2689> <-9.9629, 6.9219, 5.2689> <-10.6004, 6.9219, 5.2689> <-10.6197, 6.9027, 5.2689>
		<-9.9421, 6.9042, 5.6744> <-9.9614, 6.9235, 5.6744> <-10.6020, 6.9235, 5.6744> <-10.6213, 6.9042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 6.2250, 5.6744> <-10.6225, 6.2237, 6.0073> <-10.6172, 6.2290, 6.4517> <-10.6305, 6.2157, 6.7841>
		<-10.6405, 6.2443, 5.6744> <-10.6418, 6.2430, 6.0073> <-10.6371, 6.2488, 6.4517> <-10.6503, 6.2355, 6.7841>
		<-10.6405, 6.8849, 5.6744> <-10.6418, 6.8861, 6.0073> <-10.6371, 6.8804, 6.4517> <-10.6503, 6.8936, 6.7841>
		<-10.6213, 6.9042, 5.6744> <-10.6225, 6.9054, 6.0073> <-10.6172, 6.9002, 6.4517> <-10.6305, 6.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 6.2250, 5.6744> <-10.6020, 6.2057, 5.6744> <-9.9614, 6.2057, 5.6744> <-9.9421, 6.2250, 5.6744>
		<-10.6225, 6.2237, 6.0073> <-10.6032, 6.2044, 6.0073> <-9.9601, 6.2044, 6.0073> <-9.9408, 6.2237, 6.0073>
		<-10.6172, 6.2290, 6.4517> <-10.5974, 6.2092, 6.4517> <-9.9659, 6.2092, 6.4517> <-9.9461, 6.2290, 6.4517>
		<-10.6305, 6.2157, 6.7841> <-10.6107, 6.1959, 6.7841> <-9.9526, 6.1959, 6.7841> <-9.9328, 6.2157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 6.2250, 5.6744> <-9.9228, 6.2443, 5.6744> <-9.9228, 6.8849, 5.6744> <-9.9421, 6.9042, 5.6744>
		<-9.9408, 6.2237, 6.0073> <-9.9215, 6.2430, 6.0073> <-9.9215, 6.8861, 6.0073> <-9.9408, 6.9054, 6.0073>
		<-9.9461, 6.2290, 6.4517> <-9.9263, 6.2488, 6.4517> <-9.9263, 6.8804, 6.4517> <-9.9461, 6.9002, 6.4517>
		<-9.9328, 6.2157, 6.7841> <-9.9130, 6.2355, 6.7841> <-9.9130, 6.8936, 6.7841> <-9.9328, 6.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 6.9042, 5.6744> <-9.9614, 6.9235, 5.6744> <-10.6020, 6.9235, 5.6744> <-10.6213, 6.9042, 5.6744>
		<-9.9408, 6.9054, 6.0073> <-9.9601, 6.9247, 6.0073> <-10.6032, 6.9247, 6.0073> <-10.6225, 6.9054, 6.0073>
		<-9.9461, 6.9002, 6.4517> <-9.9659, 6.9200, 6.4517> <-10.5974, 6.9200, 6.4517> <-10.6172, 6.9002, 6.4517>
		<-9.9328, 6.9134, 6.7841> <-9.9526, 6.9333, 6.7841> <-10.6107, 6.9333, 6.7841> <-10.6305, 6.9134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 6.2157, 6.7841> <-10.6325, 6.2137, 6.8341> <-10.6449, 6.2013, 6.9079> <-10.6718, 6.1745, 6.9405>
		<-10.6503, 6.2355, 6.7841> <-10.6523, 6.2336, 6.8341> <-10.6671, 6.2235, 6.9079> <-10.6940, 6.1966, 6.9405>
		<-10.6503, 6.8936, 6.7841> <-10.6523, 6.8956, 6.8341> <-10.6671, 6.9057, 6.9079> <-10.6940, 6.9326, 6.9405>
		<-10.6305, 6.9134, 6.7841> <-10.6325, 6.9154, 6.8341> <-10.6449, 6.9278, 6.9079> <-10.6718, 6.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 6.2157, 6.7841> <-10.6107, 6.1959, 6.7841> <-9.9526, 6.1959, 6.7841> <-9.9328, 6.2157, 6.7841>
		<-10.6325, 6.2137, 6.8341> <-10.6127, 6.1939, 6.8341> <-9.9506, 6.1939, 6.8341> <-9.9308, 6.2137, 6.8341>
		<-10.6449, 6.2013, 6.9079> <-10.6228, 6.1792, 6.9079> <-9.9406, 6.1792, 6.9079> <-9.9184, 6.2013, 6.9079>
		<-10.6718, 6.1745, 6.9405> <-10.6496, 6.1523, 6.9405> <-9.9137, 6.1523, 6.9405> <-9.8915, 6.1745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 6.2157, 6.7841> <-9.9130, 6.2355, 6.7841> <-9.9130, 6.8936, 6.7841> <-9.9328, 6.9134, 6.7841>
		<-9.9308, 6.2137, 6.8341> <-9.9110, 6.2336, 6.8341> <-9.9110, 6.8956, 6.8341> <-9.9308, 6.9154, 6.8341>
		<-9.9184, 6.2013, 6.9079> <-9.8962, 6.2235, 6.9079> <-9.8962, 6.9057, 6.9079> <-9.9184, 6.9278, 6.9079>
		<-9.8915, 6.1745, 6.9405> <-9.8694, 6.1966, 6.9405> <-9.8694, 6.9326, 6.9405> <-9.8915, 6.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 6.9134, 6.7841> <-9.9526, 6.9333, 6.7841> <-10.6107, 6.9333, 6.7841> <-10.6305, 6.9134, 6.7841>
		<-9.9308, 6.9154, 6.8341> <-9.9506, 6.9352, 6.8341> <-10.6127, 6.9352, 6.8341> <-10.6325, 6.9154, 6.8341>
		<-9.9184, 6.9278, 6.9079> <-9.9406, 6.9500, 6.9079> <-10.6228, 6.9500, 6.9079> <-10.6449, 6.9278, 6.9079>
		<-9.8915, 6.9547, 6.9405> <-9.9137, 6.9769, 6.9405> <-10.6496, 6.9769, 6.9405> <-10.6718, 6.9547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 6.1745, 6.9405> <-10.7339, 6.1123, 7.0160> <-10.8620, 5.9842, 7.0331> <-10.9114, 5.9348, 7.1255>
		<-10.6940, 6.1966, 6.9405> <-10.7561, 6.1345, 7.0160> <-10.8978, 6.0200, 7.0331> <-10.9472, 5.9706, 7.1255>
		<-10.6940, 6.9326, 6.9405> <-10.7561, 6.9947, 7.0160> <-10.8978, 7.1092, 7.0331> <-10.9472, 7.1586, 7.1255>
		<-10.6718, 6.9547, 6.9405> <-10.7339, 7.0168, 7.0160> <-10.8620, 7.1449, 7.0331> <-10.9114, 7.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 6.1745, 6.9405> <-10.6496, 6.1523, 6.9405> <-9.9137, 6.1523, 6.9405> <-9.8915, 6.1745, 6.9405>
		<-10.7339, 6.1123, 7.0160> <-10.7117, 6.0902, 7.0160> <-9.8516, 6.0902, 7.0160> <-9.8294, 6.1123, 7.0160>
		<-10.8620, 5.9842, 7.0331> <-10.8262, 5.9485, 7.0331> <-9.7371, 5.9485, 7.0331> <-9.7013, 5.9842, 7.0331>
		<-10.9114, 5.9348, 7.1255> <-10.8757, 5.8990, 7.1255> <-9.6877, 5.8990, 7.1255> <-9.6519, 5.9348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 6.1745, 6.9405> <-9.8694, 6.1966, 6.9405> <-9.8694, 6.9326, 6.9405> <-9.8915, 6.9547, 6.9405>
		<-9.8294, 6.1123, 7.0160> <-9.8073, 6.1345, 7.0160> <-9.8073, 6.9947, 7.0160> <-9.8294, 7.0168, 7.0160>
		<-9.7013, 5.9842, 7.0331> <-9.6655, 6.0200, 7.0331> <-9.6655, 7.1092, 7.0331> <-9.7013, 7.1449, 7.0331>
		<-9.6519, 5.9348, 7.1255> <-9.6161, 5.9706, 7.1255> <-9.6161, 7.1586, 7.1255> <-9.6519, 7.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 6.9547, 6.9405> <-9.9137, 6.9769, 6.9405> <-10.6496, 6.9769, 6.9405> <-10.6718, 6.9547, 6.9405>
		<-9.8294, 7.0168, 7.0160> <-9.8516, 7.0390, 7.0160> <-10.7117, 7.0390, 7.0160> <-10.7339, 7.0168, 7.0160>
		<-9.7013, 7.1449, 7.0331> <-9.7371, 7.1807, 7.0331> <-10.8262, 7.1807, 7.0331> <-10.8620, 7.1449, 7.0331>
		<-9.6519, 7.1944, 7.1255> <-9.6877, 7.2301, 7.1255> <-10.8757, 7.2301, 7.1255> <-10.9114, 7.1944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 5.9348, 7.1255> <-10.9319, 5.9143, 7.1638> <-10.8316, 6.0146, 7.1912> <-10.8316, 6.0146, 7.2393>
		<-10.9472, 5.9706, 7.1255> <-10.9677, 5.9501, 7.1638> <-10.8629, 6.0459, 7.1912> <-10.8629, 6.0459, 7.2393>
		<-10.9472, 7.1586, 7.1255> <-10.9677, 7.1791, 7.1638> <-10.8629, 7.0833, 7.1912> <-10.8629, 7.0833, 7.2393>
		<-10.9114, 7.1944, 7.1255> <-10.9319, 7.2149, 7.1638> <-10.8316, 7.1146, 7.1912> <-10.8316, 7.1146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 5.9348, 7.1255> <-10.8757, 5.8990, 7.1255> <-9.6877, 5.8990, 7.1255> <-9.6519, 5.9348, 7.1255>
		<-10.9319, 5.9143, 7.1638> <-10.8962, 5.8785, 7.1638> <-9.6671, 5.8785, 7.1638> <-9.6314, 5.9143, 7.1638>
		<-10.8316, 6.0146, 7.1912> <-10.8004, 5.9834, 7.1912> <-9.7629, 5.9834, 7.1912> <-9.7317, 6.0146, 7.1912>
		<-10.8316, 6.0146, 7.2393> <-10.8004, 5.9834, 7.2393> <-9.7629, 5.9834, 7.2393> <-9.7317, 6.0146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 5.9348, 7.1255> <-9.6161, 5.9706, 7.1255> <-9.6161, 7.1586, 7.1255> <-9.6519, 7.1944, 7.1255>
		<-9.6314, 5.9143, 7.1638> <-9.5956, 5.9501, 7.1638> <-9.5956, 7.1791, 7.1638> <-9.6314, 7.2149, 7.1638>
		<-9.7317, 6.0146, 7.1912> <-9.7005, 6.0459, 7.1912> <-9.7005, 7.0833, 7.1912> <-9.7317, 7.1146, 7.1912>
		<-9.7317, 6.0146, 7.2393> <-9.7005, 6.0459, 7.2393> <-9.7005, 7.0833, 7.2393> <-9.7317, 7.1146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 7.1944, 7.1255> <-9.6877, 7.2301, 7.1255> <-10.8757, 7.2301, 7.1255> <-10.9114, 7.1944, 7.1255>
		<-9.6314, 7.2149, 7.1638> <-9.6671, 7.2506, 7.1638> <-10.8962, 7.2506, 7.1638> <-10.9319, 7.2149, 7.1638>
		<-9.7317, 7.1146, 7.1912> <-9.7629, 7.1458, 7.1912> <-10.8004, 7.1458, 7.1912> <-10.8316, 7.1146, 7.1912>
		<-9.7317, 7.1146, 7.2393> <-9.7629, 7.1458, 7.2393> <-10.8004, 7.1458, 7.2393> <-10.8316, 7.1146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 6.0146, 7.2393> <-10.8316, 6.0146, 7.2905> <-10.9054, 5.9408, 7.3169> <-10.9114, 5.9348, 7.3673>
		<-10.8629, 6.0459, 7.2393> <-10.8629, 6.0459, 7.2905> <-10.9412, 5.9766, 7.3169> <-10.9472, 5.9706, 7.3673>
		<-10.8629, 7.0833, 7.2393> <-10.8629, 7.0833, 7.2905> <-10.9412, 7.1526, 7.3169> <-10.9472, 7.1586, 7.3673>
		<-10.8316, 7.1146, 7.2393> <-10.8316, 7.1146, 7.2905> <-10.9054, 7.1883, 7.3169> <-10.9114, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 6.0146, 7.2393> <-10.8004, 5.9834, 7.2393> <-9.7629, 5.9834, 7.2393> <-9.7317, 6.0146, 7.2393>
		<-10.8316, 6.0146, 7.2905> <-10.8004, 5.9834, 7.2905> <-9.7629, 5.9834, 7.2905> <-9.7317, 6.0146, 7.2905>
		<-10.9054, 5.9408, 7.3169> <-10.8696, 5.9051, 7.3169> <-9.6937, 5.9051, 7.3169> <-9.6579, 5.9408, 7.3169>
		<-10.9114, 5.9348, 7.3673> <-10.8757, 5.8990, 7.3673> <-9.6877, 5.8990, 7.3673> <-9.6519, 5.9348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 6.0146, 7.2393> <-9.7005, 6.0459, 7.2393> <-9.7005, 7.0833, 7.2393> <-9.7317, 7.1146, 7.2393>
		<-9.7317, 6.0146, 7.2905> <-9.7005, 6.0459, 7.2905> <-9.7005, 7.0833, 7.2905> <-9.7317, 7.1146, 7.2905>
		<-9.6579, 5.9408, 7.3169> <-9.6222, 5.9766, 7.3169> <-9.6222, 7.1526, 7.3169> <-9.6579, 7.1883, 7.3169>
		<-9.6519, 5.9348, 7.3673> <-9.6161, 5.9706, 7.3673> <-9.6161, 7.1586, 7.3673> <-9.6519, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 7.1146, 7.2393> <-9.7629, 7.1458, 7.2393> <-10.8004, 7.1458, 7.2393> <-10.8316, 7.1146, 7.2393>
		<-9.7317, 7.1146, 7.2905> <-9.7629, 7.1458, 7.2905> <-10.8004, 7.1458, 7.2905> <-10.8316, 7.1146, 7.2905>
		<-9.6579, 7.1883, 7.3169> <-9.6937, 7.2241, 7.3169> <-10.8696, 7.2241, 7.3169> <-10.9054, 7.1883, 7.3169>
		<-9.6519, 7.1944, 7.3673> <-9.6877, 7.2301, 7.3673> <-10.8757, 7.2301, 7.3673> <-10.9114, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 5.9348, 7.9080> <-10.9472, 5.9706, 7.9080> <-10.9472, 7.1586, 7.9080> <-10.9114, 7.1944, 7.9080>
		<-10.9114, 5.9348, 7.7458> <-10.9472, 5.9706, 7.7458> <-10.9472, 7.1586, 7.7458> <-10.9114, 7.1944, 7.7458>
		<-10.9305, 5.9157, 7.5273> <-10.9663, 5.9515, 7.5273> <-10.9663, 7.1777, 7.5273> <-10.9305, 7.2134, 7.5273>
		<-10.9114, 5.9348, 7.3673> <-10.9472, 5.9706, 7.3673> <-10.9472, 7.1586, 7.3673> <-10.9114, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 5.9348, 7.9080> <-10.9114, 5.9348, 7.7458> <-10.9305, 5.9157, 7.5273> <-10.9114, 5.9348, 7.3673>
		<-10.8757, 5.8990, 7.9080> <-10.8757, 5.8990, 7.7458> <-10.8947, 5.8800, 7.5273> <-10.8757, 5.8990, 7.3673>
		<-9.6877, 5.8990, 7.9080> <-9.6877, 5.8990, 7.7458> <-9.6686, 5.8800, 7.5273> <-9.6877, 5.8990, 7.3673>
		<-9.6519, 5.9348, 7.9080> <-9.6519, 5.9348, 7.7458> <-9.6328, 5.9157, 7.5273> <-9.6519, 5.9348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 5.9348, 7.9080> <-9.6519, 5.9348, 7.7458> <-9.6328, 5.9157, 7.5273> <-9.6519, 5.9348, 7.3673>
		<-9.6161, 5.9706, 7.9080> <-9.6161, 5.9706, 7.7458> <-9.5970, 5.9515, 7.5273> <-9.6161, 5.9706, 7.3673>
		<-9.6161, 7.1586, 7.9080> <-9.6161, 7.1586, 7.7458> <-9.5970, 7.1777, 7.5273> <-9.6161, 7.1586, 7.3673>
		<-9.6519, 7.1944, 7.9080> <-9.6519, 7.1944, 7.7458> <-9.6328, 7.2134, 7.5273> <-9.6519, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 7.1944, 7.9080> <-9.6519, 7.1944, 7.7458> <-9.6328, 7.2134, 7.5273> <-9.6519, 7.1944, 7.3673>
		<-9.6877, 7.2301, 7.9080> <-9.6877, 7.2301, 7.7458> <-9.6686, 7.2492, 7.5273> <-9.6877, 7.2301, 7.3673>
		<-10.8757, 7.2301, 7.9080> <-10.8757, 7.2301, 7.7458> <-10.8947, 7.2492, 7.5273> <-10.8757, 7.2301, 7.3673>
		<-10.9114, 7.1944, 7.9080> <-10.9114, 7.1944, 7.7458> <-10.9305, 7.2134, 7.5273> <-10.9114, 7.1944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 5.6874, 0.7771> <-11.2087, 5.7372, 0.7771> <-11.2087, 7.3920, 0.7771> <-11.1589, 7.4418, 0.7771>
		<-11.1796, 5.6666, 0.6520> <-11.2294, 5.7164, 0.6520> <-11.2294, 7.4127, 0.6520> <-11.1796, 7.4626, 0.6520>
		<-11.1589, 5.6874, 0.4772> <-11.2087, 5.7372, 0.4772> <-11.2087, 7.3920, 0.4772> <-11.1589, 7.4418, 0.4772>
		<-11.1589, 5.6874, 0.3486> <-11.2087, 5.7372, 0.3486> <-11.2087, 7.3920, 0.3486> <-11.1589, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 5.6874, 0.7771> <-11.1796, 5.6666, 0.6520> <-11.1589, 5.6874, 0.4772> <-11.1589, 5.6874, 0.3486>
		<-11.1090, 5.6376, 0.7771> <-11.1298, 5.6168, 0.6520> <-11.1090, 5.6376, 0.4772> <-11.1090, 5.6376, 0.3486>
		<-9.4543, 5.6376, 0.7771> <-9.4335, 5.6168, 0.6520> <-9.4543, 5.6376, 0.4772> <-9.4543, 5.6376, 0.3486>
		<-9.4045, 5.6874, 0.7771> <-9.3837, 5.6666, 0.6520> <-9.4045, 5.6874, 0.4772> <-9.4045, 5.6874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 5.6874, 0.7771> <-9.3837, 5.6666, 0.6520> <-9.4045, 5.6874, 0.4772> <-9.4045, 5.6874, 0.3486>
		<-9.3546, 5.7372, 0.7771> <-9.3339, 5.7164, 0.6520> <-9.3546, 5.7372, 0.4772> <-9.3546, 5.7372, 0.3486>
		<-9.3546, 7.3920, 0.7771> <-9.3339, 7.4127, 0.6520> <-9.3546, 7.3920, 0.4772> <-9.3546, 7.3920, 0.3486>
		<-9.4045, 7.4418, 0.7771> <-9.3837, 7.4626, 0.6520> <-9.4045, 7.4418, 0.4772> <-9.4045, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 7.4418, 0.7771> <-9.3837, 7.4626, 0.6520> <-9.4045, 7.4418, 0.4772> <-9.4045, 7.4418, 0.3486>
		<-9.4543, 7.4916, 0.7771> <-9.4335, 7.5124, 0.6520> <-9.4543, 7.4916, 0.4772> <-9.4543, 7.4916, 0.3486>
		<-11.1090, 7.4916, 0.7771> <-11.1298, 7.5124, 0.6520> <-11.1090, 7.4916, 0.4772> <-11.1090, 7.4916, 0.3486>
		<-11.1589, 7.4418, 0.7771> <-11.1796, 7.4626, 0.6520> <-11.1589, 7.4418, 0.4772> <-11.1589, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 5.6874, -0.0618> <-11.1589, 5.6874, 0.0613> <-11.1589, 5.6874, 0.2255> <-11.1589, 5.6874, 0.3486>
		<-11.2087, 5.7372, -0.0618> <-11.2087, 5.7372, 0.0613> <-11.2087, 5.7372, 0.2255> <-11.2087, 5.7372, 0.3486>
		<-11.2087, 7.3920, -0.0618> <-11.2087, 7.3920, 0.0613> <-11.2087, 7.3920, 0.2255> <-11.2087, 7.3920, 0.3486>
		<-11.1589, 7.4418, -0.0618> <-11.1589, 7.4418, 0.0613> <-11.1589, 7.4418, 0.2255> <-11.1589, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 5.6874, -0.0618> <-11.1090, 5.6376, -0.0618> <-9.4543, 5.6376, -0.0618> <-9.4045, 5.6874, -0.0618>
		<-11.1589, 5.6874, 0.0613> <-11.1090, 5.6376, 0.0613> <-9.4543, 5.6376, 0.0613> <-9.4045, 5.6874, 0.0613>
		<-11.1589, 5.6874, 0.2255> <-11.1090, 5.6376, 0.2255> <-9.4543, 5.6376, 0.2255> <-9.4045, 5.6874, 0.2255>
		<-11.1589, 5.6874, 0.3486> <-11.1090, 5.6376, 0.3486> <-9.4543, 5.6376, 0.3486> <-9.4045, 5.6874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 5.6874, -0.0618> <-9.3546, 5.7372, -0.0618> <-9.3546, 7.3920, -0.0618> <-9.4045, 7.4418, -0.0618>
		<-9.4045, 5.6874, 0.0613> <-9.3546, 5.7372, 0.0613> <-9.3546, 7.3920, 0.0613> <-9.4045, 7.4418, 0.0613>
		<-9.4045, 5.6874, 0.2255> <-9.3546, 5.7372, 0.2255> <-9.3546, 7.3920, 0.2255> <-9.4045, 7.4418, 0.2255>
		<-9.4045, 5.6874, 0.3486> <-9.3546, 5.7372, 0.3486> <-9.3546, 7.3920, 0.3486> <-9.4045, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 7.4418, -0.0618> <-9.4543, 7.4916, -0.0618> <-11.1090, 7.4916, -0.0618> <-11.1589, 7.4418, -0.0618>
		<-9.4045, 7.4418, 0.0613> <-9.4543, 7.4916, 0.0613> <-11.1090, 7.4916, 0.0613> <-11.1589, 7.4418, 0.0613>
		<-9.4045, 7.4418, 0.2255> <-9.4543, 7.4916, 0.2255> <-11.1090, 7.4916, 0.2255> <-11.1589, 7.4418, 0.2255>
		<-9.4045, 7.4418, 0.3486> <-9.4543, 7.4916, 0.3486> <-11.1090, 7.4916, 0.3486> <-11.1589, 7.4418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 0.9062> <-11.1109, 3.6245, 0.9062> <-11.1109, 5.1047, 0.9062> <-11.0664, 5.1493, 0.9062>
		<-11.0712, 3.5751, 0.8515> <-11.1157, 3.6196, 0.8515> <-11.1157, 5.1095, 0.8515> <-11.0712, 5.1541, 0.8515>
		<-11.1500, 3.4963, 0.8308> <-11.1998, 3.5461, 0.8308> <-11.1998, 5.1831, 0.8308> <-11.1500, 5.2329, 0.8308>
		<-11.1589, 3.4874, 0.7771> <-11.2087, 3.5372, 0.7771> <-11.2087, 5.1920, 0.7771> <-11.1589, 5.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 0.9062> <-11.0620, 3.5842, 0.9557> <-11.1560, 3.4903, 0.9996> <-11.1357, 3.5105, 1.0404>
		<-11.1109, 3.6245, 0.9062> <-11.1066, 3.6288, 0.9557> <-11.2045, 3.5388, 0.9996> <-11.1842, 3.5590, 1.0404>
		<-11.1109, 5.1047, 0.9062> <-11.1066, 5.1004, 0.9557> <-11.2045, 5.1904, 0.9996> <-11.1842, 5.1702, 1.0404>
		<-11.0664, 5.1493, 0.9062> <-11.0620, 5.1449, 0.9557> <-11.1560, 5.2389, 0.9996> <-11.1357, 5.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 0.9062> <-11.0712, 3.5751, 0.8515> <-11.1500, 3.4963, 0.8308> <-11.1589, 3.4874, 0.7771>
		<-11.0218, 3.5353, 0.9062> <-11.0266, 3.5305, 0.8515> <-11.1001, 3.4465, 0.8308> <-11.1090, 3.4376, 0.7771>
		<-9.5415, 3.5353, 0.9062> <-9.5367, 3.5305, 0.8515> <-9.4632, 3.4465, 0.8308> <-9.4543, 3.4376, 0.7771>
		<-9.4970, 3.5799, 0.9062> <-9.4922, 3.5751, 0.8515> <-9.4134, 3.4963, 0.8308> <-9.4045, 3.4874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 0.9062> <-11.0218, 3.5353, 0.9062> <-9.5415, 3.5353, 0.9062> <-9.4970, 3.5799, 0.9062>
		<-11.0620, 3.5842, 0.9557> <-11.0175, 3.5397, 0.9557> <-9.5459, 3.5397, 0.9557> <-9.5013, 3.5842, 0.9557>
		<-11.1560, 3.4903, 0.9996> <-11.1075, 3.4418, 0.9996> <-9.4559, 3.4418, 0.9996> <-9.4073, 3.4903, 0.9996>
		<-11.1357, 3.5105, 1.0404> <-11.0872, 3.4620, 1.0404> <-9.4761, 3.4620, 1.0404> <-9.4276, 3.5105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 3.5799, 0.9062> <-9.4922, 3.5751, 0.8515> <-9.4134, 3.4963, 0.8308> <-9.4045, 3.4874, 0.7771>
		<-9.4524, 3.6245, 0.9062> <-9.4476, 3.6196, 0.8515> <-9.3635, 3.5461, 0.8308> <-9.3546, 3.5372, 0.7771>
		<-9.4524, 5.1047, 0.9062> <-9.4476, 5.1095, 0.8515> <-9.3635, 5.1831, 0.8308> <-9.3546, 5.1920, 0.7771>
		<-9.4970, 5.1493, 0.9062> <-9.4922, 5.1541, 0.8515> <-9.4134, 5.2329, 0.8308> <-9.4045, 5.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 3.5799, 0.9062> <-9.4524, 3.6245, 0.9062> <-9.4524, 5.1047, 0.9062> <-9.4970, 5.1493, 0.9062>
		<-9.5013, 3.5842, 0.9557> <-9.4567, 3.6288, 0.9557> <-9.4567, 5.1004, 0.9557> <-9.5013, 5.1449, 0.9557>
		<-9.4073, 3.4903, 0.9996> <-9.3588, 3.5388, 0.9996> <-9.3588, 5.1904, 0.9996> <-9.4073, 5.2389, 0.9996>
		<-9.4276, 3.5105, 1.0404> <-9.3791, 3.5590, 1.0404> <-9.3791, 5.1702, 1.0404> <-9.4276, 5.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.1493, 0.9062> <-9.4922, 5.1541, 0.8515> <-9.4134, 5.2329, 0.8308> <-9.4045, 5.2418, 0.7771>
		<-9.5415, 5.1939, 0.9062> <-9.5367, 5.1987, 0.8515> <-9.4632, 5.2827, 0.8308> <-9.4543, 5.2916, 0.7771>
		<-11.0218, 5.1939, 0.9062> <-11.0266, 5.1987, 0.8515> <-11.1001, 5.2827, 0.8308> <-11.1090, 5.2916, 0.7771>
		<-11.0664, 5.1493, 0.9062> <-11.0712, 5.1541, 0.8515> <-11.1500, 5.2329, 0.8308> <-11.1589, 5.2418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.1493, 0.9062> <-9.5415, 5.1939, 0.9062> <-11.0218, 5.1939, 0.9062> <-11.0664, 5.1493, 0.9062>
		<-9.5013, 5.1449, 0.9557> <-9.5459, 5.1895, 0.9557> <-11.0175, 5.1895, 0.9557> <-11.0620, 5.1449, 0.9557>
		<-9.4073, 5.2389, 0.9996> <-9.4559, 5.2874, 0.9996> <-11.1075, 5.2874, 0.9996> <-11.1560, 5.2389, 0.9996>
		<-9.4276, 5.2187, 1.0404> <-9.4761, 5.2672, 1.0404> <-11.0872, 5.2672, 1.0404> <-11.1357, 5.2187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 3.5105, 1.0404> <-11.0677, 3.5786, 1.1777> <-10.8982, 3.7481, 1.2552> <-10.8269, 3.8193, 1.3892>
		<-11.1842, 3.5590, 1.0404> <-11.1162, 3.6271, 1.1777> <-10.9291, 3.7790, 1.2552> <-10.8579, 3.8503, 1.3892>
		<-11.1842, 5.1702, 1.0404> <-11.1162, 5.1021, 1.1777> <-10.9291, 4.9501, 1.2552> <-10.8579, 4.8789, 1.3892>
		<-11.1357, 5.2187, 1.0404> <-11.0677, 5.1506, 1.1777> <-10.8982, 4.9811, 1.2552> <-10.8269, 4.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 3.5105, 1.0404> <-11.0872, 3.4620, 1.0404> <-9.4761, 3.4620, 1.0404> <-9.4276, 3.5105, 1.0404>
		<-11.0677, 3.5786, 1.1777> <-11.0192, 3.5301, 1.1777> <-9.5442, 3.5301, 1.1777> <-9.4957, 3.5786, 1.1777>
		<-10.8982, 3.7481, 1.2552> <-10.8672, 3.7171, 1.2552> <-9.6961, 3.7171, 1.2552> <-9.6652, 3.7481, 1.2552>
		<-10.8269, 3.8193, 1.3892> <-10.7959, 3.7884, 1.3892> <-9.7674, 3.7884, 1.3892> <-9.7364, 3.8193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 3.5105, 1.0404> <-9.3791, 3.5590, 1.0404> <-9.3791, 5.1702, 1.0404> <-9.4276, 5.2187, 1.0404>
		<-9.4957, 3.5786, 1.1777> <-9.4471, 3.6271, 1.1777> <-9.4471, 5.1021, 1.1777> <-9.4957, 5.1506, 1.1777>
		<-9.6652, 3.7481, 1.2552> <-9.6342, 3.7790, 1.2552> <-9.6342, 4.9501, 1.2552> <-9.6652, 4.9811, 1.2552>
		<-9.7364, 3.8193, 1.3892> <-9.7054, 3.8503, 1.3892> <-9.7054, 4.8789, 1.3892> <-9.7364, 4.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 5.2187, 1.0404> <-9.4761, 5.2672, 1.0404> <-11.0872, 5.2672, 1.0404> <-11.1357, 5.2187, 1.0404>
		<-9.4957, 5.1506, 1.1777> <-9.5442, 5.1991, 1.1777> <-11.0192, 5.1991, 1.1777> <-11.0677, 5.1506, 1.1777>
		<-9.6652, 4.9811, 1.2552> <-9.6961, 5.0121, 1.2552> <-10.8672, 5.0121, 1.2552> <-10.8982, 4.9811, 1.2552>
		<-9.7364, 4.9098, 1.3892> <-9.7674, 4.9408, 1.3892> <-10.7959, 4.9408, 1.3892> <-10.8269, 4.9098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 3.8193, 1.3892> <-10.8079, 3.8383, 1.4249> <-10.8837, 3.7626, 1.4698> <-10.8837, 3.7626, 1.5144>
		<-10.8579, 3.8503, 1.3892> <-10.8389, 3.8693, 1.4249> <-10.9179, 3.7968, 1.4698> <-10.9179, 3.7968, 1.5144>
		<-10.8579, 4.8789, 1.3892> <-10.8389, 4.8599, 1.4249> <-10.9179, 4.9324, 1.4698> <-10.9179, 4.9324, 1.5144>
		<-10.8269, 4.9098, 1.3892> <-10.8079, 4.8909, 1.4249> <-10.8837, 4.9666, 1.4698> <-10.8837, 4.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 3.8193, 1.3892> <-10.7959, 3.7884, 1.3892> <-9.7674, 3.7884, 1.3892> <-9.7364, 3.8193, 1.3892>
		<-10.8079, 3.8383, 1.4249> <-10.7770, 3.8073, 1.4249> <-9.7863, 3.8073, 1.4249> <-9.7554, 3.8383, 1.4249>
		<-10.8837, 3.7626, 1.4698> <-10.8495, 3.7284, 1.4698> <-9.7138, 3.7284, 1.4698> <-9.6796, 3.7626, 1.4698>
		<-10.8837, 3.7626, 1.5144> <-10.8495, 3.7284, 1.5144> <-9.7138, 3.7284, 1.5144> <-9.6796, 3.7626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 3.8193, 1.3892> <-9.7054, 3.8503, 1.3892> <-9.7054, 4.8789, 1.3892> <-9.7364, 4.9098, 1.3892>
		<-9.7554, 3.8383, 1.4249> <-9.7244, 3.8693, 1.4249> <-9.7244, 4.8599, 1.4249> <-9.7554, 4.8909, 1.4249>
		<-9.6796, 3.7626, 1.4698> <-9.6455, 3.7968, 1.4698> <-9.6455, 4.9324, 1.4698> <-9.6796, 4.9666, 1.4698>
		<-9.6796, 3.7626, 1.5144> <-9.6455, 3.7968, 1.5144> <-9.6455, 4.9324, 1.5144> <-9.6796, 4.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 4.9098, 1.3892> <-9.7674, 4.9408, 1.3892> <-10.7959, 4.9408, 1.3892> <-10.8269, 4.9098, 1.3892>
		<-9.7554, 4.8909, 1.4249> <-9.7863, 4.9218, 1.4249> <-10.7770, 4.9218, 1.4249> <-10.8079, 4.8909, 1.4249>
		<-9.6796, 4.9666, 1.4698> <-9.7138, 5.0008, 1.4698> <-10.8495, 5.0008, 1.4698> <-10.8837, 4.9666, 1.4698>
		<-9.6796, 4.9666, 1.5144> <-9.7138, 5.0008, 1.5144> <-10.8495, 5.0008, 1.5144> <-10.8837, 4.9666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 3.7626, 1.5144> <-10.8837, 3.7626, 1.5613> <-10.8121, 3.8341, 1.6066> <-10.8269, 3.8193, 1.6486>
		<-10.9179, 3.7968, 1.5144> <-10.9179, 3.7968, 1.5613> <-10.8431, 3.8651, 1.6066> <-10.8579, 3.8503, 1.6486>
		<-10.9179, 4.9324, 1.5144> <-10.9179, 4.9324, 1.5613> <-10.8431, 4.8641, 1.6066> <-10.8579, 4.8789, 1.6486>
		<-10.8837, 4.9666, 1.5144> <-10.8837, 4.9666, 1.5613> <-10.8121, 4.8950, 1.6066> <-10.8269, 4.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 3.7626, 1.5144> <-10.8495, 3.7284, 1.5144> <-9.7138, 3.7284, 1.5144> <-9.6796, 3.7626, 1.5144>
		<-10.8837, 3.7626, 1.5613> <-10.8495, 3.7284, 1.5613> <-9.7138, 3.7284, 1.5613> <-9.6796, 3.7626, 1.5613>
		<-10.8121, 3.8341, 1.6066> <-10.7812, 3.8032, 1.6066> <-9.7822, 3.8032, 1.6066> <-9.7512, 3.8341, 1.6066>
		<-10.8269, 3.8193, 1.6486> <-10.7959, 3.7884, 1.6486> <-9.7674, 3.7884, 1.6486> <-9.7364, 3.8193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 3.7626, 1.5144> <-9.6455, 3.7968, 1.5144> <-9.6455, 4.9324, 1.5144> <-9.6796, 4.9666, 1.5144>
		<-9.6796, 3.7626, 1.5613> <-9.6455, 3.7968, 1.5613> <-9.6455, 4.9324, 1.5613> <-9.6796, 4.9666, 1.5613>
		<-9.7512, 3.8341, 1.6066> <-9.7202, 3.8651, 1.6066> <-9.7202, 4.8641, 1.6066> <-9.7512, 4.8950, 1.6066>
		<-9.7364, 3.8193, 1.6486> <-9.7054, 3.8503, 1.6486> <-9.7054, 4.8789, 1.6486> <-9.7364, 4.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 4.9666, 1.5144> <-9.7138, 5.0008, 1.5144> <-10.8495, 5.0008, 1.5144> <-10.8837, 4.9666, 1.5144>
		<-9.6796, 4.9666, 1.5613> <-9.7138, 5.0008, 1.5613> <-10.8495, 5.0008, 1.5613> <-10.8837, 4.9666, 1.5613>
		<-9.7512, 4.8950, 1.6066> <-9.7822, 4.9260, 1.6066> <-10.7812, 4.9260, 1.6066> <-10.8121, 4.8950, 1.6066>
		<-9.7364, 4.9098, 1.6486> <-9.7674, 4.9408, 1.6486> <-10.7959, 4.9408, 1.6486> <-10.8269, 4.9098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 3.8193, 1.6486> <-10.8754, 3.7709, 1.7862> <-11.0172, 3.6290, 1.8960> <-11.0664, 3.5799, 2.0332>
		<-10.8579, 3.8503, 1.6486> <-10.9063, 3.8018, 1.7862> <-11.0618, 3.6736, 1.8960> <-11.1109, 3.6245, 2.0332>
		<-10.8579, 4.8789, 1.6486> <-10.9063, 4.9273, 1.7862> <-11.0618, 5.0556, 1.8960> <-11.1109, 5.1047, 2.0332>
		<-10.8269, 4.9098, 1.6486> <-10.8754, 4.9583, 1.7862> <-11.0172, 5.1002, 1.8960> <-11.0664, 5.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 3.8193, 1.6486> <-10.7959, 3.7884, 1.6486> <-9.7674, 3.7884, 1.6486> <-9.7364, 3.8193, 1.6486>
		<-10.8754, 3.7709, 1.7862> <-10.8444, 3.7399, 1.7862> <-9.7189, 3.7399, 1.7862> <-9.6880, 3.7709, 1.7862>
		<-11.0172, 3.6290, 1.8960> <-10.9727, 3.5844, 1.8960> <-9.5907, 3.5844, 1.8960> <-9.5461, 3.6290, 1.8960>
		<-11.0664, 3.5799, 2.0332> <-11.0218, 3.5353, 2.0332> <-9.5415, 3.5353, 2.0332> <-9.4970, 3.5799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 3.8193, 1.6486> <-9.7054, 3.8503, 1.6486> <-9.7054, 4.8789, 1.6486> <-9.7364, 4.9098, 1.6486>
		<-9.6880, 3.7709, 1.7862> <-9.6570, 3.8018, 1.7862> <-9.6570, 4.9273, 1.7862> <-9.6880, 4.9583, 1.7862>
		<-9.5461, 3.6290, 1.8960> <-9.5015, 3.6736, 1.8960> <-9.5015, 5.0556, 1.8960> <-9.5461, 5.1002, 1.8960>
		<-9.4970, 3.5799, 2.0332> <-9.4524, 3.6245, 2.0332> <-9.4524, 5.1047, 2.0332> <-9.4970, 5.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 4.9098, 1.6486> <-9.7674, 4.9408, 1.6486> <-10.7959, 4.9408, 1.6486> <-10.8269, 4.9098, 1.6486>
		<-9.6880, 4.9583, 1.7862> <-9.7189, 4.9893, 1.7862> <-10.8444, 4.9893, 1.7862> <-10.8754, 4.9583, 1.7862>
		<-9.5461, 5.1002, 1.8960> <-9.5907, 5.1447, 1.8960> <-10.9727, 5.1447, 1.8960> <-11.0172, 5.1002, 1.8960>
		<-9.4970, 5.1493, 2.0332> <-9.5415, 5.1939, 2.0332> <-11.0218, 5.1939, 2.0332> <-11.0664, 5.1493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 2.0332> <-11.0930, 3.5533, 2.1074> <-11.0932, 3.5531, 2.2382> <-11.0641, 3.5822, 2.3104>
		<-11.1109, 3.6245, 2.0332> <-11.1375, 3.5979, 2.1074> <-11.1376, 3.5975, 2.2382> <-11.1085, 3.6266, 2.3104>
		<-11.1109, 5.1047, 2.0332> <-11.1375, 5.1313, 2.1074> <-11.1376, 5.1317, 2.2382> <-11.1085, 5.1025, 2.3104>
		<-11.0664, 5.1493, 2.0332> <-11.0930, 5.1759, 2.1074> <-11.0932, 5.1761, 2.2382> <-11.0641, 5.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 3.5799, 2.0332> <-11.0218, 3.5353, 2.0332> <-9.5415, 3.5353, 2.0332> <-9.4970, 3.5799, 2.0332>
		<-11.0930, 3.5533, 2.1074> <-11.0484, 3.5087, 2.1074> <-9.5149, 3.5087, 2.1074> <-9.4704, 3.5533, 2.1074>
		<-11.0932, 3.5531, 2.2382> <-11.0488, 3.5086, 2.2382> <-9.5146, 3.5086, 2.2382> <-9.4701, 3.5531, 2.2382>
		<-11.0641, 3.5822, 2.3104> <-11.0196, 3.5378, 2.3104> <-9.5437, 3.5378, 2.3104> <-9.4993, 3.5822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 3.5799, 2.0332> <-9.4524, 3.6245, 2.0332> <-9.4524, 5.1047, 2.0332> <-9.4970, 5.1493, 2.0332>
		<-9.4704, 3.5533, 2.1074> <-9.4258, 3.5979, 2.1074> <-9.4258, 5.1313, 2.1074> <-9.4704, 5.1759, 2.1074>
		<-9.4701, 3.5531, 2.2382> <-9.4257, 3.5975, 2.2382> <-9.4257, 5.1317, 2.2382> <-9.4701, 5.1761, 2.2382>
		<-9.4993, 3.5822, 2.3104> <-9.4548, 3.6266, 2.3104> <-9.4548, 5.1025, 2.3104> <-9.4993, 5.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 5.1493, 2.0332> <-9.5415, 5.1939, 2.0332> <-11.0218, 5.1939, 2.0332> <-11.0664, 5.1493, 2.0332>
		<-9.4704, 5.1759, 2.1074> <-9.5149, 5.2204, 2.1074> <-11.0484, 5.2204, 2.1074> <-11.0930, 5.1759, 2.1074>
		<-9.4701, 5.1761, 2.2382> <-9.5146, 5.2206, 2.2382> <-11.0488, 5.2206, 2.2382> <-11.0932, 5.1761, 2.2382>
		<-9.4993, 5.1470, 2.3104> <-9.5437, 5.1914, 2.3104> <-11.0196, 5.1914, 2.3104> <-11.0641, 5.1470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 3.5822, 2.3104> <-10.9801, 3.6661, 2.5186> <-10.7843, 3.8620, 2.7154> <-10.7056, 3.9406, 2.9276>
		<-11.1085, 3.6266, 2.3104> <-11.0246, 3.7106, 2.5186> <-10.8084, 3.8860, 2.7154> <-10.7297, 3.9647, 2.9276>
		<-11.1085, 5.1025, 2.3104> <-11.0246, 5.0186, 2.5186> <-10.8084, 4.8431, 2.7154> <-10.7297, 4.7645, 2.9276>
		<-11.0641, 5.1470, 2.3104> <-10.9801, 5.0630, 2.5186> <-10.7843, 4.8672, 2.7154> <-10.7056, 4.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 3.5822, 2.3104> <-11.0196, 3.5378, 2.3104> <-9.5437, 3.5378, 2.3104> <-9.4993, 3.5822, 2.3104>
		<-10.9801, 3.6661, 2.5186> <-10.9357, 3.6217, 2.5186> <-9.6277, 3.6217, 2.5186> <-9.5832, 3.6661, 2.5186>
		<-10.7843, 3.8620, 2.7154> <-10.7602, 3.8379, 2.7154> <-9.8031, 3.8379, 2.7154> <-9.7790, 3.8620, 2.7154>
		<-10.7056, 3.9406, 2.9276> <-10.6815, 3.9165, 2.9276> <-9.8818, 3.9165, 2.9276> <-9.8577, 3.9406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 3.5822, 2.3104> <-9.4548, 3.6266, 2.3104> <-9.4548, 5.1025, 2.3104> <-9.4993, 5.1470, 2.3104>
		<-9.5832, 3.6661, 2.5186> <-9.5388, 3.7106, 2.5186> <-9.5388, 5.0186, 2.5186> <-9.5832, 5.0630, 2.5186>
		<-9.7790, 3.8620, 2.7154> <-9.7550, 3.8860, 2.7154> <-9.7550, 4.8431, 2.7154> <-9.7790, 4.8672, 2.7154>
		<-9.8577, 3.9406, 2.9276> <-9.8336, 3.9647, 2.9276> <-9.8336, 4.7645, 2.9276> <-9.8577, 4.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 5.1470, 2.3104> <-9.5437, 5.1914, 2.3104> <-11.0196, 5.1914, 2.3104> <-11.0641, 5.1470, 2.3104>
		<-9.5832, 5.0630, 2.5186> <-9.6277, 5.1075, 2.5186> <-10.9357, 5.1075, 2.5186> <-10.9801, 5.0630, 2.5186>
		<-9.7790, 4.8672, 2.7154> <-9.8031, 4.8913, 2.7154> <-10.7602, 4.8913, 2.7154> <-10.7843, 4.8672, 2.7154>
		<-9.8577, 4.7885, 2.9276> <-9.8818, 4.8126, 2.9276> <-10.6815, 4.8126, 2.9276> <-10.7056, 4.7885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 3.9406, 2.9276> <-10.6887, 3.9576, 2.9732> <-10.7889, 3.8574, 3.0012> <-10.7889, 3.8574, 3.0528>
		<-10.7297, 3.9647, 2.9276> <-10.7128, 3.9816, 2.9732> <-10.8177, 3.8862, 3.0012> <-10.8177, 3.8862, 3.0528>
		<-10.7297, 4.7645, 2.9276> <-10.7128, 4.7475, 2.9732> <-10.8177, 4.8430, 3.0012> <-10.8177, 4.8430, 3.0528>
		<-10.7056, 4.7885, 2.9276> <-10.6887, 4.7716, 2.9732> <-10.7889, 4.8718, 3.0012> <-10.7889, 4.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 3.9406, 2.9276> <-10.6815, 3.9165, 2.9276> <-9.8818, 3.9165, 2.9276> <-9.8577, 3.9406, 2.9276>
		<-10.6887, 3.9576, 2.9732> <-10.6646, 3.9335, 2.9732> <-9.8987, 3.9335, 2.9732> <-9.8746, 3.9576, 2.9732>
		<-10.7889, 3.8574, 3.0012> <-10.7601, 3.8286, 3.0012> <-9.8033, 3.8286, 3.0012> <-9.7745, 3.8574, 3.0012>
		<-10.7889, 3.8574, 3.0528> <-10.7601, 3.8286, 3.0528> <-9.8033, 3.8286, 3.0528> <-9.7745, 3.8574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 3.9406, 2.9276> <-9.8336, 3.9647, 2.9276> <-9.8336, 4.7645, 2.9276> <-9.8577, 4.7885, 2.9276>
		<-9.8746, 3.9576, 2.9732> <-9.8506, 3.9816, 2.9732> <-9.8506, 4.7475, 2.9732> <-9.8746, 4.7716, 2.9732>
		<-9.7745, 3.8574, 3.0012> <-9.7456, 3.8862, 3.0012> <-9.7456, 4.8430, 3.0012> <-9.7745, 4.8718, 3.0012>
		<-9.7745, 3.8574, 3.0528> <-9.7456, 3.8862, 3.0528> <-9.7456, 4.8430, 3.0528> <-9.7745, 4.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 4.7885, 2.9276> <-9.8818, 4.8126, 2.9276> <-10.6815, 4.8126, 2.9276> <-10.7056, 4.7885, 2.9276>
		<-9.8746, 4.7716, 2.9732> <-9.8987, 4.7957, 2.9732> <-10.6646, 4.7957, 2.9732> <-10.6887, 4.7716, 2.9732>
		<-9.7745, 4.8718, 3.0012> <-9.8033, 4.9006, 3.0012> <-10.7601, 4.9006, 3.0012> <-10.7889, 4.8718, 3.0012>
		<-9.7745, 4.8718, 3.0528> <-9.8033, 4.9006, 3.0528> <-10.7601, 4.9006, 3.0528> <-10.7889, 4.8718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 3.8574, 3.0528> <-10.7889, 3.8574, 3.1044> <-10.6862, 3.9600, 3.1344> <-10.7056, 3.9406, 3.1780>
		<-10.8177, 3.8862, 3.0528> <-10.8177, 3.8862, 3.1044> <-10.7103, 3.9841, 3.1344> <-10.7297, 3.9647, 3.1780>
		<-10.8177, 4.8430, 3.0528> <-10.8177, 4.8430, 3.1044> <-10.7103, 4.7451, 3.1344> <-10.7297, 4.7645, 3.1780>
		<-10.7889, 4.8718, 3.0528> <-10.7889, 4.8718, 3.1044> <-10.6862, 4.7691, 3.1344> <-10.7056, 4.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 3.8574, 3.0528> <-10.7601, 3.8286, 3.0528> <-9.8033, 3.8286, 3.0528> <-9.7745, 3.8574, 3.0528>
		<-10.7889, 3.8574, 3.1044> <-10.7601, 3.8286, 3.1044> <-9.8033, 3.8286, 3.1044> <-9.7745, 3.8574, 3.1044>
		<-10.6862, 3.9600, 3.1344> <-10.6621, 3.9360, 3.1344> <-9.9012, 3.9360, 3.1344> <-9.8771, 3.9600, 3.1344>
		<-10.7056, 3.9406, 3.1780> <-10.6815, 3.9165, 3.1780> <-9.8818, 3.9165, 3.1780> <-9.8577, 3.9406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 3.8574, 3.0528> <-9.7456, 3.8862, 3.0528> <-9.7456, 4.8430, 3.0528> <-9.7745, 4.8718, 3.0528>
		<-9.7745, 3.8574, 3.1044> <-9.7456, 3.8862, 3.1044> <-9.7456, 4.8430, 3.1044> <-9.7745, 4.8718, 3.1044>
		<-9.8771, 3.9600, 3.1344> <-9.8530, 3.9841, 3.1344> <-9.8530, 4.7451, 3.1344> <-9.8771, 4.7691, 3.1344>
		<-9.8577, 3.9406, 3.1780> <-9.8336, 3.9647, 3.1780> <-9.8336, 4.7645, 3.1780> <-9.8577, 4.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 4.8718, 3.0528> <-9.8033, 4.9006, 3.0528> <-10.7601, 4.9006, 3.0528> <-10.7889, 4.8718, 3.0528>
		<-9.7745, 4.8718, 3.1044> <-9.8033, 4.9006, 3.1044> <-10.7601, 4.9006, 3.1044> <-10.7889, 4.8718, 3.1044>
		<-9.8771, 4.7691, 3.1344> <-9.9012, 4.7932, 3.1344> <-10.6621, 4.7932, 3.1344> <-10.6862, 4.7691, 3.1344>
		<-9.8577, 4.7885, 3.1780> <-9.8818, 4.8126, 3.1780> <-10.6815, 4.8126, 3.1780> <-10.7056, 4.7885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 3.9406, 3.1780> <-10.7438, 3.9024, 3.2640> <-10.8610, 3.7852, 3.2738> <-10.9161, 3.7302, 3.3390>
		<-10.7297, 3.9647, 3.1780> <-10.7679, 3.9265, 3.2640> <-10.8971, 3.8212, 3.2738> <-10.9521, 3.7662, 3.3390>
		<-10.7297, 4.7645, 3.1780> <-10.7679, 4.8027, 3.2640> <-10.8971, 4.9079, 3.2738> <-10.9521, 4.9629, 3.3390>
		<-10.7056, 4.7885, 3.1780> <-10.7438, 4.8267, 3.2640> <-10.8610, 4.9440, 3.2738> <-10.9161, 4.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 3.9406, 3.1780> <-10.6815, 3.9165, 3.1780> <-9.8818, 3.9165, 3.1780> <-9.8577, 3.9406, 3.1780>
		<-10.7438, 3.9024, 3.2640> <-10.7197, 3.8784, 3.2640> <-9.8436, 3.8784, 3.2640> <-9.8195, 3.9024, 3.2640>
		<-10.8610, 3.7852, 3.2738> <-10.8250, 3.7492, 3.2738> <-9.7383, 3.7492, 3.2738> <-9.7023, 3.7852, 3.2738>
		<-10.9161, 3.7302, 3.3390> <-10.8800, 3.6942, 3.3390> <-9.6833, 3.6942, 3.3390> <-9.6473, 3.7302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 3.9406, 3.1780> <-9.8336, 3.9647, 3.1780> <-9.8336, 4.7645, 3.1780> <-9.8577, 4.7885, 3.1780>
		<-9.8195, 3.9024, 3.2640> <-9.7954, 3.9265, 3.2640> <-9.7954, 4.8027, 3.2640> <-9.8195, 4.8267, 3.2640>
		<-9.7023, 3.7852, 3.2738> <-9.6663, 3.8212, 3.2738> <-9.6663, 4.9079, 3.2738> <-9.7023, 4.9440, 3.2738>
		<-9.6473, 3.7302, 3.3390> <-9.6112, 3.7662, 3.3390> <-9.6112, 4.9629, 3.3390> <-9.6473, 4.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 4.7885, 3.1780> <-9.8818, 4.8126, 3.1780> <-10.6815, 4.8126, 3.1780> <-10.7056, 4.7885, 3.1780>
		<-9.8195, 4.8267, 3.2640> <-9.8436, 4.8508, 3.2640> <-10.7197, 4.8508, 3.2640> <-10.7438, 4.8267, 3.2640>
		<-9.7023, 4.9440, 3.2738> <-9.7383, 4.9800, 3.2738> <-10.8250, 4.9800, 3.2738> <-10.8610, 4.9440, 3.2738>
		<-9.6473, 4.9990, 3.3390> <-9.6833, 5.0350, 3.3390> <-10.8800, 5.0350, 3.3390> <-10.9161, 4.9990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 3.7302, 3.3390> <-10.9416, 3.7046, 3.3693> <-10.9797, 3.6665, 3.4419> <-10.9623, 3.6839, 3.4821>
		<-10.9521, 3.7662, 3.3390> <-10.9777, 3.7406, 3.3693> <-11.0184, 3.7052, 3.4419> <-11.0010, 3.7226, 3.4821>
		<-10.9521, 4.9629, 3.3390> <-10.9777, 4.9885, 3.3693> <-11.0184, 5.0240, 3.4419> <-11.0010, 5.0066, 3.4821>
		<-10.9161, 4.9990, 3.3390> <-10.9416, 5.0246, 3.3693> <-10.9797, 5.0627, 3.4419> <-10.9623, 5.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 3.7302, 3.3390> <-10.8800, 3.6942, 3.3390> <-9.6833, 3.6942, 3.3390> <-9.6473, 3.7302, 3.3390>
		<-10.9416, 3.7046, 3.3693> <-10.9056, 3.6686, 3.3693> <-9.6577, 3.6686, 3.3693> <-9.6217, 3.7046, 3.3693>
		<-10.9797, 3.6665, 3.4419> <-10.9411, 3.6279, 3.4419> <-9.6223, 3.6279, 3.4419> <-9.5836, 3.6665, 3.4419>
		<-10.9623, 3.6839, 3.4821> <-10.9236, 3.6453, 3.4821> <-9.6397, 3.6453, 3.4821> <-9.6010, 3.6839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 3.7302, 3.3390> <-9.6112, 3.7662, 3.3390> <-9.6112, 4.9629, 3.3390> <-9.6473, 4.9990, 3.3390>
		<-9.6217, 3.7046, 3.3693> <-9.5857, 3.7406, 3.3693> <-9.5857, 4.9885, 3.3693> <-9.6217, 5.0246, 3.3693>
		<-9.5836, 3.6665, 3.4419> <-9.5449, 3.7052, 3.4419> <-9.5449, 5.0240, 3.4419> <-9.5836, 5.0627, 3.4419>
		<-9.6010, 3.6839, 3.4821> <-9.5624, 3.7226, 3.4821> <-9.5624, 5.0066, 3.4821> <-9.6010, 5.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 4.9990, 3.3390> <-9.6833, 5.0350, 3.3390> <-10.8800, 5.0350, 3.3390> <-10.9161, 4.9990, 3.3390>
		<-9.6217, 5.0246, 3.3693> <-9.6577, 5.0606, 3.3693> <-10.9056, 5.0606, 3.3693> <-10.9416, 5.0246, 3.3693>
		<-9.5836, 5.0627, 3.4419> <-9.6223, 5.1013, 3.4419> <-10.9411, 5.1013, 3.4419> <-10.9797, 5.0627, 3.4419>
		<-9.6010, 5.0452, 3.4821> <-9.6397, 5.0839, 3.4821> <-10.9236, 5.0839, 3.4821> <-10.9623, 5.0452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 3.6839, 3.4821> <-10.9163, 3.7300, 3.5884> <-10.7961, 3.8502, 3.6567> <-10.7380, 3.9083, 3.7504>
		<-11.0010, 3.7226, 3.4821> <-10.9550, 3.7686, 3.5884> <-10.8220, 3.8761, 3.6567> <-10.7639, 3.9342, 3.7504>
		<-11.0010, 5.0066, 3.4821> <-10.9550, 4.9606, 3.5884> <-10.8220, 4.8531, 3.6567> <-10.7639, 4.7950, 3.7504>
		<-10.9623, 5.0452, 3.4821> <-10.9163, 4.9992, 3.5884> <-10.7961, 4.8790, 3.6567> <-10.7380, 4.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 3.6839, 3.4821> <-10.9236, 3.6453, 3.4821> <-9.6397, 3.6453, 3.4821> <-9.6010, 3.6839, 3.4821>
		<-10.9163, 3.7300, 3.5884> <-10.8776, 3.6913, 3.5884> <-9.6857, 3.6913, 3.5884> <-9.6470, 3.7300, 3.5884>
		<-10.7961, 3.8502, 3.6567> <-10.7702, 3.8242, 3.6567> <-9.7932, 3.8242, 3.6567> <-9.7672, 3.8502, 3.6567>
		<-10.7380, 3.9083, 3.7504> <-10.7121, 3.8823, 3.7504> <-9.8513, 3.8823, 3.7504> <-9.8253, 3.9083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 3.6839, 3.4821> <-9.5624, 3.7226, 3.4821> <-9.5624, 5.0066, 3.4821> <-9.6010, 5.0452, 3.4821>
		<-9.6470, 3.7300, 3.5884> <-9.6084, 3.7686, 3.5884> <-9.6084, 4.9606, 3.5884> <-9.6470, 4.9992, 3.5884>
		<-9.7672, 3.8502, 3.6567> <-9.7413, 3.8761, 3.6567> <-9.7413, 4.8531, 3.6567> <-9.7672, 4.8790, 3.6567>
		<-9.8253, 3.9083, 3.7504> <-9.7994, 3.9342, 3.7504> <-9.7994, 4.7950, 3.7504> <-9.8253, 4.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 5.0452, 3.4821> <-9.6397, 5.0839, 3.4821> <-10.9236, 5.0839, 3.4821> <-10.9623, 5.0452, 3.4821>
		<-9.6470, 4.9992, 3.5884> <-9.6857, 5.0379, 3.5884> <-10.8776, 5.0379, 3.5884> <-10.9163, 4.9992, 3.5884>
		<-9.7672, 4.8790, 3.6567> <-9.7932, 4.9049, 3.6567> <-10.7702, 4.9049, 3.6567> <-10.7961, 4.8790, 3.6567>
		<-9.8253, 4.8209, 3.7504> <-9.8513, 4.8468, 3.7504> <-10.7121, 4.8468, 3.7504> <-10.7380, 4.8209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 3.9083, 3.7504> <-10.6964, 3.9498, 3.8175> <-10.6527, 3.9935, 3.9241> <-10.6352, 4.0110, 4.0098>
		<-10.7639, 3.9342, 3.7504> <-10.7223, 3.9757, 3.8175> <-10.6728, 4.0136, 3.9241> <-10.6553, 4.0311, 4.0098>
		<-10.7639, 4.7950, 3.7504> <-10.7223, 4.7534, 3.8175> <-10.6728, 4.7156, 3.9241> <-10.6553, 4.6981, 4.0098>
		<-10.7380, 4.8209, 3.7504> <-10.6964, 4.7793, 3.8175> <-10.6527, 4.7356, 3.9241> <-10.6352, 4.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 3.9083, 3.7504> <-10.7121, 3.8823, 3.7504> <-9.8513, 3.8823, 3.7504> <-9.8253, 3.9083, 3.7504>
		<-10.6964, 3.9498, 3.8175> <-10.6705, 3.9239, 3.8175> <-9.8928, 3.9239, 3.8175> <-9.8669, 3.9498, 3.8175>
		<-10.6527, 3.9935, 3.9241> <-10.6326, 3.9734, 3.9241> <-9.9307, 3.9734, 3.9241> <-9.9106, 3.9935, 3.9241>
		<-10.6352, 4.0110, 4.0098> <-10.6152, 3.9909, 4.0098> <-9.9482, 3.9909, 4.0098> <-9.9281, 4.0110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 3.9083, 3.7504> <-9.7994, 3.9342, 3.7504> <-9.7994, 4.7950, 3.7504> <-9.8253, 4.8209, 3.7504>
		<-9.8669, 3.9498, 3.8175> <-9.8410, 3.9757, 3.8175> <-9.8410, 4.7534, 3.8175> <-9.8669, 4.7793, 3.8175>
		<-9.9106, 3.9935, 3.9241> <-9.8905, 4.0136, 3.9241> <-9.8905, 4.7156, 3.9241> <-9.9106, 4.7356, 3.9241>
		<-9.9281, 4.0110, 4.0098> <-9.9080, 4.0311, 4.0098> <-9.9080, 4.6981, 4.0098> <-9.9281, 4.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 4.8209, 3.7504> <-9.8513, 4.8468, 3.7504> <-10.7121, 4.8468, 3.7504> <-10.7380, 4.8209, 3.7504>
		<-9.8669, 4.7793, 3.8175> <-9.8928, 4.8053, 3.8175> <-10.6705, 4.8053, 3.8175> <-10.6964, 4.7793, 3.8175>
		<-9.9106, 4.7356, 3.9241> <-9.9307, 4.7557, 3.9241> <-10.6326, 4.7557, 3.9241> <-10.6527, 4.7356, 3.9241>
		<-9.9281, 4.7182, 4.0098> <-9.9482, 4.7383, 4.0098> <-10.6152, 4.7383, 4.0098> <-10.6352, 4.7182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 4.0110, 4.0098> <-10.6168, 4.0294, 4.1002> <-10.6221, 4.0242, 4.2288> <-10.6213, 4.0250, 4.3229>
		<-10.6553, 4.0311, 4.0098> <-10.6369, 4.0495, 4.1002> <-10.6413, 4.0435, 4.2288> <-10.6405, 4.0443, 4.3229>
		<-10.6553, 4.6981, 4.0098> <-10.6369, 4.6797, 4.1002> <-10.6413, 4.6857, 4.2288> <-10.6405, 4.6849, 4.3229>
		<-10.6352, 4.7182, 4.0098> <-10.6168, 4.6997, 4.1002> <-10.6221, 4.7050, 4.2288> <-10.6213, 4.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 4.0110, 4.0098> <-10.6152, 3.9909, 4.0098> <-9.9482, 3.9909, 4.0098> <-9.9281, 4.0110, 4.0098>
		<-10.6168, 4.0294, 4.1002> <-10.5967, 4.0094, 4.1002> <-9.9666, 4.0094, 4.1002> <-9.9465, 4.0294, 4.1002>
		<-10.6221, 4.0242, 4.2288> <-10.6028, 4.0049, 4.2288> <-9.9606, 4.0049, 4.2288> <-9.9413, 4.0242, 4.2288>
		<-10.6213, 4.0250, 4.3229> <-10.6020, 4.0057, 4.3229> <-9.9614, 4.0057, 4.3229> <-9.9421, 4.0250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 4.0110, 4.0098> <-9.9080, 4.0311, 4.0098> <-9.9080, 4.6981, 4.0098> <-9.9281, 4.7182, 4.0098>
		<-9.9465, 4.0294, 4.1002> <-9.9264, 4.0495, 4.1002> <-9.9264, 4.6797, 4.1002> <-9.9465, 4.6997, 4.1002>
		<-9.9413, 4.0242, 4.2288> <-9.9220, 4.0435, 4.2288> <-9.9220, 4.6857, 4.2288> <-9.9413, 4.7050, 4.2288>
		<-9.9421, 4.0250, 4.3229> <-9.9228, 4.0443, 4.3229> <-9.9228, 4.6849, 4.3229> <-9.9421, 4.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 4.7182, 4.0098> <-9.9482, 4.7383, 4.0098> <-10.6152, 4.7383, 4.0098> <-10.6352, 4.7182, 4.0098>
		<-9.9465, 4.6997, 4.1002> <-9.9666, 4.7198, 4.1002> <-10.5967, 4.7198, 4.1002> <-10.6168, 4.6997, 4.1002>
		<-9.9413, 4.7050, 4.2288> <-9.9606, 4.7243, 4.2288> <-10.6028, 4.7243, 4.2288> <-10.6221, 4.7050, 4.2288>
		<-9.9421, 4.7042, 4.3229> <-9.9614, 4.7235, 4.3229> <-10.6020, 4.7235, 4.3229> <-10.6213, 4.7042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 4.0250, 4.3229> <-10.6179, 4.0284, 4.7283> <-10.6197, 4.0265, 5.2689> <-10.6213, 4.0250, 5.6744>
		<-10.6405, 4.0443, 4.3229> <-10.6371, 4.0477, 4.7283> <-10.6390, 4.0458, 5.2689> <-10.6405, 4.0443, 5.6744>
		<-10.6405, 4.6849, 4.3229> <-10.6371, 4.6815, 4.7283> <-10.6390, 4.6834, 5.2689> <-10.6405, 4.6849, 5.6744>
		<-10.6213, 4.7042, 4.3229> <-10.6179, 4.7008, 4.7283> <-10.6197, 4.7027, 5.2689> <-10.6213, 4.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 4.0250, 4.3229> <-10.6020, 4.0057, 4.3229> <-9.9614, 4.0057, 4.3229> <-9.9421, 4.0250, 4.3229>
		<-10.6179, 4.0284, 4.7283> <-10.5986, 4.0091, 4.7283> <-9.9648, 4.0091, 4.7283> <-9.9455, 4.0284, 4.7283>
		<-10.6197, 4.0265, 5.2689> <-10.6004, 4.0072, 5.2689> <-9.9629, 4.0072, 5.2689> <-9.9436, 4.0265, 5.2689>
		<-10.6213, 4.0250, 5.6744> <-10.6020, 4.0057, 5.6744> <-9.9614, 4.0057, 5.6744> <-9.9421, 4.0250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 4.0250, 4.3229> <-9.9228, 4.0443, 4.3229> <-9.9228, 4.6849, 4.3229> <-9.9421, 4.7042, 4.3229>
		<-9.9455, 4.0284, 4.7283> <-9.9262, 4.0477, 4.7283> <-9.9262, 4.6815, 4.7283> <-9.9455, 4.7008, 4.7283>
		<-9.9436, 4.0265, 5.2689> <-9.9243, 4.0458, 5.2689> <-9.9243, 4.6834, 5.2689> <-9.9436, 4.7027, 5.2689>
		<-9.9421, 4.0250, 5.6744> <-9.9228, 4.0443, 5.6744> <-9.9228, 4.6849, 5.6744> <-9.9421, 4.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 4.7042, 4.3229> <-9.9614, 4.7235, 4.3229> <-10.6020, 4.7235, 4.3229> <-10.6213, 4.7042, 4.3229>
		<-9.9455, 4.7008, 4.7283> <-9.9648, 4.7201, 4.7283> <-10.5986, 4.7201, 4.7283> <-10.6179, 4.7008, 4.7283>
		<-9.9436, 4.7027, 5.2689> <-9.9629, 4.7219, 5.2689> <-10.6004, 4.7219, 5.2689> <-10.6197, 4.7027, 5.2689>
		<-9.9421, 4.7042, 5.6744> <-9.9614, 4.7235, 5.6744> <-10.6020, 4.7235, 5.6744> <-10.6213, 4.7042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 4.0250, 5.6744> <-10.6225, 4.0237, 6.0073> <-10.6172, 4.0290, 6.4517> <-10.6305, 4.0157, 6.7841>
		<-10.6405, 4.0443, 5.6744> <-10.6418, 4.0430, 6.0073> <-10.6371, 4.0488, 6.4517> <-10.6503, 4.0355, 6.7841>
		<-10.6405, 4.6849, 5.6744> <-10.6418, 4.6861, 6.0073> <-10.6371, 4.6804, 6.4517> <-10.6503, 4.6936, 6.7841>
		<-10.6213, 4.7042, 5.6744> <-10.6225, 4.7054, 6.0073> <-10.6172, 4.7002, 6.4517> <-10.6305, 4.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 4.0250, 5.6744> <-10.6020, 4.0057, 5.6744> <-9.9614, 4.0057, 5.6744> <-9.9421, 4.0250, 5.6744>
		<-10.6225, 4.0237, 6.0073> <-10.6032, 4.0044, 6.0073> <-9.9601, 4.0044, 6.0073> <-9.9408, 4.0237, 6.0073>
		<-10.6172, 4.0290, 6.4517> <-10.5974, 4.0092, 6.4517> <-9.9659, 4.0092, 6.4517> <-9.9461, 4.0290, 6.4517>
		<-10.6305, 4.0157, 6.7841> <-10.6107, 3.9959, 6.7841> <-9.9526, 3.9959, 6.7841> <-9.9328, 4.0157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 4.0250, 5.6744> <-9.9228, 4.0443, 5.6744> <-9.9228, 4.6849, 5.6744> <-9.9421, 4.7042, 5.6744>
		<-9.9408, 4.0237, 6.0073> <-9.9215, 4.0430, 6.0073> <-9.9215, 4.6861, 6.0073> <-9.9408, 4.7054, 6.0073>
		<-9.9461, 4.0290, 6.4517> <-9.9263, 4.0488, 6.4517> <-9.9263, 4.6804, 6.4517> <-9.9461, 4.7002, 6.4517>
		<-9.9328, 4.0157, 6.7841> <-9.9130, 4.0355, 6.7841> <-9.9130, 4.6936, 6.7841> <-9.9328, 4.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 4.7042, 5.6744> <-9.9614, 4.7235, 5.6744> <-10.6020, 4.7235, 5.6744> <-10.6213, 4.7042, 5.6744>
		<-9.9408, 4.7054, 6.0073> <-9.9601, 4.7247, 6.0073> <-10.6032, 4.7247, 6.0073> <-10.6225, 4.7054, 6.0073>
		<-9.9461, 4.7002, 6.4517> <-9.9659, 4.7200, 6.4517> <-10.5974, 4.7200, 6.4517> <-10.6172, 4.7002, 6.4517>
		<-9.9328, 4.7134, 6.7841> <-9.9526, 4.7333, 6.7841> <-10.6107, 4.7333, 6.7841> <-10.6305, 4.7134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 4.0157, 6.7841> <-10.6325, 4.0137, 6.8341> <-10.6449, 4.0013, 6.9079> <-10.6718, 3.9745, 6.9405>
		<-10.6503, 4.0355, 6.7841> <-10.6523, 4.0336, 6.8341> <-10.6671, 4.0235, 6.9079> <-10.6940, 3.9966, 6.9405>
		<-10.6503, 4.6936, 6.7841> <-10.6523, 4.6956, 6.8341> <-10.6671, 4.7057, 6.9079> <-10.6940, 4.7326, 6.9405>
		<-10.6305, 4.7134, 6.7841> <-10.6325, 4.7154, 6.8341> <-10.6449, 4.7278, 6.9079> <-10.6718, 4.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 4.0157, 6.7841> <-10.6107, 3.9959, 6.7841> <-9.9526, 3.9959, 6.7841> <-9.9328, 4.0157, 6.7841>
		<-10.6325, 4.0137, 6.8341> <-10.6127, 3.9939, 6.8341> <-9.9506, 3.9939, 6.8341> <-9.9308, 4.0137, 6.8341>
		<-10.6449, 4.0013, 6.9079> <-10.6228, 3.9792, 6.9079> <-9.9406, 3.9792, 6.9079> <-9.9184, 4.0013, 6.9079>
		<-10.6718, 3.9745, 6.9405> <-10.6496, 3.9523, 6.9405> <-9.9137, 3.9523, 6.9405> <-9.8915, 3.9745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 4.0157, 6.7841> <-9.9130, 4.0355, 6.7841> <-9.9130, 4.6936, 6.7841> <-9.9328, 4.7134, 6.7841>
		<-9.9308, 4.0137, 6.8341> <-9.9110, 4.0336, 6.8341> <-9.9110, 4.6956, 6.8341> <-9.9308, 4.7154, 6.8341>
		<-9.9184, 4.0013, 6.9079> <-9.8962, 4.0235, 6.9079> <-9.8962, 4.7057, 6.9079> <-9.9184, 4.7278, 6.9079>
		<-9.8915, 3.9745, 6.9405> <-9.8694, 3.9966, 6.9405> <-9.8694, 4.7326, 6.9405> <-9.8915, 4.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 4.7134, 6.7841> <-9.9526, 4.7333, 6.7841> <-10.6107, 4.7333, 6.7841> <-10.6305, 4.7134, 6.7841>
		<-9.9308, 4.7154, 6.8341> <-9.9506, 4.7352, 6.8341> <-10.6127, 4.7352, 6.8341> <-10.6325, 4.7154, 6.8341>
		<-9.9184, 4.7278, 6.9079> <-9.9406, 4.7500, 6.9079> <-10.6228, 4.7500, 6.9079> <-10.6449, 4.7278, 6.9079>
		<-9.8915, 4.7547, 6.9405> <-9.9137, 4.7769, 6.9405> <-10.6496, 4.7769, 6.9405> <-10.6718, 4.7547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 3.9745, 6.9405> <-10.7339, 3.9123, 7.0160> <-10.8620, 3.7842, 7.0331> <-10.9114, 3.7348, 7.1255>
		<-10.6940, 3.9966, 6.9405> <-10.7561, 3.9345, 7.0160> <-10.8978, 3.8200, 7.0331> <-10.9472, 3.7706, 7.1255>
		<-10.6940, 4.7326, 6.9405> <-10.7561, 4.7947, 7.0160> <-10.8978, 4.9092, 7.0331> <-10.9472, 4.9586, 7.1255>
		<-10.6718, 4.7547, 6.9405> <-10.7339, 4.8168, 7.0160> <-10.8620, 4.9449, 7.0331> <-10.9114, 4.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 3.9745, 6.9405> <-10.6496, 3.9523, 6.9405> <-9.9137, 3.9523, 6.9405> <-9.8915, 3.9745, 6.9405>
		<-10.7339, 3.9123, 7.0160> <-10.7117, 3.8902, 7.0160> <-9.8516, 3.8902, 7.0160> <-9.8294, 3.9123, 7.0160>
		<-10.8620, 3.7842, 7.0331> <-10.8262, 3.7485, 7.0331> <-9.7371, 3.7485, 7.0331> <-9.7013, 3.7842, 7.0331>
		<-10.9114, 3.7348, 7.1255> <-10.8757, 3.6990, 7.1255> <-9.6877, 3.6990, 7.1255> <-9.6519, 3.7348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 3.9745, 6.9405> <-9.8694, 3.9966, 6.9405> <-9.8694, 4.7326, 6.9405> <-9.8915, 4.7547, 6.9405>
		<-9.8294, 3.9123, 7.0160> <-9.8073, 3.9345, 7.0160> <-9.8073, 4.7947, 7.0160> <-9.8294, 4.8168, 7.0160>
		<-9.7013, 3.7842, 7.0331> <-9.6655, 3.8200, 7.0331> <-9.6655, 4.9092, 7.0331> <-9.7013, 4.9449, 7.0331>
		<-9.6519, 3.7348, 7.1255> <-9.6161, 3.7706, 7.1255> <-9.6161, 4.9586, 7.1255> <-9.6519, 4.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 4.7547, 6.9405> <-9.9137, 4.7769, 6.9405> <-10.6496, 4.7769, 6.9405> <-10.6718, 4.7547, 6.9405>
		<-9.8294, 4.8168, 7.0160> <-9.8516, 4.8390, 7.0160> <-10.7117, 4.8390, 7.0160> <-10.7339, 4.8168, 7.0160>
		<-9.7013, 4.9449, 7.0331> <-9.7371, 4.9807, 7.0331> <-10.8262, 4.9807, 7.0331> <-10.8620, 4.9449, 7.0331>
		<-9.6519, 4.9944, 7.1255> <-9.6877, 5.0301, 7.1255> <-10.8757, 5.0301, 7.1255> <-10.9114, 4.9944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 3.7348, 7.1255> <-10.9319, 3.7143, 7.1638> <-10.8316, 3.8146, 7.1912> <-10.8316, 3.8146, 7.2393>
		<-10.9472, 3.7706, 7.1255> <-10.9677, 3.7501, 7.1638> <-10.8629, 3.8459, 7.1912> <-10.8629, 3.8459, 7.2393>
		<-10.9472, 4.9586, 7.1255> <-10.9677, 4.9791, 7.1638> <-10.8629, 4.8833, 7.1912> <-10.8629, 4.8833, 7.2393>
		<-10.9114, 4.9944, 7.1255> <-10.9319, 5.0149, 7.1638> <-10.8316, 4.9146, 7.1912> <-10.8316, 4.9146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 3.7348, 7.1255> <-10.8757, 3.6990, 7.1255> <-9.6877, 3.6990, 7.1255> <-9.6519, 3.7348, 7.1255>
		<-10.9319, 3.7143, 7.1638> <-10.8962, 3.6785, 7.1638> <-9.6671, 3.6785, 7.1638> <-9.6314, 3.7143, 7.1638>
		<-10.8316, 3.8146, 7.1912> <-10.8004, 3.7834, 7.1912> <-9.7629, 3.7834, 7.1912> <-9.7317, 3.8146, 7.1912>
		<-10.8316, 3.8146, 7.2393> <-10.8004, 3.7834, 7.2393> <-9.7629, 3.7834, 7.2393> <-9.7317, 3.8146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 3.7348, 7.1255> <-9.6161, 3.7706, 7.1255> <-9.6161, 4.9586, 7.1255> <-9.6519, 4.9944, 7.1255>
		<-9.6314, 3.7143, 7.1638> <-9.5956, 3.7501, 7.1638> <-9.5956, 4.9791, 7.1638> <-9.6314, 5.0149, 7.1638>
		<-9.7317, 3.8146, 7.1912> <-9.7005, 3.8459, 7.1912> <-9.7005, 4.8833, 7.1912> <-9.7317, 4.9146, 7.1912>
		<-9.7317, 3.8146, 7.2393> <-9.7005, 3.8459, 7.2393> <-9.7005, 4.8833, 7.2393> <-9.7317, 4.9146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 4.9944, 7.1255> <-9.6877, 5.0301, 7.1255> <-10.8757, 5.0301, 7.1255> <-10.9114, 4.9944, 7.1255>
		<-9.6314, 5.0149, 7.1638> <-9.6671, 5.0506, 7.1638> <-10.8962, 5.0506, 7.1638> <-10.9319, 5.0149, 7.1638>
		<-9.7317, 4.9146, 7.1912> <-9.7629, 4.9458, 7.1912> <-10.8004, 4.9458, 7.1912> <-10.8316, 4.9146, 7.1912>
		<-9.7317, 4.9146, 7.2393> <-9.7629, 4.9458, 7.2393> <-10.8004, 4.9458, 7.2393> <-10.8316, 4.9146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 3.8146, 7.2393> <-10.8316, 3.8146, 7.2905> <-10.9054, 3.7408, 7.3169> <-10.9114, 3.7348, 7.3673>
		<-10.8629, 3.8459, 7.2393> <-10.8629, 3.8459, 7.2905> <-10.9412, 3.7766, 7.3169> <-10.9472, 3.7706, 7.3673>
		<-10.8629, 4.8833, 7.2393> <-10.8629, 4.8833, 7.2905> <-10.9412, 4.9526, 7.3169> <-10.9472, 4.9586, 7.3673>
		<-10.8316, 4.9146, 7.2393> <-10.8316, 4.9146, 7.2905> <-10.9054, 4.9883, 7.3169> <-10.9114, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 3.8146, 7.2393> <-10.8004, 3.7834, 7.2393> <-9.7629, 3.7834, 7.2393> <-9.7317, 3.8146, 7.2393>
		<-10.8316, 3.8146, 7.2905> <-10.8004, 3.7834, 7.2905> <-9.7629, 3.7834, 7.2905> <-9.7317, 3.8146, 7.2905>
		<-10.9054, 3.7408, 7.3169> <-10.8696, 3.7051, 7.3169> <-9.6937, 3.7051, 7.3169> <-9.6579, 3.7408, 7.3169>
		<-10.9114, 3.7348, 7.3673> <-10.8757, 3.6990, 7.3673> <-9.6877, 3.6990, 7.3673> <-9.6519, 3.7348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 3.8146, 7.2393> <-9.7005, 3.8459, 7.2393> <-9.7005, 4.8833, 7.2393> <-9.7317, 4.9146, 7.2393>
		<-9.7317, 3.8146, 7.2905> <-9.7005, 3.8459, 7.2905> <-9.7005, 4.8833, 7.2905> <-9.7317, 4.9146, 7.2905>
		<-9.6579, 3.7408, 7.3169> <-9.6222, 3.7766, 7.3169> <-9.6222, 4.9526, 7.3169> <-9.6579, 4.9883, 7.3169>
		<-9.6519, 3.7348, 7.3673> <-9.6161, 3.7706, 7.3673> <-9.6161, 4.9586, 7.3673> <-9.6519, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 4.9146, 7.2393> <-9.7629, 4.9458, 7.2393> <-10.8004, 4.9458, 7.2393> <-10.8316, 4.9146, 7.2393>
		<-9.7317, 4.9146, 7.2905> <-9.7629, 4.9458, 7.2905> <-10.8004, 4.9458, 7.2905> <-10.8316, 4.9146, 7.2905>
		<-9.6579, 4.9883, 7.3169> <-9.6937, 5.0241, 7.3169> <-10.8696, 5.0241, 7.3169> <-10.9054, 4.9883, 7.3169>
		<-9.6519, 4.9944, 7.3673> <-9.6877, 5.0301, 7.3673> <-10.8757, 5.0301, 7.3673> <-10.9114, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 3.7348, 7.9080> <-10.9472, 3.7706, 7.9080> <-10.9472, 4.9586, 7.9080> <-10.9114, 4.9944, 7.9080>
		<-10.9114, 3.7348, 7.7458> <-10.9472, 3.7706, 7.7458> <-10.9472, 4.9586, 7.7458> <-10.9114, 4.9944, 7.7458>
		<-10.9305, 3.7157, 7.5273> <-10.9663, 3.7515, 7.5273> <-10.9663, 4.9777, 7.5273> <-10.9305, 5.0134, 7.5273>
		<-10.9114, 3.7348, 7.3673> <-10.9472, 3.7706, 7.3673> <-10.9472, 4.9586, 7.3673> <-10.9114, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 3.7348, 7.9080> <-10.9114, 3.7348, 7.7458> <-10.9305, 3.7157, 7.5273> <-10.9114, 3.7348, 7.3673>
		<-10.8757, 3.6990, 7.9080> <-10.8757, 3.6990, 7.7458> <-10.8947, 3.6800, 7.5273> <-10.8757, 3.6990, 7.3673>
		<-9.6877, 3.6990, 7.9080> <-9.6877, 3.6990, 7.7458> <-9.6686, 3.6800, 7.5273> <-9.6877, 3.6990, 7.3673>
		<-9.6519, 3.7348, 7.9080> <-9.6519, 3.7348, 7.7458> <-9.6328, 3.7157, 7.5273> <-9.6519, 3.7348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 3.7348, 7.9080> <-9.6519, 3.7348, 7.7458> <-9.6328, 3.7157, 7.5273> <-9.6519, 3.7348, 7.3673>
		<-9.6161, 3.7706, 7.9080> <-9.6161, 3.7706, 7.7458> <-9.5970, 3.7515, 7.5273> <-9.6161, 3.7706, 7.3673>
		<-9.6161, 4.9586, 7.9080> <-9.6161, 4.9586, 7.7458> <-9.5970, 4.9777, 7.5273> <-9.6161, 4.9586, 7.3673>
		<-9.6519, 4.9944, 7.9080> <-9.6519, 4.9944, 7.7458> <-9.6328, 5.0134, 7.5273> <-9.6519, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 4.9944, 7.9080> <-9.6519, 4.9944, 7.7458> <-9.6328, 5.0134, 7.5273> <-9.6519, 4.9944, 7.3673>
		<-9.6877, 5.0301, 7.9080> <-9.6877, 5.0301, 7.7458> <-9.6686, 5.0492, 7.5273> <-9.6877, 5.0301, 7.3673>
		<-10.8757, 5.0301, 7.9080> <-10.8757, 5.0301, 7.7458> <-10.8947, 5.0492, 7.5273> <-10.8757, 5.0301, 7.3673>
		<-10.9114, 4.9944, 7.9080> <-10.9114, 4.9944, 7.7458> <-10.9305, 5.0134, 7.5273> <-10.9114, 4.9944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 3.4874, 0.7771> <-11.2087, 3.5372, 0.7771> <-11.2087, 5.1920, 0.7771> <-11.1589, 5.2418, 0.7771>
		<-11.1796, 3.4666, 0.6520> <-11.2294, 3.5164, 0.6520> <-11.2294, 5.2127, 0.6520> <-11.1796, 5.2626, 0.6520>
		<-11.1589, 3.4874, 0.4772> <-11.2087, 3.5372, 0.4772> <-11.2087, 5.1920, 0.4772> <-11.1589, 5.2418, 0.4772>
		<-11.1589, 3.4874, 0.3486> <-11.2087, 3.5372, 0.3486> <-11.2087, 5.1920, 0.3486> <-11.1589, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 3.4874, 0.7771> <-11.1796, 3.4666, 0.6520> <-11.1589, 3.4874, 0.4772> <-11.1589, 3.4874, 0.3486>
		<-11.1090, 3.4376, 0.7771> <-11.1298, 3.4168, 0.6520> <-11.1090, 3.4376, 0.4772> <-11.1090, 3.4376, 0.3486>
		<-9.4543, 3.4376, 0.7771> <-9.4335, 3.4168, 0.6520> <-9.4543, 3.4376, 0.4772> <-9.4543, 3.4376, 0.3486>
		<-9.4045, 3.4874, 0.7771> <-9.3837, 3.4666, 0.6520> <-9.4045, 3.4874, 0.4772> <-9.4045, 3.4874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 3.4874, 0.7771> <-9.3837, 3.4666, 0.6520> <-9.4045, 3.4874, 0.4772> <-9.4045, 3.4874, 0.3486>
		<-9.3546, 3.5372, 0.7771> <-9.3339, 3.5164, 0.6520> <-9.3546, 3.5372, 0.4772> <-9.3546, 3.5372, 0.3486>
		<-9.3546, 5.1920, 0.7771> <-9.3339, 5.2127, 0.6520> <-9.3546, 5.1920, 0.4772> <-9.3546, 5.1920, 0.3486>
		<-9.4045, 5.2418, 0.7771> <-9.3837, 5.2626, 0.6520> <-9.4045, 5.2418, 0.4772> <-9.4045, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 5.2418, 0.7771> <-9.3837, 5.2626, 0.6520> <-9.4045, 5.2418, 0.4772> <-9.4045, 5.2418, 0.3486>
		<-9.4543, 5.2916, 0.7771> <-9.4335, 5.3124, 0.6520> <-9.4543, 5.2916, 0.4772> <-9.4543, 5.2916, 0.3486>
		<-11.1090, 5.2916, 0.7771> <-11.1298, 5.3124, 0.6520> <-11.1090, 5.2916, 0.4772> <-11.1090, 5.2916, 0.3486>
		<-11.1589, 5.2418, 0.7771> <-11.1796, 5.2626, 0.6520> <-11.1589, 5.2418, 0.4772> <-11.1589, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 3.4874, -0.0618> <-11.1589, 3.4874, 0.0613> <-11.1589, 3.4874, 0.2255> <-11.1589, 3.4874, 0.3486>
		<-11.2087, 3.5372, -0.0618> <-11.2087, 3.5372, 0.0613> <-11.2087, 3.5372, 0.2255> <-11.2087, 3.5372, 0.3486>
		<-11.2087, 5.1920, -0.0618> <-11.2087, 5.1920, 0.0613> <-11.2087, 5.1920, 0.2255> <-11.2087, 5.1920, 0.3486>
		<-11.1589, 5.2418, -0.0618> <-11.1589, 5.2418, 0.0613> <-11.1589, 5.2418, 0.2255> <-11.1589, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 3.4874, -0.0618> <-11.1090, 3.4376, -0.0618> <-9.4543, 3.4376, -0.0618> <-9.4045, 3.4874, -0.0618>
		<-11.1589, 3.4874, 0.0613> <-11.1090, 3.4376, 0.0613> <-9.4543, 3.4376, 0.0613> <-9.4045, 3.4874, 0.0613>
		<-11.1589, 3.4874, 0.2255> <-11.1090, 3.4376, 0.2255> <-9.4543, 3.4376, 0.2255> <-9.4045, 3.4874, 0.2255>
		<-11.1589, 3.4874, 0.3486> <-11.1090, 3.4376, 0.3486> <-9.4543, 3.4376, 0.3486> <-9.4045, 3.4874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 3.4874, -0.0618> <-9.3546, 3.5372, -0.0618> <-9.3546, 5.1920, -0.0618> <-9.4045, 5.2418, -0.0618>
		<-9.4045, 3.4874, 0.0613> <-9.3546, 3.5372, 0.0613> <-9.3546, 5.1920, 0.0613> <-9.4045, 5.2418, 0.0613>
		<-9.4045, 3.4874, 0.2255> <-9.3546, 3.5372, 0.2255> <-9.3546, 5.1920, 0.2255> <-9.4045, 5.2418, 0.2255>
		<-9.4045, 3.4874, 0.3486> <-9.3546, 3.5372, 0.3486> <-9.3546, 5.1920, 0.3486> <-9.4045, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 5.2418, -0.0618> <-9.4543, 5.2916, -0.0618> <-11.1090, 5.2916, -0.0618> <-11.1589, 5.2418, -0.0618>
		<-9.4045, 5.2418, 0.0613> <-9.4543, 5.2916, 0.0613> <-11.1090, 5.2916, 0.0613> <-11.1589, 5.2418, 0.0613>
		<-9.4045, 5.2418, 0.2255> <-9.4543, 5.2916, 0.2255> <-11.1090, 5.2916, 0.2255> <-11.1589, 5.2418, 0.2255>
		<-9.4045, 5.2418, 0.3486> <-9.4543, 5.2916, 0.3486> <-11.1090, 5.2916, 0.3486> <-11.1589, 5.2418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 0.9062> <-11.1109, 1.4245, 0.9062> <-11.1109, 2.9047, 0.9062> <-11.0664, 2.9493, 0.9062>
		<-11.0712, 1.3751, 0.8515> <-11.1157, 1.4196, 0.8515> <-11.1157, 2.9095, 0.8515> <-11.0712, 2.9541, 0.8515>
		<-11.1500, 1.2963, 0.8308> <-11.1998, 1.3461, 0.8308> <-11.1998, 2.9831, 0.8308> <-11.1500, 3.0329, 0.8308>
		<-11.1589, 1.2874, 0.7771> <-11.2087, 1.3372, 0.7771> <-11.2087, 2.9920, 0.7771> <-11.1589, 3.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 0.9062> <-11.0620, 1.3842, 0.9557> <-11.1560, 1.2903, 0.9996> <-11.1357, 1.3105, 1.0404>
		<-11.1109, 1.4245, 0.9062> <-11.1066, 1.4288, 0.9557> <-11.2045, 1.3388, 0.9996> <-11.1842, 1.3590, 1.0404>
		<-11.1109, 2.9047, 0.9062> <-11.1066, 2.9004, 0.9557> <-11.2045, 2.9904, 0.9996> <-11.1842, 2.9702, 1.0404>
		<-11.0664, 2.9493, 0.9062> <-11.0620, 2.9449, 0.9557> <-11.1560, 3.0389, 0.9996> <-11.1357, 3.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 0.9062> <-11.0712, 1.3751, 0.8515> <-11.1500, 1.2963, 0.8308> <-11.1589, 1.2874, 0.7771>
		<-11.0218, 1.3353, 0.9062> <-11.0266, 1.3305, 0.8515> <-11.1001, 1.2465, 0.8308> <-11.1090, 1.2376, 0.7771>
		<-9.5415, 1.3353, 0.9062> <-9.5367, 1.3305, 0.8515> <-9.4632, 1.2465, 0.8308> <-9.4543, 1.2376, 0.7771>
		<-9.4970, 1.3799, 0.9062> <-9.4922, 1.3751, 0.8515> <-9.4134, 1.2963, 0.8308> <-9.4045, 1.2874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 0.9062> <-11.0218, 1.3353, 0.9062> <-9.5415, 1.3353, 0.9062> <-9.4970, 1.3799, 0.9062>
		<-11.0620, 1.3842, 0.9557> <-11.0175, 1.3397, 0.9557> <-9.5459, 1.3397, 0.9557> <-9.5013, 1.3842, 0.9557>
		<-11.1560, 1.2903, 0.9996> <-11.1075, 1.2418, 0.9996> <-9.4559, 1.2418, 0.9996> <-9.4073, 1.2903, 0.9996>
		<-11.1357, 1.3105, 1.0404> <-11.0872, 1.2620, 1.0404> <-9.4761, 1.2620, 1.0404> <-9.4276, 1.3105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 1.3799, 0.9062> <-9.4922, 1.3751, 0.8515> <-9.4134, 1.2963, 0.8308> <-9.4045, 1.2874, 0.7771>
		<-9.4524, 1.4245, 0.9062> <-9.4476, 1.4196, 0.8515> <-9.3635, 1.3461, 0.8308> <-9.3546, 1.3372, 0.7771>
		<-9.4524, 2.9047, 0.9062> <-9.4476, 2.9095, 0.8515> <-9.3635, 2.9831, 0.8308> <-9.3546, 2.9920, 0.7771>
		<-9.4970, 2.9493, 0.9062> <-9.4922, 2.9541, 0.8515> <-9.4134, 3.0329, 0.8308> <-9.4045, 3.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 1.3799, 0.9062> <-9.4524, 1.4245, 0.9062> <-9.4524, 2.9047, 0.9062> <-9.4970, 2.9493, 0.9062>
		<-9.5013, 1.3842, 0.9557> <-9.4567, 1.4288, 0.9557> <-9.4567, 2.9004, 0.9557> <-9.5013, 2.9449, 0.9557>
		<-9.4073, 1.2903, 0.9996> <-9.3588, 1.3388, 0.9996> <-9.3588, 2.9904, 0.9996> <-9.4073, 3.0389, 0.9996>
		<-9.4276, 1.3105, 1.0404> <-9.3791, 1.3590, 1.0404> <-9.3791, 2.9702, 1.0404> <-9.4276, 3.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 2.9493, 0.9062> <-9.4922, 2.9541, 0.8515> <-9.4134, 3.0329, 0.8308> <-9.4045, 3.0418, 0.7771>
		<-9.5415, 2.9939, 0.9062> <-9.5367, 2.9987, 0.8515> <-9.4632, 3.0827, 0.8308> <-9.4543, 3.0916, 0.7771>
		<-11.0218, 2.9939, 0.9062> <-11.0266, 2.9987, 0.8515> <-11.1001, 3.0827, 0.8308> <-11.1090, 3.0916, 0.7771>
		<-11.0664, 2.9493, 0.9062> <-11.0712, 2.9541, 0.8515> <-11.1500, 3.0329, 0.8308> <-11.1589, 3.0418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 2.9493, 0.9062> <-9.5415, 2.9939, 0.9062> <-11.0218, 2.9939, 0.9062> <-11.0664, 2.9493, 0.9062>
		<-9.5013, 2.9449, 0.9557> <-9.5459, 2.9895, 0.9557> <-11.0175, 2.9895, 0.9557> <-11.0620, 2.9449, 0.9557>
		<-9.4073, 3.0389, 0.9996> <-9.4559, 3.0874, 0.9996> <-11.1075, 3.0874, 0.9996> <-11.1560, 3.0389, 0.9996>
		<-9.4276, 3.0187, 1.0404> <-9.4761, 3.0672, 1.0404> <-11.0872, 3.0672, 1.0404> <-11.1357, 3.0187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 1.3105, 1.0404> <-11.0677, 1.3786, 1.1777> <-10.8982, 1.5481, 1.2552> <-10.8269, 1.6193, 1.3892>
		<-11.1842, 1.3590, 1.0404> <-11.1162, 1.4271, 1.1777> <-10.9291, 1.5790, 1.2552> <-10.8579, 1.6503, 1.3892>
		<-11.1842, 2.9702, 1.0404> <-11.1162, 2.9021, 1.1777> <-10.9291, 2.7501, 1.2552> <-10.8579, 2.6789, 1.3892>
		<-11.1357, 3.0187, 1.0404> <-11.0677, 2.9506, 1.1777> <-10.8982, 2.7811, 1.2552> <-10.8269, 2.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, 1.3105, 1.0404> <-11.0872, 1.2620, 1.0404> <-9.4761, 1.2620, 1.0404> <-9.4276, 1.3105, 1.0404>
		<-11.0677, 1.3786, 1.1777> <-11.0192, 1.3301, 1.1777> <-9.5442, 1.3301, 1.1777> <-9.4957, 1.3786, 1.1777>
		<-10.8982, 1.5481, 1.2552> <-10.8672, 1.5171, 1.2552> <-9.6961, 1.5171, 1.2552> <-9.6652, 1.5481, 1.2552>
		<-10.8269, 1.6193, 1.3892> <-10.7959, 1.5884, 1.3892> <-9.7674, 1.5884, 1.3892> <-9.7364, 1.6193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 1.3105, 1.0404> <-9.3791, 1.3590, 1.0404> <-9.3791, 2.9702, 1.0404> <-9.4276, 3.0187, 1.0404>
		<-9.4957, 1.3786, 1.1777> <-9.4471, 1.4271, 1.1777> <-9.4471, 2.9021, 1.1777> <-9.4957, 2.9506, 1.1777>
		<-9.6652, 1.5481, 1.2552> <-9.6342, 1.5790, 1.2552> <-9.6342, 2.7501, 1.2552> <-9.6652, 2.7811, 1.2552>
		<-9.7364, 1.6193, 1.3892> <-9.7054, 1.6503, 1.3892> <-9.7054, 2.6789, 1.3892> <-9.7364, 2.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 3.0187, 1.0404> <-9.4761, 3.0672, 1.0404> <-11.0872, 3.0672, 1.0404> <-11.1357, 3.0187, 1.0404>
		<-9.4957, 2.9506, 1.1777> <-9.5442, 2.9991, 1.1777> <-11.0192, 2.9991, 1.1777> <-11.0677, 2.9506, 1.1777>
		<-9.6652, 2.7811, 1.2552> <-9.6961, 2.8121, 1.2552> <-10.8672, 2.8121, 1.2552> <-10.8982, 2.7811, 1.2552>
		<-9.7364, 2.7098, 1.3892> <-9.7674, 2.7408, 1.3892> <-10.7959, 2.7408, 1.3892> <-10.8269, 2.7098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 1.6193, 1.3892> <-10.8079, 1.6383, 1.4249> <-10.8837, 1.5626, 1.4698> <-10.8837, 1.5626, 1.5144>
		<-10.8579, 1.6503, 1.3892> <-10.8389, 1.6693, 1.4249> <-10.9179, 1.5968, 1.4698> <-10.9179, 1.5968, 1.5144>
		<-10.8579, 2.6789, 1.3892> <-10.8389, 2.6599, 1.4249> <-10.9179, 2.7324, 1.4698> <-10.9179, 2.7324, 1.5144>
		<-10.8269, 2.7098, 1.3892> <-10.8079, 2.6909, 1.4249> <-10.8837, 2.7666, 1.4698> <-10.8837, 2.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 1.6193, 1.3892> <-10.7959, 1.5884, 1.3892> <-9.7674, 1.5884, 1.3892> <-9.7364, 1.6193, 1.3892>
		<-10.8079, 1.6383, 1.4249> <-10.7770, 1.6073, 1.4249> <-9.7863, 1.6073, 1.4249> <-9.7554, 1.6383, 1.4249>
		<-10.8837, 1.5626, 1.4698> <-10.8495, 1.5284, 1.4698> <-9.7138, 1.5284, 1.4698> <-9.6796, 1.5626, 1.4698>
		<-10.8837, 1.5626, 1.5144> <-10.8495, 1.5284, 1.5144> <-9.7138, 1.5284, 1.5144> <-9.6796, 1.5626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 1.6193, 1.3892> <-9.7054, 1.6503, 1.3892> <-9.7054, 2.6789, 1.3892> <-9.7364, 2.7098, 1.3892>
		<-9.7554, 1.6383, 1.4249> <-9.7244, 1.6693, 1.4249> <-9.7244, 2.6599, 1.4249> <-9.7554, 2.6909, 1.4249>
		<-9.6796, 1.5626, 1.4698> <-9.6455, 1.5968, 1.4698> <-9.6455, 2.7324, 1.4698> <-9.6796, 2.7666, 1.4698>
		<-9.6796, 1.5626, 1.5144> <-9.6455, 1.5968, 1.5144> <-9.6455, 2.7324, 1.5144> <-9.6796, 2.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 2.7098, 1.3892> <-9.7674, 2.7408, 1.3892> <-10.7959, 2.7408, 1.3892> <-10.8269, 2.7098, 1.3892>
		<-9.7554, 2.6909, 1.4249> <-9.7863, 2.7218, 1.4249> <-10.7770, 2.7218, 1.4249> <-10.8079, 2.6909, 1.4249>
		<-9.6796, 2.7666, 1.4698> <-9.7138, 2.8008, 1.4698> <-10.8495, 2.8008, 1.4698> <-10.8837, 2.7666, 1.4698>
		<-9.6796, 2.7666, 1.5144> <-9.7138, 2.8008, 1.5144> <-10.8495, 2.8008, 1.5144> <-10.8837, 2.7666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 1.5626, 1.5144> <-10.8837, 1.5626, 1.5613> <-10.8121, 1.6341, 1.6066> <-10.8269, 1.6193, 1.6486>
		<-10.9179, 1.5968, 1.5144> <-10.9179, 1.5968, 1.5613> <-10.8431, 1.6651, 1.6066> <-10.8579, 1.6503, 1.6486>
		<-10.9179, 2.7324, 1.5144> <-10.9179, 2.7324, 1.5613> <-10.8431, 2.6641, 1.6066> <-10.8579, 2.6789, 1.6486>
		<-10.8837, 2.7666, 1.5144> <-10.8837, 2.7666, 1.5613> <-10.8121, 2.6950, 1.6066> <-10.8269, 2.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, 1.5626, 1.5144> <-10.8495, 1.5284, 1.5144> <-9.7138, 1.5284, 1.5144> <-9.6796, 1.5626, 1.5144>
		<-10.8837, 1.5626, 1.5613> <-10.8495, 1.5284, 1.5613> <-9.7138, 1.5284, 1.5613> <-9.6796, 1.5626, 1.5613>
		<-10.8121, 1.6341, 1.6066> <-10.7812, 1.6032, 1.6066> <-9.7822, 1.6032, 1.6066> <-9.7512, 1.6341, 1.6066>
		<-10.8269, 1.6193, 1.6486> <-10.7959, 1.5884, 1.6486> <-9.7674, 1.5884, 1.6486> <-9.7364, 1.6193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 1.5626, 1.5144> <-9.6455, 1.5968, 1.5144> <-9.6455, 2.7324, 1.5144> <-9.6796, 2.7666, 1.5144>
		<-9.6796, 1.5626, 1.5613> <-9.6455, 1.5968, 1.5613> <-9.6455, 2.7324, 1.5613> <-9.6796, 2.7666, 1.5613>
		<-9.7512, 1.6341, 1.6066> <-9.7202, 1.6651, 1.6066> <-9.7202, 2.6641, 1.6066> <-9.7512, 2.6950, 1.6066>
		<-9.7364, 1.6193, 1.6486> <-9.7054, 1.6503, 1.6486> <-9.7054, 2.6789, 1.6486> <-9.7364, 2.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 2.7666, 1.5144> <-9.7138, 2.8008, 1.5144> <-10.8495, 2.8008, 1.5144> <-10.8837, 2.7666, 1.5144>
		<-9.6796, 2.7666, 1.5613> <-9.7138, 2.8008, 1.5613> <-10.8495, 2.8008, 1.5613> <-10.8837, 2.7666, 1.5613>
		<-9.7512, 2.6950, 1.6066> <-9.7822, 2.7260, 1.6066> <-10.7812, 2.7260, 1.6066> <-10.8121, 2.6950, 1.6066>
		<-9.7364, 2.7098, 1.6486> <-9.7674, 2.7408, 1.6486> <-10.7959, 2.7408, 1.6486> <-10.8269, 2.7098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 1.6193, 1.6486> <-10.8754, 1.5709, 1.7862> <-11.0172, 1.4290, 1.8960> <-11.0664, 1.3799, 2.0332>
		<-10.8579, 1.6503, 1.6486> <-10.9063, 1.6018, 1.7862> <-11.0618, 1.4736, 1.8960> <-11.1109, 1.4245, 2.0332>
		<-10.8579, 2.6789, 1.6486> <-10.9063, 2.7273, 1.7862> <-11.0618, 2.8556, 1.8960> <-11.1109, 2.9047, 2.0332>
		<-10.8269, 2.7098, 1.6486> <-10.8754, 2.7583, 1.7862> <-11.0172, 2.9002, 1.8960> <-11.0664, 2.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, 1.6193, 1.6486> <-10.7959, 1.5884, 1.6486> <-9.7674, 1.5884, 1.6486> <-9.7364, 1.6193, 1.6486>
		<-10.8754, 1.5709, 1.7862> <-10.8444, 1.5399, 1.7862> <-9.7189, 1.5399, 1.7862> <-9.6880, 1.5709, 1.7862>
		<-11.0172, 1.4290, 1.8960> <-10.9727, 1.3844, 1.8960> <-9.5907, 1.3844, 1.8960> <-9.5461, 1.4290, 1.8960>
		<-11.0664, 1.3799, 2.0332> <-11.0218, 1.3353, 2.0332> <-9.5415, 1.3353, 2.0332> <-9.4970, 1.3799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 1.6193, 1.6486> <-9.7054, 1.6503, 1.6486> <-9.7054, 2.6789, 1.6486> <-9.7364, 2.7098, 1.6486>
		<-9.6880, 1.5709, 1.7862> <-9.6570, 1.6018, 1.7862> <-9.6570, 2.7273, 1.7862> <-9.6880, 2.7583, 1.7862>
		<-9.5461, 1.4290, 1.8960> <-9.5015, 1.4736, 1.8960> <-9.5015, 2.8556, 1.8960> <-9.5461, 2.9002, 1.8960>
		<-9.4970, 1.3799, 2.0332> <-9.4524, 1.4245, 2.0332> <-9.4524, 2.9047, 2.0332> <-9.4970, 2.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 2.7098, 1.6486> <-9.7674, 2.7408, 1.6486> <-10.7959, 2.7408, 1.6486> <-10.8269, 2.7098, 1.6486>
		<-9.6880, 2.7583, 1.7862> <-9.7189, 2.7893, 1.7862> <-10.8444, 2.7893, 1.7862> <-10.8754, 2.7583, 1.7862>
		<-9.5461, 2.9002, 1.8960> <-9.5907, 2.9447, 1.8960> <-10.9727, 2.9447, 1.8960> <-11.0172, 2.9002, 1.8960>
		<-9.4970, 2.9493, 2.0332> <-9.5415, 2.9939, 2.0332> <-11.0218, 2.9939, 2.0332> <-11.0664, 2.9493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 2.0332> <-11.0930, 1.3533, 2.1074> <-11.0932, 1.3531, 2.2382> <-11.0641, 1.3822, 2.3104>
		<-11.1109, 1.4245, 2.0332> <-11.1375, 1.3979, 2.1074> <-11.1376, 1.3975, 2.2382> <-11.1085, 1.4266, 2.3104>
		<-11.1109, 2.9047, 2.0332> <-11.1375, 2.9313, 2.1074> <-11.1376, 2.9317, 2.2382> <-11.1085, 2.9025, 2.3104>
		<-11.0664, 2.9493, 2.0332> <-11.0930, 2.9759, 2.1074> <-11.0932, 2.9761, 2.2382> <-11.0641, 2.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, 1.3799, 2.0332> <-11.0218, 1.3353, 2.0332> <-9.5415, 1.3353, 2.0332> <-9.4970, 1.3799, 2.0332>
		<-11.0930, 1.3533, 2.1074> <-11.0484, 1.3087, 2.1074> <-9.5149, 1.3087, 2.1074> <-9.4704, 1.3533, 2.1074>
		<-11.0932, 1.3531, 2.2382> <-11.0488, 1.3086, 2.2382> <-9.5146, 1.3086, 2.2382> <-9.4701, 1.3531, 2.2382>
		<-11.0641, 1.3822, 2.3104> <-11.0196, 1.3378, 2.3104> <-9.5437, 1.3378, 2.3104> <-9.4993, 1.3822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 1.3799, 2.0332> <-9.4524, 1.4245, 2.0332> <-9.4524, 2.9047, 2.0332> <-9.4970, 2.9493, 2.0332>
		<-9.4704, 1.3533, 2.1074> <-9.4258, 1.3979, 2.1074> <-9.4258, 2.9313, 2.1074> <-9.4704, 2.9759, 2.1074>
		<-9.4701, 1.3531, 2.2382> <-9.4257, 1.3975, 2.2382> <-9.4257, 2.9317, 2.2382> <-9.4701, 2.9761, 2.2382>
		<-9.4993, 1.3822, 2.3104> <-9.4548, 1.4266, 2.3104> <-9.4548, 2.9025, 2.3104> <-9.4993, 2.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 2.9493, 2.0332> <-9.5415, 2.9939, 2.0332> <-11.0218, 2.9939, 2.0332> <-11.0664, 2.9493, 2.0332>
		<-9.4704, 2.9759, 2.1074> <-9.5149, 3.0204, 2.1074> <-11.0484, 3.0204, 2.1074> <-11.0930, 2.9759, 2.1074>
		<-9.4701, 2.9761, 2.2382> <-9.5146, 3.0206, 2.2382> <-11.0488, 3.0206, 2.2382> <-11.0932, 2.9761, 2.2382>
		<-9.4993, 2.9470, 2.3104> <-9.5437, 2.9914, 2.3104> <-11.0196, 2.9914, 2.3104> <-11.0641, 2.9470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 1.3822, 2.3104> <-10.9801, 1.4661, 2.5186> <-10.7843, 1.6620, 2.7154> <-10.7056, 1.7406, 2.9276>
		<-11.1085, 1.4266, 2.3104> <-11.0246, 1.5106, 2.5186> <-10.8084, 1.6860, 2.7154> <-10.7297, 1.7647, 2.9276>
		<-11.1085, 2.9025, 2.3104> <-11.0246, 2.8186, 2.5186> <-10.8084, 2.6431, 2.7154> <-10.7297, 2.5645, 2.9276>
		<-11.0641, 2.9470, 2.3104> <-10.9801, 2.8630, 2.5186> <-10.7843, 2.6672, 2.7154> <-10.7056, 2.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, 1.3822, 2.3104> <-11.0196, 1.3378, 2.3104> <-9.5437, 1.3378, 2.3104> <-9.4993, 1.3822, 2.3104>
		<-10.9801, 1.4661, 2.5186> <-10.9357, 1.4217, 2.5186> <-9.6277, 1.4217, 2.5186> <-9.5832, 1.4661, 2.5186>
		<-10.7843, 1.6620, 2.7154> <-10.7602, 1.6379, 2.7154> <-9.8031, 1.6379, 2.7154> <-9.7790, 1.6620, 2.7154>
		<-10.7056, 1.7406, 2.9276> <-10.6815, 1.7166, 2.9276> <-9.8818, 1.7166, 2.9276> <-9.8577, 1.7406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 1.3822, 2.3104> <-9.4548, 1.4266, 2.3104> <-9.4548, 2.9025, 2.3104> <-9.4993, 2.9470, 2.3104>
		<-9.5832, 1.4661, 2.5186> <-9.5388, 1.5106, 2.5186> <-9.5388, 2.8186, 2.5186> <-9.5832, 2.8630, 2.5186>
		<-9.7790, 1.6620, 2.7154> <-9.7550, 1.6860, 2.7154> <-9.7550, 2.6431, 2.7154> <-9.7790, 2.6672, 2.7154>
		<-9.8577, 1.7406, 2.9276> <-9.8336, 1.7647, 2.9276> <-9.8336, 2.5645, 2.9276> <-9.8577, 2.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 2.9470, 2.3104> <-9.5437, 2.9914, 2.3104> <-11.0196, 2.9914, 2.3104> <-11.0641, 2.9470, 2.3104>
		<-9.5832, 2.8630, 2.5186> <-9.6277, 2.9075, 2.5186> <-10.9357, 2.9075, 2.5186> <-10.9801, 2.8630, 2.5186>
		<-9.7790, 2.6672, 2.7154> <-9.8031, 2.6913, 2.7154> <-10.7602, 2.6913, 2.7154> <-10.7843, 2.6672, 2.7154>
		<-9.8577, 2.5885, 2.9276> <-9.8818, 2.6126, 2.9276> <-10.6815, 2.6126, 2.9276> <-10.7056, 2.5885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 1.7406, 2.9276> <-10.6887, 1.7576, 2.9732> <-10.7889, 1.6574, 3.0012> <-10.7889, 1.6574, 3.0528>
		<-10.7297, 1.7647, 2.9276> <-10.7128, 1.7816, 2.9732> <-10.8177, 1.6862, 3.0012> <-10.8177, 1.6862, 3.0528>
		<-10.7297, 2.5645, 2.9276> <-10.7128, 2.5475, 2.9732> <-10.8177, 2.6430, 3.0012> <-10.8177, 2.6430, 3.0528>
		<-10.7056, 2.5885, 2.9276> <-10.6887, 2.5716, 2.9732> <-10.7889, 2.6718, 3.0012> <-10.7889, 2.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 1.7406, 2.9276> <-10.6815, 1.7166, 2.9276> <-9.8818, 1.7166, 2.9276> <-9.8577, 1.7406, 2.9276>
		<-10.6887, 1.7576, 2.9732> <-10.6646, 1.7335, 2.9732> <-9.8987, 1.7335, 2.9732> <-9.8746, 1.7576, 2.9732>
		<-10.7889, 1.6574, 3.0012> <-10.7601, 1.6286, 3.0012> <-9.8033, 1.6286, 3.0012> <-9.7745, 1.6574, 3.0012>
		<-10.7889, 1.6574, 3.0528> <-10.7601, 1.6286, 3.0528> <-9.8033, 1.6286, 3.0528> <-9.7745, 1.6574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 1.7406, 2.9276> <-9.8336, 1.7647, 2.9276> <-9.8336, 2.5645, 2.9276> <-9.8577, 2.5885, 2.9276>
		<-9.8746, 1.7576, 2.9732> <-9.8506, 1.7816, 2.9732> <-9.8506, 2.5475, 2.9732> <-9.8746, 2.5716, 2.9732>
		<-9.7745, 1.6574, 3.0012> <-9.7456, 1.6862, 3.0012> <-9.7456, 2.6430, 3.0012> <-9.7745, 2.6718, 3.0012>
		<-9.7745, 1.6574, 3.0528> <-9.7456, 1.6862, 3.0528> <-9.7456, 2.6430, 3.0528> <-9.7745, 2.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 2.5885, 2.9276> <-9.8818, 2.6126, 2.9276> <-10.6815, 2.6126, 2.9276> <-10.7056, 2.5885, 2.9276>
		<-9.8746, 2.5716, 2.9732> <-9.8987, 2.5957, 2.9732> <-10.6646, 2.5957, 2.9732> <-10.6887, 2.5716, 2.9732>
		<-9.7745, 2.6718, 3.0012> <-9.8033, 2.7006, 3.0012> <-10.7601, 2.7006, 3.0012> <-10.7889, 2.6718, 3.0012>
		<-9.7745, 2.6718, 3.0528> <-9.8033, 2.7006, 3.0528> <-10.7601, 2.7006, 3.0528> <-10.7889, 2.6718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 1.6574, 3.0528> <-10.7889, 1.6574, 3.1044> <-10.6862, 1.7600, 3.1344> <-10.7056, 1.7406, 3.1780>
		<-10.8177, 1.6862, 3.0528> <-10.8177, 1.6862, 3.1044> <-10.7103, 1.7841, 3.1344> <-10.7297, 1.7647, 3.1780>
		<-10.8177, 2.6430, 3.0528> <-10.8177, 2.6430, 3.1044> <-10.7103, 2.5451, 3.1344> <-10.7297, 2.5645, 3.1780>
		<-10.7889, 2.6718, 3.0528> <-10.7889, 2.6718, 3.1044> <-10.6862, 2.5691, 3.1344> <-10.7056, 2.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, 1.6574, 3.0528> <-10.7601, 1.6286, 3.0528> <-9.8033, 1.6286, 3.0528> <-9.7745, 1.6574, 3.0528>
		<-10.7889, 1.6574, 3.1044> <-10.7601, 1.6286, 3.1044> <-9.8033, 1.6286, 3.1044> <-9.7745, 1.6574, 3.1044>
		<-10.6862, 1.7600, 3.1344> <-10.6621, 1.7360, 3.1344> <-9.9012, 1.7360, 3.1344> <-9.8771, 1.7600, 3.1344>
		<-10.7056, 1.7406, 3.1780> <-10.6815, 1.7166, 3.1780> <-9.8818, 1.7166, 3.1780> <-9.8577, 1.7406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 1.6574, 3.0528> <-9.7456, 1.6862, 3.0528> <-9.7456, 2.6430, 3.0528> <-9.7745, 2.6718, 3.0528>
		<-9.7745, 1.6574, 3.1044> <-9.7456, 1.6862, 3.1044> <-9.7456, 2.6430, 3.1044> <-9.7745, 2.6718, 3.1044>
		<-9.8771, 1.7600, 3.1344> <-9.8530, 1.7841, 3.1344> <-9.8530, 2.5451, 3.1344> <-9.8771, 2.5691, 3.1344>
		<-9.8577, 1.7406, 3.1780> <-9.8336, 1.7647, 3.1780> <-9.8336, 2.5645, 3.1780> <-9.8577, 2.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 2.6718, 3.0528> <-9.8033, 2.7006, 3.0528> <-10.7601, 2.7006, 3.0528> <-10.7889, 2.6718, 3.0528>
		<-9.7745, 2.6718, 3.1044> <-9.8033, 2.7006, 3.1044> <-10.7601, 2.7006, 3.1044> <-10.7889, 2.6718, 3.1044>
		<-9.8771, 2.5691, 3.1344> <-9.9012, 2.5932, 3.1344> <-10.6621, 2.5932, 3.1344> <-10.6862, 2.5691, 3.1344>
		<-9.8577, 2.5885, 3.1780> <-9.8818, 2.6126, 3.1780> <-10.6815, 2.6126, 3.1780> <-10.7056, 2.5885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 1.7406, 3.1780> <-10.7438, 1.7024, 3.2640> <-10.8610, 1.5852, 3.2738> <-10.9161, 1.5302, 3.3390>
		<-10.7297, 1.7647, 3.1780> <-10.7679, 1.7265, 3.2640> <-10.8971, 1.6212, 3.2738> <-10.9521, 1.5662, 3.3390>
		<-10.7297, 2.5645, 3.1780> <-10.7679, 2.6027, 3.2640> <-10.8971, 2.7079, 3.2738> <-10.9521, 2.7629, 3.3390>
		<-10.7056, 2.5885, 3.1780> <-10.7438, 2.6267, 3.2640> <-10.8610, 2.7440, 3.2738> <-10.9161, 2.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, 1.7406, 3.1780> <-10.6815, 1.7166, 3.1780> <-9.8818, 1.7166, 3.1780> <-9.8577, 1.7406, 3.1780>
		<-10.7438, 1.7024, 3.2640> <-10.7197, 1.6784, 3.2640> <-9.8436, 1.6784, 3.2640> <-9.8195, 1.7024, 3.2640>
		<-10.8610, 1.5852, 3.2738> <-10.8250, 1.5492, 3.2738> <-9.7383, 1.5492, 3.2738> <-9.7023, 1.5852, 3.2738>
		<-10.9161, 1.5302, 3.3390> <-10.8800, 1.4942, 3.3390> <-9.6833, 1.4942, 3.3390> <-9.6473, 1.5302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 1.7406, 3.1780> <-9.8336, 1.7647, 3.1780> <-9.8336, 2.5645, 3.1780> <-9.8577, 2.5885, 3.1780>
		<-9.8195, 1.7024, 3.2640> <-9.7954, 1.7265, 3.2640> <-9.7954, 2.6027, 3.2640> <-9.8195, 2.6267, 3.2640>
		<-9.7023, 1.5852, 3.2738> <-9.6663, 1.6212, 3.2738> <-9.6663, 2.7079, 3.2738> <-9.7023, 2.7440, 3.2738>
		<-9.6473, 1.5302, 3.3390> <-9.6112, 1.5662, 3.3390> <-9.6112, 2.7629, 3.3390> <-9.6473, 2.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 2.5885, 3.1780> <-9.8818, 2.6126, 3.1780> <-10.6815, 2.6126, 3.1780> <-10.7056, 2.5885, 3.1780>
		<-9.8195, 2.6267, 3.2640> <-9.8436, 2.6508, 3.2640> <-10.7197, 2.6508, 3.2640> <-10.7438, 2.6267, 3.2640>
		<-9.7023, 2.7440, 3.2738> <-9.7383, 2.7800, 3.2738> <-10.8250, 2.7800, 3.2738> <-10.8610, 2.7440, 3.2738>
		<-9.6473, 2.7990, 3.3390> <-9.6833, 2.8350, 3.3390> <-10.8800, 2.8350, 3.3390> <-10.9161, 2.7990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 1.5302, 3.3390> <-10.9416, 1.5046, 3.3693> <-10.9797, 1.4665, 3.4419> <-10.9623, 1.4839, 3.4821>
		<-10.9521, 1.5662, 3.3390> <-10.9777, 1.5406, 3.3693> <-11.0184, 1.5052, 3.4419> <-11.0010, 1.5226, 3.4821>
		<-10.9521, 2.7629, 3.3390> <-10.9777, 2.7885, 3.3693> <-11.0184, 2.8240, 3.4419> <-11.0010, 2.8066, 3.4821>
		<-10.9161, 2.7990, 3.3390> <-10.9416, 2.8246, 3.3693> <-10.9797, 2.8627, 3.4419> <-10.9623, 2.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, 1.5302, 3.3390> <-10.8800, 1.4942, 3.3390> <-9.6833, 1.4942, 3.3390> <-9.6473, 1.5302, 3.3390>
		<-10.9416, 1.5046, 3.3693> <-10.9056, 1.4686, 3.3693> <-9.6577, 1.4686, 3.3693> <-9.6217, 1.5046, 3.3693>
		<-10.9797, 1.4665, 3.4419> <-10.9411, 1.4279, 3.4419> <-9.6223, 1.4279, 3.4419> <-9.5836, 1.4665, 3.4419>
		<-10.9623, 1.4839, 3.4821> <-10.9236, 1.4453, 3.4821> <-9.6397, 1.4453, 3.4821> <-9.6010, 1.4839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 1.5302, 3.3390> <-9.6112, 1.5662, 3.3390> <-9.6112, 2.7629, 3.3390> <-9.6473, 2.7990, 3.3390>
		<-9.6217, 1.5046, 3.3693> <-9.5857, 1.5406, 3.3693> <-9.5857, 2.7885, 3.3693> <-9.6217, 2.8246, 3.3693>
		<-9.5836, 1.4665, 3.4419> <-9.5449, 1.5052, 3.4419> <-9.5449, 2.8240, 3.4419> <-9.5836, 2.8627, 3.4419>
		<-9.6010, 1.4839, 3.4821> <-9.5624, 1.5226, 3.4821> <-9.5624, 2.8066, 3.4821> <-9.6010, 2.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 2.7990, 3.3390> <-9.6833, 2.8350, 3.3390> <-10.8800, 2.8350, 3.3390> <-10.9161, 2.7990, 3.3390>
		<-9.6217, 2.8246, 3.3693> <-9.6577, 2.8606, 3.3693> <-10.9056, 2.8606, 3.3693> <-10.9416, 2.8246, 3.3693>
		<-9.5836, 2.8627, 3.4419> <-9.6223, 2.9013, 3.4419> <-10.9411, 2.9013, 3.4419> <-10.9797, 2.8627, 3.4419>
		<-9.6010, 2.8452, 3.4821> <-9.6397, 2.8839, 3.4821> <-10.9236, 2.8839, 3.4821> <-10.9623, 2.8452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 1.4839, 3.4821> <-10.9163, 1.5300, 3.5884> <-10.7961, 1.6502, 3.6567> <-10.7380, 1.7083, 3.7504>
		<-11.0010, 1.5226, 3.4821> <-10.9550, 1.5686, 3.5884> <-10.8220, 1.6761, 3.6567> <-10.7639, 1.7342, 3.7504>
		<-11.0010, 2.8066, 3.4821> <-10.9550, 2.7606, 3.5884> <-10.8220, 2.6531, 3.6567> <-10.7639, 2.5950, 3.7504>
		<-10.9623, 2.8452, 3.4821> <-10.9163, 2.7992, 3.5884> <-10.7961, 2.6790, 3.6567> <-10.7380, 2.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, 1.4839, 3.4821> <-10.9236, 1.4453, 3.4821> <-9.6397, 1.4453, 3.4821> <-9.6010, 1.4839, 3.4821>
		<-10.9163, 1.5300, 3.5884> <-10.8776, 1.4913, 3.5884> <-9.6857, 1.4913, 3.5884> <-9.6470, 1.5300, 3.5884>
		<-10.7961, 1.6502, 3.6567> <-10.7702, 1.6242, 3.6567> <-9.7932, 1.6242, 3.6567> <-9.7672, 1.6502, 3.6567>
		<-10.7380, 1.7083, 3.7504> <-10.7121, 1.6823, 3.7504> <-9.8513, 1.6823, 3.7504> <-9.8253, 1.7083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 1.4839, 3.4821> <-9.5624, 1.5226, 3.4821> <-9.5624, 2.8066, 3.4821> <-9.6010, 2.8452, 3.4821>
		<-9.6470, 1.5300, 3.5884> <-9.6084, 1.5686, 3.5884> <-9.6084, 2.7606, 3.5884> <-9.6470, 2.7992, 3.5884>
		<-9.7672, 1.6502, 3.6567> <-9.7413, 1.6761, 3.6567> <-9.7413, 2.6531, 3.6567> <-9.7672, 2.6790, 3.6567>
		<-9.8253, 1.7083, 3.7504> <-9.7994, 1.7342, 3.7504> <-9.7994, 2.5950, 3.7504> <-9.8253, 2.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 2.8452, 3.4821> <-9.6397, 2.8839, 3.4821> <-10.9236, 2.8839, 3.4821> <-10.9623, 2.8452, 3.4821>
		<-9.6470, 2.7992, 3.5884> <-9.6857, 2.8379, 3.5884> <-10.8776, 2.8379, 3.5884> <-10.9163, 2.7992, 3.5884>
		<-9.7672, 2.6790, 3.6567> <-9.7932, 2.7049, 3.6567> <-10.7702, 2.7049, 3.6567> <-10.7961, 2.6790, 3.6567>
		<-9.8253, 2.6209, 3.7504> <-9.8513, 2.6468, 3.7504> <-10.7121, 2.6468, 3.7504> <-10.7380, 2.6209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 1.7083, 3.7504> <-10.6964, 1.7498, 3.8175> <-10.6527, 1.7935, 3.9241> <-10.6352, 1.8110, 4.0098>
		<-10.7639, 1.7342, 3.7504> <-10.7223, 1.7757, 3.8175> <-10.6728, 1.8136, 3.9241> <-10.6553, 1.8311, 4.0098>
		<-10.7639, 2.5950, 3.7504> <-10.7223, 2.5534, 3.8175> <-10.6728, 2.5156, 3.9241> <-10.6553, 2.4981, 4.0098>
		<-10.7380, 2.6209, 3.7504> <-10.6964, 2.5793, 3.8175> <-10.6527, 2.5356, 3.9241> <-10.6352, 2.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, 1.7083, 3.7504> <-10.7121, 1.6823, 3.7504> <-9.8513, 1.6823, 3.7504> <-9.8253, 1.7083, 3.7504>
		<-10.6964, 1.7498, 3.8175> <-10.6705, 1.7239, 3.8175> <-9.8928, 1.7239, 3.8175> <-9.8669, 1.7498, 3.8175>
		<-10.6527, 1.7935, 3.9241> <-10.6326, 1.7734, 3.9241> <-9.9307, 1.7734, 3.9241> <-9.9106, 1.7935, 3.9241>
		<-10.6352, 1.8110, 4.0098> <-10.6152, 1.7909, 4.0098> <-9.9482, 1.7909, 4.0098> <-9.9281, 1.8110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 1.7083, 3.7504> <-9.7994, 1.7342, 3.7504> <-9.7994, 2.5950, 3.7504> <-9.8253, 2.6209, 3.7504>
		<-9.8669, 1.7498, 3.8175> <-9.8410, 1.7757, 3.8175> <-9.8410, 2.5534, 3.8175> <-9.8669, 2.5793, 3.8175>
		<-9.9106, 1.7935, 3.9241> <-9.8905, 1.8136, 3.9241> <-9.8905, 2.5156, 3.9241> <-9.9106, 2.5356, 3.9241>
		<-9.9281, 1.8110, 4.0098> <-9.9080, 1.8311, 4.0098> <-9.9080, 2.4981, 4.0098> <-9.9281, 2.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 2.6209, 3.7504> <-9.8513, 2.6468, 3.7504> <-10.7121, 2.6468, 3.7504> <-10.7380, 2.6209, 3.7504>
		<-9.8669, 2.5793, 3.8175> <-9.8928, 2.6053, 3.8175> <-10.6705, 2.6053, 3.8175> <-10.6964, 2.5793, 3.8175>
		<-9.9106, 2.5356, 3.9241> <-9.9307, 2.5557, 3.9241> <-10.6326, 2.5557, 3.9241> <-10.6527, 2.5356, 3.9241>
		<-9.9281, 2.5182, 4.0098> <-9.9482, 2.5383, 4.0098> <-10.6152, 2.5383, 4.0098> <-10.6352, 2.5182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 1.8110, 4.0098> <-10.6168, 1.8294, 4.1002> <-10.6221, 1.8242, 4.2288> <-10.6213, 1.8250, 4.3229>
		<-10.6553, 1.8311, 4.0098> <-10.6369, 1.8495, 4.1002> <-10.6413, 1.8435, 4.2288> <-10.6405, 1.8443, 4.3229>
		<-10.6553, 2.4981, 4.0098> <-10.6369, 2.4797, 4.1002> <-10.6413, 2.4857, 4.2288> <-10.6405, 2.4849, 4.3229>
		<-10.6352, 2.5182, 4.0098> <-10.6168, 2.4997, 4.1002> <-10.6221, 2.5050, 4.2288> <-10.6213, 2.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, 1.8110, 4.0098> <-10.6152, 1.7909, 4.0098> <-9.9482, 1.7909, 4.0098> <-9.9281, 1.8110, 4.0098>
		<-10.6168, 1.8294, 4.1002> <-10.5967, 1.8094, 4.1002> <-9.9666, 1.8094, 4.1002> <-9.9465, 1.8294, 4.1002>
		<-10.6221, 1.8242, 4.2288> <-10.6028, 1.8049, 4.2288> <-9.9606, 1.8049, 4.2288> <-9.9413, 1.8242, 4.2288>
		<-10.6213, 1.8250, 4.3229> <-10.6020, 1.8057, 4.3229> <-9.9614, 1.8057, 4.3229> <-9.9421, 1.8250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 1.8110, 4.0098> <-9.9080, 1.8311, 4.0098> <-9.9080, 2.4981, 4.0098> <-9.9281, 2.5182, 4.0098>
		<-9.9465, 1.8294, 4.1002> <-9.9264, 1.8495, 4.1002> <-9.9264, 2.4797, 4.1002> <-9.9465, 2.4997, 4.1002>
		<-9.9413, 1.8242, 4.2288> <-9.9220, 1.8435, 4.2288> <-9.9220, 2.4857, 4.2288> <-9.9413, 2.5050, 4.2288>
		<-9.9421, 1.8250, 4.3229> <-9.9228, 1.8443, 4.3229> <-9.9228, 2.4849, 4.3229> <-9.9421, 2.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 2.5182, 4.0098> <-9.9482, 2.5383, 4.0098> <-10.6152, 2.5383, 4.0098> <-10.6352, 2.5182, 4.0098>
		<-9.9465, 2.4997, 4.1002> <-9.9666, 2.5198, 4.1002> <-10.5967, 2.5198, 4.1002> <-10.6168, 2.4997, 4.1002>
		<-9.9413, 2.5050, 4.2288> <-9.9606, 2.5243, 4.2288> <-10.6028, 2.5243, 4.2288> <-10.6221, 2.5050, 4.2288>
		<-9.9421, 2.5042, 4.3229> <-9.9614, 2.5235, 4.3229> <-10.6020, 2.5235, 4.3229> <-10.6213, 2.5042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 1.8250, 4.3229> <-10.6179, 1.8284, 4.7283> <-10.6197, 1.8265, 5.2689> <-10.6213, 1.8250, 5.6744>
		<-10.6405, 1.8443, 4.3229> <-10.6371, 1.8477, 4.7283> <-10.6390, 1.8458, 5.2689> <-10.6405, 1.8443, 5.6744>
		<-10.6405, 2.4849, 4.3229> <-10.6371, 2.4815, 4.7283> <-10.6390, 2.4834, 5.2689> <-10.6405, 2.4849, 5.6744>
		<-10.6213, 2.5042, 4.3229> <-10.6179, 2.5008, 4.7283> <-10.6197, 2.5027, 5.2689> <-10.6213, 2.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 1.8250, 4.3229> <-10.6020, 1.8057, 4.3229> <-9.9614, 1.8057, 4.3229> <-9.9421, 1.8250, 4.3229>
		<-10.6179, 1.8284, 4.7283> <-10.5986, 1.8091, 4.7283> <-9.9648, 1.8091, 4.7283> <-9.9455, 1.8284, 4.7283>
		<-10.6197, 1.8265, 5.2689> <-10.6004, 1.8072, 5.2689> <-9.9629, 1.8072, 5.2689> <-9.9436, 1.8265, 5.2689>
		<-10.6213, 1.8250, 5.6744> <-10.6020, 1.8057, 5.6744> <-9.9614, 1.8057, 5.6744> <-9.9421, 1.8250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 1.8250, 4.3229> <-9.9228, 1.8443, 4.3229> <-9.9228, 2.4849, 4.3229> <-9.9421, 2.5042, 4.3229>
		<-9.9455, 1.8284, 4.7283> <-9.9262, 1.8477, 4.7283> <-9.9262, 2.4815, 4.7283> <-9.9455, 2.5008, 4.7283>
		<-9.9436, 1.8265, 5.2689> <-9.9243, 1.8458, 5.2689> <-9.9243, 2.4834, 5.2689> <-9.9436, 2.5027, 5.2689>
		<-9.9421, 1.8250, 5.6744> <-9.9228, 1.8443, 5.6744> <-9.9228, 2.4849, 5.6744> <-9.9421, 2.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 2.5042, 4.3229> <-9.9614, 2.5235, 4.3229> <-10.6020, 2.5235, 4.3229> <-10.6213, 2.5042, 4.3229>
		<-9.9455, 2.5008, 4.7283> <-9.9648, 2.5201, 4.7283> <-10.5986, 2.5201, 4.7283> <-10.6179, 2.5008, 4.7283>
		<-9.9436, 2.5027, 5.2689> <-9.9629, 2.5219, 5.2689> <-10.6004, 2.5219, 5.2689> <-10.6197, 2.5027, 5.2689>
		<-9.9421, 2.5042, 5.6744> <-9.9614, 2.5235, 5.6744> <-10.6020, 2.5235, 5.6744> <-10.6213, 2.5042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 1.8250, 5.6744> <-10.6225, 1.8237, 6.0073> <-10.6172, 1.8290, 6.4517> <-10.6305, 1.8157, 6.7841>
		<-10.6405, 1.8443, 5.6744> <-10.6418, 1.8430, 6.0073> <-10.6371, 1.8488, 6.4517> <-10.6503, 1.8355, 6.7841>
		<-10.6405, 2.4849, 5.6744> <-10.6418, 2.4861, 6.0073> <-10.6371, 2.4804, 6.4517> <-10.6503, 2.4936, 6.7841>
		<-10.6213, 2.5042, 5.6744> <-10.6225, 2.5054, 6.0073> <-10.6172, 2.5002, 6.4517> <-10.6305, 2.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, 1.8250, 5.6744> <-10.6020, 1.8057, 5.6744> <-9.9614, 1.8057, 5.6744> <-9.9421, 1.8250, 5.6744>
		<-10.6225, 1.8237, 6.0073> <-10.6032, 1.8044, 6.0073> <-9.9601, 1.8044, 6.0073> <-9.9408, 1.8237, 6.0073>
		<-10.6172, 1.8290, 6.4517> <-10.5974, 1.8092, 6.4517> <-9.9659, 1.8092, 6.4517> <-9.9461, 1.8290, 6.4517>
		<-10.6305, 1.8157, 6.7841> <-10.6107, 1.7959, 6.7841> <-9.9526, 1.7959, 6.7841> <-9.9328, 1.8157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 1.8250, 5.6744> <-9.9228, 1.8443, 5.6744> <-9.9228, 2.4849, 5.6744> <-9.9421, 2.5042, 5.6744>
		<-9.9408, 1.8237, 6.0073> <-9.9215, 1.8430, 6.0073> <-9.9215, 2.4861, 6.0073> <-9.9408, 2.5054, 6.0073>
		<-9.9461, 1.8290, 6.4517> <-9.9263, 1.8488, 6.4517> <-9.9263, 2.4804, 6.4517> <-9.9461, 2.5002, 6.4517>
		<-9.9328, 1.8157, 6.7841> <-9.9130, 1.8355, 6.7841> <-9.9130, 2.4936, 6.7841> <-9.9328, 2.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 2.5042, 5.6744> <-9.9614, 2.5235, 5.6744> <-10.6020, 2.5235, 5.6744> <-10.6213, 2.5042, 5.6744>
		<-9.9408, 2.5054, 6.0073> <-9.9601, 2.5247, 6.0073> <-10.6032, 2.5247, 6.0073> <-10.6225, 2.5054, 6.0073>
		<-9.9461, 2.5002, 6.4517> <-9.9659, 2.5200, 6.4517> <-10.5974, 2.5200, 6.4517> <-10.6172, 2.5002, 6.4517>
		<-9.9328, 2.5134, 6.7841> <-9.9526, 2.5333, 6.7841> <-10.6107, 2.5333, 6.7841> <-10.6305, 2.5134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 1.8157, 6.7841> <-10.6325, 1.8137, 6.8341> <-10.6449, 1.8013, 6.9079> <-10.6718, 1.7745, 6.9405>
		<-10.6503, 1.8355, 6.7841> <-10.6523, 1.8336, 6.8341> <-10.6671, 1.8235, 6.9079> <-10.6940, 1.7966, 6.9405>
		<-10.6503, 2.4936, 6.7841> <-10.6523, 2.4956, 6.8341> <-10.6671, 2.5057, 6.9079> <-10.6940, 2.5326, 6.9405>
		<-10.6305, 2.5134, 6.7841> <-10.6325, 2.5154, 6.8341> <-10.6449, 2.5278, 6.9079> <-10.6718, 2.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, 1.8157, 6.7841> <-10.6107, 1.7959, 6.7841> <-9.9526, 1.7959, 6.7841> <-9.9328, 1.8157, 6.7841>
		<-10.6325, 1.8137, 6.8341> <-10.6127, 1.7939, 6.8341> <-9.9506, 1.7939, 6.8341> <-9.9308, 1.8137, 6.8341>
		<-10.6449, 1.8013, 6.9079> <-10.6228, 1.7792, 6.9079> <-9.9406, 1.7792, 6.9079> <-9.9184, 1.8013, 6.9079>
		<-10.6718, 1.7745, 6.9405> <-10.6496, 1.7523, 6.9405> <-9.9137, 1.7523, 6.9405> <-9.8915, 1.7745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 1.8157, 6.7841> <-9.9130, 1.8355, 6.7841> <-9.9130, 2.4936, 6.7841> <-9.9328, 2.5134, 6.7841>
		<-9.9308, 1.8137, 6.8341> <-9.9110, 1.8336, 6.8341> <-9.9110, 2.4956, 6.8341> <-9.9308, 2.5154, 6.8341>
		<-9.9184, 1.8013, 6.9079> <-9.8962, 1.8235, 6.9079> <-9.8962, 2.5057, 6.9079> <-9.9184, 2.5278, 6.9079>
		<-9.8915, 1.7745, 6.9405> <-9.8694, 1.7966, 6.9405> <-9.8694, 2.5326, 6.9405> <-9.8915, 2.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 2.5134, 6.7841> <-9.9526, 2.5333, 6.7841> <-10.6107, 2.5333, 6.7841> <-10.6305, 2.5134, 6.7841>
		<-9.9308, 2.5154, 6.8341> <-9.9506, 2.5352, 6.8341> <-10.6127, 2.5352, 6.8341> <-10.6325, 2.5154, 6.8341>
		<-9.9184, 2.5278, 6.9079> <-9.9406, 2.5500, 6.9079> <-10.6228, 2.5500, 6.9079> <-10.6449, 2.5278, 6.9079>
		<-9.8915, 2.5547, 6.9405> <-9.9137, 2.5769, 6.9405> <-10.6496, 2.5769, 6.9405> <-10.6718, 2.5547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 1.7745, 6.9405> <-10.7339, 1.7123, 7.0160> <-10.8620, 1.5842, 7.0331> <-10.9114, 1.5348, 7.1255>
		<-10.6940, 1.7966, 6.9405> <-10.7561, 1.7345, 7.0160> <-10.8978, 1.6200, 7.0331> <-10.9472, 1.5706, 7.1255>
		<-10.6940, 2.5326, 6.9405> <-10.7561, 2.5947, 7.0160> <-10.8978, 2.7092, 7.0331> <-10.9472, 2.7586, 7.1255>
		<-10.6718, 2.5547, 6.9405> <-10.7339, 2.6168, 7.0160> <-10.8620, 2.7449, 7.0331> <-10.9114, 2.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, 1.7745, 6.9405> <-10.6496, 1.7523, 6.9405> <-9.9137, 1.7523, 6.9405> <-9.8915, 1.7745, 6.9405>
		<-10.7339, 1.7123, 7.0160> <-10.7117, 1.6902, 7.0160> <-9.8516, 1.6902, 7.0160> <-9.8294, 1.7123, 7.0160>
		<-10.8620, 1.5842, 7.0331> <-10.8262, 1.5485, 7.0331> <-9.7371, 1.5485, 7.0331> <-9.7013, 1.5842, 7.0331>
		<-10.9114, 1.5348, 7.1255> <-10.8757, 1.4990, 7.1255> <-9.6877, 1.4990, 7.1255> <-9.6519, 1.5348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 1.7745, 6.9405> <-9.8694, 1.7966, 6.9405> <-9.8694, 2.5326, 6.9405> <-9.8915, 2.5547, 6.9405>
		<-9.8294, 1.7123, 7.0160> <-9.8073, 1.7345, 7.0160> <-9.8073, 2.5947, 7.0160> <-9.8294, 2.6168, 7.0160>
		<-9.7013, 1.5842, 7.0331> <-9.6655, 1.6200, 7.0331> <-9.6655, 2.7092, 7.0331> <-9.7013, 2.7449, 7.0331>
		<-9.6519, 1.5348, 7.1255> <-9.6161, 1.5706, 7.1255> <-9.6161, 2.7586, 7.1255> <-9.6519, 2.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 2.5547, 6.9405> <-9.9137, 2.5769, 6.9405> <-10.6496, 2.5769, 6.9405> <-10.6718, 2.5547, 6.9405>
		<-9.8294, 2.6168, 7.0160> <-9.8516, 2.6390, 7.0160> <-10.7117, 2.6390, 7.0160> <-10.7339, 2.6168, 7.0160>
		<-9.7013, 2.7449, 7.0331> <-9.7371, 2.7807, 7.0331> <-10.8262, 2.7807, 7.0331> <-10.8620, 2.7449, 7.0331>
		<-9.6519, 2.7944, 7.1255> <-9.6877, 2.8301, 7.1255> <-10.8757, 2.8301, 7.1255> <-10.9114, 2.7944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 1.5348, 7.1255> <-10.9319, 1.5143, 7.1638> <-10.8316, 1.6146, 7.1912> <-10.8316, 1.6146, 7.2393>
		<-10.9472, 1.5706, 7.1255> <-10.9677, 1.5501, 7.1638> <-10.8629, 1.6459, 7.1912> <-10.8629, 1.6459, 7.2393>
		<-10.9472, 2.7586, 7.1255> <-10.9677, 2.7791, 7.1638> <-10.8629, 2.6833, 7.1912> <-10.8629, 2.6833, 7.2393>
		<-10.9114, 2.7944, 7.1255> <-10.9319, 2.8149, 7.1638> <-10.8316, 2.7146, 7.1912> <-10.8316, 2.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 1.5348, 7.1255> <-10.8757, 1.4990, 7.1255> <-9.6877, 1.4990, 7.1255> <-9.6519, 1.5348, 7.1255>
		<-10.9319, 1.5143, 7.1638> <-10.8962, 1.4785, 7.1638> <-9.6671, 1.4785, 7.1638> <-9.6314, 1.5143, 7.1638>
		<-10.8316, 1.6146, 7.1912> <-10.8004, 1.5834, 7.1912> <-9.7629, 1.5834, 7.1912> <-9.7317, 1.6146, 7.1912>
		<-10.8316, 1.6146, 7.2393> <-10.8004, 1.5834, 7.2393> <-9.7629, 1.5834, 7.2393> <-9.7317, 1.6146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 1.5348, 7.1255> <-9.6161, 1.5706, 7.1255> <-9.6161, 2.7586, 7.1255> <-9.6519, 2.7944, 7.1255>
		<-9.6314, 1.5143, 7.1638> <-9.5956, 1.5501, 7.1638> <-9.5956, 2.7791, 7.1638> <-9.6314, 2.8149, 7.1638>
		<-9.7317, 1.6146, 7.1912> <-9.7005, 1.6459, 7.1912> <-9.7005, 2.6833, 7.1912> <-9.7317, 2.7146, 7.1912>
		<-9.7317, 1.6146, 7.2393> <-9.7005, 1.6459, 7.2393> <-9.7005, 2.6833, 7.2393> <-9.7317, 2.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 2.7944, 7.1255> <-9.6877, 2.8301, 7.1255> <-10.8757, 2.8301, 7.1255> <-10.9114, 2.7944, 7.1255>
		<-9.6314, 2.8149, 7.1638> <-9.6671, 2.8506, 7.1638> <-10.8962, 2.8506, 7.1638> <-10.9319, 2.8149, 7.1638>
		<-9.7317, 2.7146, 7.1912> <-9.7629, 2.7458, 7.1912> <-10.8004, 2.7458, 7.1912> <-10.8316, 2.7146, 7.1912>
		<-9.7317, 2.7146, 7.2393> <-9.7629, 2.7458, 7.2393> <-10.8004, 2.7458, 7.2393> <-10.8316, 2.7146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 1.6146, 7.2393> <-10.8316, 1.6146, 7.2905> <-10.9054, 1.5408, 7.3169> <-10.9114, 1.5348, 7.3673>
		<-10.8629, 1.6459, 7.2393> <-10.8629, 1.6459, 7.2905> <-10.9412, 1.5766, 7.3169> <-10.9472, 1.5706, 7.3673>
		<-10.8629, 2.6833, 7.2393> <-10.8629, 2.6833, 7.2905> <-10.9412, 2.7526, 7.3169> <-10.9472, 2.7586, 7.3673>
		<-10.8316, 2.7146, 7.2393> <-10.8316, 2.7146, 7.2905> <-10.9054, 2.7883, 7.3169> <-10.9114, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, 1.6146, 7.2393> <-10.8004, 1.5834, 7.2393> <-9.7629, 1.5834, 7.2393> <-9.7317, 1.6146, 7.2393>
		<-10.8316, 1.6146, 7.2905> <-10.8004, 1.5834, 7.2905> <-9.7629, 1.5834, 7.2905> <-9.7317, 1.6146, 7.2905>
		<-10.9054, 1.5408, 7.3169> <-10.8696, 1.5051, 7.3169> <-9.6937, 1.5051, 7.3169> <-9.6579, 1.5408, 7.3169>
		<-10.9114, 1.5348, 7.3673> <-10.8757, 1.4990, 7.3673> <-9.6877, 1.4990, 7.3673> <-9.6519, 1.5348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 1.6146, 7.2393> <-9.7005, 1.6459, 7.2393> <-9.7005, 2.6833, 7.2393> <-9.7317, 2.7146, 7.2393>
		<-9.7317, 1.6146, 7.2905> <-9.7005, 1.6459, 7.2905> <-9.7005, 2.6833, 7.2905> <-9.7317, 2.7146, 7.2905>
		<-9.6579, 1.5408, 7.3169> <-9.6222, 1.5766, 7.3169> <-9.6222, 2.7526, 7.3169> <-9.6579, 2.7883, 7.3169>
		<-9.6519, 1.5348, 7.3673> <-9.6161, 1.5706, 7.3673> <-9.6161, 2.7586, 7.3673> <-9.6519, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 2.7146, 7.2393> <-9.7629, 2.7458, 7.2393> <-10.8004, 2.7458, 7.2393> <-10.8316, 2.7146, 7.2393>
		<-9.7317, 2.7146, 7.2905> <-9.7629, 2.7458, 7.2905> <-10.8004, 2.7458, 7.2905> <-10.8316, 2.7146, 7.2905>
		<-9.6579, 2.7883, 7.3169> <-9.6937, 2.8241, 7.3169> <-10.8696, 2.8241, 7.3169> <-10.9054, 2.7883, 7.3169>
		<-9.6519, 2.7944, 7.3673> <-9.6877, 2.8301, 7.3673> <-10.8757, 2.8301, 7.3673> <-10.9114, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 1.5348, 7.9080> <-10.9472, 1.5706, 7.9080> <-10.9472, 2.7586, 7.9080> <-10.9114, 2.7944, 7.9080>
		<-10.9114, 1.5348, 7.7458> <-10.9472, 1.5706, 7.7458> <-10.9472, 2.7586, 7.7458> <-10.9114, 2.7944, 7.7458>
		<-10.9305, 1.5157, 7.5273> <-10.9663, 1.5515, 7.5273> <-10.9663, 2.7777, 7.5273> <-10.9305, 2.8134, 7.5273>
		<-10.9114, 1.5348, 7.3673> <-10.9472, 1.5706, 7.3673> <-10.9472, 2.7586, 7.3673> <-10.9114, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, 1.5348, 7.9080> <-10.9114, 1.5348, 7.7458> <-10.9305, 1.5157, 7.5273> <-10.9114, 1.5348, 7.3673>
		<-10.8757, 1.4990, 7.9080> <-10.8757, 1.4990, 7.7458> <-10.8947, 1.4800, 7.5273> <-10.8757, 1.4990, 7.3673>
		<-9.6877, 1.4990, 7.9080> <-9.6877, 1.4990, 7.7458> <-9.6686, 1.4800, 7.5273> <-9.6877, 1.4990, 7.3673>
		<-9.6519, 1.5348, 7.9080> <-9.6519, 1.5348, 7.7458> <-9.6328, 1.5157, 7.5273> <-9.6519, 1.5348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 1.5348, 7.9080> <-9.6519, 1.5348, 7.7458> <-9.6328, 1.5157, 7.5273> <-9.6519, 1.5348, 7.3673>
		<-9.6161, 1.5706, 7.9080> <-9.6161, 1.5706, 7.7458> <-9.5970, 1.5515, 7.5273> <-9.6161, 1.5706, 7.3673>
		<-9.6161, 2.7586, 7.9080> <-9.6161, 2.7586, 7.7458> <-9.5970, 2.7777, 7.5273> <-9.6161, 2.7586, 7.3673>
		<-9.6519, 2.7944, 7.9080> <-9.6519, 2.7944, 7.7458> <-9.6328, 2.8134, 7.5273> <-9.6519, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 2.7944, 7.9080> <-9.6519, 2.7944, 7.7458> <-9.6328, 2.8134, 7.5273> <-9.6519, 2.7944, 7.3673>
		<-9.6877, 2.8301, 7.9080> <-9.6877, 2.8301, 7.7458> <-9.6686, 2.8492, 7.5273> <-9.6877, 2.8301, 7.3673>
		<-10.8757, 2.8301, 7.9080> <-10.8757, 2.8301, 7.7458> <-10.8947, 2.8492, 7.5273> <-10.8757, 2.8301, 7.3673>
		<-10.9114, 2.7944, 7.9080> <-10.9114, 2.7944, 7.7458> <-10.9305, 2.8134, 7.5273> <-10.9114, 2.7944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 1.2874, 0.7771> <-11.2087, 1.3372, 0.7771> <-11.2087, 2.9920, 0.7771> <-11.1589, 3.0418, 0.7771>
		<-11.1796, 1.2666, 0.6520> <-11.2294, 1.3164, 0.6520> <-11.2294, 3.0127, 0.6520> <-11.1796, 3.0626, 0.6520>
		<-11.1589, 1.2874, 0.4772> <-11.2087, 1.3372, 0.4772> <-11.2087, 2.9920, 0.4772> <-11.1589, 3.0418, 0.4772>
		<-11.1589, 1.2874, 0.3486> <-11.2087, 1.3372, 0.3486> <-11.2087, 2.9920, 0.3486> <-11.1589, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 1.2874, 0.7771> <-11.1796, 1.2666, 0.6520> <-11.1589, 1.2874, 0.4772> <-11.1589, 1.2874, 0.3486>
		<-11.1090, 1.2376, 0.7771> <-11.1298, 1.2168, 0.6520> <-11.1090, 1.2376, 0.4772> <-11.1090, 1.2376, 0.3486>
		<-9.4543, 1.2376, 0.7771> <-9.4335, 1.2168, 0.6520> <-9.4543, 1.2376, 0.4772> <-9.4543, 1.2376, 0.3486>
		<-9.4045, 1.2874, 0.7771> <-9.3837, 1.2666, 0.6520> <-9.4045, 1.2874, 0.4772> <-9.4045, 1.2874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 1.2874, 0.7771> <-9.3837, 1.2666, 0.6520> <-9.4045, 1.2874, 0.4772> <-9.4045, 1.2874, 0.3486>
		<-9.3546, 1.3372, 0.7771> <-9.3339, 1.3164, 0.6520> <-9.3546, 1.3372, 0.4772> <-9.3546, 1.3372, 0.3486>
		<-9.3546, 2.9920, 0.7771> <-9.3339, 3.0127, 0.6520> <-9.3546, 2.9920, 0.4772> <-9.3546, 2.9920, 0.3486>
		<-9.4045, 3.0418, 0.7771> <-9.3837, 3.0626, 0.6520> <-9.4045, 3.0418, 0.4772> <-9.4045, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 3.0418, 0.7771> <-9.3837, 3.0626, 0.6520> <-9.4045, 3.0418, 0.4772> <-9.4045, 3.0418, 0.3486>
		<-9.4543, 3.0916, 0.7771> <-9.4335, 3.1124, 0.6520> <-9.4543, 3.0916, 0.4772> <-9.4543, 3.0916, 0.3486>
		<-11.1090, 3.0916, 0.7771> <-11.1298, 3.1124, 0.6520> <-11.1090, 3.0916, 0.4772> <-11.1090, 3.0916, 0.3486>
		<-11.1589, 3.0418, 0.7771> <-11.1796, 3.0626, 0.6520> <-11.1589, 3.0418, 0.4772> <-11.1589, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 1.2874, -0.0618> <-11.1589, 1.2874, 0.0613> <-11.1589, 1.2874, 0.2255> <-11.1589, 1.2874, 0.3486>
		<-11.2087, 1.3372, -0.0618> <-11.2087, 1.3372, 0.0613> <-11.2087, 1.3372, 0.2255> <-11.2087, 1.3372, 0.3486>
		<-11.2087, 2.9920, -0.0618> <-11.2087, 2.9920, 0.0613> <-11.2087, 2.9920, 0.2255> <-11.2087, 2.9920, 0.3486>
		<-11.1589, 3.0418, -0.0618> <-11.1589, 3.0418, 0.0613> <-11.1589, 3.0418, 0.2255> <-11.1589, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, 1.2874, -0.0618> <-11.1090, 1.2376, -0.0618> <-9.4543, 1.2376, -0.0618> <-9.4045, 1.2874, -0.0618>
		<-11.1589, 1.2874, 0.0613> <-11.1090, 1.2376, 0.0613> <-9.4543, 1.2376, 0.0613> <-9.4045, 1.2874, 0.0613>
		<-11.1589, 1.2874, 0.2255> <-11.1090, 1.2376, 0.2255> <-9.4543, 1.2376, 0.2255> <-9.4045, 1.2874, 0.2255>
		<-11.1589, 1.2874, 0.3486> <-11.1090, 1.2376, 0.3486> <-9.4543, 1.2376, 0.3486> <-9.4045, 1.2874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 1.2874, -0.0618> <-9.3546, 1.3372, -0.0618> <-9.3546, 2.9920, -0.0618> <-9.4045, 3.0418, -0.0618>
		<-9.4045, 1.2874, 0.0613> <-9.3546, 1.3372, 0.0613> <-9.3546, 2.9920, 0.0613> <-9.4045, 3.0418, 0.0613>
		<-9.4045, 1.2874, 0.2255> <-9.3546, 1.3372, 0.2255> <-9.3546, 2.9920, 0.2255> <-9.4045, 3.0418, 0.2255>
		<-9.4045, 1.2874, 0.3486> <-9.3546, 1.3372, 0.3486> <-9.3546, 2.9920, 0.3486> <-9.4045, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 3.0418, -0.0618> <-9.4543, 3.0916, -0.0618> <-11.1090, 3.0916, -0.0618> <-11.1589, 3.0418, -0.0618>
		<-9.4045, 3.0418, 0.0613> <-9.4543, 3.0916, 0.0613> <-11.1090, 3.0916, 0.0613> <-11.1589, 3.0418, 0.0613>
		<-9.4045, 3.0418, 0.2255> <-9.4543, 3.0916, 0.2255> <-11.1090, 3.0916, 0.2255> <-11.1589, 3.0418, 0.2255>
		<-9.4045, 3.0418, 0.3486> <-9.4543, 3.0916, 0.3486> <-11.1090, 3.0916, 0.3486> <-11.1589, 3.0418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 0.9062> <-11.1109, -0.7755, 0.9062> <-11.1109, 0.7047, 0.9062> <-11.0664, 0.7493, 0.9062>
		<-11.0712, -0.8249, 0.8515> <-11.1157, -0.7804, 0.8515> <-11.1157, 0.7095, 0.8515> <-11.0712, 0.7541, 0.8515>
		<-11.1500, -0.9037, 0.8308> <-11.1998, -0.8539, 0.8308> <-11.1998, 0.7831, 0.8308> <-11.1500, 0.8329, 0.8308>
		<-11.1589, -0.9126, 0.7771> <-11.2087, -0.8628, 0.7771> <-11.2087, 0.7920, 0.7771> <-11.1589, 0.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 0.9062> <-11.0620, -0.8158, 0.9557> <-11.1560, -0.9097, 0.9996> <-11.1357, -0.8895, 1.0404>
		<-11.1109, -0.7755, 0.9062> <-11.1066, -0.7712, 0.9557> <-11.2045, -0.8612, 0.9996> <-11.1842, -0.8410, 1.0404>
		<-11.1109, 0.7047, 0.9062> <-11.1066, 0.7004, 0.9557> <-11.2045, 0.7904, 0.9996> <-11.1842, 0.7702, 1.0404>
		<-11.0664, 0.7493, 0.9062> <-11.0620, 0.7449, 0.9557> <-11.1560, 0.8389, 0.9996> <-11.1357, 0.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 0.9062> <-11.0712, -0.8249, 0.8515> <-11.1500, -0.9037, 0.8308> <-11.1589, -0.9126, 0.7771>
		<-11.0218, -0.8647, 0.9062> <-11.0266, -0.8695, 0.8515> <-11.1001, -0.9535, 0.8308> <-11.1090, -0.9624, 0.7771>
		<-9.5415, -0.8647, 0.9062> <-9.5367, -0.8695, 0.8515> <-9.4632, -0.9535, 0.8308> <-9.4543, -0.9624, 0.7771>
		<-9.4970, -0.8201, 0.9062> <-9.4922, -0.8249, 0.8515> <-9.4134, -0.9037, 0.8308> <-9.4045, -0.9126, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 0.9062> <-11.0218, -0.8647, 0.9062> <-9.5415, -0.8647, 0.9062> <-9.4970, -0.8201, 0.9062>
		<-11.0620, -0.8158, 0.9557> <-11.0175, -0.8603, 0.9557> <-9.5459, -0.8603, 0.9557> <-9.5013, -0.8158, 0.9557>
		<-11.1560, -0.9097, 0.9996> <-11.1075, -0.9582, 0.9996> <-9.4559, -0.9582, 0.9996> <-9.4073, -0.9097, 0.9996>
		<-11.1357, -0.8895, 1.0404> <-11.0872, -0.9380, 1.0404> <-9.4761, -0.9380, 1.0404> <-9.4276, -0.8895, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -0.8201, 0.9062> <-9.4922, -0.8249, 0.8515> <-9.4134, -0.9037, 0.8308> <-9.4045, -0.9126, 0.7771>
		<-9.4524, -0.7755, 0.9062> <-9.4476, -0.7804, 0.8515> <-9.3635, -0.8539, 0.8308> <-9.3546, -0.8628, 0.7771>
		<-9.4524, 0.7047, 0.9062> <-9.4476, 0.7095, 0.8515> <-9.3635, 0.7831, 0.8308> <-9.3546, 0.7920, 0.7771>
		<-9.4970, 0.7493, 0.9062> <-9.4922, 0.7541, 0.8515> <-9.4134, 0.8329, 0.8308> <-9.4045, 0.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -0.8201, 0.9062> <-9.4524, -0.7755, 0.9062> <-9.4524, 0.7047, 0.9062> <-9.4970, 0.7493, 0.9062>
		<-9.5013, -0.8158, 0.9557> <-9.4567, -0.7712, 0.9557> <-9.4567, 0.7004, 0.9557> <-9.5013, 0.7449, 0.9557>
		<-9.4073, -0.9097, 0.9996> <-9.3588, -0.8612, 0.9996> <-9.3588, 0.7904, 0.9996> <-9.4073, 0.8389, 0.9996>
		<-9.4276, -0.8895, 1.0404> <-9.3791, -0.8410, 1.0404> <-9.3791, 0.7702, 1.0404> <-9.4276, 0.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 0.7493, 0.9062> <-9.4922, 0.7541, 0.8515> <-9.4134, 0.8329, 0.8308> <-9.4045, 0.8418, 0.7771>
		<-9.5415, 0.7939, 0.9062> <-9.5367, 0.7987, 0.8515> <-9.4632, 0.8827, 0.8308> <-9.4543, 0.8916, 0.7771>
		<-11.0218, 0.7939, 0.9062> <-11.0266, 0.7987, 0.8515> <-11.1001, 0.8827, 0.8308> <-11.1090, 0.8916, 0.7771>
		<-11.0664, 0.7493, 0.9062> <-11.0712, 0.7541, 0.8515> <-11.1500, 0.8329, 0.8308> <-11.1589, 0.8418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 0.7493, 0.9062> <-9.5415, 0.7939, 0.9062> <-11.0218, 0.7939, 0.9062> <-11.0664, 0.7493, 0.9062>
		<-9.5013, 0.7449, 0.9557> <-9.5459, 0.7895, 0.9557> <-11.0175, 0.7895, 0.9557> <-11.0620, 0.7449, 0.9557>
		<-9.4073, 0.8389, 0.9996> <-9.4559, 0.8874, 0.9996> <-11.1075, 0.8874, 0.9996> <-11.1560, 0.8389, 0.9996>
		<-9.4276, 0.8187, 1.0404> <-9.4761, 0.8672, 1.0404> <-11.0872, 0.8672, 1.0404> <-11.1357, 0.8187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -0.8895, 1.0404> <-11.0677, -0.8214, 1.1777> <-10.8982, -0.6519, 1.2552> <-10.8269, -0.5807, 1.3892>
		<-11.1842, -0.8410, 1.0404> <-11.1162, -0.7729, 1.1777> <-10.9291, -0.6210, 1.2552> <-10.8579, -0.5497, 1.3892>
		<-11.1842, 0.7702, 1.0404> <-11.1162, 0.7021, 1.1777> <-10.9291, 0.5501, 1.2552> <-10.8579, 0.4789, 1.3892>
		<-11.1357, 0.8187, 1.0404> <-11.0677, 0.7506, 1.1777> <-10.8982, 0.5811, 1.2552> <-10.8269, 0.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -0.8895, 1.0404> <-11.0872, -0.9380, 1.0404> <-9.4761, -0.9380, 1.0404> <-9.4276, -0.8895, 1.0404>
		<-11.0677, -0.8214, 1.1777> <-11.0192, -0.8699, 1.1777> <-9.5442, -0.8699, 1.1777> <-9.4957, -0.8214, 1.1777>
		<-10.8982, -0.6519, 1.2552> <-10.8672, -0.6829, 1.2552> <-9.6961, -0.6829, 1.2552> <-9.6652, -0.6519, 1.2552>
		<-10.8269, -0.5807, 1.3892> <-10.7959, -0.6116, 1.3892> <-9.7674, -0.6116, 1.3892> <-9.7364, -0.5807, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, -0.8895, 1.0404> <-9.3791, -0.8410, 1.0404> <-9.3791, 0.7702, 1.0404> <-9.4276, 0.8187, 1.0404>
		<-9.4957, -0.8214, 1.1777> <-9.4471, -0.7729, 1.1777> <-9.4471, 0.7021, 1.1777> <-9.4957, 0.7506, 1.1777>
		<-9.6652, -0.6519, 1.2552> <-9.6342, -0.6210, 1.2552> <-9.6342, 0.5501, 1.2552> <-9.6652, 0.5811, 1.2552>
		<-9.7364, -0.5807, 1.3892> <-9.7054, -0.5497, 1.3892> <-9.7054, 0.4789, 1.3892> <-9.7364, 0.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, 0.8187, 1.0404> <-9.4761, 0.8672, 1.0404> <-11.0872, 0.8672, 1.0404> <-11.1357, 0.8187, 1.0404>
		<-9.4957, 0.7506, 1.1777> <-9.5442, 0.7991, 1.1777> <-11.0192, 0.7991, 1.1777> <-11.0677, 0.7506, 1.1777>
		<-9.6652, 0.5811, 1.2552> <-9.6961, 0.6121, 1.2552> <-10.8672, 0.6121, 1.2552> <-10.8982, 0.5811, 1.2552>
		<-9.7364, 0.5098, 1.3892> <-9.7674, 0.5408, 1.3892> <-10.7959, 0.5408, 1.3892> <-10.8269, 0.5098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -0.5807, 1.3892> <-10.8079, -0.5617, 1.4249> <-10.8837, -0.6374, 1.4698> <-10.8837, -0.6374, 1.5144>
		<-10.8579, -0.5497, 1.3892> <-10.8389, -0.5307, 1.4249> <-10.9179, -0.6032, 1.4698> <-10.9179, -0.6032, 1.5144>
		<-10.8579, 0.4789, 1.3892> <-10.8389, 0.4599, 1.4249> <-10.9179, 0.5324, 1.4698> <-10.9179, 0.5324, 1.5144>
		<-10.8269, 0.5098, 1.3892> <-10.8079, 0.4909, 1.4249> <-10.8837, 0.5666, 1.4698> <-10.8837, 0.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -0.5807, 1.3892> <-10.7959, -0.6116, 1.3892> <-9.7674, -0.6116, 1.3892> <-9.7364, -0.5807, 1.3892>
		<-10.8079, -0.5617, 1.4249> <-10.7770, -0.5927, 1.4249> <-9.7863, -0.5927, 1.4249> <-9.7554, -0.5617, 1.4249>
		<-10.8837, -0.6374, 1.4698> <-10.8495, -0.6716, 1.4698> <-9.7138, -0.6716, 1.4698> <-9.6796, -0.6374, 1.4698>
		<-10.8837, -0.6374, 1.5144> <-10.8495, -0.6716, 1.5144> <-9.7138, -0.6716, 1.5144> <-9.6796, -0.6374, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -0.5807, 1.3892> <-9.7054, -0.5497, 1.3892> <-9.7054, 0.4789, 1.3892> <-9.7364, 0.5098, 1.3892>
		<-9.7554, -0.5617, 1.4249> <-9.7244, -0.5307, 1.4249> <-9.7244, 0.4599, 1.4249> <-9.7554, 0.4909, 1.4249>
		<-9.6796, -0.6374, 1.4698> <-9.6455, -0.6032, 1.4698> <-9.6455, 0.5324, 1.4698> <-9.6796, 0.5666, 1.4698>
		<-9.6796, -0.6374, 1.5144> <-9.6455, -0.6032, 1.5144> <-9.6455, 0.5324, 1.5144> <-9.6796, 0.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 0.5098, 1.3892> <-9.7674, 0.5408, 1.3892> <-10.7959, 0.5408, 1.3892> <-10.8269, 0.5098, 1.3892>
		<-9.7554, 0.4909, 1.4249> <-9.7863, 0.5218, 1.4249> <-10.7770, 0.5218, 1.4249> <-10.8079, 0.4909, 1.4249>
		<-9.6796, 0.5666, 1.4698> <-9.7138, 0.6008, 1.4698> <-10.8495, 0.6008, 1.4698> <-10.8837, 0.5666, 1.4698>
		<-9.6796, 0.5666, 1.5144> <-9.7138, 0.6008, 1.5144> <-10.8495, 0.6008, 1.5144> <-10.8837, 0.5666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -0.6374, 1.5144> <-10.8837, -0.6374, 1.5613> <-10.8121, -0.5659, 1.6066> <-10.8269, -0.5807, 1.6486>
		<-10.9179, -0.6032, 1.5144> <-10.9179, -0.6032, 1.5613> <-10.8431, -0.5349, 1.6066> <-10.8579, -0.5497, 1.6486>
		<-10.9179, 0.5324, 1.5144> <-10.9179, 0.5324, 1.5613> <-10.8431, 0.4641, 1.6066> <-10.8579, 0.4789, 1.6486>
		<-10.8837, 0.5666, 1.5144> <-10.8837, 0.5666, 1.5613> <-10.8121, 0.4950, 1.6066> <-10.8269, 0.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -0.6374, 1.5144> <-10.8495, -0.6716, 1.5144> <-9.7138, -0.6716, 1.5144> <-9.6796, -0.6374, 1.5144>
		<-10.8837, -0.6374, 1.5613> <-10.8495, -0.6716, 1.5613> <-9.7138, -0.6716, 1.5613> <-9.6796, -0.6374, 1.5613>
		<-10.8121, -0.5659, 1.6066> <-10.7812, -0.5968, 1.6066> <-9.7822, -0.5968, 1.6066> <-9.7512, -0.5659, 1.6066>
		<-10.8269, -0.5807, 1.6486> <-10.7959, -0.6116, 1.6486> <-9.7674, -0.6116, 1.6486> <-9.7364, -0.5807, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, -0.6374, 1.5144> <-9.6455, -0.6032, 1.5144> <-9.6455, 0.5324, 1.5144> <-9.6796, 0.5666, 1.5144>
		<-9.6796, -0.6374, 1.5613> <-9.6455, -0.6032, 1.5613> <-9.6455, 0.5324, 1.5613> <-9.6796, 0.5666, 1.5613>
		<-9.7512, -0.5659, 1.6066> <-9.7202, -0.5349, 1.6066> <-9.7202, 0.4641, 1.6066> <-9.7512, 0.4950, 1.6066>
		<-9.7364, -0.5807, 1.6486> <-9.7054, -0.5497, 1.6486> <-9.7054, 0.4789, 1.6486> <-9.7364, 0.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, 0.5666, 1.5144> <-9.7138, 0.6008, 1.5144> <-10.8495, 0.6008, 1.5144> <-10.8837, 0.5666, 1.5144>
		<-9.6796, 0.5666, 1.5613> <-9.7138, 0.6008, 1.5613> <-10.8495, 0.6008, 1.5613> <-10.8837, 0.5666, 1.5613>
		<-9.7512, 0.4950, 1.6066> <-9.7822, 0.5260, 1.6066> <-10.7812, 0.5260, 1.6066> <-10.8121, 0.4950, 1.6066>
		<-9.7364, 0.5098, 1.6486> <-9.7674, 0.5408, 1.6486> <-10.7959, 0.5408, 1.6486> <-10.8269, 0.5098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -0.5807, 1.6486> <-10.8754, -0.6291, 1.7862> <-11.0172, -0.7710, 1.8960> <-11.0664, -0.8201, 2.0332>
		<-10.8579, -0.5497, 1.6486> <-10.9063, -0.5982, 1.7862> <-11.0618, -0.7264, 1.8960> <-11.1109, -0.7755, 2.0332>
		<-10.8579, 0.4789, 1.6486> <-10.9063, 0.5273, 1.7862> <-11.0618, 0.6556, 1.8960> <-11.1109, 0.7047, 2.0332>
		<-10.8269, 0.5098, 1.6486> <-10.8754, 0.5583, 1.7862> <-11.0172, 0.7002, 1.8960> <-11.0664, 0.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -0.5807, 1.6486> <-10.7959, -0.6116, 1.6486> <-9.7674, -0.6116, 1.6486> <-9.7364, -0.5807, 1.6486>
		<-10.8754, -0.6291, 1.7862> <-10.8444, -0.6601, 1.7862> <-9.7189, -0.6601, 1.7862> <-9.6880, -0.6291, 1.7862>
		<-11.0172, -0.7710, 1.8960> <-10.9727, -0.8156, 1.8960> <-9.5907, -0.8156, 1.8960> <-9.5461, -0.7710, 1.8960>
		<-11.0664, -0.8201, 2.0332> <-11.0218, -0.8647, 2.0332> <-9.5415, -0.8647, 2.0332> <-9.4970, -0.8201, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -0.5807, 1.6486> <-9.7054, -0.5497, 1.6486> <-9.7054, 0.4789, 1.6486> <-9.7364, 0.5098, 1.6486>
		<-9.6880, -0.6291, 1.7862> <-9.6570, -0.5982, 1.7862> <-9.6570, 0.5273, 1.7862> <-9.6880, 0.5583, 1.7862>
		<-9.5461, -0.7710, 1.8960> <-9.5015, -0.7264, 1.8960> <-9.5015, 0.6556, 1.8960> <-9.5461, 0.7002, 1.8960>
		<-9.4970, -0.8201, 2.0332> <-9.4524, -0.7755, 2.0332> <-9.4524, 0.7047, 2.0332> <-9.4970, 0.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, 0.5098, 1.6486> <-9.7674, 0.5408, 1.6486> <-10.7959, 0.5408, 1.6486> <-10.8269, 0.5098, 1.6486>
		<-9.6880, 0.5583, 1.7862> <-9.7189, 0.5893, 1.7862> <-10.8444, 0.5893, 1.7862> <-10.8754, 0.5583, 1.7862>
		<-9.5461, 0.7002, 1.8960> <-9.5907, 0.7447, 1.8960> <-10.9727, 0.7447, 1.8960> <-11.0172, 0.7002, 1.8960>
		<-9.4970, 0.7493, 2.0332> <-9.5415, 0.7939, 2.0332> <-11.0218, 0.7939, 2.0332> <-11.0664, 0.7493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 2.0332> <-11.0930, -0.8467, 2.1074> <-11.0932, -0.8469, 2.2382> <-11.0641, -0.8178, 2.3104>
		<-11.1109, -0.7755, 2.0332> <-11.1375, -0.8021, 2.1074> <-11.1376, -0.8025, 2.2382> <-11.1085, -0.7734, 2.3104>
		<-11.1109, 0.7047, 2.0332> <-11.1375, 0.7313, 2.1074> <-11.1376, 0.7317, 2.2382> <-11.1085, 0.7025, 2.3104>
		<-11.0664, 0.7493, 2.0332> <-11.0930, 0.7759, 2.1074> <-11.0932, 0.7761, 2.2382> <-11.0641, 0.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -0.8201, 2.0332> <-11.0218, -0.8647, 2.0332> <-9.5415, -0.8647, 2.0332> <-9.4970, -0.8201, 2.0332>
		<-11.0930, -0.8467, 2.1074> <-11.0484, -0.8913, 2.1074> <-9.5149, -0.8913, 2.1074> <-9.4704, -0.8467, 2.1074>
		<-11.0932, -0.8469, 2.2382> <-11.0488, -0.8914, 2.2382> <-9.5146, -0.8914, 2.2382> <-9.4701, -0.8469, 2.2382>
		<-11.0641, -0.8178, 2.3104> <-11.0196, -0.8622, 2.3104> <-9.5437, -0.8622, 2.3104> <-9.4993, -0.8178, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -0.8201, 2.0332> <-9.4524, -0.7755, 2.0332> <-9.4524, 0.7047, 2.0332> <-9.4970, 0.7493, 2.0332>
		<-9.4704, -0.8467, 2.1074> <-9.4258, -0.8021, 2.1074> <-9.4258, 0.7313, 2.1074> <-9.4704, 0.7759, 2.1074>
		<-9.4701, -0.8469, 2.2382> <-9.4257, -0.8025, 2.2382> <-9.4257, 0.7317, 2.2382> <-9.4701, 0.7761, 2.2382>
		<-9.4993, -0.8178, 2.3104> <-9.4548, -0.7734, 2.3104> <-9.4548, 0.7025, 2.3104> <-9.4993, 0.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, 0.7493, 2.0332> <-9.5415, 0.7939, 2.0332> <-11.0218, 0.7939, 2.0332> <-11.0664, 0.7493, 2.0332>
		<-9.4704, 0.7759, 2.1074> <-9.5149, 0.8204, 2.1074> <-11.0484, 0.8204, 2.1074> <-11.0930, 0.7759, 2.1074>
		<-9.4701, 0.7761, 2.2382> <-9.5146, 0.8206, 2.2382> <-11.0488, 0.8206, 2.2382> <-11.0932, 0.7761, 2.2382>
		<-9.4993, 0.7470, 2.3104> <-9.5437, 0.7914, 2.3104> <-11.0196, 0.7914, 2.3104> <-11.0641, 0.7470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -0.8178, 2.3104> <-10.9801, -0.7339, 2.5186> <-10.7843, -0.5380, 2.7154> <-10.7056, -0.4594, 2.9276>
		<-11.1085, -0.7734, 2.3104> <-11.0246, -0.6894, 2.5186> <-10.8084, -0.5140, 2.7154> <-10.7297, -0.4353, 2.9276>
		<-11.1085, 0.7025, 2.3104> <-11.0246, 0.6186, 2.5186> <-10.8084, 0.4431, 2.7154> <-10.7297, 0.3645, 2.9276>
		<-11.0641, 0.7470, 2.3104> <-10.9801, 0.6630, 2.5186> <-10.7843, 0.4672, 2.7154> <-10.7056, 0.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -0.8178, 2.3104> <-11.0196, -0.8622, 2.3104> <-9.5437, -0.8622, 2.3104> <-9.4993, -0.8178, 2.3104>
		<-10.9801, -0.7339, 2.5186> <-10.9357, -0.7783, 2.5186> <-9.6277, -0.7783, 2.5186> <-9.5832, -0.7339, 2.5186>
		<-10.7843, -0.5380, 2.7154> <-10.7602, -0.5621, 2.7154> <-9.8031, -0.5621, 2.7154> <-9.7790, -0.5380, 2.7154>
		<-10.7056, -0.4594, 2.9276> <-10.6815, -0.4834, 2.9276> <-9.8818, -0.4834, 2.9276> <-9.8577, -0.4594, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, -0.8178, 2.3104> <-9.4548, -0.7734, 2.3104> <-9.4548, 0.7025, 2.3104> <-9.4993, 0.7470, 2.3104>
		<-9.5832, -0.7339, 2.5186> <-9.5388, -0.6894, 2.5186> <-9.5388, 0.6186, 2.5186> <-9.5832, 0.6630, 2.5186>
		<-9.7790, -0.5380, 2.7154> <-9.7550, -0.5140, 2.7154> <-9.7550, 0.4431, 2.7154> <-9.7790, 0.4672, 2.7154>
		<-9.8577, -0.4594, 2.9276> <-9.8336, -0.4353, 2.9276> <-9.8336, 0.3645, 2.9276> <-9.8577, 0.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, 0.7470, 2.3104> <-9.5437, 0.7914, 2.3104> <-11.0196, 0.7914, 2.3104> <-11.0641, 0.7470, 2.3104>
		<-9.5832, 0.6630, 2.5186> <-9.6277, 0.7075, 2.5186> <-10.9357, 0.7075, 2.5186> <-10.9801, 0.6630, 2.5186>
		<-9.7790, 0.4672, 2.7154> <-9.8031, 0.4913, 2.7154> <-10.7602, 0.4913, 2.7154> <-10.7843, 0.4672, 2.7154>
		<-9.8577, 0.3885, 2.9276> <-9.8818, 0.4126, 2.9276> <-10.6815, 0.4126, 2.9276> <-10.7056, 0.3885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -0.4594, 2.9276> <-10.6887, -0.4424, 2.9732> <-10.7889, -0.5426, 3.0012> <-10.7889, -0.5426, 3.0528>
		<-10.7297, -0.4353, 2.9276> <-10.7128, -0.4184, 2.9732> <-10.8177, -0.5138, 3.0012> <-10.8177, -0.5138, 3.0528>
		<-10.7297, 0.3645, 2.9276> <-10.7128, 0.3475, 2.9732> <-10.8177, 0.4430, 3.0012> <-10.8177, 0.4430, 3.0528>
		<-10.7056, 0.3885, 2.9276> <-10.6887, 0.3716, 2.9732> <-10.7889, 0.4718, 3.0012> <-10.7889, 0.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -0.4594, 2.9276> <-10.6815, -0.4834, 2.9276> <-9.8818, -0.4834, 2.9276> <-9.8577, -0.4594, 2.9276>
		<-10.6887, -0.4424, 2.9732> <-10.6646, -0.4665, 2.9732> <-9.8987, -0.4665, 2.9732> <-9.8746, -0.4424, 2.9732>
		<-10.7889, -0.5426, 3.0012> <-10.7601, -0.5714, 3.0012> <-9.8033, -0.5714, 3.0012> <-9.7745, -0.5426, 3.0012>
		<-10.7889, -0.5426, 3.0528> <-10.7601, -0.5714, 3.0528> <-9.8033, -0.5714, 3.0528> <-9.7745, -0.5426, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -0.4594, 2.9276> <-9.8336, -0.4353, 2.9276> <-9.8336, 0.3645, 2.9276> <-9.8577, 0.3885, 2.9276>
		<-9.8746, -0.4424, 2.9732> <-9.8506, -0.4184, 2.9732> <-9.8506, 0.3475, 2.9732> <-9.8746, 0.3716, 2.9732>
		<-9.7745, -0.5426, 3.0012> <-9.7456, -0.5138, 3.0012> <-9.7456, 0.4430, 3.0012> <-9.7745, 0.4718, 3.0012>
		<-9.7745, -0.5426, 3.0528> <-9.7456, -0.5138, 3.0528> <-9.7456, 0.4430, 3.0528> <-9.7745, 0.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 0.3885, 2.9276> <-9.8818, 0.4126, 2.9276> <-10.6815, 0.4126, 2.9276> <-10.7056, 0.3885, 2.9276>
		<-9.8746, 0.3716, 2.9732> <-9.8987, 0.3957, 2.9732> <-10.6646, 0.3957, 2.9732> <-10.6887, 0.3716, 2.9732>
		<-9.7745, 0.4718, 3.0012> <-9.8033, 0.5006, 3.0012> <-10.7601, 0.5006, 3.0012> <-10.7889, 0.4718, 3.0012>
		<-9.7745, 0.4718, 3.0528> <-9.8033, 0.5006, 3.0528> <-10.7601, 0.5006, 3.0528> <-10.7889, 0.4718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -0.5426, 3.0528> <-10.7889, -0.5426, 3.1044> <-10.6862, -0.4400, 3.1344> <-10.7056, -0.4594, 3.1780>
		<-10.8177, -0.5138, 3.0528> <-10.8177, -0.5138, 3.1044> <-10.7103, -0.4159, 3.1344> <-10.7297, -0.4353, 3.1780>
		<-10.8177, 0.4430, 3.0528> <-10.8177, 0.4430, 3.1044> <-10.7103, 0.3451, 3.1344> <-10.7297, 0.3645, 3.1780>
		<-10.7889, 0.4718, 3.0528> <-10.7889, 0.4718, 3.1044> <-10.6862, 0.3691, 3.1344> <-10.7056, 0.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -0.5426, 3.0528> <-10.7601, -0.5714, 3.0528> <-9.8033, -0.5714, 3.0528> <-9.7745, -0.5426, 3.0528>
		<-10.7889, -0.5426, 3.1044> <-10.7601, -0.5714, 3.1044> <-9.8033, -0.5714, 3.1044> <-9.7745, -0.5426, 3.1044>
		<-10.6862, -0.4400, 3.1344> <-10.6621, -0.4640, 3.1344> <-9.9012, -0.4640, 3.1344> <-9.8771, -0.4400, 3.1344>
		<-10.7056, -0.4594, 3.1780> <-10.6815, -0.4834, 3.1780> <-9.8818, -0.4834, 3.1780> <-9.8577, -0.4594, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, -0.5426, 3.0528> <-9.7456, -0.5138, 3.0528> <-9.7456, 0.4430, 3.0528> <-9.7745, 0.4718, 3.0528>
		<-9.7745, -0.5426, 3.1044> <-9.7456, -0.5138, 3.1044> <-9.7456, 0.4430, 3.1044> <-9.7745, 0.4718, 3.1044>
		<-9.8771, -0.4400, 3.1344> <-9.8530, -0.4159, 3.1344> <-9.8530, 0.3451, 3.1344> <-9.8771, 0.3691, 3.1344>
		<-9.8577, -0.4594, 3.1780> <-9.8336, -0.4353, 3.1780> <-9.8336, 0.3645, 3.1780> <-9.8577, 0.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, 0.4718, 3.0528> <-9.8033, 0.5006, 3.0528> <-10.7601, 0.5006, 3.0528> <-10.7889, 0.4718, 3.0528>
		<-9.7745, 0.4718, 3.1044> <-9.8033, 0.5006, 3.1044> <-10.7601, 0.5006, 3.1044> <-10.7889, 0.4718, 3.1044>
		<-9.8771, 0.3691, 3.1344> <-9.9012, 0.3932, 3.1344> <-10.6621, 0.3932, 3.1344> <-10.6862, 0.3691, 3.1344>
		<-9.8577, 0.3885, 3.1780> <-9.8818, 0.4126, 3.1780> <-10.6815, 0.4126, 3.1780> <-10.7056, 0.3885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -0.4594, 3.1780> <-10.7438, -0.4976, 3.2640> <-10.8610, -0.6148, 3.2738> <-10.9161, -0.6698, 3.3390>
		<-10.7297, -0.4353, 3.1780> <-10.7679, -0.4735, 3.2640> <-10.8971, -0.5788, 3.2738> <-10.9521, -0.6338, 3.3390>
		<-10.7297, 0.3645, 3.1780> <-10.7679, 0.4027, 3.2640> <-10.8971, 0.5079, 3.2738> <-10.9521, 0.5629, 3.3390>
		<-10.7056, 0.3885, 3.1780> <-10.7438, 0.4267, 3.2640> <-10.8610, 0.5440, 3.2738> <-10.9161, 0.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -0.4594, 3.1780> <-10.6815, -0.4834, 3.1780> <-9.8818, -0.4834, 3.1780> <-9.8577, -0.4594, 3.1780>
		<-10.7438, -0.4976, 3.2640> <-10.7197, -0.5216, 3.2640> <-9.8436, -0.5216, 3.2640> <-9.8195, -0.4976, 3.2640>
		<-10.8610, -0.6148, 3.2738> <-10.8250, -0.6508, 3.2738> <-9.7383, -0.6508, 3.2738> <-9.7023, -0.6148, 3.2738>
		<-10.9161, -0.6698, 3.3390> <-10.8800, -0.7058, 3.3390> <-9.6833, -0.7058, 3.3390> <-9.6473, -0.6698, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -0.4594, 3.1780> <-9.8336, -0.4353, 3.1780> <-9.8336, 0.3645, 3.1780> <-9.8577, 0.3885, 3.1780>
		<-9.8195, -0.4976, 3.2640> <-9.7954, -0.4735, 3.2640> <-9.7954, 0.4027, 3.2640> <-9.8195, 0.4267, 3.2640>
		<-9.7023, -0.6148, 3.2738> <-9.6663, -0.5788, 3.2738> <-9.6663, 0.5079, 3.2738> <-9.7023, 0.5440, 3.2738>
		<-9.6473, -0.6698, 3.3390> <-9.6112, -0.6338, 3.3390> <-9.6112, 0.5629, 3.3390> <-9.6473, 0.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, 0.3885, 3.1780> <-9.8818, 0.4126, 3.1780> <-10.6815, 0.4126, 3.1780> <-10.7056, 0.3885, 3.1780>
		<-9.8195, 0.4267, 3.2640> <-9.8436, 0.4508, 3.2640> <-10.7197, 0.4508, 3.2640> <-10.7438, 0.4267, 3.2640>
		<-9.7023, 0.5440, 3.2738> <-9.7383, 0.5800, 3.2738> <-10.8250, 0.5800, 3.2738> <-10.8610, 0.5440, 3.2738>
		<-9.6473, 0.5990, 3.3390> <-9.6833, 0.6350, 3.3390> <-10.8800, 0.6350, 3.3390> <-10.9161, 0.5990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -0.6698, 3.3390> <-10.9416, -0.6954, 3.3693> <-10.9797, -0.7335, 3.4419> <-10.9623, -0.7161, 3.4821>
		<-10.9521, -0.6338, 3.3390> <-10.9777, -0.6594, 3.3693> <-11.0184, -0.6948, 3.4419> <-11.0010, -0.6774, 3.4821>
		<-10.9521, 0.5629, 3.3390> <-10.9777, 0.5885, 3.3693> <-11.0184, 0.6240, 3.4419> <-11.0010, 0.6066, 3.4821>
		<-10.9161, 0.5990, 3.3390> <-10.9416, 0.6246, 3.3693> <-10.9797, 0.6627, 3.4419> <-10.9623, 0.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -0.6698, 3.3390> <-10.8800, -0.7058, 3.3390> <-9.6833, -0.7058, 3.3390> <-9.6473, -0.6698, 3.3390>
		<-10.9416, -0.6954, 3.3693> <-10.9056, -0.7314, 3.3693> <-9.6577, -0.7314, 3.3693> <-9.6217, -0.6954, 3.3693>
		<-10.9797, -0.7335, 3.4419> <-10.9411, -0.7721, 3.4419> <-9.6223, -0.7721, 3.4419> <-9.5836, -0.7335, 3.4419>
		<-10.9623, -0.7161, 3.4821> <-10.9236, -0.7547, 3.4821> <-9.6397, -0.7547, 3.4821> <-9.6010, -0.7161, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, -0.6698, 3.3390> <-9.6112, -0.6338, 3.3390> <-9.6112, 0.5629, 3.3390> <-9.6473, 0.5990, 3.3390>
		<-9.6217, -0.6954, 3.3693> <-9.5857, -0.6594, 3.3693> <-9.5857, 0.5885, 3.3693> <-9.6217, 0.6246, 3.3693>
		<-9.5836, -0.7335, 3.4419> <-9.5449, -0.6948, 3.4419> <-9.5449, 0.6240, 3.4419> <-9.5836, 0.6627, 3.4419>
		<-9.6010, -0.7161, 3.4821> <-9.5624, -0.6774, 3.4821> <-9.5624, 0.6066, 3.4821> <-9.6010, 0.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, 0.5990, 3.3390> <-9.6833, 0.6350, 3.3390> <-10.8800, 0.6350, 3.3390> <-10.9161, 0.5990, 3.3390>
		<-9.6217, 0.6246, 3.3693> <-9.6577, 0.6606, 3.3693> <-10.9056, 0.6606, 3.3693> <-10.9416, 0.6246, 3.3693>
		<-9.5836, 0.6627, 3.4419> <-9.6223, 0.7013, 3.4419> <-10.9411, 0.7013, 3.4419> <-10.9797, 0.6627, 3.4419>
		<-9.6010, 0.6452, 3.4821> <-9.6397, 0.6839, 3.4821> <-10.9236, 0.6839, 3.4821> <-10.9623, 0.6452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -0.7161, 3.4821> <-10.9163, -0.6700, 3.5884> <-10.7961, -0.5498, 3.6567> <-10.7380, -0.4917, 3.7504>
		<-11.0010, -0.6774, 3.4821> <-10.9550, -0.6314, 3.5884> <-10.8220, -0.5239, 3.6567> <-10.7639, -0.4658, 3.7504>
		<-11.0010, 0.6066, 3.4821> <-10.9550, 0.5606, 3.5884> <-10.8220, 0.4531, 3.6567> <-10.7639, 0.3950, 3.7504>
		<-10.9623, 0.6452, 3.4821> <-10.9163, 0.5992, 3.5884> <-10.7961, 0.4790, 3.6567> <-10.7380, 0.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -0.7161, 3.4821> <-10.9236, -0.7547, 3.4821> <-9.6397, -0.7547, 3.4821> <-9.6010, -0.7161, 3.4821>
		<-10.9163, -0.6700, 3.5884> <-10.8776, -0.7087, 3.5884> <-9.6857, -0.7087, 3.5884> <-9.6470, -0.6700, 3.5884>
		<-10.7961, -0.5498, 3.6567> <-10.7702, -0.5758, 3.6567> <-9.7932, -0.5758, 3.6567> <-9.7672, -0.5498, 3.6567>
		<-10.7380, -0.4917, 3.7504> <-10.7121, -0.5177, 3.7504> <-9.8513, -0.5177, 3.7504> <-9.8253, -0.4917, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, -0.7161, 3.4821> <-9.5624, -0.6774, 3.4821> <-9.5624, 0.6066, 3.4821> <-9.6010, 0.6452, 3.4821>
		<-9.6470, -0.6700, 3.5884> <-9.6084, -0.6314, 3.5884> <-9.6084, 0.5606, 3.5884> <-9.6470, 0.5992, 3.5884>
		<-9.7672, -0.5498, 3.6567> <-9.7413, -0.5239, 3.6567> <-9.7413, 0.4531, 3.6567> <-9.7672, 0.4790, 3.6567>
		<-9.8253, -0.4917, 3.7504> <-9.7994, -0.4658, 3.7504> <-9.7994, 0.3950, 3.7504> <-9.8253, 0.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, 0.6452, 3.4821> <-9.6397, 0.6839, 3.4821> <-10.9236, 0.6839, 3.4821> <-10.9623, 0.6452, 3.4821>
		<-9.6470, 0.5992, 3.5884> <-9.6857, 0.6379, 3.5884> <-10.8776, 0.6379, 3.5884> <-10.9163, 0.5992, 3.5884>
		<-9.7672, 0.4790, 3.6567> <-9.7932, 0.5049, 3.6567> <-10.7702, 0.5049, 3.6567> <-10.7961, 0.4790, 3.6567>
		<-9.8253, 0.4209, 3.7504> <-9.8513, 0.4468, 3.7504> <-10.7121, 0.4468, 3.7504> <-10.7380, 0.4209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -0.4917, 3.7504> <-10.6964, -0.4502, 3.8175> <-10.6527, -0.4065, 3.9241> <-10.6352, -0.3890, 4.0098>
		<-10.7639, -0.4658, 3.7504> <-10.7223, -0.4243, 3.8175> <-10.6728, -0.3864, 3.9241> <-10.6553, -0.3689, 4.0098>
		<-10.7639, 0.3950, 3.7504> <-10.7223, 0.3534, 3.8175> <-10.6728, 0.3156, 3.9241> <-10.6553, 0.2981, 4.0098>
		<-10.7380, 0.4209, 3.7504> <-10.6964, 0.3793, 3.8175> <-10.6527, 0.3356, 3.9241> <-10.6352, 0.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -0.4917, 3.7504> <-10.7121, -0.5177, 3.7504> <-9.8513, -0.5177, 3.7504> <-9.8253, -0.4917, 3.7504>
		<-10.6964, -0.4502, 3.8175> <-10.6705, -0.4761, 3.8175> <-9.8928, -0.4761, 3.8175> <-9.8669, -0.4502, 3.8175>
		<-10.6527, -0.4065, 3.9241> <-10.6326, -0.4266, 3.9241> <-9.9307, -0.4266, 3.9241> <-9.9106, -0.4065, 3.9241>
		<-10.6352, -0.3890, 4.0098> <-10.6152, -0.4091, 4.0098> <-9.9482, -0.4091, 4.0098> <-9.9281, -0.3890, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, -0.4917, 3.7504> <-9.7994, -0.4658, 3.7504> <-9.7994, 0.3950, 3.7504> <-9.8253, 0.4209, 3.7504>
		<-9.8669, -0.4502, 3.8175> <-9.8410, -0.4243, 3.8175> <-9.8410, 0.3534, 3.8175> <-9.8669, 0.3793, 3.8175>
		<-9.9106, -0.4065, 3.9241> <-9.8905, -0.3864, 3.9241> <-9.8905, 0.3156, 3.9241> <-9.9106, 0.3356, 3.9241>
		<-9.9281, -0.3890, 4.0098> <-9.9080, -0.3689, 4.0098> <-9.9080, 0.2981, 4.0098> <-9.9281, 0.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, 0.4209, 3.7504> <-9.8513, 0.4468, 3.7504> <-10.7121, 0.4468, 3.7504> <-10.7380, 0.4209, 3.7504>
		<-9.8669, 0.3793, 3.8175> <-9.8928, 0.4053, 3.8175> <-10.6705, 0.4053, 3.8175> <-10.6964, 0.3793, 3.8175>
		<-9.9106, 0.3356, 3.9241> <-9.9307, 0.3557, 3.9241> <-10.6326, 0.3557, 3.9241> <-10.6527, 0.3356, 3.9241>
		<-9.9281, 0.3182, 4.0098> <-9.9482, 0.3383, 4.0098> <-10.6152, 0.3383, 4.0098> <-10.6352, 0.3182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -0.3890, 4.0098> <-10.6168, -0.3706, 4.1002> <-10.6221, -0.3758, 4.2288> <-10.6213, -0.3750, 4.3229>
		<-10.6553, -0.3689, 4.0098> <-10.6369, -0.3505, 4.1002> <-10.6413, -0.3565, 4.2288> <-10.6405, -0.3557, 4.3229>
		<-10.6553, 0.2981, 4.0098> <-10.6369, 0.2797, 4.1002> <-10.6413, 0.2857, 4.2288> <-10.6405, 0.2849, 4.3229>
		<-10.6352, 0.3182, 4.0098> <-10.6168, 0.2997, 4.1002> <-10.6221, 0.3050, 4.2288> <-10.6213, 0.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -0.3890, 4.0098> <-10.6152, -0.4091, 4.0098> <-9.9482, -0.4091, 4.0098> <-9.9281, -0.3890, 4.0098>
		<-10.6168, -0.3706, 4.1002> <-10.5967, -0.3906, 4.1002> <-9.9666, -0.3906, 4.1002> <-9.9465, -0.3706, 4.1002>
		<-10.6221, -0.3758, 4.2288> <-10.6028, -0.3951, 4.2288> <-9.9606, -0.3951, 4.2288> <-9.9413, -0.3758, 4.2288>
		<-10.6213, -0.3750, 4.3229> <-10.6020, -0.3943, 4.3229> <-9.9614, -0.3943, 4.3229> <-9.9421, -0.3750, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, -0.3890, 4.0098> <-9.9080, -0.3689, 4.0098> <-9.9080, 0.2981, 4.0098> <-9.9281, 0.3182, 4.0098>
		<-9.9465, -0.3706, 4.1002> <-9.9264, -0.3505, 4.1002> <-9.9264, 0.2797, 4.1002> <-9.9465, 0.2997, 4.1002>
		<-9.9413, -0.3758, 4.2288> <-9.9220, -0.3565, 4.2288> <-9.9220, 0.2857, 4.2288> <-9.9413, 0.3050, 4.2288>
		<-9.9421, -0.3750, 4.3229> <-9.9228, -0.3557, 4.3229> <-9.9228, 0.2849, 4.3229> <-9.9421, 0.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, 0.3182, 4.0098> <-9.9482, 0.3383, 4.0098> <-10.6152, 0.3383, 4.0098> <-10.6352, 0.3182, 4.0098>
		<-9.9465, 0.2997, 4.1002> <-9.9666, 0.3198, 4.1002> <-10.5967, 0.3198, 4.1002> <-10.6168, 0.2997, 4.1002>
		<-9.9413, 0.3050, 4.2288> <-9.9606, 0.3243, 4.2288> <-10.6028, 0.3243, 4.2288> <-10.6221, 0.3050, 4.2288>
		<-9.9421, 0.3042, 4.3229> <-9.9614, 0.3235, 4.3229> <-10.6020, 0.3235, 4.3229> <-10.6213, 0.3042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -0.3750, 4.3229> <-10.6179, -0.3716, 4.7283> <-10.6197, -0.3735, 5.2689> <-10.6213, -0.3750, 5.6744>
		<-10.6405, -0.3557, 4.3229> <-10.6371, -0.3523, 4.7283> <-10.6390, -0.3542, 5.2689> <-10.6405, -0.3557, 5.6744>
		<-10.6405, 0.2849, 4.3229> <-10.6371, 0.2815, 4.7283> <-10.6390, 0.2834, 5.2689> <-10.6405, 0.2849, 5.6744>
		<-10.6213, 0.3042, 4.3229> <-10.6179, 0.3008, 4.7283> <-10.6197, 0.3027, 5.2689> <-10.6213, 0.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -0.3750, 4.3229> <-10.6020, -0.3943, 4.3229> <-9.9614, -0.3943, 4.3229> <-9.9421, -0.3750, 4.3229>
		<-10.6179, -0.3716, 4.7283> <-10.5986, -0.3909, 4.7283> <-9.9648, -0.3909, 4.7283> <-9.9455, -0.3716, 4.7283>
		<-10.6197, -0.3735, 5.2689> <-10.6004, -0.3928, 5.2689> <-9.9629, -0.3928, 5.2689> <-9.9436, -0.3735, 5.2689>
		<-10.6213, -0.3750, 5.6744> <-10.6020, -0.3943, 5.6744> <-9.9614, -0.3943, 5.6744> <-9.9421, -0.3750, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -0.3750, 4.3229> <-9.9228, -0.3557, 4.3229> <-9.9228, 0.2849, 4.3229> <-9.9421, 0.3042, 4.3229>
		<-9.9455, -0.3716, 4.7283> <-9.9262, -0.3523, 4.7283> <-9.9262, 0.2815, 4.7283> <-9.9455, 0.3008, 4.7283>
		<-9.9436, -0.3735, 5.2689> <-9.9243, -0.3542, 5.2689> <-9.9243, 0.2834, 5.2689> <-9.9436, 0.3027, 5.2689>
		<-9.9421, -0.3750, 5.6744> <-9.9228, -0.3557, 5.6744> <-9.9228, 0.2849, 5.6744> <-9.9421, 0.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 0.3042, 4.3229> <-9.9614, 0.3235, 4.3229> <-10.6020, 0.3235, 4.3229> <-10.6213, 0.3042, 4.3229>
		<-9.9455, 0.3008, 4.7283> <-9.9648, 0.3201, 4.7283> <-10.5986, 0.3201, 4.7283> <-10.6179, 0.3008, 4.7283>
		<-9.9436, 0.3027, 5.2689> <-9.9629, 0.3219, 5.2689> <-10.6004, 0.3219, 5.2689> <-10.6197, 0.3027, 5.2689>
		<-9.9421, 0.3042, 5.6744> <-9.9614, 0.3235, 5.6744> <-10.6020, 0.3235, 5.6744> <-10.6213, 0.3042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -0.3750, 5.6744> <-10.6225, -0.3763, 6.0073> <-10.6172, -0.3710, 6.4517> <-10.6305, -0.3843, 6.7841>
		<-10.6405, -0.3557, 5.6744> <-10.6418, -0.3570, 6.0073> <-10.6371, -0.3512, 6.4517> <-10.6503, -0.3645, 6.7841>
		<-10.6405, 0.2849, 5.6744> <-10.6418, 0.2861, 6.0073> <-10.6371, 0.2804, 6.4517> <-10.6503, 0.2936, 6.7841>
		<-10.6213, 0.3042, 5.6744> <-10.6225, 0.3054, 6.0073> <-10.6172, 0.3002, 6.4517> <-10.6305, 0.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -0.3750, 5.6744> <-10.6020, -0.3943, 5.6744> <-9.9614, -0.3943, 5.6744> <-9.9421, -0.3750, 5.6744>
		<-10.6225, -0.3763, 6.0073> <-10.6032, -0.3956, 6.0073> <-9.9601, -0.3956, 6.0073> <-9.9408, -0.3763, 6.0073>
		<-10.6172, -0.3710, 6.4517> <-10.5974, -0.3908, 6.4517> <-9.9659, -0.3908, 6.4517> <-9.9461, -0.3710, 6.4517>
		<-10.6305, -0.3843, 6.7841> <-10.6107, -0.4041, 6.7841> <-9.9526, -0.4041, 6.7841> <-9.9328, -0.3843, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -0.3750, 5.6744> <-9.9228, -0.3557, 5.6744> <-9.9228, 0.2849, 5.6744> <-9.9421, 0.3042, 5.6744>
		<-9.9408, -0.3763, 6.0073> <-9.9215, -0.3570, 6.0073> <-9.9215, 0.2861, 6.0073> <-9.9408, 0.3054, 6.0073>
		<-9.9461, -0.3710, 6.4517> <-9.9263, -0.3512, 6.4517> <-9.9263, 0.2804, 6.4517> <-9.9461, 0.3002, 6.4517>
		<-9.9328, -0.3843, 6.7841> <-9.9130, -0.3645, 6.7841> <-9.9130, 0.2936, 6.7841> <-9.9328, 0.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, 0.3042, 5.6744> <-9.9614, 0.3235, 5.6744> <-10.6020, 0.3235, 5.6744> <-10.6213, 0.3042, 5.6744>
		<-9.9408, 0.3054, 6.0073> <-9.9601, 0.3247, 6.0073> <-10.6032, 0.3247, 6.0073> <-10.6225, 0.3054, 6.0073>
		<-9.9461, 0.3002, 6.4517> <-9.9659, 0.3200, 6.4517> <-10.5974, 0.3200, 6.4517> <-10.6172, 0.3002, 6.4517>
		<-9.9328, 0.3134, 6.7841> <-9.9526, 0.3333, 6.7841> <-10.6107, 0.3333, 6.7841> <-10.6305, 0.3134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -0.3843, 6.7841> <-10.6325, -0.3863, 6.8341> <-10.6449, -0.3987, 6.9079> <-10.6718, -0.4255, 6.9405>
		<-10.6503, -0.3645, 6.7841> <-10.6523, -0.3664, 6.8341> <-10.6671, -0.3765, 6.9079> <-10.6940, -0.4034, 6.9405>
		<-10.6503, 0.2936, 6.7841> <-10.6523, 0.2956, 6.8341> <-10.6671, 0.3057, 6.9079> <-10.6940, 0.3326, 6.9405>
		<-10.6305, 0.3134, 6.7841> <-10.6325, 0.3154, 6.8341> <-10.6449, 0.3278, 6.9079> <-10.6718, 0.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -0.3843, 6.7841> <-10.6107, -0.4041, 6.7841> <-9.9526, -0.4041, 6.7841> <-9.9328, -0.3843, 6.7841>
		<-10.6325, -0.3863, 6.8341> <-10.6127, -0.4061, 6.8341> <-9.9506, -0.4061, 6.8341> <-9.9308, -0.3863, 6.8341>
		<-10.6449, -0.3987, 6.9079> <-10.6228, -0.4208, 6.9079> <-9.9406, -0.4208, 6.9079> <-9.9184, -0.3987, 6.9079>
		<-10.6718, -0.4255, 6.9405> <-10.6496, -0.4477, 6.9405> <-9.9137, -0.4477, 6.9405> <-9.8915, -0.4255, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, -0.3843, 6.7841> <-9.9130, -0.3645, 6.7841> <-9.9130, 0.2936, 6.7841> <-9.9328, 0.3134, 6.7841>
		<-9.9308, -0.3863, 6.8341> <-9.9110, -0.3664, 6.8341> <-9.9110, 0.2956, 6.8341> <-9.9308, 0.3154, 6.8341>
		<-9.9184, -0.3987, 6.9079> <-9.8962, -0.3765, 6.9079> <-9.8962, 0.3057, 6.9079> <-9.9184, 0.3278, 6.9079>
		<-9.8915, -0.4255, 6.9405> <-9.8694, -0.4034, 6.9405> <-9.8694, 0.3326, 6.9405> <-9.8915, 0.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, 0.3134, 6.7841> <-9.9526, 0.3333, 6.7841> <-10.6107, 0.3333, 6.7841> <-10.6305, 0.3134, 6.7841>
		<-9.9308, 0.3154, 6.8341> <-9.9506, 0.3352, 6.8341> <-10.6127, 0.3352, 6.8341> <-10.6325, 0.3154, 6.8341>
		<-9.9184, 0.3278, 6.9079> <-9.9406, 0.3500, 6.9079> <-10.6228, 0.3500, 6.9079> <-10.6449, 0.3278, 6.9079>
		<-9.8915, 0.3547, 6.9405> <-9.9137, 0.3769, 6.9405> <-10.6496, 0.3769, 6.9405> <-10.6718, 0.3547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -0.4255, 6.9405> <-10.7339, -0.4877, 7.0160> <-10.8620, -0.6158, 7.0331> <-10.9114, -0.6652, 7.1255>
		<-10.6940, -0.4034, 6.9405> <-10.7561, -0.4655, 7.0160> <-10.8978, -0.5800, 7.0331> <-10.9472, -0.6294, 7.1255>
		<-10.6940, 0.3326, 6.9405> <-10.7561, 0.3947, 7.0160> <-10.8978, 0.5092, 7.0331> <-10.9472, 0.5586, 7.1255>
		<-10.6718, 0.3547, 6.9405> <-10.7339, 0.4168, 7.0160> <-10.8620, 0.5449, 7.0331> <-10.9114, 0.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -0.4255, 6.9405> <-10.6496, -0.4477, 6.9405> <-9.9137, -0.4477, 6.9405> <-9.8915, -0.4255, 6.9405>
		<-10.7339, -0.4877, 7.0160> <-10.7117, -0.5098, 7.0160> <-9.8516, -0.5098, 7.0160> <-9.8294, -0.4877, 7.0160>
		<-10.8620, -0.6158, 7.0331> <-10.8262, -0.6515, 7.0331> <-9.7371, -0.6515, 7.0331> <-9.7013, -0.6158, 7.0331>
		<-10.9114, -0.6652, 7.1255> <-10.8757, -0.7010, 7.1255> <-9.6877, -0.7010, 7.1255> <-9.6519, -0.6652, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, -0.4255, 6.9405> <-9.8694, -0.4034, 6.9405> <-9.8694, 0.3326, 6.9405> <-9.8915, 0.3547, 6.9405>
		<-9.8294, -0.4877, 7.0160> <-9.8073, -0.4655, 7.0160> <-9.8073, 0.3947, 7.0160> <-9.8294, 0.4168, 7.0160>
		<-9.7013, -0.6158, 7.0331> <-9.6655, -0.5800, 7.0331> <-9.6655, 0.5092, 7.0331> <-9.7013, 0.5449, 7.0331>
		<-9.6519, -0.6652, 7.1255> <-9.6161, -0.6294, 7.1255> <-9.6161, 0.5586, 7.1255> <-9.6519, 0.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, 0.3547, 6.9405> <-9.9137, 0.3769, 6.9405> <-10.6496, 0.3769, 6.9405> <-10.6718, 0.3547, 6.9405>
		<-9.8294, 0.4168, 7.0160> <-9.8516, 0.4390, 7.0160> <-10.7117, 0.4390, 7.0160> <-10.7339, 0.4168, 7.0160>
		<-9.7013, 0.5449, 7.0331> <-9.7371, 0.5807, 7.0331> <-10.8262, 0.5807, 7.0331> <-10.8620, 0.5449, 7.0331>
		<-9.6519, 0.5944, 7.1255> <-9.6877, 0.6301, 7.1255> <-10.8757, 0.6301, 7.1255> <-10.9114, 0.5944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -0.6652, 7.1255> <-10.9319, -0.6857, 7.1638> <-10.8316, -0.5854, 7.1912> <-10.8316, -0.5854, 7.2393>
		<-10.9472, -0.6294, 7.1255> <-10.9677, -0.6499, 7.1638> <-10.8629, -0.5541, 7.1912> <-10.8629, -0.5541, 7.2393>
		<-10.9472, 0.5586, 7.1255> <-10.9677, 0.5791, 7.1638> <-10.8629, 0.4833, 7.1912> <-10.8629, 0.4833, 7.2393>
		<-10.9114, 0.5944, 7.1255> <-10.9319, 0.6149, 7.1638> <-10.8316, 0.5146, 7.1912> <-10.8316, 0.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -0.6652, 7.1255> <-10.8757, -0.7010, 7.1255> <-9.6877, -0.7010, 7.1255> <-9.6519, -0.6652, 7.1255>
		<-10.9319, -0.6857, 7.1638> <-10.8962, -0.7215, 7.1638> <-9.6671, -0.7215, 7.1638> <-9.6314, -0.6857, 7.1638>
		<-10.8316, -0.5854, 7.1912> <-10.8004, -0.6166, 7.1912> <-9.7629, -0.6166, 7.1912> <-9.7317, -0.5854, 7.1912>
		<-10.8316, -0.5854, 7.2393> <-10.8004, -0.6166, 7.2393> <-9.7629, -0.6166, 7.2393> <-9.7317, -0.5854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -0.6652, 7.1255> <-9.6161, -0.6294, 7.1255> <-9.6161, 0.5586, 7.1255> <-9.6519, 0.5944, 7.1255>
		<-9.6314, -0.6857, 7.1638> <-9.5956, -0.6499, 7.1638> <-9.5956, 0.5791, 7.1638> <-9.6314, 0.6149, 7.1638>
		<-9.7317, -0.5854, 7.1912> <-9.7005, -0.5541, 7.1912> <-9.7005, 0.4833, 7.1912> <-9.7317, 0.5146, 7.1912>
		<-9.7317, -0.5854, 7.2393> <-9.7005, -0.5541, 7.2393> <-9.7005, 0.4833, 7.2393> <-9.7317, 0.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 0.5944, 7.1255> <-9.6877, 0.6301, 7.1255> <-10.8757, 0.6301, 7.1255> <-10.9114, 0.5944, 7.1255>
		<-9.6314, 0.6149, 7.1638> <-9.6671, 0.6506, 7.1638> <-10.8962, 0.6506, 7.1638> <-10.9319, 0.6149, 7.1638>
		<-9.7317, 0.5146, 7.1912> <-9.7629, 0.5458, 7.1912> <-10.8004, 0.5458, 7.1912> <-10.8316, 0.5146, 7.1912>
		<-9.7317, 0.5146, 7.2393> <-9.7629, 0.5458, 7.2393> <-10.8004, 0.5458, 7.2393> <-10.8316, 0.5146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -0.5854, 7.2393> <-10.8316, -0.5854, 7.2905> <-10.9054, -0.6592, 7.3169> <-10.9114, -0.6652, 7.3673>
		<-10.8629, -0.5541, 7.2393> <-10.8629, -0.5541, 7.2905> <-10.9412, -0.6234, 7.3169> <-10.9472, -0.6294, 7.3673>
		<-10.8629, 0.4833, 7.2393> <-10.8629, 0.4833, 7.2905> <-10.9412, 0.5526, 7.3169> <-10.9472, 0.5586, 7.3673>
		<-10.8316, 0.5146, 7.2393> <-10.8316, 0.5146, 7.2905> <-10.9054, 0.5883, 7.3169> <-10.9114, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -0.5854, 7.2393> <-10.8004, -0.6166, 7.2393> <-9.7629, -0.6166, 7.2393> <-9.7317, -0.5854, 7.2393>
		<-10.8316, -0.5854, 7.2905> <-10.8004, -0.6166, 7.2905> <-9.7629, -0.6166, 7.2905> <-9.7317, -0.5854, 7.2905>
		<-10.9054, -0.6592, 7.3169> <-10.8696, -0.6949, 7.3169> <-9.6937, -0.6949, 7.3169> <-9.6579, -0.6592, 7.3169>
		<-10.9114, -0.6652, 7.3673> <-10.8757, -0.7010, 7.3673> <-9.6877, -0.7010, 7.3673> <-9.6519, -0.6652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, -0.5854, 7.2393> <-9.7005, -0.5541, 7.2393> <-9.7005, 0.4833, 7.2393> <-9.7317, 0.5146, 7.2393>
		<-9.7317, -0.5854, 7.2905> <-9.7005, -0.5541, 7.2905> <-9.7005, 0.4833, 7.2905> <-9.7317, 0.5146, 7.2905>
		<-9.6579, -0.6592, 7.3169> <-9.6222, -0.6234, 7.3169> <-9.6222, 0.5526, 7.3169> <-9.6579, 0.5883, 7.3169>
		<-9.6519, -0.6652, 7.3673> <-9.6161, -0.6294, 7.3673> <-9.6161, 0.5586, 7.3673> <-9.6519, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, 0.5146, 7.2393> <-9.7629, 0.5458, 7.2393> <-10.8004, 0.5458, 7.2393> <-10.8316, 0.5146, 7.2393>
		<-9.7317, 0.5146, 7.2905> <-9.7629, 0.5458, 7.2905> <-10.8004, 0.5458, 7.2905> <-10.8316, 0.5146, 7.2905>
		<-9.6579, 0.5883, 7.3169> <-9.6937, 0.6241, 7.3169> <-10.8696, 0.6241, 7.3169> <-10.9054, 0.5883, 7.3169>
		<-9.6519, 0.5944, 7.3673> <-9.6877, 0.6301, 7.3673> <-10.8757, 0.6301, 7.3673> <-10.9114, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -0.6652, 7.9080> <-10.9472, -0.6294, 7.9080> <-10.9472, 0.5586, 7.9080> <-10.9114, 0.5944, 7.9080>
		<-10.9114, -0.6652, 7.7458> <-10.9472, -0.6294, 7.7458> <-10.9472, 0.5586, 7.7458> <-10.9114, 0.5944, 7.7458>
		<-10.9305, -0.6843, 7.5273> <-10.9663, -0.6485, 7.5273> <-10.9663, 0.5777, 7.5273> <-10.9305, 0.6134, 7.5273>
		<-10.9114, -0.6652, 7.3673> <-10.9472, -0.6294, 7.3673> <-10.9472, 0.5586, 7.3673> <-10.9114, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -0.6652, 7.9080> <-10.9114, -0.6652, 7.7458> <-10.9305, -0.6843, 7.5273> <-10.9114, -0.6652, 7.3673>
		<-10.8757, -0.7010, 7.9080> <-10.8757, -0.7010, 7.7458> <-10.8947, -0.7200, 7.5273> <-10.8757, -0.7010, 7.3673>
		<-9.6877, -0.7010, 7.9080> <-9.6877, -0.7010, 7.7458> <-9.6686, -0.7200, 7.5273> <-9.6877, -0.7010, 7.3673>
		<-9.6519, -0.6652, 7.9080> <-9.6519, -0.6652, 7.7458> <-9.6328, -0.6843, 7.5273> <-9.6519, -0.6652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -0.6652, 7.9080> <-9.6519, -0.6652, 7.7458> <-9.6328, -0.6843, 7.5273> <-9.6519, -0.6652, 7.3673>
		<-9.6161, -0.6294, 7.9080> <-9.6161, -0.6294, 7.7458> <-9.5970, -0.6485, 7.5273> <-9.6161, -0.6294, 7.3673>
		<-9.6161, 0.5586, 7.9080> <-9.6161, 0.5586, 7.7458> <-9.5970, 0.5777, 7.5273> <-9.6161, 0.5586, 7.3673>
		<-9.6519, 0.5944, 7.9080> <-9.6519, 0.5944, 7.7458> <-9.6328, 0.6134, 7.5273> <-9.6519, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, 0.5944, 7.9080> <-9.6519, 0.5944, 7.7458> <-9.6328, 0.6134, 7.5273> <-9.6519, 0.5944, 7.3673>
		<-9.6877, 0.6301, 7.9080> <-9.6877, 0.6301, 7.7458> <-9.6686, 0.6492, 7.5273> <-9.6877, 0.6301, 7.3673>
		<-10.8757, 0.6301, 7.9080> <-10.8757, 0.6301, 7.7458> <-10.8947, 0.6492, 7.5273> <-10.8757, 0.6301, 7.3673>
		<-10.9114, 0.5944, 7.9080> <-10.9114, 0.5944, 7.7458> <-10.9305, 0.6134, 7.5273> <-10.9114, 0.5944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -0.9126, 0.7771> <-11.2087, -0.8628, 0.7771> <-11.2087, 0.7920, 0.7771> <-11.1589, 0.8418, 0.7771>
		<-11.1796, -0.9334, 0.6520> <-11.2294, -0.8836, 0.6520> <-11.2294, 0.8127, 0.6520> <-11.1796, 0.8626, 0.6520>
		<-11.1589, -0.9126, 0.4772> <-11.2087, -0.8628, 0.4772> <-11.2087, 0.7920, 0.4772> <-11.1589, 0.8418, 0.4772>
		<-11.1589, -0.9126, 0.3486> <-11.2087, -0.8628, 0.3486> <-11.2087, 0.7920, 0.3486> <-11.1589, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -0.9126, 0.7771> <-11.1796, -0.9334, 0.6520> <-11.1589, -0.9126, 0.4772> <-11.1589, -0.9126, 0.3486>
		<-11.1090, -0.9624, 0.7771> <-11.1298, -0.9832, 0.6520> <-11.1090, -0.9624, 0.4772> <-11.1090, -0.9624, 0.3486>
		<-9.4543, -0.9624, 0.7771> <-9.4335, -0.9832, 0.6520> <-9.4543, -0.9624, 0.4772> <-9.4543, -0.9624, 0.3486>
		<-9.4045, -0.9126, 0.7771> <-9.3837, -0.9334, 0.6520> <-9.4045, -0.9126, 0.4772> <-9.4045, -0.9126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -0.9126, 0.7771> <-9.3837, -0.9334, 0.6520> <-9.4045, -0.9126, 0.4772> <-9.4045, -0.9126, 0.3486>
		<-9.3546, -0.8628, 0.7771> <-9.3339, -0.8836, 0.6520> <-9.3546, -0.8628, 0.4772> <-9.3546, -0.8628, 0.3486>
		<-9.3546, 0.7920, 0.7771> <-9.3339, 0.8127, 0.6520> <-9.3546, 0.7920, 0.4772> <-9.3546, 0.7920, 0.3486>
		<-9.4045, 0.8418, 0.7771> <-9.3837, 0.8626, 0.6520> <-9.4045, 0.8418, 0.4772> <-9.4045, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 0.8418, 0.7771> <-9.3837, 0.8626, 0.6520> <-9.4045, 0.8418, 0.4772> <-9.4045, 0.8418, 0.3486>
		<-9.4543, 0.8916, 0.7771> <-9.4335, 0.9124, 0.6520> <-9.4543, 0.8916, 0.4772> <-9.4543, 0.8916, 0.3486>
		<-11.1090, 0.8916, 0.7771> <-11.1298, 0.9124, 0.6520> <-11.1090, 0.8916, 0.4772> <-11.1090, 0.8916, 0.3486>
		<-11.1589, 0.8418, 0.7771> <-11.1796, 0.8626, 0.6520> <-11.1589, 0.8418, 0.4772> <-11.1589, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -0.9126, -0.0618> <-11.1589, -0.9126, 0.0613> <-11.1589, -0.9126, 0.2255> <-11.1589, -0.9126, 0.3486>
		<-11.2087, -0.8628, -0.0618> <-11.2087, -0.8628, 0.0613> <-11.2087, -0.8628, 0.2255> <-11.2087, -0.8628, 0.3486>
		<-11.2087, 0.7920, -0.0618> <-11.2087, 0.7920, 0.0613> <-11.2087, 0.7920, 0.2255> <-11.2087, 0.7920, 0.3486>
		<-11.1589, 0.8418, -0.0618> <-11.1589, 0.8418, 0.0613> <-11.1589, 0.8418, 0.2255> <-11.1589, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -0.9126, -0.0618> <-11.1090, -0.9624, -0.0618> <-9.4543, -0.9624, -0.0618> <-9.4045, -0.9126, -0.0618>
		<-11.1589, -0.9126, 0.0613> <-11.1090, -0.9624, 0.0613> <-9.4543, -0.9624, 0.0613> <-9.4045, -0.9126, 0.0613>
		<-11.1589, -0.9126, 0.2255> <-11.1090, -0.9624, 0.2255> <-9.4543, -0.9624, 0.2255> <-9.4045, -0.9126, 0.2255>
		<-11.1589, -0.9126, 0.3486> <-11.1090, -0.9624, 0.3486> <-9.4543, -0.9624, 0.3486> <-9.4045, -0.9126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -0.9126, -0.0618> <-9.3546, -0.8628, -0.0618> <-9.3546, 0.7920, -0.0618> <-9.4045, 0.8418, -0.0618>
		<-9.4045, -0.9126, 0.0613> <-9.3546, -0.8628, 0.0613> <-9.3546, 0.7920, 0.0613> <-9.4045, 0.8418, 0.0613>
		<-9.4045, -0.9126, 0.2255> <-9.3546, -0.8628, 0.2255> <-9.3546, 0.7920, 0.2255> <-9.4045, 0.8418, 0.2255>
		<-9.4045, -0.9126, 0.3486> <-9.3546, -0.8628, 0.3486> <-9.3546, 0.7920, 0.3486> <-9.4045, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, 0.8418, -0.0618> <-9.4543, 0.8916, -0.0618> <-11.1090, 0.8916, -0.0618> <-11.1589, 0.8418, -0.0618>
		<-9.4045, 0.8418, 0.0613> <-9.4543, 0.8916, 0.0613> <-11.1090, 0.8916, 0.0613> <-11.1589, 0.8418, 0.0613>
		<-9.4045, 0.8418, 0.2255> <-9.4543, 0.8916, 0.2255> <-11.1090, 0.8916, 0.2255> <-11.1589, 0.8418, 0.2255>
		<-9.4045, 0.8418, 0.3486> <-9.4543, 0.8916, 0.3486> <-11.1090, 0.8916, 0.3486> <-11.1589, 0.8418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 0.9062> <-11.1109, -2.9755, 0.9062> <-11.1109, -1.4953, 0.9062> <-11.0664, -1.4507, 0.9062>
		<-11.0712, -3.0249, 0.8515> <-11.1157, -2.9804, 0.8515> <-11.1157, -1.4905, 0.8515> <-11.0712, -1.4459, 0.8515>
		<-11.1500, -3.1037, 0.8308> <-11.1998, -3.0539, 0.8308> <-11.1998, -1.4169, 0.8308> <-11.1500, -1.3671, 0.8308>
		<-11.1589, -3.1126, 0.7771> <-11.2087, -3.0628, 0.7771> <-11.2087, -1.4080, 0.7771> <-11.1589, -1.3582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 0.9062> <-11.0620, -3.0158, 0.9557> <-11.1560, -3.1097, 0.9996> <-11.1357, -3.0895, 1.0404>
		<-11.1109, -2.9755, 0.9062> <-11.1066, -2.9712, 0.9557> <-11.2045, -3.0612, 0.9996> <-11.1842, -3.0410, 1.0404>
		<-11.1109, -1.4953, 0.9062> <-11.1066, -1.4996, 0.9557> <-11.2045, -1.4096, 0.9996> <-11.1842, -1.4298, 1.0404>
		<-11.0664, -1.4507, 0.9062> <-11.0620, -1.4551, 0.9557> <-11.1560, -1.3611, 0.9996> <-11.1357, -1.3813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 0.9062> <-11.0712, -3.0249, 0.8515> <-11.1500, -3.1037, 0.8308> <-11.1589, -3.1126, 0.7771>
		<-11.0218, -3.0647, 0.9062> <-11.0266, -3.0695, 0.8515> <-11.1001, -3.1535, 0.8308> <-11.1090, -3.1624, 0.7771>
		<-9.5415, -3.0647, 0.9062> <-9.5367, -3.0695, 0.8515> <-9.4632, -3.1535, 0.8308> <-9.4543, -3.1624, 0.7771>
		<-9.4970, -3.0201, 0.9062> <-9.4922, -3.0249, 0.8515> <-9.4134, -3.1037, 0.8308> <-9.4045, -3.1126, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 0.9062> <-11.0218, -3.0647, 0.9062> <-9.5415, -3.0647, 0.9062> <-9.4970, -3.0201, 0.9062>
		<-11.0620, -3.0158, 0.9557> <-11.0175, -3.0603, 0.9557> <-9.5459, -3.0603, 0.9557> <-9.5013, -3.0158, 0.9557>
		<-11.1560, -3.1097, 0.9996> <-11.1075, -3.1582, 0.9996> <-9.4559, -3.1582, 0.9996> <-9.4073, -3.1097, 0.9996>
		<-11.1357, -3.0895, 1.0404> <-11.0872, -3.1380, 1.0404> <-9.4761, -3.1380, 1.0404> <-9.4276, -3.0895, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.0201, 0.9062> <-9.4922, -3.0249, 0.8515> <-9.4134, -3.1037, 0.8308> <-9.4045, -3.1126, 0.7771>
		<-9.4524, -2.9755, 0.9062> <-9.4476, -2.9804, 0.8515> <-9.3635, -3.0539, 0.8308> <-9.3546, -3.0628, 0.7771>
		<-9.4524, -1.4953, 0.9062> <-9.4476, -1.4905, 0.8515> <-9.3635, -1.4169, 0.8308> <-9.3546, -1.4080, 0.7771>
		<-9.4970, -1.4507, 0.9062> <-9.4922, -1.4459, 0.8515> <-9.4134, -1.3671, 0.8308> <-9.4045, -1.3582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.0201, 0.9062> <-9.4524, -2.9755, 0.9062> <-9.4524, -1.4953, 0.9062> <-9.4970, -1.4507, 0.9062>
		<-9.5013, -3.0158, 0.9557> <-9.4567, -2.9712, 0.9557> <-9.4567, -1.4996, 0.9557> <-9.5013, -1.4551, 0.9557>
		<-9.4073, -3.1097, 0.9996> <-9.3588, -3.0612, 0.9996> <-9.3588, -1.4096, 0.9996> <-9.4073, -1.3611, 0.9996>
		<-9.4276, -3.0895, 1.0404> <-9.3791, -3.0410, 1.0404> <-9.3791, -1.4298, 1.0404> <-9.4276, -1.3813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -1.4507, 0.9062> <-9.4922, -1.4459, 0.8515> <-9.4134, -1.3671, 0.8308> <-9.4045, -1.3582, 0.7771>
		<-9.5415, -1.4061, 0.9062> <-9.5367, -1.4013, 0.8515> <-9.4632, -1.3173, 0.8308> <-9.4543, -1.3084, 0.7771>
		<-11.0218, -1.4061, 0.9062> <-11.0266, -1.4013, 0.8515> <-11.1001, -1.3173, 0.8308> <-11.1090, -1.3084, 0.7771>
		<-11.0664, -1.4507, 0.9062> <-11.0712, -1.4459, 0.8515> <-11.1500, -1.3671, 0.8308> <-11.1589, -1.3582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -1.4507, 0.9062> <-9.5415, -1.4061, 0.9062> <-11.0218, -1.4061, 0.9062> <-11.0664, -1.4507, 0.9062>
		<-9.5013, -1.4551, 0.9557> <-9.5459, -1.4105, 0.9557> <-11.0175, -1.4105, 0.9557> <-11.0620, -1.4551, 0.9557>
		<-9.4073, -1.3611, 0.9996> <-9.4559, -1.3126, 0.9996> <-11.1075, -1.3126, 0.9996> <-11.1560, -1.3611, 0.9996>
		<-9.4276, -1.3813, 1.0404> <-9.4761, -1.3328, 1.0404> <-11.0872, -1.3328, 1.0404> <-11.1357, -1.3813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -3.0895, 1.0404> <-11.0677, -3.0214, 1.1777> <-10.8982, -2.8519, 1.2552> <-10.8269, -2.7807, 1.3892>
		<-11.1842, -3.0410, 1.0404> <-11.1162, -2.9729, 1.1777> <-10.9291, -2.8210, 1.2552> <-10.8579, -2.7497, 1.3892>
		<-11.1842, -1.4298, 1.0404> <-11.1162, -1.4979, 1.1777> <-10.9291, -1.6499, 1.2552> <-10.8579, -1.7211, 1.3892>
		<-11.1357, -1.3813, 1.0404> <-11.0677, -1.4494, 1.1777> <-10.8982, -1.6189, 1.2552> <-10.8269, -1.6902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -3.0895, 1.0404> <-11.0872, -3.1380, 1.0404> <-9.4761, -3.1380, 1.0404> <-9.4276, -3.0895, 1.0404>
		<-11.0677, -3.0214, 1.1777> <-11.0192, -3.0699, 1.1777> <-9.5442, -3.0699, 1.1777> <-9.4957, -3.0214, 1.1777>
		<-10.8982, -2.8519, 1.2552> <-10.8672, -2.8829, 1.2552> <-9.6961, -2.8829, 1.2552> <-9.6652, -2.8519, 1.2552>
		<-10.8269, -2.7807, 1.3892> <-10.7959, -2.8116, 1.3892> <-9.7674, -2.8116, 1.3892> <-9.7364, -2.7807, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, -3.0895, 1.0404> <-9.3791, -3.0410, 1.0404> <-9.3791, -1.4298, 1.0404> <-9.4276, -1.3813, 1.0404>
		<-9.4957, -3.0214, 1.1777> <-9.4471, -2.9729, 1.1777> <-9.4471, -1.4979, 1.1777> <-9.4957, -1.4494, 1.1777>
		<-9.6652, -2.8519, 1.2552> <-9.6342, -2.8210, 1.2552> <-9.6342, -1.6499, 1.2552> <-9.6652, -1.6189, 1.2552>
		<-9.7364, -2.7807, 1.3892> <-9.7054, -2.7497, 1.3892> <-9.7054, -1.7211, 1.3892> <-9.7364, -1.6902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, -1.3813, 1.0404> <-9.4761, -1.3328, 1.0404> <-11.0872, -1.3328, 1.0404> <-11.1357, -1.3813, 1.0404>
		<-9.4957, -1.4494, 1.1777> <-9.5442, -1.4009, 1.1777> <-11.0192, -1.4009, 1.1777> <-11.0677, -1.4494, 1.1777>
		<-9.6652, -1.6189, 1.2552> <-9.6961, -1.5879, 1.2552> <-10.8672, -1.5879, 1.2552> <-10.8982, -1.6189, 1.2552>
		<-9.7364, -1.6902, 1.3892> <-9.7674, -1.6592, 1.3892> <-10.7959, -1.6592, 1.3892> <-10.8269, -1.6902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -2.7807, 1.3892> <-10.8079, -2.7617, 1.4249> <-10.8837, -2.8374, 1.4698> <-10.8837, -2.8374, 1.5144>
		<-10.8579, -2.7497, 1.3892> <-10.8389, -2.7307, 1.4249> <-10.9179, -2.8032, 1.4698> <-10.9179, -2.8032, 1.5144>
		<-10.8579, -1.7211, 1.3892> <-10.8389, -1.7401, 1.4249> <-10.9179, -1.6676, 1.4698> <-10.9179, -1.6676, 1.5144>
		<-10.8269, -1.6902, 1.3892> <-10.8079, -1.7091, 1.4249> <-10.8837, -1.6334, 1.4698> <-10.8837, -1.6334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -2.7807, 1.3892> <-10.7959, -2.8116, 1.3892> <-9.7674, -2.8116, 1.3892> <-9.7364, -2.7807, 1.3892>
		<-10.8079, -2.7617, 1.4249> <-10.7770, -2.7927, 1.4249> <-9.7863, -2.7927, 1.4249> <-9.7554, -2.7617, 1.4249>
		<-10.8837, -2.8374, 1.4698> <-10.8495, -2.8716, 1.4698> <-9.7138, -2.8716, 1.4698> <-9.6796, -2.8374, 1.4698>
		<-10.8837, -2.8374, 1.5144> <-10.8495, -2.8716, 1.5144> <-9.7138, -2.8716, 1.5144> <-9.6796, -2.8374, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -2.7807, 1.3892> <-9.7054, -2.7497, 1.3892> <-9.7054, -1.7211, 1.3892> <-9.7364, -1.6902, 1.3892>
		<-9.7554, -2.7617, 1.4249> <-9.7244, -2.7307, 1.4249> <-9.7244, -1.7401, 1.4249> <-9.7554, -1.7091, 1.4249>
		<-9.6796, -2.8374, 1.4698> <-9.6455, -2.8032, 1.4698> <-9.6455, -1.6676, 1.4698> <-9.6796, -1.6334, 1.4698>
		<-9.6796, -2.8374, 1.5144> <-9.6455, -2.8032, 1.5144> <-9.6455, -1.6676, 1.5144> <-9.6796, -1.6334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -1.6902, 1.3892> <-9.7674, -1.6592, 1.3892> <-10.7959, -1.6592, 1.3892> <-10.8269, -1.6902, 1.3892>
		<-9.7554, -1.7091, 1.4249> <-9.7863, -1.6782, 1.4249> <-10.7770, -1.6782, 1.4249> <-10.8079, -1.7091, 1.4249>
		<-9.6796, -1.6334, 1.4698> <-9.7138, -1.5992, 1.4698> <-10.8495, -1.5992, 1.4698> <-10.8837, -1.6334, 1.4698>
		<-9.6796, -1.6334, 1.5144> <-9.7138, -1.5992, 1.5144> <-10.8495, -1.5992, 1.5144> <-10.8837, -1.6334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -2.8374, 1.5144> <-10.8837, -2.8374, 1.5613> <-10.8121, -2.7659, 1.6066> <-10.8269, -2.7807, 1.6486>
		<-10.9179, -2.8032, 1.5144> <-10.9179, -2.8032, 1.5613> <-10.8431, -2.7349, 1.6066> <-10.8579, -2.7497, 1.6486>
		<-10.9179, -1.6676, 1.5144> <-10.9179, -1.6676, 1.5613> <-10.8431, -1.7359, 1.6066> <-10.8579, -1.7211, 1.6486>
		<-10.8837, -1.6334, 1.5144> <-10.8837, -1.6334, 1.5613> <-10.8121, -1.7050, 1.6066> <-10.8269, -1.6902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -2.8374, 1.5144> <-10.8495, -2.8716, 1.5144> <-9.7138, -2.8716, 1.5144> <-9.6796, -2.8374, 1.5144>
		<-10.8837, -2.8374, 1.5613> <-10.8495, -2.8716, 1.5613> <-9.7138, -2.8716, 1.5613> <-9.6796, -2.8374, 1.5613>
		<-10.8121, -2.7659, 1.6066> <-10.7812, -2.7968, 1.6066> <-9.7822, -2.7968, 1.6066> <-9.7512, -2.7659, 1.6066>
		<-10.8269, -2.7807, 1.6486> <-10.7959, -2.8116, 1.6486> <-9.7674, -2.8116, 1.6486> <-9.7364, -2.7807, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, -2.8374, 1.5144> <-9.6455, -2.8032, 1.5144> <-9.6455, -1.6676, 1.5144> <-9.6796, -1.6334, 1.5144>
		<-9.6796, -2.8374, 1.5613> <-9.6455, -2.8032, 1.5613> <-9.6455, -1.6676, 1.5613> <-9.6796, -1.6334, 1.5613>
		<-9.7512, -2.7659, 1.6066> <-9.7202, -2.7349, 1.6066> <-9.7202, -1.7359, 1.6066> <-9.7512, -1.7050, 1.6066>
		<-9.7364, -2.7807, 1.6486> <-9.7054, -2.7497, 1.6486> <-9.7054, -1.7211, 1.6486> <-9.7364, -1.6902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, -1.6334, 1.5144> <-9.7138, -1.5992, 1.5144> <-10.8495, -1.5992, 1.5144> <-10.8837, -1.6334, 1.5144>
		<-9.6796, -1.6334, 1.5613> <-9.7138, -1.5992, 1.5613> <-10.8495, -1.5992, 1.5613> <-10.8837, -1.6334, 1.5613>
		<-9.7512, -1.7050, 1.6066> <-9.7822, -1.6740, 1.6066> <-10.7812, -1.6740, 1.6066> <-10.8121, -1.7050, 1.6066>
		<-9.7364, -1.6902, 1.6486> <-9.7674, -1.6592, 1.6486> <-10.7959, -1.6592, 1.6486> <-10.8269, -1.6902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -2.7807, 1.6486> <-10.8754, -2.8291, 1.7862> <-11.0172, -2.9710, 1.8960> <-11.0664, -3.0201, 2.0332>
		<-10.8579, -2.7497, 1.6486> <-10.9063, -2.7982, 1.7862> <-11.0618, -2.9264, 1.8960> <-11.1109, -2.9755, 2.0332>
		<-10.8579, -1.7211, 1.6486> <-10.9063, -1.6727, 1.7862> <-11.0618, -1.5444, 1.8960> <-11.1109, -1.4953, 2.0332>
		<-10.8269, -1.6902, 1.6486> <-10.8754, -1.6417, 1.7862> <-11.0172, -1.4998, 1.8960> <-11.0664, -1.4507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -2.7807, 1.6486> <-10.7959, -2.8116, 1.6486> <-9.7674, -2.8116, 1.6486> <-9.7364, -2.7807, 1.6486>
		<-10.8754, -2.8291, 1.7862> <-10.8444, -2.8601, 1.7862> <-9.7189, -2.8601, 1.7862> <-9.6880, -2.8291, 1.7862>
		<-11.0172, -2.9710, 1.8960> <-10.9727, -3.0156, 1.8960> <-9.5907, -3.0156, 1.8960> <-9.5461, -2.9710, 1.8960>
		<-11.0664, -3.0201, 2.0332> <-11.0218, -3.0647, 2.0332> <-9.5415, -3.0647, 2.0332> <-9.4970, -3.0201, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -2.7807, 1.6486> <-9.7054, -2.7497, 1.6486> <-9.7054, -1.7211, 1.6486> <-9.7364, -1.6902, 1.6486>
		<-9.6880, -2.8291, 1.7862> <-9.6570, -2.7982, 1.7862> <-9.6570, -1.6727, 1.7862> <-9.6880, -1.6417, 1.7862>
		<-9.5461, -2.9710, 1.8960> <-9.5015, -2.9264, 1.8960> <-9.5015, -1.5444, 1.8960> <-9.5461, -1.4998, 1.8960>
		<-9.4970, -3.0201, 2.0332> <-9.4524, -2.9755, 2.0332> <-9.4524, -1.4953, 2.0332> <-9.4970, -1.4507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -1.6902, 1.6486> <-9.7674, -1.6592, 1.6486> <-10.7959, -1.6592, 1.6486> <-10.8269, -1.6902, 1.6486>
		<-9.6880, -1.6417, 1.7862> <-9.7189, -1.6107, 1.7862> <-10.8444, -1.6107, 1.7862> <-10.8754, -1.6417, 1.7862>
		<-9.5461, -1.4998, 1.8960> <-9.5907, -1.4553, 1.8960> <-10.9727, -1.4553, 1.8960> <-11.0172, -1.4998, 1.8960>
		<-9.4970, -1.4507, 2.0332> <-9.5415, -1.4061, 2.0332> <-11.0218, -1.4061, 2.0332> <-11.0664, -1.4507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 2.0332> <-11.0930, -3.0467, 2.1074> <-11.0932, -3.0469, 2.2382> <-11.0641, -3.0178, 2.3104>
		<-11.1109, -2.9755, 2.0332> <-11.1375, -3.0021, 2.1074> <-11.1376, -3.0025, 2.2382> <-11.1085, -2.9734, 2.3104>
		<-11.1109, -1.4953, 2.0332> <-11.1375, -1.4687, 2.1074> <-11.1376, -1.4683, 2.2382> <-11.1085, -1.4975, 2.3104>
		<-11.0664, -1.4507, 2.0332> <-11.0930, -1.4241, 2.1074> <-11.0932, -1.4239, 2.2382> <-11.0641, -1.4530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -3.0201, 2.0332> <-11.0218, -3.0647, 2.0332> <-9.5415, -3.0647, 2.0332> <-9.4970, -3.0201, 2.0332>
		<-11.0930, -3.0467, 2.1074> <-11.0484, -3.0913, 2.1074> <-9.5149, -3.0913, 2.1074> <-9.4704, -3.0467, 2.1074>
		<-11.0932, -3.0469, 2.2382> <-11.0488, -3.0914, 2.2382> <-9.5146, -3.0914, 2.2382> <-9.4701, -3.0469, 2.2382>
		<-11.0641, -3.0178, 2.3104> <-11.0196, -3.0622, 2.3104> <-9.5437, -3.0622, 2.3104> <-9.4993, -3.0178, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.0201, 2.0332> <-9.4524, -2.9755, 2.0332> <-9.4524, -1.4953, 2.0332> <-9.4970, -1.4507, 2.0332>
		<-9.4704, -3.0467, 2.1074> <-9.4258, -3.0021, 2.1074> <-9.4258, -1.4687, 2.1074> <-9.4704, -1.4241, 2.1074>
		<-9.4701, -3.0469, 2.2382> <-9.4257, -3.0025, 2.2382> <-9.4257, -1.4683, 2.2382> <-9.4701, -1.4239, 2.2382>
		<-9.4993, -3.0178, 2.3104> <-9.4548, -2.9734, 2.3104> <-9.4548, -1.4975, 2.3104> <-9.4993, -1.4530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -1.4507, 2.0332> <-9.5415, -1.4061, 2.0332> <-11.0218, -1.4061, 2.0332> <-11.0664, -1.4507, 2.0332>
		<-9.4704, -1.4241, 2.1074> <-9.5149, -1.3796, 2.1074> <-11.0484, -1.3796, 2.1074> <-11.0930, -1.4241, 2.1074>
		<-9.4701, -1.4239, 2.2382> <-9.5146, -1.3794, 2.2382> <-11.0488, -1.3794, 2.2382> <-11.0932, -1.4239, 2.2382>
		<-9.4993, -1.4530, 2.3104> <-9.5437, -1.4086, 2.3104> <-11.0196, -1.4086, 2.3104> <-11.0641, -1.4530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -3.0178, 2.3104> <-10.9801, -2.9339, 2.5186> <-10.7843, -2.7380, 2.7154> <-10.7056, -2.6594, 2.9276>
		<-11.1085, -2.9734, 2.3104> <-11.0246, -2.8894, 2.5186> <-10.8084, -2.7140, 2.7154> <-10.7297, -2.6353, 2.9276>
		<-11.1085, -1.4975, 2.3104> <-11.0246, -1.5814, 2.5186> <-10.8084, -1.7569, 2.7154> <-10.7297, -1.8355, 2.9276>
		<-11.0641, -1.4530, 2.3104> <-10.9801, -1.5370, 2.5186> <-10.7843, -1.7328, 2.7154> <-10.7056, -1.8115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -3.0178, 2.3104> <-11.0196, -3.0622, 2.3104> <-9.5437, -3.0622, 2.3104> <-9.4993, -3.0178, 2.3104>
		<-10.9801, -2.9339, 2.5186> <-10.9357, -2.9783, 2.5186> <-9.6277, -2.9783, 2.5186> <-9.5832, -2.9339, 2.5186>
		<-10.7843, -2.7380, 2.7154> <-10.7602, -2.7621, 2.7154> <-9.8031, -2.7621, 2.7154> <-9.7790, -2.7380, 2.7154>
		<-10.7056, -2.6594, 2.9276> <-10.6815, -2.6834, 2.9276> <-9.8818, -2.6834, 2.9276> <-9.8577, -2.6594, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, -3.0178, 2.3104> <-9.4548, -2.9734, 2.3104> <-9.4548, -1.4975, 2.3104> <-9.4993, -1.4530, 2.3104>
		<-9.5832, -2.9339, 2.5186> <-9.5388, -2.8894, 2.5186> <-9.5388, -1.5814, 2.5186> <-9.5832, -1.5370, 2.5186>
		<-9.7790, -2.7380, 2.7154> <-9.7550, -2.7140, 2.7154> <-9.7550, -1.7569, 2.7154> <-9.7790, -1.7328, 2.7154>
		<-9.8577, -2.6594, 2.9276> <-9.8336, -2.6353, 2.9276> <-9.8336, -1.8355, 2.9276> <-9.8577, -1.8115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, -1.4530, 2.3104> <-9.5437, -1.4086, 2.3104> <-11.0196, -1.4086, 2.3104> <-11.0641, -1.4530, 2.3104>
		<-9.5832, -1.5370, 2.5186> <-9.6277, -1.4925, 2.5186> <-10.9357, -1.4925, 2.5186> <-10.9801, -1.5370, 2.5186>
		<-9.7790, -1.7328, 2.7154> <-9.8031, -1.7087, 2.7154> <-10.7602, -1.7087, 2.7154> <-10.7843, -1.7328, 2.7154>
		<-9.8577, -1.8115, 2.9276> <-9.8818, -1.7874, 2.9276> <-10.6815, -1.7874, 2.9276> <-10.7056, -1.8115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -2.6594, 2.9276> <-10.6887, -2.6424, 2.9732> <-10.7889, -2.7426, 3.0012> <-10.7889, -2.7426, 3.0528>
		<-10.7297, -2.6353, 2.9276> <-10.7128, -2.6184, 2.9732> <-10.8177, -2.7138, 3.0012> <-10.8177, -2.7138, 3.0528>
		<-10.7297, -1.8355, 2.9276> <-10.7128, -1.8525, 2.9732> <-10.8177, -1.7570, 3.0012> <-10.8177, -1.7570, 3.0528>
		<-10.7056, -1.8115, 2.9276> <-10.6887, -1.8284, 2.9732> <-10.7889, -1.7282, 3.0012> <-10.7889, -1.7282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -2.6594, 2.9276> <-10.6815, -2.6834, 2.9276> <-9.8818, -2.6834, 2.9276> <-9.8577, -2.6594, 2.9276>
		<-10.6887, -2.6424, 2.9732> <-10.6646, -2.6665, 2.9732> <-9.8987, -2.6665, 2.9732> <-9.8746, -2.6424, 2.9732>
		<-10.7889, -2.7426, 3.0012> <-10.7601, -2.7714, 3.0012> <-9.8033, -2.7714, 3.0012> <-9.7745, -2.7426, 3.0012>
		<-10.7889, -2.7426, 3.0528> <-10.7601, -2.7714, 3.0528> <-9.8033, -2.7714, 3.0528> <-9.7745, -2.7426, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -2.6594, 2.9276> <-9.8336, -2.6353, 2.9276> <-9.8336, -1.8355, 2.9276> <-9.8577, -1.8115, 2.9276>
		<-9.8746, -2.6424, 2.9732> <-9.8506, -2.6184, 2.9732> <-9.8506, -1.8525, 2.9732> <-9.8746, -1.8284, 2.9732>
		<-9.7745, -2.7426, 3.0012> <-9.7456, -2.7138, 3.0012> <-9.7456, -1.7570, 3.0012> <-9.7745, -1.7282, 3.0012>
		<-9.7745, -2.7426, 3.0528> <-9.7456, -2.7138, 3.0528> <-9.7456, -1.7570, 3.0528> <-9.7745, -1.7282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -1.8115, 2.9276> <-9.8818, -1.7874, 2.9276> <-10.6815, -1.7874, 2.9276> <-10.7056, -1.8115, 2.9276>
		<-9.8746, -1.8284, 2.9732> <-9.8987, -1.8043, 2.9732> <-10.6646, -1.8043, 2.9732> <-10.6887, -1.8284, 2.9732>
		<-9.7745, -1.7282, 3.0012> <-9.8033, -1.6994, 3.0012> <-10.7601, -1.6994, 3.0012> <-10.7889, -1.7282, 3.0012>
		<-9.7745, -1.7282, 3.0528> <-9.8033, -1.6994, 3.0528> <-10.7601, -1.6994, 3.0528> <-10.7889, -1.7282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -2.7426, 3.0528> <-10.7889, -2.7426, 3.1044> <-10.6862, -2.6400, 3.1344> <-10.7056, -2.6594, 3.1780>
		<-10.8177, -2.7138, 3.0528> <-10.8177, -2.7138, 3.1044> <-10.7103, -2.6159, 3.1344> <-10.7297, -2.6353, 3.1780>
		<-10.8177, -1.7570, 3.0528> <-10.8177, -1.7570, 3.1044> <-10.7103, -1.8549, 3.1344> <-10.7297, -1.8355, 3.1780>
		<-10.7889, -1.7282, 3.0528> <-10.7889, -1.7282, 3.1044> <-10.6862, -1.8309, 3.1344> <-10.7056, -1.8115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -2.7426, 3.0528> <-10.7601, -2.7714, 3.0528> <-9.8033, -2.7714, 3.0528> <-9.7745, -2.7426, 3.0528>
		<-10.7889, -2.7426, 3.1044> <-10.7601, -2.7714, 3.1044> <-9.8033, -2.7714, 3.1044> <-9.7745, -2.7426, 3.1044>
		<-10.6862, -2.6400, 3.1344> <-10.6621, -2.6640, 3.1344> <-9.9012, -2.6640, 3.1344> <-9.8771, -2.6400, 3.1344>
		<-10.7056, -2.6594, 3.1780> <-10.6815, -2.6834, 3.1780> <-9.8818, -2.6834, 3.1780> <-9.8577, -2.6594, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, -2.7426, 3.0528> <-9.7456, -2.7138, 3.0528> <-9.7456, -1.7570, 3.0528> <-9.7745, -1.7282, 3.0528>
		<-9.7745, -2.7426, 3.1044> <-9.7456, -2.7138, 3.1044> <-9.7456, -1.7570, 3.1044> <-9.7745, -1.7282, 3.1044>
		<-9.8771, -2.6400, 3.1344> <-9.8530, -2.6159, 3.1344> <-9.8530, -1.8549, 3.1344> <-9.8771, -1.8309, 3.1344>
		<-9.8577, -2.6594, 3.1780> <-9.8336, -2.6353, 3.1780> <-9.8336, -1.8355, 3.1780> <-9.8577, -1.8115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, -1.7282, 3.0528> <-9.8033, -1.6994, 3.0528> <-10.7601, -1.6994, 3.0528> <-10.7889, -1.7282, 3.0528>
		<-9.7745, -1.7282, 3.1044> <-9.8033, -1.6994, 3.1044> <-10.7601, -1.6994, 3.1044> <-10.7889, -1.7282, 3.1044>
		<-9.8771, -1.8309, 3.1344> <-9.9012, -1.8068, 3.1344> <-10.6621, -1.8068, 3.1344> <-10.6862, -1.8309, 3.1344>
		<-9.8577, -1.8115, 3.1780> <-9.8818, -1.7874, 3.1780> <-10.6815, -1.7874, 3.1780> <-10.7056, -1.8115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -2.6594, 3.1780> <-10.7438, -2.6976, 3.2640> <-10.8610, -2.8148, 3.2738> <-10.9161, -2.8698, 3.3390>
		<-10.7297, -2.6353, 3.1780> <-10.7679, -2.6735, 3.2640> <-10.8971, -2.7788, 3.2738> <-10.9521, -2.8338, 3.3390>
		<-10.7297, -1.8355, 3.1780> <-10.7679, -1.7973, 3.2640> <-10.8971, -1.6921, 3.2738> <-10.9521, -1.6371, 3.3390>
		<-10.7056, -1.8115, 3.1780> <-10.7438, -1.7733, 3.2640> <-10.8610, -1.6560, 3.2738> <-10.9161, -1.6010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -2.6594, 3.1780> <-10.6815, -2.6834, 3.1780> <-9.8818, -2.6834, 3.1780> <-9.8577, -2.6594, 3.1780>
		<-10.7438, -2.6976, 3.2640> <-10.7197, -2.7216, 3.2640> <-9.8436, -2.7216, 3.2640> <-9.8195, -2.6976, 3.2640>
		<-10.8610, -2.8148, 3.2738> <-10.8250, -2.8508, 3.2738> <-9.7383, -2.8508, 3.2738> <-9.7023, -2.8148, 3.2738>
		<-10.9161, -2.8698, 3.3390> <-10.8800, -2.9058, 3.3390> <-9.6833, -2.9058, 3.3390> <-9.6473, -2.8698, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -2.6594, 3.1780> <-9.8336, -2.6353, 3.1780> <-9.8336, -1.8355, 3.1780> <-9.8577, -1.8115, 3.1780>
		<-9.8195, -2.6976, 3.2640> <-9.7954, -2.6735, 3.2640> <-9.7954, -1.7973, 3.2640> <-9.8195, -1.7733, 3.2640>
		<-9.7023, -2.8148, 3.2738> <-9.6663, -2.7788, 3.2738> <-9.6663, -1.6921, 3.2738> <-9.7023, -1.6560, 3.2738>
		<-9.6473, -2.8698, 3.3390> <-9.6112, -2.8338, 3.3390> <-9.6112, -1.6371, 3.3390> <-9.6473, -1.6010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -1.8115, 3.1780> <-9.8818, -1.7874, 3.1780> <-10.6815, -1.7874, 3.1780> <-10.7056, -1.8115, 3.1780>
		<-9.8195, -1.7733, 3.2640> <-9.8436, -1.7492, 3.2640> <-10.7197, -1.7492, 3.2640> <-10.7438, -1.7733, 3.2640>
		<-9.7023, -1.6560, 3.2738> <-9.7383, -1.6200, 3.2738> <-10.8250, -1.6200, 3.2738> <-10.8610, -1.6560, 3.2738>
		<-9.6473, -1.6010, 3.3390> <-9.6833, -1.5650, 3.3390> <-10.8800, -1.5650, 3.3390> <-10.9161, -1.6010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -2.8698, 3.3390> <-10.9416, -2.8954, 3.3693> <-10.9797, -2.9335, 3.4419> <-10.9623, -2.9161, 3.4821>
		<-10.9521, -2.8338, 3.3390> <-10.9777, -2.8594, 3.3693> <-11.0184, -2.8948, 3.4419> <-11.0010, -2.8774, 3.4821>
		<-10.9521, -1.6371, 3.3390> <-10.9777, -1.6115, 3.3693> <-11.0184, -1.5760, 3.4419> <-11.0010, -1.5934, 3.4821>
		<-10.9161, -1.6010, 3.3390> <-10.9416, -1.5754, 3.3693> <-10.9797, -1.5373, 3.4419> <-10.9623, -1.5548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -2.8698, 3.3390> <-10.8800, -2.9058, 3.3390> <-9.6833, -2.9058, 3.3390> <-9.6473, -2.8698, 3.3390>
		<-10.9416, -2.8954, 3.3693> <-10.9056, -2.9314, 3.3693> <-9.6577, -2.9314, 3.3693> <-9.6217, -2.8954, 3.3693>
		<-10.9797, -2.9335, 3.4419> <-10.9411, -2.9721, 3.4419> <-9.6223, -2.9721, 3.4419> <-9.5836, -2.9335, 3.4419>
		<-10.9623, -2.9161, 3.4821> <-10.9236, -2.9547, 3.4821> <-9.6397, -2.9547, 3.4821> <-9.6010, -2.9161, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, -2.8698, 3.3390> <-9.6112, -2.8338, 3.3390> <-9.6112, -1.6371, 3.3390> <-9.6473, -1.6010, 3.3390>
		<-9.6217, -2.8954, 3.3693> <-9.5857, -2.8594, 3.3693> <-9.5857, -1.6115, 3.3693> <-9.6217, -1.5754, 3.3693>
		<-9.5836, -2.9335, 3.4419> <-9.5449, -2.8948, 3.4419> <-9.5449, -1.5760, 3.4419> <-9.5836, -1.5373, 3.4419>
		<-9.6010, -2.9161, 3.4821> <-9.5624, -2.8774, 3.4821> <-9.5624, -1.5934, 3.4821> <-9.6010, -1.5548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, -1.6010, 3.3390> <-9.6833, -1.5650, 3.3390> <-10.8800, -1.5650, 3.3390> <-10.9161, -1.6010, 3.3390>
		<-9.6217, -1.5754, 3.3693> <-9.6577, -1.5394, 3.3693> <-10.9056, -1.5394, 3.3693> <-10.9416, -1.5754, 3.3693>
		<-9.5836, -1.5373, 3.4419> <-9.6223, -1.4987, 3.4419> <-10.9411, -1.4987, 3.4419> <-10.9797, -1.5373, 3.4419>
		<-9.6010, -1.5548, 3.4821> <-9.6397, -1.5161, 3.4821> <-10.9236, -1.5161, 3.4821> <-10.9623, -1.5548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -2.9161, 3.4821> <-10.9163, -2.8700, 3.5884> <-10.7961, -2.7498, 3.6567> <-10.7380, -2.6917, 3.7504>
		<-11.0010, -2.8774, 3.4821> <-10.9550, -2.8314, 3.5884> <-10.8220, -2.7239, 3.6567> <-10.7639, -2.6658, 3.7504>
		<-11.0010, -1.5934, 3.4821> <-10.9550, -1.6394, 3.5884> <-10.8220, -1.7469, 3.6567> <-10.7639, -1.8050, 3.7504>
		<-10.9623, -1.5548, 3.4821> <-10.9163, -1.6008, 3.5884> <-10.7961, -1.7210, 3.6567> <-10.7380, -1.7791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -2.9161, 3.4821> <-10.9236, -2.9547, 3.4821> <-9.6397, -2.9547, 3.4821> <-9.6010, -2.9161, 3.4821>
		<-10.9163, -2.8700, 3.5884> <-10.8776, -2.9087, 3.5884> <-9.6857, -2.9087, 3.5884> <-9.6470, -2.8700, 3.5884>
		<-10.7961, -2.7498, 3.6567> <-10.7702, -2.7758, 3.6567> <-9.7932, -2.7758, 3.6567> <-9.7672, -2.7498, 3.6567>
		<-10.7380, -2.6917, 3.7504> <-10.7121, -2.7177, 3.7504> <-9.8513, -2.7177, 3.7504> <-9.8253, -2.6917, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, -2.9161, 3.4821> <-9.5624, -2.8774, 3.4821> <-9.5624, -1.5934, 3.4821> <-9.6010, -1.5548, 3.4821>
		<-9.6470, -2.8700, 3.5884> <-9.6084, -2.8314, 3.5884> <-9.6084, -1.6394, 3.5884> <-9.6470, -1.6008, 3.5884>
		<-9.7672, -2.7498, 3.6567> <-9.7413, -2.7239, 3.6567> <-9.7413, -1.7469, 3.6567> <-9.7672, -1.7210, 3.6567>
		<-9.8253, -2.6917, 3.7504> <-9.7994, -2.6658, 3.7504> <-9.7994, -1.8050, 3.7504> <-9.8253, -1.7791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, -1.5548, 3.4821> <-9.6397, -1.5161, 3.4821> <-10.9236, -1.5161, 3.4821> <-10.9623, -1.5548, 3.4821>
		<-9.6470, -1.6008, 3.5884> <-9.6857, -1.5621, 3.5884> <-10.8776, -1.5621, 3.5884> <-10.9163, -1.6008, 3.5884>
		<-9.7672, -1.7210, 3.6567> <-9.7932, -1.6951, 3.6567> <-10.7702, -1.6951, 3.6567> <-10.7961, -1.7210, 3.6567>
		<-9.8253, -1.7791, 3.7504> <-9.8513, -1.7532, 3.7504> <-10.7121, -1.7532, 3.7504> <-10.7380, -1.7791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -2.6917, 3.7504> <-10.6964, -2.6502, 3.8175> <-10.6527, -2.6065, 3.9241> <-10.6352, -2.5890, 4.0098>
		<-10.7639, -2.6658, 3.7504> <-10.7223, -2.6243, 3.8175> <-10.6728, -2.5864, 3.9241> <-10.6553, -2.5689, 4.0098>
		<-10.7639, -1.8050, 3.7504> <-10.7223, -1.8466, 3.8175> <-10.6728, -1.8844, 3.9241> <-10.6553, -1.9019, 4.0098>
		<-10.7380, -1.7791, 3.7504> <-10.6964, -1.8207, 3.8175> <-10.6527, -1.8644, 3.9241> <-10.6352, -1.8818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -2.6917, 3.7504> <-10.7121, -2.7177, 3.7504> <-9.8513, -2.7177, 3.7504> <-9.8253, -2.6917, 3.7504>
		<-10.6964, -2.6502, 3.8175> <-10.6705, -2.6761, 3.8175> <-9.8928, -2.6761, 3.8175> <-9.8669, -2.6502, 3.8175>
		<-10.6527, -2.6065, 3.9241> <-10.6326, -2.6266, 3.9241> <-9.9307, -2.6266, 3.9241> <-9.9106, -2.6065, 3.9241>
		<-10.6352, -2.5890, 4.0098> <-10.6152, -2.6091, 4.0098> <-9.9482, -2.6091, 4.0098> <-9.9281, -2.5890, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, -2.6917, 3.7504> <-9.7994, -2.6658, 3.7504> <-9.7994, -1.8050, 3.7504> <-9.8253, -1.7791, 3.7504>
		<-9.8669, -2.6502, 3.8175> <-9.8410, -2.6243, 3.8175> <-9.8410, -1.8466, 3.8175> <-9.8669, -1.8207, 3.8175>
		<-9.9106, -2.6065, 3.9241> <-9.8905, -2.5864, 3.9241> <-9.8905, -1.8844, 3.9241> <-9.9106, -1.8644, 3.9241>
		<-9.9281, -2.5890, 4.0098> <-9.9080, -2.5689, 4.0098> <-9.9080, -1.9019, 4.0098> <-9.9281, -1.8818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, -1.7791, 3.7504> <-9.8513, -1.7532, 3.7504> <-10.7121, -1.7532, 3.7504> <-10.7380, -1.7791, 3.7504>
		<-9.8669, -1.8207, 3.8175> <-9.8928, -1.7947, 3.8175> <-10.6705, -1.7947, 3.8175> <-10.6964, -1.8207, 3.8175>
		<-9.9106, -1.8644, 3.9241> <-9.9307, -1.8443, 3.9241> <-10.6326, -1.8443, 3.9241> <-10.6527, -1.8644, 3.9241>
		<-9.9281, -1.8818, 4.0098> <-9.9482, -1.8617, 4.0098> <-10.6152, -1.8617, 4.0098> <-10.6352, -1.8818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -2.5890, 4.0098> <-10.6168, -2.5706, 4.1002> <-10.6221, -2.5758, 4.2288> <-10.6213, -2.5750, 4.3229>
		<-10.6553, -2.5689, 4.0098> <-10.6369, -2.5505, 4.1002> <-10.6413, -2.5565, 4.2288> <-10.6405, -2.5557, 4.3229>
		<-10.6553, -1.9019, 4.0098> <-10.6369, -1.9203, 4.1002> <-10.6413, -1.9143, 4.2288> <-10.6405, -1.9151, 4.3229>
		<-10.6352, -1.8818, 4.0098> <-10.6168, -1.9003, 4.1002> <-10.6221, -1.8950, 4.2288> <-10.6213, -1.8958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -2.5890, 4.0098> <-10.6152, -2.6091, 4.0098> <-9.9482, -2.6091, 4.0098> <-9.9281, -2.5890, 4.0098>
		<-10.6168, -2.5706, 4.1002> <-10.5967, -2.5906, 4.1002> <-9.9666, -2.5906, 4.1002> <-9.9465, -2.5706, 4.1002>
		<-10.6221, -2.5758, 4.2288> <-10.6028, -2.5951, 4.2288> <-9.9606, -2.5951, 4.2288> <-9.9413, -2.5758, 4.2288>
		<-10.6213, -2.5750, 4.3229> <-10.6020, -2.5943, 4.3229> <-9.9614, -2.5943, 4.3229> <-9.9421, -2.5750, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, -2.5890, 4.0098> <-9.9080, -2.5689, 4.0098> <-9.9080, -1.9019, 4.0098> <-9.9281, -1.8818, 4.0098>
		<-9.9465, -2.5706, 4.1002> <-9.9264, -2.5505, 4.1002> <-9.9264, -1.9203, 4.1002> <-9.9465, -1.9003, 4.1002>
		<-9.9413, -2.5758, 4.2288> <-9.9220, -2.5565, 4.2288> <-9.9220, -1.9143, 4.2288> <-9.9413, -1.8950, 4.2288>
		<-9.9421, -2.5750, 4.3229> <-9.9228, -2.5557, 4.3229> <-9.9228, -1.9151, 4.3229> <-9.9421, -1.8958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, -1.8818, 4.0098> <-9.9482, -1.8617, 4.0098> <-10.6152, -1.8617, 4.0098> <-10.6352, -1.8818, 4.0098>
		<-9.9465, -1.9003, 4.1002> <-9.9666, -1.8802, 4.1002> <-10.5967, -1.8802, 4.1002> <-10.6168, -1.9003, 4.1002>
		<-9.9413, -1.8950, 4.2288> <-9.9606, -1.8757, 4.2288> <-10.6028, -1.8757, 4.2288> <-10.6221, -1.8950, 4.2288>
		<-9.9421, -1.8958, 4.3229> <-9.9614, -1.8765, 4.3229> <-10.6020, -1.8765, 4.3229> <-10.6213, -1.8958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -2.5750, 4.3229> <-10.6179, -2.5716, 4.7283> <-10.6197, -2.5735, 5.2689> <-10.6213, -2.5750, 5.6744>
		<-10.6405, -2.5557, 4.3229> <-10.6371, -2.5523, 4.7283> <-10.6390, -2.5542, 5.2689> <-10.6405, -2.5557, 5.6744>
		<-10.6405, -1.9151, 4.3229> <-10.6371, -1.9185, 4.7283> <-10.6390, -1.9166, 5.2689> <-10.6405, -1.9151, 5.6744>
		<-10.6213, -1.8958, 4.3229> <-10.6179, -1.8992, 4.7283> <-10.6197, -1.8973, 5.2689> <-10.6213, -1.8958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -2.5750, 4.3229> <-10.6020, -2.5943, 4.3229> <-9.9614, -2.5943, 4.3229> <-9.9421, -2.5750, 4.3229>
		<-10.6179, -2.5716, 4.7283> <-10.5986, -2.5909, 4.7283> <-9.9648, -2.5909, 4.7283> <-9.9455, -2.5716, 4.7283>
		<-10.6197, -2.5735, 5.2689> <-10.6004, -2.5928, 5.2689> <-9.9629, -2.5928, 5.2689> <-9.9436, -2.5735, 5.2689>
		<-10.6213, -2.5750, 5.6744> <-10.6020, -2.5943, 5.6744> <-9.9614, -2.5943, 5.6744> <-9.9421, -2.5750, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -2.5750, 4.3229> <-9.9228, -2.5557, 4.3229> <-9.9228, -1.9151, 4.3229> <-9.9421, -1.8958, 4.3229>
		<-9.9455, -2.5716, 4.7283> <-9.9262, -2.5523, 4.7283> <-9.9262, -1.9185, 4.7283> <-9.9455, -1.8992, 4.7283>
		<-9.9436, -2.5735, 5.2689> <-9.9243, -2.5542, 5.2689> <-9.9243, -1.9166, 5.2689> <-9.9436, -1.8973, 5.2689>
		<-9.9421, -2.5750, 5.6744> <-9.9228, -2.5557, 5.6744> <-9.9228, -1.9151, 5.6744> <-9.9421, -1.8958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -1.8958, 4.3229> <-9.9614, -1.8765, 4.3229> <-10.6020, -1.8765, 4.3229> <-10.6213, -1.8958, 4.3229>
		<-9.9455, -1.8992, 4.7283> <-9.9648, -1.8799, 4.7283> <-10.5986, -1.8799, 4.7283> <-10.6179, -1.8992, 4.7283>
		<-9.9436, -1.8973, 5.2689> <-9.9629, -1.8781, 5.2689> <-10.6004, -1.8781, 5.2689> <-10.6197, -1.8973, 5.2689>
		<-9.9421, -1.8958, 5.6744> <-9.9614, -1.8765, 5.6744> <-10.6020, -1.8765, 5.6744> <-10.6213, -1.8958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -2.5750, 5.6744> <-10.6225, -2.5763, 6.0073> <-10.6172, -2.5710, 6.4517> <-10.6305, -2.5843, 6.7841>
		<-10.6405, -2.5557, 5.6744> <-10.6418, -2.5570, 6.0073> <-10.6371, -2.5512, 6.4517> <-10.6503, -2.5645, 6.7841>
		<-10.6405, -1.9151, 5.6744> <-10.6418, -1.9139, 6.0073> <-10.6371, -1.9196, 6.4517> <-10.6503, -1.9064, 6.7841>
		<-10.6213, -1.8958, 5.6744> <-10.6225, -1.8946, 6.0073> <-10.6172, -1.8998, 6.4517> <-10.6305, -1.8866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -2.5750, 5.6744> <-10.6020, -2.5943, 5.6744> <-9.9614, -2.5943, 5.6744> <-9.9421, -2.5750, 5.6744>
		<-10.6225, -2.5763, 6.0073> <-10.6032, -2.5956, 6.0073> <-9.9601, -2.5956, 6.0073> <-9.9408, -2.5763, 6.0073>
		<-10.6172, -2.5710, 6.4517> <-10.5974, -2.5908, 6.4517> <-9.9659, -2.5908, 6.4517> <-9.9461, -2.5710, 6.4517>
		<-10.6305, -2.5843, 6.7841> <-10.6107, -2.6041, 6.7841> <-9.9526, -2.6041, 6.7841> <-9.9328, -2.5843, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -2.5750, 5.6744> <-9.9228, -2.5557, 5.6744> <-9.9228, -1.9151, 5.6744> <-9.9421, -1.8958, 5.6744>
		<-9.9408, -2.5763, 6.0073> <-9.9215, -2.5570, 6.0073> <-9.9215, -1.9139, 6.0073> <-9.9408, -1.8946, 6.0073>
		<-9.9461, -2.5710, 6.4517> <-9.9263, -2.5512, 6.4517> <-9.9263, -1.9196, 6.4517> <-9.9461, -1.8998, 6.4517>
		<-9.9328, -2.5843, 6.7841> <-9.9130, -2.5645, 6.7841> <-9.9130, -1.9064, 6.7841> <-9.9328, -1.8866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -1.8958, 5.6744> <-9.9614, -1.8765, 5.6744> <-10.6020, -1.8765, 5.6744> <-10.6213, -1.8958, 5.6744>
		<-9.9408, -1.8946, 6.0073> <-9.9601, -1.8753, 6.0073> <-10.6032, -1.8753, 6.0073> <-10.6225, -1.8946, 6.0073>
		<-9.9461, -1.8998, 6.4517> <-9.9659, -1.8800, 6.4517> <-10.5974, -1.8800, 6.4517> <-10.6172, -1.8998, 6.4517>
		<-9.9328, -1.8866, 6.7841> <-9.9526, -1.8667, 6.7841> <-10.6107, -1.8667, 6.7841> <-10.6305, -1.8866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -2.5843, 6.7841> <-10.6325, -2.5863, 6.8341> <-10.6449, -2.5987, 6.9079> <-10.6718, -2.6255, 6.9405>
		<-10.6503, -2.5645, 6.7841> <-10.6523, -2.5664, 6.8341> <-10.6671, -2.5765, 6.9079> <-10.6940, -2.6034, 6.9405>
		<-10.6503, -1.9064, 6.7841> <-10.6523, -1.9044, 6.8341> <-10.6671, -1.8943, 6.9079> <-10.6940, -1.8674, 6.9405>
		<-10.6305, -1.8866, 6.7841> <-10.6325, -1.8846, 6.8341> <-10.6449, -1.8722, 6.9079> <-10.6718, -1.8453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -2.5843, 6.7841> <-10.6107, -2.6041, 6.7841> <-9.9526, -2.6041, 6.7841> <-9.9328, -2.5843, 6.7841>
		<-10.6325, -2.5863, 6.8341> <-10.6127, -2.6061, 6.8341> <-9.9506, -2.6061, 6.8341> <-9.9308, -2.5863, 6.8341>
		<-10.6449, -2.5987, 6.9079> <-10.6228, -2.6208, 6.9079> <-9.9406, -2.6208, 6.9079> <-9.9184, -2.5987, 6.9079>
		<-10.6718, -2.6255, 6.9405> <-10.6496, -2.6477, 6.9405> <-9.9137, -2.6477, 6.9405> <-9.8915, -2.6255, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, -2.5843, 6.7841> <-9.9130, -2.5645, 6.7841> <-9.9130, -1.9064, 6.7841> <-9.9328, -1.8866, 6.7841>
		<-9.9308, -2.5863, 6.8341> <-9.9110, -2.5664, 6.8341> <-9.9110, -1.9044, 6.8341> <-9.9308, -1.8846, 6.8341>
		<-9.9184, -2.5987, 6.9079> <-9.8962, -2.5765, 6.9079> <-9.8962, -1.8943, 6.9079> <-9.9184, -1.8722, 6.9079>
		<-9.8915, -2.6255, 6.9405> <-9.8694, -2.6034, 6.9405> <-9.8694, -1.8674, 6.9405> <-9.8915, -1.8453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, -1.8866, 6.7841> <-9.9526, -1.8667, 6.7841> <-10.6107, -1.8667, 6.7841> <-10.6305, -1.8866, 6.7841>
		<-9.9308, -1.8846, 6.8341> <-9.9506, -1.8648, 6.8341> <-10.6127, -1.8648, 6.8341> <-10.6325, -1.8846, 6.8341>
		<-9.9184, -1.8722, 6.9079> <-9.9406, -1.8500, 6.9079> <-10.6228, -1.8500, 6.9079> <-10.6449, -1.8722, 6.9079>
		<-9.8915, -1.8453, 6.9405> <-9.9137, -1.8231, 6.9405> <-10.6496, -1.8231, 6.9405> <-10.6718, -1.8453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -2.6255, 6.9405> <-10.7339, -2.6877, 7.0160> <-10.8620, -2.8158, 7.0331> <-10.9114, -2.8652, 7.1255>
		<-10.6940, -2.6034, 6.9405> <-10.7561, -2.6655, 7.0160> <-10.8978, -2.7800, 7.0331> <-10.9472, -2.8294, 7.1255>
		<-10.6940, -1.8674, 6.9405> <-10.7561, -1.8053, 7.0160> <-10.8978, -1.6908, 7.0331> <-10.9472, -1.6414, 7.1255>
		<-10.6718, -1.8453, 6.9405> <-10.7339, -1.7832, 7.0160> <-10.8620, -1.6551, 7.0331> <-10.9114, -1.6056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -2.6255, 6.9405> <-10.6496, -2.6477, 6.9405> <-9.9137, -2.6477, 6.9405> <-9.8915, -2.6255, 6.9405>
		<-10.7339, -2.6877, 7.0160> <-10.7117, -2.7098, 7.0160> <-9.8516, -2.7098, 7.0160> <-9.8294, -2.6877, 7.0160>
		<-10.8620, -2.8158, 7.0331> <-10.8262, -2.8515, 7.0331> <-9.7371, -2.8515, 7.0331> <-9.7013, -2.8158, 7.0331>
		<-10.9114, -2.8652, 7.1255> <-10.8757, -2.9010, 7.1255> <-9.6877, -2.9010, 7.1255> <-9.6519, -2.8652, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, -2.6255, 6.9405> <-9.8694, -2.6034, 6.9405> <-9.8694, -1.8674, 6.9405> <-9.8915, -1.8453, 6.9405>
		<-9.8294, -2.6877, 7.0160> <-9.8073, -2.6655, 7.0160> <-9.8073, -1.8053, 7.0160> <-9.8294, -1.7832, 7.0160>
		<-9.7013, -2.8158, 7.0331> <-9.6655, -2.7800, 7.0331> <-9.6655, -1.6908, 7.0331> <-9.7013, -1.6551, 7.0331>
		<-9.6519, -2.8652, 7.1255> <-9.6161, -2.8294, 7.1255> <-9.6161, -1.6414, 7.1255> <-9.6519, -1.6056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, -1.8453, 6.9405> <-9.9137, -1.8231, 6.9405> <-10.6496, -1.8231, 6.9405> <-10.6718, -1.8453, 6.9405>
		<-9.8294, -1.7832, 7.0160> <-9.8516, -1.7610, 7.0160> <-10.7117, -1.7610, 7.0160> <-10.7339, -1.7832, 7.0160>
		<-9.7013, -1.6551, 7.0331> <-9.7371, -1.6193, 7.0331> <-10.8262, -1.6193, 7.0331> <-10.8620, -1.6551, 7.0331>
		<-9.6519, -1.6056, 7.1255> <-9.6877, -1.5699, 7.1255> <-10.8757, -1.5699, 7.1255> <-10.9114, -1.6056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -2.8652, 7.1255> <-10.9319, -2.8857, 7.1638> <-10.8316, -2.7854, 7.1912> <-10.8316, -2.7854, 7.2393>
		<-10.9472, -2.8294, 7.1255> <-10.9677, -2.8499, 7.1638> <-10.8629, -2.7541, 7.1912> <-10.8629, -2.7541, 7.2393>
		<-10.9472, -1.6414, 7.1255> <-10.9677, -1.6209, 7.1638> <-10.8629, -1.7167, 7.1912> <-10.8629, -1.7167, 7.2393>
		<-10.9114, -1.6056, 7.1255> <-10.9319, -1.5851, 7.1638> <-10.8316, -1.6854, 7.1912> <-10.8316, -1.6854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -2.8652, 7.1255> <-10.8757, -2.9010, 7.1255> <-9.6877, -2.9010, 7.1255> <-9.6519, -2.8652, 7.1255>
		<-10.9319, -2.8857, 7.1638> <-10.8962, -2.9215, 7.1638> <-9.6671, -2.9215, 7.1638> <-9.6314, -2.8857, 7.1638>
		<-10.8316, -2.7854, 7.1912> <-10.8004, -2.8166, 7.1912> <-9.7629, -2.8166, 7.1912> <-9.7317, -2.7854, 7.1912>
		<-10.8316, -2.7854, 7.2393> <-10.8004, -2.8166, 7.2393> <-9.7629, -2.8166, 7.2393> <-9.7317, -2.7854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -2.8652, 7.1255> <-9.6161, -2.8294, 7.1255> <-9.6161, -1.6414, 7.1255> <-9.6519, -1.6056, 7.1255>
		<-9.6314, -2.8857, 7.1638> <-9.5956, -2.8499, 7.1638> <-9.5956, -1.6209, 7.1638> <-9.6314, -1.5851, 7.1638>
		<-9.7317, -2.7854, 7.1912> <-9.7005, -2.7541, 7.1912> <-9.7005, -1.7167, 7.1912> <-9.7317, -1.6854, 7.1912>
		<-9.7317, -2.7854, 7.2393> <-9.7005, -2.7541, 7.2393> <-9.7005, -1.7167, 7.2393> <-9.7317, -1.6854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -1.6056, 7.1255> <-9.6877, -1.5699, 7.1255> <-10.8757, -1.5699, 7.1255> <-10.9114, -1.6056, 7.1255>
		<-9.6314, -1.5851, 7.1638> <-9.6671, -1.5494, 7.1638> <-10.8962, -1.5494, 7.1638> <-10.9319, -1.5851, 7.1638>
		<-9.7317, -1.6854, 7.1912> <-9.7629, -1.6542, 7.1912> <-10.8004, -1.6542, 7.1912> <-10.8316, -1.6854, 7.1912>
		<-9.7317, -1.6854, 7.2393> <-9.7629, -1.6542, 7.2393> <-10.8004, -1.6542, 7.2393> <-10.8316, -1.6854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -2.7854, 7.2393> <-10.8316, -2.7854, 7.2905> <-10.9054, -2.8592, 7.3169> <-10.9114, -2.8652, 7.3673>
		<-10.8629, -2.7541, 7.2393> <-10.8629, -2.7541, 7.2905> <-10.9412, -2.8234, 7.3169> <-10.9472, -2.8294, 7.3673>
		<-10.8629, -1.7167, 7.2393> <-10.8629, -1.7167, 7.2905> <-10.9412, -1.6474, 7.3169> <-10.9472, -1.6414, 7.3673>
		<-10.8316, -1.6854, 7.2393> <-10.8316, -1.6854, 7.2905> <-10.9054, -1.6117, 7.3169> <-10.9114, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -2.7854, 7.2393> <-10.8004, -2.8166, 7.2393> <-9.7629, -2.8166, 7.2393> <-9.7317, -2.7854, 7.2393>
		<-10.8316, -2.7854, 7.2905> <-10.8004, -2.8166, 7.2905> <-9.7629, -2.8166, 7.2905> <-9.7317, -2.7854, 7.2905>
		<-10.9054, -2.8592, 7.3169> <-10.8696, -2.8949, 7.3169> <-9.6937, -2.8949, 7.3169> <-9.6579, -2.8592, 7.3169>
		<-10.9114, -2.8652, 7.3673> <-10.8757, -2.9010, 7.3673> <-9.6877, -2.9010, 7.3673> <-9.6519, -2.8652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, -2.7854, 7.2393> <-9.7005, -2.7541, 7.2393> <-9.7005, -1.7167, 7.2393> <-9.7317, -1.6854, 7.2393>
		<-9.7317, -2.7854, 7.2905> <-9.7005, -2.7541, 7.2905> <-9.7005, -1.7167, 7.2905> <-9.7317, -1.6854, 7.2905>
		<-9.6579, -2.8592, 7.3169> <-9.6222, -2.8234, 7.3169> <-9.6222, -1.6474, 7.3169> <-9.6579, -1.6117, 7.3169>
		<-9.6519, -2.8652, 7.3673> <-9.6161, -2.8294, 7.3673> <-9.6161, -1.6414, 7.3673> <-9.6519, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, -1.6854, 7.2393> <-9.7629, -1.6542, 7.2393> <-10.8004, -1.6542, 7.2393> <-10.8316, -1.6854, 7.2393>
		<-9.7317, -1.6854, 7.2905> <-9.7629, -1.6542, 7.2905> <-10.8004, -1.6542, 7.2905> <-10.8316, -1.6854, 7.2905>
		<-9.6579, -1.6117, 7.3169> <-9.6937, -1.5759, 7.3169> <-10.8696, -1.5759, 7.3169> <-10.9054, -1.6117, 7.3169>
		<-9.6519, -1.6056, 7.3673> <-9.6877, -1.5699, 7.3673> <-10.8757, -1.5699, 7.3673> <-10.9114, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -2.8652, 7.9080> <-10.9472, -2.8294, 7.9080> <-10.9472, -1.6414, 7.9080> <-10.9114, -1.6056, 7.9080>
		<-10.9114, -2.8652, 7.7458> <-10.9472, -2.8294, 7.7458> <-10.9472, -1.6414, 7.7458> <-10.9114, -1.6056, 7.7458>
		<-10.9305, -2.8843, 7.5273> <-10.9663, -2.8485, 7.5273> <-10.9663, -1.6223, 7.5273> <-10.9305, -1.5866, 7.5273>
		<-10.9114, -2.8652, 7.3673> <-10.9472, -2.8294, 7.3673> <-10.9472, -1.6414, 7.3673> <-10.9114, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -2.8652, 7.9080> <-10.9114, -2.8652, 7.7458> <-10.9305, -2.8843, 7.5273> <-10.9114, -2.8652, 7.3673>
		<-10.8757, -2.9010, 7.9080> <-10.8757, -2.9010, 7.7458> <-10.8947, -2.9200, 7.5273> <-10.8757, -2.9010, 7.3673>
		<-9.6877, -2.9010, 7.9080> <-9.6877, -2.9010, 7.7458> <-9.6686, -2.9200, 7.5273> <-9.6877, -2.9010, 7.3673>
		<-9.6519, -2.8652, 7.9080> <-9.6519, -2.8652, 7.7458> <-9.6328, -2.8843, 7.5273> <-9.6519, -2.8652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -2.8652, 7.9080> <-9.6519, -2.8652, 7.7458> <-9.6328, -2.8843, 7.5273> <-9.6519, -2.8652, 7.3673>
		<-9.6161, -2.8294, 7.9080> <-9.6161, -2.8294, 7.7458> <-9.5970, -2.8485, 7.5273> <-9.6161, -2.8294, 7.3673>
		<-9.6161, -1.6414, 7.9080> <-9.6161, -1.6414, 7.7458> <-9.5970, -1.6223, 7.5273> <-9.6161, -1.6414, 7.3673>
		<-9.6519, -1.6056, 7.9080> <-9.6519, -1.6056, 7.7458> <-9.6328, -1.5866, 7.5273> <-9.6519, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -1.6056, 7.9080> <-9.6519, -1.6056, 7.7458> <-9.6328, -1.5866, 7.5273> <-9.6519, -1.6056, 7.3673>
		<-9.6877, -1.5699, 7.9080> <-9.6877, -1.5699, 7.7458> <-9.6686, -1.5508, 7.5273> <-9.6877, -1.5699, 7.3673>
		<-10.8757, -1.5699, 7.9080> <-10.8757, -1.5699, 7.7458> <-10.8947, -1.5508, 7.5273> <-10.8757, -1.5699, 7.3673>
		<-10.9114, -1.6056, 7.9080> <-10.9114, -1.6056, 7.7458> <-10.9305, -1.5866, 7.5273> <-10.9114, -1.6056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -3.1126, 0.7771> <-11.2087, -3.0628, 0.7771> <-11.2087, -1.4080, 0.7771> <-11.1589, -1.3582, 0.7771>
		<-11.1796, -3.1334, 0.6520> <-11.2294, -3.0836, 0.6520> <-11.2294, -1.3873, 0.6520> <-11.1796, -1.3374, 0.6520>
		<-11.1589, -3.1126, 0.4772> <-11.2087, -3.0628, 0.4772> <-11.2087, -1.4080, 0.4772> <-11.1589, -1.3582, 0.4772>
		<-11.1589, -3.1126, 0.3486> <-11.2087, -3.0628, 0.3486> <-11.2087, -1.4080, 0.3486> <-11.1589, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -3.1126, 0.7771> <-11.1796, -3.1334, 0.6520> <-11.1589, -3.1126, 0.4772> <-11.1589, -3.1126, 0.3486>
		<-11.1090, -3.1624, 0.7771> <-11.1298, -3.1832, 0.6520> <-11.1090, -3.1624, 0.4772> <-11.1090, -3.1624, 0.3486>
		<-9.4543, -3.1624, 0.7771> <-9.4335, -3.1832, 0.6520> <-9.4543, -3.1624, 0.4772> <-9.4543, -3.1624, 0.3486>
		<-9.4045, -3.1126, 0.7771> <-9.3837, -3.1334, 0.6520> <-9.4045, -3.1126, 0.4772> <-9.4045, -3.1126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -3.1126, 0.7771> <-9.3837, -3.1334, 0.6520> <-9.4045, -3.1126, 0.4772> <-9.4045, -3.1126, 0.3486>
		<-9.3546, -3.0628, 0.7771> <-9.3339, -3.0836, 0.6520> <-9.3546, -3.0628, 0.4772> <-9.3546, -3.0628, 0.3486>
		<-9.3546, -1.4080, 0.7771> <-9.3339, -1.3873, 0.6520> <-9.3546, -1.4080, 0.4772> <-9.3546, -1.4080, 0.3486>
		<-9.4045, -1.3582, 0.7771> <-9.3837, -1.3374, 0.6520> <-9.4045, -1.3582, 0.4772> <-9.4045, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -1.3582, 0.7771> <-9.3837, -1.3374, 0.6520> <-9.4045, -1.3582, 0.4772> <-9.4045, -1.3582, 0.3486>
		<-9.4543, -1.3084, 0.7771> <-9.4335, -1.2876, 0.6520> <-9.4543, -1.3084, 0.4772> <-9.4543, -1.3084, 0.3486>
		<-11.1090, -1.3084, 0.7771> <-11.1298, -1.2876, 0.6520> <-11.1090, -1.3084, 0.4772> <-11.1090, -1.3084, 0.3486>
		<-11.1589, -1.3582, 0.7771> <-11.1796, -1.3374, 0.6520> <-11.1589, -1.3582, 0.4772> <-11.1589, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -3.1126, -0.0618> <-11.1589, -3.1126, 0.0613> <-11.1589, -3.1126, 0.2255> <-11.1589, -3.1126, 0.3486>
		<-11.2087, -3.0628, -0.0618> <-11.2087, -3.0628, 0.0613> <-11.2087, -3.0628, 0.2255> <-11.2087, -3.0628, 0.3486>
		<-11.2087, -1.4080, -0.0618> <-11.2087, -1.4080, 0.0613> <-11.2087, -1.4080, 0.2255> <-11.2087, -1.4080, 0.3486>
		<-11.1589, -1.3582, -0.0618> <-11.1589, -1.3582, 0.0613> <-11.1589, -1.3582, 0.2255> <-11.1589, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -3.1126, -0.0618> <-11.1090, -3.1624, -0.0618> <-9.4543, -3.1624, -0.0618> <-9.4045, -3.1126, -0.0618>
		<-11.1589, -3.1126, 0.0613> <-11.1090, -3.1624, 0.0613> <-9.4543, -3.1624, 0.0613> <-9.4045, -3.1126, 0.0613>
		<-11.1589, -3.1126, 0.2255> <-11.1090, -3.1624, 0.2255> <-9.4543, -3.1624, 0.2255> <-9.4045, -3.1126, 0.2255>
		<-11.1589, -3.1126, 0.3486> <-11.1090, -3.1624, 0.3486> <-9.4543, -3.1624, 0.3486> <-9.4045, -3.1126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -3.1126, -0.0618> <-9.3546, -3.0628, -0.0618> <-9.3546, -1.4080, -0.0618> <-9.4045, -1.3582, -0.0618>
		<-9.4045, -3.1126, 0.0613> <-9.3546, -3.0628, 0.0613> <-9.3546, -1.4080, 0.0613> <-9.4045, -1.3582, 0.0613>
		<-9.4045, -3.1126, 0.2255> <-9.3546, -3.0628, 0.2255> <-9.3546, -1.4080, 0.2255> <-9.4045, -1.3582, 0.2255>
		<-9.4045, -3.1126, 0.3486> <-9.3546, -3.0628, 0.3486> <-9.3546, -1.4080, 0.3486> <-9.4045, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -1.3582, -0.0618> <-9.4543, -1.3084, -0.0618> <-11.1090, -1.3084, -0.0618> <-11.1589, -1.3582, -0.0618>
		<-9.4045, -1.3582, 0.0613> <-9.4543, -1.3084, 0.0613> <-11.1090, -1.3084, 0.0613> <-11.1589, -1.3582, 0.0613>
		<-9.4045, -1.3582, 0.2255> <-9.4543, -1.3084, 0.2255> <-11.1090, -1.3084, 0.2255> <-11.1589, -1.3582, 0.2255>
		<-9.4045, -1.3582, 0.3486> <-9.4543, -1.3084, 0.3486> <-11.1090, -1.3084, 0.3486> <-11.1589, -1.3582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 0.9062> <-11.1109, -5.1755, 0.9062> <-11.1109, -3.6953, 0.9062> <-11.0664, -3.6507, 0.9062>
		<-11.0712, -5.2249, 0.8515> <-11.1157, -5.1804, 0.8515> <-11.1157, -3.6905, 0.8515> <-11.0712, -3.6459, 0.8515>
		<-11.1500, -5.3037, 0.8308> <-11.1998, -5.2539, 0.8308> <-11.1998, -3.6169, 0.8308> <-11.1500, -3.5671, 0.8308>
		<-11.1589, -5.3126, 0.7771> <-11.2087, -5.2628, 0.7771> <-11.2087, -3.6080, 0.7771> <-11.1589, -3.5582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 0.9062> <-11.0620, -5.2158, 0.9557> <-11.1560, -5.3097, 0.9996> <-11.1357, -5.2895, 1.0404>
		<-11.1109, -5.1755, 0.9062> <-11.1066, -5.1712, 0.9557> <-11.2045, -5.2612, 0.9996> <-11.1842, -5.2410, 1.0404>
		<-11.1109, -3.6953, 0.9062> <-11.1066, -3.6996, 0.9557> <-11.2045, -3.6096, 0.9996> <-11.1842, -3.6298, 1.0404>
		<-11.0664, -3.6507, 0.9062> <-11.0620, -3.6551, 0.9557> <-11.1560, -3.5611, 0.9996> <-11.1357, -3.5813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 0.9062> <-11.0712, -5.2249, 0.8515> <-11.1500, -5.3037, 0.8308> <-11.1589, -5.3126, 0.7771>
		<-11.0218, -5.2647, 0.9062> <-11.0266, -5.2695, 0.8515> <-11.1001, -5.3535, 0.8308> <-11.1090, -5.3624, 0.7771>
		<-9.5415, -5.2647, 0.9062> <-9.5367, -5.2695, 0.8515> <-9.4632, -5.3535, 0.8308> <-9.4543, -5.3624, 0.7771>
		<-9.4970, -5.2201, 0.9062> <-9.4922, -5.2249, 0.8515> <-9.4134, -5.3037, 0.8308> <-9.4045, -5.3126, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 0.9062> <-11.0218, -5.2647, 0.9062> <-9.5415, -5.2647, 0.9062> <-9.4970, -5.2201, 0.9062>
		<-11.0620, -5.2158, 0.9557> <-11.0175, -5.2603, 0.9557> <-9.5459, -5.2603, 0.9557> <-9.5013, -5.2158, 0.9557>
		<-11.1560, -5.3097, 0.9996> <-11.1075, -5.3582, 0.9996> <-9.4559, -5.3582, 0.9996> <-9.4073, -5.3097, 0.9996>
		<-11.1357, -5.2895, 1.0404> <-11.0872, -5.3380, 1.0404> <-9.4761, -5.3380, 1.0404> <-9.4276, -5.2895, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -5.2201, 0.9062> <-9.4922, -5.2249, 0.8515> <-9.4134, -5.3037, 0.8308> <-9.4045, -5.3126, 0.7771>
		<-9.4524, -5.1755, 0.9062> <-9.4476, -5.1804, 0.8515> <-9.3635, -5.2539, 0.8308> <-9.3546, -5.2628, 0.7771>
		<-9.4524, -3.6953, 0.9062> <-9.4476, -3.6905, 0.8515> <-9.3635, -3.6169, 0.8308> <-9.3546, -3.6080, 0.7771>
		<-9.4970, -3.6507, 0.9062> <-9.4922, -3.6459, 0.8515> <-9.4134, -3.5671, 0.8308> <-9.4045, -3.5582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -5.2201, 0.9062> <-9.4524, -5.1755, 0.9062> <-9.4524, -3.6953, 0.9062> <-9.4970, -3.6507, 0.9062>
		<-9.5013, -5.2158, 0.9557> <-9.4567, -5.1712, 0.9557> <-9.4567, -3.6996, 0.9557> <-9.5013, -3.6551, 0.9557>
		<-9.4073, -5.3097, 0.9996> <-9.3588, -5.2612, 0.9996> <-9.3588, -3.6096, 0.9996> <-9.4073, -3.5611, 0.9996>
		<-9.4276, -5.2895, 1.0404> <-9.3791, -5.2410, 1.0404> <-9.3791, -3.6298, 1.0404> <-9.4276, -3.5813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.6507, 0.9062> <-9.4922, -3.6459, 0.8515> <-9.4134, -3.5671, 0.8308> <-9.4045, -3.5582, 0.7771>
		<-9.5415, -3.6061, 0.9062> <-9.5367, -3.6013, 0.8515> <-9.4632, -3.5173, 0.8308> <-9.4543, -3.5084, 0.7771>
		<-11.0218, -3.6061, 0.9062> <-11.0266, -3.6013, 0.8515> <-11.1001, -3.5173, 0.8308> <-11.1090, -3.5084, 0.7771>
		<-11.0664, -3.6507, 0.9062> <-11.0712, -3.6459, 0.8515> <-11.1500, -3.5671, 0.8308> <-11.1589, -3.5582, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.6507, 0.9062> <-9.5415, -3.6061, 0.9062> <-11.0218, -3.6061, 0.9062> <-11.0664, -3.6507, 0.9062>
		<-9.5013, -3.6551, 0.9557> <-9.5459, -3.6105, 0.9557> <-11.0175, -3.6105, 0.9557> <-11.0620, -3.6551, 0.9557>
		<-9.4073, -3.5611, 0.9996> <-9.4559, -3.5126, 0.9996> <-11.1075, -3.5126, 0.9996> <-11.1560, -3.5611, 0.9996>
		<-9.4276, -3.5813, 1.0404> <-9.4761, -3.5328, 1.0404> <-11.0872, -3.5328, 1.0404> <-11.1357, -3.5813, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -5.2895, 1.0404> <-11.0677, -5.2214, 1.1777> <-10.8982, -5.0519, 1.2552> <-10.8269, -4.9807, 1.3892>
		<-11.1842, -5.2410, 1.0404> <-11.1162, -5.1729, 1.1777> <-10.9291, -5.0210, 1.2552> <-10.8579, -4.9497, 1.3892>
		<-11.1842, -3.6298, 1.0404> <-11.1162, -3.6979, 1.1777> <-10.9291, -3.8499, 1.2552> <-10.8579, -3.9211, 1.3892>
		<-11.1357, -3.5813, 1.0404> <-11.0677, -3.6494, 1.1777> <-10.8982, -3.8189, 1.2552> <-10.8269, -3.8902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1357, -5.2895, 1.0404> <-11.0872, -5.3380, 1.0404> <-9.4761, -5.3380, 1.0404> <-9.4276, -5.2895, 1.0404>
		<-11.0677, -5.2214, 1.1777> <-11.0192, -5.2699, 1.1777> <-9.5442, -5.2699, 1.1777> <-9.4957, -5.2214, 1.1777>
		<-10.8982, -5.0519, 1.2552> <-10.8672, -5.0829, 1.2552> <-9.6961, -5.0829, 1.2552> <-9.6652, -5.0519, 1.2552>
		<-10.8269, -4.9807, 1.3892> <-10.7959, -5.0116, 1.3892> <-9.7674, -5.0116, 1.3892> <-9.7364, -4.9807, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, -5.2895, 1.0404> <-9.3791, -5.2410, 1.0404> <-9.3791, -3.6298, 1.0404> <-9.4276, -3.5813, 1.0404>
		<-9.4957, -5.2214, 1.1777> <-9.4471, -5.1729, 1.1777> <-9.4471, -3.6979, 1.1777> <-9.4957, -3.6494, 1.1777>
		<-9.6652, -5.0519, 1.2552> <-9.6342, -5.0210, 1.2552> <-9.6342, -3.8499, 1.2552> <-9.6652, -3.8189, 1.2552>
		<-9.7364, -4.9807, 1.3892> <-9.7054, -4.9497, 1.3892> <-9.7054, -3.9211, 1.3892> <-9.7364, -3.8902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4276, -3.5813, 1.0404> <-9.4761, -3.5328, 1.0404> <-11.0872, -3.5328, 1.0404> <-11.1357, -3.5813, 1.0404>
		<-9.4957, -3.6494, 1.1777> <-9.5442, -3.6009, 1.1777> <-11.0192, -3.6009, 1.1777> <-11.0677, -3.6494, 1.1777>
		<-9.6652, -3.8189, 1.2552> <-9.6961, -3.7879, 1.2552> <-10.8672, -3.7879, 1.2552> <-10.8982, -3.8189, 1.2552>
		<-9.7364, -3.8902, 1.3892> <-9.7674, -3.8592, 1.3892> <-10.7959, -3.8592, 1.3892> <-10.8269, -3.8902, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -4.9807, 1.3892> <-10.8079, -4.9617, 1.4249> <-10.8837, -5.0374, 1.4698> <-10.8837, -5.0374, 1.5144>
		<-10.8579, -4.9497, 1.3892> <-10.8389, -4.9307, 1.4249> <-10.9179, -5.0032, 1.4698> <-10.9179, -5.0032, 1.5144>
		<-10.8579, -3.9211, 1.3892> <-10.8389, -3.9401, 1.4249> <-10.9179, -3.8676, 1.4698> <-10.9179, -3.8676, 1.5144>
		<-10.8269, -3.8902, 1.3892> <-10.8079, -3.9091, 1.4249> <-10.8837, -3.8334, 1.4698> <-10.8837, -3.8334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -4.9807, 1.3892> <-10.7959, -5.0116, 1.3892> <-9.7674, -5.0116, 1.3892> <-9.7364, -4.9807, 1.3892>
		<-10.8079, -4.9617, 1.4249> <-10.7770, -4.9927, 1.4249> <-9.7863, -4.9927, 1.4249> <-9.7554, -4.9617, 1.4249>
		<-10.8837, -5.0374, 1.4698> <-10.8495, -5.0716, 1.4698> <-9.7138, -5.0716, 1.4698> <-9.6796, -5.0374, 1.4698>
		<-10.8837, -5.0374, 1.5144> <-10.8495, -5.0716, 1.5144> <-9.7138, -5.0716, 1.5144> <-9.6796, -5.0374, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -4.9807, 1.3892> <-9.7054, -4.9497, 1.3892> <-9.7054, -3.9211, 1.3892> <-9.7364, -3.8902, 1.3892>
		<-9.7554, -4.9617, 1.4249> <-9.7244, -4.9307, 1.4249> <-9.7244, -3.9401, 1.4249> <-9.7554, -3.9091, 1.4249>
		<-9.6796, -5.0374, 1.4698> <-9.6455, -5.0032, 1.4698> <-9.6455, -3.8676, 1.4698> <-9.6796, -3.8334, 1.4698>
		<-9.6796, -5.0374, 1.5144> <-9.6455, -5.0032, 1.5144> <-9.6455, -3.8676, 1.5144> <-9.6796, -3.8334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -3.8902, 1.3892> <-9.7674, -3.8592, 1.3892> <-10.7959, -3.8592, 1.3892> <-10.8269, -3.8902, 1.3892>
		<-9.7554, -3.9091, 1.4249> <-9.7863, -3.8782, 1.4249> <-10.7770, -3.8782, 1.4249> <-10.8079, -3.9091, 1.4249>
		<-9.6796, -3.8334, 1.4698> <-9.7138, -3.7992, 1.4698> <-10.8495, -3.7992, 1.4698> <-10.8837, -3.8334, 1.4698>
		<-9.6796, -3.8334, 1.5144> <-9.7138, -3.7992, 1.5144> <-10.8495, -3.7992, 1.5144> <-10.8837, -3.8334, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -5.0374, 1.5144> <-10.8837, -5.0374, 1.5613> <-10.8121, -4.9659, 1.6066> <-10.8269, -4.9807, 1.6486>
		<-10.9179, -5.0032, 1.5144> <-10.9179, -5.0032, 1.5613> <-10.8431, -4.9349, 1.6066> <-10.8579, -4.9497, 1.6486>
		<-10.9179, -3.8676, 1.5144> <-10.9179, -3.8676, 1.5613> <-10.8431, -3.9359, 1.6066> <-10.8579, -3.9211, 1.6486>
		<-10.8837, -3.8334, 1.5144> <-10.8837, -3.8334, 1.5613> <-10.8121, -3.9050, 1.6066> <-10.8269, -3.8902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8837, -5.0374, 1.5144> <-10.8495, -5.0716, 1.5144> <-9.7138, -5.0716, 1.5144> <-9.6796, -5.0374, 1.5144>
		<-10.8837, -5.0374, 1.5613> <-10.8495, -5.0716, 1.5613> <-9.7138, -5.0716, 1.5613> <-9.6796, -5.0374, 1.5613>
		<-10.8121, -4.9659, 1.6066> <-10.7812, -4.9968, 1.6066> <-9.7822, -4.9968, 1.6066> <-9.7512, -4.9659, 1.6066>
		<-10.8269, -4.9807, 1.6486> <-10.7959, -5.0116, 1.6486> <-9.7674, -5.0116, 1.6486> <-9.7364, -4.9807, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, -5.0374, 1.5144> <-9.6455, -5.0032, 1.5144> <-9.6455, -3.8676, 1.5144> <-9.6796, -3.8334, 1.5144>
		<-9.6796, -5.0374, 1.5613> <-9.6455, -5.0032, 1.5613> <-9.6455, -3.8676, 1.5613> <-9.6796, -3.8334, 1.5613>
		<-9.7512, -4.9659, 1.6066> <-9.7202, -4.9349, 1.6066> <-9.7202, -3.9359, 1.6066> <-9.7512, -3.9050, 1.6066>
		<-9.7364, -4.9807, 1.6486> <-9.7054, -4.9497, 1.6486> <-9.7054, -3.9211, 1.6486> <-9.7364, -3.8902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6796, -3.8334, 1.5144> <-9.7138, -3.7992, 1.5144> <-10.8495, -3.7992, 1.5144> <-10.8837, -3.8334, 1.5144>
		<-9.6796, -3.8334, 1.5613> <-9.7138, -3.7992, 1.5613> <-10.8495, -3.7992, 1.5613> <-10.8837, -3.8334, 1.5613>
		<-9.7512, -3.9050, 1.6066> <-9.7822, -3.8740, 1.6066> <-10.7812, -3.8740, 1.6066> <-10.8121, -3.9050, 1.6066>
		<-9.7364, -3.8902, 1.6486> <-9.7674, -3.8592, 1.6486> <-10.7959, -3.8592, 1.6486> <-10.8269, -3.8902, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -4.9807, 1.6486> <-10.8754, -5.0291, 1.7862> <-11.0172, -5.1710, 1.8960> <-11.0664, -5.2201, 2.0332>
		<-10.8579, -4.9497, 1.6486> <-10.9063, -4.9982, 1.7862> <-11.0618, -5.1264, 1.8960> <-11.1109, -5.1755, 2.0332>
		<-10.8579, -3.9211, 1.6486> <-10.9063, -3.8727, 1.7862> <-11.0618, -3.7444, 1.8960> <-11.1109, -3.6953, 2.0332>
		<-10.8269, -3.8902, 1.6486> <-10.8754, -3.8417, 1.7862> <-11.0172, -3.6998, 1.8960> <-11.0664, -3.6507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8269, -4.9807, 1.6486> <-10.7959, -5.0116, 1.6486> <-9.7674, -5.0116, 1.6486> <-9.7364, -4.9807, 1.6486>
		<-10.8754, -5.0291, 1.7862> <-10.8444, -5.0601, 1.7862> <-9.7189, -5.0601, 1.7862> <-9.6880, -5.0291, 1.7862>
		<-11.0172, -5.1710, 1.8960> <-10.9727, -5.2156, 1.8960> <-9.5907, -5.2156, 1.8960> <-9.5461, -5.1710, 1.8960>
		<-11.0664, -5.2201, 2.0332> <-11.0218, -5.2647, 2.0332> <-9.5415, -5.2647, 2.0332> <-9.4970, -5.2201, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -4.9807, 1.6486> <-9.7054, -4.9497, 1.6486> <-9.7054, -3.9211, 1.6486> <-9.7364, -3.8902, 1.6486>
		<-9.6880, -5.0291, 1.7862> <-9.6570, -4.9982, 1.7862> <-9.6570, -3.8727, 1.7862> <-9.6880, -3.8417, 1.7862>
		<-9.5461, -5.1710, 1.8960> <-9.5015, -5.1264, 1.8960> <-9.5015, -3.7444, 1.8960> <-9.5461, -3.6998, 1.8960>
		<-9.4970, -5.2201, 2.0332> <-9.4524, -5.1755, 2.0332> <-9.4524, -3.6953, 2.0332> <-9.4970, -3.6507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7364, -3.8902, 1.6486> <-9.7674, -3.8592, 1.6486> <-10.7959, -3.8592, 1.6486> <-10.8269, -3.8902, 1.6486>
		<-9.6880, -3.8417, 1.7862> <-9.7189, -3.8107, 1.7862> <-10.8444, -3.8107, 1.7862> <-10.8754, -3.8417, 1.7862>
		<-9.5461, -3.6998, 1.8960> <-9.5907, -3.6553, 1.8960> <-10.9727, -3.6553, 1.8960> <-11.0172, -3.6998, 1.8960>
		<-9.4970, -3.6507, 2.0332> <-9.5415, -3.6061, 2.0332> <-11.0218, -3.6061, 2.0332> <-11.0664, -3.6507, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 2.0332> <-11.0930, -5.2467, 2.1074> <-11.0932, -5.2469, 2.2382> <-11.0641, -5.2178, 2.3104>
		<-11.1109, -5.1755, 2.0332> <-11.1375, -5.2021, 2.1074> <-11.1376, -5.2025, 2.2382> <-11.1085, -5.1734, 2.3104>
		<-11.1109, -3.6953, 2.0332> <-11.1375, -3.6687, 2.1074> <-11.1376, -3.6683, 2.2382> <-11.1085, -3.6975, 2.3104>
		<-11.0664, -3.6507, 2.0332> <-11.0930, -3.6241, 2.1074> <-11.0932, -3.6239, 2.2382> <-11.0641, -3.6530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0664, -5.2201, 2.0332> <-11.0218, -5.2647, 2.0332> <-9.5415, -5.2647, 2.0332> <-9.4970, -5.2201, 2.0332>
		<-11.0930, -5.2467, 2.1074> <-11.0484, -5.2913, 2.1074> <-9.5149, -5.2913, 2.1074> <-9.4704, -5.2467, 2.1074>
		<-11.0932, -5.2469, 2.2382> <-11.0488, -5.2914, 2.2382> <-9.5146, -5.2914, 2.2382> <-9.4701, -5.2469, 2.2382>
		<-11.0641, -5.2178, 2.3104> <-11.0196, -5.2622, 2.3104> <-9.5437, -5.2622, 2.3104> <-9.4993, -5.2178, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -5.2201, 2.0332> <-9.4524, -5.1755, 2.0332> <-9.4524, -3.6953, 2.0332> <-9.4970, -3.6507, 2.0332>
		<-9.4704, -5.2467, 2.1074> <-9.4258, -5.2021, 2.1074> <-9.4258, -3.6687, 2.1074> <-9.4704, -3.6241, 2.1074>
		<-9.4701, -5.2469, 2.2382> <-9.4257, -5.2025, 2.2382> <-9.4257, -3.6683, 2.2382> <-9.4701, -3.6239, 2.2382>
		<-9.4993, -5.2178, 2.3104> <-9.4548, -5.1734, 2.3104> <-9.4548, -3.6975, 2.3104> <-9.4993, -3.6530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4970, -3.6507, 2.0332> <-9.5415, -3.6061, 2.0332> <-11.0218, -3.6061, 2.0332> <-11.0664, -3.6507, 2.0332>
		<-9.4704, -3.6241, 2.1074> <-9.5149, -3.5796, 2.1074> <-11.0484, -3.5796, 2.1074> <-11.0930, -3.6241, 2.1074>
		<-9.4701, -3.6239, 2.2382> <-9.5146, -3.5794, 2.2382> <-11.0488, -3.5794, 2.2382> <-11.0932, -3.6239, 2.2382>
		<-9.4993, -3.6530, 2.3104> <-9.5437, -3.6086, 2.3104> <-11.0196, -3.6086, 2.3104> <-11.0641, -3.6530, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -5.2178, 2.3104> <-10.9801, -5.1339, 2.5186> <-10.7843, -4.9380, 2.7154> <-10.7056, -4.8594, 2.9276>
		<-11.1085, -5.1734, 2.3104> <-11.0246, -5.0894, 2.5186> <-10.8084, -4.9140, 2.7154> <-10.7297, -4.8353, 2.9276>
		<-11.1085, -3.6975, 2.3104> <-11.0246, -3.7814, 2.5186> <-10.8084, -3.9569, 2.7154> <-10.7297, -4.0355, 2.9276>
		<-11.0641, -3.6530, 2.3104> <-10.9801, -3.7370, 2.5186> <-10.7843, -3.9328, 2.7154> <-10.7056, -4.0115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.0641, -5.2178, 2.3104> <-11.0196, -5.2622, 2.3104> <-9.5437, -5.2622, 2.3104> <-9.4993, -5.2178, 2.3104>
		<-10.9801, -5.1339, 2.5186> <-10.9357, -5.1783, 2.5186> <-9.6277, -5.1783, 2.5186> <-9.5832, -5.1339, 2.5186>
		<-10.7843, -4.9380, 2.7154> <-10.7602, -4.9621, 2.7154> <-9.8031, -4.9621, 2.7154> <-9.7790, -4.9380, 2.7154>
		<-10.7056, -4.8594, 2.9276> <-10.6815, -4.8835, 2.9276> <-9.8818, -4.8835, 2.9276> <-9.8577, -4.8594, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, -5.2178, 2.3104> <-9.4548, -5.1734, 2.3104> <-9.4548, -3.6975, 2.3104> <-9.4993, -3.6530, 2.3104>
		<-9.5832, -5.1339, 2.5186> <-9.5388, -5.0894, 2.5186> <-9.5388, -3.7814, 2.5186> <-9.5832, -3.7370, 2.5186>
		<-9.7790, -4.9380, 2.7154> <-9.7550, -4.9140, 2.7154> <-9.7550, -3.9569, 2.7154> <-9.7790, -3.9328, 2.7154>
		<-9.8577, -4.8594, 2.9276> <-9.8336, -4.8353, 2.9276> <-9.8336, -4.0355, 2.9276> <-9.8577, -4.0115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4993, -3.6530, 2.3104> <-9.5437, -3.6086, 2.3104> <-11.0196, -3.6086, 2.3104> <-11.0641, -3.6530, 2.3104>
		<-9.5832, -3.7370, 2.5186> <-9.6277, -3.6925, 2.5186> <-10.9357, -3.6925, 2.5186> <-10.9801, -3.7370, 2.5186>
		<-9.7790, -3.9328, 2.7154> <-9.8031, -3.9087, 2.7154> <-10.7602, -3.9087, 2.7154> <-10.7843, -3.9328, 2.7154>
		<-9.8577, -4.0115, 2.9276> <-9.8818, -3.9874, 2.9276> <-10.6815, -3.9874, 2.9276> <-10.7056, -4.0115, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -4.8594, 2.9276> <-10.6887, -4.8424, 2.9732> <-10.7889, -4.9426, 3.0012> <-10.7889, -4.9426, 3.0528>
		<-10.7297, -4.8353, 2.9276> <-10.7128, -4.8184, 2.9732> <-10.8177, -4.9138, 3.0012> <-10.8177, -4.9138, 3.0528>
		<-10.7297, -4.0355, 2.9276> <-10.7128, -4.0525, 2.9732> <-10.8177, -3.9570, 3.0012> <-10.8177, -3.9570, 3.0528>
		<-10.7056, -4.0115, 2.9276> <-10.6887, -4.0284, 2.9732> <-10.7889, -3.9282, 3.0012> <-10.7889, -3.9282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -4.8594, 2.9276> <-10.6815, -4.8835, 2.9276> <-9.8818, -4.8835, 2.9276> <-9.8577, -4.8594, 2.9276>
		<-10.6887, -4.8424, 2.9732> <-10.6646, -4.8665, 2.9732> <-9.8987, -4.8665, 2.9732> <-9.8746, -4.8424, 2.9732>
		<-10.7889, -4.9426, 3.0012> <-10.7601, -4.9714, 3.0012> <-9.8033, -4.9714, 3.0012> <-9.7745, -4.9426, 3.0012>
		<-10.7889, -4.9426, 3.0528> <-10.7601, -4.9714, 3.0528> <-9.8033, -4.9714, 3.0528> <-9.7745, -4.9426, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -4.8594, 2.9276> <-9.8336, -4.8353, 2.9276> <-9.8336, -4.0355, 2.9276> <-9.8577, -4.0115, 2.9276>
		<-9.8746, -4.8424, 2.9732> <-9.8506, -4.8184, 2.9732> <-9.8506, -4.0525, 2.9732> <-9.8746, -4.0284, 2.9732>
		<-9.7745, -4.9426, 3.0012> <-9.7456, -4.9138, 3.0012> <-9.7456, -3.9570, 3.0012> <-9.7745, -3.9282, 3.0012>
		<-9.7745, -4.9426, 3.0528> <-9.7456, -4.9138, 3.0528> <-9.7456, -3.9570, 3.0528> <-9.7745, -3.9282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -4.0115, 2.9276> <-9.8818, -3.9874, 2.9276> <-10.6815, -3.9874, 2.9276> <-10.7056, -4.0115, 2.9276>
		<-9.8746, -4.0284, 2.9732> <-9.8987, -4.0043, 2.9732> <-10.6646, -4.0043, 2.9732> <-10.6887, -4.0284, 2.9732>
		<-9.7745, -3.9282, 3.0012> <-9.8033, -3.8994, 3.0012> <-10.7601, -3.8994, 3.0012> <-10.7889, -3.9282, 3.0012>
		<-9.7745, -3.9282, 3.0528> <-9.8033, -3.8994, 3.0528> <-10.7601, -3.8994, 3.0528> <-10.7889, -3.9282, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -4.9426, 3.0528> <-10.7889, -4.9426, 3.1044> <-10.6862, -4.8400, 3.1344> <-10.7056, -4.8594, 3.1780>
		<-10.8177, -4.9138, 3.0528> <-10.8177, -4.9138, 3.1044> <-10.7103, -4.8159, 3.1344> <-10.7297, -4.8353, 3.1780>
		<-10.8177, -3.9570, 3.0528> <-10.8177, -3.9570, 3.1044> <-10.7103, -4.0549, 3.1344> <-10.7297, -4.0355, 3.1780>
		<-10.7889, -3.9282, 3.0528> <-10.7889, -3.9282, 3.1044> <-10.6862, -4.0309, 3.1344> <-10.7056, -4.0115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7889, -4.9426, 3.0528> <-10.7601, -4.9714, 3.0528> <-9.8033, -4.9714, 3.0528> <-9.7745, -4.9426, 3.0528>
		<-10.7889, -4.9426, 3.1044> <-10.7601, -4.9714, 3.1044> <-9.8033, -4.9714, 3.1044> <-9.7745, -4.9426, 3.1044>
		<-10.6862, -4.8400, 3.1344> <-10.6621, -4.8640, 3.1344> <-9.9012, -4.8640, 3.1344> <-9.8771, -4.8400, 3.1344>
		<-10.7056, -4.8594, 3.1780> <-10.6815, -4.8835, 3.1780> <-9.8818, -4.8835, 3.1780> <-9.8577, -4.8594, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, -4.9426, 3.0528> <-9.7456, -4.9138, 3.0528> <-9.7456, -3.9570, 3.0528> <-9.7745, -3.9282, 3.0528>
		<-9.7745, -4.9426, 3.1044> <-9.7456, -4.9138, 3.1044> <-9.7456, -3.9570, 3.1044> <-9.7745, -3.9282, 3.1044>
		<-9.8771, -4.8400, 3.1344> <-9.8530, -4.8159, 3.1344> <-9.8530, -4.0549, 3.1344> <-9.8771, -4.0309, 3.1344>
		<-9.8577, -4.8594, 3.1780> <-9.8336, -4.8353, 3.1780> <-9.8336, -4.0355, 3.1780> <-9.8577, -4.0115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7745, -3.9282, 3.0528> <-9.8033, -3.8994, 3.0528> <-10.7601, -3.8994, 3.0528> <-10.7889, -3.9282, 3.0528>
		<-9.7745, -3.9282, 3.1044> <-9.8033, -3.8994, 3.1044> <-10.7601, -3.8994, 3.1044> <-10.7889, -3.9282, 3.1044>
		<-9.8771, -4.0309, 3.1344> <-9.9012, -4.0068, 3.1344> <-10.6621, -4.0068, 3.1344> <-10.6862, -4.0309, 3.1344>
		<-9.8577, -4.0115, 3.1780> <-9.8818, -3.9874, 3.1780> <-10.6815, -3.9874, 3.1780> <-10.7056, -4.0115, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -4.8594, 3.1780> <-10.7438, -4.8976, 3.2640> <-10.8610, -5.0148, 3.2738> <-10.9161, -5.0698, 3.3390>
		<-10.7297, -4.8353, 3.1780> <-10.7679, -4.8735, 3.2640> <-10.8971, -4.9788, 3.2738> <-10.9521, -5.0338, 3.3390>
		<-10.7297, -4.0355, 3.1780> <-10.7679, -3.9973, 3.2640> <-10.8971, -3.8921, 3.2738> <-10.9521, -3.8371, 3.3390>
		<-10.7056, -4.0115, 3.1780> <-10.7438, -3.9733, 3.2640> <-10.8610, -3.8560, 3.2738> <-10.9161, -3.8010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7056, -4.8594, 3.1780> <-10.6815, -4.8835, 3.1780> <-9.8818, -4.8835, 3.1780> <-9.8577, -4.8594, 3.1780>
		<-10.7438, -4.8976, 3.2640> <-10.7197, -4.9216, 3.2640> <-9.8436, -4.9216, 3.2640> <-9.8195, -4.8976, 3.2640>
		<-10.8610, -5.0148, 3.2738> <-10.8250, -5.0508, 3.2738> <-9.7383, -5.0508, 3.2738> <-9.7023, -5.0148, 3.2738>
		<-10.9161, -5.0698, 3.3390> <-10.8800, -5.1058, 3.3390> <-9.6833, -5.1058, 3.3390> <-9.6473, -5.0698, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -4.8594, 3.1780> <-9.8336, -4.8353, 3.1780> <-9.8336, -4.0355, 3.1780> <-9.8577, -4.0115, 3.1780>
		<-9.8195, -4.8976, 3.2640> <-9.7954, -4.8735, 3.2640> <-9.7954, -3.9973, 3.2640> <-9.8195, -3.9733, 3.2640>
		<-9.7023, -5.0148, 3.2738> <-9.6663, -4.9788, 3.2738> <-9.6663, -3.8921, 3.2738> <-9.7023, -3.8560, 3.2738>
		<-9.6473, -5.0698, 3.3390> <-9.6112, -5.0338, 3.3390> <-9.6112, -3.8371, 3.3390> <-9.6473, -3.8010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8577, -4.0115, 3.1780> <-9.8818, -3.9874, 3.1780> <-10.6815, -3.9874, 3.1780> <-10.7056, -4.0115, 3.1780>
		<-9.8195, -3.9733, 3.2640> <-9.8436, -3.9492, 3.2640> <-10.7197, -3.9492, 3.2640> <-10.7438, -3.9733, 3.2640>
		<-9.7023, -3.8560, 3.2738> <-9.7383, -3.8200, 3.2738> <-10.8250, -3.8200, 3.2738> <-10.8610, -3.8560, 3.2738>
		<-9.6473, -3.8010, 3.3390> <-9.6833, -3.7650, 3.3390> <-10.8800, -3.7650, 3.3390> <-10.9161, -3.8010, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -5.0698, 3.3390> <-10.9416, -5.0954, 3.3693> <-10.9797, -5.1335, 3.4419> <-10.9623, -5.1161, 3.4821>
		<-10.9521, -5.0338, 3.3390> <-10.9777, -5.0594, 3.3693> <-11.0184, -5.0948, 3.4419> <-11.0010, -5.0774, 3.4821>
		<-10.9521, -3.8371, 3.3390> <-10.9777, -3.8115, 3.3693> <-11.0184, -3.7760, 3.4419> <-11.0010, -3.7934, 3.4821>
		<-10.9161, -3.8010, 3.3390> <-10.9416, -3.7754, 3.3693> <-10.9797, -3.7373, 3.4419> <-10.9623, -3.7548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9161, -5.0698, 3.3390> <-10.8800, -5.1058, 3.3390> <-9.6833, -5.1058, 3.3390> <-9.6473, -5.0698, 3.3390>
		<-10.9416, -5.0954, 3.3693> <-10.9056, -5.1314, 3.3693> <-9.6577, -5.1314, 3.3693> <-9.6217, -5.0954, 3.3693>
		<-10.9797, -5.1335, 3.4419> <-10.9411, -5.1721, 3.4419> <-9.6223, -5.1721, 3.4419> <-9.5836, -5.1335, 3.4419>
		<-10.9623, -5.1161, 3.4821> <-10.9236, -5.1547, 3.4821> <-9.6397, -5.1547, 3.4821> <-9.6010, -5.1161, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, -5.0698, 3.3390> <-9.6112, -5.0338, 3.3390> <-9.6112, -3.8371, 3.3390> <-9.6473, -3.8010, 3.3390>
		<-9.6217, -5.0954, 3.3693> <-9.5857, -5.0594, 3.3693> <-9.5857, -3.8115, 3.3693> <-9.6217, -3.7754, 3.3693>
		<-9.5836, -5.1335, 3.4419> <-9.5449, -5.0948, 3.4419> <-9.5449, -3.7760, 3.4419> <-9.5836, -3.7373, 3.4419>
		<-9.6010, -5.1161, 3.4821> <-9.5624, -5.0774, 3.4821> <-9.5624, -3.7934, 3.4821> <-9.6010, -3.7548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6473, -3.8010, 3.3390> <-9.6833, -3.7650, 3.3390> <-10.8800, -3.7650, 3.3390> <-10.9161, -3.8010, 3.3390>
		<-9.6217, -3.7754, 3.3693> <-9.6577, -3.7394, 3.3693> <-10.9056, -3.7394, 3.3693> <-10.9416, -3.7754, 3.3693>
		<-9.5836, -3.7373, 3.4419> <-9.6223, -3.6987, 3.4419> <-10.9411, -3.6987, 3.4419> <-10.9797, -3.7373, 3.4419>
		<-9.6010, -3.7548, 3.4821> <-9.6397, -3.7161, 3.4821> <-10.9236, -3.7161, 3.4821> <-10.9623, -3.7548, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -5.1161, 3.4821> <-10.9163, -5.0700, 3.5884> <-10.7961, -4.9498, 3.6567> <-10.7380, -4.8917, 3.7504>
		<-11.0010, -5.0774, 3.4821> <-10.9550, -5.0314, 3.5884> <-10.8220, -4.9239, 3.6567> <-10.7639, -4.8658, 3.7504>
		<-11.0010, -3.7934, 3.4821> <-10.9550, -3.8394, 3.5884> <-10.8220, -3.9469, 3.6567> <-10.7639, -4.0050, 3.7504>
		<-10.9623, -3.7548, 3.4821> <-10.9163, -3.8008, 3.5884> <-10.7961, -3.9210, 3.6567> <-10.7380, -3.9791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9623, -5.1161, 3.4821> <-10.9236, -5.1547, 3.4821> <-9.6397, -5.1547, 3.4821> <-9.6010, -5.1161, 3.4821>
		<-10.9163, -5.0700, 3.5884> <-10.8776, -5.1087, 3.5884> <-9.6857, -5.1087, 3.5884> <-9.6470, -5.0700, 3.5884>
		<-10.7961, -4.9498, 3.6567> <-10.7702, -4.9758, 3.6567> <-9.7932, -4.9758, 3.6567> <-9.7672, -4.9498, 3.6567>
		<-10.7380, -4.8917, 3.7504> <-10.7121, -4.9177, 3.7504> <-9.8513, -4.9177, 3.7504> <-9.8253, -4.8917, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, -5.1161, 3.4821> <-9.5624, -5.0774, 3.4821> <-9.5624, -3.7934, 3.4821> <-9.6010, -3.7548, 3.4821>
		<-9.6470, -5.0700, 3.5884> <-9.6084, -5.0314, 3.5884> <-9.6084, -3.8394, 3.5884> <-9.6470, -3.8008, 3.5884>
		<-9.7672, -4.9498, 3.6567> <-9.7413, -4.9239, 3.6567> <-9.7413, -3.9469, 3.6567> <-9.7672, -3.9210, 3.6567>
		<-9.8253, -4.8917, 3.7504> <-9.7994, -4.8658, 3.7504> <-9.7994, -4.0050, 3.7504> <-9.8253, -3.9791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6010, -3.7548, 3.4821> <-9.6397, -3.7161, 3.4821> <-10.9236, -3.7161, 3.4821> <-10.9623, -3.7548, 3.4821>
		<-9.6470, -3.8008, 3.5884> <-9.6857, -3.7621, 3.5884> <-10.8776, -3.7621, 3.5884> <-10.9163, -3.8008, 3.5884>
		<-9.7672, -3.9210, 3.6567> <-9.7932, -3.8951, 3.6567> <-10.7702, -3.8951, 3.6567> <-10.7961, -3.9210, 3.6567>
		<-9.8253, -3.9791, 3.7504> <-9.8513, -3.9532, 3.7504> <-10.7121, -3.9532, 3.7504> <-10.7380, -3.9791, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -4.8917, 3.7504> <-10.6964, -4.8502, 3.8175> <-10.6527, -4.8065, 3.9241> <-10.6352, -4.7890, 4.0098>
		<-10.7639, -4.8658, 3.7504> <-10.7223, -4.8243, 3.8175> <-10.6728, -4.7864, 3.9241> <-10.6553, -4.7689, 4.0098>
		<-10.7639, -4.0050, 3.7504> <-10.7223, -4.0466, 3.8175> <-10.6728, -4.0844, 3.9241> <-10.6553, -4.1019, 4.0098>
		<-10.7380, -3.9791, 3.7504> <-10.6964, -4.0207, 3.8175> <-10.6527, -4.0644, 3.9241> <-10.6352, -4.0818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.7380, -4.8917, 3.7504> <-10.7121, -4.9177, 3.7504> <-9.8513, -4.9177, 3.7504> <-9.8253, -4.8917, 3.7504>
		<-10.6964, -4.8502, 3.8175> <-10.6705, -4.8761, 3.8175> <-9.8928, -4.8761, 3.8175> <-9.8669, -4.8502, 3.8175>
		<-10.6527, -4.8065, 3.9241> <-10.6326, -4.8266, 3.9241> <-9.9307, -4.8266, 3.9241> <-9.9106, -4.8065, 3.9241>
		<-10.6352, -4.7890, 4.0098> <-10.6152, -4.8091, 4.0098> <-9.9482, -4.8091, 4.0098> <-9.9281, -4.7890, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, -4.8917, 3.7504> <-9.7994, -4.8658, 3.7504> <-9.7994, -4.0050, 3.7504> <-9.8253, -3.9791, 3.7504>
		<-9.8669, -4.8502, 3.8175> <-9.8410, -4.8243, 3.8175> <-9.8410, -4.0466, 3.8175> <-9.8669, -4.0207, 3.8175>
		<-9.9106, -4.8065, 3.9241> <-9.8905, -4.7864, 3.9241> <-9.8905, -4.0844, 3.9241> <-9.9106, -4.0644, 3.9241>
		<-9.9281, -4.7890, 4.0098> <-9.9080, -4.7689, 4.0098> <-9.9080, -4.1019, 4.0098> <-9.9281, -4.0818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8253, -3.9791, 3.7504> <-9.8513, -3.9532, 3.7504> <-10.7121, -3.9532, 3.7504> <-10.7380, -3.9791, 3.7504>
		<-9.8669, -4.0207, 3.8175> <-9.8928, -3.9947, 3.8175> <-10.6705, -3.9947, 3.8175> <-10.6964, -4.0207, 3.8175>
		<-9.9106, -4.0644, 3.9241> <-9.9307, -4.0443, 3.9241> <-10.6326, -4.0443, 3.9241> <-10.6527, -4.0644, 3.9241>
		<-9.9281, -4.0818, 4.0098> <-9.9482, -4.0617, 4.0098> <-10.6152, -4.0617, 4.0098> <-10.6352, -4.0818, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -4.7890, 4.0098> <-10.6168, -4.7706, 4.1002> <-10.6221, -4.7758, 4.2288> <-10.6213, -4.7750, 4.3229>
		<-10.6553, -4.7689, 4.0098> <-10.6369, -4.7505, 4.1002> <-10.6413, -4.7565, 4.2288> <-10.6405, -4.7557, 4.3229>
		<-10.6553, -4.1019, 4.0098> <-10.6369, -4.1203, 4.1002> <-10.6413, -4.1143, 4.2288> <-10.6405, -4.1151, 4.3229>
		<-10.6352, -4.0818, 4.0098> <-10.6168, -4.1003, 4.1002> <-10.6221, -4.0950, 4.2288> <-10.6213, -4.0958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6352, -4.7890, 4.0098> <-10.6152, -4.8091, 4.0098> <-9.9482, -4.8091, 4.0098> <-9.9281, -4.7890, 4.0098>
		<-10.6168, -4.7706, 4.1002> <-10.5967, -4.7906, 4.1002> <-9.9666, -4.7906, 4.1002> <-9.9465, -4.7706, 4.1002>
		<-10.6221, -4.7758, 4.2288> <-10.6028, -4.7951, 4.2288> <-9.9606, -4.7951, 4.2288> <-9.9413, -4.7758, 4.2288>
		<-10.6213, -4.7750, 4.3229> <-10.6020, -4.7943, 4.3229> <-9.9614, -4.7943, 4.3229> <-9.9421, -4.7750, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, -4.7890, 4.0098> <-9.9080, -4.7689, 4.0098> <-9.9080, -4.1019, 4.0098> <-9.9281, -4.0818, 4.0098>
		<-9.9465, -4.7706, 4.1002> <-9.9264, -4.7505, 4.1002> <-9.9264, -4.1203, 4.1002> <-9.9465, -4.1003, 4.1002>
		<-9.9413, -4.7758, 4.2288> <-9.9220, -4.7565, 4.2288> <-9.9220, -4.1143, 4.2288> <-9.9413, -4.0950, 4.2288>
		<-9.9421, -4.7750, 4.3229> <-9.9228, -4.7557, 4.3229> <-9.9228, -4.1151, 4.3229> <-9.9421, -4.0958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9281, -4.0818, 4.0098> <-9.9482, -4.0617, 4.0098> <-10.6152, -4.0617, 4.0098> <-10.6352, -4.0818, 4.0098>
		<-9.9465, -4.1003, 4.1002> <-9.9666, -4.0802, 4.1002> <-10.5967, -4.0802, 4.1002> <-10.6168, -4.1003, 4.1002>
		<-9.9413, -4.0950, 4.2288> <-9.9606, -4.0757, 4.2288> <-10.6028, -4.0757, 4.2288> <-10.6221, -4.0950, 4.2288>
		<-9.9421, -4.0958, 4.3229> <-9.9614, -4.0765, 4.3229> <-10.6020, -4.0765, 4.3229> <-10.6213, -4.0958, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -4.7750, 4.3229> <-10.6179, -4.7716, 4.7283> <-10.6197, -4.7735, 5.2689> <-10.6213, -4.7750, 5.6744>
		<-10.6405, -4.7557, 4.3229> <-10.6371, -4.7523, 4.7283> <-10.6390, -4.7542, 5.2689> <-10.6405, -4.7557, 5.6744>
		<-10.6405, -4.1151, 4.3229> <-10.6371, -4.1185, 4.7283> <-10.6390, -4.1166, 5.2689> <-10.6405, -4.1151, 5.6744>
		<-10.6213, -4.0958, 4.3229> <-10.6179, -4.0992, 4.7283> <-10.6197, -4.0973, 5.2689> <-10.6213, -4.0958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -4.7750, 4.3229> <-10.6020, -4.7943, 4.3229> <-9.9614, -4.7943, 4.3229> <-9.9421, -4.7750, 4.3229>
		<-10.6179, -4.7716, 4.7283> <-10.5986, -4.7909, 4.7283> <-9.9648, -4.7909, 4.7283> <-9.9455, -4.7716, 4.7283>
		<-10.6197, -4.7735, 5.2689> <-10.6004, -4.7928, 5.2689> <-9.9629, -4.7928, 5.2689> <-9.9436, -4.7735, 5.2689>
		<-10.6213, -4.7750, 5.6744> <-10.6020, -4.7943, 5.6744> <-9.9614, -4.7943, 5.6744> <-9.9421, -4.7750, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -4.7750, 4.3229> <-9.9228, -4.7557, 4.3229> <-9.9228, -4.1151, 4.3229> <-9.9421, -4.0958, 4.3229>
		<-9.9455, -4.7716, 4.7283> <-9.9262, -4.7523, 4.7283> <-9.9262, -4.1185, 4.7283> <-9.9455, -4.0992, 4.7283>
		<-9.9436, -4.7735, 5.2689> <-9.9243, -4.7542, 5.2689> <-9.9243, -4.1166, 5.2689> <-9.9436, -4.0973, 5.2689>
		<-9.9421, -4.7750, 5.6744> <-9.9228, -4.7557, 5.6744> <-9.9228, -4.1151, 5.6744> <-9.9421, -4.0958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -4.0958, 4.3229> <-9.9614, -4.0765, 4.3229> <-10.6020, -4.0765, 4.3229> <-10.6213, -4.0958, 4.3229>
		<-9.9455, -4.0992, 4.7283> <-9.9648, -4.0799, 4.7283> <-10.5986, -4.0799, 4.7283> <-10.6179, -4.0992, 4.7283>
		<-9.9436, -4.0973, 5.2689> <-9.9629, -4.0781, 5.2689> <-10.6004, -4.0781, 5.2689> <-10.6197, -4.0973, 5.2689>
		<-9.9421, -4.0958, 5.6744> <-9.9614, -4.0765, 5.6744> <-10.6020, -4.0765, 5.6744> <-10.6213, -4.0958, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -4.7750, 5.6744> <-10.6225, -4.7763, 6.0073> <-10.6172, -4.7710, 6.4517> <-10.6305, -4.7843, 6.7841>
		<-10.6405, -4.7557, 5.6744> <-10.6418, -4.7570, 6.0073> <-10.6371, -4.7512, 6.4517> <-10.6503, -4.7645, 6.7841>
		<-10.6405, -4.1151, 5.6744> <-10.6418, -4.1139, 6.0073> <-10.6371, -4.1196, 6.4517> <-10.6503, -4.1064, 6.7841>
		<-10.6213, -4.0958, 5.6744> <-10.6225, -4.0946, 6.0073> <-10.6172, -4.0998, 6.4517> <-10.6305, -4.0866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6213, -4.7750, 5.6744> <-10.6020, -4.7943, 5.6744> <-9.9614, -4.7943, 5.6744> <-9.9421, -4.7750, 5.6744>
		<-10.6225, -4.7763, 6.0073> <-10.6032, -4.7956, 6.0073> <-9.9601, -4.7956, 6.0073> <-9.9408, -4.7763, 6.0073>
		<-10.6172, -4.7710, 6.4517> <-10.5974, -4.7908, 6.4517> <-9.9659, -4.7908, 6.4517> <-9.9461, -4.7710, 6.4517>
		<-10.6305, -4.7843, 6.7841> <-10.6107, -4.8041, 6.7841> <-9.9526, -4.8041, 6.7841> <-9.9328, -4.7843, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -4.7750, 5.6744> <-9.9228, -4.7557, 5.6744> <-9.9228, -4.1151, 5.6744> <-9.9421, -4.0958, 5.6744>
		<-9.9408, -4.7763, 6.0073> <-9.9215, -4.7570, 6.0073> <-9.9215, -4.1139, 6.0073> <-9.9408, -4.0946, 6.0073>
		<-9.9461, -4.7710, 6.4517> <-9.9263, -4.7512, 6.4517> <-9.9263, -4.1196, 6.4517> <-9.9461, -4.0998, 6.4517>
		<-9.9328, -4.7843, 6.7841> <-9.9130, -4.7645, 6.7841> <-9.9130, -4.1064, 6.7841> <-9.9328, -4.0866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9421, -4.0958, 5.6744> <-9.9614, -4.0765, 5.6744> <-10.6020, -4.0765, 5.6744> <-10.6213, -4.0958, 5.6744>
		<-9.9408, -4.0946, 6.0073> <-9.9601, -4.0753, 6.0073> <-10.6032, -4.0753, 6.0073> <-10.6225, -4.0946, 6.0073>
		<-9.9461, -4.0998, 6.4517> <-9.9659, -4.0800, 6.4517> <-10.5974, -4.0800, 6.4517> <-10.6172, -4.0998, 6.4517>
		<-9.9328, -4.0866, 6.7841> <-9.9526, -4.0667, 6.7841> <-10.6107, -4.0667, 6.7841> <-10.6305, -4.0866, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -4.7843, 6.7841> <-10.6325, -4.7863, 6.8341> <-10.6449, -4.7987, 6.9079> <-10.6718, -4.8255, 6.9405>
		<-10.6503, -4.7645, 6.7841> <-10.6523, -4.7664, 6.8341> <-10.6671, -4.7765, 6.9079> <-10.6940, -4.8034, 6.9405>
		<-10.6503, -4.1064, 6.7841> <-10.6523, -4.1044, 6.8341> <-10.6671, -4.0943, 6.9079> <-10.6940, -4.0674, 6.9405>
		<-10.6305, -4.0866, 6.7841> <-10.6325, -4.0846, 6.8341> <-10.6449, -4.0722, 6.9079> <-10.6718, -4.0453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6305, -4.7843, 6.7841> <-10.6107, -4.8041, 6.7841> <-9.9526, -4.8041, 6.7841> <-9.9328, -4.7843, 6.7841>
		<-10.6325, -4.7863, 6.8341> <-10.6127, -4.8061, 6.8341> <-9.9506, -4.8061, 6.8341> <-9.9308, -4.7863, 6.8341>
		<-10.6449, -4.7987, 6.9079> <-10.6228, -4.8208, 6.9079> <-9.9406, -4.8208, 6.9079> <-9.9184, -4.7987, 6.9079>
		<-10.6718, -4.8255, 6.9405> <-10.6496, -4.8477, 6.9405> <-9.9137, -4.8477, 6.9405> <-9.8915, -4.8255, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, -4.7843, 6.7841> <-9.9130, -4.7645, 6.7841> <-9.9130, -4.1064, 6.7841> <-9.9328, -4.0866, 6.7841>
		<-9.9308, -4.7863, 6.8341> <-9.9110, -4.7664, 6.8341> <-9.9110, -4.1044, 6.8341> <-9.9308, -4.0846, 6.8341>
		<-9.9184, -4.7987, 6.9079> <-9.8962, -4.7765, 6.9079> <-9.8962, -4.0943, 6.9079> <-9.9184, -4.0722, 6.9079>
		<-9.8915, -4.8255, 6.9405> <-9.8694, -4.8034, 6.9405> <-9.8694, -4.0674, 6.9405> <-9.8915, -4.0453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.9328, -4.0866, 6.7841> <-9.9526, -4.0667, 6.7841> <-10.6107, -4.0667, 6.7841> <-10.6305, -4.0866, 6.7841>
		<-9.9308, -4.0846, 6.8341> <-9.9506, -4.0648, 6.8341> <-10.6127, -4.0648, 6.8341> <-10.6325, -4.0846, 6.8341>
		<-9.9184, -4.0722, 6.9079> <-9.9406, -4.0500, 6.9079> <-10.6228, -4.0500, 6.9079> <-10.6449, -4.0722, 6.9079>
		<-9.8915, -4.0453, 6.9405> <-9.9137, -4.0231, 6.9405> <-10.6496, -4.0231, 6.9405> <-10.6718, -4.0453, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -4.8255, 6.9405> <-10.7339, -4.8877, 7.0160> <-10.8620, -5.0158, 7.0331> <-10.9114, -5.0652, 7.1255>
		<-10.6940, -4.8034, 6.9405> <-10.7561, -4.8655, 7.0160> <-10.8978, -4.9800, 7.0331> <-10.9472, -5.0294, 7.1255>
		<-10.6940, -4.0674, 6.9405> <-10.7561, -4.0053, 7.0160> <-10.8978, -3.8908, 7.0331> <-10.9472, -3.8414, 7.1255>
		<-10.6718, -4.0453, 6.9405> <-10.7339, -3.9832, 7.0160> <-10.8620, -3.8551, 7.0331> <-10.9114, -3.8056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.6718, -4.8255, 6.9405> <-10.6496, -4.8477, 6.9405> <-9.9137, -4.8477, 6.9405> <-9.8915, -4.8255, 6.9405>
		<-10.7339, -4.8877, 7.0160> <-10.7117, -4.9098, 7.0160> <-9.8516, -4.9098, 7.0160> <-9.8294, -4.8877, 7.0160>
		<-10.8620, -5.0158, 7.0331> <-10.8262, -5.0515, 7.0331> <-9.7371, -5.0515, 7.0331> <-9.7013, -5.0158, 7.0331>
		<-10.9114, -5.0652, 7.1255> <-10.8757, -5.1010, 7.1255> <-9.6877, -5.1010, 7.1255> <-9.6519, -5.0652, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, -4.8255, 6.9405> <-9.8694, -4.8034, 6.9405> <-9.8694, -4.0674, 6.9405> <-9.8915, -4.0453, 6.9405>
		<-9.8294, -4.8877, 7.0160> <-9.8073, -4.8655, 7.0160> <-9.8073, -4.0053, 7.0160> <-9.8294, -3.9832, 7.0160>
		<-9.7013, -5.0158, 7.0331> <-9.6655, -4.9800, 7.0331> <-9.6655, -3.8908, 7.0331> <-9.7013, -3.8551, 7.0331>
		<-9.6519, -5.0652, 7.1255> <-9.6161, -5.0294, 7.1255> <-9.6161, -3.8414, 7.1255> <-9.6519, -3.8056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.8915, -4.0453, 6.9405> <-9.9137, -4.0231, 6.9405> <-10.6496, -4.0231, 6.9405> <-10.6718, -4.0453, 6.9405>
		<-9.8294, -3.9832, 7.0160> <-9.8516, -3.9610, 7.0160> <-10.7117, -3.9610, 7.0160> <-10.7339, -3.9832, 7.0160>
		<-9.7013, -3.8551, 7.0331> <-9.7371, -3.8193, 7.0331> <-10.8262, -3.8193, 7.0331> <-10.8620, -3.8551, 7.0331>
		<-9.6519, -3.8056, 7.1255> <-9.6877, -3.7699, 7.1255> <-10.8757, -3.7699, 7.1255> <-10.9114, -3.8056, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -5.0652, 7.1255> <-10.9319, -5.0857, 7.1638> <-10.8316, -4.9854, 7.1912> <-10.8316, -4.9854, 7.2393>
		<-10.9472, -5.0294, 7.1255> <-10.9677, -5.0499, 7.1638> <-10.8629, -4.9541, 7.1912> <-10.8629, -4.9541, 7.2393>
		<-10.9472, -3.8414, 7.1255> <-10.9677, -3.8209, 7.1638> <-10.8629, -3.9167, 7.1912> <-10.8629, -3.9167, 7.2393>
		<-10.9114, -3.8056, 7.1255> <-10.9319, -3.7851, 7.1638> <-10.8316, -3.8854, 7.1912> <-10.8316, -3.8854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -5.0652, 7.1255> <-10.8757, -5.1010, 7.1255> <-9.6877, -5.1010, 7.1255> <-9.6519, -5.0652, 7.1255>
		<-10.9319, -5.0857, 7.1638> <-10.8962, -5.1215, 7.1638> <-9.6671, -5.1215, 7.1638> <-9.6314, -5.0857, 7.1638>
		<-10.8316, -4.9854, 7.1912> <-10.8004, -5.0166, 7.1912> <-9.7629, -5.0166, 7.1912> <-9.7317, -4.9854, 7.1912>
		<-10.8316, -4.9854, 7.2393> <-10.8004, -5.0166, 7.2393> <-9.7629, -5.0166, 7.2393> <-9.7317, -4.9854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -5.0652, 7.1255> <-9.6161, -5.0294, 7.1255> <-9.6161, -3.8414, 7.1255> <-9.6519, -3.8056, 7.1255>
		<-9.6314, -5.0857, 7.1638> <-9.5956, -5.0499, 7.1638> <-9.5956, -3.8209, 7.1638> <-9.6314, -3.7851, 7.1638>
		<-9.7317, -4.9854, 7.1912> <-9.7005, -4.9541, 7.1912> <-9.7005, -3.9167, 7.1912> <-9.7317, -3.8854, 7.1912>
		<-9.7317, -4.9854, 7.2393> <-9.7005, -4.9541, 7.2393> <-9.7005, -3.9167, 7.2393> <-9.7317, -3.8854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -3.8056, 7.1255> <-9.6877, -3.7699, 7.1255> <-10.8757, -3.7699, 7.1255> <-10.9114, -3.8056, 7.1255>
		<-9.6314, -3.7851, 7.1638> <-9.6671, -3.7494, 7.1638> <-10.8962, -3.7494, 7.1638> <-10.9319, -3.7851, 7.1638>
		<-9.7317, -3.8854, 7.1912> <-9.7629, -3.8542, 7.1912> <-10.8004, -3.8542, 7.1912> <-10.8316, -3.8854, 7.1912>
		<-9.7317, -3.8854, 7.2393> <-9.7629, -3.8542, 7.2393> <-10.8004, -3.8542, 7.2393> <-10.8316, -3.8854, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -4.9854, 7.2393> <-10.8316, -4.9854, 7.2905> <-10.9054, -5.0592, 7.3169> <-10.9114, -5.0652, 7.3673>
		<-10.8629, -4.9541, 7.2393> <-10.8629, -4.9541, 7.2905> <-10.9412, -5.0234, 7.3169> <-10.9472, -5.0294, 7.3673>
		<-10.8629, -3.9167, 7.2393> <-10.8629, -3.9167, 7.2905> <-10.9412, -3.8474, 7.3169> <-10.9472, -3.8414, 7.3673>
		<-10.8316, -3.8854, 7.2393> <-10.8316, -3.8854, 7.2905> <-10.9054, -3.8117, 7.3169> <-10.9114, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.8316, -4.9854, 7.2393> <-10.8004, -5.0166, 7.2393> <-9.7629, -5.0166, 7.2393> <-9.7317, -4.9854, 7.2393>
		<-10.8316, -4.9854, 7.2905> <-10.8004, -5.0166, 7.2905> <-9.7629, -5.0166, 7.2905> <-9.7317, -4.9854, 7.2905>
		<-10.9054, -5.0592, 7.3169> <-10.8696, -5.0949, 7.3169> <-9.6937, -5.0949, 7.3169> <-9.6579, -5.0592, 7.3169>
		<-10.9114, -5.0652, 7.3673> <-10.8757, -5.1010, 7.3673> <-9.6877, -5.1010, 7.3673> <-9.6519, -5.0652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, -4.9854, 7.2393> <-9.7005, -4.9541, 7.2393> <-9.7005, -3.9167, 7.2393> <-9.7317, -3.8854, 7.2393>
		<-9.7317, -4.9854, 7.2905> <-9.7005, -4.9541, 7.2905> <-9.7005, -3.9167, 7.2905> <-9.7317, -3.8854, 7.2905>
		<-9.6579, -5.0592, 7.3169> <-9.6222, -5.0234, 7.3169> <-9.6222, -3.8474, 7.3169> <-9.6579, -3.8117, 7.3169>
		<-9.6519, -5.0652, 7.3673> <-9.6161, -5.0294, 7.3673> <-9.6161, -3.8414, 7.3673> <-9.6519, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.7317, -3.8854, 7.2393> <-9.7629, -3.8542, 7.2393> <-10.8004, -3.8542, 7.2393> <-10.8316, -3.8854, 7.2393>
		<-9.7317, -3.8854, 7.2905> <-9.7629, -3.8542, 7.2905> <-10.8004, -3.8542, 7.2905> <-10.8316, -3.8854, 7.2905>
		<-9.6579, -3.8117, 7.3169> <-9.6937, -3.7759, 7.3169> <-10.8696, -3.7759, 7.3169> <-10.9054, -3.8117, 7.3169>
		<-9.6519, -3.8056, 7.3673> <-9.6877, -3.7699, 7.3673> <-10.8757, -3.7699, 7.3673> <-10.9114, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -5.0652, 7.9080> <-10.9472, -5.0294, 7.9080> <-10.9472, -3.8414, 7.9080> <-10.9114, -3.8056, 7.9080>
		<-10.9114, -5.0652, 7.7458> <-10.9472, -5.0294, 7.7458> <-10.9472, -3.8414, 7.7458> <-10.9114, -3.8056, 7.7458>
		<-10.9305, -5.0843, 7.5273> <-10.9663, -5.0485, 7.5273> <-10.9663, -3.8223, 7.5273> <-10.9305, -3.7866, 7.5273>
		<-10.9114, -5.0652, 7.3673> <-10.9472, -5.0294, 7.3673> <-10.9472, -3.8414, 7.3673> <-10.9114, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-10.9114, -5.0652, 7.9080> <-10.9114, -5.0652, 7.7458> <-10.9305, -5.0843, 7.5273> <-10.9114, -5.0652, 7.3673>
		<-10.8757, -5.1010, 7.9080> <-10.8757, -5.1010, 7.7458> <-10.8947, -5.1200, 7.5273> <-10.8757, -5.1010, 7.3673>
		<-9.6877, -5.1010, 7.9080> <-9.6877, -5.1010, 7.7458> <-9.6686, -5.1200, 7.5273> <-9.6877, -5.1010, 7.3673>
		<-9.6519, -5.0652, 7.9080> <-9.6519, -5.0652, 7.7458> <-9.6328, -5.0843, 7.5273> <-9.6519, -5.0652, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -5.0652, 7.9080> <-9.6519, -5.0652, 7.7458> <-9.6328, -5.0843, 7.5273> <-9.6519, -5.0652, 7.3673>
		<-9.6161, -5.0294, 7.9080> <-9.6161, -5.0294, 7.7458> <-9.5970, -5.0485, 7.5273> <-9.6161, -5.0294, 7.3673>
		<-9.6161, -3.8414, 7.9080> <-9.6161, -3.8414, 7.7458> <-9.5970, -3.8223, 7.5273> <-9.6161, -3.8414, 7.3673>
		<-9.6519, -3.8056, 7.9080> <-9.6519, -3.8056, 7.7458> <-9.6328, -3.7866, 7.5273> <-9.6519, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.6519, -3.8056, 7.9080> <-9.6519, -3.8056, 7.7458> <-9.6328, -3.7866, 7.5273> <-9.6519, -3.8056, 7.3673>
		<-9.6877, -3.7699, 7.9080> <-9.6877, -3.7699, 7.7458> <-9.6686, -3.7508, 7.5273> <-9.6877, -3.7699, 7.3673>
		<-10.8757, -3.7699, 7.9080> <-10.8757, -3.7699, 7.7458> <-10.8947, -3.7508, 7.5273> <-10.8757, -3.7699, 7.3673>
		<-10.9114, -3.8056, 7.9080> <-10.9114, -3.8056, 7.7458> <-10.9305, -3.7866, 7.5273> <-10.9114, -3.8056, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -5.3126, 0.7771> <-11.2087, -5.2628, 0.7771> <-11.2087, -3.6080, 0.7771> <-11.1589, -3.5582, 0.7771>
		<-11.1796, -5.3334, 0.6520> <-11.2294, -5.2836, 0.6520> <-11.2294, -3.5873, 0.6520> <-11.1796, -3.5374, 0.6520>
		<-11.1589, -5.3126, 0.4772> <-11.2087, -5.2628, 0.4772> <-11.2087, -3.6080, 0.4772> <-11.1589, -3.5582, 0.4772>
		<-11.1589, -5.3126, 0.3486> <-11.2087, -5.2628, 0.3486> <-11.2087, -3.6080, 0.3486> <-11.1589, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -5.3126, 0.7771> <-11.1796, -5.3334, 0.6520> <-11.1589, -5.3126, 0.4772> <-11.1589, -5.3126, 0.3486>
		<-11.1090, -5.3624, 0.7771> <-11.1298, -5.3832, 0.6520> <-11.1090, -5.3624, 0.4772> <-11.1090, -5.3624, 0.3486>
		<-9.4543, -5.3624, 0.7771> <-9.4335, -5.3832, 0.6520> <-9.4543, -5.3624, 0.4772> <-9.4543, -5.3624, 0.3486>
		<-9.4045, -5.3126, 0.7771> <-9.3837, -5.3334, 0.6520> <-9.4045, -5.3126, 0.4772> <-9.4045, -5.3126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -5.3126, 0.7771> <-9.3837, -5.3334, 0.6520> <-9.4045, -5.3126, 0.4772> <-9.4045, -5.3126, 0.3486>
		<-9.3546, -5.2628, 0.7771> <-9.3339, -5.2836, 0.6520> <-9.3546, -5.2628, 0.4772> <-9.3546, -5.2628, 0.3486>
		<-9.3546, -3.6080, 0.7771> <-9.3339, -3.5873, 0.6520> <-9.3546, -3.6080, 0.4772> <-9.3546, -3.6080, 0.3486>
		<-9.4045, -3.5582, 0.7771> <-9.3837, -3.5374, 0.6520> <-9.4045, -3.5582, 0.4772> <-9.4045, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -3.5582, 0.7771> <-9.3837, -3.5374, 0.6520> <-9.4045, -3.5582, 0.4772> <-9.4045, -3.5582, 0.3486>
		<-9.4543, -3.5084, 0.7771> <-9.4335, -3.4876, 0.6520> <-9.4543, -3.5084, 0.4772> <-9.4543, -3.5084, 0.3486>
		<-11.1090, -3.5084, 0.7771> <-11.1298, -3.4876, 0.6520> <-11.1090, -3.5084, 0.4772> <-11.1090, -3.5084, 0.3486>
		<-11.1589, -3.5582, 0.7771> <-11.1796, -3.5374, 0.6520> <-11.1589, -3.5582, 0.4772> <-11.1589, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -5.3126, -0.0618> <-11.1589, -5.3126, 0.0613> <-11.1589, -5.3126, 0.2255> <-11.1589, -5.3126, 0.3486>
		<-11.2087, -5.2628, -0.0618> <-11.2087, -5.2628, 0.0613> <-11.2087, -5.2628, 0.2255> <-11.2087, -5.2628, 0.3486>
		<-11.2087, -3.6080, -0.0618> <-11.2087, -3.6080, 0.0613> <-11.2087, -3.6080, 0.2255> <-11.2087, -3.6080, 0.3486>
		<-11.1589, -3.5582, -0.0618> <-11.1589, -3.5582, 0.0613> <-11.1589, -3.5582, 0.2255> <-11.1589, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-11.1589, -5.3126, -0.0618> <-11.1090, -5.3624, -0.0618> <-9.4543, -5.3624, -0.0618> <-9.4045, -5.3126, -0.0618>
		<-11.1589, -5.3126, 0.0613> <-11.1090, -5.3624, 0.0613> <-9.4543, -5.3624, 0.0613> <-9.4045, -5.3126, 0.0613>
		<-11.1589, -5.3126, 0.2255> <-11.1090, -5.3624, 0.2255> <-9.4543, -5.3624, 0.2255> <-9.4045, -5.3126, 0.2255>
		<-11.1589, -5.3126, 0.3486> <-11.1090, -5.3624, 0.3486> <-9.4543, -5.3624, 0.3486> <-9.4045, -5.3126, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -5.3126, -0.0618> <-9.3546, -5.2628, -0.0618> <-9.3546, -3.6080, -0.0618> <-9.4045, -3.5582, -0.0618>
		<-9.4045, -5.3126, 0.0613> <-9.3546, -5.2628, 0.0613> <-9.3546, -3.6080, 0.0613> <-9.4045, -3.5582, 0.0613>
		<-9.4045, -5.3126, 0.2255> <-9.3546, -5.2628, 0.2255> <-9.3546, -3.6080, 0.2255> <-9.4045, -3.5582, 0.2255>
		<-9.4045, -5.3126, 0.3486> <-9.3546, -5.2628, 0.3486> <-9.3546, -3.6080, 0.3486> <-9.4045, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-9.4045, -3.5582, -0.0618> <-9.4543, -3.5084, -0.0618> <-11.1090, -3.5084, -0.0618> <-11.1589, -3.5582, -0.0618>
		<-9.4045, -3.5582, 0.0613> <-9.4543, -3.5084, 0.0613> <-11.1090, -3.5084, 0.0613> <-11.1589, -3.5582, 0.0613>
		<-9.4045, -3.5582, 0.2255> <-9.4543, -3.5084, 0.2255> <-11.1090, -3.5084, 0.2255> <-11.1589, -3.5582, 0.2255>
		<-9.4045, -3.5582, 0.3486> <-9.4543, -3.5084, 0.3486> <-11.1090, -3.5084, 0.3486> <-11.1589, -3.5582, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 0.9062> <-8.9109, 19.0245, 0.9062> <-8.9109, 20.5047, 0.9062> <-8.8664, 20.5493, 0.9062>
		<-8.8712, 18.9751, 0.8515> <-8.9157, 19.0196, 0.8515> <-8.9157, 20.5095, 0.8515> <-8.8712, 20.5541, 0.8515>
		<-8.9500, 18.8963, 0.8308> <-8.9998, 18.9461, 0.8308> <-8.9998, 20.5831, 0.8308> <-8.9500, 20.6329, 0.8308>
		<-8.9589, 18.8874, 0.7771> <-9.0087, 18.9372, 0.7771> <-9.0087, 20.5920, 0.7771> <-8.9589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 0.9062> <-8.8620, 18.9842, 0.9557> <-8.9560, 18.8903, 0.9996> <-8.9357, 18.9105, 1.0404>
		<-8.9109, 19.0245, 0.9062> <-8.9066, 19.0288, 0.9557> <-9.0045, 18.9388, 0.9996> <-8.9843, 18.9590, 1.0404>
		<-8.9109, 20.5047, 0.9062> <-8.9066, 20.5004, 0.9557> <-9.0045, 20.5904, 0.9996> <-8.9843, 20.5702, 1.0404>
		<-8.8664, 20.5493, 0.9062> <-8.8620, 20.5449, 0.9557> <-8.9560, 20.6389, 0.9996> <-8.9357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 0.9062> <-8.8712, 18.9751, 0.8515> <-8.9500, 18.8963, 0.8308> <-8.9589, 18.8874, 0.7771>
		<-8.8218, 18.9353, 0.9062> <-8.8266, 18.9305, 0.8515> <-8.9001, 18.8465, 0.8308> <-8.9090, 18.8376, 0.7771>
		<-7.3415, 18.9353, 0.9062> <-7.3367, 18.9305, 0.8515> <-7.2632, 18.8465, 0.8308> <-7.2543, 18.8376, 0.7771>
		<-7.2970, 18.9799, 0.9062> <-7.2922, 18.9751, 0.8515> <-7.2134, 18.8963, 0.8308> <-7.2045, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 0.9062> <-8.8218, 18.9353, 0.9062> <-7.3415, 18.9353, 0.9062> <-7.2970, 18.9799, 0.9062>
		<-8.8620, 18.9842, 0.9557> <-8.8175, 18.9397, 0.9557> <-7.3459, 18.9397, 0.9557> <-7.3013, 18.9842, 0.9557>
		<-8.9560, 18.8903, 0.9996> <-8.9075, 18.8418, 0.9996> <-7.2559, 18.8418, 0.9996> <-7.2073, 18.8903, 0.9996>
		<-8.9357, 18.9105, 1.0404> <-8.8872, 18.8620, 1.0404> <-7.2761, 18.8620, 1.0404> <-7.2276, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 18.9799, 0.9062> <-7.2922, 18.9751, 0.8515> <-7.2134, 18.8963, 0.8308> <-7.2045, 18.8874, 0.7771>
		<-7.2524, 19.0245, 0.9062> <-7.2476, 19.0196, 0.8515> <-7.1635, 18.9461, 0.8308> <-7.1546, 18.9372, 0.7771>
		<-7.2524, 20.5047, 0.9062> <-7.2476, 20.5095, 0.8515> <-7.1635, 20.5831, 0.8308> <-7.1546, 20.5920, 0.7771>
		<-7.2970, 20.5493, 0.9062> <-7.2922, 20.5541, 0.8515> <-7.2134, 20.6329, 0.8308> <-7.2045, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 18.9799, 0.9062> <-7.2524, 19.0245, 0.9062> <-7.2524, 20.5047, 0.9062> <-7.2970, 20.5493, 0.9062>
		<-7.3013, 18.9842, 0.9557> <-7.2567, 19.0288, 0.9557> <-7.2567, 20.5004, 0.9557> <-7.3013, 20.5449, 0.9557>
		<-7.2073, 18.8903, 0.9996> <-7.1588, 18.9388, 0.9996> <-7.1588, 20.5904, 0.9996> <-7.2073, 20.6389, 0.9996>
		<-7.2276, 18.9105, 1.0404> <-7.1791, 18.9590, 1.0404> <-7.1791, 20.5702, 1.0404> <-7.2276, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 20.5493, 0.9062> <-7.2922, 20.5541, 0.8515> <-7.2134, 20.6329, 0.8308> <-7.2045, 20.6418, 0.7771>
		<-7.3415, 20.5939, 0.9062> <-7.3367, 20.5987, 0.8515> <-7.2632, 20.6827, 0.8308> <-7.2543, 20.6916, 0.7771>
		<-8.8218, 20.5939, 0.9062> <-8.8266, 20.5987, 0.8515> <-8.9001, 20.6827, 0.8308> <-8.9090, 20.6916, 0.7771>
		<-8.8664, 20.5493, 0.9062> <-8.8712, 20.5541, 0.8515> <-8.9500, 20.6329, 0.8308> <-8.9589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 20.5493, 0.9062> <-7.3415, 20.5939, 0.9062> <-8.8218, 20.5939, 0.9062> <-8.8664, 20.5493, 0.9062>
		<-7.3013, 20.5449, 0.9557> <-7.3459, 20.5895, 0.9557> <-8.8175, 20.5895, 0.9557> <-8.8620, 20.5449, 0.9557>
		<-7.2073, 20.6389, 0.9996> <-7.2559, 20.6874, 0.9996> <-8.9075, 20.6874, 0.9996> <-8.9560, 20.6389, 0.9996>
		<-7.2276, 20.6187, 1.0404> <-7.2761, 20.6672, 1.0404> <-8.8872, 20.6672, 1.0404> <-8.9357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9357, 18.9105, 1.0404> <-8.8677, 18.9786, 1.1777> <-8.6982, 19.1481, 1.2552> <-8.6269, 19.2193, 1.3892>
		<-8.9843, 18.9590, 1.0404> <-8.9162, 19.0271, 1.1777> <-8.7291, 19.1790, 1.2552> <-8.6579, 19.2503, 1.3892>
		<-8.9843, 20.5702, 1.0404> <-8.9162, 20.5021, 1.1777> <-8.7291, 20.3501, 1.2552> <-8.6579, 20.2789, 1.3892>
		<-8.9357, 20.6187, 1.0404> <-8.8677, 20.5506, 1.1777> <-8.6982, 20.3811, 1.2552> <-8.6269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9357, 18.9105, 1.0404> <-8.8872, 18.8620, 1.0404> <-7.2761, 18.8620, 1.0404> <-7.2276, 18.9105, 1.0404>
		<-8.8677, 18.9786, 1.1777> <-8.8192, 18.9301, 1.1777> <-7.3442, 18.9301, 1.1777> <-7.2957, 18.9786, 1.1777>
		<-8.6982, 19.1481, 1.2552> <-8.6672, 19.1171, 1.2552> <-7.4961, 19.1171, 1.2552> <-7.4652, 19.1481, 1.2552>
		<-8.6269, 19.2193, 1.3892> <-8.5959, 19.1884, 1.3892> <-7.5674, 19.1884, 1.3892> <-7.5364, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2276, 18.9105, 1.0404> <-7.1791, 18.9590, 1.0404> <-7.1791, 20.5702, 1.0404> <-7.2276, 20.6187, 1.0404>
		<-7.2957, 18.9786, 1.1777> <-7.2471, 19.0271, 1.1777> <-7.2471, 20.5021, 1.1777> <-7.2957, 20.5506, 1.1777>
		<-7.4652, 19.1481, 1.2552> <-7.4342, 19.1790, 1.2552> <-7.4342, 20.3501, 1.2552> <-7.4652, 20.3811, 1.2552>
		<-7.5364, 19.2193, 1.3892> <-7.5054, 19.2503, 1.3892> <-7.5054, 20.2789, 1.3892> <-7.5364, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2276, 20.6187, 1.0404> <-7.2761, 20.6672, 1.0404> <-8.8872, 20.6672, 1.0404> <-8.9357, 20.6187, 1.0404>
		<-7.2957, 20.5506, 1.1777> <-7.3442, 20.5991, 1.1777> <-8.8192, 20.5991, 1.1777> <-8.8677, 20.5506, 1.1777>
		<-7.4652, 20.3811, 1.2552> <-7.4961, 20.4121, 1.2552> <-8.6672, 20.4121, 1.2552> <-8.6982, 20.3811, 1.2552>
		<-7.5364, 20.3098, 1.3892> <-7.5674, 20.3408, 1.3892> <-8.5959, 20.3408, 1.3892> <-8.6269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6269, 19.2193, 1.3892> <-8.6079, 19.2383, 1.4249> <-8.6837, 19.1626, 1.4698> <-8.6837, 19.1626, 1.5144>
		<-8.6579, 19.2503, 1.3892> <-8.6389, 19.2693, 1.4249> <-8.7179, 19.1968, 1.4698> <-8.7179, 19.1968, 1.5144>
		<-8.6579, 20.2789, 1.3892> <-8.6389, 20.2599, 1.4249> <-8.7179, 20.3324, 1.4698> <-8.7179, 20.3324, 1.5144>
		<-8.6269, 20.3098, 1.3892> <-8.6079, 20.2909, 1.4249> <-8.6837, 20.3666, 1.4698> <-8.6837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6269, 19.2193, 1.3892> <-8.5959, 19.1884, 1.3892> <-7.5674, 19.1884, 1.3892> <-7.5364, 19.2193, 1.3892>
		<-8.6079, 19.2383, 1.4249> <-8.5770, 19.2073, 1.4249> <-7.5863, 19.2073, 1.4249> <-7.5554, 19.2383, 1.4249>
		<-8.6837, 19.1626, 1.4698> <-8.6495, 19.1284, 1.4698> <-7.5138, 19.1284, 1.4698> <-7.4796, 19.1626, 1.4698>
		<-8.6837, 19.1626, 1.5144> <-8.6495, 19.1284, 1.5144> <-7.5138, 19.1284, 1.5144> <-7.4796, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5364, 19.2193, 1.3892> <-7.5054, 19.2503, 1.3892> <-7.5054, 20.2789, 1.3892> <-7.5364, 20.3098, 1.3892>
		<-7.5554, 19.2383, 1.4249> <-7.5244, 19.2693, 1.4249> <-7.5244, 20.2599, 1.4249> <-7.5554, 20.2909, 1.4249>
		<-7.4796, 19.1626, 1.4698> <-7.4455, 19.1968, 1.4698> <-7.4455, 20.3324, 1.4698> <-7.4796, 20.3666, 1.4698>
		<-7.4796, 19.1626, 1.5144> <-7.4455, 19.1968, 1.5144> <-7.4455, 20.3324, 1.5144> <-7.4796, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5364, 20.3098, 1.3892> <-7.5674, 20.3408, 1.3892> <-8.5959, 20.3408, 1.3892> <-8.6269, 20.3098, 1.3892>
		<-7.5554, 20.2909, 1.4249> <-7.5863, 20.3218, 1.4249> <-8.5770, 20.3218, 1.4249> <-8.6079, 20.2909, 1.4249>
		<-7.4796, 20.3666, 1.4698> <-7.5138, 20.4008, 1.4698> <-8.6495, 20.4008, 1.4698> <-8.6837, 20.3666, 1.4698>
		<-7.4796, 20.3666, 1.5144> <-7.5138, 20.4008, 1.5144> <-8.6495, 20.4008, 1.5144> <-8.6837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6837, 19.1626, 1.5144> <-8.6837, 19.1626, 1.5613> <-8.6121, 19.2341, 1.6066> <-8.6269, 19.2193, 1.6486>
		<-8.7179, 19.1968, 1.5144> <-8.7179, 19.1968, 1.5613> <-8.6431, 19.2651, 1.6066> <-8.6579, 19.2503, 1.6486>
		<-8.7179, 20.3324, 1.5144> <-8.7179, 20.3324, 1.5613> <-8.6431, 20.2641, 1.6066> <-8.6579, 20.2789, 1.6486>
		<-8.6837, 20.3666, 1.5144> <-8.6837, 20.3666, 1.5613> <-8.6121, 20.2950, 1.6066> <-8.6269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6837, 19.1626, 1.5144> <-8.6495, 19.1284, 1.5144> <-7.5138, 19.1284, 1.5144> <-7.4796, 19.1626, 1.5144>
		<-8.6837, 19.1626, 1.5613> <-8.6495, 19.1284, 1.5613> <-7.5138, 19.1284, 1.5613> <-7.4796, 19.1626, 1.5613>
		<-8.6121, 19.2341, 1.6066> <-8.5812, 19.2032, 1.6066> <-7.5822, 19.2032, 1.6066> <-7.5512, 19.2341, 1.6066>
		<-8.6269, 19.2193, 1.6486> <-8.5959, 19.1884, 1.6486> <-7.5674, 19.1884, 1.6486> <-7.5364, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4796, 19.1626, 1.5144> <-7.4455, 19.1968, 1.5144> <-7.4455, 20.3324, 1.5144> <-7.4796, 20.3666, 1.5144>
		<-7.4796, 19.1626, 1.5613> <-7.4455, 19.1968, 1.5613> <-7.4455, 20.3324, 1.5613> <-7.4796, 20.3666, 1.5613>
		<-7.5512, 19.2341, 1.6066> <-7.5202, 19.2651, 1.6066> <-7.5202, 20.2641, 1.6066> <-7.5512, 20.2950, 1.6066>
		<-7.5364, 19.2193, 1.6486> <-7.5054, 19.2503, 1.6486> <-7.5054, 20.2789, 1.6486> <-7.5364, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4796, 20.3666, 1.5144> <-7.5138, 20.4008, 1.5144> <-8.6495, 20.4008, 1.5144> <-8.6837, 20.3666, 1.5144>
		<-7.4796, 20.3666, 1.5613> <-7.5138, 20.4008, 1.5613> <-8.6495, 20.4008, 1.5613> <-8.6837, 20.3666, 1.5613>
		<-7.5512, 20.2950, 1.6066> <-7.5822, 20.3260, 1.6066> <-8.5812, 20.3260, 1.6066> <-8.6121, 20.2950, 1.6066>
		<-7.5364, 20.3098, 1.6486> <-7.5674, 20.3408, 1.6486> <-8.5959, 20.3408, 1.6486> <-8.6269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6269, 19.2193, 1.6486> <-8.6754, 19.1709, 1.7862> <-8.8172, 19.0290, 1.8960> <-8.8664, 18.9799, 2.0332>
		<-8.6579, 19.2503, 1.6486> <-8.7063, 19.2018, 1.7862> <-8.8618, 19.0736, 1.8960> <-8.9109, 19.0245, 2.0332>
		<-8.6579, 20.2789, 1.6486> <-8.7063, 20.3273, 1.7862> <-8.8618, 20.4556, 1.8960> <-8.9109, 20.5047, 2.0332>
		<-8.6269, 20.3098, 1.6486> <-8.6754, 20.3583, 1.7862> <-8.8172, 20.5002, 1.8960> <-8.8664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6269, 19.2193, 1.6486> <-8.5959, 19.1884, 1.6486> <-7.5674, 19.1884, 1.6486> <-7.5364, 19.2193, 1.6486>
		<-8.6754, 19.1709, 1.7862> <-8.6444, 19.1399, 1.7862> <-7.5189, 19.1399, 1.7862> <-7.4880, 19.1709, 1.7862>
		<-8.8172, 19.0290, 1.8960> <-8.7727, 18.9844, 1.8960> <-7.3907, 18.9844, 1.8960> <-7.3461, 19.0290, 1.8960>
		<-8.8664, 18.9799, 2.0332> <-8.8218, 18.9353, 2.0332> <-7.3415, 18.9353, 2.0332> <-7.2970, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5364, 19.2193, 1.6486> <-7.5054, 19.2503, 1.6486> <-7.5054, 20.2789, 1.6486> <-7.5364, 20.3098, 1.6486>
		<-7.4880, 19.1709, 1.7862> <-7.4570, 19.2018, 1.7862> <-7.4570, 20.3273, 1.7862> <-7.4880, 20.3583, 1.7862>
		<-7.3461, 19.0290, 1.8960> <-7.3015, 19.0736, 1.8960> <-7.3015, 20.4556, 1.8960> <-7.3461, 20.5002, 1.8960>
		<-7.2970, 18.9799, 2.0332> <-7.2524, 19.0245, 2.0332> <-7.2524, 20.5047, 2.0332> <-7.2970, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5364, 20.3098, 1.6486> <-7.5674, 20.3408, 1.6486> <-8.5959, 20.3408, 1.6486> <-8.6269, 20.3098, 1.6486>
		<-7.4880, 20.3583, 1.7862> <-7.5189, 20.3893, 1.7862> <-8.6444, 20.3893, 1.7862> <-8.6754, 20.3583, 1.7862>
		<-7.3461, 20.5002, 1.8960> <-7.3907, 20.5447, 1.8960> <-8.7727, 20.5447, 1.8960> <-8.8172, 20.5002, 1.8960>
		<-7.2970, 20.5493, 2.0332> <-7.3415, 20.5939, 2.0332> <-8.8218, 20.5939, 2.0332> <-8.8664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 2.0332> <-8.8930, 18.9533, 2.1074> <-8.8932, 18.9531, 2.2382> <-8.8641, 18.9822, 2.3104>
		<-8.9109, 19.0245, 2.0332> <-8.9375, 18.9979, 2.1074> <-8.9376, 18.9975, 2.2382> <-8.9085, 19.0266, 2.3104>
		<-8.9109, 20.5047, 2.0332> <-8.9375, 20.5313, 2.1074> <-8.9376, 20.5317, 2.2382> <-8.9085, 20.5025, 2.3104>
		<-8.8664, 20.5493, 2.0332> <-8.8930, 20.5759, 2.1074> <-8.8932, 20.5761, 2.2382> <-8.8641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8664, 18.9799, 2.0332> <-8.8218, 18.9353, 2.0332> <-7.3415, 18.9353, 2.0332> <-7.2970, 18.9799, 2.0332>
		<-8.8930, 18.9533, 2.1074> <-8.8484, 18.9087, 2.1074> <-7.3149, 18.9087, 2.1074> <-7.2704, 18.9533, 2.1074>
		<-8.8932, 18.9531, 2.2382> <-8.8488, 18.9086, 2.2382> <-7.3146, 18.9086, 2.2382> <-7.2701, 18.9531, 2.2382>
		<-8.8641, 18.9822, 2.3104> <-8.8196, 18.9378, 2.3104> <-7.3437, 18.9378, 2.3104> <-7.2993, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 18.9799, 2.0332> <-7.2524, 19.0245, 2.0332> <-7.2524, 20.5047, 2.0332> <-7.2970, 20.5493, 2.0332>
		<-7.2704, 18.9533, 2.1074> <-7.2258, 18.9979, 2.1074> <-7.2258, 20.5313, 2.1074> <-7.2704, 20.5759, 2.1074>
		<-7.2701, 18.9531, 2.2382> <-7.2257, 18.9975, 2.2382> <-7.2257, 20.5317, 2.2382> <-7.2701, 20.5761, 2.2382>
		<-7.2993, 18.9822, 2.3104> <-7.2548, 19.0266, 2.3104> <-7.2548, 20.5025, 2.3104> <-7.2993, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2970, 20.5493, 2.0332> <-7.3415, 20.5939, 2.0332> <-8.8218, 20.5939, 2.0332> <-8.8664, 20.5493, 2.0332>
		<-7.2704, 20.5759, 2.1074> <-7.3149, 20.6204, 2.1074> <-8.8484, 20.6204, 2.1074> <-8.8930, 20.5759, 2.1074>
		<-7.2701, 20.5761, 2.2382> <-7.3146, 20.6206, 2.2382> <-8.8488, 20.6206, 2.2382> <-8.8932, 20.5761, 2.2382>
		<-7.2993, 20.5470, 2.3104> <-7.3437, 20.5914, 2.3104> <-8.8196, 20.5914, 2.3104> <-8.8641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8641, 18.9822, 2.3104> <-8.7801, 19.0661, 2.5186> <-8.5843, 19.2620, 2.7154> <-8.5056, 19.3406, 2.9276>
		<-8.9085, 19.0266, 2.3104> <-8.8246, 19.1106, 2.5186> <-8.6084, 19.2860, 2.7154> <-8.5297, 19.3647, 2.9276>
		<-8.9085, 20.5025, 2.3104> <-8.8246, 20.4186, 2.5186> <-8.6084, 20.2431, 2.7154> <-8.5297, 20.1645, 2.9276>
		<-8.8641, 20.5470, 2.3104> <-8.7801, 20.4630, 2.5186> <-8.5843, 20.2672, 2.7154> <-8.5056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.8641, 18.9822, 2.3104> <-8.8196, 18.9378, 2.3104> <-7.3437, 18.9378, 2.3104> <-7.2993, 18.9822, 2.3104>
		<-8.7801, 19.0661, 2.5186> <-8.7357, 19.0217, 2.5186> <-7.4276, 19.0217, 2.5186> <-7.3832, 19.0661, 2.5186>
		<-8.5843, 19.2620, 2.7154> <-8.5602, 19.2379, 2.7154> <-7.6031, 19.2379, 2.7154> <-7.5790, 19.2620, 2.7154>
		<-8.5056, 19.3406, 2.9276> <-8.4815, 19.3165, 2.9276> <-7.6818, 19.3165, 2.9276> <-7.6577, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2993, 18.9822, 2.3104> <-7.2548, 19.0266, 2.3104> <-7.2548, 20.5025, 2.3104> <-7.2993, 20.5470, 2.3104>
		<-7.3832, 19.0661, 2.5186> <-7.3388, 19.1106, 2.5186> <-7.3388, 20.4186, 2.5186> <-7.3832, 20.4630, 2.5186>
		<-7.5790, 19.2620, 2.7154> <-7.5550, 19.2860, 2.7154> <-7.5550, 20.2431, 2.7154> <-7.5790, 20.2672, 2.7154>
		<-7.6577, 19.3406, 2.9276> <-7.6336, 19.3647, 2.9276> <-7.6336, 20.1645, 2.9276> <-7.6577, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2993, 20.5470, 2.3104> <-7.3437, 20.5914, 2.3104> <-8.8196, 20.5914, 2.3104> <-8.8641, 20.5470, 2.3104>
		<-7.3832, 20.4630, 2.5186> <-7.4276, 20.5075, 2.5186> <-8.7357, 20.5075, 2.5186> <-8.7801, 20.4630, 2.5186>
		<-7.5790, 20.2672, 2.7154> <-7.6031, 20.2913, 2.7154> <-8.5602, 20.2913, 2.7154> <-8.5843, 20.2672, 2.7154>
		<-7.6577, 20.1885, 2.9276> <-7.6818, 20.2126, 2.9276> <-8.4815, 20.2126, 2.9276> <-8.5056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5056, 19.3406, 2.9276> <-8.4887, 19.3576, 2.9732> <-8.5889, 19.2574, 3.0012> <-8.5889, 19.2574, 3.0528>
		<-8.5297, 19.3647, 2.9276> <-8.5128, 19.3816, 2.9732> <-8.6177, 19.2862, 3.0012> <-8.6177, 19.2862, 3.0528>
		<-8.5297, 20.1645, 2.9276> <-8.5128, 20.1475, 2.9732> <-8.6177, 20.2430, 3.0012> <-8.6177, 20.2430, 3.0528>
		<-8.5056, 20.1885, 2.9276> <-8.4887, 20.1716, 2.9732> <-8.5889, 20.2718, 3.0012> <-8.5889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5056, 19.3406, 2.9276> <-8.4815, 19.3165, 2.9276> <-7.6818, 19.3165, 2.9276> <-7.6577, 19.3406, 2.9276>
		<-8.4887, 19.3576, 2.9732> <-8.4646, 19.3335, 2.9732> <-7.6987, 19.3335, 2.9732> <-7.6746, 19.3576, 2.9732>
		<-8.5889, 19.2574, 3.0012> <-8.5601, 19.2286, 3.0012> <-7.6033, 19.2286, 3.0012> <-7.5745, 19.2574, 3.0012>
		<-8.5889, 19.2574, 3.0528> <-8.5601, 19.2286, 3.0528> <-7.6033, 19.2286, 3.0528> <-7.5745, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6577, 19.3406, 2.9276> <-7.6336, 19.3647, 2.9276> <-7.6336, 20.1645, 2.9276> <-7.6577, 20.1885, 2.9276>
		<-7.6746, 19.3576, 2.9732> <-7.6506, 19.3816, 2.9732> <-7.6506, 20.1475, 2.9732> <-7.6746, 20.1716, 2.9732>
		<-7.5745, 19.2574, 3.0012> <-7.5456, 19.2862, 3.0012> <-7.5456, 20.2430, 3.0012> <-7.5745, 20.2718, 3.0012>
		<-7.5745, 19.2574, 3.0528> <-7.5456, 19.2862, 3.0528> <-7.5456, 20.2430, 3.0528> <-7.5745, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6577, 20.1885, 2.9276> <-7.6818, 20.2126, 2.9276> <-8.4815, 20.2126, 2.9276> <-8.5056, 20.1885, 2.9276>
		<-7.6746, 20.1716, 2.9732> <-7.6987, 20.1957, 2.9732> <-8.4646, 20.1957, 2.9732> <-8.4887, 20.1716, 2.9732>
		<-7.5745, 20.2718, 3.0012> <-7.6033, 20.3006, 3.0012> <-8.5601, 20.3006, 3.0012> <-8.5889, 20.2718, 3.0012>
		<-7.5745, 20.2718, 3.0528> <-7.6033, 20.3006, 3.0528> <-8.5601, 20.3006, 3.0528> <-8.5889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5889, 19.2574, 3.0528> <-8.5889, 19.2574, 3.1044> <-8.4862, 19.3600, 3.1344> <-8.5056, 19.3406, 3.1780>
		<-8.6177, 19.2862, 3.0528> <-8.6177, 19.2862, 3.1044> <-8.5103, 19.3841, 3.1344> <-8.5297, 19.3647, 3.1780>
		<-8.6177, 20.2430, 3.0528> <-8.6177, 20.2430, 3.1044> <-8.5103, 20.1451, 3.1344> <-8.5297, 20.1645, 3.1780>
		<-8.5889, 20.2718, 3.0528> <-8.5889, 20.2718, 3.1044> <-8.4862, 20.1691, 3.1344> <-8.5056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5889, 19.2574, 3.0528> <-8.5601, 19.2286, 3.0528> <-7.6033, 19.2286, 3.0528> <-7.5745, 19.2574, 3.0528>
		<-8.5889, 19.2574, 3.1044> <-8.5601, 19.2286, 3.1044> <-7.6033, 19.2286, 3.1044> <-7.5745, 19.2574, 3.1044>
		<-8.4862, 19.3600, 3.1344> <-8.4621, 19.3359, 3.1344> <-7.7012, 19.3359, 3.1344> <-7.6771, 19.3600, 3.1344>
		<-8.5056, 19.3406, 3.1780> <-8.4815, 19.3165, 3.1780> <-7.6818, 19.3165, 3.1780> <-7.6577, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5745, 19.2574, 3.0528> <-7.5456, 19.2862, 3.0528> <-7.5456, 20.2430, 3.0528> <-7.5745, 20.2718, 3.0528>
		<-7.5745, 19.2574, 3.1044> <-7.5456, 19.2862, 3.1044> <-7.5456, 20.2430, 3.1044> <-7.5745, 20.2718, 3.1044>
		<-7.6771, 19.3600, 3.1344> <-7.6530, 19.3841, 3.1344> <-7.6530, 20.1451, 3.1344> <-7.6771, 20.1691, 3.1344>
		<-7.6577, 19.3406, 3.1780> <-7.6336, 19.3647, 3.1780> <-7.6336, 20.1645, 3.1780> <-7.6577, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5745, 20.2718, 3.0528> <-7.6033, 20.3006, 3.0528> <-8.5601, 20.3006, 3.0528> <-8.5889, 20.2718, 3.0528>
		<-7.5745, 20.2718, 3.1044> <-7.6033, 20.3006, 3.1044> <-8.5601, 20.3006, 3.1044> <-8.5889, 20.2718, 3.1044>
		<-7.6771, 20.1691, 3.1344> <-7.7012, 20.1932, 3.1344> <-8.4621, 20.1932, 3.1344> <-8.4862, 20.1691, 3.1344>
		<-7.6577, 20.1885, 3.1780> <-7.6818, 20.2126, 3.1780> <-8.4815, 20.2126, 3.1780> <-8.5056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5056, 19.3406, 3.1780> <-8.5438, 19.3024, 3.2640> <-8.6610, 19.1852, 3.2738> <-8.7161, 19.1302, 3.3390>
		<-8.5297, 19.3647, 3.1780> <-8.5679, 19.3265, 3.2640> <-8.6971, 19.2212, 3.2738> <-8.7521, 19.1662, 3.3390>
		<-8.5297, 20.1645, 3.1780> <-8.5679, 20.2027, 3.2640> <-8.6971, 20.3079, 3.2738> <-8.7521, 20.3629, 3.3390>
		<-8.5056, 20.1885, 3.1780> <-8.5438, 20.2267, 3.2640> <-8.6610, 20.3440, 3.2738> <-8.7161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5056, 19.3406, 3.1780> <-8.4815, 19.3165, 3.1780> <-7.6818, 19.3165, 3.1780> <-7.6577, 19.3406, 3.1780>
		<-8.5438, 19.3024, 3.2640> <-8.5197, 19.2784, 3.2640> <-7.6436, 19.2784, 3.2640> <-7.6195, 19.3024, 3.2640>
		<-8.6610, 19.1852, 3.2738> <-8.6250, 19.1492, 3.2738> <-7.5383, 19.1492, 3.2738> <-7.5023, 19.1852, 3.2738>
		<-8.7161, 19.1302, 3.3390> <-8.6800, 19.0942, 3.3390> <-7.4833, 19.0942, 3.3390> <-7.4473, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6577, 19.3406, 3.1780> <-7.6336, 19.3647, 3.1780> <-7.6336, 20.1645, 3.1780> <-7.6577, 20.1885, 3.1780>
		<-7.6195, 19.3024, 3.2640> <-7.5954, 19.3265, 3.2640> <-7.5954, 20.2027, 3.2640> <-7.6195, 20.2267, 3.2640>
		<-7.5023, 19.1852, 3.2738> <-7.4663, 19.2212, 3.2738> <-7.4663, 20.3079, 3.2738> <-7.5023, 20.3440, 3.2738>
		<-7.4473, 19.1302, 3.3390> <-7.4112, 19.1662, 3.3390> <-7.4112, 20.3629, 3.3390> <-7.4473, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6577, 20.1885, 3.1780> <-7.6818, 20.2126, 3.1780> <-8.4815, 20.2126, 3.1780> <-8.5056, 20.1885, 3.1780>
		<-7.6195, 20.2267, 3.2640> <-7.6436, 20.2508, 3.2640> <-8.5197, 20.2508, 3.2640> <-8.5438, 20.2267, 3.2640>
		<-7.5023, 20.3440, 3.2738> <-7.5383, 20.3800, 3.2738> <-8.6250, 20.3800, 3.2738> <-8.6610, 20.3440, 3.2738>
		<-7.4473, 20.3990, 3.3390> <-7.4833, 20.4350, 3.3390> <-8.6800, 20.4350, 3.3390> <-8.7161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7161, 19.1302, 3.3390> <-8.7416, 19.1046, 3.3693> <-8.7797, 19.0665, 3.4419> <-8.7623, 19.0839, 3.4821>
		<-8.7521, 19.1662, 3.3390> <-8.7777, 19.1406, 3.3693> <-8.8184, 19.1052, 3.4419> <-8.8010, 19.1226, 3.4821>
		<-8.7521, 20.3629, 3.3390> <-8.7777, 20.3885, 3.3693> <-8.8184, 20.4240, 3.4419> <-8.8010, 20.4066, 3.4821>
		<-8.7161, 20.3990, 3.3390> <-8.7416, 20.4246, 3.3693> <-8.7797, 20.4627, 3.4419> <-8.7623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7161, 19.1302, 3.3390> <-8.6800, 19.0942, 3.3390> <-7.4833, 19.0942, 3.3390> <-7.4473, 19.1302, 3.3390>
		<-8.7416, 19.1046, 3.3693> <-8.7056, 19.0686, 3.3693> <-7.4577, 19.0686, 3.3693> <-7.4217, 19.1046, 3.3693>
		<-8.7797, 19.0665, 3.4419> <-8.7411, 19.0279, 3.4419> <-7.4223, 19.0279, 3.4419> <-7.3836, 19.0665, 3.4419>
		<-8.7623, 19.0839, 3.4821> <-8.7236, 19.0453, 3.4821> <-7.4397, 19.0453, 3.4821> <-7.4010, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4473, 19.1302, 3.3390> <-7.4112, 19.1662, 3.3390> <-7.4112, 20.3629, 3.3390> <-7.4473, 20.3990, 3.3390>
		<-7.4217, 19.1046, 3.3693> <-7.3857, 19.1406, 3.3693> <-7.3857, 20.3885, 3.3693> <-7.4217, 20.4246, 3.3693>
		<-7.3836, 19.0665, 3.4419> <-7.3449, 19.1052, 3.4419> <-7.3449, 20.4240, 3.4419> <-7.3836, 20.4627, 3.4419>
		<-7.4010, 19.0839, 3.4821> <-7.3624, 19.1226, 3.4821> <-7.3624, 20.4066, 3.4821> <-7.4010, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4473, 20.3990, 3.3390> <-7.4833, 20.4350, 3.3390> <-8.6800, 20.4350, 3.3390> <-8.7161, 20.3990, 3.3390>
		<-7.4217, 20.4246, 3.3693> <-7.4577, 20.4606, 3.3693> <-8.7056, 20.4606, 3.3693> <-8.7416, 20.4246, 3.3693>
		<-7.3836, 20.4627, 3.4419> <-7.4223, 20.5013, 3.4419> <-8.7411, 20.5013, 3.4419> <-8.7797, 20.4627, 3.4419>
		<-7.4010, 20.4452, 3.4821> <-7.4397, 20.4839, 3.4821> <-8.7236, 20.4839, 3.4821> <-8.7623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7623, 19.0839, 3.4821> <-8.7163, 19.1300, 3.5884> <-8.5961, 19.2502, 3.6567> <-8.5380, 19.3083, 3.7504>
		<-8.8010, 19.1226, 3.4821> <-8.7550, 19.1686, 3.5884> <-8.6220, 19.2761, 3.6567> <-8.5639, 19.3342, 3.7504>
		<-8.8010, 20.4066, 3.4821> <-8.7550, 20.3606, 3.5884> <-8.6220, 20.2531, 3.6567> <-8.5639, 20.1950, 3.7504>
		<-8.7623, 20.4452, 3.4821> <-8.7163, 20.3992, 3.5884> <-8.5961, 20.2790, 3.6567> <-8.5380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7623, 19.0839, 3.4821> <-8.7236, 19.0453, 3.4821> <-7.4397, 19.0453, 3.4821> <-7.4010, 19.0839, 3.4821>
		<-8.7163, 19.1300, 3.5884> <-8.6776, 19.0913, 3.5884> <-7.4857, 19.0913, 3.5884> <-7.4470, 19.1300, 3.5884>
		<-8.5961, 19.2502, 3.6567> <-8.5702, 19.2242, 3.6567> <-7.5932, 19.2242, 3.6567> <-7.5672, 19.2502, 3.6567>
		<-8.5380, 19.3083, 3.7504> <-8.5121, 19.2823, 3.7504> <-7.6513, 19.2823, 3.7504> <-7.6253, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4010, 19.0839, 3.4821> <-7.3624, 19.1226, 3.4821> <-7.3624, 20.4066, 3.4821> <-7.4010, 20.4452, 3.4821>
		<-7.4470, 19.1300, 3.5884> <-7.4084, 19.1686, 3.5884> <-7.4084, 20.3606, 3.5884> <-7.4470, 20.3992, 3.5884>
		<-7.5672, 19.2502, 3.6567> <-7.5413, 19.2761, 3.6567> <-7.5413, 20.2531, 3.6567> <-7.5672, 20.2790, 3.6567>
		<-7.6253, 19.3083, 3.7504> <-7.5994, 19.3342, 3.7504> <-7.5994, 20.1950, 3.7504> <-7.6253, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4010, 20.4452, 3.4821> <-7.4397, 20.4839, 3.4821> <-8.7236, 20.4839, 3.4821> <-8.7623, 20.4452, 3.4821>
		<-7.4470, 20.3992, 3.5884> <-7.4857, 20.4379, 3.5884> <-8.6776, 20.4379, 3.5884> <-8.7163, 20.3992, 3.5884>
		<-7.5672, 20.2790, 3.6567> <-7.5932, 20.3049, 3.6567> <-8.5702, 20.3049, 3.6567> <-8.5961, 20.2790, 3.6567>
		<-7.6253, 20.2209, 3.7504> <-7.6513, 20.2468, 3.7504> <-8.5121, 20.2468, 3.7504> <-8.5380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5380, 19.3083, 3.7504> <-8.4964, 19.3498, 3.8175> <-8.4527, 19.3935, 3.9241> <-8.4352, 19.4110, 4.0098>
		<-8.5639, 19.3342, 3.7504> <-8.5223, 19.3757, 3.8175> <-8.4728, 19.4136, 3.9241> <-8.4553, 19.4311, 4.0098>
		<-8.5639, 20.1950, 3.7504> <-8.5223, 20.1534, 3.8175> <-8.4728, 20.1156, 3.9241> <-8.4553, 20.0981, 4.0098>
		<-8.5380, 20.2209, 3.7504> <-8.4964, 20.1793, 3.8175> <-8.4527, 20.1356, 3.9241> <-8.4352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.5380, 19.3083, 3.7504> <-8.5121, 19.2823, 3.7504> <-7.6513, 19.2823, 3.7504> <-7.6253, 19.3083, 3.7504>
		<-8.4964, 19.3498, 3.8175> <-8.4705, 19.3239, 3.8175> <-7.6928, 19.3239, 3.8175> <-7.6669, 19.3498, 3.8175>
		<-8.4527, 19.3935, 3.9241> <-8.4326, 19.3734, 3.9241> <-7.7307, 19.3734, 3.9241> <-7.7106, 19.3935, 3.9241>
		<-8.4352, 19.4110, 4.0098> <-8.4152, 19.3909, 4.0098> <-7.7482, 19.3909, 4.0098> <-7.7281, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6253, 19.3083, 3.7504> <-7.5994, 19.3342, 3.7504> <-7.5994, 20.1950, 3.7504> <-7.6253, 20.2209, 3.7504>
		<-7.6669, 19.3498, 3.8175> <-7.6410, 19.3757, 3.8175> <-7.6410, 20.1534, 3.8175> <-7.6669, 20.1793, 3.8175>
		<-7.7106, 19.3935, 3.9241> <-7.6905, 19.4136, 3.9241> <-7.6905, 20.1156, 3.9241> <-7.7106, 20.1356, 3.9241>
		<-7.7281, 19.4110, 4.0098> <-7.7080, 19.4311, 4.0098> <-7.7080, 20.0981, 4.0098> <-7.7281, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6253, 20.2209, 3.7504> <-7.6513, 20.2468, 3.7504> <-8.5121, 20.2468, 3.7504> <-8.5380, 20.2209, 3.7504>
		<-7.6669, 20.1793, 3.8175> <-7.6928, 20.2053, 3.8175> <-8.4705, 20.2053, 3.8175> <-8.4964, 20.1793, 3.8175>
		<-7.7106, 20.1356, 3.9241> <-7.7307, 20.1557, 3.9241> <-8.4326, 20.1557, 3.9241> <-8.4527, 20.1356, 3.9241>
		<-7.7281, 20.1182, 4.0098> <-7.7482, 20.1383, 4.0098> <-8.4152, 20.1383, 4.0098> <-8.4352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4352, 19.4110, 4.0098> <-8.4168, 19.4294, 4.1002> <-8.4221, 19.4242, 4.2288> <-8.4213, 19.4250, 4.3229>
		<-8.4553, 19.4311, 4.0098> <-8.4369, 19.4495, 4.1002> <-8.4413, 19.4435, 4.2288> <-8.4405, 19.4443, 4.3229>
		<-8.4553, 20.0981, 4.0098> <-8.4369, 20.0797, 4.1002> <-8.4413, 20.0857, 4.2288> <-8.4405, 20.0849, 4.3229>
		<-8.4352, 20.1182, 4.0098> <-8.4168, 20.0997, 4.1002> <-8.4221, 20.1050, 4.2288> <-8.4213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4352, 19.4110, 4.0098> <-8.4152, 19.3909, 4.0098> <-7.7482, 19.3909, 4.0098> <-7.7281, 19.4110, 4.0098>
		<-8.4168, 19.4294, 4.1002> <-8.3967, 19.4094, 4.1002> <-7.7666, 19.4094, 4.1002> <-7.7465, 19.4294, 4.1002>
		<-8.4221, 19.4242, 4.2288> <-8.4028, 19.4049, 4.2288> <-7.7606, 19.4049, 4.2288> <-7.7413, 19.4242, 4.2288>
		<-8.4213, 19.4250, 4.3229> <-8.4020, 19.4057, 4.3229> <-7.7614, 19.4057, 4.3229> <-7.7421, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7281, 19.4110, 4.0098> <-7.7080, 19.4311, 4.0098> <-7.7080, 20.0981, 4.0098> <-7.7281, 20.1182, 4.0098>
		<-7.7465, 19.4294, 4.1002> <-7.7264, 19.4495, 4.1002> <-7.7264, 20.0797, 4.1002> <-7.7465, 20.0997, 4.1002>
		<-7.7413, 19.4242, 4.2288> <-7.7220, 19.4435, 4.2288> <-7.7220, 20.0857, 4.2288> <-7.7413, 20.1050, 4.2288>
		<-7.7421, 19.4250, 4.3229> <-7.7228, 19.4443, 4.3229> <-7.7228, 20.0849, 4.3229> <-7.7421, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7281, 20.1182, 4.0098> <-7.7482, 20.1383, 4.0098> <-8.4152, 20.1383, 4.0098> <-8.4352, 20.1182, 4.0098>
		<-7.7465, 20.0997, 4.1002> <-7.7666, 20.1198, 4.1002> <-8.3967, 20.1198, 4.1002> <-8.4168, 20.0997, 4.1002>
		<-7.7413, 20.1050, 4.2288> <-7.7606, 20.1243, 4.2288> <-8.4028, 20.1243, 4.2288> <-8.4221, 20.1050, 4.2288>
		<-7.7421, 20.1042, 4.3229> <-7.7614, 20.1235, 4.3229> <-8.4020, 20.1235, 4.3229> <-8.4213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4213, 19.4250, 4.3229> <-8.4179, 19.4284, 4.7283> <-8.4197, 19.4265, 5.2689> <-8.4213, 19.4250, 5.6744>
		<-8.4405, 19.4443, 4.3229> <-8.4371, 19.4477, 4.7283> <-8.4390, 19.4458, 5.2689> <-8.4405, 19.4443, 5.6744>
		<-8.4405, 20.0849, 4.3229> <-8.4371, 20.0815, 4.7283> <-8.4390, 20.0834, 5.2689> <-8.4405, 20.0849, 5.6744>
		<-8.4213, 20.1042, 4.3229> <-8.4179, 20.1008, 4.7283> <-8.4197, 20.1027, 5.2689> <-8.4213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4213, 19.4250, 4.3229> <-8.4020, 19.4057, 4.3229> <-7.7614, 19.4057, 4.3229> <-7.7421, 19.4250, 4.3229>
		<-8.4179, 19.4284, 4.7283> <-8.3986, 19.4091, 4.7283> <-7.7648, 19.4091, 4.7283> <-7.7455, 19.4284, 4.7283>
		<-8.4197, 19.4265, 5.2689> <-8.4004, 19.4072, 5.2689> <-7.7629, 19.4072, 5.2689> <-7.7436, 19.4265, 5.2689>
		<-8.4213, 19.4250, 5.6744> <-8.4020, 19.4057, 5.6744> <-7.7614, 19.4057, 5.6744> <-7.7421, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7421, 19.4250, 4.3229> <-7.7228, 19.4443, 4.3229> <-7.7228, 20.0849, 4.3229> <-7.7421, 20.1042, 4.3229>
		<-7.7455, 19.4284, 4.7283> <-7.7262, 19.4477, 4.7283> <-7.7262, 20.0815, 4.7283> <-7.7455, 20.1008, 4.7283>
		<-7.7436, 19.4265, 5.2689> <-7.7243, 19.4458, 5.2689> <-7.7243, 20.0834, 5.2689> <-7.7436, 20.1027, 5.2689>
		<-7.7421, 19.4250, 5.6744> <-7.7228, 19.4443, 5.6744> <-7.7228, 20.0849, 5.6744> <-7.7421, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7421, 20.1042, 4.3229> <-7.7614, 20.1235, 4.3229> <-8.4020, 20.1235, 4.3229> <-8.4213, 20.1042, 4.3229>
		<-7.7455, 20.1008, 4.7283> <-7.7648, 20.1201, 4.7283> <-8.3986, 20.1201, 4.7283> <-8.4179, 20.1008, 4.7283>
		<-7.7436, 20.1027, 5.2689> <-7.7629, 20.1220, 5.2689> <-8.4004, 20.1220, 5.2689> <-8.4197, 20.1027, 5.2689>
		<-7.7421, 20.1042, 5.6744> <-7.7614, 20.1235, 5.6744> <-8.4020, 20.1235, 5.6744> <-8.4213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4213, 19.4250, 5.6744> <-8.4225, 19.4237, 6.0073> <-8.4172, 19.4290, 6.4517> <-8.4305, 19.4157, 6.7841>
		<-8.4405, 19.4443, 5.6744> <-8.4418, 19.4430, 6.0073> <-8.4371, 19.4488, 6.4517> <-8.4503, 19.4355, 6.7841>
		<-8.4405, 20.0849, 5.6744> <-8.4418, 20.0861, 6.0073> <-8.4371, 20.0804, 6.4517> <-8.4503, 20.0936, 6.7841>
		<-8.4213, 20.1042, 5.6744> <-8.4225, 20.1054, 6.0073> <-8.4172, 20.1002, 6.4517> <-8.4305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4213, 19.4250, 5.6744> <-8.4020, 19.4057, 5.6744> <-7.7614, 19.4057, 5.6744> <-7.7421, 19.4250, 5.6744>
		<-8.4225, 19.4237, 6.0073> <-8.4032, 19.4044, 6.0073> <-7.7601, 19.4044, 6.0073> <-7.7408, 19.4237, 6.0073>
		<-8.4172, 19.4290, 6.4517> <-8.3974, 19.4092, 6.4517> <-7.7659, 19.4092, 6.4517> <-7.7461, 19.4290, 6.4517>
		<-8.4305, 19.4157, 6.7841> <-8.4107, 19.3959, 6.7841> <-7.7526, 19.3959, 6.7841> <-7.7328, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7421, 19.4250, 5.6744> <-7.7228, 19.4443, 5.6744> <-7.7228, 20.0849, 5.6744> <-7.7421, 20.1042, 5.6744>
		<-7.7408, 19.4237, 6.0073> <-7.7215, 19.4430, 6.0073> <-7.7215, 20.0861, 6.0073> <-7.7408, 20.1054, 6.0073>
		<-7.7461, 19.4290, 6.4517> <-7.7263, 19.4488, 6.4517> <-7.7263, 20.0804, 6.4517> <-7.7461, 20.1002, 6.4517>
		<-7.7328, 19.4157, 6.7841> <-7.7130, 19.4355, 6.7841> <-7.7130, 20.0936, 6.7841> <-7.7328, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7421, 20.1042, 5.6744> <-7.7614, 20.1235, 5.6744> <-8.4020, 20.1235, 5.6744> <-8.4213, 20.1042, 5.6744>
		<-7.7408, 20.1054, 6.0073> <-7.7601, 20.1247, 6.0073> <-8.4032, 20.1247, 6.0073> <-8.4225, 20.1054, 6.0073>
		<-7.7461, 20.1002, 6.4517> <-7.7659, 20.1200, 6.4517> <-8.3974, 20.1200, 6.4517> <-8.4172, 20.1002, 6.4517>
		<-7.7328, 20.1134, 6.7841> <-7.7526, 20.1333, 6.7841> <-8.4107, 20.1333, 6.7841> <-8.4305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4305, 19.4157, 6.7841> <-8.4325, 19.4137, 6.8341> <-8.4449, 19.4013, 6.9079> <-8.4718, 19.3745, 6.9405>
		<-8.4503, 19.4355, 6.7841> <-8.4523, 19.4336, 6.8341> <-8.4671, 19.4235, 6.9079> <-8.4940, 19.3966, 6.9405>
		<-8.4503, 20.0936, 6.7841> <-8.4523, 20.0956, 6.8341> <-8.4671, 20.1057, 6.9079> <-8.4940, 20.1326, 6.9405>
		<-8.4305, 20.1134, 6.7841> <-8.4325, 20.1154, 6.8341> <-8.4449, 20.1278, 6.9079> <-8.4718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4305, 19.4157, 6.7841> <-8.4107, 19.3959, 6.7841> <-7.7526, 19.3959, 6.7841> <-7.7328, 19.4157, 6.7841>
		<-8.4325, 19.4137, 6.8341> <-8.4127, 19.3939, 6.8341> <-7.7506, 19.3939, 6.8341> <-7.7308, 19.4137, 6.8341>
		<-8.4449, 19.4013, 6.9079> <-8.4228, 19.3792, 6.9079> <-7.7406, 19.3792, 6.9079> <-7.7184, 19.4013, 6.9079>
		<-8.4718, 19.3745, 6.9405> <-8.4496, 19.3523, 6.9405> <-7.7137, 19.3523, 6.9405> <-7.6915, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7328, 19.4157, 6.7841> <-7.7130, 19.4355, 6.7841> <-7.7130, 20.0936, 6.7841> <-7.7328, 20.1134, 6.7841>
		<-7.7308, 19.4137, 6.8341> <-7.7110, 19.4336, 6.8341> <-7.7110, 20.0956, 6.8341> <-7.7308, 20.1154, 6.8341>
		<-7.7184, 19.4013, 6.9079> <-7.6962, 19.4235, 6.9079> <-7.6962, 20.1057, 6.9079> <-7.7184, 20.1278, 6.9079>
		<-7.6915, 19.3745, 6.9405> <-7.6694, 19.3966, 6.9405> <-7.6694, 20.1326, 6.9405> <-7.6915, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.7328, 20.1134, 6.7841> <-7.7526, 20.1333, 6.7841> <-8.4107, 20.1333, 6.7841> <-8.4305, 20.1134, 6.7841>
		<-7.7308, 20.1154, 6.8341> <-7.7506, 20.1352, 6.8341> <-8.4127, 20.1352, 6.8341> <-8.4325, 20.1154, 6.8341>
		<-7.7184, 20.1278, 6.9079> <-7.7406, 20.1500, 6.9079> <-8.4228, 20.1500, 6.9079> <-8.4449, 20.1278, 6.9079>
		<-7.6915, 20.1547, 6.9405> <-7.7137, 20.1769, 6.9405> <-8.4496, 20.1769, 6.9405> <-8.4718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4718, 19.3745, 6.9405> <-8.5339, 19.3123, 7.0160> <-8.6620, 19.1842, 7.0331> <-8.7114, 19.1348, 7.1255>
		<-8.4940, 19.3966, 6.9405> <-8.5561, 19.3345, 7.0160> <-8.6978, 19.2200, 7.0331> <-8.7472, 19.1706, 7.1255>
		<-8.4940, 20.1326, 6.9405> <-8.5561, 20.1947, 7.0160> <-8.6978, 20.3092, 7.0331> <-8.7472, 20.3586, 7.1255>
		<-8.4718, 20.1547, 6.9405> <-8.5339, 20.2168, 7.0160> <-8.6620, 20.3449, 7.0331> <-8.7114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.4718, 19.3745, 6.9405> <-8.4496, 19.3523, 6.9405> <-7.7137, 19.3523, 6.9405> <-7.6915, 19.3745, 6.9405>
		<-8.5339, 19.3123, 7.0160> <-8.5117, 19.2902, 7.0160> <-7.6516, 19.2902, 7.0160> <-7.6294, 19.3123, 7.0160>
		<-8.6620, 19.1842, 7.0331> <-8.6262, 19.1485, 7.0331> <-7.5371, 19.1485, 7.0331> <-7.5013, 19.1842, 7.0331>
		<-8.7114, 19.1348, 7.1255> <-8.6757, 19.0990, 7.1255> <-7.4877, 19.0990, 7.1255> <-7.4519, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6915, 19.3745, 6.9405> <-7.6694, 19.3966, 6.9405> <-7.6694, 20.1326, 6.9405> <-7.6915, 20.1547, 6.9405>
		<-7.6294, 19.3123, 7.0160> <-7.6073, 19.3345, 7.0160> <-7.6073, 20.1947, 7.0160> <-7.6294, 20.2168, 7.0160>
		<-7.5013, 19.1842, 7.0331> <-7.4655, 19.2200, 7.0331> <-7.4655, 20.3092, 7.0331> <-7.5013, 20.3449, 7.0331>
		<-7.4519, 19.1348, 7.1255> <-7.4161, 19.1706, 7.1255> <-7.4161, 20.3586, 7.1255> <-7.4519, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.6915, 20.1547, 6.9405> <-7.7137, 20.1769, 6.9405> <-8.4496, 20.1769, 6.9405> <-8.4718, 20.1547, 6.9405>
		<-7.6294, 20.2168, 7.0160> <-7.6516, 20.2390, 7.0160> <-8.5117, 20.2390, 7.0160> <-8.5339, 20.2168, 7.0160>
		<-7.5013, 20.3449, 7.0331> <-7.5371, 20.3807, 7.0331> <-8.6262, 20.3807, 7.0331> <-8.6620, 20.3449, 7.0331>
		<-7.4519, 20.3944, 7.1255> <-7.4877, 20.4301, 7.1255> <-8.6757, 20.4301, 7.1255> <-8.7114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7114, 19.1348, 7.1255> <-8.7319, 19.1143, 7.1638> <-8.6316, 19.2146, 7.1912> <-8.6316, 19.2146, 7.2393>
		<-8.7472, 19.1706, 7.1255> <-8.7677, 19.1501, 7.1638> <-8.6629, 19.2459, 7.1912> <-8.6629, 19.2459, 7.2393>
		<-8.7472, 20.3586, 7.1255> <-8.7677, 20.3791, 7.1638> <-8.6629, 20.2833, 7.1912> <-8.6629, 20.2833, 7.2393>
		<-8.7114, 20.3944, 7.1255> <-8.7319, 20.4149, 7.1638> <-8.6316, 20.3146, 7.1912> <-8.6316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7114, 19.1348, 7.1255> <-8.6757, 19.0990, 7.1255> <-7.4877, 19.0990, 7.1255> <-7.4519, 19.1348, 7.1255>
		<-8.7319, 19.1143, 7.1638> <-8.6962, 19.0785, 7.1638> <-7.4671, 19.0785, 7.1638> <-7.4314, 19.1143, 7.1638>
		<-8.6316, 19.2146, 7.1912> <-8.6004, 19.1834, 7.1912> <-7.5629, 19.1834, 7.1912> <-7.5317, 19.2146, 7.1912>
		<-8.6316, 19.2146, 7.2393> <-8.6004, 19.1834, 7.2393> <-7.5629, 19.1834, 7.2393> <-7.5317, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4519, 19.1348, 7.1255> <-7.4161, 19.1706, 7.1255> <-7.4161, 20.3586, 7.1255> <-7.4519, 20.3944, 7.1255>
		<-7.4314, 19.1143, 7.1638> <-7.3956, 19.1501, 7.1638> <-7.3956, 20.3791, 7.1638> <-7.4314, 20.4149, 7.1638>
		<-7.5317, 19.2146, 7.1912> <-7.5005, 19.2459, 7.1912> <-7.5005, 20.2833, 7.1912> <-7.5317, 20.3146, 7.1912>
		<-7.5317, 19.2146, 7.2393> <-7.5005, 19.2459, 7.2393> <-7.5005, 20.2833, 7.2393> <-7.5317, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4519, 20.3944, 7.1255> <-7.4877, 20.4301, 7.1255> <-8.6757, 20.4301, 7.1255> <-8.7114, 20.3944, 7.1255>
		<-7.4314, 20.4149, 7.1638> <-7.4671, 20.4506, 7.1638> <-8.6962, 20.4506, 7.1638> <-8.7319, 20.4149, 7.1638>
		<-7.5317, 20.3146, 7.1912> <-7.5629, 20.3458, 7.1912> <-8.6004, 20.3458, 7.1912> <-8.6316, 20.3146, 7.1912>
		<-7.5317, 20.3146, 7.2393> <-7.5629, 20.3458, 7.2393> <-8.6004, 20.3458, 7.2393> <-8.6316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6316, 19.2146, 7.2393> <-8.6316, 19.2146, 7.2905> <-8.7054, 19.1408, 7.3169> <-8.7114, 19.1348, 7.3673>
		<-8.6629, 19.2459, 7.2393> <-8.6629, 19.2459, 7.2905> <-8.7412, 19.1766, 7.3169> <-8.7472, 19.1706, 7.3673>
		<-8.6629, 20.2833, 7.2393> <-8.6629, 20.2833, 7.2905> <-8.7412, 20.3526, 7.3169> <-8.7472, 20.3586, 7.3673>
		<-8.6316, 20.3146, 7.2393> <-8.6316, 20.3146, 7.2905> <-8.7054, 20.3883, 7.3169> <-8.7114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.6316, 19.2146, 7.2393> <-8.6004, 19.1834, 7.2393> <-7.5629, 19.1834, 7.2393> <-7.5317, 19.2146, 7.2393>
		<-8.6316, 19.2146, 7.2905> <-8.6004, 19.1834, 7.2905> <-7.5629, 19.1834, 7.2905> <-7.5317, 19.2146, 7.2905>
		<-8.7054, 19.1408, 7.3169> <-8.6696, 19.1051, 7.3169> <-7.4937, 19.1051, 7.3169> <-7.4579, 19.1408, 7.3169>
		<-8.7114, 19.1348, 7.3673> <-8.6757, 19.0990, 7.3673> <-7.4877, 19.0990, 7.3673> <-7.4519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5317, 19.2146, 7.2393> <-7.5005, 19.2459, 7.2393> <-7.5005, 20.2833, 7.2393> <-7.5317, 20.3146, 7.2393>
		<-7.5317, 19.2146, 7.2905> <-7.5005, 19.2459, 7.2905> <-7.5005, 20.2833, 7.2905> <-7.5317, 20.3146, 7.2905>
		<-7.4579, 19.1408, 7.3169> <-7.4222, 19.1766, 7.3169> <-7.4222, 20.3526, 7.3169> <-7.4579, 20.3883, 7.3169>
		<-7.4519, 19.1348, 7.3673> <-7.4161, 19.1706, 7.3673> <-7.4161, 20.3586, 7.3673> <-7.4519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.5317, 20.3146, 7.2393> <-7.5629, 20.3458, 7.2393> <-8.6004, 20.3458, 7.2393> <-8.6316, 20.3146, 7.2393>
		<-7.5317, 20.3146, 7.2905> <-7.5629, 20.3458, 7.2905> <-8.6004, 20.3458, 7.2905> <-8.6316, 20.3146, 7.2905>
		<-7.4579, 20.3883, 7.3169> <-7.4937, 20.4241, 7.3169> <-8.6696, 20.4241, 7.3169> <-8.7054, 20.3883, 7.3169>
		<-7.4519, 20.3944, 7.3673> <-7.4877, 20.4301, 7.3673> <-8.6757, 20.4301, 7.3673> <-8.7114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7114, 19.1348, 7.9080> <-8.7472, 19.1706, 7.9080> <-8.7472, 20.3586, 7.9080> <-8.7114, 20.3944, 7.9080>
		<-8.7114, 19.1348, 7.7458> <-8.7472, 19.1706, 7.7458> <-8.7472, 20.3586, 7.7458> <-8.7114, 20.3944, 7.7458>
		<-8.7305, 19.1157, 7.5273> <-8.7663, 19.1515, 7.5273> <-8.7663, 20.3777, 7.5273> <-8.7305, 20.4134, 7.5273>
		<-8.7114, 19.1348, 7.3673> <-8.7472, 19.1706, 7.3673> <-8.7472, 20.3586, 7.3673> <-8.7114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.7114, 19.1348, 7.9080> <-8.7114, 19.1348, 7.7458> <-8.7305, 19.1157, 7.5273> <-8.7114, 19.1348, 7.3673>
		<-8.6757, 19.0990, 7.9080> <-8.6757, 19.0990, 7.7458> <-8.6947, 19.0800, 7.5273> <-8.6757, 19.0990, 7.3673>
		<-7.4877, 19.0990, 7.9080> <-7.4877, 19.0990, 7.7458> <-7.4686, 19.0800, 7.5273> <-7.4877, 19.0990, 7.3673>
		<-7.4519, 19.1348, 7.9080> <-7.4519, 19.1348, 7.7458> <-7.4328, 19.1157, 7.5273> <-7.4519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4519, 19.1348, 7.9080> <-7.4519, 19.1348, 7.7458> <-7.4328, 19.1157, 7.5273> <-7.4519, 19.1348, 7.3673>
		<-7.4161, 19.1706, 7.9080> <-7.4161, 19.1706, 7.7458> <-7.3970, 19.1515, 7.5273> <-7.4161, 19.1706, 7.3673>
		<-7.4161, 20.3586, 7.9080> <-7.4161, 20.3586, 7.7458> <-7.3970, 20.3777, 7.5273> <-7.4161, 20.3586, 7.3673>
		<-7.4519, 20.3944, 7.9080> <-7.4519, 20.3944, 7.7458> <-7.4328, 20.4134, 7.5273> <-7.4519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.4519, 20.3944, 7.9080> <-7.4519, 20.3944, 7.7458> <-7.4328, 20.4134, 7.5273> <-7.4519, 20.3944, 7.3673>
		<-7.4877, 20.4301, 7.9080> <-7.4877, 20.4301, 7.7458> <-7.4686, 20.4492, 7.5273> <-7.4877, 20.4301, 7.3673>
		<-8.6757, 20.4301, 7.9080> <-8.6757, 20.4301, 7.7458> <-8.6947, 20.4492, 7.5273> <-8.6757, 20.4301, 7.3673>
		<-8.7114, 20.3944, 7.9080> <-8.7114, 20.3944, 7.7458> <-8.7305, 20.4134, 7.5273> <-8.7114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9589, 18.8874, 0.7771> <-9.0087, 18.9372, 0.7771> <-9.0087, 20.5920, 0.7771> <-8.9589, 20.6418, 0.7771>
		<-8.9796, 18.8666, 0.6520> <-9.0294, 18.9164, 0.6520> <-9.0294, 20.6127, 0.6520> <-8.9796, 20.6626, 0.6520>
		<-8.9589, 18.8874, 0.4772> <-9.0087, 18.9372, 0.4772> <-9.0087, 20.5920, 0.4772> <-8.9589, 20.6418, 0.4772>
		<-8.9589, 18.8874, 0.3486> <-9.0087, 18.9372, 0.3486> <-9.0087, 20.5920, 0.3486> <-8.9589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9589, 18.8874, 0.7771> <-8.9796, 18.8666, 0.6520> <-8.9589, 18.8874, 0.4772> <-8.9589, 18.8874, 0.3486>
		<-8.9090, 18.8376, 0.7771> <-8.9298, 18.8168, 0.6520> <-8.9090, 18.8376, 0.4772> <-8.9090, 18.8376, 0.3486>
		<-7.2543, 18.8376, 0.7771> <-7.2335, 18.8168, 0.6520> <-7.2543, 18.8376, 0.4772> <-7.2543, 18.8376, 0.3486>
		<-7.2045, 18.8874, 0.7771> <-7.1837, 18.8666, 0.6520> <-7.2045, 18.8874, 0.4772> <-7.2045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2045, 18.8874, 0.7771> <-7.1837, 18.8666, 0.6520> <-7.2045, 18.8874, 0.4772> <-7.2045, 18.8874, 0.3486>
		<-7.1546, 18.9372, 0.7771> <-7.1339, 18.9164, 0.6520> <-7.1546, 18.9372, 0.4772> <-7.1546, 18.9372, 0.3486>
		<-7.1546, 20.5920, 0.7771> <-7.1339, 20.6127, 0.6520> <-7.1546, 20.5920, 0.4772> <-7.1546, 20.5920, 0.3486>
		<-7.2045, 20.6418, 0.7771> <-7.1837, 20.6626, 0.6520> <-7.2045, 20.6418, 0.4772> <-7.2045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2045, 20.6418, 0.7771> <-7.1837, 20.6626, 0.6520> <-7.2045, 20.6418, 0.4772> <-7.2045, 20.6418, 0.3486>
		<-7.2543, 20.6916, 0.7771> <-7.2335, 20.7124, 0.6520> <-7.2543, 20.6916, 0.4772> <-7.2543, 20.6916, 0.3486>
		<-8.9090, 20.6916, 0.7771> <-8.9298, 20.7124, 0.6520> <-8.9090, 20.6916, 0.4772> <-8.9090, 20.6916, 0.3486>
		<-8.9589, 20.6418, 0.7771> <-8.9796, 20.6626, 0.6520> <-8.9589, 20.6418, 0.4772> <-8.9589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9589, 18.8874, -0.0618> <-8.9589, 18.8874, 0.0613> <-8.9589, 18.8874, 0.2255> <-8.9589, 18.8874, 0.3486>
		<-9.0087, 18.9372, -0.0618> <-9.0087, 18.9372, 0.0613> <-9.0087, 18.9372, 0.2255> <-9.0087, 18.9372, 0.3486>
		<-9.0087, 20.5920, -0.0618> <-9.0087, 20.5920, 0.0613> <-9.0087, 20.5920, 0.2255> <-9.0087, 20.5920, 0.3486>
		<-8.9589, 20.6418, -0.0618> <-8.9589, 20.6418, 0.0613> <-8.9589, 20.6418, 0.2255> <-8.9589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.9589, 18.8874, -0.0618> <-8.9090, 18.8376, -0.0618> <-7.2543, 18.8376, -0.0618> <-7.2045, 18.8874, -0.0618>
		<-8.9589, 18.8874, 0.0613> <-8.9090, 18.8376, 0.0613> <-7.2543, 18.8376, 0.0613> <-7.2045, 18.8874, 0.0613>
		<-8.9589, 18.8874, 0.2255> <-8.9090, 18.8376, 0.2255> <-7.2543, 18.8376, 0.2255> <-7.2045, 18.8874, 0.2255>
		<-8.9589, 18.8874, 0.3486> <-8.9090, 18.8376, 0.3486> <-7.2543, 18.8376, 0.3486> <-7.2045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2045, 18.8874, -0.0618> <-7.1546, 18.9372, -0.0618> <-7.1546, 20.5920, -0.0618> <-7.2045, 20.6418, -0.0618>
		<-7.2045, 18.8874, 0.0613> <-7.1546, 18.9372, 0.0613> <-7.1546, 20.5920, 0.0613> <-7.2045, 20.6418, 0.0613>
		<-7.2045, 18.8874, 0.2255> <-7.1546, 18.9372, 0.2255> <-7.1546, 20.5920, 0.2255> <-7.2045, 20.6418, 0.2255>
		<-7.2045, 18.8874, 0.3486> <-7.1546, 18.9372, 0.3486> <-7.1546, 20.5920, 0.3486> <-7.2045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.2045, 20.6418, -0.0618> <-7.2543, 20.6916, -0.0618> <-8.9090, 20.6916, -0.0618> <-8.9589, 20.6418, -0.0618>
		<-7.2045, 20.6418, 0.0613> <-7.2543, 20.6916, 0.0613> <-8.9090, 20.6916, 0.0613> <-8.9589, 20.6418, 0.0613>
		<-7.2045, 20.6418, 0.2255> <-7.2543, 20.6916, 0.2255> <-8.9090, 20.6916, 0.2255> <-8.9589, 20.6418, 0.2255>
		<-7.2045, 20.6418, 0.3486> <-7.2543, 20.6916, 0.3486> <-8.9090, 20.6916, 0.3486> <-8.9589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 0.9062> <-6.7109, 19.0245, 0.9062> <-6.7109, 20.5047, 0.9062> <-6.6664, 20.5493, 0.9062>
		<-6.6712, 18.9751, 0.8515> <-6.7157, 19.0196, 0.8515> <-6.7157, 20.5095, 0.8515> <-6.6712, 20.5541, 0.8515>
		<-6.7500, 18.8963, 0.8308> <-6.7998, 18.9461, 0.8308> <-6.7998, 20.5831, 0.8308> <-6.7500, 20.6329, 0.8308>
		<-6.7589, 18.8874, 0.7771> <-6.8087, 18.9372, 0.7771> <-6.8087, 20.5920, 0.7771> <-6.7589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 0.9062> <-6.6620, 18.9842, 0.9557> <-6.7560, 18.8903, 0.9996> <-6.7357, 18.9105, 1.0404>
		<-6.7109, 19.0245, 0.9062> <-6.7066, 19.0288, 0.9557> <-6.8045, 18.9388, 0.9996> <-6.7843, 18.9590, 1.0404>
		<-6.7109, 20.5047, 0.9062> <-6.7066, 20.5004, 0.9557> <-6.8045, 20.5904, 0.9996> <-6.7843, 20.5702, 1.0404>
		<-6.6664, 20.5493, 0.9062> <-6.6620, 20.5449, 0.9557> <-6.7560, 20.6389, 0.9996> <-6.7357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 0.9062> <-6.6712, 18.9751, 0.8515> <-6.7500, 18.8963, 0.8308> <-6.7589, 18.8874, 0.7771>
		<-6.6218, 18.9353, 0.9062> <-6.6266, 18.9305, 0.8515> <-6.7001, 18.8465, 0.8308> <-6.7090, 18.8376, 0.7771>
		<-5.1415, 18.9353, 0.9062> <-5.1367, 18.9305, 0.8515> <-5.0632, 18.8465, 0.8308> <-5.0543, 18.8376, 0.7771>
		<-5.0970, 18.9799, 0.9062> <-5.0922, 18.9751, 0.8515> <-5.0134, 18.8963, 0.8308> <-5.0045, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 0.9062> <-6.6218, 18.9353, 0.9062> <-5.1415, 18.9353, 0.9062> <-5.0970, 18.9799, 0.9062>
		<-6.6620, 18.9842, 0.9557> <-6.6175, 18.9397, 0.9557> <-5.1459, 18.9397, 0.9557> <-5.1013, 18.9842, 0.9557>
		<-6.7560, 18.8903, 0.9996> <-6.7075, 18.8418, 0.9996> <-5.0559, 18.8418, 0.9996> <-5.0073, 18.8903, 0.9996>
		<-6.7357, 18.9105, 1.0404> <-6.6872, 18.8620, 1.0404> <-5.0761, 18.8620, 1.0404> <-5.0276, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 18.9799, 0.9062> <-5.0922, 18.9751, 0.8515> <-5.0134, 18.8963, 0.8308> <-5.0045, 18.8874, 0.7771>
		<-5.0524, 19.0245, 0.9062> <-5.0476, 19.0196, 0.8515> <-4.9635, 18.9461, 0.8308> <-4.9546, 18.9372, 0.7771>
		<-5.0524, 20.5047, 0.9062> <-5.0476, 20.5095, 0.8515> <-4.9635, 20.5831, 0.8308> <-4.9546, 20.5920, 0.7771>
		<-5.0970, 20.5493, 0.9062> <-5.0922, 20.5541, 0.8515> <-5.0134, 20.6329, 0.8308> <-5.0045, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 18.9799, 0.9062> <-5.0524, 19.0245, 0.9062> <-5.0524, 20.5047, 0.9062> <-5.0970, 20.5493, 0.9062>
		<-5.1013, 18.9842, 0.9557> <-5.0567, 19.0288, 0.9557> <-5.0567, 20.5004, 0.9557> <-5.1013, 20.5449, 0.9557>
		<-5.0073, 18.8903, 0.9996> <-4.9588, 18.9388, 0.9996> <-4.9588, 20.5904, 0.9996> <-5.0073, 20.6389, 0.9996>
		<-5.0276, 18.9105, 1.0404> <-4.9791, 18.9590, 1.0404> <-4.9791, 20.5702, 1.0404> <-5.0276, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 20.5493, 0.9062> <-5.0922, 20.5541, 0.8515> <-5.0134, 20.6329, 0.8308> <-5.0045, 20.6418, 0.7771>
		<-5.1415, 20.5939, 0.9062> <-5.1367, 20.5987, 0.8515> <-5.0632, 20.6827, 0.8308> <-5.0543, 20.6916, 0.7771>
		<-6.6218, 20.5939, 0.9062> <-6.6266, 20.5987, 0.8515> <-6.7001, 20.6827, 0.8308> <-6.7090, 20.6916, 0.7771>
		<-6.6664, 20.5493, 0.9062> <-6.6712, 20.5541, 0.8515> <-6.7500, 20.6329, 0.8308> <-6.7589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 20.5493, 0.9062> <-5.1415, 20.5939, 0.9062> <-6.6218, 20.5939, 0.9062> <-6.6664, 20.5493, 0.9062>
		<-5.1013, 20.5449, 0.9557> <-5.1459, 20.5895, 0.9557> <-6.6175, 20.5895, 0.9557> <-6.6620, 20.5449, 0.9557>
		<-5.0073, 20.6389, 0.9996> <-5.0559, 20.6874, 0.9996> <-6.7075, 20.6874, 0.9996> <-6.7560, 20.6389, 0.9996>
		<-5.0276, 20.6187, 1.0404> <-5.0761, 20.6672, 1.0404> <-6.6872, 20.6672, 1.0404> <-6.7357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7357, 18.9105, 1.0404> <-6.6677, 18.9786, 1.1777> <-6.4982, 19.1481, 1.2552> <-6.4269, 19.2193, 1.3892>
		<-6.7843, 18.9590, 1.0404> <-6.7162, 19.0271, 1.1777> <-6.5291, 19.1790, 1.2552> <-6.4579, 19.2503, 1.3892>
		<-6.7843, 20.5702, 1.0404> <-6.7162, 20.5021, 1.1777> <-6.5291, 20.3501, 1.2552> <-6.4579, 20.2789, 1.3892>
		<-6.7357, 20.6187, 1.0404> <-6.6677, 20.5506, 1.1777> <-6.4982, 20.3811, 1.2552> <-6.4269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7357, 18.9105, 1.0404> <-6.6872, 18.8620, 1.0404> <-5.0761, 18.8620, 1.0404> <-5.0276, 18.9105, 1.0404>
		<-6.6677, 18.9786, 1.1777> <-6.6192, 18.9301, 1.1777> <-5.1442, 18.9301, 1.1777> <-5.0957, 18.9786, 1.1777>
		<-6.4982, 19.1481, 1.2552> <-6.4672, 19.1171, 1.2552> <-5.2961, 19.1171, 1.2552> <-5.2652, 19.1481, 1.2552>
		<-6.4269, 19.2193, 1.3892> <-6.3959, 19.1884, 1.3892> <-5.3674, 19.1884, 1.3892> <-5.3364, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0276, 18.9105, 1.0404> <-4.9791, 18.9590, 1.0404> <-4.9791, 20.5702, 1.0404> <-5.0276, 20.6187, 1.0404>
		<-5.0957, 18.9786, 1.1777> <-5.0471, 19.0271, 1.1777> <-5.0471, 20.5021, 1.1777> <-5.0957, 20.5506, 1.1777>
		<-5.2652, 19.1481, 1.2552> <-5.2342, 19.1790, 1.2552> <-5.2342, 20.3501, 1.2552> <-5.2652, 20.3811, 1.2552>
		<-5.3364, 19.2193, 1.3892> <-5.3054, 19.2503, 1.3892> <-5.3054, 20.2789, 1.3892> <-5.3364, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0276, 20.6187, 1.0404> <-5.0761, 20.6672, 1.0404> <-6.6872, 20.6672, 1.0404> <-6.7357, 20.6187, 1.0404>
		<-5.0957, 20.5506, 1.1777> <-5.1442, 20.5991, 1.1777> <-6.6192, 20.5991, 1.1777> <-6.6677, 20.5506, 1.1777>
		<-5.2652, 20.3811, 1.2552> <-5.2961, 20.4121, 1.2552> <-6.4672, 20.4121, 1.2552> <-6.4982, 20.3811, 1.2552>
		<-5.3364, 20.3098, 1.3892> <-5.3674, 20.3408, 1.3892> <-6.3959, 20.3408, 1.3892> <-6.4269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4269, 19.2193, 1.3892> <-6.4079, 19.2383, 1.4249> <-6.4837, 19.1626, 1.4698> <-6.4837, 19.1626, 1.5144>
		<-6.4579, 19.2503, 1.3892> <-6.4389, 19.2693, 1.4249> <-6.5179, 19.1968, 1.4698> <-6.5179, 19.1968, 1.5144>
		<-6.4579, 20.2789, 1.3892> <-6.4389, 20.2599, 1.4249> <-6.5179, 20.3324, 1.4698> <-6.5179, 20.3324, 1.5144>
		<-6.4269, 20.3098, 1.3892> <-6.4079, 20.2909, 1.4249> <-6.4837, 20.3666, 1.4698> <-6.4837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4269, 19.2193, 1.3892> <-6.3959, 19.1884, 1.3892> <-5.3674, 19.1884, 1.3892> <-5.3364, 19.2193, 1.3892>
		<-6.4079, 19.2383, 1.4249> <-6.3770, 19.2073, 1.4249> <-5.3863, 19.2073, 1.4249> <-5.3554, 19.2383, 1.4249>
		<-6.4837, 19.1626, 1.4698> <-6.4495, 19.1284, 1.4698> <-5.3138, 19.1284, 1.4698> <-5.2796, 19.1626, 1.4698>
		<-6.4837, 19.1626, 1.5144> <-6.4495, 19.1284, 1.5144> <-5.3138, 19.1284, 1.5144> <-5.2796, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3364, 19.2193, 1.3892> <-5.3054, 19.2503, 1.3892> <-5.3054, 20.2789, 1.3892> <-5.3364, 20.3098, 1.3892>
		<-5.3554, 19.2383, 1.4249> <-5.3244, 19.2693, 1.4249> <-5.3244, 20.2599, 1.4249> <-5.3554, 20.2909, 1.4249>
		<-5.2796, 19.1626, 1.4698> <-5.2455, 19.1968, 1.4698> <-5.2455, 20.3324, 1.4698> <-5.2796, 20.3666, 1.4698>
		<-5.2796, 19.1626, 1.5144> <-5.2455, 19.1968, 1.5144> <-5.2455, 20.3324, 1.5144> <-5.2796, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3364, 20.3098, 1.3892> <-5.3674, 20.3408, 1.3892> <-6.3959, 20.3408, 1.3892> <-6.4269, 20.3098, 1.3892>
		<-5.3554, 20.2909, 1.4249> <-5.3863, 20.3218, 1.4249> <-6.3770, 20.3218, 1.4249> <-6.4079, 20.2909, 1.4249>
		<-5.2796, 20.3666, 1.4698> <-5.3138, 20.4008, 1.4698> <-6.4495, 20.4008, 1.4698> <-6.4837, 20.3666, 1.4698>
		<-5.2796, 20.3666, 1.5144> <-5.3138, 20.4008, 1.5144> <-6.4495, 20.4008, 1.5144> <-6.4837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4837, 19.1626, 1.5144> <-6.4837, 19.1626, 1.5613> <-6.4121, 19.2341, 1.6066> <-6.4269, 19.2193, 1.6486>
		<-6.5179, 19.1968, 1.5144> <-6.5179, 19.1968, 1.5613> <-6.4431, 19.2651, 1.6066> <-6.4579, 19.2503, 1.6486>
		<-6.5179, 20.3324, 1.5144> <-6.5179, 20.3324, 1.5613> <-6.4431, 20.2641, 1.6066> <-6.4579, 20.2789, 1.6486>
		<-6.4837, 20.3666, 1.5144> <-6.4837, 20.3666, 1.5613> <-6.4121, 20.2950, 1.6066> <-6.4269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4837, 19.1626, 1.5144> <-6.4495, 19.1284, 1.5144> <-5.3138, 19.1284, 1.5144> <-5.2796, 19.1626, 1.5144>
		<-6.4837, 19.1626, 1.5613> <-6.4495, 19.1284, 1.5613> <-5.3138, 19.1284, 1.5613> <-5.2796, 19.1626, 1.5613>
		<-6.4121, 19.2341, 1.6066> <-6.3812, 19.2032, 1.6066> <-5.3822, 19.2032, 1.6066> <-5.3512, 19.2341, 1.6066>
		<-6.4269, 19.2193, 1.6486> <-6.3959, 19.1884, 1.6486> <-5.3674, 19.1884, 1.6486> <-5.3364, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2796, 19.1626, 1.5144> <-5.2455, 19.1968, 1.5144> <-5.2455, 20.3324, 1.5144> <-5.2796, 20.3666, 1.5144>
		<-5.2796, 19.1626, 1.5613> <-5.2455, 19.1968, 1.5613> <-5.2455, 20.3324, 1.5613> <-5.2796, 20.3666, 1.5613>
		<-5.3512, 19.2341, 1.6066> <-5.3202, 19.2651, 1.6066> <-5.3202, 20.2641, 1.6066> <-5.3512, 20.2950, 1.6066>
		<-5.3364, 19.2193, 1.6486> <-5.3054, 19.2503, 1.6486> <-5.3054, 20.2789, 1.6486> <-5.3364, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2796, 20.3666, 1.5144> <-5.3138, 20.4008, 1.5144> <-6.4495, 20.4008, 1.5144> <-6.4837, 20.3666, 1.5144>
		<-5.2796, 20.3666, 1.5613> <-5.3138, 20.4008, 1.5613> <-6.4495, 20.4008, 1.5613> <-6.4837, 20.3666, 1.5613>
		<-5.3512, 20.2950, 1.6066> <-5.3822, 20.3260, 1.6066> <-6.3812, 20.3260, 1.6066> <-6.4121, 20.2950, 1.6066>
		<-5.3364, 20.3098, 1.6486> <-5.3674, 20.3408, 1.6486> <-6.3959, 20.3408, 1.6486> <-6.4269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4269, 19.2193, 1.6486> <-6.4754, 19.1709, 1.7862> <-6.6172, 19.0290, 1.8960> <-6.6664, 18.9799, 2.0332>
		<-6.4579, 19.2503, 1.6486> <-6.5063, 19.2018, 1.7862> <-6.6618, 19.0736, 1.8960> <-6.7109, 19.0245, 2.0332>
		<-6.4579, 20.2789, 1.6486> <-6.5063, 20.3273, 1.7862> <-6.6618, 20.4556, 1.8960> <-6.7109, 20.5047, 2.0332>
		<-6.4269, 20.3098, 1.6486> <-6.4754, 20.3583, 1.7862> <-6.6172, 20.5002, 1.8960> <-6.6664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4269, 19.2193, 1.6486> <-6.3959, 19.1884, 1.6486> <-5.3674, 19.1884, 1.6486> <-5.3364, 19.2193, 1.6486>
		<-6.4754, 19.1709, 1.7862> <-6.4444, 19.1399, 1.7862> <-5.3189, 19.1399, 1.7862> <-5.2880, 19.1709, 1.7862>
		<-6.6172, 19.0290, 1.8960> <-6.5727, 18.9844, 1.8960> <-5.1907, 18.9844, 1.8960> <-5.1461, 19.0290, 1.8960>
		<-6.6664, 18.9799, 2.0332> <-6.6218, 18.9353, 2.0332> <-5.1415, 18.9353, 2.0332> <-5.0970, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3364, 19.2193, 1.6486> <-5.3054, 19.2503, 1.6486> <-5.3054, 20.2789, 1.6486> <-5.3364, 20.3098, 1.6486>
		<-5.2880, 19.1709, 1.7862> <-5.2570, 19.2018, 1.7862> <-5.2570, 20.3273, 1.7862> <-5.2880, 20.3583, 1.7862>
		<-5.1461, 19.0290, 1.8960> <-5.1015, 19.0736, 1.8960> <-5.1015, 20.4556, 1.8960> <-5.1461, 20.5002, 1.8960>
		<-5.0970, 18.9799, 2.0332> <-5.0524, 19.0245, 2.0332> <-5.0524, 20.5047, 2.0332> <-5.0970, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3364, 20.3098, 1.6486> <-5.3674, 20.3408, 1.6486> <-6.3959, 20.3408, 1.6486> <-6.4269, 20.3098, 1.6486>
		<-5.2880, 20.3583, 1.7862> <-5.3189, 20.3893, 1.7862> <-6.4444, 20.3893, 1.7862> <-6.4754, 20.3583, 1.7862>
		<-5.1461, 20.5002, 1.8960> <-5.1907, 20.5447, 1.8960> <-6.5727, 20.5447, 1.8960> <-6.6172, 20.5002, 1.8960>
		<-5.0970, 20.5493, 2.0332> <-5.1415, 20.5939, 2.0332> <-6.6218, 20.5939, 2.0332> <-6.6664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 2.0332> <-6.6930, 18.9533, 2.1074> <-6.6932, 18.9531, 2.2382> <-6.6641, 18.9822, 2.3104>
		<-6.7109, 19.0245, 2.0332> <-6.7375, 18.9979, 2.1074> <-6.7376, 18.9975, 2.2382> <-6.7085, 19.0266, 2.3104>
		<-6.7109, 20.5047, 2.0332> <-6.7375, 20.5313, 2.1074> <-6.7376, 20.5317, 2.2382> <-6.7085, 20.5025, 2.3104>
		<-6.6664, 20.5493, 2.0332> <-6.6930, 20.5759, 2.1074> <-6.6932, 20.5761, 2.2382> <-6.6641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6664, 18.9799, 2.0332> <-6.6218, 18.9353, 2.0332> <-5.1415, 18.9353, 2.0332> <-5.0970, 18.9799, 2.0332>
		<-6.6930, 18.9533, 2.1074> <-6.6484, 18.9087, 2.1074> <-5.1149, 18.9087, 2.1074> <-5.0704, 18.9533, 2.1074>
		<-6.6932, 18.9531, 2.2382> <-6.6488, 18.9086, 2.2382> <-5.1146, 18.9086, 2.2382> <-5.0701, 18.9531, 2.2382>
		<-6.6641, 18.9822, 2.3104> <-6.6196, 18.9378, 2.3104> <-5.1437, 18.9378, 2.3104> <-5.0993, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 18.9799, 2.0332> <-5.0524, 19.0245, 2.0332> <-5.0524, 20.5047, 2.0332> <-5.0970, 20.5493, 2.0332>
		<-5.0704, 18.9533, 2.1074> <-5.0258, 18.9979, 2.1074> <-5.0258, 20.5313, 2.1074> <-5.0704, 20.5759, 2.1074>
		<-5.0701, 18.9531, 2.2382> <-5.0257, 18.9975, 2.2382> <-5.0257, 20.5317, 2.2382> <-5.0701, 20.5761, 2.2382>
		<-5.0993, 18.9822, 2.3104> <-5.0548, 19.0266, 2.3104> <-5.0548, 20.5025, 2.3104> <-5.0993, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0970, 20.5493, 2.0332> <-5.1415, 20.5939, 2.0332> <-6.6218, 20.5939, 2.0332> <-6.6664, 20.5493, 2.0332>
		<-5.0704, 20.5759, 2.1074> <-5.1149, 20.6204, 2.1074> <-6.6484, 20.6204, 2.1074> <-6.6930, 20.5759, 2.1074>
		<-5.0701, 20.5761, 2.2382> <-5.1146, 20.6206, 2.2382> <-6.6488, 20.6206, 2.2382> <-6.6932, 20.5761, 2.2382>
		<-5.0993, 20.5470, 2.3104> <-5.1437, 20.5914, 2.3104> <-6.6196, 20.5914, 2.3104> <-6.6641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6641, 18.9822, 2.3104> <-6.5801, 19.0661, 2.5186> <-6.3843, 19.2620, 2.7154> <-6.3056, 19.3406, 2.9276>
		<-6.7085, 19.0266, 2.3104> <-6.6246, 19.1106, 2.5186> <-6.4084, 19.2860, 2.7154> <-6.3297, 19.3647, 2.9276>
		<-6.7085, 20.5025, 2.3104> <-6.6246, 20.4186, 2.5186> <-6.4084, 20.2431, 2.7154> <-6.3297, 20.1645, 2.9276>
		<-6.6641, 20.5470, 2.3104> <-6.5801, 20.4630, 2.5186> <-6.3843, 20.2672, 2.7154> <-6.3056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.6641, 18.9822, 2.3104> <-6.6196, 18.9378, 2.3104> <-5.1437, 18.9378, 2.3104> <-5.0993, 18.9822, 2.3104>
		<-6.5801, 19.0661, 2.5186> <-6.5357, 19.0217, 2.5186> <-5.2277, 19.0217, 2.5186> <-5.1832, 19.0661, 2.5186>
		<-6.3843, 19.2620, 2.7154> <-6.3602, 19.2379, 2.7154> <-5.4031, 19.2379, 2.7154> <-5.3790, 19.2620, 2.7154>
		<-6.3056, 19.3406, 2.9276> <-6.2815, 19.3165, 2.9276> <-5.4818, 19.3165, 2.9276> <-5.4577, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0993, 18.9822, 2.3104> <-5.0548, 19.0266, 2.3104> <-5.0548, 20.5025, 2.3104> <-5.0993, 20.5470, 2.3104>
		<-5.1832, 19.0661, 2.5186> <-5.1388, 19.1106, 2.5186> <-5.1388, 20.4186, 2.5186> <-5.1832, 20.4630, 2.5186>
		<-5.3790, 19.2620, 2.7154> <-5.3550, 19.2860, 2.7154> <-5.3550, 20.2431, 2.7154> <-5.3790, 20.2672, 2.7154>
		<-5.4577, 19.3406, 2.9276> <-5.4336, 19.3647, 2.9276> <-5.4336, 20.1645, 2.9276> <-5.4577, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0993, 20.5470, 2.3104> <-5.1437, 20.5914, 2.3104> <-6.6196, 20.5914, 2.3104> <-6.6641, 20.5470, 2.3104>
		<-5.1832, 20.4630, 2.5186> <-5.2277, 20.5075, 2.5186> <-6.5357, 20.5075, 2.5186> <-6.5801, 20.4630, 2.5186>
		<-5.3790, 20.2672, 2.7154> <-5.4031, 20.2913, 2.7154> <-6.3602, 20.2913, 2.7154> <-6.3843, 20.2672, 2.7154>
		<-5.4577, 20.1885, 2.9276> <-5.4818, 20.2126, 2.9276> <-6.2815, 20.2126, 2.9276> <-6.3056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3056, 19.3406, 2.9276> <-6.2887, 19.3576, 2.9732> <-6.3889, 19.2574, 3.0012> <-6.3889, 19.2574, 3.0528>
		<-6.3297, 19.3647, 2.9276> <-6.3128, 19.3816, 2.9732> <-6.4177, 19.2862, 3.0012> <-6.4177, 19.2862, 3.0528>
		<-6.3297, 20.1645, 2.9276> <-6.3128, 20.1475, 2.9732> <-6.4177, 20.2430, 3.0012> <-6.4177, 20.2430, 3.0528>
		<-6.3056, 20.1885, 2.9276> <-6.2887, 20.1716, 2.9732> <-6.3889, 20.2718, 3.0012> <-6.3889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3056, 19.3406, 2.9276> <-6.2815, 19.3165, 2.9276> <-5.4818, 19.3165, 2.9276> <-5.4577, 19.3406, 2.9276>
		<-6.2887, 19.3576, 2.9732> <-6.2646, 19.3335, 2.9732> <-5.4987, 19.3335, 2.9732> <-5.4746, 19.3576, 2.9732>
		<-6.3889, 19.2574, 3.0012> <-6.3601, 19.2286, 3.0012> <-5.4033, 19.2286, 3.0012> <-5.3745, 19.2574, 3.0012>
		<-6.3889, 19.2574, 3.0528> <-6.3601, 19.2286, 3.0528> <-5.4033, 19.2286, 3.0528> <-5.3745, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4577, 19.3406, 2.9276> <-5.4336, 19.3647, 2.9276> <-5.4336, 20.1645, 2.9276> <-5.4577, 20.1885, 2.9276>
		<-5.4746, 19.3576, 2.9732> <-5.4506, 19.3816, 2.9732> <-5.4506, 20.1475, 2.9732> <-5.4746, 20.1716, 2.9732>
		<-5.3745, 19.2574, 3.0012> <-5.3456, 19.2862, 3.0012> <-5.3456, 20.2430, 3.0012> <-5.3745, 20.2718, 3.0012>
		<-5.3745, 19.2574, 3.0528> <-5.3456, 19.2862, 3.0528> <-5.3456, 20.2430, 3.0528> <-5.3745, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4577, 20.1885, 2.9276> <-5.4818, 20.2126, 2.9276> <-6.2815, 20.2126, 2.9276> <-6.3056, 20.1885, 2.9276>
		<-5.4746, 20.1716, 2.9732> <-5.4987, 20.1957, 2.9732> <-6.2646, 20.1957, 2.9732> <-6.2887, 20.1716, 2.9732>
		<-5.3745, 20.2718, 3.0012> <-5.4033, 20.3006, 3.0012> <-6.3601, 20.3006, 3.0012> <-6.3889, 20.2718, 3.0012>
		<-5.3745, 20.2718, 3.0528> <-5.4033, 20.3006, 3.0528> <-6.3601, 20.3006, 3.0528> <-6.3889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3889, 19.2574, 3.0528> <-6.3889, 19.2574, 3.1044> <-6.2862, 19.3600, 3.1344> <-6.3056, 19.3406, 3.1780>
		<-6.4177, 19.2862, 3.0528> <-6.4177, 19.2862, 3.1044> <-6.3103, 19.3841, 3.1344> <-6.3297, 19.3647, 3.1780>
		<-6.4177, 20.2430, 3.0528> <-6.4177, 20.2430, 3.1044> <-6.3103, 20.1451, 3.1344> <-6.3297, 20.1645, 3.1780>
		<-6.3889, 20.2718, 3.0528> <-6.3889, 20.2718, 3.1044> <-6.2862, 20.1691, 3.1344> <-6.3056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3889, 19.2574, 3.0528> <-6.3601, 19.2286, 3.0528> <-5.4033, 19.2286, 3.0528> <-5.3745, 19.2574, 3.0528>
		<-6.3889, 19.2574, 3.1044> <-6.3601, 19.2286, 3.1044> <-5.4033, 19.2286, 3.1044> <-5.3745, 19.2574, 3.1044>
		<-6.2862, 19.3600, 3.1344> <-6.2621, 19.3359, 3.1344> <-5.5012, 19.3359, 3.1344> <-5.4771, 19.3600, 3.1344>
		<-6.3056, 19.3406, 3.1780> <-6.2815, 19.3165, 3.1780> <-5.4818, 19.3165, 3.1780> <-5.4577, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3745, 19.2574, 3.0528> <-5.3456, 19.2862, 3.0528> <-5.3456, 20.2430, 3.0528> <-5.3745, 20.2718, 3.0528>
		<-5.3745, 19.2574, 3.1044> <-5.3456, 19.2862, 3.1044> <-5.3456, 20.2430, 3.1044> <-5.3745, 20.2718, 3.1044>
		<-5.4771, 19.3600, 3.1344> <-5.4530, 19.3841, 3.1344> <-5.4530, 20.1451, 3.1344> <-5.4771, 20.1691, 3.1344>
		<-5.4577, 19.3406, 3.1780> <-5.4336, 19.3647, 3.1780> <-5.4336, 20.1645, 3.1780> <-5.4577, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3745, 20.2718, 3.0528> <-5.4033, 20.3006, 3.0528> <-6.3601, 20.3006, 3.0528> <-6.3889, 20.2718, 3.0528>
		<-5.3745, 20.2718, 3.1044> <-5.4033, 20.3006, 3.1044> <-6.3601, 20.3006, 3.1044> <-6.3889, 20.2718, 3.1044>
		<-5.4771, 20.1691, 3.1344> <-5.5012, 20.1932, 3.1344> <-6.2621, 20.1932, 3.1344> <-6.2862, 20.1691, 3.1344>
		<-5.4577, 20.1885, 3.1780> <-5.4818, 20.2126, 3.1780> <-6.2815, 20.2126, 3.1780> <-6.3056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3056, 19.3406, 3.1780> <-6.3438, 19.3024, 3.2640> <-6.4610, 19.1852, 3.2738> <-6.5161, 19.1302, 3.3390>
		<-6.3297, 19.3647, 3.1780> <-6.3679, 19.3265, 3.2640> <-6.4971, 19.2212, 3.2738> <-6.5521, 19.1662, 3.3390>
		<-6.3297, 20.1645, 3.1780> <-6.3679, 20.2027, 3.2640> <-6.4971, 20.3079, 3.2738> <-6.5521, 20.3629, 3.3390>
		<-6.3056, 20.1885, 3.1780> <-6.3438, 20.2267, 3.2640> <-6.4610, 20.3440, 3.2738> <-6.5161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3056, 19.3406, 3.1780> <-6.2815, 19.3165, 3.1780> <-5.4818, 19.3165, 3.1780> <-5.4577, 19.3406, 3.1780>
		<-6.3438, 19.3024, 3.2640> <-6.3197, 19.2784, 3.2640> <-5.4436, 19.2784, 3.2640> <-5.4195, 19.3024, 3.2640>
		<-6.4610, 19.1852, 3.2738> <-6.4250, 19.1492, 3.2738> <-5.3383, 19.1492, 3.2738> <-5.3023, 19.1852, 3.2738>
		<-6.5161, 19.1302, 3.3390> <-6.4800, 19.0942, 3.3390> <-5.2833, 19.0942, 3.3390> <-5.2473, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4577, 19.3406, 3.1780> <-5.4336, 19.3647, 3.1780> <-5.4336, 20.1645, 3.1780> <-5.4577, 20.1885, 3.1780>
		<-5.4195, 19.3024, 3.2640> <-5.3954, 19.3265, 3.2640> <-5.3954, 20.2027, 3.2640> <-5.4195, 20.2267, 3.2640>
		<-5.3023, 19.1852, 3.2738> <-5.2663, 19.2212, 3.2738> <-5.2663, 20.3079, 3.2738> <-5.3023, 20.3440, 3.2738>
		<-5.2473, 19.1302, 3.3390> <-5.2112, 19.1662, 3.3390> <-5.2112, 20.3629, 3.3390> <-5.2473, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4577, 20.1885, 3.1780> <-5.4818, 20.2126, 3.1780> <-6.2815, 20.2126, 3.1780> <-6.3056, 20.1885, 3.1780>
		<-5.4195, 20.2267, 3.2640> <-5.4436, 20.2508, 3.2640> <-6.3197, 20.2508, 3.2640> <-6.3438, 20.2267, 3.2640>
		<-5.3023, 20.3440, 3.2738> <-5.3383, 20.3800, 3.2738> <-6.4250, 20.3800, 3.2738> <-6.4610, 20.3440, 3.2738>
		<-5.2473, 20.3990, 3.3390> <-5.2833, 20.4350, 3.3390> <-6.4800, 20.4350, 3.3390> <-6.5161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5161, 19.1302, 3.3390> <-6.5416, 19.1046, 3.3693> <-6.5797, 19.0665, 3.4419> <-6.5623, 19.0839, 3.4821>
		<-6.5521, 19.1662, 3.3390> <-6.5777, 19.1406, 3.3693> <-6.6184, 19.1052, 3.4419> <-6.6010, 19.1226, 3.4821>
		<-6.5521, 20.3629, 3.3390> <-6.5777, 20.3885, 3.3693> <-6.6184, 20.4240, 3.4419> <-6.6010, 20.4066, 3.4821>
		<-6.5161, 20.3990, 3.3390> <-6.5416, 20.4246, 3.3693> <-6.5797, 20.4627, 3.4419> <-6.5623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5161, 19.1302, 3.3390> <-6.4800, 19.0942, 3.3390> <-5.2833, 19.0942, 3.3390> <-5.2473, 19.1302, 3.3390>
		<-6.5416, 19.1046, 3.3693> <-6.5056, 19.0686, 3.3693> <-5.2577, 19.0686, 3.3693> <-5.2217, 19.1046, 3.3693>
		<-6.5797, 19.0665, 3.4419> <-6.5411, 19.0279, 3.4419> <-5.2223, 19.0279, 3.4419> <-5.1836, 19.0665, 3.4419>
		<-6.5623, 19.0839, 3.4821> <-6.5236, 19.0453, 3.4821> <-5.2397, 19.0453, 3.4821> <-5.2010, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2473, 19.1302, 3.3390> <-5.2112, 19.1662, 3.3390> <-5.2112, 20.3629, 3.3390> <-5.2473, 20.3990, 3.3390>
		<-5.2217, 19.1046, 3.3693> <-5.1857, 19.1406, 3.3693> <-5.1857, 20.3885, 3.3693> <-5.2217, 20.4246, 3.3693>
		<-5.1836, 19.0665, 3.4419> <-5.1449, 19.1052, 3.4419> <-5.1449, 20.4240, 3.4419> <-5.1836, 20.4627, 3.4419>
		<-5.2010, 19.0839, 3.4821> <-5.1624, 19.1226, 3.4821> <-5.1624, 20.4066, 3.4821> <-5.2010, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2473, 20.3990, 3.3390> <-5.2833, 20.4350, 3.3390> <-6.4800, 20.4350, 3.3390> <-6.5161, 20.3990, 3.3390>
		<-5.2217, 20.4246, 3.3693> <-5.2577, 20.4606, 3.3693> <-6.5056, 20.4606, 3.3693> <-6.5416, 20.4246, 3.3693>
		<-5.1836, 20.4627, 3.4419> <-5.2223, 20.5013, 3.4419> <-6.5411, 20.5013, 3.4419> <-6.5797, 20.4627, 3.4419>
		<-5.2010, 20.4452, 3.4821> <-5.2397, 20.4839, 3.4821> <-6.5236, 20.4839, 3.4821> <-6.5623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5623, 19.0839, 3.4821> <-6.5163, 19.1300, 3.5884> <-6.3961, 19.2502, 3.6567> <-6.3380, 19.3083, 3.7504>
		<-6.6010, 19.1226, 3.4821> <-6.5550, 19.1686, 3.5884> <-6.4220, 19.2761, 3.6567> <-6.3639, 19.3342, 3.7504>
		<-6.6010, 20.4066, 3.4821> <-6.5550, 20.3606, 3.5884> <-6.4220, 20.2531, 3.6567> <-6.3639, 20.1950, 3.7504>
		<-6.5623, 20.4452, 3.4821> <-6.5163, 20.3992, 3.5884> <-6.3961, 20.2790, 3.6567> <-6.3380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5623, 19.0839, 3.4821> <-6.5236, 19.0453, 3.4821> <-5.2397, 19.0453, 3.4821> <-5.2010, 19.0839, 3.4821>
		<-6.5163, 19.1300, 3.5884> <-6.4776, 19.0913, 3.5884> <-5.2857, 19.0913, 3.5884> <-5.2470, 19.1300, 3.5884>
		<-6.3961, 19.2502, 3.6567> <-6.3702, 19.2242, 3.6567> <-5.3932, 19.2242, 3.6567> <-5.3672, 19.2502, 3.6567>
		<-6.3380, 19.3083, 3.7504> <-6.3121, 19.2823, 3.7504> <-5.4513, 19.2823, 3.7504> <-5.4253, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2010, 19.0839, 3.4821> <-5.1624, 19.1226, 3.4821> <-5.1624, 20.4066, 3.4821> <-5.2010, 20.4452, 3.4821>
		<-5.2470, 19.1300, 3.5884> <-5.2084, 19.1686, 3.5884> <-5.2084, 20.3606, 3.5884> <-5.2470, 20.3992, 3.5884>
		<-5.3672, 19.2502, 3.6567> <-5.3413, 19.2761, 3.6567> <-5.3413, 20.2531, 3.6567> <-5.3672, 20.2790, 3.6567>
		<-5.4253, 19.3083, 3.7504> <-5.3994, 19.3342, 3.7504> <-5.3994, 20.1950, 3.7504> <-5.4253, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2010, 20.4452, 3.4821> <-5.2397, 20.4839, 3.4821> <-6.5236, 20.4839, 3.4821> <-6.5623, 20.4452, 3.4821>
		<-5.2470, 20.3992, 3.5884> <-5.2857, 20.4379, 3.5884> <-6.4776, 20.4379, 3.5884> <-6.5163, 20.3992, 3.5884>
		<-5.3672, 20.2790, 3.6567> <-5.3932, 20.3049, 3.6567> <-6.3702, 20.3049, 3.6567> <-6.3961, 20.2790, 3.6567>
		<-5.4253, 20.2209, 3.7504> <-5.4513, 20.2468, 3.7504> <-6.3121, 20.2468, 3.7504> <-6.3380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3380, 19.3083, 3.7504> <-6.2964, 19.3498, 3.8175> <-6.2527, 19.3935, 3.9241> <-6.2352, 19.4110, 4.0098>
		<-6.3639, 19.3342, 3.7504> <-6.3223, 19.3757, 3.8175> <-6.2728, 19.4136, 3.9241> <-6.2553, 19.4311, 4.0098>
		<-6.3639, 20.1950, 3.7504> <-6.3223, 20.1534, 3.8175> <-6.2728, 20.1156, 3.9241> <-6.2553, 20.0981, 4.0098>
		<-6.3380, 20.2209, 3.7504> <-6.2964, 20.1793, 3.8175> <-6.2527, 20.1356, 3.9241> <-6.2352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.3380, 19.3083, 3.7504> <-6.3121, 19.2823, 3.7504> <-5.4513, 19.2823, 3.7504> <-5.4253, 19.3083, 3.7504>
		<-6.2964, 19.3498, 3.8175> <-6.2705, 19.3239, 3.8175> <-5.4928, 19.3239, 3.8175> <-5.4669, 19.3498, 3.8175>
		<-6.2527, 19.3935, 3.9241> <-6.2326, 19.3734, 3.9241> <-5.5307, 19.3734, 3.9241> <-5.5106, 19.3935, 3.9241>
		<-6.2352, 19.4110, 4.0098> <-6.2152, 19.3909, 4.0098> <-5.5482, 19.3909, 4.0098> <-5.5281, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4253, 19.3083, 3.7504> <-5.3994, 19.3342, 3.7504> <-5.3994, 20.1950, 3.7504> <-5.4253, 20.2209, 3.7504>
		<-5.4669, 19.3498, 3.8175> <-5.4410, 19.3757, 3.8175> <-5.4410, 20.1534, 3.8175> <-5.4669, 20.1793, 3.8175>
		<-5.5106, 19.3935, 3.9241> <-5.4905, 19.4136, 3.9241> <-5.4905, 20.1156, 3.9241> <-5.5106, 20.1356, 3.9241>
		<-5.5281, 19.4110, 4.0098> <-5.5080, 19.4311, 4.0098> <-5.5080, 20.0981, 4.0098> <-5.5281, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4253, 20.2209, 3.7504> <-5.4513, 20.2468, 3.7504> <-6.3121, 20.2468, 3.7504> <-6.3380, 20.2209, 3.7504>
		<-5.4669, 20.1793, 3.8175> <-5.4928, 20.2053, 3.8175> <-6.2705, 20.2053, 3.8175> <-6.2964, 20.1793, 3.8175>
		<-5.5106, 20.1356, 3.9241> <-5.5307, 20.1557, 3.9241> <-6.2326, 20.1557, 3.9241> <-6.2527, 20.1356, 3.9241>
		<-5.5281, 20.1182, 4.0098> <-5.5482, 20.1383, 4.0098> <-6.2152, 20.1383, 4.0098> <-6.2352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2352, 19.4110, 4.0098> <-6.2168, 19.4294, 4.1002> <-6.2221, 19.4242, 4.2288> <-6.2213, 19.4250, 4.3229>
		<-6.2553, 19.4311, 4.0098> <-6.2369, 19.4495, 4.1002> <-6.2413, 19.4435, 4.2288> <-6.2405, 19.4443, 4.3229>
		<-6.2553, 20.0981, 4.0098> <-6.2369, 20.0797, 4.1002> <-6.2413, 20.0857, 4.2288> <-6.2405, 20.0849, 4.3229>
		<-6.2352, 20.1182, 4.0098> <-6.2168, 20.0997, 4.1002> <-6.2221, 20.1050, 4.2288> <-6.2213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2352, 19.4110, 4.0098> <-6.2152, 19.3909, 4.0098> <-5.5482, 19.3909, 4.0098> <-5.5281, 19.4110, 4.0098>
		<-6.2168, 19.4294, 4.1002> <-6.1967, 19.4094, 4.1002> <-5.5666, 19.4094, 4.1002> <-5.5465, 19.4294, 4.1002>
		<-6.2221, 19.4242, 4.2288> <-6.2028, 19.4049, 4.2288> <-5.5606, 19.4049, 4.2288> <-5.5413, 19.4242, 4.2288>
		<-6.2213, 19.4250, 4.3229> <-6.2020, 19.4057, 4.3229> <-5.5614, 19.4057, 4.3229> <-5.5421, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5281, 19.4110, 4.0098> <-5.5080, 19.4311, 4.0098> <-5.5080, 20.0981, 4.0098> <-5.5281, 20.1182, 4.0098>
		<-5.5465, 19.4294, 4.1002> <-5.5264, 19.4495, 4.1002> <-5.5264, 20.0797, 4.1002> <-5.5465, 20.0997, 4.1002>
		<-5.5413, 19.4242, 4.2288> <-5.5220, 19.4435, 4.2288> <-5.5220, 20.0857, 4.2288> <-5.5413, 20.1050, 4.2288>
		<-5.5421, 19.4250, 4.3229> <-5.5228, 19.4443, 4.3229> <-5.5228, 20.0849, 4.3229> <-5.5421, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5281, 20.1182, 4.0098> <-5.5482, 20.1383, 4.0098> <-6.2152, 20.1383, 4.0098> <-6.2352, 20.1182, 4.0098>
		<-5.5465, 20.0997, 4.1002> <-5.5666, 20.1198, 4.1002> <-6.1967, 20.1198, 4.1002> <-6.2168, 20.0997, 4.1002>
		<-5.5413, 20.1050, 4.2288> <-5.5606, 20.1243, 4.2288> <-6.2028, 20.1243, 4.2288> <-6.2221, 20.1050, 4.2288>
		<-5.5421, 20.1042, 4.3229> <-5.5614, 20.1235, 4.3229> <-6.2020, 20.1235, 4.3229> <-6.2213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2213, 19.4250, 4.3229> <-6.2179, 19.4284, 4.7283> <-6.2197, 19.4265, 5.2689> <-6.2213, 19.4250, 5.6744>
		<-6.2405, 19.4443, 4.3229> <-6.2371, 19.4477, 4.7283> <-6.2390, 19.4458, 5.2689> <-6.2405, 19.4443, 5.6744>
		<-6.2405, 20.0849, 4.3229> <-6.2371, 20.0815, 4.7283> <-6.2390, 20.0834, 5.2689> <-6.2405, 20.0849, 5.6744>
		<-6.2213, 20.1042, 4.3229> <-6.2179, 20.1008, 4.7283> <-6.2197, 20.1027, 5.2689> <-6.2213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2213, 19.4250, 4.3229> <-6.2020, 19.4057, 4.3229> <-5.5614, 19.4057, 4.3229> <-5.5421, 19.4250, 4.3229>
		<-6.2179, 19.4284, 4.7283> <-6.1986, 19.4091, 4.7283> <-5.5648, 19.4091, 4.7283> <-5.5455, 19.4284, 4.7283>
		<-6.2197, 19.4265, 5.2689> <-6.2004, 19.4072, 5.2689> <-5.5629, 19.4072, 5.2689> <-5.5436, 19.4265, 5.2689>
		<-6.2213, 19.4250, 5.6744> <-6.2020, 19.4057, 5.6744> <-5.5614, 19.4057, 5.6744> <-5.5421, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5421, 19.4250, 4.3229> <-5.5228, 19.4443, 4.3229> <-5.5228, 20.0849, 4.3229> <-5.5421, 20.1042, 4.3229>
		<-5.5455, 19.4284, 4.7283> <-5.5262, 19.4477, 4.7283> <-5.5262, 20.0815, 4.7283> <-5.5455, 20.1008, 4.7283>
		<-5.5436, 19.4265, 5.2689> <-5.5243, 19.4458, 5.2689> <-5.5243, 20.0834, 5.2689> <-5.5436, 20.1027, 5.2689>
		<-5.5421, 19.4250, 5.6744> <-5.5228, 19.4443, 5.6744> <-5.5228, 20.0849, 5.6744> <-5.5421, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5421, 20.1042, 4.3229> <-5.5614, 20.1235, 4.3229> <-6.2020, 20.1235, 4.3229> <-6.2213, 20.1042, 4.3229>
		<-5.5455, 20.1008, 4.7283> <-5.5648, 20.1201, 4.7283> <-6.1986, 20.1201, 4.7283> <-6.2179, 20.1008, 4.7283>
		<-5.5436, 20.1027, 5.2689> <-5.5629, 20.1220, 5.2689> <-6.2004, 20.1220, 5.2689> <-6.2197, 20.1027, 5.2689>
		<-5.5421, 20.1042, 5.6744> <-5.5614, 20.1235, 5.6744> <-6.2020, 20.1235, 5.6744> <-6.2213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2213, 19.4250, 5.6744> <-6.2225, 19.4237, 6.0073> <-6.2172, 19.4290, 6.4517> <-6.2305, 19.4157, 6.7841>
		<-6.2405, 19.4443, 5.6744> <-6.2418, 19.4430, 6.0073> <-6.2371, 19.4488, 6.4517> <-6.2503, 19.4355, 6.7841>
		<-6.2405, 20.0849, 5.6744> <-6.2418, 20.0861, 6.0073> <-6.2371, 20.0804, 6.4517> <-6.2503, 20.0936, 6.7841>
		<-6.2213, 20.1042, 5.6744> <-6.2225, 20.1054, 6.0073> <-6.2172, 20.1002, 6.4517> <-6.2305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2213, 19.4250, 5.6744> <-6.2020, 19.4057, 5.6744> <-5.5614, 19.4057, 5.6744> <-5.5421, 19.4250, 5.6744>
		<-6.2225, 19.4237, 6.0073> <-6.2032, 19.4044, 6.0073> <-5.5601, 19.4044, 6.0073> <-5.5408, 19.4237, 6.0073>
		<-6.2172, 19.4290, 6.4517> <-6.1974, 19.4092, 6.4517> <-5.5659, 19.4092, 6.4517> <-5.5461, 19.4290, 6.4517>
		<-6.2305, 19.4157, 6.7841> <-6.2107, 19.3959, 6.7841> <-5.5526, 19.3959, 6.7841> <-5.5328, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5421, 19.4250, 5.6744> <-5.5228, 19.4443, 5.6744> <-5.5228, 20.0849, 5.6744> <-5.5421, 20.1042, 5.6744>
		<-5.5408, 19.4237, 6.0073> <-5.5215, 19.4430, 6.0073> <-5.5215, 20.0861, 6.0073> <-5.5408, 20.1054, 6.0073>
		<-5.5461, 19.4290, 6.4517> <-5.5263, 19.4488, 6.4517> <-5.5263, 20.0804, 6.4517> <-5.5461, 20.1002, 6.4517>
		<-5.5328, 19.4157, 6.7841> <-5.5130, 19.4355, 6.7841> <-5.5130, 20.0936, 6.7841> <-5.5328, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5421, 20.1042, 5.6744> <-5.5614, 20.1235, 5.6744> <-6.2020, 20.1235, 5.6744> <-6.2213, 20.1042, 5.6744>
		<-5.5408, 20.1054, 6.0073> <-5.5601, 20.1247, 6.0073> <-6.2032, 20.1247, 6.0073> <-6.2225, 20.1054, 6.0073>
		<-5.5461, 20.1002, 6.4517> <-5.5659, 20.1200, 6.4517> <-6.1974, 20.1200, 6.4517> <-6.2172, 20.1002, 6.4517>
		<-5.5328, 20.1134, 6.7841> <-5.5526, 20.1333, 6.7841> <-6.2107, 20.1333, 6.7841> <-6.2305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2305, 19.4157, 6.7841> <-6.2325, 19.4137, 6.8341> <-6.2449, 19.4013, 6.9079> <-6.2718, 19.3745, 6.9405>
		<-6.2503, 19.4355, 6.7841> <-6.2523, 19.4336, 6.8341> <-6.2671, 19.4235, 6.9079> <-6.2940, 19.3966, 6.9405>
		<-6.2503, 20.0936, 6.7841> <-6.2523, 20.0956, 6.8341> <-6.2671, 20.1057, 6.9079> <-6.2940, 20.1326, 6.9405>
		<-6.2305, 20.1134, 6.7841> <-6.2325, 20.1154, 6.8341> <-6.2449, 20.1278, 6.9079> <-6.2718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2305, 19.4157, 6.7841> <-6.2107, 19.3959, 6.7841> <-5.5526, 19.3959, 6.7841> <-5.5328, 19.4157, 6.7841>
		<-6.2325, 19.4137, 6.8341> <-6.2127, 19.3939, 6.8341> <-5.5506, 19.3939, 6.8341> <-5.5308, 19.4137, 6.8341>
		<-6.2449, 19.4013, 6.9079> <-6.2228, 19.3792, 6.9079> <-5.5406, 19.3792, 6.9079> <-5.5184, 19.4013, 6.9079>
		<-6.2718, 19.3745, 6.9405> <-6.2496, 19.3523, 6.9405> <-5.5137, 19.3523, 6.9405> <-5.4915, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5328, 19.4157, 6.7841> <-5.5130, 19.4355, 6.7841> <-5.5130, 20.0936, 6.7841> <-5.5328, 20.1134, 6.7841>
		<-5.5308, 19.4137, 6.8341> <-5.5110, 19.4336, 6.8341> <-5.5110, 20.0956, 6.8341> <-5.5308, 20.1154, 6.8341>
		<-5.5184, 19.4013, 6.9079> <-5.4962, 19.4235, 6.9079> <-5.4962, 20.1057, 6.9079> <-5.5184, 20.1278, 6.9079>
		<-5.4915, 19.3745, 6.9405> <-5.4694, 19.3966, 6.9405> <-5.4694, 20.1326, 6.9405> <-5.4915, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.5328, 20.1134, 6.7841> <-5.5526, 20.1333, 6.7841> <-6.2107, 20.1333, 6.7841> <-6.2305, 20.1134, 6.7841>
		<-5.5308, 20.1154, 6.8341> <-5.5506, 20.1352, 6.8341> <-6.2127, 20.1352, 6.8341> <-6.2325, 20.1154, 6.8341>
		<-5.5184, 20.1278, 6.9079> <-5.5406, 20.1500, 6.9079> <-6.2228, 20.1500, 6.9079> <-6.2449, 20.1278, 6.9079>
		<-5.4915, 20.1547, 6.9405> <-5.5137, 20.1769, 6.9405> <-6.2496, 20.1769, 6.9405> <-6.2718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2718, 19.3745, 6.9405> <-6.3339, 19.3123, 7.0160> <-6.4620, 19.1842, 7.0331> <-6.5114, 19.1348, 7.1255>
		<-6.2940, 19.3966, 6.9405> <-6.3561, 19.3345, 7.0160> <-6.4978, 19.2200, 7.0331> <-6.5472, 19.1706, 7.1255>
		<-6.2940, 20.1326, 6.9405> <-6.3561, 20.1947, 7.0160> <-6.4978, 20.3092, 7.0331> <-6.5472, 20.3586, 7.1255>
		<-6.2718, 20.1547, 6.9405> <-6.3339, 20.2168, 7.0160> <-6.4620, 20.3449, 7.0331> <-6.5114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.2718, 19.3745, 6.9405> <-6.2496, 19.3523, 6.9405> <-5.5137, 19.3523, 6.9405> <-5.4915, 19.3745, 6.9405>
		<-6.3339, 19.3123, 7.0160> <-6.3117, 19.2902, 7.0160> <-5.4516, 19.2902, 7.0160> <-5.4294, 19.3123, 7.0160>
		<-6.4620, 19.1842, 7.0331> <-6.4262, 19.1485, 7.0331> <-5.3371, 19.1485, 7.0331> <-5.3013, 19.1842, 7.0331>
		<-6.5114, 19.1348, 7.1255> <-6.4757, 19.0990, 7.1255> <-5.2877, 19.0990, 7.1255> <-5.2519, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4915, 19.3745, 6.9405> <-5.4694, 19.3966, 6.9405> <-5.4694, 20.1326, 6.9405> <-5.4915, 20.1547, 6.9405>
		<-5.4294, 19.3123, 7.0160> <-5.4073, 19.3345, 7.0160> <-5.4073, 20.1947, 7.0160> <-5.4294, 20.2168, 7.0160>
		<-5.3013, 19.1842, 7.0331> <-5.2655, 19.2200, 7.0331> <-5.2655, 20.3092, 7.0331> <-5.3013, 20.3449, 7.0331>
		<-5.2519, 19.1348, 7.1255> <-5.2161, 19.1706, 7.1255> <-5.2161, 20.3586, 7.1255> <-5.2519, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.4915, 20.1547, 6.9405> <-5.5137, 20.1769, 6.9405> <-6.2496, 20.1769, 6.9405> <-6.2718, 20.1547, 6.9405>
		<-5.4294, 20.2168, 7.0160> <-5.4516, 20.2390, 7.0160> <-6.3117, 20.2390, 7.0160> <-6.3339, 20.2168, 7.0160>
		<-5.3013, 20.3449, 7.0331> <-5.3371, 20.3807, 7.0331> <-6.4262, 20.3807, 7.0331> <-6.4620, 20.3449, 7.0331>
		<-5.2519, 20.3944, 7.1255> <-5.2877, 20.4301, 7.1255> <-6.4757, 20.4301, 7.1255> <-6.5114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5114, 19.1348, 7.1255> <-6.5319, 19.1143, 7.1638> <-6.4316, 19.2146, 7.1912> <-6.4316, 19.2146, 7.2393>
		<-6.5472, 19.1706, 7.1255> <-6.5677, 19.1501, 7.1638> <-6.4629, 19.2459, 7.1912> <-6.4629, 19.2459, 7.2393>
		<-6.5472, 20.3586, 7.1255> <-6.5677, 20.3791, 7.1638> <-6.4629, 20.2833, 7.1912> <-6.4629, 20.2833, 7.2393>
		<-6.5114, 20.3944, 7.1255> <-6.5319, 20.4149, 7.1638> <-6.4316, 20.3146, 7.1912> <-6.4316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5114, 19.1348, 7.1255> <-6.4757, 19.0990, 7.1255> <-5.2877, 19.0990, 7.1255> <-5.2519, 19.1348, 7.1255>
		<-6.5319, 19.1143, 7.1638> <-6.4962, 19.0785, 7.1638> <-5.2671, 19.0785, 7.1638> <-5.2314, 19.1143, 7.1638>
		<-6.4316, 19.2146, 7.1912> <-6.4004, 19.1834, 7.1912> <-5.3629, 19.1834, 7.1912> <-5.3317, 19.2146, 7.1912>
		<-6.4316, 19.2146, 7.2393> <-6.4004, 19.1834, 7.2393> <-5.3629, 19.1834, 7.2393> <-5.3317, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2519, 19.1348, 7.1255> <-5.2161, 19.1706, 7.1255> <-5.2161, 20.3586, 7.1255> <-5.2519, 20.3944, 7.1255>
		<-5.2314, 19.1143, 7.1638> <-5.1956, 19.1501, 7.1638> <-5.1956, 20.3791, 7.1638> <-5.2314, 20.4149, 7.1638>
		<-5.3317, 19.2146, 7.1912> <-5.3005, 19.2459, 7.1912> <-5.3005, 20.2833, 7.1912> <-5.3317, 20.3146, 7.1912>
		<-5.3317, 19.2146, 7.2393> <-5.3005, 19.2459, 7.2393> <-5.3005, 20.2833, 7.2393> <-5.3317, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2519, 20.3944, 7.1255> <-5.2877, 20.4301, 7.1255> <-6.4757, 20.4301, 7.1255> <-6.5114, 20.3944, 7.1255>
		<-5.2314, 20.4149, 7.1638> <-5.2671, 20.4506, 7.1638> <-6.4962, 20.4506, 7.1638> <-6.5319, 20.4149, 7.1638>
		<-5.3317, 20.3146, 7.1912> <-5.3629, 20.3458, 7.1912> <-6.4004, 20.3458, 7.1912> <-6.4316, 20.3146, 7.1912>
		<-5.3317, 20.3146, 7.2393> <-5.3629, 20.3458, 7.2393> <-6.4004, 20.3458, 7.2393> <-6.4316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4316, 19.2146, 7.2393> <-6.4316, 19.2146, 7.2905> <-6.5054, 19.1408, 7.3169> <-6.5114, 19.1348, 7.3673>
		<-6.4629, 19.2459, 7.2393> <-6.4629, 19.2459, 7.2905> <-6.5412, 19.1766, 7.3169> <-6.5472, 19.1706, 7.3673>
		<-6.4629, 20.2833, 7.2393> <-6.4629, 20.2833, 7.2905> <-6.5412, 20.3526, 7.3169> <-6.5472, 20.3586, 7.3673>
		<-6.4316, 20.3146, 7.2393> <-6.4316, 20.3146, 7.2905> <-6.5054, 20.3883, 7.3169> <-6.5114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.4316, 19.2146, 7.2393> <-6.4004, 19.1834, 7.2393> <-5.3629, 19.1834, 7.2393> <-5.3317, 19.2146, 7.2393>
		<-6.4316, 19.2146, 7.2905> <-6.4004, 19.1834, 7.2905> <-5.3629, 19.1834, 7.2905> <-5.3317, 19.2146, 7.2905>
		<-6.5054, 19.1408, 7.3169> <-6.4696, 19.1051, 7.3169> <-5.2937, 19.1051, 7.3169> <-5.2579, 19.1408, 7.3169>
		<-6.5114, 19.1348, 7.3673> <-6.4757, 19.0990, 7.3673> <-5.2877, 19.0990, 7.3673> <-5.2519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3317, 19.2146, 7.2393> <-5.3005, 19.2459, 7.2393> <-5.3005, 20.2833, 7.2393> <-5.3317, 20.3146, 7.2393>
		<-5.3317, 19.2146, 7.2905> <-5.3005, 19.2459, 7.2905> <-5.3005, 20.2833, 7.2905> <-5.3317, 20.3146, 7.2905>
		<-5.2579, 19.1408, 7.3169> <-5.2222, 19.1766, 7.3169> <-5.2222, 20.3526, 7.3169> <-5.2579, 20.3883, 7.3169>
		<-5.2519, 19.1348, 7.3673> <-5.2161, 19.1706, 7.3673> <-5.2161, 20.3586, 7.3673> <-5.2519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.3317, 20.3146, 7.2393> <-5.3629, 20.3458, 7.2393> <-6.4004, 20.3458, 7.2393> <-6.4316, 20.3146, 7.2393>
		<-5.3317, 20.3146, 7.2905> <-5.3629, 20.3458, 7.2905> <-6.4004, 20.3458, 7.2905> <-6.4316, 20.3146, 7.2905>
		<-5.2579, 20.3883, 7.3169> <-5.2937, 20.4241, 7.3169> <-6.4696, 20.4241, 7.3169> <-6.5054, 20.3883, 7.3169>
		<-5.2519, 20.3944, 7.3673> <-5.2877, 20.4301, 7.3673> <-6.4757, 20.4301, 7.3673> <-6.5114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5114, 19.1348, 7.9080> <-6.5472, 19.1706, 7.9080> <-6.5472, 20.3586, 7.9080> <-6.5114, 20.3944, 7.9080>
		<-6.5114, 19.1348, 7.7458> <-6.5472, 19.1706, 7.7458> <-6.5472, 20.3586, 7.7458> <-6.5114, 20.3944, 7.7458>
		<-6.5305, 19.1157, 7.5273> <-6.5663, 19.1515, 7.5273> <-6.5663, 20.3777, 7.5273> <-6.5305, 20.4134, 7.5273>
		<-6.5114, 19.1348, 7.3673> <-6.5472, 19.1706, 7.3673> <-6.5472, 20.3586, 7.3673> <-6.5114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.5114, 19.1348, 7.9080> <-6.5114, 19.1348, 7.7458> <-6.5305, 19.1157, 7.5273> <-6.5114, 19.1348, 7.3673>
		<-6.4757, 19.0990, 7.9080> <-6.4757, 19.0990, 7.7458> <-6.4947, 19.0800, 7.5273> <-6.4757, 19.0990, 7.3673>
		<-5.2877, 19.0990, 7.9080> <-5.2877, 19.0990, 7.7458> <-5.2686, 19.0800, 7.5273> <-5.2877, 19.0990, 7.3673>
		<-5.2519, 19.1348, 7.9080> <-5.2519, 19.1348, 7.7458> <-5.2328, 19.1157, 7.5273> <-5.2519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2519, 19.1348, 7.9080> <-5.2519, 19.1348, 7.7458> <-5.2328, 19.1157, 7.5273> <-5.2519, 19.1348, 7.3673>
		<-5.2161, 19.1706, 7.9080> <-5.2161, 19.1706, 7.7458> <-5.1970, 19.1515, 7.5273> <-5.2161, 19.1706, 7.3673>
		<-5.2161, 20.3586, 7.9080> <-5.2161, 20.3586, 7.7458> <-5.1970, 20.3777, 7.5273> <-5.2161, 20.3586, 7.3673>
		<-5.2519, 20.3944, 7.9080> <-5.2519, 20.3944, 7.7458> <-5.2328, 20.4134, 7.5273> <-5.2519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.2519, 20.3944, 7.9080> <-5.2519, 20.3944, 7.7458> <-5.2328, 20.4134, 7.5273> <-5.2519, 20.3944, 7.3673>
		<-5.2877, 20.4301, 7.9080> <-5.2877, 20.4301, 7.7458> <-5.2686, 20.4492, 7.5273> <-5.2877, 20.4301, 7.3673>
		<-6.4757, 20.4301, 7.9080> <-6.4757, 20.4301, 7.7458> <-6.4947, 20.4492, 7.5273> <-6.4757, 20.4301, 7.3673>
		<-6.5114, 20.3944, 7.9080> <-6.5114, 20.3944, 7.7458> <-6.5305, 20.4134, 7.5273> <-6.5114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7589, 18.8874, 0.7771> <-6.8087, 18.9372, 0.7771> <-6.8087, 20.5920, 0.7771> <-6.7589, 20.6418, 0.7771>
		<-6.7796, 18.8666, 0.6520> <-6.8294, 18.9164, 0.6520> <-6.8294, 20.6127, 0.6520> <-6.7796, 20.6626, 0.6520>
		<-6.7589, 18.8874, 0.4772> <-6.8087, 18.9372, 0.4772> <-6.8087, 20.5920, 0.4772> <-6.7589, 20.6418, 0.4772>
		<-6.7589, 18.8874, 0.3486> <-6.8087, 18.9372, 0.3486> <-6.8087, 20.5920, 0.3486> <-6.7589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7589, 18.8874, 0.7771> <-6.7796, 18.8666, 0.6520> <-6.7589, 18.8874, 0.4772> <-6.7589, 18.8874, 0.3486>
		<-6.7090, 18.8376, 0.7771> <-6.7298, 18.8168, 0.6520> <-6.7090, 18.8376, 0.4772> <-6.7090, 18.8376, 0.3486>
		<-5.0543, 18.8376, 0.7771> <-5.0335, 18.8168, 0.6520> <-5.0543, 18.8376, 0.4772> <-5.0543, 18.8376, 0.3486>
		<-5.0045, 18.8874, 0.7771> <-4.9837, 18.8666, 0.6520> <-5.0045, 18.8874, 0.4772> <-5.0045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0045, 18.8874, 0.7771> <-4.9837, 18.8666, 0.6520> <-5.0045, 18.8874, 0.4772> <-5.0045, 18.8874, 0.3486>
		<-4.9546, 18.9372, 0.7771> <-4.9339, 18.9164, 0.6520> <-4.9546, 18.9372, 0.4772> <-4.9546, 18.9372, 0.3486>
		<-4.9546, 20.5920, 0.7771> <-4.9339, 20.6127, 0.6520> <-4.9546, 20.5920, 0.4772> <-4.9546, 20.5920, 0.3486>
		<-5.0045, 20.6418, 0.7771> <-4.9837, 20.6626, 0.6520> <-5.0045, 20.6418, 0.4772> <-5.0045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0045, 20.6418, 0.7771> <-4.9837, 20.6626, 0.6520> <-5.0045, 20.6418, 0.4772> <-5.0045, 20.6418, 0.3486>
		<-5.0543, 20.6916, 0.7771> <-5.0335, 20.7124, 0.6520> <-5.0543, 20.6916, 0.4772> <-5.0543, 20.6916, 0.3486>
		<-6.7090, 20.6916, 0.7771> <-6.7298, 20.7124, 0.6520> <-6.7090, 20.6916, 0.4772> <-6.7090, 20.6916, 0.3486>
		<-6.7589, 20.6418, 0.7771> <-6.7796, 20.6626, 0.6520> <-6.7589, 20.6418, 0.4772> <-6.7589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7589, 18.8874, -0.0618> <-6.7589, 18.8874, 0.0613> <-6.7589, 18.8874, 0.2255> <-6.7589, 18.8874, 0.3486>
		<-6.8087, 18.9372, -0.0618> <-6.8087, 18.9372, 0.0613> <-6.8087, 18.9372, 0.2255> <-6.8087, 18.9372, 0.3486>
		<-6.8087, 20.5920, -0.0618> <-6.8087, 20.5920, 0.0613> <-6.8087, 20.5920, 0.2255> <-6.8087, 20.5920, 0.3486>
		<-6.7589, 20.6418, -0.0618> <-6.7589, 20.6418, 0.0613> <-6.7589, 20.6418, 0.2255> <-6.7589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.7589, 18.8874, -0.0618> <-6.7090, 18.8376, -0.0618> <-5.0543, 18.8376, -0.0618> <-5.0045, 18.8874, -0.0618>
		<-6.7589, 18.8874, 0.0613> <-6.7090, 18.8376, 0.0613> <-5.0543, 18.8376, 0.0613> <-5.0045, 18.8874, 0.0613>
		<-6.7589, 18.8874, 0.2255> <-6.7090, 18.8376, 0.2255> <-5.0543, 18.8376, 0.2255> <-5.0045, 18.8874, 0.2255>
		<-6.7589, 18.8874, 0.3486> <-6.7090, 18.8376, 0.3486> <-5.0543, 18.8376, 0.3486> <-5.0045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0045, 18.8874, -0.0618> <-4.9546, 18.9372, -0.0618> <-4.9546, 20.5920, -0.0618> <-5.0045, 20.6418, -0.0618>
		<-5.0045, 18.8874, 0.0613> <-4.9546, 18.9372, 0.0613> <-4.9546, 20.5920, 0.0613> <-5.0045, 20.6418, 0.0613>
		<-5.0045, 18.8874, 0.2255> <-4.9546, 18.9372, 0.2255> <-4.9546, 20.5920, 0.2255> <-5.0045, 20.6418, 0.2255>
		<-5.0045, 18.8874, 0.3486> <-4.9546, 18.9372, 0.3486> <-4.9546, 20.5920, 0.3486> <-5.0045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.0045, 20.6418, -0.0618> <-5.0543, 20.6916, -0.0618> <-6.7090, 20.6916, -0.0618> <-6.7589, 20.6418, -0.0618>
		<-5.0045, 20.6418, 0.0613> <-5.0543, 20.6916, 0.0613> <-6.7090, 20.6916, 0.0613> <-6.7589, 20.6418, 0.0613>
		<-5.0045, 20.6418, 0.2255> <-5.0543, 20.6916, 0.2255> <-6.7090, 20.6916, 0.2255> <-6.7589, 20.6418, 0.2255>
		<-5.0045, 20.6418, 0.3486> <-5.0543, 20.6916, 0.3486> <-6.7090, 20.6916, 0.3486> <-6.7589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 0.9062> <-4.5109, 19.0245, 0.9062> <-4.5109, 20.5047, 0.9062> <-4.4664, 20.5493, 0.9062>
		<-4.4712, 18.9751, 0.8515> <-4.5157, 19.0196, 0.8515> <-4.5157, 20.5095, 0.8515> <-4.4712, 20.5541, 0.8515>
		<-4.5500, 18.8963, 0.8308> <-4.5998, 18.9461, 0.8308> <-4.5998, 20.5831, 0.8308> <-4.5500, 20.6329, 0.8308>
		<-4.5589, 18.8874, 0.7771> <-4.6087, 18.9372, 0.7771> <-4.6087, 20.5920, 0.7771> <-4.5589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 0.9062> <-4.4620, 18.9842, 0.9557> <-4.5560, 18.8903, 0.9996> <-4.5357, 18.9105, 1.0404>
		<-4.5109, 19.0245, 0.9062> <-4.5066, 19.0288, 0.9557> <-4.6045, 18.9388, 0.9996> <-4.5843, 18.9590, 1.0404>
		<-4.5109, 20.5047, 0.9062> <-4.5066, 20.5004, 0.9557> <-4.6045, 20.5904, 0.9996> <-4.5843, 20.5702, 1.0404>
		<-4.4664, 20.5493, 0.9062> <-4.4620, 20.5449, 0.9557> <-4.5560, 20.6389, 0.9996> <-4.5357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 0.9062> <-4.4712, 18.9751, 0.8515> <-4.5500, 18.8963, 0.8308> <-4.5589, 18.8874, 0.7771>
		<-4.4218, 18.9353, 0.9062> <-4.4266, 18.9305, 0.8515> <-4.5001, 18.8465, 0.8308> <-4.5090, 18.8376, 0.7771>
		<-2.9415, 18.9353, 0.9062> <-2.9367, 18.9305, 0.8515> <-2.8632, 18.8465, 0.8308> <-2.8543, 18.8376, 0.7771>
		<-2.8970, 18.9799, 0.9062> <-2.8922, 18.9751, 0.8515> <-2.8134, 18.8963, 0.8308> <-2.8045, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 0.9062> <-4.4218, 18.9353, 0.9062> <-2.9415, 18.9353, 0.9062> <-2.8970, 18.9799, 0.9062>
		<-4.4620, 18.9842, 0.9557> <-4.4175, 18.9397, 0.9557> <-2.9459, 18.9397, 0.9557> <-2.9013, 18.9842, 0.9557>
		<-4.5560, 18.8903, 0.9996> <-4.5075, 18.8418, 0.9996> <-2.8559, 18.8418, 0.9996> <-2.8073, 18.8903, 0.9996>
		<-4.5357, 18.9105, 1.0404> <-4.4872, 18.8620, 1.0404> <-2.8761, 18.8620, 1.0404> <-2.8276, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 18.9799, 0.9062> <-2.8922, 18.9751, 0.8515> <-2.8134, 18.8963, 0.8308> <-2.8045, 18.8874, 0.7771>
		<-2.8524, 19.0245, 0.9062> <-2.8476, 19.0196, 0.8515> <-2.7635, 18.9461, 0.8308> <-2.7546, 18.9372, 0.7771>
		<-2.8524, 20.5047, 0.9062> <-2.8476, 20.5095, 0.8515> <-2.7635, 20.5831, 0.8308> <-2.7546, 20.5920, 0.7771>
		<-2.8970, 20.5493, 0.9062> <-2.8922, 20.5541, 0.8515> <-2.8134, 20.6329, 0.8308> <-2.8045, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 18.9799, 0.9062> <-2.8524, 19.0245, 0.9062> <-2.8524, 20.5047, 0.9062> <-2.8970, 20.5493, 0.9062>
		<-2.9013, 18.9842, 0.9557> <-2.8567, 19.0288, 0.9557> <-2.8567, 20.5004, 0.9557> <-2.9013, 20.5449, 0.9557>
		<-2.8073, 18.8903, 0.9996> <-2.7588, 18.9388, 0.9996> <-2.7588, 20.5904, 0.9996> <-2.8073, 20.6389, 0.9996>
		<-2.8276, 18.9105, 1.0404> <-2.7791, 18.9590, 1.0404> <-2.7791, 20.5702, 1.0404> <-2.8276, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 20.5493, 0.9062> <-2.8922, 20.5541, 0.8515> <-2.8134, 20.6329, 0.8308> <-2.8045, 20.6418, 0.7771>
		<-2.9415, 20.5939, 0.9062> <-2.9367, 20.5987, 0.8515> <-2.8632, 20.6827, 0.8308> <-2.8543, 20.6916, 0.7771>
		<-4.4218, 20.5939, 0.9062> <-4.4266, 20.5987, 0.8515> <-4.5001, 20.6827, 0.8308> <-4.5090, 20.6916, 0.7771>
		<-4.4664, 20.5493, 0.9062> <-4.4712, 20.5541, 0.8515> <-4.5500, 20.6329, 0.8308> <-4.5589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 20.5493, 0.9062> <-2.9415, 20.5939, 0.9062> <-4.4218, 20.5939, 0.9062> <-4.4664, 20.5493, 0.9062>
		<-2.9013, 20.5449, 0.9557> <-2.9459, 20.5895, 0.9557> <-4.4175, 20.5895, 0.9557> <-4.4620, 20.5449, 0.9557>
		<-2.8073, 20.6389, 0.9996> <-2.8559, 20.6874, 0.9996> <-4.5075, 20.6874, 0.9996> <-4.5560, 20.6389, 0.9996>
		<-2.8276, 20.6187, 1.0404> <-2.8761, 20.6672, 1.0404> <-4.4872, 20.6672, 1.0404> <-4.5357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5357, 18.9105, 1.0404> <-4.4677, 18.9786, 1.1777> <-4.2982, 19.1481, 1.2552> <-4.2269, 19.2193, 1.3892>
		<-4.5843, 18.9590, 1.0404> <-4.5162, 19.0271, 1.1777> <-4.3291, 19.1790, 1.2552> <-4.2579, 19.2503, 1.3892>
		<-4.5843, 20.5702, 1.0404> <-4.5162, 20.5021, 1.1777> <-4.3291, 20.3501, 1.2552> <-4.2579, 20.2789, 1.3892>
		<-4.5357, 20.6187, 1.0404> <-4.4677, 20.5506, 1.1777> <-4.2982, 20.3811, 1.2552> <-4.2269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5357, 18.9105, 1.0404> <-4.4872, 18.8620, 1.0404> <-2.8761, 18.8620, 1.0404> <-2.8276, 18.9105, 1.0404>
		<-4.4677, 18.9786, 1.1777> <-4.4192, 18.9301, 1.1777> <-2.9442, 18.9301, 1.1777> <-2.8957, 18.9786, 1.1777>
		<-4.2982, 19.1481, 1.2552> <-4.2672, 19.1171, 1.2552> <-3.0961, 19.1171, 1.2552> <-3.0652, 19.1481, 1.2552>
		<-4.2269, 19.2193, 1.3892> <-4.1959, 19.1884, 1.3892> <-3.1674, 19.1884, 1.3892> <-3.1364, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8276, 18.9105, 1.0404> <-2.7791, 18.9590, 1.0404> <-2.7791, 20.5702, 1.0404> <-2.8276, 20.6187, 1.0404>
		<-2.8957, 18.9786, 1.1777> <-2.8471, 19.0271, 1.1777> <-2.8471, 20.5021, 1.1777> <-2.8957, 20.5506, 1.1777>
		<-3.0652, 19.1481, 1.2552> <-3.0342, 19.1790, 1.2552> <-3.0342, 20.3501, 1.2552> <-3.0652, 20.3811, 1.2552>
		<-3.1364, 19.2193, 1.3892> <-3.1054, 19.2503, 1.3892> <-3.1054, 20.2789, 1.3892> <-3.1364, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8276, 20.6187, 1.0404> <-2.8761, 20.6672, 1.0404> <-4.4872, 20.6672, 1.0404> <-4.5357, 20.6187, 1.0404>
		<-2.8957, 20.5506, 1.1777> <-2.9442, 20.5991, 1.1777> <-4.4192, 20.5991, 1.1777> <-4.4677, 20.5506, 1.1777>
		<-3.0652, 20.3811, 1.2552> <-3.0961, 20.4121, 1.2552> <-4.2672, 20.4121, 1.2552> <-4.2982, 20.3811, 1.2552>
		<-3.1364, 20.3098, 1.3892> <-3.1674, 20.3408, 1.3892> <-4.1959, 20.3408, 1.3892> <-4.2269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2269, 19.2193, 1.3892> <-4.2079, 19.2383, 1.4249> <-4.2837, 19.1626, 1.4698> <-4.2837, 19.1626, 1.5144>
		<-4.2579, 19.2503, 1.3892> <-4.2389, 19.2693, 1.4249> <-4.3179, 19.1968, 1.4698> <-4.3179, 19.1968, 1.5144>
		<-4.2579, 20.2789, 1.3892> <-4.2389, 20.2599, 1.4249> <-4.3179, 20.3324, 1.4698> <-4.3179, 20.3324, 1.5144>
		<-4.2269, 20.3098, 1.3892> <-4.2079, 20.2909, 1.4249> <-4.2837, 20.3666, 1.4698> <-4.2837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2269, 19.2193, 1.3892> <-4.1959, 19.1884, 1.3892> <-3.1674, 19.1884, 1.3892> <-3.1364, 19.2193, 1.3892>
		<-4.2079, 19.2383, 1.4249> <-4.1770, 19.2073, 1.4249> <-3.1863, 19.2073, 1.4249> <-3.1554, 19.2383, 1.4249>
		<-4.2837, 19.1626, 1.4698> <-4.2495, 19.1284, 1.4698> <-3.1138, 19.1284, 1.4698> <-3.0796, 19.1626, 1.4698>
		<-4.2837, 19.1626, 1.5144> <-4.2495, 19.1284, 1.5144> <-3.1138, 19.1284, 1.5144> <-3.0796, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1364, 19.2193, 1.3892> <-3.1054, 19.2503, 1.3892> <-3.1054, 20.2789, 1.3892> <-3.1364, 20.3098, 1.3892>
		<-3.1554, 19.2383, 1.4249> <-3.1244, 19.2693, 1.4249> <-3.1244, 20.2599, 1.4249> <-3.1554, 20.2909, 1.4249>
		<-3.0796, 19.1626, 1.4698> <-3.0455, 19.1968, 1.4698> <-3.0455, 20.3324, 1.4698> <-3.0796, 20.3666, 1.4698>
		<-3.0796, 19.1626, 1.5144> <-3.0455, 19.1968, 1.5144> <-3.0455, 20.3324, 1.5144> <-3.0796, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1364, 20.3098, 1.3892> <-3.1674, 20.3408, 1.3892> <-4.1959, 20.3408, 1.3892> <-4.2269, 20.3098, 1.3892>
		<-3.1554, 20.2909, 1.4249> <-3.1863, 20.3218, 1.4249> <-4.1770, 20.3218, 1.4249> <-4.2079, 20.2909, 1.4249>
		<-3.0796, 20.3666, 1.4698> <-3.1138, 20.4008, 1.4698> <-4.2495, 20.4008, 1.4698> <-4.2837, 20.3666, 1.4698>
		<-3.0796, 20.3666, 1.5144> <-3.1138, 20.4008, 1.5144> <-4.2495, 20.4008, 1.5144> <-4.2837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2837, 19.1626, 1.5144> <-4.2837, 19.1626, 1.5613> <-4.2121, 19.2341, 1.6066> <-4.2269, 19.2193, 1.6486>
		<-4.3179, 19.1968, 1.5144> <-4.3179, 19.1968, 1.5613> <-4.2431, 19.2651, 1.6066> <-4.2579, 19.2503, 1.6486>
		<-4.3179, 20.3324, 1.5144> <-4.3179, 20.3324, 1.5613> <-4.2431, 20.2641, 1.6066> <-4.2579, 20.2789, 1.6486>
		<-4.2837, 20.3666, 1.5144> <-4.2837, 20.3666, 1.5613> <-4.2121, 20.2950, 1.6066> <-4.2269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2837, 19.1626, 1.5144> <-4.2495, 19.1284, 1.5144> <-3.1138, 19.1284, 1.5144> <-3.0796, 19.1626, 1.5144>
		<-4.2837, 19.1626, 1.5613> <-4.2495, 19.1284, 1.5613> <-3.1138, 19.1284, 1.5613> <-3.0796, 19.1626, 1.5613>
		<-4.2121, 19.2341, 1.6066> <-4.1812, 19.2032, 1.6066> <-3.1822, 19.2032, 1.6066> <-3.1512, 19.2341, 1.6066>
		<-4.2269, 19.2193, 1.6486> <-4.1959, 19.1884, 1.6486> <-3.1674, 19.1884, 1.6486> <-3.1364, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0796, 19.1626, 1.5144> <-3.0455, 19.1968, 1.5144> <-3.0455, 20.3324, 1.5144> <-3.0796, 20.3666, 1.5144>
		<-3.0796, 19.1626, 1.5613> <-3.0455, 19.1968, 1.5613> <-3.0455, 20.3324, 1.5613> <-3.0796, 20.3666, 1.5613>
		<-3.1512, 19.2341, 1.6066> <-3.1202, 19.2651, 1.6066> <-3.1202, 20.2641, 1.6066> <-3.1512, 20.2950, 1.6066>
		<-3.1364, 19.2193, 1.6486> <-3.1054, 19.2503, 1.6486> <-3.1054, 20.2789, 1.6486> <-3.1364, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0796, 20.3666, 1.5144> <-3.1138, 20.4008, 1.5144> <-4.2495, 20.4008, 1.5144> <-4.2837, 20.3666, 1.5144>
		<-3.0796, 20.3666, 1.5613> <-3.1138, 20.4008, 1.5613> <-4.2495, 20.4008, 1.5613> <-4.2837, 20.3666, 1.5613>
		<-3.1512, 20.2950, 1.6066> <-3.1822, 20.3260, 1.6066> <-4.1812, 20.3260, 1.6066> <-4.2121, 20.2950, 1.6066>
		<-3.1364, 20.3098, 1.6486> <-3.1674, 20.3408, 1.6486> <-4.1959, 20.3408, 1.6486> <-4.2269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2269, 19.2193, 1.6486> <-4.2754, 19.1709, 1.7862> <-4.4172, 19.0290, 1.8960> <-4.4664, 18.9799, 2.0332>
		<-4.2579, 19.2503, 1.6486> <-4.3063, 19.2018, 1.7862> <-4.4618, 19.0736, 1.8960> <-4.5109, 19.0245, 2.0332>
		<-4.2579, 20.2789, 1.6486> <-4.3063, 20.3273, 1.7862> <-4.4618, 20.4556, 1.8960> <-4.5109, 20.5047, 2.0332>
		<-4.2269, 20.3098, 1.6486> <-4.2754, 20.3583, 1.7862> <-4.4172, 20.5002, 1.8960> <-4.4664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2269, 19.2193, 1.6486> <-4.1959, 19.1884, 1.6486> <-3.1674, 19.1884, 1.6486> <-3.1364, 19.2193, 1.6486>
		<-4.2754, 19.1709, 1.7862> <-4.2444, 19.1399, 1.7862> <-3.1189, 19.1399, 1.7862> <-3.0880, 19.1709, 1.7862>
		<-4.4172, 19.0290, 1.8960> <-4.3727, 18.9844, 1.8960> <-2.9907, 18.9844, 1.8960> <-2.9461, 19.0290, 1.8960>
		<-4.4664, 18.9799, 2.0332> <-4.4218, 18.9353, 2.0332> <-2.9415, 18.9353, 2.0332> <-2.8970, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1364, 19.2193, 1.6486> <-3.1054, 19.2503, 1.6486> <-3.1054, 20.2789, 1.6486> <-3.1364, 20.3098, 1.6486>
		<-3.0880, 19.1709, 1.7862> <-3.0570, 19.2018, 1.7862> <-3.0570, 20.3273, 1.7862> <-3.0880, 20.3583, 1.7862>
		<-2.9461, 19.0290, 1.8960> <-2.9015, 19.0736, 1.8960> <-2.9015, 20.4556, 1.8960> <-2.9461, 20.5002, 1.8960>
		<-2.8970, 18.9799, 2.0332> <-2.8524, 19.0245, 2.0332> <-2.8524, 20.5047, 2.0332> <-2.8970, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1364, 20.3098, 1.6486> <-3.1674, 20.3408, 1.6486> <-4.1959, 20.3408, 1.6486> <-4.2269, 20.3098, 1.6486>
		<-3.0880, 20.3583, 1.7862> <-3.1189, 20.3893, 1.7862> <-4.2444, 20.3893, 1.7862> <-4.2754, 20.3583, 1.7862>
		<-2.9461, 20.5002, 1.8960> <-2.9907, 20.5447, 1.8960> <-4.3727, 20.5447, 1.8960> <-4.4172, 20.5002, 1.8960>
		<-2.8970, 20.5493, 2.0332> <-2.9415, 20.5939, 2.0332> <-4.4218, 20.5939, 2.0332> <-4.4664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 2.0332> <-4.4930, 18.9533, 2.1074> <-4.4932, 18.9531, 2.2382> <-4.4641, 18.9822, 2.3104>
		<-4.5109, 19.0245, 2.0332> <-4.5375, 18.9979, 2.1074> <-4.5376, 18.9975, 2.2382> <-4.5085, 19.0266, 2.3104>
		<-4.5109, 20.5047, 2.0332> <-4.5375, 20.5313, 2.1074> <-4.5376, 20.5317, 2.2382> <-4.5085, 20.5025, 2.3104>
		<-4.4664, 20.5493, 2.0332> <-4.4930, 20.5759, 2.1074> <-4.4932, 20.5761, 2.2382> <-4.4641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4664, 18.9799, 2.0332> <-4.4218, 18.9353, 2.0332> <-2.9415, 18.9353, 2.0332> <-2.8970, 18.9799, 2.0332>
		<-4.4930, 18.9533, 2.1074> <-4.4484, 18.9087, 2.1074> <-2.9149, 18.9087, 2.1074> <-2.8704, 18.9533, 2.1074>
		<-4.4932, 18.9531, 2.2382> <-4.4488, 18.9086, 2.2382> <-2.9146, 18.9086, 2.2382> <-2.8701, 18.9531, 2.2382>
		<-4.4641, 18.9822, 2.3104> <-4.4196, 18.9378, 2.3104> <-2.9437, 18.9378, 2.3104> <-2.8993, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 18.9799, 2.0332> <-2.8524, 19.0245, 2.0332> <-2.8524, 20.5047, 2.0332> <-2.8970, 20.5493, 2.0332>
		<-2.8704, 18.9533, 2.1074> <-2.8258, 18.9979, 2.1074> <-2.8258, 20.5313, 2.1074> <-2.8704, 20.5759, 2.1074>
		<-2.8701, 18.9531, 2.2382> <-2.8257, 18.9975, 2.2382> <-2.8257, 20.5317, 2.2382> <-2.8701, 20.5761, 2.2382>
		<-2.8993, 18.9822, 2.3104> <-2.8548, 19.0266, 2.3104> <-2.8548, 20.5025, 2.3104> <-2.8993, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8970, 20.5493, 2.0332> <-2.9415, 20.5939, 2.0332> <-4.4218, 20.5939, 2.0332> <-4.4664, 20.5493, 2.0332>
		<-2.8704, 20.5759, 2.1074> <-2.9149, 20.6204, 2.1074> <-4.4484, 20.6204, 2.1074> <-4.4930, 20.5759, 2.1074>
		<-2.8701, 20.5761, 2.2382> <-2.9146, 20.6206, 2.2382> <-4.4488, 20.6206, 2.2382> <-4.4932, 20.5761, 2.2382>
		<-2.8993, 20.5470, 2.3104> <-2.9437, 20.5914, 2.3104> <-4.4196, 20.5914, 2.3104> <-4.4641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4641, 18.9822, 2.3104> <-4.3801, 19.0661, 2.5186> <-4.1843, 19.2620, 2.7154> <-4.1056, 19.3406, 2.9276>
		<-4.5085, 19.0266, 2.3104> <-4.4246, 19.1106, 2.5186> <-4.2084, 19.2860, 2.7154> <-4.1297, 19.3647, 2.9276>
		<-4.5085, 20.5025, 2.3104> <-4.4246, 20.4186, 2.5186> <-4.2084, 20.2431, 2.7154> <-4.1297, 20.1645, 2.9276>
		<-4.4641, 20.5470, 2.3104> <-4.3801, 20.4630, 2.5186> <-4.1843, 20.2672, 2.7154> <-4.1056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.4641, 18.9822, 2.3104> <-4.4196, 18.9378, 2.3104> <-2.9437, 18.9378, 2.3104> <-2.8993, 18.9822, 2.3104>
		<-4.3801, 19.0661, 2.5186> <-4.3357, 19.0217, 2.5186> <-3.0276, 19.0217, 2.5186> <-2.9832, 19.0661, 2.5186>
		<-4.1843, 19.2620, 2.7154> <-4.1602, 19.2379, 2.7154> <-3.2031, 19.2379, 2.7154> <-3.1790, 19.2620, 2.7154>
		<-4.1056, 19.3406, 2.9276> <-4.0815, 19.3165, 2.9276> <-3.2818, 19.3165, 2.9276> <-3.2577, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8993, 18.9822, 2.3104> <-2.8548, 19.0266, 2.3104> <-2.8548, 20.5025, 2.3104> <-2.8993, 20.5470, 2.3104>
		<-2.9832, 19.0661, 2.5186> <-2.9388, 19.1106, 2.5186> <-2.9388, 20.4186, 2.5186> <-2.9832, 20.4630, 2.5186>
		<-3.1790, 19.2620, 2.7154> <-3.1550, 19.2860, 2.7154> <-3.1550, 20.2431, 2.7154> <-3.1790, 20.2672, 2.7154>
		<-3.2577, 19.3406, 2.9276> <-3.2336, 19.3647, 2.9276> <-3.2336, 20.1645, 2.9276> <-3.2577, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8993, 20.5470, 2.3104> <-2.9437, 20.5914, 2.3104> <-4.4196, 20.5914, 2.3104> <-4.4641, 20.5470, 2.3104>
		<-2.9832, 20.4630, 2.5186> <-3.0277, 20.5075, 2.5186> <-4.3357, 20.5075, 2.5186> <-4.3801, 20.4630, 2.5186>
		<-3.1790, 20.2672, 2.7154> <-3.2031, 20.2913, 2.7154> <-4.1602, 20.2913, 2.7154> <-4.1843, 20.2672, 2.7154>
		<-3.2577, 20.1885, 2.9276> <-3.2818, 20.2126, 2.9276> <-4.0815, 20.2126, 2.9276> <-4.1056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1056, 19.3406, 2.9276> <-4.0887, 19.3576, 2.9732> <-4.1889, 19.2574, 3.0012> <-4.1889, 19.2574, 3.0528>
		<-4.1297, 19.3647, 2.9276> <-4.1128, 19.3816, 2.9732> <-4.2177, 19.2862, 3.0012> <-4.2177, 19.2862, 3.0528>
		<-4.1297, 20.1645, 2.9276> <-4.1128, 20.1475, 2.9732> <-4.2177, 20.2430, 3.0012> <-4.2177, 20.2430, 3.0528>
		<-4.1056, 20.1885, 2.9276> <-4.0887, 20.1716, 2.9732> <-4.1889, 20.2718, 3.0012> <-4.1889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1056, 19.3406, 2.9276> <-4.0815, 19.3165, 2.9276> <-3.2818, 19.3165, 2.9276> <-3.2577, 19.3406, 2.9276>
		<-4.0887, 19.3576, 2.9732> <-4.0646, 19.3335, 2.9732> <-3.2987, 19.3335, 2.9732> <-3.2746, 19.3576, 2.9732>
		<-4.1889, 19.2574, 3.0012> <-4.1601, 19.2286, 3.0012> <-3.2033, 19.2286, 3.0012> <-3.1745, 19.2574, 3.0012>
		<-4.1889, 19.2574, 3.0528> <-4.1601, 19.2286, 3.0528> <-3.2033, 19.2286, 3.0528> <-3.1745, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2577, 19.3406, 2.9276> <-3.2336, 19.3647, 2.9276> <-3.2336, 20.1645, 2.9276> <-3.2577, 20.1885, 2.9276>
		<-3.2746, 19.3576, 2.9732> <-3.2506, 19.3816, 2.9732> <-3.2506, 20.1475, 2.9732> <-3.2746, 20.1716, 2.9732>
		<-3.1745, 19.2574, 3.0012> <-3.1456, 19.2862, 3.0012> <-3.1456, 20.2430, 3.0012> <-3.1745, 20.2718, 3.0012>
		<-3.1745, 19.2574, 3.0528> <-3.1456, 19.2862, 3.0528> <-3.1456, 20.2430, 3.0528> <-3.1745, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2577, 20.1885, 2.9276> <-3.2818, 20.2126, 2.9276> <-4.0815, 20.2126, 2.9276> <-4.1056, 20.1885, 2.9276>
		<-3.2746, 20.1716, 2.9732> <-3.2987, 20.1957, 2.9732> <-4.0646, 20.1957, 2.9732> <-4.0887, 20.1716, 2.9732>
		<-3.1745, 20.2718, 3.0012> <-3.2033, 20.3006, 3.0012> <-4.1601, 20.3006, 3.0012> <-4.1889, 20.2718, 3.0012>
		<-3.1745, 20.2718, 3.0528> <-3.2033, 20.3006, 3.0528> <-4.1601, 20.3006, 3.0528> <-4.1889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1889, 19.2574, 3.0528> <-4.1889, 19.2574, 3.1044> <-4.0862, 19.3600, 3.1344> <-4.1056, 19.3406, 3.1780>
		<-4.2177, 19.2862, 3.0528> <-4.2177, 19.2862, 3.1044> <-4.1103, 19.3841, 3.1344> <-4.1297, 19.3647, 3.1780>
		<-4.2177, 20.2430, 3.0528> <-4.2177, 20.2430, 3.1044> <-4.1103, 20.1451, 3.1344> <-4.1297, 20.1645, 3.1780>
		<-4.1889, 20.2718, 3.0528> <-4.1889, 20.2718, 3.1044> <-4.0862, 20.1691, 3.1344> <-4.1056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1889, 19.2574, 3.0528> <-4.1601, 19.2286, 3.0528> <-3.2033, 19.2286, 3.0528> <-3.1745, 19.2574, 3.0528>
		<-4.1889, 19.2574, 3.1044> <-4.1601, 19.2286, 3.1044> <-3.2033, 19.2286, 3.1044> <-3.1745, 19.2574, 3.1044>
		<-4.0862, 19.3600, 3.1344> <-4.0621, 19.3359, 3.1344> <-3.3012, 19.3359, 3.1344> <-3.2771, 19.3600, 3.1344>
		<-4.1056, 19.3406, 3.1780> <-4.0815, 19.3165, 3.1780> <-3.2818, 19.3165, 3.1780> <-3.2577, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1745, 19.2574, 3.0528> <-3.1456, 19.2862, 3.0528> <-3.1456, 20.2430, 3.0528> <-3.1745, 20.2718, 3.0528>
		<-3.1745, 19.2574, 3.1044> <-3.1456, 19.2862, 3.1044> <-3.1456, 20.2430, 3.1044> <-3.1745, 20.2718, 3.1044>
		<-3.2771, 19.3600, 3.1344> <-3.2530, 19.3841, 3.1344> <-3.2530, 20.1451, 3.1344> <-3.2771, 20.1691, 3.1344>
		<-3.2577, 19.3406, 3.1780> <-3.2336, 19.3647, 3.1780> <-3.2336, 20.1645, 3.1780> <-3.2577, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1745, 20.2718, 3.0528> <-3.2033, 20.3006, 3.0528> <-4.1601, 20.3006, 3.0528> <-4.1889, 20.2718, 3.0528>
		<-3.1745, 20.2718, 3.1044> <-3.2033, 20.3006, 3.1044> <-4.1601, 20.3006, 3.1044> <-4.1889, 20.2718, 3.1044>
		<-3.2771, 20.1691, 3.1344> <-3.3012, 20.1932, 3.1344> <-4.0621, 20.1932, 3.1344> <-4.0862, 20.1691, 3.1344>
		<-3.2577, 20.1885, 3.1780> <-3.2818, 20.2126, 3.1780> <-4.0815, 20.2126, 3.1780> <-4.1056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1056, 19.3406, 3.1780> <-4.1438, 19.3024, 3.2640> <-4.2610, 19.1852, 3.2738> <-4.3161, 19.1302, 3.3390>
		<-4.1297, 19.3647, 3.1780> <-4.1679, 19.3265, 3.2640> <-4.2971, 19.2212, 3.2738> <-4.3521, 19.1662, 3.3390>
		<-4.1297, 20.1645, 3.1780> <-4.1679, 20.2027, 3.2640> <-4.2971, 20.3079, 3.2738> <-4.3521, 20.3629, 3.3390>
		<-4.1056, 20.1885, 3.1780> <-4.1438, 20.2267, 3.2640> <-4.2610, 20.3440, 3.2738> <-4.3161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1056, 19.3406, 3.1780> <-4.0815, 19.3165, 3.1780> <-3.2818, 19.3165, 3.1780> <-3.2577, 19.3406, 3.1780>
		<-4.1438, 19.3024, 3.2640> <-4.1197, 19.2784, 3.2640> <-3.2436, 19.2784, 3.2640> <-3.2195, 19.3024, 3.2640>
		<-4.2610, 19.1852, 3.2738> <-4.2250, 19.1492, 3.2738> <-3.1383, 19.1492, 3.2738> <-3.1023, 19.1852, 3.2738>
		<-4.3161, 19.1302, 3.3390> <-4.2800, 19.0942, 3.3390> <-3.0833, 19.0942, 3.3390> <-3.0473, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2577, 19.3406, 3.1780> <-3.2336, 19.3647, 3.1780> <-3.2336, 20.1645, 3.1780> <-3.2577, 20.1885, 3.1780>
		<-3.2195, 19.3024, 3.2640> <-3.1954, 19.3265, 3.2640> <-3.1954, 20.2027, 3.2640> <-3.2195, 20.2267, 3.2640>
		<-3.1023, 19.1852, 3.2738> <-3.0663, 19.2212, 3.2738> <-3.0663, 20.3079, 3.2738> <-3.1023, 20.3440, 3.2738>
		<-3.0473, 19.1302, 3.3390> <-3.0112, 19.1662, 3.3390> <-3.0112, 20.3629, 3.3390> <-3.0473, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2577, 20.1885, 3.1780> <-3.2818, 20.2126, 3.1780> <-4.0815, 20.2126, 3.1780> <-4.1056, 20.1885, 3.1780>
		<-3.2195, 20.2267, 3.2640> <-3.2436, 20.2508, 3.2640> <-4.1197, 20.2508, 3.2640> <-4.1438, 20.2267, 3.2640>
		<-3.1023, 20.3440, 3.2738> <-3.1383, 20.3800, 3.2738> <-4.2250, 20.3800, 3.2738> <-4.2610, 20.3440, 3.2738>
		<-3.0473, 20.3990, 3.3390> <-3.0833, 20.4350, 3.3390> <-4.2800, 20.4350, 3.3390> <-4.3161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3161, 19.1302, 3.3390> <-4.3416, 19.1046, 3.3693> <-4.3797, 19.0665, 3.4419> <-4.3623, 19.0839, 3.4821>
		<-4.3521, 19.1662, 3.3390> <-4.3777, 19.1406, 3.3693> <-4.4184, 19.1052, 3.4419> <-4.4010, 19.1226, 3.4821>
		<-4.3521, 20.3629, 3.3390> <-4.3777, 20.3885, 3.3693> <-4.4184, 20.4240, 3.4419> <-4.4010, 20.4066, 3.4821>
		<-4.3161, 20.3990, 3.3390> <-4.3416, 20.4246, 3.3693> <-4.3797, 20.4627, 3.4419> <-4.3623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3161, 19.1302, 3.3390> <-4.2800, 19.0942, 3.3390> <-3.0833, 19.0942, 3.3390> <-3.0473, 19.1302, 3.3390>
		<-4.3416, 19.1046, 3.3693> <-4.3056, 19.0686, 3.3693> <-3.0577, 19.0686, 3.3693> <-3.0217, 19.1046, 3.3693>
		<-4.3797, 19.0665, 3.4419> <-4.3411, 19.0279, 3.4419> <-3.0223, 19.0279, 3.4419> <-2.9836, 19.0665, 3.4419>
		<-4.3623, 19.0839, 3.4821> <-4.3236, 19.0453, 3.4821> <-3.0397, 19.0453, 3.4821> <-3.0010, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0473, 19.1302, 3.3390> <-3.0112, 19.1662, 3.3390> <-3.0112, 20.3629, 3.3390> <-3.0473, 20.3990, 3.3390>
		<-3.0217, 19.1046, 3.3693> <-2.9857, 19.1406, 3.3693> <-2.9857, 20.3885, 3.3693> <-3.0217, 20.4246, 3.3693>
		<-2.9836, 19.0665, 3.4419> <-2.9449, 19.1052, 3.4419> <-2.9449, 20.4240, 3.4419> <-2.9836, 20.4627, 3.4419>
		<-3.0010, 19.0839, 3.4821> <-2.9624, 19.1226, 3.4821> <-2.9624, 20.4066, 3.4821> <-3.0010, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0473, 20.3990, 3.3390> <-3.0833, 20.4350, 3.3390> <-4.2800, 20.4350, 3.3390> <-4.3161, 20.3990, 3.3390>
		<-3.0217, 20.4246, 3.3693> <-3.0577, 20.4606, 3.3693> <-4.3056, 20.4606, 3.3693> <-4.3416, 20.4246, 3.3693>
		<-2.9836, 20.4627, 3.4419> <-3.0223, 20.5013, 3.4419> <-4.3411, 20.5013, 3.4419> <-4.3797, 20.4627, 3.4419>
		<-3.0010, 20.4452, 3.4821> <-3.0397, 20.4839, 3.4821> <-4.3236, 20.4839, 3.4821> <-4.3623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3623, 19.0839, 3.4821> <-4.3163, 19.1300, 3.5884> <-4.1961, 19.2502, 3.6567> <-4.1380, 19.3083, 3.7504>
		<-4.4010, 19.1226, 3.4821> <-4.3550, 19.1686, 3.5884> <-4.2220, 19.2761, 3.6567> <-4.1639, 19.3342, 3.7504>
		<-4.4010, 20.4066, 3.4821> <-4.3550, 20.3606, 3.5884> <-4.2220, 20.2531, 3.6567> <-4.1639, 20.1950, 3.7504>
		<-4.3623, 20.4452, 3.4821> <-4.3163, 20.3992, 3.5884> <-4.1961, 20.2790, 3.6567> <-4.1380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3623, 19.0839, 3.4821> <-4.3236, 19.0453, 3.4821> <-3.0397, 19.0453, 3.4821> <-3.0010, 19.0839, 3.4821>
		<-4.3163, 19.1300, 3.5884> <-4.2776, 19.0913, 3.5884> <-3.0857, 19.0913, 3.5884> <-3.0470, 19.1300, 3.5884>
		<-4.1961, 19.2502, 3.6567> <-4.1702, 19.2242, 3.6567> <-3.1932, 19.2242, 3.6567> <-3.1672, 19.2502, 3.6567>
		<-4.1380, 19.3083, 3.7504> <-4.1121, 19.2823, 3.7504> <-3.2513, 19.2823, 3.7504> <-3.2253, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0010, 19.0839, 3.4821> <-2.9624, 19.1226, 3.4821> <-2.9624, 20.4066, 3.4821> <-3.0010, 20.4452, 3.4821>
		<-3.0470, 19.1300, 3.5884> <-3.0084, 19.1686, 3.5884> <-3.0084, 20.3606, 3.5884> <-3.0470, 20.3992, 3.5884>
		<-3.1672, 19.2502, 3.6567> <-3.1413, 19.2761, 3.6567> <-3.1413, 20.2531, 3.6567> <-3.1672, 20.2790, 3.6567>
		<-3.2253, 19.3083, 3.7504> <-3.1994, 19.3342, 3.7504> <-3.1994, 20.1950, 3.7504> <-3.2253, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0010, 20.4452, 3.4821> <-3.0397, 20.4839, 3.4821> <-4.3236, 20.4839, 3.4821> <-4.3623, 20.4452, 3.4821>
		<-3.0470, 20.3992, 3.5884> <-3.0857, 20.4379, 3.5884> <-4.2776, 20.4379, 3.5884> <-4.3163, 20.3992, 3.5884>
		<-3.1672, 20.2790, 3.6567> <-3.1932, 20.3049, 3.6567> <-4.1702, 20.3049, 3.6567> <-4.1961, 20.2790, 3.6567>
		<-3.2253, 20.2209, 3.7504> <-3.2513, 20.2468, 3.7504> <-4.1121, 20.2468, 3.7504> <-4.1380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1380, 19.3083, 3.7504> <-4.0964, 19.3498, 3.8175> <-4.0527, 19.3935, 3.9241> <-4.0352, 19.4110, 4.0098>
		<-4.1639, 19.3342, 3.7504> <-4.1223, 19.3757, 3.8175> <-4.0728, 19.4136, 3.9241> <-4.0553, 19.4311, 4.0098>
		<-4.1639, 20.1950, 3.7504> <-4.1223, 20.1534, 3.8175> <-4.0728, 20.1156, 3.9241> <-4.0553, 20.0981, 4.0098>
		<-4.1380, 20.2209, 3.7504> <-4.0964, 20.1793, 3.8175> <-4.0527, 20.1356, 3.9241> <-4.0352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.1380, 19.3083, 3.7504> <-4.1121, 19.2823, 3.7504> <-3.2513, 19.2823, 3.7504> <-3.2253, 19.3083, 3.7504>
		<-4.0964, 19.3498, 3.8175> <-4.0705, 19.3239, 3.8175> <-3.2928, 19.3239, 3.8175> <-3.2669, 19.3498, 3.8175>
		<-4.0527, 19.3935, 3.9241> <-4.0326, 19.3734, 3.9241> <-3.3307, 19.3734, 3.9241> <-3.3106, 19.3935, 3.9241>
		<-4.0352, 19.4110, 4.0098> <-4.0152, 19.3909, 4.0098> <-3.3482, 19.3909, 4.0098> <-3.3281, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2253, 19.3083, 3.7504> <-3.1994, 19.3342, 3.7504> <-3.1994, 20.1950, 3.7504> <-3.2253, 20.2209, 3.7504>
		<-3.2669, 19.3498, 3.8175> <-3.2410, 19.3757, 3.8175> <-3.2410, 20.1534, 3.8175> <-3.2669, 20.1793, 3.8175>
		<-3.3106, 19.3935, 3.9241> <-3.2905, 19.4136, 3.9241> <-3.2905, 20.1156, 3.9241> <-3.3106, 20.1356, 3.9241>
		<-3.3281, 19.4110, 4.0098> <-3.3080, 19.4311, 4.0098> <-3.3080, 20.0981, 4.0098> <-3.3281, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2253, 20.2209, 3.7504> <-3.2513, 20.2468, 3.7504> <-4.1121, 20.2468, 3.7504> <-4.1380, 20.2209, 3.7504>
		<-3.2669, 20.1793, 3.8175> <-3.2928, 20.2053, 3.8175> <-4.0705, 20.2053, 3.8175> <-4.0964, 20.1793, 3.8175>
		<-3.3106, 20.1356, 3.9241> <-3.3307, 20.1557, 3.9241> <-4.0326, 20.1557, 3.9241> <-4.0527, 20.1356, 3.9241>
		<-3.3281, 20.1182, 4.0098> <-3.3482, 20.1383, 4.0098> <-4.0152, 20.1383, 4.0098> <-4.0352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0352, 19.4110, 4.0098> <-4.0168, 19.4294, 4.1002> <-4.0221, 19.4242, 4.2288> <-4.0213, 19.4250, 4.3229>
		<-4.0553, 19.4311, 4.0098> <-4.0369, 19.4495, 4.1002> <-4.0413, 19.4435, 4.2288> <-4.0405, 19.4443, 4.3229>
		<-4.0553, 20.0981, 4.0098> <-4.0369, 20.0797, 4.1002> <-4.0413, 20.0857, 4.2288> <-4.0405, 20.0849, 4.3229>
		<-4.0352, 20.1182, 4.0098> <-4.0168, 20.0997, 4.1002> <-4.0221, 20.1050, 4.2288> <-4.0213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0352, 19.4110, 4.0098> <-4.0152, 19.3909, 4.0098> <-3.3482, 19.3909, 4.0098> <-3.3281, 19.4110, 4.0098>
		<-4.0168, 19.4294, 4.1002> <-3.9967, 19.4094, 4.1002> <-3.3666, 19.4094, 4.1002> <-3.3465, 19.4294, 4.1002>
		<-4.0221, 19.4242, 4.2288> <-4.0028, 19.4049, 4.2288> <-3.3606, 19.4049, 4.2288> <-3.3413, 19.4242, 4.2288>
		<-4.0213, 19.4250, 4.3229> <-4.0020, 19.4057, 4.3229> <-3.3614, 19.4057, 4.3229> <-3.3421, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3281, 19.4110, 4.0098> <-3.3080, 19.4311, 4.0098> <-3.3080, 20.0981, 4.0098> <-3.3281, 20.1182, 4.0098>
		<-3.3465, 19.4294, 4.1002> <-3.3264, 19.4495, 4.1002> <-3.3264, 20.0797, 4.1002> <-3.3465, 20.0997, 4.1002>
		<-3.3413, 19.4242, 4.2288> <-3.3220, 19.4435, 4.2288> <-3.3220, 20.0857, 4.2288> <-3.3413, 20.1050, 4.2288>
		<-3.3421, 19.4250, 4.3229> <-3.3228, 19.4443, 4.3229> <-3.3228, 20.0849, 4.3229> <-3.3421, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3281, 20.1182, 4.0098> <-3.3482, 20.1383, 4.0098> <-4.0152, 20.1383, 4.0098> <-4.0352, 20.1182, 4.0098>
		<-3.3465, 20.0997, 4.1002> <-3.3666, 20.1198, 4.1002> <-3.9967, 20.1198, 4.1002> <-4.0168, 20.0997, 4.1002>
		<-3.3413, 20.1050, 4.2288> <-3.3606, 20.1243, 4.2288> <-4.0028, 20.1243, 4.2288> <-4.0221, 20.1050, 4.2288>
		<-3.3421, 20.1042, 4.3229> <-3.3614, 20.1235, 4.3229> <-4.0020, 20.1235, 4.3229> <-4.0213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0213, 19.4250, 4.3229> <-4.0179, 19.4284, 4.7283> <-4.0197, 19.4265, 5.2689> <-4.0213, 19.4250, 5.6744>
		<-4.0405, 19.4443, 4.3229> <-4.0371, 19.4477, 4.7283> <-4.0390, 19.4458, 5.2689> <-4.0405, 19.4443, 5.6744>
		<-4.0405, 20.0849, 4.3229> <-4.0371, 20.0815, 4.7283> <-4.0390, 20.0834, 5.2689> <-4.0405, 20.0849, 5.6744>
		<-4.0213, 20.1042, 4.3229> <-4.0179, 20.1008, 4.7283> <-4.0197, 20.1027, 5.2689> <-4.0213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0213, 19.4250, 4.3229> <-4.0020, 19.4057, 4.3229> <-3.3614, 19.4057, 4.3229> <-3.3421, 19.4250, 4.3229>
		<-4.0179, 19.4284, 4.7283> <-3.9986, 19.4091, 4.7283> <-3.3648, 19.4091, 4.7283> <-3.3455, 19.4284, 4.7283>
		<-4.0197, 19.4265, 5.2689> <-4.0004, 19.4072, 5.2689> <-3.3629, 19.4072, 5.2689> <-3.3436, 19.4265, 5.2689>
		<-4.0213, 19.4250, 5.6744> <-4.0020, 19.4057, 5.6744> <-3.3614, 19.4057, 5.6744> <-3.3421, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3421, 19.4250, 4.3229> <-3.3228, 19.4443, 4.3229> <-3.3228, 20.0849, 4.3229> <-3.3421, 20.1042, 4.3229>
		<-3.3455, 19.4284, 4.7283> <-3.3262, 19.4477, 4.7283> <-3.3262, 20.0815, 4.7283> <-3.3455, 20.1008, 4.7283>
		<-3.3436, 19.4265, 5.2689> <-3.3243, 19.4458, 5.2689> <-3.3243, 20.0834, 5.2689> <-3.3436, 20.1027, 5.2689>
		<-3.3421, 19.4250, 5.6744> <-3.3228, 19.4443, 5.6744> <-3.3228, 20.0849, 5.6744> <-3.3421, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3421, 20.1042, 4.3229> <-3.3614, 20.1235, 4.3229> <-4.0020, 20.1235, 4.3229> <-4.0213, 20.1042, 4.3229>
		<-3.3455, 20.1008, 4.7283> <-3.3648, 20.1201, 4.7283> <-3.9986, 20.1201, 4.7283> <-4.0179, 20.1008, 4.7283>
		<-3.3436, 20.1027, 5.2689> <-3.3629, 20.1220, 5.2689> <-4.0004, 20.1220, 5.2689> <-4.0197, 20.1027, 5.2689>
		<-3.3421, 20.1042, 5.6744> <-3.3614, 20.1235, 5.6744> <-4.0020, 20.1235, 5.6744> <-4.0213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0213, 19.4250, 5.6744> <-4.0225, 19.4237, 6.0073> <-4.0172, 19.4290, 6.4517> <-4.0305, 19.4157, 6.7841>
		<-4.0405, 19.4443, 5.6744> <-4.0418, 19.4430, 6.0073> <-4.0371, 19.4488, 6.4517> <-4.0503, 19.4355, 6.7841>
		<-4.0405, 20.0849, 5.6744> <-4.0418, 20.0861, 6.0073> <-4.0371, 20.0804, 6.4517> <-4.0503, 20.0936, 6.7841>
		<-4.0213, 20.1042, 5.6744> <-4.0225, 20.1054, 6.0073> <-4.0172, 20.1002, 6.4517> <-4.0305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0213, 19.4250, 5.6744> <-4.0020, 19.4057, 5.6744> <-3.3614, 19.4057, 5.6744> <-3.3421, 19.4250, 5.6744>
		<-4.0225, 19.4237, 6.0073> <-4.0032, 19.4044, 6.0073> <-3.3601, 19.4044, 6.0073> <-3.3408, 19.4237, 6.0073>
		<-4.0172, 19.4290, 6.4517> <-3.9974, 19.4092, 6.4517> <-3.3659, 19.4092, 6.4517> <-3.3461, 19.4290, 6.4517>
		<-4.0305, 19.4157, 6.7841> <-4.0107, 19.3959, 6.7841> <-3.3526, 19.3959, 6.7841> <-3.3328, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3421, 19.4250, 5.6744> <-3.3228, 19.4443, 5.6744> <-3.3228, 20.0849, 5.6744> <-3.3421, 20.1042, 5.6744>
		<-3.3408, 19.4237, 6.0073> <-3.3215, 19.4430, 6.0073> <-3.3215, 20.0861, 6.0073> <-3.3408, 20.1054, 6.0073>
		<-3.3461, 19.4290, 6.4517> <-3.3263, 19.4488, 6.4517> <-3.3263, 20.0804, 6.4517> <-3.3461, 20.1002, 6.4517>
		<-3.3328, 19.4157, 6.7841> <-3.3130, 19.4355, 6.7841> <-3.3130, 20.0936, 6.7841> <-3.3328, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3421, 20.1042, 5.6744> <-3.3614, 20.1235, 5.6744> <-4.0020, 20.1235, 5.6744> <-4.0213, 20.1042, 5.6744>
		<-3.3408, 20.1054, 6.0073> <-3.3601, 20.1247, 6.0073> <-4.0032, 20.1247, 6.0073> <-4.0225, 20.1054, 6.0073>
		<-3.3461, 20.1002, 6.4517> <-3.3659, 20.1200, 6.4517> <-3.9974, 20.1200, 6.4517> <-4.0172, 20.1002, 6.4517>
		<-3.3328, 20.1134, 6.7841> <-3.3526, 20.1333, 6.7841> <-4.0107, 20.1333, 6.7841> <-4.0305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0305, 19.4157, 6.7841> <-4.0325, 19.4137, 6.8341> <-4.0449, 19.4013, 6.9079> <-4.0718, 19.3745, 6.9405>
		<-4.0503, 19.4355, 6.7841> <-4.0523, 19.4336, 6.8341> <-4.0671, 19.4235, 6.9079> <-4.0940, 19.3966, 6.9405>
		<-4.0503, 20.0936, 6.7841> <-4.0523, 20.0956, 6.8341> <-4.0671, 20.1057, 6.9079> <-4.0940, 20.1326, 6.9405>
		<-4.0305, 20.1134, 6.7841> <-4.0325, 20.1154, 6.8341> <-4.0449, 20.1278, 6.9079> <-4.0718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0305, 19.4157, 6.7841> <-4.0107, 19.3959, 6.7841> <-3.3526, 19.3959, 6.7841> <-3.3328, 19.4157, 6.7841>
		<-4.0325, 19.4137, 6.8341> <-4.0127, 19.3939, 6.8341> <-3.3506, 19.3939, 6.8341> <-3.3308, 19.4137, 6.8341>
		<-4.0449, 19.4013, 6.9079> <-4.0228, 19.3792, 6.9079> <-3.3406, 19.3792, 6.9079> <-3.3184, 19.4013, 6.9079>
		<-4.0718, 19.3745, 6.9405> <-4.0496, 19.3523, 6.9405> <-3.3137, 19.3523, 6.9405> <-3.2915, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3328, 19.4157, 6.7841> <-3.3130, 19.4355, 6.7841> <-3.3130, 20.0936, 6.7841> <-3.3328, 20.1134, 6.7841>
		<-3.3308, 19.4137, 6.8341> <-3.3110, 19.4336, 6.8341> <-3.3110, 20.0956, 6.8341> <-3.3308, 20.1154, 6.8341>
		<-3.3184, 19.4013, 6.9079> <-3.2962, 19.4235, 6.9079> <-3.2962, 20.1057, 6.9079> <-3.3184, 20.1278, 6.9079>
		<-3.2915, 19.3745, 6.9405> <-3.2694, 19.3966, 6.9405> <-3.2694, 20.1326, 6.9405> <-3.2915, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.3328, 20.1134, 6.7841> <-3.3526, 20.1333, 6.7841> <-4.0107, 20.1333, 6.7841> <-4.0305, 20.1134, 6.7841>
		<-3.3308, 20.1154, 6.8341> <-3.3506, 20.1352, 6.8341> <-4.0127, 20.1352, 6.8341> <-4.0325, 20.1154, 6.8341>
		<-3.3184, 20.1278, 6.9079> <-3.3406, 20.1500, 6.9079> <-4.0228, 20.1500, 6.9079> <-4.0449, 20.1278, 6.9079>
		<-3.2915, 20.1547, 6.9405> <-3.3137, 20.1769, 6.9405> <-4.0496, 20.1769, 6.9405> <-4.0718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0718, 19.3745, 6.9405> <-4.1339, 19.3123, 7.0160> <-4.2620, 19.1842, 7.0331> <-4.3114, 19.1348, 7.1255>
		<-4.0940, 19.3966, 6.9405> <-4.1561, 19.3345, 7.0160> <-4.2978, 19.2200, 7.0331> <-4.3472, 19.1706, 7.1255>
		<-4.0940, 20.1326, 6.9405> <-4.1561, 20.1947, 7.0160> <-4.2978, 20.3092, 7.0331> <-4.3472, 20.3586, 7.1255>
		<-4.0718, 20.1547, 6.9405> <-4.1339, 20.2168, 7.0160> <-4.2620, 20.3449, 7.0331> <-4.3114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.0718, 19.3745, 6.9405> <-4.0496, 19.3523, 6.9405> <-3.3137, 19.3523, 6.9405> <-3.2915, 19.3745, 6.9405>
		<-4.1339, 19.3123, 7.0160> <-4.1117, 19.2902, 7.0160> <-3.2516, 19.2902, 7.0160> <-3.2294, 19.3123, 7.0160>
		<-4.2620, 19.1842, 7.0331> <-4.2262, 19.1485, 7.0331> <-3.1371, 19.1485, 7.0331> <-3.1013, 19.1842, 7.0331>
		<-4.3114, 19.1348, 7.1255> <-4.2757, 19.0990, 7.1255> <-3.0877, 19.0990, 7.1255> <-3.0519, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2915, 19.3745, 6.9405> <-3.2694, 19.3966, 6.9405> <-3.2694, 20.1326, 6.9405> <-3.2915, 20.1547, 6.9405>
		<-3.2294, 19.3123, 7.0160> <-3.2073, 19.3345, 7.0160> <-3.2073, 20.1947, 7.0160> <-3.2294, 20.2168, 7.0160>
		<-3.1013, 19.1842, 7.0331> <-3.0655, 19.2200, 7.0331> <-3.0655, 20.3092, 7.0331> <-3.1013, 20.3449, 7.0331>
		<-3.0519, 19.1348, 7.1255> <-3.0161, 19.1706, 7.1255> <-3.0161, 20.3586, 7.1255> <-3.0519, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.2915, 20.1547, 6.9405> <-3.3137, 20.1769, 6.9405> <-4.0496, 20.1769, 6.9405> <-4.0718, 20.1547, 6.9405>
		<-3.2294, 20.2168, 7.0160> <-3.2516, 20.2390, 7.0160> <-4.1117, 20.2390, 7.0160> <-4.1339, 20.2168, 7.0160>
		<-3.1013, 20.3449, 7.0331> <-3.1371, 20.3807, 7.0331> <-4.2262, 20.3807, 7.0331> <-4.2620, 20.3449, 7.0331>
		<-3.0519, 20.3944, 7.1255> <-3.0877, 20.4301, 7.1255> <-4.2757, 20.4301, 7.1255> <-4.3114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3114, 19.1348, 7.1255> <-4.3319, 19.1143, 7.1638> <-4.2316, 19.2146, 7.1912> <-4.2316, 19.2146, 7.2393>
		<-4.3472, 19.1706, 7.1255> <-4.3677, 19.1501, 7.1638> <-4.2629, 19.2459, 7.1912> <-4.2629, 19.2459, 7.2393>
		<-4.3472, 20.3586, 7.1255> <-4.3677, 20.3791, 7.1638> <-4.2629, 20.2833, 7.1912> <-4.2629, 20.2833, 7.2393>
		<-4.3114, 20.3944, 7.1255> <-4.3319, 20.4149, 7.1638> <-4.2316, 20.3146, 7.1912> <-4.2316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3114, 19.1348, 7.1255> <-4.2757, 19.0990, 7.1255> <-3.0877, 19.0990, 7.1255> <-3.0519, 19.1348, 7.1255>
		<-4.3319, 19.1143, 7.1638> <-4.2962, 19.0785, 7.1638> <-3.0671, 19.0785, 7.1638> <-3.0314, 19.1143, 7.1638>
		<-4.2316, 19.2146, 7.1912> <-4.2004, 19.1834, 7.1912> <-3.1629, 19.1834, 7.1912> <-3.1317, 19.2146, 7.1912>
		<-4.2316, 19.2146, 7.2393> <-4.2004, 19.1834, 7.2393> <-3.1629, 19.1834, 7.2393> <-3.1317, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0519, 19.1348, 7.1255> <-3.0161, 19.1706, 7.1255> <-3.0161, 20.3586, 7.1255> <-3.0519, 20.3944, 7.1255>
		<-3.0314, 19.1143, 7.1638> <-2.9956, 19.1501, 7.1638> <-2.9956, 20.3791, 7.1638> <-3.0314, 20.4149, 7.1638>
		<-3.1317, 19.2146, 7.1912> <-3.1005, 19.2459, 7.1912> <-3.1005, 20.2833, 7.1912> <-3.1317, 20.3146, 7.1912>
		<-3.1317, 19.2146, 7.2393> <-3.1005, 19.2459, 7.2393> <-3.1005, 20.2833, 7.2393> <-3.1317, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0519, 20.3944, 7.1255> <-3.0877, 20.4301, 7.1255> <-4.2757, 20.4301, 7.1255> <-4.3114, 20.3944, 7.1255>
		<-3.0314, 20.4149, 7.1638> <-3.0671, 20.4506, 7.1638> <-4.2962, 20.4506, 7.1638> <-4.3319, 20.4149, 7.1638>
		<-3.1317, 20.3146, 7.1912> <-3.1629, 20.3458, 7.1912> <-4.2004, 20.3458, 7.1912> <-4.2316, 20.3146, 7.1912>
		<-3.1317, 20.3146, 7.2393> <-3.1629, 20.3458, 7.2393> <-4.2004, 20.3458, 7.2393> <-4.2316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2316, 19.2146, 7.2393> <-4.2316, 19.2146, 7.2905> <-4.3054, 19.1408, 7.3169> <-4.3114, 19.1348, 7.3673>
		<-4.2629, 19.2459, 7.2393> <-4.2629, 19.2459, 7.2905> <-4.3412, 19.1766, 7.3169> <-4.3472, 19.1706, 7.3673>
		<-4.2629, 20.2833, 7.2393> <-4.2629, 20.2833, 7.2905> <-4.3412, 20.3526, 7.3169> <-4.3472, 20.3586, 7.3673>
		<-4.2316, 20.3146, 7.2393> <-4.2316, 20.3146, 7.2905> <-4.3054, 20.3883, 7.3169> <-4.3114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.2316, 19.2146, 7.2393> <-4.2004, 19.1834, 7.2393> <-3.1629, 19.1834, 7.2393> <-3.1317, 19.2146, 7.2393>
		<-4.2316, 19.2146, 7.2905> <-4.2004, 19.1834, 7.2905> <-3.1629, 19.1834, 7.2905> <-3.1317, 19.2146, 7.2905>
		<-4.3054, 19.1408, 7.3169> <-4.2696, 19.1051, 7.3169> <-3.0937, 19.1051, 7.3169> <-3.0579, 19.1408, 7.3169>
		<-4.3114, 19.1348, 7.3673> <-4.2757, 19.0990, 7.3673> <-3.0877, 19.0990, 7.3673> <-3.0519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1317, 19.2146, 7.2393> <-3.1005, 19.2459, 7.2393> <-3.1005, 20.2833, 7.2393> <-3.1317, 20.3146, 7.2393>
		<-3.1317, 19.2146, 7.2905> <-3.1005, 19.2459, 7.2905> <-3.1005, 20.2833, 7.2905> <-3.1317, 20.3146, 7.2905>
		<-3.0579, 19.1408, 7.3169> <-3.0222, 19.1766, 7.3169> <-3.0222, 20.3526, 7.3169> <-3.0579, 20.3883, 7.3169>
		<-3.0519, 19.1348, 7.3673> <-3.0161, 19.1706, 7.3673> <-3.0161, 20.3586, 7.3673> <-3.0519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.1317, 20.3146, 7.2393> <-3.1629, 20.3458, 7.2393> <-4.2004, 20.3458, 7.2393> <-4.2316, 20.3146, 7.2393>
		<-3.1317, 20.3146, 7.2905> <-3.1629, 20.3458, 7.2905> <-4.2004, 20.3458, 7.2905> <-4.2316, 20.3146, 7.2905>
		<-3.0579, 20.3883, 7.3169> <-3.0937, 20.4241, 7.3169> <-4.2696, 20.4241, 7.3169> <-4.3054, 20.3883, 7.3169>
		<-3.0519, 20.3944, 7.3673> <-3.0877, 20.4301, 7.3673> <-4.2757, 20.4301, 7.3673> <-4.3114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3114, 19.1348, 7.9080> <-4.3472, 19.1706, 7.9080> <-4.3472, 20.3586, 7.9080> <-4.3114, 20.3944, 7.9080>
		<-4.3114, 19.1348, 7.7458> <-4.3472, 19.1706, 7.7458> <-4.3472, 20.3586, 7.7458> <-4.3114, 20.3944, 7.7458>
		<-4.3305, 19.1157, 7.5273> <-4.3663, 19.1515, 7.5273> <-4.3663, 20.3777, 7.5273> <-4.3305, 20.4134, 7.5273>
		<-4.3114, 19.1348, 7.3673> <-4.3472, 19.1706, 7.3673> <-4.3472, 20.3586, 7.3673> <-4.3114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.3114, 19.1348, 7.9080> <-4.3114, 19.1348, 7.7458> <-4.3305, 19.1157, 7.5273> <-4.3114, 19.1348, 7.3673>
		<-4.2757, 19.0990, 7.9080> <-4.2757, 19.0990, 7.7458> <-4.2947, 19.0800, 7.5273> <-4.2757, 19.0990, 7.3673>
		<-3.0877, 19.0990, 7.9080> <-3.0877, 19.0990, 7.7458> <-3.0686, 19.0800, 7.5273> <-3.0877, 19.0990, 7.3673>
		<-3.0519, 19.1348, 7.9080> <-3.0519, 19.1348, 7.7458> <-3.0328, 19.1157, 7.5273> <-3.0519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0519, 19.1348, 7.9080> <-3.0519, 19.1348, 7.7458> <-3.0328, 19.1157, 7.5273> <-3.0519, 19.1348, 7.3673>
		<-3.0161, 19.1706, 7.9080> <-3.0161, 19.1706, 7.7458> <-2.9970, 19.1515, 7.5273> <-3.0161, 19.1706, 7.3673>
		<-3.0161, 20.3586, 7.9080> <-3.0161, 20.3586, 7.7458> <-2.9970, 20.3777, 7.5273> <-3.0161, 20.3586, 7.3673>
		<-3.0519, 20.3944, 7.9080> <-3.0519, 20.3944, 7.7458> <-3.0328, 20.4134, 7.5273> <-3.0519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.0519, 20.3944, 7.9080> <-3.0519, 20.3944, 7.7458> <-3.0328, 20.4134, 7.5273> <-3.0519, 20.3944, 7.3673>
		<-3.0877, 20.4301, 7.9080> <-3.0877, 20.4301, 7.7458> <-3.0686, 20.4492, 7.5273> <-3.0877, 20.4301, 7.3673>
		<-4.2757, 20.4301, 7.9080> <-4.2757, 20.4301, 7.7458> <-4.2947, 20.4492, 7.5273> <-4.2757, 20.4301, 7.3673>
		<-4.3114, 20.3944, 7.9080> <-4.3114, 20.3944, 7.7458> <-4.3305, 20.4134, 7.5273> <-4.3114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5589, 18.8874, 0.7771> <-4.6087, 18.9372, 0.7771> <-4.6087, 20.5920, 0.7771> <-4.5589, 20.6418, 0.7771>
		<-4.5796, 18.8666, 0.6520> <-4.6294, 18.9164, 0.6520> <-4.6294, 20.6127, 0.6520> <-4.5796, 20.6626, 0.6520>
		<-4.5589, 18.8874, 0.4772> <-4.6087, 18.9372, 0.4772> <-4.6087, 20.5920, 0.4772> <-4.5589, 20.6418, 0.4772>
		<-4.5589, 18.8874, 0.3486> <-4.6087, 18.9372, 0.3486> <-4.6087, 20.5920, 0.3486> <-4.5589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5589, 18.8874, 0.7771> <-4.5796, 18.8666, 0.6520> <-4.5589, 18.8874, 0.4772> <-4.5589, 18.8874, 0.3486>
		<-4.5090, 18.8376, 0.7771> <-4.5298, 18.8168, 0.6520> <-4.5090, 18.8376, 0.4772> <-4.5090, 18.8376, 0.3486>
		<-2.8543, 18.8376, 0.7771> <-2.8335, 18.8168, 0.6520> <-2.8543, 18.8376, 0.4772> <-2.8543, 18.8376, 0.3486>
		<-2.8045, 18.8874, 0.7771> <-2.7837, 18.8666, 0.6520> <-2.8045, 18.8874, 0.4772> <-2.8045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8045, 18.8874, 0.7771> <-2.7837, 18.8666, 0.6520> <-2.8045, 18.8874, 0.4772> <-2.8045, 18.8874, 0.3486>
		<-2.7546, 18.9372, 0.7771> <-2.7339, 18.9164, 0.6520> <-2.7546, 18.9372, 0.4772> <-2.7546, 18.9372, 0.3486>
		<-2.7546, 20.5920, 0.7771> <-2.7339, 20.6127, 0.6520> <-2.7546, 20.5920, 0.4772> <-2.7546, 20.5920, 0.3486>
		<-2.8045, 20.6418, 0.7771> <-2.7837, 20.6626, 0.6520> <-2.8045, 20.6418, 0.4772> <-2.8045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8045, 20.6418, 0.7771> <-2.7837, 20.6626, 0.6520> <-2.8045, 20.6418, 0.4772> <-2.8045, 20.6418, 0.3486>
		<-2.8543, 20.6916, 0.7771> <-2.8335, 20.7124, 0.6520> <-2.8543, 20.6916, 0.4772> <-2.8543, 20.6916, 0.3486>
		<-4.5090, 20.6916, 0.7771> <-4.5298, 20.7124, 0.6520> <-4.5090, 20.6916, 0.4772> <-4.5090, 20.6916, 0.3486>
		<-4.5589, 20.6418, 0.7771> <-4.5796, 20.6626, 0.6520> <-4.5589, 20.6418, 0.4772> <-4.5589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5589, 18.8874, -0.0618> <-4.5589, 18.8874, 0.0613> <-4.5589, 18.8874, 0.2255> <-4.5589, 18.8874, 0.3486>
		<-4.6087, 18.9372, -0.0618> <-4.6087, 18.9372, 0.0613> <-4.6087, 18.9372, 0.2255> <-4.6087, 18.9372, 0.3486>
		<-4.6087, 20.5920, -0.0618> <-4.6087, 20.5920, 0.0613> <-4.6087, 20.5920, 0.2255> <-4.6087, 20.5920, 0.3486>
		<-4.5589, 20.6418, -0.0618> <-4.5589, 20.6418, 0.0613> <-4.5589, 20.6418, 0.2255> <-4.5589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.5589, 18.8874, -0.0618> <-4.5090, 18.8376, -0.0618> <-2.8543, 18.8376, -0.0618> <-2.8045, 18.8874, -0.0618>
		<-4.5589, 18.8874, 0.0613> <-4.5090, 18.8376, 0.0613> <-2.8543, 18.8376, 0.0613> <-2.8045, 18.8874, 0.0613>
		<-4.5589, 18.8874, 0.2255> <-4.5090, 18.8376, 0.2255> <-2.8543, 18.8376, 0.2255> <-2.8045, 18.8874, 0.2255>
		<-4.5589, 18.8874, 0.3486> <-4.5090, 18.8376, 0.3486> <-2.8543, 18.8376, 0.3486> <-2.8045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8045, 18.8874, -0.0618> <-2.7546, 18.9372, -0.0618> <-2.7546, 20.5920, -0.0618> <-2.8045, 20.6418, -0.0618>
		<-2.8045, 18.8874, 0.0613> <-2.7546, 18.9372, 0.0613> <-2.7546, 20.5920, 0.0613> <-2.8045, 20.6418, 0.0613>
		<-2.8045, 18.8874, 0.2255> <-2.7546, 18.9372, 0.2255> <-2.7546, 20.5920, 0.2255> <-2.8045, 20.6418, 0.2255>
		<-2.8045, 18.8874, 0.3486> <-2.7546, 18.9372, 0.3486> <-2.7546, 20.5920, 0.3486> <-2.8045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.8045, 20.6418, -0.0618> <-2.8543, 20.6916, -0.0618> <-4.5090, 20.6916, -0.0618> <-4.5589, 20.6418, -0.0618>
		<-2.8045, 20.6418, 0.0613> <-2.8543, 20.6916, 0.0613> <-4.5090, 20.6916, 0.0613> <-4.5589, 20.6418, 0.0613>
		<-2.8045, 20.6418, 0.2255> <-2.8543, 20.6916, 0.2255> <-4.5090, 20.6916, 0.2255> <-4.5589, 20.6418, 0.2255>
		<-2.8045, 20.6418, 0.3486> <-2.8543, 20.6916, 0.3486> <-4.5090, 20.6916, 0.3486> <-4.5589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 0.9062> <-2.3109, 19.0245, 0.9062> <-2.3109, 20.5047, 0.9062> <-2.2664, 20.5493, 0.9062>
		<-2.2712, 18.9751, 0.8515> <-2.3157, 19.0196, 0.8515> <-2.3157, 20.5095, 0.8515> <-2.2712, 20.5541, 0.8515>
		<-2.3500, 18.8963, 0.8308> <-2.3998, 18.9461, 0.8308> <-2.3998, 20.5831, 0.8308> <-2.3500, 20.6329, 0.8308>
		<-2.3589, 18.8874, 0.7771> <-2.4087, 18.9372, 0.7771> <-2.4087, 20.5920, 0.7771> <-2.3589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 0.9062> <-2.2620, 18.9842, 0.9557> <-2.3560, 18.8903, 0.9996> <-2.3357, 18.9105, 1.0404>
		<-2.3109, 19.0245, 0.9062> <-2.3066, 19.0288, 0.9557> <-2.4045, 18.9388, 0.9996> <-2.3843, 18.9590, 1.0404>
		<-2.3109, 20.5047, 0.9062> <-2.3066, 20.5004, 0.9557> <-2.4045, 20.5904, 0.9996> <-2.3843, 20.5702, 1.0404>
		<-2.2664, 20.5493, 0.9062> <-2.2620, 20.5449, 0.9557> <-2.3560, 20.6389, 0.9996> <-2.3357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 0.9062> <-2.2712, 18.9751, 0.8515> <-2.3500, 18.8963, 0.8308> <-2.3589, 18.8874, 0.7771>
		<-2.2218, 18.9353, 0.9062> <-2.2266, 18.9305, 0.8515> <-2.3001, 18.8465, 0.8308> <-2.3090, 18.8376, 0.7771>
		<-0.7415, 18.9353, 0.9062> <-0.7367, 18.9305, 0.8515> <-0.6632, 18.8465, 0.8308> <-0.6543, 18.8376, 0.7771>
		<-0.6970, 18.9799, 0.9062> <-0.6922, 18.9751, 0.8515> <-0.6134, 18.8963, 0.8308> <-0.6045, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 0.9062> <-2.2218, 18.9353, 0.9062> <-0.7415, 18.9353, 0.9062> <-0.6970, 18.9799, 0.9062>
		<-2.2620, 18.9842, 0.9557> <-2.2175, 18.9397, 0.9557> <-0.7459, 18.9397, 0.9557> <-0.7013, 18.9842, 0.9557>
		<-2.3560, 18.8903, 0.9996> <-2.3075, 18.8418, 0.9996> <-0.6559, 18.8418, 0.9996> <-0.6073, 18.8903, 0.9996>
		<-2.3357, 18.9105, 1.0404> <-2.2872, 18.8620, 1.0404> <-0.6761, 18.8620, 1.0404> <-0.6276, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 18.9799, 0.9062> <-0.6922, 18.9751, 0.8515> <-0.6134, 18.8963, 0.8308> <-0.6045, 18.8874, 0.7771>
		<-0.6524, 19.0245, 0.9062> <-0.6476, 19.0196, 0.8515> <-0.5635, 18.9461, 0.8308> <-0.5546, 18.9372, 0.7771>
		<-0.6524, 20.5047, 0.9062> <-0.6476, 20.5095, 0.8515> <-0.5635, 20.5831, 0.8308> <-0.5546, 20.5920, 0.7771>
		<-0.6970, 20.5493, 0.9062> <-0.6922, 20.5541, 0.8515> <-0.6134, 20.6329, 0.8308> <-0.6045, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 18.9799, 0.9062> <-0.6524, 19.0245, 0.9062> <-0.6524, 20.5047, 0.9062> <-0.6970, 20.5493, 0.9062>
		<-0.7013, 18.9842, 0.9557> <-0.6567, 19.0288, 0.9557> <-0.6567, 20.5004, 0.9557> <-0.7013, 20.5449, 0.9557>
		<-0.6073, 18.8903, 0.9996> <-0.5588, 18.9388, 0.9996> <-0.5588, 20.5904, 0.9996> <-0.6073, 20.6389, 0.9996>
		<-0.6276, 18.9105, 1.0404> <-0.5791, 18.9590, 1.0404> <-0.5791, 20.5702, 1.0404> <-0.6276, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 20.5493, 0.9062> <-0.6922, 20.5541, 0.8515> <-0.6134, 20.6329, 0.8308> <-0.6045, 20.6418, 0.7771>
		<-0.7415, 20.5939, 0.9062> <-0.7367, 20.5987, 0.8515> <-0.6632, 20.6827, 0.8308> <-0.6543, 20.6916, 0.7771>
		<-2.2218, 20.5939, 0.9062> <-2.2266, 20.5987, 0.8515> <-2.3001, 20.6827, 0.8308> <-2.3090, 20.6916, 0.7771>
		<-2.2664, 20.5493, 0.9062> <-2.2712, 20.5541, 0.8515> <-2.3500, 20.6329, 0.8308> <-2.3589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 20.5493, 0.9062> <-0.7415, 20.5939, 0.9062> <-2.2218, 20.5939, 0.9062> <-2.2664, 20.5493, 0.9062>
		<-0.7013, 20.5449, 0.9557> <-0.7459, 20.5895, 0.9557> <-2.2175, 20.5895, 0.9557> <-2.2620, 20.5449, 0.9557>
		<-0.6073, 20.6389, 0.9996> <-0.6559, 20.6874, 0.9996> <-2.3075, 20.6874, 0.9996> <-2.3560, 20.6389, 0.9996>
		<-0.6276, 20.6187, 1.0404> <-0.6761, 20.6672, 1.0404> <-2.2872, 20.6672, 1.0404> <-2.3357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3357, 18.9105, 1.0404> <-2.2677, 18.9786, 1.1777> <-2.0982, 19.1481, 1.2552> <-2.0269, 19.2193, 1.3892>
		<-2.3843, 18.9590, 1.0404> <-2.3162, 19.0271, 1.1777> <-2.1291, 19.1790, 1.2552> <-2.0579, 19.2503, 1.3892>
		<-2.3843, 20.5702, 1.0404> <-2.3162, 20.5021, 1.1777> <-2.1291, 20.3501, 1.2552> <-2.0579, 20.2789, 1.3892>
		<-2.3357, 20.6187, 1.0404> <-2.2677, 20.5506, 1.1777> <-2.0982, 20.3811, 1.2552> <-2.0269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3357, 18.9105, 1.0404> <-2.2872, 18.8620, 1.0404> <-0.6761, 18.8620, 1.0404> <-0.6276, 18.9105, 1.0404>
		<-2.2677, 18.9786, 1.1777> <-2.2192, 18.9301, 1.1777> <-0.7442, 18.9301, 1.1777> <-0.6957, 18.9786, 1.1777>
		<-2.0982, 19.1481, 1.2552> <-2.0672, 19.1171, 1.2552> <-0.8961, 19.1171, 1.2552> <-0.8652, 19.1481, 1.2552>
		<-2.0269, 19.2193, 1.3892> <-1.9959, 19.1884, 1.3892> <-0.9674, 19.1884, 1.3892> <-0.9364, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6276, 18.9105, 1.0404> <-0.5791, 18.9590, 1.0404> <-0.5791, 20.5702, 1.0404> <-0.6276, 20.6187, 1.0404>
		<-0.6957, 18.9786, 1.1777> <-0.6471, 19.0271, 1.1777> <-0.6471, 20.5021, 1.1777> <-0.6957, 20.5506, 1.1777>
		<-0.8652, 19.1481, 1.2552> <-0.8342, 19.1790, 1.2552> <-0.8342, 20.3501, 1.2552> <-0.8652, 20.3811, 1.2552>
		<-0.9364, 19.2193, 1.3892> <-0.9054, 19.2503, 1.3892> <-0.9054, 20.2789, 1.3892> <-0.9364, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6276, 20.6187, 1.0404> <-0.6761, 20.6672, 1.0404> <-2.2872, 20.6672, 1.0404> <-2.3357, 20.6187, 1.0404>
		<-0.6957, 20.5506, 1.1777> <-0.7442, 20.5991, 1.1777> <-2.2192, 20.5991, 1.1777> <-2.2677, 20.5506, 1.1777>
		<-0.8652, 20.3811, 1.2552> <-0.8961, 20.4121, 1.2552> <-2.0672, 20.4121, 1.2552> <-2.0982, 20.3811, 1.2552>
		<-0.9364, 20.3098, 1.3892> <-0.9674, 20.3408, 1.3892> <-1.9959, 20.3408, 1.3892> <-2.0269, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0269, 19.2193, 1.3892> <-2.0079, 19.2383, 1.4249> <-2.0837, 19.1626, 1.4698> <-2.0837, 19.1626, 1.5144>
		<-2.0579, 19.2503, 1.3892> <-2.0389, 19.2693, 1.4249> <-2.1179, 19.1968, 1.4698> <-2.1179, 19.1968, 1.5144>
		<-2.0579, 20.2789, 1.3892> <-2.0389, 20.2599, 1.4249> <-2.1179, 20.3324, 1.4698> <-2.1179, 20.3324, 1.5144>
		<-2.0269, 20.3098, 1.3892> <-2.0079, 20.2909, 1.4249> <-2.0837, 20.3666, 1.4698> <-2.0837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0269, 19.2193, 1.3892> <-1.9959, 19.1884, 1.3892> <-0.9674, 19.1884, 1.3892> <-0.9364, 19.2193, 1.3892>
		<-2.0079, 19.2383, 1.4249> <-1.9770, 19.2073, 1.4249> <-0.9863, 19.2073, 1.4249> <-0.9554, 19.2383, 1.4249>
		<-2.0837, 19.1626, 1.4698> <-2.0495, 19.1284, 1.4698> <-0.9138, 19.1284, 1.4698> <-0.8796, 19.1626, 1.4698>
		<-2.0837, 19.1626, 1.5144> <-2.0495, 19.1284, 1.5144> <-0.9138, 19.1284, 1.5144> <-0.8796, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9364, 19.2193, 1.3892> <-0.9054, 19.2503, 1.3892> <-0.9054, 20.2789, 1.3892> <-0.9364, 20.3098, 1.3892>
		<-0.9554, 19.2383, 1.4249> <-0.9244, 19.2693, 1.4249> <-0.9244, 20.2599, 1.4249> <-0.9554, 20.2909, 1.4249>
		<-0.8796, 19.1626, 1.4698> <-0.8455, 19.1968, 1.4698> <-0.8455, 20.3324, 1.4698> <-0.8796, 20.3666, 1.4698>
		<-0.8796, 19.1626, 1.5144> <-0.8455, 19.1968, 1.5144> <-0.8455, 20.3324, 1.5144> <-0.8796, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9364, 20.3098, 1.3892> <-0.9674, 20.3408, 1.3892> <-1.9959, 20.3408, 1.3892> <-2.0269, 20.3098, 1.3892>
		<-0.9554, 20.2909, 1.4249> <-0.9863, 20.3218, 1.4249> <-1.9770, 20.3218, 1.4249> <-2.0079, 20.2909, 1.4249>
		<-0.8796, 20.3666, 1.4698> <-0.9138, 20.4008, 1.4698> <-2.0495, 20.4008, 1.4698> <-2.0837, 20.3666, 1.4698>
		<-0.8796, 20.3666, 1.5144> <-0.9138, 20.4008, 1.5144> <-2.0495, 20.4008, 1.5144> <-2.0837, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0837, 19.1626, 1.5144> <-2.0837, 19.1626, 1.5613> <-2.0121, 19.2341, 1.6066> <-2.0269, 19.2193, 1.6486>
		<-2.1179, 19.1968, 1.5144> <-2.1179, 19.1968, 1.5613> <-2.0431, 19.2651, 1.6066> <-2.0579, 19.2503, 1.6486>
		<-2.1179, 20.3324, 1.5144> <-2.1179, 20.3324, 1.5613> <-2.0431, 20.2641, 1.6066> <-2.0579, 20.2789, 1.6486>
		<-2.0837, 20.3666, 1.5144> <-2.0837, 20.3666, 1.5613> <-2.0121, 20.2950, 1.6066> <-2.0269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0837, 19.1626, 1.5144> <-2.0495, 19.1284, 1.5144> <-0.9138, 19.1284, 1.5144> <-0.8796, 19.1626, 1.5144>
		<-2.0837, 19.1626, 1.5613> <-2.0495, 19.1284, 1.5613> <-0.9138, 19.1284, 1.5613> <-0.8796, 19.1626, 1.5613>
		<-2.0121, 19.2341, 1.6066> <-1.9812, 19.2032, 1.6066> <-0.9822, 19.2032, 1.6066> <-0.9512, 19.2341, 1.6066>
		<-2.0269, 19.2193, 1.6486> <-1.9959, 19.1884, 1.6486> <-0.9674, 19.1884, 1.6486> <-0.9364, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8796, 19.1626, 1.5144> <-0.8455, 19.1968, 1.5144> <-0.8455, 20.3324, 1.5144> <-0.8796, 20.3666, 1.5144>
		<-0.8796, 19.1626, 1.5613> <-0.8455, 19.1968, 1.5613> <-0.8455, 20.3324, 1.5613> <-0.8796, 20.3666, 1.5613>
		<-0.9512, 19.2341, 1.6066> <-0.9202, 19.2651, 1.6066> <-0.9202, 20.2641, 1.6066> <-0.9512, 20.2950, 1.6066>
		<-0.9364, 19.2193, 1.6486> <-0.9054, 19.2503, 1.6486> <-0.9054, 20.2789, 1.6486> <-0.9364, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8796, 20.3666, 1.5144> <-0.9138, 20.4008, 1.5144> <-2.0495, 20.4008, 1.5144> <-2.0837, 20.3666, 1.5144>
		<-0.8796, 20.3666, 1.5613> <-0.9138, 20.4008, 1.5613> <-2.0495, 20.4008, 1.5613> <-2.0837, 20.3666, 1.5613>
		<-0.9512, 20.2950, 1.6066> <-0.9822, 20.3260, 1.6066> <-1.9812, 20.3260, 1.6066> <-2.0121, 20.2950, 1.6066>
		<-0.9364, 20.3098, 1.6486> <-0.9674, 20.3408, 1.6486> <-1.9959, 20.3408, 1.6486> <-2.0269, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0269, 19.2193, 1.6486> <-2.0754, 19.1709, 1.7862> <-2.2172, 19.0290, 1.8960> <-2.2664, 18.9799, 2.0332>
		<-2.0579, 19.2503, 1.6486> <-2.1063, 19.2018, 1.7862> <-2.2618, 19.0736, 1.8960> <-2.3109, 19.0245, 2.0332>
		<-2.0579, 20.2789, 1.6486> <-2.1063, 20.3273, 1.7862> <-2.2618, 20.4556, 1.8960> <-2.3109, 20.5047, 2.0332>
		<-2.0269, 20.3098, 1.6486> <-2.0754, 20.3583, 1.7862> <-2.2172, 20.5002, 1.8960> <-2.2664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0269, 19.2193, 1.6486> <-1.9959, 19.1884, 1.6486> <-0.9674, 19.1884, 1.6486> <-0.9364, 19.2193, 1.6486>
		<-2.0754, 19.1709, 1.7862> <-2.0444, 19.1399, 1.7862> <-0.9189, 19.1399, 1.7862> <-0.8880, 19.1709, 1.7862>
		<-2.2172, 19.0290, 1.8960> <-2.1727, 18.9844, 1.8960> <-0.7907, 18.9844, 1.8960> <-0.7461, 19.0290, 1.8960>
		<-2.2664, 18.9799, 2.0332> <-2.2218, 18.9353, 2.0332> <-0.7415, 18.9353, 2.0332> <-0.6970, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9364, 19.2193, 1.6486> <-0.9054, 19.2503, 1.6486> <-0.9054, 20.2789, 1.6486> <-0.9364, 20.3098, 1.6486>
		<-0.8880, 19.1709, 1.7862> <-0.8570, 19.2018, 1.7862> <-0.8570, 20.3273, 1.7862> <-0.8880, 20.3583, 1.7862>
		<-0.7461, 19.0290, 1.8960> <-0.7015, 19.0736, 1.8960> <-0.7015, 20.4556, 1.8960> <-0.7461, 20.5002, 1.8960>
		<-0.6970, 18.9799, 2.0332> <-0.6524, 19.0245, 2.0332> <-0.6524, 20.5047, 2.0332> <-0.6970, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9364, 20.3098, 1.6486> <-0.9674, 20.3408, 1.6486> <-1.9959, 20.3408, 1.6486> <-2.0269, 20.3098, 1.6486>
		<-0.8880, 20.3583, 1.7862> <-0.9189, 20.3893, 1.7862> <-2.0444, 20.3893, 1.7862> <-2.0754, 20.3583, 1.7862>
		<-0.7461, 20.5002, 1.8960> <-0.7907, 20.5447, 1.8960> <-2.1727, 20.5447, 1.8960> <-2.2172, 20.5002, 1.8960>
		<-0.6970, 20.5493, 2.0332> <-0.7415, 20.5939, 2.0332> <-2.2218, 20.5939, 2.0332> <-2.2664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 2.0332> <-2.2930, 18.9533, 2.1074> <-2.2932, 18.9531, 2.2382> <-2.2641, 18.9822, 2.3104>
		<-2.3109, 19.0245, 2.0332> <-2.3375, 18.9979, 2.1074> <-2.3376, 18.9975, 2.2382> <-2.3085, 19.0266, 2.3104>
		<-2.3109, 20.5047, 2.0332> <-2.3375, 20.5313, 2.1074> <-2.3376, 20.5317, 2.2382> <-2.3085, 20.5025, 2.3104>
		<-2.2664, 20.5493, 2.0332> <-2.2930, 20.5759, 2.1074> <-2.2932, 20.5761, 2.2382> <-2.2641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2664, 18.9799, 2.0332> <-2.2218, 18.9353, 2.0332> <-0.7415, 18.9353, 2.0332> <-0.6970, 18.9799, 2.0332>
		<-2.2930, 18.9533, 2.1074> <-2.2484, 18.9087, 2.1074> <-0.7149, 18.9087, 2.1074> <-0.6704, 18.9533, 2.1074>
		<-2.2932, 18.9531, 2.2382> <-2.2488, 18.9086, 2.2382> <-0.7146, 18.9086, 2.2382> <-0.6701, 18.9531, 2.2382>
		<-2.2641, 18.9822, 2.3104> <-2.2196, 18.9378, 2.3104> <-0.7437, 18.9378, 2.3104> <-0.6993, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 18.9799, 2.0332> <-0.6524, 19.0245, 2.0332> <-0.6524, 20.5047, 2.0332> <-0.6970, 20.5493, 2.0332>
		<-0.6704, 18.9533, 2.1074> <-0.6258, 18.9979, 2.1074> <-0.6258, 20.5313, 2.1074> <-0.6704, 20.5759, 2.1074>
		<-0.6701, 18.9531, 2.2382> <-0.6257, 18.9975, 2.2382> <-0.6257, 20.5317, 2.2382> <-0.6701, 20.5761, 2.2382>
		<-0.6993, 18.9822, 2.3104> <-0.6548, 19.0266, 2.3104> <-0.6548, 20.5025, 2.3104> <-0.6993, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6970, 20.5493, 2.0332> <-0.7415, 20.5939, 2.0332> <-2.2218, 20.5939, 2.0332> <-2.2664, 20.5493, 2.0332>
		<-0.6704, 20.5759, 2.1074> <-0.7149, 20.6204, 2.1074> <-2.2484, 20.6204, 2.1074> <-2.2930, 20.5759, 2.1074>
		<-0.6701, 20.5761, 2.2382> <-0.7146, 20.6206, 2.2382> <-2.2488, 20.6206, 2.2382> <-2.2932, 20.5761, 2.2382>
		<-0.6993, 20.5470, 2.3104> <-0.7437, 20.5914, 2.3104> <-2.2196, 20.5914, 2.3104> <-2.2641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2641, 18.9822, 2.3104> <-2.1801, 19.0661, 2.5186> <-1.9843, 19.2620, 2.7154> <-1.9056, 19.3406, 2.9276>
		<-2.3085, 19.0266, 2.3104> <-2.2246, 19.1106, 2.5186> <-2.0084, 19.2860, 2.7154> <-1.9297, 19.3647, 2.9276>
		<-2.3085, 20.5025, 2.3104> <-2.2246, 20.4186, 2.5186> <-2.0084, 20.2431, 2.7154> <-1.9297, 20.1645, 2.9276>
		<-2.2641, 20.5470, 2.3104> <-2.1801, 20.4630, 2.5186> <-1.9843, 20.2672, 2.7154> <-1.9056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.2641, 18.9822, 2.3104> <-2.2196, 18.9378, 2.3104> <-0.7437, 18.9378, 2.3104> <-0.6993, 18.9822, 2.3104>
		<-2.1801, 19.0661, 2.5186> <-2.1357, 19.0217, 2.5186> <-0.8277, 19.0217, 2.5186> <-0.7832, 19.0661, 2.5186>
		<-1.9843, 19.2620, 2.7154> <-1.9602, 19.2379, 2.7154> <-1.0031, 19.2379, 2.7154> <-0.9790, 19.2620, 2.7154>
		<-1.9056, 19.3406, 2.9276> <-1.8815, 19.3165, 2.9276> <-1.0818, 19.3165, 2.9276> <-1.0577, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6993, 18.9822, 2.3104> <-0.6548, 19.0266, 2.3104> <-0.6548, 20.5025, 2.3104> <-0.6993, 20.5470, 2.3104>
		<-0.7832, 19.0661, 2.5186> <-0.7388, 19.1106, 2.5186> <-0.7388, 20.4186, 2.5186> <-0.7832, 20.4630, 2.5186>
		<-0.9790, 19.2620, 2.7154> <-0.9550, 19.2860, 2.7154> <-0.9550, 20.2431, 2.7154> <-0.9790, 20.2672, 2.7154>
		<-1.0577, 19.3406, 2.9276> <-1.0336, 19.3647, 2.9276> <-1.0336, 20.1645, 2.9276> <-1.0577, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6993, 20.5470, 2.3104> <-0.7437, 20.5914, 2.3104> <-2.2196, 20.5914, 2.3104> <-2.2641, 20.5470, 2.3104>
		<-0.7832, 20.4630, 2.5186> <-0.8277, 20.5075, 2.5186> <-2.1357, 20.5075, 2.5186> <-2.1801, 20.4630, 2.5186>
		<-0.9790, 20.2672, 2.7154> <-1.0031, 20.2913, 2.7154> <-1.9602, 20.2913, 2.7154> <-1.9843, 20.2672, 2.7154>
		<-1.0577, 20.1885, 2.9276> <-1.0818, 20.2126, 2.9276> <-1.8815, 20.2126, 2.9276> <-1.9056, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9056, 19.3406, 2.9276> <-1.8887, 19.3576, 2.9732> <-1.9889, 19.2574, 3.0012> <-1.9889, 19.2574, 3.0528>
		<-1.9297, 19.3647, 2.9276> <-1.9128, 19.3816, 2.9732> <-2.0177, 19.2862, 3.0012> <-2.0177, 19.2862, 3.0528>
		<-1.9297, 20.1645, 2.9276> <-1.9128, 20.1475, 2.9732> <-2.0177, 20.2430, 3.0012> <-2.0177, 20.2430, 3.0528>
		<-1.9056, 20.1885, 2.9276> <-1.8887, 20.1716, 2.9732> <-1.9889, 20.2718, 3.0012> <-1.9889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9056, 19.3406, 2.9276> <-1.8815, 19.3165, 2.9276> <-1.0818, 19.3165, 2.9276> <-1.0577, 19.3406, 2.9276>
		<-1.8887, 19.3576, 2.9732> <-1.8646, 19.3335, 2.9732> <-1.0987, 19.3335, 2.9732> <-1.0746, 19.3576, 2.9732>
		<-1.9889, 19.2574, 3.0012> <-1.9601, 19.2286, 3.0012> <-1.0033, 19.2286, 3.0012> <-0.9745, 19.2574, 3.0012>
		<-1.9889, 19.2574, 3.0528> <-1.9601, 19.2286, 3.0528> <-1.0033, 19.2286, 3.0528> <-0.9745, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0577, 19.3406, 2.9276> <-1.0336, 19.3647, 2.9276> <-1.0336, 20.1645, 2.9276> <-1.0577, 20.1885, 2.9276>
		<-1.0746, 19.3576, 2.9732> <-1.0506, 19.3816, 2.9732> <-1.0506, 20.1475, 2.9732> <-1.0746, 20.1716, 2.9732>
		<-0.9745, 19.2574, 3.0012> <-0.9456, 19.2862, 3.0012> <-0.9456, 20.2430, 3.0012> <-0.9745, 20.2718, 3.0012>
		<-0.9745, 19.2574, 3.0528> <-0.9456, 19.2862, 3.0528> <-0.9456, 20.2430, 3.0528> <-0.9745, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0577, 20.1885, 2.9276> <-1.0818, 20.2126, 2.9276> <-1.8815, 20.2126, 2.9276> <-1.9056, 20.1885, 2.9276>
		<-1.0746, 20.1716, 2.9732> <-1.0987, 20.1957, 2.9732> <-1.8646, 20.1957, 2.9732> <-1.8887, 20.1716, 2.9732>
		<-0.9745, 20.2718, 3.0012> <-1.0033, 20.3006, 3.0012> <-1.9601, 20.3006, 3.0012> <-1.9889, 20.2718, 3.0012>
		<-0.9745, 20.2718, 3.0528> <-1.0033, 20.3006, 3.0528> <-1.9601, 20.3006, 3.0528> <-1.9889, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9889, 19.2574, 3.0528> <-1.9889, 19.2574, 3.1044> <-1.8862, 19.3600, 3.1344> <-1.9056, 19.3406, 3.1780>
		<-2.0177, 19.2862, 3.0528> <-2.0177, 19.2862, 3.1044> <-1.9103, 19.3841, 3.1344> <-1.9297, 19.3647, 3.1780>
		<-2.0177, 20.2430, 3.0528> <-2.0177, 20.2430, 3.1044> <-1.9103, 20.1451, 3.1344> <-1.9297, 20.1645, 3.1780>
		<-1.9889, 20.2718, 3.0528> <-1.9889, 20.2718, 3.1044> <-1.8862, 20.1691, 3.1344> <-1.9056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9889, 19.2574, 3.0528> <-1.9601, 19.2286, 3.0528> <-1.0033, 19.2286, 3.0528> <-0.9745, 19.2574, 3.0528>
		<-1.9889, 19.2574, 3.1044> <-1.9601, 19.2286, 3.1044> <-1.0033, 19.2286, 3.1044> <-0.9745, 19.2574, 3.1044>
		<-1.8862, 19.3600, 3.1344> <-1.8621, 19.3359, 3.1344> <-1.1012, 19.3359, 3.1344> <-1.0771, 19.3600, 3.1344>
		<-1.9056, 19.3406, 3.1780> <-1.8815, 19.3165, 3.1780> <-1.0818, 19.3165, 3.1780> <-1.0577, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9745, 19.2574, 3.0528> <-0.9456, 19.2862, 3.0528> <-0.9456, 20.2430, 3.0528> <-0.9745, 20.2718, 3.0528>
		<-0.9745, 19.2574, 3.1044> <-0.9456, 19.2862, 3.1044> <-0.9456, 20.2430, 3.1044> <-0.9745, 20.2718, 3.1044>
		<-1.0771, 19.3600, 3.1344> <-1.0530, 19.3841, 3.1344> <-1.0530, 20.1451, 3.1344> <-1.0771, 20.1691, 3.1344>
		<-1.0577, 19.3406, 3.1780> <-1.0336, 19.3647, 3.1780> <-1.0336, 20.1645, 3.1780> <-1.0577, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9745, 20.2718, 3.0528> <-1.0033, 20.3006, 3.0528> <-1.9601, 20.3006, 3.0528> <-1.9889, 20.2718, 3.0528>
		<-0.9745, 20.2718, 3.1044> <-1.0033, 20.3006, 3.1044> <-1.9601, 20.3006, 3.1044> <-1.9889, 20.2718, 3.1044>
		<-1.0771, 20.1691, 3.1344> <-1.1012, 20.1932, 3.1344> <-1.8621, 20.1932, 3.1344> <-1.8862, 20.1691, 3.1344>
		<-1.0577, 20.1885, 3.1780> <-1.0818, 20.2126, 3.1780> <-1.8815, 20.2126, 3.1780> <-1.9056, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9056, 19.3406, 3.1780> <-1.9438, 19.3024, 3.2640> <-2.0610, 19.1852, 3.2738> <-2.1161, 19.1302, 3.3390>
		<-1.9297, 19.3647, 3.1780> <-1.9679, 19.3265, 3.2640> <-2.0971, 19.2212, 3.2738> <-2.1521, 19.1662, 3.3390>
		<-1.9297, 20.1645, 3.1780> <-1.9679, 20.2027, 3.2640> <-2.0971, 20.3079, 3.2738> <-2.1521, 20.3629, 3.3390>
		<-1.9056, 20.1885, 3.1780> <-1.9438, 20.2267, 3.2640> <-2.0610, 20.3440, 3.2738> <-2.1161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9056, 19.3406, 3.1780> <-1.8815, 19.3165, 3.1780> <-1.0818, 19.3165, 3.1780> <-1.0577, 19.3406, 3.1780>
		<-1.9438, 19.3024, 3.2640> <-1.9197, 19.2784, 3.2640> <-1.0436, 19.2784, 3.2640> <-1.0195, 19.3024, 3.2640>
		<-2.0610, 19.1852, 3.2738> <-2.0250, 19.1492, 3.2738> <-0.9383, 19.1492, 3.2738> <-0.9023, 19.1852, 3.2738>
		<-2.1161, 19.1302, 3.3390> <-2.0800, 19.0942, 3.3390> <-0.8833, 19.0942, 3.3390> <-0.8473, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0577, 19.3406, 3.1780> <-1.0336, 19.3647, 3.1780> <-1.0336, 20.1645, 3.1780> <-1.0577, 20.1885, 3.1780>
		<-1.0195, 19.3024, 3.2640> <-0.9954, 19.3265, 3.2640> <-0.9954, 20.2027, 3.2640> <-1.0195, 20.2267, 3.2640>
		<-0.9023, 19.1852, 3.2738> <-0.8663, 19.2212, 3.2738> <-0.8663, 20.3079, 3.2738> <-0.9023, 20.3440, 3.2738>
		<-0.8473, 19.1302, 3.3390> <-0.8112, 19.1662, 3.3390> <-0.8112, 20.3629, 3.3390> <-0.8473, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0577, 20.1885, 3.1780> <-1.0818, 20.2126, 3.1780> <-1.8815, 20.2126, 3.1780> <-1.9056, 20.1885, 3.1780>
		<-1.0195, 20.2267, 3.2640> <-1.0436, 20.2508, 3.2640> <-1.9197, 20.2508, 3.2640> <-1.9438, 20.2267, 3.2640>
		<-0.9023, 20.3440, 3.2738> <-0.9383, 20.3800, 3.2738> <-2.0250, 20.3800, 3.2738> <-2.0610, 20.3440, 3.2738>
		<-0.8473, 20.3990, 3.3390> <-0.8833, 20.4350, 3.3390> <-2.0800, 20.4350, 3.3390> <-2.1161, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1161, 19.1302, 3.3390> <-2.1416, 19.1046, 3.3693> <-2.1797, 19.0665, 3.4419> <-2.1623, 19.0839, 3.4821>
		<-2.1521, 19.1662, 3.3390> <-2.1777, 19.1406, 3.3693> <-2.2184, 19.1052, 3.4419> <-2.2010, 19.1226, 3.4821>
		<-2.1521, 20.3629, 3.3390> <-2.1777, 20.3885, 3.3693> <-2.2184, 20.4240, 3.4419> <-2.2010, 20.4066, 3.4821>
		<-2.1161, 20.3990, 3.3390> <-2.1416, 20.4246, 3.3693> <-2.1797, 20.4627, 3.4419> <-2.1623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1161, 19.1302, 3.3390> <-2.0800, 19.0942, 3.3390> <-0.8833, 19.0942, 3.3390> <-0.8473, 19.1302, 3.3390>
		<-2.1416, 19.1046, 3.3693> <-2.1056, 19.0686, 3.3693> <-0.8577, 19.0686, 3.3693> <-0.8217, 19.1046, 3.3693>
		<-2.1797, 19.0665, 3.4419> <-2.1411, 19.0279, 3.4419> <-0.8223, 19.0279, 3.4419> <-0.7836, 19.0665, 3.4419>
		<-2.1623, 19.0839, 3.4821> <-2.1236, 19.0453, 3.4821> <-0.8397, 19.0453, 3.4821> <-0.8010, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8473, 19.1302, 3.3390> <-0.8112, 19.1662, 3.3390> <-0.8112, 20.3629, 3.3390> <-0.8473, 20.3990, 3.3390>
		<-0.8217, 19.1046, 3.3693> <-0.7857, 19.1406, 3.3693> <-0.7857, 20.3885, 3.3693> <-0.8217, 20.4246, 3.3693>
		<-0.7836, 19.0665, 3.4419> <-0.7449, 19.1052, 3.4419> <-0.7449, 20.4240, 3.4419> <-0.7836, 20.4627, 3.4419>
		<-0.8010, 19.0839, 3.4821> <-0.7624, 19.1226, 3.4821> <-0.7624, 20.4066, 3.4821> <-0.8010, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8473, 20.3990, 3.3390> <-0.8833, 20.4350, 3.3390> <-2.0800, 20.4350, 3.3390> <-2.1161, 20.3990, 3.3390>
		<-0.8217, 20.4246, 3.3693> <-0.8577, 20.4606, 3.3693> <-2.1056, 20.4606, 3.3693> <-2.1416, 20.4246, 3.3693>
		<-0.7836, 20.4627, 3.4419> <-0.8223, 20.5013, 3.4419> <-2.1411, 20.5013, 3.4419> <-2.1797, 20.4627, 3.4419>
		<-0.8010, 20.4452, 3.4821> <-0.8397, 20.4839, 3.4821> <-2.1236, 20.4839, 3.4821> <-2.1623, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1623, 19.0839, 3.4821> <-2.1163, 19.1300, 3.5884> <-1.9961, 19.2502, 3.6567> <-1.9380, 19.3083, 3.7504>
		<-2.2010, 19.1226, 3.4821> <-2.1550, 19.1686, 3.5884> <-2.0220, 19.2761, 3.6567> <-1.9639, 19.3342, 3.7504>
		<-2.2010, 20.4066, 3.4821> <-2.1550, 20.3606, 3.5884> <-2.0220, 20.2531, 3.6567> <-1.9639, 20.1950, 3.7504>
		<-2.1623, 20.4452, 3.4821> <-2.1163, 20.3992, 3.5884> <-1.9961, 20.2790, 3.6567> <-1.9380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1623, 19.0839, 3.4821> <-2.1236, 19.0453, 3.4821> <-0.8397, 19.0453, 3.4821> <-0.8010, 19.0839, 3.4821>
		<-2.1163, 19.1300, 3.5884> <-2.0776, 19.0913, 3.5884> <-0.8857, 19.0913, 3.5884> <-0.8470, 19.1300, 3.5884>
		<-1.9961, 19.2502, 3.6567> <-1.9702, 19.2242, 3.6567> <-0.9932, 19.2242, 3.6567> <-0.9672, 19.2502, 3.6567>
		<-1.9380, 19.3083, 3.7504> <-1.9121, 19.2823, 3.7504> <-1.0513, 19.2823, 3.7504> <-1.0253, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8010, 19.0839, 3.4821> <-0.7624, 19.1226, 3.4821> <-0.7624, 20.4066, 3.4821> <-0.8010, 20.4452, 3.4821>
		<-0.8470, 19.1300, 3.5884> <-0.8084, 19.1686, 3.5884> <-0.8084, 20.3606, 3.5884> <-0.8470, 20.3992, 3.5884>
		<-0.9672, 19.2502, 3.6567> <-0.9413, 19.2761, 3.6567> <-0.9413, 20.2531, 3.6567> <-0.9672, 20.2790, 3.6567>
		<-1.0253, 19.3083, 3.7504> <-0.9994, 19.3342, 3.7504> <-0.9994, 20.1950, 3.7504> <-1.0253, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8010, 20.4452, 3.4821> <-0.8397, 20.4839, 3.4821> <-2.1236, 20.4839, 3.4821> <-2.1623, 20.4452, 3.4821>
		<-0.8470, 20.3992, 3.5884> <-0.8857, 20.4379, 3.5884> <-2.0776, 20.4379, 3.5884> <-2.1163, 20.3992, 3.5884>
		<-0.9672, 20.2790, 3.6567> <-0.9932, 20.3049, 3.6567> <-1.9702, 20.3049, 3.6567> <-1.9961, 20.2790, 3.6567>
		<-1.0253, 20.2209, 3.7504> <-1.0513, 20.2468, 3.7504> <-1.9121, 20.2468, 3.7504> <-1.9380, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9380, 19.3083, 3.7504> <-1.8964, 19.3498, 3.8175> <-1.8527, 19.3935, 3.9241> <-1.8352, 19.4110, 4.0098>
		<-1.9639, 19.3342, 3.7504> <-1.9223, 19.3757, 3.8175> <-1.8728, 19.4136, 3.9241> <-1.8553, 19.4311, 4.0098>
		<-1.9639, 20.1950, 3.7504> <-1.9223, 20.1534, 3.8175> <-1.8728, 20.1156, 3.9241> <-1.8553, 20.0981, 4.0098>
		<-1.9380, 20.2209, 3.7504> <-1.8964, 20.1793, 3.8175> <-1.8527, 20.1356, 3.9241> <-1.8352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9380, 19.3083, 3.7504> <-1.9121, 19.2823, 3.7504> <-1.0513, 19.2823, 3.7504> <-1.0253, 19.3083, 3.7504>
		<-1.8964, 19.3498, 3.8175> <-1.8705, 19.3239, 3.8175> <-1.0928, 19.3239, 3.8175> <-1.0669, 19.3498, 3.8175>
		<-1.8527, 19.3935, 3.9241> <-1.8326, 19.3734, 3.9241> <-1.1307, 19.3734, 3.9241> <-1.1106, 19.3935, 3.9241>
		<-1.8352, 19.4110, 4.0098> <-1.8152, 19.3909, 4.0098> <-1.1482, 19.3909, 4.0098> <-1.1281, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0253, 19.3083, 3.7504> <-0.9994, 19.3342, 3.7504> <-0.9994, 20.1950, 3.7504> <-1.0253, 20.2209, 3.7504>
		<-1.0669, 19.3498, 3.8175> <-1.0410, 19.3757, 3.8175> <-1.0410, 20.1534, 3.8175> <-1.0669, 20.1793, 3.8175>
		<-1.1106, 19.3935, 3.9241> <-1.0905, 19.4136, 3.9241> <-1.0905, 20.1156, 3.9241> <-1.1106, 20.1356, 3.9241>
		<-1.1281, 19.4110, 4.0098> <-1.1080, 19.4311, 4.0098> <-1.1080, 20.0981, 4.0098> <-1.1281, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0253, 20.2209, 3.7504> <-1.0513, 20.2468, 3.7504> <-1.9121, 20.2468, 3.7504> <-1.9380, 20.2209, 3.7504>
		<-1.0669, 20.1793, 3.8175> <-1.0928, 20.2053, 3.8175> <-1.8705, 20.2053, 3.8175> <-1.8964, 20.1793, 3.8175>
		<-1.1106, 20.1356, 3.9241> <-1.1307, 20.1557, 3.9241> <-1.8326, 20.1557, 3.9241> <-1.8527, 20.1356, 3.9241>
		<-1.1281, 20.1182, 4.0098> <-1.1482, 20.1383, 4.0098> <-1.8152, 20.1383, 4.0098> <-1.8352, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8352, 19.4110, 4.0098> <-1.8168, 19.4294, 4.1002> <-1.8221, 19.4242, 4.2288> <-1.8213, 19.4250, 4.3229>
		<-1.8553, 19.4311, 4.0098> <-1.8369, 19.4495, 4.1002> <-1.8413, 19.4435, 4.2288> <-1.8405, 19.4443, 4.3229>
		<-1.8553, 20.0981, 4.0098> <-1.8369, 20.0797, 4.1002> <-1.8413, 20.0857, 4.2288> <-1.8405, 20.0849, 4.3229>
		<-1.8352, 20.1182, 4.0098> <-1.8168, 20.0997, 4.1002> <-1.8221, 20.1050, 4.2288> <-1.8213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8352, 19.4110, 4.0098> <-1.8152, 19.3909, 4.0098> <-1.1482, 19.3909, 4.0098> <-1.1281, 19.4110, 4.0098>
		<-1.8168, 19.4294, 4.1002> <-1.7967, 19.4094, 4.1002> <-1.1666, 19.4094, 4.1002> <-1.1465, 19.4294, 4.1002>
		<-1.8221, 19.4242, 4.2288> <-1.8028, 19.4049, 4.2288> <-1.1606, 19.4049, 4.2288> <-1.1413, 19.4242, 4.2288>
		<-1.8213, 19.4250, 4.3229> <-1.8020, 19.4057, 4.3229> <-1.1614, 19.4057, 4.3229> <-1.1421, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1281, 19.4110, 4.0098> <-1.1080, 19.4311, 4.0098> <-1.1080, 20.0981, 4.0098> <-1.1281, 20.1182, 4.0098>
		<-1.1465, 19.4294, 4.1002> <-1.1264, 19.4495, 4.1002> <-1.1264, 20.0797, 4.1002> <-1.1465, 20.0997, 4.1002>
		<-1.1413, 19.4242, 4.2288> <-1.1220, 19.4435, 4.2288> <-1.1220, 20.0857, 4.2288> <-1.1413, 20.1050, 4.2288>
		<-1.1421, 19.4250, 4.3229> <-1.1228, 19.4443, 4.3229> <-1.1228, 20.0849, 4.3229> <-1.1421, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1281, 20.1182, 4.0098> <-1.1482, 20.1383, 4.0098> <-1.8152, 20.1383, 4.0098> <-1.8352, 20.1182, 4.0098>
		<-1.1465, 20.0997, 4.1002> <-1.1666, 20.1198, 4.1002> <-1.7967, 20.1198, 4.1002> <-1.8168, 20.0997, 4.1002>
		<-1.1413, 20.1050, 4.2288> <-1.1606, 20.1243, 4.2288> <-1.8028, 20.1243, 4.2288> <-1.8221, 20.1050, 4.2288>
		<-1.1421, 20.1042, 4.3229> <-1.1614, 20.1235, 4.3229> <-1.8020, 20.1235, 4.3229> <-1.8213, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8213, 19.4250, 4.3229> <-1.8179, 19.4284, 4.7283> <-1.8197, 19.4265, 5.2689> <-1.8213, 19.4250, 5.6744>
		<-1.8405, 19.4443, 4.3229> <-1.8371, 19.4477, 4.7283> <-1.8390, 19.4458, 5.2689> <-1.8405, 19.4443, 5.6744>
		<-1.8405, 20.0849, 4.3229> <-1.8371, 20.0815, 4.7283> <-1.8390, 20.0834, 5.2689> <-1.8405, 20.0849, 5.6744>
		<-1.8213, 20.1042, 4.3229> <-1.8179, 20.1008, 4.7283> <-1.8197, 20.1027, 5.2689> <-1.8213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8213, 19.4250, 4.3229> <-1.8020, 19.4057, 4.3229> <-1.1614, 19.4057, 4.3229> <-1.1421, 19.4250, 4.3229>
		<-1.8179, 19.4284, 4.7283> <-1.7986, 19.4091, 4.7283> <-1.1648, 19.4091, 4.7283> <-1.1455, 19.4284, 4.7283>
		<-1.8197, 19.4265, 5.2689> <-1.8004, 19.4072, 5.2689> <-1.1629, 19.4072, 5.2689> <-1.1436, 19.4265, 5.2689>
		<-1.8213, 19.4250, 5.6744> <-1.8020, 19.4057, 5.6744> <-1.1614, 19.4057, 5.6744> <-1.1421, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1421, 19.4250, 4.3229> <-1.1228, 19.4443, 4.3229> <-1.1228, 20.0849, 4.3229> <-1.1421, 20.1042, 4.3229>
		<-1.1455, 19.4284, 4.7283> <-1.1262, 19.4477, 4.7283> <-1.1262, 20.0815, 4.7283> <-1.1455, 20.1008, 4.7283>
		<-1.1436, 19.4265, 5.2689> <-1.1243, 19.4458, 5.2689> <-1.1243, 20.0834, 5.2689> <-1.1436, 20.1027, 5.2689>
		<-1.1421, 19.4250, 5.6744> <-1.1228, 19.4443, 5.6744> <-1.1228, 20.0849, 5.6744> <-1.1421, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1421, 20.1042, 4.3229> <-1.1614, 20.1235, 4.3229> <-1.8020, 20.1235, 4.3229> <-1.8213, 20.1042, 4.3229>
		<-1.1455, 20.1008, 4.7283> <-1.1648, 20.1201, 4.7283> <-1.7986, 20.1201, 4.7283> <-1.8179, 20.1008, 4.7283>
		<-1.1436, 20.1027, 5.2689> <-1.1629, 20.1220, 5.2689> <-1.8004, 20.1220, 5.2689> <-1.8197, 20.1027, 5.2689>
		<-1.1421, 20.1042, 5.6744> <-1.1614, 20.1235, 5.6744> <-1.8020, 20.1235, 5.6744> <-1.8213, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8213, 19.4250, 5.6744> <-1.8225, 19.4237, 6.0073> <-1.8172, 19.4290, 6.4517> <-1.8305, 19.4157, 6.7841>
		<-1.8405, 19.4443, 5.6744> <-1.8418, 19.4430, 6.0073> <-1.8371, 19.4488, 6.4517> <-1.8503, 19.4355, 6.7841>
		<-1.8405, 20.0849, 5.6744> <-1.8418, 20.0861, 6.0073> <-1.8371, 20.0804, 6.4517> <-1.8503, 20.0936, 6.7841>
		<-1.8213, 20.1042, 5.6744> <-1.8225, 20.1054, 6.0073> <-1.8172, 20.1002, 6.4517> <-1.8305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8213, 19.4250, 5.6744> <-1.8020, 19.4057, 5.6744> <-1.1614, 19.4057, 5.6744> <-1.1421, 19.4250, 5.6744>
		<-1.8225, 19.4237, 6.0073> <-1.8032, 19.4044, 6.0073> <-1.1601, 19.4044, 6.0073> <-1.1408, 19.4237, 6.0073>
		<-1.8172, 19.4290, 6.4517> <-1.7974, 19.4092, 6.4517> <-1.1659, 19.4092, 6.4517> <-1.1461, 19.4290, 6.4517>
		<-1.8305, 19.4157, 6.7841> <-1.8107, 19.3959, 6.7841> <-1.1526, 19.3959, 6.7841> <-1.1328, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1421, 19.4250, 5.6744> <-1.1228, 19.4443, 5.6744> <-1.1228, 20.0849, 5.6744> <-1.1421, 20.1042, 5.6744>
		<-1.1408, 19.4237, 6.0073> <-1.1215, 19.4430, 6.0073> <-1.1215, 20.0861, 6.0073> <-1.1408, 20.1054, 6.0073>
		<-1.1461, 19.4290, 6.4517> <-1.1263, 19.4488, 6.4517> <-1.1263, 20.0804, 6.4517> <-1.1461, 20.1002, 6.4517>
		<-1.1328, 19.4157, 6.7841> <-1.1130, 19.4355, 6.7841> <-1.1130, 20.0936, 6.7841> <-1.1328, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1421, 20.1042, 5.6744> <-1.1614, 20.1235, 5.6744> <-1.8020, 20.1235, 5.6744> <-1.8213, 20.1042, 5.6744>
		<-1.1408, 20.1054, 6.0073> <-1.1601, 20.1247, 6.0073> <-1.8032, 20.1247, 6.0073> <-1.8225, 20.1054, 6.0073>
		<-1.1461, 20.1002, 6.4517> <-1.1659, 20.1200, 6.4517> <-1.7974, 20.1200, 6.4517> <-1.8172, 20.1002, 6.4517>
		<-1.1328, 20.1134, 6.7841> <-1.1526, 20.1333, 6.7841> <-1.8107, 20.1333, 6.7841> <-1.8305, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8305, 19.4157, 6.7841> <-1.8325, 19.4137, 6.8341> <-1.8449, 19.4013, 6.9079> <-1.8718, 19.3745, 6.9405>
		<-1.8503, 19.4355, 6.7841> <-1.8523, 19.4336, 6.8341> <-1.8671, 19.4235, 6.9079> <-1.8940, 19.3966, 6.9405>
		<-1.8503, 20.0936, 6.7841> <-1.8523, 20.0956, 6.8341> <-1.8671, 20.1057, 6.9079> <-1.8940, 20.1326, 6.9405>
		<-1.8305, 20.1134, 6.7841> <-1.8325, 20.1154, 6.8341> <-1.8449, 20.1278, 6.9079> <-1.8718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8305, 19.4157, 6.7841> <-1.8107, 19.3959, 6.7841> <-1.1526, 19.3959, 6.7841> <-1.1328, 19.4157, 6.7841>
		<-1.8325, 19.4137, 6.8341> <-1.8127, 19.3939, 6.8341> <-1.1506, 19.3939, 6.8341> <-1.1308, 19.4137, 6.8341>
		<-1.8449, 19.4013, 6.9079> <-1.8228, 19.3792, 6.9079> <-1.1406, 19.3792, 6.9079> <-1.1184, 19.4013, 6.9079>
		<-1.8718, 19.3745, 6.9405> <-1.8496, 19.3523, 6.9405> <-1.1137, 19.3523, 6.9405> <-1.0915, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1328, 19.4157, 6.7841> <-1.1130, 19.4355, 6.7841> <-1.1130, 20.0936, 6.7841> <-1.1328, 20.1134, 6.7841>
		<-1.1308, 19.4137, 6.8341> <-1.1110, 19.4336, 6.8341> <-1.1110, 20.0956, 6.8341> <-1.1308, 20.1154, 6.8341>
		<-1.1184, 19.4013, 6.9079> <-1.0962, 19.4235, 6.9079> <-1.0962, 20.1057, 6.9079> <-1.1184, 20.1278, 6.9079>
		<-1.0915, 19.3745, 6.9405> <-1.0694, 19.3966, 6.9405> <-1.0694, 20.1326, 6.9405> <-1.0915, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1328, 20.1134, 6.7841> <-1.1526, 20.1333, 6.7841> <-1.8107, 20.1333, 6.7841> <-1.8305, 20.1134, 6.7841>
		<-1.1308, 20.1154, 6.8341> <-1.1506, 20.1352, 6.8341> <-1.8127, 20.1352, 6.8341> <-1.8325, 20.1154, 6.8341>
		<-1.1184, 20.1278, 6.9079> <-1.1406, 20.1500, 6.9079> <-1.8228, 20.1500, 6.9079> <-1.8449, 20.1278, 6.9079>
		<-1.0915, 20.1547, 6.9405> <-1.1137, 20.1769, 6.9405> <-1.8496, 20.1769, 6.9405> <-1.8718, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8718, 19.3745, 6.9405> <-1.9339, 19.3123, 7.0160> <-2.0620, 19.1842, 7.0331> <-2.1114, 19.1348, 7.1255>
		<-1.8940, 19.3966, 6.9405> <-1.9561, 19.3345, 7.0160> <-2.0978, 19.2200, 7.0331> <-2.1472, 19.1706, 7.1255>
		<-1.8940, 20.1326, 6.9405> <-1.9561, 20.1947, 7.0160> <-2.0978, 20.3092, 7.0331> <-2.1472, 20.3586, 7.1255>
		<-1.8718, 20.1547, 6.9405> <-1.9339, 20.2168, 7.0160> <-2.0620, 20.3449, 7.0331> <-2.1114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.8718, 19.3745, 6.9405> <-1.8496, 19.3523, 6.9405> <-1.1137, 19.3523, 6.9405> <-1.0915, 19.3745, 6.9405>
		<-1.9339, 19.3123, 7.0160> <-1.9117, 19.2902, 7.0160> <-1.0516, 19.2902, 7.0160> <-1.0294, 19.3123, 7.0160>
		<-2.0620, 19.1842, 7.0331> <-2.0262, 19.1485, 7.0331> <-0.9371, 19.1485, 7.0331> <-0.9013, 19.1842, 7.0331>
		<-2.1114, 19.1348, 7.1255> <-2.0757, 19.0990, 7.1255> <-0.8877, 19.0990, 7.1255> <-0.8519, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0915, 19.3745, 6.9405> <-1.0694, 19.3966, 6.9405> <-1.0694, 20.1326, 6.9405> <-1.0915, 20.1547, 6.9405>
		<-1.0294, 19.3123, 7.0160> <-1.0073, 19.3345, 7.0160> <-1.0073, 20.1947, 7.0160> <-1.0294, 20.2168, 7.0160>
		<-0.9013, 19.1842, 7.0331> <-0.8655, 19.2200, 7.0331> <-0.8655, 20.3092, 7.0331> <-0.9013, 20.3449, 7.0331>
		<-0.8519, 19.1348, 7.1255> <-0.8161, 19.1706, 7.1255> <-0.8161, 20.3586, 7.1255> <-0.8519, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0915, 20.1547, 6.9405> <-1.1137, 20.1769, 6.9405> <-1.8496, 20.1769, 6.9405> <-1.8718, 20.1547, 6.9405>
		<-1.0294, 20.2168, 7.0160> <-1.0516, 20.2390, 7.0160> <-1.9117, 20.2390, 7.0160> <-1.9339, 20.2168, 7.0160>
		<-0.9013, 20.3449, 7.0331> <-0.9371, 20.3807, 7.0331> <-2.0262, 20.3807, 7.0331> <-2.0620, 20.3449, 7.0331>
		<-0.8519, 20.3944, 7.1255> <-0.8877, 20.4301, 7.1255> <-2.0757, 20.4301, 7.1255> <-2.1114, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1114, 19.1348, 7.1255> <-2.1319, 19.1143, 7.1638> <-2.0316, 19.2146, 7.1912> <-2.0316, 19.2146, 7.2393>
		<-2.1472, 19.1706, 7.1255> <-2.1677, 19.1501, 7.1638> <-2.0629, 19.2459, 7.1912> <-2.0629, 19.2459, 7.2393>
		<-2.1472, 20.3586, 7.1255> <-2.1677, 20.3791, 7.1638> <-2.0629, 20.2833, 7.1912> <-2.0629, 20.2833, 7.2393>
		<-2.1114, 20.3944, 7.1255> <-2.1319, 20.4149, 7.1638> <-2.0316, 20.3146, 7.1912> <-2.0316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1114, 19.1348, 7.1255> <-2.0757, 19.0990, 7.1255> <-0.8877, 19.0990, 7.1255> <-0.8519, 19.1348, 7.1255>
		<-2.1319, 19.1143, 7.1638> <-2.0962, 19.0785, 7.1638> <-0.8671, 19.0785, 7.1638> <-0.8314, 19.1143, 7.1638>
		<-2.0316, 19.2146, 7.1912> <-2.0004, 19.1834, 7.1912> <-0.9629, 19.1834, 7.1912> <-0.9317, 19.2146, 7.1912>
		<-2.0316, 19.2146, 7.2393> <-2.0004, 19.1834, 7.2393> <-0.9629, 19.1834, 7.2393> <-0.9317, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8519, 19.1348, 7.1255> <-0.8161, 19.1706, 7.1255> <-0.8161, 20.3586, 7.1255> <-0.8519, 20.3944, 7.1255>
		<-0.8314, 19.1143, 7.1638> <-0.7956, 19.1501, 7.1638> <-0.7956, 20.3791, 7.1638> <-0.8314, 20.4149, 7.1638>
		<-0.9317, 19.2146, 7.1912> <-0.9005, 19.2459, 7.1912> <-0.9005, 20.2833, 7.1912> <-0.9317, 20.3146, 7.1912>
		<-0.9317, 19.2146, 7.2393> <-0.9005, 19.2459, 7.2393> <-0.9005, 20.2833, 7.2393> <-0.9317, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8519, 20.3944, 7.1255> <-0.8877, 20.4301, 7.1255> <-2.0757, 20.4301, 7.1255> <-2.1114, 20.3944, 7.1255>
		<-0.8314, 20.4149, 7.1638> <-0.8671, 20.4506, 7.1638> <-2.0962, 20.4506, 7.1638> <-2.1319, 20.4149, 7.1638>
		<-0.9317, 20.3146, 7.1912> <-0.9629, 20.3458, 7.1912> <-2.0004, 20.3458, 7.1912> <-2.0316, 20.3146, 7.1912>
		<-0.9317, 20.3146, 7.2393> <-0.9629, 20.3458, 7.2393> <-2.0004, 20.3458, 7.2393> <-2.0316, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0316, 19.2146, 7.2393> <-2.0316, 19.2146, 7.2905> <-2.1054, 19.1408, 7.3169> <-2.1114, 19.1348, 7.3673>
		<-2.0629, 19.2459, 7.2393> <-2.0629, 19.2459, 7.2905> <-2.1412, 19.1766, 7.3169> <-2.1472, 19.1706, 7.3673>
		<-2.0629, 20.2833, 7.2393> <-2.0629, 20.2833, 7.2905> <-2.1412, 20.3526, 7.3169> <-2.1472, 20.3586, 7.3673>
		<-2.0316, 20.3146, 7.2393> <-2.0316, 20.3146, 7.2905> <-2.1054, 20.3883, 7.3169> <-2.1114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0316, 19.2146, 7.2393> <-2.0004, 19.1834, 7.2393> <-0.9629, 19.1834, 7.2393> <-0.9317, 19.2146, 7.2393>
		<-2.0316, 19.2146, 7.2905> <-2.0004, 19.1834, 7.2905> <-0.9629, 19.1834, 7.2905> <-0.9317, 19.2146, 7.2905>
		<-2.1054, 19.1408, 7.3169> <-2.0696, 19.1051, 7.3169> <-0.8937, 19.1051, 7.3169> <-0.8579, 19.1408, 7.3169>
		<-2.1114, 19.1348, 7.3673> <-2.0757, 19.0990, 7.3673> <-0.8877, 19.0990, 7.3673> <-0.8519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9317, 19.2146, 7.2393> <-0.9005, 19.2459, 7.2393> <-0.9005, 20.2833, 7.2393> <-0.9317, 20.3146, 7.2393>
		<-0.9317, 19.2146, 7.2905> <-0.9005, 19.2459, 7.2905> <-0.9005, 20.2833, 7.2905> <-0.9317, 20.3146, 7.2905>
		<-0.8579, 19.1408, 7.3169> <-0.8222, 19.1766, 7.3169> <-0.8222, 20.3526, 7.3169> <-0.8579, 20.3883, 7.3169>
		<-0.8519, 19.1348, 7.3673> <-0.8161, 19.1706, 7.3673> <-0.8161, 20.3586, 7.3673> <-0.8519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.9317, 20.3146, 7.2393> <-0.9629, 20.3458, 7.2393> <-2.0004, 20.3458, 7.2393> <-2.0316, 20.3146, 7.2393>
		<-0.9317, 20.3146, 7.2905> <-0.9629, 20.3458, 7.2905> <-2.0004, 20.3458, 7.2905> <-2.0316, 20.3146, 7.2905>
		<-0.8579, 20.3883, 7.3169> <-0.8937, 20.4241, 7.3169> <-2.0696, 20.4241, 7.3169> <-2.1054, 20.3883, 7.3169>
		<-0.8519, 20.3944, 7.3673> <-0.8877, 20.4301, 7.3673> <-2.0757, 20.4301, 7.3673> <-2.1114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1114, 19.1348, 7.9080> <-2.1472, 19.1706, 7.9080> <-2.1472, 20.3586, 7.9080> <-2.1114, 20.3944, 7.9080>
		<-2.1114, 19.1348, 7.7458> <-2.1472, 19.1706, 7.7458> <-2.1472, 20.3586, 7.7458> <-2.1114, 20.3944, 7.7458>
		<-2.1305, 19.1157, 7.5273> <-2.1663, 19.1515, 7.5273> <-2.1663, 20.3777, 7.5273> <-2.1305, 20.4134, 7.5273>
		<-2.1114, 19.1348, 7.3673> <-2.1472, 19.1706, 7.3673> <-2.1472, 20.3586, 7.3673> <-2.1114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.1114, 19.1348, 7.9080> <-2.1114, 19.1348, 7.7458> <-2.1305, 19.1157, 7.5273> <-2.1114, 19.1348, 7.3673>
		<-2.0757, 19.0990, 7.9080> <-2.0757, 19.0990, 7.7458> <-2.0947, 19.0800, 7.5273> <-2.0757, 19.0990, 7.3673>
		<-0.8877, 19.0990, 7.9080> <-0.8877, 19.0990, 7.7458> <-0.8686, 19.0800, 7.5273> <-0.8877, 19.0990, 7.3673>
		<-0.8519, 19.1348, 7.9080> <-0.8519, 19.1348, 7.7458> <-0.8328, 19.1157, 7.5273> <-0.8519, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8519, 19.1348, 7.9080> <-0.8519, 19.1348, 7.7458> <-0.8328, 19.1157, 7.5273> <-0.8519, 19.1348, 7.3673>
		<-0.8161, 19.1706, 7.9080> <-0.8161, 19.1706, 7.7458> <-0.7970, 19.1515, 7.5273> <-0.8161, 19.1706, 7.3673>
		<-0.8161, 20.3586, 7.9080> <-0.8161, 20.3586, 7.7458> <-0.7970, 20.3777, 7.5273> <-0.8161, 20.3586, 7.3673>
		<-0.8519, 20.3944, 7.9080> <-0.8519, 20.3944, 7.7458> <-0.8328, 20.4134, 7.5273> <-0.8519, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.8519, 20.3944, 7.9080> <-0.8519, 20.3944, 7.7458> <-0.8328, 20.4134, 7.5273> <-0.8519, 20.3944, 7.3673>
		<-0.8877, 20.4301, 7.9080> <-0.8877, 20.4301, 7.7458> <-0.8686, 20.4492, 7.5273> <-0.8877, 20.4301, 7.3673>
		<-2.0757, 20.4301, 7.9080> <-2.0757, 20.4301, 7.7458> <-2.0947, 20.4492, 7.5273> <-2.0757, 20.4301, 7.3673>
		<-2.1114, 20.3944, 7.9080> <-2.1114, 20.3944, 7.7458> <-2.1305, 20.4134, 7.5273> <-2.1114, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3589, 18.8874, 0.7771> <-2.4087, 18.9372, 0.7771> <-2.4087, 20.5920, 0.7771> <-2.3589, 20.6418, 0.7771>
		<-2.3796, 18.8666, 0.6520> <-2.4294, 18.9164, 0.6520> <-2.4294, 20.6127, 0.6520> <-2.3796, 20.6626, 0.6520>
		<-2.3589, 18.8874, 0.4772> <-2.4087, 18.9372, 0.4772> <-2.4087, 20.5920, 0.4772> <-2.3589, 20.6418, 0.4772>
		<-2.3589, 18.8874, 0.3486> <-2.4087, 18.9372, 0.3486> <-2.4087, 20.5920, 0.3486> <-2.3589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3589, 18.8874, 0.7771> <-2.3796, 18.8666, 0.6520> <-2.3589, 18.8874, 0.4772> <-2.3589, 18.8874, 0.3486>
		<-2.3090, 18.8376, 0.7771> <-2.3298, 18.8168, 0.6520> <-2.3090, 18.8376, 0.4772> <-2.3090, 18.8376, 0.3486>
		<-0.6543, 18.8376, 0.7771> <-0.6335, 18.8168, 0.6520> <-0.6543, 18.8376, 0.4772> <-0.6543, 18.8376, 0.3486>
		<-0.6045, 18.8874, 0.7771> <-0.5837, 18.8666, 0.6520> <-0.6045, 18.8874, 0.4772> <-0.6045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6045, 18.8874, 0.7771> <-0.5837, 18.8666, 0.6520> <-0.6045, 18.8874, 0.4772> <-0.6045, 18.8874, 0.3486>
		<-0.5546, 18.9372, 0.7771> <-0.5339, 18.9164, 0.6520> <-0.5546, 18.9372, 0.4772> <-0.5546, 18.9372, 0.3486>
		<-0.5546, 20.5920, 0.7771> <-0.5339, 20.6127, 0.6520> <-0.5546, 20.5920, 0.4772> <-0.5546, 20.5920, 0.3486>
		<-0.6045, 20.6418, 0.7771> <-0.5837, 20.6626, 0.6520> <-0.6045, 20.6418, 0.4772> <-0.6045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6045, 20.6418, 0.7771> <-0.5837, 20.6626, 0.6520> <-0.6045, 20.6418, 0.4772> <-0.6045, 20.6418, 0.3486>
		<-0.6543, 20.6916, 0.7771> <-0.6335, 20.7124, 0.6520> <-0.6543, 20.6916, 0.4772> <-0.6543, 20.6916, 0.3486>
		<-2.3090, 20.6916, 0.7771> <-2.3298, 20.7124, 0.6520> <-2.3090, 20.6916, 0.4772> <-2.3090, 20.6916, 0.3486>
		<-2.3589, 20.6418, 0.7771> <-2.3796, 20.6626, 0.6520> <-2.3589, 20.6418, 0.4772> <-2.3589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3589, 18.8874, -0.0618> <-2.3589, 18.8874, 0.0613> <-2.3589, 18.8874, 0.2255> <-2.3589, 18.8874, 0.3486>
		<-2.4087, 18.9372, -0.0618> <-2.4087, 18.9372, 0.0613> <-2.4087, 18.9372, 0.2255> <-2.4087, 18.9372, 0.3486>
		<-2.4087, 20.5920, -0.0618> <-2.4087, 20.5920, 0.0613> <-2.4087, 20.5920, 0.2255> <-2.4087, 20.5920, 0.3486>
		<-2.3589, 20.6418, -0.0618> <-2.3589, 20.6418, 0.0613> <-2.3589, 20.6418, 0.2255> <-2.3589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.3589, 18.8874, -0.0618> <-2.3090, 18.8376, -0.0618> <-0.6543, 18.8376, -0.0618> <-0.6045, 18.8874, -0.0618>
		<-2.3589, 18.8874, 0.0613> <-2.3090, 18.8376, 0.0613> <-0.6543, 18.8376, 0.0613> <-0.6045, 18.8874, 0.0613>
		<-2.3589, 18.8874, 0.2255> <-2.3090, 18.8376, 0.2255> <-0.6543, 18.8376, 0.2255> <-0.6045, 18.8874, 0.2255>
		<-2.3589, 18.8874, 0.3486> <-2.3090, 18.8376, 0.3486> <-0.6543, 18.8376, 0.3486> <-0.6045, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6045, 18.8874, -0.0618> <-0.5546, 18.9372, -0.0618> <-0.5546, 20.5920, -0.0618> <-0.6045, 20.6418, -0.0618>
		<-0.6045, 18.8874, 0.0613> <-0.5546, 18.9372, 0.0613> <-0.5546, 20.5920, 0.0613> <-0.6045, 20.6418, 0.0613>
		<-0.6045, 18.8874, 0.2255> <-0.5546, 18.9372, 0.2255> <-0.5546, 20.5920, 0.2255> <-0.6045, 20.6418, 0.2255>
		<-0.6045, 18.8874, 0.3486> <-0.5546, 18.9372, 0.3486> <-0.5546, 20.5920, 0.3486> <-0.6045, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.6045, 20.6418, -0.0618> <-0.6543, 20.6916, -0.0618> <-2.3090, 20.6916, -0.0618> <-2.3589, 20.6418, -0.0618>
		<-0.6045, 20.6418, 0.0613> <-0.6543, 20.6916, 0.0613> <-2.3090, 20.6916, 0.0613> <-2.3589, 20.6418, 0.0613>
		<-0.6045, 20.6418, 0.2255> <-0.6543, 20.6916, 0.2255> <-2.3090, 20.6916, 0.2255> <-2.3589, 20.6418, 0.2255>
		<-0.6045, 20.6418, 0.3486> <-0.6543, 20.6916, 0.3486> <-2.3090, 20.6916, 0.3486> <-2.3589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 0.9062> <-0.1109, 19.0245, 0.9062> <-0.1109, 20.5047, 0.9062> <-0.0664, 20.5493, 0.9062>
		<-0.0712, 18.9751, 0.8515> <-0.1157, 19.0196, 0.8515> <-0.1157, 20.5095, 0.8515> <-0.0712, 20.5541, 0.8515>
		<-0.1500, 18.8963, 0.8308> <-0.1998, 18.9461, 0.8308> <-0.1998, 20.5831, 0.8308> <-0.1500, 20.6329, 0.8308>
		<-0.1589, 18.8874, 0.7771> <-0.2087, 18.9372, 0.7771> <-0.2087, 20.5920, 0.7771> <-0.1589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 0.9062> <-0.0620, 18.9842, 0.9557> <-0.1560, 18.8903, 0.9996> <-0.1357, 18.9105, 1.0404>
		<-0.1109, 19.0245, 0.9062> <-0.1066, 19.0288, 0.9557> <-0.2045, 18.9388, 0.9996> <-0.1843, 18.9590, 1.0404>
		<-0.1109, 20.5047, 0.9062> <-0.1066, 20.5004, 0.9557> <-0.2045, 20.5904, 0.9996> <-0.1843, 20.5702, 1.0404>
		<-0.0664, 20.5493, 0.9062> <-0.0620, 20.5449, 0.9557> <-0.1560, 20.6389, 0.9996> <-0.1357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 0.9062> <-0.0712, 18.9751, 0.8515> <-0.1500, 18.8963, 0.8308> <-0.1589, 18.8874, 0.7771>
		<-0.0218, 18.9353, 0.9062> <-0.0266, 18.9305, 0.8515> <-0.1001, 18.8465, 0.8308> <-0.1090, 18.8376, 0.7771>
		<1.4585, 18.9353, 0.9062> <1.4633, 18.9305, 0.8515> <1.5368, 18.8465, 0.8308> <1.5457, 18.8376, 0.7771>
		<1.5030, 18.9799, 0.9062> <1.5078, 18.9751, 0.8515> <1.5866, 18.8963, 0.8308> <1.5955, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 0.9062> <-0.0218, 18.9353, 0.9062> <1.4585, 18.9353, 0.9062> <1.5030, 18.9799, 0.9062>
		<-0.0620, 18.9842, 0.9557> <-0.0175, 18.9397, 0.9557> <1.4541, 18.9397, 0.9557> <1.4987, 18.9842, 0.9557>
		<-0.1560, 18.8903, 0.9996> <-0.1075, 18.8418, 0.9996> <1.5441, 18.8418, 0.9996> <1.5927, 18.8903, 0.9996>
		<-0.1357, 18.9105, 1.0404> <-0.0872, 18.8620, 1.0404> <1.5239, 18.8620, 1.0404> <1.5724, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 18.9799, 0.9062> <1.5078, 18.9751, 0.8515> <1.5866, 18.8963, 0.8308> <1.5955, 18.8874, 0.7771>
		<1.5476, 19.0245, 0.9062> <1.5524, 19.0196, 0.8515> <1.6365, 18.9461, 0.8308> <1.6454, 18.9372, 0.7771>
		<1.5476, 20.5047, 0.9062> <1.5524, 20.5095, 0.8515> <1.6365, 20.5831, 0.8308> <1.6454, 20.5920, 0.7771>
		<1.5030, 20.5493, 0.9062> <1.5078, 20.5541, 0.8515> <1.5866, 20.6329, 0.8308> <1.5955, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 18.9799, 0.9062> <1.5476, 19.0245, 0.9062> <1.5476, 20.5047, 0.9062> <1.5030, 20.5493, 0.9062>
		<1.4987, 18.9842, 0.9557> <1.5433, 19.0288, 0.9557> <1.5433, 20.5004, 0.9557> <1.4987, 20.5449, 0.9557>
		<1.5927, 18.8903, 0.9996> <1.6412, 18.9388, 0.9996> <1.6412, 20.5904, 0.9996> <1.5927, 20.6389, 0.9996>
		<1.5724, 18.9105, 1.0404> <1.6209, 18.9590, 1.0404> <1.6209, 20.5702, 1.0404> <1.5724, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 20.5493, 0.9062> <1.5078, 20.5541, 0.8515> <1.5866, 20.6329, 0.8308> <1.5955, 20.6418, 0.7771>
		<1.4585, 20.5939, 0.9062> <1.4633, 20.5987, 0.8515> <1.5368, 20.6827, 0.8308> <1.5457, 20.6916, 0.7771>
		<-0.0218, 20.5939, 0.9062> <-0.0266, 20.5987, 0.8515> <-0.1001, 20.6827, 0.8308> <-0.1090, 20.6916, 0.7771>
		<-0.0664, 20.5493, 0.9062> <-0.0712, 20.5541, 0.8515> <-0.1500, 20.6329, 0.8308> <-0.1589, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 20.5493, 0.9062> <1.4585, 20.5939, 0.9062> <-0.0218, 20.5939, 0.9062> <-0.0664, 20.5493, 0.9062>
		<1.4987, 20.5449, 0.9557> <1.4541, 20.5895, 0.9557> <-0.0175, 20.5895, 0.9557> <-0.0620, 20.5449, 0.9557>
		<1.5927, 20.6389, 0.9996> <1.5441, 20.6874, 0.9996> <-0.1075, 20.6874, 0.9996> <-0.1560, 20.6389, 0.9996>
		<1.5724, 20.6187, 1.0404> <1.5239, 20.6672, 1.0404> <-0.0872, 20.6672, 1.0404> <-0.1357, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1357, 18.9105, 1.0404> <-0.0677, 18.9786, 1.1777> <0.1018, 19.1481, 1.2552> <0.1731, 19.2193, 1.3892>
		<-0.1843, 18.9590, 1.0404> <-0.1162, 19.0271, 1.1777> <0.0709, 19.1790, 1.2552> <0.1421, 19.2503, 1.3892>
		<-0.1843, 20.5702, 1.0404> <-0.1162, 20.5021, 1.1777> <0.0709, 20.3501, 1.2552> <0.1421, 20.2789, 1.3892>
		<-0.1357, 20.6187, 1.0404> <-0.0677, 20.5506, 1.1777> <0.1018, 20.3811, 1.2552> <0.1731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1357, 18.9105, 1.0404> <-0.0872, 18.8620, 1.0404> <1.5239, 18.8620, 1.0404> <1.5724, 18.9105, 1.0404>
		<-0.0677, 18.9786, 1.1777> <-0.0192, 18.9301, 1.1777> <1.4558, 18.9301, 1.1777> <1.5043, 18.9786, 1.1777>
		<0.1018, 19.1481, 1.2552> <0.1328, 19.1171, 1.2552> <1.3039, 19.1171, 1.2552> <1.3348, 19.1481, 1.2552>
		<0.1731, 19.2193, 1.3892> <0.2041, 19.1884, 1.3892> <1.2326, 19.1884, 1.3892> <1.2636, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5724, 18.9105, 1.0404> <1.6209, 18.9590, 1.0404> <1.6209, 20.5702, 1.0404> <1.5724, 20.6187, 1.0404>
		<1.5043, 18.9786, 1.1777> <1.5529, 19.0271, 1.1777> <1.5529, 20.5021, 1.1777> <1.5043, 20.5506, 1.1777>
		<1.3348, 19.1481, 1.2552> <1.3658, 19.1790, 1.2552> <1.3658, 20.3501, 1.2552> <1.3348, 20.3811, 1.2552>
		<1.2636, 19.2193, 1.3892> <1.2946, 19.2503, 1.3892> <1.2946, 20.2789, 1.3892> <1.2636, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5724, 20.6187, 1.0404> <1.5239, 20.6672, 1.0404> <-0.0872, 20.6672, 1.0404> <-0.1357, 20.6187, 1.0404>
		<1.5043, 20.5506, 1.1777> <1.4558, 20.5991, 1.1777> <-0.0192, 20.5991, 1.1777> <-0.0677, 20.5506, 1.1777>
		<1.3348, 20.3811, 1.2552> <1.3039, 20.4121, 1.2552> <0.1328, 20.4121, 1.2552> <0.1018, 20.3811, 1.2552>
		<1.2636, 20.3098, 1.3892> <1.2326, 20.3408, 1.3892> <0.2041, 20.3408, 1.3892> <0.1731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1731, 19.2193, 1.3892> <0.1921, 19.2383, 1.4249> <0.1163, 19.1626, 1.4698> <0.1163, 19.1626, 1.5144>
		<0.1421, 19.2503, 1.3892> <0.1611, 19.2693, 1.4249> <0.0821, 19.1968, 1.4698> <0.0821, 19.1968, 1.5144>
		<0.1421, 20.2789, 1.3892> <0.1611, 20.2599, 1.4249> <0.0821, 20.3324, 1.4698> <0.0821, 20.3324, 1.5144>
		<0.1731, 20.3098, 1.3892> <0.1921, 20.2909, 1.4249> <0.1163, 20.3666, 1.4698> <0.1163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1731, 19.2193, 1.3892> <0.2041, 19.1884, 1.3892> <1.2326, 19.1884, 1.3892> <1.2636, 19.2193, 1.3892>
		<0.1921, 19.2383, 1.4249> <0.2230, 19.2073, 1.4249> <1.2137, 19.2073, 1.4249> <1.2446, 19.2383, 1.4249>
		<0.1163, 19.1626, 1.4698> <0.1505, 19.1284, 1.4698> <1.2862, 19.1284, 1.4698> <1.3204, 19.1626, 1.4698>
		<0.1163, 19.1626, 1.5144> <0.1505, 19.1284, 1.5144> <1.2862, 19.1284, 1.5144> <1.3204, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2636, 19.2193, 1.3892> <1.2946, 19.2503, 1.3892> <1.2946, 20.2789, 1.3892> <1.2636, 20.3098, 1.3892>
		<1.2446, 19.2383, 1.4249> <1.2756, 19.2693, 1.4249> <1.2756, 20.2599, 1.4249> <1.2446, 20.2909, 1.4249>
		<1.3204, 19.1626, 1.4698> <1.3545, 19.1968, 1.4698> <1.3545, 20.3324, 1.4698> <1.3204, 20.3666, 1.4698>
		<1.3204, 19.1626, 1.5144> <1.3545, 19.1968, 1.5144> <1.3545, 20.3324, 1.5144> <1.3204, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2636, 20.3098, 1.3892> <1.2326, 20.3408, 1.3892> <0.2041, 20.3408, 1.3892> <0.1731, 20.3098, 1.3892>
		<1.2446, 20.2909, 1.4249> <1.2137, 20.3218, 1.4249> <0.2230, 20.3218, 1.4249> <0.1921, 20.2909, 1.4249>
		<1.3204, 20.3666, 1.4698> <1.2862, 20.4008, 1.4698> <0.1505, 20.4008, 1.4698> <0.1163, 20.3666, 1.4698>
		<1.3204, 20.3666, 1.5144> <1.2862, 20.4008, 1.5144> <0.1505, 20.4008, 1.5144> <0.1163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1163, 19.1626, 1.5144> <0.1163, 19.1626, 1.5613> <0.1879, 19.2341, 1.6066> <0.1731, 19.2193, 1.6486>
		<0.0821, 19.1968, 1.5144> <0.0821, 19.1968, 1.5613> <0.1569, 19.2651, 1.6066> <0.1421, 19.2503, 1.6486>
		<0.0821, 20.3324, 1.5144> <0.0821, 20.3324, 1.5613> <0.1569, 20.2641, 1.6066> <0.1421, 20.2789, 1.6486>
		<0.1163, 20.3666, 1.5144> <0.1163, 20.3666, 1.5613> <0.1879, 20.2950, 1.6066> <0.1731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1163, 19.1626, 1.5144> <0.1505, 19.1284, 1.5144> <1.2862, 19.1284, 1.5144> <1.3204, 19.1626, 1.5144>
		<0.1163, 19.1626, 1.5613> <0.1505, 19.1284, 1.5613> <1.2862, 19.1284, 1.5613> <1.3204, 19.1626, 1.5613>
		<0.1879, 19.2341, 1.6066> <0.2188, 19.2032, 1.6066> <1.2178, 19.2032, 1.6066> <1.2488, 19.2341, 1.6066>
		<0.1731, 19.2193, 1.6486> <0.2041, 19.1884, 1.6486> <1.2326, 19.1884, 1.6486> <1.2636, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3204, 19.1626, 1.5144> <1.3545, 19.1968, 1.5144> <1.3545, 20.3324, 1.5144> <1.3204, 20.3666, 1.5144>
		<1.3204, 19.1626, 1.5613> <1.3545, 19.1968, 1.5613> <1.3545, 20.3324, 1.5613> <1.3204, 20.3666, 1.5613>
		<1.2488, 19.2341, 1.6066> <1.2798, 19.2651, 1.6066> <1.2798, 20.2641, 1.6066> <1.2488, 20.2950, 1.6066>
		<1.2636, 19.2193, 1.6486> <1.2946, 19.2503, 1.6486> <1.2946, 20.2789, 1.6486> <1.2636, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3204, 20.3666, 1.5144> <1.2862, 20.4008, 1.5144> <0.1505, 20.4008, 1.5144> <0.1163, 20.3666, 1.5144>
		<1.3204, 20.3666, 1.5613> <1.2862, 20.4008, 1.5613> <0.1505, 20.4008, 1.5613> <0.1163, 20.3666, 1.5613>
		<1.2488, 20.2950, 1.6066> <1.2178, 20.3260, 1.6066> <0.2188, 20.3260, 1.6066> <0.1879, 20.2950, 1.6066>
		<1.2636, 20.3098, 1.6486> <1.2326, 20.3408, 1.6486> <0.2041, 20.3408, 1.6486> <0.1731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1731, 19.2193, 1.6486> <0.1246, 19.1709, 1.7862> <-0.0172, 19.0290, 1.8960> <-0.0664, 18.9799, 2.0332>
		<0.1421, 19.2503, 1.6486> <0.0937, 19.2018, 1.7862> <-0.0618, 19.0736, 1.8960> <-0.1109, 19.0245, 2.0332>
		<0.1421, 20.2789, 1.6486> <0.0937, 20.3273, 1.7862> <-0.0618, 20.4556, 1.8960> <-0.1109, 20.5047, 2.0332>
		<0.1731, 20.3098, 1.6486> <0.1246, 20.3583, 1.7862> <-0.0172, 20.5002, 1.8960> <-0.0664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1731, 19.2193, 1.6486> <0.2041, 19.1884, 1.6486> <1.2326, 19.1884, 1.6486> <1.2636, 19.2193, 1.6486>
		<0.1246, 19.1709, 1.7862> <0.1556, 19.1399, 1.7862> <1.2811, 19.1399, 1.7862> <1.3120, 19.1709, 1.7862>
		<-0.0172, 19.0290, 1.8960> <0.0273, 18.9844, 1.8960> <1.4093, 18.9844, 1.8960> <1.4539, 19.0290, 1.8960>
		<-0.0664, 18.9799, 2.0332> <-0.0218, 18.9353, 2.0332> <1.4585, 18.9353, 2.0332> <1.5030, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2636, 19.2193, 1.6486> <1.2946, 19.2503, 1.6486> <1.2946, 20.2789, 1.6486> <1.2636, 20.3098, 1.6486>
		<1.3120, 19.1709, 1.7862> <1.3430, 19.2018, 1.7862> <1.3430, 20.3273, 1.7862> <1.3120, 20.3583, 1.7862>
		<1.4539, 19.0290, 1.8960> <1.4985, 19.0736, 1.8960> <1.4985, 20.4556, 1.8960> <1.4539, 20.5002, 1.8960>
		<1.5030, 18.9799, 2.0332> <1.5476, 19.0245, 2.0332> <1.5476, 20.5047, 2.0332> <1.5030, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2636, 20.3098, 1.6486> <1.2326, 20.3408, 1.6486> <0.2041, 20.3408, 1.6486> <0.1731, 20.3098, 1.6486>
		<1.3120, 20.3583, 1.7862> <1.2811, 20.3893, 1.7862> <0.1556, 20.3893, 1.7862> <0.1246, 20.3583, 1.7862>
		<1.4539, 20.5002, 1.8960> <1.4093, 20.5447, 1.8960> <0.0273, 20.5447, 1.8960> <-0.0172, 20.5002, 1.8960>
		<1.5030, 20.5493, 2.0332> <1.4585, 20.5939, 2.0332> <-0.0218, 20.5939, 2.0332> <-0.0664, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 2.0332> <-0.0930, 18.9533, 2.1074> <-0.0932, 18.9531, 2.2382> <-0.0641, 18.9822, 2.3104>
		<-0.1109, 19.0245, 2.0332> <-0.1375, 18.9979, 2.1074> <-0.1376, 18.9975, 2.2382> <-0.1085, 19.0266, 2.3104>
		<-0.1109, 20.5047, 2.0332> <-0.1375, 20.5313, 2.1074> <-0.1376, 20.5317, 2.2382> <-0.1085, 20.5025, 2.3104>
		<-0.0664, 20.5493, 2.0332> <-0.0930, 20.5759, 2.1074> <-0.0932, 20.5761, 2.2382> <-0.0641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0664, 18.9799, 2.0332> <-0.0218, 18.9353, 2.0332> <1.4585, 18.9353, 2.0332> <1.5030, 18.9799, 2.0332>
		<-0.0930, 18.9533, 2.1074> <-0.0484, 18.9087, 2.1074> <1.4851, 18.9087, 2.1074> <1.5296, 18.9533, 2.1074>
		<-0.0932, 18.9531, 2.2382> <-0.0488, 18.9086, 2.2382> <1.4854, 18.9086, 2.2382> <1.5299, 18.9531, 2.2382>
		<-0.0641, 18.9822, 2.3104> <-0.0196, 18.9378, 2.3104> <1.4563, 18.9378, 2.3104> <1.5007, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 18.9799, 2.0332> <1.5476, 19.0245, 2.0332> <1.5476, 20.5047, 2.0332> <1.5030, 20.5493, 2.0332>
		<1.5296, 18.9533, 2.1074> <1.5742, 18.9979, 2.1074> <1.5742, 20.5313, 2.1074> <1.5296, 20.5759, 2.1074>
		<1.5299, 18.9531, 2.2382> <1.5743, 18.9975, 2.2382> <1.5743, 20.5317, 2.2382> <1.5299, 20.5761, 2.2382>
		<1.5007, 18.9822, 2.3104> <1.5452, 19.0266, 2.3104> <1.5452, 20.5025, 2.3104> <1.5007, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5030, 20.5493, 2.0332> <1.4585, 20.5939, 2.0332> <-0.0218, 20.5939, 2.0332> <-0.0664, 20.5493, 2.0332>
		<1.5296, 20.5759, 2.1074> <1.4851, 20.6204, 2.1074> <-0.0484, 20.6204, 2.1074> <-0.0930, 20.5759, 2.1074>
		<1.5299, 20.5761, 2.2382> <1.4854, 20.6206, 2.2382> <-0.0488, 20.6206, 2.2382> <-0.0932, 20.5761, 2.2382>
		<1.5007, 20.5470, 2.3104> <1.4563, 20.5914, 2.3104> <-0.0196, 20.5914, 2.3104> <-0.0641, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0641, 18.9822, 2.3104> <0.0199, 19.0661, 2.5186> <0.2157, 19.2620, 2.7154> <0.2944, 19.3406, 2.9276>
		<-0.1085, 19.0266, 2.3104> <-0.0246, 19.1106, 2.5186> <0.1916, 19.2860, 2.7154> <0.2703, 19.3647, 2.9276>
		<-0.1085, 20.5025, 2.3104> <-0.0246, 20.4186, 2.5186> <0.1916, 20.2431, 2.7154> <0.2703, 20.1645, 2.9276>
		<-0.0641, 20.5470, 2.3104> <0.0199, 20.4630, 2.5186> <0.2157, 20.2672, 2.7154> <0.2944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0641, 18.9822, 2.3104> <-0.0196, 18.9378, 2.3104> <1.4563, 18.9378, 2.3104> <1.5007, 18.9822, 2.3104>
		<0.0199, 19.0661, 2.5186> <0.0643, 19.0217, 2.5186> <1.3723, 19.0217, 2.5186> <1.4168, 19.0661, 2.5186>
		<0.2157, 19.2620, 2.7154> <0.2398, 19.2379, 2.7154> <1.1969, 19.2379, 2.7154> <1.2210, 19.2620, 2.7154>
		<0.2944, 19.3406, 2.9276> <0.3185, 19.3165, 2.9276> <1.1182, 19.3165, 2.9276> <1.1423, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5007, 18.9822, 2.3104> <1.5452, 19.0266, 2.3104> <1.5452, 20.5025, 2.3104> <1.5007, 20.5470, 2.3104>
		<1.4168, 19.0661, 2.5186> <1.4612, 19.1106, 2.5186> <1.4612, 20.4186, 2.5186> <1.4168, 20.4630, 2.5186>
		<1.2210, 19.2620, 2.7154> <1.2450, 19.2860, 2.7154> <1.2450, 20.2431, 2.7154> <1.2210, 20.2672, 2.7154>
		<1.1423, 19.3406, 2.9276> <1.1664, 19.3647, 2.9276> <1.1664, 20.1645, 2.9276> <1.1423, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5007, 20.5470, 2.3104> <1.4563, 20.5914, 2.3104> <-0.0196, 20.5914, 2.3104> <-0.0641, 20.5470, 2.3104>
		<1.4168, 20.4630, 2.5186> <1.3723, 20.5075, 2.5186> <0.0643, 20.5075, 2.5186> <0.0199, 20.4630, 2.5186>
		<1.2210, 20.2672, 2.7154> <1.1969, 20.2913, 2.7154> <0.2398, 20.2913, 2.7154> <0.2157, 20.2672, 2.7154>
		<1.1423, 20.1885, 2.9276> <1.1182, 20.2126, 2.9276> <0.3185, 20.2126, 2.9276> <0.2944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2944, 19.3406, 2.9276> <0.3113, 19.3576, 2.9732> <0.2111, 19.2574, 3.0012> <0.2111, 19.2574, 3.0528>
		<0.2703, 19.3647, 2.9276> <0.2872, 19.3816, 2.9732> <0.1823, 19.2862, 3.0012> <0.1823, 19.2862, 3.0528>
		<0.2703, 20.1645, 2.9276> <0.2872, 20.1475, 2.9732> <0.1823, 20.2430, 3.0012> <0.1823, 20.2430, 3.0528>
		<0.2944, 20.1885, 2.9276> <0.3113, 20.1716, 2.9732> <0.2111, 20.2718, 3.0012> <0.2111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2944, 19.3406, 2.9276> <0.3185, 19.3165, 2.9276> <1.1182, 19.3165, 2.9276> <1.1423, 19.3406, 2.9276>
		<0.3113, 19.3576, 2.9732> <0.3354, 19.3335, 2.9732> <1.1013, 19.3335, 2.9732> <1.1254, 19.3576, 2.9732>
		<0.2111, 19.2574, 3.0012> <0.2399, 19.2286, 3.0012> <1.1967, 19.2286, 3.0012> <1.2255, 19.2574, 3.0012>
		<0.2111, 19.2574, 3.0528> <0.2399, 19.2286, 3.0528> <1.1967, 19.2286, 3.0528> <1.2255, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1423, 19.3406, 2.9276> <1.1664, 19.3647, 2.9276> <1.1664, 20.1645, 2.9276> <1.1423, 20.1885, 2.9276>
		<1.1254, 19.3576, 2.9732> <1.1494, 19.3816, 2.9732> <1.1494, 20.1475, 2.9732> <1.1254, 20.1716, 2.9732>
		<1.2255, 19.2574, 3.0012> <1.2544, 19.2862, 3.0012> <1.2544, 20.2430, 3.0012> <1.2255, 20.2718, 3.0012>
		<1.2255, 19.2574, 3.0528> <1.2544, 19.2862, 3.0528> <1.2544, 20.2430, 3.0528> <1.2255, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1423, 20.1885, 2.9276> <1.1182, 20.2126, 2.9276> <0.3185, 20.2126, 2.9276> <0.2944, 20.1885, 2.9276>
		<1.1254, 20.1716, 2.9732> <1.1013, 20.1957, 2.9732> <0.3354, 20.1957, 2.9732> <0.3113, 20.1716, 2.9732>
		<1.2255, 20.2718, 3.0012> <1.1967, 20.3006, 3.0012> <0.2399, 20.3006, 3.0012> <0.2111, 20.2718, 3.0012>
		<1.2255, 20.2718, 3.0528> <1.1967, 20.3006, 3.0528> <0.2399, 20.3006, 3.0528> <0.2111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2111, 19.2574, 3.0528> <0.2111, 19.2574, 3.1044> <0.3138, 19.3600, 3.1344> <0.2944, 19.3406, 3.1780>
		<0.1823, 19.2862, 3.0528> <0.1823, 19.2862, 3.1044> <0.2897, 19.3841, 3.1344> <0.2703, 19.3647, 3.1780>
		<0.1823, 20.2430, 3.0528> <0.1823, 20.2430, 3.1044> <0.2897, 20.1451, 3.1344> <0.2703, 20.1645, 3.1780>
		<0.2111, 20.2718, 3.0528> <0.2111, 20.2718, 3.1044> <0.3138, 20.1691, 3.1344> <0.2944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2111, 19.2574, 3.0528> <0.2399, 19.2286, 3.0528> <1.1967, 19.2286, 3.0528> <1.2255, 19.2574, 3.0528>
		<0.2111, 19.2574, 3.1044> <0.2399, 19.2286, 3.1044> <1.1967, 19.2286, 3.1044> <1.2255, 19.2574, 3.1044>
		<0.3138, 19.3600, 3.1344> <0.3379, 19.3359, 3.1344> <1.0988, 19.3359, 3.1344> <1.1229, 19.3600, 3.1344>
		<0.2944, 19.3406, 3.1780> <0.3185, 19.3165, 3.1780> <1.1182, 19.3165, 3.1780> <1.1423, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2255, 19.2574, 3.0528> <1.2544, 19.2862, 3.0528> <1.2544, 20.2430, 3.0528> <1.2255, 20.2718, 3.0528>
		<1.2255, 19.2574, 3.1044> <1.2544, 19.2862, 3.1044> <1.2544, 20.2430, 3.1044> <1.2255, 20.2718, 3.1044>
		<1.1229, 19.3600, 3.1344> <1.1470, 19.3841, 3.1344> <1.1470, 20.1451, 3.1344> <1.1229, 20.1691, 3.1344>
		<1.1423, 19.3406, 3.1780> <1.1664, 19.3647, 3.1780> <1.1664, 20.1645, 3.1780> <1.1423, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2255, 20.2718, 3.0528> <1.1967, 20.3006, 3.0528> <0.2399, 20.3006, 3.0528> <0.2111, 20.2718, 3.0528>
		<1.2255, 20.2718, 3.1044> <1.1967, 20.3006, 3.1044> <0.2399, 20.3006, 3.1044> <0.2111, 20.2718, 3.1044>
		<1.1229, 20.1691, 3.1344> <1.0988, 20.1932, 3.1344> <0.3379, 20.1932, 3.1344> <0.3138, 20.1691, 3.1344>
		<1.1423, 20.1885, 3.1780> <1.1182, 20.2126, 3.1780> <0.3185, 20.2126, 3.1780> <0.2944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2944, 19.3406, 3.1780> <0.2562, 19.3024, 3.2640> <0.1390, 19.1852, 3.2738> <0.0839, 19.1302, 3.3390>
		<0.2703, 19.3647, 3.1780> <0.2321, 19.3265, 3.2640> <0.1029, 19.2212, 3.2738> <0.0479, 19.1662, 3.3390>
		<0.2703, 20.1645, 3.1780> <0.2321, 20.2027, 3.2640> <0.1029, 20.3079, 3.2738> <0.0479, 20.3629, 3.3390>
		<0.2944, 20.1885, 3.1780> <0.2562, 20.2267, 3.2640> <0.1390, 20.3440, 3.2738> <0.0839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2944, 19.3406, 3.1780> <0.3185, 19.3165, 3.1780> <1.1182, 19.3165, 3.1780> <1.1423, 19.3406, 3.1780>
		<0.2562, 19.3024, 3.2640> <0.2803, 19.2784, 3.2640> <1.1564, 19.2784, 3.2640> <1.1805, 19.3024, 3.2640>
		<0.1390, 19.1852, 3.2738> <0.1750, 19.1492, 3.2738> <1.2617, 19.1492, 3.2738> <1.2977, 19.1852, 3.2738>
		<0.0839, 19.1302, 3.3390> <0.1200, 19.0942, 3.3390> <1.3167, 19.0942, 3.3390> <1.3527, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1423, 19.3406, 3.1780> <1.1664, 19.3647, 3.1780> <1.1664, 20.1645, 3.1780> <1.1423, 20.1885, 3.1780>
		<1.1805, 19.3024, 3.2640> <1.2046, 19.3265, 3.2640> <1.2046, 20.2027, 3.2640> <1.1805, 20.2267, 3.2640>
		<1.2977, 19.1852, 3.2738> <1.3337, 19.2212, 3.2738> <1.3337, 20.3079, 3.2738> <1.2977, 20.3440, 3.2738>
		<1.3527, 19.1302, 3.3390> <1.3888, 19.1662, 3.3390> <1.3888, 20.3629, 3.3390> <1.3527, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1423, 20.1885, 3.1780> <1.1182, 20.2126, 3.1780> <0.3185, 20.2126, 3.1780> <0.2944, 20.1885, 3.1780>
		<1.1805, 20.2267, 3.2640> <1.1564, 20.2508, 3.2640> <0.2803, 20.2508, 3.2640> <0.2562, 20.2267, 3.2640>
		<1.2977, 20.3440, 3.2738> <1.2617, 20.3800, 3.2738> <0.1750, 20.3800, 3.2738> <0.1390, 20.3440, 3.2738>
		<1.3527, 20.3990, 3.3390> <1.3167, 20.4350, 3.3390> <0.1200, 20.4350, 3.3390> <0.0839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0839, 19.1302, 3.3390> <0.0584, 19.1046, 3.3693> <0.0203, 19.0665, 3.4419> <0.0377, 19.0839, 3.4821>
		<0.0479, 19.1662, 3.3390> <0.0223, 19.1406, 3.3693> <-0.0184, 19.1052, 3.4419> <-0.0010, 19.1226, 3.4821>
		<0.0479, 20.3629, 3.3390> <0.0223, 20.3885, 3.3693> <-0.0184, 20.4240, 3.4419> <-0.0010, 20.4066, 3.4821>
		<0.0839, 20.3990, 3.3390> <0.0584, 20.4246, 3.3693> <0.0203, 20.4627, 3.4419> <0.0377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0839, 19.1302, 3.3390> <0.1200, 19.0942, 3.3390> <1.3167, 19.0942, 3.3390> <1.3527, 19.1302, 3.3390>
		<0.0584, 19.1046, 3.3693> <0.0944, 19.0686, 3.3693> <1.3423, 19.0686, 3.3693> <1.3783, 19.1046, 3.3693>
		<0.0203, 19.0665, 3.4419> <0.0589, 19.0279, 3.4419> <1.3777, 19.0279, 3.4419> <1.4164, 19.0665, 3.4419>
		<0.0377, 19.0839, 3.4821> <0.0764, 19.0453, 3.4821> <1.3603, 19.0453, 3.4821> <1.3990, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3527, 19.1302, 3.3390> <1.3888, 19.1662, 3.3390> <1.3888, 20.3629, 3.3390> <1.3527, 20.3990, 3.3390>
		<1.3783, 19.1046, 3.3693> <1.4143, 19.1406, 3.3693> <1.4143, 20.3885, 3.3693> <1.3783, 20.4246, 3.3693>
		<1.4164, 19.0665, 3.4419> <1.4551, 19.1052, 3.4419> <1.4551, 20.4240, 3.4419> <1.4164, 20.4627, 3.4419>
		<1.3990, 19.0839, 3.4821> <1.4376, 19.1226, 3.4821> <1.4376, 20.4066, 3.4821> <1.3990, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3527, 20.3990, 3.3390> <1.3167, 20.4350, 3.3390> <0.1200, 20.4350, 3.3390> <0.0839, 20.3990, 3.3390>
		<1.3783, 20.4246, 3.3693> <1.3423, 20.4606, 3.3693> <0.0944, 20.4606, 3.3693> <0.0584, 20.4246, 3.3693>
		<1.4164, 20.4627, 3.4419> <1.3777, 20.5013, 3.4419> <0.0589, 20.5013, 3.4419> <0.0203, 20.4627, 3.4419>
		<1.3990, 20.4452, 3.4821> <1.3603, 20.4839, 3.4821> <0.0764, 20.4839, 3.4821> <0.0377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0377, 19.0839, 3.4821> <0.0837, 19.1300, 3.5884> <0.2039, 19.2502, 3.6567> <0.2620, 19.3083, 3.7504>
		<-0.0010, 19.1226, 3.4821> <0.0450, 19.1686, 3.5884> <0.1780, 19.2761, 3.6567> <0.2361, 19.3342, 3.7504>
		<-0.0010, 20.4066, 3.4821> <0.0450, 20.3606, 3.5884> <0.1780, 20.2531, 3.6567> <0.2361, 20.1950, 3.7504>
		<0.0377, 20.4452, 3.4821> <0.0837, 20.3992, 3.5884> <0.2039, 20.2790, 3.6567> <0.2620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0377, 19.0839, 3.4821> <0.0764, 19.0453, 3.4821> <1.3603, 19.0453, 3.4821> <1.3990, 19.0839, 3.4821>
		<0.0837, 19.1300, 3.5884> <0.1224, 19.0913, 3.5884> <1.3143, 19.0913, 3.5884> <1.3530, 19.1300, 3.5884>
		<0.2039, 19.2502, 3.6567> <0.2298, 19.2242, 3.6567> <1.2068, 19.2242, 3.6567> <1.2328, 19.2502, 3.6567>
		<0.2620, 19.3083, 3.7504> <0.2879, 19.2823, 3.7504> <1.1487, 19.2823, 3.7504> <1.1747, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3990, 19.0839, 3.4821> <1.4376, 19.1226, 3.4821> <1.4376, 20.4066, 3.4821> <1.3990, 20.4452, 3.4821>
		<1.3530, 19.1300, 3.5884> <1.3916, 19.1686, 3.5884> <1.3916, 20.3606, 3.5884> <1.3530, 20.3992, 3.5884>
		<1.2328, 19.2502, 3.6567> <1.2587, 19.2761, 3.6567> <1.2587, 20.2531, 3.6567> <1.2328, 20.2790, 3.6567>
		<1.1747, 19.3083, 3.7504> <1.2006, 19.3342, 3.7504> <1.2006, 20.1950, 3.7504> <1.1747, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3990, 20.4452, 3.4821> <1.3603, 20.4839, 3.4821> <0.0764, 20.4839, 3.4821> <0.0377, 20.4452, 3.4821>
		<1.3530, 20.3992, 3.5884> <1.3143, 20.4379, 3.5884> <0.1224, 20.4379, 3.5884> <0.0837, 20.3992, 3.5884>
		<1.2328, 20.2790, 3.6567> <1.2068, 20.3049, 3.6567> <0.2298, 20.3049, 3.6567> <0.2039, 20.2790, 3.6567>
		<1.1747, 20.2209, 3.7504> <1.1487, 20.2468, 3.7504> <0.2879, 20.2468, 3.7504> <0.2620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2620, 19.3083, 3.7504> <0.3036, 19.3498, 3.8175> <0.3473, 19.3935, 3.9241> <0.3648, 19.4110, 4.0098>
		<0.2361, 19.3342, 3.7504> <0.2777, 19.3757, 3.8175> <0.3272, 19.4136, 3.9241> <0.3447, 19.4311, 4.0098>
		<0.2361, 20.1950, 3.7504> <0.2777, 20.1534, 3.8175> <0.3272, 20.1156, 3.9241> <0.3447, 20.0981, 4.0098>
		<0.2620, 20.2209, 3.7504> <0.3036, 20.1793, 3.8175> <0.3473, 20.1356, 3.9241> <0.3648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2620, 19.3083, 3.7504> <0.2879, 19.2823, 3.7504> <1.1487, 19.2823, 3.7504> <1.1747, 19.3083, 3.7504>
		<0.3036, 19.3498, 3.8175> <0.3295, 19.3239, 3.8175> <1.1072, 19.3239, 3.8175> <1.1331, 19.3498, 3.8175>
		<0.3473, 19.3935, 3.9241> <0.3674, 19.3734, 3.9241> <1.0693, 19.3734, 3.9241> <1.0894, 19.3935, 3.9241>
		<0.3648, 19.4110, 4.0098> <0.3848, 19.3909, 4.0098> <1.0518, 19.3909, 4.0098> <1.0719, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1747, 19.3083, 3.7504> <1.2006, 19.3342, 3.7504> <1.2006, 20.1950, 3.7504> <1.1747, 20.2209, 3.7504>
		<1.1331, 19.3498, 3.8175> <1.1590, 19.3757, 3.8175> <1.1590, 20.1534, 3.8175> <1.1331, 20.1793, 3.8175>
		<1.0894, 19.3935, 3.9241> <1.1095, 19.4136, 3.9241> <1.1095, 20.1156, 3.9241> <1.0894, 20.1356, 3.9241>
		<1.0719, 19.4110, 4.0098> <1.0920, 19.4311, 4.0098> <1.0920, 20.0981, 4.0098> <1.0719, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1747, 20.2209, 3.7504> <1.1487, 20.2468, 3.7504> <0.2879, 20.2468, 3.7504> <0.2620, 20.2209, 3.7504>
		<1.1331, 20.1793, 3.8175> <1.1072, 20.2053, 3.8175> <0.3295, 20.2053, 3.8175> <0.3036, 20.1793, 3.8175>
		<1.0894, 20.1356, 3.9241> <1.0693, 20.1557, 3.9241> <0.3674, 20.1557, 3.9241> <0.3473, 20.1356, 3.9241>
		<1.0719, 20.1182, 4.0098> <1.0518, 20.1383, 4.0098> <0.3848, 20.1383, 4.0098> <0.3648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3648, 19.4110, 4.0098> <0.3832, 19.4294, 4.1002> <0.3779, 19.4242, 4.2288> <0.3787, 19.4250, 4.3229>
		<0.3447, 19.4311, 4.0098> <0.3631, 19.4495, 4.1002> <0.3587, 19.4435, 4.2288> <0.3595, 19.4443, 4.3229>
		<0.3447, 20.0981, 4.0098> <0.3631, 20.0797, 4.1002> <0.3587, 20.0857, 4.2288> <0.3595, 20.0849, 4.3229>
		<0.3648, 20.1182, 4.0098> <0.3832, 20.0997, 4.1002> <0.3779, 20.1050, 4.2288> <0.3787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3648, 19.4110, 4.0098> <0.3848, 19.3909, 4.0098> <1.0518, 19.3909, 4.0098> <1.0719, 19.4110, 4.0098>
		<0.3832, 19.4294, 4.1002> <0.4033, 19.4094, 4.1002> <1.0334, 19.4094, 4.1002> <1.0535, 19.4294, 4.1002>
		<0.3779, 19.4242, 4.2288> <0.3972, 19.4049, 4.2288> <1.0394, 19.4049, 4.2288> <1.0587, 19.4242, 4.2288>
		<0.3787, 19.4250, 4.3229> <0.3980, 19.4057, 4.3229> <1.0386, 19.4057, 4.3229> <1.0579, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0719, 19.4110, 4.0098> <1.0920, 19.4311, 4.0098> <1.0920, 20.0981, 4.0098> <1.0719, 20.1182, 4.0098>
		<1.0535, 19.4294, 4.1002> <1.0736, 19.4495, 4.1002> <1.0736, 20.0797, 4.1002> <1.0535, 20.0997, 4.1002>
		<1.0587, 19.4242, 4.2288> <1.0780, 19.4435, 4.2288> <1.0780, 20.0857, 4.2288> <1.0587, 20.1050, 4.2288>
		<1.0579, 19.4250, 4.3229> <1.0772, 19.4443, 4.3229> <1.0772, 20.0849, 4.3229> <1.0579, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0719, 20.1182, 4.0098> <1.0518, 20.1383, 4.0098> <0.3848, 20.1383, 4.0098> <0.3648, 20.1182, 4.0098>
		<1.0535, 20.0997, 4.1002> <1.0334, 20.1198, 4.1002> <0.4033, 20.1198, 4.1002> <0.3832, 20.0997, 4.1002>
		<1.0587, 20.1050, 4.2288> <1.0394, 20.1243, 4.2288> <0.3972, 20.1243, 4.2288> <0.3779, 20.1050, 4.2288>
		<1.0579, 20.1042, 4.3229> <1.0386, 20.1235, 4.3229> <0.3980, 20.1235, 4.3229> <0.3787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3787, 19.4250, 4.3229> <0.3821, 19.4284, 4.7283> <0.3803, 19.4265, 5.2689> <0.3787, 19.4250, 5.6744>
		<0.3595, 19.4443, 4.3229> <0.3629, 19.4477, 4.7283> <0.3610, 19.4458, 5.2689> <0.3595, 19.4443, 5.6744>
		<0.3595, 20.0849, 4.3229> <0.3629, 20.0815, 4.7283> <0.3610, 20.0834, 5.2689> <0.3595, 20.0849, 5.6744>
		<0.3787, 20.1042, 4.3229> <0.3821, 20.1008, 4.7283> <0.3803, 20.1027, 5.2689> <0.3787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3787, 19.4250, 4.3229> <0.3980, 19.4057, 4.3229> <1.0386, 19.4057, 4.3229> <1.0579, 19.4250, 4.3229>
		<0.3821, 19.4284, 4.7283> <0.4014, 19.4091, 4.7283> <1.0352, 19.4091, 4.7283> <1.0545, 19.4284, 4.7283>
		<0.3803, 19.4265, 5.2689> <0.3996, 19.4072, 5.2689> <1.0371, 19.4072, 5.2689> <1.0564, 19.4265, 5.2689>
		<0.3787, 19.4250, 5.6744> <0.3980, 19.4057, 5.6744> <1.0386, 19.4057, 5.6744> <1.0579, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0579, 19.4250, 4.3229> <1.0772, 19.4443, 4.3229> <1.0772, 20.0849, 4.3229> <1.0579, 20.1042, 4.3229>
		<1.0545, 19.4284, 4.7283> <1.0738, 19.4477, 4.7283> <1.0738, 20.0815, 4.7283> <1.0545, 20.1008, 4.7283>
		<1.0564, 19.4265, 5.2689> <1.0757, 19.4458, 5.2689> <1.0757, 20.0834, 5.2689> <1.0564, 20.1027, 5.2689>
		<1.0579, 19.4250, 5.6744> <1.0772, 19.4443, 5.6744> <1.0772, 20.0849, 5.6744> <1.0579, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0579, 20.1042, 4.3229> <1.0386, 20.1235, 4.3229> <0.3980, 20.1235, 4.3229> <0.3787, 20.1042, 4.3229>
		<1.0545, 20.1008, 4.7283> <1.0352, 20.1201, 4.7283> <0.4014, 20.1201, 4.7283> <0.3821, 20.1008, 4.7283>
		<1.0564, 20.1027, 5.2689> <1.0371, 20.1220, 5.2689> <0.3996, 20.1220, 5.2689> <0.3803, 20.1027, 5.2689>
		<1.0579, 20.1042, 5.6744> <1.0386, 20.1235, 5.6744> <0.3980, 20.1235, 5.6744> <0.3787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3787, 19.4250, 5.6744> <0.3775, 19.4237, 6.0073> <0.3828, 19.4290, 6.4517> <0.3695, 19.4157, 6.7841>
		<0.3595, 19.4443, 5.6744> <0.3582, 19.4430, 6.0073> <0.3629, 19.4488, 6.4517> <0.3497, 19.4355, 6.7841>
		<0.3595, 20.0849, 5.6744> <0.3582, 20.0861, 6.0073> <0.3629, 20.0804, 6.4517> <0.3497, 20.0936, 6.7841>
		<0.3787, 20.1042, 5.6744> <0.3775, 20.1054, 6.0073> <0.3828, 20.1002, 6.4517> <0.3695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3787, 19.4250, 5.6744> <0.3980, 19.4057, 5.6744> <1.0386, 19.4057, 5.6744> <1.0579, 19.4250, 5.6744>
		<0.3775, 19.4237, 6.0073> <0.3968, 19.4044, 6.0073> <1.0399, 19.4044, 6.0073> <1.0592, 19.4237, 6.0073>
		<0.3828, 19.4290, 6.4517> <0.4026, 19.4092, 6.4517> <1.0341, 19.4092, 6.4517> <1.0539, 19.4290, 6.4517>
		<0.3695, 19.4157, 6.7841> <0.3893, 19.3959, 6.7841> <1.0474, 19.3959, 6.7841> <1.0672, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0579, 19.4250, 5.6744> <1.0772, 19.4443, 5.6744> <1.0772, 20.0849, 5.6744> <1.0579, 20.1042, 5.6744>
		<1.0592, 19.4237, 6.0073> <1.0785, 19.4430, 6.0073> <1.0785, 20.0861, 6.0073> <1.0592, 20.1054, 6.0073>
		<1.0539, 19.4290, 6.4517> <1.0737, 19.4488, 6.4517> <1.0737, 20.0804, 6.4517> <1.0539, 20.1002, 6.4517>
		<1.0672, 19.4157, 6.7841> <1.0870, 19.4355, 6.7841> <1.0870, 20.0936, 6.7841> <1.0672, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0579, 20.1042, 5.6744> <1.0386, 20.1235, 5.6744> <0.3980, 20.1235, 5.6744> <0.3787, 20.1042, 5.6744>
		<1.0592, 20.1054, 6.0073> <1.0399, 20.1247, 6.0073> <0.3968, 20.1247, 6.0073> <0.3775, 20.1054, 6.0073>
		<1.0539, 20.1002, 6.4517> <1.0341, 20.1200, 6.4517> <0.4026, 20.1200, 6.4517> <0.3828, 20.1002, 6.4517>
		<1.0672, 20.1134, 6.7841> <1.0474, 20.1333, 6.7841> <0.3893, 20.1333, 6.7841> <0.3695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3695, 19.4157, 6.7841> <0.3675, 19.4137, 6.8341> <0.3551, 19.4013, 6.9079> <0.3282, 19.3745, 6.9405>
		<0.3497, 19.4355, 6.7841> <0.3477, 19.4336, 6.8341> <0.3329, 19.4235, 6.9079> <0.3060, 19.3966, 6.9405>
		<0.3497, 20.0936, 6.7841> <0.3477, 20.0956, 6.8341> <0.3329, 20.1057, 6.9079> <0.3060, 20.1326, 6.9405>
		<0.3695, 20.1134, 6.7841> <0.3675, 20.1154, 6.8341> <0.3551, 20.1278, 6.9079> <0.3282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3695, 19.4157, 6.7841> <0.3893, 19.3959, 6.7841> <1.0474, 19.3959, 6.7841> <1.0672, 19.4157, 6.7841>
		<0.3675, 19.4137, 6.8341> <0.3873, 19.3939, 6.8341> <1.0494, 19.3939, 6.8341> <1.0692, 19.4137, 6.8341>
		<0.3551, 19.4013, 6.9079> <0.3772, 19.3792, 6.9079> <1.0594, 19.3792, 6.9079> <1.0816, 19.4013, 6.9079>
		<0.3282, 19.3745, 6.9405> <0.3504, 19.3523, 6.9405> <1.0863, 19.3523, 6.9405> <1.1085, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0672, 19.4157, 6.7841> <1.0870, 19.4355, 6.7841> <1.0870, 20.0936, 6.7841> <1.0672, 20.1134, 6.7841>
		<1.0692, 19.4137, 6.8341> <1.0890, 19.4336, 6.8341> <1.0890, 20.0956, 6.8341> <1.0692, 20.1154, 6.8341>
		<1.0816, 19.4013, 6.9079> <1.1038, 19.4235, 6.9079> <1.1038, 20.1057, 6.9079> <1.0816, 20.1278, 6.9079>
		<1.1085, 19.3745, 6.9405> <1.1306, 19.3966, 6.9405> <1.1306, 20.1326, 6.9405> <1.1085, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.0672, 20.1134, 6.7841> <1.0474, 20.1333, 6.7841> <0.3893, 20.1333, 6.7841> <0.3695, 20.1134, 6.7841>
		<1.0692, 20.1154, 6.8341> <1.0494, 20.1352, 6.8341> <0.3873, 20.1352, 6.8341> <0.3675, 20.1154, 6.8341>
		<1.0816, 20.1278, 6.9079> <1.0594, 20.1500, 6.9079> <0.3772, 20.1500, 6.9079> <0.3551, 20.1278, 6.9079>
		<1.1085, 20.1547, 6.9405> <1.0863, 20.1769, 6.9405> <0.3504, 20.1769, 6.9405> <0.3282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3282, 19.3745, 6.9405> <0.2661, 19.3123, 7.0160> <0.1380, 19.1842, 7.0331> <0.0886, 19.1348, 7.1255>
		<0.3060, 19.3966, 6.9405> <0.2439, 19.3345, 7.0160> <0.1022, 19.2200, 7.0331> <0.0528, 19.1706, 7.1255>
		<0.3060, 20.1326, 6.9405> <0.2439, 20.1947, 7.0160> <0.1022, 20.3092, 7.0331> <0.0528, 20.3586, 7.1255>
		<0.3282, 20.1547, 6.9405> <0.2661, 20.2168, 7.0160> <0.1380, 20.3449, 7.0331> <0.0886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3282, 19.3745, 6.9405> <0.3504, 19.3523, 6.9405> <1.0863, 19.3523, 6.9405> <1.1085, 19.3745, 6.9405>
		<0.2661, 19.3123, 7.0160> <0.2883, 19.2902, 7.0160> <1.1484, 19.2902, 7.0160> <1.1706, 19.3123, 7.0160>
		<0.1380, 19.1842, 7.0331> <0.1738, 19.1485, 7.0331> <1.2629, 19.1485, 7.0331> <1.2987, 19.1842, 7.0331>
		<0.0886, 19.1348, 7.1255> <0.1243, 19.0990, 7.1255> <1.3123, 19.0990, 7.1255> <1.3481, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1085, 19.3745, 6.9405> <1.1306, 19.3966, 6.9405> <1.1306, 20.1326, 6.9405> <1.1085, 20.1547, 6.9405>
		<1.1706, 19.3123, 7.0160> <1.1927, 19.3345, 7.0160> <1.1927, 20.1947, 7.0160> <1.1706, 20.2168, 7.0160>
		<1.2987, 19.1842, 7.0331> <1.3345, 19.2200, 7.0331> <1.3345, 20.3092, 7.0331> <1.2987, 20.3449, 7.0331>
		<1.3481, 19.1348, 7.1255> <1.3839, 19.1706, 7.1255> <1.3839, 20.3586, 7.1255> <1.3481, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.1085, 20.1547, 6.9405> <1.0863, 20.1769, 6.9405> <0.3504, 20.1769, 6.9405> <0.3282, 20.1547, 6.9405>
		<1.1706, 20.2168, 7.0160> <1.1484, 20.2390, 7.0160> <0.2883, 20.2390, 7.0160> <0.2661, 20.2168, 7.0160>
		<1.2987, 20.3449, 7.0331> <1.2629, 20.3807, 7.0331> <0.1738, 20.3807, 7.0331> <0.1380, 20.3449, 7.0331>
		<1.3481, 20.3944, 7.1255> <1.3123, 20.4301, 7.1255> <0.1243, 20.4301, 7.1255> <0.0886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0886, 19.1348, 7.1255> <0.0681, 19.1143, 7.1638> <0.1684, 19.2146, 7.1912> <0.1684, 19.2146, 7.2393>
		<0.0528, 19.1706, 7.1255> <0.0323, 19.1501, 7.1638> <0.1371, 19.2459, 7.1912> <0.1371, 19.2459, 7.2393>
		<0.0528, 20.3586, 7.1255> <0.0323, 20.3791, 7.1638> <0.1371, 20.2833, 7.1912> <0.1371, 20.2833, 7.2393>
		<0.0886, 20.3944, 7.1255> <0.0681, 20.4149, 7.1638> <0.1684, 20.3146, 7.1912> <0.1684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0886, 19.1348, 7.1255> <0.1243, 19.0990, 7.1255> <1.3123, 19.0990, 7.1255> <1.3481, 19.1348, 7.1255>
		<0.0681, 19.1143, 7.1638> <0.1038, 19.0785, 7.1638> <1.3329, 19.0785, 7.1638> <1.3686, 19.1143, 7.1638>
		<0.1684, 19.2146, 7.1912> <0.1996, 19.1834, 7.1912> <1.2371, 19.1834, 7.1912> <1.2683, 19.2146, 7.1912>
		<0.1684, 19.2146, 7.2393> <0.1996, 19.1834, 7.2393> <1.2371, 19.1834, 7.2393> <1.2683, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3481, 19.1348, 7.1255> <1.3839, 19.1706, 7.1255> <1.3839, 20.3586, 7.1255> <1.3481, 20.3944, 7.1255>
		<1.3686, 19.1143, 7.1638> <1.4044, 19.1501, 7.1638> <1.4044, 20.3791, 7.1638> <1.3686, 20.4149, 7.1638>
		<1.2683, 19.2146, 7.1912> <1.2995, 19.2459, 7.1912> <1.2995, 20.2833, 7.1912> <1.2683, 20.3146, 7.1912>
		<1.2683, 19.2146, 7.2393> <1.2995, 19.2459, 7.2393> <1.2995, 20.2833, 7.2393> <1.2683, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3481, 20.3944, 7.1255> <1.3123, 20.4301, 7.1255> <0.1243, 20.4301, 7.1255> <0.0886, 20.3944, 7.1255>
		<1.3686, 20.4149, 7.1638> <1.3329, 20.4506, 7.1638> <0.1038, 20.4506, 7.1638> <0.0681, 20.4149, 7.1638>
		<1.2683, 20.3146, 7.1912> <1.2371, 20.3458, 7.1912> <0.1996, 20.3458, 7.1912> <0.1684, 20.3146, 7.1912>
		<1.2683, 20.3146, 7.2393> <1.2371, 20.3458, 7.2393> <0.1996, 20.3458, 7.2393> <0.1684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1684, 19.2146, 7.2393> <0.1684, 19.2146, 7.2905> <0.0946, 19.1408, 7.3169> <0.0886, 19.1348, 7.3673>
		<0.1371, 19.2459, 7.2393> <0.1371, 19.2459, 7.2905> <0.0588, 19.1766, 7.3169> <0.0528, 19.1706, 7.3673>
		<0.1371, 20.2833, 7.2393> <0.1371, 20.2833, 7.2905> <0.0588, 20.3526, 7.3169> <0.0528, 20.3586, 7.3673>
		<0.1684, 20.3146, 7.2393> <0.1684, 20.3146, 7.2905> <0.0946, 20.3883, 7.3169> <0.0886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1684, 19.2146, 7.2393> <0.1996, 19.1834, 7.2393> <1.2371, 19.1834, 7.2393> <1.2683, 19.2146, 7.2393>
		<0.1684, 19.2146, 7.2905> <0.1996, 19.1834, 7.2905> <1.2371, 19.1834, 7.2905> <1.2683, 19.2146, 7.2905>
		<0.0946, 19.1408, 7.3169> <0.1304, 19.1051, 7.3169> <1.3063, 19.1051, 7.3169> <1.3421, 19.1408, 7.3169>
		<0.0886, 19.1348, 7.3673> <0.1243, 19.0990, 7.3673> <1.3123, 19.0990, 7.3673> <1.3481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2683, 19.2146, 7.2393> <1.2995, 19.2459, 7.2393> <1.2995, 20.2833, 7.2393> <1.2683, 20.3146, 7.2393>
		<1.2683, 19.2146, 7.2905> <1.2995, 19.2459, 7.2905> <1.2995, 20.2833, 7.2905> <1.2683, 20.3146, 7.2905>
		<1.3421, 19.1408, 7.3169> <1.3778, 19.1766, 7.3169> <1.3778, 20.3526, 7.3169> <1.3421, 20.3883, 7.3169>
		<1.3481, 19.1348, 7.3673> <1.3839, 19.1706, 7.3673> <1.3839, 20.3586, 7.3673> <1.3481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.2683, 20.3146, 7.2393> <1.2371, 20.3458, 7.2393> <0.1996, 20.3458, 7.2393> <0.1684, 20.3146, 7.2393>
		<1.2683, 20.3146, 7.2905> <1.2371, 20.3458, 7.2905> <0.1996, 20.3458, 7.2905> <0.1684, 20.3146, 7.2905>
		<1.3421, 20.3883, 7.3169> <1.3063, 20.4241, 7.3169> <0.1304, 20.4241, 7.3169> <0.0946, 20.3883, 7.3169>
		<1.3481, 20.3944, 7.3673> <1.3123, 20.4301, 7.3673> <0.1243, 20.4301, 7.3673> <0.0886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0886, 19.1348, 7.9080> <0.0528, 19.1706, 7.9080> <0.0528, 20.3586, 7.9080> <0.0886, 20.3944, 7.9080>
		<0.0886, 19.1348, 7.7458> <0.0528, 19.1706, 7.7458> <0.0528, 20.3586, 7.7458> <0.0886, 20.3944, 7.7458>
		<0.0695, 19.1157, 7.5273> <0.0337, 19.1515, 7.5273> <0.0337, 20.3777, 7.5273> <0.0695, 20.4134, 7.5273>
		<0.0886, 19.1348, 7.3673> <0.0528, 19.1706, 7.3673> <0.0528, 20.3586, 7.3673> <0.0886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0886, 19.1348, 7.9080> <0.0886, 19.1348, 7.7458> <0.0695, 19.1157, 7.5273> <0.0886, 19.1348, 7.3673>
		<0.1243, 19.0990, 7.9080> <0.1243, 19.0990, 7.7458> <0.1053, 19.0800, 7.5273> <0.1243, 19.0990, 7.3673>
		<1.3123, 19.0990, 7.9080> <1.3123, 19.0990, 7.7458> <1.3314, 19.0800, 7.5273> <1.3123, 19.0990, 7.3673>
		<1.3481, 19.1348, 7.9080> <1.3481, 19.1348, 7.7458> <1.3672, 19.1157, 7.5273> <1.3481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3481, 19.1348, 7.9080> <1.3481, 19.1348, 7.7458> <1.3672, 19.1157, 7.5273> <1.3481, 19.1348, 7.3673>
		<1.3839, 19.1706, 7.9080> <1.3839, 19.1706, 7.7458> <1.4030, 19.1515, 7.5273> <1.3839, 19.1706, 7.3673>
		<1.3839, 20.3586, 7.9080> <1.3839, 20.3586, 7.7458> <1.4030, 20.3777, 7.5273> <1.3839, 20.3586, 7.3673>
		<1.3481, 20.3944, 7.9080> <1.3481, 20.3944, 7.7458> <1.3672, 20.4134, 7.5273> <1.3481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3481, 20.3944, 7.9080> <1.3481, 20.3944, 7.7458> <1.3672, 20.4134, 7.5273> <1.3481, 20.3944, 7.3673>
		<1.3123, 20.4301, 7.9080> <1.3123, 20.4301, 7.7458> <1.3314, 20.4492, 7.5273> <1.3123, 20.4301, 7.3673>
		<0.1243, 20.4301, 7.9080> <0.1243, 20.4301, 7.7458> <0.1053, 20.4492, 7.5273> <0.1243, 20.4301, 7.3673>
		<0.0886, 20.3944, 7.9080> <0.0886, 20.3944, 7.7458> <0.0695, 20.4134, 7.5273> <0.0886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 18.8874, 0.7771> <-0.2087, 18.9372, 0.7771> <-0.2087, 20.5920, 0.7771> <-0.1589, 20.6418, 0.7771>
		<-0.1796, 18.8666, 0.6520> <-0.2294, 18.9164, 0.6520> <-0.2294, 20.6127, 0.6520> <-0.1796, 20.6626, 0.6520>
		<-0.1589, 18.8874, 0.4772> <-0.2087, 18.9372, 0.4772> <-0.2087, 20.5920, 0.4772> <-0.1589, 20.6418, 0.4772>
		<-0.1589, 18.8874, 0.3486> <-0.2087, 18.9372, 0.3486> <-0.2087, 20.5920, 0.3486> <-0.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 18.8874, 0.7771> <-0.1796, 18.8666, 0.6520> <-0.1589, 18.8874, 0.4772> <-0.1589, 18.8874, 0.3486>
		<-0.1090, 18.8376, 0.7771> <-0.1298, 18.8168, 0.6520> <-0.1090, 18.8376, 0.4772> <-0.1090, 18.8376, 0.3486>
		<1.5457, 18.8376, 0.7771> <1.5665, 18.8168, 0.6520> <1.5457, 18.8376, 0.4772> <1.5457, 18.8376, 0.3486>
		<1.5955, 18.8874, 0.7771> <1.6163, 18.8666, 0.6520> <1.5955, 18.8874, 0.4772> <1.5955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5955, 18.8874, 0.7771> <1.6163, 18.8666, 0.6520> <1.5955, 18.8874, 0.4772> <1.5955, 18.8874, 0.3486>
		<1.6454, 18.9372, 0.7771> <1.6661, 18.9164, 0.6520> <1.6454, 18.9372, 0.4772> <1.6454, 18.9372, 0.3486>
		<1.6454, 20.5920, 0.7771> <1.6661, 20.6127, 0.6520> <1.6454, 20.5920, 0.4772> <1.6454, 20.5920, 0.3486>
		<1.5955, 20.6418, 0.7771> <1.6163, 20.6626, 0.6520> <1.5955, 20.6418, 0.4772> <1.5955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5955, 20.6418, 0.7771> <1.6163, 20.6626, 0.6520> <1.5955, 20.6418, 0.4772> <1.5955, 20.6418, 0.3486>
		<1.5457, 20.6916, 0.7771> <1.5665, 20.7124, 0.6520> <1.5457, 20.6916, 0.4772> <1.5457, 20.6916, 0.3486>
		<-0.1090, 20.6916, 0.7771> <-0.1298, 20.7124, 0.6520> <-0.1090, 20.6916, 0.4772> <-0.1090, 20.6916, 0.3486>
		<-0.1589, 20.6418, 0.7771> <-0.1796, 20.6626, 0.6520> <-0.1589, 20.6418, 0.4772> <-0.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 18.8874, -0.0618> <-0.1589, 18.8874, 0.0613> <-0.1589, 18.8874, 0.2255> <-0.1589, 18.8874, 0.3486>
		<-0.2087, 18.9372, -0.0618> <-0.2087, 18.9372, 0.0613> <-0.2087, 18.9372, 0.2255> <-0.2087, 18.9372, 0.3486>
		<-0.2087, 20.5920, -0.0618> <-0.2087, 20.5920, 0.0613> <-0.2087, 20.5920, 0.2255> <-0.2087, 20.5920, 0.3486>
		<-0.1589, 20.6418, -0.0618> <-0.1589, 20.6418, 0.0613> <-0.1589, 20.6418, 0.2255> <-0.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1589, 18.8874, -0.0618> <-0.1090, 18.8376, -0.0618> <1.5457, 18.8376, -0.0618> <1.5955, 18.8874, -0.0618>
		<-0.1589, 18.8874, 0.0613> <-0.1090, 18.8376, 0.0613> <1.5457, 18.8376, 0.0613> <1.5955, 18.8874, 0.0613>
		<-0.1589, 18.8874, 0.2255> <-0.1090, 18.8376, 0.2255> <1.5457, 18.8376, 0.2255> <1.5955, 18.8874, 0.2255>
		<-0.1589, 18.8874, 0.3486> <-0.1090, 18.8376, 0.3486> <1.5457, 18.8376, 0.3486> <1.5955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5955, 18.8874, -0.0618> <1.6454, 18.9372, -0.0618> <1.6454, 20.5920, -0.0618> <1.5955, 20.6418, -0.0618>
		<1.5955, 18.8874, 0.0613> <1.6454, 18.9372, 0.0613> <1.6454, 20.5920, 0.0613> <1.5955, 20.6418, 0.0613>
		<1.5955, 18.8874, 0.2255> <1.6454, 18.9372, 0.2255> <1.6454, 20.5920, 0.2255> <1.5955, 20.6418, 0.2255>
		<1.5955, 18.8874, 0.3486> <1.6454, 18.9372, 0.3486> <1.6454, 20.5920, 0.3486> <1.5955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5955, 20.6418, -0.0618> <1.5457, 20.6916, -0.0618> <-0.1090, 20.6916, -0.0618> <-0.1589, 20.6418, -0.0618>
		<1.5955, 20.6418, 0.0613> <1.5457, 20.6916, 0.0613> <-0.1090, 20.6916, 0.0613> <-0.1589, 20.6418, 0.0613>
		<1.5955, 20.6418, 0.2255> <1.5457, 20.6916, 0.2255> <-0.1090, 20.6916, 0.2255> <-0.1589, 20.6418, 0.2255>
		<1.5955, 20.6418, 0.3486> <1.5457, 20.6916, 0.3486> <-0.1090, 20.6916, 0.3486> <-0.1589, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 0.9062> <2.0891, 19.0245, 0.9062> <2.0891, 20.5047, 0.9062> <2.1336, 20.5493, 0.9062>
		<2.1288, 18.9751, 0.8515> <2.0843, 19.0196, 0.8515> <2.0843, 20.5095, 0.8515> <2.1288, 20.5541, 0.8515>
		<2.0500, 18.8963, 0.8308> <2.0002, 18.9461, 0.8308> <2.0002, 20.5831, 0.8308> <2.0500, 20.6329, 0.8308>
		<2.0411, 18.8874, 0.7771> <1.9913, 18.9372, 0.7771> <1.9913, 20.5920, 0.7771> <2.0411, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 0.9062> <2.1380, 18.9842, 0.9557> <2.0440, 18.8903, 0.9996> <2.0643, 18.9105, 1.0404>
		<2.0891, 19.0245, 0.9062> <2.0934, 19.0288, 0.9557> <1.9955, 18.9388, 0.9996> <2.0157, 18.9590, 1.0404>
		<2.0891, 20.5047, 0.9062> <2.0934, 20.5004, 0.9557> <1.9955, 20.5904, 0.9996> <2.0157, 20.5702, 1.0404>
		<2.1336, 20.5493, 0.9062> <2.1380, 20.5449, 0.9557> <2.0440, 20.6389, 0.9996> <2.0643, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 0.9062> <2.1288, 18.9751, 0.8515> <2.0500, 18.8963, 0.8308> <2.0411, 18.8874, 0.7771>
		<2.1782, 18.9353, 0.9062> <2.1734, 18.9305, 0.8515> <2.0999, 18.8465, 0.8308> <2.0910, 18.8376, 0.7771>
		<3.6585, 18.9353, 0.9062> <3.6633, 18.9305, 0.8515> <3.7368, 18.8465, 0.8308> <3.7457, 18.8376, 0.7771>
		<3.7030, 18.9799, 0.9062> <3.7078, 18.9751, 0.8515> <3.7866, 18.8963, 0.8308> <3.7955, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 0.9062> <2.1782, 18.9353, 0.9062> <3.6585, 18.9353, 0.9062> <3.7030, 18.9799, 0.9062>
		<2.1380, 18.9842, 0.9557> <2.1825, 18.9397, 0.9557> <3.6541, 18.9397, 0.9557> <3.6987, 18.9842, 0.9557>
		<2.0440, 18.8903, 0.9996> <2.0925, 18.8418, 0.9996> <3.7441, 18.8418, 0.9996> <3.7927, 18.8903, 0.9996>
		<2.0643, 18.9105, 1.0404> <2.1128, 18.8620, 1.0404> <3.7239, 18.8620, 1.0404> <3.7724, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 18.9799, 0.9062> <3.7078, 18.9751, 0.8515> <3.7866, 18.8963, 0.8308> <3.7955, 18.8874, 0.7771>
		<3.7476, 19.0245, 0.9062> <3.7524, 19.0196, 0.8515> <3.8365, 18.9461, 0.8308> <3.8454, 18.9372, 0.7771>
		<3.7476, 20.5047, 0.9062> <3.7524, 20.5095, 0.8515> <3.8365, 20.5831, 0.8308> <3.8454, 20.5920, 0.7771>
		<3.7030, 20.5493, 0.9062> <3.7078, 20.5541, 0.8515> <3.7866, 20.6329, 0.8308> <3.7955, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 18.9799, 0.9062> <3.7476, 19.0245, 0.9062> <3.7476, 20.5047, 0.9062> <3.7030, 20.5493, 0.9062>
		<3.6987, 18.9842, 0.9557> <3.7433, 19.0288, 0.9557> <3.7433, 20.5004, 0.9557> <3.6987, 20.5449, 0.9557>
		<3.7927, 18.8903, 0.9996> <3.8412, 18.9388, 0.9996> <3.8412, 20.5904, 0.9996> <3.7927, 20.6389, 0.9996>
		<3.7724, 18.9105, 1.0404> <3.8209, 18.9590, 1.0404> <3.8209, 20.5702, 1.0404> <3.7724, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 20.5493, 0.9062> <3.7078, 20.5541, 0.8515> <3.7866, 20.6329, 0.8308> <3.7955, 20.6418, 0.7771>
		<3.6585, 20.5939, 0.9062> <3.6633, 20.5987, 0.8515> <3.7368, 20.6827, 0.8308> <3.7457, 20.6916, 0.7771>
		<2.1782, 20.5939, 0.9062> <2.1734, 20.5987, 0.8515> <2.0999, 20.6827, 0.8308> <2.0910, 20.6916, 0.7771>
		<2.1336, 20.5493, 0.9062> <2.1288, 20.5541, 0.8515> <2.0500, 20.6329, 0.8308> <2.0411, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 20.5493, 0.9062> <3.6585, 20.5939, 0.9062> <2.1782, 20.5939, 0.9062> <2.1336, 20.5493, 0.9062>
		<3.6987, 20.5449, 0.9557> <3.6541, 20.5895, 0.9557> <2.1825, 20.5895, 0.9557> <2.1380, 20.5449, 0.9557>
		<3.7927, 20.6389, 0.9996> <3.7441, 20.6874, 0.9996> <2.0925, 20.6874, 0.9996> <2.0440, 20.6389, 0.9996>
		<3.7724, 20.6187, 1.0404> <3.7239, 20.6672, 1.0404> <2.1128, 20.6672, 1.0404> <2.0643, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0643, 18.9105, 1.0404> <2.1323, 18.9786, 1.1777> <2.3018, 19.1481, 1.2552> <2.3731, 19.2193, 1.3892>
		<2.0157, 18.9590, 1.0404> <2.0838, 19.0271, 1.1777> <2.2709, 19.1790, 1.2552> <2.3421, 19.2503, 1.3892>
		<2.0157, 20.5702, 1.0404> <2.0838, 20.5021, 1.1777> <2.2709, 20.3501, 1.2552> <2.3421, 20.2789, 1.3892>
		<2.0643, 20.6187, 1.0404> <2.1323, 20.5506, 1.1777> <2.3018, 20.3811, 1.2552> <2.3731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0643, 18.9105, 1.0404> <2.1128, 18.8620, 1.0404> <3.7239, 18.8620, 1.0404> <3.7724, 18.9105, 1.0404>
		<2.1323, 18.9786, 1.1777> <2.1808, 18.9301, 1.1777> <3.6558, 18.9301, 1.1777> <3.7043, 18.9786, 1.1777>
		<2.3018, 19.1481, 1.2552> <2.3328, 19.1171, 1.2552> <3.5039, 19.1171, 1.2552> <3.5348, 19.1481, 1.2552>
		<2.3731, 19.2193, 1.3892> <2.4041, 19.1884, 1.3892> <3.4326, 19.1884, 1.3892> <3.4636, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7724, 18.9105, 1.0404> <3.8209, 18.9590, 1.0404> <3.8209, 20.5702, 1.0404> <3.7724, 20.6187, 1.0404>
		<3.7043, 18.9786, 1.1777> <3.7529, 19.0271, 1.1777> <3.7529, 20.5021, 1.1777> <3.7043, 20.5506, 1.1777>
		<3.5348, 19.1481, 1.2552> <3.5658, 19.1790, 1.2552> <3.5658, 20.3501, 1.2552> <3.5348, 20.3811, 1.2552>
		<3.4636, 19.2193, 1.3892> <3.4946, 19.2503, 1.3892> <3.4946, 20.2789, 1.3892> <3.4636, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7724, 20.6187, 1.0404> <3.7239, 20.6672, 1.0404> <2.1128, 20.6672, 1.0404> <2.0643, 20.6187, 1.0404>
		<3.7043, 20.5506, 1.1777> <3.6558, 20.5991, 1.1777> <2.1808, 20.5991, 1.1777> <2.1323, 20.5506, 1.1777>
		<3.5348, 20.3811, 1.2552> <3.5039, 20.4121, 1.2552> <2.3328, 20.4121, 1.2552> <2.3018, 20.3811, 1.2552>
		<3.4636, 20.3098, 1.3892> <3.4326, 20.3408, 1.3892> <2.4041, 20.3408, 1.3892> <2.3731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3731, 19.2193, 1.3892> <2.3921, 19.2383, 1.4249> <2.3163, 19.1626, 1.4698> <2.3163, 19.1626, 1.5144>
		<2.3421, 19.2503, 1.3892> <2.3611, 19.2693, 1.4249> <2.2821, 19.1968, 1.4698> <2.2821, 19.1968, 1.5144>
		<2.3421, 20.2789, 1.3892> <2.3611, 20.2599, 1.4249> <2.2821, 20.3324, 1.4698> <2.2821, 20.3324, 1.5144>
		<2.3731, 20.3098, 1.3892> <2.3921, 20.2909, 1.4249> <2.3163, 20.3666, 1.4698> <2.3163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3731, 19.2193, 1.3892> <2.4041, 19.1884, 1.3892> <3.4326, 19.1884, 1.3892> <3.4636, 19.2193, 1.3892>
		<2.3921, 19.2383, 1.4249> <2.4230, 19.2073, 1.4249> <3.4137, 19.2073, 1.4249> <3.4446, 19.2383, 1.4249>
		<2.3163, 19.1626, 1.4698> <2.3505, 19.1284, 1.4698> <3.4862, 19.1284, 1.4698> <3.5204, 19.1626, 1.4698>
		<2.3163, 19.1626, 1.5144> <2.3505, 19.1284, 1.5144> <3.4862, 19.1284, 1.5144> <3.5204, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4636, 19.2193, 1.3892> <3.4946, 19.2503, 1.3892> <3.4946, 20.2789, 1.3892> <3.4636, 20.3098, 1.3892>
		<3.4446, 19.2383, 1.4249> <3.4756, 19.2693, 1.4249> <3.4756, 20.2599, 1.4249> <3.4446, 20.2909, 1.4249>
		<3.5204, 19.1626, 1.4698> <3.5545, 19.1968, 1.4698> <3.5545, 20.3324, 1.4698> <3.5204, 20.3666, 1.4698>
		<3.5204, 19.1626, 1.5144> <3.5545, 19.1968, 1.5144> <3.5545, 20.3324, 1.5144> <3.5204, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4636, 20.3098, 1.3892> <3.4326, 20.3408, 1.3892> <2.4041, 20.3408, 1.3892> <2.3731, 20.3098, 1.3892>
		<3.4446, 20.2909, 1.4249> <3.4137, 20.3218, 1.4249> <2.4230, 20.3218, 1.4249> <2.3921, 20.2909, 1.4249>
		<3.5204, 20.3666, 1.4698> <3.4862, 20.4008, 1.4698> <2.3505, 20.4008, 1.4698> <2.3163, 20.3666, 1.4698>
		<3.5204, 20.3666, 1.5144> <3.4862, 20.4008, 1.5144> <2.3505, 20.4008, 1.5144> <2.3163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3163, 19.1626, 1.5144> <2.3163, 19.1626, 1.5613> <2.3879, 19.2341, 1.6066> <2.3731, 19.2193, 1.6486>
		<2.2821, 19.1968, 1.5144> <2.2821, 19.1968, 1.5613> <2.3569, 19.2651, 1.6066> <2.3421, 19.2503, 1.6486>
		<2.2821, 20.3324, 1.5144> <2.2821, 20.3324, 1.5613> <2.3569, 20.2641, 1.6066> <2.3421, 20.2789, 1.6486>
		<2.3163, 20.3666, 1.5144> <2.3163, 20.3666, 1.5613> <2.3879, 20.2950, 1.6066> <2.3731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3163, 19.1626, 1.5144> <2.3505, 19.1284, 1.5144> <3.4862, 19.1284, 1.5144> <3.5204, 19.1626, 1.5144>
		<2.3163, 19.1626, 1.5613> <2.3505, 19.1284, 1.5613> <3.4862, 19.1284, 1.5613> <3.5204, 19.1626, 1.5613>
		<2.3879, 19.2341, 1.6066> <2.4188, 19.2032, 1.6066> <3.4178, 19.2032, 1.6066> <3.4488, 19.2341, 1.6066>
		<2.3731, 19.2193, 1.6486> <2.4041, 19.1884, 1.6486> <3.4326, 19.1884, 1.6486> <3.4636, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5204, 19.1626, 1.5144> <3.5545, 19.1968, 1.5144> <3.5545, 20.3324, 1.5144> <3.5204, 20.3666, 1.5144>
		<3.5204, 19.1626, 1.5613> <3.5545, 19.1968, 1.5613> <3.5545, 20.3324, 1.5613> <3.5204, 20.3666, 1.5613>
		<3.4488, 19.2341, 1.6066> <3.4798, 19.2651, 1.6066> <3.4798, 20.2641, 1.6066> <3.4488, 20.2950, 1.6066>
		<3.4636, 19.2193, 1.6486> <3.4946, 19.2503, 1.6486> <3.4946, 20.2789, 1.6486> <3.4636, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5204, 20.3666, 1.5144> <3.4862, 20.4008, 1.5144> <2.3505, 20.4008, 1.5144> <2.3163, 20.3666, 1.5144>
		<3.5204, 20.3666, 1.5613> <3.4862, 20.4008, 1.5613> <2.3505, 20.4008, 1.5613> <2.3163, 20.3666, 1.5613>
		<3.4488, 20.2950, 1.6066> <3.4178, 20.3260, 1.6066> <2.4188, 20.3260, 1.6066> <2.3879, 20.2950, 1.6066>
		<3.4636, 20.3098, 1.6486> <3.4326, 20.3408, 1.6486> <2.4041, 20.3408, 1.6486> <2.3731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3731, 19.2193, 1.6486> <2.3246, 19.1709, 1.7862> <2.1828, 19.0290, 1.8960> <2.1336, 18.9799, 2.0332>
		<2.3421, 19.2503, 1.6486> <2.2937, 19.2018, 1.7862> <2.1382, 19.0736, 1.8960> <2.0891, 19.0245, 2.0332>
		<2.3421, 20.2789, 1.6486> <2.2937, 20.3273, 1.7862> <2.1382, 20.4556, 1.8960> <2.0891, 20.5047, 2.0332>
		<2.3731, 20.3098, 1.6486> <2.3246, 20.3583, 1.7862> <2.1828, 20.5002, 1.8960> <2.1336, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3731, 19.2193, 1.6486> <2.4041, 19.1884, 1.6486> <3.4326, 19.1884, 1.6486> <3.4636, 19.2193, 1.6486>
		<2.3246, 19.1709, 1.7862> <2.3556, 19.1399, 1.7862> <3.4811, 19.1399, 1.7862> <3.5120, 19.1709, 1.7862>
		<2.1828, 19.0290, 1.8960> <2.2273, 18.9844, 1.8960> <3.6093, 18.9844, 1.8960> <3.6539, 19.0290, 1.8960>
		<2.1336, 18.9799, 2.0332> <2.1782, 18.9353, 2.0332> <3.6585, 18.9353, 2.0332> <3.7030, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4636, 19.2193, 1.6486> <3.4946, 19.2503, 1.6486> <3.4946, 20.2789, 1.6486> <3.4636, 20.3098, 1.6486>
		<3.5120, 19.1709, 1.7862> <3.5430, 19.2018, 1.7862> <3.5430, 20.3273, 1.7862> <3.5120, 20.3583, 1.7862>
		<3.6539, 19.0290, 1.8960> <3.6985, 19.0736, 1.8960> <3.6985, 20.4556, 1.8960> <3.6539, 20.5002, 1.8960>
		<3.7030, 18.9799, 2.0332> <3.7476, 19.0245, 2.0332> <3.7476, 20.5047, 2.0332> <3.7030, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4636, 20.3098, 1.6486> <3.4326, 20.3408, 1.6486> <2.4041, 20.3408, 1.6486> <2.3731, 20.3098, 1.6486>
		<3.5120, 20.3583, 1.7862> <3.4811, 20.3893, 1.7862> <2.3556, 20.3893, 1.7862> <2.3246, 20.3583, 1.7862>
		<3.6539, 20.5002, 1.8960> <3.6093, 20.5447, 1.8960> <2.2273, 20.5447, 1.8960> <2.1828, 20.5002, 1.8960>
		<3.7030, 20.5493, 2.0332> <3.6585, 20.5939, 2.0332> <2.1782, 20.5939, 2.0332> <2.1336, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 2.0332> <2.1070, 18.9533, 2.1074> <2.1068, 18.9531, 2.2382> <2.1359, 18.9822, 2.3104>
		<2.0891, 19.0245, 2.0332> <2.0625, 18.9979, 2.1074> <2.0624, 18.9975, 2.2382> <2.0915, 19.0266, 2.3104>
		<2.0891, 20.5047, 2.0332> <2.0625, 20.5313, 2.1074> <2.0624, 20.5317, 2.2382> <2.0915, 20.5025, 2.3104>
		<2.1336, 20.5493, 2.0332> <2.1070, 20.5759, 2.1074> <2.1068, 20.5761, 2.2382> <2.1359, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1336, 18.9799, 2.0332> <2.1782, 18.9353, 2.0332> <3.6585, 18.9353, 2.0332> <3.7030, 18.9799, 2.0332>
		<2.1070, 18.9533, 2.1074> <2.1516, 18.9087, 2.1074> <3.6851, 18.9087, 2.1074> <3.7296, 18.9533, 2.1074>
		<2.1068, 18.9531, 2.2382> <2.1512, 18.9086, 2.2382> <3.6854, 18.9086, 2.2382> <3.7299, 18.9531, 2.2382>
		<2.1359, 18.9822, 2.3104> <2.1804, 18.9378, 2.3104> <3.6563, 18.9378, 2.3104> <3.7007, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 18.9799, 2.0332> <3.7476, 19.0245, 2.0332> <3.7476, 20.5047, 2.0332> <3.7030, 20.5493, 2.0332>
		<3.7296, 18.9533, 2.1074> <3.7742, 18.9979, 2.1074> <3.7742, 20.5313, 2.1074> <3.7296, 20.5759, 2.1074>
		<3.7299, 18.9531, 2.2382> <3.7743, 18.9975, 2.2382> <3.7743, 20.5317, 2.2382> <3.7299, 20.5761, 2.2382>
		<3.7007, 18.9822, 2.3104> <3.7452, 19.0266, 2.3104> <3.7452, 20.5025, 2.3104> <3.7007, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7030, 20.5493, 2.0332> <3.6585, 20.5939, 2.0332> <2.1782, 20.5939, 2.0332> <2.1336, 20.5493, 2.0332>
		<3.7296, 20.5759, 2.1074> <3.6851, 20.6204, 2.1074> <2.1516, 20.6204, 2.1074> <2.1070, 20.5759, 2.1074>
		<3.7299, 20.5761, 2.2382> <3.6854, 20.6206, 2.2382> <2.1512, 20.6206, 2.2382> <2.1068, 20.5761, 2.2382>
		<3.7007, 20.5470, 2.3104> <3.6563, 20.5914, 2.3104> <2.1804, 20.5914, 2.3104> <2.1359, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1359, 18.9822, 2.3104> <2.2199, 19.0661, 2.5186> <2.4157, 19.2620, 2.7154> <2.4944, 19.3406, 2.9276>
		<2.0915, 19.0266, 2.3104> <2.1754, 19.1106, 2.5186> <2.3916, 19.2860, 2.7154> <2.4703, 19.3647, 2.9276>
		<2.0915, 20.5025, 2.3104> <2.1754, 20.4186, 2.5186> <2.3916, 20.2431, 2.7154> <2.4703, 20.1645, 2.9276>
		<2.1359, 20.5470, 2.3104> <2.2199, 20.4630, 2.5186> <2.4157, 20.2672, 2.7154> <2.4944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1359, 18.9822, 2.3104> <2.1804, 18.9378, 2.3104> <3.6563, 18.9378, 2.3104> <3.7007, 18.9822, 2.3104>
		<2.2199, 19.0661, 2.5186> <2.2643, 19.0217, 2.5186> <3.5723, 19.0217, 2.5186> <3.6168, 19.0661, 2.5186>
		<2.4157, 19.2620, 2.7154> <2.4398, 19.2379, 2.7154> <3.3969, 19.2379, 2.7154> <3.4210, 19.2620, 2.7154>
		<2.4944, 19.3406, 2.9276> <2.5185, 19.3165, 2.9276> <3.3182, 19.3165, 2.9276> <3.3423, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7007, 18.9822, 2.3104> <3.7452, 19.0266, 2.3104> <3.7452, 20.5025, 2.3104> <3.7007, 20.5470, 2.3104>
		<3.6168, 19.0661, 2.5186> <3.6612, 19.1106, 2.5186> <3.6612, 20.4186, 2.5186> <3.6168, 20.4630, 2.5186>
		<3.4210, 19.2620, 2.7154> <3.4450, 19.2860, 2.7154> <3.4450, 20.2431, 2.7154> <3.4210, 20.2672, 2.7154>
		<3.3423, 19.3406, 2.9276> <3.3664, 19.3647, 2.9276> <3.3664, 20.1645, 2.9276> <3.3423, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7007, 20.5470, 2.3104> <3.6563, 20.5914, 2.3104> <2.1804, 20.5914, 2.3104> <2.1359, 20.5470, 2.3104>
		<3.6168, 20.4630, 2.5186> <3.5723, 20.5075, 2.5186> <2.2643, 20.5075, 2.5186> <2.2199, 20.4630, 2.5186>
		<3.4210, 20.2672, 2.7154> <3.3969, 20.2913, 2.7154> <2.4398, 20.2913, 2.7154> <2.4157, 20.2672, 2.7154>
		<3.3423, 20.1885, 2.9276> <3.3182, 20.2126, 2.9276> <2.5185, 20.2126, 2.9276> <2.4944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4944, 19.3406, 2.9276> <2.5113, 19.3576, 2.9732> <2.4111, 19.2574, 3.0012> <2.4111, 19.2574, 3.0528>
		<2.4703, 19.3647, 2.9276> <2.4872, 19.3816, 2.9732> <2.3823, 19.2862, 3.0012> <2.3823, 19.2862, 3.0528>
		<2.4703, 20.1645, 2.9276> <2.4872, 20.1475, 2.9732> <2.3823, 20.2430, 3.0012> <2.3823, 20.2430, 3.0528>
		<2.4944, 20.1885, 2.9276> <2.5113, 20.1716, 2.9732> <2.4111, 20.2718, 3.0012> <2.4111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4944, 19.3406, 2.9276> <2.5185, 19.3165, 2.9276> <3.3182, 19.3165, 2.9276> <3.3423, 19.3406, 2.9276>
		<2.5113, 19.3576, 2.9732> <2.5354, 19.3335, 2.9732> <3.3013, 19.3335, 2.9732> <3.3254, 19.3576, 2.9732>
		<2.4111, 19.2574, 3.0012> <2.4399, 19.2286, 3.0012> <3.3967, 19.2286, 3.0012> <3.4255, 19.2574, 3.0012>
		<2.4111, 19.2574, 3.0528> <2.4399, 19.2286, 3.0528> <3.3967, 19.2286, 3.0528> <3.4255, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3423, 19.3406, 2.9276> <3.3664, 19.3647, 2.9276> <3.3664, 20.1645, 2.9276> <3.3423, 20.1885, 2.9276>
		<3.3254, 19.3576, 2.9732> <3.3494, 19.3816, 2.9732> <3.3494, 20.1475, 2.9732> <3.3254, 20.1716, 2.9732>
		<3.4255, 19.2574, 3.0012> <3.4544, 19.2862, 3.0012> <3.4544, 20.2430, 3.0012> <3.4255, 20.2718, 3.0012>
		<3.4255, 19.2574, 3.0528> <3.4544, 19.2862, 3.0528> <3.4544, 20.2430, 3.0528> <3.4255, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3423, 20.1885, 2.9276> <3.3182, 20.2126, 2.9276> <2.5185, 20.2126, 2.9276> <2.4944, 20.1885, 2.9276>
		<3.3254, 20.1716, 2.9732> <3.3013, 20.1957, 2.9732> <2.5354, 20.1957, 2.9732> <2.5113, 20.1716, 2.9732>
		<3.4255, 20.2718, 3.0012> <3.3967, 20.3006, 3.0012> <2.4399, 20.3006, 3.0012> <2.4111, 20.2718, 3.0012>
		<3.4255, 20.2718, 3.0528> <3.3967, 20.3006, 3.0528> <2.4399, 20.3006, 3.0528> <2.4111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4111, 19.2574, 3.0528> <2.4111, 19.2574, 3.1044> <2.5138, 19.3600, 3.1344> <2.4944, 19.3406, 3.1780>
		<2.3823, 19.2862, 3.0528> <2.3823, 19.2862, 3.1044> <2.4897, 19.3841, 3.1344> <2.4703, 19.3647, 3.1780>
		<2.3823, 20.2430, 3.0528> <2.3823, 20.2430, 3.1044> <2.4897, 20.1451, 3.1344> <2.4703, 20.1645, 3.1780>
		<2.4111, 20.2718, 3.0528> <2.4111, 20.2718, 3.1044> <2.5138, 20.1691, 3.1344> <2.4944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4111, 19.2574, 3.0528> <2.4399, 19.2286, 3.0528> <3.3967, 19.2286, 3.0528> <3.4255, 19.2574, 3.0528>
		<2.4111, 19.2574, 3.1044> <2.4399, 19.2286, 3.1044> <3.3967, 19.2286, 3.1044> <3.4255, 19.2574, 3.1044>
		<2.5138, 19.3600, 3.1344> <2.5379, 19.3359, 3.1344> <3.2988, 19.3359, 3.1344> <3.3229, 19.3600, 3.1344>
		<2.4944, 19.3406, 3.1780> <2.5185, 19.3165, 3.1780> <3.3182, 19.3165, 3.1780> <3.3423, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4255, 19.2574, 3.0528> <3.4544, 19.2862, 3.0528> <3.4544, 20.2430, 3.0528> <3.4255, 20.2718, 3.0528>
		<3.4255, 19.2574, 3.1044> <3.4544, 19.2862, 3.1044> <3.4544, 20.2430, 3.1044> <3.4255, 20.2718, 3.1044>
		<3.3229, 19.3600, 3.1344> <3.3470, 19.3841, 3.1344> <3.3470, 20.1451, 3.1344> <3.3229, 20.1691, 3.1344>
		<3.3423, 19.3406, 3.1780> <3.3664, 19.3647, 3.1780> <3.3664, 20.1645, 3.1780> <3.3423, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4255, 20.2718, 3.0528> <3.3967, 20.3006, 3.0528> <2.4399, 20.3006, 3.0528> <2.4111, 20.2718, 3.0528>
		<3.4255, 20.2718, 3.1044> <3.3967, 20.3006, 3.1044> <2.4399, 20.3006, 3.1044> <2.4111, 20.2718, 3.1044>
		<3.3229, 20.1691, 3.1344> <3.2988, 20.1932, 3.1344> <2.5379, 20.1932, 3.1344> <2.5138, 20.1691, 3.1344>
		<3.3423, 20.1885, 3.1780> <3.3182, 20.2126, 3.1780> <2.5185, 20.2126, 3.1780> <2.4944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4944, 19.3406, 3.1780> <2.4562, 19.3024, 3.2640> <2.3390, 19.1852, 3.2738> <2.2839, 19.1302, 3.3390>
		<2.4703, 19.3647, 3.1780> <2.4321, 19.3265, 3.2640> <2.3029, 19.2212, 3.2738> <2.2479, 19.1662, 3.3390>
		<2.4703, 20.1645, 3.1780> <2.4321, 20.2027, 3.2640> <2.3029, 20.3079, 3.2738> <2.2479, 20.3629, 3.3390>
		<2.4944, 20.1885, 3.1780> <2.4562, 20.2267, 3.2640> <2.3390, 20.3440, 3.2738> <2.2839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4944, 19.3406, 3.1780> <2.5185, 19.3165, 3.1780> <3.3182, 19.3165, 3.1780> <3.3423, 19.3406, 3.1780>
		<2.4562, 19.3024, 3.2640> <2.4803, 19.2784, 3.2640> <3.3564, 19.2784, 3.2640> <3.3805, 19.3024, 3.2640>
		<2.3390, 19.1852, 3.2738> <2.3750, 19.1492, 3.2738> <3.4617, 19.1492, 3.2738> <3.4977, 19.1852, 3.2738>
		<2.2839, 19.1302, 3.3390> <2.3200, 19.0942, 3.3390> <3.5167, 19.0942, 3.3390> <3.5527, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3423, 19.3406, 3.1780> <3.3664, 19.3647, 3.1780> <3.3664, 20.1645, 3.1780> <3.3423, 20.1885, 3.1780>
		<3.3805, 19.3024, 3.2640> <3.4046, 19.3265, 3.2640> <3.4046, 20.2027, 3.2640> <3.3805, 20.2267, 3.2640>
		<3.4977, 19.1852, 3.2738> <3.5337, 19.2212, 3.2738> <3.5337, 20.3079, 3.2738> <3.4977, 20.3440, 3.2738>
		<3.5527, 19.1302, 3.3390> <3.5888, 19.1662, 3.3390> <3.5888, 20.3629, 3.3390> <3.5527, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3423, 20.1885, 3.1780> <3.3182, 20.2126, 3.1780> <2.5185, 20.2126, 3.1780> <2.4944, 20.1885, 3.1780>
		<3.3805, 20.2267, 3.2640> <3.3564, 20.2508, 3.2640> <2.4803, 20.2508, 3.2640> <2.4562, 20.2267, 3.2640>
		<3.4977, 20.3440, 3.2738> <3.4617, 20.3800, 3.2738> <2.3750, 20.3800, 3.2738> <2.3390, 20.3440, 3.2738>
		<3.5527, 20.3990, 3.3390> <3.5167, 20.4350, 3.3390> <2.3200, 20.4350, 3.3390> <2.2839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2839, 19.1302, 3.3390> <2.2584, 19.1046, 3.3693> <2.2203, 19.0665, 3.4419> <2.2377, 19.0839, 3.4821>
		<2.2479, 19.1662, 3.3390> <2.2223, 19.1406, 3.3693> <2.1816, 19.1052, 3.4419> <2.1990, 19.1226, 3.4821>
		<2.2479, 20.3629, 3.3390> <2.2223, 20.3885, 3.3693> <2.1816, 20.4240, 3.4419> <2.1990, 20.4066, 3.4821>
		<2.2839, 20.3990, 3.3390> <2.2584, 20.4246, 3.3693> <2.2203, 20.4627, 3.4419> <2.2377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2839, 19.1302, 3.3390> <2.3200, 19.0942, 3.3390> <3.5167, 19.0942, 3.3390> <3.5527, 19.1302, 3.3390>
		<2.2584, 19.1046, 3.3693> <2.2944, 19.0686, 3.3693> <3.5423, 19.0686, 3.3693> <3.5783, 19.1046, 3.3693>
		<2.2203, 19.0665, 3.4419> <2.2589, 19.0279, 3.4419> <3.5777, 19.0279, 3.4419> <3.6164, 19.0665, 3.4419>
		<2.2377, 19.0839, 3.4821> <2.2764, 19.0453, 3.4821> <3.5603, 19.0453, 3.4821> <3.5990, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5527, 19.1302, 3.3390> <3.5888, 19.1662, 3.3390> <3.5888, 20.3629, 3.3390> <3.5527, 20.3990, 3.3390>
		<3.5783, 19.1046, 3.3693> <3.6143, 19.1406, 3.3693> <3.6143, 20.3885, 3.3693> <3.5783, 20.4246, 3.3693>
		<3.6164, 19.0665, 3.4419> <3.6551, 19.1052, 3.4419> <3.6551, 20.4240, 3.4419> <3.6164, 20.4627, 3.4419>
		<3.5990, 19.0839, 3.4821> <3.6376, 19.1226, 3.4821> <3.6376, 20.4066, 3.4821> <3.5990, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5527, 20.3990, 3.3390> <3.5167, 20.4350, 3.3390> <2.3200, 20.4350, 3.3390> <2.2839, 20.3990, 3.3390>
		<3.5783, 20.4246, 3.3693> <3.5423, 20.4606, 3.3693> <2.2944, 20.4606, 3.3693> <2.2584, 20.4246, 3.3693>
		<3.6164, 20.4627, 3.4419> <3.5777, 20.5013, 3.4419> <2.2589, 20.5013, 3.4419> <2.2203, 20.4627, 3.4419>
		<3.5990, 20.4452, 3.4821> <3.5603, 20.4839, 3.4821> <2.2764, 20.4839, 3.4821> <2.2377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2377, 19.0839, 3.4821> <2.2837, 19.1300, 3.5884> <2.4039, 19.2502, 3.6567> <2.4620, 19.3083, 3.7504>
		<2.1990, 19.1226, 3.4821> <2.2450, 19.1686, 3.5884> <2.3780, 19.2761, 3.6567> <2.4361, 19.3342, 3.7504>
		<2.1990, 20.4066, 3.4821> <2.2450, 20.3606, 3.5884> <2.3780, 20.2531, 3.6567> <2.4361, 20.1950, 3.7504>
		<2.2377, 20.4452, 3.4821> <2.2837, 20.3992, 3.5884> <2.4039, 20.2790, 3.6567> <2.4620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2377, 19.0839, 3.4821> <2.2764, 19.0453, 3.4821> <3.5603, 19.0453, 3.4821> <3.5990, 19.0839, 3.4821>
		<2.2837, 19.1300, 3.5884> <2.3224, 19.0913, 3.5884> <3.5143, 19.0913, 3.5884> <3.5530, 19.1300, 3.5884>
		<2.4039, 19.2502, 3.6567> <2.4298, 19.2242, 3.6567> <3.4068, 19.2242, 3.6567> <3.4328, 19.2502, 3.6567>
		<2.4620, 19.3083, 3.7504> <2.4879, 19.2823, 3.7504> <3.3487, 19.2823, 3.7504> <3.3747, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5990, 19.0839, 3.4821> <3.6376, 19.1226, 3.4821> <3.6376, 20.4066, 3.4821> <3.5990, 20.4452, 3.4821>
		<3.5530, 19.1300, 3.5884> <3.5916, 19.1686, 3.5884> <3.5916, 20.3606, 3.5884> <3.5530, 20.3992, 3.5884>
		<3.4328, 19.2502, 3.6567> <3.4587, 19.2761, 3.6567> <3.4587, 20.2531, 3.6567> <3.4328, 20.2790, 3.6567>
		<3.3747, 19.3083, 3.7504> <3.4006, 19.3342, 3.7504> <3.4006, 20.1950, 3.7504> <3.3747, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5990, 20.4452, 3.4821> <3.5603, 20.4839, 3.4821> <2.2764, 20.4839, 3.4821> <2.2377, 20.4452, 3.4821>
		<3.5530, 20.3992, 3.5884> <3.5143, 20.4379, 3.5884> <2.3224, 20.4379, 3.5884> <2.2837, 20.3992, 3.5884>
		<3.4328, 20.2790, 3.6567> <3.4068, 20.3049, 3.6567> <2.4298, 20.3049, 3.6567> <2.4039, 20.2790, 3.6567>
		<3.3747, 20.2209, 3.7504> <3.3487, 20.2468, 3.7504> <2.4879, 20.2468, 3.7504> <2.4620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4620, 19.3083, 3.7504> <2.5036, 19.3498, 3.8175> <2.5473, 19.3935, 3.9241> <2.5648, 19.4110, 4.0098>
		<2.4361, 19.3342, 3.7504> <2.4777, 19.3757, 3.8175> <2.5272, 19.4136, 3.9241> <2.5447, 19.4311, 4.0098>
		<2.4361, 20.1950, 3.7504> <2.4777, 20.1534, 3.8175> <2.5272, 20.1156, 3.9241> <2.5447, 20.0981, 4.0098>
		<2.4620, 20.2209, 3.7504> <2.5036, 20.1793, 3.8175> <2.5473, 20.1356, 3.9241> <2.5648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4620, 19.3083, 3.7504> <2.4879, 19.2823, 3.7504> <3.3487, 19.2823, 3.7504> <3.3747, 19.3083, 3.7504>
		<2.5036, 19.3498, 3.8175> <2.5295, 19.3239, 3.8175> <3.3072, 19.3239, 3.8175> <3.3331, 19.3498, 3.8175>
		<2.5473, 19.3935, 3.9241> <2.5674, 19.3734, 3.9241> <3.2693, 19.3734, 3.9241> <3.2894, 19.3935, 3.9241>
		<2.5648, 19.4110, 4.0098> <2.5848, 19.3909, 4.0098> <3.2518, 19.3909, 4.0098> <3.2719, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3747, 19.3083, 3.7504> <3.4006, 19.3342, 3.7504> <3.4006, 20.1950, 3.7504> <3.3747, 20.2209, 3.7504>
		<3.3331, 19.3498, 3.8175> <3.3590, 19.3757, 3.8175> <3.3590, 20.1534, 3.8175> <3.3331, 20.1793, 3.8175>
		<3.2894, 19.3935, 3.9241> <3.3095, 19.4136, 3.9241> <3.3095, 20.1156, 3.9241> <3.2894, 20.1356, 3.9241>
		<3.2719, 19.4110, 4.0098> <3.2920, 19.4311, 4.0098> <3.2920, 20.0981, 4.0098> <3.2719, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3747, 20.2209, 3.7504> <3.3487, 20.2468, 3.7504> <2.4879, 20.2468, 3.7504> <2.4620, 20.2209, 3.7504>
		<3.3331, 20.1793, 3.8175> <3.3072, 20.2053, 3.8175> <2.5295, 20.2053, 3.8175> <2.5036, 20.1793, 3.8175>
		<3.2894, 20.1356, 3.9241> <3.2693, 20.1557, 3.9241> <2.5674, 20.1557, 3.9241> <2.5473, 20.1356, 3.9241>
		<3.2719, 20.1182, 4.0098> <3.2518, 20.1383, 4.0098> <2.5848, 20.1383, 4.0098> <2.5648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5648, 19.4110, 4.0098> <2.5832, 19.4294, 4.1002> <2.5779, 19.4242, 4.2288> <2.5787, 19.4250, 4.3229>
		<2.5447, 19.4311, 4.0098> <2.5631, 19.4495, 4.1002> <2.5587, 19.4435, 4.2288> <2.5595, 19.4443, 4.3229>
		<2.5447, 20.0981, 4.0098> <2.5631, 20.0797, 4.1002> <2.5587, 20.0857, 4.2288> <2.5595, 20.0849, 4.3229>
		<2.5648, 20.1182, 4.0098> <2.5832, 20.0997, 4.1002> <2.5779, 20.1050, 4.2288> <2.5787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5648, 19.4110, 4.0098> <2.5848, 19.3909, 4.0098> <3.2518, 19.3909, 4.0098> <3.2719, 19.4110, 4.0098>
		<2.5832, 19.4294, 4.1002> <2.6033, 19.4094, 4.1002> <3.2334, 19.4094, 4.1002> <3.2535, 19.4294, 4.1002>
		<2.5779, 19.4242, 4.2288> <2.5972, 19.4049, 4.2288> <3.2394, 19.4049, 4.2288> <3.2587, 19.4242, 4.2288>
		<2.5787, 19.4250, 4.3229> <2.5980, 19.4057, 4.3229> <3.2386, 19.4057, 4.3229> <3.2579, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2719, 19.4110, 4.0098> <3.2920, 19.4311, 4.0098> <3.2920, 20.0981, 4.0098> <3.2719, 20.1182, 4.0098>
		<3.2535, 19.4294, 4.1002> <3.2736, 19.4495, 4.1002> <3.2736, 20.0797, 4.1002> <3.2535, 20.0997, 4.1002>
		<3.2587, 19.4242, 4.2288> <3.2780, 19.4435, 4.2288> <3.2780, 20.0857, 4.2288> <3.2587, 20.1050, 4.2288>
		<3.2579, 19.4250, 4.3229> <3.2772, 19.4443, 4.3229> <3.2772, 20.0849, 4.3229> <3.2579, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2719, 20.1182, 4.0098> <3.2518, 20.1383, 4.0098> <2.5848, 20.1383, 4.0098> <2.5648, 20.1182, 4.0098>
		<3.2535, 20.0997, 4.1002> <3.2334, 20.1198, 4.1002> <2.6033, 20.1198, 4.1002> <2.5832, 20.0997, 4.1002>
		<3.2587, 20.1050, 4.2288> <3.2394, 20.1243, 4.2288> <2.5972, 20.1243, 4.2288> <2.5779, 20.1050, 4.2288>
		<3.2579, 20.1042, 4.3229> <3.2386, 20.1235, 4.3229> <2.5980, 20.1235, 4.3229> <2.5787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5787, 19.4250, 4.3229> <2.5821, 19.4284, 4.7283> <2.5803, 19.4265, 5.2689> <2.5787, 19.4250, 5.6744>
		<2.5595, 19.4443, 4.3229> <2.5629, 19.4477, 4.7283> <2.5610, 19.4458, 5.2689> <2.5595, 19.4443, 5.6744>
		<2.5595, 20.0849, 4.3229> <2.5629, 20.0815, 4.7283> <2.5610, 20.0834, 5.2689> <2.5595, 20.0849, 5.6744>
		<2.5787, 20.1042, 4.3229> <2.5821, 20.1008, 4.7283> <2.5803, 20.1027, 5.2689> <2.5787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5787, 19.4250, 4.3229> <2.5980, 19.4057, 4.3229> <3.2386, 19.4057, 4.3229> <3.2579, 19.4250, 4.3229>
		<2.5821, 19.4284, 4.7283> <2.6014, 19.4091, 4.7283> <3.2352, 19.4091, 4.7283> <3.2545, 19.4284, 4.7283>
		<2.5803, 19.4265, 5.2689> <2.5996, 19.4072, 5.2689> <3.2371, 19.4072, 5.2689> <3.2564, 19.4265, 5.2689>
		<2.5787, 19.4250, 5.6744> <2.5980, 19.4057, 5.6744> <3.2386, 19.4057, 5.6744> <3.2579, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2579, 19.4250, 4.3229> <3.2772, 19.4443, 4.3229> <3.2772, 20.0849, 4.3229> <3.2579, 20.1042, 4.3229>
		<3.2545, 19.4284, 4.7283> <3.2738, 19.4477, 4.7283> <3.2738, 20.0815, 4.7283> <3.2545, 20.1008, 4.7283>
		<3.2564, 19.4265, 5.2689> <3.2757, 19.4458, 5.2689> <3.2757, 20.0834, 5.2689> <3.2564, 20.1027, 5.2689>
		<3.2579, 19.4250, 5.6744> <3.2772, 19.4443, 5.6744> <3.2772, 20.0849, 5.6744> <3.2579, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2579, 20.1042, 4.3229> <3.2386, 20.1235, 4.3229> <2.5980, 20.1235, 4.3229> <2.5787, 20.1042, 4.3229>
		<3.2545, 20.1008, 4.7283> <3.2352, 20.1201, 4.7283> <2.6014, 20.1201, 4.7283> <2.5821, 20.1008, 4.7283>
		<3.2564, 20.1027, 5.2689> <3.2371, 20.1220, 5.2689> <2.5996, 20.1220, 5.2689> <2.5803, 20.1027, 5.2689>
		<3.2579, 20.1042, 5.6744> <3.2386, 20.1235, 5.6744> <2.5980, 20.1235, 5.6744> <2.5787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5787, 19.4250, 5.6744> <2.5775, 19.4237, 6.0073> <2.5828, 19.4290, 6.4517> <2.5695, 19.4157, 6.7841>
		<2.5595, 19.4443, 5.6744> <2.5582, 19.4430, 6.0073> <2.5629, 19.4488, 6.4517> <2.5497, 19.4355, 6.7841>
		<2.5595, 20.0849, 5.6744> <2.5582, 20.0861, 6.0073> <2.5629, 20.0804, 6.4517> <2.5497, 20.0936, 6.7841>
		<2.5787, 20.1042, 5.6744> <2.5775, 20.1054, 6.0073> <2.5828, 20.1002, 6.4517> <2.5695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5787, 19.4250, 5.6744> <2.5980, 19.4057, 5.6744> <3.2386, 19.4057, 5.6744> <3.2579, 19.4250, 5.6744>
		<2.5775, 19.4237, 6.0073> <2.5968, 19.4044, 6.0073> <3.2399, 19.4044, 6.0073> <3.2592, 19.4237, 6.0073>
		<2.5828, 19.4290, 6.4517> <2.6026, 19.4092, 6.4517> <3.2341, 19.4092, 6.4517> <3.2539, 19.4290, 6.4517>
		<2.5695, 19.4157, 6.7841> <2.5893, 19.3959, 6.7841> <3.2474, 19.3959, 6.7841> <3.2672, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2579, 19.4250, 5.6744> <3.2772, 19.4443, 5.6744> <3.2772, 20.0849, 5.6744> <3.2579, 20.1042, 5.6744>
		<3.2592, 19.4237, 6.0073> <3.2785, 19.4430, 6.0073> <3.2785, 20.0861, 6.0073> <3.2592, 20.1054, 6.0073>
		<3.2539, 19.4290, 6.4517> <3.2737, 19.4488, 6.4517> <3.2737, 20.0804, 6.4517> <3.2539, 20.1002, 6.4517>
		<3.2672, 19.4157, 6.7841> <3.2870, 19.4355, 6.7841> <3.2870, 20.0936, 6.7841> <3.2672, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2579, 20.1042, 5.6744> <3.2386, 20.1235, 5.6744> <2.5980, 20.1235, 5.6744> <2.5787, 20.1042, 5.6744>
		<3.2592, 20.1054, 6.0073> <3.2399, 20.1247, 6.0073> <2.5968, 20.1247, 6.0073> <2.5775, 20.1054, 6.0073>
		<3.2539, 20.1002, 6.4517> <3.2341, 20.1200, 6.4517> <2.6026, 20.1200, 6.4517> <2.5828, 20.1002, 6.4517>
		<3.2672, 20.1134, 6.7841> <3.2474, 20.1333, 6.7841> <2.5893, 20.1333, 6.7841> <2.5695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5695, 19.4157, 6.7841> <2.5675, 19.4137, 6.8341> <2.5551, 19.4013, 6.9079> <2.5282, 19.3745, 6.9405>
		<2.5497, 19.4355, 6.7841> <2.5477, 19.4336, 6.8341> <2.5329, 19.4235, 6.9079> <2.5060, 19.3966, 6.9405>
		<2.5497, 20.0936, 6.7841> <2.5477, 20.0956, 6.8341> <2.5329, 20.1057, 6.9079> <2.5060, 20.1326, 6.9405>
		<2.5695, 20.1134, 6.7841> <2.5675, 20.1154, 6.8341> <2.5551, 20.1278, 6.9079> <2.5282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5695, 19.4157, 6.7841> <2.5893, 19.3959, 6.7841> <3.2474, 19.3959, 6.7841> <3.2672, 19.4157, 6.7841>
		<2.5675, 19.4137, 6.8341> <2.5873, 19.3939, 6.8341> <3.2494, 19.3939, 6.8341> <3.2692, 19.4137, 6.8341>
		<2.5551, 19.4013, 6.9079> <2.5772, 19.3792, 6.9079> <3.2594, 19.3792, 6.9079> <3.2816, 19.4013, 6.9079>
		<2.5282, 19.3745, 6.9405> <2.5504, 19.3523, 6.9405> <3.2863, 19.3523, 6.9405> <3.3085, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2672, 19.4157, 6.7841> <3.2870, 19.4355, 6.7841> <3.2870, 20.0936, 6.7841> <3.2672, 20.1134, 6.7841>
		<3.2692, 19.4137, 6.8341> <3.2890, 19.4336, 6.8341> <3.2890, 20.0956, 6.8341> <3.2692, 20.1154, 6.8341>
		<3.2816, 19.4013, 6.9079> <3.3038, 19.4235, 6.9079> <3.3038, 20.1057, 6.9079> <3.2816, 20.1278, 6.9079>
		<3.3085, 19.3745, 6.9405> <3.3306, 19.3966, 6.9405> <3.3306, 20.1326, 6.9405> <3.3085, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2672, 20.1134, 6.7841> <3.2474, 20.1333, 6.7841> <2.5893, 20.1333, 6.7841> <2.5695, 20.1134, 6.7841>
		<3.2692, 20.1154, 6.8341> <3.2494, 20.1352, 6.8341> <2.5873, 20.1352, 6.8341> <2.5675, 20.1154, 6.8341>
		<3.2816, 20.1278, 6.9079> <3.2594, 20.1500, 6.9079> <2.5772, 20.1500, 6.9079> <2.5551, 20.1278, 6.9079>
		<3.3085, 20.1547, 6.9405> <3.2863, 20.1769, 6.9405> <2.5504, 20.1769, 6.9405> <2.5282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5282, 19.3745, 6.9405> <2.4661, 19.3123, 7.0160> <2.3380, 19.1842, 7.0331> <2.2886, 19.1348, 7.1255>
		<2.5060, 19.3966, 6.9405> <2.4439, 19.3345, 7.0160> <2.3022, 19.2200, 7.0331> <2.2528, 19.1706, 7.1255>
		<2.5060, 20.1326, 6.9405> <2.4439, 20.1947, 7.0160> <2.3022, 20.3092, 7.0331> <2.2528, 20.3586, 7.1255>
		<2.5282, 20.1547, 6.9405> <2.4661, 20.2168, 7.0160> <2.3380, 20.3449, 7.0331> <2.2886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5282, 19.3745, 6.9405> <2.5504, 19.3523, 6.9405> <3.2863, 19.3523, 6.9405> <3.3085, 19.3745, 6.9405>
		<2.4661, 19.3123, 7.0160> <2.4883, 19.2902, 7.0160> <3.3484, 19.2902, 7.0160> <3.3706, 19.3123, 7.0160>
		<2.3380, 19.1842, 7.0331> <2.3738, 19.1485, 7.0331> <3.4629, 19.1485, 7.0331> <3.4987, 19.1842, 7.0331>
		<2.2886, 19.1348, 7.1255> <2.3243, 19.0990, 7.1255> <3.5123, 19.0990, 7.1255> <3.5481, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3085, 19.3745, 6.9405> <3.3306, 19.3966, 6.9405> <3.3306, 20.1326, 6.9405> <3.3085, 20.1547, 6.9405>
		<3.3706, 19.3123, 7.0160> <3.3927, 19.3345, 7.0160> <3.3927, 20.1947, 7.0160> <3.3706, 20.2168, 7.0160>
		<3.4987, 19.1842, 7.0331> <3.5345, 19.2200, 7.0331> <3.5345, 20.3092, 7.0331> <3.4987, 20.3449, 7.0331>
		<3.5481, 19.1348, 7.1255> <3.5839, 19.1706, 7.1255> <3.5839, 20.3586, 7.1255> <3.5481, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.3085, 20.1547, 6.9405> <3.2863, 20.1769, 6.9405> <2.5504, 20.1769, 6.9405> <2.5282, 20.1547, 6.9405>
		<3.3706, 20.2168, 7.0160> <3.3484, 20.2390, 7.0160> <2.4883, 20.2390, 7.0160> <2.4661, 20.2168, 7.0160>
		<3.4987, 20.3449, 7.0331> <3.4629, 20.3807, 7.0331> <2.3738, 20.3807, 7.0331> <2.3380, 20.3449, 7.0331>
		<3.5481, 20.3944, 7.1255> <3.5123, 20.4301, 7.1255> <2.3243, 20.4301, 7.1255> <2.2886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2886, 19.1348, 7.1255> <2.2681, 19.1143, 7.1638> <2.3684, 19.2146, 7.1912> <2.3684, 19.2146, 7.2393>
		<2.2528, 19.1706, 7.1255> <2.2323, 19.1501, 7.1638> <2.3371, 19.2459, 7.1912> <2.3371, 19.2459, 7.2393>
		<2.2528, 20.3586, 7.1255> <2.2323, 20.3791, 7.1638> <2.3371, 20.2833, 7.1912> <2.3371, 20.2833, 7.2393>
		<2.2886, 20.3944, 7.1255> <2.2681, 20.4149, 7.1638> <2.3684, 20.3146, 7.1912> <2.3684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2886, 19.1348, 7.1255> <2.3243, 19.0990, 7.1255> <3.5123, 19.0990, 7.1255> <3.5481, 19.1348, 7.1255>
		<2.2681, 19.1143, 7.1638> <2.3038, 19.0785, 7.1638> <3.5329, 19.0785, 7.1638> <3.5686, 19.1143, 7.1638>
		<2.3684, 19.2146, 7.1912> <2.3996, 19.1834, 7.1912> <3.4371, 19.1834, 7.1912> <3.4683, 19.2146, 7.1912>
		<2.3684, 19.2146, 7.2393> <2.3996, 19.1834, 7.2393> <3.4371, 19.1834, 7.2393> <3.4683, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5481, 19.1348, 7.1255> <3.5839, 19.1706, 7.1255> <3.5839, 20.3586, 7.1255> <3.5481, 20.3944, 7.1255>
		<3.5686, 19.1143, 7.1638> <3.6044, 19.1501, 7.1638> <3.6044, 20.3791, 7.1638> <3.5686, 20.4149, 7.1638>
		<3.4683, 19.2146, 7.1912> <3.4995, 19.2459, 7.1912> <3.4995, 20.2833, 7.1912> <3.4683, 20.3146, 7.1912>
		<3.4683, 19.2146, 7.2393> <3.4995, 19.2459, 7.2393> <3.4995, 20.2833, 7.2393> <3.4683, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5481, 20.3944, 7.1255> <3.5123, 20.4301, 7.1255> <2.3243, 20.4301, 7.1255> <2.2886, 20.3944, 7.1255>
		<3.5686, 20.4149, 7.1638> <3.5329, 20.4506, 7.1638> <2.3038, 20.4506, 7.1638> <2.2681, 20.4149, 7.1638>
		<3.4683, 20.3146, 7.1912> <3.4371, 20.3458, 7.1912> <2.3996, 20.3458, 7.1912> <2.3684, 20.3146, 7.1912>
		<3.4683, 20.3146, 7.2393> <3.4371, 20.3458, 7.2393> <2.3996, 20.3458, 7.2393> <2.3684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3684, 19.2146, 7.2393> <2.3684, 19.2146, 7.2905> <2.2946, 19.1408, 7.3169> <2.2886, 19.1348, 7.3673>
		<2.3371, 19.2459, 7.2393> <2.3371, 19.2459, 7.2905> <2.2588, 19.1766, 7.3169> <2.2528, 19.1706, 7.3673>
		<2.3371, 20.2833, 7.2393> <2.3371, 20.2833, 7.2905> <2.2588, 20.3526, 7.3169> <2.2528, 20.3586, 7.3673>
		<2.3684, 20.3146, 7.2393> <2.3684, 20.3146, 7.2905> <2.2946, 20.3883, 7.3169> <2.2886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.3684, 19.2146, 7.2393> <2.3996, 19.1834, 7.2393> <3.4371, 19.1834, 7.2393> <3.4683, 19.2146, 7.2393>
		<2.3684, 19.2146, 7.2905> <2.3996, 19.1834, 7.2905> <3.4371, 19.1834, 7.2905> <3.4683, 19.2146, 7.2905>
		<2.2946, 19.1408, 7.3169> <2.3304, 19.1051, 7.3169> <3.5063, 19.1051, 7.3169> <3.5421, 19.1408, 7.3169>
		<2.2886, 19.1348, 7.3673> <2.3243, 19.0990, 7.3673> <3.5123, 19.0990, 7.3673> <3.5481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4683, 19.2146, 7.2393> <3.4995, 19.2459, 7.2393> <3.4995, 20.2833, 7.2393> <3.4683, 20.3146, 7.2393>
		<3.4683, 19.2146, 7.2905> <3.4995, 19.2459, 7.2905> <3.4995, 20.2833, 7.2905> <3.4683, 20.3146, 7.2905>
		<3.5421, 19.1408, 7.3169> <3.5778, 19.1766, 7.3169> <3.5778, 20.3526, 7.3169> <3.5421, 20.3883, 7.3169>
		<3.5481, 19.1348, 7.3673> <3.5839, 19.1706, 7.3673> <3.5839, 20.3586, 7.3673> <3.5481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.4683, 20.3146, 7.2393> <3.4371, 20.3458, 7.2393> <2.3996, 20.3458, 7.2393> <2.3684, 20.3146, 7.2393>
		<3.4683, 20.3146, 7.2905> <3.4371, 20.3458, 7.2905> <2.3996, 20.3458, 7.2905> <2.3684, 20.3146, 7.2905>
		<3.5421, 20.3883, 7.3169> <3.5063, 20.4241, 7.3169> <2.3304, 20.4241, 7.3169> <2.2946, 20.3883, 7.3169>
		<3.5481, 20.3944, 7.3673> <3.5123, 20.4301, 7.3673> <2.3243, 20.4301, 7.3673> <2.2886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2886, 19.1348, 7.9080> <2.2528, 19.1706, 7.9080> <2.2528, 20.3586, 7.9080> <2.2886, 20.3944, 7.9080>
		<2.2886, 19.1348, 7.7458> <2.2528, 19.1706, 7.7458> <2.2528, 20.3586, 7.7458> <2.2886, 20.3944, 7.7458>
		<2.2695, 19.1157, 7.5273> <2.2337, 19.1515, 7.5273> <2.2337, 20.3777, 7.5273> <2.2695, 20.4134, 7.5273>
		<2.2886, 19.1348, 7.3673> <2.2528, 19.1706, 7.3673> <2.2528, 20.3586, 7.3673> <2.2886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2886, 19.1348, 7.9080> <2.2886, 19.1348, 7.7458> <2.2695, 19.1157, 7.5273> <2.2886, 19.1348, 7.3673>
		<2.3243, 19.0990, 7.9080> <2.3243, 19.0990, 7.7458> <2.3053, 19.0800, 7.5273> <2.3243, 19.0990, 7.3673>
		<3.5123, 19.0990, 7.9080> <3.5123, 19.0990, 7.7458> <3.5314, 19.0800, 7.5273> <3.5123, 19.0990, 7.3673>
		<3.5481, 19.1348, 7.9080> <3.5481, 19.1348, 7.7458> <3.5672, 19.1157, 7.5273> <3.5481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5481, 19.1348, 7.9080> <3.5481, 19.1348, 7.7458> <3.5672, 19.1157, 7.5273> <3.5481, 19.1348, 7.3673>
		<3.5839, 19.1706, 7.9080> <3.5839, 19.1706, 7.7458> <3.6030, 19.1515, 7.5273> <3.5839, 19.1706, 7.3673>
		<3.5839, 20.3586, 7.9080> <3.5839, 20.3586, 7.7458> <3.6030, 20.3777, 7.5273> <3.5839, 20.3586, 7.3673>
		<3.5481, 20.3944, 7.9080> <3.5481, 20.3944, 7.7458> <3.5672, 20.4134, 7.5273> <3.5481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.5481, 20.3944, 7.9080> <3.5481, 20.3944, 7.7458> <3.5672, 20.4134, 7.5273> <3.5481, 20.3944, 7.3673>
		<3.5123, 20.4301, 7.9080> <3.5123, 20.4301, 7.7458> <3.5314, 20.4492, 7.5273> <3.5123, 20.4301, 7.3673>
		<2.3243, 20.4301, 7.9080> <2.3243, 20.4301, 7.7458> <2.3053, 20.4492, 7.5273> <2.3243, 20.4301, 7.3673>
		<2.2886, 20.3944, 7.9080> <2.2886, 20.3944, 7.7458> <2.2695, 20.4134, 7.5273> <2.2886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0411, 18.8874, 0.7771> <1.9913, 18.9372, 0.7771> <1.9913, 20.5920, 0.7771> <2.0411, 20.6418, 0.7771>
		<2.0204, 18.8666, 0.6520> <1.9706, 18.9164, 0.6520> <1.9706, 20.6127, 0.6520> <2.0204, 20.6626, 0.6520>
		<2.0411, 18.8874, 0.4772> <1.9913, 18.9372, 0.4772> <1.9913, 20.5920, 0.4772> <2.0411, 20.6418, 0.4772>
		<2.0411, 18.8874, 0.3486> <1.9913, 18.9372, 0.3486> <1.9913, 20.5920, 0.3486> <2.0411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0411, 18.8874, 0.7771> <2.0204, 18.8666, 0.6520> <2.0411, 18.8874, 0.4772> <2.0411, 18.8874, 0.3486>
		<2.0910, 18.8376, 0.7771> <2.0702, 18.8168, 0.6520> <2.0910, 18.8376, 0.4772> <2.0910, 18.8376, 0.3486>
		<3.7457, 18.8376, 0.7771> <3.7665, 18.8168, 0.6520> <3.7457, 18.8376, 0.4772> <3.7457, 18.8376, 0.3486>
		<3.7955, 18.8874, 0.7771> <3.8163, 18.8666, 0.6520> <3.7955, 18.8874, 0.4772> <3.7955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7955, 18.8874, 0.7771> <3.8163, 18.8666, 0.6520> <3.7955, 18.8874, 0.4772> <3.7955, 18.8874, 0.3486>
		<3.8454, 18.9372, 0.7771> <3.8661, 18.9164, 0.6520> <3.8454, 18.9372, 0.4772> <3.8454, 18.9372, 0.3486>
		<3.8454, 20.5920, 0.7771> <3.8661, 20.6127, 0.6520> <3.8454, 20.5920, 0.4772> <3.8454, 20.5920, 0.3486>
		<3.7955, 20.6418, 0.7771> <3.8163, 20.6626, 0.6520> <3.7955, 20.6418, 0.4772> <3.7955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7955, 20.6418, 0.7771> <3.8163, 20.6626, 0.6520> <3.7955, 20.6418, 0.4772> <3.7955, 20.6418, 0.3486>
		<3.7457, 20.6916, 0.7771> <3.7665, 20.7124, 0.6520> <3.7457, 20.6916, 0.4772> <3.7457, 20.6916, 0.3486>
		<2.0910, 20.6916, 0.7771> <2.0702, 20.7124, 0.6520> <2.0910, 20.6916, 0.4772> <2.0910, 20.6916, 0.3486>
		<2.0411, 20.6418, 0.7771> <2.0204, 20.6626, 0.6520> <2.0411, 20.6418, 0.4772> <2.0411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0411, 18.8874, -0.0618> <2.0411, 18.8874, 0.0613> <2.0411, 18.8874, 0.2255> <2.0411, 18.8874, 0.3486>
		<1.9913, 18.9372, -0.0618> <1.9913, 18.9372, 0.0613> <1.9913, 18.9372, 0.2255> <1.9913, 18.9372, 0.3486>
		<1.9913, 20.5920, -0.0618> <1.9913, 20.5920, 0.0613> <1.9913, 20.5920, 0.2255> <1.9913, 20.5920, 0.3486>
		<2.0411, 20.6418, -0.0618> <2.0411, 20.6418, 0.0613> <2.0411, 20.6418, 0.2255> <2.0411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0411, 18.8874, -0.0618> <2.0910, 18.8376, -0.0618> <3.7457, 18.8376, -0.0618> <3.7955, 18.8874, -0.0618>
		<2.0411, 18.8874, 0.0613> <2.0910, 18.8376, 0.0613> <3.7457, 18.8376, 0.0613> <3.7955, 18.8874, 0.0613>
		<2.0411, 18.8874, 0.2255> <2.0910, 18.8376, 0.2255> <3.7457, 18.8376, 0.2255> <3.7955, 18.8874, 0.2255>
		<2.0411, 18.8874, 0.3486> <2.0910, 18.8376, 0.3486> <3.7457, 18.8376, 0.3486> <3.7955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7955, 18.8874, -0.0618> <3.8454, 18.9372, -0.0618> <3.8454, 20.5920, -0.0618> <3.7955, 20.6418, -0.0618>
		<3.7955, 18.8874, 0.0613> <3.8454, 18.9372, 0.0613> <3.8454, 20.5920, 0.0613> <3.7955, 20.6418, 0.0613>
		<3.7955, 18.8874, 0.2255> <3.8454, 18.9372, 0.2255> <3.8454, 20.5920, 0.2255> <3.7955, 20.6418, 0.2255>
		<3.7955, 18.8874, 0.3486> <3.8454, 18.9372, 0.3486> <3.8454, 20.5920, 0.3486> <3.7955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7955, 20.6418, -0.0618> <3.7457, 20.6916, -0.0618> <2.0910, 20.6916, -0.0618> <2.0411, 20.6418, -0.0618>
		<3.7955, 20.6418, 0.0613> <3.7457, 20.6916, 0.0613> <2.0910, 20.6916, 0.0613> <2.0411, 20.6418, 0.0613>
		<3.7955, 20.6418, 0.2255> <3.7457, 20.6916, 0.2255> <2.0910, 20.6916, 0.2255> <2.0411, 20.6418, 0.2255>
		<3.7955, 20.6418, 0.3486> <3.7457, 20.6916, 0.3486> <2.0910, 20.6916, 0.3486> <2.0411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 0.9062> <4.2891, 19.0245, 0.9062> <4.2891, 20.5047, 0.9062> <4.3336, 20.5493, 0.9062>
		<4.3288, 18.9751, 0.8515> <4.2843, 19.0196, 0.8515> <4.2843, 20.5095, 0.8515> <4.3288, 20.5541, 0.8515>
		<4.2500, 18.8963, 0.8308> <4.2002, 18.9461, 0.8308> <4.2002, 20.5831, 0.8308> <4.2500, 20.6329, 0.8308>
		<4.2411, 18.8874, 0.7771> <4.1913, 18.9372, 0.7771> <4.1913, 20.5920, 0.7771> <4.2411, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 0.9062> <4.3380, 18.9842, 0.9557> <4.2440, 18.8903, 0.9996> <4.2643, 18.9105, 1.0404>
		<4.2891, 19.0245, 0.9062> <4.2934, 19.0288, 0.9557> <4.1955, 18.9388, 0.9996> <4.2157, 18.9590, 1.0404>
		<4.2891, 20.5047, 0.9062> <4.2934, 20.5004, 0.9557> <4.1955, 20.5904, 0.9996> <4.2157, 20.5702, 1.0404>
		<4.3336, 20.5493, 0.9062> <4.3380, 20.5449, 0.9557> <4.2440, 20.6389, 0.9996> <4.2643, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 0.9062> <4.3288, 18.9751, 0.8515> <4.2500, 18.8963, 0.8308> <4.2411, 18.8874, 0.7771>
		<4.3782, 18.9353, 0.9062> <4.3734, 18.9305, 0.8515> <4.2999, 18.8465, 0.8308> <4.2910, 18.8376, 0.7771>
		<5.8585, 18.9353, 0.9062> <5.8633, 18.9305, 0.8515> <5.9368, 18.8465, 0.8308> <5.9457, 18.8376, 0.7771>
		<5.9030, 18.9799, 0.9062> <5.9078, 18.9751, 0.8515> <5.9866, 18.8963, 0.8308> <5.9955, 18.8874, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 0.9062> <4.3782, 18.9353, 0.9062> <5.8585, 18.9353, 0.9062> <5.9030, 18.9799, 0.9062>
		<4.3380, 18.9842, 0.9557> <4.3825, 18.9397, 0.9557> <5.8541, 18.9397, 0.9557> <5.8987, 18.9842, 0.9557>
		<4.2440, 18.8903, 0.9996> <4.2925, 18.8418, 0.9996> <5.9441, 18.8418, 0.9996> <5.9927, 18.8903, 0.9996>
		<4.2643, 18.9105, 1.0404> <4.3128, 18.8620, 1.0404> <5.9239, 18.8620, 1.0404> <5.9724, 18.9105, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 18.9799, 0.9062> <5.9078, 18.9751, 0.8515> <5.9866, 18.8963, 0.8308> <5.9955, 18.8874, 0.7771>
		<5.9476, 19.0245, 0.9062> <5.9524, 19.0196, 0.8515> <6.0365, 18.9461, 0.8308> <6.0454, 18.9372, 0.7771>
		<5.9476, 20.5047, 0.9062> <5.9524, 20.5095, 0.8515> <6.0365, 20.5831, 0.8308> <6.0454, 20.5920, 0.7771>
		<5.9030, 20.5493, 0.9062> <5.9078, 20.5541, 0.8515> <5.9866, 20.6329, 0.8308> <5.9955, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 18.9799, 0.9062> <5.9476, 19.0245, 0.9062> <5.9476, 20.5047, 0.9062> <5.9030, 20.5493, 0.9062>
		<5.8987, 18.9842, 0.9557> <5.9433, 19.0288, 0.9557> <5.9433, 20.5004, 0.9557> <5.8987, 20.5449, 0.9557>
		<5.9927, 18.8903, 0.9996> <6.0412, 18.9388, 0.9996> <6.0412, 20.5904, 0.9996> <5.9927, 20.6389, 0.9996>
		<5.9724, 18.9105, 1.0404> <6.0209, 18.9590, 1.0404> <6.0209, 20.5702, 1.0404> <5.9724, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 20.5493, 0.9062> <5.9078, 20.5541, 0.8515> <5.9866, 20.6329, 0.8308> <5.9955, 20.6418, 0.7771>
		<5.8585, 20.5939, 0.9062> <5.8633, 20.5987, 0.8515> <5.9368, 20.6827, 0.8308> <5.9457, 20.6916, 0.7771>
		<4.3782, 20.5939, 0.9062> <4.3734, 20.5987, 0.8515> <4.2999, 20.6827, 0.8308> <4.2910, 20.6916, 0.7771>
		<4.3336, 20.5493, 0.9062> <4.3288, 20.5541, 0.8515> <4.2500, 20.6329, 0.8308> <4.2411, 20.6418, 0.7771>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 20.5493, 0.9062> <5.8585, 20.5939, 0.9062> <4.3782, 20.5939, 0.9062> <4.3336, 20.5493, 0.9062>
		<5.8987, 20.5449, 0.9557> <5.8541, 20.5895, 0.9557> <4.3825, 20.5895, 0.9557> <4.3380, 20.5449, 0.9557>
		<5.9927, 20.6389, 0.9996> <5.9441, 20.6874, 0.9996> <4.2925, 20.6874, 0.9996> <4.2440, 20.6389, 0.9996>
		<5.9724, 20.6187, 1.0404> <5.9239, 20.6672, 1.0404> <4.3128, 20.6672, 1.0404> <4.2643, 20.6187, 1.0404>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2643, 18.9105, 1.0404> <4.3323, 18.9786, 1.1777> <4.5018, 19.1481, 1.2552> <4.5731, 19.2193, 1.3892>
		<4.2157, 18.9590, 1.0404> <4.2838, 19.0271, 1.1777> <4.4709, 19.1790, 1.2552> <4.5421, 19.2503, 1.3892>
		<4.2157, 20.5702, 1.0404> <4.2838, 20.5021, 1.1777> <4.4709, 20.3501, 1.2552> <4.5421, 20.2789, 1.3892>
		<4.2643, 20.6187, 1.0404> <4.3323, 20.5506, 1.1777> <4.5018, 20.3811, 1.2552> <4.5731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2643, 18.9105, 1.0404> <4.3128, 18.8620, 1.0404> <5.9239, 18.8620, 1.0404> <5.9724, 18.9105, 1.0404>
		<4.3323, 18.9786, 1.1777> <4.3808, 18.9301, 1.1777> <5.8558, 18.9301, 1.1777> <5.9043, 18.9786, 1.1777>
		<4.5018, 19.1481, 1.2552> <4.5328, 19.1171, 1.2552> <5.7039, 19.1171, 1.2552> <5.7348, 19.1481, 1.2552>
		<4.5731, 19.2193, 1.3892> <4.6041, 19.1884, 1.3892> <5.6326, 19.1884, 1.3892> <5.6636, 19.2193, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9724, 18.9105, 1.0404> <6.0209, 18.9590, 1.0404> <6.0209, 20.5702, 1.0404> <5.9724, 20.6187, 1.0404>
		<5.9043, 18.9786, 1.1777> <5.9529, 19.0271, 1.1777> <5.9529, 20.5021, 1.1777> <5.9043, 20.5506, 1.1777>
		<5.7348, 19.1481, 1.2552> <5.7658, 19.1790, 1.2552> <5.7658, 20.3501, 1.2552> <5.7348, 20.3811, 1.2552>
		<5.6636, 19.2193, 1.3892> <5.6946, 19.2503, 1.3892> <5.6946, 20.2789, 1.3892> <5.6636, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9724, 20.6187, 1.0404> <5.9239, 20.6672, 1.0404> <4.3128, 20.6672, 1.0404> <4.2643, 20.6187, 1.0404>
		<5.9043, 20.5506, 1.1777> <5.8558, 20.5991, 1.1777> <4.3808, 20.5991, 1.1777> <4.3323, 20.5506, 1.1777>
		<5.7348, 20.3811, 1.2552> <5.7039, 20.4121, 1.2552> <4.5328, 20.4121, 1.2552> <4.5018, 20.3811, 1.2552>
		<5.6636, 20.3098, 1.3892> <5.6326, 20.3408, 1.3892> <4.6041, 20.3408, 1.3892> <4.5731, 20.3098, 1.3892>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5731, 19.2193, 1.3892> <4.5921, 19.2383, 1.4249> <4.5163, 19.1626, 1.4698> <4.5163, 19.1626, 1.5144>
		<4.5421, 19.2503, 1.3892> <4.5611, 19.2693, 1.4249> <4.4821, 19.1968, 1.4698> <4.4821, 19.1968, 1.5144>
		<4.5421, 20.2789, 1.3892> <4.5611, 20.2599, 1.4249> <4.4821, 20.3324, 1.4698> <4.4821, 20.3324, 1.5144>
		<4.5731, 20.3098, 1.3892> <4.5921, 20.2909, 1.4249> <4.5163, 20.3666, 1.4698> <4.5163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5731, 19.2193, 1.3892> <4.6041, 19.1884, 1.3892> <5.6326, 19.1884, 1.3892> <5.6636, 19.2193, 1.3892>
		<4.5921, 19.2383, 1.4249> <4.6230, 19.2073, 1.4249> <5.6137, 19.2073, 1.4249> <5.6446, 19.2383, 1.4249>
		<4.5163, 19.1626, 1.4698> <4.5505, 19.1284, 1.4698> <5.6862, 19.1284, 1.4698> <5.7204, 19.1626, 1.4698>
		<4.5163, 19.1626, 1.5144> <4.5505, 19.1284, 1.5144> <5.6862, 19.1284, 1.5144> <5.7204, 19.1626, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6636, 19.2193, 1.3892> <5.6946, 19.2503, 1.3892> <5.6946, 20.2789, 1.3892> <5.6636, 20.3098, 1.3892>
		<5.6446, 19.2383, 1.4249> <5.6756, 19.2693, 1.4249> <5.6756, 20.2599, 1.4249> <5.6446, 20.2909, 1.4249>
		<5.7204, 19.1626, 1.4698> <5.7545, 19.1968, 1.4698> <5.7545, 20.3324, 1.4698> <5.7204, 20.3666, 1.4698>
		<5.7204, 19.1626, 1.5144> <5.7545, 19.1968, 1.5144> <5.7545, 20.3324, 1.5144> <5.7204, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6636, 20.3098, 1.3892> <5.6326, 20.3408, 1.3892> <4.6041, 20.3408, 1.3892> <4.5731, 20.3098, 1.3892>
		<5.6446, 20.2909, 1.4249> <5.6137, 20.3218, 1.4249> <4.6230, 20.3218, 1.4249> <4.5921, 20.2909, 1.4249>
		<5.7204, 20.3666, 1.4698> <5.6862, 20.4008, 1.4698> <4.5505, 20.4008, 1.4698> <4.5163, 20.3666, 1.4698>
		<5.7204, 20.3666, 1.5144> <5.6862, 20.4008, 1.5144> <4.5505, 20.4008, 1.5144> <4.5163, 20.3666, 1.5144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5163, 19.1626, 1.5144> <4.5163, 19.1626, 1.5613> <4.5879, 19.2341, 1.6066> <4.5731, 19.2193, 1.6486>
		<4.4821, 19.1968, 1.5144> <4.4821, 19.1968, 1.5613> <4.5569, 19.2651, 1.6066> <4.5421, 19.2503, 1.6486>
		<4.4821, 20.3324, 1.5144> <4.4821, 20.3324, 1.5613> <4.5569, 20.2641, 1.6066> <4.5421, 20.2789, 1.6486>
		<4.5163, 20.3666, 1.5144> <4.5163, 20.3666, 1.5613> <4.5879, 20.2950, 1.6066> <4.5731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5163, 19.1626, 1.5144> <4.5505, 19.1284, 1.5144> <5.6862, 19.1284, 1.5144> <5.7204, 19.1626, 1.5144>
		<4.5163, 19.1626, 1.5613> <4.5505, 19.1284, 1.5613> <5.6862, 19.1284, 1.5613> <5.7204, 19.1626, 1.5613>
		<4.5879, 19.2341, 1.6066> <4.6188, 19.2032, 1.6066> <5.6178, 19.2032, 1.6066> <5.6488, 19.2341, 1.6066>
		<4.5731, 19.2193, 1.6486> <4.6041, 19.1884, 1.6486> <5.6326, 19.1884, 1.6486> <5.6636, 19.2193, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7204, 19.1626, 1.5144> <5.7545, 19.1968, 1.5144> <5.7545, 20.3324, 1.5144> <5.7204, 20.3666, 1.5144>
		<5.7204, 19.1626, 1.5613> <5.7545, 19.1968, 1.5613> <5.7545, 20.3324, 1.5613> <5.7204, 20.3666, 1.5613>
		<5.6488, 19.2341, 1.6066> <5.6798, 19.2651, 1.6066> <5.6798, 20.2641, 1.6066> <5.6488, 20.2950, 1.6066>
		<5.6636, 19.2193, 1.6486> <5.6946, 19.2503, 1.6486> <5.6946, 20.2789, 1.6486> <5.6636, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7204, 20.3666, 1.5144> <5.6862, 20.4008, 1.5144> <4.5505, 20.4008, 1.5144> <4.5163, 20.3666, 1.5144>
		<5.7204, 20.3666, 1.5613> <5.6862, 20.4008, 1.5613> <4.5505, 20.4008, 1.5613> <4.5163, 20.3666, 1.5613>
		<5.6488, 20.2950, 1.6066> <5.6178, 20.3260, 1.6066> <4.6188, 20.3260, 1.6066> <4.5879, 20.2950, 1.6066>
		<5.6636, 20.3098, 1.6486> <5.6326, 20.3408, 1.6486> <4.6041, 20.3408, 1.6486> <4.5731, 20.3098, 1.6486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5731, 19.2193, 1.6486> <4.5246, 19.1709, 1.7862> <4.3828, 19.0290, 1.8960> <4.3336, 18.9799, 2.0332>
		<4.5421, 19.2503, 1.6486> <4.4937, 19.2018, 1.7862> <4.3382, 19.0736, 1.8960> <4.2891, 19.0245, 2.0332>
		<4.5421, 20.2789, 1.6486> <4.4937, 20.3273, 1.7862> <4.3382, 20.4556, 1.8960> <4.2891, 20.5047, 2.0332>
		<4.5731, 20.3098, 1.6486> <4.5246, 20.3583, 1.7862> <4.3828, 20.5002, 1.8960> <4.3336, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5731, 19.2193, 1.6486> <4.6041, 19.1884, 1.6486> <5.6326, 19.1884, 1.6486> <5.6636, 19.2193, 1.6486>
		<4.5246, 19.1709, 1.7862> <4.5556, 19.1399, 1.7862> <5.6811, 19.1399, 1.7862> <5.7120, 19.1709, 1.7862>
		<4.3828, 19.0290, 1.8960> <4.4273, 18.9844, 1.8960> <5.8093, 18.9844, 1.8960> <5.8539, 19.0290, 1.8960>
		<4.3336, 18.9799, 2.0332> <4.3782, 18.9353, 2.0332> <5.8585, 18.9353, 2.0332> <5.9030, 18.9799, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6636, 19.2193, 1.6486> <5.6946, 19.2503, 1.6486> <5.6946, 20.2789, 1.6486> <5.6636, 20.3098, 1.6486>
		<5.7120, 19.1709, 1.7862> <5.7430, 19.2018, 1.7862> <5.7430, 20.3273, 1.7862> <5.7120, 20.3583, 1.7862>
		<5.8539, 19.0290, 1.8960> <5.8985, 19.0736, 1.8960> <5.8985, 20.4556, 1.8960> <5.8539, 20.5002, 1.8960>
		<5.9030, 18.9799, 2.0332> <5.9476, 19.0245, 2.0332> <5.9476, 20.5047, 2.0332> <5.9030, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6636, 20.3098, 1.6486> <5.6326, 20.3408, 1.6486> <4.6041, 20.3408, 1.6486> <4.5731, 20.3098, 1.6486>
		<5.7120, 20.3583, 1.7862> <5.6811, 20.3893, 1.7862> <4.5556, 20.3893, 1.7862> <4.5246, 20.3583, 1.7862>
		<5.8539, 20.5002, 1.8960> <5.8093, 20.5447, 1.8960> <4.4273, 20.5447, 1.8960> <4.3828, 20.5002, 1.8960>
		<5.9030, 20.5493, 2.0332> <5.8585, 20.5939, 2.0332> <4.3782, 20.5939, 2.0332> <4.3336, 20.5493, 2.0332>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 2.0332> <4.3070, 18.9533, 2.1074> <4.3068, 18.9531, 2.2382> <4.3359, 18.9822, 2.3104>
		<4.2891, 19.0245, 2.0332> <4.2625, 18.9979, 2.1074> <4.2624, 18.9975, 2.2382> <4.2915, 19.0266, 2.3104>
		<4.2891, 20.5047, 2.0332> <4.2625, 20.5313, 2.1074> <4.2624, 20.5317, 2.2382> <4.2915, 20.5025, 2.3104>
		<4.3336, 20.5493, 2.0332> <4.3070, 20.5759, 2.1074> <4.3068, 20.5761, 2.2382> <4.3359, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3336, 18.9799, 2.0332> <4.3782, 18.9353, 2.0332> <5.8585, 18.9353, 2.0332> <5.9030, 18.9799, 2.0332>
		<4.3070, 18.9533, 2.1074> <4.3516, 18.9087, 2.1074> <5.8851, 18.9087, 2.1074> <5.9296, 18.9533, 2.1074>
		<4.3068, 18.9531, 2.2382> <4.3512, 18.9086, 2.2382> <5.8854, 18.9086, 2.2382> <5.9299, 18.9531, 2.2382>
		<4.3359, 18.9822, 2.3104> <4.3804, 18.9378, 2.3104> <5.8563, 18.9378, 2.3104> <5.9007, 18.9822, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 18.9799, 2.0332> <5.9476, 19.0245, 2.0332> <5.9476, 20.5047, 2.0332> <5.9030, 20.5493, 2.0332>
		<5.9296, 18.9533, 2.1074> <5.9742, 18.9979, 2.1074> <5.9742, 20.5313, 2.1074> <5.9296, 20.5759, 2.1074>
		<5.9299, 18.9531, 2.2382> <5.9743, 18.9975, 2.2382> <5.9743, 20.5317, 2.2382> <5.9299, 20.5761, 2.2382>
		<5.9007, 18.9822, 2.3104> <5.9452, 19.0266, 2.3104> <5.9452, 20.5025, 2.3104> <5.9007, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9030, 20.5493, 2.0332> <5.8585, 20.5939, 2.0332> <4.3782, 20.5939, 2.0332> <4.3336, 20.5493, 2.0332>
		<5.9296, 20.5759, 2.1074> <5.8851, 20.6204, 2.1074> <4.3516, 20.6204, 2.1074> <4.3070, 20.5759, 2.1074>
		<5.9299, 20.5761, 2.2382> <5.8854, 20.6206, 2.2382> <4.3512, 20.6206, 2.2382> <4.3068, 20.5761, 2.2382>
		<5.9007, 20.5470, 2.3104> <5.8563, 20.5914, 2.3104> <4.3804, 20.5914, 2.3104> <4.3359, 20.5470, 2.3104>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3359, 18.9822, 2.3104> <4.4199, 19.0661, 2.5186> <4.6157, 19.2620, 2.7154> <4.6944, 19.3406, 2.9276>
		<4.2915, 19.0266, 2.3104> <4.3754, 19.1106, 2.5186> <4.5916, 19.2860, 2.7154> <4.6703, 19.3647, 2.9276>
		<4.2915, 20.5025, 2.3104> <4.3754, 20.4186, 2.5186> <4.5916, 20.2431, 2.7154> <4.6703, 20.1645, 2.9276>
		<4.3359, 20.5470, 2.3104> <4.4199, 20.4630, 2.5186> <4.6157, 20.2672, 2.7154> <4.6944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.3359, 18.9822, 2.3104> <4.3804, 18.9378, 2.3104> <5.8563, 18.9378, 2.3104> <5.9007, 18.9822, 2.3104>
		<4.4199, 19.0661, 2.5186> <4.4643, 19.0217, 2.5186> <5.7723, 19.0217, 2.5186> <5.8168, 19.0661, 2.5186>
		<4.6157, 19.2620, 2.7154> <4.6398, 19.2379, 2.7154> <5.5969, 19.2379, 2.7154> <5.6210, 19.2620, 2.7154>
		<4.6944, 19.3406, 2.9276> <4.7185, 19.3165, 2.9276> <5.5182, 19.3165, 2.9276> <5.5423, 19.3406, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9007, 18.9822, 2.3104> <5.9452, 19.0266, 2.3104> <5.9452, 20.5025, 2.3104> <5.9007, 20.5470, 2.3104>
		<5.8168, 19.0661, 2.5186> <5.8612, 19.1106, 2.5186> <5.8612, 20.4186, 2.5186> <5.8168, 20.4630, 2.5186>
		<5.6210, 19.2620, 2.7154> <5.6450, 19.2860, 2.7154> <5.6450, 20.2431, 2.7154> <5.6210, 20.2672, 2.7154>
		<5.5423, 19.3406, 2.9276> <5.5664, 19.3647, 2.9276> <5.5664, 20.1645, 2.9276> <5.5423, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9007, 20.5470, 2.3104> <5.8563, 20.5914, 2.3104> <4.3804, 20.5914, 2.3104> <4.3359, 20.5470, 2.3104>
		<5.8168, 20.4630, 2.5186> <5.7723, 20.5075, 2.5186> <4.4643, 20.5075, 2.5186> <4.4199, 20.4630, 2.5186>
		<5.6210, 20.2672, 2.7154> <5.5969, 20.2913, 2.7154> <4.6398, 20.2913, 2.7154> <4.6157, 20.2672, 2.7154>
		<5.5423, 20.1885, 2.9276> <5.5182, 20.2126, 2.9276> <4.7185, 20.2126, 2.9276> <4.6944, 20.1885, 2.9276>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6944, 19.3406, 2.9276> <4.7113, 19.3576, 2.9732> <4.6111, 19.2574, 3.0012> <4.6111, 19.2574, 3.0528>
		<4.6703, 19.3647, 2.9276> <4.6872, 19.3816, 2.9732> <4.5823, 19.2862, 3.0012> <4.5823, 19.2862, 3.0528>
		<4.6703, 20.1645, 2.9276> <4.6872, 20.1475, 2.9732> <4.5823, 20.2430, 3.0012> <4.5823, 20.2430, 3.0528>
		<4.6944, 20.1885, 2.9276> <4.7113, 20.1716, 2.9732> <4.6111, 20.2718, 3.0012> <4.6111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6944, 19.3406, 2.9276> <4.7185, 19.3165, 2.9276> <5.5182, 19.3165, 2.9276> <5.5423, 19.3406, 2.9276>
		<4.7113, 19.3576, 2.9732> <4.7354, 19.3335, 2.9732> <5.5013, 19.3335, 2.9732> <5.5254, 19.3576, 2.9732>
		<4.6111, 19.2574, 3.0012> <4.6399, 19.2286, 3.0012> <5.5967, 19.2286, 3.0012> <5.6255, 19.2574, 3.0012>
		<4.6111, 19.2574, 3.0528> <4.6399, 19.2286, 3.0528> <5.5967, 19.2286, 3.0528> <5.6255, 19.2574, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5423, 19.3406, 2.9276> <5.5664, 19.3647, 2.9276> <5.5664, 20.1645, 2.9276> <5.5423, 20.1885, 2.9276>
		<5.5254, 19.3576, 2.9732> <5.5494, 19.3816, 2.9732> <5.5494, 20.1475, 2.9732> <5.5254, 20.1716, 2.9732>
		<5.6255, 19.2574, 3.0012> <5.6544, 19.2862, 3.0012> <5.6544, 20.2430, 3.0012> <5.6255, 20.2718, 3.0012>
		<5.6255, 19.2574, 3.0528> <5.6544, 19.2862, 3.0528> <5.6544, 20.2430, 3.0528> <5.6255, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5423, 20.1885, 2.9276> <5.5182, 20.2126, 2.9276> <4.7185, 20.2126, 2.9276> <4.6944, 20.1885, 2.9276>
		<5.5254, 20.1716, 2.9732> <5.5013, 20.1957, 2.9732> <4.7354, 20.1957, 2.9732> <4.7113, 20.1716, 2.9732>
		<5.6255, 20.2718, 3.0012> <5.5967, 20.3006, 3.0012> <4.6399, 20.3006, 3.0012> <4.6111, 20.2718, 3.0012>
		<5.6255, 20.2718, 3.0528> <5.5967, 20.3006, 3.0528> <4.6399, 20.3006, 3.0528> <4.6111, 20.2718, 3.0528>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6111, 19.2574, 3.0528> <4.6111, 19.2574, 3.1044> <4.7138, 19.3600, 3.1344> <4.6944, 19.3406, 3.1780>
		<4.5823, 19.2862, 3.0528> <4.5823, 19.2862, 3.1044> <4.6897, 19.3841, 3.1344> <4.6703, 19.3647, 3.1780>
		<4.5823, 20.2430, 3.0528> <4.5823, 20.2430, 3.1044> <4.6897, 20.1451, 3.1344> <4.6703, 20.1645, 3.1780>
		<4.6111, 20.2718, 3.0528> <4.6111, 20.2718, 3.1044> <4.7138, 20.1691, 3.1344> <4.6944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6111, 19.2574, 3.0528> <4.6399, 19.2286, 3.0528> <5.5967, 19.2286, 3.0528> <5.6255, 19.2574, 3.0528>
		<4.6111, 19.2574, 3.1044> <4.6399, 19.2286, 3.1044> <5.5967, 19.2286, 3.1044> <5.6255, 19.2574, 3.1044>
		<4.7138, 19.3600, 3.1344> <4.7379, 19.3359, 3.1344> <5.4988, 19.3359, 3.1344> <5.5229, 19.3600, 3.1344>
		<4.6944, 19.3406, 3.1780> <4.7185, 19.3165, 3.1780> <5.5182, 19.3165, 3.1780> <5.5423, 19.3406, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6255, 19.2574, 3.0528> <5.6544, 19.2862, 3.0528> <5.6544, 20.2430, 3.0528> <5.6255, 20.2718, 3.0528>
		<5.6255, 19.2574, 3.1044> <5.6544, 19.2862, 3.1044> <5.6544, 20.2430, 3.1044> <5.6255, 20.2718, 3.1044>
		<5.5229, 19.3600, 3.1344> <5.5470, 19.3841, 3.1344> <5.5470, 20.1451, 3.1344> <5.5229, 20.1691, 3.1344>
		<5.5423, 19.3406, 3.1780> <5.5664, 19.3647, 3.1780> <5.5664, 20.1645, 3.1780> <5.5423, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6255, 20.2718, 3.0528> <5.5967, 20.3006, 3.0528> <4.6399, 20.3006, 3.0528> <4.6111, 20.2718, 3.0528>
		<5.6255, 20.2718, 3.1044> <5.5967, 20.3006, 3.1044> <4.6399, 20.3006, 3.1044> <4.6111, 20.2718, 3.1044>
		<5.5229, 20.1691, 3.1344> <5.4988, 20.1932, 3.1344> <4.7379, 20.1932, 3.1344> <4.7138, 20.1691, 3.1344>
		<5.5423, 20.1885, 3.1780> <5.5182, 20.2126, 3.1780> <4.7185, 20.2126, 3.1780> <4.6944, 20.1885, 3.1780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6944, 19.3406, 3.1780> <4.6562, 19.3024, 3.2640> <4.5390, 19.1852, 3.2738> <4.4839, 19.1302, 3.3390>
		<4.6703, 19.3647, 3.1780> <4.6321, 19.3265, 3.2640> <4.5029, 19.2212, 3.2738> <4.4479, 19.1662, 3.3390>
		<4.6703, 20.1645, 3.1780> <4.6321, 20.2027, 3.2640> <4.5029, 20.3079, 3.2738> <4.4479, 20.3629, 3.3390>
		<4.6944, 20.1885, 3.1780> <4.6562, 20.2267, 3.2640> <4.5390, 20.3440, 3.2738> <4.4839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6944, 19.3406, 3.1780> <4.7185, 19.3165, 3.1780> <5.5182, 19.3165, 3.1780> <5.5423, 19.3406, 3.1780>
		<4.6562, 19.3024, 3.2640> <4.6803, 19.2784, 3.2640> <5.5564, 19.2784, 3.2640> <5.5805, 19.3024, 3.2640>
		<4.5390, 19.1852, 3.2738> <4.5750, 19.1492, 3.2738> <5.6617, 19.1492, 3.2738> <5.6977, 19.1852, 3.2738>
		<4.4839, 19.1302, 3.3390> <4.5200, 19.0942, 3.3390> <5.7167, 19.0942, 3.3390> <5.7527, 19.1302, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5423, 19.3406, 3.1780> <5.5664, 19.3647, 3.1780> <5.5664, 20.1645, 3.1780> <5.5423, 20.1885, 3.1780>
		<5.5805, 19.3024, 3.2640> <5.6046, 19.3265, 3.2640> <5.6046, 20.2027, 3.2640> <5.5805, 20.2267, 3.2640>
		<5.6977, 19.1852, 3.2738> <5.7337, 19.2212, 3.2738> <5.7337, 20.3079, 3.2738> <5.6977, 20.3440, 3.2738>
		<5.7527, 19.1302, 3.3390> <5.7888, 19.1662, 3.3390> <5.7888, 20.3629, 3.3390> <5.7527, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5423, 20.1885, 3.1780> <5.5182, 20.2126, 3.1780> <4.7185, 20.2126, 3.1780> <4.6944, 20.1885, 3.1780>
		<5.5805, 20.2267, 3.2640> <5.5564, 20.2508, 3.2640> <4.6803, 20.2508, 3.2640> <4.6562, 20.2267, 3.2640>
		<5.6977, 20.3440, 3.2738> <5.6617, 20.3800, 3.2738> <4.5750, 20.3800, 3.2738> <4.5390, 20.3440, 3.2738>
		<5.7527, 20.3990, 3.3390> <5.7167, 20.4350, 3.3390> <4.5200, 20.4350, 3.3390> <4.4839, 20.3990, 3.3390>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4839, 19.1302, 3.3390> <4.4584, 19.1046, 3.3693> <4.4203, 19.0665, 3.4419> <4.4377, 19.0839, 3.4821>
		<4.4479, 19.1662, 3.3390> <4.4223, 19.1406, 3.3693> <4.3816, 19.1052, 3.4419> <4.3990, 19.1226, 3.4821>
		<4.4479, 20.3629, 3.3390> <4.4223, 20.3885, 3.3693> <4.3816, 20.4240, 3.4419> <4.3990, 20.4066, 3.4821>
		<4.4839, 20.3990, 3.3390> <4.4584, 20.4246, 3.3693> <4.4203, 20.4627, 3.4419> <4.4377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4839, 19.1302, 3.3390> <4.5200, 19.0942, 3.3390> <5.7167, 19.0942, 3.3390> <5.7527, 19.1302, 3.3390>
		<4.4584, 19.1046, 3.3693> <4.4944, 19.0686, 3.3693> <5.7423, 19.0686, 3.3693> <5.7783, 19.1046, 3.3693>
		<4.4203, 19.0665, 3.4419> <4.4589, 19.0279, 3.4419> <5.7777, 19.0279, 3.4419> <5.8164, 19.0665, 3.4419>
		<4.4377, 19.0839, 3.4821> <4.4764, 19.0453, 3.4821> <5.7603, 19.0453, 3.4821> <5.7990, 19.0839, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7527, 19.1302, 3.3390> <5.7888, 19.1662, 3.3390> <5.7888, 20.3629, 3.3390> <5.7527, 20.3990, 3.3390>
		<5.7783, 19.1046, 3.3693> <5.8143, 19.1406, 3.3693> <5.8143, 20.3885, 3.3693> <5.7783, 20.4246, 3.3693>
		<5.8164, 19.0665, 3.4419> <5.8551, 19.1052, 3.4419> <5.8551, 20.4240, 3.4419> <5.8164, 20.4627, 3.4419>
		<5.7990, 19.0839, 3.4821> <5.8376, 19.1226, 3.4821> <5.8376, 20.4066, 3.4821> <5.7990, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7527, 20.3990, 3.3390> <5.7167, 20.4350, 3.3390> <4.5200, 20.4350, 3.3390> <4.4839, 20.3990, 3.3390>
		<5.7783, 20.4246, 3.3693> <5.7423, 20.4606, 3.3693> <4.4944, 20.4606, 3.3693> <4.4584, 20.4246, 3.3693>
		<5.8164, 20.4627, 3.4419> <5.7777, 20.5013, 3.4419> <4.4589, 20.5013, 3.4419> <4.4203, 20.4627, 3.4419>
		<5.7990, 20.4452, 3.4821> <5.7603, 20.4839, 3.4821> <4.4764, 20.4839, 3.4821> <4.4377, 20.4452, 3.4821>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4377, 19.0839, 3.4821> <4.4837, 19.1300, 3.5884> <4.6039, 19.2502, 3.6567> <4.6620, 19.3083, 3.7504>
		<4.3990, 19.1226, 3.4821> <4.4450, 19.1686, 3.5884> <4.5780, 19.2761, 3.6567> <4.6361, 19.3342, 3.7504>
		<4.3990, 20.4066, 3.4821> <4.4450, 20.3606, 3.5884> <4.5780, 20.2531, 3.6567> <4.6361, 20.1950, 3.7504>
		<4.4377, 20.4452, 3.4821> <4.4837, 20.3992, 3.5884> <4.6039, 20.2790, 3.6567> <4.6620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4377, 19.0839, 3.4821> <4.4764, 19.0453, 3.4821> <5.7603, 19.0453, 3.4821> <5.7990, 19.0839, 3.4821>
		<4.4837, 19.1300, 3.5884> <4.5224, 19.0913, 3.5884> <5.7143, 19.0913, 3.5884> <5.7530, 19.1300, 3.5884>
		<4.6039, 19.2502, 3.6567> <4.6298, 19.2242, 3.6567> <5.6068, 19.2242, 3.6567> <5.6328, 19.2502, 3.6567>
		<4.6620, 19.3083, 3.7504> <4.6879, 19.2823, 3.7504> <5.5487, 19.2823, 3.7504> <5.5747, 19.3083, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7990, 19.0839, 3.4821> <5.8376, 19.1226, 3.4821> <5.8376, 20.4066, 3.4821> <5.7990, 20.4452, 3.4821>
		<5.7530, 19.1300, 3.5884> <5.7916, 19.1686, 3.5884> <5.7916, 20.3606, 3.5884> <5.7530, 20.3992, 3.5884>
		<5.6328, 19.2502, 3.6567> <5.6587, 19.2761, 3.6567> <5.6587, 20.2531, 3.6567> <5.6328, 20.2790, 3.6567>
		<5.5747, 19.3083, 3.7504> <5.6006, 19.3342, 3.7504> <5.6006, 20.1950, 3.7504> <5.5747, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7990, 20.4452, 3.4821> <5.7603, 20.4839, 3.4821> <4.4764, 20.4839, 3.4821> <4.4377, 20.4452, 3.4821>
		<5.7530, 20.3992, 3.5884> <5.7143, 20.4379, 3.5884> <4.5224, 20.4379, 3.5884> <4.4837, 20.3992, 3.5884>
		<5.6328, 20.2790, 3.6567> <5.6068, 20.3049, 3.6567> <4.6298, 20.3049, 3.6567> <4.6039, 20.2790, 3.6567>
		<5.5747, 20.2209, 3.7504> <5.5487, 20.2468, 3.7504> <4.6879, 20.2468, 3.7504> <4.6620, 20.2209, 3.7504>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6620, 19.3083, 3.7504> <4.7036, 19.3498, 3.8175> <4.7473, 19.3935, 3.9241> <4.7648, 19.4110, 4.0098>
		<4.6361, 19.3342, 3.7504> <4.6777, 19.3757, 3.8175> <4.7272, 19.4136, 3.9241> <4.7447, 19.4311, 4.0098>
		<4.6361, 20.1950, 3.7504> <4.6777, 20.1534, 3.8175> <4.7272, 20.1156, 3.9241> <4.7447, 20.0981, 4.0098>
		<4.6620, 20.2209, 3.7504> <4.7036, 20.1793, 3.8175> <4.7473, 20.1356, 3.9241> <4.7648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6620, 19.3083, 3.7504> <4.6879, 19.2823, 3.7504> <5.5487, 19.2823, 3.7504> <5.5747, 19.3083, 3.7504>
		<4.7036, 19.3498, 3.8175> <4.7295, 19.3239, 3.8175> <5.5072, 19.3239, 3.8175> <5.5331, 19.3498, 3.8175>
		<4.7473, 19.3935, 3.9241> <4.7674, 19.3734, 3.9241> <5.4693, 19.3734, 3.9241> <5.4894, 19.3935, 3.9241>
		<4.7648, 19.4110, 4.0098> <4.7848, 19.3909, 4.0098> <5.4518, 19.3909, 4.0098> <5.4719, 19.4110, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5747, 19.3083, 3.7504> <5.6006, 19.3342, 3.7504> <5.6006, 20.1950, 3.7504> <5.5747, 20.2209, 3.7504>
		<5.5331, 19.3498, 3.8175> <5.5590, 19.3757, 3.8175> <5.5590, 20.1534, 3.8175> <5.5331, 20.1793, 3.8175>
		<5.4894, 19.3935, 3.9241> <5.5095, 19.4136, 3.9241> <5.5095, 20.1156, 3.9241> <5.4894, 20.1356, 3.9241>
		<5.4719, 19.4110, 4.0098> <5.4920, 19.4311, 4.0098> <5.4920, 20.0981, 4.0098> <5.4719, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5747, 20.2209, 3.7504> <5.5487, 20.2468, 3.7504> <4.6879, 20.2468, 3.7504> <4.6620, 20.2209, 3.7504>
		<5.5331, 20.1793, 3.8175> <5.5072, 20.2053, 3.8175> <4.7295, 20.2053, 3.8175> <4.7036, 20.1793, 3.8175>
		<5.4894, 20.1356, 3.9241> <5.4693, 20.1557, 3.9241> <4.7674, 20.1557, 3.9241> <4.7473, 20.1356, 3.9241>
		<5.4719, 20.1182, 4.0098> <5.4518, 20.1383, 4.0098> <4.7848, 20.1383, 4.0098> <4.7648, 20.1182, 4.0098>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7648, 19.4110, 4.0098> <4.7832, 19.4294, 4.1002> <4.7779, 19.4242, 4.2288> <4.7787, 19.4250, 4.3229>
		<4.7447, 19.4311, 4.0098> <4.7631, 19.4495, 4.1002> <4.7587, 19.4435, 4.2288> <4.7595, 19.4443, 4.3229>
		<4.7447, 20.0981, 4.0098> <4.7631, 20.0797, 4.1002> <4.7587, 20.0857, 4.2288> <4.7595, 20.0849, 4.3229>
		<4.7648, 20.1182, 4.0098> <4.7832, 20.0997, 4.1002> <4.7779, 20.1050, 4.2288> <4.7787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7648, 19.4110, 4.0098> <4.7848, 19.3909, 4.0098> <5.4518, 19.3909, 4.0098> <5.4719, 19.4110, 4.0098>
		<4.7832, 19.4294, 4.1002> <4.8033, 19.4094, 4.1002> <5.4334, 19.4094, 4.1002> <5.4535, 19.4294, 4.1002>
		<4.7779, 19.4242, 4.2288> <4.7972, 19.4049, 4.2288> <5.4394, 19.4049, 4.2288> <5.4587, 19.4242, 4.2288>
		<4.7787, 19.4250, 4.3229> <4.7980, 19.4057, 4.3229> <5.4386, 19.4057, 4.3229> <5.4579, 19.4250, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4719, 19.4110, 4.0098> <5.4920, 19.4311, 4.0098> <5.4920, 20.0981, 4.0098> <5.4719, 20.1182, 4.0098>
		<5.4535, 19.4294, 4.1002> <5.4736, 19.4495, 4.1002> <5.4736, 20.0797, 4.1002> <5.4535, 20.0997, 4.1002>
		<5.4587, 19.4242, 4.2288> <5.4780, 19.4435, 4.2288> <5.4780, 20.0857, 4.2288> <5.4587, 20.1050, 4.2288>
		<5.4579, 19.4250, 4.3229> <5.4772, 19.4443, 4.3229> <5.4772, 20.0849, 4.3229> <5.4579, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4719, 20.1182, 4.0098> <5.4518, 20.1383, 4.0098> <4.7848, 20.1383, 4.0098> <4.7648, 20.1182, 4.0098>
		<5.4535, 20.0997, 4.1002> <5.4334, 20.1198, 4.1002> <4.8033, 20.1198, 4.1002> <4.7832, 20.0997, 4.1002>
		<5.4587, 20.1050, 4.2288> <5.4394, 20.1243, 4.2288> <4.7972, 20.1243, 4.2288> <4.7779, 20.1050, 4.2288>
		<5.4579, 20.1042, 4.3229> <5.4386, 20.1235, 4.3229> <4.7980, 20.1235, 4.3229> <4.7787, 20.1042, 4.3229>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7787, 19.4250, 4.3229> <4.7821, 19.4284, 4.7283> <4.7803, 19.4265, 5.2689> <4.7787, 19.4250, 5.6744>
		<4.7595, 19.4443, 4.3229> <4.7629, 19.4477, 4.7283> <4.7610, 19.4458, 5.2689> <4.7595, 19.4443, 5.6744>
		<4.7595, 20.0849, 4.3229> <4.7629, 20.0815, 4.7283> <4.7610, 20.0834, 5.2689> <4.7595, 20.0849, 5.6744>
		<4.7787, 20.1042, 4.3229> <4.7821, 20.1008, 4.7283> <4.7803, 20.1027, 5.2689> <4.7787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7787, 19.4250, 4.3229> <4.7980, 19.4057, 4.3229> <5.4386, 19.4057, 4.3229> <5.4579, 19.4250, 4.3229>
		<4.7821, 19.4284, 4.7283> <4.8014, 19.4091, 4.7283> <5.4352, 19.4091, 4.7283> <5.4545, 19.4284, 4.7283>
		<4.7803, 19.4265, 5.2689> <4.7996, 19.4072, 5.2689> <5.4371, 19.4072, 5.2689> <5.4564, 19.4265, 5.2689>
		<4.7787, 19.4250, 5.6744> <4.7980, 19.4057, 5.6744> <5.4386, 19.4057, 5.6744> <5.4579, 19.4250, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4579, 19.4250, 4.3229> <5.4772, 19.4443, 4.3229> <5.4772, 20.0849, 4.3229> <5.4579, 20.1042, 4.3229>
		<5.4545, 19.4284, 4.7283> <5.4738, 19.4477, 4.7283> <5.4738, 20.0815, 4.7283> <5.4545, 20.1008, 4.7283>
		<5.4564, 19.4265, 5.2689> <5.4757, 19.4458, 5.2689> <5.4757, 20.0834, 5.2689> <5.4564, 20.1027, 5.2689>
		<5.4579, 19.4250, 5.6744> <5.4772, 19.4443, 5.6744> <5.4772, 20.0849, 5.6744> <5.4579, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4579, 20.1042, 4.3229> <5.4386, 20.1235, 4.3229> <4.7980, 20.1235, 4.3229> <4.7787, 20.1042, 4.3229>
		<5.4545, 20.1008, 4.7283> <5.4352, 20.1201, 4.7283> <4.8014, 20.1201, 4.7283> <4.7821, 20.1008, 4.7283>
		<5.4564, 20.1027, 5.2689> <5.4371, 20.1220, 5.2689> <4.7996, 20.1220, 5.2689> <4.7803, 20.1027, 5.2689>
		<5.4579, 20.1042, 5.6744> <5.4386, 20.1235, 5.6744> <4.7980, 20.1235, 5.6744> <4.7787, 20.1042, 5.6744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7787, 19.4250, 5.6744> <4.7775, 19.4237, 6.0073> <4.7828, 19.4290, 6.4517> <4.7695, 19.4157, 6.7841>
		<4.7595, 19.4443, 5.6744> <4.7582, 19.4430, 6.0073> <4.7629, 19.4488, 6.4517> <4.7497, 19.4355, 6.7841>
		<4.7595, 20.0849, 5.6744> <4.7582, 20.0861, 6.0073> <4.7629, 20.0804, 6.4517> <4.7497, 20.0936, 6.7841>
		<4.7787, 20.1042, 5.6744> <4.7775, 20.1054, 6.0073> <4.7828, 20.1002, 6.4517> <4.7695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7787, 19.4250, 5.6744> <4.7980, 19.4057, 5.6744> <5.4386, 19.4057, 5.6744> <5.4579, 19.4250, 5.6744>
		<4.7775, 19.4237, 6.0073> <4.7968, 19.4044, 6.0073> <5.4399, 19.4044, 6.0073> <5.4592, 19.4237, 6.0073>
		<4.7828, 19.4290, 6.4517> <4.8026, 19.4092, 6.4517> <5.4341, 19.4092, 6.4517> <5.4539, 19.4290, 6.4517>
		<4.7695, 19.4157, 6.7841> <4.7893, 19.3959, 6.7841> <5.4474, 19.3959, 6.7841> <5.4672, 19.4157, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4579, 19.4250, 5.6744> <5.4772, 19.4443, 5.6744> <5.4772, 20.0849, 5.6744> <5.4579, 20.1042, 5.6744>
		<5.4592, 19.4237, 6.0073> <5.4785, 19.4430, 6.0073> <5.4785, 20.0861, 6.0073> <5.4592, 20.1054, 6.0073>
		<5.4539, 19.4290, 6.4517> <5.4737, 19.4488, 6.4517> <5.4737, 20.0804, 6.4517> <5.4539, 20.1002, 6.4517>
		<5.4672, 19.4157, 6.7841> <5.4870, 19.4355, 6.7841> <5.4870, 20.0936, 6.7841> <5.4672, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4579, 20.1042, 5.6744> <5.4386, 20.1235, 5.6744> <4.7980, 20.1235, 5.6744> <4.7787, 20.1042, 5.6744>
		<5.4592, 20.1054, 6.0073> <5.4399, 20.1247, 6.0073> <4.7968, 20.1247, 6.0073> <4.7775, 20.1054, 6.0073>
		<5.4539, 20.1002, 6.4517> <5.4341, 20.1200, 6.4517> <4.8026, 20.1200, 6.4517> <4.7828, 20.1002, 6.4517>
		<5.4672, 20.1134, 6.7841> <5.4474, 20.1333, 6.7841> <4.7893, 20.1333, 6.7841> <4.7695, 20.1134, 6.7841>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7695, 19.4157, 6.7841> <4.7675, 19.4137, 6.8341> <4.7551, 19.4013, 6.9079> <4.7282, 19.3745, 6.9405>
		<4.7497, 19.4355, 6.7841> <4.7477, 19.4336, 6.8341> <4.7329, 19.4235, 6.9079> <4.7060, 19.3966, 6.9405>
		<4.7497, 20.0936, 6.7841> <4.7477, 20.0956, 6.8341> <4.7329, 20.1057, 6.9079> <4.7060, 20.1326, 6.9405>
		<4.7695, 20.1134, 6.7841> <4.7675, 20.1154, 6.8341> <4.7551, 20.1278, 6.9079> <4.7282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7695, 19.4157, 6.7841> <4.7893, 19.3959, 6.7841> <5.4474, 19.3959, 6.7841> <5.4672, 19.4157, 6.7841>
		<4.7675, 19.4137, 6.8341> <4.7873, 19.3939, 6.8341> <5.4494, 19.3939, 6.8341> <5.4692, 19.4137, 6.8341>
		<4.7551, 19.4013, 6.9079> <4.7772, 19.3792, 6.9079> <5.4594, 19.3792, 6.9079> <5.4816, 19.4013, 6.9079>
		<4.7282, 19.3745, 6.9405> <4.7504, 19.3523, 6.9405> <5.4863, 19.3523, 6.9405> <5.5085, 19.3745, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4672, 19.4157, 6.7841> <5.4870, 19.4355, 6.7841> <5.4870, 20.0936, 6.7841> <5.4672, 20.1134, 6.7841>
		<5.4692, 19.4137, 6.8341> <5.4890, 19.4336, 6.8341> <5.4890, 20.0956, 6.8341> <5.4692, 20.1154, 6.8341>
		<5.4816, 19.4013, 6.9079> <5.5038, 19.4235, 6.9079> <5.5038, 20.1057, 6.9079> <5.4816, 20.1278, 6.9079>
		<5.5085, 19.3745, 6.9405> <5.5306, 19.3966, 6.9405> <5.5306, 20.1326, 6.9405> <5.5085, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.4672, 20.1134, 6.7841> <5.4474, 20.1333, 6.7841> <4.7893, 20.1333, 6.7841> <4.7695, 20.1134, 6.7841>
		<5.4692, 20.1154, 6.8341> <5.4494, 20.1352, 6.8341> <4.7873, 20.1352, 6.8341> <4.7675, 20.1154, 6.8341>
		<5.4816, 20.1278, 6.9079> <5.4594, 20.1500, 6.9079> <4.7772, 20.1500, 6.9079> <4.7551, 20.1278, 6.9079>
		<5.5085, 20.1547, 6.9405> <5.4863, 20.1769, 6.9405> <4.7504, 20.1769, 6.9405> <4.7282, 20.1547, 6.9405>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7282, 19.3745, 6.9405> <4.6661, 19.3123, 7.0160> <4.5380, 19.1842, 7.0331> <4.4886, 19.1348, 7.1255>
		<4.7060, 19.3966, 6.9405> <4.6439, 19.3345, 7.0160> <4.5022, 19.2200, 7.0331> <4.4528, 19.1706, 7.1255>
		<4.7060, 20.1326, 6.9405> <4.6439, 20.1947, 7.0160> <4.5022, 20.3092, 7.0331> <4.4528, 20.3586, 7.1255>
		<4.7282, 20.1547, 6.9405> <4.6661, 20.2168, 7.0160> <4.5380, 20.3449, 7.0331> <4.4886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7282, 19.3745, 6.9405> <4.7504, 19.3523, 6.9405> <5.4863, 19.3523, 6.9405> <5.5085, 19.3745, 6.9405>
		<4.6661, 19.3123, 7.0160> <4.6883, 19.2902, 7.0160> <5.5484, 19.2902, 7.0160> <5.5706, 19.3123, 7.0160>
		<4.5380, 19.1842, 7.0331> <4.5738, 19.1485, 7.0331> <5.6629, 19.1485, 7.0331> <5.6987, 19.1842, 7.0331>
		<4.4886, 19.1348, 7.1255> <4.5243, 19.0990, 7.1255> <5.7123, 19.0990, 7.1255> <5.7481, 19.1348, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5085, 19.3745, 6.9405> <5.5306, 19.3966, 6.9405> <5.5306, 20.1326, 6.9405> <5.5085, 20.1547, 6.9405>
		<5.5706, 19.3123, 7.0160> <5.5927, 19.3345, 7.0160> <5.5927, 20.1947, 7.0160> <5.5706, 20.2168, 7.0160>
		<5.6987, 19.1842, 7.0331> <5.7345, 19.2200, 7.0331> <5.7345, 20.3092, 7.0331> <5.6987, 20.3449, 7.0331>
		<5.7481, 19.1348, 7.1255> <5.7839, 19.1706, 7.1255> <5.7839, 20.3586, 7.1255> <5.7481, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.5085, 20.1547, 6.9405> <5.4863, 20.1769, 6.9405> <4.7504, 20.1769, 6.9405> <4.7282, 20.1547, 6.9405>
		<5.5706, 20.2168, 7.0160> <5.5484, 20.2390, 7.0160> <4.6883, 20.2390, 7.0160> <4.6661, 20.2168, 7.0160>
		<5.6987, 20.3449, 7.0331> <5.6629, 20.3807, 7.0331> <4.5738, 20.3807, 7.0331> <4.5380, 20.3449, 7.0331>
		<5.7481, 20.3944, 7.1255> <5.7123, 20.4301, 7.1255> <4.5243, 20.4301, 7.1255> <4.4886, 20.3944, 7.1255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4886, 19.1348, 7.1255> <4.4681, 19.1143, 7.1638> <4.5684, 19.2146, 7.1912> <4.5684, 19.2146, 7.2393>
		<4.4528, 19.1706, 7.1255> <4.4323, 19.1501, 7.1638> <4.5371, 19.2459, 7.1912> <4.5371, 19.2459, 7.2393>
		<4.4528, 20.3586, 7.1255> <4.4323, 20.3791, 7.1638> <4.5371, 20.2833, 7.1912> <4.5371, 20.2833, 7.2393>
		<4.4886, 20.3944, 7.1255> <4.4681, 20.4149, 7.1638> <4.5684, 20.3146, 7.1912> <4.5684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4886, 19.1348, 7.1255> <4.5243, 19.0990, 7.1255> <5.7123, 19.0990, 7.1255> <5.7481, 19.1348, 7.1255>
		<4.4681, 19.1143, 7.1638> <4.5038, 19.0785, 7.1638> <5.7329, 19.0785, 7.1638> <5.7686, 19.1143, 7.1638>
		<4.5684, 19.2146, 7.1912> <4.5996, 19.1834, 7.1912> <5.6371, 19.1834, 7.1912> <5.6683, 19.2146, 7.1912>
		<4.5684, 19.2146, 7.2393> <4.5996, 19.1834, 7.2393> <5.6371, 19.1834, 7.2393> <5.6683, 19.2146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7481, 19.1348, 7.1255> <5.7839, 19.1706, 7.1255> <5.7839, 20.3586, 7.1255> <5.7481, 20.3944, 7.1255>
		<5.7686, 19.1143, 7.1638> <5.8044, 19.1501, 7.1638> <5.8044, 20.3791, 7.1638> <5.7686, 20.4149, 7.1638>
		<5.6683, 19.2146, 7.1912> <5.6995, 19.2459, 7.1912> <5.6995, 20.2833, 7.1912> <5.6683, 20.3146, 7.1912>
		<5.6683, 19.2146, 7.2393> <5.6995, 19.2459, 7.2393> <5.6995, 20.2833, 7.2393> <5.6683, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7481, 20.3944, 7.1255> <5.7123, 20.4301, 7.1255> <4.5243, 20.4301, 7.1255> <4.4886, 20.3944, 7.1255>
		<5.7686, 20.4149, 7.1638> <5.7329, 20.4506, 7.1638> <4.5038, 20.4506, 7.1638> <4.4681, 20.4149, 7.1638>
		<5.6683, 20.3146, 7.1912> <5.6371, 20.3458, 7.1912> <4.5996, 20.3458, 7.1912> <4.5684, 20.3146, 7.1912>
		<5.6683, 20.3146, 7.2393> <5.6371, 20.3458, 7.2393> <4.5996, 20.3458, 7.2393> <4.5684, 20.3146, 7.2393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5684, 19.2146, 7.2393> <4.5684, 19.2146, 7.2905> <4.4946, 19.1408, 7.3169> <4.4886, 19.1348, 7.3673>
		<4.5371, 19.2459, 7.2393> <4.5371, 19.2459, 7.2905> <4.4588, 19.1766, 7.3169> <4.4528, 19.1706, 7.3673>
		<4.5371, 20.2833, 7.2393> <4.5371, 20.2833, 7.2905> <4.4588, 20.3526, 7.3169> <4.4528, 20.3586, 7.3673>
		<4.5684, 20.3146, 7.2393> <4.5684, 20.3146, 7.2905> <4.4946, 20.3883, 7.3169> <4.4886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5684, 19.2146, 7.2393> <4.5996, 19.1834, 7.2393> <5.6371, 19.1834, 7.2393> <5.6683, 19.2146, 7.2393>
		<4.5684, 19.2146, 7.2905> <4.5996, 19.1834, 7.2905> <5.6371, 19.1834, 7.2905> <5.6683, 19.2146, 7.2905>
		<4.4946, 19.1408, 7.3169> <4.5304, 19.1051, 7.3169> <5.7063, 19.1051, 7.3169> <5.7421, 19.1408, 7.3169>
		<4.4886, 19.1348, 7.3673> <4.5243, 19.0990, 7.3673> <5.7123, 19.0990, 7.3673> <5.7481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6683, 19.2146, 7.2393> <5.6995, 19.2459, 7.2393> <5.6995, 20.2833, 7.2393> <5.6683, 20.3146, 7.2393>
		<5.6683, 19.2146, 7.2905> <5.6995, 19.2459, 7.2905> <5.6995, 20.2833, 7.2905> <5.6683, 20.3146, 7.2905>
		<5.7421, 19.1408, 7.3169> <5.7778, 19.1766, 7.3169> <5.7778, 20.3526, 7.3169> <5.7421, 20.3883, 7.3169>
		<5.7481, 19.1348, 7.3673> <5.7839, 19.1706, 7.3673> <5.7839, 20.3586, 7.3673> <5.7481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.6683, 20.3146, 7.2393> <5.6371, 20.3458, 7.2393> <4.5996, 20.3458, 7.2393> <4.5684, 20.3146, 7.2393>
		<5.6683, 20.3146, 7.2905> <5.6371, 20.3458, 7.2905> <4.5996, 20.3458, 7.2905> <4.5684, 20.3146, 7.2905>
		<5.7421, 20.3883, 7.3169> <5.7063, 20.4241, 7.3169> <4.5304, 20.4241, 7.3169> <4.4946, 20.3883, 7.3169>
		<5.7481, 20.3944, 7.3673> <5.7123, 20.4301, 7.3673> <4.5243, 20.4301, 7.3673> <4.4886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4886, 19.1348, 7.9080> <4.4528, 19.1706, 7.9080> <4.4528, 20.3586, 7.9080> <4.4886, 20.3944, 7.9080>
		<4.4886, 19.1348, 7.7458> <4.4528, 19.1706, 7.7458> <4.4528, 20.3586, 7.7458> <4.4886, 20.3944, 7.7458>
		<4.4695, 19.1157, 7.5273> <4.4337, 19.1515, 7.5273> <4.4337, 20.3777, 7.5273> <4.4695, 20.4134, 7.5273>
		<4.4886, 19.1348, 7.3673> <4.4528, 19.1706, 7.3673> <4.4528, 20.3586, 7.3673> <4.4886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4886, 19.1348, 7.9080> <4.4886, 19.1348, 7.7458> <4.4695, 19.1157, 7.5273> <4.4886, 19.1348, 7.3673>
		<4.5243, 19.0990, 7.9080> <4.5243, 19.0990, 7.7458> <4.5053, 19.0800, 7.5273> <4.5243, 19.0990, 7.3673>
		<5.7123, 19.0990, 7.9080> <5.7123, 19.0990, 7.7458> <5.7314, 19.0800, 7.5273> <5.7123, 19.0990, 7.3673>
		<5.7481, 19.1348, 7.9080> <5.7481, 19.1348, 7.7458> <5.7672, 19.1157, 7.5273> <5.7481, 19.1348, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7481, 19.1348, 7.9080> <5.7481, 19.1348, 7.7458> <5.7672, 19.1157, 7.5273> <5.7481, 19.1348, 7.3673>
		<5.7839, 19.1706, 7.9080> <5.7839, 19.1706, 7.7458> <5.8030, 19.1515, 7.5273> <5.7839, 19.1706, 7.3673>
		<5.7839, 20.3586, 7.9080> <5.7839, 20.3586, 7.7458> <5.8030, 20.3777, 7.5273> <5.7839, 20.3586, 7.3673>
		<5.7481, 20.3944, 7.9080> <5.7481, 20.3944, 7.7458> <5.7672, 20.4134, 7.5273> <5.7481, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.7481, 20.3944, 7.9080> <5.7481, 20.3944, 7.7458> <5.7672, 20.4134, 7.5273> <5.7481, 20.3944, 7.3673>
		<5.7123, 20.4301, 7.9080> <5.7123, 20.4301, 7.7458> <5.7314, 20.4492, 7.5273> <5.7123, 20.4301, 7.3673>
		<4.5243, 20.4301, 7.9080> <4.5243, 20.4301, 7.7458> <4.5053, 20.4492, 7.5273> <4.5243, 20.4301, 7.3673>
		<4.4886, 20.3944, 7.9080> <4.4886, 20.3944, 7.7458> <4.4695, 20.4134, 7.5273> <4.4886, 20.3944, 7.3673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2411, 18.8874, 0.7771> <4.1913, 18.9372, 0.7771> <4.1913, 20.5920, 0.7771> <4.2411, 20.6418, 0.7771>
		<4.2204, 18.8666, 0.6520> <4.1706, 18.9164, 0.6520> <4.1706, 20.6127, 0.6520> <4.2204, 20.6626, 0.6520>
		<4.2411, 18.8874, 0.4772> <4.1913, 18.9372, 0.4772> <4.1913, 20.5920, 0.4772> <4.2411, 20.6418, 0.4772>
		<4.2411, 18.8874, 0.3486> <4.1913, 18.9372, 0.3486> <4.1913, 20.5920, 0.3486> <4.2411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2411, 18.8874, 0.7771> <4.2204, 18.8666, 0.6520> <4.2411, 18.8874, 0.4772> <4.2411, 18.8874, 0.3486>
		<4.2910, 18.8376, 0.7771> <4.2702, 18.8168, 0.6520> <4.2910, 18.8376, 0.4772> <4.2910, 18.8376, 0.3486>
		<5.9457, 18.8376, 0.7771> <5.9665, 18.8168, 0.6520> <5.9457, 18.8376, 0.4772> <5.9457, 18.8376, 0.3486>
		<5.9955, 18.8874, 0.7771> <6.0163, 18.8666, 0.6520> <5.9955, 18.8874, 0.4772> <5.9955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9955, 18.8874, 0.7771> <6.0163, 18.8666, 0.6520> <5.9955, 18.8874, 0.4772> <5.9955, 18.8874, 0.3486>
		<6.0454, 18.9372, 0.7771> <6.0661, 18.9164, 0.6520> <6.0454, 18.9372, 0.4772> <6.0454, 18.9372, 0.3486>
		<6.0454, 20.5920, 0.7771> <6.0661, 20.6127, 0.6520> <6.0454, 20.5920, 0.4772> <6.0454, 20.5920, 0.3486>
		<5.9955, 20.6418, 0.7771> <6.0163, 20.6626, 0.6520> <5.9955, 20.6418, 0.4772> <5.9955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9955, 20.6418, 0.7771> <6.0163, 20.6626, 0.6520> <5.9955, 20.6418, 0.4772> <5.9955, 20.6418, 0.3486>
		<5.9457, 20.6916, 0.7771> <5.9665, 20.7124, 0.6520> <5.9457, 20.6916, 0.4772> <5.9457, 20.6916, 0.3486>
		<4.2910, 20.6916, 0.7771> <4.2702, 20.7124, 0.6520> <4.2910, 20.6916, 0.4772> <4.2910, 20.6916, 0.3486>
		<4.2411, 20.6418, 0.7771> <4.2204, 20.6626, 0.6520> <4.2411, 20.6418, 0.4772> <4.2411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2411, 18.8874, -0.0618> <4.2411, 18.8874, 0.0613> <4.2411, 18.8874, 0.2255> <4.2411, 18.8874, 0.3486>
		<4.1913, 18.9372, -0.0618> <4.1913, 18.9372, 0.0613> <4.1913, 18.9372, 0.2255> <4.1913, 18.9372, 0.3486>
		<4.1913, 20.5920, -0.0618> <4.1913, 20.5920, 0.0613> <4.1913, 20.5920, 0.2255> <4.1913, 20.5920, 0.3486>
		<4.2411, 20.6418, -0.0618> <4.2411, 20.6418, 0.0613> <4.2411, 20.6418, 0.2255> <4.2411, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.2411, 18.8874, -0.0618> <4.2910, 18.8376, -0.0618> <5.9457, 18.8376, -0.0618> <5.9955, 18.8874, -0.0618>
		<4.2411, 18.8874, 0.0613> <4.2910, 18.8376, 0.0613> <5.9457, 18.8376, 0.0613> <5.9955, 18.8874, 0.0613>
		<4.2411, 18.8874, 0.2255> <4.2910, 18.8376, 0.2255> <5.9457, 18.8376, 0.2255> <5.9955, 18.8874, 0.2255>
		<4.2411, 18.8874, 0.3486> <4.2910, 18.8376, 0.3486> <5.9457, 18.8376, 0.3486> <5.9955, 18.8874, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9955, 18.8874, -0.0618> <6.0454, 18.9372, -0.0618> <6.0454, 20.5920, -0.0618> <5.9955, 20.6418, -0.0618>
		<5.9955, 18.8874, 0.0613> <6.0454, 18.9372, 0.0613> <6.0454, 20.5920, 0.0613> <5.9955, 20.6418, 0.0613>
		<5.9955, 18.8874, 0.2255> <6.0454, 18.9372, 0.2255> <6.0454, 20.5920, 0.2255> <5.9955, 20.6418, 0.2255>
		<5.9955, 18.8874, 0.3486> <6.0454, 18.9372, 0.3486> <6.0454, 20.5920, 0.3486> <5.9955, 20.6418, 0.3486>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.9955, 20.6418, -0.0618> <5.9457, 20.6916, -0.0618> <4.2910, 20.6916, -0.0618> <4.2411, 20.6418, -0.0618>
		<5.9955, 20.6418, 0.0613> <5.9457, 20.6916, 0.0613> <4.2910, 20.6916, 0.0613> <4.2411, 20.6418, 0.0613>
		<5.9955, 20.6418, 0.2255> <5.9457, 20.6916, 0.2255> <4.2910, 20.6916, 0.2255> <4.2411, 20.6418, 0.2255>
		<5.9955, 20.6418, 0.3486> <5.9457, 20.6916, 0.3486> <4.2910, 20.6916, 0.3486> <4.2411, 20.6418, 0.3486>
	}
texture {ograda}
}
